{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A t'GI.Gio.Objects.InetSocketAddress.InetSocketAddress' representing a connection via a proxy server.
-- 
-- /Since: 2.26/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.ProxyAddress
    ( 

-- * Exported types
    ProxyAddress(..)                        ,
    IsProxyAddress                          ,
    toProxyAddress                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [enumerate]("GI.Gio.Interfaces.SocketConnectable#g:method:enumerate"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [proxyEnumerate]("GI.Gio.Interfaces.SocketConnectable#g:method:proxyEnumerate"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [toNative]("GI.Gio.Objects.SocketAddress#g:method:toNative"), [toString]("GI.Gio.Interfaces.SocketConnectable#g:method:toString"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAddress]("GI.Gio.Objects.InetSocketAddress#g:method:getAddress"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDestinationHostname]("GI.Gio.Objects.ProxyAddress#g:method:getDestinationHostname"), [getDestinationPort]("GI.Gio.Objects.ProxyAddress#g:method:getDestinationPort"), [getDestinationProtocol]("GI.Gio.Objects.ProxyAddress#g:method:getDestinationProtocol"), [getFamily]("GI.Gio.Objects.SocketAddress#g:method:getFamily"), [getFlowinfo]("GI.Gio.Objects.InetSocketAddress#g:method:getFlowinfo"), [getNativeSize]("GI.Gio.Objects.SocketAddress#g:method:getNativeSize"), [getPassword]("GI.Gio.Objects.ProxyAddress#g:method:getPassword"), [getPort]("GI.Gio.Objects.InetSocketAddress#g:method:getPort"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getProtocol]("GI.Gio.Objects.ProxyAddress#g:method:getProtocol"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getScopeId]("GI.Gio.Objects.InetSocketAddress#g:method:getScopeId"), [getUri]("GI.Gio.Objects.ProxyAddress#g:method:getUri"), [getUsername]("GI.Gio.Objects.ProxyAddress#g:method:getUsername").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveProxyAddressMethod               ,
#endif

-- ** getDestinationHostname #method:getDestinationHostname#

#if defined(ENABLE_OVERLOADING)
    ProxyAddressGetDestinationHostnameMethodInfo,
#endif
    proxyAddressGetDestinationHostname      ,


-- ** getDestinationPort #method:getDestinationPort#

#if defined(ENABLE_OVERLOADING)
    ProxyAddressGetDestinationPortMethodInfo,
#endif
    proxyAddressGetDestinationPort          ,


-- ** getDestinationProtocol #method:getDestinationProtocol#

#if defined(ENABLE_OVERLOADING)
    ProxyAddressGetDestinationProtocolMethodInfo,
#endif
    proxyAddressGetDestinationProtocol      ,


-- ** getPassword #method:getPassword#

#if defined(ENABLE_OVERLOADING)
    ProxyAddressGetPasswordMethodInfo       ,
#endif
    proxyAddressGetPassword                 ,


-- ** getProtocol #method:getProtocol#

#if defined(ENABLE_OVERLOADING)
    ProxyAddressGetProtocolMethodInfo       ,
#endif
    proxyAddressGetProtocol                 ,


-- ** getUri #method:getUri#

#if defined(ENABLE_OVERLOADING)
    ProxyAddressGetUriMethodInfo            ,
#endif
    proxyAddressGetUri                      ,


-- ** getUsername #method:getUsername#

#if defined(ENABLE_OVERLOADING)
    ProxyAddressGetUsernameMethodInfo       ,
#endif
    proxyAddressGetUsername                 ,


-- ** new #method:new#

    proxyAddressNew                         ,




 -- * Properties


-- ** destinationHostname #attr:destinationHostname#
-- | The proxy destination hostname.
-- 
-- /Since: 2.26/

#if defined(ENABLE_OVERLOADING)
    ProxyAddressDestinationHostnamePropertyInfo,
#endif
    constructProxyAddressDestinationHostname,
    getProxyAddressDestinationHostname      ,
#if defined(ENABLE_OVERLOADING)
    proxyAddressDestinationHostname         ,
#endif


-- ** destinationPort #attr:destinationPort#
-- | The proxy destination port.
-- 
-- /Since: 2.26/

#if defined(ENABLE_OVERLOADING)
    ProxyAddressDestinationPortPropertyInfo ,
#endif
    constructProxyAddressDestinationPort    ,
    getProxyAddressDestinationPort          ,
#if defined(ENABLE_OVERLOADING)
    proxyAddressDestinationPort             ,
#endif


-- ** destinationProtocol #attr:destinationProtocol#
-- | The protocol being spoke to the destination host, or 'P.Nothing' if
-- the t'GI.Gio.Objects.ProxyAddress.ProxyAddress' doesn\'t know.
-- 
-- /Since: 2.34/

#if defined(ENABLE_OVERLOADING)
    ProxyAddressDestinationProtocolPropertyInfo,
#endif
    constructProxyAddressDestinationProtocol,
    getProxyAddressDestinationProtocol      ,
#if defined(ENABLE_OVERLOADING)
    proxyAddressDestinationProtocol         ,
#endif


-- ** password #attr:password#
-- | The proxy password.
-- 
-- /Since: 2.26/

#if defined(ENABLE_OVERLOADING)
    ProxyAddressPasswordPropertyInfo        ,
#endif
    constructProxyAddressPassword           ,
    getProxyAddressPassword                 ,
#if defined(ENABLE_OVERLOADING)
    proxyAddressPassword                    ,
#endif


-- ** protocol #attr:protocol#
-- | The proxy protocol.
-- 
-- /Since: 2.26/

#if defined(ENABLE_OVERLOADING)
    ProxyAddressProtocolPropertyInfo        ,
#endif
    constructProxyAddressProtocol           ,
    getProxyAddressProtocol                 ,
#if defined(ENABLE_OVERLOADING)
    proxyAddressProtocol                    ,
#endif


-- ** uri #attr:uri#
-- | The URI string that the proxy was constructed from (or 'P.Nothing'
-- if the creator didn\'t specify this).
-- 
-- /Since: 2.34/

#if defined(ENABLE_OVERLOADING)
    ProxyAddressUriPropertyInfo             ,
#endif
    constructProxyAddressUri                ,
    getProxyAddressUri                      ,
#if defined(ENABLE_OVERLOADING)
    proxyAddressUri                         ,
#endif


-- ** username #attr:username#
-- | The proxy username.
-- 
-- /Since: 2.26/

#if defined(ENABLE_OVERLOADING)
    ProxyAddressUsernamePropertyInfo        ,
#endif
    constructProxyAddressUsername           ,
    getProxyAddressUsername                 ,
#if defined(ENABLE_OVERLOADING)
    proxyAddressUsername                    ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InetSocketAddress as Gio.InetSocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddressEnumerator as Gio.SocketAddressEnumerator

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.SocketConnectable as Gio.SocketConnectable
import {-# SOURCE #-} qualified GI.Gio.Objects.InetAddress as Gio.InetAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.InetSocketAddress as Gio.InetSocketAddress
import {-# SOURCE #-} qualified GI.Gio.Objects.SocketAddress as Gio.SocketAddress

#endif

-- | Memory-managed wrapper type.
newtype ProxyAddress = ProxyAddress (SP.ManagedPtr ProxyAddress)
    deriving (Eq)

instance SP.ManagedPtrNewtype ProxyAddress where
    toManagedPtr (ProxyAddress p) = p

foreign import ccall "g_proxy_address_get_type"
    c_g_proxy_address_get_type :: IO B.Types.GType

instance B.Types.TypedObject ProxyAddress where
    glibType = c_g_proxy_address_get_type

instance B.Types.GObject ProxyAddress

-- | Type class for types which can be safely cast to t'ProxyAddress', for instance with `toProxyAddress`.
class (SP.GObject o, O.IsDescendantOf ProxyAddress o) => IsProxyAddress o
instance (SP.GObject o, O.IsDescendantOf ProxyAddress o) => IsProxyAddress o

instance O.HasParentTypes ProxyAddress
type instance O.ParentTypes ProxyAddress = '[Gio.InetSocketAddress.InetSocketAddress, Gio.SocketAddress.SocketAddress, GObject.Object.Object, Gio.SocketConnectable.SocketConnectable]

-- | Cast to t'ProxyAddress', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toProxyAddress :: (MIO.MonadIO m, IsProxyAddress o) => o -> m ProxyAddress
toProxyAddress = MIO.liftIO . B.ManagedPtr.unsafeCastTo ProxyAddress

-- | Convert t'ProxyAddress' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ProxyAddress) where
    gvalueGType_ = c_g_proxy_address_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ProxyAddress)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ProxyAddress)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ProxyAddress ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveProxyAddressMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveProxyAddressMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveProxyAddressMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveProxyAddressMethod "enumerate" o = Gio.SocketConnectable.SocketConnectableEnumerateMethodInfo
    ResolveProxyAddressMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveProxyAddressMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveProxyAddressMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveProxyAddressMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveProxyAddressMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveProxyAddressMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveProxyAddressMethod "proxyEnumerate" o = Gio.SocketConnectable.SocketConnectableProxyEnumerateMethodInfo
    ResolveProxyAddressMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveProxyAddressMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveProxyAddressMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveProxyAddressMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveProxyAddressMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveProxyAddressMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveProxyAddressMethod "toNative" o = Gio.SocketAddress.SocketAddressToNativeMethodInfo
    ResolveProxyAddressMethod "toString" o = Gio.SocketConnectable.SocketConnectableToStringMethodInfo
    ResolveProxyAddressMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveProxyAddressMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveProxyAddressMethod "getAddress" o = Gio.InetSocketAddress.InetSocketAddressGetAddressMethodInfo
    ResolveProxyAddressMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveProxyAddressMethod "getDestinationHostname" o = ProxyAddressGetDestinationHostnameMethodInfo
    ResolveProxyAddressMethod "getDestinationPort" o = ProxyAddressGetDestinationPortMethodInfo
    ResolveProxyAddressMethod "getDestinationProtocol" o = ProxyAddressGetDestinationProtocolMethodInfo
    ResolveProxyAddressMethod "getFamily" o = Gio.SocketAddress.SocketAddressGetFamilyMethodInfo
    ResolveProxyAddressMethod "getFlowinfo" o = Gio.InetSocketAddress.InetSocketAddressGetFlowinfoMethodInfo
    ResolveProxyAddressMethod "getNativeSize" o = Gio.SocketAddress.SocketAddressGetNativeSizeMethodInfo
    ResolveProxyAddressMethod "getPassword" o = ProxyAddressGetPasswordMethodInfo
    ResolveProxyAddressMethod "getPort" o = Gio.InetSocketAddress.InetSocketAddressGetPortMethodInfo
    ResolveProxyAddressMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveProxyAddressMethod "getProtocol" o = ProxyAddressGetProtocolMethodInfo
    ResolveProxyAddressMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveProxyAddressMethod "getScopeId" o = Gio.InetSocketAddress.InetSocketAddressGetScopeIdMethodInfo
    ResolveProxyAddressMethod "getUri" o = ProxyAddressGetUriMethodInfo
    ResolveProxyAddressMethod "getUsername" o = ProxyAddressGetUsernameMethodInfo
    ResolveProxyAddressMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveProxyAddressMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveProxyAddressMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveProxyAddressMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveProxyAddressMethod t ProxyAddress, O.OverloadedMethod info ProxyAddress p) => OL.IsLabel t (ProxyAddress -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveProxyAddressMethod t ProxyAddress, O.OverloadedMethod info ProxyAddress p, R.HasField t ProxyAddress p) => R.HasField t ProxyAddress p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveProxyAddressMethod t ProxyAddress, O.OverloadedMethodInfo info ProxyAddress) => OL.IsLabel t (O.MethodProxy info ProxyAddress) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "destination-hostname"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@destination-hostname@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' proxyAddress #destinationHostname
-- @
getProxyAddressDestinationHostname :: (MonadIO m, IsProxyAddress o) => o -> m T.Text
getProxyAddressDestinationHostname obj = MIO.liftIO $ checkUnexpectedNothing "getProxyAddressDestinationHostname" $ B.Properties.getObjectPropertyString obj "destination-hostname"

-- | Construct a t'GValueConstruct' with valid value for the “@destination-hostname@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProxyAddressDestinationHostname :: (IsProxyAddress o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructProxyAddressDestinationHostname val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "destination-hostname" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ProxyAddressDestinationHostnamePropertyInfo
instance AttrInfo ProxyAddressDestinationHostnamePropertyInfo where
    type AttrAllowedOps ProxyAddressDestinationHostnamePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ProxyAddressDestinationHostnamePropertyInfo = IsProxyAddress
    type AttrSetTypeConstraint ProxyAddressDestinationHostnamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ProxyAddressDestinationHostnamePropertyInfo = (~) T.Text
    type AttrTransferType ProxyAddressDestinationHostnamePropertyInfo = T.Text
    type AttrGetType ProxyAddressDestinationHostnamePropertyInfo = T.Text
    type AttrLabel ProxyAddressDestinationHostnamePropertyInfo = "destination-hostname"
    type AttrOrigin ProxyAddressDestinationHostnamePropertyInfo = ProxyAddress
    attrGet = getProxyAddressDestinationHostname
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructProxyAddressDestinationHostname
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddress.destinationHostname"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddress.html#g:attr:destinationHostname"
        })
#endif

-- VVV Prop "destination-port"
   -- Type: TBasicType TUInt
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@destination-port@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' proxyAddress #destinationPort
-- @
getProxyAddressDestinationPort :: (MonadIO m, IsProxyAddress o) => o -> m Word32
getProxyAddressDestinationPort obj = MIO.liftIO $ B.Properties.getObjectPropertyUInt32 obj "destination-port"

-- | Construct a t'GValueConstruct' with valid value for the “@destination-port@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProxyAddressDestinationPort :: (IsProxyAddress o, MIO.MonadIO m) => Word32 -> m (GValueConstruct o)
constructProxyAddressDestinationPort val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyUInt32 "destination-port" val

#if defined(ENABLE_OVERLOADING)
data ProxyAddressDestinationPortPropertyInfo
instance AttrInfo ProxyAddressDestinationPortPropertyInfo where
    type AttrAllowedOps ProxyAddressDestinationPortPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ProxyAddressDestinationPortPropertyInfo = IsProxyAddress
    type AttrSetTypeConstraint ProxyAddressDestinationPortPropertyInfo = (~) Word32
    type AttrTransferTypeConstraint ProxyAddressDestinationPortPropertyInfo = (~) Word32
    type AttrTransferType ProxyAddressDestinationPortPropertyInfo = Word32
    type AttrGetType ProxyAddressDestinationPortPropertyInfo = Word32
    type AttrLabel ProxyAddressDestinationPortPropertyInfo = "destination-port"
    type AttrOrigin ProxyAddressDestinationPortPropertyInfo = ProxyAddress
    attrGet = getProxyAddressDestinationPort
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructProxyAddressDestinationPort
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddress.destinationPort"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddress.html#g:attr:destinationPort"
        })
#endif

-- VVV Prop "destination-protocol"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@destination-protocol@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' proxyAddress #destinationProtocol
-- @
getProxyAddressDestinationProtocol :: (MonadIO m, IsProxyAddress o) => o -> m T.Text
getProxyAddressDestinationProtocol obj = MIO.liftIO $ checkUnexpectedNothing "getProxyAddressDestinationProtocol" $ B.Properties.getObjectPropertyString obj "destination-protocol"

-- | Construct a t'GValueConstruct' with valid value for the “@destination-protocol@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProxyAddressDestinationProtocol :: (IsProxyAddress o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructProxyAddressDestinationProtocol val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "destination-protocol" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ProxyAddressDestinationProtocolPropertyInfo
instance AttrInfo ProxyAddressDestinationProtocolPropertyInfo where
    type AttrAllowedOps ProxyAddressDestinationProtocolPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ProxyAddressDestinationProtocolPropertyInfo = IsProxyAddress
    type AttrSetTypeConstraint ProxyAddressDestinationProtocolPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ProxyAddressDestinationProtocolPropertyInfo = (~) T.Text
    type AttrTransferType ProxyAddressDestinationProtocolPropertyInfo = T.Text
    type AttrGetType ProxyAddressDestinationProtocolPropertyInfo = T.Text
    type AttrLabel ProxyAddressDestinationProtocolPropertyInfo = "destination-protocol"
    type AttrOrigin ProxyAddressDestinationProtocolPropertyInfo = ProxyAddress
    attrGet = getProxyAddressDestinationProtocol
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructProxyAddressDestinationProtocol
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddress.destinationProtocol"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddress.html#g:attr:destinationProtocol"
        })
#endif

-- VVV Prop "password"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@password@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' proxyAddress #password
-- @
getProxyAddressPassword :: (MonadIO m, IsProxyAddress o) => o -> m (Maybe T.Text)
getProxyAddressPassword obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "password"

-- | Construct a t'GValueConstruct' with valid value for the “@password@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProxyAddressPassword :: (IsProxyAddress o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructProxyAddressPassword val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "password" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ProxyAddressPasswordPropertyInfo
instance AttrInfo ProxyAddressPasswordPropertyInfo where
    type AttrAllowedOps ProxyAddressPasswordPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ProxyAddressPasswordPropertyInfo = IsProxyAddress
    type AttrSetTypeConstraint ProxyAddressPasswordPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ProxyAddressPasswordPropertyInfo = (~) T.Text
    type AttrTransferType ProxyAddressPasswordPropertyInfo = T.Text
    type AttrGetType ProxyAddressPasswordPropertyInfo = (Maybe T.Text)
    type AttrLabel ProxyAddressPasswordPropertyInfo = "password"
    type AttrOrigin ProxyAddressPasswordPropertyInfo = ProxyAddress
    attrGet = getProxyAddressPassword
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructProxyAddressPassword
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddress.password"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddress.html#g:attr:password"
        })
#endif

-- VVV Prop "protocol"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@protocol@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' proxyAddress #protocol
-- @
getProxyAddressProtocol :: (MonadIO m, IsProxyAddress o) => o -> m T.Text
getProxyAddressProtocol obj = MIO.liftIO $ checkUnexpectedNothing "getProxyAddressProtocol" $ B.Properties.getObjectPropertyString obj "protocol"

-- | Construct a t'GValueConstruct' with valid value for the “@protocol@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProxyAddressProtocol :: (IsProxyAddress o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructProxyAddressProtocol val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "protocol" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ProxyAddressProtocolPropertyInfo
instance AttrInfo ProxyAddressProtocolPropertyInfo where
    type AttrAllowedOps ProxyAddressProtocolPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ProxyAddressProtocolPropertyInfo = IsProxyAddress
    type AttrSetTypeConstraint ProxyAddressProtocolPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ProxyAddressProtocolPropertyInfo = (~) T.Text
    type AttrTransferType ProxyAddressProtocolPropertyInfo = T.Text
    type AttrGetType ProxyAddressProtocolPropertyInfo = T.Text
    type AttrLabel ProxyAddressProtocolPropertyInfo = "protocol"
    type AttrOrigin ProxyAddressProtocolPropertyInfo = ProxyAddress
    attrGet = getProxyAddressProtocol
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructProxyAddressProtocol
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddress.protocol"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddress.html#g:attr:protocol"
        })
#endif

-- VVV Prop "uri"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@uri@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' proxyAddress #uri
-- @
getProxyAddressUri :: (MonadIO m, IsProxyAddress o) => o -> m (Maybe T.Text)
getProxyAddressUri obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "uri"

-- | Construct a t'GValueConstruct' with valid value for the “@uri@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProxyAddressUri :: (IsProxyAddress o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructProxyAddressUri val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "uri" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ProxyAddressUriPropertyInfo
instance AttrInfo ProxyAddressUriPropertyInfo where
    type AttrAllowedOps ProxyAddressUriPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ProxyAddressUriPropertyInfo = IsProxyAddress
    type AttrSetTypeConstraint ProxyAddressUriPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ProxyAddressUriPropertyInfo = (~) T.Text
    type AttrTransferType ProxyAddressUriPropertyInfo = T.Text
    type AttrGetType ProxyAddressUriPropertyInfo = (Maybe T.Text)
    type AttrLabel ProxyAddressUriPropertyInfo = "uri"
    type AttrOrigin ProxyAddressUriPropertyInfo = ProxyAddress
    attrGet = getProxyAddressUri
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructProxyAddressUri
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddress.uri"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddress.html#g:attr:uri"
        })
#endif

-- VVV Prop "username"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@username@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' proxyAddress #username
-- @
getProxyAddressUsername :: (MonadIO m, IsProxyAddress o) => o -> m (Maybe T.Text)
getProxyAddressUsername obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "username"

-- | Construct a t'GValueConstruct' with valid value for the “@username@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructProxyAddressUsername :: (IsProxyAddress o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructProxyAddressUsername val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "username" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data ProxyAddressUsernamePropertyInfo
instance AttrInfo ProxyAddressUsernamePropertyInfo where
    type AttrAllowedOps ProxyAddressUsernamePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ProxyAddressUsernamePropertyInfo = IsProxyAddress
    type AttrSetTypeConstraint ProxyAddressUsernamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint ProxyAddressUsernamePropertyInfo = (~) T.Text
    type AttrTransferType ProxyAddressUsernamePropertyInfo = T.Text
    type AttrGetType ProxyAddressUsernamePropertyInfo = (Maybe T.Text)
    type AttrLabel ProxyAddressUsernamePropertyInfo = "username"
    type AttrOrigin ProxyAddressUsernamePropertyInfo = ProxyAddress
    attrGet = getProxyAddressUsername
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructProxyAddressUsername
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddress.username"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddress.html#g:attr:username"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ProxyAddress
type instance O.AttributeList ProxyAddress = ProxyAddressAttributeList
type ProxyAddressAttributeList = ('[ '("address", Gio.InetSocketAddress.InetSocketAddressAddressPropertyInfo), '("destinationHostname", ProxyAddressDestinationHostnamePropertyInfo), '("destinationPort", ProxyAddressDestinationPortPropertyInfo), '("destinationProtocol", ProxyAddressDestinationProtocolPropertyInfo), '("family", Gio.SocketAddress.SocketAddressFamilyPropertyInfo), '("flowinfo", Gio.InetSocketAddress.InetSocketAddressFlowinfoPropertyInfo), '("password", ProxyAddressPasswordPropertyInfo), '("port", Gio.InetSocketAddress.InetSocketAddressPortPropertyInfo), '("protocol", ProxyAddressProtocolPropertyInfo), '("scopeId", Gio.InetSocketAddress.InetSocketAddressScopeIdPropertyInfo), '("uri", ProxyAddressUriPropertyInfo), '("username", ProxyAddressUsernamePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
proxyAddressDestinationHostname :: AttrLabelProxy "destinationHostname"
proxyAddressDestinationHostname = AttrLabelProxy

proxyAddressDestinationPort :: AttrLabelProxy "destinationPort"
proxyAddressDestinationPort = AttrLabelProxy

proxyAddressDestinationProtocol :: AttrLabelProxy "destinationProtocol"
proxyAddressDestinationProtocol = AttrLabelProxy

proxyAddressPassword :: AttrLabelProxy "password"
proxyAddressPassword = AttrLabelProxy

proxyAddressProtocol :: AttrLabelProxy "protocol"
proxyAddressProtocol = AttrLabelProxy

proxyAddressUri :: AttrLabelProxy "uri"
proxyAddressUri = AttrLabelProxy

proxyAddressUsername :: AttrLabelProxy "username"
proxyAddressUsername = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ProxyAddress = ProxyAddressSignalList
type ProxyAddressSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ProxyAddress::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "inetaddr"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "InetAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The proxy server #GInetAddress."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "port"
--           , argType = TBasicType TUInt16
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The proxy server port."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "protocol"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The proxy protocol to support, in lower case (e.g. socks, http)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dest_hostname"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "The destination hostname the proxy should tunnel to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "dest_port"
--           , argType = TBasicType TUInt16
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "The destination port to tunnel to."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "username"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The username to authenticate to the proxy server\n    (or %NULL)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "password"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "The password to authenticate to the proxy server\n    (or %NULL)."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gio" , name = "ProxyAddress" })
-- throws : False
-- Skip return : False

foreign import ccall "g_proxy_address_new" g_proxy_address_new :: 
    Ptr Gio.InetAddress.InetAddress ->      -- inetaddr : TInterface (Name {namespace = "Gio", name = "InetAddress"})
    Word16 ->                               -- port : TBasicType TUInt16
    CString ->                              -- protocol : TBasicType TUTF8
    CString ->                              -- dest_hostname : TBasicType TUTF8
    Word16 ->                               -- dest_port : TBasicType TUInt16
    CString ->                              -- username : TBasicType TUTF8
    CString ->                              -- password : TBasicType TUTF8
    IO (Ptr ProxyAddress)

-- | Creates a new t'GI.Gio.Objects.ProxyAddress.ProxyAddress' for /@inetaddr@/ with /@protocol@/ that should
-- tunnel through /@destHostname@/ and /@destPort@/.
-- 
-- (Note that this method doesn\'t set the [ProxyAddress:uri]("GI.Gio.Objects.ProxyAddress#g:attr:uri") or
-- [ProxyAddress:destinationProtocol]("GI.Gio.Objects.ProxyAddress#g:attr:destinationProtocol") fields; use @/g_object_new()/@
-- directly if you want to set those.)
-- 
-- /Since: 2.26/
proxyAddressNew ::
    (B.CallStack.HasCallStack, MonadIO m, Gio.InetAddress.IsInetAddress a) =>
    a
    -- ^ /@inetaddr@/: The proxy server t'GI.Gio.Objects.InetAddress.InetAddress'.
    -> Word16
    -- ^ /@port@/: The proxy server port.
    -> T.Text
    -- ^ /@protocol@/: The proxy protocol to support, in lower case (e.g. socks, http).
    -> T.Text
    -- ^ /@destHostname@/: The destination hostname the proxy should tunnel to.
    -> Word16
    -- ^ /@destPort@/: The destination port to tunnel to.
    -> Maybe (T.Text)
    -- ^ /@username@/: The username to authenticate to the proxy server
    --     (or 'P.Nothing').
    -> Maybe (T.Text)
    -- ^ /@password@/: The password to authenticate to the proxy server
    --     (or 'P.Nothing').
    -> m ProxyAddress
    -- ^ __Returns:__ a new t'GI.Gio.Objects.ProxyAddress.ProxyAddress'
proxyAddressNew inetaddr port protocol destHostname destPort username password = liftIO $ do
    inetaddr' <- unsafeManagedPtrCastPtr inetaddr
    protocol' <- textToCString protocol
    destHostname' <- textToCString destHostname
    maybeUsername <- case username of
        Nothing -> return FP.nullPtr
        Just jUsername -> do
            jUsername' <- textToCString jUsername
            return jUsername'
    maybePassword <- case password of
        Nothing -> return FP.nullPtr
        Just jPassword -> do
            jPassword' <- textToCString jPassword
            return jPassword'
    result <- g_proxy_address_new inetaddr' port protocol' destHostname' destPort maybeUsername maybePassword
    checkUnexpectedReturnNULL "proxyAddressNew" result
    result' <- (wrapObject ProxyAddress) result
    touchManagedPtr inetaddr
    freeMem protocol'
    freeMem destHostname'
    freeMem maybeUsername
    freeMem maybePassword
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ProxyAddress::get_destination_hostname
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "proxy"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ProxyAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxyAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_proxy_address_get_destination_hostname" g_proxy_address_get_destination_hostname :: 
    Ptr ProxyAddress ->                     -- proxy : TInterface (Name {namespace = "Gio", name = "ProxyAddress"})
    IO CString

-- | Gets /@proxy@/\'s destination hostname; that is, the name of the host
-- that will be connected to via the proxy, not the name of the proxy
-- itself.
-- 
-- /Since: 2.26/
proxyAddressGetDestinationHostname ::
    (B.CallStack.HasCallStack, MonadIO m, IsProxyAddress a) =>
    a
    -- ^ /@proxy@/: a t'GI.Gio.Objects.ProxyAddress.ProxyAddress'
    -> m T.Text
    -- ^ __Returns:__ the /@proxy@/\'s destination hostname
proxyAddressGetDestinationHostname proxy = liftIO $ do
    proxy' <- unsafeManagedPtrCastPtr proxy
    result <- g_proxy_address_get_destination_hostname proxy'
    checkUnexpectedReturnNULL "proxyAddressGetDestinationHostname" result
    result' <- cstringToText result
    touchManagedPtr proxy
    return result'

#if defined(ENABLE_OVERLOADING)
data ProxyAddressGetDestinationHostnameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsProxyAddress a) => O.OverloadedMethod ProxyAddressGetDestinationHostnameMethodInfo a signature where
    overloadedMethod = proxyAddressGetDestinationHostname

instance O.OverloadedMethodInfo ProxyAddressGetDestinationHostnameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddress.proxyAddressGetDestinationHostname",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddress.html#v:proxyAddressGetDestinationHostname"
        })


#endif

-- method ProxyAddress::get_destination_port
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "proxy"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ProxyAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxyAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt16)
-- throws : False
-- Skip return : False

foreign import ccall "g_proxy_address_get_destination_port" g_proxy_address_get_destination_port :: 
    Ptr ProxyAddress ->                     -- proxy : TInterface (Name {namespace = "Gio", name = "ProxyAddress"})
    IO Word16

-- | Gets /@proxy@/\'s destination port; that is, the port on the
-- destination host that will be connected to via the proxy, not the
-- port number of the proxy itself.
-- 
-- /Since: 2.26/
proxyAddressGetDestinationPort ::
    (B.CallStack.HasCallStack, MonadIO m, IsProxyAddress a) =>
    a
    -- ^ /@proxy@/: a t'GI.Gio.Objects.ProxyAddress.ProxyAddress'
    -> m Word16
    -- ^ __Returns:__ the /@proxy@/\'s destination port
proxyAddressGetDestinationPort proxy = liftIO $ do
    proxy' <- unsafeManagedPtrCastPtr proxy
    result <- g_proxy_address_get_destination_port proxy'
    touchManagedPtr proxy
    return result

#if defined(ENABLE_OVERLOADING)
data ProxyAddressGetDestinationPortMethodInfo
instance (signature ~ (m Word16), MonadIO m, IsProxyAddress a) => O.OverloadedMethod ProxyAddressGetDestinationPortMethodInfo a signature where
    overloadedMethod = proxyAddressGetDestinationPort

instance O.OverloadedMethodInfo ProxyAddressGetDestinationPortMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddress.proxyAddressGetDestinationPort",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddress.html#v:proxyAddressGetDestinationPort"
        })


#endif

-- method ProxyAddress::get_destination_protocol
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "proxy"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ProxyAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxyAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_proxy_address_get_destination_protocol" g_proxy_address_get_destination_protocol :: 
    Ptr ProxyAddress ->                     -- proxy : TInterface (Name {namespace = "Gio", name = "ProxyAddress"})
    IO CString

-- | Gets the protocol that is being spoken to the destination
-- server; eg, \"http\" or \"ftp\".
-- 
-- /Since: 2.34/
proxyAddressGetDestinationProtocol ::
    (B.CallStack.HasCallStack, MonadIO m, IsProxyAddress a) =>
    a
    -- ^ /@proxy@/: a t'GI.Gio.Objects.ProxyAddress.ProxyAddress'
    -> m T.Text
    -- ^ __Returns:__ the /@proxy@/\'s destination protocol
proxyAddressGetDestinationProtocol proxy = liftIO $ do
    proxy' <- unsafeManagedPtrCastPtr proxy
    result <- g_proxy_address_get_destination_protocol proxy'
    checkUnexpectedReturnNULL "proxyAddressGetDestinationProtocol" result
    result' <- cstringToText result
    touchManagedPtr proxy
    return result'

#if defined(ENABLE_OVERLOADING)
data ProxyAddressGetDestinationProtocolMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsProxyAddress a) => O.OverloadedMethod ProxyAddressGetDestinationProtocolMethodInfo a signature where
    overloadedMethod = proxyAddressGetDestinationProtocol

instance O.OverloadedMethodInfo ProxyAddressGetDestinationProtocolMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddress.proxyAddressGetDestinationProtocol",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddress.html#v:proxyAddressGetDestinationProtocol"
        })


#endif

-- method ProxyAddress::get_password
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "proxy"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ProxyAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxyAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_proxy_address_get_password" g_proxy_address_get_password :: 
    Ptr ProxyAddress ->                     -- proxy : TInterface (Name {namespace = "Gio", name = "ProxyAddress"})
    IO CString

-- | Gets /@proxy@/\'s password.
-- 
-- /Since: 2.26/
proxyAddressGetPassword ::
    (B.CallStack.HasCallStack, MonadIO m, IsProxyAddress a) =>
    a
    -- ^ /@proxy@/: a t'GI.Gio.Objects.ProxyAddress.ProxyAddress'
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the /@proxy@/\'s password
proxyAddressGetPassword proxy = liftIO $ do
    proxy' <- unsafeManagedPtrCastPtr proxy
    result <- g_proxy_address_get_password proxy'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr proxy
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ProxyAddressGetPasswordMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsProxyAddress a) => O.OverloadedMethod ProxyAddressGetPasswordMethodInfo a signature where
    overloadedMethod = proxyAddressGetPassword

instance O.OverloadedMethodInfo ProxyAddressGetPasswordMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddress.proxyAddressGetPassword",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddress.html#v:proxyAddressGetPassword"
        })


#endif

-- method ProxyAddress::get_protocol
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "proxy"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ProxyAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxyAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_proxy_address_get_protocol" g_proxy_address_get_protocol :: 
    Ptr ProxyAddress ->                     -- proxy : TInterface (Name {namespace = "Gio", name = "ProxyAddress"})
    IO CString

-- | Gets /@proxy@/\'s protocol. eg, \"socks\" or \"http\"
-- 
-- /Since: 2.26/
proxyAddressGetProtocol ::
    (B.CallStack.HasCallStack, MonadIO m, IsProxyAddress a) =>
    a
    -- ^ /@proxy@/: a t'GI.Gio.Objects.ProxyAddress.ProxyAddress'
    -> m T.Text
    -- ^ __Returns:__ the /@proxy@/\'s protocol
proxyAddressGetProtocol proxy = liftIO $ do
    proxy' <- unsafeManagedPtrCastPtr proxy
    result <- g_proxy_address_get_protocol proxy'
    checkUnexpectedReturnNULL "proxyAddressGetProtocol" result
    result' <- cstringToText result
    touchManagedPtr proxy
    return result'

#if defined(ENABLE_OVERLOADING)
data ProxyAddressGetProtocolMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsProxyAddress a) => O.OverloadedMethod ProxyAddressGetProtocolMethodInfo a signature where
    overloadedMethod = proxyAddressGetProtocol

instance O.OverloadedMethodInfo ProxyAddressGetProtocolMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddress.proxyAddressGetProtocol",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddress.html#v:proxyAddressGetProtocol"
        })


#endif

-- method ProxyAddress::get_uri
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "proxy"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ProxyAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxyAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_proxy_address_get_uri" g_proxy_address_get_uri :: 
    Ptr ProxyAddress ->                     -- proxy : TInterface (Name {namespace = "Gio", name = "ProxyAddress"})
    IO CString

-- | Gets the proxy URI that /@proxy@/ was constructed from.
-- 
-- /Since: 2.34/
proxyAddressGetUri ::
    (B.CallStack.HasCallStack, MonadIO m, IsProxyAddress a) =>
    a
    -- ^ /@proxy@/: a t'GI.Gio.Objects.ProxyAddress.ProxyAddress'
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the /@proxy@/\'s URI, or 'P.Nothing' if unknown
proxyAddressGetUri proxy = liftIO $ do
    proxy' <- unsafeManagedPtrCastPtr proxy
    result <- g_proxy_address_get_uri proxy'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr proxy
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ProxyAddressGetUriMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsProxyAddress a) => O.OverloadedMethod ProxyAddressGetUriMethodInfo a signature where
    overloadedMethod = proxyAddressGetUri

instance O.OverloadedMethodInfo ProxyAddressGetUriMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddress.proxyAddressGetUri",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddress.html#v:proxyAddressGetUri"
        })


#endif

-- method ProxyAddress::get_username
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "proxy"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "ProxyAddress" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GProxyAddress" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "g_proxy_address_get_username" g_proxy_address_get_username :: 
    Ptr ProxyAddress ->                     -- proxy : TInterface (Name {namespace = "Gio", name = "ProxyAddress"})
    IO CString

-- | Gets /@proxy@/\'s username.
-- 
-- /Since: 2.26/
proxyAddressGetUsername ::
    (B.CallStack.HasCallStack, MonadIO m, IsProxyAddress a) =>
    a
    -- ^ /@proxy@/: a t'GI.Gio.Objects.ProxyAddress.ProxyAddress'
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the /@proxy@/\'s username
proxyAddressGetUsername proxy = liftIO $ do
    proxy' <- unsafeManagedPtrCastPtr proxy
    result <- g_proxy_address_get_username proxy'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr proxy
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ProxyAddressGetUsernameMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsProxyAddress a) => O.OverloadedMethod ProxyAddressGetUsernameMethodInfo a signature where
    overloadedMethod = proxyAddressGetUsername

instance O.OverloadedMethodInfo ProxyAddressGetUsernameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.ProxyAddress.proxyAddressGetUsername",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-ProxyAddress.html#v:proxyAddressGetUsername"
        })


#endif


