{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A @GDBusObjectSkeleton@ instance is essentially a group of D-Bus
-- interfaces. The set of exported interfaces on the object may be
-- dynamic and change at runtime.
-- 
-- This type is intended to be used with t'GI.Gio.Interfaces.DBusObjectManager.DBusObjectManager'.
-- 
-- /Since: 2.30/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Objects.DBusObjectSkeleton
    ( 

-- * Exported types
    DBusObjectSkeleton(..)                  ,
    IsDBusObjectSkeleton                    ,
    toDBusObjectSkeleton                    ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [addInterface]("GI.Gio.Objects.DBusObjectSkeleton#g:method:addInterface"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [flush]("GI.Gio.Objects.DBusObjectSkeleton#g:method:flush"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeInterface]("GI.Gio.Objects.DBusObjectSkeleton#g:method:removeInterface"), [removeInterfaceByName]("GI.Gio.Objects.DBusObjectSkeleton#g:method:removeInterfaceByName"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getInterface]("GI.Gio.Interfaces.DBusObject#g:method:getInterface"), [getInterfaces]("GI.Gio.Interfaces.DBusObject#g:method:getInterfaces"), [getObjectPath]("GI.Gio.Interfaces.DBusObject#g:method:getObjectPath"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setObjectPath]("GI.Gio.Objects.DBusObjectSkeleton#g:method:setObjectPath"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDBusObjectSkeletonMethod         ,
#endif

-- ** addInterface #method:addInterface#

#if defined(ENABLE_OVERLOADING)
    DBusObjectSkeletonAddInterfaceMethodInfo,
#endif
    dBusObjectSkeletonAddInterface          ,


-- ** flush #method:flush#

#if defined(ENABLE_OVERLOADING)
    DBusObjectSkeletonFlushMethodInfo       ,
#endif
    dBusObjectSkeletonFlush                 ,


-- ** new #method:new#

    dBusObjectSkeletonNew                   ,


-- ** removeInterface #method:removeInterface#

#if defined(ENABLE_OVERLOADING)
    DBusObjectSkeletonRemoveInterfaceMethodInfo,
#endif
    dBusObjectSkeletonRemoveInterface       ,


-- ** removeInterfaceByName #method:removeInterfaceByName#

#if defined(ENABLE_OVERLOADING)
    DBusObjectSkeletonRemoveInterfaceByNameMethodInfo,
#endif
    dBusObjectSkeletonRemoveInterfaceByName ,


-- ** setObjectPath #method:setObjectPath#

#if defined(ENABLE_OVERLOADING)
    DBusObjectSkeletonSetObjectPathMethodInfo,
#endif
    dBusObjectSkeletonSetObjectPath         ,




 -- * Properties


-- ** gObjectPath #attr:gObjectPath#
-- | The object path where the object is exported.
-- 
-- /Since: 2.30/

#if defined(ENABLE_OVERLOADING)
    DBusObjectSkeletonGObjectPathPropertyInfo,
#endif
    clearDBusObjectSkeletonGObjectPath      ,
    constructDBusObjectSkeletonGObjectPath  ,
#if defined(ENABLE_OVERLOADING)
    dBusObjectSkeletonGObjectPath           ,
#endif
    getDBusObjectSkeletonGObjectPath        ,
    setDBusObjectSkeletonGObjectPath        ,




 -- * Signals


-- ** authorizeMethod #signal:authorizeMethod#

    DBusObjectSkeletonAuthorizeMethodCallback,
#if defined(ENABLE_OVERLOADING)
    DBusObjectSkeletonAuthorizeMethodSignalInfo,
#endif
    afterDBusObjectSkeletonAuthorizeMethod  ,
    onDBusObjectSkeletonAuthorizeMethod     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GLib.Structs.VariantType as GLib.VariantType
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import qualified GI.Gio.Callbacks as Gio.Callbacks
import {-# SOURCE #-} qualified GI.Gio.Enums as Gio.Enums
import {-# SOURCE #-} qualified GI.Gio.Flags as Gio.Flags
import {-# SOURCE #-} qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncInitable as Gio.AsyncInitable
import {-# SOURCE #-} qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusInterface as Gio.DBusInterface
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusObject as Gio.DBusObject
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import {-# SOURCE #-} qualified GI.Gio.Objects.Credentials as Gio.Credentials
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusAuthObserver as Gio.DBusAuthObserver
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusConnection as Gio.DBusConnection
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusInterfaceSkeleton as Gio.DBusInterfaceSkeleton
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusMessage as Gio.DBusMessage
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusMethodInvocation as Gio.DBusMethodInvocation
import {-# SOURCE #-} qualified GI.Gio.Objects.IOStream as Gio.IOStream
import {-# SOURCE #-} qualified GI.Gio.Objects.InputStream as Gio.InputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuAttributeIter as Gio.MenuAttributeIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuLinkIter as Gio.MenuLinkIter
import {-# SOURCE #-} qualified GI.Gio.Objects.MenuModel as Gio.MenuModel
import {-# SOURCE #-} qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import {-# SOURCE #-} qualified GI.Gio.Objects.UnixFDList as Gio.UnixFDList
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusAnnotationInfo as Gio.DBusAnnotationInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusArgInfo as Gio.DBusArgInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceInfo as Gio.DBusInterfaceInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusInterfaceVTable as Gio.DBusInterfaceVTable
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusMethodInfo as Gio.DBusMethodInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusPropertyInfo as Gio.DBusPropertyInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSignalInfo as Gio.DBusSignalInfo
import {-# SOURCE #-} qualified GI.Gio.Structs.DBusSubtreeVTable as Gio.DBusSubtreeVTable
import {-# SOURCE #-} qualified GI.Gio.Structs.OutputVector as Gio.OutputVector

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.DBusObject as Gio.DBusObject
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusInterfaceSkeleton as Gio.DBusInterfaceSkeleton
import {-# SOURCE #-} qualified GI.Gio.Objects.DBusMethodInvocation as Gio.DBusMethodInvocation

#endif

-- | Memory-managed wrapper type.
newtype DBusObjectSkeleton = DBusObjectSkeleton (SP.ManagedPtr DBusObjectSkeleton)
    deriving (Eq)

instance SP.ManagedPtrNewtype DBusObjectSkeleton where
    toManagedPtr (DBusObjectSkeleton p) = p

foreign import ccall "g_dbus_object_skeleton_get_type"
    c_g_dbus_object_skeleton_get_type :: IO B.Types.GType

instance B.Types.TypedObject DBusObjectSkeleton where
    glibType = c_g_dbus_object_skeleton_get_type

instance B.Types.GObject DBusObjectSkeleton

-- | Type class for types which can be safely cast to t'DBusObjectSkeleton', for instance with `toDBusObjectSkeleton`.
class (SP.GObject o, O.IsDescendantOf DBusObjectSkeleton o) => IsDBusObjectSkeleton o
instance (SP.GObject o, O.IsDescendantOf DBusObjectSkeleton o) => IsDBusObjectSkeleton o

instance O.HasParentTypes DBusObjectSkeleton
type instance O.ParentTypes DBusObjectSkeleton = '[GObject.Object.Object, Gio.DBusObject.DBusObject]

-- | Cast to t'DBusObjectSkeleton', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDBusObjectSkeleton :: (MIO.MonadIO m, IsDBusObjectSkeleton o) => o -> m DBusObjectSkeleton
toDBusObjectSkeleton = MIO.liftIO . B.ManagedPtr.unsafeCastTo DBusObjectSkeleton

-- | Convert t'DBusObjectSkeleton' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe DBusObjectSkeleton) where
    gvalueGType_ = c_g_dbus_object_skeleton_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr DBusObjectSkeleton)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr DBusObjectSkeleton)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject DBusObjectSkeleton ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDBusObjectSkeletonMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDBusObjectSkeletonMethod "addInterface" o = DBusObjectSkeletonAddInterfaceMethodInfo
    ResolveDBusObjectSkeletonMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDBusObjectSkeletonMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDBusObjectSkeletonMethod "flush" o = DBusObjectSkeletonFlushMethodInfo
    ResolveDBusObjectSkeletonMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDBusObjectSkeletonMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDBusObjectSkeletonMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDBusObjectSkeletonMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDBusObjectSkeletonMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDBusObjectSkeletonMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDBusObjectSkeletonMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDBusObjectSkeletonMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDBusObjectSkeletonMethod "removeInterface" o = DBusObjectSkeletonRemoveInterfaceMethodInfo
    ResolveDBusObjectSkeletonMethod "removeInterfaceByName" o = DBusObjectSkeletonRemoveInterfaceByNameMethodInfo
    ResolveDBusObjectSkeletonMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDBusObjectSkeletonMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDBusObjectSkeletonMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDBusObjectSkeletonMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDBusObjectSkeletonMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDBusObjectSkeletonMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDBusObjectSkeletonMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDBusObjectSkeletonMethod "getInterface" o = Gio.DBusObject.DBusObjectGetInterfaceMethodInfo
    ResolveDBusObjectSkeletonMethod "getInterfaces" o = Gio.DBusObject.DBusObjectGetInterfacesMethodInfo
    ResolveDBusObjectSkeletonMethod "getObjectPath" o = Gio.DBusObject.DBusObjectGetObjectPathMethodInfo
    ResolveDBusObjectSkeletonMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDBusObjectSkeletonMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDBusObjectSkeletonMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDBusObjectSkeletonMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDBusObjectSkeletonMethod "setObjectPath" o = DBusObjectSkeletonSetObjectPathMethodInfo
    ResolveDBusObjectSkeletonMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDBusObjectSkeletonMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDBusObjectSkeletonMethod t DBusObjectSkeleton, O.OverloadedMethod info DBusObjectSkeleton p) => OL.IsLabel t (DBusObjectSkeleton -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDBusObjectSkeletonMethod t DBusObjectSkeleton, O.OverloadedMethod info DBusObjectSkeleton p, R.HasField t DBusObjectSkeleton p) => R.HasField t DBusObjectSkeleton p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDBusObjectSkeletonMethod t DBusObjectSkeleton, O.OverloadedMethodInfo info DBusObjectSkeleton) => OL.IsLabel t (O.MethodProxy info DBusObjectSkeleton) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal DBusObjectSkeleton::authorize-method
-- | Emitted when a method is invoked by a remote caller and used to
-- determine if the method call is authorized.
-- 
-- This signal is like t'GI.Gio.Objects.DBusInterfaceSkeleton.DBusInterfaceSkeleton'\'s
-- [DBusInterfaceSkeleton::gAuthorizeMethod]("GI.Gio.Objects.DBusInterfaceSkeleton#g:signal:gAuthorizeMethod") signal,
-- except that it is for the enclosing object.
-- 
-- The default class handler just returns 'P.True'.
-- 
-- /Since: 2.30/
type DBusObjectSkeletonAuthorizeMethodCallback =
    Gio.DBusInterfaceSkeleton.DBusInterfaceSkeleton
    -- ^ /@interface@/: The t'GI.Gio.Objects.DBusInterfaceSkeleton.DBusInterfaceSkeleton' that /@invocation@/ is for.
    -> Gio.DBusMethodInvocation.DBusMethodInvocation
    -- ^ /@invocation@/: A t'GI.Gio.Objects.DBusMethodInvocation.DBusMethodInvocation'.
    -> IO Bool
    -- ^ __Returns:__ 'P.True' if the call is authorized, 'P.False' otherwise.

type C_DBusObjectSkeletonAuthorizeMethodCallback =
    Ptr DBusObjectSkeleton ->               -- object
    Ptr Gio.DBusInterfaceSkeleton.DBusInterfaceSkeleton ->
    Ptr Gio.DBusMethodInvocation.DBusMethodInvocation ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_DBusObjectSkeletonAuthorizeMethodCallback`.
foreign import ccall "wrapper"
    mk_DBusObjectSkeletonAuthorizeMethodCallback :: C_DBusObjectSkeletonAuthorizeMethodCallback -> IO (FunPtr C_DBusObjectSkeletonAuthorizeMethodCallback)

wrap_DBusObjectSkeletonAuthorizeMethodCallback :: 
    GObject a => (a -> DBusObjectSkeletonAuthorizeMethodCallback) ->
    C_DBusObjectSkeletonAuthorizeMethodCallback
wrap_DBusObjectSkeletonAuthorizeMethodCallback gi'cb gi'selfPtr interface invocation _ = do
    interface' <- (newObject Gio.DBusInterfaceSkeleton.DBusInterfaceSkeleton) interface
    invocation' <- (newObject Gio.DBusMethodInvocation.DBusMethodInvocation) invocation
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  interface' invocation'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [authorizeMethod](#signal:authorizeMethod) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' dBusObjectSkeleton #authorizeMethod callback
-- @
-- 
-- 
onDBusObjectSkeletonAuthorizeMethod :: (IsDBusObjectSkeleton a, MonadIO m) => a -> ((?self :: a) => DBusObjectSkeletonAuthorizeMethodCallback) -> m SignalHandlerId
onDBusObjectSkeletonAuthorizeMethod obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DBusObjectSkeletonAuthorizeMethodCallback wrapped
    wrapped'' <- mk_DBusObjectSkeletonAuthorizeMethodCallback wrapped'
    connectSignalFunPtr obj "authorize-method" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [authorizeMethod](#signal:authorizeMethod) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' dBusObjectSkeleton #authorizeMethod callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDBusObjectSkeletonAuthorizeMethod :: (IsDBusObjectSkeleton a, MonadIO m) => a -> ((?self :: a) => DBusObjectSkeletonAuthorizeMethodCallback) -> m SignalHandlerId
afterDBusObjectSkeletonAuthorizeMethod obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DBusObjectSkeletonAuthorizeMethodCallback wrapped
    wrapped'' <- mk_DBusObjectSkeletonAuthorizeMethodCallback wrapped'
    connectSignalFunPtr obj "authorize-method" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DBusObjectSkeletonAuthorizeMethodSignalInfo
instance SignalInfo DBusObjectSkeletonAuthorizeMethodSignalInfo where
    type HaskellCallbackType DBusObjectSkeletonAuthorizeMethodSignalInfo = DBusObjectSkeletonAuthorizeMethodCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DBusObjectSkeletonAuthorizeMethodCallback cb
        cb'' <- mk_DBusObjectSkeletonAuthorizeMethodCallback cb'
        connectSignalFunPtr obj "authorize-method" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectSkeleton::authorize-method"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-DBusObjectSkeleton.html#g:signal:authorizeMethod"})

#endif

-- VVV Prop "g-object-path"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@g-object-path@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' dBusObjectSkeleton #gObjectPath
-- @
getDBusObjectSkeletonGObjectPath :: (MonadIO m, IsDBusObjectSkeleton o) => o -> m (Maybe T.Text)
getDBusObjectSkeletonGObjectPath obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "g-object-path"

-- | Set the value of the “@g-object-path@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' dBusObjectSkeleton [ #gObjectPath 'Data.GI.Base.Attributes.:=' value ]
-- @
setDBusObjectSkeletonGObjectPath :: (MonadIO m, IsDBusObjectSkeleton o) => o -> T.Text -> m ()
setDBusObjectSkeletonGObjectPath obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "g-object-path" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@g-object-path@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDBusObjectSkeletonGObjectPath :: (IsDBusObjectSkeleton o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructDBusObjectSkeletonGObjectPath val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "g-object-path" (P.Just val)

-- | Set the value of the “@g-object-path@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #gObjectPath
-- @
clearDBusObjectSkeletonGObjectPath :: (MonadIO m, IsDBusObjectSkeleton o) => o -> m ()
clearDBusObjectSkeletonGObjectPath obj = liftIO $ B.Properties.setObjectPropertyString obj "g-object-path" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data DBusObjectSkeletonGObjectPathPropertyInfo
instance AttrInfo DBusObjectSkeletonGObjectPathPropertyInfo where
    type AttrAllowedOps DBusObjectSkeletonGObjectPathPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DBusObjectSkeletonGObjectPathPropertyInfo = IsDBusObjectSkeleton
    type AttrSetTypeConstraint DBusObjectSkeletonGObjectPathPropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint DBusObjectSkeletonGObjectPathPropertyInfo = (~) T.Text
    type AttrTransferType DBusObjectSkeletonGObjectPathPropertyInfo = T.Text
    type AttrGetType DBusObjectSkeletonGObjectPathPropertyInfo = (Maybe T.Text)
    type AttrLabel DBusObjectSkeletonGObjectPathPropertyInfo = "g-object-path"
    type AttrOrigin DBusObjectSkeletonGObjectPathPropertyInfo = DBusObjectSkeleton
    attrGet = getDBusObjectSkeletonGObjectPath
    attrSet = setDBusObjectSkeletonGObjectPath
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDBusObjectSkeletonGObjectPath
    attrClear = clearDBusObjectSkeletonGObjectPath
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectSkeleton.gObjectPath"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-DBusObjectSkeleton.html#g:attr:gObjectPath"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList DBusObjectSkeleton
type instance O.AttributeList DBusObjectSkeleton = DBusObjectSkeletonAttributeList
type DBusObjectSkeletonAttributeList = ('[ '("gObjectPath", DBusObjectSkeletonGObjectPathPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
dBusObjectSkeletonGObjectPath :: AttrLabelProxy "gObjectPath"
dBusObjectSkeletonGObjectPath = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList DBusObjectSkeleton = DBusObjectSkeletonSignalList
type DBusObjectSkeletonSignalList = ('[ '("authorizeMethod", DBusObjectSkeletonAuthorizeMethodSignalInfo), '("interfaceAdded", Gio.DBusObject.DBusObjectInterfaceAddedSignalInfo), '("interfaceRemoved", Gio.DBusObject.DBusObjectInterfaceRemovedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method DBusObjectSkeleton::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "object_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "An object path." , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "DBusObjectSkeleton" })
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_skeleton_new" g_dbus_object_skeleton_new :: 
    CString ->                              -- object_path : TBasicType TUTF8
    IO (Ptr DBusObjectSkeleton)

-- | Creates a new t'GI.Gio.Objects.DBusObjectSkeleton.DBusObjectSkeleton'.
-- 
-- /Since: 2.30/
dBusObjectSkeletonNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    T.Text
    -- ^ /@objectPath@/: An object path.
    -> m DBusObjectSkeleton
    -- ^ __Returns:__ A t'GI.Gio.Objects.DBusObjectSkeleton.DBusObjectSkeleton'. Free with 'GI.GObject.Objects.Object.objectUnref'.
dBusObjectSkeletonNew objectPath = liftIO $ do
    objectPath' <- textToCString objectPath
    result <- g_dbus_object_skeleton_new objectPath'
    checkUnexpectedReturnNULL "dBusObjectSkeletonNew" result
    result' <- (wrapObject DBusObjectSkeleton) result
    freeMem objectPath'
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method DBusObjectSkeleton::add_interface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusObjectSkeleton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObjectSkeleton."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interface_"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DBusInterfaceSkeleton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusInterfaceSkeleton."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_skeleton_add_interface" g_dbus_object_skeleton_add_interface :: 
    Ptr DBusObjectSkeleton ->               -- object : TInterface (Name {namespace = "Gio", name = "DBusObjectSkeleton"})
    Ptr Gio.DBusInterfaceSkeleton.DBusInterfaceSkeleton -> -- interface_ : TInterface (Name {namespace = "Gio", name = "DBusInterfaceSkeleton"})
    IO ()

-- | Adds /@interface_@/ to /@object@/.
-- 
-- If /@object@/ already contains a t'GI.Gio.Objects.DBusInterfaceSkeleton.DBusInterfaceSkeleton' with the same
-- interface name, it is removed before /@interface_@/ is added.
-- 
-- Note that /@object@/ takes its own reference on /@interface_@/ and holds
-- it until removed.
-- 
-- /Since: 2.30/
dBusObjectSkeletonAddInterface ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusObjectSkeleton a, Gio.DBusInterfaceSkeleton.IsDBusInterfaceSkeleton b) =>
    a
    -- ^ /@object@/: A t'GI.Gio.Objects.DBusObjectSkeleton.DBusObjectSkeleton'.
    -> b
    -- ^ /@interface_@/: A t'GI.Gio.Objects.DBusInterfaceSkeleton.DBusInterfaceSkeleton'.
    -> m ()
dBusObjectSkeletonAddInterface object interface_ = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    interface_' <- unsafeManagedPtrCastPtr interface_
    g_dbus_object_skeleton_add_interface object' interface_'
    touchManagedPtr object
    touchManagedPtr interface_
    return ()

#if defined(ENABLE_OVERLOADING)
data DBusObjectSkeletonAddInterfaceMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsDBusObjectSkeleton a, Gio.DBusInterfaceSkeleton.IsDBusInterfaceSkeleton b) => O.OverloadedMethod DBusObjectSkeletonAddInterfaceMethodInfo a signature where
    overloadedMethod = dBusObjectSkeletonAddInterface

instance O.OverloadedMethodInfo DBusObjectSkeletonAddInterfaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectSkeleton.dBusObjectSkeletonAddInterface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-DBusObjectSkeleton.html#v:dBusObjectSkeletonAddInterface"
        })


#endif

-- method DBusObjectSkeleton::flush
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusObjectSkeleton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObjectSkeleton."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_skeleton_flush" g_dbus_object_skeleton_flush :: 
    Ptr DBusObjectSkeleton ->               -- object : TInterface (Name {namespace = "Gio", name = "DBusObjectSkeleton"})
    IO ()

-- | This method simply calls 'GI.Gio.Objects.DBusInterfaceSkeleton.dBusInterfaceSkeletonFlush' on all
-- interfaces belonging to /@object@/. See that method for when flushing
-- is useful.
-- 
-- /Since: 2.30/
dBusObjectSkeletonFlush ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusObjectSkeleton a) =>
    a
    -- ^ /@object@/: A t'GI.Gio.Objects.DBusObjectSkeleton.DBusObjectSkeleton'.
    -> m ()
dBusObjectSkeletonFlush object = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    g_dbus_object_skeleton_flush object'
    touchManagedPtr object
    return ()

#if defined(ENABLE_OVERLOADING)
data DBusObjectSkeletonFlushMethodInfo
instance (signature ~ (m ()), MonadIO m, IsDBusObjectSkeleton a) => O.OverloadedMethod DBusObjectSkeletonFlushMethodInfo a signature where
    overloadedMethod = dBusObjectSkeletonFlush

instance O.OverloadedMethodInfo DBusObjectSkeletonFlushMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectSkeleton.dBusObjectSkeletonFlush",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-DBusObjectSkeleton.html#v:dBusObjectSkeletonFlush"
        })


#endif

-- method DBusObjectSkeleton::remove_interface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusObjectSkeleton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObjectSkeleton."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interface_"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "DBusInterfaceSkeleton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusInterfaceSkeleton."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_skeleton_remove_interface" g_dbus_object_skeleton_remove_interface :: 
    Ptr DBusObjectSkeleton ->               -- object : TInterface (Name {namespace = "Gio", name = "DBusObjectSkeleton"})
    Ptr Gio.DBusInterfaceSkeleton.DBusInterfaceSkeleton -> -- interface_ : TInterface (Name {namespace = "Gio", name = "DBusInterfaceSkeleton"})
    IO ()

-- | Removes /@interface_@/ from /@object@/.
-- 
-- /Since: 2.30/
dBusObjectSkeletonRemoveInterface ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusObjectSkeleton a, Gio.DBusInterfaceSkeleton.IsDBusInterfaceSkeleton b) =>
    a
    -- ^ /@object@/: A t'GI.Gio.Objects.DBusObjectSkeleton.DBusObjectSkeleton'.
    -> b
    -- ^ /@interface_@/: A t'GI.Gio.Objects.DBusInterfaceSkeleton.DBusInterfaceSkeleton'.
    -> m ()
dBusObjectSkeletonRemoveInterface object interface_ = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    interface_' <- unsafeManagedPtrCastPtr interface_
    g_dbus_object_skeleton_remove_interface object' interface_'
    touchManagedPtr object
    touchManagedPtr interface_
    return ()

#if defined(ENABLE_OVERLOADING)
data DBusObjectSkeletonRemoveInterfaceMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsDBusObjectSkeleton a, Gio.DBusInterfaceSkeleton.IsDBusInterfaceSkeleton b) => O.OverloadedMethod DBusObjectSkeletonRemoveInterfaceMethodInfo a signature where
    overloadedMethod = dBusObjectSkeletonRemoveInterface

instance O.OverloadedMethodInfo DBusObjectSkeletonRemoveInterfaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectSkeleton.dBusObjectSkeletonRemoveInterface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-DBusObjectSkeleton.html#v:dBusObjectSkeletonRemoveInterface"
        })


#endif

-- method DBusObjectSkeleton::remove_interface_by_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusObjectSkeleton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObjectSkeleton."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "interface_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A D-Bus interface name."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_skeleton_remove_interface_by_name" g_dbus_object_skeleton_remove_interface_by_name :: 
    Ptr DBusObjectSkeleton ->               -- object : TInterface (Name {namespace = "Gio", name = "DBusObjectSkeleton"})
    CString ->                              -- interface_name : TBasicType TUTF8
    IO ()

-- | Removes the t'GI.Gio.Interfaces.DBusInterface.DBusInterface' with /@interfaceName@/ from /@object@/.
-- 
-- If no D-Bus interface of the given interface exists, this function
-- does nothing.
-- 
-- /Since: 2.30/
dBusObjectSkeletonRemoveInterfaceByName ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusObjectSkeleton a) =>
    a
    -- ^ /@object@/: A t'GI.Gio.Objects.DBusObjectSkeleton.DBusObjectSkeleton'.
    -> T.Text
    -- ^ /@interfaceName@/: A D-Bus interface name.
    -> m ()
dBusObjectSkeletonRemoveInterfaceByName object interfaceName = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    interfaceName' <- textToCString interfaceName
    g_dbus_object_skeleton_remove_interface_by_name object' interfaceName'
    touchManagedPtr object
    freeMem interfaceName'
    return ()

#if defined(ENABLE_OVERLOADING)
data DBusObjectSkeletonRemoveInterfaceByNameMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsDBusObjectSkeleton a) => O.OverloadedMethod DBusObjectSkeletonRemoveInterfaceByNameMethodInfo a signature where
    overloadedMethod = dBusObjectSkeletonRemoveInterfaceByName

instance O.OverloadedMethodInfo DBusObjectSkeletonRemoveInterfaceByNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectSkeleton.dBusObjectSkeletonRemoveInterfaceByName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-DBusObjectSkeleton.html#v:dBusObjectSkeletonRemoveInterfaceByName"
        })


#endif

-- method DBusObjectSkeleton::set_object_path
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "object"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "DBusObjectSkeleton" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A #GDBusObjectSkeleton."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "object_path"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "A valid D-Bus object path."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "g_dbus_object_skeleton_set_object_path" g_dbus_object_skeleton_set_object_path :: 
    Ptr DBusObjectSkeleton ->               -- object : TInterface (Name {namespace = "Gio", name = "DBusObjectSkeleton"})
    CString ->                              -- object_path : TBasicType TUTF8
    IO ()

-- | Sets the object path for /@object@/.
-- 
-- /Since: 2.30/
dBusObjectSkeletonSetObjectPath ::
    (B.CallStack.HasCallStack, MonadIO m, IsDBusObjectSkeleton a) =>
    a
    -- ^ /@object@/: A t'GI.Gio.Objects.DBusObjectSkeleton.DBusObjectSkeleton'.
    -> T.Text
    -- ^ /@objectPath@/: A valid D-Bus object path.
    -> m ()
dBusObjectSkeletonSetObjectPath object objectPath = liftIO $ do
    object' <- unsafeManagedPtrCastPtr object
    objectPath' <- textToCString objectPath
    g_dbus_object_skeleton_set_object_path object' objectPath'
    touchManagedPtr object
    freeMem objectPath'
    return ()

#if defined(ENABLE_OVERLOADING)
data DBusObjectSkeletonSetObjectPathMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsDBusObjectSkeleton a) => O.OverloadedMethod DBusObjectSkeletonSetObjectPathMethodInfo a signature where
    overloadedMethod = dBusObjectSkeletonSetObjectPath

instance O.OverloadedMethodInfo DBusObjectSkeletonSetObjectPathMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Objects.DBusObjectSkeleton.dBusObjectSkeletonSetObjectPath",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Objects-DBusObjectSkeleton.html#v:dBusObjectSkeletonSetObjectPath"
        })


#endif


