{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GPowerProfileMonitor@ makes it possible for applications as well as OS
-- components to monitor system power profiles and act upon them. It currently
-- only exports whether the system is in “Power Saver” mode (known as
-- “Low Power” mode on some systems).
-- 
-- When in “Low Power” mode, it is recommended that applications:
-- 
-- * disable automatic downloads;
-- * reduce the rate of refresh from online sources such as calendar or
--   email synchronisation;
-- * reduce the use of expensive visual effects.
-- 
-- 
-- It is also likely that OS components providing services to applications will
-- lower their own background activity, for the sake of the system.
-- 
-- There are a variety of tools that exist for power consumption analysis, but those
-- usually depend on the OS and hardware used. On Linux, one could use @upower@ to
-- monitor the battery discharge rate, @powertop@ to check on the background activity
-- or activity at all), @sysprof@ to inspect CPU usage, and @intel_gpu_time@ to
-- profile GPU usage.
-- 
-- Don’t forget to disconnect the [Object::notify]("GI.GObject.Objects.Object#g:signal:notify") signal for
-- [PowerProfileMonitor:powerSaverEnabled]("GI.Gio.Interfaces.PowerProfileMonitor#g:attr:powerSaverEnabled"), and unref the
-- @GPowerProfileMonitor@ itself when exiting.
-- 
-- /Since: 2.70/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gio.Interfaces.PowerProfileMonitor
    ( 

-- * Exported types
    PowerProfileMonitor(..)                 ,
    IsPowerProfileMonitor                   ,
    toPowerProfileMonitor                   ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [init]("GI.Gio.Interfaces.Initable#g:method:init"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getPowerSaverEnabled]("GI.Gio.Interfaces.PowerProfileMonitor#g:method:getPowerSaverEnabled"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolvePowerProfileMonitorMethod        ,
#endif

-- ** dupDefault #method:dupDefault#

    powerProfileMonitorDupDefault           ,


-- ** getPowerSaverEnabled #method:getPowerSaverEnabled#

#if defined(ENABLE_OVERLOADING)
    PowerProfileMonitorGetPowerSaverEnabledMethodInfo,
#endif
    powerProfileMonitorGetPowerSaverEnabled ,




 -- * Properties


-- ** powerSaverEnabled #attr:powerSaverEnabled#
-- | Whether “Power Saver” mode is enabled on the system.
-- 
-- /Since: 2.70/

#if defined(ENABLE_OVERLOADING)
    PowerProfileMonitorPowerSaverEnabledPropertyInfo,
#endif
    getPowerProfileMonitorPowerSaverEnabled ,
#if defined(ENABLE_OVERLOADING)
    powerProfileMonitorPowerSaverEnabled    ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.PollFD as GLib.PollFD
import qualified GI.GLib.Structs.Source as GLib.Source
import qualified GI.GObject.Callbacks as GObject.Callbacks
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.GObject.Structs.Parameter as GObject.Parameter
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable
import {-# SOURCE #-} qualified GI.Gio.Objects.Cancellable as Gio.Cancellable

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gio.Interfaces.Initable as Gio.Initable

#endif

-- interface PowerProfileMonitor 
-- | Memory-managed wrapper type.
newtype PowerProfileMonitor = PowerProfileMonitor (SP.ManagedPtr PowerProfileMonitor)
    deriving (Eq)

instance SP.ManagedPtrNewtype PowerProfileMonitor where
    toManagedPtr (PowerProfileMonitor p) = p

foreign import ccall "g_power_profile_monitor_get_type"
    c_g_power_profile_monitor_get_type :: IO B.Types.GType

instance B.Types.TypedObject PowerProfileMonitor where
    glibType = c_g_power_profile_monitor_get_type

instance B.Types.GObject PowerProfileMonitor

-- | Type class for types which can be safely cast to t'PowerProfileMonitor', for instance with `toPowerProfileMonitor`.
class (SP.GObject o, O.IsDescendantOf PowerProfileMonitor o) => IsPowerProfileMonitor o
instance (SP.GObject o, O.IsDescendantOf PowerProfileMonitor o) => IsPowerProfileMonitor o

instance O.HasParentTypes PowerProfileMonitor
type instance O.ParentTypes PowerProfileMonitor = '[Gio.Initable.Initable, GObject.Object.Object]

-- | Cast to t'PowerProfileMonitor', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toPowerProfileMonitor :: (MIO.MonadIO m, IsPowerProfileMonitor o) => o -> m PowerProfileMonitor
toPowerProfileMonitor = MIO.liftIO . B.ManagedPtr.unsafeCastTo PowerProfileMonitor

-- | Convert t'PowerProfileMonitor' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe PowerProfileMonitor) where
    gvalueGType_ = c_g_power_profile_monitor_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr PowerProfileMonitor)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr PowerProfileMonitor)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject PowerProfileMonitor ptr
        else return P.Nothing
        
    

-- VVV Prop "power-saver-enabled"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@power-saver-enabled@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' powerProfileMonitor #powerSaverEnabled
-- @
getPowerProfileMonitorPowerSaverEnabled :: (MonadIO m, IsPowerProfileMonitor o) => o -> m Bool
getPowerProfileMonitorPowerSaverEnabled obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "power-saver-enabled"

#if defined(ENABLE_OVERLOADING)
data PowerProfileMonitorPowerSaverEnabledPropertyInfo
instance AttrInfo PowerProfileMonitorPowerSaverEnabledPropertyInfo where
    type AttrAllowedOps PowerProfileMonitorPowerSaverEnabledPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint PowerProfileMonitorPowerSaverEnabledPropertyInfo = IsPowerProfileMonitor
    type AttrSetTypeConstraint PowerProfileMonitorPowerSaverEnabledPropertyInfo = (~) ()
    type AttrTransferTypeConstraint PowerProfileMonitorPowerSaverEnabledPropertyInfo = (~) ()
    type AttrTransferType PowerProfileMonitorPowerSaverEnabledPropertyInfo = ()
    type AttrGetType PowerProfileMonitorPowerSaverEnabledPropertyInfo = Bool
    type AttrLabel PowerProfileMonitorPowerSaverEnabledPropertyInfo = "power-saver-enabled"
    type AttrOrigin PowerProfileMonitorPowerSaverEnabledPropertyInfo = PowerProfileMonitor
    attrGet = getPowerProfileMonitorPowerSaverEnabled
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.PowerProfileMonitor.powerSaverEnabled"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-PowerProfileMonitor.html#g:attr:powerSaverEnabled"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList PowerProfileMonitor
type instance O.AttributeList PowerProfileMonitor = PowerProfileMonitorAttributeList
type PowerProfileMonitorAttributeList = ('[ '("powerSaverEnabled", PowerProfileMonitorPowerSaverEnabledPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
powerProfileMonitorPowerSaverEnabled :: AttrLabelProxy "powerSaverEnabled"
powerProfileMonitorPowerSaverEnabled = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type family ResolvePowerProfileMonitorMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolvePowerProfileMonitorMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolvePowerProfileMonitorMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolvePowerProfileMonitorMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolvePowerProfileMonitorMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolvePowerProfileMonitorMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolvePowerProfileMonitorMethod "init" o = Gio.Initable.InitableInitMethodInfo
    ResolvePowerProfileMonitorMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolvePowerProfileMonitorMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolvePowerProfileMonitorMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolvePowerProfileMonitorMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolvePowerProfileMonitorMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolvePowerProfileMonitorMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolvePowerProfileMonitorMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolvePowerProfileMonitorMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolvePowerProfileMonitorMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolvePowerProfileMonitorMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolvePowerProfileMonitorMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolvePowerProfileMonitorMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolvePowerProfileMonitorMethod "getPowerSaverEnabled" o = PowerProfileMonitorGetPowerSaverEnabledMethodInfo
    ResolvePowerProfileMonitorMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolvePowerProfileMonitorMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolvePowerProfileMonitorMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolvePowerProfileMonitorMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolvePowerProfileMonitorMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolvePowerProfileMonitorMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolvePowerProfileMonitorMethod t PowerProfileMonitor, O.OverloadedMethod info PowerProfileMonitor p) => OL.IsLabel t (PowerProfileMonitor -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolvePowerProfileMonitorMethod t PowerProfileMonitor, O.OverloadedMethod info PowerProfileMonitor p, R.HasField t PowerProfileMonitor p) => R.HasField t PowerProfileMonitor p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolvePowerProfileMonitorMethod t PowerProfileMonitor, O.OverloadedMethodInfo info PowerProfileMonitor) => OL.IsLabel t (O.MethodProxy info PowerProfileMonitor) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- method PowerProfileMonitor::get_power_saver_enabled
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "monitor"
--           , argType =
--               TInterface
--                 Name { namespace = "Gio" , name = "PowerProfileMonitor" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a #GPowerProfileMonitor"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "g_power_profile_monitor_get_power_saver_enabled" g_power_profile_monitor_get_power_saver_enabled :: 
    Ptr PowerProfileMonitor ->              -- monitor : TInterface (Name {namespace = "Gio", name = "PowerProfileMonitor"})
    IO CInt

-- | Gets whether the system is in “Power Saver” mode.
-- 
-- You are expected to listen to the
-- t'GI.Gio.Interfaces.PowerProfileMonitor.PowerProfileMonitor'::@/notify/@[powerSaverEnabled](#g:signal:powerSaverEnabled) signal to know when the profile has
-- changed.
-- 
-- /Since: 2.70/
powerProfileMonitorGetPowerSaverEnabled ::
    (B.CallStack.HasCallStack, MonadIO m, IsPowerProfileMonitor a) =>
    a
    -- ^ /@monitor@/: a t'GI.Gio.Interfaces.PowerProfileMonitor.PowerProfileMonitor'
    -> m Bool
    -- ^ __Returns:__ Whether the system is in “Power Saver” mode.
powerProfileMonitorGetPowerSaverEnabled monitor = liftIO $ do
    monitor' <- unsafeManagedPtrCastPtr monitor
    result <- g_power_profile_monitor_get_power_saver_enabled monitor'
    let result' = (/= 0) result
    touchManagedPtr monitor
    return result'

#if defined(ENABLE_OVERLOADING)
data PowerProfileMonitorGetPowerSaverEnabledMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsPowerProfileMonitor a) => O.OverloadedMethod PowerProfileMonitorGetPowerSaverEnabledMethodInfo a signature where
    overloadedMethod = powerProfileMonitorGetPowerSaverEnabled

instance O.OverloadedMethodInfo PowerProfileMonitorGetPowerSaverEnabledMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gio.Interfaces.PowerProfileMonitor.powerProfileMonitorGetPowerSaverEnabled",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gio-2.0.38/docs/GI-Gio-Interfaces-PowerProfileMonitor.html#v:powerProfileMonitorGetPowerSaverEnabled"
        })


#endif

-- method PowerProfileMonitor::dup_default
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gio" , name = "PowerProfileMonitor" })
-- throws : False
-- Skip return : False

foreign import ccall "g_power_profile_monitor_dup_default" g_power_profile_monitor_dup_default :: 
    IO (Ptr PowerProfileMonitor)

-- | Gets a reference to the default t'GI.Gio.Interfaces.PowerProfileMonitor.PowerProfileMonitor' for the system.
-- 
-- /Since: 2.70/
powerProfileMonitorDupDefault ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m PowerProfileMonitor
    -- ^ __Returns:__ a new reference to the default t'GI.Gio.Interfaces.PowerProfileMonitor.PowerProfileMonitor'
powerProfileMonitorDupDefault  = liftIO $ do
    result <- g_power_profile_monitor_dup_default
    checkUnexpectedReturnNULL "powerProfileMonitorDupDefault" result
    result' <- (wrapObject PowerProfileMonitor) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList PowerProfileMonitor = PowerProfileMonitorSignalList
type PowerProfileMonitorSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


