{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.GdkX11.Objects.X11DisplayManager
    ( 

-- * Exported types
    X11DisplayManager(..)                   ,
    IsX11DisplayManager                     ,
    toX11DisplayManager                     ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [listDisplays]("GI.Gdk.Objects.DisplayManager#g:method:listDisplays"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [openDisplay]("GI.Gdk.Objects.DisplayManager#g:method:openDisplay"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDefaultDisplay]("GI.Gdk.Objects.DisplayManager#g:method:getDefaultDisplay"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDefaultDisplay]("GI.Gdk.Objects.DisplayManager#g:method:setDefaultDisplay"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveX11DisplayManagerMethod          ,
#endif



    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.DisplayManager as Gdk.DisplayManager

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.DisplayManager as Gdk.DisplayManager

#endif

-- | Memory-managed wrapper type.
newtype X11DisplayManager = X11DisplayManager (SP.ManagedPtr X11DisplayManager)
    deriving (Eq)

instance SP.ManagedPtrNewtype X11DisplayManager where
    toManagedPtr (X11DisplayManager p) = p

foreign import ccall "gdk_x11_display_manager_get_type"
    c_gdk_x11_display_manager_get_type :: IO B.Types.GType

instance B.Types.TypedObject X11DisplayManager where
    glibType = c_gdk_x11_display_manager_get_type

instance B.Types.GObject X11DisplayManager

-- | Type class for types which can be safely cast to t'X11DisplayManager', for instance with `toX11DisplayManager`.
class (SP.GObject o, O.IsDescendantOf X11DisplayManager o) => IsX11DisplayManager o
instance (SP.GObject o, O.IsDescendantOf X11DisplayManager o) => IsX11DisplayManager o

instance O.HasParentTypes X11DisplayManager
type instance O.ParentTypes X11DisplayManager = '[Gdk.DisplayManager.DisplayManager, GObject.Object.Object]

-- | Cast to t'X11DisplayManager', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toX11DisplayManager :: (MIO.MonadIO m, IsX11DisplayManager o) => o -> m X11DisplayManager
toX11DisplayManager = MIO.liftIO . B.ManagedPtr.unsafeCastTo X11DisplayManager

-- | Convert t'X11DisplayManager' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe X11DisplayManager) where
    gvalueGType_ = c_gdk_x11_display_manager_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr X11DisplayManager)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr X11DisplayManager)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject X11DisplayManager ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveX11DisplayManagerMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveX11DisplayManagerMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveX11DisplayManagerMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveX11DisplayManagerMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveX11DisplayManagerMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveX11DisplayManagerMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveX11DisplayManagerMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveX11DisplayManagerMethod "listDisplays" o = Gdk.DisplayManager.DisplayManagerListDisplaysMethodInfo
    ResolveX11DisplayManagerMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveX11DisplayManagerMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveX11DisplayManagerMethod "openDisplay" o = Gdk.DisplayManager.DisplayManagerOpenDisplayMethodInfo
    ResolveX11DisplayManagerMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveX11DisplayManagerMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveX11DisplayManagerMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveX11DisplayManagerMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveX11DisplayManagerMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveX11DisplayManagerMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveX11DisplayManagerMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveX11DisplayManagerMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveX11DisplayManagerMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveX11DisplayManagerMethod "getDefaultDisplay" o = Gdk.DisplayManager.DisplayManagerGetDefaultDisplayMethodInfo
    ResolveX11DisplayManagerMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveX11DisplayManagerMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveX11DisplayManagerMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveX11DisplayManagerMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveX11DisplayManagerMethod "setDefaultDisplay" o = Gdk.DisplayManager.DisplayManagerSetDefaultDisplayMethodInfo
    ResolveX11DisplayManagerMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveX11DisplayManagerMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveX11DisplayManagerMethod t X11DisplayManager, O.OverloadedMethod info X11DisplayManager p) => OL.IsLabel t (X11DisplayManager -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveX11DisplayManagerMethod t X11DisplayManager, O.OverloadedMethod info X11DisplayManager p, R.HasField t X11DisplayManager p) => R.HasField t X11DisplayManager p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveX11DisplayManagerMethod t X11DisplayManager, O.OverloadedMethodInfo info X11DisplayManager) => OL.IsLabel t (O.MethodProxy info X11DisplayManager) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList X11DisplayManager
type instance O.AttributeList X11DisplayManager = X11DisplayManagerAttributeList
type X11DisplayManagerAttributeList = ('[ '("defaultDisplay", Gdk.DisplayManager.DisplayManagerDefaultDisplayPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList X11DisplayManager = X11DisplayManagerSignalList
type X11DisplayManagerSignalList = ('[ '("displayOpened", Gdk.DisplayManager.DisplayManagerDisplayOpenedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif


