{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Cairo.Structs.Rectangle
    ( 

-- * Exported types
    Rectangle(..)                           ,
    newZeroRectangle                        ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveRectangleMethod                  ,
#endif



 -- * Properties


-- ** height #attr:height#
-- | /No description available in the introspection data./

    getRectangleHeight                      ,
#if defined(ENABLE_OVERLOADING)
    rectangle_height                        ,
#endif
    setRectangleHeight                      ,


-- ** width #attr:width#
-- | /No description available in the introspection data./

    getRectangleWidth                       ,
#if defined(ENABLE_OVERLOADING)
    rectangle_width                         ,
#endif
    setRectangleWidth                       ,


-- ** x #attr:x#
-- | /No description available in the introspection data./

    getRectangleX                           ,
#if defined(ENABLE_OVERLOADING)
    rectangle_x                             ,
#endif
    setRectangleX                           ,


-- ** y #attr:y#
-- | /No description available in the introspection data./

    getRectangleY                           ,
#if defined(ENABLE_OVERLOADING)
    rectangle_y                             ,
#endif
    setRectangleY                           ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype Rectangle = Rectangle (SP.ManagedPtr Rectangle)
    deriving (Eq)

instance SP.ManagedPtrNewtype Rectangle where
    toManagedPtr (Rectangle p) = p

foreign import ccall "cairo_gobject_rectangle_get_type" c_cairo_gobject_rectangle_get_type :: 
    IO GType

type instance O.ParentTypes Rectangle = '[]
instance O.HasParentTypes Rectangle

instance B.Types.TypedObject Rectangle where
    glibType = c_cairo_gobject_rectangle_get_type

instance B.Types.GBoxed Rectangle

-- | Convert t'Rectangle' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Rectangle) where
    gvalueGType_ = c_cairo_gobject_rectangle_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr Rectangle)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr Rectangle)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed Rectangle ptr
        else return P.Nothing
        
    

-- | Construct a t'Rectangle' struct initialized to zero.
newZeroRectangle :: MonadIO m => m Rectangle
newZeroRectangle = liftIO $ callocBoxedBytes 32 >>= wrapBoxed Rectangle

instance tag ~ 'AttrSet => Constructible Rectangle tag where
    new _ attrs = do
        o <- newZeroRectangle
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' rectangle #x
-- @
getRectangleX :: MonadIO m => Rectangle -> m Double
getRectangleX s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@x@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' rectangle [ #x 'Data.GI.Base.Attributes.:=' value ]
-- @
setRectangleX :: MonadIO m => Rectangle -> Double -> m ()
setRectangleX s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 0) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data RectangleXFieldInfo
instance AttrInfo RectangleXFieldInfo where
    type AttrBaseTypeConstraint RectangleXFieldInfo = (~) Rectangle
    type AttrAllowedOps RectangleXFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint RectangleXFieldInfo = (~) Double
    type AttrTransferTypeConstraint RectangleXFieldInfo = (~)Double
    type AttrTransferType RectangleXFieldInfo = Double
    type AttrGetType RectangleXFieldInfo = Double
    type AttrLabel RectangleXFieldInfo = "x"
    type AttrOrigin RectangleXFieldInfo = Rectangle
    attrGet = getRectangleX
    attrSet = setRectangleX
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Cairo.Structs.Rectangle.x"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-cairo-1.0.30/docs/GI-Cairo-Structs-Rectangle.html#g:attr:x"
        })

rectangle_x :: AttrLabelProxy "x"
rectangle_x = AttrLabelProxy

#endif


-- | Get the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' rectangle #y
-- @
getRectangleY :: MonadIO m => Rectangle -> m Double
getRectangleY s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@y@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' rectangle [ #y 'Data.GI.Base.Attributes.:=' value ]
-- @
setRectangleY :: MonadIO m => Rectangle -> Double -> m ()
setRectangleY s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 8) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data RectangleYFieldInfo
instance AttrInfo RectangleYFieldInfo where
    type AttrBaseTypeConstraint RectangleYFieldInfo = (~) Rectangle
    type AttrAllowedOps RectangleYFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint RectangleYFieldInfo = (~) Double
    type AttrTransferTypeConstraint RectangleYFieldInfo = (~)Double
    type AttrTransferType RectangleYFieldInfo = Double
    type AttrGetType RectangleYFieldInfo = Double
    type AttrLabel RectangleYFieldInfo = "y"
    type AttrOrigin RectangleYFieldInfo = Rectangle
    attrGet = getRectangleY
    attrSet = setRectangleY
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Cairo.Structs.Rectangle.y"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-cairo-1.0.30/docs/GI-Cairo-Structs-Rectangle.html#g:attr:y"
        })

rectangle_y :: AttrLabelProxy "y"
rectangle_y = AttrLabelProxy

#endif


-- | Get the value of the “@width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' rectangle #width
-- @
getRectangleWidth :: MonadIO m => Rectangle -> m Double
getRectangleWidth s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 16) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@width@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' rectangle [ #width 'Data.GI.Base.Attributes.:=' value ]
-- @
setRectangleWidth :: MonadIO m => Rectangle -> Double -> m ()
setRectangleWidth s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 16) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data RectangleWidthFieldInfo
instance AttrInfo RectangleWidthFieldInfo where
    type AttrBaseTypeConstraint RectangleWidthFieldInfo = (~) Rectangle
    type AttrAllowedOps RectangleWidthFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint RectangleWidthFieldInfo = (~) Double
    type AttrTransferTypeConstraint RectangleWidthFieldInfo = (~)Double
    type AttrTransferType RectangleWidthFieldInfo = Double
    type AttrGetType RectangleWidthFieldInfo = Double
    type AttrLabel RectangleWidthFieldInfo = "width"
    type AttrOrigin RectangleWidthFieldInfo = Rectangle
    attrGet = getRectangleWidth
    attrSet = setRectangleWidth
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Cairo.Structs.Rectangle.width"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-cairo-1.0.30/docs/GI-Cairo-Structs-Rectangle.html#g:attr:width"
        })

rectangle_width :: AttrLabelProxy "width"
rectangle_width = AttrLabelProxy

#endif


-- | Get the value of the “@height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' rectangle #height
-- @
getRectangleHeight :: MonadIO m => Rectangle -> m Double
getRectangleHeight s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 24) :: IO CDouble
    let val' = realToFrac val
    return val'

-- | Set the value of the “@height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' rectangle [ #height 'Data.GI.Base.Attributes.:=' value ]
-- @
setRectangleHeight :: MonadIO m => Rectangle -> Double -> m ()
setRectangleHeight s val = liftIO $ withManagedPtr s $ \ptr -> do
    let val' = realToFrac val
    poke (ptr `plusPtr` 24) (val' :: CDouble)

#if defined(ENABLE_OVERLOADING)
data RectangleHeightFieldInfo
instance AttrInfo RectangleHeightFieldInfo where
    type AttrBaseTypeConstraint RectangleHeightFieldInfo = (~) Rectangle
    type AttrAllowedOps RectangleHeightFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint RectangleHeightFieldInfo = (~) Double
    type AttrTransferTypeConstraint RectangleHeightFieldInfo = (~)Double
    type AttrTransferType RectangleHeightFieldInfo = Double
    type AttrGetType RectangleHeightFieldInfo = Double
    type AttrLabel RectangleHeightFieldInfo = "height"
    type AttrOrigin RectangleHeightFieldInfo = Rectangle
    attrGet = getRectangleHeight
    attrSet = setRectangleHeight
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Cairo.Structs.Rectangle.height"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-cairo-1.0.30/docs/GI-Cairo-Structs-Rectangle.html#g:attr:height"
        })

rectangle_height :: AttrLabelProxy "height"
rectangle_height = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Rectangle
type instance O.AttributeList Rectangle = RectangleAttributeList
type RectangleAttributeList = ('[ '("x", RectangleXFieldInfo), '("y", RectangleYFieldInfo), '("width", RectangleWidthFieldInfo), '("height", RectangleHeightFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveRectangleMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveRectangleMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveRectangleMethod t Rectangle, O.OverloadedMethod info Rectangle p) => OL.IsLabel t (Rectangle -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveRectangleMethod t Rectangle, O.OverloadedMethod info Rectangle p, R.HasField t Rectangle p) => R.HasField t Rectangle p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveRectangleMethod t Rectangle, O.OverloadedMethodInfo info Rectangle) => OL.IsLabel t (O.MethodProxy info Rectangle) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


