/* utilities.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from utilities.vala, do not modify */

/* SPDX-License-Identifier: GPL-3.0-or-later*/

#include "graphs.h"
#include <gio/gio.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <adwaita.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block13Data Block13Data;
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
typedef struct _Block14Data Block14Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block15Data Block15Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _Block13Data {
	int _ref_count_;
	GSettings* settings;
};

struct _Block14Data {
	int _ref_count_;
	Block13Data * _data13_;
	gchar* key;
};

struct _Block15Data {
	int _ref_count_;
	Block14Data * _data14_;
	AdwComboRow* comborow;
};

static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static void ______lambda19_ (Block15Data* _data15_);
static void _______lambda19__g_object_notify (GObject* _sender,
                                       GParamSpec* pspec,
                                       gpointer self);
static void ______lambda20_ (Block15Data* _data15_);
static void _______lambda20__g_settings_changed (GSettings* _sender,
                                          const gchar* key,
                                          gpointer self);
VALA_EXTERN gdouble graphs_tools_get_srgb (gdouble color);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

/**
         * Bind settings values to UI.
         */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		_g_object_unref0 (_data13_->settings);
		g_slice_free (Block13Data, _data13_);
	}
}

static Block14Data*
block14_data_ref (Block14Data* _data14_)
{
	g_atomic_int_inc (&_data14_->_ref_count_);
	return _data14_;
}

static void
block14_data_unref (void * _userdata_)
{
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
		_g_free0 (_data14_->key);
		block13_data_unref (_data14_->_data13_);
		_data14_->_data13_ = NULL;
		g_slice_free (Block14Data, _data14_);
	}
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
	g_atomic_int_inc (&_data15_->_ref_count_);
	return _data15_;
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
		_g_object_unref0 (_data15_->comborow);
		block14_data_unref (_data15_->_data14_);
		_data15_->_data14_ = NULL;
		g_slice_free (Block15Data, _data15_);
	}
}

static void
______lambda19_ (Block15Data* _data15_)
{
	Block14Data* _data14_;
	Block13Data* _data13_;
	const gchar* _tmp0_;
	AdwComboRow* _tmp1_;
	_data14_ = _data15_->_data14_;
	_data13_ = _data14_->_data13_;
	_tmp0_ = _data14_->key;
	_tmp1_ = _data15_->comborow;
	if (((guint) g_settings_get_enum (_data13_->settings, _tmp0_)) != adw_combo_row_get_selected (_tmp1_)) {
		const gchar* _tmp2_;
		AdwComboRow* _tmp3_;
		_tmp2_ = _data14_->key;
		_tmp3_ = _data15_->comborow;
		g_settings_set_enum (_data13_->settings, _tmp2_, (gint) adw_combo_row_get_selected (_tmp3_));
	}
}

static void
_______lambda19__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self)
{
	______lambda19_ (self);
}

static void
______lambda20_ (Block15Data* _data15_)
{
	Block14Data* _data14_;
	Block13Data* _data13_;
	AdwComboRow* _tmp0_;
	const gchar* _tmp1_;
	_data14_ = _data15_->_data14_;
	_data13_ = _data14_->_data13_;
	_tmp0_ = _data15_->comborow;
	_tmp1_ = _data14_->key;
	adw_combo_row_set_selected (_tmp0_, (guint) g_settings_get_enum (_data13_->settings, _tmp1_));
}

static void
_______lambda20__g_settings_changed (GSettings* _sender,
                                     const gchar* key,
                                     gpointer self)
{
	______lambda20_ (self);
}

void
graphs_tools_bind_settings_to_widgets (GSettings* settings,
                                       GtkWidget* parent)
{
	Block13Data* _data13_;
	GSettings* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	GSettingsSchema* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (settings != NULL);
	g_return_if_fail (parent != NULL);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (_data13_->settings);
	_data13_->settings = _tmp0_;
	g_object_get (_data13_->settings, "settings-schema", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp5_ = _tmp4_ = g_settings_schema_list_keys (_tmp3_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _vala_array_length (_tmp4_);
	_g_settings_schema_unref0 (_tmp3_);
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp6_;
		key_collection_length1 = _tmp6__length1;
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
			gchar* _tmp7_;
			gchar* key = NULL;
			_tmp7_ = g_strdup (key_collection[key_it]);
			key = _tmp7_;
			{
				Block14Data* _data14_;
				GtkWidget* widget = NULL;
				const gchar* _tmp8_;
				GtkWidget* _tmp9_ = NULL;
				GtkWidget* _tmp10_;
				_data14_ = g_slice_new0 (Block14Data);
				_data14_->_ref_count_ = 1;
				_data14_->_data13_ = block13_data_ref (_data13_);
				_data14_->key = key;
				_tmp8_ = _data14_->key;
				g_object_get ((GObject*) parent, _tmp8_, &_tmp9_, NULL);
				_g_object_unref0 (widget);
				widget = _tmp9_;
				_tmp10_ = widget;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, adw_entry_row_get_type ())) {
					const gchar* _tmp11_;
					GtkWidget* _tmp12_;
					_tmp11_ = _data14_->key;
					_tmp12_ = widget;
					g_settings_bind (_data13_->settings, _tmp11_, (GObject*) _tmp12_, "text", 0);
				} else {
					GtkWidget* _tmp13_;
					_tmp13_ = widget;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, adw_combo_row_get_type ())) {
						Block15Data* _data15_;
						GtkWidget* _tmp14_;
						AdwComboRow* _tmp15_;
						AdwComboRow* _tmp16_;
						const gchar* _tmp17_;
						AdwComboRow* _tmp18_;
						const gchar* _tmp19_;
						gchar* _tmp20_;
						_data15_ = g_slice_new0 (Block15Data);
						_data15_->_ref_count_ = 1;
						_data15_->_data14_ = block14_data_ref (_data14_);
						_tmp14_ = widget;
						_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, adw_combo_row_get_type (), AdwComboRow));
						_data15_->comborow = _tmp15_;
						_tmp16_ = _data15_->comborow;
						_tmp17_ = _data14_->key;
						adw_combo_row_set_selected (_tmp16_, (guint) g_settings_get_enum (_data13_->settings, _tmp17_));
						_tmp18_ = _data15_->comborow;
						g_signal_connect_data ((GObject*) _tmp18_, "notify::selected", (GCallback) _______lambda19__g_object_notify, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
						_tmp19_ = _data14_->key;
						_tmp20_ = g_strconcat ("changed::", _tmp19_, NULL);
						g_signal_connect_data (_data13_->settings, _tmp20_, (GCallback) _______lambda20__g_settings_changed, block15_data_ref (_data15_), (GClosureNotify) block15_data_unref, 0);
						_g_free0 (_tmp20_);
						block15_data_unref (_data15_);
						_data15_ = NULL;
					} else {
						GtkWidget* _tmp21_;
						_tmp21_ = widget;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, gtk_switch_get_type ())) {
							const gchar* _tmp22_;
							GtkWidget* _tmp23_;
							_tmp22_ = _data14_->key;
							_tmp23_ = widget;
							g_settings_bind (_data13_->settings, _tmp22_, (GObject*) _tmp23_, "active", 0);
						} else {
							GtkWidget* _tmp24_;
							_tmp24_ = widget;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, adw_switch_row_get_type ())) {
								const gchar* _tmp25_;
								GtkWidget* _tmp26_;
								_tmp25_ = _data14_->key;
								_tmp26_ = widget;
								g_settings_bind (_data13_->settings, _tmp25_, (GObject*) _tmp26_, "active", 0);
							} else {
								GtkWidget* _tmp27_;
								_tmp27_ = widget;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, adw_expander_row_get_type ())) {
									const gchar* _tmp28_;
									GtkWidget* _tmp29_;
									GtkWidget* _tmp30_;
									_tmp28_ = _data14_->key;
									_tmp29_ = widget;
									g_settings_bind (_data13_->settings, _tmp28_, (GObject*) _tmp29_, "enable-expansion", 0);
									_tmp30_ = widget;
									adw_expander_row_set_expanded ((AdwExpanderRow*) _tmp30_, TRUE);
								} else {
									GtkWidget* _tmp31_;
									_tmp31_ = widget;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, adw_spin_row_get_type ())) {
										const gchar* _tmp32_;
										GtkWidget* _tmp33_;
										_tmp32_ = _data14_->key;
										_tmp33_ = widget;
										g_settings_bind (_data13_->settings, _tmp32_, (GObject*) _tmp33_, "value", 0);
									}
								}
							}
						}
					}
				}
				_g_object_unref0 (widget);
				block14_data_unref (_data14_);
				_data14_ = NULL;
			}
		}
		key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	block13_data_unref (_data13_);
	_data13_ = NULL;
}

/**
         * Reset a settings instance to default values.
         */
void
graphs_tools_reset_settings (GSettings* settings)
{
	GSettingsSchema* _tmp0_;
	GSettingsSchema* _tmp1_;
	GSettingsSchema* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	g_return_if_fail (settings != NULL);
	g_object_get (settings, "settings-schema", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp4_ = _tmp3_ = g_settings_schema_list_keys (_tmp2_);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _vala_array_length (_tmp3_);
	_g_settings_schema_unref0 (_tmp2_);
	{
		gchar** key_collection = NULL;
		gint key_collection_length1 = 0;
		gint _key_collection_size_ = 0;
		gint key_it = 0;
		key_collection = _tmp5_;
		key_collection_length1 = _tmp5__length1;
		for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
			gchar* _tmp6_;
			gchar* key = NULL;
			_tmp6_ = g_strdup (key_collection[key_it]);
			key = _tmp6_;
			{
				const gchar* _tmp7_;
				_tmp7_ = key;
				g_settings_reset (settings, _tmp7_);
				_g_free0 (key);
			}
		}
		key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
	}
}

/**
         * Convert a color in hex representation to Gdk.RGBA
         */
void
graphs_tools_hex_to_rgba (const gchar* hex,
                          GdkRGBA* result)
{
	GdkRGBA rgba = {0};
	g_return_if_fail (hex != NULL);
	memset (&rgba, 0, sizeof (GdkRGBA));
	gdk_rgba_parse (&rgba, hex);
	*result = rgba;
	return;
}

/**
         * Convert a Gdk.RGBA to a color in hex representation
         */
gchar*
graphs_tools_rgba_to_hex (GdkRGBA* rgba)
{
	GString* builder = NULL;
	GString* _tmp0_;
	GdkRGBA _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GdkRGBA _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GdkRGBA _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* result;
	g_return_val_if_fail (rgba != NULL, NULL);
	_tmp0_ = g_string_new ("#");
	builder = _tmp0_;
	_tmp1_ = *rgba;
	_tmp2_ = g_strdup_printf ("%02x", (guint) (_tmp1_.red * 255));
	_tmp3_ = _tmp2_;
	g_string_append (builder, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = *rgba;
	_tmp5_ = g_strdup_printf ("%02x", (guint) (_tmp4_.green * 255));
	_tmp6_ = _tmp5_;
	g_string_append (builder, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = *rgba;
	_tmp8_ = g_strdup_printf ("%02x", (guint) (_tmp7_.blue * 255));
	_tmp9_ = _tmp8_;
	g_string_append (builder, _tmp9_);
	_g_free0 (_tmp9_);
	_tmp10_ = builder->str;
	_tmp11_ = g_utf8_strup (_tmp10_, (gssize) -1);
	result = _tmp11_;
	_g_string_free0 (builder);
	return result;
}

/**
         * Calculate luminance of a color in hex representation.
         */
gdouble
graphs_tools_get_luminance_from_hex (const gchar* hex)
{
	GdkRGBA _tmp0_ = {0};
	gdouble result;
	g_return_val_if_fail (hex != NULL, 0.0);
	graphs_tools_hex_to_rgba (hex, &_tmp0_);
	result = graphs_tools_get_luminance_from_rgba (&_tmp0_);
	return result;
}

gdouble
graphs_tools_get_srgb (gdouble color)
{
	gdouble result;
	if (color <= 0.03928) {
		result = color / 12.92;
		return result;
	} else {
		result = pow ((color + 0.055) / 1.055, 2.4);
		return result;
	}
}

/**
         * Calculate luminance of a Gdk.RGBA
         */
gdouble
graphs_tools_get_luminance_from_rgba (GdkRGBA* rgba)
{
	gdouble r = 0.0;
	GdkRGBA _tmp0_;
	gdouble g = 0.0;
	GdkRGBA _tmp1_;
	gdouble b = 0.0;
	GdkRGBA _tmp2_;
	gdouble result;
	g_return_val_if_fail (rgba != NULL, 0.0);
	_tmp0_ = *rgba;
	r = graphs_tools_get_srgb ((gdouble) _tmp0_.red);
	_tmp1_ = *rgba;
	g = graphs_tools_get_srgb ((gdouble) _tmp1_.green);
	_tmp2_ = *rgba;
	b = graphs_tools_get_srgb ((gdouble) _tmp2_.blue);
	result = ((0.2126 * r) + (0.7152 * g)) + (0.0722 * b);
	return result;
}

/**
         * Get the contrast between two colors
         */
gdouble
graphs_tools_get_contrast (GdkRGBA* bg_color,
                           GdkRGBA* fg_color)
{
	gdouble bg_luminance = 0.0;
	GdkRGBA _tmp0_;
	gdouble fg_luminance = 0.0;
	GdkRGBA _tmp1_;
	gdouble min_value = 0.0;
	gdouble max_value = 0.0;
	gdouble result;
	g_return_val_if_fail (bg_color != NULL, 0.0);
	g_return_val_if_fail (fg_color != NULL, 0.0);
	_tmp0_ = *bg_color;
	bg_luminance = graphs_tools_get_luminance_from_rgba (&_tmp0_);
	_tmp1_ = *fg_color;
	fg_luminance = graphs_tools_get_luminance_from_rgba (&_tmp1_);
	min_value = MIN (bg_luminance, fg_luminance) + 0.05;
	max_value = MAX (bg_luminance, fg_luminance) + 0.05;
	result = max_value / min_value;
	return result;
}

/**
         * Shorten a label
         *
         * @param max_length Maximum length
         */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gchar*
graphs_tools_shorten_label (const gchar* label,
                            guint max_length)
{
	gint _tmp0_;
	gint _tmp1_;
	gchar* result;
	g_return_val_if_fail (label != NULL, NULL);
	_tmp0_ = strlen (label);
	_tmp1_ = _tmp0_;
	if (((guint) _tmp1_) > max_length) {
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = string_substring (label, (glong) 0, (glong) (max_length - 1));
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, "…", NULL);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		result = _tmp5_;
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup (label);
		result = _tmp6_;
		return result;
	}
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

gchar*
graphs_tools_get_duplicate_string (const gchar* original,
                                   gchar** used,
                                   gint used_length1)
{
	gchar* old_str = NULL;
	gchar* _tmp1_;
	guint i = 0U;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (original != NULL, NULL);
	if (!_vala_string_array_contains (used, used_length1, original)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (original);
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_strdup (original);
	old_str = _tmp1_;
	{
		GRegex* regex = NULL;
		GRegex* _tmp2_;
		GMatchInfo* info = NULL;
		GRegex* _tmp3_;
		GMatchInfo* _tmp4_ = NULL;
		gboolean _tmp5_;
		_tmp2_ = g_regex_new ("(?P<string>.+) \\(\\d+\\)", 0, 0, &_inner_error0_);
		regex = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = regex;
		_tmp5_ = g_regex_match (_tmp3_, original, 0, &_tmp4_);
		_g_match_info_unref0 (info);
		info = _tmp4_;
		if (_tmp5_) {
			GMatchInfo* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = info;
			_tmp7_ = g_match_info_fetch_named (_tmp6_, "string");
			_g_free0 (old_str);
			old_str = _tmp7_;
		}
		_g_match_info_unref0 (info);
		_g_regex_unref0 (regex);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (old_str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	i = (guint) 1;
	while (TRUE) {
		gchar* new_str = NULL;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		guint _tmp15_;
		_tmp8_ = old_str;
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = g_strdup_printf ("%u", i);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp9_, " (", _tmp11_, ")", NULL);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		new_str = _tmp13_;
		_tmp14_ = new_str;
		if (!_vala_string_array_contains (used, used_length1, _tmp14_)) {
			result = new_str;
			_g_free0 (old_str);
			return result;
		}
		_tmp15_ = i;
		i = _tmp15_ + 1;
		_g_free0 (new_str);
	}
}

/**
         * Get the platforms config directory
         */
GFile*
graphs_tools_get_config_directory (GError** error)
{
	GFile* main_directory = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GError* _inner_error0_ = NULL;
	GFile* result;
	_tmp0_ = g_get_user_config_dir ();
	_tmp1_ = g_file_new_for_path (_tmp0_);
	main_directory = _tmp1_;
	_tmp3_ = g_file_get_child_for_display_name (main_directory, "graphs", &_inner_error0_);
	_tmp2_ = _tmp3_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (main_directory);
		return NULL;
	}
	_tmp4_ = _tmp2_;
	_tmp2_ = NULL;
	result = _tmp4_;
	_g_object_unref0 (_tmp2_);
	_g_object_unref0 (main_directory);
	return result;
}

/**
         * Get the filename of a file
         */
gchar*
graphs_tools_get_filename (GFile* file)
{
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (file != NULL, NULL);
	{
		GFileInfo* info = NULL;
		GFileInfo* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = g_file_query_info (file, "standard::display-name", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
		info = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = g_file_info_get_display_name (info);
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		_g_object_unref0 (info);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		gchar* _tmp3_;
		g_clear_error (&_inner_error0_);
		_tmp3_ = g_file_get_basename (file);
		result = _tmp3_;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

/**
         * Build a dialog from `dialogs.blp`
         */
GObject*
graphs_tools_build_dialog (const gchar* name)
{
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp0_;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GObject* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = gtk_builder_new_from_resource ("/se/sjoerd/Graphs/ui/dialogs.ui");
	builder = _tmp0_;
	_tmp1_ = gtk_builder_get_object (builder, name);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	_g_object_unref0 (builder);
	return result;
}

/**
         * Open the containing folder of a file
         */
void
graphs_tools_open_file_location (GFile* file)
{
	GtkFileLauncher* file_launcher = NULL;
	GtkFileLauncher* _tmp0_;
	g_return_if_fail (file != NULL);
	_tmp0_ = gtk_file_launcher_new (file);
	file_launcher = _tmp0_;
	gtk_file_launcher_open_containing_folder (file_launcher, NULL, NULL, NULL, NULL);
	_g_object_unref0 (file_launcher);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

