/* Settings.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Settings.vala, do not modify */

/*-
 * Copyright 2021 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <string.h>
#include <stdlib.h>
#include "granite-7.h"
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GRANITE_PANTHEON_TYPE_ACCOUNTS_SERVICE (granite_pantheon_accounts_service_get_type ())
#define GRANITE_PANTHEON_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_PANTHEON_TYPE_ACCOUNTS_SERVICE, GranitePantheonAccountsService))
#define GRANITE_PANTHEON_IS_ACCOUNTS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_PANTHEON_TYPE_ACCOUNTS_SERVICE))
#define GRANITE_PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GRANITE_PANTHEON_TYPE_ACCOUNTS_SERVICE, GranitePantheonAccountsServiceIface))

typedef struct _GranitePantheonAccountsService GranitePantheonAccountsService;
typedef struct _GranitePantheonAccountsServiceIface GranitePantheonAccountsServiceIface;

#define GRANITE_PANTHEON_TYPE_ACCOUNTS_SERVICE_PROXY (granite_pantheon_accounts_service_proxy_get_type ())
typedef GDBusProxy GranitePantheonAccountsServiceProxy;
typedef GDBusProxyClass GranitePantheonAccountsServiceProxyClass;

#define GRANITE_FDO_TYPE_ACCOUNTS (granite_fdo_accounts_get_type ())
#define GRANITE_FDO_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_FDO_TYPE_ACCOUNTS, GraniteFDOAccounts))
#define GRANITE_FDO_IS_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_FDO_TYPE_ACCOUNTS))
#define GRANITE_FDO_ACCOUNTS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GRANITE_FDO_TYPE_ACCOUNTS, GraniteFDOAccountsIface))

typedef struct _GraniteFDOAccounts GraniteFDOAccounts;
typedef struct _GraniteFDOAccountsIface GraniteFDOAccountsIface;

#define GRANITE_FDO_TYPE_ACCOUNTS_PROXY (granite_fdo_accounts_proxy_get_type ())
typedef GDBusProxy GraniteFDOAccountsProxy;
typedef GDBusProxyClass GraniteFDOAccountsProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GRANITE_PORTAL_TYPE_SETTINGS (granite_portal_settings_get_type ())
#define GRANITE_PORTAL_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GRANITE_PORTAL_TYPE_SETTINGS, GranitePortalSettings))
#define GRANITE_PORTAL_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GRANITE_PORTAL_TYPE_SETTINGS))
#define GRANITE_PORTAL_SETTINGS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GRANITE_PORTAL_TYPE_SETTINGS, GranitePortalSettingsIface))

typedef struct _GranitePortalSettings GranitePortalSettings;
typedef struct _GranitePortalSettingsIface GranitePortalSettingsIface;

#define GRANITE_PORTAL_TYPE_SETTINGS_PROXY (granite_portal_settings_proxy_get_type ())
enum  {
	GRANITE_SETTINGS_0_PROPERTY,
	GRANITE_SETTINGS_ACCENT_COLOR_PROPERTY,
	GRANITE_SETTINGS_PREFERS_COLOR_SCHEME_PROPERTY,
	GRANITE_SETTINGS_NUM_PROPERTIES
};
static GParamSpec* granite_settings_properties[GRANITE_SETTINGS_NUM_PROPERTIES];
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))

struct _GranitePantheonAccountsServiceIface {
	GTypeInterface parent_iface;
	gint (*get_prefers_color_scheme) (GranitePantheonAccountsService* self);
	void (*set_prefers_color_scheme) (GranitePantheonAccountsService* self, gint value);
};

struct _GraniteFDOAccountsIface {
	GTypeInterface parent_iface;
	gchar* (*find_user_by_name) (GraniteFDOAccounts* self, const gchar* username, GError** error);
};

struct _GranitePortalSettingsIface {
	GTypeInterface parent_iface;
	GHashTable* (*read_all) (GranitePortalSettings* self, gchar** namespaces, gint namespaces_length1, GError** error);
	GVariant* (*read) (GranitePortalSettings* self, const gchar* namespace, const gchar* key, GError** error);
};

struct _GraniteSettingsPrivate {
	GdkRGBA* _accent_color;
	GraniteSettingsColorScheme* _prefers_color_scheme;
	gchar* _user_path;
	GraniteFDOAccounts* accounts_service;
	GranitePantheonAccountsService* pantheon_act;
	GranitePortalSettings* portal;
};

static gint GraniteSettings_private_offset;
static gpointer granite_settings_parent_class = NULL;
static GOnce granite_settings_instance;
static GOnce granite_settings_instance = G_ONCE_INIT;

 G_GNUC_INTERNAL GType granite_pantheon_accounts_service_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GType granite_pantheon_accounts_service_proxy_get_type (void) G_GNUC_CONST ;
 G_GNUC_INTERNAL guint granite_pantheon_accounts_service_register_object (void* object,
                                                         GDBusConnection* connection,
                                                         const gchar* path,
                                                         GError** error);
 G_GNUC_INTERNAL gint granite_pantheon_accounts_service_get_prefers_color_scheme (GranitePantheonAccountsService* self);
 G_GNUC_INTERNAL void granite_pantheon_accounts_service_set_prefers_color_scheme (GranitePantheonAccountsService* self,
                                                                 gint value);
static GType granite_pantheon_accounts_service_get_type_once (void);
static void granite_pantheon_accounts_service_proxy_g_signal (GDBusProxy* proxy,
                                                       const gchar* sender_name,
                                                       const gchar* signal_name,
                                                       GVariant* parameters);
static gint granite_pantheon_accounts_service_dbus_proxy_get_prefers_color_scheme (GranitePantheonAccountsService* self);
static void granite_pantheon_accounts_service_dbus_proxy_set_prefers_color_scheme (GranitePantheonAccountsService* self,
                                                                            gint value);
static void granite_pantheon_accounts_service_proxy_granite_pantheon_accounts_service_interface_init (GranitePantheonAccountsServiceIface* iface);
static void granite_pantheon_accounts_service_dbus_interface_method_call (GDBusConnection* connection,
                                                                   const gchar* sender,
                                                                   const gchar* object_path,
                                                                   const gchar* interface_name,
                                                                   const gchar* method_name,
                                                                   GVariant* parameters,
                                                                   GDBusMethodInvocation* invocation,
                                                                   gpointer user_data);
static GVariant* granite_pantheon_accounts_service_dbus_interface_get_property (GDBusConnection* connection,
                                                                         const gchar* sender,
                                                                         const gchar* object_path,
                                                                         const gchar* interface_name,
                                                                         const gchar* property_name,
                                                                         GError** error,
                                                                         gpointer user_data);
static GVariant* _dbus_granite_pantheon_accounts_service_get_prefers_color_scheme (GranitePantheonAccountsService* self);
static gboolean granite_pantheon_accounts_service_dbus_interface_set_property (GDBusConnection* connection,
                                                                        const gchar* sender,
                                                                        const gchar* object_path,
                                                                        const gchar* interface_name,
                                                                        const gchar* property_name,
                                                                        GVariant* value,
                                                                        GError** error,
                                                                        gpointer user_data);
static void _dbus_granite_pantheon_accounts_service_set_prefers_color_scheme (GranitePantheonAccountsService* self,
                                                                       GVariant* _value);
static void _granite_pantheon_accounts_service_unregister_object (gpointer user_data);
VALA_EXTERN GType granite_fdo_accounts_proxy_get_type (void) G_GNUC_CONST ;
 G_GNUC_INTERNAL guint granite_fdo_accounts_register_object (void* object,
                                            GDBusConnection* connection,
                                            const gchar* path,
                                            GError** error);
 G_GNUC_INTERNAL GType granite_fdo_accounts_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
 G_GNUC_INTERNAL gchar* granite_fdo_accounts_find_user_by_name (GraniteFDOAccounts* self,
                                               const gchar* username,
                                               GError** error);
static GType granite_fdo_accounts_get_type_once (void);
static void granite_fdo_accounts_proxy_g_signal (GDBusProxy* proxy,
                                          const gchar* sender_name,
                                          const gchar* signal_name,
                                          GVariant* parameters);
static gchar* granite_fdo_accounts_proxy_find_user_by_name (GraniteFDOAccounts* self,
                                                     const gchar* username,
                                                     GError** error);
static void granite_fdo_accounts_proxy_granite_fdo_accounts_interface_init (GraniteFDOAccountsIface* iface);
static void _dbus_granite_fdo_accounts_find_user_by_name (GraniteFDOAccounts* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation);
static void granite_fdo_accounts_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data);
static GVariant* granite_fdo_accounts_dbus_interface_get_property (GDBusConnection* connection,
                                                            const gchar* sender,
                                                            const gchar* object_path,
                                                            const gchar* interface_name,
                                                            const gchar* property_name,
                                                            GError** error,
                                                            gpointer user_data);
static gboolean granite_fdo_accounts_dbus_interface_set_property (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* property_name,
                                                           GVariant* value,
                                                           GError** error,
                                                           gpointer user_data);
static void _granite_fdo_accounts_unregister_object (gpointer user_data);
VALA_EXTERN GType granite_portal_settings_proxy_get_type (void) G_GNUC_CONST ;
 G_GNUC_INTERNAL guint granite_portal_settings_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
 G_GNUC_INTERNAL GType granite_portal_settings_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void _vala_GdkRGBA_free (GdkRGBA* self);
static void granite_settings_setup_accent_color (GraniteSettings* self);
static void granite_settings_set_accent_color (GraniteSettings* self,
                                        GdkRGBA * value);
static GdkRGBA* _vala_GdkRGBA_copy (GdkRGBA* self);
static void granite_settings_setup_prefers_color_scheme (GraniteSettings* self);
static void granite_settings_set_prefers_color_scheme (GraniteSettings* self,
                                                GraniteSettingsColorScheme value);
static GraniteSettingsColorScheme* _granite_settings_color_scheme_dup (GraniteSettingsColorScheme* self);
static const gchar* granite_settings_get_user_path (GraniteSettings* self);
static void granite_settings_setup_user_path (GraniteSettings* self);
static void granite_settings_set_user_path (GraniteSettings* self,
                                     const gchar* value);
static GraniteSettings* __lambda4_ (void);
static GraniteSettings* granite_settings_new (void);
static GraniteSettings* granite_settings_construct (GType object_type);
static gpointer ___lambda4__gthread_func (gpointer self);
 G_GNUC_INTERNAL GranitePortalSettings* granite_portal_settings_get (GError** error);
 G_GNUC_INTERNAL GVariant* granite_portal_settings_read (GranitePortalSettings* self,
                                        const gchar* namespace,
                                        const gchar* key,
                                        GError** error);
static void granite_settings_parse_color (GraniteSettings* self,
                                   GVariant* color,
                                   GdkRGBA* result);
static void ___lambda5_ (GraniteSettings* self,
                  const gchar* scheme,
                  const gchar* key,
                  GVariant* value);
static void ____lambda5__granite_portal_settings_setting_changed (GranitePortalSettings* _sender,
                                                           const gchar* namespace,
                                                           const gchar* key,
                                                           GVariant* value,
                                                           gpointer self);
static void ___lambda6_ (GraniteSettings* self,
                  const gchar* scheme,
                  const gchar* key,
                  GVariant* value);
static void ____lambda6__granite_portal_settings_setting_changed (GranitePortalSettings* _sender,
                                                           const gchar* namespace,
                                                           const gchar* key,
                                                           GVariant* value,
                                                           gpointer self);
static void ___lambda7_ (GraniteSettings* self,
                  GVariant* changed,
                  gchar** invalid);
static void ____lambda7__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                     GVariant* changed_properties,
                                                     gchar** invalidated_properties,
                                                     gpointer self);
static void granite_settings_finalize (GObject * obj);
static GType granite_settings_get_type_once (void);
static void _vala_granite_settings_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec);
static void _vala_granite_settings_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec);

static const GDBusMethodInfo * const _granite_pantheon_accounts_service_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _granite_pantheon_accounts_service_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _granite_pantheon_accounts_service_dbus_property_info_prefers_color_scheme = {-1, "PrefersColorScheme", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE, NULL};
static const GDBusPropertyInfo * const _granite_pantheon_accounts_service_dbus_property_info[] = {&_granite_pantheon_accounts_service_dbus_property_info_prefers_color_scheme, NULL};
static const GDBusInterfaceInfo _granite_pantheon_accounts_service_dbus_interface_info = {-1, "io.elementary.pantheon.AccountsService", (GDBusMethodInfo **) (&_granite_pantheon_accounts_service_dbus_method_info), (GDBusSignalInfo **) (&_granite_pantheon_accounts_service_dbus_signal_info), (GDBusPropertyInfo **) (&_granite_pantheon_accounts_service_dbus_property_info), NULL};
static const GDBusInterfaceVTable _granite_pantheon_accounts_service_dbus_interface_vtable = {granite_pantheon_accounts_service_dbus_interface_method_call, granite_pantheon_accounts_service_dbus_interface_get_property, granite_pantheon_accounts_service_dbus_interface_set_property};
static const GDBusArgInfo _granite_fdo_accounts_dbus_arg_info_find_user_by_name_username = {-1, "username", "s", NULL};
static const GDBusArgInfo _granite_fdo_accounts_dbus_arg_info_find_user_by_name_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _granite_fdo_accounts_dbus_arg_info_find_user_by_name_in[] = {&_granite_fdo_accounts_dbus_arg_info_find_user_by_name_username, NULL};
static const GDBusArgInfo * const _granite_fdo_accounts_dbus_arg_info_find_user_by_name_out[] = {&_granite_fdo_accounts_dbus_arg_info_find_user_by_name_result, NULL};
static const GDBusMethodInfo _granite_fdo_accounts_dbus_method_info_find_user_by_name = {-1, "FindUserByName", (GDBusArgInfo **) (&_granite_fdo_accounts_dbus_arg_info_find_user_by_name_in), (GDBusArgInfo **) (&_granite_fdo_accounts_dbus_arg_info_find_user_by_name_out), NULL};
static const GDBusMethodInfo * const _granite_fdo_accounts_dbus_method_info[] = {&_granite_fdo_accounts_dbus_method_info_find_user_by_name, NULL};
static const GDBusSignalInfo * const _granite_fdo_accounts_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _granite_fdo_accounts_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _granite_fdo_accounts_dbus_interface_info = {-1, "org.freedesktop.Accounts", (GDBusMethodInfo **) (&_granite_fdo_accounts_dbus_method_info), (GDBusSignalInfo **) (&_granite_fdo_accounts_dbus_signal_info), (GDBusPropertyInfo **) (&_granite_fdo_accounts_dbus_property_info), NULL};
static const GDBusInterfaceVTable _granite_fdo_accounts_dbus_interface_vtable = {granite_fdo_accounts_dbus_interface_method_call, granite_fdo_accounts_dbus_interface_get_property, granite_fdo_accounts_dbus_interface_set_property};

 G_GNUC_INTERNAL gint
granite_pantheon_accounts_service_get_prefers_color_scheme (GranitePantheonAccountsService* self)
{
	GranitePantheonAccountsServiceIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = GRANITE_PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->get_prefers_color_scheme) {
		return _iface_->get_prefers_color_scheme (self);
	}
	return -1;
}

 G_GNUC_INTERNAL void
granite_pantheon_accounts_service_set_prefers_color_scheme (GranitePantheonAccountsService* self,
                                                            gint value)
{
	GranitePantheonAccountsServiceIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = GRANITE_PANTHEON_ACCOUNTS_SERVICE_GET_INTERFACE (self);
	if (_iface_->set_prefers_color_scheme) {
		_iface_->set_prefers_color_scheme (self, value);
	}
}

static void
granite_pantheon_accounts_service_default_init (GranitePantheonAccountsServiceIface * iface,
                                                gpointer iface_data)
{
}

static GType
granite_pantheon_accounts_service_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GranitePantheonAccountsServiceIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_pantheon_accounts_service_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType granite_pantheon_accounts_service_type_id;
	granite_pantheon_accounts_service_type_id = g_type_register_static (G_TYPE_INTERFACE, "GranitePantheonAccountsService", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (granite_pantheon_accounts_service_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (granite_pantheon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) granite_pantheon_accounts_service_proxy_get_type);
	g_type_set_qdata (granite_pantheon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "io.elementary.pantheon.AccountsService");
	g_type_set_qdata (granite_pantheon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_granite_pantheon_accounts_service_dbus_interface_info));
	g_type_set_qdata (granite_pantheon_accounts_service_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) granite_pantheon_accounts_service_register_object);
	return granite_pantheon_accounts_service_type_id;
}

 G_GNUC_INTERNAL GType
granite_pantheon_accounts_service_get_type (void)
{
	static volatile gsize granite_pantheon_accounts_service_type_id__once = 0;
	if (g_once_init_enter (&granite_pantheon_accounts_service_type_id__once)) {
		GType granite_pantheon_accounts_service_type_id;
		granite_pantheon_accounts_service_type_id = granite_pantheon_accounts_service_get_type_once ();
		g_once_init_leave (&granite_pantheon_accounts_service_type_id__once, granite_pantheon_accounts_service_type_id);
	}
	return granite_pantheon_accounts_service_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GranitePantheonAccountsServiceProxy, granite_pantheon_accounts_service_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GRANITE_PANTHEON_TYPE_ACCOUNTS_SERVICE, granite_pantheon_accounts_service_proxy_granite_pantheon_accounts_service_interface_init) )
static void
granite_pantheon_accounts_service_proxy_class_init (GranitePantheonAccountsServiceProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = granite_pantheon_accounts_service_proxy_g_signal;
}

static void
granite_pantheon_accounts_service_proxy_g_signal (GDBusProxy* proxy,
                                                  const gchar* sender_name,
                                                  const gchar* signal_name,
                                                  GVariant* parameters)
{
}

static void
granite_pantheon_accounts_service_proxy_init (GranitePantheonAccountsServiceProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_granite_pantheon_accounts_service_dbus_interface_info));
}

static gint
granite_pantheon_accounts_service_dbus_proxy_get_prefers_color_scheme (GranitePantheonAccountsService* self)
{
	GVariant *_inner_reply;
	gint _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "PrefersColorScheme");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("io.elementary.pantheon.AccountsService"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PrefersColorScheme"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint _tmp98_ = 0;
			return _tmp98_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
granite_pantheon_accounts_service_dbus_proxy_set_prefers_color_scheme (GranitePantheonAccountsService* self,
                                                                       gint value)
{
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("io.elementary.pantheon.AccountsService"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("PrefersColorScheme"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int32 (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}

static void
granite_pantheon_accounts_service_proxy_granite_pantheon_accounts_service_interface_init (GranitePantheonAccountsServiceIface* iface)
{
	iface->get_prefers_color_scheme = granite_pantheon_accounts_service_dbus_proxy_get_prefers_color_scheme;
	iface->set_prefers_color_scheme = granite_pantheon_accounts_service_dbus_proxy_set_prefers_color_scheme;
}

static void
granite_pantheon_accounts_service_dbus_interface_method_call (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* method_name,
                                                              GVariant* parameters,
                                                              GDBusMethodInvocation* invocation,
                                                              gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_granite_pantheon_accounts_service_get_prefers_color_scheme (GranitePantheonAccountsService* self)
{
	gint result;
	GVariant* _reply;
	result = granite_pantheon_accounts_service_get_prefers_color_scheme (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
granite_pantheon_accounts_service_dbus_interface_get_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GError** error,
                                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "PrefersColorScheme") == 0) {
		return _dbus_granite_pantheon_accounts_service_get_prefers_color_scheme (object);
	}
	return NULL;
}

static void
_dbus_granite_pantheon_accounts_service_set_prefers_color_scheme (GranitePantheonAccountsService* self,
                                                                  GVariant* _value)
{
	gint value = 0;
	value = g_variant_get_int32 (_value);
	granite_pantheon_accounts_service_set_prefers_color_scheme (self, value);
}

static gboolean
granite_pantheon_accounts_service_dbus_interface_set_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GVariant* value,
                                                               GError** error,
                                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "PrefersColorScheme") == 0) {
		_dbus_granite_pantheon_accounts_service_set_prefers_color_scheme (object, value);
		return TRUE;
	}
	return FALSE;
}

 G_GNUC_INTERNAL guint
granite_pantheon_accounts_service_register_object (gpointer object,
                                                   GDBusConnection* connection,
                                                   const gchar* path,
                                                   GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_granite_pantheon_accounts_service_dbus_interface_info), &_granite_pantheon_accounts_service_dbus_interface_vtable, data, _granite_pantheon_accounts_service_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_granite_pantheon_accounts_service_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

gchar*
granite_fdo_accounts_find_user_by_name (GraniteFDOAccounts* self,
                                        const gchar* username,
                                        GError** error)
{
	GraniteFDOAccountsIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = GRANITE_FDO_ACCOUNTS_GET_INTERFACE (self);
	if (_iface_->find_user_by_name) {
		return _iface_->find_user_by_name (self, username, error);
	}
	return NULL;
}

static void
granite_fdo_accounts_default_init (GraniteFDOAccountsIface * iface,
                                   gpointer iface_data)
{
}

static GType
granite_fdo_accounts_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteFDOAccountsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_fdo_accounts_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType granite_fdo_accounts_type_id;
	granite_fdo_accounts_type_id = g_type_register_static (G_TYPE_INTERFACE, "GraniteFDOAccounts", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (granite_fdo_accounts_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (granite_fdo_accounts_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) granite_fdo_accounts_proxy_get_type);
	g_type_set_qdata (granite_fdo_accounts_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Accounts");
	g_type_set_qdata (granite_fdo_accounts_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_granite_fdo_accounts_dbus_interface_info));
	g_type_set_qdata (granite_fdo_accounts_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) granite_fdo_accounts_register_object);
	return granite_fdo_accounts_type_id;
}

 G_GNUC_INTERNAL GType
granite_fdo_accounts_get_type (void)
{
	static volatile gsize granite_fdo_accounts_type_id__once = 0;
	if (g_once_init_enter (&granite_fdo_accounts_type_id__once)) {
		GType granite_fdo_accounts_type_id;
		granite_fdo_accounts_type_id = granite_fdo_accounts_get_type_once ();
		g_once_init_leave (&granite_fdo_accounts_type_id__once, granite_fdo_accounts_type_id);
	}
	return granite_fdo_accounts_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (GraniteFDOAccountsProxy, granite_fdo_accounts_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (GRANITE_FDO_TYPE_ACCOUNTS, granite_fdo_accounts_proxy_granite_fdo_accounts_interface_init) )
static void
granite_fdo_accounts_proxy_class_init (GraniteFDOAccountsProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = granite_fdo_accounts_proxy_g_signal;
}

static void
granite_fdo_accounts_proxy_g_signal (GDBusProxy* proxy,
                                     const gchar* sender_name,
                                     const gchar* signal_name,
                                     GVariant* parameters)
{
}

static void
granite_fdo_accounts_proxy_init (GraniteFDOAccountsProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_granite_fdo_accounts_dbus_interface_info));
}

static gchar*
granite_fdo_accounts_proxy_find_user_by_name (GraniteFDOAccounts* self,
                                              const gchar* username,
                                              GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp99_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Accounts", "FindUserByName");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (username));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp99_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp99_, NULL);
	g_variant_unref (_tmp99_);
	g_object_unref (_reply_message);
	return _result;
}

static void
granite_fdo_accounts_proxy_granite_fdo_accounts_interface_init (GraniteFDOAccountsIface* iface)
{
	iface->find_user_by_name = granite_fdo_accounts_proxy_find_user_by_name;
}

static void
_dbus_granite_fdo_accounts_find_user_by_name (GraniteFDOAccounts* self,
                                              GVariant* _parameters_,
                                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* username = NULL;
	GVariant* _tmp100_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp100_ = g_variant_iter_next_value (&_arguments_iter);
	username = g_variant_dup_string (_tmp100_, NULL);
	g_variant_unref (_tmp100_);
	result = granite_fdo_accounts_find_user_by_name (self, username, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (username);
	;
}

static void
granite_fdo_accounts_dbus_interface_method_call (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* method_name,
                                                 GVariant* parameters,
                                                 GDBusMethodInvocation* invocation,
                                                 gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "FindUserByName") == 0) {
		_dbus_granite_fdo_accounts_find_user_by_name (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
granite_fdo_accounts_dbus_interface_get_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
granite_fdo_accounts_dbus_interface_set_property (GDBusConnection* connection,
                                                  const gchar* sender,
                                                  const gchar* object_path,
                                                  const gchar* interface_name,
                                                  const gchar* property_name,
                                                  GVariant* value,
                                                  GError** error,
                                                  gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

 G_GNUC_INTERNAL guint
granite_fdo_accounts_register_object (gpointer object,
                                      GDBusConnection* connection,
                                      const gchar* path,
                                      GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_granite_fdo_accounts_dbus_interface_info), &_granite_fdo_accounts_dbus_interface_vtable, data, _granite_fdo_accounts_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_granite_fdo_accounts_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
granite_settings_get_instance_private (GraniteSettings* self)
{
	return G_STRUCT_MEMBER_P (self, GraniteSettings_private_offset);
}

/**
         * Possible color scheme preferences expressed by the user
         */
static GType
granite_settings_color_scheme_get_type_once (void)
{
	static const GEnumValue values[] = {{GRANITE_SETTINGS_COLOR_SCHEME_NO_PREFERENCE, "GRANITE_SETTINGS_COLOR_SCHEME_NO_PREFERENCE", "no-preference"}, {GRANITE_SETTINGS_COLOR_SCHEME_DARK, "GRANITE_SETTINGS_COLOR_SCHEME_DARK", "dark"}, {GRANITE_SETTINGS_COLOR_SCHEME_LIGHT, "GRANITE_SETTINGS_COLOR_SCHEME_LIGHT", "light"}, {0, NULL, NULL}};
	GType granite_settings_color_scheme_type_id;
	granite_settings_color_scheme_type_id = g_enum_register_static ("GraniteSettingsColorScheme", values);
	return granite_settings_color_scheme_type_id;
}

GType
granite_settings_color_scheme_get_type (void)
{
	static volatile gsize granite_settings_color_scheme_type_id__once = 0;
	if (g_once_init_enter (&granite_settings_color_scheme_type_id__once)) {
		GType granite_settings_color_scheme_type_id;
		granite_settings_color_scheme_type_id = granite_settings_color_scheme_get_type_once ();
		g_once_init_leave (&granite_settings_color_scheme_type_id__once, granite_settings_color_scheme_type_id);
	}
	return granite_settings_color_scheme_type_id__once;
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

void
granite_settings_get_accent_color (GraniteSettings* self,
                                   GdkRGBA * result)
{
	GdkRGBA* _tmp0_;
	GdkRGBA* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_accent_color;
	if (_tmp0_ == NULL) {
		granite_settings_setup_accent_color (self);
	}
	_tmp1_ = self->priv->_accent_color;
	*result = *_tmp1_;
	return;
}

static GdkRGBA*
_vala_GdkRGBA_copy (GdkRGBA* self)
{
	return g_boxed_copy (gdk_rgba_get_type (), self);
}

static gpointer
__vala_GdkRGBA_copy0 (gpointer self)
{
	return self ? _vala_GdkRGBA_copy (self) : NULL;
}

static void
granite_settings_set_accent_color (GraniteSettings* self,
                                   GdkRGBA * value)
{
	GdkRGBA _tmp0_;
	GdkRGBA* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = *value;
	_tmp1_ = __vala_GdkRGBA_copy0 (&_tmp0_);
	__vala_GdkRGBA_free0 (self->priv->_accent_color);
	self->priv->_accent_color = _tmp1_;
	g_object_notify_by_pspec ((GObject *) self, granite_settings_properties[GRANITE_SETTINGS_ACCENT_COLOR_PROPERTY]);
}

GraniteSettingsColorScheme
granite_settings_get_prefers_color_scheme (GraniteSettings* self)
{
	GraniteSettingsColorScheme result;
	GraniteSettingsColorScheme* _tmp0_;
	GraniteSettingsColorScheme* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_prefers_color_scheme;
	if (_tmp0_ == NULL) {
		granite_settings_setup_prefers_color_scheme (self);
	}
	_tmp1_ = self->priv->_prefers_color_scheme;
	result = *_tmp1_;
	return result;
}

static GraniteSettingsColorScheme*
_granite_settings_color_scheme_dup (GraniteSettingsColorScheme* self)
{
	GraniteSettingsColorScheme* dup;
	dup = g_new0 (GraniteSettingsColorScheme, 1);
	memcpy (dup, self, sizeof (GraniteSettingsColorScheme));
	return dup;
}

static gpointer
__granite_settings_color_scheme_dup0 (gpointer self)
{
	return self ? _granite_settings_color_scheme_dup (self) : NULL;
}

static void
granite_settings_set_prefers_color_scheme (GraniteSettings* self,
                                           GraniteSettingsColorScheme value)
{
	GraniteSettingsColorScheme* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __granite_settings_color_scheme_dup0 (&value);
	_g_free0 (self->priv->_prefers_color_scheme);
	self->priv->_prefers_color_scheme = _tmp0_;
	g_object_notify_by_pspec ((GObject *) self, granite_settings_properties[GRANITE_SETTINGS_PREFERS_COLOR_SCHEME_PROPERTY]);
}

static const gchar*
granite_settings_get_user_path (GraniteSettings* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_user_path;
	if (_tmp0_ == NULL) {
		granite_settings_setup_user_path (self);
	}
	_tmp1_ = self->priv->_user_path;
	result = _tmp1_;
	return result;
}

static void
granite_settings_set_user_path (GraniteSettings* self,
                                const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_user_path);
	self->priv->_user_path = _tmp0_;
}

static GraniteSettings*
__lambda4_ (void)
{
	GraniteSettings* _tmp0_;
	GraniteSettings* result;
	_tmp0_ = granite_settings_new ();
	result = _tmp0_;
	return result;
}

static gpointer
___lambda4__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda4_ ();
	return result;
}

GraniteSettings*
granite_settings_get_default (void)
{
	gconstpointer _tmp0_;
	GraniteSettings* result;
	_tmp0_ = g_once (&granite_settings_instance, ___lambda4__gthread_func, NULL);
	result = (GraniteSettings*) _tmp0_;
	return result;
}

static GraniteSettings*
granite_settings_construct (GType object_type)
{
	GraniteSettings * self = NULL;
	self = (GraniteSettings*) g_object_new (object_type, NULL);
	return self;
}

static GraniteSettings*
granite_settings_new (void)
{
	return granite_settings_construct (GRANITE_TYPE_SETTINGS);
}

static void
granite_settings_setup_user_path (GraniteSettings* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GraniteFDOAccounts* _tmp0_ = NULL;
		GraniteFDOAccounts* _tmp1_;
		GraniteFDOAccounts* _tmp2_;
		gchar* _tmp3_ = NULL;
		GraniteFDOAccounts* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp1_ = (GraniteFDOAccounts*) g_initable_new (GRANITE_FDO_TYPE_ACCOUNTS_PROXY, NULL, &_inner_error0_, "g-flags", 0, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/org/freedesktop/Accounts", "g-interface-name", "org.freedesktop.Accounts", NULL);
		_tmp0_ = (GraniteFDOAccounts*) _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->accounts_service);
		self->priv->accounts_service = _tmp2_;
		_tmp4_ = self->priv->accounts_service;
		_tmp5_ = g_get_user_name ();
		_tmp6_ = granite_fdo_accounts_find_user_by_name (_tmp4_, _tmp5_, &_inner_error0_);
		_tmp3_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (_tmp0_);
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (self->priv->_user_path);
		self->priv->_user_path = _tmp7_;
		_g_free0 (_tmp3_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("Settings.vala:114: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda5_ (GraniteSettings* self,
             const gchar* scheme,
             const gchar* key,
             GVariant* value)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (scheme != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	if (g_strcmp0 (scheme, "org.freedesktop.appearance") == 0) {
		_tmp0_ = g_strcmp0 (key, "accent-color") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GdkRGBA _tmp1_ = {0};
		granite_settings_parse_color (self, value, &_tmp1_);
		granite_settings_set_accent_color (self, &_tmp1_);
	}
}

static void
____lambda5__granite_portal_settings_setting_changed (GranitePortalSettings* _sender,
                                                      const gchar* namespace,
                                                      const gchar* key,
                                                      GVariant* value,
                                                      gpointer self)
{
	___lambda5_ ((GraniteSettings*) self, namespace, key, value);
}

static void
granite_settings_setup_accent_color (GraniteSettings* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GranitePortalSettings* _tmp0_;
		GVariant* _tmp4_ = NULL;
		GranitePortalSettings* _tmp5_;
		GVariant* _tmp6_;
		GVariant* variant = NULL;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		GdkRGBA _tmp9_ = {0};
		GranitePortalSettings* _tmp10_;
		_tmp0_ = self->priv->portal;
		if (_tmp0_ == NULL) {
			GranitePortalSettings* _tmp1_ = NULL;
			GranitePortalSettings* _tmp2_;
			GranitePortalSettings* _tmp3_;
			_tmp2_ = granite_portal_settings_get (&_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (self->priv->portal);
			self->priv->portal = _tmp3_;
			_g_object_unref0 (_tmp1_);
		}
		_tmp5_ = self->priv->portal;
		_tmp6_ = granite_portal_settings_read (_tmp5_, "org.freedesktop.appearance", "accent-color", &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = g_variant_get_variant (_tmp4_);
		variant = _tmp7_;
		_tmp8_ = variant;
		granite_settings_parse_color (self, _tmp8_, &_tmp9_);
		granite_settings_set_accent_color (self, &_tmp9_);
		_tmp10_ = self->priv->portal;
		g_signal_connect_object (_tmp10_, "setting-changed", (GCallback) ____lambda5__granite_portal_settings_setting_changed, self, 0);
		_g_variant_unref0 (variant);
		_g_variant_unref0 (_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		GdkRGBA _tmp13_ = {0};
		GdkRGBA* _tmp14_;
		GdkRGBA* _tmp15_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("Settings.vala:137: %s", _tmp12_);
		memset (&_tmp13_, 0, sizeof (GdkRGBA));
		_tmp14_ = __vala_GdkRGBA_copy0 (&_tmp13_);
		__vala_GdkRGBA_free0 (self->priv->_accent_color);
		self->priv->_accent_color = _tmp14_;
		_tmp15_ = self->priv->_accent_color;
		gdk_rgba_parse (_tmp15_, "#3689e6");
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
granite_settings_parse_color (GraniteSettings* self,
                              GVariant* color,
                              GdkRGBA* result)
{
	gdouble red = 0.0;
	gdouble green = 0.0;
	gdouble blue = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	GdkRGBA rgba = {0};
	GdkRGBA _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (color != NULL);
	g_variant_get (color, "(ddd)", &_tmp0_, &_tmp1_, &_tmp2_, NULL);
	red = _tmp0_;
	green = _tmp1_;
	blue = _tmp2_;
	_tmp3_.red = (gfloat) red;
	_tmp3_.green = (gfloat) green;
	_tmp3_.blue = (gfloat) blue;
	_tmp3_.alpha = (gfloat) 1;
	rgba = _tmp3_;
	*result = rgba;
	return;
}

static void
___lambda6_ (GraniteSettings* self,
             const gchar* scheme,
             const gchar* key,
             GVariant* value)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (scheme != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	if (g_strcmp0 (scheme, "org.freedesktop.appearance") == 0) {
		_tmp0_ = g_strcmp0 (key, "color-scheme") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		granite_settings_set_prefers_color_scheme (self, (GraniteSettingsColorScheme) g_variant_get_uint32 (value));
	}
}

static void
____lambda6__granite_portal_settings_setting_changed (GranitePortalSettings* _sender,
                                                      const gchar* namespace,
                                                      const gchar* key,
                                                      GVariant* value,
                                                      gpointer self)
{
	___lambda6_ ((GraniteSettings*) self, namespace, key, value);
}

static void
___lambda7_ (GraniteSettings* self,
             GVariant* changed,
             gchar** invalid)
{
	GVariant* color_scheme = NULL;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (changed != NULL);
	_tmp0_ = g_variant_type_new ("i");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_lookup_value (changed, "PrefersColorScheme", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	color_scheme = _tmp3_;
	_tmp4_ = color_scheme;
	if (_tmp4_ != NULL) {
		GVariant* _tmp5_;
		_tmp5_ = color_scheme;
		granite_settings_set_prefers_color_scheme (self, (GraniteSettingsColorScheme) g_variant_get_int32 (_tmp5_));
	}
	_g_variant_unref0 (color_scheme);
}

static void
____lambda7__g_dbus_proxy_g_properties_changed (GDBusProxy* _sender,
                                                GVariant* changed_properties,
                                                gchar** invalidated_properties,
                                                gpointer self)
{
	___lambda7_ ((GraniteSettings*) self, changed_properties, invalidated_properties);
}

static void
granite_settings_setup_prefers_color_scheme (GraniteSettings* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GranitePortalSettings* _tmp0_;
		GVariant* _tmp4_ = NULL;
		GranitePortalSettings* _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_;
		GVariant* _tmp8_;
		GranitePortalSettings* _tmp9_;
		_tmp0_ = self->priv->portal;
		if (_tmp0_ == NULL) {
			GranitePortalSettings* _tmp1_ = NULL;
			GranitePortalSettings* _tmp2_;
			GranitePortalSettings* _tmp3_;
			_tmp2_ = granite_portal_settings_get (&_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (self->priv->portal);
			self->priv->portal = _tmp3_;
			_g_object_unref0 (_tmp1_);
		}
		_tmp5_ = self->priv->portal;
		_tmp6_ = granite_portal_settings_read (_tmp5_, "org.freedesktop.appearance", "color-scheme", &_inner_error0_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp7_ = g_variant_get_variant (_tmp4_);
		_tmp8_ = _tmp7_;
		granite_settings_set_prefers_color_scheme (self, (GraniteSettingsColorScheme) g_variant_get_uint32 (_tmp8_));
		_g_variant_unref0 (_tmp8_);
		_tmp9_ = self->priv->portal;
		g_signal_connect_object (_tmp9_, "setting-changed", (GCallback) ____lambda6__granite_portal_settings_setting_changed, self, 0);
		_g_variant_unref0 (_tmp4_);
		return;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp10_ = e;
		_tmp11_ = _tmp10_->message;
		g_debug ("Settings.vala:172: cannot use the portal, using the AccountsService: %" \
"s", _tmp11_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		GranitePantheonAccountsService* _tmp12_ = NULL;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		GranitePantheonAccountsService* _tmp15_;
		GranitePantheonAccountsService* _tmp16_;
		GranitePantheonAccountsService* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		GranitePantheonAccountsService* _tmp20_;
		_tmp13_ = granite_settings_get_user_path (self);
		_tmp14_ = _tmp13_;
		_tmp15_ = (GranitePantheonAccountsService*) g_initable_new (GRANITE_PANTHEON_TYPE_ACCOUNTS_SERVICE_PROXY, NULL, &_inner_error0_, "g-flags", G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES, "g-name", "org.freedesktop.Accounts", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", _tmp14_, "g-interface-name", "io.elementary.pantheon.AccountsService", NULL);
		_tmp12_ = (GranitePantheonAccountsService*) _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp16_ = _tmp12_;
		_tmp12_ = NULL;
		_g_object_unref0 (self->priv->pantheon_act);
		self->priv->pantheon_act = _tmp16_;
		_tmp17_ = self->priv->pantheon_act;
		_tmp18_ = granite_pantheon_accounts_service_get_prefers_color_scheme (_tmp17_);
		_tmp19_ = _tmp18_;
		granite_settings_set_prefers_color_scheme (self, (GraniteSettingsColorScheme) _tmp19_);
		_tmp20_ = self->priv->pantheon_act;
		g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, g_dbus_proxy_get_type (), GDBusProxy), "g-properties-changed", (GCallback) ____lambda7__g_dbus_proxy_g_properties_changed, self, 0);
		_g_object_unref0 (_tmp12_);
		return;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp21_;
		const gchar* _tmp22_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp21_ = e;
		_tmp22_ = _tmp21_->message;
		g_critical ("Settings.vala:193: %s", _tmp22_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	granite_settings_set_prefers_color_scheme (self, GRANITE_SETTINGS_COLOR_SCHEME_NO_PREFERENCE);
}

static void
granite_settings_class_init (GraniteSettingsClass * klass,
                             gpointer klass_data)
{
	granite_settings_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraniteSettings_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_granite_settings_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_granite_settings_set_property;
	G_OBJECT_CLASS (klass)->finalize = granite_settings_finalize;
	/**
	         * The theme accent color chosen by the user
	         * @since 7.7.0
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_SETTINGS_ACCENT_COLOR_PROPERTY, granite_settings_properties[GRANITE_SETTINGS_ACCENT_COLOR_PROPERTY] = g_param_spec_boxed ("accent-color", "accent-color", "accent-color", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	         * Whether the user would prefer if apps use a dark or light color scheme or if the user has expressed no preference.
	         *
	         * To access this from a Flatpak application, add an entry with the value `'--system-talk-name=org.freedesktop.Accounts'`
	         * in the `finish-args` array of your Flatpak manifest.
	         */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRANITE_SETTINGS_PREFERS_COLOR_SCHEME_PROPERTY, granite_settings_properties[GRANITE_SETTINGS_PREFERS_COLOR_SCHEME_PROPERTY] = g_param_spec_enum ("prefers-color-scheme", "prefers-color-scheme", "prefers-color-scheme", GRANITE_SETTINGS_TYPE_COLOR_SCHEME, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
granite_settings_instance_init (GraniteSettings * self,
                                gpointer klass)
{
	self->priv = granite_settings_get_instance_private (self);
	self->priv->_accent_color = NULL;
	self->priv->_prefers_color_scheme = NULL;
	self->priv->_user_path = NULL;
	self->priv->accounts_service = NULL;
	self->priv->pantheon_act = NULL;
	self->priv->portal = NULL;
}

static void
granite_settings_finalize (GObject * obj)
{
	GraniteSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRANITE_TYPE_SETTINGS, GraniteSettings);
	__vala_GdkRGBA_free0 (self->priv->_accent_color);
	_g_free0 (self->priv->_prefers_color_scheme);
	_g_free0 (self->priv->_user_path);
	_g_object_unref0 (self->priv->accounts_service);
	_g_object_unref0 (self->priv->pantheon_act);
	_g_object_unref0 (self->priv->portal);
	G_OBJECT_CLASS (granite_settings_parent_class)->finalize (obj);
}

/**
     * Granite.Settings provides a way to share Pantheon desktop settings with applications.
     */
static GType
granite_settings_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraniteSettingsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) granite_settings_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraniteSettings), 0, (GInstanceInitFunc) granite_settings_instance_init, NULL };
	GType granite_settings_type_id;
	granite_settings_type_id = g_type_register_static (G_TYPE_OBJECT, "GraniteSettings", &g_define_type_info, 0);
	GraniteSettings_private_offset = g_type_add_instance_private (granite_settings_type_id, sizeof (GraniteSettingsPrivate));
	return granite_settings_type_id;
}

GType
granite_settings_get_type (void)
{
	static volatile gsize granite_settings_type_id__once = 0;
	if (g_once_init_enter (&granite_settings_type_id__once)) {
		GType granite_settings_type_id;
		granite_settings_type_id = granite_settings_get_type_once ();
		g_once_init_leave (&granite_settings_type_id__once, granite_settings_type_id);
	}
	return granite_settings_type_id__once;
}

static void
_vala_granite_settings_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec)
{
	GraniteSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_SETTINGS, GraniteSettings);
	switch (property_id) {
		case GRANITE_SETTINGS_ACCENT_COLOR_PROPERTY:
		{
			GdkRGBA boxed;
			granite_settings_get_accent_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case GRANITE_SETTINGS_PREFERS_COLOR_SCHEME_PROPERTY:
		g_value_set_enum (value, granite_settings_get_prefers_color_scheme (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_granite_settings_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec)
{
	GraniteSettings * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRANITE_TYPE_SETTINGS, GraniteSettings);
	switch (property_id) {
		case GRANITE_SETTINGS_ACCENT_COLOR_PROPERTY:
		granite_settings_set_accent_color (self, g_value_get_boxed (value));
		break;
		case GRANITE_SETTINGS_PREFERS_COLOR_SCHEME_PROPERTY:
		granite_settings_set_prefers_color_scheme (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

