// Code generated by astool. DO NOT EDIT.

package propertyaudience

import (
	vocab "code.superseriousbusiness.org/activity/streams/vocab"
	"fmt"
	"net/url"
)

// ActivityStreamsAudiencePropertyIterator is an iterator for a property. It is
// permitted to be one of multiple value types. At most, one type of value can
// be present, or none at all. Setting a value will clear the other types of
// values so that only one of the 'Is' methods will return true. It is
// possible to clear all values, so that this property is empty.
type ActivityStreamsAudiencePropertyIterator struct {
	activitystreamsObjectMember                vocab.ActivityStreamsObject
	activitystreamsLinkMember                  vocab.ActivityStreamsLink
	activitystreamsAcceptMember                vocab.ActivityStreamsAccept
	activitystreamsActivityMember              vocab.ActivityStreamsActivity
	activitystreamsAddMember                   vocab.ActivityStreamsAdd
	funkwhaleAlbumMember                       vocab.FunkwhaleAlbum
	activitystreamsAnnounceMember              vocab.ActivityStreamsAnnounce
	gotosocialAnnounceApprovalMember           vocab.GoToSocialAnnounceApproval
	gotosocialAnnounceAuthorizationMember      vocab.GoToSocialAnnounceAuthorization
	gotosocialAnnounceRequestMember            vocab.GoToSocialAnnounceRequest
	activitystreamsApplicationMember           vocab.ActivityStreamsApplication
	activitystreamsArriveMember                vocab.ActivityStreamsArrive
	activitystreamsArticleMember               vocab.ActivityStreamsArticle
	funkwhaleArtistMember                      vocab.FunkwhaleArtist
	activitystreamsAudioMember                 vocab.ActivityStreamsAudio
	activitystreamsBlockMember                 vocab.ActivityStreamsBlock
	activitystreamsCollectionMember            vocab.ActivityStreamsCollection
	activitystreamsCollectionPageMember        vocab.ActivityStreamsCollectionPage
	activitystreamsCreateMember                vocab.ActivityStreamsCreate
	activitystreamsDeleteMember                vocab.ActivityStreamsDelete
	activitystreamsDislikeMember               vocab.ActivityStreamsDislike
	activitystreamsDocumentMember              vocab.ActivityStreamsDocument
	tootEmojiMember                            vocab.TootEmoji
	litepubEmojiReactMember                    vocab.LitePubEmojiReact
	activitystreamsEventMember                 vocab.ActivityStreamsEvent
	activitystreamsFlagMember                  vocab.ActivityStreamsFlag
	activitystreamsFollowMember                vocab.ActivityStreamsFollow
	activitystreamsGroupMember                 vocab.ActivityStreamsGroup
	tootHashtagMember                          vocab.TootHashtag
	tootIdentityProofMember                    vocab.TootIdentityProof
	activitystreamsIgnoreMember                vocab.ActivityStreamsIgnore
	activitystreamsImageMember                 vocab.ActivityStreamsImage
	activitystreamsIntransitiveActivityMember  vocab.ActivityStreamsIntransitiveActivity
	activitystreamsInviteMember                vocab.ActivityStreamsInvite
	activitystreamsJoinMember                  vocab.ActivityStreamsJoin
	activitystreamsLeaveMember                 vocab.ActivityStreamsLeave
	funkwhaleLibraryMember                     vocab.FunkwhaleLibrary
	activitystreamsLikeMember                  vocab.ActivityStreamsLike
	gotosocialLikeApprovalMember               vocab.GoToSocialLikeApproval
	gotosocialLikeAuthorizationMember          vocab.GoToSocialLikeAuthorization
	gotosocialLikeRequestMember                vocab.GoToSocialLikeRequest
	activitystreamsListenMember                vocab.ActivityStreamsListen
	activitystreamsMentionMember               vocab.ActivityStreamsMention
	activitystreamsMoveMember                  vocab.ActivityStreamsMove
	activitystreamsNoteMember                  vocab.ActivityStreamsNote
	activitystreamsOfferMember                 vocab.ActivityStreamsOffer
	activitystreamsOrderedCollectionMember     vocab.ActivityStreamsOrderedCollection
	activitystreamsOrderedCollectionPageMember vocab.ActivityStreamsOrderedCollectionPage
	activitystreamsOrganizationMember          vocab.ActivityStreamsOrganization
	activitystreamsPageMember                  vocab.ActivityStreamsPage
	activitystreamsPersonMember                vocab.ActivityStreamsPerson
	activitystreamsPlaceMember                 vocab.ActivityStreamsPlace
	activitystreamsProfileMember               vocab.ActivityStreamsProfile
	schemaPropertyValueMember                  vocab.SchemaPropertyValue
	activitystreamsQuestionMember              vocab.ActivityStreamsQuestion
	activitystreamsReadMember                  vocab.ActivityStreamsRead
	activitystreamsRejectMember                vocab.ActivityStreamsReject
	activitystreamsRelationshipMember          vocab.ActivityStreamsRelationship
	activitystreamsRemoveMember                vocab.ActivityStreamsRemove
	gotosocialReplyApprovalMember              vocab.GoToSocialReplyApproval
	gotosocialReplyAuthorizationMember         vocab.GoToSocialReplyAuthorization
	gotosocialReplyRequestMember               vocab.GoToSocialReplyRequest
	activitystreamsServiceMember               vocab.ActivityStreamsService
	activitystreamsTentativeAcceptMember       vocab.ActivityStreamsTentativeAccept
	activitystreamsTentativeRejectMember       vocab.ActivityStreamsTentativeReject
	activitystreamsTombstoneMember             vocab.ActivityStreamsTombstone
	funkwhaleTrackMember                       vocab.FunkwhaleTrack
	activitystreamsTravelMember                vocab.ActivityStreamsTravel
	activitystreamsUndoMember                  vocab.ActivityStreamsUndo
	activitystreamsUpdateMember                vocab.ActivityStreamsUpdate
	activitystreamsVideoMember                 vocab.ActivityStreamsVideo
	activitystreamsViewMember                  vocab.ActivityStreamsView
	unknown                                    interface{}
	iri                                        *url.URL
	alias                                      string
	myIdx                                      int
	parent                                     vocab.ActivityStreamsAudienceProperty
}

// NewActivityStreamsAudiencePropertyIterator creates a new
// ActivityStreamsAudience property.
func NewActivityStreamsAudiencePropertyIterator() *ActivityStreamsAudiencePropertyIterator {
	return &ActivityStreamsAudiencePropertyIterator{alias: ""}
}

// deserializeActivityStreamsAudiencePropertyIterator creates an iterator from an
// element that has been unmarshalled from a text or binary format.
func deserializeActivityStreamsAudiencePropertyIterator(i interface{}, aliasMap map[string]string) (*ActivityStreamsAudiencePropertyIterator, error) {
	alias := ""
	if a, ok := aliasMap["https://www.w3.org/ns/activitystreams"]; ok {
		alias = a
	}
	if s, ok := i.(string); ok {
		u, err := url.Parse(s)
		// If error exists, don't error out -- skip this and treat as unknown string ([]byte) at worst
		// Also, if no scheme exists, don't treat it as a URL -- net/url is greedy
		if err == nil && len(u.Scheme) > 0 {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias: alias,
				iri:   u,
			}
			return this, nil
		}
	}
	if m, ok := i.(map[string]interface{}); ok {
		if v, err := mgr.DeserializeObjectActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsObjectMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeLinkActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsLinkMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeAcceptActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsAcceptMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeActivityActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsActivityMember: v,
				alias:                         alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeAddActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsAddMember: v,
				alias:                    alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeAlbumFunkwhale()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:                alias,
				funkwhaleAlbumMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeAnnounceActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsAnnounceMember: v,
				alias:                         alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeAnnounceApprovalGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:                            alias,
				gotosocialAnnounceApprovalMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeAnnounceAuthorizationGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:                                 alias,
				gotosocialAnnounceAuthorizationMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeAnnounceRequestGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:                           alias,
				gotosocialAnnounceRequestMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeApplicationActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsApplicationMember: v,
				alias:                            alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeArriveActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsArriveMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeArticleActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsArticleMember: v,
				alias:                        alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeArtistFunkwhale()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:                 alias,
				funkwhaleArtistMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeAudioActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsAudioMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeBlockActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsBlockMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeCollectionActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsCollectionMember: v,
				alias:                           alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeCollectionPageActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsCollectionPageMember: v,
				alias:                               alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeCreateActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsCreateMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeDeleteActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsDeleteMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeDislikeActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsDislikeMember: v,
				alias:                        alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeDocumentActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsDocumentMember: v,
				alias:                         alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeEmojiToot()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:           alias,
				tootEmojiMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeEmojiReactLitePub()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:                   alias,
				litepubEmojiReactMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeEventActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsEventMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeFlagActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsFlagMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeFollowActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsFollowMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeGroupActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsGroupMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeHashtagToot()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:             alias,
				tootHashtagMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeIdentityProofToot()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:                   alias,
				tootIdentityProofMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeIgnoreActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsIgnoreMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeImageActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsImageMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeIntransitiveActivityActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsIntransitiveActivityMember: v,
				alias: alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeInviteActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsInviteMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeJoinActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsJoinMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeLeaveActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsLeaveMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeLibraryFunkwhale()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:                  alias,
				funkwhaleLibraryMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeLikeActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsLikeMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeLikeApprovalGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:                        alias,
				gotosocialLikeApprovalMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeLikeAuthorizationGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:                             alias,
				gotosocialLikeAuthorizationMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeLikeRequestGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:                       alias,
				gotosocialLikeRequestMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeListenActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsListenMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeMentionActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsMentionMember: v,
				alias:                        alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeMoveActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsMoveMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeNoteActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsNoteMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeOfferActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsOfferMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeOrderedCollectionActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsOrderedCollectionMember: v,
				alias:                                  alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeOrderedCollectionPageActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsOrderedCollectionPageMember: v,
				alias: alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeOrganizationActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsOrganizationMember: v,
				alias:                             alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializePageActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsPageMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializePersonActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsPersonMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializePlaceActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsPlaceMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeProfileActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsProfileMember: v,
				alias:                        alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializePropertyValueSchema()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:                     alias,
				schemaPropertyValueMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeQuestionActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsQuestionMember: v,
				alias:                         alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeReadActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsReadMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeRejectActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsRejectMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeRelationshipActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsRelationshipMember: v,
				alias:                             alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeRemoveActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsRemoveMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeReplyApprovalGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:                         alias,
				gotosocialReplyApprovalMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeReplyAuthorizationGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:                              alias,
				gotosocialReplyAuthorizationMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeReplyRequestGoToSocial()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:                        alias,
				gotosocialReplyRequestMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeServiceActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsServiceMember: v,
				alias:                        alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeTentativeAcceptActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsTentativeAcceptMember: v,
				alias:                                alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeTentativeRejectActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsTentativeRejectMember: v,
				alias:                                alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeTombstoneActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsTombstoneMember: v,
				alias:                          alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeTrackFunkwhale()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				alias:                alias,
				funkwhaleTrackMember: v,
			}
			return this, nil
		} else if v, err := mgr.DeserializeTravelActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsTravelMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeUndoActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsUndoMember: v,
				alias:                     alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeUpdateActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsUpdateMember: v,
				alias:                       alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeVideoActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsVideoMember: v,
				alias:                      alias,
			}
			return this, nil
		} else if v, err := mgr.DeserializeViewActivityStreams()(m, aliasMap); err == nil {
			this := &ActivityStreamsAudiencePropertyIterator{
				activitystreamsViewMember: v,
				alias:                     alias,
			}
			return this, nil
		}
	}
	this := &ActivityStreamsAudiencePropertyIterator{
		alias:   alias,
		unknown: i,
	}
	return this, nil
}

// GetActivityStreamsAccept returns the value of this property. When
// IsActivityStreamsAccept returns false, GetActivityStreamsAccept will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsAccept() vocab.ActivityStreamsAccept {
	return this.activitystreamsAcceptMember
}

// GetActivityStreamsActivity returns the value of this property. When
// IsActivityStreamsActivity returns false, GetActivityStreamsActivity will
// return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsActivity() vocab.ActivityStreamsActivity {
	return this.activitystreamsActivityMember
}

// GetActivityStreamsAdd returns the value of this property. When
// IsActivityStreamsAdd returns false, GetActivityStreamsAdd will return an
// arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsAdd() vocab.ActivityStreamsAdd {
	return this.activitystreamsAddMember
}

// GetActivityStreamsAnnounce returns the value of this property. When
// IsActivityStreamsAnnounce returns false, GetActivityStreamsAnnounce will
// return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsAnnounce() vocab.ActivityStreamsAnnounce {
	return this.activitystreamsAnnounceMember
}

// GetActivityStreamsApplication returns the value of this property. When
// IsActivityStreamsApplication returns false, GetActivityStreamsApplication
// will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsApplication() vocab.ActivityStreamsApplication {
	return this.activitystreamsApplicationMember
}

// GetActivityStreamsArrive returns the value of this property. When
// IsActivityStreamsArrive returns false, GetActivityStreamsArrive will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsArrive() vocab.ActivityStreamsArrive {
	return this.activitystreamsArriveMember
}

// GetActivityStreamsArticle returns the value of this property. When
// IsActivityStreamsArticle returns false, GetActivityStreamsArticle will
// return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsArticle() vocab.ActivityStreamsArticle {
	return this.activitystreamsArticleMember
}

// GetActivityStreamsAudio returns the value of this property. When
// IsActivityStreamsAudio returns false, GetActivityStreamsAudio will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsAudio() vocab.ActivityStreamsAudio {
	return this.activitystreamsAudioMember
}

// GetActivityStreamsBlock returns the value of this property. When
// IsActivityStreamsBlock returns false, GetActivityStreamsBlock will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsBlock() vocab.ActivityStreamsBlock {
	return this.activitystreamsBlockMember
}

// GetActivityStreamsCollection returns the value of this property. When
// IsActivityStreamsCollection returns false, GetActivityStreamsCollection
// will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsCollection() vocab.ActivityStreamsCollection {
	return this.activitystreamsCollectionMember
}

// GetActivityStreamsCollectionPage returns the value of this property. When
// IsActivityStreamsCollectionPage returns false,
// GetActivityStreamsCollectionPage will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsCollectionPage() vocab.ActivityStreamsCollectionPage {
	return this.activitystreamsCollectionPageMember
}

// GetActivityStreamsCreate returns the value of this property. When
// IsActivityStreamsCreate returns false, GetActivityStreamsCreate will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsCreate() vocab.ActivityStreamsCreate {
	return this.activitystreamsCreateMember
}

// GetActivityStreamsDelete returns the value of this property. When
// IsActivityStreamsDelete returns false, GetActivityStreamsDelete will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsDelete() vocab.ActivityStreamsDelete {
	return this.activitystreamsDeleteMember
}

// GetActivityStreamsDislike returns the value of this property. When
// IsActivityStreamsDislike returns false, GetActivityStreamsDislike will
// return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsDislike() vocab.ActivityStreamsDislike {
	return this.activitystreamsDislikeMember
}

// GetActivityStreamsDocument returns the value of this property. When
// IsActivityStreamsDocument returns false, GetActivityStreamsDocument will
// return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsDocument() vocab.ActivityStreamsDocument {
	return this.activitystreamsDocumentMember
}

// GetActivityStreamsEvent returns the value of this property. When
// IsActivityStreamsEvent returns false, GetActivityStreamsEvent will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsEvent() vocab.ActivityStreamsEvent {
	return this.activitystreamsEventMember
}

// GetActivityStreamsFlag returns the value of this property. When
// IsActivityStreamsFlag returns false, GetActivityStreamsFlag will return an
// arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsFlag() vocab.ActivityStreamsFlag {
	return this.activitystreamsFlagMember
}

// GetActivityStreamsFollow returns the value of this property. When
// IsActivityStreamsFollow returns false, GetActivityStreamsFollow will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsFollow() vocab.ActivityStreamsFollow {
	return this.activitystreamsFollowMember
}

// GetActivityStreamsGroup returns the value of this property. When
// IsActivityStreamsGroup returns false, GetActivityStreamsGroup will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsGroup() vocab.ActivityStreamsGroup {
	return this.activitystreamsGroupMember
}

// GetActivityStreamsIgnore returns the value of this property. When
// IsActivityStreamsIgnore returns false, GetActivityStreamsIgnore will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsIgnore() vocab.ActivityStreamsIgnore {
	return this.activitystreamsIgnoreMember
}

// GetActivityStreamsImage returns the value of this property. When
// IsActivityStreamsImage returns false, GetActivityStreamsImage will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsImage() vocab.ActivityStreamsImage {
	return this.activitystreamsImageMember
}

// GetActivityStreamsIntransitiveActivity returns the value of this property. When
// IsActivityStreamsIntransitiveActivity returns false,
// GetActivityStreamsIntransitiveActivity will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsIntransitiveActivity() vocab.ActivityStreamsIntransitiveActivity {
	return this.activitystreamsIntransitiveActivityMember
}

// GetActivityStreamsInvite returns the value of this property. When
// IsActivityStreamsInvite returns false, GetActivityStreamsInvite will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsInvite() vocab.ActivityStreamsInvite {
	return this.activitystreamsInviteMember
}

// GetActivityStreamsJoin returns the value of this property. When
// IsActivityStreamsJoin returns false, GetActivityStreamsJoin will return an
// arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsJoin() vocab.ActivityStreamsJoin {
	return this.activitystreamsJoinMember
}

// GetActivityStreamsLeave returns the value of this property. When
// IsActivityStreamsLeave returns false, GetActivityStreamsLeave will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsLeave() vocab.ActivityStreamsLeave {
	return this.activitystreamsLeaveMember
}

// GetActivityStreamsLike returns the value of this property. When
// IsActivityStreamsLike returns false, GetActivityStreamsLike will return an
// arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsLike() vocab.ActivityStreamsLike {
	return this.activitystreamsLikeMember
}

// GetActivityStreamsLink returns the value of this property. When
// IsActivityStreamsLink returns false, GetActivityStreamsLink will return an
// arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsLink() vocab.ActivityStreamsLink {
	return this.activitystreamsLinkMember
}

// GetActivityStreamsListen returns the value of this property. When
// IsActivityStreamsListen returns false, GetActivityStreamsListen will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsListen() vocab.ActivityStreamsListen {
	return this.activitystreamsListenMember
}

// GetActivityStreamsMention returns the value of this property. When
// IsActivityStreamsMention returns false, GetActivityStreamsMention will
// return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsMention() vocab.ActivityStreamsMention {
	return this.activitystreamsMentionMember
}

// GetActivityStreamsMove returns the value of this property. When
// IsActivityStreamsMove returns false, GetActivityStreamsMove will return an
// arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsMove() vocab.ActivityStreamsMove {
	return this.activitystreamsMoveMember
}

// GetActivityStreamsNote returns the value of this property. When
// IsActivityStreamsNote returns false, GetActivityStreamsNote will return an
// arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsNote() vocab.ActivityStreamsNote {
	return this.activitystreamsNoteMember
}

// GetActivityStreamsObject returns the value of this property. When
// IsActivityStreamsObject returns false, GetActivityStreamsObject will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsObject() vocab.ActivityStreamsObject {
	return this.activitystreamsObjectMember
}

// GetActivityStreamsOffer returns the value of this property. When
// IsActivityStreamsOffer returns false, GetActivityStreamsOffer will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsOffer() vocab.ActivityStreamsOffer {
	return this.activitystreamsOfferMember
}

// GetActivityStreamsOrderedCollection returns the value of this property. When
// IsActivityStreamsOrderedCollection returns false,
// GetActivityStreamsOrderedCollection will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsOrderedCollection() vocab.ActivityStreamsOrderedCollection {
	return this.activitystreamsOrderedCollectionMember
}

// GetActivityStreamsOrderedCollectionPage returns the value of this property.
// When IsActivityStreamsOrderedCollectionPage returns false,
// GetActivityStreamsOrderedCollectionPage will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsOrderedCollectionPage() vocab.ActivityStreamsOrderedCollectionPage {
	return this.activitystreamsOrderedCollectionPageMember
}

// GetActivityStreamsOrganization returns the value of this property. When
// IsActivityStreamsOrganization returns false, GetActivityStreamsOrganization
// will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsOrganization() vocab.ActivityStreamsOrganization {
	return this.activitystreamsOrganizationMember
}

// GetActivityStreamsPage returns the value of this property. When
// IsActivityStreamsPage returns false, GetActivityStreamsPage will return an
// arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsPage() vocab.ActivityStreamsPage {
	return this.activitystreamsPageMember
}

// GetActivityStreamsPerson returns the value of this property. When
// IsActivityStreamsPerson returns false, GetActivityStreamsPerson will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsPerson() vocab.ActivityStreamsPerson {
	return this.activitystreamsPersonMember
}

// GetActivityStreamsPlace returns the value of this property. When
// IsActivityStreamsPlace returns false, GetActivityStreamsPlace will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsPlace() vocab.ActivityStreamsPlace {
	return this.activitystreamsPlaceMember
}

// GetActivityStreamsProfile returns the value of this property. When
// IsActivityStreamsProfile returns false, GetActivityStreamsProfile will
// return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsProfile() vocab.ActivityStreamsProfile {
	return this.activitystreamsProfileMember
}

// GetActivityStreamsQuestion returns the value of this property. When
// IsActivityStreamsQuestion returns false, GetActivityStreamsQuestion will
// return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsQuestion() vocab.ActivityStreamsQuestion {
	return this.activitystreamsQuestionMember
}

// GetActivityStreamsRead returns the value of this property. When
// IsActivityStreamsRead returns false, GetActivityStreamsRead will return an
// arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsRead() vocab.ActivityStreamsRead {
	return this.activitystreamsReadMember
}

// GetActivityStreamsReject returns the value of this property. When
// IsActivityStreamsReject returns false, GetActivityStreamsReject will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsReject() vocab.ActivityStreamsReject {
	return this.activitystreamsRejectMember
}

// GetActivityStreamsRelationship returns the value of this property. When
// IsActivityStreamsRelationship returns false, GetActivityStreamsRelationship
// will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsRelationship() vocab.ActivityStreamsRelationship {
	return this.activitystreamsRelationshipMember
}

// GetActivityStreamsRemove returns the value of this property. When
// IsActivityStreamsRemove returns false, GetActivityStreamsRemove will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsRemove() vocab.ActivityStreamsRemove {
	return this.activitystreamsRemoveMember
}

// GetActivityStreamsService returns the value of this property. When
// IsActivityStreamsService returns false, GetActivityStreamsService will
// return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsService() vocab.ActivityStreamsService {
	return this.activitystreamsServiceMember
}

// GetActivityStreamsTentativeAccept returns the value of this property. When
// IsActivityStreamsTentativeAccept returns false,
// GetActivityStreamsTentativeAccept will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsTentativeAccept() vocab.ActivityStreamsTentativeAccept {
	return this.activitystreamsTentativeAcceptMember
}

// GetActivityStreamsTentativeReject returns the value of this property. When
// IsActivityStreamsTentativeReject returns false,
// GetActivityStreamsTentativeReject will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsTentativeReject() vocab.ActivityStreamsTentativeReject {
	return this.activitystreamsTentativeRejectMember
}

// GetActivityStreamsTombstone returns the value of this property. When
// IsActivityStreamsTombstone returns false, GetActivityStreamsTombstone will
// return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsTombstone() vocab.ActivityStreamsTombstone {
	return this.activitystreamsTombstoneMember
}

// GetActivityStreamsTravel returns the value of this property. When
// IsActivityStreamsTravel returns false, GetActivityStreamsTravel will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsTravel() vocab.ActivityStreamsTravel {
	return this.activitystreamsTravelMember
}

// GetActivityStreamsUndo returns the value of this property. When
// IsActivityStreamsUndo returns false, GetActivityStreamsUndo will return an
// arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsUndo() vocab.ActivityStreamsUndo {
	return this.activitystreamsUndoMember
}

// GetActivityStreamsUpdate returns the value of this property. When
// IsActivityStreamsUpdate returns false, GetActivityStreamsUpdate will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsUpdate() vocab.ActivityStreamsUpdate {
	return this.activitystreamsUpdateMember
}

// GetActivityStreamsVideo returns the value of this property. When
// IsActivityStreamsVideo returns false, GetActivityStreamsVideo will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsVideo() vocab.ActivityStreamsVideo {
	return this.activitystreamsVideoMember
}

// GetActivityStreamsView returns the value of this property. When
// IsActivityStreamsView returns false, GetActivityStreamsView will return an
// arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetActivityStreamsView() vocab.ActivityStreamsView {
	return this.activitystreamsViewMember
}

// GetFunkwhaleAlbum returns the value of this property. When IsFunkwhaleAlbum
// returns false, GetFunkwhaleAlbum will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetFunkwhaleAlbum() vocab.FunkwhaleAlbum {
	return this.funkwhaleAlbumMember
}

// GetFunkwhaleArtist returns the value of this property. When IsFunkwhaleArtist
// returns false, GetFunkwhaleArtist will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetFunkwhaleArtist() vocab.FunkwhaleArtist {
	return this.funkwhaleArtistMember
}

// GetFunkwhaleLibrary returns the value of this property. When IsFunkwhaleLibrary
// returns false, GetFunkwhaleLibrary will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetFunkwhaleLibrary() vocab.FunkwhaleLibrary {
	return this.funkwhaleLibraryMember
}

// GetFunkwhaleTrack returns the value of this property. When IsFunkwhaleTrack
// returns false, GetFunkwhaleTrack will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetFunkwhaleTrack() vocab.FunkwhaleTrack {
	return this.funkwhaleTrackMember
}

// GetGoToSocialAnnounceApproval returns the value of this property. When
// IsGoToSocialAnnounceApproval returns false, GetGoToSocialAnnounceApproval
// will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetGoToSocialAnnounceApproval() vocab.GoToSocialAnnounceApproval {
	return this.gotosocialAnnounceApprovalMember
}

// GetGoToSocialAnnounceAuthorization returns the value of this property. When
// IsGoToSocialAnnounceAuthorization returns false,
// GetGoToSocialAnnounceAuthorization will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetGoToSocialAnnounceAuthorization() vocab.GoToSocialAnnounceAuthorization {
	return this.gotosocialAnnounceAuthorizationMember
}

// GetGoToSocialAnnounceRequest returns the value of this property. When
// IsGoToSocialAnnounceRequest returns false, GetGoToSocialAnnounceRequest
// will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetGoToSocialAnnounceRequest() vocab.GoToSocialAnnounceRequest {
	return this.gotosocialAnnounceRequestMember
}

// GetGoToSocialLikeApproval returns the value of this property. When
// IsGoToSocialLikeApproval returns false, GetGoToSocialLikeApproval will
// return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetGoToSocialLikeApproval() vocab.GoToSocialLikeApproval {
	return this.gotosocialLikeApprovalMember
}

// GetGoToSocialLikeAuthorization returns the value of this property. When
// IsGoToSocialLikeAuthorization returns false, GetGoToSocialLikeAuthorization
// will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetGoToSocialLikeAuthorization() vocab.GoToSocialLikeAuthorization {
	return this.gotosocialLikeAuthorizationMember
}

// GetGoToSocialLikeRequest returns the value of this property. When
// IsGoToSocialLikeRequest returns false, GetGoToSocialLikeRequest will return
// an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetGoToSocialLikeRequest() vocab.GoToSocialLikeRequest {
	return this.gotosocialLikeRequestMember
}

// GetGoToSocialReplyApproval returns the value of this property. When
// IsGoToSocialReplyApproval returns false, GetGoToSocialReplyApproval will
// return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetGoToSocialReplyApproval() vocab.GoToSocialReplyApproval {
	return this.gotosocialReplyApprovalMember
}

// GetGoToSocialReplyAuthorization returns the value of this property. When
// IsGoToSocialReplyAuthorization returns false,
// GetGoToSocialReplyAuthorization will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetGoToSocialReplyAuthorization() vocab.GoToSocialReplyAuthorization {
	return this.gotosocialReplyAuthorizationMember
}

// GetGoToSocialReplyRequest returns the value of this property. When
// IsGoToSocialReplyRequest returns false, GetGoToSocialReplyRequest will
// return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetGoToSocialReplyRequest() vocab.GoToSocialReplyRequest {
	return this.gotosocialReplyRequestMember
}

// GetIRI returns the IRI of this property. When IsIRI returns false, GetIRI will
// return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetIRI() *url.URL {
	return this.iri
}

// GetLitePubEmojiReact returns the value of this property. When
// IsLitePubEmojiReact returns false, GetLitePubEmojiReact will return an
// arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetLitePubEmojiReact() vocab.LitePubEmojiReact {
	return this.litepubEmojiReactMember
}

// GetSchemaPropertyValue returns the value of this property. When
// IsSchemaPropertyValue returns false, GetSchemaPropertyValue will return an
// arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetSchemaPropertyValue() vocab.SchemaPropertyValue {
	return this.schemaPropertyValueMember
}

// GetTootEmoji returns the value of this property. When IsTootEmoji returns
// false, GetTootEmoji will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetTootEmoji() vocab.TootEmoji {
	return this.tootEmojiMember
}

// GetTootHashtag returns the value of this property. When IsTootHashtag returns
// false, GetTootHashtag will return an arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetTootHashtag() vocab.TootHashtag {
	return this.tootHashtagMember
}

// GetTootIdentityProof returns the value of this property. When
// IsTootIdentityProof returns false, GetTootIdentityProof will return an
// arbitrary value.
func (this ActivityStreamsAudiencePropertyIterator) GetTootIdentityProof() vocab.TootIdentityProof {
	return this.tootIdentityProofMember
}

// GetType returns the value in this property as a Type. Returns nil if the value
// is not an ActivityStreams type, such as an IRI or another value.
func (this ActivityStreamsAudiencePropertyIterator) GetType() vocab.Type {
	if this.IsActivityStreamsObject() {
		return this.GetActivityStreamsObject()
	}
	if this.IsActivityStreamsLink() {
		return this.GetActivityStreamsLink()
	}
	if this.IsActivityStreamsAccept() {
		return this.GetActivityStreamsAccept()
	}
	if this.IsActivityStreamsActivity() {
		return this.GetActivityStreamsActivity()
	}
	if this.IsActivityStreamsAdd() {
		return this.GetActivityStreamsAdd()
	}
	if this.IsFunkwhaleAlbum() {
		return this.GetFunkwhaleAlbum()
	}
	if this.IsActivityStreamsAnnounce() {
		return this.GetActivityStreamsAnnounce()
	}
	if this.IsGoToSocialAnnounceApproval() {
		return this.GetGoToSocialAnnounceApproval()
	}
	if this.IsGoToSocialAnnounceAuthorization() {
		return this.GetGoToSocialAnnounceAuthorization()
	}
	if this.IsGoToSocialAnnounceRequest() {
		return this.GetGoToSocialAnnounceRequest()
	}
	if this.IsActivityStreamsApplication() {
		return this.GetActivityStreamsApplication()
	}
	if this.IsActivityStreamsArrive() {
		return this.GetActivityStreamsArrive()
	}
	if this.IsActivityStreamsArticle() {
		return this.GetActivityStreamsArticle()
	}
	if this.IsFunkwhaleArtist() {
		return this.GetFunkwhaleArtist()
	}
	if this.IsActivityStreamsAudio() {
		return this.GetActivityStreamsAudio()
	}
	if this.IsActivityStreamsBlock() {
		return this.GetActivityStreamsBlock()
	}
	if this.IsActivityStreamsCollection() {
		return this.GetActivityStreamsCollection()
	}
	if this.IsActivityStreamsCollectionPage() {
		return this.GetActivityStreamsCollectionPage()
	}
	if this.IsActivityStreamsCreate() {
		return this.GetActivityStreamsCreate()
	}
	if this.IsActivityStreamsDelete() {
		return this.GetActivityStreamsDelete()
	}
	if this.IsActivityStreamsDislike() {
		return this.GetActivityStreamsDislike()
	}
	if this.IsActivityStreamsDocument() {
		return this.GetActivityStreamsDocument()
	}
	if this.IsTootEmoji() {
		return this.GetTootEmoji()
	}
	if this.IsLitePubEmojiReact() {
		return this.GetLitePubEmojiReact()
	}
	if this.IsActivityStreamsEvent() {
		return this.GetActivityStreamsEvent()
	}
	if this.IsActivityStreamsFlag() {
		return this.GetActivityStreamsFlag()
	}
	if this.IsActivityStreamsFollow() {
		return this.GetActivityStreamsFollow()
	}
	if this.IsActivityStreamsGroup() {
		return this.GetActivityStreamsGroup()
	}
	if this.IsTootHashtag() {
		return this.GetTootHashtag()
	}
	if this.IsTootIdentityProof() {
		return this.GetTootIdentityProof()
	}
	if this.IsActivityStreamsIgnore() {
		return this.GetActivityStreamsIgnore()
	}
	if this.IsActivityStreamsImage() {
		return this.GetActivityStreamsImage()
	}
	if this.IsActivityStreamsIntransitiveActivity() {
		return this.GetActivityStreamsIntransitiveActivity()
	}
	if this.IsActivityStreamsInvite() {
		return this.GetActivityStreamsInvite()
	}
	if this.IsActivityStreamsJoin() {
		return this.GetActivityStreamsJoin()
	}
	if this.IsActivityStreamsLeave() {
		return this.GetActivityStreamsLeave()
	}
	if this.IsFunkwhaleLibrary() {
		return this.GetFunkwhaleLibrary()
	}
	if this.IsActivityStreamsLike() {
		return this.GetActivityStreamsLike()
	}
	if this.IsGoToSocialLikeApproval() {
		return this.GetGoToSocialLikeApproval()
	}
	if this.IsGoToSocialLikeAuthorization() {
		return this.GetGoToSocialLikeAuthorization()
	}
	if this.IsGoToSocialLikeRequest() {
		return this.GetGoToSocialLikeRequest()
	}
	if this.IsActivityStreamsListen() {
		return this.GetActivityStreamsListen()
	}
	if this.IsActivityStreamsMention() {
		return this.GetActivityStreamsMention()
	}
	if this.IsActivityStreamsMove() {
		return this.GetActivityStreamsMove()
	}
	if this.IsActivityStreamsNote() {
		return this.GetActivityStreamsNote()
	}
	if this.IsActivityStreamsOffer() {
		return this.GetActivityStreamsOffer()
	}
	if this.IsActivityStreamsOrderedCollection() {
		return this.GetActivityStreamsOrderedCollection()
	}
	if this.IsActivityStreamsOrderedCollectionPage() {
		return this.GetActivityStreamsOrderedCollectionPage()
	}
	if this.IsActivityStreamsOrganization() {
		return this.GetActivityStreamsOrganization()
	}
	if this.IsActivityStreamsPage() {
		return this.GetActivityStreamsPage()
	}
	if this.IsActivityStreamsPerson() {
		return this.GetActivityStreamsPerson()
	}
	if this.IsActivityStreamsPlace() {
		return this.GetActivityStreamsPlace()
	}
	if this.IsActivityStreamsProfile() {
		return this.GetActivityStreamsProfile()
	}
	if this.IsSchemaPropertyValue() {
		return this.GetSchemaPropertyValue()
	}
	if this.IsActivityStreamsQuestion() {
		return this.GetActivityStreamsQuestion()
	}
	if this.IsActivityStreamsRead() {
		return this.GetActivityStreamsRead()
	}
	if this.IsActivityStreamsReject() {
		return this.GetActivityStreamsReject()
	}
	if this.IsActivityStreamsRelationship() {
		return this.GetActivityStreamsRelationship()
	}
	if this.IsActivityStreamsRemove() {
		return this.GetActivityStreamsRemove()
	}
	if this.IsGoToSocialReplyApproval() {
		return this.GetGoToSocialReplyApproval()
	}
	if this.IsGoToSocialReplyAuthorization() {
		return this.GetGoToSocialReplyAuthorization()
	}
	if this.IsGoToSocialReplyRequest() {
		return this.GetGoToSocialReplyRequest()
	}
	if this.IsActivityStreamsService() {
		return this.GetActivityStreamsService()
	}
	if this.IsActivityStreamsTentativeAccept() {
		return this.GetActivityStreamsTentativeAccept()
	}
	if this.IsActivityStreamsTentativeReject() {
		return this.GetActivityStreamsTentativeReject()
	}
	if this.IsActivityStreamsTombstone() {
		return this.GetActivityStreamsTombstone()
	}
	if this.IsFunkwhaleTrack() {
		return this.GetFunkwhaleTrack()
	}
	if this.IsActivityStreamsTravel() {
		return this.GetActivityStreamsTravel()
	}
	if this.IsActivityStreamsUndo() {
		return this.GetActivityStreamsUndo()
	}
	if this.IsActivityStreamsUpdate() {
		return this.GetActivityStreamsUpdate()
	}
	if this.IsActivityStreamsVideo() {
		return this.GetActivityStreamsVideo()
	}
	if this.IsActivityStreamsView() {
		return this.GetActivityStreamsView()
	}

	return nil
}

// HasAny returns true if any of the different values is set.
func (this ActivityStreamsAudiencePropertyIterator) HasAny() bool {
	return this.IsActivityStreamsObject() ||
		this.IsActivityStreamsLink() ||
		this.IsActivityStreamsAccept() ||
		this.IsActivityStreamsActivity() ||
		this.IsActivityStreamsAdd() ||
		this.IsFunkwhaleAlbum() ||
		this.IsActivityStreamsAnnounce() ||
		this.IsGoToSocialAnnounceApproval() ||
		this.IsGoToSocialAnnounceAuthorization() ||
		this.IsGoToSocialAnnounceRequest() ||
		this.IsActivityStreamsApplication() ||
		this.IsActivityStreamsArrive() ||
		this.IsActivityStreamsArticle() ||
		this.IsFunkwhaleArtist() ||
		this.IsActivityStreamsAudio() ||
		this.IsActivityStreamsBlock() ||
		this.IsActivityStreamsCollection() ||
		this.IsActivityStreamsCollectionPage() ||
		this.IsActivityStreamsCreate() ||
		this.IsActivityStreamsDelete() ||
		this.IsActivityStreamsDislike() ||
		this.IsActivityStreamsDocument() ||
		this.IsTootEmoji() ||
		this.IsLitePubEmojiReact() ||
		this.IsActivityStreamsEvent() ||
		this.IsActivityStreamsFlag() ||
		this.IsActivityStreamsFollow() ||
		this.IsActivityStreamsGroup() ||
		this.IsTootHashtag() ||
		this.IsTootIdentityProof() ||
		this.IsActivityStreamsIgnore() ||
		this.IsActivityStreamsImage() ||
		this.IsActivityStreamsIntransitiveActivity() ||
		this.IsActivityStreamsInvite() ||
		this.IsActivityStreamsJoin() ||
		this.IsActivityStreamsLeave() ||
		this.IsFunkwhaleLibrary() ||
		this.IsActivityStreamsLike() ||
		this.IsGoToSocialLikeApproval() ||
		this.IsGoToSocialLikeAuthorization() ||
		this.IsGoToSocialLikeRequest() ||
		this.IsActivityStreamsListen() ||
		this.IsActivityStreamsMention() ||
		this.IsActivityStreamsMove() ||
		this.IsActivityStreamsNote() ||
		this.IsActivityStreamsOffer() ||
		this.IsActivityStreamsOrderedCollection() ||
		this.IsActivityStreamsOrderedCollectionPage() ||
		this.IsActivityStreamsOrganization() ||
		this.IsActivityStreamsPage() ||
		this.IsActivityStreamsPerson() ||
		this.IsActivityStreamsPlace() ||
		this.IsActivityStreamsProfile() ||
		this.IsSchemaPropertyValue() ||
		this.IsActivityStreamsQuestion() ||
		this.IsActivityStreamsRead() ||
		this.IsActivityStreamsReject() ||
		this.IsActivityStreamsRelationship() ||
		this.IsActivityStreamsRemove() ||
		this.IsGoToSocialReplyApproval() ||
		this.IsGoToSocialReplyAuthorization() ||
		this.IsGoToSocialReplyRequest() ||
		this.IsActivityStreamsService() ||
		this.IsActivityStreamsTentativeAccept() ||
		this.IsActivityStreamsTentativeReject() ||
		this.IsActivityStreamsTombstone() ||
		this.IsFunkwhaleTrack() ||
		this.IsActivityStreamsTravel() ||
		this.IsActivityStreamsUndo() ||
		this.IsActivityStreamsUpdate() ||
		this.IsActivityStreamsVideo() ||
		this.IsActivityStreamsView() ||
		this.iri != nil
}

// IsActivityStreamsAccept returns true if this property has a type of "Accept".
// When true, use the GetActivityStreamsAccept and SetActivityStreamsAccept
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsAccept() bool {
	return this.activitystreamsAcceptMember != nil
}

// IsActivityStreamsActivity returns true if this property has a type of
// "Activity". When true, use the GetActivityStreamsActivity and
// SetActivityStreamsActivity methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsActivity() bool {
	return this.activitystreamsActivityMember != nil
}

// IsActivityStreamsAdd returns true if this property has a type of "Add". When
// true, use the GetActivityStreamsAdd and SetActivityStreamsAdd methods to
// access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsAdd() bool {
	return this.activitystreamsAddMember != nil
}

// IsActivityStreamsAnnounce returns true if this property has a type of
// "Announce". When true, use the GetActivityStreamsAnnounce and
// SetActivityStreamsAnnounce methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsAnnounce() bool {
	return this.activitystreamsAnnounceMember != nil
}

// IsActivityStreamsApplication returns true if this property has a type of
// "Application". When true, use the GetActivityStreamsApplication and
// SetActivityStreamsApplication methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsApplication() bool {
	return this.activitystreamsApplicationMember != nil
}

// IsActivityStreamsArrive returns true if this property has a type of "Arrive".
// When true, use the GetActivityStreamsArrive and SetActivityStreamsArrive
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsArrive() bool {
	return this.activitystreamsArriveMember != nil
}

// IsActivityStreamsArticle returns true if this property has a type of "Article".
// When true, use the GetActivityStreamsArticle and SetActivityStreamsArticle
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsArticle() bool {
	return this.activitystreamsArticleMember != nil
}

// IsActivityStreamsAudio returns true if this property has a type of "Audio".
// When true, use the GetActivityStreamsAudio and SetActivityStreamsAudio
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsAudio() bool {
	return this.activitystreamsAudioMember != nil
}

// IsActivityStreamsBlock returns true if this property has a type of "Block".
// When true, use the GetActivityStreamsBlock and SetActivityStreamsBlock
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsBlock() bool {
	return this.activitystreamsBlockMember != nil
}

// IsActivityStreamsCollection returns true if this property has a type of
// "Collection". When true, use the GetActivityStreamsCollection and
// SetActivityStreamsCollection methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsCollection() bool {
	return this.activitystreamsCollectionMember != nil
}

// IsActivityStreamsCollectionPage returns true if this property has a type of
// "CollectionPage". When true, use the GetActivityStreamsCollectionPage and
// SetActivityStreamsCollectionPage methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsCollectionPage() bool {
	return this.activitystreamsCollectionPageMember != nil
}

// IsActivityStreamsCreate returns true if this property has a type of "Create".
// When true, use the GetActivityStreamsCreate and SetActivityStreamsCreate
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsCreate() bool {
	return this.activitystreamsCreateMember != nil
}

// IsActivityStreamsDelete returns true if this property has a type of "Delete".
// When true, use the GetActivityStreamsDelete and SetActivityStreamsDelete
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsDelete() bool {
	return this.activitystreamsDeleteMember != nil
}

// IsActivityStreamsDislike returns true if this property has a type of "Dislike".
// When true, use the GetActivityStreamsDislike and SetActivityStreamsDislike
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsDislike() bool {
	return this.activitystreamsDislikeMember != nil
}

// IsActivityStreamsDocument returns true if this property has a type of
// "Document". When true, use the GetActivityStreamsDocument and
// SetActivityStreamsDocument methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsDocument() bool {
	return this.activitystreamsDocumentMember != nil
}

// IsActivityStreamsEvent returns true if this property has a type of "Event".
// When true, use the GetActivityStreamsEvent and SetActivityStreamsEvent
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsEvent() bool {
	return this.activitystreamsEventMember != nil
}

// IsActivityStreamsFlag returns true if this property has a type of "Flag". When
// true, use the GetActivityStreamsFlag and SetActivityStreamsFlag methods to
// access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsFlag() bool {
	return this.activitystreamsFlagMember != nil
}

// IsActivityStreamsFollow returns true if this property has a type of "Follow".
// When true, use the GetActivityStreamsFollow and SetActivityStreamsFollow
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsFollow() bool {
	return this.activitystreamsFollowMember != nil
}

// IsActivityStreamsGroup returns true if this property has a type of "Group".
// When true, use the GetActivityStreamsGroup and SetActivityStreamsGroup
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsGroup() bool {
	return this.activitystreamsGroupMember != nil
}

// IsActivityStreamsIgnore returns true if this property has a type of "Ignore".
// When true, use the GetActivityStreamsIgnore and SetActivityStreamsIgnore
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsIgnore() bool {
	return this.activitystreamsIgnoreMember != nil
}

// IsActivityStreamsImage returns true if this property has a type of "Image".
// When true, use the GetActivityStreamsImage and SetActivityStreamsImage
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsImage() bool {
	return this.activitystreamsImageMember != nil
}

// IsActivityStreamsIntransitiveActivity returns true if this property has a type
// of "IntransitiveActivity". When true, use the
// GetActivityStreamsIntransitiveActivity and
// SetActivityStreamsIntransitiveActivity methods to access and set this
// property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsIntransitiveActivity() bool {
	return this.activitystreamsIntransitiveActivityMember != nil
}

// IsActivityStreamsInvite returns true if this property has a type of "Invite".
// When true, use the GetActivityStreamsInvite and SetActivityStreamsInvite
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsInvite() bool {
	return this.activitystreamsInviteMember != nil
}

// IsActivityStreamsJoin returns true if this property has a type of "Join". When
// true, use the GetActivityStreamsJoin and SetActivityStreamsJoin methods to
// access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsJoin() bool {
	return this.activitystreamsJoinMember != nil
}

// IsActivityStreamsLeave returns true if this property has a type of "Leave".
// When true, use the GetActivityStreamsLeave and SetActivityStreamsLeave
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsLeave() bool {
	return this.activitystreamsLeaveMember != nil
}

// IsActivityStreamsLike returns true if this property has a type of "Like". When
// true, use the GetActivityStreamsLike and SetActivityStreamsLike methods to
// access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsLike() bool {
	return this.activitystreamsLikeMember != nil
}

// IsActivityStreamsLink returns true if this property has a type of "Link". When
// true, use the GetActivityStreamsLink and SetActivityStreamsLink methods to
// access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsLink() bool {
	return this.activitystreamsLinkMember != nil
}

// IsActivityStreamsListen returns true if this property has a type of "Listen".
// When true, use the GetActivityStreamsListen and SetActivityStreamsListen
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsListen() bool {
	return this.activitystreamsListenMember != nil
}

// IsActivityStreamsMention returns true if this property has a type of "Mention".
// When true, use the GetActivityStreamsMention and SetActivityStreamsMention
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsMention() bool {
	return this.activitystreamsMentionMember != nil
}

// IsActivityStreamsMove returns true if this property has a type of "Move". When
// true, use the GetActivityStreamsMove and SetActivityStreamsMove methods to
// access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsMove() bool {
	return this.activitystreamsMoveMember != nil
}

// IsActivityStreamsNote returns true if this property has a type of "Note". When
// true, use the GetActivityStreamsNote and SetActivityStreamsNote methods to
// access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsNote() bool {
	return this.activitystreamsNoteMember != nil
}

// IsActivityStreamsObject returns true if this property has a type of "Object".
// When true, use the GetActivityStreamsObject and SetActivityStreamsObject
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsObject() bool {
	return this.activitystreamsObjectMember != nil
}

// IsActivityStreamsOffer returns true if this property has a type of "Offer".
// When true, use the GetActivityStreamsOffer and SetActivityStreamsOffer
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsOffer() bool {
	return this.activitystreamsOfferMember != nil
}

// IsActivityStreamsOrderedCollection returns true if this property has a type of
// "OrderedCollection". When true, use the GetActivityStreamsOrderedCollection
// and SetActivityStreamsOrderedCollection methods to access and set this
// property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsOrderedCollection() bool {
	return this.activitystreamsOrderedCollectionMember != nil
}

// IsActivityStreamsOrderedCollectionPage returns true if this property has a type
// of "OrderedCollectionPage". When true, use the
// GetActivityStreamsOrderedCollectionPage and
// SetActivityStreamsOrderedCollectionPage methods to access and set this
// property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsOrderedCollectionPage() bool {
	return this.activitystreamsOrderedCollectionPageMember != nil
}

// IsActivityStreamsOrganization returns true if this property has a type of
// "Organization". When true, use the GetActivityStreamsOrganization and
// SetActivityStreamsOrganization methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsOrganization() bool {
	return this.activitystreamsOrganizationMember != nil
}

// IsActivityStreamsPage returns true if this property has a type of "Page". When
// true, use the GetActivityStreamsPage and SetActivityStreamsPage methods to
// access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsPage() bool {
	return this.activitystreamsPageMember != nil
}

// IsActivityStreamsPerson returns true if this property has a type of "Person".
// When true, use the GetActivityStreamsPerson and SetActivityStreamsPerson
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsPerson() bool {
	return this.activitystreamsPersonMember != nil
}

// IsActivityStreamsPlace returns true if this property has a type of "Place".
// When true, use the GetActivityStreamsPlace and SetActivityStreamsPlace
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsPlace() bool {
	return this.activitystreamsPlaceMember != nil
}

// IsActivityStreamsProfile returns true if this property has a type of "Profile".
// When true, use the GetActivityStreamsProfile and SetActivityStreamsProfile
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsProfile() bool {
	return this.activitystreamsProfileMember != nil
}

// IsActivityStreamsQuestion returns true if this property has a type of
// "Question". When true, use the GetActivityStreamsQuestion and
// SetActivityStreamsQuestion methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsQuestion() bool {
	return this.activitystreamsQuestionMember != nil
}

// IsActivityStreamsRead returns true if this property has a type of "Read". When
// true, use the GetActivityStreamsRead and SetActivityStreamsRead methods to
// access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsRead() bool {
	return this.activitystreamsReadMember != nil
}

// IsActivityStreamsReject returns true if this property has a type of "Reject".
// When true, use the GetActivityStreamsReject and SetActivityStreamsReject
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsReject() bool {
	return this.activitystreamsRejectMember != nil
}

// IsActivityStreamsRelationship returns true if this property has a type of
// "Relationship". When true, use the GetActivityStreamsRelationship and
// SetActivityStreamsRelationship methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsRelationship() bool {
	return this.activitystreamsRelationshipMember != nil
}

// IsActivityStreamsRemove returns true if this property has a type of "Remove".
// When true, use the GetActivityStreamsRemove and SetActivityStreamsRemove
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsRemove() bool {
	return this.activitystreamsRemoveMember != nil
}

// IsActivityStreamsService returns true if this property has a type of "Service".
// When true, use the GetActivityStreamsService and SetActivityStreamsService
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsService() bool {
	return this.activitystreamsServiceMember != nil
}

// IsActivityStreamsTentativeAccept returns true if this property has a type of
// "TentativeAccept". When true, use the GetActivityStreamsTentativeAccept and
// SetActivityStreamsTentativeAccept methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsTentativeAccept() bool {
	return this.activitystreamsTentativeAcceptMember != nil
}

// IsActivityStreamsTentativeReject returns true if this property has a type of
// "TentativeReject". When true, use the GetActivityStreamsTentativeReject and
// SetActivityStreamsTentativeReject methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsTentativeReject() bool {
	return this.activitystreamsTentativeRejectMember != nil
}

// IsActivityStreamsTombstone returns true if this property has a type of
// "Tombstone". When true, use the GetActivityStreamsTombstone and
// SetActivityStreamsTombstone methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsTombstone() bool {
	return this.activitystreamsTombstoneMember != nil
}

// IsActivityStreamsTravel returns true if this property has a type of "Travel".
// When true, use the GetActivityStreamsTravel and SetActivityStreamsTravel
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsTravel() bool {
	return this.activitystreamsTravelMember != nil
}

// IsActivityStreamsUndo returns true if this property has a type of "Undo". When
// true, use the GetActivityStreamsUndo and SetActivityStreamsUndo methods to
// access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsUndo() bool {
	return this.activitystreamsUndoMember != nil
}

// IsActivityStreamsUpdate returns true if this property has a type of "Update".
// When true, use the GetActivityStreamsUpdate and SetActivityStreamsUpdate
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsUpdate() bool {
	return this.activitystreamsUpdateMember != nil
}

// IsActivityStreamsVideo returns true if this property has a type of "Video".
// When true, use the GetActivityStreamsVideo and SetActivityStreamsVideo
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsVideo() bool {
	return this.activitystreamsVideoMember != nil
}

// IsActivityStreamsView returns true if this property has a type of "View". When
// true, use the GetActivityStreamsView and SetActivityStreamsView methods to
// access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsActivityStreamsView() bool {
	return this.activitystreamsViewMember != nil
}

// IsFunkwhaleAlbum returns true if this property has a type of "Album". When
// true, use the GetFunkwhaleAlbum and SetFunkwhaleAlbum methods to access and
// set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsFunkwhaleAlbum() bool {
	return this.funkwhaleAlbumMember != nil
}

// IsFunkwhaleArtist returns true if this property has a type of "Artist". When
// true, use the GetFunkwhaleArtist and SetFunkwhaleArtist methods to access
// and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsFunkwhaleArtist() bool {
	return this.funkwhaleArtistMember != nil
}

// IsFunkwhaleLibrary returns true if this property has a type of "Library". When
// true, use the GetFunkwhaleLibrary and SetFunkwhaleLibrary methods to access
// and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsFunkwhaleLibrary() bool {
	return this.funkwhaleLibraryMember != nil
}

// IsFunkwhaleTrack returns true if this property has a type of "Track". When
// true, use the GetFunkwhaleTrack and SetFunkwhaleTrack methods to access and
// set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsFunkwhaleTrack() bool {
	return this.funkwhaleTrackMember != nil
}

// IsGoToSocialAnnounceApproval returns true if this property has a type of
// "AnnounceApproval". When true, use the GetGoToSocialAnnounceApproval and
// SetGoToSocialAnnounceApproval methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsGoToSocialAnnounceApproval() bool {
	return this.gotosocialAnnounceApprovalMember != nil
}

// IsGoToSocialAnnounceAuthorization returns true if this property has a type of
// "AnnounceAuthorization". When true, use the
// GetGoToSocialAnnounceAuthorization and SetGoToSocialAnnounceAuthorization
// methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsGoToSocialAnnounceAuthorization() bool {
	return this.gotosocialAnnounceAuthorizationMember != nil
}

// IsGoToSocialAnnounceRequest returns true if this property has a type of
// "AnnounceRequest". When true, use the GetGoToSocialAnnounceRequest and
// SetGoToSocialAnnounceRequest methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsGoToSocialAnnounceRequest() bool {
	return this.gotosocialAnnounceRequestMember != nil
}

// IsGoToSocialLikeApproval returns true if this property has a type of
// "LikeApproval". When true, use the GetGoToSocialLikeApproval and
// SetGoToSocialLikeApproval methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsGoToSocialLikeApproval() bool {
	return this.gotosocialLikeApprovalMember != nil
}

// IsGoToSocialLikeAuthorization returns true if this property has a type of
// "LikeAuthorization". When true, use the GetGoToSocialLikeAuthorization and
// SetGoToSocialLikeAuthorization methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsGoToSocialLikeAuthorization() bool {
	return this.gotosocialLikeAuthorizationMember != nil
}

// IsGoToSocialLikeRequest returns true if this property has a type of
// "LikeRequest". When true, use the GetGoToSocialLikeRequest and
// SetGoToSocialLikeRequest methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsGoToSocialLikeRequest() bool {
	return this.gotosocialLikeRequestMember != nil
}

// IsGoToSocialReplyApproval returns true if this property has a type of
// "ReplyApproval". When true, use the GetGoToSocialReplyApproval and
// SetGoToSocialReplyApproval methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsGoToSocialReplyApproval() bool {
	return this.gotosocialReplyApprovalMember != nil
}

// IsGoToSocialReplyAuthorization returns true if this property has a type of
// "ReplyAuthorization". When true, use the GetGoToSocialReplyAuthorization
// and SetGoToSocialReplyAuthorization methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsGoToSocialReplyAuthorization() bool {
	return this.gotosocialReplyAuthorizationMember != nil
}

// IsGoToSocialReplyRequest returns true if this property has a type of
// "ReplyRequest". When true, use the GetGoToSocialReplyRequest and
// SetGoToSocialReplyRequest methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsGoToSocialReplyRequest() bool {
	return this.gotosocialReplyRequestMember != nil
}

// IsIRI returns true if this property is an IRI. When true, use GetIRI and SetIRI
// to access and set this property
func (this ActivityStreamsAudiencePropertyIterator) IsIRI() bool {
	return this.iri != nil
}

// IsLitePubEmojiReact returns true if this property has a type of "EmojiReact".
// When true, use the GetLitePubEmojiReact and SetLitePubEmojiReact methods to
// access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsLitePubEmojiReact() bool {
	return this.litepubEmojiReactMember != nil
}

// IsSchemaPropertyValue returns true if this property has a type of
// "PropertyValue". When true, use the GetSchemaPropertyValue and
// SetSchemaPropertyValue methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsSchemaPropertyValue() bool {
	return this.schemaPropertyValueMember != nil
}

// IsTootEmoji returns true if this property has a type of "Emoji". When true, use
// the GetTootEmoji and SetTootEmoji methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsTootEmoji() bool {
	return this.tootEmojiMember != nil
}

// IsTootHashtag returns true if this property has a type of "Hashtag". When true,
// use the GetTootHashtag and SetTootHashtag methods to access and set this
// property.
func (this ActivityStreamsAudiencePropertyIterator) IsTootHashtag() bool {
	return this.tootHashtagMember != nil
}

// IsTootIdentityProof returns true if this property has a type of
// "IdentityProof". When true, use the GetTootIdentityProof and
// SetTootIdentityProof methods to access and set this property.
func (this ActivityStreamsAudiencePropertyIterator) IsTootIdentityProof() bool {
	return this.tootIdentityProofMember != nil
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// property and the specific values that are set. The value in the map is the
// alias used to import the property's value or values.
func (this ActivityStreamsAudiencePropertyIterator) JSONLDContext() map[string]string {
	m := map[string]string{"https://www.w3.org/ns/activitystreams": this.alias}
	var child map[string]string
	if this.IsActivityStreamsObject() {
		child = this.GetActivityStreamsObject().JSONLDContext()
	} else if this.IsActivityStreamsLink() {
		child = this.GetActivityStreamsLink().JSONLDContext()
	} else if this.IsActivityStreamsAccept() {
		child = this.GetActivityStreamsAccept().JSONLDContext()
	} else if this.IsActivityStreamsActivity() {
		child = this.GetActivityStreamsActivity().JSONLDContext()
	} else if this.IsActivityStreamsAdd() {
		child = this.GetActivityStreamsAdd().JSONLDContext()
	} else if this.IsFunkwhaleAlbum() {
		child = this.GetFunkwhaleAlbum().JSONLDContext()
	} else if this.IsActivityStreamsAnnounce() {
		child = this.GetActivityStreamsAnnounce().JSONLDContext()
	} else if this.IsGoToSocialAnnounceApproval() {
		child = this.GetGoToSocialAnnounceApproval().JSONLDContext()
	} else if this.IsGoToSocialAnnounceAuthorization() {
		child = this.GetGoToSocialAnnounceAuthorization().JSONLDContext()
	} else if this.IsGoToSocialAnnounceRequest() {
		child = this.GetGoToSocialAnnounceRequest().JSONLDContext()
	} else if this.IsActivityStreamsApplication() {
		child = this.GetActivityStreamsApplication().JSONLDContext()
	} else if this.IsActivityStreamsArrive() {
		child = this.GetActivityStreamsArrive().JSONLDContext()
	} else if this.IsActivityStreamsArticle() {
		child = this.GetActivityStreamsArticle().JSONLDContext()
	} else if this.IsFunkwhaleArtist() {
		child = this.GetFunkwhaleArtist().JSONLDContext()
	} else if this.IsActivityStreamsAudio() {
		child = this.GetActivityStreamsAudio().JSONLDContext()
	} else if this.IsActivityStreamsBlock() {
		child = this.GetActivityStreamsBlock().JSONLDContext()
	} else if this.IsActivityStreamsCollection() {
		child = this.GetActivityStreamsCollection().JSONLDContext()
	} else if this.IsActivityStreamsCollectionPage() {
		child = this.GetActivityStreamsCollectionPage().JSONLDContext()
	} else if this.IsActivityStreamsCreate() {
		child = this.GetActivityStreamsCreate().JSONLDContext()
	} else if this.IsActivityStreamsDelete() {
		child = this.GetActivityStreamsDelete().JSONLDContext()
	} else if this.IsActivityStreamsDislike() {
		child = this.GetActivityStreamsDislike().JSONLDContext()
	} else if this.IsActivityStreamsDocument() {
		child = this.GetActivityStreamsDocument().JSONLDContext()
	} else if this.IsTootEmoji() {
		child = this.GetTootEmoji().JSONLDContext()
	} else if this.IsLitePubEmojiReact() {
		child = this.GetLitePubEmojiReact().JSONLDContext()
	} else if this.IsActivityStreamsEvent() {
		child = this.GetActivityStreamsEvent().JSONLDContext()
	} else if this.IsActivityStreamsFlag() {
		child = this.GetActivityStreamsFlag().JSONLDContext()
	} else if this.IsActivityStreamsFollow() {
		child = this.GetActivityStreamsFollow().JSONLDContext()
	} else if this.IsActivityStreamsGroup() {
		child = this.GetActivityStreamsGroup().JSONLDContext()
	} else if this.IsTootHashtag() {
		child = this.GetTootHashtag().JSONLDContext()
	} else if this.IsTootIdentityProof() {
		child = this.GetTootIdentityProof().JSONLDContext()
	} else if this.IsActivityStreamsIgnore() {
		child = this.GetActivityStreamsIgnore().JSONLDContext()
	} else if this.IsActivityStreamsImage() {
		child = this.GetActivityStreamsImage().JSONLDContext()
	} else if this.IsActivityStreamsIntransitiveActivity() {
		child = this.GetActivityStreamsIntransitiveActivity().JSONLDContext()
	} else if this.IsActivityStreamsInvite() {
		child = this.GetActivityStreamsInvite().JSONLDContext()
	} else if this.IsActivityStreamsJoin() {
		child = this.GetActivityStreamsJoin().JSONLDContext()
	} else if this.IsActivityStreamsLeave() {
		child = this.GetActivityStreamsLeave().JSONLDContext()
	} else if this.IsFunkwhaleLibrary() {
		child = this.GetFunkwhaleLibrary().JSONLDContext()
	} else if this.IsActivityStreamsLike() {
		child = this.GetActivityStreamsLike().JSONLDContext()
	} else if this.IsGoToSocialLikeApproval() {
		child = this.GetGoToSocialLikeApproval().JSONLDContext()
	} else if this.IsGoToSocialLikeAuthorization() {
		child = this.GetGoToSocialLikeAuthorization().JSONLDContext()
	} else if this.IsGoToSocialLikeRequest() {
		child = this.GetGoToSocialLikeRequest().JSONLDContext()
	} else if this.IsActivityStreamsListen() {
		child = this.GetActivityStreamsListen().JSONLDContext()
	} else if this.IsActivityStreamsMention() {
		child = this.GetActivityStreamsMention().JSONLDContext()
	} else if this.IsActivityStreamsMove() {
		child = this.GetActivityStreamsMove().JSONLDContext()
	} else if this.IsActivityStreamsNote() {
		child = this.GetActivityStreamsNote().JSONLDContext()
	} else if this.IsActivityStreamsOffer() {
		child = this.GetActivityStreamsOffer().JSONLDContext()
	} else if this.IsActivityStreamsOrderedCollection() {
		child = this.GetActivityStreamsOrderedCollection().JSONLDContext()
	} else if this.IsActivityStreamsOrderedCollectionPage() {
		child = this.GetActivityStreamsOrderedCollectionPage().JSONLDContext()
	} else if this.IsActivityStreamsOrganization() {
		child = this.GetActivityStreamsOrganization().JSONLDContext()
	} else if this.IsActivityStreamsPage() {
		child = this.GetActivityStreamsPage().JSONLDContext()
	} else if this.IsActivityStreamsPerson() {
		child = this.GetActivityStreamsPerson().JSONLDContext()
	} else if this.IsActivityStreamsPlace() {
		child = this.GetActivityStreamsPlace().JSONLDContext()
	} else if this.IsActivityStreamsProfile() {
		child = this.GetActivityStreamsProfile().JSONLDContext()
	} else if this.IsSchemaPropertyValue() {
		child = this.GetSchemaPropertyValue().JSONLDContext()
	} else if this.IsActivityStreamsQuestion() {
		child = this.GetActivityStreamsQuestion().JSONLDContext()
	} else if this.IsActivityStreamsRead() {
		child = this.GetActivityStreamsRead().JSONLDContext()
	} else if this.IsActivityStreamsReject() {
		child = this.GetActivityStreamsReject().JSONLDContext()
	} else if this.IsActivityStreamsRelationship() {
		child = this.GetActivityStreamsRelationship().JSONLDContext()
	} else if this.IsActivityStreamsRemove() {
		child = this.GetActivityStreamsRemove().JSONLDContext()
	} else if this.IsGoToSocialReplyApproval() {
		child = this.GetGoToSocialReplyApproval().JSONLDContext()
	} else if this.IsGoToSocialReplyAuthorization() {
		child = this.GetGoToSocialReplyAuthorization().JSONLDContext()
	} else if this.IsGoToSocialReplyRequest() {
		child = this.GetGoToSocialReplyRequest().JSONLDContext()
	} else if this.IsActivityStreamsService() {
		child = this.GetActivityStreamsService().JSONLDContext()
	} else if this.IsActivityStreamsTentativeAccept() {
		child = this.GetActivityStreamsTentativeAccept().JSONLDContext()
	} else if this.IsActivityStreamsTentativeReject() {
		child = this.GetActivityStreamsTentativeReject().JSONLDContext()
	} else if this.IsActivityStreamsTombstone() {
		child = this.GetActivityStreamsTombstone().JSONLDContext()
	} else if this.IsFunkwhaleTrack() {
		child = this.GetFunkwhaleTrack().JSONLDContext()
	} else if this.IsActivityStreamsTravel() {
		child = this.GetActivityStreamsTravel().JSONLDContext()
	} else if this.IsActivityStreamsUndo() {
		child = this.GetActivityStreamsUndo().JSONLDContext()
	} else if this.IsActivityStreamsUpdate() {
		child = this.GetActivityStreamsUpdate().JSONLDContext()
	} else if this.IsActivityStreamsVideo() {
		child = this.GetActivityStreamsVideo().JSONLDContext()
	} else if this.IsActivityStreamsView() {
		child = this.GetActivityStreamsView().JSONLDContext()
	}
	/*
	   Since the literal maps in this function are determined at
	   code-generation time, this loop should not overwrite an existing key with a
	   new value.
	*/
	for k, v := range child {
		m[k] = v
	}
	return m
}

// KindIndex computes an arbitrary value for indexing this kind of value. This is
// a leaky API detail only for folks looking to replace the go-fed
// implementation. Applications should not use this method.
func (this ActivityStreamsAudiencePropertyIterator) KindIndex() int {
	if this.IsActivityStreamsObject() {
		return 0
	}
	if this.IsActivityStreamsLink() {
		return 1
	}
	if this.IsActivityStreamsAccept() {
		return 2
	}
	if this.IsActivityStreamsActivity() {
		return 3
	}
	if this.IsActivityStreamsAdd() {
		return 4
	}
	if this.IsFunkwhaleAlbum() {
		return 5
	}
	if this.IsActivityStreamsAnnounce() {
		return 6
	}
	if this.IsGoToSocialAnnounceApproval() {
		return 7
	}
	if this.IsGoToSocialAnnounceAuthorization() {
		return 8
	}
	if this.IsGoToSocialAnnounceRequest() {
		return 9
	}
	if this.IsActivityStreamsApplication() {
		return 10
	}
	if this.IsActivityStreamsArrive() {
		return 11
	}
	if this.IsActivityStreamsArticle() {
		return 12
	}
	if this.IsFunkwhaleArtist() {
		return 13
	}
	if this.IsActivityStreamsAudio() {
		return 14
	}
	if this.IsActivityStreamsBlock() {
		return 15
	}
	if this.IsActivityStreamsCollection() {
		return 16
	}
	if this.IsActivityStreamsCollectionPage() {
		return 17
	}
	if this.IsActivityStreamsCreate() {
		return 18
	}
	if this.IsActivityStreamsDelete() {
		return 19
	}
	if this.IsActivityStreamsDislike() {
		return 20
	}
	if this.IsActivityStreamsDocument() {
		return 21
	}
	if this.IsTootEmoji() {
		return 22
	}
	if this.IsLitePubEmojiReact() {
		return 23
	}
	if this.IsActivityStreamsEvent() {
		return 24
	}
	if this.IsActivityStreamsFlag() {
		return 25
	}
	if this.IsActivityStreamsFollow() {
		return 26
	}
	if this.IsActivityStreamsGroup() {
		return 27
	}
	if this.IsTootHashtag() {
		return 28
	}
	if this.IsTootIdentityProof() {
		return 29
	}
	if this.IsActivityStreamsIgnore() {
		return 30
	}
	if this.IsActivityStreamsImage() {
		return 31
	}
	if this.IsActivityStreamsIntransitiveActivity() {
		return 32
	}
	if this.IsActivityStreamsInvite() {
		return 33
	}
	if this.IsActivityStreamsJoin() {
		return 34
	}
	if this.IsActivityStreamsLeave() {
		return 35
	}
	if this.IsFunkwhaleLibrary() {
		return 36
	}
	if this.IsActivityStreamsLike() {
		return 37
	}
	if this.IsGoToSocialLikeApproval() {
		return 38
	}
	if this.IsGoToSocialLikeAuthorization() {
		return 39
	}
	if this.IsGoToSocialLikeRequest() {
		return 40
	}
	if this.IsActivityStreamsListen() {
		return 41
	}
	if this.IsActivityStreamsMention() {
		return 42
	}
	if this.IsActivityStreamsMove() {
		return 43
	}
	if this.IsActivityStreamsNote() {
		return 44
	}
	if this.IsActivityStreamsOffer() {
		return 45
	}
	if this.IsActivityStreamsOrderedCollection() {
		return 46
	}
	if this.IsActivityStreamsOrderedCollectionPage() {
		return 47
	}
	if this.IsActivityStreamsOrganization() {
		return 48
	}
	if this.IsActivityStreamsPage() {
		return 49
	}
	if this.IsActivityStreamsPerson() {
		return 50
	}
	if this.IsActivityStreamsPlace() {
		return 51
	}
	if this.IsActivityStreamsProfile() {
		return 52
	}
	if this.IsSchemaPropertyValue() {
		return 53
	}
	if this.IsActivityStreamsQuestion() {
		return 54
	}
	if this.IsActivityStreamsRead() {
		return 55
	}
	if this.IsActivityStreamsReject() {
		return 56
	}
	if this.IsActivityStreamsRelationship() {
		return 57
	}
	if this.IsActivityStreamsRemove() {
		return 58
	}
	if this.IsGoToSocialReplyApproval() {
		return 59
	}
	if this.IsGoToSocialReplyAuthorization() {
		return 60
	}
	if this.IsGoToSocialReplyRequest() {
		return 61
	}
	if this.IsActivityStreamsService() {
		return 62
	}
	if this.IsActivityStreamsTentativeAccept() {
		return 63
	}
	if this.IsActivityStreamsTentativeReject() {
		return 64
	}
	if this.IsActivityStreamsTombstone() {
		return 65
	}
	if this.IsFunkwhaleTrack() {
		return 66
	}
	if this.IsActivityStreamsTravel() {
		return 67
	}
	if this.IsActivityStreamsUndo() {
		return 68
	}
	if this.IsActivityStreamsUpdate() {
		return 69
	}
	if this.IsActivityStreamsVideo() {
		return 70
	}
	if this.IsActivityStreamsView() {
		return 71
	}
	if this.IsIRI() {
		return -2
	}
	return -1
}

// LessThan compares two instances of this property with an arbitrary but stable
// comparison. Applications should not use this because it is only meant to
// help alternative implementations to go-fed to be able to normalize
// nonfunctional properties.
func (this ActivityStreamsAudiencePropertyIterator) LessThan(o vocab.ActivityStreamsAudiencePropertyIterator) bool {
	idx1 := this.KindIndex()
	idx2 := o.KindIndex()
	if idx1 < idx2 {
		return true
	} else if idx1 > idx2 {
		return false
	} else if this.IsActivityStreamsObject() {
		return this.GetActivityStreamsObject().LessThan(o.GetActivityStreamsObject())
	} else if this.IsActivityStreamsLink() {
		return this.GetActivityStreamsLink().LessThan(o.GetActivityStreamsLink())
	} else if this.IsActivityStreamsAccept() {
		return this.GetActivityStreamsAccept().LessThan(o.GetActivityStreamsAccept())
	} else if this.IsActivityStreamsActivity() {
		return this.GetActivityStreamsActivity().LessThan(o.GetActivityStreamsActivity())
	} else if this.IsActivityStreamsAdd() {
		return this.GetActivityStreamsAdd().LessThan(o.GetActivityStreamsAdd())
	} else if this.IsFunkwhaleAlbum() {
		return this.GetFunkwhaleAlbum().LessThan(o.GetFunkwhaleAlbum())
	} else if this.IsActivityStreamsAnnounce() {
		return this.GetActivityStreamsAnnounce().LessThan(o.GetActivityStreamsAnnounce())
	} else if this.IsGoToSocialAnnounceApproval() {
		return this.GetGoToSocialAnnounceApproval().LessThan(o.GetGoToSocialAnnounceApproval())
	} else if this.IsGoToSocialAnnounceAuthorization() {
		return this.GetGoToSocialAnnounceAuthorization().LessThan(o.GetGoToSocialAnnounceAuthorization())
	} else if this.IsGoToSocialAnnounceRequest() {
		return this.GetGoToSocialAnnounceRequest().LessThan(o.GetGoToSocialAnnounceRequest())
	} else if this.IsActivityStreamsApplication() {
		return this.GetActivityStreamsApplication().LessThan(o.GetActivityStreamsApplication())
	} else if this.IsActivityStreamsArrive() {
		return this.GetActivityStreamsArrive().LessThan(o.GetActivityStreamsArrive())
	} else if this.IsActivityStreamsArticle() {
		return this.GetActivityStreamsArticle().LessThan(o.GetActivityStreamsArticle())
	} else if this.IsFunkwhaleArtist() {
		return this.GetFunkwhaleArtist().LessThan(o.GetFunkwhaleArtist())
	} else if this.IsActivityStreamsAudio() {
		return this.GetActivityStreamsAudio().LessThan(o.GetActivityStreamsAudio())
	} else if this.IsActivityStreamsBlock() {
		return this.GetActivityStreamsBlock().LessThan(o.GetActivityStreamsBlock())
	} else if this.IsActivityStreamsCollection() {
		return this.GetActivityStreamsCollection().LessThan(o.GetActivityStreamsCollection())
	} else if this.IsActivityStreamsCollectionPage() {
		return this.GetActivityStreamsCollectionPage().LessThan(o.GetActivityStreamsCollectionPage())
	} else if this.IsActivityStreamsCreate() {
		return this.GetActivityStreamsCreate().LessThan(o.GetActivityStreamsCreate())
	} else if this.IsActivityStreamsDelete() {
		return this.GetActivityStreamsDelete().LessThan(o.GetActivityStreamsDelete())
	} else if this.IsActivityStreamsDislike() {
		return this.GetActivityStreamsDislike().LessThan(o.GetActivityStreamsDislike())
	} else if this.IsActivityStreamsDocument() {
		return this.GetActivityStreamsDocument().LessThan(o.GetActivityStreamsDocument())
	} else if this.IsTootEmoji() {
		return this.GetTootEmoji().LessThan(o.GetTootEmoji())
	} else if this.IsLitePubEmojiReact() {
		return this.GetLitePubEmojiReact().LessThan(o.GetLitePubEmojiReact())
	} else if this.IsActivityStreamsEvent() {
		return this.GetActivityStreamsEvent().LessThan(o.GetActivityStreamsEvent())
	} else if this.IsActivityStreamsFlag() {
		return this.GetActivityStreamsFlag().LessThan(o.GetActivityStreamsFlag())
	} else if this.IsActivityStreamsFollow() {
		return this.GetActivityStreamsFollow().LessThan(o.GetActivityStreamsFollow())
	} else if this.IsActivityStreamsGroup() {
		return this.GetActivityStreamsGroup().LessThan(o.GetActivityStreamsGroup())
	} else if this.IsTootHashtag() {
		return this.GetTootHashtag().LessThan(o.GetTootHashtag())
	} else if this.IsTootIdentityProof() {
		return this.GetTootIdentityProof().LessThan(o.GetTootIdentityProof())
	} else if this.IsActivityStreamsIgnore() {
		return this.GetActivityStreamsIgnore().LessThan(o.GetActivityStreamsIgnore())
	} else if this.IsActivityStreamsImage() {
		return this.GetActivityStreamsImage().LessThan(o.GetActivityStreamsImage())
	} else if this.IsActivityStreamsIntransitiveActivity() {
		return this.GetActivityStreamsIntransitiveActivity().LessThan(o.GetActivityStreamsIntransitiveActivity())
	} else if this.IsActivityStreamsInvite() {
		return this.GetActivityStreamsInvite().LessThan(o.GetActivityStreamsInvite())
	} else if this.IsActivityStreamsJoin() {
		return this.GetActivityStreamsJoin().LessThan(o.GetActivityStreamsJoin())
	} else if this.IsActivityStreamsLeave() {
		return this.GetActivityStreamsLeave().LessThan(o.GetActivityStreamsLeave())
	} else if this.IsFunkwhaleLibrary() {
		return this.GetFunkwhaleLibrary().LessThan(o.GetFunkwhaleLibrary())
	} else if this.IsActivityStreamsLike() {
		return this.GetActivityStreamsLike().LessThan(o.GetActivityStreamsLike())
	} else if this.IsGoToSocialLikeApproval() {
		return this.GetGoToSocialLikeApproval().LessThan(o.GetGoToSocialLikeApproval())
	} else if this.IsGoToSocialLikeAuthorization() {
		return this.GetGoToSocialLikeAuthorization().LessThan(o.GetGoToSocialLikeAuthorization())
	} else if this.IsGoToSocialLikeRequest() {
		return this.GetGoToSocialLikeRequest().LessThan(o.GetGoToSocialLikeRequest())
	} else if this.IsActivityStreamsListen() {
		return this.GetActivityStreamsListen().LessThan(o.GetActivityStreamsListen())
	} else if this.IsActivityStreamsMention() {
		return this.GetActivityStreamsMention().LessThan(o.GetActivityStreamsMention())
	} else if this.IsActivityStreamsMove() {
		return this.GetActivityStreamsMove().LessThan(o.GetActivityStreamsMove())
	} else if this.IsActivityStreamsNote() {
		return this.GetActivityStreamsNote().LessThan(o.GetActivityStreamsNote())
	} else if this.IsActivityStreamsOffer() {
		return this.GetActivityStreamsOffer().LessThan(o.GetActivityStreamsOffer())
	} else if this.IsActivityStreamsOrderedCollection() {
		return this.GetActivityStreamsOrderedCollection().LessThan(o.GetActivityStreamsOrderedCollection())
	} else if this.IsActivityStreamsOrderedCollectionPage() {
		return this.GetActivityStreamsOrderedCollectionPage().LessThan(o.GetActivityStreamsOrderedCollectionPage())
	} else if this.IsActivityStreamsOrganization() {
		return this.GetActivityStreamsOrganization().LessThan(o.GetActivityStreamsOrganization())
	} else if this.IsActivityStreamsPage() {
		return this.GetActivityStreamsPage().LessThan(o.GetActivityStreamsPage())
	} else if this.IsActivityStreamsPerson() {
		return this.GetActivityStreamsPerson().LessThan(o.GetActivityStreamsPerson())
	} else if this.IsActivityStreamsPlace() {
		return this.GetActivityStreamsPlace().LessThan(o.GetActivityStreamsPlace())
	} else if this.IsActivityStreamsProfile() {
		return this.GetActivityStreamsProfile().LessThan(o.GetActivityStreamsProfile())
	} else if this.IsSchemaPropertyValue() {
		return this.GetSchemaPropertyValue().LessThan(o.GetSchemaPropertyValue())
	} else if this.IsActivityStreamsQuestion() {
		return this.GetActivityStreamsQuestion().LessThan(o.GetActivityStreamsQuestion())
	} else if this.IsActivityStreamsRead() {
		return this.GetActivityStreamsRead().LessThan(o.GetActivityStreamsRead())
	} else if this.IsActivityStreamsReject() {
		return this.GetActivityStreamsReject().LessThan(o.GetActivityStreamsReject())
	} else if this.IsActivityStreamsRelationship() {
		return this.GetActivityStreamsRelationship().LessThan(o.GetActivityStreamsRelationship())
	} else if this.IsActivityStreamsRemove() {
		return this.GetActivityStreamsRemove().LessThan(o.GetActivityStreamsRemove())
	} else if this.IsGoToSocialReplyApproval() {
		return this.GetGoToSocialReplyApproval().LessThan(o.GetGoToSocialReplyApproval())
	} else if this.IsGoToSocialReplyAuthorization() {
		return this.GetGoToSocialReplyAuthorization().LessThan(o.GetGoToSocialReplyAuthorization())
	} else if this.IsGoToSocialReplyRequest() {
		return this.GetGoToSocialReplyRequest().LessThan(o.GetGoToSocialReplyRequest())
	} else if this.IsActivityStreamsService() {
		return this.GetActivityStreamsService().LessThan(o.GetActivityStreamsService())
	} else if this.IsActivityStreamsTentativeAccept() {
		return this.GetActivityStreamsTentativeAccept().LessThan(o.GetActivityStreamsTentativeAccept())
	} else if this.IsActivityStreamsTentativeReject() {
		return this.GetActivityStreamsTentativeReject().LessThan(o.GetActivityStreamsTentativeReject())
	} else if this.IsActivityStreamsTombstone() {
		return this.GetActivityStreamsTombstone().LessThan(o.GetActivityStreamsTombstone())
	} else if this.IsFunkwhaleTrack() {
		return this.GetFunkwhaleTrack().LessThan(o.GetFunkwhaleTrack())
	} else if this.IsActivityStreamsTravel() {
		return this.GetActivityStreamsTravel().LessThan(o.GetActivityStreamsTravel())
	} else if this.IsActivityStreamsUndo() {
		return this.GetActivityStreamsUndo().LessThan(o.GetActivityStreamsUndo())
	} else if this.IsActivityStreamsUpdate() {
		return this.GetActivityStreamsUpdate().LessThan(o.GetActivityStreamsUpdate())
	} else if this.IsActivityStreamsVideo() {
		return this.GetActivityStreamsVideo().LessThan(o.GetActivityStreamsVideo())
	} else if this.IsActivityStreamsView() {
		return this.GetActivityStreamsView().LessThan(o.GetActivityStreamsView())
	} else if this.IsIRI() {
		return this.iri.String() < o.GetIRI().String()
	}
	return false
}

// Name returns the name of this property: "ActivityStreamsAudience".
func (this ActivityStreamsAudiencePropertyIterator) Name() string {
	if len(this.alias) > 0 {
		return this.alias + ":" + "ActivityStreamsAudience"
	} else {
		return "ActivityStreamsAudience"
	}
}

// Next returns the next iterator, or nil if there is no next iterator.
func (this ActivityStreamsAudiencePropertyIterator) Next() vocab.ActivityStreamsAudiencePropertyIterator {
	if this.myIdx+1 >= this.parent.Len() {
		return nil
	} else {
		return this.parent.At(this.myIdx + 1)
	}
}

// Prev returns the previous iterator, or nil if there is no previous iterator.
func (this ActivityStreamsAudiencePropertyIterator) Prev() vocab.ActivityStreamsAudiencePropertyIterator {
	if this.myIdx-1 < 0 {
		return nil
	} else {
		return this.parent.At(this.myIdx - 1)
	}
}

// SetActivityStreamsAccept sets the value of this property. Calling
// IsActivityStreamsAccept afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsAccept(v vocab.ActivityStreamsAccept) {
	this.clear()
	this.activitystreamsAcceptMember = v
}

// SetActivityStreamsActivity sets the value of this property. Calling
// IsActivityStreamsActivity afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsActivity(v vocab.ActivityStreamsActivity) {
	this.clear()
	this.activitystreamsActivityMember = v
}

// SetActivityStreamsAdd sets the value of this property. Calling
// IsActivityStreamsAdd afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsAdd(v vocab.ActivityStreamsAdd) {
	this.clear()
	this.activitystreamsAddMember = v
}

// SetActivityStreamsAnnounce sets the value of this property. Calling
// IsActivityStreamsAnnounce afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsAnnounce(v vocab.ActivityStreamsAnnounce) {
	this.clear()
	this.activitystreamsAnnounceMember = v
}

// SetActivityStreamsApplication sets the value of this property. Calling
// IsActivityStreamsApplication afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsApplication(v vocab.ActivityStreamsApplication) {
	this.clear()
	this.activitystreamsApplicationMember = v
}

// SetActivityStreamsArrive sets the value of this property. Calling
// IsActivityStreamsArrive afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsArrive(v vocab.ActivityStreamsArrive) {
	this.clear()
	this.activitystreamsArriveMember = v
}

// SetActivityStreamsArticle sets the value of this property. Calling
// IsActivityStreamsArticle afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsArticle(v vocab.ActivityStreamsArticle) {
	this.clear()
	this.activitystreamsArticleMember = v
}

// SetActivityStreamsAudio sets the value of this property. Calling
// IsActivityStreamsAudio afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsAudio(v vocab.ActivityStreamsAudio) {
	this.clear()
	this.activitystreamsAudioMember = v
}

// SetActivityStreamsBlock sets the value of this property. Calling
// IsActivityStreamsBlock afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsBlock(v vocab.ActivityStreamsBlock) {
	this.clear()
	this.activitystreamsBlockMember = v
}

// SetActivityStreamsCollection sets the value of this property. Calling
// IsActivityStreamsCollection afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsCollection(v vocab.ActivityStreamsCollection) {
	this.clear()
	this.activitystreamsCollectionMember = v
}

// SetActivityStreamsCollectionPage sets the value of this property. Calling
// IsActivityStreamsCollectionPage afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsCollectionPage(v vocab.ActivityStreamsCollectionPage) {
	this.clear()
	this.activitystreamsCollectionPageMember = v
}

// SetActivityStreamsCreate sets the value of this property. Calling
// IsActivityStreamsCreate afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsCreate(v vocab.ActivityStreamsCreate) {
	this.clear()
	this.activitystreamsCreateMember = v
}

// SetActivityStreamsDelete sets the value of this property. Calling
// IsActivityStreamsDelete afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsDelete(v vocab.ActivityStreamsDelete) {
	this.clear()
	this.activitystreamsDeleteMember = v
}

// SetActivityStreamsDislike sets the value of this property. Calling
// IsActivityStreamsDislike afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsDislike(v vocab.ActivityStreamsDislike) {
	this.clear()
	this.activitystreamsDislikeMember = v
}

// SetActivityStreamsDocument sets the value of this property. Calling
// IsActivityStreamsDocument afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsDocument(v vocab.ActivityStreamsDocument) {
	this.clear()
	this.activitystreamsDocumentMember = v
}

// SetActivityStreamsEvent sets the value of this property. Calling
// IsActivityStreamsEvent afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsEvent(v vocab.ActivityStreamsEvent) {
	this.clear()
	this.activitystreamsEventMember = v
}

// SetActivityStreamsFlag sets the value of this property. Calling
// IsActivityStreamsFlag afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsFlag(v vocab.ActivityStreamsFlag) {
	this.clear()
	this.activitystreamsFlagMember = v
}

// SetActivityStreamsFollow sets the value of this property. Calling
// IsActivityStreamsFollow afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsFollow(v vocab.ActivityStreamsFollow) {
	this.clear()
	this.activitystreamsFollowMember = v
}

// SetActivityStreamsGroup sets the value of this property. Calling
// IsActivityStreamsGroup afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsGroup(v vocab.ActivityStreamsGroup) {
	this.clear()
	this.activitystreamsGroupMember = v
}

// SetActivityStreamsIgnore sets the value of this property. Calling
// IsActivityStreamsIgnore afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsIgnore(v vocab.ActivityStreamsIgnore) {
	this.clear()
	this.activitystreamsIgnoreMember = v
}

// SetActivityStreamsImage sets the value of this property. Calling
// IsActivityStreamsImage afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsImage(v vocab.ActivityStreamsImage) {
	this.clear()
	this.activitystreamsImageMember = v
}

// SetActivityStreamsIntransitiveActivity sets the value of this property. Calling
// IsActivityStreamsIntransitiveActivity afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsIntransitiveActivity(v vocab.ActivityStreamsIntransitiveActivity) {
	this.clear()
	this.activitystreamsIntransitiveActivityMember = v
}

// SetActivityStreamsInvite sets the value of this property. Calling
// IsActivityStreamsInvite afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsInvite(v vocab.ActivityStreamsInvite) {
	this.clear()
	this.activitystreamsInviteMember = v
}

// SetActivityStreamsJoin sets the value of this property. Calling
// IsActivityStreamsJoin afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsJoin(v vocab.ActivityStreamsJoin) {
	this.clear()
	this.activitystreamsJoinMember = v
}

// SetActivityStreamsLeave sets the value of this property. Calling
// IsActivityStreamsLeave afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsLeave(v vocab.ActivityStreamsLeave) {
	this.clear()
	this.activitystreamsLeaveMember = v
}

// SetActivityStreamsLike sets the value of this property. Calling
// IsActivityStreamsLike afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsLike(v vocab.ActivityStreamsLike) {
	this.clear()
	this.activitystreamsLikeMember = v
}

// SetActivityStreamsLink sets the value of this property. Calling
// IsActivityStreamsLink afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsLink(v vocab.ActivityStreamsLink) {
	this.clear()
	this.activitystreamsLinkMember = v
}

// SetActivityStreamsListen sets the value of this property. Calling
// IsActivityStreamsListen afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsListen(v vocab.ActivityStreamsListen) {
	this.clear()
	this.activitystreamsListenMember = v
}

// SetActivityStreamsMention sets the value of this property. Calling
// IsActivityStreamsMention afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsMention(v vocab.ActivityStreamsMention) {
	this.clear()
	this.activitystreamsMentionMember = v
}

// SetActivityStreamsMove sets the value of this property. Calling
// IsActivityStreamsMove afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsMove(v vocab.ActivityStreamsMove) {
	this.clear()
	this.activitystreamsMoveMember = v
}

// SetActivityStreamsNote sets the value of this property. Calling
// IsActivityStreamsNote afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsNote(v vocab.ActivityStreamsNote) {
	this.clear()
	this.activitystreamsNoteMember = v
}

// SetActivityStreamsObject sets the value of this property. Calling
// IsActivityStreamsObject afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsObject(v vocab.ActivityStreamsObject) {
	this.clear()
	this.activitystreamsObjectMember = v
}

// SetActivityStreamsOffer sets the value of this property. Calling
// IsActivityStreamsOffer afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsOffer(v vocab.ActivityStreamsOffer) {
	this.clear()
	this.activitystreamsOfferMember = v
}

// SetActivityStreamsOrderedCollection sets the value of this property. Calling
// IsActivityStreamsOrderedCollection afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsOrderedCollection(v vocab.ActivityStreamsOrderedCollection) {
	this.clear()
	this.activitystreamsOrderedCollectionMember = v
}

// SetActivityStreamsOrderedCollectionPage sets the value of this property.
// Calling IsActivityStreamsOrderedCollectionPage afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsOrderedCollectionPage(v vocab.ActivityStreamsOrderedCollectionPage) {
	this.clear()
	this.activitystreamsOrderedCollectionPageMember = v
}

// SetActivityStreamsOrganization sets the value of this property. Calling
// IsActivityStreamsOrganization afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsOrganization(v vocab.ActivityStreamsOrganization) {
	this.clear()
	this.activitystreamsOrganizationMember = v
}

// SetActivityStreamsPage sets the value of this property. Calling
// IsActivityStreamsPage afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsPage(v vocab.ActivityStreamsPage) {
	this.clear()
	this.activitystreamsPageMember = v
}

// SetActivityStreamsPerson sets the value of this property. Calling
// IsActivityStreamsPerson afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsPerson(v vocab.ActivityStreamsPerson) {
	this.clear()
	this.activitystreamsPersonMember = v
}

// SetActivityStreamsPlace sets the value of this property. Calling
// IsActivityStreamsPlace afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsPlace(v vocab.ActivityStreamsPlace) {
	this.clear()
	this.activitystreamsPlaceMember = v
}

// SetActivityStreamsProfile sets the value of this property. Calling
// IsActivityStreamsProfile afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsProfile(v vocab.ActivityStreamsProfile) {
	this.clear()
	this.activitystreamsProfileMember = v
}

// SetActivityStreamsQuestion sets the value of this property. Calling
// IsActivityStreamsQuestion afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsQuestion(v vocab.ActivityStreamsQuestion) {
	this.clear()
	this.activitystreamsQuestionMember = v
}

// SetActivityStreamsRead sets the value of this property. Calling
// IsActivityStreamsRead afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsRead(v vocab.ActivityStreamsRead) {
	this.clear()
	this.activitystreamsReadMember = v
}

// SetActivityStreamsReject sets the value of this property. Calling
// IsActivityStreamsReject afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsReject(v vocab.ActivityStreamsReject) {
	this.clear()
	this.activitystreamsRejectMember = v
}

// SetActivityStreamsRelationship sets the value of this property. Calling
// IsActivityStreamsRelationship afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsRelationship(v vocab.ActivityStreamsRelationship) {
	this.clear()
	this.activitystreamsRelationshipMember = v
}

// SetActivityStreamsRemove sets the value of this property. Calling
// IsActivityStreamsRemove afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsRemove(v vocab.ActivityStreamsRemove) {
	this.clear()
	this.activitystreamsRemoveMember = v
}

// SetActivityStreamsService sets the value of this property. Calling
// IsActivityStreamsService afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsService(v vocab.ActivityStreamsService) {
	this.clear()
	this.activitystreamsServiceMember = v
}

// SetActivityStreamsTentativeAccept sets the value of this property. Calling
// IsActivityStreamsTentativeAccept afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsTentativeAccept(v vocab.ActivityStreamsTentativeAccept) {
	this.clear()
	this.activitystreamsTentativeAcceptMember = v
}

// SetActivityStreamsTentativeReject sets the value of this property. Calling
// IsActivityStreamsTentativeReject afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsTentativeReject(v vocab.ActivityStreamsTentativeReject) {
	this.clear()
	this.activitystreamsTentativeRejectMember = v
}

// SetActivityStreamsTombstone sets the value of this property. Calling
// IsActivityStreamsTombstone afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsTombstone(v vocab.ActivityStreamsTombstone) {
	this.clear()
	this.activitystreamsTombstoneMember = v
}

// SetActivityStreamsTravel sets the value of this property. Calling
// IsActivityStreamsTravel afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsTravel(v vocab.ActivityStreamsTravel) {
	this.clear()
	this.activitystreamsTravelMember = v
}

// SetActivityStreamsUndo sets the value of this property. Calling
// IsActivityStreamsUndo afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsUndo(v vocab.ActivityStreamsUndo) {
	this.clear()
	this.activitystreamsUndoMember = v
}

// SetActivityStreamsUpdate sets the value of this property. Calling
// IsActivityStreamsUpdate afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsUpdate(v vocab.ActivityStreamsUpdate) {
	this.clear()
	this.activitystreamsUpdateMember = v
}

// SetActivityStreamsVideo sets the value of this property. Calling
// IsActivityStreamsVideo afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsVideo(v vocab.ActivityStreamsVideo) {
	this.clear()
	this.activitystreamsVideoMember = v
}

// SetActivityStreamsView sets the value of this property. Calling
// IsActivityStreamsView afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetActivityStreamsView(v vocab.ActivityStreamsView) {
	this.clear()
	this.activitystreamsViewMember = v
}

// SetFunkwhaleAlbum sets the value of this property. Calling IsFunkwhaleAlbum
// afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetFunkwhaleAlbum(v vocab.FunkwhaleAlbum) {
	this.clear()
	this.funkwhaleAlbumMember = v
}

// SetFunkwhaleArtist sets the value of this property. Calling IsFunkwhaleArtist
// afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetFunkwhaleArtist(v vocab.FunkwhaleArtist) {
	this.clear()
	this.funkwhaleArtistMember = v
}

// SetFunkwhaleLibrary sets the value of this property. Calling IsFunkwhaleLibrary
// afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetFunkwhaleLibrary(v vocab.FunkwhaleLibrary) {
	this.clear()
	this.funkwhaleLibraryMember = v
}

// SetFunkwhaleTrack sets the value of this property. Calling IsFunkwhaleTrack
// afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetFunkwhaleTrack(v vocab.FunkwhaleTrack) {
	this.clear()
	this.funkwhaleTrackMember = v
}

// SetGoToSocialAnnounceApproval sets the value of this property. Calling
// IsGoToSocialAnnounceApproval afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetGoToSocialAnnounceApproval(v vocab.GoToSocialAnnounceApproval) {
	this.clear()
	this.gotosocialAnnounceApprovalMember = v
}

// SetGoToSocialAnnounceAuthorization sets the value of this property. Calling
// IsGoToSocialAnnounceAuthorization afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetGoToSocialAnnounceAuthorization(v vocab.GoToSocialAnnounceAuthorization) {
	this.clear()
	this.gotosocialAnnounceAuthorizationMember = v
}

// SetGoToSocialAnnounceRequest sets the value of this property. Calling
// IsGoToSocialAnnounceRequest afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetGoToSocialAnnounceRequest(v vocab.GoToSocialAnnounceRequest) {
	this.clear()
	this.gotosocialAnnounceRequestMember = v
}

// SetGoToSocialLikeApproval sets the value of this property. Calling
// IsGoToSocialLikeApproval afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetGoToSocialLikeApproval(v vocab.GoToSocialLikeApproval) {
	this.clear()
	this.gotosocialLikeApprovalMember = v
}

// SetGoToSocialLikeAuthorization sets the value of this property. Calling
// IsGoToSocialLikeAuthorization afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetGoToSocialLikeAuthorization(v vocab.GoToSocialLikeAuthorization) {
	this.clear()
	this.gotosocialLikeAuthorizationMember = v
}

// SetGoToSocialLikeRequest sets the value of this property. Calling
// IsGoToSocialLikeRequest afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetGoToSocialLikeRequest(v vocab.GoToSocialLikeRequest) {
	this.clear()
	this.gotosocialLikeRequestMember = v
}

// SetGoToSocialReplyApproval sets the value of this property. Calling
// IsGoToSocialReplyApproval afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetGoToSocialReplyApproval(v vocab.GoToSocialReplyApproval) {
	this.clear()
	this.gotosocialReplyApprovalMember = v
}

// SetGoToSocialReplyAuthorization sets the value of this property. Calling
// IsGoToSocialReplyAuthorization afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetGoToSocialReplyAuthorization(v vocab.GoToSocialReplyAuthorization) {
	this.clear()
	this.gotosocialReplyAuthorizationMember = v
}

// SetGoToSocialReplyRequest sets the value of this property. Calling
// IsGoToSocialReplyRequest afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetGoToSocialReplyRequest(v vocab.GoToSocialReplyRequest) {
	this.clear()
	this.gotosocialReplyRequestMember = v
}

// SetIRI sets the value of this property. Calling IsIRI afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetIRI(v *url.URL) {
	this.clear()
	this.iri = v
}

// SetLitePubEmojiReact sets the value of this property. Calling
// IsLitePubEmojiReact afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetLitePubEmojiReact(v vocab.LitePubEmojiReact) {
	this.clear()
	this.litepubEmojiReactMember = v
}

// SetSchemaPropertyValue sets the value of this property. Calling
// IsSchemaPropertyValue afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetSchemaPropertyValue(v vocab.SchemaPropertyValue) {
	this.clear()
	this.schemaPropertyValueMember = v
}

// SetTootEmoji sets the value of this property. Calling IsTootEmoji afterwards
// returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetTootEmoji(v vocab.TootEmoji) {
	this.clear()
	this.tootEmojiMember = v
}

// SetTootHashtag sets the value of this property. Calling IsTootHashtag
// afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetTootHashtag(v vocab.TootHashtag) {
	this.clear()
	this.tootHashtagMember = v
}

// SetTootIdentityProof sets the value of this property. Calling
// IsTootIdentityProof afterwards returns true.
func (this *ActivityStreamsAudiencePropertyIterator) SetTootIdentityProof(v vocab.TootIdentityProof) {
	this.clear()
	this.tootIdentityProofMember = v
}

// SetType attempts to set the property for the arbitrary type. Returns an error
// if it is not a valid type to set on this property.
func (this *ActivityStreamsAudiencePropertyIterator) SetType(t vocab.Type) error {
	if v, ok := t.(vocab.ActivityStreamsObject); ok {
		this.SetActivityStreamsObject(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsLink); ok {
		this.SetActivityStreamsLink(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsAccept); ok {
		this.SetActivityStreamsAccept(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsActivity); ok {
		this.SetActivityStreamsActivity(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsAdd); ok {
		this.SetActivityStreamsAdd(v)
		return nil
	}
	if v, ok := t.(vocab.FunkwhaleAlbum); ok {
		this.SetFunkwhaleAlbum(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsAnnounce); ok {
		this.SetActivityStreamsAnnounce(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialAnnounceApproval); ok {
		this.SetGoToSocialAnnounceApproval(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialAnnounceAuthorization); ok {
		this.SetGoToSocialAnnounceAuthorization(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialAnnounceRequest); ok {
		this.SetGoToSocialAnnounceRequest(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsApplication); ok {
		this.SetActivityStreamsApplication(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsArrive); ok {
		this.SetActivityStreamsArrive(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsArticle); ok {
		this.SetActivityStreamsArticle(v)
		return nil
	}
	if v, ok := t.(vocab.FunkwhaleArtist); ok {
		this.SetFunkwhaleArtist(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsAudio); ok {
		this.SetActivityStreamsAudio(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsBlock); ok {
		this.SetActivityStreamsBlock(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsCollection); ok {
		this.SetActivityStreamsCollection(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsCollectionPage); ok {
		this.SetActivityStreamsCollectionPage(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsCreate); ok {
		this.SetActivityStreamsCreate(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsDelete); ok {
		this.SetActivityStreamsDelete(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsDislike); ok {
		this.SetActivityStreamsDislike(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsDocument); ok {
		this.SetActivityStreamsDocument(v)
		return nil
	}
	if v, ok := t.(vocab.TootEmoji); ok {
		this.SetTootEmoji(v)
		return nil
	}
	if v, ok := t.(vocab.LitePubEmojiReact); ok {
		this.SetLitePubEmojiReact(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsEvent); ok {
		this.SetActivityStreamsEvent(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsFlag); ok {
		this.SetActivityStreamsFlag(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsFollow); ok {
		this.SetActivityStreamsFollow(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsGroup); ok {
		this.SetActivityStreamsGroup(v)
		return nil
	}
	if v, ok := t.(vocab.TootHashtag); ok {
		this.SetTootHashtag(v)
		return nil
	}
	if v, ok := t.(vocab.TootIdentityProof); ok {
		this.SetTootIdentityProof(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsIgnore); ok {
		this.SetActivityStreamsIgnore(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsImage); ok {
		this.SetActivityStreamsImage(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsIntransitiveActivity); ok {
		this.SetActivityStreamsIntransitiveActivity(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsInvite); ok {
		this.SetActivityStreamsInvite(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsJoin); ok {
		this.SetActivityStreamsJoin(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsLeave); ok {
		this.SetActivityStreamsLeave(v)
		return nil
	}
	if v, ok := t.(vocab.FunkwhaleLibrary); ok {
		this.SetFunkwhaleLibrary(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsLike); ok {
		this.SetActivityStreamsLike(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialLikeApproval); ok {
		this.SetGoToSocialLikeApproval(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialLikeAuthorization); ok {
		this.SetGoToSocialLikeAuthorization(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialLikeRequest); ok {
		this.SetGoToSocialLikeRequest(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsListen); ok {
		this.SetActivityStreamsListen(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsMention); ok {
		this.SetActivityStreamsMention(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsMove); ok {
		this.SetActivityStreamsMove(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsNote); ok {
		this.SetActivityStreamsNote(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsOffer); ok {
		this.SetActivityStreamsOffer(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsOrderedCollection); ok {
		this.SetActivityStreamsOrderedCollection(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsOrderedCollectionPage); ok {
		this.SetActivityStreamsOrderedCollectionPage(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsOrganization); ok {
		this.SetActivityStreamsOrganization(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsPage); ok {
		this.SetActivityStreamsPage(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsPerson); ok {
		this.SetActivityStreamsPerson(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsPlace); ok {
		this.SetActivityStreamsPlace(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsProfile); ok {
		this.SetActivityStreamsProfile(v)
		return nil
	}
	if v, ok := t.(vocab.SchemaPropertyValue); ok {
		this.SetSchemaPropertyValue(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsQuestion); ok {
		this.SetActivityStreamsQuestion(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsRead); ok {
		this.SetActivityStreamsRead(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsReject); ok {
		this.SetActivityStreamsReject(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsRelationship); ok {
		this.SetActivityStreamsRelationship(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsRemove); ok {
		this.SetActivityStreamsRemove(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialReplyApproval); ok {
		this.SetGoToSocialReplyApproval(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialReplyAuthorization); ok {
		this.SetGoToSocialReplyAuthorization(v)
		return nil
	}
	if v, ok := t.(vocab.GoToSocialReplyRequest); ok {
		this.SetGoToSocialReplyRequest(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsService); ok {
		this.SetActivityStreamsService(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsTentativeAccept); ok {
		this.SetActivityStreamsTentativeAccept(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsTentativeReject); ok {
		this.SetActivityStreamsTentativeReject(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsTombstone); ok {
		this.SetActivityStreamsTombstone(v)
		return nil
	}
	if v, ok := t.(vocab.FunkwhaleTrack); ok {
		this.SetFunkwhaleTrack(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsTravel); ok {
		this.SetActivityStreamsTravel(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsUndo); ok {
		this.SetActivityStreamsUndo(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsUpdate); ok {
		this.SetActivityStreamsUpdate(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsVideo); ok {
		this.SetActivityStreamsVideo(v)
		return nil
	}
	if v, ok := t.(vocab.ActivityStreamsView); ok {
		this.SetActivityStreamsView(v)
		return nil
	}

	return fmt.Errorf("illegal type to set on ActivityStreamsAudience property: %T", t)
}

// clear ensures no value of this property is set. Calling HasAny or any of the
// 'Is' methods afterwards will return false.
func (this *ActivityStreamsAudiencePropertyIterator) clear() {
	this.activitystreamsObjectMember = nil
	this.activitystreamsLinkMember = nil
	this.activitystreamsAcceptMember = nil
	this.activitystreamsActivityMember = nil
	this.activitystreamsAddMember = nil
	this.funkwhaleAlbumMember = nil
	this.activitystreamsAnnounceMember = nil
	this.gotosocialAnnounceApprovalMember = nil
	this.gotosocialAnnounceAuthorizationMember = nil
	this.gotosocialAnnounceRequestMember = nil
	this.activitystreamsApplicationMember = nil
	this.activitystreamsArriveMember = nil
	this.activitystreamsArticleMember = nil
	this.funkwhaleArtistMember = nil
	this.activitystreamsAudioMember = nil
	this.activitystreamsBlockMember = nil
	this.activitystreamsCollectionMember = nil
	this.activitystreamsCollectionPageMember = nil
	this.activitystreamsCreateMember = nil
	this.activitystreamsDeleteMember = nil
	this.activitystreamsDislikeMember = nil
	this.activitystreamsDocumentMember = nil
	this.tootEmojiMember = nil
	this.litepubEmojiReactMember = nil
	this.activitystreamsEventMember = nil
	this.activitystreamsFlagMember = nil
	this.activitystreamsFollowMember = nil
	this.activitystreamsGroupMember = nil
	this.tootHashtagMember = nil
	this.tootIdentityProofMember = nil
	this.activitystreamsIgnoreMember = nil
	this.activitystreamsImageMember = nil
	this.activitystreamsIntransitiveActivityMember = nil
	this.activitystreamsInviteMember = nil
	this.activitystreamsJoinMember = nil
	this.activitystreamsLeaveMember = nil
	this.funkwhaleLibraryMember = nil
	this.activitystreamsLikeMember = nil
	this.gotosocialLikeApprovalMember = nil
	this.gotosocialLikeAuthorizationMember = nil
	this.gotosocialLikeRequestMember = nil
	this.activitystreamsListenMember = nil
	this.activitystreamsMentionMember = nil
	this.activitystreamsMoveMember = nil
	this.activitystreamsNoteMember = nil
	this.activitystreamsOfferMember = nil
	this.activitystreamsOrderedCollectionMember = nil
	this.activitystreamsOrderedCollectionPageMember = nil
	this.activitystreamsOrganizationMember = nil
	this.activitystreamsPageMember = nil
	this.activitystreamsPersonMember = nil
	this.activitystreamsPlaceMember = nil
	this.activitystreamsProfileMember = nil
	this.schemaPropertyValueMember = nil
	this.activitystreamsQuestionMember = nil
	this.activitystreamsReadMember = nil
	this.activitystreamsRejectMember = nil
	this.activitystreamsRelationshipMember = nil
	this.activitystreamsRemoveMember = nil
	this.gotosocialReplyApprovalMember = nil
	this.gotosocialReplyAuthorizationMember = nil
	this.gotosocialReplyRequestMember = nil
	this.activitystreamsServiceMember = nil
	this.activitystreamsTentativeAcceptMember = nil
	this.activitystreamsTentativeRejectMember = nil
	this.activitystreamsTombstoneMember = nil
	this.funkwhaleTrackMember = nil
	this.activitystreamsTravelMember = nil
	this.activitystreamsUndoMember = nil
	this.activitystreamsUpdateMember = nil
	this.activitystreamsVideoMember = nil
	this.activitystreamsViewMember = nil
	this.unknown = nil
	this.iri = nil
}

// serialize converts this into an interface representation suitable for
// marshalling into a text or binary format. Applications should not need this
// function as most typical use cases serialize types instead of individual
// properties. It is exposed for alternatives to go-fed implementations to use.
func (this ActivityStreamsAudiencePropertyIterator) serialize() (interface{}, error) {
	if this.IsActivityStreamsObject() {
		return this.GetActivityStreamsObject().Serialize()
	} else if this.IsActivityStreamsLink() {
		return this.GetActivityStreamsLink().Serialize()
	} else if this.IsActivityStreamsAccept() {
		return this.GetActivityStreamsAccept().Serialize()
	} else if this.IsActivityStreamsActivity() {
		return this.GetActivityStreamsActivity().Serialize()
	} else if this.IsActivityStreamsAdd() {
		return this.GetActivityStreamsAdd().Serialize()
	} else if this.IsFunkwhaleAlbum() {
		return this.GetFunkwhaleAlbum().Serialize()
	} else if this.IsActivityStreamsAnnounce() {
		return this.GetActivityStreamsAnnounce().Serialize()
	} else if this.IsGoToSocialAnnounceApproval() {
		return this.GetGoToSocialAnnounceApproval().Serialize()
	} else if this.IsGoToSocialAnnounceAuthorization() {
		return this.GetGoToSocialAnnounceAuthorization().Serialize()
	} else if this.IsGoToSocialAnnounceRequest() {
		return this.GetGoToSocialAnnounceRequest().Serialize()
	} else if this.IsActivityStreamsApplication() {
		return this.GetActivityStreamsApplication().Serialize()
	} else if this.IsActivityStreamsArrive() {
		return this.GetActivityStreamsArrive().Serialize()
	} else if this.IsActivityStreamsArticle() {
		return this.GetActivityStreamsArticle().Serialize()
	} else if this.IsFunkwhaleArtist() {
		return this.GetFunkwhaleArtist().Serialize()
	} else if this.IsActivityStreamsAudio() {
		return this.GetActivityStreamsAudio().Serialize()
	} else if this.IsActivityStreamsBlock() {
		return this.GetActivityStreamsBlock().Serialize()
	} else if this.IsActivityStreamsCollection() {
		return this.GetActivityStreamsCollection().Serialize()
	} else if this.IsActivityStreamsCollectionPage() {
		return this.GetActivityStreamsCollectionPage().Serialize()
	} else if this.IsActivityStreamsCreate() {
		return this.GetActivityStreamsCreate().Serialize()
	} else if this.IsActivityStreamsDelete() {
		return this.GetActivityStreamsDelete().Serialize()
	} else if this.IsActivityStreamsDislike() {
		return this.GetActivityStreamsDislike().Serialize()
	} else if this.IsActivityStreamsDocument() {
		return this.GetActivityStreamsDocument().Serialize()
	} else if this.IsTootEmoji() {
		return this.GetTootEmoji().Serialize()
	} else if this.IsLitePubEmojiReact() {
		return this.GetLitePubEmojiReact().Serialize()
	} else if this.IsActivityStreamsEvent() {
		return this.GetActivityStreamsEvent().Serialize()
	} else if this.IsActivityStreamsFlag() {
		return this.GetActivityStreamsFlag().Serialize()
	} else if this.IsActivityStreamsFollow() {
		return this.GetActivityStreamsFollow().Serialize()
	} else if this.IsActivityStreamsGroup() {
		return this.GetActivityStreamsGroup().Serialize()
	} else if this.IsTootHashtag() {
		return this.GetTootHashtag().Serialize()
	} else if this.IsTootIdentityProof() {
		return this.GetTootIdentityProof().Serialize()
	} else if this.IsActivityStreamsIgnore() {
		return this.GetActivityStreamsIgnore().Serialize()
	} else if this.IsActivityStreamsImage() {
		return this.GetActivityStreamsImage().Serialize()
	} else if this.IsActivityStreamsIntransitiveActivity() {
		return this.GetActivityStreamsIntransitiveActivity().Serialize()
	} else if this.IsActivityStreamsInvite() {
		return this.GetActivityStreamsInvite().Serialize()
	} else if this.IsActivityStreamsJoin() {
		return this.GetActivityStreamsJoin().Serialize()
	} else if this.IsActivityStreamsLeave() {
		return this.GetActivityStreamsLeave().Serialize()
	} else if this.IsFunkwhaleLibrary() {
		return this.GetFunkwhaleLibrary().Serialize()
	} else if this.IsActivityStreamsLike() {
		return this.GetActivityStreamsLike().Serialize()
	} else if this.IsGoToSocialLikeApproval() {
		return this.GetGoToSocialLikeApproval().Serialize()
	} else if this.IsGoToSocialLikeAuthorization() {
		return this.GetGoToSocialLikeAuthorization().Serialize()
	} else if this.IsGoToSocialLikeRequest() {
		return this.GetGoToSocialLikeRequest().Serialize()
	} else if this.IsActivityStreamsListen() {
		return this.GetActivityStreamsListen().Serialize()
	} else if this.IsActivityStreamsMention() {
		return this.GetActivityStreamsMention().Serialize()
	} else if this.IsActivityStreamsMove() {
		return this.GetActivityStreamsMove().Serialize()
	} else if this.IsActivityStreamsNote() {
		return this.GetActivityStreamsNote().Serialize()
	} else if this.IsActivityStreamsOffer() {
		return this.GetActivityStreamsOffer().Serialize()
	} else if this.IsActivityStreamsOrderedCollection() {
		return this.GetActivityStreamsOrderedCollection().Serialize()
	} else if this.IsActivityStreamsOrderedCollectionPage() {
		return this.GetActivityStreamsOrderedCollectionPage().Serialize()
	} else if this.IsActivityStreamsOrganization() {
		return this.GetActivityStreamsOrganization().Serialize()
	} else if this.IsActivityStreamsPage() {
		return this.GetActivityStreamsPage().Serialize()
	} else if this.IsActivityStreamsPerson() {
		return this.GetActivityStreamsPerson().Serialize()
	} else if this.IsActivityStreamsPlace() {
		return this.GetActivityStreamsPlace().Serialize()
	} else if this.IsActivityStreamsProfile() {
		return this.GetActivityStreamsProfile().Serialize()
	} else if this.IsSchemaPropertyValue() {
		return this.GetSchemaPropertyValue().Serialize()
	} else if this.IsActivityStreamsQuestion() {
		return this.GetActivityStreamsQuestion().Serialize()
	} else if this.IsActivityStreamsRead() {
		return this.GetActivityStreamsRead().Serialize()
	} else if this.IsActivityStreamsReject() {
		return this.GetActivityStreamsReject().Serialize()
	} else if this.IsActivityStreamsRelationship() {
		return this.GetActivityStreamsRelationship().Serialize()
	} else if this.IsActivityStreamsRemove() {
		return this.GetActivityStreamsRemove().Serialize()
	} else if this.IsGoToSocialReplyApproval() {
		return this.GetGoToSocialReplyApproval().Serialize()
	} else if this.IsGoToSocialReplyAuthorization() {
		return this.GetGoToSocialReplyAuthorization().Serialize()
	} else if this.IsGoToSocialReplyRequest() {
		return this.GetGoToSocialReplyRequest().Serialize()
	} else if this.IsActivityStreamsService() {
		return this.GetActivityStreamsService().Serialize()
	} else if this.IsActivityStreamsTentativeAccept() {
		return this.GetActivityStreamsTentativeAccept().Serialize()
	} else if this.IsActivityStreamsTentativeReject() {
		return this.GetActivityStreamsTentativeReject().Serialize()
	} else if this.IsActivityStreamsTombstone() {
		return this.GetActivityStreamsTombstone().Serialize()
	} else if this.IsFunkwhaleTrack() {
		return this.GetFunkwhaleTrack().Serialize()
	} else if this.IsActivityStreamsTravel() {
		return this.GetActivityStreamsTravel().Serialize()
	} else if this.IsActivityStreamsUndo() {
		return this.GetActivityStreamsUndo().Serialize()
	} else if this.IsActivityStreamsUpdate() {
		return this.GetActivityStreamsUpdate().Serialize()
	} else if this.IsActivityStreamsVideo() {
		return this.GetActivityStreamsVideo().Serialize()
	} else if this.IsActivityStreamsView() {
		return this.GetActivityStreamsView().Serialize()
	} else if this.IsIRI() {
		return this.iri.String(), nil
	}
	return this.unknown, nil
}

// ActivityStreamsAudienceProperty is the non-functional property "audience". It
// is permitted to have one or more values, and of different value types.
type ActivityStreamsAudienceProperty struct {
	properties []*ActivityStreamsAudiencePropertyIterator
	alias      string
}

// DeserializeAudienceProperty creates a "audience" property from an interface
// representation that has been unmarshalled from a text or binary format.
func DeserializeAudienceProperty(m map[string]interface{}, aliasMap map[string]string) (vocab.ActivityStreamsAudienceProperty, error) {
	alias := ""
	if a, ok := aliasMap["https://www.w3.org/ns/activitystreams"]; ok {
		alias = a
	}
	propName := "audience"
	if len(alias) > 0 {
		propName = fmt.Sprintf("%s:%s", alias, "audience")
	}
	i, ok := m[propName]

	if ok {
		this := &ActivityStreamsAudienceProperty{
			alias:      alias,
			properties: []*ActivityStreamsAudiencePropertyIterator{},
		}
		if list, ok := i.([]interface{}); ok {
			for _, iterator := range list {
				if p, err := deserializeActivityStreamsAudiencePropertyIterator(iterator, aliasMap); err != nil {
					return this, err
				} else if p != nil {
					this.properties = append(this.properties, p)
				}
			}
		} else {
			if p, err := deserializeActivityStreamsAudiencePropertyIterator(i, aliasMap); err != nil {
				return this, err
			} else if p != nil {
				this.properties = append(this.properties, p)
			}
		}
		// Set up the properties for iteration.
		for idx, ele := range this.properties {
			ele.parent = this
			ele.myIdx = idx
		}
		return this, nil
	}
	return nil, nil
}

// NewActivityStreamsAudienceProperty creates a new audience property.
func NewActivityStreamsAudienceProperty() *ActivityStreamsAudienceProperty {
	return &ActivityStreamsAudienceProperty{alias: ""}
}

// AppendActivityStreamsAccept appends a Accept value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsAccept(v vocab.ActivityStreamsAccept) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsAcceptMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsActivity appends a Activity value to the back of a list of
// the property "audience". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsActivity(v vocab.ActivityStreamsActivity) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsActivityMember: v,
		alias:                         this.alias,
		myIdx:                         this.Len(),
		parent:                        this,
	})
}

// AppendActivityStreamsAdd appends a Add value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsAdd(v vocab.ActivityStreamsAdd) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsAddMember: v,
		alias:                    this.alias,
		myIdx:                    this.Len(),
		parent:                   this,
	})
}

// AppendActivityStreamsAnnounce appends a Announce value to the back of a list of
// the property "audience". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsAnnounce(v vocab.ActivityStreamsAnnounce) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsAnnounceMember: v,
		alias:                         this.alias,
		myIdx:                         this.Len(),
		parent:                        this,
	})
}

// AppendActivityStreamsApplication appends a Application value to the back of a
// list of the property "audience". Invalidates iterators that are traversing
// using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsApplication(v vocab.ActivityStreamsApplication) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsApplicationMember: v,
		alias:                            this.alias,
		myIdx:                            this.Len(),
		parent:                           this,
	})
}

// AppendActivityStreamsArrive appends a Arrive value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsArrive(v vocab.ActivityStreamsArrive) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsArriveMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsArticle appends a Article value to the back of a list of
// the property "audience". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsArticle(v vocab.ActivityStreamsArticle) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsArticleMember: v,
		alias:                        this.alias,
		myIdx:                        this.Len(),
		parent:                       this,
	})
}

// AppendActivityStreamsAudio appends a Audio value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsAudio(v vocab.ActivityStreamsAudio) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsAudioMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsBlock appends a Block value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsBlock(v vocab.ActivityStreamsBlock) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsBlockMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsCollection appends a Collection value to the back of a
// list of the property "audience". Invalidates iterators that are traversing
// using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsCollection(v vocab.ActivityStreamsCollection) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsCollectionMember: v,
		alias:                           this.alias,
		myIdx:                           this.Len(),
		parent:                          this,
	})
}

// AppendActivityStreamsCollectionPage appends a CollectionPage value to the back
// of a list of the property "audience". Invalidates iterators that are
// traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsCollectionPage(v vocab.ActivityStreamsCollectionPage) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsCollectionPageMember: v,
		alias:                               this.alias,
		myIdx:                               this.Len(),
		parent:                              this,
	})
}

// AppendActivityStreamsCreate appends a Create value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsCreate(v vocab.ActivityStreamsCreate) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsCreateMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsDelete appends a Delete value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsDelete(v vocab.ActivityStreamsDelete) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsDeleteMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsDislike appends a Dislike value to the back of a list of
// the property "audience". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsDislike(v vocab.ActivityStreamsDislike) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsDislikeMember: v,
		alias:                        this.alias,
		myIdx:                        this.Len(),
		parent:                       this,
	})
}

// AppendActivityStreamsDocument appends a Document value to the back of a list of
// the property "audience". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsDocument(v vocab.ActivityStreamsDocument) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsDocumentMember: v,
		alias:                         this.alias,
		myIdx:                         this.Len(),
		parent:                        this,
	})
}

// AppendActivityStreamsEvent appends a Event value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsEvent(v vocab.ActivityStreamsEvent) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsEventMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsFlag appends a Flag value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsFlag(v vocab.ActivityStreamsFlag) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsFlagMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsFollow appends a Follow value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsFollow(v vocab.ActivityStreamsFollow) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsFollowMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsGroup appends a Group value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsGroup(v vocab.ActivityStreamsGroup) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsGroupMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsIgnore appends a Ignore value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsIgnore(v vocab.ActivityStreamsIgnore) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsIgnoreMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsImage appends a Image value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsImage(v vocab.ActivityStreamsImage) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsImageMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsIntransitiveActivity appends a IntransitiveActivity value
// to the back of a list of the property "audience". Invalidates iterators
// that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsIntransitiveActivity(v vocab.ActivityStreamsIntransitiveActivity) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsIntransitiveActivityMember: v,
		alias:  this.alias,
		myIdx:  this.Len(),
		parent: this,
	})
}

// AppendActivityStreamsInvite appends a Invite value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsInvite(v vocab.ActivityStreamsInvite) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsInviteMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsJoin appends a Join value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsJoin(v vocab.ActivityStreamsJoin) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsJoinMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsLeave appends a Leave value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsLeave(v vocab.ActivityStreamsLeave) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsLeaveMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsLike appends a Like value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsLike(v vocab.ActivityStreamsLike) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsLikeMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsLink appends a Link value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsLink(v vocab.ActivityStreamsLink) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsLinkMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsListen appends a Listen value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsListen(v vocab.ActivityStreamsListen) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsListenMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsMention appends a Mention value to the back of a list of
// the property "audience". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsMention(v vocab.ActivityStreamsMention) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsMentionMember: v,
		alias:                        this.alias,
		myIdx:                        this.Len(),
		parent:                       this,
	})
}

// AppendActivityStreamsMove appends a Move value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsMove(v vocab.ActivityStreamsMove) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsMoveMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsNote appends a Note value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsNote(v vocab.ActivityStreamsNote) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsNoteMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsObject appends a Object value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsObject(v vocab.ActivityStreamsObject) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsObjectMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsOffer appends a Offer value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsOffer(v vocab.ActivityStreamsOffer) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsOfferMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsOrderedCollection appends a OrderedCollection value to the
// back of a list of the property "audience". Invalidates iterators that are
// traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsOrderedCollection(v vocab.ActivityStreamsOrderedCollection) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsOrderedCollectionMember: v,
		alias:                                  this.alias,
		myIdx:                                  this.Len(),
		parent:                                 this,
	})
}

// AppendActivityStreamsOrderedCollectionPage appends a OrderedCollectionPage
// value to the back of a list of the property "audience". Invalidates
// iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsOrderedCollectionPage(v vocab.ActivityStreamsOrderedCollectionPage) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsOrderedCollectionPageMember: v,
		alias:  this.alias,
		myIdx:  this.Len(),
		parent: this,
	})
}

// AppendActivityStreamsOrganization appends a Organization value to the back of a
// list of the property "audience". Invalidates iterators that are traversing
// using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsOrganization(v vocab.ActivityStreamsOrganization) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsOrganizationMember: v,
		alias:                             this.alias,
		myIdx:                             this.Len(),
		parent:                            this,
	})
}

// AppendActivityStreamsPage appends a Page value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsPage(v vocab.ActivityStreamsPage) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsPageMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsPerson appends a Person value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsPerson(v vocab.ActivityStreamsPerson) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsPersonMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsPlace appends a Place value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsPlace(v vocab.ActivityStreamsPlace) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsPlaceMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsProfile appends a Profile value to the back of a list of
// the property "audience". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsProfile(v vocab.ActivityStreamsProfile) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsProfileMember: v,
		alias:                        this.alias,
		myIdx:                        this.Len(),
		parent:                       this,
	})
}

// AppendActivityStreamsQuestion appends a Question value to the back of a list of
// the property "audience". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsQuestion(v vocab.ActivityStreamsQuestion) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsQuestionMember: v,
		alias:                         this.alias,
		myIdx:                         this.Len(),
		parent:                        this,
	})
}

// AppendActivityStreamsRead appends a Read value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsRead(v vocab.ActivityStreamsRead) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsReadMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsReject appends a Reject value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsReject(v vocab.ActivityStreamsReject) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsRejectMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsRelationship appends a Relationship value to the back of a
// list of the property "audience". Invalidates iterators that are traversing
// using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsRelationship(v vocab.ActivityStreamsRelationship) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsRelationshipMember: v,
		alias:                             this.alias,
		myIdx:                             this.Len(),
		parent:                            this,
	})
}

// AppendActivityStreamsRemove appends a Remove value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsRemove(v vocab.ActivityStreamsRemove) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsRemoveMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsService appends a Service value to the back of a list of
// the property "audience". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsService(v vocab.ActivityStreamsService) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsServiceMember: v,
		alias:                        this.alias,
		myIdx:                        this.Len(),
		parent:                       this,
	})
}

// AppendActivityStreamsTentativeAccept appends a TentativeAccept value to the
// back of a list of the property "audience". Invalidates iterators that are
// traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsTentativeAccept(v vocab.ActivityStreamsTentativeAccept) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsTentativeAcceptMember: v,
		alias:                                this.alias,
		myIdx:                                this.Len(),
		parent:                               this,
	})
}

// AppendActivityStreamsTentativeReject appends a TentativeReject value to the
// back of a list of the property "audience". Invalidates iterators that are
// traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsTentativeReject(v vocab.ActivityStreamsTentativeReject) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsTentativeRejectMember: v,
		alias:                                this.alias,
		myIdx:                                this.Len(),
		parent:                               this,
	})
}

// AppendActivityStreamsTombstone appends a Tombstone value to the back of a list
// of the property "audience". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsTombstone(v vocab.ActivityStreamsTombstone) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsTombstoneMember: v,
		alias:                          this.alias,
		myIdx:                          this.Len(),
		parent:                         this,
	})
}

// AppendActivityStreamsTravel appends a Travel value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsTravel(v vocab.ActivityStreamsTravel) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsTravelMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsUndo appends a Undo value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsUndo(v vocab.ActivityStreamsUndo) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsUndoMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendActivityStreamsUpdate appends a Update value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsUpdate(v vocab.ActivityStreamsUpdate) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsUpdateMember: v,
		alias:                       this.alias,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendActivityStreamsVideo appends a Video value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsVideo(v vocab.ActivityStreamsVideo) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsVideoMember: v,
		alias:                      this.alias,
		myIdx:                      this.Len(),
		parent:                     this,
	})
}

// AppendActivityStreamsView appends a View value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendActivityStreamsView(v vocab.ActivityStreamsView) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		activitystreamsViewMember: v,
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
	})
}

// AppendFunkwhaleAlbum appends a Album value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendFunkwhaleAlbum(v vocab.FunkwhaleAlbum) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:                this.alias,
		funkwhaleAlbumMember: v,
		myIdx:                this.Len(),
		parent:               this,
	})
}

// AppendFunkwhaleArtist appends a Artist value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendFunkwhaleArtist(v vocab.FunkwhaleArtist) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:                 this.alias,
		funkwhaleArtistMember: v,
		myIdx:                 this.Len(),
		parent:                this,
	})
}

// AppendFunkwhaleLibrary appends a Library value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendFunkwhaleLibrary(v vocab.FunkwhaleLibrary) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:                  this.alias,
		funkwhaleLibraryMember: v,
		myIdx:                  this.Len(),
		parent:                 this,
	})
}

// AppendFunkwhaleTrack appends a Track value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendFunkwhaleTrack(v vocab.FunkwhaleTrack) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:                this.alias,
		funkwhaleTrackMember: v,
		myIdx:                this.Len(),
		parent:               this,
	})
}

// AppendGoToSocialAnnounceApproval appends a AnnounceApproval value to the back
// of a list of the property "audience". Invalidates iterators that are
// traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendGoToSocialAnnounceApproval(v vocab.GoToSocialAnnounceApproval) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:                            this.alias,
		gotosocialAnnounceApprovalMember: v,
		myIdx:                            this.Len(),
		parent:                           this,
	})
}

// AppendGoToSocialAnnounceAuthorization appends a AnnounceAuthorization value to
// the back of a list of the property "audience". Invalidates iterators that
// are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendGoToSocialAnnounceAuthorization(v vocab.GoToSocialAnnounceAuthorization) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:                                 this.alias,
		gotosocialAnnounceAuthorizationMember: v,
		myIdx:                                 this.Len(),
		parent:                                this,
	})
}

// AppendGoToSocialAnnounceRequest appends a AnnounceRequest value to the back of
// a list of the property "audience". Invalidates iterators that are
// traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendGoToSocialAnnounceRequest(v vocab.GoToSocialAnnounceRequest) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:                           this.alias,
		gotosocialAnnounceRequestMember: v,
		myIdx:                           this.Len(),
		parent:                          this,
	})
}

// AppendGoToSocialLikeApproval appends a LikeApproval value to the back of a list
// of the property "audience". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAudienceProperty) AppendGoToSocialLikeApproval(v vocab.GoToSocialLikeApproval) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:                        this.alias,
		gotosocialLikeApprovalMember: v,
		myIdx:                        this.Len(),
		parent:                       this,
	})
}

// AppendGoToSocialLikeAuthorization appends a LikeAuthorization value to the back
// of a list of the property "audience". Invalidates iterators that are
// traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendGoToSocialLikeAuthorization(v vocab.GoToSocialLikeAuthorization) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:                             this.alias,
		gotosocialLikeAuthorizationMember: v,
		myIdx:                             this.Len(),
		parent:                            this,
	})
}

// AppendGoToSocialLikeRequest appends a LikeRequest value to the back of a list
// of the property "audience". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAudienceProperty) AppendGoToSocialLikeRequest(v vocab.GoToSocialLikeRequest) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:                       this.alias,
		gotosocialLikeRequestMember: v,
		myIdx:                       this.Len(),
		parent:                      this,
	})
}

// AppendGoToSocialReplyApproval appends a ReplyApproval value to the back of a
// list of the property "audience". Invalidates iterators that are traversing
// using Prev.
func (this *ActivityStreamsAudienceProperty) AppendGoToSocialReplyApproval(v vocab.GoToSocialReplyApproval) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:                         this.alias,
		gotosocialReplyApprovalMember: v,
		myIdx:                         this.Len(),
		parent:                        this,
	})
}

// AppendGoToSocialReplyAuthorization appends a ReplyAuthorization value to the
// back of a list of the property "audience". Invalidates iterators that are
// traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendGoToSocialReplyAuthorization(v vocab.GoToSocialReplyAuthorization) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:                              this.alias,
		gotosocialReplyAuthorizationMember: v,
		myIdx:                              this.Len(),
		parent:                             this,
	})
}

// AppendGoToSocialReplyRequest appends a ReplyRequest value to the back of a list
// of the property "audience". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAudienceProperty) AppendGoToSocialReplyRequest(v vocab.GoToSocialReplyRequest) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:                        this.alias,
		gotosocialReplyRequestMember: v,
		myIdx:                        this.Len(),
		parent:                       this,
	})
}

// AppendIRI appends an IRI value to the back of a list of the property "audience"
func (this *ActivityStreamsAudienceProperty) AppendIRI(v *url.URL) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  this.Len(),
		parent: this,
	})
}

// AppendLitePubEmojiReact appends a EmojiReact value to the back of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendLitePubEmojiReact(v vocab.LitePubEmojiReact) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:                   this.alias,
		litepubEmojiReactMember: v,
		myIdx:                   this.Len(),
		parent:                  this,
	})
}

// AppendSchemaPropertyValue appends a PropertyValue value to the back of a list
// of the property "audience". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAudienceProperty) AppendSchemaPropertyValue(v vocab.SchemaPropertyValue) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:                     this.alias,
		myIdx:                     this.Len(),
		parent:                    this,
		schemaPropertyValueMember: v,
	})
}

// AppendTootEmoji appends a Emoji value to the back of a list of the property
// "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendTootEmoji(v vocab.TootEmoji) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:           this.alias,
		myIdx:           this.Len(),
		parent:          this,
		tootEmojiMember: v,
	})
}

// AppendTootHashtag appends a Hashtag value to the back of a list of the property
// "audience". Invalidates iterators that are traversing using Prev.
func (this *ActivityStreamsAudienceProperty) AppendTootHashtag(v vocab.TootHashtag) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:             this.alias,
		myIdx:             this.Len(),
		parent:            this,
		tootHashtagMember: v,
	})
}

// AppendTootIdentityProof appends a IdentityProof value to the back of a list of
// the property "audience". Invalidates iterators that are traversing using
// Prev.
func (this *ActivityStreamsAudienceProperty) AppendTootIdentityProof(v vocab.TootIdentityProof) {
	this.properties = append(this.properties, &ActivityStreamsAudiencePropertyIterator{
		alias:                   this.alias,
		myIdx:                   this.Len(),
		parent:                  this,
		tootIdentityProofMember: v,
	})
}

// PrependType prepends an arbitrary type value to the front of a list of the
// property "audience". Invalidates iterators that are traversing using Prev.
// Returns an error if the type is not a valid one to set for this property.
func (this *ActivityStreamsAudienceProperty) AppendType(t vocab.Type) error {
	n := &ActivityStreamsAudiencePropertyIterator{
		alias:  this.alias,
		myIdx:  this.Len(),
		parent: this,
	}
	if err := n.SetType(t); err != nil {
		return err
	}
	this.properties = append(this.properties, n)
	return nil
}

// At returns the property value for the specified index. Panics if the index is
// out of bounds.
func (this ActivityStreamsAudienceProperty) At(index int) vocab.ActivityStreamsAudiencePropertyIterator {
	return this.properties[index]
}

// Begin returns the first iterator, or nil if empty. Can be used with the
// iterator's Next method and this property's End method to iterate from front
// to back through all values.
func (this ActivityStreamsAudienceProperty) Begin() vocab.ActivityStreamsAudiencePropertyIterator {
	if this.Empty() {
		return nil
	} else {
		return this.properties[0]
	}
}

// Empty returns returns true if there are no elements.
func (this ActivityStreamsAudienceProperty) Empty() bool {
	return this.Len() == 0
}

// End returns beyond-the-last iterator, which is nil. Can be used with the
// iterator's Next method and this property's Begin method to iterate from
// front to back through all values.
func (this ActivityStreamsAudienceProperty) End() vocab.ActivityStreamsAudiencePropertyIterator {
	return nil
}

// InsertActivityStreamsAccept inserts a Accept value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsAccept(idx int, v vocab.ActivityStreamsAccept) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsAcceptMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsActivity inserts a Activity value at the specified index
// for a property "audience". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsActivity(idx int, v vocab.ActivityStreamsActivity) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsActivityMember: v,
		alias:                         this.alias,
		myIdx:                         idx,
		parent:                        this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsAdd inserts a Add value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsAdd(idx int, v vocab.ActivityStreamsAdd) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsAddMember: v,
		alias:                    this.alias,
		myIdx:                    idx,
		parent:                   this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsAnnounce inserts a Announce value at the specified index
// for a property "audience". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsAnnounce(idx int, v vocab.ActivityStreamsAnnounce) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsAnnounceMember: v,
		alias:                         this.alias,
		myIdx:                         idx,
		parent:                        this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsApplication inserts a Application value at the specified
// index for a property "audience". Existing elements at that index and higher
// are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsApplication(idx int, v vocab.ActivityStreamsApplication) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsApplicationMember: v,
		alias:                            this.alias,
		myIdx:                            idx,
		parent:                           this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsArrive inserts a Arrive value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsArrive(idx int, v vocab.ActivityStreamsArrive) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsArriveMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsArticle inserts a Article value at the specified index for
// a property "audience". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsArticle(idx int, v vocab.ActivityStreamsArticle) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsArticleMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsAudio inserts a Audio value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsAudio(idx int, v vocab.ActivityStreamsAudio) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsAudioMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsBlock inserts a Block value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsBlock(idx int, v vocab.ActivityStreamsBlock) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsBlockMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsCollection inserts a Collection value at the specified
// index for a property "audience". Existing elements at that index and higher
// are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsCollection(idx int, v vocab.ActivityStreamsCollection) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsCollectionMember: v,
		alias:                           this.alias,
		myIdx:                           idx,
		parent:                          this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsCollectionPage inserts a CollectionPage value at the
// specified index for a property "audience". Existing elements at that index
// and higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsCollectionPage(idx int, v vocab.ActivityStreamsCollectionPage) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsCollectionPageMember: v,
		alias:                               this.alias,
		myIdx:                               idx,
		parent:                              this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsCreate inserts a Create value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsCreate(idx int, v vocab.ActivityStreamsCreate) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsCreateMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsDelete inserts a Delete value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsDelete(idx int, v vocab.ActivityStreamsDelete) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsDeleteMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsDislike inserts a Dislike value at the specified index for
// a property "audience". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsDislike(idx int, v vocab.ActivityStreamsDislike) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsDislikeMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsDocument inserts a Document value at the specified index
// for a property "audience". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsDocument(idx int, v vocab.ActivityStreamsDocument) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsDocumentMember: v,
		alias:                         this.alias,
		myIdx:                         idx,
		parent:                        this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsEvent inserts a Event value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsEvent(idx int, v vocab.ActivityStreamsEvent) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsEventMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsFlag inserts a Flag value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsFlag(idx int, v vocab.ActivityStreamsFlag) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsFlagMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsFollow inserts a Follow value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsFollow(idx int, v vocab.ActivityStreamsFollow) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsFollowMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsGroup inserts a Group value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsGroup(idx int, v vocab.ActivityStreamsGroup) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsGroupMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsIgnore inserts a Ignore value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsIgnore(idx int, v vocab.ActivityStreamsIgnore) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsIgnoreMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsImage inserts a Image value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsImage(idx int, v vocab.ActivityStreamsImage) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsImageMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsIntransitiveActivity inserts a IntransitiveActivity value
// at the specified index for a property "audience". Existing elements at that
// index and higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsIntransitiveActivity(idx int, v vocab.ActivityStreamsIntransitiveActivity) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsIntransitiveActivityMember: v,
		alias:  this.alias,
		myIdx:  idx,
		parent: this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsInvite inserts a Invite value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsInvite(idx int, v vocab.ActivityStreamsInvite) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsInviteMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsJoin inserts a Join value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsJoin(idx int, v vocab.ActivityStreamsJoin) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsJoinMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsLeave inserts a Leave value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsLeave(idx int, v vocab.ActivityStreamsLeave) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsLeaveMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsLike inserts a Like value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsLike(idx int, v vocab.ActivityStreamsLike) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsLikeMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsLink inserts a Link value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsLink(idx int, v vocab.ActivityStreamsLink) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsLinkMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsListen inserts a Listen value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsListen(idx int, v vocab.ActivityStreamsListen) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsListenMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsMention inserts a Mention value at the specified index for
// a property "audience". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsMention(idx int, v vocab.ActivityStreamsMention) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsMentionMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsMove inserts a Move value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsMove(idx int, v vocab.ActivityStreamsMove) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsMoveMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsNote inserts a Note value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsNote(idx int, v vocab.ActivityStreamsNote) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsNoteMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsObject inserts a Object value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsObject(idx int, v vocab.ActivityStreamsObject) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsObjectMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsOffer inserts a Offer value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsOffer(idx int, v vocab.ActivityStreamsOffer) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsOfferMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsOrderedCollection inserts a OrderedCollection value at the
// specified index for a property "audience". Existing elements at that index
// and higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsOrderedCollection(idx int, v vocab.ActivityStreamsOrderedCollection) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsOrderedCollectionMember: v,
		alias:                                  this.alias,
		myIdx:                                  idx,
		parent:                                 this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsOrderedCollectionPage inserts a OrderedCollectionPage
// value at the specified index for a property "audience". Existing elements
// at that index and higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsOrderedCollectionPage(idx int, v vocab.ActivityStreamsOrderedCollectionPage) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsOrderedCollectionPageMember: v,
		alias:  this.alias,
		myIdx:  idx,
		parent: this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsOrganization inserts a Organization value at the specified
// index for a property "audience". Existing elements at that index and higher
// are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsOrganization(idx int, v vocab.ActivityStreamsOrganization) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsOrganizationMember: v,
		alias:                             this.alias,
		myIdx:                             idx,
		parent:                            this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsPage inserts a Page value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsPage(idx int, v vocab.ActivityStreamsPage) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsPageMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsPerson inserts a Person value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsPerson(idx int, v vocab.ActivityStreamsPerson) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsPersonMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsPlace inserts a Place value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsPlace(idx int, v vocab.ActivityStreamsPlace) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsPlaceMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsProfile inserts a Profile value at the specified index for
// a property "audience". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsProfile(idx int, v vocab.ActivityStreamsProfile) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsProfileMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsQuestion inserts a Question value at the specified index
// for a property "audience". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsQuestion(idx int, v vocab.ActivityStreamsQuestion) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsQuestionMember: v,
		alias:                         this.alias,
		myIdx:                         idx,
		parent:                        this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsRead inserts a Read value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsRead(idx int, v vocab.ActivityStreamsRead) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsReadMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsReject inserts a Reject value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsReject(idx int, v vocab.ActivityStreamsReject) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsRejectMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsRelationship inserts a Relationship value at the specified
// index for a property "audience". Existing elements at that index and higher
// are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsRelationship(idx int, v vocab.ActivityStreamsRelationship) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsRelationshipMember: v,
		alias:                             this.alias,
		myIdx:                             idx,
		parent:                            this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsRemove inserts a Remove value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsRemove(idx int, v vocab.ActivityStreamsRemove) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsRemoveMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsService inserts a Service value at the specified index for
// a property "audience". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsService(idx int, v vocab.ActivityStreamsService) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsServiceMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsTentativeAccept inserts a TentativeAccept value at the
// specified index for a property "audience". Existing elements at that index
// and higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsTentativeAccept(idx int, v vocab.ActivityStreamsTentativeAccept) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsTentativeAcceptMember: v,
		alias:                                this.alias,
		myIdx:                                idx,
		parent:                               this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsTentativeReject inserts a TentativeReject value at the
// specified index for a property "audience". Existing elements at that index
// and higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsTentativeReject(idx int, v vocab.ActivityStreamsTentativeReject) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsTentativeRejectMember: v,
		alias:                                this.alias,
		myIdx:                                idx,
		parent:                               this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsTombstone inserts a Tombstone value at the specified index
// for a property "audience". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsTombstone(idx int, v vocab.ActivityStreamsTombstone) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsTombstoneMember: v,
		alias:                          this.alias,
		myIdx:                          idx,
		parent:                         this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsTravel inserts a Travel value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsTravel(idx int, v vocab.ActivityStreamsTravel) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsTravelMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsUndo inserts a Undo value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsUndo(idx int, v vocab.ActivityStreamsUndo) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsUndoMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsUpdate inserts a Update value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsUpdate(idx int, v vocab.ActivityStreamsUpdate) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsUpdateMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsVideo inserts a Video value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsVideo(idx int, v vocab.ActivityStreamsVideo) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsVideoMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertActivityStreamsView inserts a View value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertActivityStreamsView(idx int, v vocab.ActivityStreamsView) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsViewMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertFunkwhaleAlbum inserts a Album value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertFunkwhaleAlbum(idx int, v vocab.FunkwhaleAlbum) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                this.alias,
		funkwhaleAlbumMember: v,
		myIdx:                idx,
		parent:               this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertFunkwhaleArtist inserts a Artist value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertFunkwhaleArtist(idx int, v vocab.FunkwhaleArtist) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                 this.alias,
		funkwhaleArtistMember: v,
		myIdx:                 idx,
		parent:                this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertFunkwhaleLibrary inserts a Library value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertFunkwhaleLibrary(idx int, v vocab.FunkwhaleLibrary) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                  this.alias,
		funkwhaleLibraryMember: v,
		myIdx:                  idx,
		parent:                 this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertFunkwhaleTrack inserts a Track value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertFunkwhaleTrack(idx int, v vocab.FunkwhaleTrack) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                this.alias,
		funkwhaleTrackMember: v,
		myIdx:                idx,
		parent:               this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialAnnounceApproval inserts a AnnounceApproval value at the
// specified index for a property "audience". Existing elements at that index
// and higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertGoToSocialAnnounceApproval(idx int, v vocab.GoToSocialAnnounceApproval) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                            this.alias,
		gotosocialAnnounceApprovalMember: v,
		myIdx:                            idx,
		parent:                           this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialAnnounceAuthorization inserts a AnnounceAuthorization value at
// the specified index for a property "audience". Existing elements at that
// index and higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertGoToSocialAnnounceAuthorization(idx int, v vocab.GoToSocialAnnounceAuthorization) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                                 this.alias,
		gotosocialAnnounceAuthorizationMember: v,
		myIdx:                                 idx,
		parent:                                this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialAnnounceRequest inserts a AnnounceRequest value at the
// specified index for a property "audience". Existing elements at that index
// and higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertGoToSocialAnnounceRequest(idx int, v vocab.GoToSocialAnnounceRequest) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                           this.alias,
		gotosocialAnnounceRequestMember: v,
		myIdx:                           idx,
		parent:                          this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialLikeApproval inserts a LikeApproval value at the specified
// index for a property "audience". Existing elements at that index and higher
// are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertGoToSocialLikeApproval(idx int, v vocab.GoToSocialLikeApproval) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                        this.alias,
		gotosocialLikeApprovalMember: v,
		myIdx:                        idx,
		parent:                       this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialLikeAuthorization inserts a LikeAuthorization value at the
// specified index for a property "audience". Existing elements at that index
// and higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertGoToSocialLikeAuthorization(idx int, v vocab.GoToSocialLikeAuthorization) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                             this.alias,
		gotosocialLikeAuthorizationMember: v,
		myIdx:                             idx,
		parent:                            this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialLikeRequest inserts a LikeRequest value at the specified index
// for a property "audience". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertGoToSocialLikeRequest(idx int, v vocab.GoToSocialLikeRequest) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                       this.alias,
		gotosocialLikeRequestMember: v,
		myIdx:                       idx,
		parent:                      this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialReplyApproval inserts a ReplyApproval value at the specified
// index for a property "audience". Existing elements at that index and higher
// are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertGoToSocialReplyApproval(idx int, v vocab.GoToSocialReplyApproval) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                         this.alias,
		gotosocialReplyApprovalMember: v,
		myIdx:                         idx,
		parent:                        this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialReplyAuthorization inserts a ReplyAuthorization value at the
// specified index for a property "audience". Existing elements at that index
// and higher are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertGoToSocialReplyAuthorization(idx int, v vocab.GoToSocialReplyAuthorization) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                              this.alias,
		gotosocialReplyAuthorizationMember: v,
		myIdx:                              idx,
		parent:                             this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertGoToSocialReplyRequest inserts a ReplyRequest value at the specified
// index for a property "audience". Existing elements at that index and higher
// are shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertGoToSocialReplyRequest(idx int, v vocab.GoToSocialReplyRequest) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                        this.alias,
		gotosocialReplyRequestMember: v,
		myIdx:                        idx,
		parent:                       this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// Insert inserts an IRI value at the specified index for a property "audience".
// Existing elements at that index and higher are shifted back once.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertIRI(idx int, v *url.URL) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  idx,
		parent: this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertLitePubEmojiReact inserts a EmojiReact value at the specified index for a
// property "audience". Existing elements at that index and higher are shifted
// back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertLitePubEmojiReact(idx int, v vocab.LitePubEmojiReact) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                   this.alias,
		litepubEmojiReactMember: v,
		myIdx:                   idx,
		parent:                  this,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertSchemaPropertyValue inserts a PropertyValue value at the specified index
// for a property "audience". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertSchemaPropertyValue(idx int, v vocab.SchemaPropertyValue) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
		schemaPropertyValueMember: v,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertTootEmoji inserts a Emoji value at the specified index for a property
// "audience". Existing elements at that index and higher are shifted back
// once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertTootEmoji(idx int, v vocab.TootEmoji) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:           this.alias,
		myIdx:           idx,
		parent:          this,
		tootEmojiMember: v,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertTootHashtag inserts a Hashtag value at the specified index for a property
// "audience". Existing elements at that index and higher are shifted back
// once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertTootHashtag(idx int, v vocab.TootHashtag) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:             this.alias,
		myIdx:             idx,
		parent:            this,
		tootHashtagMember: v,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// InsertTootIdentityProof inserts a IdentityProof value at the specified index
// for a property "audience". Existing elements at that index and higher are
// shifted back once. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) InsertTootIdentityProof(idx int, v vocab.TootIdentityProof) {
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                   this.alias,
		myIdx:                   idx,
		parent:                  this,
		tootIdentityProofMember: v,
	}
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependType prepends an arbitrary type value to the front of a list of the
// property "audience". Invalidates all iterators. Returns an error if the
// type is not a valid one to set for this property.
func (this *ActivityStreamsAudienceProperty) InsertType(idx int, t vocab.Type) error {
	n := &ActivityStreamsAudiencePropertyIterator{
		alias:  this.alias,
		myIdx:  idx,
		parent: this,
	}
	if err := n.SetType(t); err != nil {
		return err
	}
	this.properties = append(this.properties, nil)
	copy(this.properties[idx+1:], this.properties[idx:])
	this.properties[idx] = n
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
	return nil
}

// JSONLDContext returns the JSONLD URIs required in the context string for this
// property and the specific values that are set. The value in the map is the
// alias used to import the property's value or values.
func (this ActivityStreamsAudienceProperty) JSONLDContext() map[string]string {
	m := map[string]string{"https://www.w3.org/ns/activitystreams": this.alias}
	for _, elem := range this.properties {
		child := elem.JSONLDContext()
		/*
		   Since the literal maps in this function are determined at
		   code-generation time, this loop should not overwrite an existing key with a
		   new value.
		*/
		for k, v := range child {
			m[k] = v
		}
	}
	return m
}

// KindIndex computes an arbitrary value for indexing this kind of value. This is
// a leaky API method specifically needed only for alternate implementations
// for go-fed. Applications should not use this method. Panics if the index is
// out of bounds.
func (this ActivityStreamsAudienceProperty) KindIndex(idx int) int {
	return this.properties[idx].KindIndex()
}

// Len returns the number of values that exist for the "audience" property.
func (this ActivityStreamsAudienceProperty) Len() (length int) {
	return len(this.properties)
}

// Less computes whether another property is less than this one. Mixing types
// results in a consistent but arbitrary ordering
func (this ActivityStreamsAudienceProperty) Less(i, j int) bool {
	idx1 := this.KindIndex(i)
	idx2 := this.KindIndex(j)
	if idx1 < idx2 {
		return true
	} else if idx1 == idx2 {
		if idx1 == 0 {
			lhs := this.properties[i].GetActivityStreamsObject()
			rhs := this.properties[j].GetActivityStreamsObject()
			return lhs.LessThan(rhs)
		} else if idx1 == 1 {
			lhs := this.properties[i].GetActivityStreamsLink()
			rhs := this.properties[j].GetActivityStreamsLink()
			return lhs.LessThan(rhs)
		} else if idx1 == 2 {
			lhs := this.properties[i].GetActivityStreamsAccept()
			rhs := this.properties[j].GetActivityStreamsAccept()
			return lhs.LessThan(rhs)
		} else if idx1 == 3 {
			lhs := this.properties[i].GetActivityStreamsActivity()
			rhs := this.properties[j].GetActivityStreamsActivity()
			return lhs.LessThan(rhs)
		} else if idx1 == 4 {
			lhs := this.properties[i].GetActivityStreamsAdd()
			rhs := this.properties[j].GetActivityStreamsAdd()
			return lhs.LessThan(rhs)
		} else if idx1 == 5 {
			lhs := this.properties[i].GetFunkwhaleAlbum()
			rhs := this.properties[j].GetFunkwhaleAlbum()
			return lhs.LessThan(rhs)
		} else if idx1 == 6 {
			lhs := this.properties[i].GetActivityStreamsAnnounce()
			rhs := this.properties[j].GetActivityStreamsAnnounce()
			return lhs.LessThan(rhs)
		} else if idx1 == 7 {
			lhs := this.properties[i].GetGoToSocialAnnounceApproval()
			rhs := this.properties[j].GetGoToSocialAnnounceApproval()
			return lhs.LessThan(rhs)
		} else if idx1 == 8 {
			lhs := this.properties[i].GetGoToSocialAnnounceAuthorization()
			rhs := this.properties[j].GetGoToSocialAnnounceAuthorization()
			return lhs.LessThan(rhs)
		} else if idx1 == 9 {
			lhs := this.properties[i].GetGoToSocialAnnounceRequest()
			rhs := this.properties[j].GetGoToSocialAnnounceRequest()
			return lhs.LessThan(rhs)
		} else if idx1 == 10 {
			lhs := this.properties[i].GetActivityStreamsApplication()
			rhs := this.properties[j].GetActivityStreamsApplication()
			return lhs.LessThan(rhs)
		} else if idx1 == 11 {
			lhs := this.properties[i].GetActivityStreamsArrive()
			rhs := this.properties[j].GetActivityStreamsArrive()
			return lhs.LessThan(rhs)
		} else if idx1 == 12 {
			lhs := this.properties[i].GetActivityStreamsArticle()
			rhs := this.properties[j].GetActivityStreamsArticle()
			return lhs.LessThan(rhs)
		} else if idx1 == 13 {
			lhs := this.properties[i].GetFunkwhaleArtist()
			rhs := this.properties[j].GetFunkwhaleArtist()
			return lhs.LessThan(rhs)
		} else if idx1 == 14 {
			lhs := this.properties[i].GetActivityStreamsAudio()
			rhs := this.properties[j].GetActivityStreamsAudio()
			return lhs.LessThan(rhs)
		} else if idx1 == 15 {
			lhs := this.properties[i].GetActivityStreamsBlock()
			rhs := this.properties[j].GetActivityStreamsBlock()
			return lhs.LessThan(rhs)
		} else if idx1 == 16 {
			lhs := this.properties[i].GetActivityStreamsCollection()
			rhs := this.properties[j].GetActivityStreamsCollection()
			return lhs.LessThan(rhs)
		} else if idx1 == 17 {
			lhs := this.properties[i].GetActivityStreamsCollectionPage()
			rhs := this.properties[j].GetActivityStreamsCollectionPage()
			return lhs.LessThan(rhs)
		} else if idx1 == 18 {
			lhs := this.properties[i].GetActivityStreamsCreate()
			rhs := this.properties[j].GetActivityStreamsCreate()
			return lhs.LessThan(rhs)
		} else if idx1 == 19 {
			lhs := this.properties[i].GetActivityStreamsDelete()
			rhs := this.properties[j].GetActivityStreamsDelete()
			return lhs.LessThan(rhs)
		} else if idx1 == 20 {
			lhs := this.properties[i].GetActivityStreamsDislike()
			rhs := this.properties[j].GetActivityStreamsDislike()
			return lhs.LessThan(rhs)
		} else if idx1 == 21 {
			lhs := this.properties[i].GetActivityStreamsDocument()
			rhs := this.properties[j].GetActivityStreamsDocument()
			return lhs.LessThan(rhs)
		} else if idx1 == 22 {
			lhs := this.properties[i].GetTootEmoji()
			rhs := this.properties[j].GetTootEmoji()
			return lhs.LessThan(rhs)
		} else if idx1 == 23 {
			lhs := this.properties[i].GetLitePubEmojiReact()
			rhs := this.properties[j].GetLitePubEmojiReact()
			return lhs.LessThan(rhs)
		} else if idx1 == 24 {
			lhs := this.properties[i].GetActivityStreamsEvent()
			rhs := this.properties[j].GetActivityStreamsEvent()
			return lhs.LessThan(rhs)
		} else if idx1 == 25 {
			lhs := this.properties[i].GetActivityStreamsFlag()
			rhs := this.properties[j].GetActivityStreamsFlag()
			return lhs.LessThan(rhs)
		} else if idx1 == 26 {
			lhs := this.properties[i].GetActivityStreamsFollow()
			rhs := this.properties[j].GetActivityStreamsFollow()
			return lhs.LessThan(rhs)
		} else if idx1 == 27 {
			lhs := this.properties[i].GetActivityStreamsGroup()
			rhs := this.properties[j].GetActivityStreamsGroup()
			return lhs.LessThan(rhs)
		} else if idx1 == 28 {
			lhs := this.properties[i].GetTootHashtag()
			rhs := this.properties[j].GetTootHashtag()
			return lhs.LessThan(rhs)
		} else if idx1 == 29 {
			lhs := this.properties[i].GetTootIdentityProof()
			rhs := this.properties[j].GetTootIdentityProof()
			return lhs.LessThan(rhs)
		} else if idx1 == 30 {
			lhs := this.properties[i].GetActivityStreamsIgnore()
			rhs := this.properties[j].GetActivityStreamsIgnore()
			return lhs.LessThan(rhs)
		} else if idx1 == 31 {
			lhs := this.properties[i].GetActivityStreamsImage()
			rhs := this.properties[j].GetActivityStreamsImage()
			return lhs.LessThan(rhs)
		} else if idx1 == 32 {
			lhs := this.properties[i].GetActivityStreamsIntransitiveActivity()
			rhs := this.properties[j].GetActivityStreamsIntransitiveActivity()
			return lhs.LessThan(rhs)
		} else if idx1 == 33 {
			lhs := this.properties[i].GetActivityStreamsInvite()
			rhs := this.properties[j].GetActivityStreamsInvite()
			return lhs.LessThan(rhs)
		} else if idx1 == 34 {
			lhs := this.properties[i].GetActivityStreamsJoin()
			rhs := this.properties[j].GetActivityStreamsJoin()
			return lhs.LessThan(rhs)
		} else if idx1 == 35 {
			lhs := this.properties[i].GetActivityStreamsLeave()
			rhs := this.properties[j].GetActivityStreamsLeave()
			return lhs.LessThan(rhs)
		} else if idx1 == 36 {
			lhs := this.properties[i].GetFunkwhaleLibrary()
			rhs := this.properties[j].GetFunkwhaleLibrary()
			return lhs.LessThan(rhs)
		} else if idx1 == 37 {
			lhs := this.properties[i].GetActivityStreamsLike()
			rhs := this.properties[j].GetActivityStreamsLike()
			return lhs.LessThan(rhs)
		} else if idx1 == 38 {
			lhs := this.properties[i].GetGoToSocialLikeApproval()
			rhs := this.properties[j].GetGoToSocialLikeApproval()
			return lhs.LessThan(rhs)
		} else if idx1 == 39 {
			lhs := this.properties[i].GetGoToSocialLikeAuthorization()
			rhs := this.properties[j].GetGoToSocialLikeAuthorization()
			return lhs.LessThan(rhs)
		} else if idx1 == 40 {
			lhs := this.properties[i].GetGoToSocialLikeRequest()
			rhs := this.properties[j].GetGoToSocialLikeRequest()
			return lhs.LessThan(rhs)
		} else if idx1 == 41 {
			lhs := this.properties[i].GetActivityStreamsListen()
			rhs := this.properties[j].GetActivityStreamsListen()
			return lhs.LessThan(rhs)
		} else if idx1 == 42 {
			lhs := this.properties[i].GetActivityStreamsMention()
			rhs := this.properties[j].GetActivityStreamsMention()
			return lhs.LessThan(rhs)
		} else if idx1 == 43 {
			lhs := this.properties[i].GetActivityStreamsMove()
			rhs := this.properties[j].GetActivityStreamsMove()
			return lhs.LessThan(rhs)
		} else if idx1 == 44 {
			lhs := this.properties[i].GetActivityStreamsNote()
			rhs := this.properties[j].GetActivityStreamsNote()
			return lhs.LessThan(rhs)
		} else if idx1 == 45 {
			lhs := this.properties[i].GetActivityStreamsOffer()
			rhs := this.properties[j].GetActivityStreamsOffer()
			return lhs.LessThan(rhs)
		} else if idx1 == 46 {
			lhs := this.properties[i].GetActivityStreamsOrderedCollection()
			rhs := this.properties[j].GetActivityStreamsOrderedCollection()
			return lhs.LessThan(rhs)
		} else if idx1 == 47 {
			lhs := this.properties[i].GetActivityStreamsOrderedCollectionPage()
			rhs := this.properties[j].GetActivityStreamsOrderedCollectionPage()
			return lhs.LessThan(rhs)
		} else if idx1 == 48 {
			lhs := this.properties[i].GetActivityStreamsOrganization()
			rhs := this.properties[j].GetActivityStreamsOrganization()
			return lhs.LessThan(rhs)
		} else if idx1 == 49 {
			lhs := this.properties[i].GetActivityStreamsPage()
			rhs := this.properties[j].GetActivityStreamsPage()
			return lhs.LessThan(rhs)
		} else if idx1 == 50 {
			lhs := this.properties[i].GetActivityStreamsPerson()
			rhs := this.properties[j].GetActivityStreamsPerson()
			return lhs.LessThan(rhs)
		} else if idx1 == 51 {
			lhs := this.properties[i].GetActivityStreamsPlace()
			rhs := this.properties[j].GetActivityStreamsPlace()
			return lhs.LessThan(rhs)
		} else if idx1 == 52 {
			lhs := this.properties[i].GetActivityStreamsProfile()
			rhs := this.properties[j].GetActivityStreamsProfile()
			return lhs.LessThan(rhs)
		} else if idx1 == 53 {
			lhs := this.properties[i].GetSchemaPropertyValue()
			rhs := this.properties[j].GetSchemaPropertyValue()
			return lhs.LessThan(rhs)
		} else if idx1 == 54 {
			lhs := this.properties[i].GetActivityStreamsQuestion()
			rhs := this.properties[j].GetActivityStreamsQuestion()
			return lhs.LessThan(rhs)
		} else if idx1 == 55 {
			lhs := this.properties[i].GetActivityStreamsRead()
			rhs := this.properties[j].GetActivityStreamsRead()
			return lhs.LessThan(rhs)
		} else if idx1 == 56 {
			lhs := this.properties[i].GetActivityStreamsReject()
			rhs := this.properties[j].GetActivityStreamsReject()
			return lhs.LessThan(rhs)
		} else if idx1 == 57 {
			lhs := this.properties[i].GetActivityStreamsRelationship()
			rhs := this.properties[j].GetActivityStreamsRelationship()
			return lhs.LessThan(rhs)
		} else if idx1 == 58 {
			lhs := this.properties[i].GetActivityStreamsRemove()
			rhs := this.properties[j].GetActivityStreamsRemove()
			return lhs.LessThan(rhs)
		} else if idx1 == 59 {
			lhs := this.properties[i].GetGoToSocialReplyApproval()
			rhs := this.properties[j].GetGoToSocialReplyApproval()
			return lhs.LessThan(rhs)
		} else if idx1 == 60 {
			lhs := this.properties[i].GetGoToSocialReplyAuthorization()
			rhs := this.properties[j].GetGoToSocialReplyAuthorization()
			return lhs.LessThan(rhs)
		} else if idx1 == 61 {
			lhs := this.properties[i].GetGoToSocialReplyRequest()
			rhs := this.properties[j].GetGoToSocialReplyRequest()
			return lhs.LessThan(rhs)
		} else if idx1 == 62 {
			lhs := this.properties[i].GetActivityStreamsService()
			rhs := this.properties[j].GetActivityStreamsService()
			return lhs.LessThan(rhs)
		} else if idx1 == 63 {
			lhs := this.properties[i].GetActivityStreamsTentativeAccept()
			rhs := this.properties[j].GetActivityStreamsTentativeAccept()
			return lhs.LessThan(rhs)
		} else if idx1 == 64 {
			lhs := this.properties[i].GetActivityStreamsTentativeReject()
			rhs := this.properties[j].GetActivityStreamsTentativeReject()
			return lhs.LessThan(rhs)
		} else if idx1 == 65 {
			lhs := this.properties[i].GetActivityStreamsTombstone()
			rhs := this.properties[j].GetActivityStreamsTombstone()
			return lhs.LessThan(rhs)
		} else if idx1 == 66 {
			lhs := this.properties[i].GetFunkwhaleTrack()
			rhs := this.properties[j].GetFunkwhaleTrack()
			return lhs.LessThan(rhs)
		} else if idx1 == 67 {
			lhs := this.properties[i].GetActivityStreamsTravel()
			rhs := this.properties[j].GetActivityStreamsTravel()
			return lhs.LessThan(rhs)
		} else if idx1 == 68 {
			lhs := this.properties[i].GetActivityStreamsUndo()
			rhs := this.properties[j].GetActivityStreamsUndo()
			return lhs.LessThan(rhs)
		} else if idx1 == 69 {
			lhs := this.properties[i].GetActivityStreamsUpdate()
			rhs := this.properties[j].GetActivityStreamsUpdate()
			return lhs.LessThan(rhs)
		} else if idx1 == 70 {
			lhs := this.properties[i].GetActivityStreamsVideo()
			rhs := this.properties[j].GetActivityStreamsVideo()
			return lhs.LessThan(rhs)
		} else if idx1 == 71 {
			lhs := this.properties[i].GetActivityStreamsView()
			rhs := this.properties[j].GetActivityStreamsView()
			return lhs.LessThan(rhs)
		} else if idx1 == -2 {
			lhs := this.properties[i].GetIRI()
			rhs := this.properties[j].GetIRI()
			return lhs.String() < rhs.String()
		}
	}
	return false
}

// LessThan compares two instances of this property with an arbitrary but stable
// comparison. Applications should not use this because it is only meant to
// help alternative implementations to go-fed to be able to normalize
// nonfunctional properties.
func (this ActivityStreamsAudienceProperty) LessThan(o vocab.ActivityStreamsAudienceProperty) bool {
	l1 := this.Len()
	l2 := o.Len()
	l := l1
	if l2 < l1 {
		l = l2
	}
	for i := 0; i < l; i++ {
		if this.properties[i].LessThan(o.At(i)) {
			return true
		} else if o.At(i).LessThan(this.properties[i]) {
			return false
		}
	}
	return l1 < l2
}

// Name returns the name of this property ("audience") with any alias.
func (this ActivityStreamsAudienceProperty) Name() string {
	if len(this.alias) > 0 {
		return this.alias + ":" + "audience"
	} else {
		return "audience"
	}
}

// PrependActivityStreamsAccept prepends a Accept value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsAccept(v vocab.ActivityStreamsAccept) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsAcceptMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsActivity prepends a Activity value to the front of a list
// of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsActivity(v vocab.ActivityStreamsActivity) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsActivityMember: v,
		alias:                         this.alias,
		myIdx:                         0,
		parent:                        this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsAdd prepends a Add value to the front of a list of the
// property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsAdd(v vocab.ActivityStreamsAdd) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsAddMember: v,
		alias:                    this.alias,
		myIdx:                    0,
		parent:                   this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsAnnounce prepends a Announce value to the front of a list
// of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsAnnounce(v vocab.ActivityStreamsAnnounce) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsAnnounceMember: v,
		alias:                         this.alias,
		myIdx:                         0,
		parent:                        this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsApplication prepends a Application value to the front of
// a list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsApplication(v vocab.ActivityStreamsApplication) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsApplicationMember: v,
		alias:                            this.alias,
		myIdx:                            0,
		parent:                           this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsArrive prepends a Arrive value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsArrive(v vocab.ActivityStreamsArrive) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsArriveMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsArticle prepends a Article value to the front of a list
// of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsArticle(v vocab.ActivityStreamsArticle) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsArticleMember: v,
		alias:                        this.alias,
		myIdx:                        0,
		parent:                       this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsAudio prepends a Audio value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsAudio(v vocab.ActivityStreamsAudio) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsAudioMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsBlock prepends a Block value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsBlock(v vocab.ActivityStreamsBlock) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsBlockMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsCollection prepends a Collection value to the front of a
// list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsCollection(v vocab.ActivityStreamsCollection) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsCollectionMember: v,
		alias:                           this.alias,
		myIdx:                           0,
		parent:                          this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsCollectionPage prepends a CollectionPage value to the
// front of a list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsCollectionPage(v vocab.ActivityStreamsCollectionPage) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsCollectionPageMember: v,
		alias:                               this.alias,
		myIdx:                               0,
		parent:                              this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsCreate prepends a Create value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsCreate(v vocab.ActivityStreamsCreate) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsCreateMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsDelete prepends a Delete value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsDelete(v vocab.ActivityStreamsDelete) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsDeleteMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsDislike prepends a Dislike value to the front of a list
// of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsDislike(v vocab.ActivityStreamsDislike) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsDislikeMember: v,
		alias:                        this.alias,
		myIdx:                        0,
		parent:                       this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsDocument prepends a Document value to the front of a list
// of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsDocument(v vocab.ActivityStreamsDocument) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsDocumentMember: v,
		alias:                         this.alias,
		myIdx:                         0,
		parent:                        this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsEvent prepends a Event value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsEvent(v vocab.ActivityStreamsEvent) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsEventMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsFlag prepends a Flag value to the front of a list of the
// property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsFlag(v vocab.ActivityStreamsFlag) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsFlagMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsFollow prepends a Follow value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsFollow(v vocab.ActivityStreamsFollow) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsFollowMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsGroup prepends a Group value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsGroup(v vocab.ActivityStreamsGroup) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsGroupMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsIgnore prepends a Ignore value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsIgnore(v vocab.ActivityStreamsIgnore) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsIgnoreMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsImage prepends a Image value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsImage(v vocab.ActivityStreamsImage) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsImageMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsIntransitiveActivity prepends a IntransitiveActivity
// value to the front of a list of the property "audience". Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsIntransitiveActivity(v vocab.ActivityStreamsIntransitiveActivity) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsIntransitiveActivityMember: v,
		alias:  this.alias,
		myIdx:  0,
		parent: this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsInvite prepends a Invite value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsInvite(v vocab.ActivityStreamsInvite) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsInviteMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsJoin prepends a Join value to the front of a list of the
// property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsJoin(v vocab.ActivityStreamsJoin) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsJoinMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsLeave prepends a Leave value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsLeave(v vocab.ActivityStreamsLeave) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsLeaveMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsLike prepends a Like value to the front of a list of the
// property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsLike(v vocab.ActivityStreamsLike) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsLikeMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsLink prepends a Link value to the front of a list of the
// property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsLink(v vocab.ActivityStreamsLink) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsLinkMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsListen prepends a Listen value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsListen(v vocab.ActivityStreamsListen) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsListenMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsMention prepends a Mention value to the front of a list
// of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsMention(v vocab.ActivityStreamsMention) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsMentionMember: v,
		alias:                        this.alias,
		myIdx:                        0,
		parent:                       this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsMove prepends a Move value to the front of a list of the
// property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsMove(v vocab.ActivityStreamsMove) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsMoveMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsNote prepends a Note value to the front of a list of the
// property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsNote(v vocab.ActivityStreamsNote) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsNoteMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsObject prepends a Object value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsObject(v vocab.ActivityStreamsObject) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsObjectMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsOffer prepends a Offer value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsOffer(v vocab.ActivityStreamsOffer) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsOfferMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsOrderedCollection prepends a OrderedCollection value to
// the front of a list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsOrderedCollection(v vocab.ActivityStreamsOrderedCollection) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsOrderedCollectionMember: v,
		alias:                                  this.alias,
		myIdx:                                  0,
		parent:                                 this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsOrderedCollectionPage prepends a OrderedCollectionPage
// value to the front of a list of the property "audience". Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsOrderedCollectionPage(v vocab.ActivityStreamsOrderedCollectionPage) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsOrderedCollectionPageMember: v,
		alias:  this.alias,
		myIdx:  0,
		parent: this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsOrganization prepends a Organization value to the front
// of a list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsOrganization(v vocab.ActivityStreamsOrganization) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsOrganizationMember: v,
		alias:                             this.alias,
		myIdx:                             0,
		parent:                            this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsPage prepends a Page value to the front of a list of the
// property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsPage(v vocab.ActivityStreamsPage) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsPageMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsPerson prepends a Person value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsPerson(v vocab.ActivityStreamsPerson) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsPersonMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsPlace prepends a Place value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsPlace(v vocab.ActivityStreamsPlace) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsPlaceMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsProfile prepends a Profile value to the front of a list
// of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsProfile(v vocab.ActivityStreamsProfile) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsProfileMember: v,
		alias:                        this.alias,
		myIdx:                        0,
		parent:                       this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsQuestion prepends a Question value to the front of a list
// of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsQuestion(v vocab.ActivityStreamsQuestion) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsQuestionMember: v,
		alias:                         this.alias,
		myIdx:                         0,
		parent:                        this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsRead prepends a Read value to the front of a list of the
// property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsRead(v vocab.ActivityStreamsRead) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsReadMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsReject prepends a Reject value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsReject(v vocab.ActivityStreamsReject) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsRejectMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsRelationship prepends a Relationship value to the front
// of a list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsRelationship(v vocab.ActivityStreamsRelationship) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsRelationshipMember: v,
		alias:                             this.alias,
		myIdx:                             0,
		parent:                            this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsRemove prepends a Remove value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsRemove(v vocab.ActivityStreamsRemove) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsRemoveMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsService prepends a Service value to the front of a list
// of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsService(v vocab.ActivityStreamsService) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsServiceMember: v,
		alias:                        this.alias,
		myIdx:                        0,
		parent:                       this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsTentativeAccept prepends a TentativeAccept value to the
// front of a list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsTentativeAccept(v vocab.ActivityStreamsTentativeAccept) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsTentativeAcceptMember: v,
		alias:                                this.alias,
		myIdx:                                0,
		parent:                               this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsTentativeReject prepends a TentativeReject value to the
// front of a list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsTentativeReject(v vocab.ActivityStreamsTentativeReject) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsTentativeRejectMember: v,
		alias:                                this.alias,
		myIdx:                                0,
		parent:                               this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsTombstone prepends a Tombstone value to the front of a
// list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsTombstone(v vocab.ActivityStreamsTombstone) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsTombstoneMember: v,
		alias:                          this.alias,
		myIdx:                          0,
		parent:                         this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsTravel prepends a Travel value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsTravel(v vocab.ActivityStreamsTravel) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsTravelMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsUndo prepends a Undo value to the front of a list of the
// property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsUndo(v vocab.ActivityStreamsUndo) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsUndoMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsUpdate prepends a Update value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsUpdate(v vocab.ActivityStreamsUpdate) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsUpdateMember: v,
		alias:                       this.alias,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsVideo prepends a Video value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsVideo(v vocab.ActivityStreamsVideo) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsVideoMember: v,
		alias:                      this.alias,
		myIdx:                      0,
		parent:                     this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependActivityStreamsView prepends a View value to the front of a list of the
// property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependActivityStreamsView(v vocab.ActivityStreamsView) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		activitystreamsViewMember: v,
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependFunkwhaleAlbum prepends a Album value to the front of a list of the
// property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependFunkwhaleAlbum(v vocab.FunkwhaleAlbum) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:                this.alias,
		funkwhaleAlbumMember: v,
		myIdx:                0,
		parent:               this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependFunkwhaleArtist prepends a Artist value to the front of a list of the
// property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependFunkwhaleArtist(v vocab.FunkwhaleArtist) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:                 this.alias,
		funkwhaleArtistMember: v,
		myIdx:                 0,
		parent:                this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependFunkwhaleLibrary prepends a Library value to the front of a list of the
// property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependFunkwhaleLibrary(v vocab.FunkwhaleLibrary) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:                  this.alias,
		funkwhaleLibraryMember: v,
		myIdx:                  0,
		parent:                 this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependFunkwhaleTrack prepends a Track value to the front of a list of the
// property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependFunkwhaleTrack(v vocab.FunkwhaleTrack) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:                this.alias,
		funkwhaleTrackMember: v,
		myIdx:                0,
		parent:               this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialAnnounceApproval prepends a AnnounceApproval value to the
// front of a list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependGoToSocialAnnounceApproval(v vocab.GoToSocialAnnounceApproval) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:                            this.alias,
		gotosocialAnnounceApprovalMember: v,
		myIdx:                            0,
		parent:                           this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialAnnounceAuthorization prepends a AnnounceAuthorization value
// to the front of a list of the property "audience". Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) PrependGoToSocialAnnounceAuthorization(v vocab.GoToSocialAnnounceAuthorization) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:                                 this.alias,
		gotosocialAnnounceAuthorizationMember: v,
		myIdx:                                 0,
		parent:                                this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialAnnounceRequest prepends a AnnounceRequest value to the front
// of a list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependGoToSocialAnnounceRequest(v vocab.GoToSocialAnnounceRequest) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:                           this.alias,
		gotosocialAnnounceRequestMember: v,
		myIdx:                           0,
		parent:                          this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialLikeApproval prepends a LikeApproval value to the front of a
// list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependGoToSocialLikeApproval(v vocab.GoToSocialLikeApproval) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:                        this.alias,
		gotosocialLikeApprovalMember: v,
		myIdx:                        0,
		parent:                       this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialLikeAuthorization prepends a LikeAuthorization value to the
// front of a list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependGoToSocialLikeAuthorization(v vocab.GoToSocialLikeAuthorization) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:                             this.alias,
		gotosocialLikeAuthorizationMember: v,
		myIdx:                             0,
		parent:                            this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialLikeRequest prepends a LikeRequest value to the front of a
// list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependGoToSocialLikeRequest(v vocab.GoToSocialLikeRequest) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:                       this.alias,
		gotosocialLikeRequestMember: v,
		myIdx:                       0,
		parent:                      this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialReplyApproval prepends a ReplyApproval value to the front of a
// list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependGoToSocialReplyApproval(v vocab.GoToSocialReplyApproval) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:                         this.alias,
		gotosocialReplyApprovalMember: v,
		myIdx:                         0,
		parent:                        this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialReplyAuthorization prepends a ReplyAuthorization value to the
// front of a list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependGoToSocialReplyAuthorization(v vocab.GoToSocialReplyAuthorization) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:                              this.alias,
		gotosocialReplyAuthorizationMember: v,
		myIdx:                              0,
		parent:                             this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependGoToSocialReplyRequest prepends a ReplyRequest value to the front of a
// list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependGoToSocialReplyRequest(v vocab.GoToSocialReplyRequest) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:                        this.alias,
		gotosocialReplyRequestMember: v,
		myIdx:                        0,
		parent:                       this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependIRI prepends an IRI value to the front of a list of the property
// "audience".
func (this *ActivityStreamsAudienceProperty) PrependIRI(v *url.URL) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:  this.alias,
		iri:    v,
		myIdx:  0,
		parent: this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependLitePubEmojiReact prepends a EmojiReact value to the front of a list of
// the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependLitePubEmojiReact(v vocab.LitePubEmojiReact) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:                   this.alias,
		litepubEmojiReactMember: v,
		myIdx:                   0,
		parent:                  this,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependSchemaPropertyValue prepends a PropertyValue value to the front of a
// list of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependSchemaPropertyValue(v vocab.SchemaPropertyValue) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:                     this.alias,
		myIdx:                     0,
		parent:                    this,
		schemaPropertyValueMember: v,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependTootEmoji prepends a Emoji value to the front of a list of the property
// "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependTootEmoji(v vocab.TootEmoji) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:           this.alias,
		myIdx:           0,
		parent:          this,
		tootEmojiMember: v,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependTootHashtag prepends a Hashtag value to the front of a list of the
// property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependTootHashtag(v vocab.TootHashtag) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:             this.alias,
		myIdx:             0,
		parent:            this,
		tootHashtagMember: v,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependTootIdentityProof prepends a IdentityProof value to the front of a list
// of the property "audience". Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) PrependTootIdentityProof(v vocab.TootIdentityProof) {
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{{
		alias:                   this.alias,
		myIdx:                   0,
		parent:                  this,
		tootIdentityProofMember: v,
	}}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// PrependType prepends an arbitrary type value to the front of a list of the
// property "audience". Invalidates all iterators. Returns an error if the
// type is not a valid one to set for this property.
func (this *ActivityStreamsAudienceProperty) PrependType(t vocab.Type) error {
	n := &ActivityStreamsAudiencePropertyIterator{
		alias:  this.alias,
		myIdx:  0,
		parent: this,
	}
	if err := n.SetType(t); err != nil {
		return err
	}
	this.properties = append([]*ActivityStreamsAudiencePropertyIterator{n}, this.properties...)
	for i := 1; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
	return nil
}

// Remove deletes an element at the specified index from a list of the property
// "audience", regardless of its type. Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) Remove(idx int) {
	(this.properties)[idx].parent = nil
	copy((this.properties)[idx:], (this.properties)[idx+1:])
	(this.properties)[len(this.properties)-1] = &ActivityStreamsAudiencePropertyIterator{}
	this.properties = (this.properties)[:len(this.properties)-1]
	for i := idx; i < this.Len(); i++ {
		(this.properties)[i].myIdx = i
	}
}

// Serialize converts this into an interface representation suitable for
// marshalling into a text or binary format. Applications should not need this
// function as most typical use cases serialize types instead of individual
// properties. It is exposed for alternatives to go-fed implementations to use.
func (this ActivityStreamsAudienceProperty) Serialize() (interface{}, error) {
	s := make([]interface{}, 0, len(this.properties))
	for _, iterator := range this.properties {
		if b, err := iterator.serialize(); err != nil {
			return s, err
		} else {
			s = append(s, b)
		}
	}
	// Shortcut: if serializing one value, don't return an array -- pretty sure other Fediverse software would choke on a "type" value with array, for example.
	if len(s) == 1 {
		return s[0], nil
	}
	return s, nil
}

// SetActivityStreamsAccept sets a Accept value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsAccept(idx int, v vocab.ActivityStreamsAccept) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsAcceptMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsActivity sets a Activity value to be at the specified index
// for the property "audience". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsActivity(idx int, v vocab.ActivityStreamsActivity) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsActivityMember: v,
		alias:                         this.alias,
		myIdx:                         idx,
		parent:                        this,
	}
}

// SetActivityStreamsAdd sets a Add value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsAdd(idx int, v vocab.ActivityStreamsAdd) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsAddMember: v,
		alias:                    this.alias,
		myIdx:                    idx,
		parent:                   this,
	}
}

// SetActivityStreamsAnnounce sets a Announce value to be at the specified index
// for the property "audience". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsAnnounce(idx int, v vocab.ActivityStreamsAnnounce) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsAnnounceMember: v,
		alias:                         this.alias,
		myIdx:                         idx,
		parent:                        this,
	}
}

// SetActivityStreamsApplication sets a Application value to be at the specified
// index for the property "audience". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsApplication(idx int, v vocab.ActivityStreamsApplication) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsApplicationMember: v,
		alias:                            this.alias,
		myIdx:                            idx,
		parent:                           this,
	}
}

// SetActivityStreamsArrive sets a Arrive value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsArrive(idx int, v vocab.ActivityStreamsArrive) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsArriveMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsArticle sets a Article value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsArticle(idx int, v vocab.ActivityStreamsArticle) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsArticleMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
}

// SetActivityStreamsAudio sets a Audio value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsAudio(idx int, v vocab.ActivityStreamsAudio) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsAudioMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsBlock sets a Block value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsBlock(idx int, v vocab.ActivityStreamsBlock) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsBlockMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsCollection sets a Collection value to be at the specified
// index for the property "audience". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsCollection(idx int, v vocab.ActivityStreamsCollection) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsCollectionMember: v,
		alias:                           this.alias,
		myIdx:                           idx,
		parent:                          this,
	}
}

// SetActivityStreamsCollectionPage sets a CollectionPage value to be at the
// specified index for the property "audience". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsCollectionPage(idx int, v vocab.ActivityStreamsCollectionPage) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsCollectionPageMember: v,
		alias:                               this.alias,
		myIdx:                               idx,
		parent:                              this,
	}
}

// SetActivityStreamsCreate sets a Create value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsCreate(idx int, v vocab.ActivityStreamsCreate) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsCreateMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsDelete sets a Delete value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsDelete(idx int, v vocab.ActivityStreamsDelete) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsDeleteMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsDislike sets a Dislike value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsDislike(idx int, v vocab.ActivityStreamsDislike) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsDislikeMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
}

// SetActivityStreamsDocument sets a Document value to be at the specified index
// for the property "audience". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsDocument(idx int, v vocab.ActivityStreamsDocument) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsDocumentMember: v,
		alias:                         this.alias,
		myIdx:                         idx,
		parent:                        this,
	}
}

// SetActivityStreamsEvent sets a Event value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsEvent(idx int, v vocab.ActivityStreamsEvent) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsEventMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsFlag sets a Flag value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsFlag(idx int, v vocab.ActivityStreamsFlag) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsFlagMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsFollow sets a Follow value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsFollow(idx int, v vocab.ActivityStreamsFollow) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsFollowMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsGroup sets a Group value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsGroup(idx int, v vocab.ActivityStreamsGroup) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsGroupMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsIgnore sets a Ignore value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsIgnore(idx int, v vocab.ActivityStreamsIgnore) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsIgnoreMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsImage sets a Image value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsImage(idx int, v vocab.ActivityStreamsImage) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsImageMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsIntransitiveActivity sets a IntransitiveActivity value to be
// at the specified index for the property "audience". Panics if the index is
// out of bounds. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsIntransitiveActivity(idx int, v vocab.ActivityStreamsIntransitiveActivity) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsIntransitiveActivityMember: v,
		alias:  this.alias,
		myIdx:  idx,
		parent: this,
	}
}

// SetActivityStreamsInvite sets a Invite value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsInvite(idx int, v vocab.ActivityStreamsInvite) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsInviteMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsJoin sets a Join value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsJoin(idx int, v vocab.ActivityStreamsJoin) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsJoinMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsLeave sets a Leave value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsLeave(idx int, v vocab.ActivityStreamsLeave) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsLeaveMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsLike sets a Like value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsLike(idx int, v vocab.ActivityStreamsLike) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsLikeMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsLink sets a Link value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsLink(idx int, v vocab.ActivityStreamsLink) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsLinkMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsListen sets a Listen value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsListen(idx int, v vocab.ActivityStreamsListen) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsListenMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsMention sets a Mention value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsMention(idx int, v vocab.ActivityStreamsMention) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsMentionMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
}

// SetActivityStreamsMove sets a Move value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsMove(idx int, v vocab.ActivityStreamsMove) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsMoveMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsNote sets a Note value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsNote(idx int, v vocab.ActivityStreamsNote) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsNoteMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsObject sets a Object value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsObject(idx int, v vocab.ActivityStreamsObject) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsObjectMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsOffer sets a Offer value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsOffer(idx int, v vocab.ActivityStreamsOffer) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsOfferMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsOrderedCollection sets a OrderedCollection value to be at the
// specified index for the property "audience". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsOrderedCollection(idx int, v vocab.ActivityStreamsOrderedCollection) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsOrderedCollectionMember: v,
		alias:                                  this.alias,
		myIdx:                                  idx,
		parent:                                 this,
	}
}

// SetActivityStreamsOrderedCollectionPage sets a OrderedCollectionPage value to
// be at the specified index for the property "audience". Panics if the index
// is out of bounds. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsOrderedCollectionPage(idx int, v vocab.ActivityStreamsOrderedCollectionPage) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsOrderedCollectionPageMember: v,
		alias:  this.alias,
		myIdx:  idx,
		parent: this,
	}
}

// SetActivityStreamsOrganization sets a Organization value to be at the specified
// index for the property "audience". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsOrganization(idx int, v vocab.ActivityStreamsOrganization) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsOrganizationMember: v,
		alias:                             this.alias,
		myIdx:                             idx,
		parent:                            this,
	}
}

// SetActivityStreamsPage sets a Page value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsPage(idx int, v vocab.ActivityStreamsPage) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsPageMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsPerson sets a Person value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsPerson(idx int, v vocab.ActivityStreamsPerson) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsPersonMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsPlace sets a Place value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsPlace(idx int, v vocab.ActivityStreamsPlace) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsPlaceMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsProfile sets a Profile value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsProfile(idx int, v vocab.ActivityStreamsProfile) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsProfileMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
}

// SetActivityStreamsQuestion sets a Question value to be at the specified index
// for the property "audience". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsQuestion(idx int, v vocab.ActivityStreamsQuestion) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsQuestionMember: v,
		alias:                         this.alias,
		myIdx:                         idx,
		parent:                        this,
	}
}

// SetActivityStreamsRead sets a Read value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsRead(idx int, v vocab.ActivityStreamsRead) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsReadMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsReject sets a Reject value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsReject(idx int, v vocab.ActivityStreamsReject) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsRejectMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsRelationship sets a Relationship value to be at the specified
// index for the property "audience". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsRelationship(idx int, v vocab.ActivityStreamsRelationship) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsRelationshipMember: v,
		alias:                             this.alias,
		myIdx:                             idx,
		parent:                            this,
	}
}

// SetActivityStreamsRemove sets a Remove value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsRemove(idx int, v vocab.ActivityStreamsRemove) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsRemoveMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsService sets a Service value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsService(idx int, v vocab.ActivityStreamsService) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsServiceMember: v,
		alias:                        this.alias,
		myIdx:                        idx,
		parent:                       this,
	}
}

// SetActivityStreamsTentativeAccept sets a TentativeAccept value to be at the
// specified index for the property "audience". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsTentativeAccept(idx int, v vocab.ActivityStreamsTentativeAccept) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsTentativeAcceptMember: v,
		alias:                                this.alias,
		myIdx:                                idx,
		parent:                               this,
	}
}

// SetActivityStreamsTentativeReject sets a TentativeReject value to be at the
// specified index for the property "audience". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsTentativeReject(idx int, v vocab.ActivityStreamsTentativeReject) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsTentativeRejectMember: v,
		alias:                                this.alias,
		myIdx:                                idx,
		parent:                               this,
	}
}

// SetActivityStreamsTombstone sets a Tombstone value to be at the specified index
// for the property "audience". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsTombstone(idx int, v vocab.ActivityStreamsTombstone) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsTombstoneMember: v,
		alias:                          this.alias,
		myIdx:                          idx,
		parent:                         this,
	}
}

// SetActivityStreamsTravel sets a Travel value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsTravel(idx int, v vocab.ActivityStreamsTravel) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsTravelMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsUndo sets a Undo value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsUndo(idx int, v vocab.ActivityStreamsUndo) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsUndoMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetActivityStreamsUpdate sets a Update value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsUpdate(idx int, v vocab.ActivityStreamsUpdate) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsUpdateMember: v,
		alias:                       this.alias,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetActivityStreamsVideo sets a Video value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsVideo(idx int, v vocab.ActivityStreamsVideo) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsVideoMember: v,
		alias:                      this.alias,
		myIdx:                      idx,
		parent:                     this,
	}
}

// SetActivityStreamsView sets a View value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetActivityStreamsView(idx int, v vocab.ActivityStreamsView) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		activitystreamsViewMember: v,
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
	}
}

// SetFunkwhaleAlbum sets a Album value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetFunkwhaleAlbum(idx int, v vocab.FunkwhaleAlbum) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                this.alias,
		funkwhaleAlbumMember: v,
		myIdx:                idx,
		parent:               this,
	}
}

// SetFunkwhaleArtist sets a Artist value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetFunkwhaleArtist(idx int, v vocab.FunkwhaleArtist) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                 this.alias,
		funkwhaleArtistMember: v,
		myIdx:                 idx,
		parent:                this,
	}
}

// SetFunkwhaleLibrary sets a Library value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetFunkwhaleLibrary(idx int, v vocab.FunkwhaleLibrary) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                  this.alias,
		funkwhaleLibraryMember: v,
		myIdx:                  idx,
		parent:                 this,
	}
}

// SetFunkwhaleTrack sets a Track value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetFunkwhaleTrack(idx int, v vocab.FunkwhaleTrack) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                this.alias,
		funkwhaleTrackMember: v,
		myIdx:                idx,
		parent:               this,
	}
}

// SetGoToSocialAnnounceApproval sets a AnnounceApproval value to be at the
// specified index for the property "audience". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetGoToSocialAnnounceApproval(idx int, v vocab.GoToSocialAnnounceApproval) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                            this.alias,
		gotosocialAnnounceApprovalMember: v,
		myIdx:                            idx,
		parent:                           this,
	}
}

// SetGoToSocialAnnounceAuthorization sets a AnnounceAuthorization value to be at
// the specified index for the property "audience". Panics if the index is out
// of bounds. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetGoToSocialAnnounceAuthorization(idx int, v vocab.GoToSocialAnnounceAuthorization) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                                 this.alias,
		gotosocialAnnounceAuthorizationMember: v,
		myIdx:                                 idx,
		parent:                                this,
	}
}

// SetGoToSocialAnnounceRequest sets a AnnounceRequest value to be at the
// specified index for the property "audience". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetGoToSocialAnnounceRequest(idx int, v vocab.GoToSocialAnnounceRequest) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                           this.alias,
		gotosocialAnnounceRequestMember: v,
		myIdx:                           idx,
		parent:                          this,
	}
}

// SetGoToSocialLikeApproval sets a LikeApproval value to be at the specified
// index for the property "audience". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetGoToSocialLikeApproval(idx int, v vocab.GoToSocialLikeApproval) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                        this.alias,
		gotosocialLikeApprovalMember: v,
		myIdx:                        idx,
		parent:                       this,
	}
}

// SetGoToSocialLikeAuthorization sets a LikeAuthorization value to be at the
// specified index for the property "audience". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetGoToSocialLikeAuthorization(idx int, v vocab.GoToSocialLikeAuthorization) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                             this.alias,
		gotosocialLikeAuthorizationMember: v,
		myIdx:                             idx,
		parent:                            this,
	}
}

// SetGoToSocialLikeRequest sets a LikeRequest value to be at the specified index
// for the property "audience". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetGoToSocialLikeRequest(idx int, v vocab.GoToSocialLikeRequest) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                       this.alias,
		gotosocialLikeRequestMember: v,
		myIdx:                       idx,
		parent:                      this,
	}
}

// SetGoToSocialReplyApproval sets a ReplyApproval value to be at the specified
// index for the property "audience". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetGoToSocialReplyApproval(idx int, v vocab.GoToSocialReplyApproval) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                         this.alias,
		gotosocialReplyApprovalMember: v,
		myIdx:                         idx,
		parent:                        this,
	}
}

// SetGoToSocialReplyAuthorization sets a ReplyAuthorization value to be at the
// specified index for the property "audience". Panics if the index is out of
// bounds. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetGoToSocialReplyAuthorization(idx int, v vocab.GoToSocialReplyAuthorization) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                              this.alias,
		gotosocialReplyAuthorizationMember: v,
		myIdx:                              idx,
		parent:                             this,
	}
}

// SetGoToSocialReplyRequest sets a ReplyRequest value to be at the specified
// index for the property "audience". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetGoToSocialReplyRequest(idx int, v vocab.GoToSocialReplyRequest) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                        this.alias,
		gotosocialReplyRequestMember: v,
		myIdx:                        idx,
		parent:                       this,
	}
}

// SetIRI sets an IRI value to be at the specified index for the property
// "audience". Panics if the index is out of bounds.
func (this *ActivityStreamsAudienceProperty) SetIRI(idx int, v *url.URL) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:  this.alias,
		iri:    v,
		myIdx:  idx,
		parent: this,
	}
}

// SetLitePubEmojiReact sets a EmojiReact value to be at the specified index for
// the property "audience". Panics if the index is out of bounds. Invalidates
// all iterators.
func (this *ActivityStreamsAudienceProperty) SetLitePubEmojiReact(idx int, v vocab.LitePubEmojiReact) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                   this.alias,
		litepubEmojiReactMember: v,
		myIdx:                   idx,
		parent:                  this,
	}
}

// SetSchemaPropertyValue sets a PropertyValue value to be at the specified index
// for the property "audience". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetSchemaPropertyValue(idx int, v vocab.SchemaPropertyValue) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                     this.alias,
		myIdx:                     idx,
		parent:                    this,
		schemaPropertyValueMember: v,
	}
}

// SetTootEmoji sets a Emoji value to be at the specified index for the property
// "audience". Panics if the index is out of bounds. Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetTootEmoji(idx int, v vocab.TootEmoji) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:           this.alias,
		myIdx:           idx,
		parent:          this,
		tootEmojiMember: v,
	}
}

// SetTootHashtag sets a Hashtag value to be at the specified index for the
// property "audience". Panics if the index is out of bounds. Invalidates all
// iterators.
func (this *ActivityStreamsAudienceProperty) SetTootHashtag(idx int, v vocab.TootHashtag) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:             this.alias,
		myIdx:             idx,
		parent:            this,
		tootHashtagMember: v,
	}
}

// SetTootIdentityProof sets a IdentityProof value to be at the specified index
// for the property "audience". Panics if the index is out of bounds.
// Invalidates all iterators.
func (this *ActivityStreamsAudienceProperty) SetTootIdentityProof(idx int, v vocab.TootIdentityProof) {
	(this.properties)[idx].parent = nil
	(this.properties)[idx] = &ActivityStreamsAudiencePropertyIterator{
		alias:                   this.alias,
		myIdx:                   idx,
		parent:                  this,
		tootIdentityProofMember: v,
	}
}

// SetType sets an arbitrary type value to the specified index of the property
// "audience". Invalidates all iterators. Returns an error if the type is not
// a valid one to set for this property. Panics if the index is out of bounds.
func (this *ActivityStreamsAudienceProperty) SetType(idx int, t vocab.Type) error {
	n := &ActivityStreamsAudiencePropertyIterator{
		alias:  this.alias,
		myIdx:  idx,
		parent: this,
	}
	if err := n.SetType(t); err != nil {
		return err
	}
	(this.properties)[idx] = n
	return nil
}

// Swap swaps the location of values at two indices for the "audience" property.
func (this ActivityStreamsAudienceProperty) Swap(i, j int) {
	this.properties[i], this.properties[j] = this.properties[j], this.properties[i]
}
