/* iso-extractor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from iso-extractor.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/
/* Helper class to extract files from an ISO image*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <archive.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_ISO_EXTRACTOR (boxes_iso_extractor_get_type ())
#define BOXES_ISO_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ISO_EXTRACTOR, BoxesISOExtractor))
#define BOXES_ISO_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ISO_EXTRACTOR, BoxesISOExtractorClass))
#define BOXES_IS_ISO_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ISO_EXTRACTOR))
#define BOXES_IS_ISO_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ISO_EXTRACTOR))
#define BOXES_ISO_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ISO_EXTRACTOR, BoxesISOExtractorClass))

typedef struct _BoxesISOExtractor BoxesISOExtractor;
typedef struct _BoxesISOExtractorClass BoxesISOExtractorClass;
typedef struct _BoxesISOExtractorPrivate BoxesISOExtractorPrivate;
enum  {
	BOXES_ISO_EXTRACTOR_0_PROPERTY,
	BOXES_ISO_EXTRACTOR_NUM_PROPERTIES
};
static GParamSpec* boxes_iso_extractor_properties[BOXES_ISO_EXTRACTOR_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BOXES_TYPE_ARCHIVE_READER (boxes_archive_reader_get_type ())
#define BOXES_ARCHIVE_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReader))
#define BOXES_ARCHIVE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReaderClass))
#define BOXES_IS_ARCHIVE_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ARCHIVE_READER))
#define BOXES_IS_ARCHIVE_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ARCHIVE_READER))
#define BOXES_ARCHIVE_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ARCHIVE_READER, BoxesArchiveReaderClass))

typedef struct _BoxesArchiveReader BoxesArchiveReader;
typedef struct _BoxesArchiveReaderClass BoxesArchiveReaderClass;
typedef struct _BoxesIsoExtractorExtractData BoxesIsoExtractorExtractData;

struct _BoxesISOExtractor {
	GObject parent_instance;
	BoxesISOExtractorPrivate * priv;
};

struct _BoxesISOExtractorClass {
	GObjectClass parent_class;
};

struct _BoxesISOExtractorPrivate {
	gchar* device_file;
};

struct _BoxesIsoExtractorExtractData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesISOExtractor* self;
	gchar* path;
	gchar* output_path;
	GCancellable* cancellable;
	const gchar* _tmp0_;
	BoxesArchiveReader* reader;
	const gchar* _tmp1_;
	BoxesArchiveReader* _tmp2_;
	BoxesArchiveReader* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_;
};

static gint BoxesISOExtractor_private_offset;
static gpointer boxes_iso_extractor_parent_class = NULL;

VALA_EXTERN GType boxes_iso_extractor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesISOExtractor, g_object_unref)
VALA_EXTERN BoxesISOExtractor* boxes_iso_extractor_new (const gchar* iso_path);
VALA_EXTERN BoxesISOExtractor* boxes_iso_extractor_construct (GType object_type,
                                                  const gchar* iso_path);
static void boxes_iso_extractor_extract_data_free (gpointer _data);
VALA_EXTERN void boxes_iso_extractor_extract (BoxesISOExtractor* self,
                                  const gchar* path,
                                  const gchar* output_path,
                                  GCancellable* cancellable,
                                  GAsyncReadyCallback _callback_,
                                  gpointer _user_data_);
VALA_EXTERN void boxes_iso_extractor_extract_finish (BoxesISOExtractor* self,
                                         GAsyncResult* _res_,
                                         GError** error);
static gboolean boxes_iso_extractor_extract_co (BoxesIsoExtractorExtractData* _data_);
VALA_EXTERN GType boxes_archive_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesArchiveReader, g_object_unref)
VALA_EXTERN BoxesArchiveReader* boxes_archive_reader_new (const gchar* filename,
                                              int* format,
                                              GList* filters,
                                              GError** error);
VALA_EXTERN BoxesArchiveReader* boxes_archive_reader_construct (GType object_type,
                                                    const gchar* filename,
                                                    int* format,
                                                    GList* filters,
                                                    GError** error);
VALA_EXTERN void boxes_archive_reader_extract_file (BoxesArchiveReader* self,
                                        const gchar* src,
                                        const gchar* dest,
                                        gboolean override_if_necessary,
                                        GError** error);
static void boxes_iso_extractor_finalize (GObject * obj);
static GType boxes_iso_extractor_get_type_once (void);

static inline gpointer
boxes_iso_extractor_get_instance_private (BoxesISOExtractor* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesISOExtractor_private_offset);
}

BoxesISOExtractor*
boxes_iso_extractor_construct (GType object_type,
                               const gchar* iso_path)
{
	BoxesISOExtractor * self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (iso_path != NULL, NULL);
	self = (BoxesISOExtractor*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup (iso_path);
	_g_free0 (self->priv->device_file);
	self->priv->device_file = _tmp0_;
	return self;
}

BoxesISOExtractor*
boxes_iso_extractor_new (const gchar* iso_path)
{
	return boxes_iso_extractor_construct (BOXES_TYPE_ISO_EXTRACTOR, iso_path);
}

static void
boxes_iso_extractor_extract_data_free (gpointer _data)
{
	BoxesIsoExtractorExtractData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_free0 (_data_->output_path);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesIsoExtractorExtractData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
boxes_iso_extractor_extract (BoxesISOExtractor* self,
                             const gchar* path,
                             const gchar* output_path,
                             GCancellable* cancellable,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_)
{
	BoxesIsoExtractorExtractData* _data_;
	BoxesISOExtractor* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (output_path != NULL);
	_data_ = g_slice_new0 (BoxesIsoExtractorExtractData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_iso_extractor_extract_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (_data_->path);
	_data_->path = _tmp1_;
	_tmp2_ = g_strdup (output_path);
	_g_free0 (_data_->output_path);
	_data_->output_path = _tmp2_;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	boxes_iso_extractor_extract_co (_data_);
}

void
boxes_iso_extractor_extract_finish (BoxesISOExtractor* self,
                                    GAsyncResult* _res_,
                                    GError** error)
{
	BoxesIsoExtractorExtractData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static gboolean
boxes_iso_extractor_extract_co (BoxesIsoExtractorExtractData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->device_file;
	g_debug ("iso-extractor.vala:12: Extracting '%s' from '%s' at path '%s'..", _data_->path, _data_->_tmp0_, _data_->output_path);
	_data_->_tmp1_ = _data_->self->priv->device_file;
	_data_->_tmp2_ = boxes_archive_reader_new (_data_->_tmp1_, NULL, NULL, &_data_->_inner_error0_);
	_data_->reader = _data_->_tmp2_;
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->reader;
	boxes_archive_reader_extract_file (_data_->_tmp3_, _data_->path, _data_->output_path, TRUE, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->reader);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp4_ = _data_->self->priv->device_file;
	g_debug ("iso-extractor.vala:15: Extracted '%s' from '%s' at path '%s'.", _data_->path, _data_->_tmp4_, _data_->output_path);
	_g_object_unref0 (_data_->reader);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
boxes_iso_extractor_class_init (BoxesISOExtractorClass * klass,
                                gpointer klass_data)
{
	boxes_iso_extractor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesISOExtractor_private_offset);
	G_OBJECT_CLASS (klass)->finalize = boxes_iso_extractor_finalize;
}

static void
boxes_iso_extractor_instance_init (BoxesISOExtractor * self,
                                   gpointer klass)
{
	self->priv = boxes_iso_extractor_get_instance_private (self);
}

static void
boxes_iso_extractor_finalize (GObject * obj)
{
	BoxesISOExtractor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_ISO_EXTRACTOR, BoxesISOExtractor);
	_g_free0 (self->priv->device_file);
	G_OBJECT_CLASS (boxes_iso_extractor_parent_class)->finalize (obj);
}

static GType
boxes_iso_extractor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesISOExtractorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_iso_extractor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesISOExtractor), 0, (GInstanceInitFunc) boxes_iso_extractor_instance_init, NULL };
	GType boxes_iso_extractor_type_id;
	boxes_iso_extractor_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesISOExtractor", &g_define_type_info, 0);
	BoxesISOExtractor_private_offset = g_type_add_instance_private (boxes_iso_extractor_type_id, sizeof (BoxesISOExtractorPrivate));
	return boxes_iso_extractor_type_id;
}

GType
boxes_iso_extractor_get_type (void)
{
	static volatile gsize boxes_iso_extractor_type_id__once = 0;
	if (g_once_init_enter (&boxes_iso_extractor_type_id__once)) {
		GType boxes_iso_extractor_type_id;
		boxes_iso_extractor_type_id = boxes_iso_extractor_get_type_once ();
		g_once_init_leave (&boxes_iso_extractor_type_id__once, boxes_iso_extractor_type_id);
	}
	return boxes_iso_extractor_type_id__once;
}

