// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v6.30.2
// source: ref.proto

package gitalypb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	RefService_FindDefaultBranchName_FullMethodName           = "/gitaly.RefService/FindDefaultBranchName"
	RefService_FindLocalBranches_FullMethodName               = "/gitaly.RefService/FindLocalBranches"
	RefService_FindAllBranches_FullMethodName                 = "/gitaly.RefService/FindAllBranches"
	RefService_FindAllTags_FullMethodName                     = "/gitaly.RefService/FindAllTags"
	RefService_FindTag_FullMethodName                         = "/gitaly.RefService/FindTag"
	RefService_FindAllRemoteBranches_FullMethodName           = "/gitaly.RefService/FindAllRemoteBranches"
	RefService_RefExists_FullMethodName                       = "/gitaly.RefService/RefExists"
	RefService_FindBranch_FullMethodName                      = "/gitaly.RefService/FindBranch"
	RefService_UpdateReferences_FullMethodName                = "/gitaly.RefService/UpdateReferences"
	RefService_DeleteRefs_FullMethodName                      = "/gitaly.RefService/DeleteRefs"
	RefService_ListBranchNamesContainingCommit_FullMethodName = "/gitaly.RefService/ListBranchNamesContainingCommit"
	RefService_ListTagNamesContainingCommit_FullMethodName    = "/gitaly.RefService/ListTagNamesContainingCommit"
	RefService_GetTagSignatures_FullMethodName                = "/gitaly.RefService/GetTagSignatures"
	RefService_GetTagMessages_FullMethodName                  = "/gitaly.RefService/GetTagMessages"
	RefService_ListRefs_FullMethodName                        = "/gitaly.RefService/ListRefs"
	RefService_FindRefsByOID_FullMethodName                   = "/gitaly.RefService/FindRefsByOID"
)

// RefServiceClient is the client API for RefService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// RefService is a service that provides RPCs to list and modify Git references.
type RefServiceClient interface {
	// FindDefaultBranchName looks up the default branch reference name. Unless
	// otherwise specified the following heuristic is used:
	//
	// 1. If there are no branches, return an empty string.
	// 2. If there is only one branch, return the only branch.
	// 3. If a branch exists that matches HEAD, return the HEAD reference name.
	// 4. If a branch exists named refs/heads/main, return refs/heads/main.
	// 5. If a branch exists named refs/heads/master, return refs/heads/master.
	// 6. Return the first branch (as per default ordering by git).
	FindDefaultBranchName(ctx context.Context, in *FindDefaultBranchNameRequest, opts ...grpc.CallOption) (*FindDefaultBranchNameResponse, error)
	// FindLocalBranches finds all the local branches under `refs/heads/` for the specified repository.
	// The response is streamed back to the client to divide the list of branches into chunks.
	FindLocalBranches(ctx context.Context, in *FindLocalBranchesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[FindLocalBranchesResponse], error)
	// FindAllBranches finds all branches under `refs/heads/` and `refs/remotes/` for the specified repository.
	// The response is streamed back to the client to divide the list of branches into chunks.
	FindAllBranches(ctx context.Context, in *FindAllBranchesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[FindAllBranchesResponse], error)
	// FindAllTags finds all tags under `refs/tags/` for the specified repository.
	// The response is streamed back to the client to divide the list of tags into chunks.
	FindAllTags(ctx context.Context, in *FindAllTagsRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[FindAllTagsResponse], error)
	// FindTag looks up a tag by its name and returns it to the caller if it exists. This RPC supports
	// both lightweight and annotated tags. Note: this RPC returns an `Internal` error if the tag was
	// not found.
	FindTag(ctx context.Context, in *FindTagRequest, opts ...grpc.CallOption) (*FindTagResponse, error)
	// FindAllRemoteBranches finds all the remote branches under `refs/remotes/` for the specified repository.
	// The response is streamed back to the client to divide the list of branches into chunks.
	FindAllRemoteBranches(ctx context.Context, in *FindAllRemoteBranchesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[FindAllRemoteBranchesResponse], error)
	// RefExists checks if the specified reference exists. The reference must be fully qualified.
	RefExists(ctx context.Context, in *RefExistsRequest, opts ...grpc.CallOption) (*RefExistsResponse, error)
	// FindBranch finds a branch by its unqualified name (like "master") and
	// returns the commit it currently points to.
	FindBranch(ctx context.Context, in *FindBranchRequest, opts ...grpc.CallOption) (*FindBranchResponse, error)
	// UpdateReferences atomically updates a set of references to a new state. This RPC allows creating
	// new references, deleting old references and updating existing references in a raceless way.
	//
	// Updating symbolic references with this RPC is not allowed.
	UpdateReferences(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[UpdateReferencesRequest, UpdateReferencesResponse], error)
	// DeleteRefs deletes the specified references from its repository. Attempting to delete an
	// non-existent reference does not result in an error. It is recommended to instead use the
	// UpdateReferences RPC because it can delete references in a raceless manner via the expected old
	// object ID.
	DeleteRefs(ctx context.Context, in *DeleteRefsRequest, opts ...grpc.CallOption) (*DeleteRefsResponse, error)
	// ListBranchNamesContainingCommit finds all branches under `refs/heads/` that contain the specified commit.
	// The response is streamed back to the client to divide the list of branches into chunks.
	ListBranchNamesContainingCommit(ctx context.Context, in *ListBranchNamesContainingCommitRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ListBranchNamesContainingCommitResponse], error)
	// ListTagNamesContainingCommit finds all tags under `refs/tags/` that contain the specified commit.
	// The response is streamed back to the client to divide the list of tags into chunks.
	ListTagNamesContainingCommit(ctx context.Context, in *ListTagNamesContainingCommitRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ListTagNamesContainingCommitResponse], error)
	// GetTagSignatures returns signatures for annotated tags resolved from a set of revisions. Revisions
	// which don't resolve to an annotated tag are silently discarded. Revisions which cannot be resolved
	// result in an error. Tags which are annotated but not signed will return a TagSignature response
	// which has no signature, but its unsigned contents will still be returned.
	GetTagSignatures(ctx context.Context, in *GetTagSignaturesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetTagSignaturesResponse], error)
	// GetTagMessages returns tag messages for the annotated tags identified via the given revisions.
	// The response is streamed back to the client with a response message containing the tag ID
	// always preceding one or more messages containing the tag message contents. This is repeated for
	// all tags in the response.
	GetTagMessages(ctx context.Context, in *GetTagMessagesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetTagMessagesResponse], error)
	// ListRefs returns a stream of all references in the repository. By default, pseudo-revisions like HEAD
	// will not be returned by this RPC. Any symbolic references will be resolved to the object ID it is
	// pointing at.
	ListRefs(ctx context.Context, in *ListRefsRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ListRefsResponse], error)
	// FindRefsByOID returns an array of fully qualified reference names that point to an object ID.
	// It returns nothing if the object ID doesn't exist, or doesn't point to
	// any branches or tags. Prefixes can be also be used as the object ID.
	FindRefsByOID(ctx context.Context, in *FindRefsByOIDRequest, opts ...grpc.CallOption) (*FindRefsByOIDResponse, error)
}

type refServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRefServiceClient(cc grpc.ClientConnInterface) RefServiceClient {
	return &refServiceClient{cc}
}

func (c *refServiceClient) FindDefaultBranchName(ctx context.Context, in *FindDefaultBranchNameRequest, opts ...grpc.CallOption) (*FindDefaultBranchNameResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(FindDefaultBranchNameResponse)
	err := c.cc.Invoke(ctx, RefService_FindDefaultBranchName_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) FindLocalBranches(ctx context.Context, in *FindLocalBranchesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[FindLocalBranchesResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RefService_ServiceDesc.Streams[0], RefService_FindLocalBranches_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[FindLocalBranchesRequest, FindLocalBranchesResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_FindLocalBranchesClient = grpc.ServerStreamingClient[FindLocalBranchesResponse]

func (c *refServiceClient) FindAllBranches(ctx context.Context, in *FindAllBranchesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[FindAllBranchesResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RefService_ServiceDesc.Streams[1], RefService_FindAllBranches_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[FindAllBranchesRequest, FindAllBranchesResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_FindAllBranchesClient = grpc.ServerStreamingClient[FindAllBranchesResponse]

func (c *refServiceClient) FindAllTags(ctx context.Context, in *FindAllTagsRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[FindAllTagsResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RefService_ServiceDesc.Streams[2], RefService_FindAllTags_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[FindAllTagsRequest, FindAllTagsResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_FindAllTagsClient = grpc.ServerStreamingClient[FindAllTagsResponse]

func (c *refServiceClient) FindTag(ctx context.Context, in *FindTagRequest, opts ...grpc.CallOption) (*FindTagResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(FindTagResponse)
	err := c.cc.Invoke(ctx, RefService_FindTag_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) FindAllRemoteBranches(ctx context.Context, in *FindAllRemoteBranchesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[FindAllRemoteBranchesResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RefService_ServiceDesc.Streams[3], RefService_FindAllRemoteBranches_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[FindAllRemoteBranchesRequest, FindAllRemoteBranchesResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_FindAllRemoteBranchesClient = grpc.ServerStreamingClient[FindAllRemoteBranchesResponse]

func (c *refServiceClient) RefExists(ctx context.Context, in *RefExistsRequest, opts ...grpc.CallOption) (*RefExistsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RefExistsResponse)
	err := c.cc.Invoke(ctx, RefService_RefExists_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) FindBranch(ctx context.Context, in *FindBranchRequest, opts ...grpc.CallOption) (*FindBranchResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(FindBranchResponse)
	err := c.cc.Invoke(ctx, RefService_FindBranch_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) UpdateReferences(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[UpdateReferencesRequest, UpdateReferencesResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RefService_ServiceDesc.Streams[4], RefService_UpdateReferences_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[UpdateReferencesRequest, UpdateReferencesResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_UpdateReferencesClient = grpc.ClientStreamingClient[UpdateReferencesRequest, UpdateReferencesResponse]

func (c *refServiceClient) DeleteRefs(ctx context.Context, in *DeleteRefsRequest, opts ...grpc.CallOption) (*DeleteRefsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(DeleteRefsResponse)
	err := c.cc.Invoke(ctx, RefService_DeleteRefs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *refServiceClient) ListBranchNamesContainingCommit(ctx context.Context, in *ListBranchNamesContainingCommitRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ListBranchNamesContainingCommitResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RefService_ServiceDesc.Streams[5], RefService_ListBranchNamesContainingCommit_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[ListBranchNamesContainingCommitRequest, ListBranchNamesContainingCommitResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_ListBranchNamesContainingCommitClient = grpc.ServerStreamingClient[ListBranchNamesContainingCommitResponse]

func (c *refServiceClient) ListTagNamesContainingCommit(ctx context.Context, in *ListTagNamesContainingCommitRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ListTagNamesContainingCommitResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RefService_ServiceDesc.Streams[6], RefService_ListTagNamesContainingCommit_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[ListTagNamesContainingCommitRequest, ListTagNamesContainingCommitResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_ListTagNamesContainingCommitClient = grpc.ServerStreamingClient[ListTagNamesContainingCommitResponse]

func (c *refServiceClient) GetTagSignatures(ctx context.Context, in *GetTagSignaturesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetTagSignaturesResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RefService_ServiceDesc.Streams[7], RefService_GetTagSignatures_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[GetTagSignaturesRequest, GetTagSignaturesResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_GetTagSignaturesClient = grpc.ServerStreamingClient[GetTagSignaturesResponse]

func (c *refServiceClient) GetTagMessages(ctx context.Context, in *GetTagMessagesRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetTagMessagesResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RefService_ServiceDesc.Streams[8], RefService_GetTagMessages_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[GetTagMessagesRequest, GetTagMessagesResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_GetTagMessagesClient = grpc.ServerStreamingClient[GetTagMessagesResponse]

func (c *refServiceClient) ListRefs(ctx context.Context, in *ListRefsRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ListRefsResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RefService_ServiceDesc.Streams[9], RefService_ListRefs_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[ListRefsRequest, ListRefsResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_ListRefsClient = grpc.ServerStreamingClient[ListRefsResponse]

func (c *refServiceClient) FindRefsByOID(ctx context.Context, in *FindRefsByOIDRequest, opts ...grpc.CallOption) (*FindRefsByOIDResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(FindRefsByOIDResponse)
	err := c.cc.Invoke(ctx, RefService_FindRefsByOID_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RefServiceServer is the server API for RefService service.
// All implementations must embed UnimplementedRefServiceServer
// for forward compatibility.
//
// RefService is a service that provides RPCs to list and modify Git references.
type RefServiceServer interface {
	// FindDefaultBranchName looks up the default branch reference name. Unless
	// otherwise specified the following heuristic is used:
	//
	// 1. If there are no branches, return an empty string.
	// 2. If there is only one branch, return the only branch.
	// 3. If a branch exists that matches HEAD, return the HEAD reference name.
	// 4. If a branch exists named refs/heads/main, return refs/heads/main.
	// 5. If a branch exists named refs/heads/master, return refs/heads/master.
	// 6. Return the first branch (as per default ordering by git).
	FindDefaultBranchName(context.Context, *FindDefaultBranchNameRequest) (*FindDefaultBranchNameResponse, error)
	// FindLocalBranches finds all the local branches under `refs/heads/` for the specified repository.
	// The response is streamed back to the client to divide the list of branches into chunks.
	FindLocalBranches(*FindLocalBranchesRequest, grpc.ServerStreamingServer[FindLocalBranchesResponse]) error
	// FindAllBranches finds all branches under `refs/heads/` and `refs/remotes/` for the specified repository.
	// The response is streamed back to the client to divide the list of branches into chunks.
	FindAllBranches(*FindAllBranchesRequest, grpc.ServerStreamingServer[FindAllBranchesResponse]) error
	// FindAllTags finds all tags under `refs/tags/` for the specified repository.
	// The response is streamed back to the client to divide the list of tags into chunks.
	FindAllTags(*FindAllTagsRequest, grpc.ServerStreamingServer[FindAllTagsResponse]) error
	// FindTag looks up a tag by its name and returns it to the caller if it exists. This RPC supports
	// both lightweight and annotated tags. Note: this RPC returns an `Internal` error if the tag was
	// not found.
	FindTag(context.Context, *FindTagRequest) (*FindTagResponse, error)
	// FindAllRemoteBranches finds all the remote branches under `refs/remotes/` for the specified repository.
	// The response is streamed back to the client to divide the list of branches into chunks.
	FindAllRemoteBranches(*FindAllRemoteBranchesRequest, grpc.ServerStreamingServer[FindAllRemoteBranchesResponse]) error
	// RefExists checks if the specified reference exists. The reference must be fully qualified.
	RefExists(context.Context, *RefExistsRequest) (*RefExistsResponse, error)
	// FindBranch finds a branch by its unqualified name (like "master") and
	// returns the commit it currently points to.
	FindBranch(context.Context, *FindBranchRequest) (*FindBranchResponse, error)
	// UpdateReferences atomically updates a set of references to a new state. This RPC allows creating
	// new references, deleting old references and updating existing references in a raceless way.
	//
	// Updating symbolic references with this RPC is not allowed.
	UpdateReferences(grpc.ClientStreamingServer[UpdateReferencesRequest, UpdateReferencesResponse]) error
	// DeleteRefs deletes the specified references from its repository. Attempting to delete an
	// non-existent reference does not result in an error. It is recommended to instead use the
	// UpdateReferences RPC because it can delete references in a raceless manner via the expected old
	// object ID.
	DeleteRefs(context.Context, *DeleteRefsRequest) (*DeleteRefsResponse, error)
	// ListBranchNamesContainingCommit finds all branches under `refs/heads/` that contain the specified commit.
	// The response is streamed back to the client to divide the list of branches into chunks.
	ListBranchNamesContainingCommit(*ListBranchNamesContainingCommitRequest, grpc.ServerStreamingServer[ListBranchNamesContainingCommitResponse]) error
	// ListTagNamesContainingCommit finds all tags under `refs/tags/` that contain the specified commit.
	// The response is streamed back to the client to divide the list of tags into chunks.
	ListTagNamesContainingCommit(*ListTagNamesContainingCommitRequest, grpc.ServerStreamingServer[ListTagNamesContainingCommitResponse]) error
	// GetTagSignatures returns signatures for annotated tags resolved from a set of revisions. Revisions
	// which don't resolve to an annotated tag are silently discarded. Revisions which cannot be resolved
	// result in an error. Tags which are annotated but not signed will return a TagSignature response
	// which has no signature, but its unsigned contents will still be returned.
	GetTagSignatures(*GetTagSignaturesRequest, grpc.ServerStreamingServer[GetTagSignaturesResponse]) error
	// GetTagMessages returns tag messages for the annotated tags identified via the given revisions.
	// The response is streamed back to the client with a response message containing the tag ID
	// always preceding one or more messages containing the tag message contents. This is repeated for
	// all tags in the response.
	GetTagMessages(*GetTagMessagesRequest, grpc.ServerStreamingServer[GetTagMessagesResponse]) error
	// ListRefs returns a stream of all references in the repository. By default, pseudo-revisions like HEAD
	// will not be returned by this RPC. Any symbolic references will be resolved to the object ID it is
	// pointing at.
	ListRefs(*ListRefsRequest, grpc.ServerStreamingServer[ListRefsResponse]) error
	// FindRefsByOID returns an array of fully qualified reference names that point to an object ID.
	// It returns nothing if the object ID doesn't exist, or doesn't point to
	// any branches or tags. Prefixes can be also be used as the object ID.
	FindRefsByOID(context.Context, *FindRefsByOIDRequest) (*FindRefsByOIDResponse, error)
	mustEmbedUnimplementedRefServiceServer()
}

// UnimplementedRefServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedRefServiceServer struct{}

func (UnimplementedRefServiceServer) FindDefaultBranchName(context.Context, *FindDefaultBranchNameRequest) (*FindDefaultBranchNameResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindDefaultBranchName not implemented")
}
func (UnimplementedRefServiceServer) FindLocalBranches(*FindLocalBranchesRequest, grpc.ServerStreamingServer[FindLocalBranchesResponse]) error {
	return status.Errorf(codes.Unimplemented, "method FindLocalBranches not implemented")
}
func (UnimplementedRefServiceServer) FindAllBranches(*FindAllBranchesRequest, grpc.ServerStreamingServer[FindAllBranchesResponse]) error {
	return status.Errorf(codes.Unimplemented, "method FindAllBranches not implemented")
}
func (UnimplementedRefServiceServer) FindAllTags(*FindAllTagsRequest, grpc.ServerStreamingServer[FindAllTagsResponse]) error {
	return status.Errorf(codes.Unimplemented, "method FindAllTags not implemented")
}
func (UnimplementedRefServiceServer) FindTag(context.Context, *FindTagRequest) (*FindTagResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindTag not implemented")
}
func (UnimplementedRefServiceServer) FindAllRemoteBranches(*FindAllRemoteBranchesRequest, grpc.ServerStreamingServer[FindAllRemoteBranchesResponse]) error {
	return status.Errorf(codes.Unimplemented, "method FindAllRemoteBranches not implemented")
}
func (UnimplementedRefServiceServer) RefExists(context.Context, *RefExistsRequest) (*RefExistsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RefExists not implemented")
}
func (UnimplementedRefServiceServer) FindBranch(context.Context, *FindBranchRequest) (*FindBranchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindBranch not implemented")
}
func (UnimplementedRefServiceServer) UpdateReferences(grpc.ClientStreamingServer[UpdateReferencesRequest, UpdateReferencesResponse]) error {
	return status.Errorf(codes.Unimplemented, "method UpdateReferences not implemented")
}
func (UnimplementedRefServiceServer) DeleteRefs(context.Context, *DeleteRefsRequest) (*DeleteRefsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRefs not implemented")
}
func (UnimplementedRefServiceServer) ListBranchNamesContainingCommit(*ListBranchNamesContainingCommitRequest, grpc.ServerStreamingServer[ListBranchNamesContainingCommitResponse]) error {
	return status.Errorf(codes.Unimplemented, "method ListBranchNamesContainingCommit not implemented")
}
func (UnimplementedRefServiceServer) ListTagNamesContainingCommit(*ListTagNamesContainingCommitRequest, grpc.ServerStreamingServer[ListTagNamesContainingCommitResponse]) error {
	return status.Errorf(codes.Unimplemented, "method ListTagNamesContainingCommit not implemented")
}
func (UnimplementedRefServiceServer) GetTagSignatures(*GetTagSignaturesRequest, grpc.ServerStreamingServer[GetTagSignaturesResponse]) error {
	return status.Errorf(codes.Unimplemented, "method GetTagSignatures not implemented")
}
func (UnimplementedRefServiceServer) GetTagMessages(*GetTagMessagesRequest, grpc.ServerStreamingServer[GetTagMessagesResponse]) error {
	return status.Errorf(codes.Unimplemented, "method GetTagMessages not implemented")
}
func (UnimplementedRefServiceServer) ListRefs(*ListRefsRequest, grpc.ServerStreamingServer[ListRefsResponse]) error {
	return status.Errorf(codes.Unimplemented, "method ListRefs not implemented")
}
func (UnimplementedRefServiceServer) FindRefsByOID(context.Context, *FindRefsByOIDRequest) (*FindRefsByOIDResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FindRefsByOID not implemented")
}
func (UnimplementedRefServiceServer) mustEmbedUnimplementedRefServiceServer() {}
func (UnimplementedRefServiceServer) testEmbeddedByValue()                    {}

// UnsafeRefServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RefServiceServer will
// result in compilation errors.
type UnsafeRefServiceServer interface {
	mustEmbedUnimplementedRefServiceServer()
}

func RegisterRefServiceServer(s grpc.ServiceRegistrar, srv RefServiceServer) {
	// If the following call pancis, it indicates UnimplementedRefServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&RefService_ServiceDesc, srv)
}

func _RefService_FindDefaultBranchName_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindDefaultBranchNameRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).FindDefaultBranchName(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RefService_FindDefaultBranchName_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).FindDefaultBranchName(ctx, req.(*FindDefaultBranchNameRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_FindLocalBranches_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindLocalBranchesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).FindLocalBranches(m, &grpc.GenericServerStream[FindLocalBranchesRequest, FindLocalBranchesResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_FindLocalBranchesServer = grpc.ServerStreamingServer[FindLocalBranchesResponse]

func _RefService_FindAllBranches_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindAllBranchesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).FindAllBranches(m, &grpc.GenericServerStream[FindAllBranchesRequest, FindAllBranchesResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_FindAllBranchesServer = grpc.ServerStreamingServer[FindAllBranchesResponse]

func _RefService_FindAllTags_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindAllTagsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).FindAllTags(m, &grpc.GenericServerStream[FindAllTagsRequest, FindAllTagsResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_FindAllTagsServer = grpc.ServerStreamingServer[FindAllTagsResponse]

func _RefService_FindTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).FindTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RefService_FindTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).FindTag(ctx, req.(*FindTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_FindAllRemoteBranches_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(FindAllRemoteBranchesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).FindAllRemoteBranches(m, &grpc.GenericServerStream[FindAllRemoteBranchesRequest, FindAllRemoteBranchesResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_FindAllRemoteBranchesServer = grpc.ServerStreamingServer[FindAllRemoteBranchesResponse]

func _RefService_RefExists_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RefExistsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).RefExists(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RefService_RefExists_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).RefExists(ctx, req.(*RefExistsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_FindBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).FindBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RefService_FindBranch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).FindBranch(ctx, req.(*FindBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_UpdateReferences_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RefServiceServer).UpdateReferences(&grpc.GenericServerStream[UpdateReferencesRequest, UpdateReferencesResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_UpdateReferencesServer = grpc.ClientStreamingServer[UpdateReferencesRequest, UpdateReferencesResponse]

func _RefService_DeleteRefs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRefsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).DeleteRefs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RefService_DeleteRefs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).DeleteRefs(ctx, req.(*DeleteRefsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RefService_ListBranchNamesContainingCommit_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListBranchNamesContainingCommitRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).ListBranchNamesContainingCommit(m, &grpc.GenericServerStream[ListBranchNamesContainingCommitRequest, ListBranchNamesContainingCommitResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_ListBranchNamesContainingCommitServer = grpc.ServerStreamingServer[ListBranchNamesContainingCommitResponse]

func _RefService_ListTagNamesContainingCommit_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListTagNamesContainingCommitRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).ListTagNamesContainingCommit(m, &grpc.GenericServerStream[ListTagNamesContainingCommitRequest, ListTagNamesContainingCommitResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_ListTagNamesContainingCommitServer = grpc.ServerStreamingServer[ListTagNamesContainingCommitResponse]

func _RefService_GetTagSignatures_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetTagSignaturesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).GetTagSignatures(m, &grpc.GenericServerStream[GetTagSignaturesRequest, GetTagSignaturesResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_GetTagSignaturesServer = grpc.ServerStreamingServer[GetTagSignaturesResponse]

func _RefService_GetTagMessages_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetTagMessagesRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).GetTagMessages(m, &grpc.GenericServerStream[GetTagMessagesRequest, GetTagMessagesResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_GetTagMessagesServer = grpc.ServerStreamingServer[GetTagMessagesResponse]

func _RefService_ListRefs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListRefsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RefServiceServer).ListRefs(m, &grpc.GenericServerStream[ListRefsRequest, ListRefsResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RefService_ListRefsServer = grpc.ServerStreamingServer[ListRefsResponse]

func _RefService_FindRefsByOID_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FindRefsByOIDRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RefServiceServer).FindRefsByOID(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RefService_FindRefsByOID_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RefServiceServer).FindRefsByOID(ctx, req.(*FindRefsByOIDRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// RefService_ServiceDesc is the grpc.ServiceDesc for RefService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RefService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.RefService",
	HandlerType: (*RefServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "FindDefaultBranchName",
			Handler:    _RefService_FindDefaultBranchName_Handler,
		},
		{
			MethodName: "FindTag",
			Handler:    _RefService_FindTag_Handler,
		},
		{
			MethodName: "RefExists",
			Handler:    _RefService_RefExists_Handler,
		},
		{
			MethodName: "FindBranch",
			Handler:    _RefService_FindBranch_Handler,
		},
		{
			MethodName: "DeleteRefs",
			Handler:    _RefService_DeleteRefs_Handler,
		},
		{
			MethodName: "FindRefsByOID",
			Handler:    _RefService_FindRefsByOID_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "FindLocalBranches",
			Handler:       _RefService_FindLocalBranches_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindAllBranches",
			Handler:       _RefService_FindAllBranches_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindAllTags",
			Handler:       _RefService_FindAllTags_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "FindAllRemoteBranches",
			Handler:       _RefService_FindAllRemoteBranches_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "UpdateReferences",
			Handler:       _RefService_UpdateReferences_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "ListBranchNamesContainingCommit",
			Handler:       _RefService_ListBranchNamesContainingCommit_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListTagNamesContainingCommit",
			Handler:       _RefService_ListTagNamesContainingCommit_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetTagSignatures",
			Handler:       _RefService_GetTagSignatures_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetTagMessages",
			Handler:       _RefService_GetTagMessages_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListRefs",
			Handler:       _RefService_ListRefs_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "ref.proto",
}
