// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v6.30.2
// source: cluster.proto

package gitalypb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	RaftService_SendMessage_FullMethodName    = "/gitaly.RaftService/SendMessage"
	RaftService_SendSnapshot_FullMethodName   = "/gitaly.RaftService/SendSnapshot"
	RaftService_JoinCluster_FullMethodName    = "/gitaly.RaftService/JoinCluster"
	RaftService_GetPartitions_FullMethodName  = "/gitaly.RaftService/GetPartitions"
	RaftService_GetClusterInfo_FullMethodName = "/gitaly.RaftService/GetClusterInfo"
)

// RaftServiceClient is the client API for RaftService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// RaftService manages the sending of Raft messages to peers.
type RaftServiceClient interface {
	// SendMessage processes Raft messages and ensures they are handled by
	// the receiving node to update its Raft state machine.
	SendMessage(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[RaftMessageRequest, RaftMessageResponse], error)
	// SendSnapshot sends raft snapshots from the leader to the follower node. Typically it
	// would be useful for nodes to catch up to the latest state.
	SendSnapshot(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[RaftSnapshotMessageRequest, RaftSnapshotMessageResponse], error)
	// JoinCluster is called by the leader to instruct a new node to join an existing cluster.
	JoinCluster(ctx context.Context, in *JoinClusterRequest, opts ...grpc.CallOption) (*JoinClusterResponse, error)
	// GetPartitions retrieves comprehensive information about the Raft cluster topology,
	// partition states, and replica health. This is useful for monitoring and debugging.
	// Returns a stream of partition information, one response per partition.
	GetPartitions(ctx context.Context, in *GetPartitionsRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetPartitionsResponse], error)
	// GetClusterInfo retrieves cluster-wide statistics and overview information.
	// This is a unary RPC that returns only aggregated statistics, not partition details.
	GetClusterInfo(ctx context.Context, in *RaftClusterInfoRequest, opts ...grpc.CallOption) (*RaftClusterInfoResponse, error)
}

type raftServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRaftServiceClient(cc grpc.ClientConnInterface) RaftServiceClient {
	return &raftServiceClient{cc}
}

func (c *raftServiceClient) SendMessage(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[RaftMessageRequest, RaftMessageResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RaftService_ServiceDesc.Streams[0], RaftService_SendMessage_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[RaftMessageRequest, RaftMessageResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RaftService_SendMessageClient = grpc.ClientStreamingClient[RaftMessageRequest, RaftMessageResponse]

func (c *raftServiceClient) SendSnapshot(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[RaftSnapshotMessageRequest, RaftSnapshotMessageResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RaftService_ServiceDesc.Streams[1], RaftService_SendSnapshot_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[RaftSnapshotMessageRequest, RaftSnapshotMessageResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RaftService_SendSnapshotClient = grpc.ClientStreamingClient[RaftSnapshotMessageRequest, RaftSnapshotMessageResponse]

func (c *raftServiceClient) JoinCluster(ctx context.Context, in *JoinClusterRequest, opts ...grpc.CallOption) (*JoinClusterResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(JoinClusterResponse)
	err := c.cc.Invoke(ctx, RaftService_JoinCluster_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *raftServiceClient) GetPartitions(ctx context.Context, in *GetPartitionsRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetPartitionsResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &RaftService_ServiceDesc.Streams[2], RaftService_GetPartitions_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[GetPartitionsRequest, GetPartitionsResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RaftService_GetPartitionsClient = grpc.ServerStreamingClient[GetPartitionsResponse]

func (c *raftServiceClient) GetClusterInfo(ctx context.Context, in *RaftClusterInfoRequest, opts ...grpc.CallOption) (*RaftClusterInfoResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(RaftClusterInfoResponse)
	err := c.cc.Invoke(ctx, RaftService_GetClusterInfo_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RaftServiceServer is the server API for RaftService service.
// All implementations must embed UnimplementedRaftServiceServer
// for forward compatibility.
//
// RaftService manages the sending of Raft messages to peers.
type RaftServiceServer interface {
	// SendMessage processes Raft messages and ensures they are handled by
	// the receiving node to update its Raft state machine.
	SendMessage(grpc.ClientStreamingServer[RaftMessageRequest, RaftMessageResponse]) error
	// SendSnapshot sends raft snapshots from the leader to the follower node. Typically it
	// would be useful for nodes to catch up to the latest state.
	SendSnapshot(grpc.ClientStreamingServer[RaftSnapshotMessageRequest, RaftSnapshotMessageResponse]) error
	// JoinCluster is called by the leader to instruct a new node to join an existing cluster.
	JoinCluster(context.Context, *JoinClusterRequest) (*JoinClusterResponse, error)
	// GetPartitions retrieves comprehensive information about the Raft cluster topology,
	// partition states, and replica health. This is useful for monitoring and debugging.
	// Returns a stream of partition information, one response per partition.
	GetPartitions(*GetPartitionsRequest, grpc.ServerStreamingServer[GetPartitionsResponse]) error
	// GetClusterInfo retrieves cluster-wide statistics and overview information.
	// This is a unary RPC that returns only aggregated statistics, not partition details.
	GetClusterInfo(context.Context, *RaftClusterInfoRequest) (*RaftClusterInfoResponse, error)
	mustEmbedUnimplementedRaftServiceServer()
}

// UnimplementedRaftServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedRaftServiceServer struct{}

func (UnimplementedRaftServiceServer) SendMessage(grpc.ClientStreamingServer[RaftMessageRequest, RaftMessageResponse]) error {
	return status.Errorf(codes.Unimplemented, "method SendMessage not implemented")
}
func (UnimplementedRaftServiceServer) SendSnapshot(grpc.ClientStreamingServer[RaftSnapshotMessageRequest, RaftSnapshotMessageResponse]) error {
	return status.Errorf(codes.Unimplemented, "method SendSnapshot not implemented")
}
func (UnimplementedRaftServiceServer) JoinCluster(context.Context, *JoinClusterRequest) (*JoinClusterResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method JoinCluster not implemented")
}
func (UnimplementedRaftServiceServer) GetPartitions(*GetPartitionsRequest, grpc.ServerStreamingServer[GetPartitionsResponse]) error {
	return status.Errorf(codes.Unimplemented, "method GetPartitions not implemented")
}
func (UnimplementedRaftServiceServer) GetClusterInfo(context.Context, *RaftClusterInfoRequest) (*RaftClusterInfoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetClusterInfo not implemented")
}
func (UnimplementedRaftServiceServer) mustEmbedUnimplementedRaftServiceServer() {}
func (UnimplementedRaftServiceServer) testEmbeddedByValue()                     {}

// UnsafeRaftServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RaftServiceServer will
// result in compilation errors.
type UnsafeRaftServiceServer interface {
	mustEmbedUnimplementedRaftServiceServer()
}

func RegisterRaftServiceServer(s grpc.ServiceRegistrar, srv RaftServiceServer) {
	// If the following call pancis, it indicates UnimplementedRaftServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&RaftService_ServiceDesc, srv)
}

func _RaftService_SendMessage_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RaftServiceServer).SendMessage(&grpc.GenericServerStream[RaftMessageRequest, RaftMessageResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RaftService_SendMessageServer = grpc.ClientStreamingServer[RaftMessageRequest, RaftMessageResponse]

func _RaftService_SendSnapshot_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(RaftServiceServer).SendSnapshot(&grpc.GenericServerStream[RaftSnapshotMessageRequest, RaftSnapshotMessageResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RaftService_SendSnapshotServer = grpc.ClientStreamingServer[RaftSnapshotMessageRequest, RaftSnapshotMessageResponse]

func _RaftService_JoinCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(JoinClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RaftServiceServer).JoinCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RaftService_JoinCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RaftServiceServer).JoinCluster(ctx, req.(*JoinClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RaftService_GetPartitions_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetPartitionsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(RaftServiceServer).GetPartitions(m, &grpc.GenericServerStream[GetPartitionsRequest, GetPartitionsResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type RaftService_GetPartitionsServer = grpc.ServerStreamingServer[GetPartitionsResponse]

func _RaftService_GetClusterInfo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RaftClusterInfoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RaftServiceServer).GetClusterInfo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: RaftService_GetClusterInfo_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RaftServiceServer).GetClusterInfo(ctx, req.(*RaftClusterInfoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// RaftService_ServiceDesc is the grpc.ServiceDesc for RaftService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RaftService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.RaftService",
	HandlerType: (*RaftServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "JoinCluster",
			Handler:    _RaftService_JoinCluster_Handler,
		},
		{
			MethodName: "GetClusterInfo",
			Handler:    _RaftService_GetClusterInfo_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "SendMessage",
			Handler:       _RaftService_SendMessage_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "SendSnapshot",
			Handler:       _RaftService_SendSnapshot_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "GetPartitions",
			Handler:       _RaftService_GetPartitions_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "cluster.proto",
}
