/* WindowCloneContainer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WindowCloneContainer.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2014 Tom Beckmann
 *                         2025 elementary, Inc. (https://elementary.io)
 */

#include "gala.h"
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <clutter/clutter.h>
#include <meta/window.h>
#include <gio/gio.h>
#include <meta/common.h>
#include <meta/meta-plugin.h>
#include <meta/display.h>
#include <mtk/mtk.h>
#include <graphene-gobject.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WINDOW_CLONE_CONTAINER (gala_window_clone_container_get_type ())
#define GALA_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer))
#define GALA_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))
#define GALA_IS_WINDOW_CLONE_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_IS_WINDOW_CLONE_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE_CONTAINER))
#define GALA_WINDOW_CLONE_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainerClass))

typedef struct _GalaWindowCloneContainer GalaWindowCloneContainer;
typedef struct _GalaWindowCloneContainerClass GalaWindowCloneContainerClass;
typedef struct _GalaWindowCloneContainerPrivate GalaWindowCloneContainerPrivate;

#define GALA_TYPE_WINDOW_LIST_MODEL (gala_window_list_model_get_type ())
#define GALA_WINDOW_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModel))
#define GALA_WINDOW_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModelClass))
#define GALA_IS_WINDOW_LIST_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_LIST_MODEL))
#define GALA_IS_WINDOW_LIST_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_LIST_MODEL))
#define GALA_WINDOW_LIST_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_LIST_MODEL, GalaWindowListModelClass))

typedef struct _GalaWindowListModel GalaWindowListModel;
typedef struct _GalaWindowListModelClass GalaWindowListModelClass;

#define GALA_TYPE_WINDOW_CLONE (gala_window_clone_get_type ())
#define GALA_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowClone))
#define GALA_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))
#define GALA_IS_WINDOW_CLONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WINDOW_CLONE))
#define GALA_IS_WINDOW_CLONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WINDOW_CLONE))
#define GALA_WINDOW_CLONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WINDOW_CLONE, GalaWindowCloneClass))

typedef struct _GalaWindowClone GalaWindowClone;
typedef struct _GalaWindowCloneClass GalaWindowCloneClass;
enum  {
	GALA_WINDOW_CLONE_CONTAINER_0_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_WINDOWS_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY,
	GALA_WINDOW_CLONE_CONTAINER_NUM_PROPERTIES
};
static GParamSpec* gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GALA_WINDOW_CLONE_CONTAINER_TYPE_TILABLE_WINDOW (gala_window_clone_container_tilable_window_get_type ())
typedef struct _GalaWindowCloneContainerTilableWindow GalaWindowCloneContainerTilableWindow;
#define _gala_window_clone_container_tilable_window_free0(var) ((var == NULL) ? NULL : (var = (gala_window_clone_container_tilable_window_free (var), NULL)))
#define __vala_MtkRectangle_free0(var) ((var == NULL) ? NULL : (var = (_vala_MtkRectangle_free (var), NULL)))
enum  {
	GALA_WINDOW_CLONE_CONTAINER_WINDOW_SELECTED_SIGNAL,
	GALA_WINDOW_CLONE_CONTAINER_REQUESTED_CLOSE_SIGNAL,
	GALA_WINDOW_CLONE_CONTAINER_NUM_SIGNALS
};
static guint gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_NUM_SIGNALS] = {0};

struct _GalaWindowCloneContainer {
	GalaActorTarget parent_instance;
	GalaWindowCloneContainerPrivate * priv;
};

struct _GalaWindowCloneContainerClass {
	GalaActorTargetClass parent_class;
};

struct _GalaWindowCloneContainerPrivate {
	gint _padding_top;
	gint _padding_left;
	gint _padding_right;
	gint _padding_bottom;
	GalaWindowManager* _wm;
	GalaWindowListModel* _windows;
	gfloat _monitor_scale;
	gboolean _overview_mode;
	gboolean opened;
	GalaWindowClone* current_window;
};

struct _GalaWindowCloneContainerTilableWindow {
	GalaWindowClone* clone;
	MtkRectangle rect;
};

static gint GalaWindowCloneContainer_private_offset;
static gpointer gala_window_clone_container_parent_class = NULL;

VALA_EXTERN GType gala_window_clone_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowCloneContainer, g_object_unref)
VALA_EXTERN GType gala_window_list_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowListModel, g_object_unref)
VALA_EXTERN GType gala_window_clone_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWindowClone, g_object_unref)
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_new (GalaWindowManager* wm,
                                                           GalaWindowListModel* windows,
                                                           gfloat monitor_scale,
                                                           gboolean overview_mode);
VALA_EXTERN GalaWindowCloneContainer* gala_window_clone_container_construct (GType object_type,
                                                                 GalaWindowManager* wm,
                                                                 GalaWindowListModel* windows,
                                                                 gfloat monitor_scale,
                                                                 gboolean overview_mode);
static void gala_window_clone_container_on_items_changed (GalaWindowCloneContainer* self,
                                                   guint position,
                                                   guint removed,
                                                   guint added);
static void _g_object_unref0_ (gpointer var);
VALA_EXTERN MetaWindow* gala_window_clone_get_window (GalaWindowClone* self);
VALA_EXTERN GalaWindowListModel* gala_window_clone_container_get_windows (GalaWindowCloneContainer* self);
VALA_EXTERN GalaWindowManager* gala_window_clone_container_get_wm (GalaWindowCloneContainer* self);
VALA_EXTERN gfloat gala_window_clone_container_get_monitor_scale (GalaWindowCloneContainer* self);
VALA_EXTERN gboolean gala_window_clone_container_get_overview_mode (GalaWindowCloneContainer* self);
VALA_EXTERN GalaWindowClone* gala_window_clone_new (GalaWindowManager* wm,
                                        MetaWindow* window,
                                        gfloat monitor_scale,
                                        gboolean overview_mode);
VALA_EXTERN GalaWindowClone* gala_window_clone_construct (GType object_type,
                                              GalaWindowManager* wm,
                                              MetaWindow* window,
                                              gfloat monitor_scale,
                                              gboolean overview_mode);
static void ______lambda71_ (GalaWindowCloneContainer* self,
                      GalaWindowClone* _clone);
static void _______lambda71__gala_window_clone_selected (GalaWindowClone* _sender,
                                                  gpointer self);
static void ______lambda72_ (GalaWindowCloneContainer* self);
static void gala_window_clone_container_reflow (GalaWindowCloneContainer* self,
                                         gboolean view_toggle);
static void _______lambda72__gala_window_clone_request_reposition (GalaWindowClone* _sender,
                                                            gpointer self);
VALA_EXTERN void gala_window_clone_container_select_next_window (GalaWindowCloneContainer* self,
                                                     MetaMotionDirection direction,
                                                     gboolean user_action);
static void gala_window_clone_container_real_start_progress (GalaActorTarget* base,
                                                      GalaGestureAction action);
VALA_EXTERN void gala_window_clone_set_active (GalaWindowClone* self,
                                   gboolean value);
VALA_EXTERN void gala_window_list_model_sort (GalaWindowListModel* self);
static void gala_window_clone_container_real_commit_progress (GalaActorTarget* base,
                                                       GalaGestureAction action,
                                                       gdouble to);
static GType gala_window_clone_container_tilable_window_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GalaWindowCloneContainerTilableWindow* gala_window_clone_container_tilable_window_dup (const GalaWindowCloneContainerTilableWindow* self);
static void gala_window_clone_container_tilable_window_free (GalaWindowCloneContainerTilableWindow* self);
static gint __lambda73_ (GalaWindowCloneContainerTilableWindow* a,
                  GalaWindowCloneContainerTilableWindow* b);
static gint ___lambda73__gcompare_func (gconstpointer a,
                                 gconstpointer b);
VALA_EXTERN gint gala_window_clone_container_get_padding_left (GalaWindowCloneContainer* self);
VALA_EXTERN gint gala_window_clone_container_get_padding_top (GalaWindowCloneContainer* self);
VALA_EXTERN gint gala_window_clone_container_get_padding_right (GalaWindowCloneContainer* self);
VALA_EXTERN gint gala_window_clone_container_get_padding_bottom (GalaWindowCloneContainer* self);
static GList* gala_window_clone_container_calculate_grid_placement (GalaWindowCloneContainer* self,
                                                             MtkRectangle* area,
                                                             GList* windows);
VALA_EXTERN void gala_window_clone_take_slot (GalaWindowClone* self,
                                  MtkRectangle* rect,
                                  gboolean animate);
static void _gala_window_clone_container_tilable_window_free0_ (gpointer var);
static inline void _g_list_free__gala_window_clone_container_tilable_window_free0_ (GList* self);
static gboolean gala_window_clone_container_real_key_press_event (ClutterActor* base,
                                                           ClutterEvent* event);
VALA_EXTERN MtkRectangle* gala_window_clone_get_slot (GalaWindowClone* self);
static MtkRectangle* _vala_MtkRectangle_copy (MtkRectangle* self);
static void _vala_MtkRectangle_free (MtkRectangle* self);
VALA_EXTERN void gala_internal_utils_bell_notify (MetaDisplay* display);
static gfloat gala_window_clone_container_squared_distance (graphene_point_t* a,
                                                     graphene_point_t* b);
static void gala_window_clone_container_rect_adjusted (MtkRectangle* rect,
                                                gint dw,
                                                gint dh,
                                                MtkRectangle* result);
static void gala_window_clone_container_rect_center (MtkRectangle* rect,
                                              graphene_point_t* result);
static gboolean _mtk_rectangle_equal (const MtkRectangle * s1,
                               const MtkRectangle * s2);
static gboolean _gala_window_clone_container_tilable_window_equal (const GalaWindowCloneContainerTilableWindow * s1,
                                                            const GalaWindowCloneContainerTilableWindow * s2);
VALA_EXTERN void gala_window_clone_container_set_padding_top (GalaWindowCloneContainer* self,
                                                  gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_left (GalaWindowCloneContainer* self,
                                                   gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_right (GalaWindowCloneContainer* self,
                                                    gint value);
VALA_EXTERN void gala_window_clone_container_set_padding_bottom (GalaWindowCloneContainer* self,
                                                     gint value);
static void gala_window_clone_container_set_wm (GalaWindowCloneContainer* self,
                                         GalaWindowManager* value);
static void gala_window_clone_container_set_windows (GalaWindowCloneContainer* self,
                                              GalaWindowListModel* value);
VALA_EXTERN void gala_window_clone_container_set_monitor_scale (GalaWindowCloneContainer* self,
                                                    gfloat value);
static void gala_window_clone_container_set_overview_mode (GalaWindowCloneContainer* self,
                                                    gboolean value);
static GObject * gala_window_clone_container_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static void _gala_window_clone_container_on_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                               guint position,
                                                                               guint removed,
                                                                               guint added,
                                                                               gpointer self);
static void gala_window_clone_container_finalize (GObject * obj);
static GType gala_window_clone_container_get_type_once (void);
static void _vala_gala_window_clone_container_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_gala_window_clone_container_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gala_window_clone_container_get_instance_private (GalaWindowCloneContainer* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWindowCloneContainer_private_offset);
}

GalaWindowCloneContainer*
gala_window_clone_container_construct (GType object_type,
                                       GalaWindowManager* wm,
                                       GalaWindowListModel* windows,
                                       gfloat monitor_scale,
                                       gboolean overview_mode)
{
	GalaWindowCloneContainer * self = NULL;
	g_return_val_if_fail (wm != NULL, NULL);
	g_return_val_if_fail (windows != NULL, NULL);
	self = (GalaWindowCloneContainer*) g_object_new (object_type, "wm", wm, "windows", windows, "monitor-scale", monitor_scale, "overview-mode", overview_mode, NULL);
	return self;
}

GalaWindowCloneContainer*
gala_window_clone_container_new (GalaWindowManager* wm,
                                 GalaWindowListModel* windows,
                                 gfloat monitor_scale,
                                 gboolean overview_mode)
{
	return gala_window_clone_container_construct (GALA_TYPE_WINDOW_CLONE_CONTAINER, wm, windows, monitor_scale, overview_mode);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_vala_g_hash_table_take (GHashTable* self,
                         gconstpointer key,
                         gboolean* exists)
{
	gboolean _vala_exists = FALSE;
	GHashTable* ht = NULL;
	void** htp = NULL;
	gconstpointer _tmp0_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	ht = NULL;
	htp = &ht;
	_tmp0_ = g_hash_table_lookup (self, key);
	*htp = _tmp0_;
	_vala_exists = g_hash_table_steal (self, key);
	result = ht;
	if (exists) {
		*exists = _vala_exists;
	}
	return result;
}

static void
______lambda71_ (GalaWindowCloneContainer* self,
                 GalaWindowClone* _clone)
{
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	g_return_if_fail (_clone != NULL);
	_tmp0_ = gala_window_clone_get_window (_clone);
	_tmp1_ = _tmp0_;
	g_signal_emit (self, gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_WINDOW_SELECTED_SIGNAL], 0, _tmp1_);
}

static void
_______lambda71__gala_window_clone_selected (GalaWindowClone* _sender,
                                             gpointer self)
{
	______lambda71_ ((GalaWindowCloneContainer*) self, _sender);
}

static void
______lambda72_ (GalaWindowCloneContainer* self)
{
	gala_window_clone_container_reflow (self, FALSE);
}

static void
_______lambda72__gala_window_clone_request_reposition (GalaWindowClone* _sender,
                                                       gpointer self)
{
	______lambda72_ ((GalaWindowCloneContainer*) self);
}

static void
gala_window_clone_container_on_items_changed (GalaWindowCloneContainer* self,
                                              guint position,
                                              guint removed,
                                              guint added)
{
	GHashTable* to_remove = NULL;
	GHashTable* _tmp0_;
	gboolean _tmp30_ = FALSE;
	GalaWindowClone* _tmp31_;
	gboolean _tmp40_ = FALSE;
	GHashTable* _tmp41_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_hash_table_new_full (NULL, NULL, _g_object_unref0_, _g_object_unref0_);
	to_remove = _tmp0_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GalaWindowClone* window_clone = NULL;
				ClutterActor* _tmp3_;
				GalaWindowClone* _tmp4_;
				GHashTable* _tmp5_;
				GalaWindowClone* _tmp6_;
				MetaWindow* _tmp7_;
				MetaWindow* _tmp8_;
				MetaWindow* _tmp9_;
				GalaWindowClone* _tmp10_;
				GalaWindowClone* _tmp11_;
				GalaWindowClone* _tmp12_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < removed)) {
					break;
				}
				_tmp3_ = clutter_actor_get_child_at_index ((ClutterActor*) self, (gint) position);
				_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
				window_clone = _tmp4_;
				_tmp5_ = to_remove;
				_tmp6_ = window_clone;
				_tmp7_ = gala_window_clone_get_window (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = _g_object_ref0 (_tmp8_);
				_tmp10_ = window_clone;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				g_hash_table_insert (_tmp5_, _tmp9_, _tmp11_);
				_tmp12_ = window_clone;
				clutter_actor_remove_child ((ClutterActor*) self, (ClutterActor*) _tmp12_);
				_g_object_unref0 (window_clone);
			}
		}
	}
	{
		gint i = 0;
		i = (gint) position;
		{
			gboolean _tmp13_ = FALSE;
			_tmp13_ = TRUE;
			while (TRUE) {
				MetaWindow* window = NULL;
				GalaWindowListModel* _tmp15_;
				GObject* _tmp16_;
				GalaWindowClone* clone = NULL;
				GHashTable* _tmp17_;
				MetaWindow* _tmp18_;
				gpointer _tmp19_;
				GalaWindowClone* _tmp20_;
				GalaWindowClone* _tmp29_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp13_ = FALSE;
				if (!(((guint) i) < (position + added))) {
					break;
				}
				_tmp15_ = self->priv->_windows;
				_tmp16_ = g_list_model_get_item ((GListModel*) _tmp15_, (guint) i);
				window = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, meta_window_get_type (), MetaWindow);
				_tmp17_ = to_remove;
				_tmp18_ = window;
				_tmp19_ = _vala_g_hash_table_take (_tmp17_, _tmp18_, NULL);
				clone = (GalaWindowClone*) _tmp19_;
				_tmp20_ = clone;
				if (_tmp20_ == NULL) {
					GalaWindowManager* _tmp21_;
					MetaWindow* _tmp22_;
					gfloat _tmp23_;
					gboolean _tmp24_;
					GalaWindowClone* _tmp25_;
					GalaWindowClone* _tmp26_;
					GalaWindowClone* _tmp27_;
					GalaWindowClone* _tmp28_;
					_tmp21_ = self->priv->_wm;
					_tmp22_ = window;
					_tmp23_ = self->priv->_monitor_scale;
					_tmp24_ = self->priv->_overview_mode;
					_tmp25_ = gala_window_clone_new (_tmp21_, _tmp22_, _tmp23_, _tmp24_);
					g_object_ref_sink (_tmp25_);
					_g_object_unref0 (clone);
					clone = _tmp25_;
					_tmp26_ = clone;
					g_signal_connect_object (_tmp26_, "selected", (GCallback) _______lambda71__gala_window_clone_selected, self, 0);
					_tmp27_ = clone;
					g_signal_connect_object (_tmp27_, "request-reposition", (GCallback) _______lambda72__gala_window_clone_request_reposition, self, 0);
					_tmp28_ = clone;
					g_object_bind_property_with_closures ((GObject*) self, "monitor-scale", (GObject*) _tmp28_, "monitor-scale", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
				}
				_tmp29_ = clone;
				clutter_actor_insert_child_at_index ((ClutterActor*) self, (ClutterActor*) _tmp29_, i);
				_g_object_unref0 (clone);
				_g_object_unref0 (window);
			}
		}
	}
	_tmp31_ = self->priv->current_window;
	if (_tmp31_ != NULL) {
		GHashTable* _tmp32_;
		GalaWindowClone* _tmp33_;
		MetaWindow* _tmp34_;
		MetaWindow* _tmp35_;
		_tmp32_ = to_remove;
		_tmp33_ = self->priv->current_window;
		_tmp34_ = gala_window_clone_get_window (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp30_ = g_hash_table_contains (_tmp32_, _tmp35_);
	} else {
		_tmp30_ = FALSE;
	}
	if (_tmp30_) {
		GHashTable* _tmp36_;
		GalaWindowClone* _tmp37_;
		MetaWindow* _tmp38_;
		MetaWindow* _tmp39_;
		gala_window_clone_container_select_next_window (self, META_MOTION_RIGHT, FALSE);
		_tmp36_ = to_remove;
		_tmp37_ = self->priv->current_window;
		_tmp38_ = gala_window_clone_get_window (_tmp37_);
		_tmp39_ = _tmp38_;
		if (g_hash_table_contains (_tmp36_, _tmp39_)) {
			self->priv->current_window = NULL;
		}
	}
	_tmp41_ = to_remove;
	if (g_hash_table_size (_tmp41_) > ((guint) 0)) {
		_tmp40_ = TRUE;
	} else {
		_tmp40_ = added != removed;
	}
	if (_tmp40_) {
		gala_window_clone_container_reflow (self, FALSE);
	}
	_g_hash_table_unref0 (to_remove);
}

static void
gala_window_clone_container_real_start_progress (GalaActorTarget* base,
                                                 GalaGestureAction action)
{
	GalaWindowCloneContainer * self;
	self = (GalaWindowCloneContainer*) base;
	if (!self->priv->opened) {
		GalaWindowClone* _tmp0_;
		MetaWindow* focus_window = NULL;
		GalaWindowManager* _tmp2_;
		MetaDisplay* _tmp3_;
		MetaWindow* _tmp4_;
		MetaWindow* _tmp5_;
		GList* _tmp6_;
		GalaWindowListModel* _tmp12_;
		self->priv->opened = TRUE;
		_tmp0_ = self->priv->current_window;
		if (_tmp0_ != NULL) {
			GalaWindowClone* _tmp1_;
			_tmp1_ = self->priv->current_window;
			gala_window_clone_set_active (_tmp1_, FALSE);
		}
		_tmp2_ = self->priv->_wm;
		_tmp3_ = meta_plugin_get_display ((MetaPlugin*) _tmp2_);
		_tmp4_ = meta_display_get_focus_window (_tmp3_);
		_tmp5_ = _tmp4_;
		focus_window = _tmp5_;
		_tmp6_ = clutter_actor_get_children ((ClutterActor*) self);
		{
			GList* clone_collection = NULL;
			GList* clone_it = NULL;
			clone_collection = (GList*) _tmp6_;
			for (clone_it = clone_collection; clone_it != NULL; clone_it = clone_it->next) {
				GalaWindowClone* clone = NULL;
				clone = (GalaWindowClone*) clone_it->data;
				{
					GalaWindowClone* _tmp7_;
					MetaWindow* _tmp8_;
					MetaWindow* _tmp9_;
					MetaWindow* _tmp10_;
					_tmp7_ = clone;
					_tmp8_ = gala_window_clone_get_window (_tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = focus_window;
					if (_tmp9_ == _tmp10_) {
						GalaWindowClone* _tmp11_;
						_tmp11_ = clone;
						self->priv->current_window = _tmp11_;
						break;
					}
				}
			}
			(clone_collection == NULL) ? NULL : (clone_collection = (g_list_free (clone_collection), NULL));
		}
		_tmp12_ = self->priv->_windows;
		gala_window_list_model_sort (_tmp12_);
		gala_window_clone_container_reflow (self, TRUE);
	} else {
		if (action == GALA_GESTURE_ACTION_MULTITASKING_VIEW) {
			GalaWindowListModel* _tmp13_;
			_tmp13_ = self->priv->_windows;
			gala_window_list_model_sort (_tmp13_);
		}
	}
}

static void
gala_window_clone_container_real_commit_progress (GalaActorTarget* base,
                                                  GalaGestureAction action,
                                                  gdouble to)
{
	GalaWindowCloneContainer * self;
	self = (GalaWindowCloneContainer*) base;
	switch (action) {
		case GALA_GESTURE_ACTION_MULTITASKING_VIEW:
		{
			self->priv->opened = to > 0.5;
			break;
		}
		case GALA_GESTURE_ACTION_SWITCH_WORKSPACE:
		{
			self->priv->opened = gala_actor_target_get_current_commit ((GalaActorTarget*) self, GALA_GESTURE_ACTION_MULTITASKING_VIEW) > 0.5;
			break;
		}
		default:
		{
			break;
		}
	}
}

/**
     * Recalculate the tiling positions of the windows and animate them to the resulting spots.
     */
static gpointer
_gala_window_clone_container_tilable_window_dup0 (gpointer self)
{
	return self ? gala_window_clone_container_tilable_window_dup (self) : NULL;
}

static gint
__lambda73_ (GalaWindowCloneContainerTilableWindow* a,
             GalaWindowCloneContainerTilableWindow* b)
{
	guint seq_a = 0U;
	GalaWindowClone* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	guint seq_b = 0U;
	GalaWindowClone* _tmp3_;
	MetaWindow* _tmp4_;
	MetaWindow* _tmp5_;
	gint result;
	_tmp0_ = (*a).clone;
	_tmp1_ = gala_window_clone_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
	_tmp2_ = _tmp1_;
	seq_a = meta_window_get_stable_sequence (_tmp2_);
	_tmp3_ = (*b).clone;
	_tmp4_ = gala_window_clone_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
	_tmp5_ = _tmp4_;
	seq_b = meta_window_get_stable_sequence (_tmp5_);
	result = (gint) (seq_b - seq_a);
	return result;
}

static gint
___lambda73__gcompare_func (gconstpointer a,
                            gconstpointer b)
{
	gint result;
	result = __lambda73_ ((GalaWindowCloneContainerTilableWindow*) a, (GalaWindowCloneContainerTilableWindow*) b);
	return result;
}

static void
_gala_window_clone_container_tilable_window_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (gala_window_clone_container_tilable_window_free (var), NULL));
}

static inline void
_g_list_free__gala_window_clone_container_tilable_window_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _gala_window_clone_container_tilable_window_free0_);
}

static void
gala_window_clone_container_reflow (GalaWindowCloneContainer* self,
                                    gboolean view_toggle)
{
	gboolean _tmp0_ = FALSE;
	GList* windows = NULL;
	GList* _tmp1_;
	MtkRectangle area = {0};
	gint _tmp9_;
	gint _tmp10_;
	gfloat _tmp11_;
	gfloat _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gfloat _tmp15_;
	gfloat _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	MtkRectangle _tmp19_ = {0};
	MtkRectangle _tmp20_;
	GList* _tmp21_;
	GList* _tmp22_;
	g_return_if_fail (self != NULL);
	if (!self->priv->opened) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = clutter_actor_get_n_children ((ClutterActor*) self) == 0;
	}
	if (_tmp0_) {
		return;
	}
	windows = NULL;
	_tmp1_ = clutter_actor_get_children ((ClutterActor*) self);
	{
		GList* clone_collection = NULL;
		GList* clone_it = NULL;
		clone_collection = (GList*) _tmp1_;
		for (clone_it = clone_collection; clone_it != NULL; clone_it = clone_it->next) {
			GalaWindowClone* clone = NULL;
			clone = (GalaWindowClone*) clone_it->data;
			{
				GalaWindowClone* _tmp2_;
				GalaWindowClone* _tmp3_;
				MetaWindow* _tmp4_;
				MetaWindow* _tmp5_;
				MtkRectangle _tmp6_ = {0};
				GalaWindowCloneContainerTilableWindow _tmp7_ = {0};
				GalaWindowCloneContainerTilableWindow* _tmp8_;
				_tmp2_ = clone;
				_tmp3_ = clone;
				_tmp4_ = gala_window_clone_get_window (_tmp3_);
				_tmp5_ = _tmp4_;
				meta_window_get_frame_rect (_tmp5_, &_tmp6_);
				_tmp7_.clone = _tmp2_;
				_tmp7_.rect = _tmp6_;
				_tmp8_ = _gala_window_clone_container_tilable_window_dup0 (&_tmp7_);
				windows = g_list_prepend (windows, _tmp8_);
			}
		}
		(clone_collection == NULL) ? NULL : (clone_collection = (g_list_free (clone_collection), NULL));
	}
	windows = g_list_sort (windows, ___lambda73__gcompare_func);
	_tmp9_ = self->priv->_padding_left;
	_tmp10_ = self->priv->_padding_top;
	_tmp11_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->_padding_left;
	_tmp14_ = self->priv->_padding_right;
	_tmp15_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->_padding_top;
	_tmp18_ = self->priv->_padding_bottom;
	_tmp19_.x = _tmp9_;
	_tmp19_.y = _tmp10_;
	_tmp19_.width = (((gint) _tmp12_) - _tmp13_) - _tmp14_;
	_tmp19_.height = (((gint) _tmp16_) - _tmp17_) - _tmp18_;
	area = _tmp19_;
	_tmp20_ = area;
	_tmp21_ = windows;
	_tmp22_ = gala_window_clone_container_calculate_grid_placement (self, &_tmp20_, _tmp21_);
	{
		GList* tilable_collection = NULL;
		GList* tilable_it = NULL;
		tilable_collection = _tmp22_;
		for (tilable_it = tilable_collection; tilable_it != NULL; tilable_it = tilable_it->next) {
			GalaWindowCloneContainerTilableWindow* _tmp23_;
			GalaWindowCloneContainerTilableWindow* tilable = NULL;
			_tmp23_ = _gala_window_clone_container_tilable_window_dup0 ((GalaWindowCloneContainerTilableWindow*) tilable_it->data);
			tilable = _tmp23_;
			{
				GalaWindowCloneContainerTilableWindow* _tmp24_;
				GalaWindowClone* _tmp25_;
				GalaWindowCloneContainerTilableWindow* _tmp26_;
				MtkRectangle _tmp27_;
				_tmp24_ = tilable;
				_tmp25_ = (*_tmp24_).clone;
				_tmp26_ = tilable;
				_tmp27_ = (*_tmp26_).rect;
				gala_window_clone_take_slot (_tmp25_, &_tmp27_, !view_toggle);
				_gala_window_clone_container_tilable_window_free0 (tilable);
			}
		}
		(tilable_collection == NULL) ? NULL : (tilable_collection = (_g_list_free__gala_window_clone_container_tilable_window_free0_ (tilable_collection), NULL));
	}
	(windows == NULL) ? NULL : (windows = (_g_list_free__gala_window_clone_container_tilable_window_free0_ (windows), NULL));
}

/**
     * Collect key events, mainly for redirecting them to the WindowCloneContainers to
     * select the active window.
     */
static gboolean
gala_window_clone_container_real_key_press_event (ClutterActor* base,
                                                  ClutterEvent* event)
{
	GalaWindowCloneContainer * self;
	gboolean result;
	self = (GalaWindowCloneContainer*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	if (!self->priv->opened) {
		result = CLUTTER_EVENT_PROPAGATE;
		return result;
	}
	switch (clutter_event_get_key_symbol (event)) {
		case CLUTTER_KEY_Escape:
		{
			g_signal_emit (self, gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_REQUESTED_CLOSE_SIGNAL], 0);
			break;
		}
		case CLUTTER_KEY_Down:
		{
			gala_window_clone_container_select_next_window (self, META_MOTION_DOWN, TRUE);
			break;
		}
		case CLUTTER_KEY_Up:
		{
			gala_window_clone_container_select_next_window (self, META_MOTION_UP, TRUE);
			break;
		}
		case CLUTTER_KEY_Left:
		{
			gala_window_clone_container_select_next_window (self, META_MOTION_LEFT, TRUE);
			break;
		}
		case CLUTTER_KEY_Right:
		{
			gala_window_clone_container_select_next_window (self, META_MOTION_RIGHT, TRUE);
			break;
		}
		case CLUTTER_KEY_Return:
		case CLUTTER_KEY_KP_Enter:
		{
			GalaWindowClone* _tmp0_;
			_tmp0_ = self->priv->current_window;
			if (_tmp0_ == NULL) {
				g_signal_emit (self, gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_REQUESTED_CLOSE_SIGNAL], 0);
			} else {
				GalaWindowClone* _tmp1_;
				MetaWindow* _tmp2_;
				MetaWindow* _tmp3_;
				_tmp1_ = self->priv->current_window;
				_tmp2_ = gala_window_clone_get_window (_tmp1_);
				_tmp3_ = _tmp2_;
				g_signal_emit (self, gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_WINDOW_SELECTED_SIGNAL], 0, _tmp3_);
			}
			break;
		}
		default:
		break;
	}
	result = CLUTTER_EVENT_STOP;
	return result;
}

/**
     * Look for the next window in a direction and make this window the new current_window.
     * Used for keyboard navigation.
     *
     * @param direction   The MetaMotionDirection in which to search for windows for.
     * @param user_action Whether we must select a window and, if failed, play a bell sound.
     */
static MtkRectangle*
_vala_MtkRectangle_copy (MtkRectangle* self)
{
	return g_boxed_copy (mtk_rectangle_get_type (), self);
}

static gpointer
__vala_MtkRectangle_copy0 (gpointer self)
{
	return self ? _vala_MtkRectangle_copy (self) : NULL;
}

static void
_vala_MtkRectangle_free (MtkRectangle* self)
{
	g_boxed_free (mtk_rectangle_get_type (), self);
}

void
gala_window_clone_container_select_next_window (GalaWindowCloneContainer* self,
                                                MetaMotionDirection direction,
                                                gboolean user_action)
{
	GalaWindowClone* closest = NULL;
	GalaWindowClone* _tmp0_;
	GalaWindowClone* _tmp83_;
	GalaWindowClone* _tmp89_;
	GalaWindowClone* _tmp92_;
	g_return_if_fail (self != NULL);
	if (clutter_actor_get_n_children ((ClutterActor*) self) == 0) {
		return;
	}
	closest = NULL;
	_tmp0_ = self->priv->current_window;
	if (_tmp0_ == NULL) {
		ClutterActor* _tmp1_;
		GalaWindowClone* _tmp2_;
		_tmp1_ = clutter_actor_get_child_at_index ((ClutterActor*) self, 0);
		_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GALA_TYPE_WINDOW_CLONE, GalaWindowClone));
		_g_object_unref0 (closest);
		closest = _tmp2_;
	} else {
		MtkRectangle* current_rect = NULL;
		GalaWindowClone* _tmp3_;
		MtkRectangle* _tmp4_;
		MtkRectangle* _tmp5_;
		MtkRectangle* _tmp6_;
		GList* _tmp7_;
		_tmp3_ = self->priv->current_window;
		_tmp4_ = gala_window_clone_get_slot (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = __vala_MtkRectangle_copy0 (_tmp5_);
		current_rect = _tmp6_;
		_tmp7_ = clutter_actor_get_children ((ClutterActor*) self);
		{
			GList* clone_collection = NULL;
			GList* clone_it = NULL;
			clone_collection = (GList*) _tmp7_;
			for (clone_it = clone_collection; clone_it != NULL; clone_it = clone_it->next) {
				GalaWindowClone* clone = NULL;
				clone = (GalaWindowClone*) clone_it->data;
				{
					GalaWindowClone* _tmp8_;
					GalaWindowClone* _tmp9_;
					MtkRectangle* window_rect = NULL;
					GalaWindowClone* _tmp10_;
					MtkRectangle* _tmp11_;
					MtkRectangle* _tmp12_;
					MtkRectangle* _tmp13_;
					MtkRectangle* _tmp14_;
					_tmp8_ = clone;
					_tmp9_ = self->priv->current_window;
					if (_tmp8_ == _tmp9_) {
						continue;
					}
					_tmp10_ = clone;
					_tmp11_ = gala_window_clone_get_slot (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = __vala_MtkRectangle_copy0 (_tmp12_);
					window_rect = _tmp13_;
					_tmp14_ = window_rect;
					if (_tmp14_ == NULL) {
						__vala_MtkRectangle_free0 (window_rect);
						continue;
					}
					if (direction == META_MOTION_LEFT) {
						MtkRectangle* _tmp15_;
						MtkRectangle* _tmp16_;
						gboolean _tmp17_ = FALSE;
						MtkRectangle* _tmp18_;
						MtkRectangle* _tmp19_;
						MtkRectangle* _tmp20_;
						_tmp15_ = window_rect;
						_tmp16_ = current_rect;
						if ((*_tmp15_).x > (*_tmp16_).x) {
							__vala_MtkRectangle_free0 (window_rect);
							continue;
						}
						_tmp18_ = window_rect;
						_tmp19_ = window_rect;
						_tmp20_ = current_rect;
						if (((*_tmp18_).y + (*_tmp19_).height) > (*_tmp20_).y) {
							MtkRectangle* _tmp21_;
							MtkRectangle* _tmp22_;
							MtkRectangle* _tmp23_;
							_tmp21_ = window_rect;
							_tmp22_ = current_rect;
							_tmp23_ = current_rect;
							_tmp17_ = (*_tmp21_).y < ((*_tmp22_).y + (*_tmp23_).height);
						} else {
							_tmp17_ = FALSE;
						}
						if (_tmp17_) {
							gboolean _tmp24_ = FALSE;
							GalaWindowClone* _tmp25_;
							_tmp25_ = closest;
							if (_tmp25_ == NULL) {
								_tmp24_ = TRUE;
							} else {
								GalaWindowClone* _tmp26_;
								MtkRectangle* _tmp27_;
								MtkRectangle* _tmp28_;
								MtkRectangle* _tmp29_;
								_tmp26_ = closest;
								_tmp27_ = gala_window_clone_get_slot (_tmp26_);
								_tmp28_ = _tmp27_;
								_tmp29_ = window_rect;
								_tmp24_ = (*_tmp28_).x < (*_tmp29_).x;
							}
							if (_tmp24_) {
								GalaWindowClone* _tmp30_;
								GalaWindowClone* _tmp31_;
								_tmp30_ = clone;
								_tmp31_ = _g_object_ref0 (_tmp30_);
								_g_object_unref0 (closest);
								closest = _tmp31_;
							}
						}
					} else {
						if (direction == META_MOTION_RIGHT) {
							MtkRectangle* _tmp32_;
							MtkRectangle* _tmp33_;
							gboolean _tmp34_ = FALSE;
							MtkRectangle* _tmp35_;
							MtkRectangle* _tmp36_;
							MtkRectangle* _tmp37_;
							_tmp32_ = window_rect;
							_tmp33_ = current_rect;
							if ((*_tmp32_).x < (*_tmp33_).x) {
								__vala_MtkRectangle_free0 (window_rect);
								continue;
							}
							_tmp35_ = window_rect;
							_tmp36_ = window_rect;
							_tmp37_ = current_rect;
							if (((*_tmp35_).y + (*_tmp36_).height) > (*_tmp37_).y) {
								MtkRectangle* _tmp38_;
								MtkRectangle* _tmp39_;
								MtkRectangle* _tmp40_;
								_tmp38_ = window_rect;
								_tmp39_ = current_rect;
								_tmp40_ = current_rect;
								_tmp34_ = (*_tmp38_).y < ((*_tmp39_).y + (*_tmp40_).height);
							} else {
								_tmp34_ = FALSE;
							}
							if (_tmp34_) {
								gboolean _tmp41_ = FALSE;
								GalaWindowClone* _tmp42_;
								_tmp42_ = closest;
								if (_tmp42_ == NULL) {
									_tmp41_ = TRUE;
								} else {
									GalaWindowClone* _tmp43_;
									MtkRectangle* _tmp44_;
									MtkRectangle* _tmp45_;
									MtkRectangle* _tmp46_;
									_tmp43_ = closest;
									_tmp44_ = gala_window_clone_get_slot (_tmp43_);
									_tmp45_ = _tmp44_;
									_tmp46_ = window_rect;
									_tmp41_ = (*_tmp45_).x > (*_tmp46_).x;
								}
								if (_tmp41_) {
									GalaWindowClone* _tmp47_;
									GalaWindowClone* _tmp48_;
									_tmp47_ = clone;
									_tmp48_ = _g_object_ref0 (_tmp47_);
									_g_object_unref0 (closest);
									closest = _tmp48_;
								}
							}
						} else {
							if (direction == META_MOTION_UP) {
								MtkRectangle* _tmp49_;
								MtkRectangle* _tmp50_;
								gboolean _tmp51_ = FALSE;
								MtkRectangle* _tmp52_;
								MtkRectangle* _tmp53_;
								MtkRectangle* _tmp54_;
								_tmp49_ = window_rect;
								_tmp50_ = current_rect;
								if ((*_tmp49_).y > (*_tmp50_).y) {
									__vala_MtkRectangle_free0 (window_rect);
									continue;
								}
								_tmp52_ = window_rect;
								_tmp53_ = window_rect;
								_tmp54_ = current_rect;
								if (((*_tmp52_).x + (*_tmp53_).width) > (*_tmp54_).x) {
									MtkRectangle* _tmp55_;
									MtkRectangle* _tmp56_;
									MtkRectangle* _tmp57_;
									_tmp55_ = window_rect;
									_tmp56_ = current_rect;
									_tmp57_ = current_rect;
									_tmp51_ = (*_tmp55_).x < ((*_tmp56_).x + (*_tmp57_).width);
								} else {
									_tmp51_ = FALSE;
								}
								if (_tmp51_) {
									gboolean _tmp58_ = FALSE;
									GalaWindowClone* _tmp59_;
									_tmp59_ = closest;
									if (_tmp59_ == NULL) {
										_tmp58_ = TRUE;
									} else {
										GalaWindowClone* _tmp60_;
										MtkRectangle* _tmp61_;
										MtkRectangle* _tmp62_;
										MtkRectangle* _tmp63_;
										_tmp60_ = closest;
										_tmp61_ = gala_window_clone_get_slot (_tmp60_);
										_tmp62_ = _tmp61_;
										_tmp63_ = window_rect;
										_tmp58_ = (*_tmp62_).y < (*_tmp63_).y;
									}
									if (_tmp58_) {
										GalaWindowClone* _tmp64_;
										GalaWindowClone* _tmp65_;
										_tmp64_ = clone;
										_tmp65_ = _g_object_ref0 (_tmp64_);
										_g_object_unref0 (closest);
										closest = _tmp65_;
									}
								}
							} else {
								if (direction == META_MOTION_DOWN) {
									MtkRectangle* _tmp66_;
									MtkRectangle* _tmp67_;
									gboolean _tmp68_ = FALSE;
									MtkRectangle* _tmp69_;
									MtkRectangle* _tmp70_;
									MtkRectangle* _tmp71_;
									_tmp66_ = window_rect;
									_tmp67_ = current_rect;
									if ((*_tmp66_).y < (*_tmp67_).y) {
										__vala_MtkRectangle_free0 (window_rect);
										continue;
									}
									_tmp69_ = window_rect;
									_tmp70_ = window_rect;
									_tmp71_ = current_rect;
									if (((*_tmp69_).x + (*_tmp70_).width) > (*_tmp71_).x) {
										MtkRectangle* _tmp72_;
										MtkRectangle* _tmp73_;
										MtkRectangle* _tmp74_;
										_tmp72_ = window_rect;
										_tmp73_ = current_rect;
										_tmp74_ = current_rect;
										_tmp68_ = (*_tmp72_).x < ((*_tmp73_).x + (*_tmp74_).width);
									} else {
										_tmp68_ = FALSE;
									}
									if (_tmp68_) {
										gboolean _tmp75_ = FALSE;
										GalaWindowClone* _tmp76_;
										_tmp76_ = closest;
										if (_tmp76_ == NULL) {
											_tmp75_ = TRUE;
										} else {
											GalaWindowClone* _tmp77_;
											MtkRectangle* _tmp78_;
											MtkRectangle* _tmp79_;
											MtkRectangle* _tmp80_;
											_tmp77_ = closest;
											_tmp78_ = gala_window_clone_get_slot (_tmp77_);
											_tmp79_ = _tmp78_;
											_tmp80_ = window_rect;
											_tmp75_ = (*_tmp79_).y > (*_tmp80_).y;
										}
										if (_tmp75_) {
											GalaWindowClone* _tmp81_;
											GalaWindowClone* _tmp82_;
											_tmp81_ = clone;
											_tmp82_ = _g_object_ref0 (_tmp81_);
											_g_object_unref0 (closest);
											closest = _tmp82_;
										}
									}
								} else {
									g_warning ("WindowCloneContainer.vala:276: Invalid direction");
									__vala_MtkRectangle_free0 (window_rect);
									break;
								}
							}
						}
					}
					__vala_MtkRectangle_free0 (window_rect);
				}
			}
			(clone_collection == NULL) ? NULL : (clone_collection = (g_list_free (clone_collection), NULL));
		}
		__vala_MtkRectangle_free0 (current_rect);
	}
	_tmp83_ = closest;
	if (_tmp83_ == NULL) {
		gboolean _tmp84_ = FALSE;
		GalaWindowClone* _tmp85_;
		_tmp85_ = self->priv->current_window;
		if (_tmp85_ != NULL) {
			_tmp84_ = user_action;
		} else {
			_tmp84_ = FALSE;
		}
		if (_tmp84_) {
			GalaWindowManager* _tmp86_;
			MetaDisplay* _tmp87_;
			GalaWindowClone* _tmp88_;
			_tmp86_ = self->priv->_wm;
			_tmp87_ = meta_plugin_get_display ((MetaPlugin*) _tmp86_);
			gala_internal_utils_bell_notify (_tmp87_);
			_tmp88_ = self->priv->current_window;
			gala_window_clone_set_active (_tmp88_, TRUE);
		}
		_g_object_unref0 (closest);
		return;
	}
	_tmp89_ = self->priv->current_window;
	if (_tmp89_ != NULL) {
		GalaWindowClone* _tmp90_;
		_tmp90_ = self->priv->current_window;
		gala_window_clone_set_active (_tmp90_, FALSE);
	}
	if (user_action) {
		GalaWindowClone* _tmp91_;
		_tmp91_ = closest;
		gala_window_clone_set_active (_tmp91_, TRUE);
	}
	_tmp92_ = closest;
	self->priv->current_window = _tmp92_;
	_g_object_unref0 (closest);
}

static gfloat
gala_window_clone_container_squared_distance (graphene_point_t* a,
                                              graphene_point_t* b)
{
	gfloat k1 = 0.0F;
	graphene_point_t _tmp0_;
	graphene_point_t _tmp1_;
	gfloat k2 = 0.0F;
	graphene_point_t _tmp2_;
	graphene_point_t _tmp3_;
	gfloat result;
	g_return_val_if_fail (a != NULL, 0.0F);
	g_return_val_if_fail (b != NULL, 0.0F);
	_tmp0_ = *b;
	_tmp1_ = *a;
	k1 = _tmp0_.x - _tmp1_.x;
	_tmp2_ = *b;
	_tmp3_ = *a;
	k2 = _tmp2_.y - _tmp3_.y;
	result = (k1 * k1) + (k2 * k2);
	return result;
}

static void
gala_window_clone_container_rect_adjusted (MtkRectangle* rect,
                                           gint dw,
                                           gint dh,
                                           MtkRectangle* result)
{
	MtkRectangle _tmp0_;
	MtkRectangle _tmp1_;
	MtkRectangle _tmp2_;
	MtkRectangle _tmp3_;
	MtkRectangle _tmp4_ = {0};
	g_return_if_fail (rect != NULL);
	_tmp0_ = *rect;
	_tmp1_ = *rect;
	_tmp2_ = *rect;
	_tmp3_ = *rect;
	_tmp4_.x = _tmp0_.x + (dw / 2);
	_tmp4_.y = _tmp1_.y + (dh / 2);
	_tmp4_.width = _tmp2_.width - dw;
	_tmp4_.height = _tmp3_.height - dh;
	*result = _tmp4_;
	return;
}

static void
gala_window_clone_container_rect_center (MtkRectangle* rect,
                                         graphene_point_t* result)
{
	MtkRectangle _tmp0_;
	MtkRectangle _tmp1_;
	MtkRectangle _tmp2_;
	MtkRectangle _tmp3_;
	graphene_point_t _tmp4_ = {0};
	g_return_if_fail (rect != NULL);
	_tmp0_ = *rect;
	_tmp1_ = *rect;
	_tmp2_ = *rect;
	_tmp3_ = *rect;
	_tmp4_.x = (gfloat) (_tmp0_.x + (_tmp1_.width / 2));
	_tmp4_.y = (gfloat) (_tmp2_.y + (_tmp3_.height / 2));
	*result = _tmp4_;
	return;
}

/**
     * Careful: List<TilableWindow?> windows will be modified in place and shouldn't be used afterwards.
     */
static gboolean
_mtk_rectangle_equal (const MtkRectangle * s1,
                      const MtkRectangle * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}

static gboolean
_gala_window_clone_container_tilable_window_equal (const GalaWindowCloneContainerTilableWindow * s1,
                                                   const GalaWindowCloneContainerTilableWindow * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->clone != s2->clone) {
		return FALSE;
	}
	if (!_mtk_rectangle_equal (&s1->rect, &s2->rect)) {
		return FALSE;
	}
	return TRUE;
}

static GList*
gala_window_clone_container_calculate_grid_placement (GalaWindowCloneContainer* self,
                                                      MtkRectangle* area,
                                                      GList* windows)
{
	guint window_count = 0U;
	gint columns = 0;
	gint rows = 0;
	gint slot_width = 0;
	MtkRectangle _tmp0_;
	gint slot_height = 0;
	MtkRectangle _tmp1_;
	GalaWindowCloneContainerTilableWindow** taken_slots = NULL;
	GalaWindowCloneContainerTilableWindow** _tmp2_;
	gint taken_slots_length1;
	gint _taken_slots_size_;
	gint _tmp3_;
	graphene_point_t* slot_centers = NULL;
	graphene_point_t* _tmp4_;
	gint slot_centers_length1;
	gint _slot_centers_size_;
	gint _tmp5_;
	GList* _result_ = NULL;
	gint left_over = 0;
	gint button_size = 0;
	gfloat _tmp48_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (area != NULL, NULL);
	window_count = g_list_length (windows);
	columns = (gint) ceil (sqrt ((gdouble) window_count));
	rows = (gint) ceil (window_count / ((gdouble) columns));
	_tmp0_ = *area;
	slot_width = _tmp0_.width / columns;
	_tmp1_ = *area;
	slot_height = _tmp1_.height / rows;
	_tmp2_ = g_new0 (GalaWindowCloneContainerTilableWindow*, 0);
	taken_slots = _tmp2_;
	taken_slots_length1 = 0;
	_taken_slots_size_ = taken_slots_length1;
	_tmp3_ = rows * columns;
	taken_slots = g_renew (GalaWindowCloneContainerTilableWindow*, taken_slots, rows * columns);
	(_tmp3_ > taken_slots_length1) ? memset (taken_slots + taken_slots_length1, 0, sizeof (GalaWindowCloneContainerTilableWindow*) * (_tmp3_ - taken_slots_length1)) : NULL;
	taken_slots_length1 = _tmp3_;
	_taken_slots_size_ = _tmp3_;
	_tmp4_ = g_new0 (graphene_point_t, 0);
	slot_centers = _tmp4_;
	slot_centers_length1 = 0;
	_slot_centers_size_ = slot_centers_length1;
	_tmp5_ = rows * columns;
	slot_centers = g_renew (graphene_point_t, slot_centers, rows * columns);
	(_tmp5_ > slot_centers_length1) ? memset (slot_centers + slot_centers_length1, 0, sizeof (graphene_point_t) * (_tmp5_ - slot_centers_length1)) : NULL;
	slot_centers_length1 = _tmp5_;
	_slot_centers_size_ = _tmp5_;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = x;
					x = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				if (!(x < columns)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							graphene_point_t* _tmp10_;
							gint _tmp10__length1;
							MtkRectangle _tmp11_;
							MtkRectangle _tmp12_;
							graphene_point_t _tmp13_ = {0};
							if (!_tmp8_) {
								gint _tmp9_;
								_tmp9_ = y;
								y = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							if (!(y < rows)) {
								break;
							}
							_tmp10_ = slot_centers;
							_tmp10__length1 = slot_centers_length1;
							_tmp11_ = *area;
							_tmp12_ = *area;
							_tmp13_.x = (gfloat) ((_tmp11_.x + (slot_width * x)) + (slot_width / 2));
							_tmp13_.y = (gfloat) ((_tmp12_.y + (slot_height * y)) + (slot_height / 2));
							_tmp10_[x + (y * columns)] = _tmp13_;
						}
					}
				}
			}
		}
	}
	while (TRUE) {
		GList* link = NULL;
		GList* _tmp14_;
		GalaWindowCloneContainerTilableWindow* window = NULL;
		GList* _tmp15_;
		gconstpointer _tmp16_;
		GalaWindowCloneContainerTilableWindow* _tmp17_;
		MtkRectangle rect = {0};
		GalaWindowCloneContainerTilableWindow* _tmp18_;
		MtkRectangle _tmp19_;
		gint slot_candidate = 0;
		gfloat slot_candidate_distance = 0.0F;
		graphene_point_t pos = {0};
		MtkRectangle _tmp20_;
		graphene_point_t _tmp21_ = {0};
		GalaWindowCloneContainerTilableWindow** _tmp39_;
		gint _tmp39__length1;
		GalaWindowCloneContainerTilableWindow* _tmp40_;
		GList* _tmp44_;
		GalaWindowCloneContainerTilableWindow** _tmp45_;
		gint _tmp45__length1;
		GalaWindowCloneContainerTilableWindow* _tmp46_;
		GalaWindowCloneContainerTilableWindow* _tmp47_;
		if (!(g_list_length (windows) > ((guint) 0))) {
			break;
		}
		_tmp14_ = g_list_nth (windows, (guint) 0);
		link = _tmp14_;
		_tmp15_ = link;
		_tmp16_ = _tmp15_->data;
		_tmp17_ = _gala_window_clone_container_tilable_window_dup0 ((GalaWindowCloneContainerTilableWindow*) _tmp16_);
		window = _tmp17_;
		_tmp18_ = window;
		_tmp19_ = (*_tmp18_).rect;
		rect = _tmp19_;
		slot_candidate = -1;
		slot_candidate_distance = FLT_MAX;
		_tmp20_ = rect;
		gala_window_clone_container_rect_center (&_tmp20_, &_tmp21_);
		pos = _tmp21_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp22_ = FALSE;
				_tmp22_ = TRUE;
				while (TRUE) {
					gfloat dist = 0.0F;
					graphene_point_t _tmp24_;
					graphene_point_t* _tmp25_;
					gint _tmp25__length1;
					graphene_point_t _tmp26_;
					if (!_tmp22_) {
						gint _tmp23_;
						_tmp23_ = i;
						i = _tmp23_ + 1;
					}
					_tmp22_ = FALSE;
					if (!(i < (columns * rows))) {
						break;
					}
					if (((guint) i) > (window_count - 1)) {
						break;
					}
					_tmp24_ = pos;
					_tmp25_ = slot_centers;
					_tmp25__length1 = slot_centers_length1;
					_tmp26_ = _tmp25_[i];
					dist = gala_window_clone_container_squared_distance (&_tmp24_, &_tmp26_);
					if (dist < slot_candidate_distance) {
						GalaWindowCloneContainerTilableWindow* occupier = NULL;
						GalaWindowCloneContainerTilableWindow** _tmp27_;
						gint _tmp27__length1;
						GalaWindowCloneContainerTilableWindow* _tmp28_;
						GalaWindowCloneContainerTilableWindow* _tmp29_;
						GalaWindowCloneContainerTilableWindow* _tmp30_;
						GalaWindowCloneContainerTilableWindow* _tmp31_;
						gboolean _tmp32_ = FALSE;
						GalaWindowCloneContainerTilableWindow* _tmp33_;
						_tmp27_ = taken_slots;
						_tmp27__length1 = taken_slots_length1;
						_tmp28_ = _tmp27_[i];
						_tmp29_ = _gala_window_clone_container_tilable_window_dup0 (_tmp28_);
						occupier = _tmp29_;
						_tmp30_ = occupier;
						_tmp31_ = window;
						if (_gala_window_clone_container_tilable_window_equal (_tmp30_, _tmp31_) == TRUE) {
							_gala_window_clone_container_tilable_window_free0 (occupier);
							continue;
						}
						_tmp33_ = occupier;
						if (_tmp33_ == NULL) {
							_tmp32_ = TRUE;
						} else {
							GalaWindowCloneContainerTilableWindow* _tmp34_;
							MtkRectangle _tmp35_;
							graphene_point_t _tmp36_ = {0};
							graphene_point_t* _tmp37_;
							gint _tmp37__length1;
							graphene_point_t _tmp38_;
							_tmp34_ = occupier;
							_tmp35_ = (*_tmp34_).rect;
							gala_window_clone_container_rect_center (&_tmp35_, &_tmp36_);
							_tmp37_ = slot_centers;
							_tmp37__length1 = slot_centers_length1;
							_tmp38_ = _tmp37_[i];
							_tmp32_ = dist < gala_window_clone_container_squared_distance (&_tmp36_, &_tmp38_);
						}
						if (_tmp32_) {
							slot_candidate = i;
							slot_candidate_distance = dist;
						}
						_gala_window_clone_container_tilable_window_free0 (occupier);
					}
				}
			}
		}
		if (slot_candidate == -1) {
			_gala_window_clone_container_tilable_window_free0 (window);
			continue;
		}
		_tmp39_ = taken_slots;
		_tmp39__length1 = taken_slots_length1;
		_tmp40_ = _tmp39_[slot_candidate];
		if (_tmp40_ != NULL) {
			GalaWindowCloneContainerTilableWindow** _tmp41_;
			gint _tmp41__length1;
			GalaWindowCloneContainerTilableWindow* _tmp42_;
			GalaWindowCloneContainerTilableWindow* _tmp43_;
			_tmp41_ = taken_slots;
			_tmp41__length1 = taken_slots_length1;
			_tmp42_ = _tmp41_[slot_candidate];
			_tmp43_ = _gala_window_clone_container_tilable_window_dup0 (_tmp42_);
			windows = g_list_prepend (windows, _tmp43_);
		}
		_tmp44_ = link;
		windows = g_list_remove_link (windows, _tmp44_);
		_tmp45_ = taken_slots;
		_tmp45__length1 = taken_slots_length1;
		_tmp46_ = window;
		_tmp47_ = _gala_window_clone_container_tilable_window_dup0 (_tmp46_);
		_gala_window_clone_container_tilable_window_free0 (_tmp45_[slot_candidate]);
		_tmp45_[slot_candidate] = _tmp47_;
		_gala_window_clone_container_tilable_window_free0 (window);
	}
	_result_ = NULL;
	left_over = ((gint) window_count) - (columns * (rows - 1));
	_tmp48_ = self->priv->_monitor_scale;
	button_size = gala_utils_calculate_button_size (_tmp48_);
	{
		gint slot = 0;
		slot = 0;
		{
			gboolean _tmp49_ = FALSE;
			_tmp49_ = TRUE;
			while (TRUE) {
				GalaWindowCloneContainerTilableWindow* window = NULL;
				GalaWindowCloneContainerTilableWindow** _tmp51_;
				gint _tmp51__length1;
				GalaWindowCloneContainerTilableWindow* _tmp52_;
				GalaWindowCloneContainerTilableWindow* _tmp53_;
				GalaWindowCloneContainerTilableWindow* _tmp54_;
				MtkRectangle rect = {0};
				GalaWindowCloneContainerTilableWindow* _tmp55_;
				MtkRectangle _tmp56_;
				MtkRectangle target = {0};
				MtkRectangle _tmp57_;
				MtkRectangle _tmp58_;
				MtkRectangle _tmp59_ = {0};
				MtkRectangle _tmp60_;
				MtkRectangle _tmp61_ = {0};
				gfloat scale = 0.0F;
				MtkRectangle _tmp62_;
				MtkRectangle _tmp63_;
				MtkRectangle _tmp64_;
				MtkRectangle _tmp65_;
				gboolean _tmp85_ = FALSE;
				GalaWindowCloneContainerTilableWindow* _tmp86_;
				GalaWindowClone* _tmp87_;
				MtkRectangle _tmp88_;
				GalaWindowCloneContainerTilableWindow _tmp89_ = {0};
				GalaWindowCloneContainerTilableWindow* _tmp90_;
				if (!_tmp49_) {
					gint _tmp50_;
					_tmp50_ = slot;
					slot = _tmp50_ + 1;
				}
				_tmp49_ = FALSE;
				if (!(slot < (columns * rows))) {
					break;
				}
				_tmp51_ = taken_slots;
				_tmp51__length1 = taken_slots_length1;
				_tmp52_ = _tmp51_[slot];
				_tmp53_ = _gala_window_clone_container_tilable_window_dup0 (_tmp52_);
				window = _tmp53_;
				_tmp54_ = window;
				if (_tmp54_ == NULL) {
					_gala_window_clone_container_tilable_window_free0 (window);
					continue;
				}
				_tmp55_ = window;
				_tmp56_ = (*_tmp55_).rect;
				rect = _tmp56_;
				_tmp57_ = *area;
				_tmp58_ = *area;
				_tmp59_.x = _tmp57_.x + ((slot % columns) * slot_width);
				_tmp59_.y = _tmp58_.y + ((slot / columns) * slot_height);
				_tmp59_.width = slot_width;
				_tmp59_.height = slot_height;
				target = _tmp59_;
				_tmp60_ = target;
				gala_window_clone_container_rect_adjusted (&_tmp60_, button_size, button_size, &_tmp61_);
				target = _tmp61_;
				_tmp62_ = target;
				_tmp63_ = rect;
				_tmp64_ = target;
				_tmp65_ = rect;
				if ((_tmp62_.width / ((gdouble) _tmp63_.width)) < (_tmp64_.height / ((gdouble) _tmp65_.height))) {
					MtkRectangle _tmp66_;
					MtkRectangle _tmp67_;
					MtkRectangle _tmp68_;
					MtkRectangle _tmp69_;
					MtkRectangle _tmp70_;
					_tmp66_ = target;
					_tmp67_ = rect;
					scale = _tmp66_.width / ((gfloat) _tmp67_.width);
					_tmp68_ = target;
					_tmp69_ = rect;
					target.y = target.y + ((_tmp68_.height - ((gint) (_tmp69_.height * scale))) / 2);
					_tmp70_ = rect;
					target.height = (gint) floorf (_tmp70_.height * scale);
				} else {
					MtkRectangle _tmp71_;
					MtkRectangle _tmp72_;
					MtkRectangle _tmp73_;
					MtkRectangle _tmp74_;
					MtkRectangle _tmp75_;
					_tmp71_ = target;
					_tmp72_ = rect;
					scale = _tmp71_.height / ((gfloat) _tmp72_.height);
					_tmp73_ = target;
					_tmp74_ = rect;
					target.x = target.x + ((_tmp73_.width - ((gint) (_tmp74_.width * scale))) / 2);
					_tmp75_ = rect;
					target.width = (gint) floorf (_tmp75_.width * scale);
				}
				if (((gdouble) scale) > 1.0) {
					MtkRectangle _tmp76_;
					graphene_point_t _tmp77_ = {0};
					MtkRectangle _tmp78_;
					MtkRectangle _tmp79_;
					graphene_point_t _tmp80_ = {0};
					MtkRectangle _tmp81_;
					MtkRectangle _tmp82_;
					MtkRectangle _tmp83_;
					MtkRectangle _tmp84_ = {0};
					scale = 1.0f;
					_tmp76_ = target;
					gala_window_clone_container_rect_center (&_tmp76_, &_tmp77_);
					_tmp78_ = rect;
					_tmp79_ = target;
					gala_window_clone_container_rect_center (&_tmp79_, &_tmp80_);
					_tmp81_ = rect;
					_tmp82_ = rect;
					_tmp83_ = rect;
					_tmp84_.x = (gint) (_tmp77_.x - (floorf (_tmp78_.width * scale) / 2));
					_tmp84_.y = (gint) (_tmp80_.y - (floorf (_tmp81_.height * scale) / 2));
					_tmp84_.width = (gint) floorf (scale * _tmp82_.width);
					_tmp84_.height = (gint) floorf (scale * _tmp83_.height);
					target = _tmp84_;
				}
				if (left_over != columns) {
					_tmp85_ = slot >= (columns * (rows - 1));
				} else {
					_tmp85_ = FALSE;
				}
				if (_tmp85_) {
					target.x = target.x + (((columns - left_over) * slot_width) / 2);
				}
				_tmp86_ = window;
				_tmp87_ = (*_tmp86_).clone;
				_tmp88_ = target;
				_tmp89_.clone = _tmp87_;
				_tmp89_.rect = _tmp88_;
				_tmp90_ = _gala_window_clone_container_tilable_window_dup0 (&_tmp89_);
				_result_ = g_list_prepend (_result_, _tmp90_);
				_gala_window_clone_container_tilable_window_free0 (window);
			}
		}
	}
	_result_ = g_list_reverse (_result_);
	result = _result_;
	slot_centers = (g_free (slot_centers), NULL);
	taken_slots = (_vala_array_free (taken_slots, taken_slots_length1, (GDestroyNotify) gala_window_clone_container_tilable_window_free), NULL);
	return result;
}

gint
gala_window_clone_container_get_padding_top (GalaWindowCloneContainer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding_top;
	return result;
}

void
gala_window_clone_container_set_padding_top (GalaWindowCloneContainer* self,
                                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_padding_top (self);
	if (old_value != value) {
		self->priv->_padding_top = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY]);
	}
}

gint
gala_window_clone_container_get_padding_left (GalaWindowCloneContainer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding_left;
	return result;
}

void
gala_window_clone_container_set_padding_left (GalaWindowCloneContainer* self,
                                              gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_padding_left (self);
	if (old_value != value) {
		self->priv->_padding_left = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY]);
	}
}

gint
gala_window_clone_container_get_padding_right (GalaWindowCloneContainer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding_right;
	return result;
}

void
gala_window_clone_container_set_padding_right (GalaWindowCloneContainer* self,
                                               gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_padding_right (self);
	if (old_value != value) {
		self->priv->_padding_right = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY]);
	}
}

gint
gala_window_clone_container_get_padding_bottom (GalaWindowCloneContainer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_padding_bottom;
	return result;
}

void
gala_window_clone_container_set_padding_bottom (GalaWindowCloneContainer* self,
                                                gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_padding_bottom (self);
	if (old_value != value) {
		self->priv->_padding_bottom = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY]);
	}
}

GalaWindowManager*
gala_window_clone_container_get_wm (GalaWindowCloneContainer* self)
{
	GalaWindowManager* result;
	GalaWindowManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_container_set_wm (GalaWindowCloneContainer* self,
                                    GalaWindowManager* value)
{
	GalaWindowManager* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_wm (self);
	if (old_value != value) {
		GalaWindowManager* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_wm);
		self->priv->_wm = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY]);
	}
}

GalaWindowListModel*
gala_window_clone_container_get_windows (GalaWindowCloneContainer* self)
{
	GalaWindowListModel* result;
	GalaWindowListModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_windows;
	result = _tmp0_;
	return result;
}

static void
gala_window_clone_container_set_windows (GalaWindowCloneContainer* self,
                                         GalaWindowListModel* value)
{
	GalaWindowListModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_windows (self);
	if (old_value != value) {
		GalaWindowListModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_windows);
		self->priv->_windows = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_WINDOWS_PROPERTY]);
	}
}

gfloat
gala_window_clone_container_get_monitor_scale (GalaWindowCloneContainer* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_monitor_scale;
	return result;
}

void
gala_window_clone_container_set_monitor_scale (GalaWindowCloneContainer* self,
                                               gfloat value)
{
	gfloat old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_monitor_scale (self);
	if (old_value != value) {
		self->priv->_monitor_scale = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY]);
	}
}

gboolean
gala_window_clone_container_get_overview_mode (GalaWindowCloneContainer* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overview_mode;
	return result;
}

static void
gala_window_clone_container_set_overview_mode (GalaWindowCloneContainer* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_window_clone_container_get_overview_mode (self);
	if (old_value != value) {
		self->priv->_overview_mode = value;
		g_object_notify_by_pspec ((GObject *) self, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY]);
	}
}

static GalaWindowCloneContainerTilableWindow*
gala_window_clone_container_tilable_window_dup (const GalaWindowCloneContainerTilableWindow* self)
{
	GalaWindowCloneContainerTilableWindow* dup;
	dup = g_new0 (GalaWindowCloneContainerTilableWindow, 1);
	memcpy (dup, self, sizeof (GalaWindowCloneContainerTilableWindow));
	return dup;
}

static void
gala_window_clone_container_tilable_window_free (GalaWindowCloneContainerTilableWindow* self)
{
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gala_window_clone_container_tilable_window_get_type_once (void)
{
	GType gala_window_clone_container_tilable_window_type_id;
	gala_window_clone_container_tilable_window_type_id = g_boxed_type_register_static ("GalaWindowCloneContainerTilableWindow", (GBoxedCopyFunc) gala_window_clone_container_tilable_window_dup, (GBoxedFreeFunc) gala_window_clone_container_tilable_window_free);
	return gala_window_clone_container_tilable_window_type_id;
}

static GType
gala_window_clone_container_tilable_window_get_type (void)
{
	static gsize gala_window_clone_container_tilable_window_type_id__once = 0;
	if (g_once_init_enter (&gala_window_clone_container_tilable_window_type_id__once)) {
		GType gala_window_clone_container_tilable_window_type_id;
		gala_window_clone_container_tilable_window_type_id = gala_window_clone_container_tilable_window_get_type_once ();
		g_once_init_leave (&gala_window_clone_container_tilable_window_type_id__once, gala_window_clone_container_tilable_window_type_id);
	}
	return gala_window_clone_container_tilable_window_type_id__once;
}

static void
_gala_window_clone_container_on_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                          guint position,
                                                                          guint removed,
                                                                          guint added,
                                                                          gpointer self)
{
	gala_window_clone_container_on_items_changed ((GalaWindowCloneContainer*) self, position, removed, added);
}

static GObject *
gala_window_clone_container_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaWindowCloneContainer * self;
	GalaWindowListModel* _tmp0_;
	GalaWindowListModel* _tmp1_;
	parent_class = G_OBJECT_CLASS (gala_window_clone_container_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
	_tmp0_ = self->priv->_windows;
	gala_window_clone_container_on_items_changed (self, (guint) 0, (guint) 0, g_list_model_get_n_items ((GListModel*) _tmp0_));
	_tmp1_ = self->priv->_windows;
	g_signal_connect_object ((GListModel*) _tmp1_, "items-changed", (GCallback) _gala_window_clone_container_on_items_changed_g_list_model_items_changed, self, 0);
	return obj;
}

static void
gala_window_clone_container_class_init (GalaWindowCloneContainerClass * klass,
                                        gpointer klass_data)
{
	gala_window_clone_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWindowCloneContainer_private_offset);
	((GalaActorTargetClass *) klass)->start_progress = (void (*) (GalaActorTarget*, GalaGestureAction)) gala_window_clone_container_real_start_progress;
	((GalaActorTargetClass *) klass)->commit_progress = (void (*) (GalaActorTarget*, GalaGestureAction, gdouble)) gala_window_clone_container_real_commit_progress;
	((ClutterActorClass *) klass)->key_press_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_window_clone_container_real_key_press_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_window_clone_container_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_window_clone_container_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_window_clone_container_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_window_clone_container_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY] = g_param_spec_int ("padding-top", "padding-top", "padding-top", G_MININT, G_MAXINT, 12, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY] = g_param_spec_int ("padding-left", "padding-left", "padding-left", G_MININT, G_MAXINT, 12, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY] = g_param_spec_int ("padding-right", "padding-right", "padding-right", G_MININT, G_MAXINT, 12, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY] = g_param_spec_int ("padding-bottom", "padding-bottom", "padding-bottom", G_MININT, G_MAXINT, 12, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY] = g_param_spec_object ("wm", "wm", "wm", GALA_TYPE_WINDOW_MANAGER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_WINDOWS_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_WINDOWS_PROPERTY] = g_param_spec_object ("windows", "windows", "windows", GALA_TYPE_WINDOW_LIST_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY] = g_param_spec_float ("monitor-scale", "monitor-scale", "monitor-scale", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY, gala_window_clone_container_properties[GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY] = g_param_spec_boolean ("overview-mode", "overview-mode", "overview-mode", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_WINDOW_SELECTED_SIGNAL] = g_signal_new ("window-selected", GALA_TYPE_WINDOW_CLONE_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, meta_window_get_type ());
	gala_window_clone_container_signals[GALA_WINDOW_CLONE_CONTAINER_REQUESTED_CLOSE_SIGNAL] = g_signal_new ("requested-close", GALA_TYPE_WINDOW_CLONE_CONTAINER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_window_clone_container_instance_init (GalaWindowCloneContainer * self,
                                           gpointer klass)
{
	self->priv = gala_window_clone_container_get_instance_private (self);
	self->priv->_padding_top = 12;
	self->priv->_padding_left = 12;
	self->priv->_padding_right = 12;
	self->priv->_padding_bottom = 12;
	self->priv->opened = FALSE;
	self->priv->current_window = NULL;
}

static void
gala_window_clone_container_finalize (GObject * obj)
{
	GalaWindowCloneContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
	_g_object_unref0 (self->priv->_wm);
	_g_object_unref0 (self->priv->_windows);
	G_OBJECT_CLASS (gala_window_clone_container_parent_class)->finalize (obj);
}

/**
 * Container which controls the layout of a set of WindowClones.
 */
 G_GNUC_NO_INLINE static GType
gala_window_clone_container_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWindowCloneContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_window_clone_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWindowCloneContainer), 0, (GInstanceInitFunc) gala_window_clone_container_instance_init, NULL };
	GType gala_window_clone_container_type_id;
	gala_window_clone_container_type_id = g_type_register_static (GALA_TYPE_ACTOR_TARGET, "GalaWindowCloneContainer", &g_define_type_info, 0);
	GalaWindowCloneContainer_private_offset = g_type_add_instance_private (gala_window_clone_container_type_id, sizeof (GalaWindowCloneContainerPrivate));
	return gala_window_clone_container_type_id;
}

GType
gala_window_clone_container_get_type (void)
{
	static gsize gala_window_clone_container_type_id__once = 0;
	if (g_once_init_enter (&gala_window_clone_container_type_id__once)) {
		GType gala_window_clone_container_type_id;
		gala_window_clone_container_type_id = gala_window_clone_container_get_type_once ();
		g_once_init_leave (&gala_window_clone_container_type_id__once, gala_window_clone_container_type_id);
	}
	return gala_window_clone_container_type_id__once;
}

static void
_vala_gala_window_clone_container_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GalaWindowCloneContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
	switch (property_id) {
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY:
		g_value_set_int (value, gala_window_clone_container_get_padding_top (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY:
		g_value_set_int (value, gala_window_clone_container_get_padding_left (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY:
		g_value_set_int (value, gala_window_clone_container_get_padding_right (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY:
		g_value_set_int (value, gala_window_clone_container_get_padding_bottom (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY:
		g_value_set_object (value, gala_window_clone_container_get_wm (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_WINDOWS_PROPERTY:
		g_value_set_object (value, gala_window_clone_container_get_windows (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY:
		g_value_set_float (value, gala_window_clone_container_get_monitor_scale (self));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY:
		g_value_set_boolean (value, gala_window_clone_container_get_overview_mode (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_window_clone_container_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	GalaWindowCloneContainer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WINDOW_CLONE_CONTAINER, GalaWindowCloneContainer);
	switch (property_id) {
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_TOP_PROPERTY:
		gala_window_clone_container_set_padding_top (self, g_value_get_int (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_LEFT_PROPERTY:
		gala_window_clone_container_set_padding_left (self, g_value_get_int (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_RIGHT_PROPERTY:
		gala_window_clone_container_set_padding_right (self, g_value_get_int (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_PADDING_BOTTOM_PROPERTY:
		gala_window_clone_container_set_padding_bottom (self, g_value_get_int (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_WM_PROPERTY:
		gala_window_clone_container_set_wm (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_WINDOWS_PROPERTY:
		gala_window_clone_container_set_windows (self, g_value_get_object (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_MONITOR_SCALE_PROPERTY:
		gala_window_clone_container_set_monitor_scale (self, g_value_get_float (value));
		break;
		case GALA_WINDOW_CLONE_CONTAINER_OVERVIEW_MODE_PROPERTY:
		gala_window_clone_container_set_overview_mode (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

