/* Utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Utils.vala, do not modify */

/**/
/*  Copyright (C) 2012 Tom Beckmann, Rico Tzschichholz*/
/**/
/*  This program is free software: you can redistribute it and/or modify*/
/*  it under the terms of the GNU General Public License as published by*/
/*  the Free Software Foundation, either version 3 of the License, or*/
/*  (at your option) any later version.*/
/**/
/*  This program is distributed in the hope that it will be useful,*/
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*  GNU General Public License for more details.*/
/**/
/*  You should have received a copy of the GNU General Public License*/
/*  along with this program.  If not, see <http://www.gnu.org/licenses/>.*/
/**/

#include "gala.h"
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gdesktopappinfo.h>
#include <meta/window.h>
#include <gtk/gtk.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <stdlib.h>
#include <string.h>
#include <meta/group.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <meta/workspace.h>
#include <meta/meta-window-actor.h>
#include <mtk/mtk.h>
#include <clutter/clutter.h>
#include <meta/meta-x11-display.h>
#include <meta/display.h>
#include <X11/extensions/shape.h>
#include <X11/extensions/Xfixes.h>
#include <meta/prefs.h>
#include <gobject/gvaluecollector.h>

#define GALA_UTILS_BUTTON_SIZE 36
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GALA_UTILS_TYPE_CACHED_ICON (gala_utils_cached_icon_get_type ())
typedef struct _GalaUtilsCachedIcon GalaUtilsCachedIcon;
typedef struct _Block5Data Block5Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gala_utils_cached_icon_free0(var) ((var == NULL) ? NULL : (var = (gala_utils_cached_icon_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GalaParamSpecUtils GalaParamSpecUtils;

struct _GalaUtilsCachedIcon {
	GdkPixbuf* icon;
	gint icon_size;
	gint scale;
};

struct _Block5Data {
	int _ref_count_;
	GDesktopAppInfo* desktop_app;
};

struct _GalaParamSpecUtils {
	GParamSpec parent_instance;
};

static gpointer gala_utils_parent_class = NULL;
static GeeHashMap* gala_utils_resize_pixbufs;
static GeeHashMap* gala_utils_resize_pixbufs = NULL;
static GeeHashMultiMap* gala_utils_icon_cache;
static GeeHashMultiMap* gala_utils_icon_cache = NULL;
static GeeHashMap* gala_utils_window_to_desktop_cache;
static GeeHashMap* gala_utils_window_to_desktop_cache = NULL;
static GeeArrayList* gala_utils_unknown_icon_cache;
static GeeArrayList* gala_utils_unknown_icon_cache = NULL;
static GalaAppCache* gala_utils_app_cache;
static GalaAppCache* gala_utils_app_cache = NULL;
static GtkIconTheme* gala_utils_icon_theme;
static GtkIconTheme* gala_utils_icon_theme = NULL;
static GHashTable* gala_utils_regions;
static GHashTable* gala_utils_regions = NULL;

static GType gala_utils_cached_icon_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GalaUtilsCachedIcon* gala_utils_cached_icon_dup (const GalaUtilsCachedIcon* self);
static void gala_utils_cached_icon_free (GalaUtilsCachedIcon* self);
static void gala_utils_cached_icon_copy (const GalaUtilsCachedIcon* self,
                                  GalaUtilsCachedIcon* dest);
static void gala_utils_cached_icon_destroy (GalaUtilsCachedIcon* self);
static void _g_object_unref0_ (gpointer var);
static void _g_free0_ (gpointer var);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static GdkPixbuf* gala_utils_get_icon_for_desktop_app_info (GDesktopAppInfo* desktop,
                                                     gint icon_size,
                                                     gint scale);
static gboolean gala_utils_check_app_prefix (GDesktopAppInfo* app,
                                      const gchar* sandbox_id);
static GDesktopAppInfo* gala_utils_lookup_desktop_wmclass (const gchar* wm_class);
static GDesktopAppInfo* gala_utils_get_app_from_id (const gchar* id);
static void ____lambda10_ (Block5Data* _data5_,
                    MetaWindow* window);
static void _____lambda10__gfunc (gconstpointer data,
                           gpointer self);
static gchar** _vala_array_dup4 (gchar** self,
                          gssize length);
static RECTANGLE* _rectangle_dup (RECTANGLE* self);
static void _gala_utils___lambda11_ (void);
static void __gala_utils___lambda11__gala_app_cache_changed (GalaAppCache* _sender,
                                                      gpointer self);
static void gala_utils_finalize (GalaUtils * obj);
static GType gala_utils_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_g_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_free (var), NULL));
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->desktop_app);
		g_slice_free (Block5Data, _data5_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
____lambda10_ (Block5Data* _data5_,
               MetaWindow* window)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GDesktopAppInfo* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (window != NULL);
	if (meta_window_get_window_type (window) != META_WINDOW_NORMAL) {
		return;
	}
	_tmp0_ = gala_utils_window_to_desktop_cache;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, window);
	_tmp2_ = (GDesktopAppInfo*) _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		GeeHashMap* _tmp4_;
		gpointer _tmp5_;
		_tmp4_ = gala_utils_window_to_desktop_cache;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, window);
		_g_object_unref0 (_data5_->desktop_app);
		_data5_->desktop_app = (GDesktopAppInfo*) _tmp5_;
	}
}

static void
_____lambda10__gfunc (gconstpointer data,
                      gpointer self)
{
	____lambda10_ (self, (MetaWindow*) data);
}

GdkPixbuf*
gala_utils_get_icon_for_window (MetaWindow* window,
                                gint icon_size,
                                gint scale)
{
	Block5Data* _data5_;
	MetaWindow* transient_for = NULL;
	MetaWindow* _tmp0_;
	MetaWindow* _tmp1_;
	MetaWindow* _tmp2_;
	GeeHashMap* _tmp5_;
	gpointer _tmp6_;
	GDesktopAppInfo* _tmp7_;
	gchar* sandbox_id = NULL;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* wm_instance = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	GalaAppCache* _tmp15_;
	const gchar* _tmp16_;
	GDesktopAppInfo* _tmp17_;
	gboolean _tmp18_ = FALSE;
	GDesktopAppInfo* _tmp19_;
	gchar* wm_class = NULL;
	const gchar* _tmp27_;
	gchar* _tmp28_;
	GalaAppCache* _tmp29_;
	const gchar* _tmp30_;
	GDesktopAppInfo* _tmp31_;
	gboolean _tmp32_ = FALSE;
	GDesktopAppInfo* _tmp33_;
	const gchar* _tmp41_;
	GDesktopAppInfo* _tmp42_;
	gboolean _tmp43_ = FALSE;
	GDesktopAppInfo* _tmp44_;
	const gchar* _tmp52_;
	GDesktopAppInfo* _tmp53_;
	gboolean _tmp54_ = FALSE;
	GDesktopAppInfo* _tmp55_;
	const gchar* _tmp63_;
	GDesktopAppInfo* _tmp64_;
	GDesktopAppInfo* _tmp65_;
	gchar* gapplication_id = NULL;
	const gchar* _tmp71_;
	gchar* _tmp72_;
	const gchar* _tmp73_;
	GDesktopAppInfo* _tmp74_;
	GDesktopAppInfo* _tmp75_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (window != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_tmp0_ = meta_window_get_transient_for (window);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	transient_for = _tmp1_;
	_tmp2_ = transient_for;
	if (_tmp2_ != NULL) {
		MetaWindow* _tmp3_;
		GdkPixbuf* _tmp4_;
		_tmp3_ = transient_for;
		_tmp4_ = gala_utils_get_icon_for_window (_tmp3_, icon_size, scale);
		result = _tmp4_;
		_g_object_unref0 (transient_for);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return result;
	}
	_data5_->desktop_app = NULL;
	_tmp5_ = gala_utils_window_to_desktop_cache;
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, window);
	_g_object_unref0 (_data5_->desktop_app);
	_data5_->desktop_app = (GDesktopAppInfo*) _tmp6_;
	_tmp7_ = _data5_->desktop_app;
	if (_tmp7_ != NULL) {
		GdkPixbuf* icon = NULL;
		GDesktopAppInfo* _tmp8_;
		GdkPixbuf* _tmp9_;
		GdkPixbuf* _tmp10_;
		_tmp8_ = _data5_->desktop_app;
		_tmp9_ = gala_utils_get_icon_for_desktop_app_info (_tmp8_, icon_size, scale);
		icon = _tmp9_;
		_tmp10_ = icon;
		if (_tmp10_ != NULL) {
			result = icon;
			_g_object_unref0 (transient_for);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return result;
		}
		_g_object_unref0 (icon);
	}
	_tmp11_ = meta_window_get_sandboxed_app_id (window);
	_tmp12_ = g_strdup (_tmp11_);
	sandbox_id = _tmp12_;
	_tmp13_ = meta_window_get_wm_class_instance (window);
	_tmp14_ = g_strdup (_tmp13_);
	wm_instance = _tmp14_;
	_tmp15_ = gala_utils_app_cache;
	_tmp16_ = wm_instance;
	_tmp17_ = gala_app_cache_lookup_startup_wmclass (_tmp15_, _tmp16_);
	_g_object_unref0 (_data5_->desktop_app);
	_data5_->desktop_app = _tmp17_;
	_tmp19_ = _data5_->desktop_app;
	if (_tmp19_ != NULL) {
		GDesktopAppInfo* _tmp20_;
		const gchar* _tmp21_;
		_tmp20_ = _data5_->desktop_app;
		_tmp21_ = sandbox_id;
		_tmp18_ = gala_utils_check_app_prefix (_tmp20_, _tmp21_);
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		GdkPixbuf* icon = NULL;
		GDesktopAppInfo* _tmp22_;
		GdkPixbuf* _tmp23_;
		GdkPixbuf* _tmp24_;
		_tmp22_ = _data5_->desktop_app;
		_tmp23_ = gala_utils_get_icon_for_desktop_app_info (_tmp22_, icon_size, scale);
		icon = _tmp23_;
		_tmp24_ = icon;
		if (_tmp24_ != NULL) {
			GeeHashMap* _tmp25_;
			GDesktopAppInfo* _tmp26_;
			_tmp25_ = gala_utils_window_to_desktop_cache;
			_tmp26_ = _data5_->desktop_app;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp25_, window, _tmp26_);
			result = icon;
			_g_free0 (wm_instance);
			_g_free0 (sandbox_id);
			_g_object_unref0 (transient_for);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return result;
		}
		_g_object_unref0 (icon);
	}
	_tmp27_ = meta_window_get_wm_class (window);
	_tmp28_ = g_strdup (_tmp27_);
	wm_class = _tmp28_;
	_tmp29_ = gala_utils_app_cache;
	_tmp30_ = wm_class;
	_tmp31_ = gala_app_cache_lookup_startup_wmclass (_tmp29_, _tmp30_);
	_g_object_unref0 (_data5_->desktop_app);
	_data5_->desktop_app = _tmp31_;
	_tmp33_ = _data5_->desktop_app;
	if (_tmp33_ != NULL) {
		GDesktopAppInfo* _tmp34_;
		const gchar* _tmp35_;
		_tmp34_ = _data5_->desktop_app;
		_tmp35_ = sandbox_id;
		_tmp32_ = gala_utils_check_app_prefix (_tmp34_, _tmp35_);
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		GdkPixbuf* icon = NULL;
		GDesktopAppInfo* _tmp36_;
		GdkPixbuf* _tmp37_;
		GdkPixbuf* _tmp38_;
		_tmp36_ = _data5_->desktop_app;
		_tmp37_ = gala_utils_get_icon_for_desktop_app_info (_tmp36_, icon_size, scale);
		icon = _tmp37_;
		_tmp38_ = icon;
		if (_tmp38_ != NULL) {
			GeeHashMap* _tmp39_;
			GDesktopAppInfo* _tmp40_;
			_tmp39_ = gala_utils_window_to_desktop_cache;
			_tmp40_ = _data5_->desktop_app;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp39_, window, _tmp40_);
			result = icon;
			_g_free0 (wm_class);
			_g_free0 (wm_instance);
			_g_free0 (sandbox_id);
			_g_object_unref0 (transient_for);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return result;
		}
		_g_object_unref0 (icon);
	}
	_tmp41_ = wm_instance;
	_tmp42_ = gala_utils_lookup_desktop_wmclass (_tmp41_);
	_g_object_unref0 (_data5_->desktop_app);
	_data5_->desktop_app = _tmp42_;
	_tmp44_ = _data5_->desktop_app;
	if (_tmp44_ != NULL) {
		GDesktopAppInfo* _tmp45_;
		const gchar* _tmp46_;
		_tmp45_ = _data5_->desktop_app;
		_tmp46_ = sandbox_id;
		_tmp43_ = gala_utils_check_app_prefix (_tmp45_, _tmp46_);
	} else {
		_tmp43_ = FALSE;
	}
	if (_tmp43_) {
		GdkPixbuf* icon = NULL;
		GDesktopAppInfo* _tmp47_;
		GdkPixbuf* _tmp48_;
		GdkPixbuf* _tmp49_;
		_tmp47_ = _data5_->desktop_app;
		_tmp48_ = gala_utils_get_icon_for_desktop_app_info (_tmp47_, icon_size, scale);
		icon = _tmp48_;
		_tmp49_ = icon;
		if (_tmp49_ != NULL) {
			GeeHashMap* _tmp50_;
			GDesktopAppInfo* _tmp51_;
			_tmp50_ = gala_utils_window_to_desktop_cache;
			_tmp51_ = _data5_->desktop_app;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp50_, window, _tmp51_);
			result = icon;
			_g_free0 (wm_class);
			_g_free0 (wm_instance);
			_g_free0 (sandbox_id);
			_g_object_unref0 (transient_for);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return result;
		}
		_g_object_unref0 (icon);
	}
	_tmp52_ = wm_class;
	_tmp53_ = gala_utils_lookup_desktop_wmclass (_tmp52_);
	_g_object_unref0 (_data5_->desktop_app);
	_data5_->desktop_app = _tmp53_;
	_tmp55_ = _data5_->desktop_app;
	if (_tmp55_ != NULL) {
		GDesktopAppInfo* _tmp56_;
		const gchar* _tmp57_;
		_tmp56_ = _data5_->desktop_app;
		_tmp57_ = sandbox_id;
		_tmp54_ = gala_utils_check_app_prefix (_tmp56_, _tmp57_);
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		GdkPixbuf* icon = NULL;
		GDesktopAppInfo* _tmp58_;
		GdkPixbuf* _tmp59_;
		GdkPixbuf* _tmp60_;
		_tmp58_ = _data5_->desktop_app;
		_tmp59_ = gala_utils_get_icon_for_desktop_app_info (_tmp58_, icon_size, scale);
		icon = _tmp59_;
		_tmp60_ = icon;
		if (_tmp60_ != NULL) {
			GeeHashMap* _tmp61_;
			GDesktopAppInfo* _tmp62_;
			_tmp61_ = gala_utils_window_to_desktop_cache;
			_tmp62_ = _data5_->desktop_app;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp61_, window, _tmp62_);
			result = icon;
			_g_free0 (wm_class);
			_g_free0 (wm_instance);
			_g_free0 (sandbox_id);
			_g_object_unref0 (transient_for);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return result;
		}
		_g_object_unref0 (icon);
	}
	_tmp63_ = sandbox_id;
	_tmp64_ = gala_utils_get_app_from_id (_tmp63_);
	_g_object_unref0 (_data5_->desktop_app);
	_data5_->desktop_app = _tmp64_;
	_tmp65_ = _data5_->desktop_app;
	if (_tmp65_ != NULL) {
		GdkPixbuf* icon = NULL;
		GDesktopAppInfo* _tmp66_;
		GdkPixbuf* _tmp67_;
		GdkPixbuf* _tmp68_;
		_tmp66_ = _data5_->desktop_app;
		_tmp67_ = gala_utils_get_icon_for_desktop_app_info (_tmp66_, icon_size, scale);
		icon = _tmp67_;
		_tmp68_ = icon;
		if (_tmp68_ != NULL) {
			GeeHashMap* _tmp69_;
			GDesktopAppInfo* _tmp70_;
			_tmp69_ = gala_utils_window_to_desktop_cache;
			_tmp70_ = _data5_->desktop_app;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp69_, window, _tmp70_);
			result = icon;
			_g_free0 (wm_class);
			_g_free0 (wm_instance);
			_g_free0 (sandbox_id);
			_g_object_unref0 (transient_for);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return result;
		}
		_g_object_unref0 (icon);
	}
	_tmp71_ = meta_window_get_gtk_application_id (window);
	_tmp72_ = g_strdup (_tmp71_);
	gapplication_id = _tmp72_;
	_tmp73_ = gapplication_id;
	_tmp74_ = gala_utils_get_app_from_id (_tmp73_);
	_g_object_unref0 (_data5_->desktop_app);
	_data5_->desktop_app = _tmp74_;
	_tmp75_ = _data5_->desktop_app;
	if (_tmp75_ != NULL) {
		GdkPixbuf* icon = NULL;
		GDesktopAppInfo* _tmp76_;
		GdkPixbuf* _tmp77_;
		GdkPixbuf* _tmp78_;
		_tmp76_ = _data5_->desktop_app;
		_tmp77_ = gala_utils_get_icon_for_desktop_app_info (_tmp76_, icon_size, scale);
		icon = _tmp77_;
		_tmp78_ = icon;
		if (_tmp78_ != NULL) {
			GeeHashMap* _tmp79_;
			GDesktopAppInfo* _tmp80_;
			_tmp79_ = gala_utils_window_to_desktop_cache;
			_tmp80_ = _data5_->desktop_app;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp79_, window, _tmp80_);
			result = icon;
			_g_free0 (gapplication_id);
			_g_free0 (wm_class);
			_g_free0 (wm_instance);
			_g_free0 (sandbox_id);
			_g_object_unref0 (transient_for);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return result;
		}
		_g_object_unref0 (icon);
	}
	if (meta_window_get_client_type (window) == META_WINDOW_CLIENT_TYPE_X11) {
		MetaGroup* group = NULL;
		MetaGroup* _tmp81_;
		MetaGroup* _tmp82_;
		_tmp81_ = meta_window_x11_get_group (window);
		group = _tmp81_;
		_tmp82_ = group;
		if (_tmp82_ != NULL) {
			GSList* group_windows = NULL;
			MetaGroup* _tmp83_;
			GSList* _tmp84_;
			GSList* _tmp85_;
			GDesktopAppInfo* _tmp86_;
			_tmp83_ = group;
			_tmp84_ = meta_group_list_windows (_tmp83_);
			group_windows = _tmp84_;
			_tmp85_ = group_windows;
			g_slist_foreach (_tmp85_, _____lambda10__gfunc, _data5_);
			_tmp86_ = _data5_->desktop_app;
			if (_tmp86_ != NULL) {
				GdkPixbuf* icon = NULL;
				GDesktopAppInfo* _tmp87_;
				GdkPixbuf* _tmp88_;
				GdkPixbuf* _tmp89_;
				_tmp87_ = _data5_->desktop_app;
				_tmp88_ = gala_utils_get_icon_for_desktop_app_info (_tmp87_, icon_size, scale);
				icon = _tmp88_;
				_tmp89_ = icon;
				if (_tmp89_ != NULL) {
					GeeHashMap* _tmp90_;
					GDesktopAppInfo* _tmp91_;
					_tmp90_ = gala_utils_window_to_desktop_cache;
					_tmp91_ = _data5_->desktop_app;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp90_, window, _tmp91_);
					result = icon;
					(group_windows == NULL) ? NULL : (group_windows = (g_slist_free (group_windows), NULL));
					_g_free0 (gapplication_id);
					_g_free0 (wm_class);
					_g_free0 (wm_instance);
					_g_free0 (sandbox_id);
					_g_object_unref0 (transient_for);
					block5_data_unref (_data5_);
					_data5_ = NULL;
					return result;
				}
				_g_object_unref0 (icon);
			}
			(group_windows == NULL) ? NULL : (group_windows = (g_slist_free (group_windows), NULL));
		}
	}
	{
		GeeArrayList* _icon_list = NULL;
		GeeArrayList* _tmp92_;
		gint _icon_size = 0;
		GeeArrayList* _tmp93_;
		gint _tmp94_;
		gint _tmp95_;
		gint _icon_index = 0;
		_tmp92_ = gala_utils_unknown_icon_cache;
		_icon_list = _tmp92_;
		_tmp93_ = _icon_list;
		_tmp94_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp93_);
		_tmp95_ = _tmp94_;
		_icon_size = _tmp95_;
		_icon_index = -1;
		while (TRUE) {
			gint _tmp96_;
			gint _tmp97_;
			GalaUtilsCachedIcon* icon = NULL;
			GeeArrayList* _tmp98_;
			gpointer _tmp99_;
			gboolean _tmp100_ = FALSE;
			GalaUtilsCachedIcon* _tmp101_;
			_icon_index = _icon_index + 1;
			_tmp96_ = _icon_index;
			_tmp97_ = _icon_size;
			if (!(_tmp96_ < _tmp97_)) {
				break;
			}
			_tmp98_ = _icon_list;
			_tmp99_ = gee_abstract_list_get ((GeeAbstractList*) _tmp98_, _icon_index);
			icon = (GalaUtilsCachedIcon*) _tmp99_;
			_tmp101_ = icon;
			if ((*_tmp101_).icon_size == icon_size) {
				GalaUtilsCachedIcon* _tmp102_;
				_tmp102_ = icon;
				_tmp100_ = (*_tmp102_).scale == scale;
			} else {
				_tmp100_ = FALSE;
			}
			if (_tmp100_) {
				GalaUtilsCachedIcon* _tmp103_;
				GdkPixbuf* _tmp104_;
				GdkPixbuf* _tmp105_;
				_tmp103_ = icon;
				_tmp104_ = (*_tmp103_).icon;
				_tmp105_ = _g_object_ref0 (_tmp104_);
				result = _tmp105_;
				_gala_utils_cached_icon_free0 (icon);
				_g_free0 (gapplication_id);
				_g_free0 (wm_class);
				_g_free0 (wm_instance);
				_g_free0 (sandbox_id);
				_g_object_unref0 (transient_for);
				block5_data_unref (_data5_);
				_data5_ = NULL;
				return result;
			}
			_gala_utils_cached_icon_free0 (icon);
		}
	}
	{
		GtkIconPaintable* icon_paintable = NULL;
		GtkIconTheme* _tmp106_;
		GtkIconPaintable* _tmp107_;
		GdkPixbuf* pixbuf = NULL;
		GtkIconPaintable* _tmp108_;
		GFile* _tmp109_;
		GFile* _tmp110_;
		gchar* _tmp111_;
		gchar* _tmp112_;
		GdkPixbuf* _tmp113_;
		GdkPixbuf* _tmp114_;
		GeeArrayList* _tmp115_;
		GdkPixbuf* _tmp116_;
		GdkPixbuf* _tmp117_;
		GalaUtilsCachedIcon _tmp118_ = {0};
		GalaUtilsCachedIcon _tmp119_;
		GalaUtilsCachedIcon _tmp120_;
		_tmp106_ = gala_utils_icon_theme;
		_tmp107_ = gtk_icon_theme_lookup_icon (_tmp106_, "application-default-icon", NULL, icon_size, scale, GTK_TEXT_DIR_NONE, 0);
		icon_paintable = _tmp107_;
		_tmp108_ = icon_paintable;
		_tmp109_ = gtk_icon_paintable_get_file (_tmp108_);
		_tmp110_ = _tmp109_;
		_tmp111_ = g_file_get_path (_tmp110_);
		_tmp112_ = _tmp111_;
		_tmp113_ = gdk_pixbuf_new_from_file (_tmp112_, &_inner_error0_);
		_tmp114_ = _tmp113_;
		_g_free0 (_tmp112_);
		_g_object_unref0 (_tmp110_);
		pixbuf = _tmp114_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (icon_paintable);
			goto __catch0_g_error;
		}
		_tmp115_ = gala_utils_unknown_icon_cache;
		_tmp116_ = pixbuf;
		_tmp117_ = _g_object_ref0 (_tmp116_);
		memset (&_tmp118_, 0, sizeof (GalaUtilsCachedIcon));
		_g_object_unref0 (_tmp118_.icon);
		_tmp118_.icon = _tmp117_;
		_tmp118_.icon_size = icon_size;
		_tmp118_.scale = scale;
		_tmp119_ = _tmp118_;
		_tmp120_ = _tmp119_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp115_, &_tmp120_);
		gala_utils_cached_icon_destroy (&_tmp119_);
		result = pixbuf;
		_g_object_unref0 (icon_paintable);
		_g_free0 (gapplication_id);
		_g_free0 (wm_class);
		_g_free0 (wm_instance);
		_g_free0 (sandbox_id);
		_g_object_unref0 (transient_for);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GdkPixbuf* icon = NULL;
		GdkPixbuf* _tmp121_;
		GdkPixbuf* _tmp122_;
		g_clear_error (&_inner_error0_);
		_tmp121_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, icon_size * scale, icon_size * scale);
		icon = _tmp121_;
		_tmp122_ = icon;
		gdk_pixbuf_fill (_tmp122_, (guint32) 0x00000000);
		result = icon;
		_g_free0 (gapplication_id);
		_g_free0 (wm_class);
		_g_free0 (wm_instance);
		_g_free0 (sandbox_id);
		_g_object_unref0 (transient_for);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return result;
	}
	__finally0:
	_g_free0 (gapplication_id);
	_g_free0 (wm_class);
	_g_free0 (wm_instance);
	_g_free0 (sandbox_id);
	_g_object_unref0 (transient_for);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gboolean
gala_utils_check_app_prefix (GDesktopAppInfo* app,
                             const gchar* sandbox_id)
{
	gchar* prefix = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (app != NULL, FALSE);
	if (sandbox_id == NULL) {
		result = TRUE;
		return result;
	}
	_tmp0_ = g_strdup_printf ("%s.", sandbox_id);
	prefix = _tmp0_;
	_tmp1_ = g_app_info_get_id ((GAppInfo*) app);
	_tmp2_ = prefix;
	if (g_str_has_prefix (_tmp1_, _tmp2_)) {
		result = TRUE;
		_g_free0 (prefix);
		return result;
	}
	result = FALSE;
	_g_free0 (prefix);
	return result;
}

void
gala_utils_clear_window_cache (MetaWindow* window)
{
	GDesktopAppInfo* desktop = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GDesktopAppInfo* _tmp2_;
	g_return_if_fail (window != NULL);
	_tmp0_ = gala_utils_window_to_desktop_cache;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, window);
	desktop = (GDesktopAppInfo*) _tmp1_;
	_tmp2_ = desktop;
	if (_tmp2_ != NULL) {
		GeeHashMultiMap* _tmp3_;
		GDesktopAppInfo* _tmp4_;
		GeeHashMap* _tmp5_;
		_tmp3_ = gala_utils_icon_cache;
		_tmp4_ = desktop;
		gee_multi_map_remove_all ((GeeMultiMap*) _tmp3_, _tmp4_);
		_tmp5_ = gala_utils_window_to_desktop_cache;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, window, NULL);
	}
	_g_object_unref0 (desktop);
}

static GDesktopAppInfo*
gala_utils_get_app_from_id (const gchar* id)
{
	gchar* desktop_file = NULL;
	gchar* _tmp0_;
	GalaAppCache* _tmp1_;
	const gchar* _tmp2_;
	GDesktopAppInfo* _tmp3_;
	GDesktopAppInfo* _tmp4_;
	GDesktopAppInfo* result;
	if (id == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_strdup_printf ("%s.desktop", id);
	desktop_file = _tmp0_;
	_tmp1_ = gala_utils_app_cache;
	_tmp2_ = desktop_file;
	_tmp3_ = gala_app_cache_lookup_id (_tmp1_, _tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	result = _tmp4_;
	_g_free0 (desktop_file);
	return result;
}

static gchar*
string_delimit (const gchar* self,
                const gchar* delimiters,
                gchar new_delimiter)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (delimiters != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strdelimit (_result_, delimiters, new_delimiter);
	result = _result_;
	return result;
}

static GDesktopAppInfo*
gala_utils_lookup_desktop_wmclass (const gchar* wm_class)
{
	GDesktopAppInfo* desktop_info = NULL;
	GDesktopAppInfo* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	gchar* canonicalized = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GDesktopAppInfo* _tmp7_;
	GDesktopAppInfo* result;
	if (wm_class == NULL) {
		result = NULL;
		return result;
	}
	_tmp0_ = gala_utils_get_app_from_id (wm_class);
	desktop_info = _tmp0_;
	_tmp1_ = desktop_info;
	if (_tmp1_ != NULL) {
		result = desktop_info;
		return result;
	}
	_tmp2_ = g_ascii_strdown (wm_class, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_delimit (_tmp3_, " ", '-');
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	canonicalized = _tmp5_;
	_tmp6_ = canonicalized;
	_tmp7_ = gala_utils_get_app_from_id (_tmp6_);
	result = _tmp7_;
	_g_free0 (canonicalized);
	_g_object_unref0 (desktop_info);
	return result;
}

static gchar**
_vala_array_dup4 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static GdkPixbuf*
gala_utils_get_icon_for_desktop_app_info (GDesktopAppInfo* desktop,
                                          gint icon_size,
                                          gint scale)
{
	GeeHashMultiMap* _tmp0_;
	GIcon* icon = NULL;
	GIcon* _tmp15_;
	GIcon* _tmp16_;
	GIcon* _tmp17_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	g_return_val_if_fail (desktop != NULL, NULL);
	_tmp0_ = gala_utils_icon_cache;
	if (gee_multi_map_contains ((GeeMultiMap*) _tmp0_, desktop)) {
		{
			GeeIterator* _icon_it = NULL;
			GeeHashMultiMap* _tmp1_;
			GeeCollection* _tmp2_;
			GeeCollection* _tmp3_;
			GeeIterator* _tmp4_;
			GeeIterator* _tmp5_;
			_tmp1_ = gala_utils_icon_cache;
			_tmp2_ = gee_multi_map_get ((GeeMultiMap*) _tmp1_, desktop);
			_tmp3_ = _tmp2_;
			_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
			_tmp5_ = _tmp4_;
			_g_object_unref0 (_tmp3_);
			_icon_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				GalaUtilsCachedIcon* icon = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				gboolean _tmp9_ = FALSE;
				GalaUtilsCachedIcon* _tmp10_;
				_tmp6_ = _icon_it;
				if (!gee_iterator_next (_tmp6_)) {
					break;
				}
				_tmp7_ = _icon_it;
				_tmp8_ = gee_iterator_get (_tmp7_);
				icon = (GalaUtilsCachedIcon*) _tmp8_;
				_tmp10_ = icon;
				if ((*_tmp10_).icon_size == icon_size) {
					GalaUtilsCachedIcon* _tmp11_;
					_tmp11_ = icon;
					_tmp9_ = (*_tmp11_).scale == scale;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					GalaUtilsCachedIcon* _tmp12_;
					GdkPixbuf* _tmp13_;
					GdkPixbuf* _tmp14_;
					_tmp12_ = icon;
					_tmp13_ = (*_tmp12_).icon;
					_tmp14_ = _g_object_ref0 (_tmp13_);
					result = _tmp14_;
					_gala_utils_cached_icon_free0 (icon);
					_g_object_unref0 (_icon_it);
					return result;
				}
				_gala_utils_cached_icon_free0 (icon);
			}
			_g_object_unref0 (_icon_it);
		}
	}
	_tmp15_ = g_app_info_get_icon ((GAppInfo*) desktop);
	_tmp16_ = _g_object_ref0 (_tmp15_);
	icon = _tmp16_;
	_tmp17_ = icon;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, g_themed_icon_get_type ())) {
		gchar** icon_names = NULL;
		GIcon* _tmp18_;
		gchar** _tmp19_;
		gchar** _tmp20_;
		gchar** _tmp21_;
		gint _tmp21__length1;
		gint icon_names_length1;
		gint _icon_names_size_;
		gchar** _tmp22_;
		gint _tmp22__length1;
		GtkIconPaintable* icon_paintable = NULL;
		GtkIconTheme* _tmp23_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		const gchar* _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar** _tmp27_;
		gint _tmp27__length1;
		GtkIconPaintable* _tmp28_;
		GFile* _tmp29_ = NULL;
		GtkIconPaintable* _tmp30_;
		GFile* _tmp31_;
		gchar* _tmp32_ = NULL;
		gchar* path = NULL;
		gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp18_ = icon;
		_tmp20_ = _tmp19_ = g_themed_icon_get_names (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, g_themed_icon_get_type (), GThemedIcon));
		_tmp21_ = (_tmp20_ != NULL) ? _vala_array_dup4 (_tmp20_, _vala_array_length (_tmp19_)) : _tmp20_;
		_tmp21__length1 = _vala_array_length (_tmp19_);
		icon_names = _tmp21_;
		icon_names_length1 = _tmp21__length1;
		_icon_names_size_ = icon_names_length1;
		_tmp22_ = icon_names;
		_tmp22__length1 = icon_names_length1;
		if (_tmp22__length1 == 0) {
			result = NULL;
			icon_names = (_vala_array_free (icon_names, icon_names_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (icon);
			return result;
		}
		_tmp23_ = gala_utils_icon_theme;
		_tmp24_ = icon_names;
		_tmp24__length1 = icon_names_length1;
		_tmp25_ = _tmp24_[0];
		_tmp26_ = icon_names;
		_tmp26__length1 = icon_names_length1;
		_tmp27_ = icon_names;
		_tmp27__length1 = icon_names_length1;
		_tmp28_ = gtk_icon_theme_lookup_icon (_tmp23_, _tmp25_, _tmp27_ + 1, icon_size, scale, GTK_TEXT_DIR_NONE, 0);
		icon_paintable = _tmp28_;
		_tmp30_ = icon_paintable;
		_tmp31_ = gtk_icon_paintable_get_file (_tmp30_);
		_tmp29_ = _tmp31_;
		_tmp32_ = NULL;
		if (_tmp29_ != NULL) {
			gchar* _tmp33_;
			_tmp33_ = g_file_get_path (_tmp29_);
			_g_free0 (_tmp32_);
			_tmp32_ = _tmp33_;
		}
		_tmp34_ = _tmp32_;
		_tmp32_ = NULL;
		path = _tmp34_;
		_tmp35_ = path;
		if (_tmp35_ == NULL) {
			result = NULL;
			_g_free0 (path);
			_g_free0 (_tmp32_);
			_g_object_unref0 (_tmp29_);
			_g_object_unref0 (icon_paintable);
			icon_names = (_vala_array_free (icon_names, icon_names_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (icon);
			return result;
		}
		{
			GdkPixbuf* pixbuf = NULL;
			const gchar* _tmp36_;
			GdkPixbuf* _tmp37_;
			GeeHashMultiMap* _tmp38_;
			GdkPixbuf* _tmp39_;
			GdkPixbuf* _tmp40_;
			GalaUtilsCachedIcon _tmp41_ = {0};
			GalaUtilsCachedIcon _tmp42_;
			GalaUtilsCachedIcon _tmp43_;
			_tmp36_ = path;
			_tmp37_ = gdk_pixbuf_new_from_file (_tmp36_, &_inner_error0_);
			pixbuf = _tmp37_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp38_ = gala_utils_icon_cache;
			_tmp39_ = pixbuf;
			_tmp40_ = _g_object_ref0 (_tmp39_);
			memset (&_tmp41_, 0, sizeof (GalaUtilsCachedIcon));
			_g_object_unref0 (_tmp41_.icon);
			_tmp41_.icon = _tmp40_;
			_tmp41_.icon_size = icon_size;
			_tmp41_.scale = scale;
			_tmp42_ = _tmp41_;
			_tmp43_ = _tmp42_;
			gee_multi_map_set ((GeeMultiMap*) _tmp38_, desktop, &_tmp43_);
			gala_utils_cached_icon_destroy (&_tmp42_);
			result = pixbuf;
			_g_free0 (path);
			_g_free0 (_tmp32_);
			_g_object_unref0 (_tmp29_);
			_g_object_unref0 (icon_paintable);
			icon_names = (_vala_array_free (icon_names, icon_names_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (icon);
			return result;
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			result = NULL;
			_g_free0 (path);
			_g_free0 (_tmp32_);
			_g_object_unref0 (_tmp29_);
			_g_object_unref0 (icon_paintable);
			icon_names = (_vala_array_free (icon_names, icon_names_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (icon);
			return result;
		}
		__finally0:
		_g_free0 (path);
		_g_free0 (_tmp32_);
		_g_object_unref0 (_tmp29_);
		_g_object_unref0 (icon_paintable);
		icon_names = (_vala_array_free (icon_names, icon_names_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (icon);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	} else {
		GIcon* _tmp44_;
		_tmp44_ = icon;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, g_file_icon_get_type ())) {
			GFile* file = NULL;
			GIcon* _tmp45_;
			GFile* _tmp46_;
			GFile* _tmp47_;
			GFile* _tmp48_;
			gint size_with_scale = 0;
			_tmp45_ = icon;
			_tmp46_ = g_file_icon_get_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, g_file_icon_get_type (), GFileIcon));
			_tmp47_ = _tmp46_;
			_tmp48_ = _g_object_ref0 (_tmp47_);
			file = _tmp48_;
			size_with_scale = icon_size * scale;
			{
				GFileInputStream* _tmp49_ = NULL;
				GFile* _tmp50_;
				GFileInputStream* _tmp51_;
				GdkPixbuf* pixbuf = NULL;
				GdkPixbuf* _tmp52_;
				GeeHashMultiMap* _tmp53_;
				GdkPixbuf* _tmp54_;
				GdkPixbuf* _tmp55_;
				GalaUtilsCachedIcon _tmp56_ = {0};
				GalaUtilsCachedIcon _tmp57_;
				GalaUtilsCachedIcon _tmp58_;
				_tmp50_ = file;
				_tmp51_ = g_file_read (_tmp50_, NULL, &_inner_error0_);
				_tmp49_ = _tmp51_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp52_ = gdk_pixbuf_new_from_stream_at_scale ((GInputStream*) _tmp49_, size_with_scale, size_with_scale, TRUE, NULL, &_inner_error0_);
				pixbuf = _tmp52_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (_tmp49_);
					goto __catch1_g_error;
				}
				_tmp53_ = gala_utils_icon_cache;
				_tmp54_ = pixbuf;
				_tmp55_ = _g_object_ref0 (_tmp54_);
				memset (&_tmp56_, 0, sizeof (GalaUtilsCachedIcon));
				_g_object_unref0 (_tmp56_.icon);
				_tmp56_.icon = _tmp55_;
				_tmp56_.icon_size = icon_size;
				_tmp56_.scale = scale;
				_tmp57_ = _tmp56_;
				_tmp58_ = _tmp57_;
				gee_multi_map_set ((GeeMultiMap*) _tmp53_, desktop, &_tmp58_);
				gala_utils_cached_icon_destroy (&_tmp57_);
				result = pixbuf;
				_g_object_unref0 (_tmp49_);
				_g_object_unref0 (file);
				_g_object_unref0 (icon);
				return result;
			}
			goto __finally1;
			__catch1_g_error:
			{
				g_clear_error (&_inner_error0_);
				result = NULL;
				_g_object_unref0 (file);
				_g_object_unref0 (icon);
				return result;
			}
			__finally1:
			_g_object_unref0 (file);
			_g_object_unref0 (icon);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	result = NULL;
	_g_object_unref0 (icon);
	return result;
}

/**
         * Multiplies an integer by a floating scaling factor, and then
         * returns the result rounded to the nearest integer
         */
gint
gala_utils_scale_to_int (gint value,
                         gfloat scale_factor)
{
	gint result;
	result = (gint) round ((gdouble) (((gfloat) value) * scale_factor));
	return result;
}

/**
         * Get the number of toplevel windows on a workspace excluding those that are
         * on all workspaces.
         *
         * We need `exclude` here because on Meta.Workspace.window_removed
         * the windows gets removed from workspace's internal window list but not display's window list
         * which Meta.Workspace uses for Meta.Workspace.list_windows ().
         *
         * @param workspace The workspace on which to count the windows
         * @param exclude a window to not count
         * 
         */
guint
gala_utils_get_n_windows (MetaWorkspace* workspace,
                          gboolean on_primary,
                          MetaWindow* exclude)
{
	gint n = 0;
	GList* _tmp0_;
	guint result;
	g_return_val_if_fail (workspace != NULL, 0U);
	n = 0;
	_tmp0_ = meta_workspace_list_windows (workspace);
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp0_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			MetaWindow* window = NULL;
			window = (MetaWindow*) window_it->data;
			{
				gboolean _tmp1_ = FALSE;
				MetaWindow* _tmp2_;
				gboolean _tmp3_;
				gboolean _tmp4_;
				gboolean _tmp6_ = FALSE;
				MetaWindow* _tmp7_;
				_tmp2_ = window;
				g_object_get (_tmp2_, "on-all-workspaces", &_tmp3_, NULL);
				_tmp4_ = _tmp3_;
				if (_tmp4_) {
					_tmp1_ = TRUE;
				} else {
					MetaWindow* _tmp5_;
					_tmp5_ = window;
					_tmp1_ = _tmp5_ == exclude;
				}
				if (_tmp1_) {
					continue;
				}
				_tmp7_ = window;
				if (gala_utils_get_window_is_normal (_tmp7_)) {
					gboolean _tmp8_ = FALSE;
					if (!on_primary) {
						_tmp8_ = TRUE;
					} else {
						gboolean _tmp9_ = FALSE;
						if (on_primary) {
							MetaWindow* _tmp10_;
							_tmp10_ = window;
							_tmp9_ = meta_window_is_on_primary_monitor (_tmp10_);
						} else {
							_tmp9_ = FALSE;
						}
						_tmp8_ = _tmp9_;
					}
					_tmp6_ = _tmp8_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					gint _tmp11_;
					_tmp11_ = n;
					n = _tmp11_ + 1;
				}
			}
		}
		(window_collection == NULL) ? NULL : (window_collection = (g_list_free (window_collection), NULL));
	}
	result = (guint) n;
	return result;
}

/**
         * Creates an actor showing the current contents of the given WindowActor.
         *
         * @param actor      The actor from which to create a snapshot
         * @param inner_rect The inner (actually visible) rectangle of the window
         *
         * @return           A copy of the actor at that time or %NULL
         */
ClutterActor*
gala_utils_get_window_actor_snapshot (MetaWindowActor* actor,
                                      MtkRectangle* inner_rect)
{
	ClutterContent* content = NULL;
	ClutterContent* _tmp6_;
	ClutterActor* container = NULL;
	ClutterContent* _tmp7_;
	ClutterContent* _tmp8_;
	MtkRectangle _tmp9_;
	MtkRectangle _tmp10_;
	MtkRectangle _tmp11_;
	MtkRectangle _tmp12_;
	ClutterActor* _tmp13_ = NULL;
	GError* _inner_error0_ = NULL;
	ClutterActor* result;
	g_return_val_if_fail (actor != NULL, NULL);
	g_return_val_if_fail (inner_rect != NULL, NULL);
	{
		ClutterContent* _tmp0_ = NULL;
		MtkRectangle _tmp1_;
		ClutterContent* _tmp2_;
		ClutterContent* _tmp3_;
		_tmp1_ = *inner_rect;
		_tmp2_ = meta_window_actor_paint_to_content (actor, &_tmp1_, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (content);
		content = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("Utils.vala:332: Could not create window snapshot: %s", _tmp5_);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (content);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (content);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp6_ = content;
	if (_tmp6_ == NULL) {
		g_warning ("Utils.vala:337: Could not create window snapshot");
		result = NULL;
		_g_object_unref0 (content);
		return result;
	}
	_tmp7_ = content;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_tmp9_ = *inner_rect;
	_tmp10_ = *inner_rect;
	_tmp11_ = *inner_rect;
	_tmp12_ = *inner_rect;
	_tmp13_ = clutter_actor_new ();
	clutter_actor_set_content (_tmp13_, _tmp8_);
	_g_object_unref0 (_tmp8_);
	clutter_actor_set_offscreen_redirect (_tmp13_, CLUTTER_OFFSCREEN_REDIRECT_ALWAYS);
	clutter_actor_set_x (_tmp13_, (gfloat) _tmp9_.x);
	clutter_actor_set_y (_tmp13_, (gfloat) _tmp10_.y);
	clutter_actor_set_width (_tmp13_, (gfloat) _tmp11_.width);
	clutter_actor_set_height (_tmp13_, (gfloat) _tmp12_.height);
	g_object_ref_sink (_tmp13_);
	container = _tmp13_;
	result = container;
	_g_object_unref0 (content);
	return result;
}

/**
         * DEPRECATED: When used with Mutter 44, this will always return 1.
         * Get the scaling factor for the monitor you are drawing to with
         * `Meta.Display.get_monitor_scale` instead
         */
gint
gala_utils_get_ui_scaling_factor (void)
{
	gint result;
	result = 1;
	return result;
}

/**
         * Returns the pixbuf that is used for resize buttons throughout gala at a
         * size of 36px
         *
         * @return the resize button pixbuf or null if it failed to load
         */
GdkPixbuf*
gala_utils_get_resize_button_pixbuf (gfloat scale)
{
	gint height = 0;
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp2_;
	gpointer _tmp3_;
	GdkPixbuf* _tmp4_;
	gboolean _tmp5_;
	GeeHashMap* _tmp11_;
	gpointer _tmp12_;
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result;
	height = gala_utils_calculate_button_size (scale);
	_tmp0_ = gala_utils_resize_pixbufs;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		_tmp1_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (gala_utils_resize_pixbufs);
		gala_utils_resize_pixbufs = _tmp1_;
	}
	_tmp2_ = gala_utils_resize_pixbufs;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, (gpointer) ((gintptr) height));
	_tmp4_ = (GdkPixbuf*) _tmp3_;
	_tmp5_ = _tmp4_ == NULL;
	_g_object_unref0 (_tmp4_);
	if (_tmp5_) {
		{
			GdkPixbuf* _tmp6_ = NULL;
			GdkPixbuf* _tmp7_;
			GeeHashMap* _tmp8_;
			_tmp7_ = gdk_pixbuf_new_from_resource_at_scale ("/org/pantheon/desktop/gala/buttons/resize.svg", -1, height, TRUE, &_inner_error0_);
			_tmp6_ = _tmp7_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp8_ = gala_utils_resize_pixbufs;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, (gpointer) ((gintptr) height), _tmp6_);
			_g_object_unref0 (_tmp6_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_;
			const gchar* _tmp10_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			g_warning ("Utils.vala:385: %s", _tmp10_);
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp11_ = gala_utils_resize_pixbufs;
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, (gpointer) ((gintptr) height));
	result = (GdkPixbuf*) _tmp12_;
	return result;
}

/**
         * Creates a new reactive ClutterActor at 36px with the resize pixbuf
         *
         * @return The resize button actor
         */
ClutterActor*
gala_utils_create_resize_button (gfloat scale)
{
	ClutterActor* texture = NULL;
	ClutterActor* _tmp0_;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf* _tmp1_;
	ClutterActor* _tmp2_;
	GdkPixbuf* _tmp3_;
	ClutterActor* result;
	_tmp0_ = clutter_actor_new ();
	g_object_ref_sink (_tmp0_);
	texture = _tmp0_;
	_tmp1_ = gala_utils_get_resize_button_pixbuf (scale);
	pixbuf = _tmp1_;
	_tmp2_ = texture;
	clutter_actor_set_reactive (_tmp2_, TRUE);
	_tmp3_ = pixbuf;
	if (_tmp3_ != NULL) {
		GalaImage* image = NULL;
		GdkPixbuf* _tmp4_;
		GalaImage* _tmp5_;
		ClutterActor* _tmp6_;
		GalaImage* _tmp7_;
		ClutterActor* _tmp8_;
		GdkPixbuf* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		GdkPixbuf* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp4_ = pixbuf;
		_tmp5_ = gala_image_new_from_pixbuf (_tmp4_);
		image = _tmp5_;
		_tmp6_ = texture;
		_tmp7_ = image;
		clutter_actor_set_content (_tmp6_, (ClutterContent*) _tmp7_);
		_tmp8_ = texture;
		_tmp9_ = pixbuf;
		_tmp10_ = gdk_pixbuf_get_width (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = pixbuf;
		_tmp13_ = gdk_pixbuf_get_height (_tmp12_);
		_tmp14_ = _tmp13_;
		clutter_actor_set_size (_tmp8_, (gfloat) _tmp11_, (gfloat) _tmp14_);
		_g_object_unref0 (image);
	} else {
		gint size = 0;
		ClutterActor* _tmp15_;
		ClutterActor* _tmp16_;
		ClutterColor _tmp17_ = {0};
		size = gala_utils_calculate_button_size (scale);
		_tmp15_ = texture;
		clutter_actor_set_size (_tmp15_, (gfloat) size, (gfloat) size);
		_tmp16_ = texture;
		_tmp17_.red = (guint8) 255;
		_tmp17_.green = (guint8) 0;
		_tmp17_.blue = (guint8) 0;
		_tmp17_.alpha = (guint8) 255;
		clutter_actor_set_background_color (_tmp16_, &_tmp17_);
	}
	result = texture;
	_g_object_unref0 (pixbuf);
	return result;
}

static RECTANGLE*
_rectangle_dup (RECTANGLE* self)
{
	RECTANGLE* dup;
	dup = g_new0 (RECTANGLE, 1);
	memcpy (dup, self, sizeof (RECTANGLE));
	return dup;
}

static gpointer
__rectangle_dup0 (gpointer self)
{
	return self ? _rectangle_dup (self) : NULL;
}

void
gala_utils_x11_set_window_pass_through (MetaWindow* window)
{
	MetaX11Display* x11_display = NULL;
	MetaDisplay* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaX11Display* _tmp2_;
	Window x_window = 0;
	Display* xdisplay = NULL;
	Display* _tmp3_;
	gint count = 0;
	gint ordering = 0;
	GHashTable* _tmp4_;
	MetaWindow* _tmp5_;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	RECTANGLE* _tmp8_;
	RECTANGLE _tmp9_;
	RECTANGLE* _tmp10_;
	XRectangle rect = {0};
	XRectangle _tmp11_ = {0};
	XserverRegion region = {0};
	XRectangle* _tmp12_;
	XRectangle* _tmp13_;
	gint _tmp13__length1;
	XserverRegion _tmp14_;
	g_return_if_fail (window != NULL);
	_tmp0_ = meta_window_get_display (window);
	_tmp1_ = _tmp0_;
	_tmp2_ = meta_display_get_x11_display (_tmp1_);
	x11_display = _tmp2_;
	x_window = meta_x11_display_lookup_xwindow (x11_display, window);
	_tmp3_ = meta_x11_display_get_xdisplay (x11_display);
	xdisplay = _tmp3_;
	_tmp4_ = gala_utils_regions;
	_tmp5_ = _g_object_ref0 (window);
	_tmp8_ = XShapeGetRectangles (xdisplay, x_window, 2, &_tmp6_, &_tmp7_);
	count = _tmp6_;
	ordering = _tmp7_;
	_tmp9_ = _tmp8_[0];
	_tmp10_ = __rectangle_dup0 (&_tmp9_);
	g_hash_table_insert (_tmp4_, _tmp5_, _tmp10_);
	rect = _tmp11_;
	_tmp12_ = g_new0 (XRectangle, 1);
	_tmp12_[0] = rect;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 1;
	_tmp14_ = XFixesCreateRegion (xdisplay, _tmp13_, (gint) 1);
	_tmp13_ = (g_free (_tmp13_), NULL);
	region = _tmp14_;
	XFixesSetWindowShapeRegion (xdisplay, x_window, 2, 0, 0, region);
	XFixesDestroyRegion (xdisplay, region);
}

void
gala_utils_x11_unset_window_pass_through (MetaWindow* window,
                                          gboolean restore_previous_region)
{
	MetaX11Display* x11_display = NULL;
	MetaDisplay* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaX11Display* _tmp2_;
	Window x_window = 0;
	MetaX11Display* _tmp3_;
	Display* xdisplay = NULL;
	MetaX11Display* _tmp4_;
	Display* _tmp5_;
	GHashTable* _tmp15_;
	g_return_if_fail (window != NULL);
	_tmp0_ = meta_window_get_display (window);
	_tmp1_ = _tmp0_;
	_tmp2_ = meta_display_get_x11_display (_tmp1_);
	x11_display = _tmp2_;
	_tmp3_ = x11_display;
	x_window = meta_x11_display_lookup_xwindow (_tmp3_, window);
	_tmp4_ = x11_display;
	_tmp5_ = meta_x11_display_get_xdisplay (_tmp4_);
	xdisplay = _tmp5_;
	if (restore_previous_region) {
		RECTANGLE* region = NULL;
		GHashTable* _tmp6_;
		gconstpointer _tmp7_;
		RECTANGLE* _tmp8_;
		RECTANGLE* _tmp9_;
		Display* _tmp10_;
		RECTANGLE* _tmp11_;
		RECTANGLE* _tmp12_;
		RECTANGLE* _tmp13_;
		gint _tmp13__length1;
		_tmp6_ = gala_utils_regions;
		_tmp7_ = g_hash_table_lookup (_tmp6_, window);
		_tmp8_ = __rectangle_dup0 ((RECTANGLE*) _tmp7_);
		region = _tmp8_;
		_tmp9_ = region;
		if (_tmp9_ == NULL) {
			g_debug ("Utils.vala:456: Cannot unset pass through: window not found.");
			_g_free0 (region);
			return;
		}
		_tmp10_ = xdisplay;
		_tmp11_ = region;
		_tmp12_ = g_new0 (RECTANGLE, 1);
		_tmp12_[0] = *_tmp11_;
		_tmp13_ = _tmp12_;
		_tmp13__length1 = 1;
		XShapeCombineRectangles (_tmp10_, x_window, 2, 0, 0, (XRectangle*) _tmp13_, (gint) 1, 0, 3);
		_tmp13_ = (g_free (_tmp13_), NULL);
		_g_free0 (region);
	} else {
		Display* _tmp14_;
		_tmp14_ = xdisplay;
		XFixesSetWindowShapeRegion (_tmp14_, x_window, 2, 0, 0, (XserverRegion) 0);
	}
	_tmp15_ = gala_utils_regions;
	g_hash_table_remove (_tmp15_, window);
}

/**
         * Utility that returns the given duration or 0 if animations are disabled.
         */
guint
gala_utils_get_animation_duration (guint duration)
{
	guint _tmp0_ = 0U;
	guint result;
	if (meta_prefs_get_gnome_animations ()) {
		_tmp0_ = duration;
	} else {
		_tmp0_ = (guint) 0;
	}
	result = _tmp0_;
	return result;
}

inline gboolean
gala_utils_get_window_is_normal (MetaWindow* window)
{
	MetaWindowType _tmp0_;
	MetaWindowType _tmp1_;
	gboolean result;
	g_return_val_if_fail (window != NULL, FALSE);
	_tmp0_ = meta_window_get_window_type (window);
	_tmp1_ = _tmp0_;
	switch (_tmp1_) {
		case META_WINDOW_NORMAL:
		case META_WINDOW_DIALOG:
		case META_WINDOW_MODAL_DIALOG:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

gint
gala_utils_calculate_button_size (gfloat monitor_scale)
{
	gint result;
	result = gala_utils_scale_to_int (GALA_UTILS_BUTTON_SIZE, monitor_scale);
	return result;
}

GalaUtils*
gala_utils_construct (GType object_type)
{
	GalaUtils* self = NULL;
	self = (GalaUtils*) g_type_create_instance (object_type);
	return self;
}

GalaUtils*
gala_utils_new (void)
{
	return gala_utils_construct (GALA_TYPE_UTILS);
}

static void
gala_utils_cached_icon_copy (const GalaUtilsCachedIcon* self,
                             GalaUtilsCachedIcon* dest)
{
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	_tmp0_ = (*self).icon;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).icon);
	(*dest).icon = _tmp1_;
	(*dest).icon_size = (*self).icon_size;
	(*dest).scale = (*self).scale;
}

static void
gala_utils_cached_icon_destroy (GalaUtilsCachedIcon* self)
{
	_g_object_unref0 ((*self).icon);
}

static GalaUtilsCachedIcon*
gala_utils_cached_icon_dup (const GalaUtilsCachedIcon* self)
{
	GalaUtilsCachedIcon* dup;
	dup = g_new0 (GalaUtilsCachedIcon, 1);
	gala_utils_cached_icon_copy (self, dup);
	return dup;
}

static void
gala_utils_cached_icon_free (GalaUtilsCachedIcon* self)
{
	gala_utils_cached_icon_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gala_utils_cached_icon_get_type_once (void)
{
	GType gala_utils_cached_icon_type_id;
	gala_utils_cached_icon_type_id = g_boxed_type_register_static ("GalaUtilsCachedIcon", (GBoxedCopyFunc) gala_utils_cached_icon_dup, (GBoxedFreeFunc) gala_utils_cached_icon_free);
	return gala_utils_cached_icon_type_id;
}

static GType
gala_utils_cached_icon_get_type (void)
{
	static gsize gala_utils_cached_icon_type_id__once = 0;
	if (g_once_init_enter (&gala_utils_cached_icon_type_id__once)) {
		GType gala_utils_cached_icon_type_id;
		gala_utils_cached_icon_type_id = gala_utils_cached_icon_get_type_once ();
		g_once_init_leave (&gala_utils_cached_icon_type_id__once, gala_utils_cached_icon_type_id);
	}
	return gala_utils_cached_icon_type_id__once;
}

static void
_gala_utils___lambda11_ (void)
{
	GeeHashMultiMap* _tmp0_;
	GeeHashMap* _tmp1_;
	_tmp0_ = gala_utils_icon_cache;
	gee_multi_map_clear ((GeeMultiMap*) _tmp0_);
	_tmp1_ = gala_utils_window_to_desktop_cache;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp1_);
}

static void
__gala_utils___lambda11__gala_app_cache_changed (GalaAppCache* _sender,
                                                 gpointer self)
{
	_gala_utils___lambda11_ ();
}

static void
gala_value_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gala_value_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gala_utils_unref (value->data[0].v_pointer);
	}
}

static void
gala_value_utils_copy_value (const GValue* src_value,
                             GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gala_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gala_value_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gala_value_utils_collect_value (GValue* value,
                                guint n_collect_values,
                                GTypeCValue* collect_values,
                                guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GalaUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gala_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gala_value_utils_lcopy_value (const GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	GalaUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gala_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gala_param_spec_utils (const gchar* name,
                       const gchar* nick,
                       const gchar* blurb,
                       GType object_type,
                       GParamFlags flags)
{
	GalaParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GALA_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gala_value_get_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
gala_value_set_utils (GValue* value,
                      gpointer v_object)
{
	GalaUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gala_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_utils_unref (old);
	}
}

void
gala_value_take_utils (GValue* value,
                       gpointer v_object)
{
	GalaUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GALA_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GALA_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gala_utils_unref (old);
	}
}

static void
gala_utils_class_init (GalaUtilsClass * klass,
                       gpointer klass_data)
{
	GHashTable* _tmp0_;
	gchar* _tmp1_;
	GtkIconTheme* _tmp2_ = NULL;
	GeeHashMultiMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeArrayList* _tmp5_;
	GalaAppCache* _tmp6_;
	GalaAppCache* _tmp7_;
	gala_utils_parent_class = g_type_class_peek_parent (klass);
	((GalaUtilsClass *) klass)->finalize = gala_utils_finalize;
	_tmp0_ = g_hash_table_new_full (NULL, NULL, _g_object_unref0_, _g_free0_);
	gala_utils_regions = _tmp0_;
	_tmp1_ = g_strdup ("elementary");
	_tmp2_ = gtk_icon_theme_new ();
	gtk_icon_theme_set_theme_name (_tmp2_, _tmp1_);
	_g_free0 (_tmp1_);
	_g_object_unref0 (gala_utils_icon_theme);
	gala_utils_icon_theme = _tmp2_;
	_tmp3_ = gee_hash_multi_map_new (G_TYPE_DESKTOP_APP_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, GALA_UTILS_TYPE_CACHED_ICON, (GBoxedCopyFunc) gala_utils_cached_icon_dup, (GDestroyNotify) gala_utils_cached_icon_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (gala_utils_icon_cache);
	gala_utils_icon_cache = _tmp3_;
	_tmp4_ = gee_hash_map_new (meta_window_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, G_TYPE_DESKTOP_APP_INFO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (gala_utils_window_to_desktop_cache);
	gala_utils_window_to_desktop_cache = _tmp4_;
	_tmp5_ = gee_array_list_new (GALA_UTILS_TYPE_CACHED_ICON, (GBoxedCopyFunc) gala_utils_cached_icon_dup, (GDestroyNotify) gala_utils_cached_icon_free, NULL, NULL, NULL);
	_g_object_unref0 (gala_utils_unknown_icon_cache);
	gala_utils_unknown_icon_cache = _tmp5_;
	_tmp6_ = gala_app_cache_new ();
	_g_object_unref0 (gala_utils_app_cache);
	gala_utils_app_cache = _tmp6_;
	_tmp7_ = gala_utils_app_cache;
	g_signal_connect (_tmp7_, "changed", (GCallback) __gala_utils___lambda11__gala_app_cache_changed, NULL);
}

static void
gala_utils_instance_init (GalaUtils * self,
                          gpointer klass)
{
	self->ref_count = 1;
}

static void
gala_utils_finalize (GalaUtils * obj)
{
	GalaUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_UTILS, GalaUtils);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
gala_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gala_value_utils_init, gala_value_utils_free_value, gala_value_utils_copy_value, gala_value_utils_peek_pointer, "p", gala_value_utils_collect_value, "p", gala_value_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GalaUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaUtils), 0, (GInstanceInitFunc) gala_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gala_utils_type_id;
	gala_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GalaUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return gala_utils_type_id;
}

GType
gala_utils_get_type (void)
{
	static gsize gala_utils_type_id__once = 0;
	if (g_once_init_enter (&gala_utils_type_id__once)) {
		GType gala_utils_type_id;
		gala_utils_type_id = gala_utils_get_type_once ();
		g_once_init_leave (&gala_utils_type_id__once, gala_utils_type_id);
	}
	return gala_utils_type_id__once;
}

gpointer
gala_utils_ref (gpointer instance)
{
	GalaUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gala_utils_unref (gpointer instance)
{
	GalaUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GALA_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

