// Generated from libavcodec/vulkan/rangecoder.comp
const char *ff_source_rangecoder_comp =
"/*\n"
" * FFv1 codec\n"
" *\n"
" * Copyright (c) 2024 Lynne <dev@lynne.ee>\n"
" *\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"struct RangeCoder {\n"
"    uint64_t bytestream_start;\n"
"    uint64_t bytestream;\n"
"    uint64_t bytestream_end;\n"
"\n"
"    int low;\n"
"    int range;\n"
"    uint16_t outstanding_count;\n"
"    uint8_t outstanding_byte;\n"
"};\n"
"\n"
"#ifdef FULL_RENORM\n"
"/* Full renorm version that can handle outstanding_byte == 0xFF */\n"
"void renorm_encoder(inout RangeCoder c)\n"
"{\n"
"    int bs_cnt = 0;\n"
"    u8buf bytestream = u8buf(c.bytestream);\n"
"\n"
"    if (c.outstanding_byte == 0xFF) {\n"
"        c.outstanding_byte = uint8_t(c.low >> 8);\n"
"    } else if (c.low <= 0xFF00) {\n"
"        bytestream[bs_cnt++].v = c.outstanding_byte;\n"
"        uint16_t cnt = c.outstanding_count;\n"
"        for (; cnt > 0; cnt--)\n"
"            bytestream[bs_cnt++].v = uint8_t(0xFF);\n"
"        c.outstanding_count = uint16_t(0);\n"
"        c.outstanding_byte = uint8_t(c.low >> 8);\n"
"    } else if (c.low >= 0x10000) {\n"
"        bytestream[bs_cnt++].v = c.outstanding_byte + uint8_t(1);\n"
"        uint16_t cnt = c.outstanding_count;\n"
"        for (; cnt > 0; cnt--)\n"
"            bytestream[bs_cnt++].v = uint8_t(0x00);\n"
"        c.outstanding_count = uint16_t(0);\n"
"        c.outstanding_byte = uint8_t(bitfieldExtract(c.low, 8, 8));\n"
"    } else {\n"
"        c.outstanding_count++;\n"
"    }\n"
"\n"
"    c.bytestream += bs_cnt;\n"
"    c.range <<= 8;\n"
"    c.low = bitfieldInsert(0, c.low, 8, 8);\n"
"}\n"
"\n"
"#else\n"
"\n"
"/* Cannot deal with outstanding_byte == -1 in the name of speed */\n"
"void renorm_encoder(inout RangeCoder c)\n"
"{\n"
"    uint16_t oc = c.outstanding_count + uint16_t(1);\n"
"    int low = c.low;\n"
"\n"
"    c.range <<= 8;\n"
"    c.low = bitfieldInsert(0, low, 8, 8);\n"
"\n"
"    if (low > 0xFF00 && low < 0x10000) {\n"
"        c.outstanding_count = oc;\n"
"        return;\n"
"    }\n"
"\n"
"    u8buf bs = u8buf(c.bytestream);\n"
"    uint8_t outstanding_byte = c.outstanding_byte;\n"
"\n"
"    c.bytestream        = uint64_t(bs) + oc;\n"
"    c.outstanding_count = uint16_t(0);\n"
"    c.outstanding_byte  = uint8_t(low >> 8);\n"
"\n"
"    uint8_t obs = uint8_t(low > 0xFF00);\n"
"    uint8_t fill = obs - uint8_t(1); /* unsigned underflow */\n"
"\n"
"    bs[0].v = outstanding_byte + obs;\n"
"    for (int i = 1; i < oc; i++)\n"
"        bs[i].v = fill;\n"
"}\n"
"#endif\n"
"\n"
"void put_rac_internal(inout RangeCoder c, const int range1, bool bit)\n"
"{\n"
"#ifdef DEBUG\n"
"    if (range1 >= c.range)\n"
"        debugPrintfEXT(\"Error: range1 >= c.range\");\n"
"    if (range1 <= 0)\n"
"        debugPrintfEXT(\"Error: range1 <= 0\");\n"
"#endif\n"
"\n"
"    int ranged = c.range - range1;\n"
"    c.low += bit ? ranged : 0;\n"
"    c.range = bit ? range1 : ranged;\n"
"\n"
"    if (expectEXT(c.range < 0x100, false))\n"
"        renorm_encoder(c);\n"
"}\n"
"\n"
"void put_rac_direct(inout RangeCoder c, inout uint8_t state, bool bit)\n"
"{\n"
"    put_rac_internal(c, (c.range * state) >> 8, bit);\n"
"    state = zero_one_state[(uint(bit) << 8) + state];\n"
"}\n"
"\n"
"void put_rac(inout RangeCoder c, uint64_t state, bool bit)\n"
"{\n"
"    put_rac_direct(c, u8buf(state).v, bit);\n"
"}\n"
"\n"
"/* Equiprobable bit */\n"
"void put_rac_equi(inout RangeCoder c, bool bit)\n"
"{\n"
"    put_rac_internal(c, c.range >> 1, bit);\n"
"}\n"
"\n"
"void put_rac_terminate(inout RangeCoder c)\n"
"{\n"
"    int range1 = (c.range * 129) >> 8;\n"
"\n"
"#ifdef DEBUG\n"
"    if (range1 >= c.range)\n"
"        debugPrintfEXT(\"Error: range1 >= c.range\");\n"
"    if (range1 <= 0)\n"
"        debugPrintfEXT(\"Error: range1 <= 0\");\n"
"#endif\n"
"\n"
"    c.range -= range1;\n"
"    if (expectEXT(c.range < 0x100, false))\n"
"        renorm_encoder(c);\n"
"}\n"
"\n"
"/* Return the number of bytes written. */\n"
"uint32_t rac_terminate(inout RangeCoder c)\n"
"{\n"
"    put_rac_terminate(c);\n"
"    c.range = uint16_t(0xFF);\n"
"    c.low  += 0xFF;\n"
"    renorm_encoder(c);\n"
"    c.range = uint16_t(0xFF);\n"
"    renorm_encoder(c);\n"
"\n"
"#ifdef DEBUG\n"
"    if (c.low != 0)\n"
"        debugPrintfEXT(\"Error: c.low != 0\");\n"
"    if (c.range < 0x100)\n"
"        debugPrintfEXT(\"Error: range < 0x100\");\n"
"#endif\n"
"\n"
"    return uint32_t(uint64_t(c.bytestream) - uint64_t(c.bytestream_start));\n"
"}\n"
"\n"
"void rac_init(out RangeCoder r, u8buf data, uint buf_size)\n"
"{\n"
"    r.bytestream_start = uint64_t(data);\n"
"    r.bytestream = uint64_t(data);\n"
"    r.bytestream_end = uint64_t(data) + buf_size;\n"
"    r.low = 0;\n"
"    r.range = 0xFF00;\n"
"    r.outstanding_count = uint16_t(0);\n"
"    r.outstanding_byte = uint8_t(0xFF);\n"
"}\n"
"\n"
"/* Decoder */\n"
"uint overread = 0;\n"
"bool corrupt = false;\n"
"\n"
"void rac_init_dec(out RangeCoder r, u8buf data, uint buf_size)\n"
"{\n"
"    overread = 0;\n"
"    corrupt = false;\n"
"\n"
"    /* Skip priming bytes */\n"
"    rac_init(r, OFFBUF(u8buf, data, 2), buf_size - 2);\n"
"\n"
"    u8vec2 prime = u8vec2buf(data).v;\n"
"    /* Switch endianness of the priming bytes */\n"
"    r.low = pack16(prime.yx);\n"
"\n"
"    if (r.low >= 0xFF00) {\n"
"        r.low = 0xFF00;\n"
"        r.bytestream_end = uint64_t(data) + 2;\n"
"    }\n"
"}\n"
"\n"
"void refill(inout RangeCoder c)\n"
"{\n"
"    c.range <<= 8;\n"
"    c.low   <<= 8;\n"
"    if (expectEXT(c.bytestream < c.bytestream_end, false)) {\n"
"        c.low |= u8buf(c.bytestream).v;\n"
"        c.bytestream++;\n"
"    } else {\n"
"        overread++;\n"
"    }\n"
"}\n"
"\n"
"bool get_rac_internal(inout RangeCoder c, const int range1)\n"
"{\n"
"    int ranged = c.range - range1;\n"
"    bool bit = c.low >= ranged;\n"
"    c.low -= bit ? ranged : 0;\n"
"    c.range = (bit ? 0 : ranged) + (bit ? range1 : 0);\n"
"\n"
"    if (expectEXT(c.range < 0x100, false))\n"
"        refill(c);\n"
"\n"
"    return bit;\n"
"}\n"
"\n"
"bool get_rac_direct(inout RangeCoder c, inout uint8_t state)\n"
"{\n"
"    bool bit = get_rac_internal(c, c.range * state >> 8);\n"
"    state = zero_one_state[state + (bit ? 256 : 0)];\n"
"    return bit;\n"
"}\n"
"\n"
"bool get_rac(inout RangeCoder c, uint64_t state)\n"
"{\n"
"    return get_rac_direct(c, u8buf(state).v);\n"
"}\n"
"\n"
"bool get_rac_equi(inout RangeCoder c)\n"
"{\n"
"    return get_rac_internal(c, c.range >> 1);\n"
"}\n"
;
