// Generated from libavcodec/vulkan/ffv1_dec.comp
const char *ff_source_ffv1_dec_comp =
"/*\n"
" * FFv1 codec\n"
" *\n"
" * Copyright (c) 2024 Lynne <dev@lynne.ee>\n"
" *\n"
" * This file is part of FFmpeg.\n"
" *\n"
" * FFmpeg is free software; you can redistribute it and/or\n"
" * modify it under the terms of the GNU Lesser General Public\n"
" * License as published by the Free Software Foundation; either\n"
" * version 2.1 of the License, or (at your option) any later version.\n"
" *\n"
" * FFmpeg is distributed in the hope that it will be useful,\n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU\n"
" * Lesser General Public License for more details.\n"
" *\n"
" * You should have received a copy of the GNU Lesser General Public\n"
" * License along with FFmpeg; if not, write to the Free Software\n"
" * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA\n"
" */\n"
"\n"
"#ifndef GOLOMB\n"
"#ifdef CACHED_SYMBOL_READER\n"
"shared uint8_t state[CONTEXT_SIZE];\n"
"#define READ(c, off) get_rac_direct(c, state[off])\n"
"#else\n"
"#define READ(c, off) get_rac(c, uint64_t(slice_state) + (state_off + off))\n"
"#endif\n"
"\n"
"int get_isymbol(inout RangeCoder c, uint state_off)\n"
"{\n"
"    if (READ(c, 0))\n"
"        return 0;\n"
"\n"
"    uint e = 1;\n"
"    for (; e < 33; e++)\n"
"        if (!READ(c, min(e, 10)))\n"
"            break;\n"
"\n"
"    if (expectEXT(e == 1, false)) {\n"
"        return READ(c, 11) ? -1 : 1;\n"
"    } else if (expectEXT(e == 33, false)) {\n"
"        corrupt = true;\n"
"        return 0;\n"
"    }\n"
"\n"
"    int a = 1;\n"
"    for (uint i = e + 20; i >= 22; i--) {\n"
"        a <<= 1;\n"
"        a |= int(READ(c, min(i, 31)));\n"
"    }\n"
"\n"
"    return READ(c, min(e + 10, 21)) ? -a : a;\n"
"}\n"
"\n"
"void decode_line_pcm(inout SliceContext sc, ivec2 sp, int w, int y, int p, int bits)\n"
"{\n"
"#ifdef CACHED_SYMBOL_READER\n"
"    if (gl_LocalInvocationID.x > 0)\n"
"        return;\n"
"#endif\n"
"\n"
"#ifndef RGB\n"
"    if (p > 0 && p < 3) {\n"
"        w >>= chroma_shift.x;\n"
"        sp >>= chroma_shift;\n"
"    }\n"
"#endif\n"
"\n"
"    for (int x = 0; x < w; x++) {\n"
"        uint v = 0;\n"
"        for (int i = (bits - 1); i >= 0; i--)\n"
"            v |= uint(get_rac_equi(sc.c)) << i;\n"
"\n"
"        imageStore(dec[p], sp + LADDR(ivec2(x, y)), uvec4(v));\n"
"    }\n"
"}\n"
"\n"
"void decode_line(inout SliceContext sc, ivec2 sp, int w,\n"
"                 int y, int p, int bits, uint state_off,\n"
"                 uint8_t quant_table_idx, const int run_index)\n"
"{\n"
"#ifndef RGB\n"
"    if (p > 0 && p < 3) {\n"
"        w >>= chroma_shift.x;\n"
"        sp >>= chroma_shift;\n"
"    }\n"
"#endif\n"
"\n"
"    for (int x = 0; x < w; x++) {\n"
"        ivec2 pr = get_pred(dec[p], sp, ivec2(x, y), 0, w,\n"
"                            quant_table_idx, extend_lookup[quant_table_idx] > 0);\n"
"\n"
"        uint context_off = state_off + CONTEXT_SIZE*abs(pr[0]);\n"
"#ifdef CACHED_SYMBOL_READER\n"
"        u8buf sb = u8buf(uint64_t(slice_state) + context_off + gl_LocalInvocationID.x);\n"
"        state[gl_LocalInvocationID.x] = sb.v;\n"
"        barrier();\n"
"        if (gl_LocalInvocationID.x == 0) {\n"
"\n"
"#endif\n"
"\n"
"            int diff = get_isymbol(sc.c, context_off);\n"
"            if (pr[0] < 0)\n"
"                diff = -diff;\n"
"\n"
"            uint v = zero_extend(pr[1] + diff, bits);\n"
"            imageStore(dec[p], sp + LADDR(ivec2(x, y)), uvec4(v));\n"
"\n"
"#ifdef CACHED_SYMBOL_READER\n"
"        }\n"
"\n"
"        barrier();\n"
"        sb.v = state[gl_LocalInvocationID.x];\n"
"#endif\n"
"    }\n"
"}\n"
"\n"
"#else /* GOLOMB */\n"
"\n"
"void decode_line(inout SliceContext sc, ivec2 sp, int w,\n"
"                 int y, int p, int bits, uint state_off,\n"
"                 uint8_t quant_table_idx, inout int run_index)\n"
"{\n"
"#ifndef RGB\n"
"    if (p > 0 && p < 3) {\n"
"        w >>= chroma_shift.x;\n"
"        sp >>= chroma_shift;\n"
"    }\n"
"#endif\n"
"\n"
"    int run_count = 0;\n"
"    int run_mode  = 0;\n"
"\n"
"    for (int x = 0; x < w; x++) {\n"
"        ivec2 pos = sp + ivec2(x, y);\n"
"        int diff;\n"
"        ivec2 pr = get_pred(dec[p], sp, ivec2(x, y), 0, w,\n"
"                            quant_table_idx, extend_lookup[quant_table_idx] > 0);\n"
"\n"
"        uint context_off = state_off + VLC_STATE_SIZE*abs(pr[0]);\n"
"        VlcState sb = VlcState(uint64_t(slice_state) + context_off);\n"
"\n"
"        if (pr[0] == 0 && run_mode == 0)\n"
"            run_mode = 1;\n"
"\n"
"        if (run_mode != 0) {\n"
"            if (run_count == 0 && run_mode == 1) {\n"
"                int tmp_idx = int(log2_run[run_index]);\n"
"                if (get_bit(sc.gb)) {\n"
"                    run_count = 1 << tmp_idx;\n"
"                    if (x + run_count <= w)\n"
"                        run_index++;\n"
"                } else {\n"
"                    if (tmp_idx != 0) {\n"
"                        run_count = int(get_bits(sc.gb, tmp_idx));\n"
"                    } else\n"
"                        run_count = 0;\n"
"\n"
"                    if (run_index != 0)\n"
"                        run_index--;\n"
"                    run_mode = 2;\n"
"                }\n"
"            }\n"
"\n"
"            run_count--;\n"
"            if (run_count < 0) {\n"
"                run_mode  = 0;\n"
"                run_count = 0;\n"
"                diff = read_vlc_symbol(sc.gb, sb, bits);\n"
"                if (diff >= 0)\n"
"                    diff++;\n"
"            } else {\n"
"                diff = 0;\n"
"            }\n"
"        } else {\n"
"            diff = read_vlc_symbol(sc.gb, sb, bits);\n"
"        }\n"
"\n"
"        if (pr[0] < 0)\n"
"            diff = -diff;\n"
"\n"
"        uint v = zero_extend(pr[1] + diff, bits);\n"
"        imageStore(dec[p], sp + LADDR(ivec2(x, y)), uvec4(v));\n"
"    }\n"
"}\n"
"#endif\n"
"\n"
"#ifdef RGB\n"
"ivec4 transform_sample(ivec4 pix, ivec2 rct_coef)\n"
"{\n"
"    pix.b -= rct_offset;\n"
"    pix.r -= rct_offset;\n"
"    pix.g -= (pix.b*rct_coef.y + pix.r*rct_coef.x) >> 2;\n"
"    pix.b += pix.g;\n"
"    pix.r += pix.g;\n"
"    return ivec4(pix[fmt_lut[0]], pix[fmt_lut[1]],\n"
"                 pix[fmt_lut[2]], pix[fmt_lut[3]]);\n"
"}\n"
"\n"
"void writeout_rgb(in SliceContext sc, ivec2 sp, int w, int y, bool apply_rct)\n"
"{\n"
"    for (uint x = gl_LocalInvocationID.x; x < w; x += gl_WorkGroupSize.x) {\n"
"        ivec2 lpos = sp + LADDR(ivec2(x, y));\n"
"        ivec2 pos = sc.slice_pos + ivec2(x, y);\n"
"\n"
"        ivec4 pix;\n"
"        pix.r = int(imageLoad(dec[2], lpos)[0]);\n"
"        pix.g = int(imageLoad(dec[0], lpos)[0]);\n"
"        pix.b = int(imageLoad(dec[1], lpos)[0]);\n"
"        if (transparency != 0)\n"
"            pix.a = int(imageLoad(dec[3], lpos)[0]);\n"
"\n"
"        if (expectEXT(apply_rct, true))\n"
"            pix = transform_sample(pix, sc.slice_rct_coef);\n"
"\n"
"        imageStore(dst[0], pos, pix);\n"
"        if (planar_rgb != 0) {\n"
"            for (int i = 1; i < color_planes; i++)\n"
"                imageStore(dst[i], pos, ivec4(pix[i]));\n"
"        }\n"
"    }\n"
"}\n"
"#endif\n"
"\n"
"void decode_slice(inout SliceContext sc, const uint slice_idx)\n"
"{\n"
"    int w = sc.slice_dim.x;\n"
"    ivec2 sp = sc.slice_pos;\n"
"\n"
"#ifndef RGB\n"
"    int bits = bits_per_raw_sample;\n"
"#else\n"
"    int bits = 9;\n"
"    if (bits != 8 || sc.slice_coding_mode != 0)\n"
"        bits = bits_per_raw_sample + int(sc.slice_coding_mode != 1);\n"
"\n"
"    sp.y = int(gl_WorkGroupID.y)*RGB_LINECACHE;\n"
"#endif\n"
"\n"
"    /* PCM coding */\n"
"#ifndef GOLOMB\n"
"    if (sc.slice_coding_mode == 1) {\n"
"#ifndef RGB\n"
"        for (int p = 0; p < planes; p++) {\n"
"            int h = sc.slice_dim.y;\n"
"            if (p > 0 && p < 3)\n"
"                h >>= chroma_shift.y;\n"
"\n"
"            for (int y = 0; y < h; y++)\n"
"                decode_line_pcm(sc, sp, w, y, p, bits);\n"
"        }\n"
"#else\n"
"        for (int y = 0; y < sc.slice_dim.y; y++) {\n"
"            for (int p = 0; p < color_planes; p++)\n"
"                decode_line_pcm(sc, sp, w, y, p, bits);\n"
"\n"
"            writeout_rgb(sc, sp, w, y, false);\n"
"        }\n"
"#endif\n"
"    } else\n"
"\n"
"    /* Arithmetic coding */\n"
"#endif\n"
"    {\n"
"        u8vec4 quant_table_idx = sc.quant_table_idx.xyyz;\n"
"        u32vec4 slice_state_off = (slice_idx*codec_planes + uvec4(0, 1, 1, 2))*plane_state_size;\n"
"\n"
"#ifndef RGB\n"
"        for (int p = 0; p < planes; p++) {\n"
"            int h = sc.slice_dim.y;\n"
"            if (p > 0 && p < 3)\n"
"                h >>= chroma_shift.y;\n"
"\n"
"            int run_index = 0;\n"
"            for (int y = 0; y < h; y++)\n"
"                decode_line(sc, sp, w, y, p, bits,\n"
"                            slice_state_off[p], quant_table_idx[p], run_index);\n"
"        }\n"
"#else\n"
"        int run_index = 0;\n"
"        for (int y = 0; y < sc.slice_dim.y; y++) {\n"
"            for (int p = 0; p < color_planes; p++)\n"
"                decode_line(sc, sp, w, y, p, bits,\n"
"                            slice_state_off[p], quant_table_idx[p], run_index);\n"
"\n"
"            writeout_rgb(sc, sp, w, y, true);\n"
"        }\n"
"#endif\n"
"    }\n"
"}\n"
"\n"
"void main(void)\n"
"{\n"
"    const uint slice_idx = gl_WorkGroupID.y*gl_NumWorkGroups.x + gl_WorkGroupID.x;\n"
"    decode_slice(slice_ctx[slice_idx], slice_idx);\n"
"\n"
"    uint32_t status = corrupt ? uint32_t(corrupt) : overread;\n"
"    if (status != 0)\n"
"        slice_status[2*slice_idx + 1] = status;\n"
"}\n"
;
