
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "history_historyentry_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_History_HistoryEntry_Type = nullptr;
static PyTypeObject *Sbk_History_HistoryEntry_TypeF(void)
{
    return _Sbk_History_HistoryEntry_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_History_HistoryEntry_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::History::HistoryEntry >()))
        return -1;

    ::History::HistoryEntry *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "HistoryEntry", 0, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: HistoryEntry::HistoryEntry()
    // 1: HistoryEntry::HistoryEntry(History::HistoryEntry)
    if (numArgs == 0) {
        overloadId = 0; // HistoryEntry()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), (pyArgs[0])))) {
        overloadId = 1; // HistoryEntry(History::HistoryEntry)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // HistoryEntry()
        {

            // HistoryEntry()
            cptr = new ::History::HistoryEntry();
            break;
        }
        case 1: // HistoryEntry(const History::HistoryEntry &HistoryEntry)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::History::HistoryEntry cppArg0_local;
            ::History::HistoryEntry *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // HistoryEntry(History::HistoryEntry)
                cptr = new ::History::HistoryEntry(*cppArg0);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::History::HistoryEntry >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_History_HistoryEntry__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_History_HistoryEntry_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_History_HistoryEntry_methods[] = {
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_History_HistoryEntry__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static PyObject *Sbk_History_HistoryEntry_get_id(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->id;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
}
static int Sbk_History_HistoryEntry_set_id(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("id");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("id", "int");
        return -1;
    }

    auto cppOut_local = cppSelf->id;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->id = cppOut_local;

    return 0;
}

static PyObject *Sbk_History_HistoryEntry_get_count(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->count;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
}
static int Sbk_History_HistoryEntry_set_count(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("count");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("count", "int");
        return -1;
    }

    auto cppOut_local = cppSelf->count;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->count = cppOut_local;

    return 0;
}

static PyObject *Sbk_History_HistoryEntry_get_date(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDateTime_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->date), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->date), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_History_HistoryEntry_set_date(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("date");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDateTime_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("date", "QDateTime");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->date;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_History_HistoryEntry_get_url(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    auto *fieldTypeObject = Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]);
    if (auto *sbkOut = Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->url), fieldTypeObject)) {
        pyOut = reinterpret_cast<PyObject *>(sbkOut);
        Py_INCREF(pyOut);
    } else {
        pyOut = Shiboken::Object::newObject(fieldTypeObject, &(cppSelf->url), false, true);
        Shiboken::Object::setParent(self, pyOut);
    }
    return pyOut;
}
static int Sbk_History_HistoryEntry_set_url(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("url");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppValueConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("url", "QUrl");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->url;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_History_HistoryEntry_get_urlString(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->urlString);
}
static int Sbk_History_HistoryEntry_set_urlString(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("urlString");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("urlString", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->urlString;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_History_HistoryEntry_get_title(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->title);
}
static int Sbk_History_HistoryEntry_set_title(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("title");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("title", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->title;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for HistoryEntry
static PyGetSetDef Sbk_History_HistoryEntry_getsetlist[] = {
    {const_cast<char *>("id"), Sbk_History_HistoryEntry_get_id, Sbk_History_HistoryEntry_set_id, nullptr, nullptr},
    {const_cast<char *>("count"), Sbk_History_HistoryEntry_get_count, Sbk_History_HistoryEntry_set_count, nullptr, nullptr},
    {const_cast<char *>("date"), Sbk_History_HistoryEntry_get_date, Sbk_History_HistoryEntry_set_date, nullptr, nullptr},
    {const_cast<char *>("url"), Sbk_History_HistoryEntry_get_url, Sbk_History_HistoryEntry_set_url, nullptr, nullptr},
    {const_cast<char *>("urlString"), Sbk_History_HistoryEntry_get_urlString, Sbk_History_HistoryEntry_set_urlString, nullptr, nullptr},
    {const_cast<char *>("title"), Sbk_History_HistoryEntry_get_title, Sbk_History_HistoryEntry_set_title, nullptr, nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_History_HistoryEntry_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_History_HistoryEntry_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_History_HistoryEntry_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_History_HistoryEntry_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_History_HistoryEntry_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_History_HistoryEntry_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_History_HistoryEntry_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_History_HistoryEntry_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_History_HistoryEntry_spec = {
    "1:PyFalkon.History.HistoryEntry",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_History_HistoryEntry_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void HistoryEntry_PythonToCpp_HistoryEntry_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_History_HistoryEntry_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_HistoryEntry_PythonToCpp_HistoryEntry_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_History_HistoryEntry_TypeF()))
        return HistoryEntry_PythonToCpp_HistoryEntry_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *HistoryEntry_PTR_CppToPython_HistoryEntry(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_History_HistoryEntry_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_History_HistoryEntry_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *HistoryEntry_COPY_CppToPython_HistoryEntry(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::History::HistoryEntry *>(cppIn);
    return Shiboken::Object::newObject(Sbk_History_HistoryEntry_TypeF(), new ::History::HistoryEntry(*source), true, true);
}

// Python to C++ copy conversion.
static void HistoryEntry_PythonToCpp_HistoryEntry_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::History::HistoryEntry *>(cppOut) = *reinterpret_cast< ::History::HistoryEntry *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_HistoryEntry_PythonToCpp_HistoryEntry_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_History_HistoryEntry_TypeF()))
        return HistoryEntry_PythonToCpp_HistoryEntry_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *History_HistoryEntry_SignatureStrings[] = {
    "1:PyFalkon.History.HistoryEntry(self)",
    "0:PyFalkon.History.HistoryEntry(self,HistoryEntry:PyFalkon.History.HistoryEntry)",
    "PyFalkon.History.HistoryEntry.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t History_HistoryEntry_SignatureByteSize = 77;
static constexpr uint8_t History_HistoryEntry_SignatureBytes[77] = {
    0x78, 0xda, 0x33, 0xb4, 0x0a, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0xf3, 0xc8, 0x2c,
    0x2e, 0xc9, 0x2f, 0xaa, 0x84, 0xd1, 0xae, 0x79, 0x25, 0x45, 0x95, 0x1a, 0xc5, 0xa9, 0x39, 0x69,
    0x9a, 0x5c, 0x06, 0x44, 0xa8, 0xd2, 0x41, 0x16, 0xc1, 0xaf, 0x5e, 0x93, 0x0b, 0xaf, 0xb4, 0x5e,
    0x7c, 0x7c, 0x72, 0x7e, 0x41, 0x65, 0x7c, 0x3c, 0xc4, 0x76, 0x5d, 0xbb, 0x92, 0xca, 0x82, 0xcc,
    0xbc, 0x74, 0xbd, 0xf8, 0x60, 0x20, 0x97, 0x0b, 0x00, 0x50, 0xf9, 0x42, 0xa9
};
#endif

PyTypeObject *init_History_HistoryEntry(PyObject *enclosingClass)
{
    if (SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX].type;

    Shiboken::AutoDecRef Sbk_History_HistoryEntry_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_History_HistoryEntry_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "HistoryEntry",
        "History::HistoryEntry",
        &Sbk_History_HistoryEntry_spec,
        &Shiboken::callCppDestructor< ::History::HistoryEntry >,
        Sbk_History_HistoryEntry_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::InnerClass | Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_History_HistoryEntry_Type; // references _Sbk_History_HistoryEntry_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, History_HistoryEntry_SignatureStrings);
#else
    InitSignatureBytes(pyType, History_HistoryEntry_SignatureBytes, History_HistoryEntry_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_History_HistoryEntry_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_History_HistoryEntry_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        HistoryEntry_PythonToCpp_HistoryEntry_PTR,
        is_HistoryEntry_PythonToCpp_HistoryEntry_PTR_Convertible,
        HistoryEntry_PTR_CppToPython_HistoryEntry,
        HistoryEntry_COPY_CppToPython_HistoryEntry);

    Shiboken::Conversions::registerConverterName(converter, "History::HistoryEntry");
    Shiboken::Conversions::registerConverterName(converter, "History::HistoryEntry*");
    Shiboken::Conversions::registerConverterName(converter, "History::HistoryEntry&");
    Shiboken::Conversions::registerConverterAlias(converter, "HistoryEntry");
    Shiboken::Conversions::registerConverterAlias(converter, "HistoryEntry*");
    Shiboken::Conversions::registerConverterAlias(converter, "HistoryEntry&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::History::HistoryEntry).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        HistoryEntry_PythonToCpp_HistoryEntry_COPY,
        is_HistoryEntry_PythonToCpp_HistoryEntry_COPY_Convertible);

    qRegisterMetaType< ::History::HistoryEntry >("HistoryEntry");
    qRegisterMetaType< ::History::HistoryEntry >("History::HistoryEntry");

    return pyType;
}
