/*
 *  Warning: Do not edit this file.
 *  Auto-generated by 'beam_makeops'.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "sys.h"
#include "erl_vm.h"
#include "export.h"
#include "erl_process.h"
#include "bif.h"
#include "erl_atom_table.h"
#include "beam_load.h"

#include "erl_term.h"
#include "erl_map.h"
#include "big.h"
#include "erl_bits.h"
#include "erl_binary.h"
#include "beam_transform_helpers.h"
#include "erl_global_literals.h"
#include "erl_debugger.h"

const char tag_to_letter[] = {
  'u', 'i', 'a', 'x', 'y', 'f', 'h', 'z', 'n', 'p', 'r', 'v', 'l', 'q', 'o', 
};

const OpEntry opc[] = {
/*   0 */  {"aligned_label_Lt", {0,0,0}, "Lt"},
/*   1 */  {"allocate_tt", {0,0,0}, "tt"},
/*   2 */  {"allocate_heap_tIt", {0,0,0}, "tIt"},
/*   3 */  {"append_cons_Is", {0,0,0}, "Is"},
/*   4 */  {"apply_t", {0,0,0}, "t"},
/*   5 */  {"apply_last_tt", {0,0,0}, "tt"},
/*   6 */  {"badmatch_s", {0,0,0}, "s"},
/*   7 */  {"badrecord_s", {0,0,0}, "s"},
/*   8 */  {"bif_bit_size_bjsd", {0,0,0}, "bjsd"},
/*   9 */  {"bif_byte_size_bjsd", {0,0,0}, "bjsd"},
/*  10 */  {"bif_element_jssd", {0,0,0}, "jssd"},
/*  11 */  {"bif_hd_sd", {0,0,0}, "sd"},
/*  12 */  {"bif_is_eq_exact_Ssd", {0,0,0}, "Ssd"},
/*  13 */  {"bif_is_ge_ssd", {0,0,0}, "ssd"},
/*  14 */  {"bif_is_lt_ssd", {0,0,0}, "ssd"},
/*  15 */  {"bif_is_map_key_bjssd", {0,0,0}, "bjssd"},
/*  16 */  {"bif_is_ne_exact_Ssd", {0,0,0}, "Ssd"},
/*  17 */  {"bif_map_get_jssd", {0,0,0}, "jssd"},
/*  18 */  {"bif_map_size_jsd", {0,0,0}, "jsd"},
/*  19 */  {"bif_max_ssd", {0,0,0}, "ssd"},
/*  20 */  {"bif_min_ssd", {0,0,0}, "ssd"},
/*  21 */  {"bif_node_jSd", {0,0,0}, "jSd"},
/*  22 */  {"bif_tuple_size_bjSd", {0,0,0}, "bjSd"},
/*  23 */  {"bs_get_integer2_fStsttd", {0,0,0}, "fStsttd"},
/*  24 */  {"bs_get_tail_Sdt", {0,0,0}, "Sdt"},
/*  25 */  {"bs_init_writable", {0,0,0}, ""},
/*  26 */  {"bs_set_position_SS", {0,0,0}, "SS"},
/*  27 */  {"bs_test_tail2_fSW", {0,0,0}, "fSW"},
/*  28 */  {"bs_test_unit_fSt", {0,0,0}, "fSt"},
/*  29 */  {"build_stacktrace", {0,0,0}, ""},
/*  30 */  {"call_bif_W", {0,0,0}, "W"},
/*  31 */  {"call_bif_mfa_aaI", {0,0,0}, "aaI"},
/*  32 */  {"call_error_handler", {0,0,0}, ""},
/*  33 */  {"call_light_bif_be", {0,0,0}, "be"},
/*  34 */  {"call_nif_WWW", {0,0,0}, "WWW"},
/*  35 */  {"case_end_s", {0,0,0}, "s"},
/*  36 */  {"catch_yf", {0,0,0}, "yf"},
/*  37 */  {"catch_end_y", {0,0,0}, "y"},
/*  38 */  {"continue_exit", {0,0,0}, ""},
/*  39 */  {"deallocate_t", {0,0,0}, "t"},
/*  40 */  {"empty_func_line", {0,0,0}, ""},
/*  41 */  {"executable_line_II", {0,0,0}, "II"},
/*  42 */  {"fconv_sl", {0,0,0}, "sl"},
/*  43 */  {"fload_ql", {0x10002000,0x0,0x0}, "ql"},
/*  44 */  {"fload_Sl", {0x10000018,0x0,0x0}, "Sl"},
/*  45 */  {"fstore_ld", {0,0,0}, "ld"},
/*  46 */  {"func_line_I", {0,0,0}, "I"},
/*  47 */  {"get_hd_Sd", {0,0,0}, "Sd"},
/*  48 */  {"get_list_Sdd", {0,0,0}, "Sdd"},
/*  49 */  {"get_tl_Sd", {0,0,0}, "Sd"},
/*  50 */  {"get_tuple_element_swap_sPdd", {0,0,0}, "sPdd"},
/*  51 */  {"get_two_tuple_elements_sPSS", {0,0,0}, "sPSS"},
/*  52 */  {"i_apply", {0,0,0}, ""},
/*  53 */  {"i_apply_fun", {0,0,0}, ""},
/*  54 */  {"i_apply_fun_last_t", {0,0,0}, "t"},
/*  55 */  {"i_apply_fun_only", {0,0,0}, ""},
/*  56 */  {"i_apply_last_t", {0,0,0}, "t"},
/*  57 */  {"i_apply_only", {0,0,0}, ""},
/*  58 */  {"i_band_ssjd", {0,0,0}, "ssjd"},
/*  59 */  {"i_bif1_sjbd", {0,0,0}, "sjbd"},
/*  60 */  {"i_bif2_ssjbd", {0,0,0}, "ssjbd"},
/*  61 */  {"i_bif3_sssjbd", {0,0,0}, "sssjbd"},
/*  62 */  {"i_bnot_jsd", {0,0,0}, "jsd"},
/*  63 */  {"i_bor_jssd", {0,0,0}, "jssd"},
/*  64 */  {"i_breakpoint_trampoline", {0,0,0}, ""},
/*  65 */  {"i_bs_create_bin_jItd", {0,0,0}, "jItd"},
/*  66 */  {"i_bs_get_bin_and_tail_SftStdd", {0,0,0}, "SftStdd"},
/*  67 */  {"i_bs_get_binary2_Sftstd", {0,0,0}, "Sftstd"},
/*  68 */  {"i_bs_get_binary_all2_Sfttd", {0,0,0}, "Sfttd"},
/*  69 */  {"i_bs_get_float2_Sftstd", {0,0,0}, "Sftstd"},
/*  70 */  {"i_bs_get_position_SS", {0,0,0}, "SS"},
/*  71 */  {"i_bs_get_utf16_Sftd", {0,0,0}, "Sftd"},
/*  72 */  {"i_bs_get_utf8_Sfd", {0,0,0}, "Sfd"},
/*  73 */  {"i_bs_match_fS", {0,0,0}, "fS"},
/*  74 */  {"i_bs_match_string_SfWM", {0,0,0}, "SfWM"},
/*  75 */  {"i_bs_match_test_heap_fSIt", {0,0,0}, "fSIt"},
/*  76 */  {"i_bs_skip_bits2_Ssft", {0,0,0}, "Ssft"},
/*  77 */  {"i_bs_skip_utf16_Sft", {0,0,0}, "Sft"},
/*  78 */  {"i_bs_skip_utf8_Sf", {0,0,0}, "Sf"},
/*  79 */  {"i_bs_start_match3_Stjd", {0,0,0}, "Stjd"},
/*  80 */  {"i_bs_validate_unicode_retract_jsS", {0,0,0}, "jsS"},
/*  81 */  {"i_bsl_ssjd", {0,0,0}, "ssjd"},
/*  82 */  {"i_bsr_ssjd", {0,0,0}, "ssjd"},
/*  83 */  {"i_bxor_jssd", {0,0,0}, "jssd"},
/*  84 */  {"i_call_f", {0,0,0}, "f"},
/*  85 */  {"i_call_ext_e", {0,0,0}, "e"},
/*  86 */  {"i_call_ext_last_et", {0,0,0}, "et"},
/*  87 */  {"i_call_ext_only_e", {0,0,0}, "e"},
/*  88 */  {"i_call_fun_t", {0,0,0}, "t"},
/*  89 */  {"i_call_fun2_atS", {0x10004,0x18,0x0}, "atS"},
/*  90 */  {"i_call_fun2_FtS", {0x10001,0x18,0x0}, "FtS"},
/*  91 */  {"i_call_fun2_last_atSt", {0x10004,0x10018,0x0}, "atSt"},
/*  92 */  {"i_call_fun2_last_FtSt", {0x10001,0x10018,0x0}, "FtSt"},
/*  93 */  {"i_call_fun_last_tt", {0,0,0}, "tt"},
/*  94 */  {"i_call_last_ft", {0,0,0}, "ft"},
/*  95 */  {"i_call_on_load_function", {0,0,0}, ""},
/*  96 */  {"i_call_only_f", {0,0,0}, "f"},
/*  97 */  {"i_call_trace_return", {0,0,0}, ""},
/*  98 */  {"i_debug_breakpoint", {0,0,0}, ""},
/*  99 */  {"i_debug_line_IIt", {0,0,0}, "IIt"},
/* 100 */  {"i_div_rem_ssjdd", {0,0,0}, "ssjdd"},
/* 101 */  {"i_fadd_lll", {0,0,0}, "lll"},
/* 102 */  {"i_fdiv_lll", {0,0,0}, "lll"},
/* 103 */  {"i_fmul_lll", {0,0,0}, "lll"},
/* 104 */  {"i_fnegate_ll", {0,0,0}, "ll"},
/* 105 */  {"i_fsub_lll", {0,0,0}, "lll"},
/* 106 */  {"i_func_info_IaaI", {0,0,0}, "IaaI"},
/* 107 */  {"i_func_label_L", {0,0,0}, "L"},
/* 108 */  {"i_generic_breakpoint", {0,0,0}, ""},
/* 109 */  {"i_get_sd", {0,0,0}, "sd"},
/* 110 */  {"i_get_hash_cWd", {0,0,0}, "cWd"},
/* 111 */  {"i_get_map_element_fSSS", {0,0,0}, "fSSS"},
/* 112 */  {"i_get_map_element_hash_fScWS", {0,0,0}, "fScWS"},
/* 113 */  {"i_get_map_elements_fsI", {0,0,0}, "fsI"},
/* 114 */  {"i_get_tuple_element_sPS", {0,0,0}, "sPS"},
/* 115 */  {"i_hibernate", {0,0,0}, ""},
/* 116 */  {"i_int_div_jssd", {0,0,0}, "jssd"},
/* 117 */  {"i_is_tagged_tuple_fsAa", {0,0,0}, "fsAa"},
/* 118 */  {"i_is_tagged_tuple_ff_ffsAa", {0,0,0}, "ffsAa"},
/* 119 */  {"i_is_tuple_fs", {0,0,0}, "fs"},
/* 120 */  {"i_is_tuple_of_arity_fsA", {0,0,0}, "fsA"},
/* 121 */  {"i_is_tuple_of_arity_ff_ffsA", {0,0,0}, "ffsA"},
/* 122 */  {"i_jump_on_val_sfWI", {0x20211E,0x10001,0x0}, "sfWI"},
/* 123 */  {"i_jump_on_val_snWI", {0x100211E,0x10001,0x0}, "snWI"},
/* 124 */  {"i_lambda_error_t", {0,0,0}, "t"},
/* 125 */  {"i_lambda_trampoline_FfWW", {0,0,0}, "FfWW"},
/* 126 */  {"i_length_jtd", {0,0,0}, "jtd"},
/* 127 */  {"i_length_setup_jts", {0,0,0}, "jts"},
/* 128 */  {"i_line_breakpoint_trampoline", {0,0,0}, ""},
/* 129 */  {"i_load_nif", {0,0,0}, ""},
/* 130 */  {"i_loop_rec_f", {0,0,0}, "f"},
/* 131 */  {"i_m_div_jssd", {0,0,0}, "jssd"},
/* 132 */  {"i_make_fun3_FStt", {0,0,0}, "FStt"},
/* 133 */  {"i_minus_ssjd", {0,0,0}, "ssjd"},
/* 134 */  {"i_move_sd", {0,0,0}, "sd"},
/* 135 */  {"i_mul_add_jssssd", {0,0,0}, "jssssd"},
/* 136 */  {"i_new_small_map_lit_dtqI", {0,0,0}, "dtqI"},
/* 137 */  {"i_nif_padding", {0,0,0}, ""},
/* 138 */  {"i_perf_counter", {0,0,0}, ""},
/* 139 */  {"i_plus_ssjd", {0,0,0}, "ssjd"},
/* 140 */  {"i_rem_ssjd", {0,0,0}, "ssjd"},
/* 141 */  {"i_rem_div_ssjdd", {0,0,0}, "ssjdd"},
/* 142 */  {"i_return_to_trace", {0,0,0}, ""},
/* 143 */  {"i_select_tuple_arity_SfI", {0,0,0}, "SfI"},
/* 144 */  {"i_select_val_bins_sfI", {0x20211E,0x1,0x0}, "sfI"},
/* 145 */  {"i_select_val_bins_snI", {0x100211E,0x1,0x0}, "snI"},
/* 146 */  {"i_select_val_lins_sfI", {0x20211E,0x1,0x0}, "sfI"},
/* 147 */  {"i_select_val_lins_snI", {0x100211E,0x1,0x0}, "snI"},
/* 148 */  {"i_test_arity_fsA", {0,0,0}, "fsA"},
/* 149 */  {"i_test_yield", {0,0,0}, ""},
/* 150 */  {"i_trim_t", {0,0,0}, "t"},
/* 151 */  {"i_unary_minus_sjd", {0,0,0}, "sjd"},
/* 152 */  {"i_validate_t", {0,0,0}, "t"},
/* 153 */  {"i_yield", {0,0,0}, ""},
/* 154 */  {"if_end", {0,0,0}, ""},
/* 155 */  {"init_yregs_I", {0,0,0}, "I"},
/* 156 */  {"int_code_end", {0,0,0}, ""},
/* 157 */  {"is_atom_fs", {0,0,0}, "fs"},
/* 158 */  {"is_binary_fs", {0,0,0}, "fs"},
/* 159 */  {"is_bitstring_fs", {0,0,0}, "fs"},
/* 160 */  {"is_boolean_fs", {0,0,0}, "fs"},
/* 161 */  {"is_eq_fss", {0,0,0}, "fss"},
/* 162 */  {"is_eq_exact_fss", {0,0,0}, "fss"},
/* 163 */  {"is_float_fs", {0,0,0}, "fs"},
/* 164 */  {"is_function_fS", {0,0,0}, "fS"},
/* 165 */  {"is_function2_fss", {0,0,0}, "fss"},
/* 166 */  {"is_ge_fss", {0,0,0}, "fss"},
/* 167 */  {"is_ge_ge_ffScc", {0,0,0}, "ffScc"},
/* 168 */  {"is_ge_lt_ffScc", {0,0,0}, "ffScc"},
/* 169 */  {"is_in_range_ffScc", {0,0,0}, "ffScc"},
/* 170 */  {"is_int_ge_fSc", {0,0,0}, "fSc"},
/* 171 */  {"is_int_in_range_fScc", {0,0,0}, "fScc"},
/* 172 */  {"is_integer_fs", {0,0,0}, "fs"},
/* 173 */  {"is_list_fs", {0,0,0}, "fs"},
/* 174 */  {"is_lt_fss", {0,0,0}, "fss"},
/* 175 */  {"is_map_fs", {0,0,0}, "fs"},
/* 176 */  {"is_ne_fss", {0,0,0}, "fss"},
/* 177 */  {"is_ne_exact_fss", {0,0,0}, "fss"},
/* 178 */  {"is_nil_fS", {0,0,0}, "fS"},
/* 179 */  {"is_nonempty_list_fS", {0,0,0}, "fS"},
/* 180 */  {"is_nonempty_list_get_hd_fSd", {0,0,0}, "fSd"},
/* 181 */  {"is_nonempty_list_get_list_fSdd", {0,0,0}, "fSdd"},
/* 182 */  {"is_nonempty_list_get_tl_fSd", {0,0,0}, "fSd"},
/* 183 */  {"is_number_fs", {0,0,0}, "fs"},
/* 184 */  {"is_pid_fs", {0,0,0}, "fs"},
/* 185 */  {"is_port_fs", {0,0,0}, "fs"},
/* 186 */  {"is_reference_fs", {0,0,0}, "fs"},
/* 187 */  {"jump_f", {0,0,0}, "f"},
/* 188 */  {"label_L", {0,0,0}, "L"},
/* 189 */  {"line_I", {0,0,0}, "I"},
/* 190 */  {"load_tuple_ptr_s", {0,0,0}, "s"},
/* 191 */  {"loop_rec_end_f", {0,0,0}, "f"},
/* 192 */  {"move_two_words_sdsd", {0,0,0}, "sdsd"},
/* 193 */  {"new_map_dtI", {0,0,0}, "dtI"},
/* 194 */  {"nif_start", {0,0,0}, ""},
/* 195 */  {"node_d", {0,0,0}, "d"},
/* 196 */  {"nofail_bif1_sbd", {0,0,0}, "sbd"},
/* 197 */  {"nofail_bif2_ssbd", {0,0,0}, "ssbd"},
/* 198 */  {"normal_exit", {0,0,0}, ""},
/* 199 */  {"on_load", {0,0,0}, ""},
/* 200 */  {"put_cons_ss", {0,0,0}, "ss"},
/* 201 */  {"put_tuple2_SA", {0,0,0}, "SA"},
/* 202 */  {"raise_ss", {0,0,0}, "ss"},
/* 203 */  {"raw_raise", {0,0,0}, ""},
/* 204 */  {"recv_marker_bind_SS", {0,0,0}, "SS"},
/* 205 */  {"recv_marker_clear_S", {0,0,0}, "S"},
/* 206 */  {"recv_marker_reserve_S", {0,0,0}, "S"},
/* 207 */  {"recv_marker_use_S", {0,0,0}, "S"},
/* 208 */  {"remove_message", {0,0,0}, ""},
/* 209 */  {"return", {0,0,0}, ""},
/* 210 */  {"return_trace", {0,0,0}, ""},
/* 211 */  {"self_d", {0,0,0}, "d"},
/* 212 */  {"send", {0,0,0}, ""},
/* 213 */  {"set_tuple_element_sSP", {0,0,0}, "sSP"},
/* 214 */  {"store_cons_Id", {0,0,0}, "Id"},
/* 215 */  {"swap_dd", {0,0,0}, "dd"},
/* 216 */  {"system_limit_body", {0,0,0}, ""},
/* 217 */  {"test_heap_It", {0,0,0}, "It"},
/* 218 */  {"timeout", {0,0,0}, ""},
/* 219 */  {"timeout_locked", {0,0,0}, ""},
/* 220 */  {"trace_jump_W", {0,0,0}, "W"},
/* 221 */  {"try_case_y", {0,0,0}, "y"},
/* 222 */  {"try_case_end_s", {0,0,0}, "s"},
/* 223 */  {"try_end_y", {0,0,0}, "y"},
/* 224 */  {"try_end_deallocate_t", {0,0,0}, "t"},
/* 225 */  {"update_map_assoc_sdtI", {0,0,0}, "sdtI"},
/* 226 */  {"update_map_exact_sjdtI", {0,0,0}, "sjdtI"},
/* 227 */  {"update_record_aIsdI", {0,0,0}, "aIsdI"},
/* 228 */  {"update_record_in_place_IsdI", {0,0,0}, "IsdI"},
/* 229 */  {"wait_locked_f", {0,0,0}, "f"},
/* 230 */  {"wait_timeout_locked_sf", {0,0,0}, "sf"},
/* 231 */  {"wait_timeout_unlocked_sf", {0,0,0}, "sf"},
/* 232 */  {"wait_unlocked_f", {0,0,0}, "f"},
};

const int num_instructions = 233;

#ifdef ERTS_OPCODE_COUNTER_SUPPORT
Uint erts_instr_count[233];
#endif

static int consecutive_words(LoaderState* S, BeamOpArg S1, BeamOpArg D1, BeamOpArg S2, BeamOpArg D2) {
  return S1.type == S2.type && S1.val + 1 == S2.val &&
  D1.type == D2.type && D1.val + 1 == D2.val;;
}

static int distinct(LoaderState* S, BeamOpArg Val1, BeamOpArg Val2) {
  if (Val1.type != Val2.type) {
    return 1;
  } else if (Val1.type == TAG_x || Val1.type == TAG_y) {
    /* We must not compare the type indices (if any). */
    return (Val1.val & REG_MASK) != (Val2.val & REG_MASK);
  } else if (Val1.type == TAG_n) {
    /* NIL has no associated value. */
    return 0;
  } else {
    return Val1.val != Val2.val;
  };
}

static int equal(LoaderState* S, BeamOpArg Val1, BeamOpArg Val2) {
  if (Val1.type != Val2.type) {
    return 0;
  } else if (Val1.type == TAG_x || Val1.type == TAG_y) {
    /* We must not compare the type indices (if any). */
    return (Val1.val & REG_MASK) == (Val2.val & REG_MASK);
  } else if (Val1.type == TAG_n) {
    /* NIL has no associated value. */
    return 1;
  } else {
    return Val1.val == Val2.val;
  };
}

static int fixed_size_values(LoaderState* S, BeamOpArg Size, BeamOpArg* Rest) {
  int i;

  if (Size.val < 2 || Size.val % 2 != 0) {
    return 0;
  }

  for (i = 0; i < Size.val; i += 2) {
    if (Rest[i+1].type != TAG_f) {
      return 0;
    }
    switch (Rest[i].type) {
      case TAG_a:
      case TAG_i:
      case TAG_v:
      break;
      case TAG_q:
      return is_float(beamfile_get_literal(&S->beam, Rest[i].val));
      default:
      return 0;
    }
  }

  return 1;;
}

static int floats_or_bignums(LoaderState* S, BeamOpArg Size, BeamOpArg* Rest) {
  int i;

  if (Size.val < 2 || Size.val % 2 != 0) {
    return 0;
  }

  for (i = 0; i < Size.val; i += 2) {
    if (Rest[i].type != TAG_q) {
      return 0;
    }
    if (Rest[i+1].type != TAG_f) {
      return 0;
    }
  }

  return 1;;
}

static int instrumenting_line_breakpoints(LoaderState* S) {
  return ERTS_DEBUGGER_IS_ENABLED_IN(S->load_hdr->debugger_flags,
  ERTS_DEBUGGER_LINE_BREAKPOINTS);;
}

static int is_empty_map(LoaderState* S, BeamOpArg Lit) {
  Eterm term;

  if (Lit.type != TAG_q) {
    return 0;
  }

  term = beamfile_get_literal(&S->beam, Lit.val);
  return is_flatmap(term) && flatmap_get_size(flatmap_val(term)) == 0;;
}

static int is_eq_exact_bif(LoaderState* S, BeamOpArg Bif) {
  Uint index = Bif.val;

  if (Bif.type == TAG_u && index < S->beam.imports.count) {
    BeamFile_ImportEntry *entry = &S->beam.imports.entries[index];

    return entry->module == am_erlang && entry->function == am_Eq && entry->arity == 2;
  }
  return 0;;
}

static int is_exit_bif(LoaderState* S, BeamOpArg Bif) {
  BeamFile_ImportEntry *import;

  if (Bif.type != TAG_u || Bif.val >= S->beam.imports.count) {
    return 0;
  }

  import = &S->beam.imports.entries[Bif.val];
  if (import->module != am_erlang) {
    return 0;
  } else {
    switch (import->function) {
      case am_error:
      return 1 <= import->arity && import->arity <= 3;
      case am_exit:
      return import->arity == 1;
      case am_throw:
      return import->arity == 1;
      case am_nif_error:
      return import->arity == 1 || import->arity == 2;
      default:
      return 0;
    }
  };
}

static int is_ge_bif(LoaderState* S, BeamOpArg Bif) {
  Uint index = Bif.val;

  if (Bif.type == TAG_u && index < S->beam.imports.count) {
    BeamFile_ImportEntry *entry = &S->beam.imports.entries[index];

    return entry->module == am_erlang && entry->function == am_Ge && entry->arity == 2;
  }
  return 0;;
}

static int is_heavy_bif(LoaderState* S, BeamOpArg Bif) {
  BeamFile_ImportEntry *import;
  const Export *export;

  if (Bif.type != TAG_u || Bif.val >= S->beam.imports.count) {
    return 0;
  }

  import = &S->beam.imports.entries[Bif.val];
  export = erts_active_export_entry(import->module,
  import->function,
  import->arity);

  if (export->bif_number != -1) {
    return bif_table[export->bif_number].kind == BIF_KIND_HEAVY;
  }

  return 0;;
}

static int is_lt_bif(LoaderState* S, BeamOpArg Bif) {
  Uint index = Bif.val;

  if (Bif.type == TAG_u && index < S->beam.imports.count) {
    BeamFile_ImportEntry *entry = &S->beam.imports.entries[index];

    return entry->module == am_erlang && entry->function == am_Lt && entry->arity == 2;
  }
  return 0;;
}

static int is_mfa_bif(LoaderState* S, BeamOpArg M, BeamOpArg F, BeamOpArg A) {
  const Export *e;

  ASSERT(M.type == TAG_a && F.type == TAG_a && A.type == TAG_u);
  e = erts_active_export_entry(M.val, F.val, A.val);

  if (e != NULL) {
    return e->bif_number != -1;
  }

  return 0;;
}

static int is_ne_exact_bif(LoaderState* S, BeamOpArg Bif) {
  Uint index = Bif.val;

  if (Bif.type == TAG_u && index < S->beam.imports.count) {
    BeamFile_ImportEntry *entry = &S->beam.imports.entries[index];

    return entry->module == am_erlang && entry->function == am_Neq && entry->arity == 2;
  }
  return 0;;
}

static int is_small_map_literal_keys(LoaderState* S, BeamOpArg Size, BeamOpArg* Rest) {
  Uint pair_count = Size.val / 2;

  if (pair_count > MAP_SMALL_MAP_LIMIT) {
    return 0;
  }

  /*
  * Operations with non-literals have always only one key.
  */
  if (pair_count != 1) {
    return 1;
  }

  switch (Rest[0].type) {
    case TAG_a:
    case TAG_i:
    case TAG_n:
    case TAG_q:
    return 1;
    default:
    return 0;
  };
}

static int map_key_sort(LoaderState* S, BeamOpArg Size, BeamOpArg* Rest) {
  return beam_load_map_key_sort(S, Size, Rest);;
}

static int mixed_types(LoaderState* S, BeamOpArg Size, BeamOpArg* Rest) {
  int i;
  Uint type;

  if (Size.val < 2 || Size.val % 2 != 0) {
    return 0;
  }

  type = Rest[0].type;
  for (i = 0; i < Size.val; i += 2) {
    if (Rest[i].type != type) {
      return 1;
    }
  }

  return 0;;
}

static int never(LoaderState* S) {
  return 0;;
}

static int never_fails(LoaderState* S, BeamOpArg Bif) {
  static Eterm nofail_bifs[] =
  {am_Neqeq,
    am_Lt,
    am_Neq,
    am_Eq,
    am_Le,
    am_Eqeq,
    am_Gt,
    am_Ge,
    am_is_atom,
    am_is_boolean,
    am_is_binary,
    am_is_bitstring,
    am_is_float,
    am_is_integer,
    am_is_list,
    am_is_map,
    am_is_number,
    am_is_pid,
    am_is_port,
    am_is_reference,
    am_is_tuple,
  };

  Uint index = Bif.val;

  if (Bif.type == TAG_u && index < S->beam.imports.count) {
    BeamFile_ImportEntry *entry = &S->beam.imports.entries[index];
    int i;

    if (entry->module != am_erlang) {
      return 0;
    }

    if (entry->function == am_is_function) {
      /* Note that is_function/2 may fail. */
      return entry->arity == 1;
    }

    for (i = 0; i < sizeof(nofail_bifs) / sizeof(nofail_bifs[0]); i++) {
      if (entry->function == nofail_bifs[i]) {
        return 1;
      }
    }
  }
  return 0;;
}

static int smp_already_locked(LoaderState* S, BeamOpArg L) {
  ASSERT(L.type == TAG_u);
  return S->labels[L.val].looprec_targeted;;
}

static int smp_mark_target_label(LoaderState* S, BeamOpArg L) {
  ASSERT(L.type == TAG_f);
  S->labels[L.val].looprec_targeted = 1;
  return 1;;
}

static int use_jump_tab(LoaderState* S, BeamOpArg Size, BeamOpArg* Rest, Uint MinSize) {
  Sint min, max;
  Sint i;

  if (Size.val < 2 * MinSize || Size.val % 2 != 0) {
    return 0;
  }

  if (Rest[0].type != TAG_i || Rest[1].type != TAG_f) {
    /* Atoms. Can't use a jump table. */
    return 0;
  }

  min = max = Rest[0].val;
  for (i = 2; i < Size.val; i += 2) {
    if (Rest[i].type != TAG_i || Rest[i+1].type != TAG_f) {
      return 0;
    }
    if (Rest[i].val < min) {
      min = Rest[i].val;
    } else if (max < Rest[i].val) {
      max = Rest[i].val;
    }
  }

  return max - min <= Size.val;;
}

static BeamOp* bs_match(LoaderState* S, BeamOpArg Fail, BeamOpArg Ctx, BeamOpArg N, BeamOpArg* List) {
  BeamOp* op;
  int fixed_args;
  int i;

  /*
  * If a BEAM file produced by a later version of Erlang/OTP
  * is accidentally loaded into an earlier version, ensure
  * that the loading fails (as opposed to crashing the runtime)
  * if there are any unknown sub commands.
  */
  i = 0;
  while (i < N.val) {
    BeamOpArg current = List[i++];

    if (current.type != TAG_a) {
      goto error;
    }

    switch (current.val) {
      case am_ensure_exactly:
      case am_skip:
      i += 1;
      break;
      case am_ensure_at_least:
      i += 2;
      break;
      case am_get_tail:
      case am_Eq:
      i += 3;
      break;
      case am_binary:
      case am_integer:
      i += 5;
      break;
      default: {
        error:
        op = beamopallocator_new_op(&(S)->op_allocator);
        op->next = NULL;;
        do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
          op->op = __make_opname__(bad_bs_match, 1);
          op->arity = 1;
#undef __make_opname__
        } while (0);
        op->a[0] = current;
        return op;
      }
    }
  }

  /*
  * Make sure that we don't attempt to pass any overflow tags to the JIT.
  */

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_bs_match, 2);
    op->arity = 2;
#undef __make_opname__
  } while (0);
  fixed_args = op->arity;
  ASSERT(op->a == op->def_args);

  op->arity = (N.val + fixed_args);
  op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;

  op->a[0] = Fail;
  op->a[1] = Ctx;

  for (i = 0; i < N.val; i++) {
    BeamOpArg current;

    current = List[i];
    if (current.type == TAG_o) {
      /* An overflow tag (in ensure_at_least or ensure_exactly)
      * means that the match will always fail. */
      do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
        op->op = __make_opname__(jump, 1);
        op->arity = 1;
#undef __make_opname__
      } while (0);
      op->a[0] = Fail;
      return op;
    }
    op->a[i+fixed_args] = current;
  }

  return op;;
}

static BeamOp* combine_conses(LoaderState* S, BeamOpArg Len, BeamOpArg Dst, BeamOpArg Hd) {
  BeamOp* cons;
  BeamOp* tail;

  cons = beamopallocator_new_op(&(S)->op_allocator);
  cons->next = NULL;;
  tail = beamopallocator_new_op(&(S)->op_allocator);
  tail->next = NULL;;

  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    cons->op = __make_opname__(append_cons, 2);
    cons->arity = 2;
#undef __make_opname__
  } while (0);
  cons->a[0] = Len;
  cons->a[1] = Hd;
  cons->next = tail;

  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    tail->op = __make_opname__(store_cons, 2);
    tail->arity = 2;
#undef __make_opname__
  } while (0);
  tail->a[0].type = TAG_u;
  tail->a[0].val = Len.val + 1;
  tail->a[1] = Dst;

  return cons;;
}

static BeamOp* create_bin(LoaderState* S, BeamOpArg Fail, BeamOpArg Alloc, BeamOpArg Live, BeamOpArg Unit, BeamOpArg Dst, BeamOpArg N, BeamOpArg* Segments) {
  BeamOp* op;
  int fixed_args;
  int i;

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_bs_create_bin, 4);
    op->arity = 4;
#undef __make_opname__
  } while (0);
  fixed_args = op->arity;
  ASSERT(op->a == op->def_args);

  op->arity = (N.val + fixed_args);
  op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;

  op->a[0] = Fail;
  op->a[1] = Alloc;
  op->a[2] = Live;
  op->a[3] = Dst;

  for (i = 0; i < N.val; i += 6) {
    BeamOpArg Flags;
    Uint flags = 0;

    /* Copy all but flags. */
    op->a[i+fixed_args+0] = Segments[i+0];
    op->a[i+fixed_args+1] = Segments[i+1];
    op->a[i+fixed_args+2] = Segments[i+2];
    op->a[i+fixed_args+4] = Segments[i+4];
    op->a[i+fixed_args+5] = Segments[i+5];

    /* Translate flags. */
    Flags = Segments[i+3];              /* Flags */
    if (Flags.type != TAG_n) {
      if (Flags.type == TAG_q) {
        Eterm term = beamfile_get_literal(&S->beam, Flags.val);
        while (is_list(term)) {
          Eterm* consp = list_val(term);
          Eterm elem = CAR(consp);
          switch (elem) {
            case am_little:
            flags |= BSF_LITTLE;
            break;
            case am_native:
            flags |= BSF_NATIVE;
            break;
          }
          term = CDR(consp);
        }
        ASSERT(is_nil(term));
      }
    }
    Flags.type = TAG_u;
    Flags.val = flags;
    do {
#if defined(WORDS_BIGENDIAN)
      if ((Flags).val & BSF_NATIVE) {
        (Flags).val &= ~(BSF_LITTLE|BSF_NATIVE);
      }
#else
      if ((Flags).val & BSF_NATIVE) {
        (Flags).val &= ~BSF_NATIVE;
        (Flags).val |= BSF_LITTLE;
      }
#endif
    } while (0);
    op->a[i+fixed_args+3] = Flags;

    /*
    * Replace short string segments with integer segments.
    * Integer segments can be combined with adjacent integer
    * segments for better performance.
    */
    if (op->a[i+fixed_args+0].val == am_string) {
      Sint num_chars = op->a[i+fixed_args+5].val;
      if (num_chars <= 4) {
        Sint index = op->a[i+fixed_args+4].val;
        const byte* s = S->beam.strings.data + index;
        Uint num = 0;
        op->a[i+fixed_args+0].val = am_integer;
        op->a[i+fixed_args+2].val = 8;
        op->a[i+fixed_args+5].val = num_chars;
        while (num_chars-- > 0) {
          num = num << 8 | *s++;
        }
        op->a[i+fixed_args+4].type = TAG_i;
        op->a[i+fixed_args+4].val = num;
      }
    }
  }

  if (op->a[4].val == am_private_append && Alloc.val != 0) {
    BeamOp* th;
    th = beamopallocator_new_op(&(S)->op_allocator);
    th->next = NULL;;
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      th->op = __make_opname__(test_heap, 2);
      th->arity = 2;
#undef __make_opname__
    } while (0);
    th->a[0] = Alloc;
    th->a[1] = Live;
    th->next = op;

    op->a[1].val = 0;

    op = th;
  }

  return op;;
}

static BeamOp* func_end(LoaderState* S, BeamOpArg Func_Label, BeamOpArg Entry_Label) {
  BeamOp *op = NULL;

  if (S->labels[Entry_Label.val].lambda_index != -1) {
    int index = S->labels[Entry_Label.val].lambda_index;
    BeamFile_LambdaEntry *lambda_entry;

    lambda_entry = &S->beam.lambdas.entries[index];

    if (lambda_entry->num_free > 0) {
      BeamOp *lambda;

      lambda = beamopallocator_new_op(&(S)->op_allocator);
      lambda->next = NULL;;
      do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
        lambda->op = __make_opname__(i_lambda_trampoline, 4);
        lambda->arity = 4;
#undef __make_opname__
      } while (0);

      lambda->a[0].type = TAG_u;
      lambda->a[0].val = index;
      lambda->a[1] = Entry_Label;
      lambda->a[2].type = TAG_u;
      lambda->a[2].val = lambda_entry->arity;
      lambda->a[3].type = TAG_u;
      lambda->a[3].val = lambda_entry->num_free;

      lambda->next = op;
      op = lambda;
    }
  }

  if (S->may_load_nif && (S->load_hdr->are_nifs == NULL ||
  S->load_hdr->are_nifs[S->function_number-1])) {
    BeamOp *padding;

    padding = beamopallocator_new_op(&(S)->op_allocator);
    padding->next = NULL;;
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      padding->op = __make_opname__(i_nif_padding, 0);
      padding->arity = 0;
#undef __make_opname__
    } while (0);

    padding->next = op;
    op = padding;
  }

  if (op == NULL) {
    /* Workaround for the fact that we have to return an instruction from
    * generators. The loader will remove this dummy instruction. */
    op = beamopallocator_new_op(&(S)->op_allocator);
    op->next = NULL;;
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(delete_me, 0);
      op->arity = 0;
#undef __make_opname__
    } while (0);

    op->next = NULL;
  }

  return op;;
}

static BeamOp* get(LoaderState* S, BeamOpArg Src, BeamOpArg Dst) {
  BeamOp* op;
  Eterm key_term;

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  key_term = beam_load_get_term(S, Src);
  if (is_value(key_term)) {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_get_hash, 3);
      op->arity = 3;
#undef __make_opname__
    } while (0);
    op->a[0] = Src;
    op->a[1].type = TAG_u;
    op->a[1].val = (BeamInstr) erts_pd_make_hx(key_term);
    op->a[2] = Dst;
  } else {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_get, 2);
      op->arity = 2;
#undef __make_opname__
    } while (0);
    op->a[0] = Src;
    op->a[1] = Dst;
  }
  return op;;
}

static BeamOp* get_float2(LoaderState* S, BeamOpArg Fail, BeamOpArg Ms, BeamOpArg Live, BeamOpArg Size, BeamOpArg Unit, BeamOpArg Flags, BeamOpArg Dst) {
  BeamOp* op;
  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;

  do {
#if defined(WORDS_BIGENDIAN)
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~(BSF_LITTLE|BSF_NATIVE);
    }
#else
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~BSF_NATIVE;
      (Flags).val |= BSF_LITTLE;
    }
#endif
  } while (0);
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_bs_get_float2, 6);
    op->arity = 6;
#undef __make_opname__
  } while (0);
  op->a[0] = Ms;
  op->a[1] = Fail;
  op->a[2] = Live;
  op->a[3] = Size;
  op->a[4].type = TAG_u;
  op->a[4].val = (Unit.val << 3) | Flags.val;
  op->a[5] = Dst;
  return op;;
}

static BeamOp* get_map_element(LoaderState* S, BeamOpArg Fail, BeamOpArg Src, BeamOpArg Size, BeamOpArg* Rest) {
  BeamOp* op;
  BeamOpArg Key;
  Eterm key_term;

  ASSERT(Size.type == TAG_u);

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  op->a[0] = Fail;
  op->a[1] = Src;
  op->a[2] = Rest[0];

  Key = Rest[0];
  key_term = beam_load_get_term(S, Key);
  if (is_value(key_term)) {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_get_map_element_hash, 5);
      op->arity = 5;
#undef __make_opname__
    } while (0);
    op->a[3].type = TAG_u;
    op->a[3].val = (BeamInstr) hashmap_make_hash(key_term);
    op->a[4] = Rest[1];
  } else {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_get_map_element, 4);
      op->arity = 4;
#undef __make_opname__
    } while (0);
    op->a[3] = Rest[1];
  }
  return op;;
}

static BeamOp* get_map_elements(LoaderState* S, BeamOpArg Fail, BeamOpArg Src, BeamOpArg Size, BeamOpArg* Rest) {
  BeamOp* op;
  Uint i;
  BeamOpArg* dst;
  Eterm key_term;

  ASSERT(Size.type == TAG_u);

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_get_map_elements, 3);
    op->arity = 3;
#undef __make_opname__
  } while (0);
  ASSERT(op->a == op->def_args);

  op->arity = 3 + 3*(Size.val/2);
  op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;
  op->a[0] = Fail;
  op->a[1] = Src;
  op->a[2].type = TAG_u;
  op->a[2].val = 3*(Size.val/2);

  dst = op->a+3;
  for (i = 0; i < Size.val / 2; i++) {
    dst[0] = Rest[2*i];
    dst[1] = Rest[2*i+1];
    dst[2].type = TAG_u;
    key_term = beam_load_get_term(S, dst[0]);
    dst[2].val = (BeamInstr) hashmap_make_hash(key_term);
    dst += 3;
  }
  return op;;
}

static BeamOp* get_utf16(LoaderState* S, BeamOpArg Fail, BeamOpArg Ms, BeamOpArg Flags, BeamOpArg Dst) {
  BeamOp* op;
  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;

  do {
#if defined(WORDS_BIGENDIAN)
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~(BSF_LITTLE|BSF_NATIVE);
    }
#else
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~BSF_NATIVE;
      (Flags).val |= BSF_LITTLE;
    }
#endif
  } while (0);
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_bs_get_utf16, 4);
    op->arity = 4;
#undef __make_opname__
  } while (0);
  op->a[0] = Ms;
  op->a[1] = Fail;
  op->a[2] = Flags;
  op->a[3] = Dst;
  return op;;
}

static BeamOp* has_map_fields(LoaderState* S, BeamOpArg Fail, BeamOpArg Src, BeamOpArg Size, BeamOpArg* Rest) {
  BeamOp* op;
  Uint i;
  Uint n;

  ASSERT(Size.type == TAG_u);
  n = Size.val;

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(get_map_elements, 3);
    op->arity = 3;
#undef __make_opname__
  } while (0);
  ASSERT(op->a == op->def_args);

  op->arity = 3 + 2*n;
  op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;

  op->a[0] = Fail;
  op->a[1] = Src;
  op->a[2].type = TAG_u;
  op->a[2].val = 2*n;

  for (i = 0; i < n; i++) {
    op->a[3+2*i] = Rest[i];
    op->a[3+2*i+1].type = TAG_x;
    op->a[3+2*i+1].val = SCRATCH_X_REG; /* Ignore result */
  }
  return op;;
}

static BeamOp* jump_tab(LoaderState* S, BeamOpArg Src, BeamOpArg Fail, BeamOpArg Size, BeamOpArg* Rest) {
  Sint min, max;
  Sint i;
  Sint size;
  Sint arity;
  int fixed_args;
  BeamOp* op;

  ASSERT(Size.val >= 2 && Size.val % 2 == 0);

  /* Don't generate a jump table if there's only one choice */
  if (Size.val == 2) {
    BeamOp* jump;

    op = beamopallocator_new_op(&(S)->op_allocator);
    op->next = NULL;;
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(is_ne_exact, 3);
      op->arity = 3;
#undef __make_opname__
    } while (0);
    op->a[0] = Rest[1];
    op->a[1] = Src;
    op->a[2] = Rest[0];

    jump = beamopallocator_new_op(&(S)->op_allocator);
    jump->next = NULL;;
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      jump->op = __make_opname__(jump, 1);
      jump->arity = 1;
#undef __make_opname__
    } while (0);
    jump->a[0] = Fail;

    op->next = jump;
    jump->next = NULL;
    return op;
  }

  /* Calculate the minimum and maximum values and size of jump table. */
  ASSERT(Rest[0].type == TAG_i);
  min = max = Rest[0].val;
  for (i = 2; i < Size.val; i += 2) {
    ASSERT(Rest[i].type == TAG_i && Rest[i+1].type == TAG_f);
    if (Rest[i].val < min) {
      min = Rest[i].val;
    } else if (max < Rest[i].val) {
      max = Rest[i].val;
    }
  }
  size = max - min + 1;

  /* Allocate structure and fill in the fixed fields. */
  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  op->next = NULL;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_jump_on_val, 4);
    op->arity = 4;
#undef __make_opname__
  } while (0);
  fixed_args = op->arity;
  arity = fixed_args + size;
  ASSERT(op->a == op->def_args);

  op->arity = arity;
  op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;
  op->a[0] = Src;
  op->a[1] = Fail;
  op->a[2].type = TAG_u;
  op->a[2].val = min;
  op->a[3].type = TAG_u;
  op->a[3].val = size;

  /* Fill in the jump table. */
  for (i = fixed_args; i < arity; i++) {
    op->a[i] = Fail;
  }

  for (i = 0; i < Size.val; i += 2) {
    Sint index = fixed_args + Rest[i].val - min;
    ASSERT(fixed_args <= index && index < arity);
    op->a[index] = Rest[i+1];
  }

  return op;;
}

static BeamOp* make_fun3(LoaderState* S, BeamOpArg Idx, BeamOpArg Dst, BeamOpArg NumFree, BeamOpArg* Env) {
  BeamOp* op;

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;

  if (Idx.val < S->beam.lambdas.count) {
    BeamFile_LambdaEntry *entry = &S->beam.lambdas.entries[Idx.val];

    if (NumFree.val == entry->num_free) {
      if (entry->num_free == 0) {
        do {
          SWord literal;

          /* If we haven't already done so, we need to create a placeholder for the
          * lambda. */
          literal = S->lambda_literals[Idx.val];
          if (literal == ERTS_SWORD_MAX) {
            Eterm tmp_hp[ERL_FUN_SIZE];
            ErlFunThing *funp;

            funp = (ErlFunThing*)tmp_hp;
            funp->thing_word = MAKE_FUN_HEADER(entry->arity, 0, 0);
            funp->entry.exp = NULL;

            literal = beamfile_add_literal(&S->beam, make_fun((Eterm*)funp), 0);
            S->lambda_literals[Idx.val] = literal;
          }

          do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
            op->op = __make_opname__(move, 2);
            op->arity = 2;
#undef __make_opname__
          } while (0);
          (op)->a[0].type = TAG_q;
          (op)->a[0].val = literal;
          (op)->a[1] = Dst;
        } while (0);
      } else {
        do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
          op->op = __make_opname__(i_make_fun3, 4);
          op->arity = 4;
#undef __make_opname__
        } while (0);
        ASSERT(op->a == op->def_args);

        op->arity = 4 + entry->num_free;
        op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;

        (op)->a[0].type = TAG_u;
        (op)->a[0].val = Idx.val;
        (op)->a[1] = Dst;
        (op)->a[2].type = TAG_u;
        (op)->a[2].val = entry->arity - entry->num_free;
        (op)->a[3].type = TAG_u;
        (op)->a[3].val = entry->num_free;

        for (int i = 0; i < entry->num_free; i++) {
          (op)->a[4 + i] = Env[i];
        };
      }

      return op;
    }
  }

  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_lambda_error, 1);
    op->arity = 1;
#undef __make_opname__
  } while (0);
  op->a[0].type = TAG_o;
  op->a[0].val = 0;
  return op;;
}

static BeamOp* new_small_map_lit(LoaderState* S, BeamOpArg Dst, BeamOpArg Live, BeamOpArg Size, BeamOpArg* Rest) {
  unsigned size = Size.val;
  Uint lit;
  unsigned i;
  BeamOp* op;
  BeamOpArg* dst;
  Eterm* tmp;
  Eterm* thp;
  Eterm keys;

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_new_small_map_lit, 4);
    op->arity = 4;
#undef __make_opname__
  } while (0);
  ASSERT(op->a == op->def_args);

  op->arity = 4 + size/2;
  op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;
  op->next = NULL;

  tmp = thp = erts_alloc(ERTS_ALC_T_LOADER_TMP, ((size == 0 ? 0 : 1) + size/2) * sizeof(*tmp));
  if (size == 0) {
    keys = ERTS_GLOBAL_LIT_EMPTY_TUPLE;
  } else {
    keys = make_tuple(thp);
    *thp++ = make_arityval(size/2);
  }

  dst = op->a+4;

  for (i = 0; i < size; i += 2) {
    switch (Rest[i].type) {
      case TAG_a:
      *thp++ = Rest[i].val;
      ASSERT(is_atom(Rest[i].val));
      break;
      case TAG_i:
      *thp++ = make_small(Rest[i].val);
      break;
      case TAG_n:
      *thp++ = NIL;
      break;
      case TAG_q:
      *thp++ = beamfile_get_literal(&S->beam, Rest[i].val);
      break;
    }
    *dst++ = Rest[i + 1];
  }

  lit = beamfile_add_literal(&S->beam, keys, 1);
  erts_free(ERTS_ALC_T_LOADER_TMP, tmp);

  op->a[0] = Dst;
  op->a[1] = Live;
  op->a[2].type = TAG_q;
  op->a[2].val = lit;
  op->a[3].type = TAG_u;
  op->a[3].val = size / 2;

  return op;;
}

static BeamOp* select_literals(LoaderState* S, BeamOpArg Src, BeamOpArg Fail, BeamOpArg Size, BeamOpArg* Rest) {
  BeamOp* op;
  BeamOp* jump;
  BeamOp** prev_next = &op;

  int i;

  for (i = 0; i < Size.val; i += 2) {
    BeamOp* op;
    ASSERT(Rest[i].type == TAG_q);

    op = beamopallocator_new_op(&(S)->op_allocator);
    op->next = NULL;;
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(is_ne_exact, 3);
      op->arity = 3;
#undef __make_opname__
    } while (0);
    op->a[0] = Rest[i+1];
    op->a[1] = Src;
    op->a[2] = Rest[i];
    *prev_next = op;
    prev_next = &op->next;
  }

  jump = beamopallocator_new_op(&(S)->op_allocator);
  jump->next = NULL;;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    jump->op = __make_opname__(jump, 1);
    jump->arity = 1;
#undef __make_opname__
  } while (0);
  jump->next = NULL;
  jump->a[0] = Fail;
  *prev_next = jump;
  return op;;
}

static BeamOp* select_tuple_arity(LoaderState* S, BeamOpArg Src, BeamOpArg Fail, BeamOpArg Size, BeamOpArg* Rest) {
  BeamOp* op;
  BeamOpArg *tmp;
  int size = Size.val / 2;
  int arity = Size.val + 3;
  int i, j;

  /* Verify the validity of the list. */
  if (Size.val % 2 != 0) {
    return NULL;
  }

  for (i = 0; i < Size.val; i += 2) {
    if (Rest[i].type != TAG_u || Rest[i+1].type != TAG_f) {
      return NULL;
    }
  }

  /*
  * Generate the generic instruction.
  * Assumption:
  *   Few different tuple arities to select on (fewer than 20).
  *   Use linear scan approach.
  */
  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_select_tuple_arity, 3);
    op->arity = 3;
#undef __make_opname__
  } while (0);
  ASSERT(op->a == op->def_args);

  op->arity = arity;
  op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;
  op->next = NULL;
  op->a[0] = Src;
  op->a[1] = Fail;

  /* Variable argument count */
  op->a[2].type = TAG_u;
  op->a[2].val = Size.val;

  tmp = (BeamOpArg*)erts_alloc(ERTS_ALC_T_LOADER_TMP,
  sizeof(BeamOpArg) * arity);

  for (i = 3; i < arity; i += 2) {
    tmp[i - 2]      = Rest[i - 2];
    tmp[i - 3].type = TAG_v;
    tmp[i - 3].val  = make_arityval_unchecked(Rest[i - 3].val);
  }

  /* Sort the values to make them useful for a binary or sentinel search. */
  beam_load_sort_select_vals(tmp, size);

  j = 3;
  for (i = 3; i < arity; i += 2) {
    op->a[j + size] = tmp[i - 2];
    op->a[j]        = tmp[i - 3];
    j++;
  }

  erts_free(ERTS_ALC_T_LOADER_TMP, (void *) tmp);

  return op;;
}

static BeamOp* select_val(LoaderState* S, BeamOpArg Src, BeamOpArg Fail, BeamOpArg Size, BeamOpArg* Rest) {
  BeamOp* op;
  BeamOpArg *tmp;
  int arity = Size.val + 3;
  int size = Size.val / 2;
  int i, j;

  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;
  op->next = NULL;

  /* Use linear search for small search spaces */
  if (size <= 10) {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_select_val_lins, 3);
      op->arity = 3;
#undef __make_opname__
    } while (0);
  } else {
    do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
      op->op = __make_opname__(i_select_val_bins, 3);
      op->arity = 3;
#undef __make_opname__
    } while (0);
  }

  ASSERT(op->a == op->def_args);

  op->arity = arity;
  op->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op->arity * sizeof(BeamOpArg));;
  op->a[0] = Src;
  op->a[1] = Fail;

  /* Variable argument count */
  op->a[2].type = TAG_u;
  op->a[2].val = Size.val;

  tmp = (BeamOpArg *) erts_alloc(ERTS_ALC_T_LOADER_TMP, sizeof(BeamOpArg)*(arity));

  for (i = 3; i < arity; i++) {
    tmp[i-3] = Rest[i-3];
  }

  /* Sort the values to make them useful for a binary or sentinel search. */
  beam_load_sort_select_vals(tmp, size);

  j = 3;
  for (i = 3; i < arity; i += 2) {
    op->a[j]      = tmp[i-3];
    op->a[j+size] = tmp[i-2];
    j++;
  }

  erts_free(ERTS_ALC_T_LOADER_TMP, (void *) tmp);

#ifdef DEBUG
  for (i = 0; i < size - 1; i++) {
    ASSERT(op->a[i+3].val <= op->a[i+4].val);
  }
#endif

  return op;;
}

static BeamOp* skip_utf16(LoaderState* S, BeamOpArg Fail, BeamOpArg Ms, BeamOpArg Flags) {
  BeamOp* op;
  op = beamopallocator_new_op(&(S)->op_allocator);
  op->next = NULL;;

  do {
#if defined(WORDS_BIGENDIAN)
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~(BSF_LITTLE|BSF_NATIVE);
    }
#else
    if ((Flags).val & BSF_NATIVE) {
      (Flags).val &= ~BSF_NATIVE;
      (Flags).val |= BSF_LITTLE;
    }
#endif
  } while (0);
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op->op = __make_opname__(i_bs_skip_utf16, 3);
    op->arity = 3;
#undef __make_opname__
  } while (0);
  op->a[0] = Ms;
  op->a[1] = Fail;
  op->a[2] = Flags;
  return op;;
}

static BeamOp* split_values(LoaderState* S, BeamOpArg Src, BeamOpArg TypeFail, BeamOpArg Fail, BeamOpArg Size, BeamOpArg* Rest) {
  BeamOp* op1;
  BeamOp* op2;
  BeamOp* is_integer;
  int i;

  ASSERT(Size.val >= 2 && Size.val % 2 == 0);

  is_integer = beamopallocator_new_op(&(S)->op_allocator);
  is_integer->next = NULL;;
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    is_integer->op = __make_opname__(is_integer, 2);
    is_integer->arity = 2;
#undef __make_opname__
  } while (0);
  is_integer->a[0] = TypeFail;
  is_integer->a[1] = Src;

  do {
    op1 = beamopallocator_new_op(&(S)->op_allocator);
    op1->next = NULL;
  } while (0);
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op1->op = __make_opname__(select_val, 3);
    op1->arity = 3;
#undef __make_opname__
  } while (0);
  ASSERT(op1->a == op1->def_args);

  op1->arity = 3 + Size.val;
  op1->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op1->arity * sizeof(BeamOpArg));;
  op1->a[0] = Src;
  /* We use [] instead of a failure label to indicate a fallthrough
  * to next instruction if none of the values match. That way, we
  * don't have to create a new label dynamically, which would be
  * tricky in BeamAsm. */
  op1->a[1].type = TAG_n;
  op1->a[1].val = 0;
  op1->a[2].type = TAG_u;
  op1->a[2].val = 0;

  do {
    op2 = beamopallocator_new_op(&(S)->op_allocator);
    op2->next = NULL;
  } while (0);
  do {
#define __make_opname__(NAME, ARITY) genop_##NAME##_##ARITY
    op2->op = __make_opname__(select_val, 3);
    op2->arity = 3;
#undef __make_opname__
  } while (0);
  ASSERT(op2->a == op2->def_args);

  op2->arity = 3 + Size.val;
  op2->a = erts_alloc(ERTS_ALC_T_LOADER_TMP, op2->arity * sizeof(BeamOpArg));;
  op2->a[0] = Src;
  op2->a[1] = Fail;
  op2->a[2].type = TAG_u;
  op2->a[2].val = 0;

  /*
  * Split the list.
  */

  ASSERT(Size.type == TAG_u);
  for (i = 0; i < Size.val; i += 2) {
    BeamOp* op = (Rest[i].type == TAG_q) ? op2 : op1;
    int dst = 3 + op->a[2].val;

    ASSERT(Rest[i+1].type == TAG_f);
    op->a[dst] = Rest[i];
    op->a[dst+1] = Rest[i+1];
    op->arity += 2;
    op->a[2].val += 2;
  }
  ASSERT(op1->a[2].val > 0);
  ASSERT(op2->a[2].val > 0);

  /*
  * Order the instruction sequence appropriately.
  */

  if (TypeFail.val == Fail.val) {
    /*
    * select_val Src [] S ... (small numbers)
    * is_integer Fail S
    * select_val Src Fail S ... (bignums)
    */
    op1->next = is_integer;
    is_integer->next = op2;
  } else {
    /*
    * is_integer TypeFail S
    * select_val Src [] S ... (small numbers)
    * select_val Src Fail S ... (bignums)
    */
    is_integer->next = op1;
    op1->next = op2;
    op1 = is_integer;
  }
  op2->next = NULL;

  return op1;;
}

int erts_transform_engine(LoaderState* st) {
  BeamOpArg v0, v1, v2, v3, v4, v5, v6, v7, v8, v9, v10;
  BeamOp* first = st->genop;
  BeamOp* instr = first;
  BeamOp* keep;
  BeamOpArg* rest_args;
  int num_rest_args;
  switch (first->op) {
    case 185: /* aligned_label/2 */

    /*
     * Line beam/jit/x86/ops.tab(397):
     *   aligned_label L A | wait_timeout Fail Src | smp_already_locked(L) => aligned_label L A | wait_timeout_locked Src Fail
     */

    v0 = instr->a[0]; /* L */
    v1 = instr->a[1]; /* A */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 26) { /* wait_timeout/2 */
      goto fail1;
    }
    v2 = instr->a[0]; /* Fail */
    v3 = instr->a[1]; /* Src */
    /* Call predicate smp_already_locked() */
    if (!smp_already_locked(st, v0)) {
      goto fail1;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 229;
    instr->arity = 2;
    instr->a[0] = v3; /* Src */
    instr->a[1] = v2; /* Fail */
    /* Create instruction: aligned_label/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 185;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* L */
    instr->a[1] = v1; /* A */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(401):
     *   aligned_label L A | wait Fail | smp_already_locked(L) => aligned_label L A | wait_locked Fail
     */

  fail1:
    instr = first;
    v0 = instr->a[0]; /* L */
    v1 = instr->a[1]; /* A */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 25) { /* wait/1 */
      goto fail2;
    }
    v2 = instr->a[0]; /* Fail */
    /* Call predicate smp_already_locked() */
    if (!smp_already_locked(st, v0)) {
      goto fail2;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 226;
    instr->arity = 1;
    instr->a[0] = v2; /* Fail */
    /* Create instruction: aligned_label/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 185;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* L */
    instr->a[1] = v1; /* A */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(405):
     *   aligned_label L A | timeout | smp_already_locked(L) => aligned_label L A | timeout_locked
     */

  fail2:
    instr = first;
    v0 = instr->a[0]; /* L */
    v1 = instr->a[1]; /* A */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 22) { /* timeout/0 */
      return TE_FAIL;
    }
    /* Call predicate smp_already_locked() */
    if (!smp_already_locked(st, v0)) {
      return TE_FAIL;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 224;
    instr->arity = 0;
    /* Create instruction: aligned_label/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 185;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* L */
    instr->a[1] = v1; /* A */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 303: /* bad_bs_match/1 */

    /*
     * Line beam/jit/x86/ops.tab(894):
     *   bad_bs_match _A | never() => _
     */

    /* Call predicate never() */
    if (!never(st)) {
      return TE_FAIL;
    }
    /* This rule succeeds */
    keep = instr = instr->next;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 9: /* bif0/2 */

    /*
     * Line beam/jit/x86/ops.tab(695):
     *   bif0 u$bif:erlang:self/0 Dst=d => self Dst
     */

    /* Is argument 1 BIF_self_0? */
    ASSERT(instr->a[0].type == TAG_u);
    if (instr->a[0].type != TAG_u) {
      goto fail5;
    } else {
      int i = instr->a[0].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail5;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail5; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_self_0]) {
          goto fail5; /* Not BIF_self_0 */
        }

      }
    }
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* d  */
      goto fail5;
    }
    v0 = instr->a[1]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 271;
    instr->arity = 1;
    instr->a[0] = v0; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(696):
     *   bif0 u$bif:erlang:node/0 Dst=d => node Dst
     */

  fail5:
    instr = first;
    /* Is argument 1 BIF_node_0? */
    ASSERT(instr->a[0].type == TAG_u);
    if (instr->a[0].type != TAG_u) {
      return TE_FAIL;
    } else {
      int i = instr->a[0].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        return TE_FAIL;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          return TE_FAIL; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_node_0]) {
          return TE_FAIL; /* Not BIF_node_0 */
        }

      }
    }
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* d  */
      return TE_FAIL;
    }
    v0 = instr->a[1]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 272;
    instr->arity = 1;
    instr->a[0] = v0; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 10: /* bif1/4 */

    /*
     * Line beam/jit/x86/ops.tab(699):
     *   bif1 Fail=f _Bif=u$bif:erlang:hd/1 Src=xy Dst => is_nonempty_list Fail Src | get_hd Src Dst
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      goto fail7;
    }
    v0 = instr->a[0]; /* Fail */
    /* Is variable _Bif BIF_hd_1? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail7;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail7;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail7; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_hd_1]) {
          goto fail7; /* Not BIF_hd_1 */
        }

      }
    }
    /* Test type */
    if (((1 << instr->a[2].type) & 24) == 0) { /* x y  */
      goto fail7;
    }
    v2 = instr->a[2]; /* Src */
    v3 = instr->a[3]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 162;
    instr->arity = 2;
    instr->a[0] = v2; /* Src */
    instr->a[1] = v3; /* Dst */
    /* Create instruction: is_nonempty_list/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 56;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v2; /* Src */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(701):
     *   bif1 _Fail=p _Bif=u$bif:erlang:hd/1 Src Dst => bif_hd Src Dst
     */

  fail7:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 512) == 0) { /* p  */
      goto fail8;
    }
    /* Is variable _Bif BIF_hd_1? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail8;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail8;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail8; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_hd_1]) {
          goto fail8; /* Not BIF_hd_1 */
        }

      }
    }
    v2 = instr->a[2]; /* Src */
    v3 = instr->a[3]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 259;
    instr->arity = 2;
    instr->a[0] = v2; /* Src */
    instr->a[1] = v3; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(706):
     *   bif1 Fail=f _Bif=u$bif:erlang:tl/1 Src=xy Dst => is_nonempty_list Fail Src | get_tl Src Dst
     */

  fail8:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      goto fail9;
    }
    v0 = instr->a[0]; /* Fail */
    /* Is variable _Bif BIF_tl_1? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail9;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail9;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail9; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_tl_1]) {
          goto fail9; /* Not BIF_tl_1 */
        }

      }
    }
    /* Test type */
    if (((1 << instr->a[2].type) & 24) == 0) { /* x y  */
      goto fail9;
    }
    v2 = instr->a[2]; /* Src */
    v3 = instr->a[3]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 163;
    instr->arity = 2;
    instr->a[0] = v2; /* Src */
    instr->a[1] = v3; /* Dst */
    /* Create instruction: is_nonempty_list/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 56;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v2; /* Src */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(708):
     *   bif1 _Fail _Bif=u$bif:erlang:get/1 Src=s Dst=d => get(Src, Dst)
     */

  fail9:
    instr = first;
    /* Is variable _Bif BIF_get_1? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail10;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail10;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail10; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_get_1]) {
          goto fail10; /* Not BIF_get_1 */
        }

      }
    }
    /* Test type */
    if (((1 << instr->a[2].type) & 8478) == 0) { /* s  */
      goto fail10;
    }
    v2 = instr->a[2]; /* Src */
    /* Test type */
    if (((1 << instr->a[3].type) & 24) == 0) { /* d  */
      goto fail10;
    }
    v3 = instr->a[3]; /* Dst */
    /* Call generator get() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = get(st, v2, v3);

      if (new_instr == NULL) {
        goto fail10;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(713):
     *   bif1 Fail _Bif=u$bif:erlang:node/1 Src=d Dst=d => bif_node Fail Src Dst
     */

  fail10:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is variable _Bif BIF_node_1? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail11;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail11;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail11; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_node_1]) {
          goto fail11; /* Not BIF_node_1 */
        }

      }
    }
    /* Test type */
    if (((1 << instr->a[2].type) & 24) == 0) { /* d  */
      goto fail11;
    }
    v2 = instr->a[2]; /* Src */
    /* Test type */
    if (((1 << instr->a[3].type) & 24) == 0) { /* d  */
      goto fail11;
    }
    v3 = instr->a[3]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 261;
    instr->arity = 3;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v2; /* Src */
    instr->a[2] = v3; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(725):
     *   bif1 Fail Bif=u$bif:erlang:tuple_size/1 Src=d Dst=d => bif_tuple_size Bif Fail Src Dst
     */

  fail11:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is variable Bif BIF_tuple_size_1? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail12;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail12;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail12; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_tuple_size_1]) {
          goto fail12; /* Not BIF_tuple_size_1 */
        }

      }
    }
    v1 = instr->a[1]; /* Bif */
    /* Test type */
    if (((1 << instr->a[2].type) & 24) == 0) { /* d  */
      goto fail12;
    }
    v2 = instr->a[2]; /* Src */
    /* Test type */
    if (((1 << instr->a[3].type) & 24) == 0) { /* d  */
      goto fail12;
    }
    v3 = instr->a[3]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 264;
    instr->arity = 4;
    instr->a[0] = v1; /* Bif */
    instr->a[1] = v0; /* Fail */
    instr->a[2] = v2; /* Src */
    instr->a[3] = v3; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(743):
     *   bif1 _Fail Bif S1 Dst | never_fails(Bif) => nofail_bif1 S1 Bif Dst
     */

  fail12:
    instr = first;
    v1 = instr->a[1]; /* Bif */
    v2 = instr->a[2]; /* S1 */
    v3 = instr->a[3]; /* Dst */
    /* Call predicate never_fails() */
    if (!never_fails(st, v1)) {
      goto fail13;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 273;
    instr->arity = 3;
    instr->a[0] = v2; /* S1 */
    instr->a[1] = v1; /* Bif */
    instr->a[2] = v3; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(746):
     *   bif1 Fail Bif S1 Dst => i_bif1 S1 Fail Bif Dst
     */

  fail13:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Bif */
    v2 = instr->a[2]; /* S1 */
    v3 = instr->a[3]; /* Dst */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 275;
    instr->arity = 4;
    instr->a[0] = v2; /* S1 */
    instr->a[1] = v0; /* Fail */
    instr->a[2] = v1; /* Bif */
    instr->a[3] = v3; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 11: /* bif2/5 */

    /*
     * Line beam/jit/x86/ops.tab(710):
     *   bif2 Fail u$bif:erlang:element/2 S1=ixy S2 Dst => bif_element Fail S1 S2 Dst
     */

    v0 = instr->a[0]; /* Fail */
    /* Is argument 2 BIF_element_2? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail15;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail15;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail15; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_element_2]) {
          goto fail15; /* Not BIF_element_2 */
        }

      }
    }
    /* Test type */
    if (((1 << instr->a[2].type) & 26) == 0) { /* i x y  */
      goto fail15;
    }
    v1 = instr->a[2]; /* S1 */
    v2 = instr->a[3]; /* S2 */
    v3 = instr->a[4]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 260;
    instr->arity = 4;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* S1 */
    instr->a[2] = v2; /* S2 */
    instr->a[3] = v3; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(729):
     *   bif2 Fail _Bif=u$bif:erlang:map_get/2 Src1 Src2=xy Dst=d => bif_map_get Fail Src1 Src2 Dst
     */

  fail15:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is variable _Bif BIF_map_get_2? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail16;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail16;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail16; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_map_get_2]) {
          goto fail16; /* Not BIF_map_get_2 */
        }

      }
    }
    v2 = instr->a[2]; /* Src1 */
    /* Test type */
    if (((1 << instr->a[3].type) & 24) == 0) { /* x y  */
      goto fail16;
    }
    v3 = instr->a[3]; /* Src2 */
    /* Test type */
    if (((1 << instr->a[4].type) & 24) == 0) { /* d  */
      goto fail16;
    }
    v4 = instr->a[4]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 265;
    instr->arity = 4;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v2; /* Src1 */
    instr->a[2] = v3; /* Src2 */
    instr->a[3] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(733):
     *   bif2 Fail Bif=u$bif:erlang:is_map_key/2 Key Map=xy Dst=d => bif_is_map_key Bif Fail Key Map Dst
     */

  fail16:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is variable Bif BIF_is_map_key_2? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail17;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail17;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail17; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_is_map_key_2]) {
          goto fail17; /* Not BIF_is_map_key_2 */
        }

      }
    }
    v1 = instr->a[1]; /* Bif */
    v2 = instr->a[2]; /* Key */
    /* Test type */
    if (((1 << instr->a[3].type) & 24) == 0) { /* x y  */
      goto fail17;
    }
    v3 = instr->a[3]; /* Map */
    /* Test type */
    if (((1 << instr->a[4].type) & 24) == 0) { /* d  */
      goto fail17;
    }
    v4 = instr->a[4]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 266;
    instr->arity = 5;
    instr->a[0] = v1; /* Bif */
    instr->a[1] = v0; /* Fail */
    instr->a[2] = v2; /* Key */
    instr->a[3] = v3; /* Map */
    instr->a[4] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(737):
     *   bif2 _Fail _Bif=u$bif:erlang:max/2 Src1 Src2 Dst => bif_max Src1 Src2 Dst
     */

  fail17:
    instr = first;
    /* Is variable _Bif BIF_max_2? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail18;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail18;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail18; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_max_2]) {
          goto fail18; /* Not BIF_max_2 */
        }

      }
    }
    v2 = instr->a[2]; /* Src1 */
    v3 = instr->a[3]; /* Src2 */
    v4 = instr->a[4]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 267;
    instr->arity = 3;
    instr->a[0] = v2; /* Src1 */
    instr->a[1] = v3; /* Src2 */
    instr->a[2] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(739):
     *   bif2 _Fail _Bif=u$bif:erlang:min/2 Src1 Src2 Dst => bif_min Src1 Src2 Dst
     */

  fail18:
    instr = first;
    /* Is variable _Bif BIF_min_2? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail19;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail19;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail19; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_min_2]) {
          goto fail19; /* Not BIF_min_2 */
        }

      }
    }
    v2 = instr->a[2]; /* Src1 */
    v3 = instr->a[3]; /* Src2 */
    v4 = instr->a[4]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 268;
    instr->arity = 3;
    instr->a[0] = v2; /* Src1 */
    instr->a[1] = v3; /* Src2 */
    instr->a[2] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(744):
     *   bif2 _Fail Bif S1 S2 Dst | never_fails(Bif) => nofail_bif2 S1 S2 Bif Dst
     */

  fail19:
    instr = first;
    v1 = instr->a[1]; /* Bif */
    v2 = instr->a[2]; /* S1 */
    v3 = instr->a[3]; /* S2 */
    v4 = instr->a[4]; /* Dst */
    /* Call predicate never_fails() */
    if (!never_fails(st, v1)) {
      goto fail20;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 274;
    instr->arity = 4;
    instr->a[0] = v2; /* S1 */
    instr->a[1] = v3; /* S2 */
    instr->a[2] = v1; /* Bif */
    instr->a[3] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(747):
     *   bif2 Fail Bif S1 S2 Dst => i_bif2 S1 S2 Fail Bif Dst
     */

  fail20:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Bif */
    v2 = instr->a[2]; /* S1 */
    v3 = instr->a[3]; /* S2 */
    v4 = instr->a[4]; /* Dst */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 276;
    instr->arity = 5;
    instr->a[0] = v2; /* S1 */
    instr->a[1] = v3; /* S2 */
    instr->a[2] = v0; /* Fail */
    instr->a[3] = v1; /* Bif */
    instr->a[4] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 177: /* bs_create_bin/6 */

    /*
     * Line beam/jit/x86/ops.tab(1029):
     *   bs_create_bin Fail=j Alloc=u Live=u Unit=u Dst=xy N=u Segments=* => create_bin(Fail, Alloc, Live, Unit, Dst, N, Segments)
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 544) == 0) { /* j  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Alloc */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v2 = instr->a[2]; /* Live */
    /* Test type */
    if (((1 << instr->a[3].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v3 = instr->a[3]; /* Unit */
    /* Test type */
    if (((1 << instr->a[4].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    v4 = instr->a[4]; /* Dst */
    /* Test type */
    if (((1 << instr->a[5].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v5 = instr->a[5]; /* N */
    /* Store dynamic arguments (Segments) */
    num_rest_args = instr->arity - 6;
    rest_args = &instr->a[6];
    /* Call generator create_bin() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = create_bin(st, v0, v1, v2, v3, v4, v5, rest_args);

      if (new_instr == NULL) {
        return TE_FAIL;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 119: /* bs_get_binary2/7 */

    /*
     * Line beam/jit/x86/ops.tab(915):
     *   bs_get_binary2 Fail=f Ms1=xy Live1=u Sz=xy Unit=u _Flags=u Dst1=d | bs_get_tail Ms2=xy Dst2 Live2 | equal(Ms1, Ms2) | equal(Live1, Live2) => i_bs_get_bin_and_tail Ms1 Fail Live1 Sz Unit Dst1 Dst2
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      goto fail23;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      goto fail23;
    }
    v1 = instr->a[1]; /* Ms1 */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      goto fail23;
    }
    v2 = instr->a[2]; /* Live1 */
    /* Test type */
    if (((1 << instr->a[3].type) & 24) == 0) { /* x y  */
      goto fail23;
    }
    v3 = instr->a[3]; /* Sz */
    /* Test type */
    if (((1 << instr->a[4].type) & 1) == 0) { /* u  */
      goto fail23;
    }
    v4 = instr->a[4]; /* Unit */
    /* Test type */
    if (((1 << instr->a[5].type) & 1) == 0) { /* u  */
      goto fail23;
    }
    /* Test type */
    if (((1 << instr->a[6].type) & 24) == 0) { /* d  */
      goto fail23;
    }
    v6 = instr->a[6]; /* Dst1 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 165) { /* bs_get_tail/3 */
      goto fail23;
    }
    /* Test type */
    if (((1 << instr->a[0].type) & 24) == 0) { /* x y  */
      goto fail23;
    }
    v7 = instr->a[0]; /* Ms2 */
    v8 = instr->a[1]; /* Dst2 */
    v9 = instr->a[2]; /* Live2 */
    /* Call predicate equal() */
    if (!equal(st, v1, v7)) {
      goto fail23;
    }
    /* Call predicate equal() */
    if (!equal(st, v2, v9)) {
      goto fail23;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 305;
    instr->arity = 7;
    instr->a[0] = v1; /* Ms1 */
    instr->a[1] = v0; /* Fail */
    instr->a[2] = v2; /* Live1 */
    instr->a[3] = v3; /* Sz */
    instr->a[4] = v4; /* Unit */
    instr->a[5] = v6; /* Dst1 */
    instr->a[6] = v8; /* Dst2 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(920):
     *   bs_get_binary2 Fail=f Ms=xy Live=u _Sz=a==am_all Unit=u _Flags=u Dst=d => i_bs_get_binary_all2 Ms Fail Live Unit Dst
     */

  fail23:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      goto fail24;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      goto fail24;
    }
    v1 = instr->a[1]; /* Ms */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      goto fail24;
    }
    v2 = instr->a[2]; /* Live */
    /* Test type */
    if (((1 << instr->a[3].type) & 4) == 0) { /* a  */
      goto fail24;
    }
    /* Test value */
    if (instr->a[3].val != am_all) {
      goto fail24;
    }
    /* Test type */
    if (((1 << instr->a[4].type) & 1) == 0) { /* u  */
      goto fail24;
    }
    v4 = instr->a[4]; /* Unit */
    /* Test type */
    if (((1 << instr->a[5].type) & 1) == 0) { /* u  */
      goto fail24;
    }
    /* Test type */
    if (((1 << instr->a[6].type) & 24) == 0) { /* d  */
      goto fail24;
    }
    v6 = instr->a[6]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 307;
    instr->arity = 5;
    instr->a[0] = v1; /* Ms */
    instr->a[1] = v0; /* Fail */
    instr->a[2] = v2; /* Live */
    instr->a[3] = v4; /* Unit */
    instr->a[4] = v6; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(923):
     *   bs_get_binary2 Fail=f Ms=xy Live=u Sz=s Unit=u _Flags=u Dst=d => i_bs_get_binary2 Ms Fail Live Sz Unit Dst
     */

  fail24:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Ms */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v2 = instr->a[2]; /* Live */
    /* Test type */
    if (((1 << instr->a[3].type) & 8478) == 0) { /* s  */
      return TE_FAIL;
    }
    v3 = instr->a[3]; /* Sz */
    /* Test type */
    if (((1 << instr->a[4].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v4 = instr->a[4]; /* Unit */
    /* Test type */
    if (((1 << instr->a[5].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    /* Test type */
    if (((1 << instr->a[6].type) & 24) == 0) { /* d  */
      return TE_FAIL;
    }
    v6 = instr->a[6]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 306;
    instr->arity = 6;
    instr->a[0] = v1; /* Ms */
    instr->a[1] = v0; /* Fail */
    instr->a[2] = v2; /* Live */
    instr->a[3] = v3; /* Sz */
    instr->a[4] = v4; /* Unit */
    instr->a[5] = v6; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 118: /* bs_get_float2/7 */

    /*
     * Line beam/jit/x86/ops.tab(930):
     *   bs_get_float2 Fail=f Ms=xy Live=u Sz=s Unit=u Flags=u Dst=d => get_float2(Fail, Ms, Live, Sz, Unit, Flags, Dst)
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      goto fail26;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      goto fail26;
    }
    v1 = instr->a[1]; /* Ms */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      goto fail26;
    }
    v2 = instr->a[2]; /* Live */
    /* Test type */
    if (((1 << instr->a[3].type) & 8478) == 0) { /* s  */
      goto fail26;
    }
    v3 = instr->a[3]; /* Sz */
    /* Test type */
    if (((1 << instr->a[4].type) & 1) == 0) { /* u  */
      goto fail26;
    }
    v4 = instr->a[4]; /* Unit */
    /* Test type */
    if (((1 << instr->a[5].type) & 1) == 0) { /* u  */
      goto fail26;
    }
    v5 = instr->a[5]; /* Flags */
    /* Test type */
    if (((1 << instr->a[6].type) & 24) == 0) { /* d  */
      goto fail26;
    }
    v6 = instr->a[6]; /* Dst */
    /* Call generator get_float2() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = get_float2(st, v0, v1, v2, v3, v4, v5, v6);

      if (new_instr == NULL) {
        goto fail26;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(932):
     *   bs_get_float2 Fail=f _Ms=x _Live=u _Sz=q _Unit=u _Flags=u _Dst=d => jump Fail
     */

  fail26:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 8) == 0) { /* x  */
      return TE_FAIL;
    }
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    /* Test type */
    if (((1 << instr->a[3].type) & 8192) == 0) { /* q  */
      return TE_FAIL;
    }
    /* Test type */
    if (((1 << instr->a[4].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    /* Test type */
    if (((1 << instr->a[5].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    /* Test type */
    if (((1 << instr->a[6].type) & 24) == 0) { /* d  */
      return TE_FAIL;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 61;
    instr->arity = 1;
    instr->a[0] = v0; /* Fail */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 167: /* bs_get_position/3 */

    /*
     * Line beam/jit/x86/ops.tab(985):
     *    bs_get_position Src Dst _Live => i_bs_get_position Src Dst
     */

    v0 = instr->a[0]; /* Src */
    v1 = instr->a[1]; /* Dst */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 311;
    instr->arity = 2;
    instr->a[0] = v0; /* Src */
    instr->a[1] = v1; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 140: /* bs_get_utf16/5 */

    /*
     * Line beam/jit/x86/ops.tab(1002):
     *   bs_get_utf16 Fail=f Ms=xy u Flags=u Dst=d => get_utf16(Fail, Ms, Flags, Dst)
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Ms */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    /* Test type */
    if (((1 << instr->a[3].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v2 = instr->a[3]; /* Flags */
    /* Test type */
    if (((1 << instr->a[4].type) & 24) == 0) { /* d  */
      return TE_FAIL;
    }
    v3 = instr->a[4]; /* Dst */
    /* Call generator get_utf16() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = get_utf16(st, v0, v1, v2, v3);

      if (new_instr == NULL) {
        return TE_FAIL;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 142: /* bs_get_utf32/5 */

    /*
     * Line beam/jit/x86/ops.tab(1011):
     *   bs_get_utf32 Fail=f Ms=xy Live=u Flags=u Dst | equal(Ms, Dst) => bs_get_integer2 Fail Ms Live i=32 u=1 Flags x | i_bs_validate_unicode_retract Fail x Ms | move x Dst
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      goto fail30;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      goto fail30;
    }
    v1 = instr->a[1]; /* Ms */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      goto fail30;
    }
    v2 = instr->a[2]; /* Live */
    /* Test type */
    if (((1 << instr->a[3].type) & 1) == 0) { /* u  */
      goto fail30;
    }
    v3 = instr->a[3]; /* Flags */
    v4 = instr->a[4]; /* Dst */
    /* Call predicate equal() */
    if (!equal(st, v1, v4)) {
      goto fail30;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 64;
    instr->arity = 2;
    /* Store value x=1023 */
    instr->a[0].type = TAG_x;
    instr->a[0].val = 1023;
    instr->a[1] = v4; /* Dst */
    /* Create instruction: i_bs_validate_unicode_retract/3 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 316;
      instr->arity = 3;
    }
    instr->a[0] = v0; /* Fail */
    /* Store value x=1023 */
    instr->a[1].type = TAG_x;
    instr->a[1].val = 1023;
    instr->a[2] = v1; /* Ms */
    /* Create instruction: bs_get_integer2/7 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 117;
      instr->arity = 7;
    }
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Ms */
    instr->a[2] = v2; /* Live */
    /* Store value i=32 */
    instr->a[3].type = TAG_i;
    instr->a[3].val = 32;
    /* Store value u=1 */
    instr->a[4].type = TAG_u;
    instr->a[4].val = 1;
    instr->a[5] = v3; /* Flags */
    /* Store value x=1023 */
    instr->a[6].type = TAG_x;
    instr->a[6].val = 1023;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1015):
     *   bs_get_utf32 Fail=f Ms=xy Live=u Flags=u Dst=d => bs_get_integer2 Fail Ms Live i=32 u=1 Flags Dst | i_bs_validate_unicode_retract Fail Dst Ms
     */

  fail30:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Ms */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v2 = instr->a[2]; /* Live */
    /* Test type */
    if (((1 << instr->a[3].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v3 = instr->a[3]; /* Flags */
    /* Test type */
    if (((1 << instr->a[4].type) & 24) == 0) { /* d  */
      return TE_FAIL;
    }
    v4 = instr->a[4]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 316;
    instr->arity = 3;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v4; /* Dst */
    instr->a[2] = v1; /* Ms */
    /* Create instruction: bs_get_integer2/7 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 117;
      instr->arity = 7;
    }
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Ms */
    instr->a[2] = v2; /* Live */
    /* Store value i=32 */
    instr->a[3].type = TAG_i;
    instr->a[3].val = 32;
    /* Store value u=1 */
    instr->a[4].type = TAG_u;
    instr->a[4].val = 1;
    instr->a[5] = v3; /* Flags */
    instr->a[6] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 138: /* bs_get_utf8/5 */

    /*
     * Line beam/jit/x86/ops.tab(996):
     *   bs_get_utf8 Fail=f Ms=xy u u Dst=d => i_bs_get_utf8 Ms Fail Dst
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Ms */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    /* Test type */
    if (((1 << instr->a[3].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    /* Test type */
    if (((1 << instr->a[4].type) & 24) == 0) { /* d  */
      return TE_FAIL;
    }
    v2 = instr->a[4]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 312;
    instr->arity = 3;
    instr->a[0] = v1; /* Ms */
    instr->a[1] = v0; /* Fail */
    instr->a[2] = v2; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 182: /* bs_match/3 */

    /*
     * Line beam/jit/x86/ops.tab(880):
     *   bs_match Fail Ctx Size Rest=* => bs_match(Fail, Ctx, Size, Rest)
     */

    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Ctx */
    v2 = instr->a[2]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 3;
    rest_args = &instr->a[3];
    /* Call generator bs_match() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = bs_match(st, v0, v1, v2, rest_args);

      if (new_instr == NULL) {
        return TE_FAIL;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 132: /* bs_match_string/4 */

    /*
     * Line beam/jit/x86/ops.tab(903):
     *   bs_match_string Fail Ms Bits Val => i_bs_match_string Ms Fail Bits Val
     */

    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Ms */
    v2 = instr->a[2]; /* Bits */
    v3 = instr->a[3]; /* Val */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 304;
    instr->arity = 4;
    instr->a[0] = v1; /* Ms */
    instr->a[1] = v0; /* Fail */
    instr->a[2] = v2; /* Bits */
    instr->a[3] = v3; /* Val */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 120: /* bs_skip_bits2/5 */

    /*
     * Line beam/jit/x86/ops.tab(939):
     *   bs_skip_bits2 Fail=f Ms=xy Sz Unit=u _Flags=u => i_bs_skip_bits2 Ms Sz Fail Unit
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Ms */
    v2 = instr->a[2]; /* Sz */
    /* Test type */
    if (((1 << instr->a[3].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v3 = instr->a[3]; /* Unit */
    /* Test type */
    if (((1 << instr->a[4].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 309;
    instr->arity = 4;
    instr->a[0] = v1; /* Ms */
    instr->a[1] = v2; /* Sz */
    instr->a[2] = v0; /* Fail */
    instr->a[3] = v3; /* Unit */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 141: /* bs_skip_utf16/4 */

    /*
     * Line beam/jit/x86/ops.tab(1003):
     *   bs_skip_utf16 Fail=f Ms=xy u Flags=u => skip_utf16(Fail, Ms, Flags)
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Ms */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    /* Test type */
    if (((1 << instr->a[3].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v2 = instr->a[3]; /* Flags */
    /* Call generator skip_utf16() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = skip_utf16(st, v0, v1, v2);

      if (new_instr == NULL) {
        return TE_FAIL;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 143: /* bs_skip_utf32/4 */

    /*
     * Line beam/jit/x86/ops.tab(1019):
     *   bs_skip_utf32 Fail=f Ms=xy Live=u Flags=u => bs_get_integer2 Fail Ms Live i=32 u=1 Flags x | i_bs_validate_unicode_retract Fail x Ms
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Ms */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v2 = instr->a[2]; /* Live */
    /* Test type */
    if (((1 << instr->a[3].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v3 = instr->a[3]; /* Flags */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 316;
    instr->arity = 3;
    instr->a[0] = v0; /* Fail */
    /* Store value x=1023 */
    instr->a[1].type = TAG_x;
    instr->a[1].val = 1023;
    instr->a[2] = v1; /* Ms */
    /* Create instruction: bs_get_integer2/7 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 117;
      instr->arity = 7;
    }
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Ms */
    instr->a[2] = v2; /* Live */
    /* Store value i=32 */
    instr->a[3].type = TAG_i;
    instr->a[3].val = 32;
    /* Store value u=1 */
    instr->a[4].type = TAG_u;
    instr->a[4].val = 1;
    instr->a[5] = v3; /* Flags */
    /* Store value x=1023 */
    instr->a[6].type = TAG_x;
    instr->a[6].val = 1023;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 139: /* bs_skip_utf8/4 */

    /*
     * Line beam/jit/x86/ops.tab(999):
     *   bs_skip_utf8 Fail=f Ms=xy u u => i_bs_skip_utf8 Ms Fail
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Ms */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    /* Test type */
    if (((1 << instr->a[3].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 313;
    instr->arity = 2;
    instr->a[0] = v1; /* Ms */
    instr->a[1] = v0; /* Fail */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 166: /* bs_start_match3/4 */

    /*
     * Line beam/jit/x86/ops.tab(976):
     *   bs_start_match3 Fail=j ica _Live _Dst => jump Fail
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 544) == 0) { /* j  */
      goto fail39;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 8454) == 0) { /* i c a  */
      goto fail39;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 61;
    instr->arity = 1;
    instr->a[0] = v0; /* Fail */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(977):
     *   bs_start_match3 Fail Bin Live Dst => i_bs_start_match3 Bin Live Fail Dst
     */

  fail39:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Bin */
    v2 = instr->a[2]; /* Live */
    v3 = instr->a[3]; /* Dst */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 310;
    instr->arity = 4;
    instr->a[0] = v1; /* Bin */
    instr->a[1] = v2; /* Live */
    instr->a[2] = v0; /* Fail */
    instr->a[3] = v3; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 170: /* bs_start_match4/4 */

    /*
     * Line beam/jit/x86/ops.tab(959):
     *   bs_start_match4 a==am_no_fail Live=u Src=xy Ctx=d => bs_start_match3 p Src Live Ctx
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 4) == 0) { /* a  */
      goto fail41;
    }
    /* Test value */
    if (instr->a[0].val != am_no_fail) {
      goto fail41;
    }
    /* Test type */
    if (((1 << instr->a[1].type) & 1) == 0) { /* u  */
      goto fail41;
    }
    v0 = instr->a[1]; /* Live */
    /* Test type */
    if (((1 << instr->a[2].type) & 24) == 0) { /* x y  */
      goto fail41;
    }
    v1 = instr->a[2]; /* Src */
    /* Test type */
    if (((1 << instr->a[3].type) & 24) == 0) { /* d  */
      goto fail41;
    }
    v2 = instr->a[3]; /* Ctx */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 166;
    instr->arity = 4;
    /* Store value p=0 */
    instr->a[0].type = TAG_p;
    instr->a[0].val = 0;
    instr->a[1] = v1; /* Src */
    instr->a[2] = v0; /* Live */
    instr->a[3] = v2; /* Ctx */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(961):
     *   bs_start_match4 Fail=f Live=u Src=xy Ctx=d => bs_start_match3 Fail Src Live Ctx
     */

  fail41:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      goto fail42;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 1) == 0) { /* u  */
      goto fail42;
    }
    v1 = instr->a[1]; /* Live */
    /* Test type */
    if (((1 << instr->a[2].type) & 24) == 0) { /* x y  */
      goto fail42;
    }
    v2 = instr->a[2]; /* Src */
    /* Test type */
    if (((1 << instr->a[3].type) & 24) == 0) { /* d  */
      goto fail42;
    }
    v3 = instr->a[3]; /* Ctx */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 166;
    instr->arity = 4;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v2; /* Src */
    instr->a[2] = v1; /* Live */
    instr->a[3] = v3; /* Ctx */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(966):
     *   bs_start_match4 a==am_resume _Live Ctx Dst | equal(Ctx, Dst) => _
     */

  fail42:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 4) == 0) { /* a  */
      goto fail43;
    }
    /* Test value */
    if (instr->a[0].val != am_resume) {
      goto fail43;
    }
    v1 = instr->a[2]; /* Ctx */
    v2 = instr->a[3]; /* Dst */
    /* Call predicate equal() */
    if (!equal(st, v1, v2)) {
      goto fail43;
    }
    /* This rule succeeds */
    keep = instr = instr->next;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(967):
     *   bs_start_match4 a==am_resume _Live Ctx Dst => move Ctx Dst
     */

  fail43:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 4) == 0) { /* a  */
      return TE_FAIL;
    }
    /* Test value */
    if (instr->a[0].val != am_resume) {
      return TE_FAIL;
    }
    v1 = instr->a[2]; /* Ctx */
    v2 = instr->a[3]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 64;
    instr->arity = 2;
    instr->a[0] = v1; /* Ctx */
    instr->a[1] = v2; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 121: /* bs_test_tail2/3 */

    /*
     * Line beam/jit/x86/ops.tab(943):
     *   bs_test_tail2 Fail=f _Ms=xy o => jump Fail
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    /* Test type */
    if (((1 << instr->a[2].type) & 16384) == 0) { /* o  */
      return TE_FAIL;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 61;
    instr->arity = 1;
    instr->a[0] = v0; /* Fail */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 4: /* call/2 */

    /*
     * Line beam/jit/x86/ops.tab(777):
     *   call _Ar Func => i_call Func
     */

    v1 = instr->a[1]; /* Func */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 282;
    instr->arity = 1;
    instr->a[0] = v1; /* Func */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 7: /* call_ext/2 */

    /*
     * Line beam/jit/x86/ops.tab(565):
     *   call_ext u==2 u$func:erlang:load_nif/2 => i_load_nif
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail47;
    }
    /* Test value */
    if (instr->a[0].val != 2) {
      goto fail47;
    }
    /* Is argument 2 the function am_erlang:am_load_nif/2? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail47;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail47;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_load_nif || import->arity != 2) {
        goto fail47;
      }
    }
    /* Rename instruction keeping the arguments */
    instr->op = 247;
    instr->arity = 0;
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(580):
     *   call_ext u==1 u$func:erlang:call_on_load_function/1 => i_call_on_load_function
     */

  fail47:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail48;
    }
    /* Test value */
    if (instr->a[0].val != 1) {
      goto fail48;
    }
    /* Is argument 2 the function am_erlang:am_call_on_load_function/1? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail48;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail48;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_call_on_load_function || import->arity != 1) {
        goto fail48;
      }
    }
    /* Rename instruction keeping the arguments */
    instr->op = 248;
    instr->arity = 0;
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(594):
     *   call_ext u==2 u$func:erlang:apply/2 => i_apply_fun
     */

  fail48:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail49;
    }
    /* Test value */
    if (instr->a[0].val != 2) {
      goto fail49;
    }
    /* Is argument 2 the function am_erlang:am_apply/2? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail49;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail49;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_apply || import->arity != 2) {
        goto fail49;
      }
    }
    /* Rename instruction keeping the arguments */
    instr->op = 253;
    instr->arity = 0;
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(602):
     *   call_ext u==3 u$func:erlang:apply/3 => i_apply
     */

  fail49:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail50;
    }
    /* Test value */
    if (instr->a[0].val != 3) {
      goto fail50;
    }
    /* Is argument 2 the function am_erlang:am_apply/3? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail50;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail50;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_apply || import->arity != 3) {
        goto fail50;
      }
    }
    /* Rename instruction keeping the arguments */
    instr->op = 250;
    instr->arity = 0;
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(610):
     *   call_ext u==0 u$func:erlang:yield/0 => i_yield
     */

  fail50:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail51;
    }
    /* Test value */
    if (instr->a[0].val != 0) {
      goto fail51;
    }
    /* Is argument 2 the function am_erlang:am_yield/0? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail51;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail51;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_yield || import->arity != 0) {
        goto fail51;
      }
    }
    /* Rename instruction keeping the arguments */
    instr->op = 193;
    instr->arity = 0;
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(617):
     *   call_ext u==0 u$func:erlang:hibernate/0 => i_hibernate
     */

  fail51:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail52;
    }
    /* Test value */
    if (instr->a[0].val != 0) {
      goto fail52;
    }
    /* Is argument 2 the function am_erlang:am_hibernate/0? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail52;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail52;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_hibernate || import->arity != 0) {
        goto fail52;
      }
    }
    /* Rename instruction keeping the arguments */
    instr->op = 257;
    instr->arity = 0;
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(622):
     *   call_ext u==0 u$func:os:perf_counter/0 => i_perf_counter
     */

  fail52:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail53;
    }
    /* Test value */
    if (instr->a[0].val != 0) {
      goto fail53;
    }
    /* Is argument 2 the function am_os:am_perf_counter/0? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail53;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail53;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_os || import->function != am_perf_counter || import->arity != 0) {
        goto fail53;
      }
    }
    /* Rename instruction keeping the arguments */
    instr->op = 258;
    instr->arity = 0;
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(634):
     *   call_ext u Bif=u$is_bif | is_heavy_bif(Bif) => i_call_ext Bif
     */

  fail53:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail54;
    }
    /* Is variable Bif a BIF? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail54;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail54;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail54; /* Not a BIF */
        }

      }
    }
    v0 = instr->a[1]; /* Bif */
    /* Call predicate is_heavy_bif() */
    if (!is_heavy_bif(st, v0)) {
      goto fail54;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 285;
    instr->arity = 1;
    instr->a[0] = v0; /* Bif */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(654):
     *   call_ext u Bif=u$is_bif => call_light_bif Bif
     */

  fail54:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail55;
    }
    /* Is variable Bif a BIF? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail55;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail55;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail55; /* Not a BIF */
        }

      }
    }
    v0 = instr->a[1]; /* Bif */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 246;
    instr->arity = 2;
    instr->a[0] = v0; /* Bif */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(667):
     *   call_ext _Ar Func => i_call_ext Func
     */

  fail55:
    instr = first;
    v1 = instr->a[1]; /* Func */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 285;
    instr->arity = 1;
    instr->a[0] = v1; /* Func */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 8: /* call_ext_last/3 */

    /*
     * Line beam/jit/x86/ops.tab(567):
     *   call_ext_last u==2 u$func:erlang:load_nif/2 D => i_load_nif | deallocate D | return
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail57;
    }
    /* Test value */
    if (instr->a[0].val != 2) {
      goto fail57;
    }
    /* Is argument 2 the function am_erlang:am_load_nif/2? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail57;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail57;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_load_nif || import->arity != 2) {
        goto fail57;
      }
    }
    v0 = instr->a[2]; /* D */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 19;
    instr->arity = 0;
    /* Create instruction: deallocate/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 18;
      instr->arity = 1;
    }
    instr->a[0] = v0; /* D */
    /* Create instruction: i_load_nif/0 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 247;
      instr->arity = 0;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(582):
     *   call_ext_last u==1 u$func:erlang:call_on_load_function/1 D => i_call_on_load_function | deallocate D | return
     */

  fail57:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail58;
    }
    /* Test value */
    if (instr->a[0].val != 1) {
      goto fail58;
    }
    /* Is argument 2 the function am_erlang:am_call_on_load_function/1? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail58;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail58;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_call_on_load_function || import->arity != 1) {
        goto fail58;
      }
    }
    v0 = instr->a[2]; /* D */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 19;
    instr->arity = 0;
    /* Create instruction: deallocate/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 18;
      instr->arity = 1;
    }
    instr->a[0] = v0; /* D */
    /* Create instruction: i_call_on_load_function/0 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 248;
      instr->arity = 0;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(595):
     *   call_ext_last u==2 u$func:erlang:apply/2 D => i_apply_fun_last D
     */

  fail58:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail59;
    }
    /* Test value */
    if (instr->a[0].val != 2) {
      goto fail59;
    }
    /* Is argument 2 the function am_erlang:am_apply/2? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail59;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail59;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_apply || import->arity != 2) {
        goto fail59;
      }
    }
    v0 = instr->a[2]; /* D */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 254;
    instr->arity = 1;
    instr->a[0] = v0; /* D */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(603):
     *   call_ext_last u==3 u$func:erlang:apply/3 D => i_apply_last D
     */

  fail59:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail60;
    }
    /* Test value */
    if (instr->a[0].val != 3) {
      goto fail60;
    }
    /* Is argument 2 the function am_erlang:am_apply/3? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail60;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail60;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_apply || import->arity != 3) {
        goto fail60;
      }
    }
    v0 = instr->a[2]; /* D */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 251;
    instr->arity = 1;
    instr->a[0] = v0; /* D */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(611):
     *   call_ext_last u==0 u$func:erlang:yield/0 D => i_yield | deallocate D | return
     */

  fail60:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail61;
    }
    /* Test value */
    if (instr->a[0].val != 0) {
      goto fail61;
    }
    /* Is argument 2 the function am_erlang:am_yield/0? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail61;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail61;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_yield || import->arity != 0) {
        goto fail61;
      }
    }
    v0 = instr->a[2]; /* D */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 19;
    instr->arity = 0;
    /* Create instruction: deallocate/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 18;
      instr->arity = 1;
    }
    instr->a[0] = v0; /* D */
    /* Create instruction: i_yield/0 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 193;
      instr->arity = 0;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(618):
     *   call_ext_last u==0 u$func:erlang:hibernate/0 D => i_hibernate | deallocate D | return
     */

  fail61:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail62;
    }
    /* Test value */
    if (instr->a[0].val != 0) {
      goto fail62;
    }
    /* Is argument 2 the function am_erlang:am_hibernate/0? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail62;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail62;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_hibernate || import->arity != 0) {
        goto fail62;
      }
    }
    v0 = instr->a[2]; /* D */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 19;
    instr->arity = 0;
    /* Create instruction: deallocate/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 18;
      instr->arity = 1;
    }
    instr->a[0] = v0; /* D */
    /* Create instruction: i_hibernate/0 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 257;
      instr->arity = 0;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(624):
     *   call_ext_last u==0 u$func:os:perf_counter/0 D => i_perf_counter | deallocate D | return
     */

  fail62:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail63;
    }
    /* Test value */
    if (instr->a[0].val != 0) {
      goto fail63;
    }
    /* Is argument 2 the function am_os:am_perf_counter/0? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail63;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail63;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_os || import->function != am_perf_counter || import->arity != 0) {
        goto fail63;
      }
    }
    v0 = instr->a[2]; /* D */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 19;
    instr->arity = 0;
    /* Create instruction: deallocate/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 18;
      instr->arity = 1;
    }
    instr->a[0] = v0; /* D */
    /* Create instruction: i_perf_counter/0 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 258;
      instr->arity = 0;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(636):
     *   call_ext_last u Bif=u$is_bif D | is_heavy_bif(Bif) => i_call_ext Bif | deallocate D | return
     */

  fail63:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail64;
    }
    /* Is variable Bif a BIF? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail64;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail64;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail64; /* Not a BIF */
        }

      }
    }
    v0 = instr->a[1]; /* Bif */
    v1 = instr->a[2]; /* D */
    /* Call predicate is_heavy_bif() */
    if (!is_heavy_bif(st, v0)) {
      goto fail64;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 19;
    instr->arity = 0;
    /* Create instruction: deallocate/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 18;
      instr->arity = 1;
    }
    instr->a[0] = v1; /* D */
    /* Create instruction: i_call_ext/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 285;
      instr->arity = 1;
    }
    instr->a[0] = v0; /* Bif */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(645):
     *   call_ext_last u Bif u | is_exit_bif(Bif) => call_light_bif Bif
     */

  fail64:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail65;
    }
    v0 = instr->a[1]; /* Bif */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      goto fail65;
    }
    /* Call predicate is_exit_bif() */
    if (!is_exit_bif(st, v0)) {
      goto fail65;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 246;
    instr->arity = 2;
    instr->a[0] = v0; /* Bif */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(656):
     *   call_ext_last u Bif=u$is_bif D => call_light_bif Bif | deallocate D | return
     */

  fail65:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail66;
    }
    /* Is variable Bif a BIF? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail66;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail66;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail66; /* Not a BIF */
        }

      }
    }
    v0 = instr->a[1]; /* Bif */
    v1 = instr->a[2]; /* D */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 19;
    instr->arity = 0;
    /* Create instruction: deallocate/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 18;
      instr->arity = 1;
    }
    instr->a[0] = v1; /* D */
    /* Create instruction: call_light_bif/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 246;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* Bif */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(668):
     *   call_ext_last _Ar Func D => i_call_ext_last Func D
     */

  fail66:
    instr = first;
    v1 = instr->a[1]; /* Func */
    v2 = instr->a[2]; /* D */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 286;
    instr->arity = 2;
    instr->a[0] = v1; /* Func */
    instr->a[1] = v2; /* D */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 78: /* call_ext_only/2 */

    /*
     * Line beam/jit/x86/ops.tab(569):
     *   call_ext_only u==2 u$func:erlang:load_nif/2 => i_load_nif | return
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail68;
    }
    /* Test value */
    if (instr->a[0].val != 2) {
      goto fail68;
    }
    /* Is argument 2 the function am_erlang:am_load_nif/2? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail68;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail68;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_load_nif || import->arity != 2) {
        goto fail68;
      }
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 19;
    instr->arity = 0;
    /* Create instruction: i_load_nif/0 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 247;
      instr->arity = 0;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(584):
     *   call_ext_only u==1 u$func:erlang:call_on_load_function/1 => i_call_on_load_function | return
     */

  fail68:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail69;
    }
    /* Test value */
    if (instr->a[0].val != 1) {
      goto fail69;
    }
    /* Is argument 2 the function am_erlang:am_call_on_load_function/1? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail69;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail69;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_call_on_load_function || import->arity != 1) {
        goto fail69;
      }
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 19;
    instr->arity = 0;
    /* Create instruction: i_call_on_load_function/0 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 248;
      instr->arity = 0;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(596):
     *   call_ext_only u==2 u$func:erlang:apply/2 => i_apply_fun_only
     */

  fail69:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail70;
    }
    /* Test value */
    if (instr->a[0].val != 2) {
      goto fail70;
    }
    /* Is argument 2 the function am_erlang:am_apply/2? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail70;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail70;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_apply || import->arity != 2) {
        goto fail70;
      }
    }
    /* Rename instruction keeping the arguments */
    instr->op = 255;
    instr->arity = 0;
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(604):
     *   call_ext_only u==3 u$func:erlang:apply/3 => i_apply_only
     */

  fail70:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail71;
    }
    /* Test value */
    if (instr->a[0].val != 3) {
      goto fail71;
    }
    /* Is argument 2 the function am_erlang:am_apply/3? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail71;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail71;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_apply || import->arity != 3) {
        goto fail71;
      }
    }
    /* Rename instruction keeping the arguments */
    instr->op = 252;
    instr->arity = 0;
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(612):
     *   call_ext_only u==0 u$func:erlang:yield/0 => i_yield | return
     */

  fail71:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail72;
    }
    /* Test value */
    if (instr->a[0].val != 0) {
      goto fail72;
    }
    /* Is argument 2 the function am_erlang:am_yield/0? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail72;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail72;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_yield || import->arity != 0) {
        goto fail72;
      }
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 19;
    instr->arity = 0;
    /* Create instruction: i_yield/0 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 193;
      instr->arity = 0;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(619):
     *   call_ext_only u==0 u$func:erlang:hibernate/0 => i_hibernate | return
     */

  fail72:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail73;
    }
    /* Test value */
    if (instr->a[0].val != 0) {
      goto fail73;
    }
    /* Is argument 2 the function am_erlang:am_hibernate/0? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail73;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail73;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_erlang || import->function != am_hibernate || import->arity != 0) {
        goto fail73;
      }
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 19;
    instr->arity = 0;
    /* Create instruction: i_hibernate/0 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 257;
      instr->arity = 0;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(626):
     *   call_ext_only u==0 u$func:os:perf_counter/0 => i_perf_counter | return
     */

  fail73:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail74;
    }
    /* Test value */
    if (instr->a[0].val != 0) {
      goto fail74;
    }
    /* Is argument 2 the function am_os:am_perf_counter/0? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail74;
    } else {
      int i = instr->a[1].val;
      BeamFile_ImportEntry* import;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail74;
      }
      import = &st->beam.imports.entries[i];
      if (import->module != am_os || import->function != am_perf_counter || import->arity != 0) {
        goto fail74;
      }
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 19;
    instr->arity = 0;
    /* Create instruction: i_perf_counter/0 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 258;
      instr->arity = 0;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(638):
     *   call_ext_only Ar=u Bif=u$is_bif | is_heavy_bif(Bif) => allocate u Ar | i_call_ext Bif | deallocate u | return
     */

  fail74:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail75;
    }
    v0 = instr->a[0]; /* Ar */
    /* Is variable Bif a BIF? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail75;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail75;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail75; /* Not a BIF */
        }

      }
    }
    v1 = instr->a[1]; /* Bif */
    /* Call predicate is_heavy_bif() */
    if (!is_heavy_bif(st, v1)) {
      goto fail75;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 19;
    instr->arity = 0;
    /* Create instruction: deallocate/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 18;
      instr->arity = 1;
    }
    /* Store value u=0 */
    instr->a[0].type = TAG_u;
    instr->a[0].val = 0;
    /* Create instruction: i_call_ext/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 285;
      instr->arity = 1;
    }
    instr->a[0] = v1; /* Bif */
    /* Create instruction: allocate/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 12;
      instr->arity = 2;
    }
    /* Store value u=0 */
    instr->a[0].type = TAG_u;
    instr->a[0].val = 0;
    instr->a[1] = v0; /* Ar */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(647):
     *   call_ext_only Ar=u Bif | is_exit_bif(Bif) => allocate u Ar | call_light_bif Bif
     */

  fail75:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail76;
    }
    v0 = instr->a[0]; /* Ar */
    v1 = instr->a[1]; /* Bif */
    /* Call predicate is_exit_bif() */
    if (!is_exit_bif(st, v1)) {
      goto fail76;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 246;
    instr->arity = 2;
    instr->a[0] = v1; /* Bif */
    /* Create instruction: allocate/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 12;
      instr->arity = 2;
    }
    /* Store value u=0 */
    instr->a[0].type = TAG_u;
    instr->a[0].val = 0;
    instr->a[1] = v0; /* Ar */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(658):
     *   call_ext_only Ar=u Bif=u$is_bif => allocate u Ar | call_light_bif Bif | deallocate u | return
     */

  fail76:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      goto fail77;
    }
    v0 = instr->a[0]; /* Ar */
    /* Is variable Bif a BIF? */
    ASSERT(instr->a[1].type == TAG_u);
    if (instr->a[1].type != TAG_u) {
      goto fail77;
    } else {
      int i = instr->a[1].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail77;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail77; /* Not a BIF */
        }

      }
    }
    v1 = instr->a[1]; /* Bif */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 19;
    instr->arity = 0;
    /* Create instruction: deallocate/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 18;
      instr->arity = 1;
    }
    /* Store value u=0 */
    instr->a[0].type = TAG_u;
    instr->a[0].val = 0;
    /* Create instruction: call_light_bif/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 246;
      instr->arity = 2;
    }
    instr->a[0] = v1; /* Bif */
    /* Create instruction: allocate/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 12;
      instr->arity = 2;
    }
    /* Store value u=0 */
    instr->a[0].type = TAG_u;
    instr->a[0].val = 0;
    instr->a[1] = v0; /* Ar */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(669):
     *   call_ext_only _Ar Func => i_call_ext_only Func
     */

  fail77:
    instr = first;
    v1 = instr->a[1]; /* Func */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 287;
    instr->arity = 1;
    instr->a[0] = v1; /* Func */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 75: /* call_fun/1 */

    /*
     * Line beam/jit/x86/ops.tab(791):
     *   call_fun Arity | deallocate D | return => i_call_fun_last Arity D
     */

    v0 = instr->a[0]; /* Arity */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 18) { /* deallocate/1 */
      goto fail79;
    }
    v1 = instr->a[0]; /* D */
    /* Advance to next instruction */
    instr = instr->next;
    if (instr == NULL) return TE_SHORT_WINDOW;
    if (instr->op != 19) { /* return/0 */
      goto fail79;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 289;
    instr->arity = 2;
    instr->a[0] = v0; /* Arity */
    instr->a[1] = v1; /* D */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(792):
     *   call_fun Arity => i_call_fun Arity
     */

  fail79:
    instr = first;
    v0 = instr->a[0]; /* Arity */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 288;
    instr->arity = 1;
    instr->a[0] = v0; /* Arity */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 178: /* call_fun2/3 */

    /*
     * Line beam/jit/x86/ops.tab(798):
     *   call_fun2 Tag Arity Func | deallocate D | return => i_call_fun2_last Tag Arity Func D
     */

    v0 = instr->a[0]; /* Tag */
    v1 = instr->a[1]; /* Arity */
    v2 = instr->a[2]; /* Func */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 18) { /* deallocate/1 */
      goto fail81;
    }
    v3 = instr->a[0]; /* D */
    /* Advance to next instruction */
    instr = instr->next;
    if (instr == NULL) return TE_SHORT_WINDOW;
    if (instr->op != 19) { /* return/0 */
      goto fail81;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 291;
    instr->arity = 4;
    instr->a[0] = v0; /* Tag */
    instr->a[1] = v1; /* Arity */
    instr->a[2] = v2; /* Func */
    instr->a[3] = v3; /* D */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(800):
     *   call_fun2 Tag Arity Func => i_call_fun2 Tag Arity Func
     */

  fail81:
    instr = first;
    v0 = instr->a[0]; /* Tag */
    v1 = instr->a[1]; /* Arity */
    v2 = instr->a[2]; /* Func */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 290;
    instr->arity = 3;
    instr->a[0] = v0; /* Tag */
    instr->a[1] = v1; /* Arity */
    instr->a[2] = v2; /* Func */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 5: /* call_last/3 */

    /*
     * Line beam/jit/x86/ops.tab(778):
     *   call_last _Ar Func D => i_call_last Func D
     */

    v1 = instr->a[1]; /* Func */
    v2 = instr->a[2]; /* D */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 283;
    instr->arity = 2;
    instr->a[0] = v1; /* Func */
    instr->a[1] = v2; /* D */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 246: /* call_light_bif/1 */

    /*
     * Line beam/jit/x86/ops.tab(681):
     *   call_light_bif Bif => call_light_bif Bif Bif
     */

    v0 = instr->a[0]; /* Bif */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 256;
    instr->arity = 2;
    instr->a[0] = v0; /* Bif */
    instr->a[1] = v0; /* Bif */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 6: /* call_only/2 */

    /*
     * Line beam/jit/x86/ops.tab(779):
     *   call_only _Ar Func => i_call_only Func
     */

    v1 = instr->a[1]; /* Func */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 284;
    instr->arity = 1;
    instr->a[0] = v1; /* Func */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 207: /* current_tuple/1 */

    /*
     * Line beam/jit/x86/ops.tab(269):
     *   current_tuple Tuple | get_tuple_element Tuple2 Pos Dst | equal(Tuple, Tuple2) => i_get_tuple_element Tuple Pos Dst | current_tuple Tuple
     */

    v0 = instr->a[0]; /* Tuple */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 66) { /* get_tuple_element/3 */
      goto fail86;
    }
    v1 = instr->a[0]; /* Tuple2 */
    v2 = instr->a[1]; /* Pos */
    v3 = instr->a[2]; /* Dst */
    /* Call predicate equal() */
    if (!equal(st, v0, v1)) {
      goto fail86;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 207;
    instr->arity = 2;
    instr->a[0] = v0; /* Tuple */
    /* Create instruction: i_get_tuple_element/3 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 216;
      instr->arity = 3;
    }
    instr->a[0] = v0; /* Tuple */
    instr->a[1] = v2; /* Pos */
    instr->a[2] = v3; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(279):
     *   current_tuple _Tuple => _
     */

  fail86:
    instr = first;
    /* This rule always succeeds */
    keep = instr = instr->next;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 208: /* current_tuple/2 */

    /*
     * Line beam/jit/x86/ops.tab(299):
     *   current_tuple Tuple Tuple2 | equal(Tuple, Tuple2) => _
     */

    v0 = instr->a[0]; /* Tuple */
    v1 = instr->a[1]; /* Tuple2 */
    /* Call predicate equal() */
    if (!equal(st, v0, v1)) {
      goto fail88;
    }
    /* This rule succeeds */
    keep = instr = instr->next;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(300):
     *   current_tuple Tuple _Dst => current_tuple Tuple
     */

  fail88:
    instr = first;
    v0 = instr->a[0]; /* Tuple */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 207;
    instr->arity = 2;
    instr->a[0] = v0; /* Tuple */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 184: /* debug_line/4 */

    /*
     * Line beam/jit/x86/ops.tab(96):
     *   debug_line a==am_entry u u u => _
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 4) == 0) { /* a  */
      goto fail90;
    }
    /* Test value */
    if (instr->a[0].val != am_entry) {
      goto fail90;
    }
    /* Test type */
    if (((1 << instr->a[1].type) & 1) == 0) { /* u  */
      goto fail90;
    }
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      goto fail90;
    }
    /* Test type */
    if (((1 << instr->a[3].type) & 1) == 0) { /* u  */
      goto fail90;
    }
    /* This rule succeeds */
    keep = instr = instr->next;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(98):
     *   debug_line _Kind Loc Index Live | instrumenting_line_breakpoints() => i_debug_line Loc Index Live | i_line_breakpoint_trampoline
     */

  fail90:
    instr = first;
    v1 = instr->a[1]; /* Loc */
    v2 = instr->a[2]; /* Index */
    v3 = instr->a[3]; /* Live */
    /* Call predicate instrumenting_line_breakpoints() */
    if (!instrumenting_line_breakpoints(st)) {
      goto fail91;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 197;
    instr->arity = 0;
    /* Create instruction: i_debug_line/3 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 196;
      instr->arity = 3;
    }
    instr->a[0] = v1; /* Loc */
    instr->a[1] = v2; /* Index */
    instr->a[2] = v3; /* Live */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(99):
     *   debug_line _Kind _Loc _Index _Live => _
     */

  fail91:
    instr = first;
    /* This rule always succeeds */
    keep = instr = instr->next;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 219: /* delete_me/0 */

    /*
     * Line beam/jit/x86/ops.tab(334):
     *   delete_me => _
     */

    /* This rule always succeeds */
    keep = instr = instr->next;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 98: /* fadd/4 */

    /*
     * Line beam/jit/x86/ops.tab(1039):
     *   fadd p FR1 FR2 FR3 => i_fadd FR1 FR2 FR3
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 512) == 0) { /* p  */
      return TE_FAIL;
    }
    v0 = instr->a[1]; /* FR1 */
    v1 = instr->a[2]; /* FR2 */
    v2 = instr->a[3]; /* FR3 */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 320;
    instr->arity = 3;
    instr->a[0] = v0; /* FR1 */
    instr->a[1] = v1; /* FR2 */
    instr->a[2] = v2; /* FR3 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 101: /* fdiv/4 */

    /*
     * Line beam/jit/x86/ops.tab(1042):
     *   fdiv p FR1 FR2 FR3 => i_fdiv FR1 FR2 FR3
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 512) == 0) { /* p  */
      return TE_FAIL;
    }
    v0 = instr->a[1]; /* FR1 */
    v1 = instr->a[2]; /* FR2 */
    v2 = instr->a[3]; /* FR3 */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 323;
    instr->arity = 3;
    instr->a[0] = v0; /* FR1 */
    instr->a[1] = v1; /* FR2 */
    instr->a[2] = v2; /* FR3 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 96: /* fmove/2 */

    /*
     * Line beam/jit/x86/ops.tab(1045):
     *   fmove Arg=l Dst=d => fstore Arg Dst
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 4096) == 0) { /* l  */
      goto fail96;
    }
    v0 = instr->a[0]; /* Arg */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* d  */
      goto fail96;
    }
    v1 = instr->a[1]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 318;
    instr->arity = 2;
    instr->a[0] = v0; /* Arg */
    instr->a[1] = v1; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1046):
     *   fmove Arg=dq Dst=l => fload Arg Dst
     */

  fail96:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 8216) == 0) { /* d q  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Arg */
    /* Test type */
    if (((1 << instr->a[1].type) & 4096) == 0) { /* l  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 319;
    instr->arity = 2;
    instr->a[0] = v0; /* Arg */
    instr->a[1] = v1; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 100: /* fmul/4 */

    /*
     * Line beam/jit/x86/ops.tab(1041):
     *   fmul p FR1 FR2 FR3 => i_fmul FR1 FR2 FR3
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 512) == 0) { /* p  */
      return TE_FAIL;
    }
    v0 = instr->a[1]; /* FR1 */
    v1 = instr->a[2]; /* FR2 */
    v2 = instr->a[3]; /* FR3 */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 322;
    instr->arity = 3;
    instr->a[0] = v0; /* FR1 */
    instr->a[1] = v1; /* FR2 */
    instr->a[2] = v2; /* FR3 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 102: /* fnegate/3 */

    /*
     * Line beam/jit/x86/ops.tab(1043):
     *   fnegate p FR1 FR2 => i_fnegate FR1 FR2
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 512) == 0) { /* p  */
      return TE_FAIL;
    }
    v0 = instr->a[1]; /* FR1 */
    v1 = instr->a[2]; /* FR2 */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 324;
    instr->arity = 2;
    instr->a[0] = v0; /* FR1 */
    instr->a[1] = v1; /* FR2 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 99: /* fsub/4 */

    /*
     * Line beam/jit/x86/ops.tab(1040):
     *   fsub p FR1 FR2 FR3 => i_fsub FR1 FR2 FR3
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 512) == 0) { /* p  */
      return TE_FAIL;
    }
    v0 = instr->a[1]; /* FR1 */
    v1 = instr->a[2]; /* FR2 */
    v2 = instr->a[3]; /* FR3 */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 321;
    instr->arity = 3;
    instr->a[0] = v0; /* FR1 */
    instr->a[1] = v1; /* FR2 */
    instr->a[2] = v2; /* FR3 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 2: /* func_info/3 */

    /*
     * Line beam/jit/x86/ops.tab(37):
     *   func_info a a u | never() => _
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 4) == 0) { /* a  */
      return TE_FAIL;
    }
    /* Test type */
    if (((1 << instr->a[1].type) & 4) == 0) { /* a  */
      return TE_FAIL;
    }
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    /* Call predicate never() */
    if (!never(st)) {
      return TE_FAIL;
    }
    /* This rule succeeds */
    keep = instr = instr->next;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 195: /* func_line/1 */

    /*
     * Line beam/jit/x86/ops.tab(86):
     *   func_line n => empty_func_line
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 256) == 0) { /* n  */
      return TE_FAIL;
    }
    /* Rename instruction keeping the arguments */
    instr->op = 194;
    instr->arity = 0;
    return TE_OK;

    case 124: /* gc_bif1/5 */

    /*
     * Line beam/jit/x86/ops.tab(717):
     *   gc_bif1 Fail _Live Bif=u$bif:erlang:bit_size/1 Src Dst=d => bif_bit_size Bif Fail Src Dst
     */

    v0 = instr->a[0]; /* Fail */
    /* Is variable Bif BIF_bit_size_1? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail103;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail103;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail103; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_bit_size_1]) {
          goto fail103; /* Not BIF_bit_size_1 */
        }

      }
    }
    v2 = instr->a[2]; /* Bif */
    v3 = instr->a[3]; /* Src */
    /* Test type */
    if (((1 << instr->a[4].type) & 24) == 0) { /* d  */
      goto fail103;
    }
    v4 = instr->a[4]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 262;
    instr->arity = 4;
    instr->a[0] = v2; /* Bif */
    instr->a[1] = v0; /* Fail */
    instr->a[2] = v3; /* Src */
    instr->a[3] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(721):
     *   gc_bif1 Fail _Live Bif=u$bif:erlang:byte_size/1 Src Dst=d => bif_byte_size Bif Fail Src Dst
     */

  fail103:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is variable Bif BIF_byte_size_1? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail104;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail104;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail104; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_byte_size_1]) {
          goto fail104; /* Not BIF_byte_size_1 */
        }

      }
    }
    v2 = instr->a[2]; /* Bif */
    v3 = instr->a[3]; /* Src */
    /* Test type */
    if (((1 << instr->a[4].type) & 24) == 0) { /* d  */
      goto fail104;
    }
    v4 = instr->a[4]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 263;
    instr->arity = 4;
    instr->a[0] = v2; /* Bif */
    instr->a[1] = v0; /* Fail */
    instr->a[2] = v3; /* Src */
    instr->a[3] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1134):
     *   gc_bif1 Fail Live u$bif:erlang:splus/1 Src Dst => gen_plus Fail Live Src i Dst
     */

  fail104:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Live */
    /* Is argument 3 BIF_splus_1? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail105;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail105;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail105; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_splus_1]) {
          goto fail105; /* Not BIF_splus_1 */
        }

      }
    }
    v2 = instr->a[3]; /* Src */
    v3 = instr->a[4]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 335;
    instr->arity = 5;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Live */
    instr->a[2] = v2; /* Src */
    /* Store value i=0 */
    instr->a[3].type = TAG_i;
    instr->a[3].val = 0;
    instr->a[4] = v3; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1139):
     *   gc_bif1 Fail _Live u$bif:erlang:sminus/1 Src Dst => i_unary_minus Src Fail Dst
     */

  fail105:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is argument 3 BIF_sminus_1? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail106;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail106;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail106; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_sminus_1]) {
          goto fail106; /* Not BIF_sminus_1 */
        }

      }
    }
    v2 = instr->a[3]; /* Src */
    v3 = instr->a[4]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 339;
    instr->arity = 3;
    instr->a[0] = v2; /* Src */
    instr->a[1] = v0; /* Fail */
    instr->a[2] = v3; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1229):
     *   gc_bif1 Fail _Live u$bif:erlang:bnot/1 Src Dst => i_bnot Fail Src Dst
     */

  fail106:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is argument 3 BIF_bnot_1? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail107;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail107;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail107; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_bnot_1]) {
          goto fail107; /* Not BIF_bnot_1 */
        }

      }
    }
    v2 = instr->a[3]; /* Src */
    v3 = instr->a[4]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 351;
    instr->arity = 3;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v2; /* Src */
    instr->a[2] = v3; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1259):
     *   gc_bif1 Fail=j Live u$bif:erlang:length/1 Src Dst => i_length_setup Fail Live Src | i_length Fail Live Dst
     */

  fail107:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 544) == 0) { /* j  */
      goto fail108;
    }
    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Live */
    /* Is argument 3 BIF_length_1? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail108;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail108;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail108; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_length_1]) {
          goto fail108; /* Not BIF_length_1 */
        }

      }
    }
    v2 = instr->a[3]; /* Src */
    v3 = instr->a[4]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 353;
    instr->arity = 3;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Live */
    instr->a[2] = v3; /* Dst */
    /* Create instruction: i_length_setup/3 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 352;
      instr->arity = 3;
    }
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Live */
    instr->a[2] = v2; /* Src */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1269):
     *   gc_bif1 Fail _Live _Bif=u$bif:erlang:map_size/1 Src Dst=d => bif_map_size Fail Src Dst
     */

  fail108:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is variable _Bif BIF_map_size_1? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail109;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail109;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail109; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_map_size_1]) {
          goto fail109; /* Not BIF_map_size_1 */
        }

      }
    }
    v3 = instr->a[3]; /* Src */
    /* Test type */
    if (((1 << instr->a[4].type) & 24) == 0) { /* d  */
      goto fail109;
    }
    v4 = instr->a[4]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 354;
    instr->arity = 3;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v3; /* Src */
    instr->a[2] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1275):
     *   gc_bif1 Fail _Live Bif Src Dst => i_bif1 Src Fail Bif Dst
     */

  fail109:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    v2 = instr->a[2]; /* Bif */
    v3 = instr->a[3]; /* Src */
    v4 = instr->a[4]; /* Dst */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 275;
    instr->arity = 4;
    instr->a[0] = v3; /* Src */
    instr->a[1] = v0; /* Fail */
    instr->a[2] = v2; /* Bif */
    instr->a[3] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 125: /* gc_bif2/6 */

    /*
     * Line beam/jit/x86/ops.tab(1136):
     *   gc_bif2 Fail Live u$bif:erlang:splus/2 S1 S2 Dst => gen_plus Fail Live S1 S2 Dst
     */

    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Live */
    /* Is argument 3 BIF_splus_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail111;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail111;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail111; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_splus_2]) {
          goto fail111; /* Not BIF_splus_2 */
        }

      }
    }
    v2 = instr->a[3]; /* S1 */
    v3 = instr->a[4]; /* S2 */
    v4 = instr->a[5]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 335;
    instr->arity = 5;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Live */
    instr->a[2] = v2; /* S1 */
    instr->a[3] = v3; /* S2 */
    instr->a[4] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1141):
     *   gc_bif2 Fail Live u$bif:erlang:sminus/2 S1 S2 Dst => gen_minus Fail Live S1 S2 Dst
     */

  fail111:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Live */
    /* Is argument 3 BIF_sminus_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail112;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail112;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail112; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_sminus_2]) {
          goto fail112; /* Not BIF_sminus_2 */
        }

      }
    }
    v2 = instr->a[3]; /* S1 */
    v3 = instr->a[4]; /* S2 */
    v4 = instr->a[5]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 336;
    instr->arity = 5;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Live */
    instr->a[2] = v2; /* S1 */
    instr->a[3] = v3; /* S2 */
    instr->a[4] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Skip 2 rules unless the second instruction is gc_bif2/6.
     */

  fail112:
    instr = first;
    /*
     * Note that the caller of transform_engine() guarantees that
     * there is always a second instruction available.
     */
    ASSERT(instr);
    if (instr->next->op != 125) {
        /* The second instruction is wrong. Skip ahead. */
        goto fail115;
    }

    /*
     * Line beam/jit/x86/ops.tab(1152):
     *   gc_bif2 Fail1 _Live1 u$bif:erlang:stimes/2 S1 S2 Dst1 | gc_bif2 Fail2 _Live2 u$bif:erlang:splus/2 S3 S4 Dst2 | equal(Dst1, S3) | equal(Dst1, Dst2) | equal(Fail1, Fail2) => i_mul_add Fail1 S1 S2 S3 S4 Dst1
     */

    v0 = instr->a[0]; /* Fail1 */
    /* Is argument 3 BIF_stimes_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail114;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail114;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail114; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_stimes_2]) {
          goto fail114; /* Not BIF_stimes_2 */
        }

      }
    }
    v2 = instr->a[3]; /* S1 */
    v3 = instr->a[4]; /* S2 */
    v4 = instr->a[5]; /* Dst1 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 125) { /* gc_bif2/6 */
      goto fail114;
    }
    v5 = instr->a[0]; /* Fail2 */
    /* Is argument 3 BIF_splus_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail114;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail114;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail114; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_splus_2]) {
          goto fail114; /* Not BIF_splus_2 */
        }

      }
    }
    v7 = instr->a[3]; /* S3 */
    v8 = instr->a[4]; /* S4 */
    v9 = instr->a[5]; /* Dst2 */
    /* Call predicate equal() */
    if (!equal(st, v4, v7)) {
      goto fail114;
    }
    /* Call predicate equal() */
    if (!equal(st, v4, v9)) {
      goto fail114;
    }
    /* Call predicate equal() */
    if (!equal(st, v0, v5)) {
      goto fail114;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 340;
    instr->arity = 6;
    instr->a[0] = v0; /* Fail1 */
    instr->a[1] = v2; /* S1 */
    instr->a[2] = v3; /* S2 */
    instr->a[3] = v7; /* S3 */
    instr->a[4] = v8; /* S4 */
    instr->a[5] = v4; /* Dst1 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1159):
     *   gc_bif2 Fail1 _Live1 u$bif:erlang:stimes/2 S1 S2 Dst1 | gc_bif2 Fail2 _Live2 u$bif:erlang:splus/2 S3 S4 Dst2 | equal(Dst1, S4) | equal(Dst1, Dst2) | equal(Fail1, Fail2) => i_mul_add Fail1 S1 S2 S4 S3 Dst1
     */

  fail114:
    instr = first;
    v0 = instr->a[0]; /* Fail1 */
    /* Is argument 3 BIF_stimes_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail115;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail115;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail115; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_stimes_2]) {
          goto fail115; /* Not BIF_stimes_2 */
        }

      }
    }
    v2 = instr->a[3]; /* S1 */
    v3 = instr->a[4]; /* S2 */
    v4 = instr->a[5]; /* Dst1 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 125) { /* gc_bif2/6 */
      goto fail115;
    }
    v5 = instr->a[0]; /* Fail2 */
    /* Is argument 3 BIF_splus_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail115;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail115;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail115; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_splus_2]) {
          goto fail115; /* Not BIF_splus_2 */
        }

      }
    }
    v7 = instr->a[3]; /* S3 */
    v8 = instr->a[4]; /* S4 */
    v9 = instr->a[5]; /* Dst2 */
    /* Call predicate equal() */
    if (!equal(st, v4, v8)) {
      goto fail115;
    }
    /* Call predicate equal() */
    if (!equal(st, v4, v9)) {
      goto fail115;
    }
    /* Call predicate equal() */
    if (!equal(st, v0, v5)) {
      goto fail115;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 340;
    instr->arity = 6;
    instr->a[0] = v0; /* Fail1 */
    instr->a[1] = v2; /* S1 */
    instr->a[2] = v3; /* S2 */
    instr->a[3] = v8; /* S4 */
    instr->a[4] = v7; /* S3 */
    instr->a[5] = v4; /* Dst1 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1162):
     *   gc_bif2 Fail _Live u$bif:erlang:stimes/2 S1 S2 Dst => i_mul_add Fail S1 S2 Dst i Dst
     */

  fail115:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is argument 3 BIF_stimes_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail116;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail116;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail116; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_stimes_2]) {
          goto fail116; /* Not BIF_stimes_2 */
        }

      }
    }
    v2 = instr->a[3]; /* S1 */
    v3 = instr->a[4]; /* S2 */
    v4 = instr->a[5]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 340;
    instr->arity = 6;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v2; /* S1 */
    instr->a[2] = v3; /* S2 */
    instr->a[3] = v4; /* Dst */
    /* Store value i=0 */
    instr->a[4].type = TAG_i;
    instr->a[4].val = 0;
    instr->a[5] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1169):
     *   gc_bif2 Fail _Live u$bif:erlang:div/2 S1 S2 Dst => i_m_div Fail S1 S2 Dst
     */

  fail116:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is argument 3 BIF_div_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail117;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail117;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail117; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_div_2]) {
          goto fail117; /* Not BIF_div_2 */
        }

      }
    }
    v2 = instr->a[3]; /* S1 */
    v3 = instr->a[4]; /* S2 */
    v4 = instr->a[5]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 341;
    instr->arity = 4;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v2; /* S1 */
    instr->a[2] = v3; /* S2 */
    instr->a[3] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Skip 2 rules unless the second instruction is gc_bif2/6.
     */

  fail117:
    instr = first;
    /*
     * Note that the caller of transform_engine() guarantees that
     * there is always a second instruction available.
     */
    ASSERT(instr);
    if (instr->next->op != 125) {
        /* The second instruction is wrong. Skip ahead. */
        goto fail120;
    }

    /*
     * Line beam/jit/x86/ops.tab(1197):
     *   gc_bif2 Fail _Live u$bif:erlang:intdiv/2 LHS1 RHS1 Quotient | gc_bif2 _A _B u$bif:erlang:rem/2 LHS2 RHS2 Remainder | equal(LHS1, LHS2) | equal(RHS1, RHS2) | distinct(LHS1, Quotient) | distinct(RHS1, Quotient) => i_div_rem LHS1 RHS1 Fail Quotient Remainder
     */

    v0 = instr->a[0]; /* Fail */
    /* Is argument 3 BIF_intdiv_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail119;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail119;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail119; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_intdiv_2]) {
          goto fail119; /* Not BIF_intdiv_2 */
        }

      }
    }
    v2 = instr->a[3]; /* LHS1 */
    v3 = instr->a[4]; /* RHS1 */
    v4 = instr->a[5]; /* Quotient */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 125) { /* gc_bif2/6 */
      goto fail119;
    }
    /* Is argument 3 BIF_rem_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail119;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail119;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail119; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_rem_2]) {
          goto fail119; /* Not BIF_rem_2 */
        }

      }
    }
    v7 = instr->a[3]; /* LHS2 */
    v8 = instr->a[4]; /* RHS2 */
    v9 = instr->a[5]; /* Remainder */
    /* Call predicate equal() */
    if (!equal(st, v2, v7)) {
      goto fail119;
    }
    /* Call predicate equal() */
    if (!equal(st, v3, v8)) {
      goto fail119;
    }
    /* Call predicate distinct() */
    if (!distinct(st, v2, v4)) {
      goto fail119;
    }
    /* Call predicate distinct() */
    if (!distinct(st, v3, v4)) {
      goto fail119;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 343;
    instr->arity = 5;
    instr->a[0] = v2; /* LHS1 */
    instr->a[1] = v3; /* RHS1 */
    instr->a[2] = v0; /* Fail */
    instr->a[3] = v4; /* Quotient */
    instr->a[4] = v9; /* Remainder */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1178):
     *   gc_bif2 Fail _Live u$bif:erlang:rem/2 LHS1 RHS1 Remainder | gc_bif2 _A _B u$bif:erlang:intdiv/2 LHS2 RHS2 Quotient | equal(LHS1, LHS2) | equal(RHS1, RHS2) | distinct(LHS1, Remainder) | distinct(RHS1, Remainder) => i_rem_div LHS1 RHS1 Fail Remainder Quotient
     */

  fail119:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is argument 3 BIF_rem_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail120;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail120;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail120; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_rem_2]) {
          goto fail120; /* Not BIF_rem_2 */
        }

      }
    }
    v2 = instr->a[3]; /* LHS1 */
    v3 = instr->a[4]; /* RHS1 */
    v4 = instr->a[5]; /* Remainder */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 125) { /* gc_bif2/6 */
      goto fail120;
    }
    /* Is argument 3 BIF_intdiv_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail120;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail120;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail120; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_intdiv_2]) {
          goto fail120; /* Not BIF_intdiv_2 */
        }

      }
    }
    v7 = instr->a[3]; /* LHS2 */
    v8 = instr->a[4]; /* RHS2 */
    v9 = instr->a[5]; /* Quotient */
    /* Call predicate equal() */
    if (!equal(st, v2, v7)) {
      goto fail120;
    }
    /* Call predicate equal() */
    if (!equal(st, v3, v8)) {
      goto fail120;
    }
    /* Call predicate distinct() */
    if (!distinct(st, v2, v4)) {
      goto fail120;
    }
    /* Call predicate distinct() */
    if (!distinct(st, v3, v4)) {
      goto fail120;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 342;
    instr->arity = 5;
    instr->a[0] = v2; /* LHS1 */
    instr->a[1] = v3; /* RHS1 */
    instr->a[2] = v0; /* Fail */
    instr->a[3] = v4; /* Remainder */
    instr->a[4] = v9; /* Quotient */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1188):
     *   gc_bif2 Fail _Live u$bif:erlang:rem/2 LHS1 RHS1 Remainder | line _Loc | gc_bif2 _A _B u$bif:erlang:intdiv/2 LHS2 RHS2 Quotient | equal(LHS1, LHS2) | equal(RHS1, RHS2) | distinct(LHS1, Remainder) | distinct(RHS1, Remainder) => i_rem_div LHS1 RHS1 Fail Remainder Quotient
     */

  fail120:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is argument 3 BIF_rem_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail121;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail121;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail121; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_rem_2]) {
          goto fail121; /* Not BIF_rem_2 */
        }

      }
    }
    v2 = instr->a[3]; /* LHS1 */
    v3 = instr->a[4]; /* RHS1 */
    v4 = instr->a[5]; /* Remainder */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 153) { /* line/1 */
      goto fail121;
    }
    /* Advance to next instruction */
    instr = instr->next;
    if (instr == NULL) return TE_SHORT_WINDOW;
    if (instr->op != 125) { /* gc_bif2/6 */
      goto fail121;
    }
    /* Is argument 3 BIF_intdiv_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail121;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail121;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail121; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_intdiv_2]) {
          goto fail121; /* Not BIF_intdiv_2 */
        }

      }
    }
    v8 = instr->a[3]; /* LHS2 */
    v9 = instr->a[4]; /* RHS2 */
    v10 = instr->a[5]; /* Quotient */
    /* Call predicate equal() */
    if (!equal(st, v2, v8)) {
      goto fail121;
    }
    /* Call predicate equal() */
    if (!equal(st, v3, v9)) {
      goto fail121;
    }
    /* Call predicate distinct() */
    if (!distinct(st, v2, v4)) {
      goto fail121;
    }
    /* Call predicate distinct() */
    if (!distinct(st, v3, v4)) {
      goto fail121;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 342;
    instr->arity = 5;
    instr->a[0] = v2; /* LHS1 */
    instr->a[1] = v3; /* RHS1 */
    instr->a[2] = v0; /* Fail */
    instr->a[3] = v4; /* Remainder */
    instr->a[4] = v10; /* Quotient */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1207):
     *   gc_bif2 Fail _Live u$bif:erlang:intdiv/2 LHS1 RHS1 Quotient | line _Loc | gc_bif2 _A _B u$bif:erlang:rem/2 LHS2 RHS2 Remainder | equal(LHS1, LHS2) | equal(RHS1, RHS2) | distinct(LHS1, Quotient) | distinct(RHS1, Quotient) => i_div_rem LHS1 RHS1 Fail Quotient Remainder
     */

  fail121:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is argument 3 BIF_intdiv_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail122;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail122;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail122; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_intdiv_2]) {
          goto fail122; /* Not BIF_intdiv_2 */
        }

      }
    }
    v2 = instr->a[3]; /* LHS1 */
    v3 = instr->a[4]; /* RHS1 */
    v4 = instr->a[5]; /* Quotient */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 153) { /* line/1 */
      goto fail122;
    }
    /* Advance to next instruction */
    instr = instr->next;
    if (instr == NULL) return TE_SHORT_WINDOW;
    if (instr->op != 125) { /* gc_bif2/6 */
      goto fail122;
    }
    /* Is argument 3 BIF_rem_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail122;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail122;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail122; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_rem_2]) {
          goto fail122; /* Not BIF_rem_2 */
        }

      }
    }
    v8 = instr->a[3]; /* LHS2 */
    v9 = instr->a[4]; /* RHS2 */
    v10 = instr->a[5]; /* Remainder */
    /* Call predicate equal() */
    if (!equal(st, v2, v8)) {
      goto fail122;
    }
    /* Call predicate equal() */
    if (!equal(st, v3, v9)) {
      goto fail122;
    }
    /* Call predicate distinct() */
    if (!distinct(st, v2, v4)) {
      goto fail122;
    }
    /* Call predicate distinct() */
    if (!distinct(st, v3, v4)) {
      goto fail122;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 343;
    instr->arity = 5;
    instr->a[0] = v2; /* LHS1 */
    instr->a[1] = v3; /* RHS1 */
    instr->a[2] = v0; /* Fail */
    instr->a[3] = v4; /* Quotient */
    instr->a[4] = v10; /* Remainder */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1210):
     *   gc_bif2 Fail _Live u$bif:erlang:intdiv/2 S1 S2 Dst => i_int_div Fail S1 S2 Dst
     */

  fail122:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is argument 3 BIF_intdiv_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail123;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail123;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail123; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_intdiv_2]) {
          goto fail123; /* Not BIF_intdiv_2 */
        }

      }
    }
    v2 = instr->a[3]; /* S1 */
    v3 = instr->a[4]; /* S2 */
    v4 = instr->a[5]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 344;
    instr->arity = 4;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v2; /* S1 */
    instr->a[2] = v3; /* S2 */
    instr->a[3] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1212):
     *   gc_bif2 Fail _Live u$bif:erlang:rem/2 S1 S2 Dst => i_rem S1 S2 Fail Dst
     */

  fail123:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is argument 3 BIF_rem_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail124;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail124;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail124; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_rem_2]) {
          goto fail124; /* Not BIF_rem_2 */
        }

      }
    }
    v2 = instr->a[3]; /* S1 */
    v3 = instr->a[4]; /* S2 */
    v4 = instr->a[5]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 345;
    instr->arity = 4;
    instr->a[0] = v2; /* S1 */
    instr->a[1] = v3; /* S2 */
    instr->a[2] = v0; /* Fail */
    instr->a[3] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1215):
     *   gc_bif2 Fail _Live u$bif:erlang:bsl/2 S1 S2 Dst => i_bsl S1 S2 Fail Dst
     */

  fail124:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is argument 3 BIF_bsl_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail125;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail125;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail125; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_bsl_2]) {
          goto fail125; /* Not BIF_bsl_2 */
        }

      }
    }
    v2 = instr->a[3]; /* S1 */
    v3 = instr->a[4]; /* S2 */
    v4 = instr->a[5]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 346;
    instr->arity = 4;
    instr->a[0] = v2; /* S1 */
    instr->a[1] = v3; /* S2 */
    instr->a[2] = v0; /* Fail */
    instr->a[3] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1217):
     *   gc_bif2 Fail _Live u$bif:erlang:bsr/2 S1 S2 Dst => i_bsr S1 S2 Fail Dst
     */

  fail125:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is argument 3 BIF_bsr_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail126;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail126;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail126; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_bsr_2]) {
          goto fail126; /* Not BIF_bsr_2 */
        }

      }
    }
    v2 = instr->a[3]; /* S1 */
    v3 = instr->a[4]; /* S2 */
    v4 = instr->a[5]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 347;
    instr->arity = 4;
    instr->a[0] = v2; /* S1 */
    instr->a[1] = v3; /* S2 */
    instr->a[2] = v0; /* Fail */
    instr->a[3] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1220):
     *   gc_bif2 Fail _Live u$bif:erlang:band/2 S1 S2 Dst => i_band S1 S2 Fail Dst
     */

  fail126:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is argument 3 BIF_band_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail127;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail127;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail127; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_band_2]) {
          goto fail127; /* Not BIF_band_2 */
        }

      }
    }
    v2 = instr->a[3]; /* S1 */
    v3 = instr->a[4]; /* S2 */
    v4 = instr->a[5]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 348;
    instr->arity = 4;
    instr->a[0] = v2; /* S1 */
    instr->a[1] = v3; /* S2 */
    instr->a[2] = v0; /* Fail */
    instr->a[3] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1223):
     *   gc_bif2 Fail _Live u$bif:erlang:bor/2 S1 S2 Dst => i_bor Fail S1 S2 Dst
     */

  fail127:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is argument 3 BIF_bor_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail128;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail128;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail128; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_bor_2]) {
          goto fail128; /* Not BIF_bor_2 */
        }

      }
    }
    v2 = instr->a[3]; /* S1 */
    v3 = instr->a[4]; /* S2 */
    v4 = instr->a[5]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 349;
    instr->arity = 4;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v2; /* S1 */
    instr->a[2] = v3; /* S2 */
    instr->a[3] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1226):
     *   gc_bif2 Fail _Live u$bif:erlang:bxor/2 S1 S2 Dst => i_bxor Fail S1 S2 Dst
     */

  fail128:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    /* Is argument 3 BIF_bxor_2? */
    ASSERT(instr->a[2].type == TAG_u);
    if (instr->a[2].type != TAG_u) {
      goto fail129;
    } else {
      int i = instr->a[2].val;
      ASSERT(i < st->beam.imports.count);
      if (i >= st->beam.imports.count) {
        goto fail129;
      } else {
        BifEntry *entry = st->bif_imports[i];

        if (!entry) {
          goto fail129; /* Not a BIF */
        }
        if (entry != &bif_table[BIF_bxor_2]) {
          goto fail129; /* Not BIF_bxor_2 */
        }

      }
    }
    v2 = instr->a[3]; /* S1 */
    v3 = instr->a[4]; /* S2 */
    v4 = instr->a[5]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 350;
    instr->arity = 4;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v2; /* S1 */
    instr->a[2] = v3; /* S2 */
    instr->a[3] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1276):
     *   gc_bif2 Fail _Live Bif S1 S2 Dst => i_bif2 S1 S2 Fail Bif Dst
     */

  fail129:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    v2 = instr->a[2]; /* Bif */
    v3 = instr->a[3]; /* S1 */
    v4 = instr->a[4]; /* S2 */
    v5 = instr->a[5]; /* Dst */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 276;
    instr->arity = 5;
    instr->a[0] = v3; /* S1 */
    instr->a[1] = v4; /* S2 */
    instr->a[2] = v0; /* Fail */
    instr->a[3] = v2; /* Bif */
    instr->a[4] = v5; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 152: /* gc_bif3/7 */

    /*
     * Line beam/jit/x86/ops.tab(1277):
     *   gc_bif3 Fail _Live Bif S1 S2 S3 Dst => i_bif3 S1 S2 S3 Fail Bif Dst
     */

    v0 = instr->a[0]; /* Fail */
    v2 = instr->a[2]; /* Bif */
    v3 = instr->a[3]; /* S1 */
    v4 = instr->a[4]; /* S2 */
    v5 = instr->a[5]; /* S3 */
    v6 = instr->a[6]; /* Dst */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 277;
    instr->arity = 6;
    instr->a[0] = v3; /* S1 */
    instr->a[1] = v4; /* S2 */
    instr->a[2] = v5; /* S3 */
    instr->a[3] = v0; /* Fail */
    instr->a[4] = v2; /* Bif */
    instr->a[5] = v6; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 336: /* gen_minus/5 */

    /*
     * Line beam/jit/x86/ops.tab(1166):
     *   gen_minus Fail _Live S1 S2 Dst => i_minus S1 S2 Fail Dst
     */

    v0 = instr->a[0]; /* Fail */
    v2 = instr->a[2]; /* S1 */
    v3 = instr->a[3]; /* S2 */
    v4 = instr->a[4]; /* Dst */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 338;
    instr->arity = 4;
    instr->a[0] = v2; /* S1 */
    instr->a[1] = v3; /* S2 */
    instr->a[2] = v0; /* Fail */
    instr->a[3] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 335: /* gen_plus/5 */

    /*
     * Line beam/jit/x86/ops.tab(1164):
     *   gen_plus Fail _Live S1 S2 Dst => i_plus S1 S2 Fail Dst
     */

    v0 = instr->a[0]; /* Fail */
    v2 = instr->a[2]; /* S1 */
    v3 = instr->a[3]; /* S2 */
    v4 = instr->a[4]; /* Dst */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 337;
    instr->arity = 4;
    instr->a[0] = v2; /* S1 */
    instr->a[1] = v3; /* S2 */
    instr->a[2] = v0; /* Fail */
    instr->a[3] = v4; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 158: /* get_map_elements/3 */

    /*
     * Line beam/jit/x86/ops.tab(1113):
     *   get_map_elements Fail Src Size=u==2 Rest=* => get_map_element(Fail, Src, Size, Rest)
     */

    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Src */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      goto fail134;
    }
    /* Test value */
    if (instr->a[2].val != 2) {
      goto fail134;
    }
    v2 = instr->a[2]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 3;
    rest_args = &instr->a[3];
    /* Call generator get_map_element() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = get_map_element(st, v0, v1, v2, rest_args);

      if (new_instr == NULL) {
        goto fail134;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1115):
     *   get_map_elements Fail Src Size Rest=* | map_key_sort(Size, Rest) => get_map_elements(Fail, Src, Size, Rest)
     */

  fail134:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Src */
    v2 = instr->a[2]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 3;
    rest_args = &instr->a[3];
    /* Call predicate map_key_sort() */
    if (!map_key_sort(st, v2, rest_args)) {
      return TE_FAIL;
    }
    /* Call generator get_map_elements() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = get_map_elements(st, v0, v1, v2, rest_args);

      if (new_instr == NULL) {
        return TE_FAIL;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 66: /* get_tuple_element/3 */

    /*
     * Line beam/jit/x86/ops.tab(265):
     *   get_tuple_element Tuple Pos Dst => load_tuple_ptr Tuple | i_get_tuple_element Tuple Pos Dst | current_tuple Tuple
     */

    v0 = instr->a[0]; /* Tuple */
    v1 = instr->a[1]; /* Pos */
    v2 = instr->a[2]; /* Dst */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 207;
    instr->arity = 2;
    instr->a[0] = v0; /* Tuple */
    /* Create instruction: i_get_tuple_element/3 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 216;
      instr->arity = 3;
    }
    instr->a[0] = v0; /* Tuple */
    instr->a[1] = v1; /* Pos */
    instr->a[2] = v2; /* Dst */
    /* Create instruction: load_tuple_ptr/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 215;
      instr->arity = 1;
    }
    instr->a[0] = v0; /* Tuple */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 157: /* has_map_fields/3 */

    /*
     * Line beam/jit/x86/ops.tab(1108):
     *   has_map_fields Fail Src Size Rest=* => has_map_fields(Fail, Src, Size, Rest)
     */

    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Src */
    v2 = instr->a[2]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 3;
    rest_args = &instr->a[3];
    /* Call generator has_map_fields() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = has_map_fields(st, v0, v1, v2, rest_args);

      if (new_instr == NULL) {
        return TE_FAIL;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 301: /* i_bs_match/2 */

    /*
     * Line beam/jit/x86/ops.tab(883):
     *   i_bs_match Fail Ctx Rest=* | test_heap Need Live => i_bs_match_test_heap Fail Ctx Need Live Rest
     */

    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Ctx */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 2;
    rest_args = &instr->a[2];
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 16) { /* test_heap/2 */
      return TE_FAIL;
    }
    v2 = instr->a[0]; /* Need */
    v3 = instr->a[1]; /* Live */
    /* This rule succeeds */
    keep = instr = instr->next;
    /* Create instruction: i_bs_match_test_heap/4 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 302;
      instr->arity = 4;
    }
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Ctx */
    instr->a[2] = v2; /* Need */
    instr->a[3] = v3; /* Live */
    /* Store dynamic arguments (Rest) */
    ASSERT(instr->a == instr->def_args);
    instr->arity = instr->arity + num_rest_args;
    instr->a = erts_alloc(ERTS_ALC_T_LOADER_TMP,
                          instr->arity * sizeof(BeamOpArg));
    sys_memcpy(instr->a, instr->def_args, 4 * sizeof(BeamOpArg));
    sys_memcpy(instr->a+4, rest_args, num_rest_args*sizeof(BeamOpArg));
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 334: /* i_get_map_element/4 */

    /*
     * Line beam/jit/x86/ops.tab(1124):
     *   i_get_map_element Fail Src=c Key Dst => move Src x | i_get_map_element Fail x Key Dst
     */

    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 8454) == 0) { /* c  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Src */
    v2 = instr->a[2]; /* Key */
    v3 = instr->a[3]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 334;
    instr->arity = 4;
    instr->a[0] = v0; /* Fail */
    /* Store value x=1023 */
    instr->a[1].type = TAG_x;
    instr->a[1].val = 1023;
    instr->a[2] = v2; /* Key */
    instr->a[3] = v3; /* Dst */
    /* Create instruction: move/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 64;
      instr->arity = 2;
    }
    instr->a[0] = v1; /* Src */
    /* Store value x=1023 */
    instr->a[1].type = TAG_x;
    instr->a[1].val = 1023;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 333: /* i_get_map_element_hash/5 */

    /*
     * Line beam/jit/x86/ops.tab(1120):
     *   i_get_map_element_hash Fail Src=c Key Hash Dst => move Src x | i_get_map_element_hash Fail x Key Hash Dst
     */

    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 8454) == 0) { /* c  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Src */
    v2 = instr->a[2]; /* Key */
    v3 = instr->a[3]; /* Hash */
    v4 = instr->a[4]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 333;
    instr->arity = 5;
    instr->a[0] = v0; /* Fail */
    /* Store value x=1023 */
    instr->a[1].type = TAG_x;
    instr->a[1].val = 1023;
    instr->a[2] = v2; /* Key */
    instr->a[3] = v3; /* Hash */
    instr->a[4] = v4; /* Dst */
    /* Create instruction: move/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 64;
      instr->arity = 2;
    }
    instr->a[0] = v1; /* Src */
    /* Store value x=1023 */
    instr->a[1].type = TAG_x;
    instr->a[1].val = 1023;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 216: /* i_get_tuple_element/3 */

    /*
     * Skip 3 rules unless the second instruction is current_tuple/1.
     */

    /*
     * Note that the caller of transform_engine() guarantees that
     * there is always a second instruction available.
     */
    ASSERT(instr);
    if (instr->next->op != 207) {
        /* The second instruction is wrong. Skip ahead. */
        goto fail144;
    }

    /*
     * Line beam/jit/x86/ops.tab(274):
     *   i_get_tuple_element Tuple Pos Tuple2 | current_tuple Tuple3 | equal(Tuple, Tuple2) | equal(Tuple, Tuple3) => i_get_tuple_element Tuple Pos Tuple
     */

    v0 = instr->a[0]; /* Tuple */
    v1 = instr->a[1]; /* Pos */
    v2 = instr->a[2]; /* Tuple2 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 207) { /* current_tuple/1 */
      goto fail142;
    }
    v3 = instr->a[0]; /* Tuple3 */
    /* Call predicate equal() */
    if (!equal(st, v0, v2)) {
      goto fail142;
    }
    /* Call predicate equal() */
    if (!equal(st, v0, v3)) {
      goto fail142;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 216;
    instr->arity = 3;
    instr->a[0] = v0; /* Tuple */
    instr->a[1] = v1; /* Pos */
    instr->a[2] = v0; /* Tuple */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(290):
     *   i_get_tuple_element Tuple Pos1 Dst1 | current_tuple Tuple2 | get_tuple_element Tuple3 Pos2 Dst2 | equal(Tuple, Tuple2) | equal(Tuple, Tuple3) | consecutive_words(Pos1, Dst1, Pos2, Dst2) => get_two_tuple_elements Tuple Pos1 Dst1 Dst2 | current_tuple Tuple Dst2
     */

  fail142:
    instr = first;
    v0 = instr->a[0]; /* Tuple */
    v1 = instr->a[1]; /* Pos1 */
    v2 = instr->a[2]; /* Dst1 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 207) { /* current_tuple/1 */
      goto fail143;
    }
    v3 = instr->a[0]; /* Tuple2 */
    /* Advance to next instruction */
    instr = instr->next;
    if (instr == NULL) return TE_SHORT_WINDOW;
    if (instr->op != 66) { /* get_tuple_element/3 */
      goto fail143;
    }
    v4 = instr->a[0]; /* Tuple3 */
    v5 = instr->a[1]; /* Pos2 */
    v6 = instr->a[2]; /* Dst2 */
    /* Call predicate equal() */
    if (!equal(st, v0, v3)) {
      goto fail143;
    }
    /* Call predicate equal() */
    if (!equal(st, v0, v4)) {
      goto fail143;
    }
    /* Call predicate consecutive_words() */
    if (!consecutive_words(st, v1, v2, v5, v6)) {
      goto fail143;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 208;
    instr->arity = 2;
    instr->a[0] = v0; /* Tuple */
    instr->a[1] = v6; /* Dst2 */
    /* Create instruction: get_two_tuple_elements/4 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 217;
      instr->arity = 4;
    }
    instr->a[0] = v0; /* Tuple */
    instr->a[1] = v1; /* Pos1 */
    instr->a[2] = v2; /* Dst1 */
    instr->a[3] = v6; /* Dst2 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(296):
     *   i_get_tuple_element Tuple Pos1 Dst1 | current_tuple Tuple2 | get_tuple_element Tuple3 Pos2 Dst2 | equal(Tuple, Tuple2) | equal(Tuple, Tuple3) | consecutive_words(Pos1, Dst2, Pos2, Dst1) => get_two_tuple_elements Tuple Pos1 Dst1 Dst2 | current_tuple Tuple Dst2
     */

  fail143:
    instr = first;
    v0 = instr->a[0]; /* Tuple */
    v1 = instr->a[1]; /* Pos1 */
    v2 = instr->a[2]; /* Dst1 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 207) { /* current_tuple/1 */
      goto fail144;
    }
    v3 = instr->a[0]; /* Tuple2 */
    /* Advance to next instruction */
    instr = instr->next;
    if (instr == NULL) return TE_SHORT_WINDOW;
    if (instr->op != 66) { /* get_tuple_element/3 */
      goto fail144;
    }
    v4 = instr->a[0]; /* Tuple3 */
    v5 = instr->a[1]; /* Pos2 */
    v6 = instr->a[2]; /* Dst2 */
    /* Call predicate equal() */
    if (!equal(st, v0, v3)) {
      goto fail144;
    }
    /* Call predicate equal() */
    if (!equal(st, v0, v4)) {
      goto fail144;
    }
    /* Call predicate consecutive_words() */
    if (!consecutive_words(st, v1, v6, v5, v2)) {
      goto fail144;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 208;
    instr->arity = 2;
    instr->a[0] = v0; /* Tuple */
    instr->a[1] = v6; /* Dst2 */
    /* Create instruction: get_two_tuple_elements/4 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 217;
      instr->arity = 4;
    }
    instr->a[0] = v0; /* Tuple */
    instr->a[1] = v1; /* Pos1 */
    instr->a[2] = v2; /* Dst1 */
    instr->a[3] = v6; /* Dst2 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(309):
     *   i_get_tuple_element Tuple Pos Dst | swap Reg1 Reg2 | equal(Dst, Reg1) => get_tuple_element_swap Tuple Pos Dst Reg2
     */

  fail144:
    instr = first;
    v0 = instr->a[0]; /* Tuple */
    v1 = instr->a[1]; /* Pos */
    v2 = instr->a[2]; /* Dst */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 169) { /* swap/2 */
      goto fail145;
    }
    v3 = instr->a[0]; /* Reg1 */
    v4 = instr->a[1]; /* Reg2 */
    /* Call predicate equal() */
    if (!equal(st, v2, v3)) {
      goto fail145;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 218;
    instr->arity = 4;
    instr->a[0] = v0; /* Tuple */
    instr->a[1] = v1; /* Pos */
    instr->a[2] = v2; /* Dst */
    instr->a[3] = v4; /* Reg2 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(312):
     *   i_get_tuple_element Tuple Pos Dst | swap Reg2 Reg1 | equal(Dst, Reg1) => get_tuple_element_swap Tuple Pos Dst Reg2
     */

  fail145:
    instr = first;
    v0 = instr->a[0]; /* Tuple */
    v1 = instr->a[1]; /* Pos */
    v2 = instr->a[2]; /* Dst */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 169) { /* swap/2 */
      return TE_FAIL;
    }
    v3 = instr->a[0]; /* Reg2 */
    v4 = instr->a[1]; /* Reg1 */
    /* Call predicate equal() */
    if (!equal(st, v2, v4)) {
      return TE_FAIL;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 218;
    instr->arity = 4;
    instr->a[0] = v0; /* Tuple */
    instr->a[1] = v1; /* Pos */
    instr->a[2] = v2; /* Dst */
    instr->a[3] = v3; /* Reg2 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 325: /* i_put_map_assoc/4 */

    /*
     * Line beam/jit/x86/ops.tab(1081):
     *   i_put_map_assoc Map Dst Live Size Rest=* | map_key_sort(Size, Rest) => sorted_put_map_assoc Map Dst Live Size Rest
     */

    v0 = instr->a[0]; /* Map */
    v1 = instr->a[1]; /* Dst */
    v2 = instr->a[2]; /* Live */
    v3 = instr->a[3]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 4;
    rest_args = &instr->a[4];
    /* Call predicate map_key_sort() */
    if (!map_key_sort(st, v3, rest_args)) {
      return TE_FAIL;
    }
    /* This rule succeeds */
    keep = instr = instr->next;
    /* Create instruction: sorted_put_map_assoc/4 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 326;
      instr->arity = 4;
    }
    instr->a[0] = v0; /* Map */
    instr->a[1] = v1; /* Dst */
    instr->a[2] = v2; /* Live */
    instr->a[3] = v3; /* Size */
    /* Store dynamic arguments (Rest) */
    ASSERT(instr->a == instr->def_args);
    instr->arity = instr->arity + num_rest_args;
    instr->a = erts_alloc(ERTS_ALC_T_LOADER_TMP,
                          instr->arity * sizeof(BeamOpArg));
    sys_memcpy(instr->a, instr->def_args, 4 * sizeof(BeamOpArg));
    sys_memcpy(instr->a+4, rest_args, num_rest_args*sizeof(BeamOpArg));
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 295: /* int_func_end/2 */

    /*
     * Line beam/jit/x86/ops.tab(862):
     *   int_func_end Func_Label Entry_Label => func_end(Func_Label, Entry_Label)
     */

    v0 = instr->a[0]; /* Func_Label */
    v1 = instr->a[1]; /* Entry_Label */
    /* Call generator func_end() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = func_end(st, v0, v1);

      if (new_instr == NULL) {
        return TE_FAIL;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 294: /* int_func_start/5 */

    /*
     * Skip 2 rules unless the second instruction is label/1.
     */

    /*
     * Note that the caller of transform_engine() guarantees that
     * there is always a second instruction available.
     */
    ASSERT(instr);
    if (instr->next->op != 1) {
        /* The second instruction is wrong. Skip ahead. */
        goto fail151;
    }

    /*
     * Line beam/jit/x86/ops.tab(833):
     *   int_func_start Func_Label Func_Line M F A | label Entry_Label | line Entry_Line => int_func_start Func_Label Func_Line M F A | func_prologue Entry_Label Entry_Line
     */

    v0 = instr->a[0]; /* Func_Label */
    v1 = instr->a[1]; /* Func_Line */
    v2 = instr->a[2]; /* M */
    v3 = instr->a[3]; /* F */
    v4 = instr->a[4]; /* A */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 1) { /* label/1 */
      goto fail150;
    }
    v5 = instr->a[0]; /* Entry_Label */
    /* Advance to next instruction */
    instr = instr->next;
    if (instr == NULL) return TE_SHORT_WINDOW;
    if (instr->op != 153) { /* line/1 */
      goto fail150;
    }
    v6 = instr->a[0]; /* Entry_Line */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 296;
    instr->arity = 2;
    instr->a[0] = v5; /* Entry_Label */
    instr->a[1] = v6; /* Entry_Line */
    /* Create instruction: int_func_start/5 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 294;
      instr->arity = 5;
    }
    instr->a[0] = v0; /* Func_Label */
    instr->a[1] = v1; /* Func_Line */
    instr->a[2] = v2; /* M */
    instr->a[3] = v3; /* F */
    instr->a[4] = v4; /* A */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(838):
     *   int_func_start Func_Label Func_Line M F A | label Entry_Label => int_func_start Func_Label Func_Line M F A | func_prologue Entry_Label n
     */

  fail150:
    instr = first;
    v0 = instr->a[0]; /* Func_Label */
    v1 = instr->a[1]; /* Func_Line */
    v2 = instr->a[2]; /* M */
    v3 = instr->a[3]; /* F */
    v4 = instr->a[4]; /* A */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 1) { /* label/1 */
      goto fail151;
    }
    v5 = instr->a[0]; /* Entry_Label */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 296;
    instr->arity = 2;
    instr->a[0] = v5; /* Entry_Label */
    /* Store value n=0 */
    instr->a[1].type = TAG_n;
    instr->a[1].val = 0;
    /* Create instruction: int_func_start/5 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 294;
      instr->arity = 5;
    }
    instr->a[0] = v0; /* Func_Label */
    instr->a[1] = v1; /* Func_Line */
    instr->a[2] = v2; /* M */
    instr->a[3] = v3; /* F */
    instr->a[4] = v4; /* A */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(849):
     *   int_func_start Func_Label Func_Line M F A | func_prologue Entry_Label Entry_Line | is_mfa_bif(M, F, A) => i_func_label Func_Label | func_line Func_Line | i_func_info Func_Label M F A | aligned_label Entry_Label u=4 | i_breakpoint_trampoline | line Entry_Line | call_bif_mfa M F A
     */

  fail151:
    instr = first;
    v0 = instr->a[0]; /* Func_Label */
    v1 = instr->a[1]; /* Func_Line */
    v2 = instr->a[2]; /* M */
    v3 = instr->a[3]; /* F */
    v4 = instr->a[4]; /* A */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 296) { /* func_prologue/2 */
      goto fail152;
    }
    v5 = instr->a[0]; /* Entry_Label */
    v6 = instr->a[1]; /* Entry_Line */
    /* Call predicate is_mfa_bif() */
    if (!is_mfa_bif(st, v2, v3, v4)) {
      goto fail152;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 241;
    instr->arity = 3;
    instr->a[0] = v2; /* M */
    instr->a[1] = v3; /* F */
    instr->a[2] = v4; /* A */
    /* Create instruction: line/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 153;
      instr->arity = 1;
    }
    instr->a[0] = v6; /* Entry_Line */
    /* Create instruction: i_breakpoint_trampoline/0 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 300;
      instr->arity = 0;
    }
    /* Create instruction: aligned_label/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 185;
      instr->arity = 2;
    }
    instr->a[0] = v5; /* Entry_Label */
    /* Store value u=4 */
    instr->a[1].type = TAG_u;
    instr->a[1].val = 4;
    /* Create instruction: i_func_info/4 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 187;
      instr->arity = 4;
    }
    instr->a[0] = v0; /* Func_Label */
    instr->a[1] = v2; /* M */
    instr->a[2] = v3; /* F */
    instr->a[3] = v4; /* A */
    /* Create instruction: func_line/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 195;
      instr->arity = 1;
    }
    instr->a[0] = v1; /* Func_Line */
    /* Create instruction: i_func_label/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 186;
      instr->arity = 1;
    }
    instr->a[0] = v0; /* Func_Label */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(859):
     *   int_func_start Func_Label Func_Line M F A | func_prologue Entry_Label Entry_Line => i_func_label Func_Label | func_line Func_Line | i_func_info Func_Label M F A | aligned_label Entry_Label u=4 | i_breakpoint_trampoline | line Entry_Line | i_test_yield
     */

  fail152:
    instr = first;
    v0 = instr->a[0]; /* Func_Label */
    v1 = instr->a[1]; /* Func_Line */
    v2 = instr->a[2]; /* M */
    v3 = instr->a[3]; /* F */
    v4 = instr->a[4]; /* A */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 296) { /* func_prologue/2 */
      return TE_FAIL;
    }
    v5 = instr->a[0]; /* Entry_Label */
    v6 = instr->a[1]; /* Entry_Line */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 297;
    instr->arity = 0;
    /* Create instruction: line/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 153;
      instr->arity = 1;
    }
    instr->a[0] = v6; /* Entry_Line */
    /* Create instruction: i_breakpoint_trampoline/0 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 300;
      instr->arity = 0;
    }
    /* Create instruction: aligned_label/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 185;
      instr->arity = 2;
    }
    instr->a[0] = v5; /* Entry_Label */
    /* Store value u=4 */
    instr->a[1].type = TAG_u;
    instr->a[1].val = 4;
    /* Create instruction: i_func_info/4 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 187;
      instr->arity = 4;
    }
    instr->a[0] = v0; /* Func_Label */
    instr->a[1] = v2; /* M */
    instr->a[2] = v3; /* F */
    instr->a[3] = v4; /* A */
    /* Create instruction: func_line/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 195;
      instr->arity = 1;
    }
    instr->a[0] = v1; /* Func_Line */
    /* Create instruction: i_func_label/1 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 186;
      instr->arity = 1;
    }
    instr->a[0] = v0; /* Func_Label */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 48: /* is_atom/2 */

    /*
     * Line beam/jit/x86/ops.tab(147):
     *   is_atom Fail=f S | select_val S2=d Fail2=fn Size=u Rest=* | equal(S, S2) | equal(Fail, Fail2) | fixed_size_values(Size, Rest) => select_val(S, Fail, Size, Rest)
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* S */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 59) { /* select_val/3 */
      return TE_FAIL;
    }
    /* Test type */
    if (((1 << instr->a[0].type) & 24) == 0) { /* d  */
      return TE_FAIL;
    }
    v2 = instr->a[0]; /* S2 */
    /* Test type */
    if (((1 << instr->a[1].type) & 288) == 0) { /* f n  */
      return TE_FAIL;
    }
    v3 = instr->a[1]; /* Fail2 */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v4 = instr->a[2]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 3;
    rest_args = &instr->a[3];
    /* Call predicate equal() */
    if (!equal(st, v1, v2)) {
      return TE_FAIL;
    }
    /* Call predicate equal() */
    if (!equal(st, v0, v3)) {
      return TE_FAIL;
    }
    /* Call predicate fixed_size_values() */
    if (!fixed_size_values(st, v4, rest_args)) {
      return TE_FAIL;
    }
    /* Call generator select_val() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = select_val(st, v1, v0, v4, rest_args);

      if (new_instr == NULL) {
        return TE_FAIL;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 129: /* is_bitstr/2 */

    /*
     * Line beam/jit/x86/ops.tab(540):
     *   is_bitstr Fail Term => is_bitstring Fail Term
     */

    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Term */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 245;
    instr->arity = 2;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Term */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 41: /* is_eq/3 */

    /*
     * Line beam/jit/x86/ops.tab(475):
     *   is_eq Fail=f Const=c Reg=xy => is_eq Fail Reg Const
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 8454) == 0) { /* c  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Const */
    /* Test type */
    if (((1 << instr->a[2].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    v2 = instr->a[2]; /* Reg */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 41;
    instr->arity = 3;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v2; /* Reg */
    instr->a[2] = v1; /* Const */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 43: /* is_eq_exact/3 */

    /*
     * Line beam/jit/x86/ops.tab(425):
     *   is_eq_exact _Lbl LHS RHS | equal(LHS, RHS) => _
     */

    v1 = instr->a[1]; /* LHS */
    v2 = instr->a[2]; /* RHS */
    /* Call predicate equal() */
    if (!equal(st, v1, v2)) {
      goto fail157;
    }
    /* This rule succeeds */
    keep = instr = instr->next;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(426):
     *   is_eq_exact Lbl C=c R=xy => is_eq_exact Lbl R C
     */

  fail157:
    instr = first;
    v0 = instr->a[0]; /* Lbl */
    /* Test type */
    if (((1 << instr->a[1].type) & 8454) == 0) { /* c  */
      goto fail158;
    }
    v1 = instr->a[1]; /* C */
    /* Test type */
    if (((1 << instr->a[2].type) & 24) == 0) { /* x y  */
      goto fail158;
    }
    v2 = instr->a[2]; /* R */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 43;
    instr->arity = 3;
    instr->a[0] = v0; /* Lbl */
    instr->a[1] = v2; /* R */
    instr->a[2] = v1; /* C */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(428):
     *   is_eq_exact Lbl R=xy n => is_nil Lbl R
     */

  fail158:
    instr = first;
    v0 = instr->a[0]; /* Lbl */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* R */
    /* Test type */
    if (((1 << instr->a[2].type) & 256) == 0) { /* n  */
      return TE_FAIL;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 52;
    instr->arity = 2;
    instr->a[0] = v0; /* Lbl */
    instr->a[1] = v1; /* R */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 77: /* is_function/2 */

    /*
     * Line beam/jit/x86/ops.tab(822):
     *   is_function Fail=f c => jump Fail
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 8454) == 0) { /* c  */
      return TE_FAIL;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 61;
    instr->arity = 1;
    instr->a[0] = v0; /* Fail */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 40: /* is_ge/3 */

    /*
     * Skip 3 rules unless the second instruction is is_ge/3.
     */

    /*
     * Note that the caller of transform_engine() guarantees that
     * there is always a second instruction available.
     */
    ASSERT(instr);
    if (instr->next->op != 40) {
        /* The second instruction is wrong. Skip ahead. */
        goto fail164;
    }

    /*
     * Line beam/jit/x86/ops.tab(455):
     *   is_ge Small N1=xy Min=i | is_ge Large Max=i N2=xy | equal(N1, N2) => is_in_range Small Large N1 Min Max
     */

    v0 = instr->a[0]; /* Small */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      goto fail162;
    }
    v1 = instr->a[1]; /* N1 */
    /* Test type */
    if (((1 << instr->a[2].type) & 2) == 0) { /* i  */
      goto fail162;
    }
    v2 = instr->a[2]; /* Min */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 40) { /* is_ge/3 */
      goto fail162;
    }
    v3 = instr->a[0]; /* Large */
    /* Test type */
    if (((1 << instr->a[1].type) & 2) == 0) { /* i  */
      goto fail162;
    }
    v4 = instr->a[1]; /* Max */
    /* Test type */
    if (((1 << instr->a[2].type) & 24) == 0) { /* x y  */
      goto fail162;
    }
    v5 = instr->a[2]; /* N2 */
    /* Call predicate equal() */
    if (!equal(st, v1, v5)) {
      goto fail162;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 232;
    instr->arity = 5;
    instr->a[0] = v0; /* Small */
    instr->a[1] = v3; /* Large */
    instr->a[2] = v1; /* N1 */
    instr->a[3] = v2; /* Min */
    instr->a[4] = v4; /* Max */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(468):
     *   is_ge Fail1 N1=xy A=i | is_ge Fail2 N2=xy B=i | equal(N1, N2) => is_ge_ge Fail1 Fail2 N1 A B
     */

  fail162:
    instr = first;
    v0 = instr->a[0]; /* Fail1 */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      goto fail163;
    }
    v1 = instr->a[1]; /* N1 */
    /* Test type */
    if (((1 << instr->a[2].type) & 2) == 0) { /* i  */
      goto fail163;
    }
    v2 = instr->a[2]; /* A */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 40) { /* is_ge/3 */
      goto fail163;
    }
    v3 = instr->a[0]; /* Fail2 */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      goto fail163;
    }
    v4 = instr->a[1]; /* N2 */
    /* Test type */
    if (((1 << instr->a[2].type) & 2) == 0) { /* i  */
      goto fail163;
    }
    v5 = instr->a[2]; /* B */
    /* Call predicate equal() */
    if (!equal(st, v1, v4)) {
      goto fail163;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 234;
    instr->arity = 5;
    instr->a[0] = v0; /* Fail1 */
    instr->a[1] = v3; /* Fail2 */
    instr->a[2] = v1; /* N1 */
    instr->a[3] = v2; /* A */
    instr->a[4] = v5; /* B */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(458):
     *   is_ge Large Max=i N2=xy | is_ge Small N1=xy Min=i | equal(N1, N2) => is_in_range Small Large N2 Min Max
     */

  fail163:
    instr = first;
    v0 = instr->a[0]; /* Large */
    /* Test type */
    if (((1 << instr->a[1].type) & 2) == 0) { /* i  */
      goto fail164;
    }
    v1 = instr->a[1]; /* Max */
    /* Test type */
    if (((1 << instr->a[2].type) & 24) == 0) { /* x y  */
      goto fail164;
    }
    v2 = instr->a[2]; /* N2 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 40) { /* is_ge/3 */
      goto fail164;
    }
    v3 = instr->a[0]; /* Small */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      goto fail164;
    }
    v4 = instr->a[1]; /* N1 */
    /* Test type */
    if (((1 << instr->a[2].type) & 2) == 0) { /* i  */
      goto fail164;
    }
    v5 = instr->a[2]; /* Min */
    /* Call predicate equal() */
    if (!equal(st, v4, v2)) {
      goto fail164;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 232;
    instr->arity = 5;
    instr->a[0] = v3; /* Small */
    instr->a[1] = v0; /* Large */
    instr->a[2] = v2; /* N2 */
    instr->a[3] = v5; /* Min */
    instr->a[4] = v1; /* Max */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(463):
     *   is_ge Small N1=xy A=i | is_lt Large B=i N2=xy | equal(N1, N2) => is_ge_lt Small Large N1 A B
     */

  fail164:
    instr = first;
    v0 = instr->a[0]; /* Small */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* N1 */
    /* Test type */
    if (((1 << instr->a[2].type) & 2) == 0) { /* i  */
      return TE_FAIL;
    }
    v2 = instr->a[2]; /* A */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 39) { /* is_lt/3 */
      return TE_FAIL;
    }
    v3 = instr->a[0]; /* Large */
    /* Test type */
    if (((1 << instr->a[1].type) & 2) == 0) { /* i  */
      return TE_FAIL;
    }
    v4 = instr->a[1]; /* B */
    /* Test type */
    if (((1 << instr->a[2].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    v5 = instr->a[2]; /* N2 */
    /* Call predicate equal() */
    if (!equal(st, v1, v5)) {
      return TE_FAIL;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 233;
    instr->arity = 5;
    instr->a[0] = v0; /* Small */
    instr->a[1] = v3; /* Large */
    instr->a[2] = v1; /* N1 */
    instr->a[3] = v2; /* A */
    instr->a[4] = v4; /* B */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 45: /* is_integer/2 */

    /*
     * Skip 3 rules unless the second instruction is select_val/3.
     */

    /*
     * Note that the caller of transform_engine() guarantees that
     * there is always a second instruction available.
     */
    ASSERT(instr);
    if (instr->next->op != 59) {
        /* The second instruction is wrong. Skip ahead. */
        goto fail169;
    }

    /*
     * Line beam/jit/x86/ops.tab(129):
     *   is_integer Fail=f S | select_val S2=s Fail2=fn Size=u Rest=* | equal(S, S2) | equal(Fail, Fail2) | use_jump_tab(Size, Rest, 6) => jump_tab(S, Fail, Size, Rest)
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      goto fail167;
    }
    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* S */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 59) { /* select_val/3 */
      goto fail167;
    }
    /* Test type */
    if (((1 << instr->a[0].type) & 8478) == 0) { /* s  */
      goto fail167;
    }
    v2 = instr->a[0]; /* S2 */
    /* Test type */
    if (((1 << instr->a[1].type) & 288) == 0) { /* f n  */
      goto fail167;
    }
    v3 = instr->a[1]; /* Fail2 */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      goto fail167;
    }
    v4 = instr->a[2]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 3;
    rest_args = &instr->a[3];
    /* Call predicate equal() */
    if (!equal(st, v1, v2)) {
      goto fail167;
    }
    /* Call predicate equal() */
    if (!equal(st, v0, v3)) {
      goto fail167;
    }
    /* Call predicate use_jump_tab() */
    if (!use_jump_tab(st, v4, rest_args, 6)) {
      goto fail167;
    }
    /* Call generator jump_tab() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = jump_tab(st, v1, v0, v4, rest_args);

      if (new_instr == NULL) {
        goto fail167;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(134):
     *   is_integer TypeFail=f S | select_val S2=s Fail=fn Size=u Rest=* | equal(S, S2) | mixed_types(Size, Rest) => split_values(S, TypeFail, Fail, Size, Rest)
     */

  fail167:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      goto fail168;
    }
    v0 = instr->a[0]; /* TypeFail */
    v1 = instr->a[1]; /* S */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 59) { /* select_val/3 */
      goto fail168;
    }
    /* Test type */
    if (((1 << instr->a[0].type) & 8478) == 0) { /* s  */
      goto fail168;
    }
    v2 = instr->a[0]; /* S2 */
    /* Test type */
    if (((1 << instr->a[1].type) & 288) == 0) { /* f n  */
      goto fail168;
    }
    v3 = instr->a[1]; /* Fail */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      goto fail168;
    }
    v4 = instr->a[2]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 3;
    rest_args = &instr->a[3];
    /* Call predicate equal() */
    if (!equal(st, v1, v2)) {
      goto fail168;
    }
    /* Call predicate mixed_types() */
    if (!mixed_types(st, v4, rest_args)) {
      goto fail168;
    }
    /* Call generator split_values() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = split_values(st, v1, v0, v3, v4, rest_args);

      if (new_instr == NULL) {
        goto fail168;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(142):
     *   is_integer Fail=f S | select_val S2=d Fail2=fn Size=u Rest=* | equal(S, S2) | equal(Fail, Fail2) | fixed_size_values(Size, Rest) => select_val(S, Fail, Size, Rest)
     */

  fail168:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      goto fail169;
    }
    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* S */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 59) { /* select_val/3 */
      goto fail169;
    }
    /* Test type */
    if (((1 << instr->a[0].type) & 24) == 0) { /* d  */
      goto fail169;
    }
    v2 = instr->a[0]; /* S2 */
    /* Test type */
    if (((1 << instr->a[1].type) & 288) == 0) { /* f n  */
      goto fail169;
    }
    v3 = instr->a[1]; /* Fail2 */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      goto fail169;
    }
    v4 = instr->a[2]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 3;
    rest_args = &instr->a[3];
    /* Call predicate equal() */
    if (!equal(st, v1, v2)) {
      goto fail169;
    }
    /* Call predicate equal() */
    if (!equal(st, v0, v3)) {
      goto fail169;
    }
    /* Call predicate fixed_size_values() */
    if (!fixed_size_values(st, v4, rest_args)) {
      goto fail169;
    }
    /* Call generator select_val() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = select_val(st, v1, v0, v4, rest_args);

      if (new_instr == NULL) {
        goto fail169;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(440):
     *   is_integer NotInt N0 | is_ge Small N1=xy Min=i | is_ge Large Max=i N2=xy | equal(N0, N1) | equal(N1, N2) | equal(NotInt, Small) | equal(Small, Large) => is_int_in_range NotInt N0 Min Max
     */

  fail169:
    instr = first;
    v0 = instr->a[0]; /* NotInt */
    v1 = instr->a[1]; /* N0 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 40) { /* is_ge/3 */
      goto fail170;
    }
    v2 = instr->a[0]; /* Small */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      goto fail170;
    }
    v3 = instr->a[1]; /* N1 */
    /* Test type */
    if (((1 << instr->a[2].type) & 2) == 0) { /* i  */
      goto fail170;
    }
    v4 = instr->a[2]; /* Min */
    /* Advance to next instruction */
    instr = instr->next;
    if (instr == NULL) return TE_SHORT_WINDOW;
    if (instr->op != 40) { /* is_ge/3 */
      goto fail170;
    }
    v5 = instr->a[0]; /* Large */
    /* Test type */
    if (((1 << instr->a[1].type) & 2) == 0) { /* i  */
      goto fail170;
    }
    v6 = instr->a[1]; /* Max */
    /* Test type */
    if (((1 << instr->a[2].type) & 24) == 0) { /* x y  */
      goto fail170;
    }
    v7 = instr->a[2]; /* N2 */
    /* Call predicate equal() */
    if (!equal(st, v1, v3)) {
      goto fail170;
    }
    /* Call predicate equal() */
    if (!equal(st, v3, v7)) {
      goto fail170;
    }
    /* Call predicate equal() */
    if (!equal(st, v0, v2)) {
      goto fail170;
    }
    /* Call predicate equal() */
    if (!equal(st, v2, v5)) {
      goto fail170;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 230;
    instr->arity = 4;
    instr->a[0] = v0; /* NotInt */
    instr->a[1] = v1; /* N0 */
    instr->a[2] = v4; /* Min */
    instr->a[3] = v6; /* Max */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Skip 2 rules unless the second instruction is is_ge/3.
     */

  fail170:
    instr = first;
    /*
     * Note that the caller of transform_engine() guarantees that
     * there is always a second instruction available.
     */
    ASSERT(instr);
    if (instr->next->op != 40) {
        /* The second instruction is wrong. Skip ahead. */
        goto fail173;
    }

    /*
     * Line beam/jit/x86/ops.tab(445):
     *   is_integer NotInt N0 | is_ge Large Max=i N2=xy | is_ge Small N1=xy Min=i | equal(N0, N1) | equal(N1, N2) | equal(NotInt, Small) | equal(Small, Large) => is_int_in_range NotInt N0 Min Max
     */

    v0 = instr->a[0]; /* NotInt */
    v1 = instr->a[1]; /* N0 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 40) { /* is_ge/3 */
      goto fail172;
    }
    v2 = instr->a[0]; /* Large */
    /* Test type */
    if (((1 << instr->a[1].type) & 2) == 0) { /* i  */
      goto fail172;
    }
    v3 = instr->a[1]; /* Max */
    /* Test type */
    if (((1 << instr->a[2].type) & 24) == 0) { /* x y  */
      goto fail172;
    }
    v4 = instr->a[2]; /* N2 */
    /* Advance to next instruction */
    instr = instr->next;
    if (instr == NULL) return TE_SHORT_WINDOW;
    if (instr->op != 40) { /* is_ge/3 */
      goto fail172;
    }
    v5 = instr->a[0]; /* Small */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      goto fail172;
    }
    v6 = instr->a[1]; /* N1 */
    /* Test type */
    if (((1 << instr->a[2].type) & 2) == 0) { /* i  */
      goto fail172;
    }
    v7 = instr->a[2]; /* Min */
    /* Call predicate equal() */
    if (!equal(st, v1, v6)) {
      goto fail172;
    }
    /* Call predicate equal() */
    if (!equal(st, v6, v4)) {
      goto fail172;
    }
    /* Call predicate equal() */
    if (!equal(st, v0, v5)) {
      goto fail172;
    }
    /* Call predicate equal() */
    if (!equal(st, v5, v2)) {
      goto fail172;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 230;
    instr->arity = 4;
    instr->a[0] = v0; /* NotInt */
    instr->a[1] = v1; /* N0 */
    instr->a[2] = v7; /* Min */
    instr->a[3] = v3; /* Max */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(449):
     *   is_integer NotInt N0 | is_ge Fail N1=xy Min=i | equal(N0, N1) | equal(NotInt, Fail) => is_int_ge NotInt N0 Min
     */

  fail172:
    instr = first;
    v0 = instr->a[0]; /* NotInt */
    v1 = instr->a[1]; /* N0 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 40) { /* is_ge/3 */
      return TE_FAIL;
    }
    v2 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    v3 = instr->a[1]; /* N1 */
    /* Test type */
    if (((1 << instr->a[2].type) & 2) == 0) { /* i  */
      return TE_FAIL;
    }
    v4 = instr->a[2]; /* Min */
    /* Call predicate equal() */
    if (!equal(st, v1, v3)) {
      return TE_FAIL;
    }
    /* Call predicate equal() */
    if (!equal(st, v0, v2)) {
      return TE_FAIL;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 231;
    instr->arity = 3;
    instr->a[0] = v0; /* NotInt */
    instr->a[1] = v1; /* N0 */
    instr->a[2] = v4; /* Min */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;
  fail173:
    instr = first;
/* Fail transformation */
return TE_FAIL;

    case 42: /* is_ne/3 */

    /*
     * Line beam/jit/x86/ops.tab(478):
     *   is_ne Fail=f Const=c Reg=xy => is_ne Fail Reg Const
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 8454) == 0) { /* c  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Const */
    /* Test type */
    if (((1 << instr->a[2].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    v2 = instr->a[2]; /* Reg */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 42;
    instr->arity = 3;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v2; /* Reg */
    instr->a[2] = v1; /* Const */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 44: /* is_ne_exact/3 */

    /*
     * Line beam/jit/x86/ops.tab(430):
     *   is_ne_exact Lbl LHS RHS | equal(LHS, RHS) => jump Lbl
     */

    v0 = instr->a[0]; /* Lbl */
    v1 = instr->a[1]; /* LHS */
    v2 = instr->a[2]; /* RHS */
    /* Call predicate equal() */
    if (!equal(st, v1, v2)) {
      goto fail176;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 61;
    instr->arity = 1;
    instr->a[0] = v0; /* Lbl */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(431):
     *   is_ne_exact Lbl C=c R=xy => is_ne_exact Lbl R C
     */

  fail176:
    instr = first;
    v0 = instr->a[0]; /* Lbl */
    /* Test type */
    if (((1 << instr->a[1].type) & 8454) == 0) { /* c  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* C */
    /* Test type */
    if (((1 << instr->a[2].type) & 24) == 0) { /* x y  */
      return TE_FAIL;
    }
    v2 = instr->a[2]; /* R */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 44;
    instr->arity = 3;
    instr->a[0] = v0; /* Lbl */
    instr->a[1] = v2; /* R */
    instr->a[2] = v1; /* C */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 52: /* is_nil/2 */

    /*
     * Line beam/jit/x86/ops.tab(535):
     *   is_nil _Fail=f n => _
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      goto fail178;
    }
    /* Test type */
    if (((1 << instr->a[1].type) & 256) == 0) { /* n  */
      goto fail178;
    }
    /* This rule succeeds */
    keep = instr = instr->next;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(536):
     *   is_nil Fail=f qia => jump Fail
     */

  fail178:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 8198) == 0) { /* q i a  */
      return TE_FAIL;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 61;
    instr->arity = 1;
    instr->a[0] = v0; /* Fail */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 56: /* is_nonempty_list/2 */

    /*
     * Line beam/jit/x86/ops.tab(179):
     *   is_nonempty_list Fail nqia => jump Fail
     */

    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 8454) == 0) { /* n q i a  */
      goto fail180;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 61;
    instr->arity = 1;
    instr->a[0] = v0; /* Fail */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(182):
     *   is_nonempty_list Fail Src | get_list Src2 Hd Tl | equal(Src, Src2) => is_nonempty_list_get_list Fail Src Hd Tl
     */

  fail180:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Src */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 65) { /* get_list/3 */
      goto fail181;
    }
    v2 = instr->a[0]; /* Src2 */
    v3 = instr->a[1]; /* Hd */
    v4 = instr->a[2]; /* Tl */
    /* Call predicate equal() */
    if (!equal(st, v1, v2)) {
      goto fail181;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 203;
    instr->arity = 4;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Src */
    instr->a[2] = v3; /* Hd */
    instr->a[3] = v4; /* Tl */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(185):
     *   is_nonempty_list Fail Src | get_hd Src2 Hd | equal(Src, Src2) => is_nonempty_list_get_hd Fail Src Hd
     */

  fail181:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Src */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 162) { /* get_hd/2 */
      goto fail182;
    }
    v2 = instr->a[0]; /* Src2 */
    v3 = instr->a[1]; /* Hd */
    /* Call predicate equal() */
    if (!equal(st, v1, v2)) {
      goto fail182;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 204;
    instr->arity = 3;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Src */
    instr->a[2] = v3; /* Hd */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(188):
     *   is_nonempty_list Fail Src | get_tl Src2 Tl | equal(Src, Src2) => is_nonempty_list_get_tl Fail Src Tl
     */

  fail182:
    instr = first;
    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Src */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 163) { /* get_tl/2 */
      return TE_FAIL;
    }
    v2 = instr->a[0]; /* Src2 */
    v3 = instr->a[1]; /* Tl */
    /* Call predicate equal() */
    if (!equal(st, v1, v2)) {
      return TE_FAIL;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 205;
    instr->arity = 3;
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Src */
    instr->a[2] = v3; /* Tl */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 159: /* is_tagged_tuple/4 */

    /*
     * Line beam/jit/x86/ops.tab(246):
     *   is_tagged_tuple Fail Tuple Arity Atom => i_is_tagged_tuple Fail Tuple Arity Atom | current_tuple Tuple
     */

    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Tuple */
    v2 = instr->a[2]; /* Arity */
    v3 = instr->a[3]; /* Atom */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 207;
    instr->arity = 2;
    instr->a[0] = v1; /* Tuple */
    /* Create instruction: i_is_tagged_tuple/4 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 212;
      instr->arity = 4;
    }
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Tuple */
    instr->a[2] = v2; /* Arity */
    instr->a[3] = v3; /* Atom */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 57: /* is_tuple/2 */

    /*
     * Line beam/jit/x86/ops.tab(157):
     *   is_tuple Fail=f S | select_tuple_arity S2=d Fail2=f Size=u Rest=* | equal(S, S2) | equal(Fail, Fail2) => select_tuple_arity(S, Fail, Size, Rest)
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      goto fail185;
    }
    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* S */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 60) { /* select_tuple_arity/3 */
      goto fail185;
    }
    /* Test type */
    if (((1 << instr->a[0].type) & 24) == 0) { /* d  */
      goto fail185;
    }
    v2 = instr->a[0]; /* S2 */
    /* Test type */
    if (((1 << instr->a[1].type) & 32) == 0) { /* f  */
      goto fail185;
    }
    v3 = instr->a[1]; /* Fail2 */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      goto fail185;
    }
    v4 = instr->a[2]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 3;
    rest_args = &instr->a[3];
    /* Call predicate equal() */
    if (!equal(st, v1, v2)) {
      goto fail185;
    }
    /* Call predicate equal() */
    if (!equal(st, v0, v3)) {
      goto fail185;
    }
    /* Call generator select_tuple_arity() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = select_tuple_arity(st, v1, v0, v4, rest_args);

      if (new_instr == NULL) {
        goto fail185;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Skip 2 rules unless the second instruction is test_arity/3.
     */

  fail185:
    instr = first;
    /*
     * Note that the caller of transform_engine() guarantees that
     * there is always a second instruction available.
     */
    ASSERT(instr);
    if (instr->next->op != 58) {
        /* The second instruction is wrong. Skip ahead. */
        goto fail188;
    }

    /*
     * Line beam/jit/x86/ops.tab(231):
     *   is_tuple Fail=f Src | test_arity Fail2 Src2 Arity | equal(Fail, Fail2) | equal(Src, Src2) => i_is_tuple_of_arity Fail Src Arity | current_tuple Src
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      goto fail187;
    }
    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Src */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 58) { /* test_arity/3 */
      goto fail187;
    }
    v2 = instr->a[0]; /* Fail2 */
    v3 = instr->a[1]; /* Src2 */
    v4 = instr->a[2]; /* Arity */
    /* Call predicate equal() */
    if (!equal(st, v0, v2)) {
      goto fail187;
    }
    /* Call predicate equal() */
    if (!equal(st, v1, v3)) {
      goto fail187;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 207;
    instr->arity = 2;
    instr->a[0] = v1; /* Src */
    /* Create instruction: i_is_tuple_of_arity/3 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 209;
      instr->arity = 3;
    }
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Src */
    instr->a[2] = v4; /* Arity */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(235):
     *   is_tuple Fail1=f Src | test_arity Fail2 Src2 Arity | equal(Src, Src2) => i_is_tuple_of_arity_ff Fail1 Fail2 Src Arity | current_tuple Src
     */

  fail187:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      goto fail188;
    }
    v0 = instr->a[0]; /* Fail1 */
    v1 = instr->a[1]; /* Src */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 58) { /* test_arity/3 */
      goto fail188;
    }
    v2 = instr->a[0]; /* Fail2 */
    v3 = instr->a[1]; /* Src2 */
    v4 = instr->a[2]; /* Arity */
    /* Call predicate equal() */
    if (!equal(st, v1, v3)) {
      goto fail188;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 207;
    instr->arity = 2;
    instr->a[0] = v1; /* Src */
    /* Create instruction: i_is_tuple_of_arity_ff/4 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 210;
      instr->arity = 4;
    }
    instr->a[0] = v0; /* Fail1 */
    instr->a[1] = v2; /* Fail2 */
    instr->a[2] = v1; /* Src */
    instr->a[3] = v4; /* Arity */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(243):
     *   is_tuple NotTupleFail Src | is_tagged_tuple WrongRecordFail Tuple Arity Atom | equal(Src, Tuple) => i_is_tagged_tuple_ff NotTupleFail WrongRecordFail Src Arity Atom | current_tuple Src
     */

  fail188:
    instr = first;
    v0 = instr->a[0]; /* NotTupleFail */
    v1 = instr->a[1]; /* Src */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 159) { /* is_tagged_tuple/4 */
      goto fail189;
    }
    v2 = instr->a[0]; /* WrongRecordFail */
    v3 = instr->a[1]; /* Tuple */
    v4 = instr->a[2]; /* Arity */
    v5 = instr->a[3]; /* Atom */
    /* Call predicate equal() */
    if (!equal(st, v1, v3)) {
      goto fail189;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 207;
    instr->arity = 2;
    instr->a[0] = v1; /* Src */
    /* Create instruction: i_is_tagged_tuple_ff/5 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 213;
      instr->arity = 5;
    }
    instr->a[0] = v0; /* NotTupleFail */
    instr->a[1] = v2; /* WrongRecordFail */
    instr->a[2] = v1; /* Src */
    instr->a[3] = v4; /* Arity */
    instr->a[4] = v5; /* Atom */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(248):
     *   is_tuple Fail=f Src => i_is_tuple Fail Src | current_tuple Src
     */

  fail189:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Src */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 207;
    instr->arity = 2;
    instr->a[0] = v1; /* Src */
    /* Create instruction: i_is_tuple/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 214;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Src */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 1: /* label/1 */

    /*
     * Line beam/jit/x86/ops.tab(386):
     *   label L | loop_rec Fail Reg => aligned_label L u=4 | loop_rec Fail Reg
     */

    v0 = instr->a[0]; /* L */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 23) { /* loop_rec/2 */
      goto fail191;
    }
    /* Keep the current instruction unchanged */
    keep = instr;
    /* Create instruction: aligned_label/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 185;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* L */
    /* Store value u=4 */
    instr->a[1].type = TAG_u;
    instr->a[1].val = 4;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(388):
     *   label L | wait_timeout Fail Src => aligned_label L u=4 | wait_timeout Fail Src
     */

  fail191:
    instr = first;
    v0 = instr->a[0]; /* L */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 26) { /* wait_timeout/2 */
      goto fail192;
    }
    /* Keep the current instruction unchanged */
    keep = instr;
    /* Create instruction: aligned_label/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 185;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* L */
    /* Store value u=4 */
    instr->a[1].type = TAG_u;
    instr->a[1].val = 4;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(390):
     *   label L | wait Fail => aligned_label L u=4 | wait Fail
     */

  fail192:
    instr = first;
    v0 = instr->a[0]; /* L */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 25) { /* wait/1 */
      goto fail193;
    }
    /* Keep the current instruction unchanged */
    keep = instr;
    /* Create instruction: aligned_label/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 185;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* L */
    /* Store value u=4 */
    instr->a[1].type = TAG_u;
    instr->a[1].val = 4;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(392):
     *   label L | timeout => aligned_label L u=4 | timeout
     */

  fail193:
    instr = first;
    v0 = instr->a[0]; /* L */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 22) { /* timeout/0 */
      return TE_FAIL;
    }
    /* Keep the current instruction unchanged */
    keep = instr;
    /* Create instruction: aligned_label/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 185;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* L */
    /* Store value u=4 */
    instr->a[1].type = TAG_u;
    instr->a[1].val = 4;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 153: /* line/1 */

    /*
     * Line beam/jit/x86/ops.tab(91):
     *   line n => _
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 256) == 0) { /* n  */
      return TE_FAIL;
    }
    /* This rule succeeds */
    keep = instr = instr->next;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 23: /* loop_rec/2 */

    /*
     * Line beam/jit/x86/ops.tab(394):
     *   loop_rec Fail x==0 | smp_mark_target_label(Fail) => i_loop_rec Fail
     */

    v0 = instr->a[0]; /* Fail */
    /* Test type */
    if (((1 << instr->a[1].type) & 8) == 0) { /* x  */
      return TE_FAIL;
    }
    /* Test value */
    if (instr->a[1].val != 0) {
      return TE_FAIL;
    }
    /* Call predicate smp_mark_target_label() */
    if (!smp_mark_target_label(st, v0)) {
      return TE_FAIL;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 225;
    instr->arity = 1;
    instr->a[0] = v0; /* Fail */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 171: /* make_fun3/3 */

    /*
     * Line beam/jit/x86/ops.tab(810):
     *   make_fun3 OldIndex=u Dst=d NumFree=u Env=* => make_fun3(OldIndex, Dst, NumFree, Env)
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* OldIndex */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* d  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Dst */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v2 = instr->a[2]; /* NumFree */
    /* Store dynamic arguments (Env) */
    num_rest_args = instr->arity - 3;
    rest_args = &instr->a[3];
    /* Call generator make_fun3() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = make_fun3(st, v0, v1, v2, rest_args);

      if (new_instr == NULL) {
        return TE_FAIL;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 64: /* move/2 */

    /*
     * Skip 4 rules unless the second instruction is line/1.
     */

    /*
     * Note that the caller of transform_engine() guarantees that
     * there is always a second instruction available.
     */
    ASSERT(instr);
    if (instr->next->op != 153) {
        /* The second instruction is wrong. Skip ahead. */
        goto fail202;
    }

    /*
     * Line beam/jit/x86/ops.tab(76):
     *   move S X0=x==0 | line _Loc | call_ext_last Ar Func=u$is_not_bif D => move S X0 | call_ext_last Ar Func D
     */

    v0 = instr->a[0]; /* S */
    /* Test type */
    if (((1 << instr->a[1].type) & 8) == 0) { /* x  */
      goto fail199;
    }
    /* Test value */
    if (instr->a[1].val != 0) {
      goto fail199;
    }
    v1 = instr->a[1]; /* X0 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 153) { /* line/1 */
      goto fail199;
    }
    /* Advance to next instruction */
    instr = instr->next;
    if (instr == NULL) return TE_SHORT_WINDOW;
    if (instr->op != 8) { /* call_ext_last/3 */
      goto fail199;
    }
    /* Is variable Func not a BIF? */
    {
      int i = instr->a[1].val;

      /*
       * In debug build, the type must be 'u'.
       */
      ASSERT(instr->a[1].type == TAG_u);
      if (instr->a[1].type != TAG_u) {
        goto fail199;
      } else if (i < st->beam.imports.count) {
        BeamFile_ImportEntry *import;

        if (st->bif_imports[i]) {
          goto fail199;
        }

        /* erlang:apply/2,3 are strange. They exist as (dummy) BIFs
         * so that they are included in the export table before
         * the erlang module is loaded. They also exist in the
         * erlang module as functions. When used in code, a special
         * Beam instruction is used.
         *
         * Below we recognize erlang:apply/2,3 as special. This is
         * necessary because after setting a trace pattern on
         * them, you can no longer see from the export entry that
         * they are special. */
        import = &st->beam.imports.entries[i];

        if (import->module == am_erlang) {
          if (import->function == am_apply) {
            if (import->arity == 2 || import->arity == 3) {
              goto fail199;
            }
          }
        }
      }
    }
    /* Keep the current instruction unchanged */
    keep = instr;
    /* Create instruction: move/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 64;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* S */
    instr->a[1] = v1; /* X0 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(78):
     *   move S X0=x==0 | line _Loc | call_ext_only Ar Func=u$is_not_bif => move S X0 | call_ext_only Ar Func
     */

  fail199:
    instr = first;
    v0 = instr->a[0]; /* S */
    /* Test type */
    if (((1 << instr->a[1].type) & 8) == 0) { /* x  */
      goto fail200;
    }
    /* Test value */
    if (instr->a[1].val != 0) {
      goto fail200;
    }
    v1 = instr->a[1]; /* X0 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 153) { /* line/1 */
      goto fail200;
    }
    /* Advance to next instruction */
    instr = instr->next;
    if (instr == NULL) return TE_SHORT_WINDOW;
    if (instr->op != 78) { /* call_ext_only/2 */
      goto fail200;
    }
    /* Is variable Func not a BIF? */
    {
      int i = instr->a[1].val;

      /*
       * In debug build, the type must be 'u'.
       */
      ASSERT(instr->a[1].type == TAG_u);
      if (instr->a[1].type != TAG_u) {
        goto fail200;
      } else if (i < st->beam.imports.count) {
        BeamFile_ImportEntry *import;

        if (st->bif_imports[i]) {
          goto fail200;
        }

        /* erlang:apply/2,3 are strange. They exist as (dummy) BIFs
         * so that they are included in the export table before
         * the erlang module is loaded. They also exist in the
         * erlang module as functions. When used in code, a special
         * Beam instruction is used.
         *
         * Below we recognize erlang:apply/2,3 as special. This is
         * necessary because after setting a trace pattern on
         * them, you can no longer see from the export entry that
         * they are special. */
        import = &st->beam.imports.entries[i];

        if (import->module == am_erlang) {
          if (import->function == am_apply) {
            if (import->arity == 2 || import->arity == 3) {
              goto fail200;
            }
          }
        }
      }
    }
    /* Keep the current instruction unchanged */
    keep = instr;
    /* Create instruction: move/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 64;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* S */
    instr->a[1] = v1; /* X0 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(81):
     *   move S X0=x==0 | line _Loc | call_last Ar Func D => move S X0 | call_last Ar Func D
     */

  fail200:
    instr = first;
    v0 = instr->a[0]; /* S */
    /* Test type */
    if (((1 << instr->a[1].type) & 8) == 0) { /* x  */
      goto fail201;
    }
    /* Test value */
    if (instr->a[1].val != 0) {
      goto fail201;
    }
    v1 = instr->a[1]; /* X0 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 153) { /* line/1 */
      goto fail201;
    }
    /* Advance to next instruction */
    instr = instr->next;
    if (instr == NULL) return TE_SHORT_WINDOW;
    if (instr->op != 5) { /* call_last/3 */
      goto fail201;
    }
    /* Keep the current instruction unchanged */
    keep = instr;
    /* Create instruction: move/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 64;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* S */
    instr->a[1] = v1; /* X0 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(83):
     *   move S X0=x==0 | line _Loc | call_only Ar Func => move S X0 | call_only Ar Func
     */

  fail201:
    instr = first;
    v0 = instr->a[0]; /* S */
    /* Test type */
    if (((1 << instr->a[1].type) & 8) == 0) { /* x  */
      goto fail202;
    }
    /* Test value */
    if (instr->a[1].val != 0) {
      goto fail202;
    }
    v1 = instr->a[1]; /* X0 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 153) { /* line/1 */
      goto fail202;
    }
    /* Advance to next instruction */
    instr = instr->next;
    if (instr == NULL) return TE_SHORT_WINDOW;
    if (instr->op != 6) { /* call_only/2 */
      goto fail202;
    }
    /* Keep the current instruction unchanged */
    keep = instr;
    /* Create instruction: move/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 64;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* S */
    instr->a[1] = v1; /* X0 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(348):
     *   move Src=c Dst => i_move Src Dst
     */

  fail202:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 8454) == 0) { /* c  */
      goto fail203;
    }
    v0 = instr->a[0]; /* Src */
    v1 = instr->a[1]; /* Dst */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 222;
    instr->arity = 2;
    instr->a[0] = v0; /* Src */
    instr->a[1] = v1; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Skip 5 rules unless the second instruction is move/2.
     */

  fail203:
    instr = first;
    /*
     * Note that the caller of transform_engine() guarantees that
     * there is always a second instruction available.
     */
    ASSERT(instr);
    if (instr->next->op != 64) {
        /* The second instruction is wrong. Skip ahead. */
        goto fail209;
    }

    /*
     * Line beam/jit/x86/ops.tab(351):
     *   move Src SrcDst | move SrcDst2 Dst | equal(SrcDst, SrcDst2) => i_move Src SrcDst | move SrcDst Dst
     */

    v0 = instr->a[0]; /* Src */
    v1 = instr->a[1]; /* SrcDst */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 64) { /* move/2 */
      goto fail205;
    }
    v2 = instr->a[0]; /* SrcDst2 */
    v3 = instr->a[1]; /* Dst */
    /* Call predicate equal() */
    if (!equal(st, v1, v2)) {
      goto fail205;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 64;
    instr->arity = 2;
    instr->a[0] = v1; /* SrcDst */
    instr->a[1] = v3; /* Dst */
    /* Create instruction: i_move/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 222;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* Src */
    instr->a[1] = v1; /* SrcDst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(358):
     *   move S1=d D1=d | move S2=d D2=d | consecutive_words(S1, D1, S2, D2) => move_two_words S1 D1 S2 D2
     */

  fail205:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 24) == 0) { /* d  */
      goto fail206;
    }
    v0 = instr->a[0]; /* S1 */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* d  */
      goto fail206;
    }
    v1 = instr->a[1]; /* D1 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 64) { /* move/2 */
      goto fail206;
    }
    /* Test type */
    if (((1 << instr->a[0].type) & 24) == 0) { /* d  */
      goto fail206;
    }
    v2 = instr->a[0]; /* S2 */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* d  */
      goto fail206;
    }
    v3 = instr->a[1]; /* D2 */
    /* Call predicate consecutive_words() */
    if (!consecutive_words(st, v0, v1, v2, v3)) {
      goto fail206;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 223;
    instr->arity = 4;
    instr->a[0] = v0; /* S1 */
    instr->a[1] = v1; /* D1 */
    instr->a[2] = v2; /* S2 */
    instr->a[3] = v3; /* D2 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(360):
     *   move S1=d D1=d | move S2=d D2=d | consecutive_words(S1, D2, S2, D1) => move_two_words S1 D1 S2 D2
     */

  fail206:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 24) == 0) { /* d  */
      goto fail207;
    }
    v0 = instr->a[0]; /* S1 */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* d  */
      goto fail207;
    }
    v1 = instr->a[1]; /* D1 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 64) { /* move/2 */
      goto fail207;
    }
    /* Test type */
    if (((1 << instr->a[0].type) & 24) == 0) { /* d  */
      goto fail207;
    }
    v2 = instr->a[0]; /* S2 */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* d  */
      goto fail207;
    }
    v3 = instr->a[1]; /* D2 */
    /* Call predicate consecutive_words() */
    if (!consecutive_words(st, v0, v3, v2, v1)) {
      goto fail207;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 223;
    instr->arity = 4;
    instr->a[0] = v0; /* S1 */
    instr->a[1] = v1; /* D1 */
    instr->a[2] = v2; /* S2 */
    instr->a[3] = v3; /* D2 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(362):
     *   move S1=d D1=d | move S2=d D2=d | consecutive_words(S2, D1, S1, D2) => move_two_words S2 D2 S1 D1
     */

  fail207:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 24) == 0) { /* d  */
      goto fail208;
    }
    v0 = instr->a[0]; /* S1 */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* d  */
      goto fail208;
    }
    v1 = instr->a[1]; /* D1 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 64) { /* move/2 */
      goto fail208;
    }
    /* Test type */
    if (((1 << instr->a[0].type) & 24) == 0) { /* d  */
      goto fail208;
    }
    v2 = instr->a[0]; /* S2 */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* d  */
      goto fail208;
    }
    v3 = instr->a[1]; /* D2 */
    /* Call predicate consecutive_words() */
    if (!consecutive_words(st, v2, v1, v0, v3)) {
      goto fail208;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 223;
    instr->arity = 4;
    instr->a[0] = v2; /* S2 */
    instr->a[1] = v3; /* D2 */
    instr->a[2] = v0; /* S1 */
    instr->a[3] = v1; /* D1 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(364):
     *   move S1=d D1=d | move S2=d D2=d | consecutive_words(S2, D2, S1, D1) => move_two_words S2 D2 S1 D1
     */

  fail208:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 24) == 0) { /* d  */
      goto fail209;
    }
    v0 = instr->a[0]; /* S1 */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* d  */
      goto fail209;
    }
    v1 = instr->a[1]; /* D1 */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 64) { /* move/2 */
      goto fail209;
    }
    /* Test type */
    if (((1 << instr->a[0].type) & 24) == 0) { /* d  */
      goto fail209;
    }
    v2 = instr->a[0]; /* S2 */
    /* Test type */
    if (((1 << instr->a[1].type) & 24) == 0) { /* d  */
      goto fail209;
    }
    v3 = instr->a[1]; /* D2 */
    /* Call predicate consecutive_words() */
    if (!consecutive_words(st, v2, v3, v0, v1)) {
      goto fail209;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 223;
    instr->arity = 4;
    instr->a[0] = v2; /* S2 */
    instr->a[1] = v3; /* D2 */
    instr->a[2] = v0; /* S1 */
    instr->a[3] = v1; /* D1 */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(366):
     *   move Src Dst => i_move Src Dst
     */

  fail209:
    instr = first;
    v0 = instr->a[0]; /* Src */
    v1 = instr->a[1]; /* Dst */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 222;
    instr->arity = 2;
    instr->a[0] = v0; /* Src */
    instr->a[1] = v1; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 328: /* new_map/3 */

    /*
     * Line beam/jit/x86/ops.tab(1096):
     *   new_map Dst Live Size Rest=* | is_small_map_literal_keys(Size, Rest) => new_small_map_lit(Dst, Live, Size, Rest)
     */

    v0 = instr->a[0]; /* Dst */
    v1 = instr->a[1]; /* Live */
    v2 = instr->a[2]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 3;
    rest_args = &instr->a[3];
    /* Call predicate is_small_map_literal_keys() */
    if (!is_small_map_literal_keys(st, v2, rest_args)) {
      return TE_FAIL;
    }
    /* Call generator new_small_map_lit() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = new_small_map_lit(st, v0, v1, v2, rest_args);

      if (new_instr == NULL) {
        return TE_FAIL;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 274: /* nofail_bif2/4 */

    /*
     * Line beam/jit/x86/ops.tab(749):
     *   nofail_bif2 S1=d S2 Bif Dst | is_eq_exact_bif(Bif) => bif_is_eq_exact S1 S2 Dst
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 24) == 0) { /* d  */
      goto fail212;
    }
    v0 = instr->a[0]; /* S1 */
    v1 = instr->a[1]; /* S2 */
    v2 = instr->a[2]; /* Bif */
    v3 = instr->a[3]; /* Dst */
    /* Call predicate is_eq_exact_bif() */
    if (!is_eq_exact_bif(st, v2)) {
      goto fail212;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 278;
    instr->arity = 3;
    instr->a[0] = v0; /* S1 */
    instr->a[1] = v1; /* S2 */
    instr->a[2] = v3; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(750):
     *   nofail_bif2 S1=d S2 Bif Dst | is_ne_exact_bif(Bif) => bif_is_ne_exact S1 S2 Dst
     */

  fail212:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 24) == 0) { /* d  */
      goto fail213;
    }
    v0 = instr->a[0]; /* S1 */
    v1 = instr->a[1]; /* S2 */
    v2 = instr->a[2]; /* Bif */
    v3 = instr->a[3]; /* Dst */
    /* Call predicate is_ne_exact_bif() */
    if (!is_ne_exact_bif(st, v2)) {
      goto fail213;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 279;
    instr->arity = 3;
    instr->a[0] = v0; /* S1 */
    instr->a[1] = v1; /* S2 */
    instr->a[2] = v3; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(751):
     *   nofail_bif2 S1 S2 Bif Dst | is_ge_bif(Bif) => bif_is_ge S1 S2 Dst
     */

  fail213:
    instr = first;
    v0 = instr->a[0]; /* S1 */
    v1 = instr->a[1]; /* S2 */
    v2 = instr->a[2]; /* Bif */
    v3 = instr->a[3]; /* Dst */
    /* Call predicate is_ge_bif() */
    if (!is_ge_bif(st, v2)) {
      goto fail214;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 280;
    instr->arity = 3;
    instr->a[0] = v0; /* S1 */
    instr->a[1] = v1; /* S2 */
    instr->a[2] = v3; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(752):
     *   nofail_bif2 S1 S2 Bif Dst | is_lt_bif(Bif) => bif_is_lt S1 S2 Dst
     */

  fail214:
    instr = first;
    v0 = instr->a[0]; /* S1 */
    v1 = instr->a[1]; /* S2 */
    v2 = instr->a[2]; /* Bif */
    v3 = instr->a[3]; /* Dst */
    /* Call predicate is_lt_bif() */
    if (!is_lt_bif(st, v2)) {
      return TE_FAIL;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 281;
    instr->arity = 3;
    instr->a[0] = v0; /* S1 */
    instr->a[1] = v1; /* S2 */
    instr->a[2] = v3; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 69: /* put_list/3 */

    /*
     * Line beam/jit/x86/ops.tab(495):
     *   put_list Hd Tl Dst => put_cons Hd Tl | store_cons u=1 Dst
     */

    v0 = instr->a[0]; /* Hd */
    v1 = instr->a[1]; /* Tl */
    v2 = instr->a[2]; /* Dst */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 235;
    instr->arity = 2;
    /* Store value u=1 */
    instr->a[0].type = TAG_u;
    instr->a[0].val = 1;
    instr->a[1] = v2; /* Dst */
    /* Create instruction: put_cons/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 236;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* Hd */
    instr->a[1] = v1; /* Tl */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 154: /* put_map_assoc/5 */

    /*
     * Line beam/jit/x86/ops.tab(1075):
     *   put_map_assoc _Fail Map Dst Live Size Rest=* => i_put_map_assoc Map Dst Live Size Rest
     */

    v1 = instr->a[1]; /* Map */
    v2 = instr->a[2]; /* Dst */
    v3 = instr->a[3]; /* Live */
    v4 = instr->a[4]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 5;
    rest_args = &instr->a[5];
    /* This rule always succeeds */
    keep = instr = instr->next;
    /* Create instruction: i_put_map_assoc/4 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 325;
      instr->arity = 4;
    }
    instr->a[0] = v1; /* Map */
    instr->a[1] = v2; /* Dst */
    instr->a[2] = v3; /* Live */
    instr->a[3] = v4; /* Size */
    /* Store dynamic arguments (Rest) */
    ASSERT(instr->a == instr->def_args);
    instr->arity = instr->arity + num_rest_args;
    instr->a = erts_alloc(ERTS_ALC_T_LOADER_TMP,
                          instr->arity * sizeof(BeamOpArg));
    sys_memcpy(instr->a, instr->def_args, 4 * sizeof(BeamOpArg));
    sys_memcpy(instr->a+4, rest_args, num_rest_args*sizeof(BeamOpArg));
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 155: /* put_map_exact/5 */

    /*
     * Line beam/jit/x86/ops.tab(1085):
     *   put_map_exact F Map Dst Live Size Rest=* | map_key_sort(Size, Rest) => sorted_put_map_exact F Map Dst Live Size Rest
     */

    v0 = instr->a[0]; /* F */
    v1 = instr->a[1]; /* Map */
    v2 = instr->a[2]; /* Dst */
    v3 = instr->a[3]; /* Live */
    v4 = instr->a[4]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 5;
    rest_args = &instr->a[5];
    /* Call predicate map_key_sort() */
    if (!map_key_sort(st, v4, rest_args)) {
      return TE_FAIL;
    }
    /* This rule succeeds */
    keep = instr = instr->next;
    /* Create instruction: sorted_put_map_exact/5 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 327;
      instr->arity = 5;
    }
    instr->a[0] = v0; /* F */
    instr->a[1] = v1; /* Map */
    instr->a[2] = v2; /* Dst */
    instr->a[3] = v3; /* Live */
    instr->a[4] = v4; /* Size */
    /* Store dynamic arguments (Rest) */
    ASSERT(instr->a == instr->def_args);
    instr->arity = instr->arity + num_rest_args;
    instr->a = erts_alloc(ERTS_ALC_T_LOADER_TMP,
                          instr->arity * sizeof(BeamOpArg));
    sys_memcpy(instr->a, instr->def_args, 5 * sizeof(BeamOpArg));
    sys_memcpy(instr->a+5, rest_args, num_rest_args*sizeof(BeamOpArg));
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 60: /* select_tuple_arity/3 */

    /*
     * Line beam/jit/x86/ops.tab(160):
     *   select_tuple_arity S=d Fail=f Size=u Rest=* => select_tuple_arity(S, Fail, Size, Rest)
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 24) == 0) { /* d  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* S */
    /* Test type */
    if (((1 << instr->a[1].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Fail */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v2 = instr->a[2]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 3;
    rest_args = &instr->a[3];
    /* Call generator select_tuple_arity() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = select_tuple_arity(st, v0, v1, v2, rest_args);

      if (new_instr == NULL) {
        return TE_FAIL;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 59: /* select_val/3 */

    /*
     * Line beam/jit/x86/ops.tab(124):
     *   select_val S Fail=fn Size=u Rest=* | use_jump_tab(Size, Rest, 6) => jump_tab(S, Fail, Size, Rest)
     */

    v0 = instr->a[0]; /* S */
    /* Test type */
    if (((1 << instr->a[1].type) & 288) == 0) { /* f n  */
      goto fail220;
    }
    v1 = instr->a[1]; /* Fail */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      goto fail220;
    }
    v2 = instr->a[2]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 3;
    rest_args = &instr->a[3];
    /* Call predicate use_jump_tab() */
    if (!use_jump_tab(st, v2, rest_args, 6)) {
      goto fail220;
    }
    /* Call generator jump_tab() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = jump_tab(st, v0, v1, v2, rest_args);

      if (new_instr == NULL) {
        goto fail220;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(137):
     *   select_val S Fail=fn Size=u Rest=* | mixed_types(Size, Rest) => split_values(S, Fail, Fail, Size, Rest)
     */

  fail220:
    instr = first;
    v0 = instr->a[0]; /* S */
    /* Test type */
    if (((1 << instr->a[1].type) & 288) == 0) { /* f n  */
      goto fail221;
    }
    v1 = instr->a[1]; /* Fail */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      goto fail221;
    }
    v2 = instr->a[2]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 3;
    rest_args = &instr->a[3];
    /* Call predicate mixed_types() */
    if (!mixed_types(st, v2, rest_args)) {
      goto fail221;
    }
    /* Call generator split_values() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = split_values(st, v0, v1, v1, v2, rest_args);

      if (new_instr == NULL) {
        goto fail221;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(150):
     *   select_val S Fail=fn Size=u Rest=* | floats_or_bignums(Size, Rest) => select_literals(S, Fail, Size, Rest)
     */

  fail221:
    instr = first;
    v0 = instr->a[0]; /* S */
    /* Test type */
    if (((1 << instr->a[1].type) & 288) == 0) { /* f n  */
      goto fail222;
    }
    v1 = instr->a[1]; /* Fail */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      goto fail222;
    }
    v2 = instr->a[2]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 3;
    rest_args = &instr->a[3];
    /* Call predicate floats_or_bignums() */
    if (!floats_or_bignums(st, v2, rest_args)) {
      goto fail222;
    }
    /* Call generator select_literals() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = select_literals(st, v0, v1, v2, rest_args);

      if (new_instr == NULL) {
        goto fail222;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(153):
     *   select_val S Fail=fn Size=u Rest=* | fixed_size_values(Size, Rest) => select_val(S, Fail, Size, Rest)
     */

  fail222:
    instr = first;
    v0 = instr->a[0]; /* S */
    /* Test type */
    if (((1 << instr->a[1].type) & 288) == 0) { /* f n  */
      return TE_FAIL;
    }
    v1 = instr->a[1]; /* Fail */
    /* Test type */
    if (((1 << instr->a[2].type) & 1) == 0) { /* u  */
      return TE_FAIL;
    }
    v2 = instr->a[2]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 3;
    rest_args = &instr->a[3];
    /* Call predicate fixed_size_values() */
    if (!fixed_size_values(st, v2, rest_args)) {
      return TE_FAIL;
    }
    /* Call generator select_val() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = select_val(st, v0, v1, v2, rest_args);

      if (new_instr == NULL) {
        return TE_FAIL;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 326: /* sorted_put_map_assoc/4 */

    /*
     * Line beam/jit/x86/ops.tab(1088):
     *   sorted_put_map_assoc Map Dst Live Size Rest=* | is_empty_map(Map) => new_map Dst Live Size Rest
     */

    v0 = instr->a[0]; /* Map */
    v1 = instr->a[1]; /* Dst */
    v2 = instr->a[2]; /* Live */
    v3 = instr->a[3]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 4;
    rest_args = &instr->a[4];
    /* Call predicate is_empty_map() */
    if (!is_empty_map(st, v0)) {
      goto fail224;
    }
    /* This rule succeeds */
    keep = instr = instr->next;
    /* Create instruction: new_map/3 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 328;
      instr->arity = 3;
    }
    instr->a[0] = v1; /* Dst */
    instr->a[1] = v2; /* Live */
    instr->a[2] = v3; /* Size */
    /* Store dynamic arguments (Rest) */
    ASSERT(instr->a == instr->def_args);
    instr->arity = instr->arity + num_rest_args;
    instr->a = erts_alloc(ERTS_ALC_T_LOADER_TMP,
                          instr->arity * sizeof(BeamOpArg));
    sys_memcpy(instr->a, instr->def_args, 3 * sizeof(BeamOpArg));
    sys_memcpy(instr->a+3, rest_args, num_rest_args*sizeof(BeamOpArg));
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(1090):
     *   sorted_put_map_assoc Src=s Dst Live Size Rest=* => update_map_assoc Src Dst Live Size Rest
     */

  fail224:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 8478) == 0) { /* s  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Src */
    v1 = instr->a[1]; /* Dst */
    v2 = instr->a[2]; /* Live */
    v3 = instr->a[3]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 4;
    rest_args = &instr->a[4];
    /* This rule succeeds */
    keep = instr = instr->next;
    /* Create instruction: update_map_assoc/4 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 330;
      instr->arity = 4;
    }
    instr->a[0] = v0; /* Src */
    instr->a[1] = v1; /* Dst */
    instr->a[2] = v2; /* Live */
    instr->a[3] = v3; /* Size */
    /* Store dynamic arguments (Rest) */
    ASSERT(instr->a == instr->def_args);
    instr->arity = instr->arity + num_rest_args;
    instr->a = erts_alloc(ERTS_ALC_T_LOADER_TMP,
                          instr->arity * sizeof(BeamOpArg));
    sys_memcpy(instr->a, instr->def_args, 4 * sizeof(BeamOpArg));
    sys_memcpy(instr->a+4, rest_args, num_rest_args*sizeof(BeamOpArg));
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 327: /* sorted_put_map_exact/5 */

    /*
     * Line beam/jit/x86/ops.tab(1093):
     *   sorted_put_map_exact Fail Src Dst Live Size Rest=* => update_map_exact Src Fail Dst Live Size Rest
     */

    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Src */
    v2 = instr->a[2]; /* Dst */
    v3 = instr->a[3]; /* Live */
    v4 = instr->a[4]; /* Size */
    /* Store dynamic arguments (Rest) */
    num_rest_args = instr->arity - 5;
    rest_args = &instr->a[5];
    /* This rule always succeeds */
    keep = instr = instr->next;
    /* Create instruction: update_map_exact/5 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 331;
      instr->arity = 5;
    }
    instr->a[0] = v1; /* Src */
    instr->a[1] = v0; /* Fail */
    instr->a[2] = v2; /* Dst */
    instr->a[3] = v3; /* Live */
    instr->a[4] = v4; /* Size */
    /* Store dynamic arguments (Rest) */
    ASSERT(instr->a == instr->def_args);
    instr->arity = instr->arity + num_rest_args;
    instr->a = erts_alloc(ERTS_ALC_T_LOADER_TMP,
                          instr->arity * sizeof(BeamOpArg));
    sys_memcpy(instr->a, instr->def_args, 5 * sizeof(BeamOpArg));
    sys_memcpy(instr->a+5, rest_args, num_rest_args*sizeof(BeamOpArg));
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 235: /* store_cons/2 */

    /*
     * Skip 2 rules unless the second instruction is put_list/3.
     */

    /*
     * Note that the caller of transform_engine() guarantees that
     * there is always a second instruction available.
     */
    ASSERT(instr);
    if (instr->next->op != 69) {
        /* The second instruction is wrong. Skip ahead. */
        goto fail229;
    }

    /*
     * Line beam/jit/x86/ops.tab(499):
     *   store_cons Len Dst | put_list Hd Tl Dst2 | equal(Dst, Tl) | equal(Dst, Dst2) | distinct(Dst, Hd) => combine_conses(Len, Dst, Hd)
     */

    v0 = instr->a[0]; /* Len */
    v1 = instr->a[1]; /* Dst */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 69) { /* put_list/3 */
      goto fail228;
    }
    v2 = instr->a[0]; /* Hd */
    v3 = instr->a[1]; /* Tl */
    v4 = instr->a[2]; /* Dst2 */
    /* Call predicate equal() */
    if (!equal(st, v1, v3)) {
      goto fail228;
    }
    /* Call predicate equal() */
    if (!equal(st, v1, v4)) {
      goto fail228;
    }
    /* Call predicate distinct() */
    if (!distinct(st, v1, v2)) {
      goto fail228;
    }
    /* Call generator combine_conses() */
    {
      BeamOp** lastp;
      BeamOp* new_instr = combine_conses(st, v0, v1, v2);

      if (new_instr == NULL) {
        goto fail228;
      }

      keep = instr->next; /* The next_instr was optimized away. */

      lastp = &new_instr;
      while (*lastp != NULL) {
          lastp = &((*lastp)->next);
      }

      *lastp = keep;
      instr = new_instr;
    }
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(502):
     *   store_cons Len Dst | put_list Hd Tl OtherDst | equal(Dst, Tl) => store_cons Len Dst | append_cons u Hd | store_cons u=1 OtherDst
     */

  fail228:
    instr = first;
    v0 = instr->a[0]; /* Len */
    v1 = instr->a[1]; /* Dst */
    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 69) { /* put_list/3 */
      return TE_FAIL;
    }
    v2 = instr->a[0]; /* Hd */
    v3 = instr->a[1]; /* Tl */
    v4 = instr->a[2]; /* OtherDst */
    /* Call predicate equal() */
    if (!equal(st, v1, v3)) {
      return TE_FAIL;
    }
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 235;
    instr->arity = 2;
    /* Store value u=1 */
    instr->a[0].type = TAG_u;
    instr->a[0].val = 1;
    instr->a[1] = v4; /* OtherDst */
    /* Create instruction: append_cons/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 237;
      instr->arity = 2;
    }
    /* Store value u=0 */
    instr->a[0].type = TAG_u;
    instr->a[0].val = 0;
    instr->a[1] = v2; /* Hd */
    /* Create instruction: store_cons/2 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 235;
      instr->arity = 2;
    }
    instr->a[0] = v0; /* Len */
    instr->a[1] = v1; /* Dst */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;
  fail229:
    instr = first;
/* Fail transformation */
return TE_FAIL;

    case 220: /* system_limit/1 */

    /*
     * Line beam/jit/x86/ops.tab(337):
     *   system_limit p => system_limit_body
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 512) == 0) { /* p  */
      goto fail231;
    }
    /* Rename instruction keeping the arguments */
    instr->op = 221;
    instr->arity = 0;
    return TE_OK;

    /*
     * Line beam/jit/x86/ops.tab(338):
     *   system_limit Fail=f => jump Fail
     */

  fail231:
    instr = first;
    /* Test type */
    if (((1 << instr->a[0].type) & 32) == 0) { /* f  */
      return TE_FAIL;
    }
    v0 = instr->a[0]; /* Fail */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 61;
    instr->arity = 1;
    instr->a[0] = v0; /* Fail */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 58: /* test_arity/3 */

    /*
     * Line beam/jit/x86/ops.tab(237):
     *   test_arity Fail Src Arity => i_test_arity Fail Src Arity | current_tuple Src
     */

    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Src */
    v2 = instr->a[2]; /* Arity */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 207;
    instr->arity = 2;
    instr->a[0] = v1; /* Src */
    /* Create instruction: i_test_arity/3 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 211;
      instr->arity = 3;
    }
    instr->a[0] = v0; /* Fail */
    instr->a[1] = v1; /* Src */
    instr->a[2] = v2; /* Arity */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 136: /* trim/2 */

    /*
     * Line beam/jit/x86/ops.tab(109):
     *   trim N _Remaining => i_trim N
     */

    v0 = instr->a[0]; /* N */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 198;
    instr->arity = 1;
    instr->a[0] = v0; /* N */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 104: /* try/2 */

    /*
     * Line beam/jit/x86/ops.tab(205):
     *   try Y F => catch Y F
     */

    v0 = instr->a[0]; /* Y */
    v1 = instr->a[1]; /* F */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 62;
    instr->arity = 2;
    instr->a[0] = v0; /* Y */
    instr->a[1] = v1; /* F */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 105: /* try_end/1 */

    /*
     * Line beam/jit/x86/ops.tab(212):
     *   try_end _Y | deallocate N => try_end_deallocate N
     */

    /* Advance to next instruction */
    instr = instr->next;
    ASSERT(instr);
    if (instr->op != 18) { /* deallocate/1 */
      return TE_FAIL;
    }
    v1 = instr->a[0]; /* N */
    /* This rule succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 206;
    instr->arity = 1;
    instr->a[0] = v1; /* N */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 355: /* unsupported_guard_bif/3 */

    /*
     * Line beam/jit/x86/ops.tab(1285):
     *   unsupported_guard_bif _A _B _C | never() => _
     */

    /* Call predicate never() */
    if (!never(st)) {
      return TE_FAIL;
    }
    /* This rule succeeds */
    keep = instr = instr->next;
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 181: /* update_record/5 */

    /*
     * Line beam/jit/x86/ops.tab(1313):
     *   update_record a==am_inplace Size Src=d Dst N Updates=* => update_record_in_place Size Src Dst N Updates
     */

    /* Test type */
    if (((1 << instr->a[0].type) & 4) == 0) { /* a  */
      return TE_FAIL;
    }
    /* Test value */
    if (instr->a[0].val != am_inplace) {
      return TE_FAIL;
    }
    v0 = instr->a[1]; /* Size */
    /* Test type */
    if (((1 << instr->a[2].type) & 24) == 0) { /* d  */
      return TE_FAIL;
    }
    v1 = instr->a[2]; /* Src */
    v2 = instr->a[3]; /* Dst */
    v3 = instr->a[4]; /* N */
    /* Store dynamic arguments (Updates) */
    num_rest_args = instr->arity - 5;
    rest_args = &instr->a[5];
    /* This rule succeeds */
    keep = instr = instr->next;
    /* Create instruction: update_record_in_place/4 */
    {
      BeamOp* new_instr = beamopallocator_new_op(&st->op_allocator);
      new_instr->next = instr;
      instr = new_instr;
      instr->op = 356;
      instr->arity = 4;
    }
    instr->a[0] = v0; /* Size */
    instr->a[1] = v1; /* Src */
    instr->a[2] = v2; /* Dst */
    instr->a[3] = v3; /* N */
    /* Store dynamic arguments (Updates) */
    ASSERT(instr->a == instr->def_args);
    instr->arity = instr->arity + num_rest_args;
    instr->a = erts_alloc(ERTS_ALC_T_LOADER_TMP,
                          instr->arity * sizeof(BeamOpArg));
    sys_memcpy(instr->a, instr->def_args, 4 * sizeof(BeamOpArg));
    sys_memcpy(instr->a+4, rest_args, num_rest_args*sizeof(BeamOpArg));
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 25: /* wait/1 */

    /*
     * Line beam/jit/x86/ops.tab(402):
     *   wait Fail => wait_unlocked Fail
     */

    v0 = instr->a[0]; /* Fail */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 227;
    instr->arity = 1;
    instr->a[0] = v0; /* Fail */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    case 26: /* wait_timeout/2 */

    /*
     * Line beam/jit/x86/ops.tab(398):
     *   wait_timeout Fail Src => wait_timeout_unlocked Src Fail
     */

    v0 = instr->a[0]; /* Fail */
    v1 = instr->a[1]; /* Src */
    /* This rule always succeeds; reusing last instruction on the left-hand side */
    ASSERT(instr->a == instr->def_args);
    keep = instr;
    instr->op = 228;
    instr->arity = 2;
    instr->a[0] = v1; /* Src */
    instr->a[1] = v0; /* Fail */
    /* End of transformation */
    st->genop = instr;
    while (first != keep) {
      BeamOp* next = first->next;
      beamopallocator_free_op(&st->op_allocator, first);
      first = next;
    }
    return TE_OK;

    default: ASSERT(0); return TE_FAIL;
  }
}

const GenOpEntry gen_opc[] = {
/*   0 */  {"", 0, 0, 0, 0},
/*   1 */  {"label", 1, 188, 1, 1},
/*   2 */  {"func_info", 3, -1, 0, 1},
/*   3 */  {"int_code_end", 0, 156, 1, 0},
/*   4 */  {"call", 2, -1, 0, 1},
/*   5 */  {"call_last", 3, -1, 0, 1},
/*   6 */  {"call_only", 2, -1, 0, 1},
/*   7 */  {"call_ext", 2, -1, 0, 1},
/*   8 */  {"call_ext_last", 3, -1, 0, 1},
/*   9 */  {"bif0", 2, -1, 0, 1},
/*  10 */  {"bif1", 4, -1, 0, 1},
/*  11 */  {"bif2", 5, -1, 0, 1},
/*  12 */  {"allocate", 2, 1, 1, 0},
/*  13 */  {"allocate_heap", 3, 2, 1, 0},
/*  14 */  {"allocate_zero", 2, -1, 0, 0},
/*  15 */  {"allocate_heap_zero", 3, -1, 0, 0},
/*  16 */  {"test_heap", 2, 217, 1, 0},
/*  17 */  {"init", 1, -1, 0, 0},
/*  18 */  {"deallocate", 1, 39, 1, 0},
/*  19 */  {"return", 0, 209, 1, 0},
/*  20 */  {"send", 0, 212, 1, 0},
/*  21 */  {"remove_message", 0, 208, 1, 0},
/*  22 */  {"timeout", 0, 218, 1, 0},
/*  23 */  {"loop_rec", 2, -1, 0, 1},
/*  24 */  {"loop_rec_end", 1, 191, 1, 0},
/*  25 */  {"wait", 1, -1, 0, 1},
/*  26 */  {"wait_timeout", 2, -1, 0, 1},
/*  27 */  {"m_plus", 4, -1, 0, 0},
/*  28 */  {"m_minus", 4, -1, 0, 0},
/*  29 */  {"m_times", 4, -1, 0, 0},
/*  30 */  {"m_div", 4, -1, 0, 0},
/*  31 */  {"int_div", 4, -1, 0, 0},
/*  32 */  {"int_rem", 4, -1, 0, 0},
/*  33 */  {"int_band", 4, -1, 0, 0},
/*  34 */  {"int_bor", 4, -1, 0, 0},
/*  35 */  {"int_bxor", 4, -1, 0, 0},
/*  36 */  {"int_bsl", 4, -1, 0, 0},
/*  37 */  {"int_bsr", 4, -1, 0, 0},
/*  38 */  {"int_bnot", 3, -1, 0, 0},
/*  39 */  {"is_lt", 3, 174, 1, 0},
/*  40 */  {"is_ge", 3, 166, 1, 1},
/*  41 */  {"is_eq", 3, 161, 1, 1},
/*  42 */  {"is_ne", 3, 176, 1, 1},
/*  43 */  {"is_eq_exact", 3, 162, 1, 1},
/*  44 */  {"is_ne_exact", 3, 177, 1, 1},
/*  45 */  {"is_integer", 2, 172, 1, 1},
/*  46 */  {"is_float", 2, 163, 1, 0},
/*  47 */  {"is_number", 2, 183, 1, 0},
/*  48 */  {"is_atom", 2, 157, 1, 1},
/*  49 */  {"is_pid", 2, 184, 1, 0},
/*  50 */  {"is_reference", 2, 186, 1, 0},
/*  51 */  {"is_port", 2, 185, 1, 0},
/*  52 */  {"is_nil", 2, 178, 1, 1},
/*  53 */  {"is_binary", 2, 158, 1, 0},
/*  54 */  {"is_constant", 2, -1, 0, 0},
/*  55 */  {"is_list", 2, 173, 1, 0},
/*  56 */  {"is_nonempty_list", 2, 179, 1, 1},
/*  57 */  {"is_tuple", 2, -1, 0, 1},
/*  58 */  {"test_arity", 3, -1, 0, 1},
/*  59 */  {"select_val", 3, -1, 0, 1},
/*  60 */  {"select_tuple_arity", 3, -1, 0, 1},
/*  61 */  {"jump", 1, 187, 1, 0},
/*  62 */  {"catch", 2, 36, 1, 0},
/*  63 */  {"catch_end", 1, 37, 1, 0},
/*  64 */  {"move", 2, -1, 0, 1},
/*  65 */  {"get_list", 3, 48, 1, 0},
/*  66 */  {"get_tuple_element", 3, -1, 0, 1},
/*  67 */  {"set_tuple_element", 3, 213, 1, 0},
/*  68 */  {"put_string", 3, -1, 0, 0},
/*  69 */  {"put_list", 3, -1, 0, 1},
/*  70 */  {"put_tuple", 2, -1, 0, 0},
/*  71 */  {"put", 1, -1, 0, 0},
/*  72 */  {"badmatch", 1, 6, 1, 0},
/*  73 */  {"if_end", 0, 154, 1, 0},
/*  74 */  {"case_end", 1, 35, 1, 0},
/*  75 */  {"call_fun", 1, -1, 0, 1},
/*  76 */  {"make_fun", 3, -1, 0, 0},
/*  77 */  {"is_function", 2, 164, 1, 1},
/*  78 */  {"call_ext_only", 2, -1, 0, 1},
/*  79 */  {"bs_start_match", 2, -1, 0, 0},
/*  80 */  {"bs_get_integer", 5, -1, 0, 0},
/*  81 */  {"bs_get_float", 5, -1, 0, 0},
/*  82 */  {"bs_get_binary", 5, -1, 0, 0},
/*  83 */  {"bs_skip_bits", 4, -1, 0, 0},
/*  84 */  {"bs_test_tail", 2, -1, 0, 0},
/*  85 */  {"bs_save", 1, -1, 0, 0},
/*  86 */  {"bs_restore", 1, -1, 0, 0},
/*  87 */  {"bs_init", 2, -1, 0, 0},
/*  88 */  {"bs_final", 2, -1, 0, 0},
/*  89 */  {"bs_put_integer", 5, -1, 0, 0},
/*  90 */  {"bs_put_binary", 5, -1, 0, 0},
/*  91 */  {"bs_put_float", 5, -1, 0, 0},
/*  92 */  {"bs_put_string", 2, -1, 0, 0},
/*  93 */  {"bs_need_buf", 1, -1, 0, 0},
/*  94 */  {"fclearerror", 0, -1, 0, 0},
/*  95 */  {"fcheckerror", 1, -1, 0, 0},
/*  96 */  {"fmove", 2, -1, 0, 1},
/*  97 */  {"fconv", 2, 42, 1, 0},
/*  98 */  {"fadd", 4, -1, 0, 1},
/*  99 */  {"fsub", 4, -1, 0, 1},
/* 100 */  {"fmul", 4, -1, 0, 1},
/* 101 */  {"fdiv", 4, -1, 0, 1},
/* 102 */  {"fnegate", 3, -1, 0, 1},
/* 103 */  {"make_fun2", 1, -1, 0, 0},
/* 104 */  {"try", 2, -1, 0, 1},
/* 105 */  {"try_end", 1, 223, 1, 1},
/* 106 */  {"try_case", 1, 221, 1, 0},
/* 107 */  {"try_case_end", 1, 222, 1, 0},
/* 108 */  {"raise", 2, 202, 1, 0},
/* 109 */  {"bs_init2", 6, -1, 0, 0},
/* 110 */  {"bs_bits_to_bytes", 3, -1, 0, 0},
/* 111 */  {"bs_add", 5, -1, 0, 0},
/* 112 */  {"apply", 1, 4, 1, 0},
/* 113 */  {"apply_last", 2, 5, 1, 0},
/* 114 */  {"is_boolean", 2, 160, 1, 0},
/* 115 */  {"is_function2", 3, 165, 1, 0},
/* 116 */  {"bs_start_match2", 5, -1, 0, 0},
/* 117 */  {"bs_get_integer2", 7, 23, 1, 0},
/* 118 */  {"bs_get_float2", 7, -1, 0, 1},
/* 119 */  {"bs_get_binary2", 7, -1, 0, 1},
/* 120 */  {"bs_skip_bits2", 5, -1, 0, 1},
/* 121 */  {"bs_test_tail2", 3, 27, 1, 1},
/* 122 */  {"bs_save2", 2, -1, 0, 0},
/* 123 */  {"bs_restore2", 2, -1, 0, 0},
/* 124 */  {"gc_bif1", 5, -1, 0, 1},
/* 125 */  {"gc_bif2", 6, -1, 0, 1},
/* 126 */  {"bs_final2", 2, -1, 0, 0},
/* 127 */  {"bs_bits_to_bytes2", 2, -1, 0, 0},
/* 128 */  {"put_literal", 2, -1, 0, 0},
/* 129 */  {"is_bitstr", 2, -1, 0, 1},
/* 130 */  {"bs_context_to_binary", 1, -1, 0, 0},
/* 131 */  {"bs_test_unit", 3, 28, 1, 0},
/* 132 */  {"bs_match_string", 4, -1, 0, 1},
/* 133 */  {"bs_init_writable", 0, 25, 1, 0},
/* 134 */  {"bs_append", 8, -1, 0, 0},
/* 135 */  {"bs_private_append", 6, -1, 0, 0},
/* 136 */  {"trim", 2, -1, 0, 1},
/* 137 */  {"bs_init_bits", 6, -1, 0, 0},
/* 138 */  {"bs_get_utf8", 5, -1, 0, 1},
/* 139 */  {"bs_skip_utf8", 4, -1, 0, 1},
/* 140 */  {"bs_get_utf16", 5, -1, 0, 1},
/* 141 */  {"bs_skip_utf16", 4, -1, 0, 1},
/* 142 */  {"bs_get_utf32", 5, -1, 0, 1},
/* 143 */  {"bs_skip_utf32", 4, -1, 0, 1},
/* 144 */  {"bs_utf8_size", 3, -1, 0, 0},
/* 145 */  {"bs_put_utf8", 3, -1, 0, 0},
/* 146 */  {"bs_utf16_size", 3, -1, 0, 0},
/* 147 */  {"bs_put_utf16", 3, -1, 0, 0},
/* 148 */  {"bs_put_utf32", 3, -1, 0, 0},
/* 149 */  {"on_load", 0, 199, 1, 0},
/* 150 */  {"recv_mark", 1, -1, 0, 0},
/* 151 */  {"recv_set", 1, -1, 0, 0},
/* 152 */  {"gc_bif3", 7, -1, 0, 1},
/* 153 */  {"line", 1, 189, 1, 1},
/* 154 */  {"put_map_assoc", 5, -1, 0, 1},
/* 155 */  {"put_map_exact", 5, -1, 0, 1},
/* 156 */  {"is_map", 2, 175, 1, 0},
/* 157 */  {"has_map_fields", 3, -1, 0, 1},
/* 158 */  {"get_map_elements", 3, -1, 0, 1},
/* 159 */  {"is_tagged_tuple", 4, -1, 0, 1},
/* 160 */  {"build_stacktrace", 0, 29, 1, 0},
/* 161 */  {"raw_raise", 0, 203, 1, 0},
/* 162 */  {"get_hd", 2, 47, 1, 0},
/* 163 */  {"get_tl", 2, 49, 1, 0},
/* 164 */  {"put_tuple2", 2, 201, 1, 0},
/* 165 */  {"bs_get_tail", 3, 24, 1, 0},
/* 166 */  {"bs_start_match3", 4, -1, 0, 1},
/* 167 */  {"bs_get_position", 3, -1, 0, 1},
/* 168 */  {"bs_set_position", 2, 26, 1, 0},
/* 169 */  {"swap", 2, 215, 1, 0},
/* 170 */  {"bs_start_match4", 4, -1, 0, 1},
/* 171 */  {"make_fun3", 3, -1, 0, 1},
/* 172 */  {"init_yregs", 1, 155, 1, 0},
/* 173 */  {"recv_marker_bind", 2, 204, 1, 0},
/* 174 */  {"recv_marker_clear", 1, 205, 1, 0},
/* 175 */  {"recv_marker_reserve", 1, 206, 1, 0},
/* 176 */  {"recv_marker_use", 1, 207, 1, 0},
/* 177 */  {"bs_create_bin", 6, -1, 0, 1},
/* 178 */  {"call_fun2", 3, -1, 0, 1},
/* 179 */  {"nif_start", 0, 194, 1, 0},
/* 180 */  {"badrecord", 1, 7, 1, 0},
/* 181 */  {"update_record", 5, 227, 1, 1},
/* 182 */  {"bs_match", 3, -1, 0, 1},
/* 183 */  {"executable_line", 2, 41, 1, 0},
/* 184 */  {"debug_line", 4, -1, 0, 1},

/*
 * Internal generic instructions.
 */

/* 185 */  {"aligned_label", 2, 0, 1, 1},
/* 186 */  {"i_func_label", 1, 107, 1, 0},
/* 187 */  {"i_func_info", 4, 106, 1, 0},
/* 188 */  {"i_generic_breakpoint", 0, 108, 1, 0},
/* 189 */  {"i_debug_breakpoint", 0, 98, 1, 0},
/* 190 */  {"i_call_trace_return", 0, 97, 1, 0},
/* 191 */  {"i_return_to_trace", 0, 142, 1, 0},
/* 192 */  {"trace_jump", 1, 220, 1, 0},
/* 193 */  {"i_yield", 0, 153, 1, 0},
/* 194 */  {"empty_func_line", 0, 40, 1, 0},
/* 195 */  {"func_line", 1, 46, 1, 1},
/* 196 */  {"i_debug_line", 3, 99, 1, 0},
/* 197 */  {"i_line_breakpoint_trampoline", 0, 128, 1, 0},
/* 198 */  {"i_trim", 1, 150, 1, 0},
/* 199 */  {"i_select_val_bins", 3, 144, 2, 0},
/* 200 */  {"i_select_val_lins", 3, 146, 2, 0},
/* 201 */  {"i_select_tuple_arity", 3, 143, 1, 0},
/* 202 */  {"i_jump_on_val", 4, 122, 2, 0},
/* 203 */  {"is_nonempty_list_get_list", 4, 181, 1, 0},
/* 204 */  {"is_nonempty_list_get_hd", 3, 180, 1, 0},
/* 205 */  {"is_nonempty_list_get_tl", 3, 182, 1, 0},
/* 206 */  {"try_end_deallocate", 1, 224, 1, 0},
/* 207 */  {"current_tuple", 1, -1, 0, 1},
/* 208 */  {"current_tuple", 2, -1, 0, 1},
/* 209 */  {"i_is_tuple_of_arity", 3, 120, 1, 0},
/* 210 */  {"i_is_tuple_of_arity_ff", 4, 121, 1, 0},
/* 211 */  {"i_test_arity", 3, 148, 1, 0},
/* 212 */  {"i_is_tagged_tuple", 4, 117, 1, 0},
/* 213 */  {"i_is_tagged_tuple_ff", 5, 118, 1, 0},
/* 214 */  {"i_is_tuple", 2, 119, 1, 0},
/* 215 */  {"load_tuple_ptr", 1, 190, 1, 0},
/* 216 */  {"i_get_tuple_element", 3, 114, 1, 1},
/* 217 */  {"get_two_tuple_elements", 4, 51, 1, 0},
/* 218 */  {"get_tuple_element_swap", 4, 50, 1, 0},
/* 219 */  {"delete_me", 0, -1, 0, 1},
/* 220 */  {"system_limit", 1, -1, 0, 1},
/* 221 */  {"system_limit_body", 0, 216, 1, 0},
/* 222 */  {"i_move", 2, 134, 1, 0},
/* 223 */  {"move_two_words", 4, 192, 1, 0},
/* 224 */  {"timeout_locked", 0, 219, 1, 0},
/* 225 */  {"i_loop_rec", 1, 130, 1, 0},
/* 226 */  {"wait_locked", 1, 229, 1, 0},
/* 227 */  {"wait_unlocked", 1, 232, 1, 0},
/* 228 */  {"wait_timeout_unlocked", 2, 231, 1, 0},
/* 229 */  {"wait_timeout_locked", 2, 230, 1, 0},
/* 230 */  {"is_int_in_range", 4, 171, 1, 0},
/* 231 */  {"is_int_ge", 3, 170, 1, 0},
/* 232 */  {"is_in_range", 5, 169, 1, 0},
/* 233 */  {"is_ge_lt", 5, 168, 1, 0},
/* 234 */  {"is_ge_ge", 5, 167, 1, 0},
/* 235 */  {"store_cons", 2, 214, 1, 1},
/* 236 */  {"put_cons", 2, 200, 1, 0},
/* 237 */  {"append_cons", 2, 3, 1, 0},
/* 238 */  {"normal_exit", 0, 198, 1, 0},
/* 239 */  {"continue_exit", 0, 38, 1, 0},
/* 240 */  {"call_bif", 1, 30, 1, 0},
/* 241 */  {"call_bif_mfa", 3, 31, 1, 0},
/* 242 */  {"call_nif", 3, 34, 1, 0},
/* 243 */  {"call_error_handler", 0, 32, 1, 0},
/* 244 */  {"return_trace", 0, 210, 1, 0},
/* 245 */  {"is_bitstring", 2, 159, 1, 0},
/* 246 */  {"call_light_bif", 1, -1, 0, 1},
/* 247 */  {"i_load_nif", 0, 129, 1, 0},
/* 248 */  {"i_call_on_load_function", 0, 95, 1, 0},
/* 249 */  {"i_validate", 1, 152, 1, 0},
/* 250 */  {"i_apply", 0, 52, 1, 0},
/* 251 */  {"i_apply_last", 1, 56, 1, 0},
/* 252 */  {"i_apply_only", 0, 57, 1, 0},
/* 253 */  {"i_apply_fun", 0, 53, 1, 0},
/* 254 */  {"i_apply_fun_last", 1, 54, 1, 0},
/* 255 */  {"i_apply_fun_only", 0, 55, 1, 0},
/* 256 */  {"call_light_bif", 2, 33, 1, 0},
/* 257 */  {"i_hibernate", 0, 115, 1, 0},
/* 258 */  {"i_perf_counter", 0, 138, 1, 0},
/* 259 */  {"bif_hd", 2, 11, 1, 0},
/* 260 */  {"bif_element", 4, 10, 1, 0},
/* 261 */  {"bif_node", 3, 21, 1, 0},
/* 262 */  {"bif_bit_size", 4, 8, 1, 0},
/* 263 */  {"bif_byte_size", 4, 9, 1, 0},
/* 264 */  {"bif_tuple_size", 4, 22, 1, 0},
/* 265 */  {"bif_map_get", 4, 17, 1, 0},
/* 266 */  {"bif_is_map_key", 5, 15, 1, 0},
/* 267 */  {"bif_max", 3, 19, 1, 0},
/* 268 */  {"bif_min", 3, 20, 1, 0},
/* 269 */  {"i_get_hash", 3, 110, 1, 0},
/* 270 */  {"i_get", 2, 109, 1, 0},
/* 271 */  {"self", 1, 211, 1, 0},
/* 272 */  {"node", 1, 195, 1, 0},
/* 273 */  {"nofail_bif1", 3, 196, 1, 0},
/* 274 */  {"nofail_bif2", 4, 197, 1, 1},
/* 275 */  {"i_bif1", 4, 59, 1, 0},
/* 276 */  {"i_bif2", 5, 60, 1, 0},
/* 277 */  {"i_bif3", 6, 61, 1, 0},
/* 278 */  {"bif_is_eq_exact", 3, 12, 1, 0},
/* 279 */  {"bif_is_ne_exact", 3, 16, 1, 0},
/* 280 */  {"bif_is_ge", 3, 13, 1, 0},
/* 281 */  {"bif_is_lt", 3, 14, 1, 0},
/* 282 */  {"i_call", 1, 84, 1, 0},
/* 283 */  {"i_call_last", 2, 94, 1, 0},
/* 284 */  {"i_call_only", 1, 96, 1, 0},
/* 285 */  {"i_call_ext", 1, 85, 1, 0},
/* 286 */  {"i_call_ext_last", 2, 86, 1, 0},
/* 287 */  {"i_call_ext_only", 1, 87, 1, 0},
/* 288 */  {"i_call_fun", 1, 88, 1, 0},
/* 289 */  {"i_call_fun_last", 2, 93, 1, 0},
/* 290 */  {"i_call_fun2", 3, 89, 2, 0},
/* 291 */  {"i_call_fun2_last", 4, 91, 2, 0},
/* 292 */  {"i_make_fun3", 4, 132, 1, 0},
/* 293 */  {"i_lambda_error", 1, 124, 1, 0},
/* 294 */  {"int_func_start", 5, -1, 0, 1},
/* 295 */  {"int_func_end", 2, -1, 0, 1},
/* 296 */  {"func_prologue", 2, -1, 0, 0},
/* 297 */  {"i_test_yield", 0, 149, 1, 0},
/* 298 */  {"i_nif_padding", 0, 137, 1, 0},
/* 299 */  {"i_lambda_trampoline", 4, 125, 1, 0},
/* 300 */  {"i_breakpoint_trampoline", 0, 64, 1, 0},
/* 301 */  {"i_bs_match", 2, 73, 1, 1},
/* 302 */  {"i_bs_match_test_heap", 4, 75, 1, 0},
/* 303 */  {"bad_bs_match", 1, -1, 0, 1},
/* 304 */  {"i_bs_match_string", 4, 74, 1, 0},
/* 305 */  {"i_bs_get_bin_and_tail", 7, 66, 1, 0},
/* 306 */  {"i_bs_get_binary2", 6, 67, 1, 0},
/* 307 */  {"i_bs_get_binary_all2", 5, 68, 1, 0},
/* 308 */  {"i_bs_get_float2", 6, 69, 1, 0},
/* 309 */  {"i_bs_skip_bits2", 4, 76, 1, 0},
/* 310 */  {"i_bs_start_match3", 4, 79, 1, 0},
/* 311 */  {"i_bs_get_position", 2, 70, 1, 0},
/* 312 */  {"i_bs_get_utf8", 3, 72, 1, 0},
/* 313 */  {"i_bs_skip_utf8", 2, 78, 1, 0},
/* 314 */  {"i_bs_get_utf16", 4, 71, 1, 0},
/* 315 */  {"i_bs_skip_utf16", 3, 77, 1, 0},
/* 316 */  {"i_bs_validate_unicode_retract", 3, 80, 1, 0},
/* 317 */  {"i_bs_create_bin", 4, 65, 1, 0},
/* 318 */  {"fstore", 2, 45, 1, 0},
/* 319 */  {"fload", 2, 43, 2, 0},
/* 320 */  {"i_fadd", 3, 101, 1, 0},
/* 321 */  {"i_fsub", 3, 105, 1, 0},
/* 322 */  {"i_fmul", 3, 103, 1, 0},
/* 323 */  {"i_fdiv", 3, 102, 1, 0},
/* 324 */  {"i_fnegate", 2, 104, 1, 0},
/* 325 */  {"i_put_map_assoc", 4, -1, 0, 1},
/* 326 */  {"sorted_put_map_assoc", 4, -1, 0, 1},
/* 327 */  {"sorted_put_map_exact", 5, -1, 0, 1},
/* 328 */  {"new_map", 3, 193, 1, 1},
/* 329 */  {"i_new_small_map_lit", 4, 136, 1, 0},
/* 330 */  {"update_map_assoc", 4, 225, 1, 0},
/* 331 */  {"update_map_exact", 5, 226, 1, 0},
/* 332 */  {"i_get_map_elements", 3, 113, 1, 0},
/* 333 */  {"i_get_map_element_hash", 5, 112, 1, 1},
/* 334 */  {"i_get_map_element", 4, 111, 1, 1},
/* 335 */  {"gen_plus", 5, -1, 0, 1},
/* 336 */  {"gen_minus", 5, -1, 0, 1},
/* 337 */  {"i_plus", 4, 139, 1, 0},
/* 338 */  {"i_minus", 4, 133, 1, 0},
/* 339 */  {"i_unary_minus", 3, 151, 1, 0},
/* 340 */  {"i_mul_add", 6, 135, 1, 0},
/* 341 */  {"i_m_div", 4, 131, 1, 0},
/* 342 */  {"i_rem_div", 5, 141, 1, 0},
/* 343 */  {"i_div_rem", 5, 100, 1, 0},
/* 344 */  {"i_int_div", 4, 116, 1, 0},
/* 345 */  {"i_rem", 4, 140, 1, 0},
/* 346 */  {"i_bsl", 4, 81, 1, 0},
/* 347 */  {"i_bsr", 4, 82, 1, 0},
/* 348 */  {"i_band", 4, 58, 1, 0},
/* 349 */  {"i_bor", 4, 63, 1, 0},
/* 350 */  {"i_bxor", 4, 83, 1, 0},
/* 351 */  {"i_bnot", 3, 62, 1, 0},
/* 352 */  {"i_length_setup", 3, 127, 1, 0},
/* 353 */  {"i_length", 3, 126, 1, 0},
/* 354 */  {"bif_map_size", 3, 18, 1, 0},
/* 355 */  {"unsupported_guard_bif", 3, -1, 0, 1},
/* 356 */  {"update_record_in_place", 4, 228, 1, 0},
};
