// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

#include "common.h"

#include "bitonic_sort.h"

namespace vxsort {
    namespace smallsort {

        extern "C" alignas(16) const uint8_t mask_table_4[M4_SIZE] = {
            0xFF, 0xFF, 0xFF, 0xFF,  // 0b0000 (0)
            0xFF, 0x00, 0x00, 0x00,  // 0b0001 (1)
            0xFF, 0xFF, 0x00, 0x00,  // 0b0011 (3)
            0xFF, 0xFF, 0xFF, 0x00,  // 0b0111 (7)
        };

        extern "C" alignas(128) const uint8_t mask_table_8[M8_SIZE] = {
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, // 0b00000000 (  0)
            0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 0b00000001 (  1)
            0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // 0b00000011 (  3)
            0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, // 0b00000111 (  7)
            0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, 0x00, // 0b00001111 ( 15)
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, 0x00, // 0b00011111 ( 31)
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, 0x00, // 0b00111111 ( 63)
            0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0x00, // 0b01111111 (127)
        };
    }
}
