/*
==============================================================================

                                 DOOM Retro
           The classic, refined DOOM source port. For Windows PC.

==============================================================================

    Copyright © 1993-2025 by id Software LLC, a ZeniMax Media company.
    Copyright © 2013-2025 by Brad Harding <mailto:brad@doomretro.com>.

    This file is a part of DOOM Retro.

    DOOM Retro is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation, either version 3 of the license, or (at your
    option) any later version.

    DOOM Retro is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
    General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with DOOM Retro. If not, see <https://www.gnu.org/licenses/>.

    DOOM is a registered trademark of id Software LLC, a ZeniMax Media
    company, in the US and/or other countries, and is used without
    permission. All other trademarks are the property of their respective
    holders. DOOM Retro is in no way affiliated with nor endorsed by
    id Software.

==============================================================================
*/

const char *wilv[] =
{
    // 0 = 'A'
    "\x20\x20\x20\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x20\x20\x20\x20\x20\x6A\x6A"
    "\x5B\x59\x51\x51\x53\x61\x6A\x20\x20\x20\x20\x20\x20\x6A\x62\x5C\x5F\x5C\x61\x62\x57\x5B\x64"
    "\x6A\x20\x20\x20\x20\x6A\x61\x5C\x59\x61\x6A\x6A\x5F\x59\x5B\x61\x6A\xFB\x20\x20\x20\x6A\x5C"
    "\x59\x5B\x6A\x6A\x6A\x5F\x59\x5C\x5F\x6A\xFB\x20\x20\x6A\x61\x57\x57\x61\x6A\x55\x55\x5B\x59"
    "\x5B\x61\x6A\xFB\x20\x20\x6A\x5C\x57\x59\x6A\x6A\x5F\x62\x5F\x59\x5C\x61\x6A\xFB\x20\x6A\x61"
    "\x57\x55\x61\x6A\x6A\x6A\x6A\x5F\x5B\x5B\x5F\x6A\xFB\x20\x6A\x5B\x51\x53\x6A\xFB\xFB\xFB\x6A"
    "\x61\x5B\x59\x61\x6A\xFB\x6A\x5C\x57\x51\x61\x6A\xFB\x20\x20\x6A\x61\x5B\x57\x61\x6A\xFB\x6A"
    "\x5C\x5C\x5B\x6A\xFB\xFB\x20\x20\x6A\x62\x61\x5F\x62\x6A\xFB\x6A\x6A\x6A\x6A\x6A\xFB\x20\x20"
    "\x20\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB"
    "\xFB",

    // 1 = 'B'
    "\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x6A\x59\x53\x51\x53\x55\x50"
    "\x50\x51\x51\x50\x57\x5F\x6A\x20\x20\x6A\x5F\x5F\x5F\x61\x64\x5F\x5F\x5F\x5F\x53\x53\x55\x5F"
    "\x6A\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x61\x53\x57\x53\x5F\x6A\xFB\x6A\x6A\x6A\x6A\x6A"
    "\x6A\x6A\x6A\x6A\x61\x5B\x53\x50\x62\x6A\xFB\x6A\x5B\x51\x51\x51\x51\x50\x51\x51\x51\x57\x53"
    "\x62\x6A\xFB\xFB\x6A\x5B\x5B\x55\x59\x5C\x5C\x5F\x5C\x5C\x57\x50\x62\x6A\xFB\x20\x6A\x5B\x5C"
    "\x53\x5B\x6A\x6A\x6A\x6A\x61\x53\x53\x50\x5B\x6A\x20\x6A\x5B\x5C\x55\x59\x6A\x6A\x6A\x6A\x61"
    "\x51\x57\x59\x5B\x6A\xFB\x6A\x5C\x5B\x57\x59\x50\x51\x50\x50\x51\x55\x57\x59\x62\x6A\xFB\x6A"
    "\x62\x61\x5F\x61\x5B\x5C\x59\x59\x5C\x5B\x5B\x5F\x6A\xFB\xFB\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A"
    "\x6A\x6A\x6A\x6A\x6A\xFB\xFB\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20"
    "\x20",

    // 2 = 'C'
    "\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x6A\x6A\x62\x5C\x5C\x59"
    "\x51\x51\x51\x51\x59\x6A\xFB\x20\x6A\x62\x59\x64\x64\x64\x64\x5C\x61\x5C\x5F\x61\x6A\xFB\x20"
    "\x6A\x5C\x5F\x64\x66\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x6A\x62\x5C\x5F\x64\x6A\xFB\xFB\xFB"
    "\xFB\xFB\xFB\xFB\xFB\xFB\x6A\x5F\x5C\x61\x64\x6A\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x6A\x5F"
    "\x5C\x61\x62\x6A\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x6A\x62\x5C\x62\x64\x6A\xFB\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x6A\x5C\x62\x64\x5C\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x6A\x64"
    "\x62\x64\x62\x55\x51\x55\x51\x53\x51\x59\x6A\xFB\x20\x20\x6A\x6A\x67\x62\x62\x5C\x62\x61\x61"
    "\x61\x5F\x6A\xFB\x20\x20\x20\xFB\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\x20\x20\x20"
    "\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB",

    // 3 = 'D'
    "\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x20\x20\x68\x5C\x51\x51\x51\x51\x50"
    "\x50\x51\x55\x61\x6A\x6A\x20\x20\x20\x6A\x62\x61\x5F\x5F\x5F\x5C\x5C\x5F\x59\x59\x57\x62\x6A"
    "\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x5F\x57\x55\x59\x6A\xFB\x20\x6A\x6A\x6A\x6A\x6A"
    "\x6A\xFB\xFB\xFB\x6A\x57\x51\x59\x62\x6A\x20\x6A\x5C\x57\x57\x5C\x6A\xFB\x20\x20\x6A\x57\x51"
    "\x55\x5F\x6A\xFB\x6A\x5F\x5B\x5C\x5F\x6A\xFB\x20\x20\x6A\x57\x51\x53\x5F\x6A\xFB\x6A\x5C\x5B"
    "\x5B\x5F\x6A\xFB\x20\x20\x6A\x55\x51\x53\x62\x6A\xFB\x6A\x5C\x59\x59\x5C\x6A\x6A\x6A\x6A\x55"
    "\x55\x51\x5B\x6A\xFB\xFB\x6A\x5C\x5B\x57\x55\x51\x50\x50\x55\x57\x53\x5B\x62\x6A\xFB\x20\x6A"
    "\x61\x5F\x5F\x5C\x5C\x5C\x5C\x5F\x5F\x61\x6A\x6A\xFB\xFB\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A"
    "\x6A\x6A\x6A\xFB\xFB\xFB\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20"
    "\x20",

    // 4 = 'E'
    "\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x6A\x6A\x5F\x55\x59\x53"
    "\x53\x55\x55\x53\x5C\x6A\xFB\x20\x6A\x64\x5B\x59\x59\x61\x62\x61\x64\x64\x5F\x62\x6A\xFB\x20"
    "\x6A\x5F\x57\x57\x5F\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x6A\x61\x59\x57\x57\x5F\x6A\x6A\x6A"
    "\x6A\x6A\x6A\x6A\x6A\xFB\x6A\x5F\x59\x57\x57\x57\x57\x55\x55\x55\x51\x51\x5F\x6A\xFB\x6A\x5F"
    "\x59\x59\x57\x59\x61\x64\x62\x64\x61\x5F\x62\x6A\xFB\x6A\x61\x57\x57\x55\x5F\x6A\x6A\x6A\x6A"
    "\x6A\x6A\x6A\x6A\xFB\x20\x6A\x5B\x51\x53\x5F\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\x6A\x64"
    "\x5F\x53\x57\x53\x51\x51\x51\x53\x55\x5B\x6A\xFB\x20\x20\x6A\x6A\x61\x5C\x5F\x5F\x61\x5F\x61"
    "\x61\x61\x6A\xFB\x20\x20\x20\xFB\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\x20\x20\x20"
    "\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB",

    // 5 = 'F'
    "\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x6A\x6A\x61\x55\x50\x50\x50\x51"
    "\x5B\x6A\xFB\x20\x6A\x64\x61\x59\x5F\x5F\x5F\x5C\x5C\x61\x6A\xFB\x20\x6A\x5C\x61\x57\x61\x6A"
    "\x6A\x6A\x6A\x6A\x6A\xFB\x6A\x62\x5C\x5C\x57\x6A\x6A\x6A\x6A\xFB\xFB\xFB\xFB\x6A\x5F\x5B\x57"
    "\x55\x50\x50\x59\x6A\xFB\x20\x20\x20\x6A\x5F\x59\x55\x55\x5F\x5C\x61\x6A\xFB\x20\x20\x20\x6A"
    "\x5C\x5B\x57\x5F\x6A\x6A\x6A\x6A\xFB\x20\x20\x20\x6A\x5F\x59\x53\x5C\x6A\xFB\xFB\xFB\xFB\x20"
    "\x20\x20\x6A\x5F\x59\x51\x5C\x6A\xFB\x20\x20\x20\x20\x20\x20\x6A\x61\x61\x5B\x61\x6A\xFB\x20"
    "\x20\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB"
    "\xFB\xFB\x20\x20\x20\x20\x20\x20",

    // 6 = 'G'
    "\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x6A\x6A\x62\x5C"
    "\x5C\x57\x55\x51\x51\x51\x51\x55\x5F\x6A\xFB\x20\x6A\x64\x5C\x5F\x64\x66\x64\x64\x5C\x61\x5C"
    "\x5F\x5F\x62\x6A\xFB\x20\x6A\x59\x5C\x5F\x64\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x6A"
    "\x62\x5B\x5C\x5F\x6A\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x6A\x61\x5C\x5C\x61\x6A\xFB"
    "\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x20\x6A\x61\x5C\x5C\x61\x6A\xFB\x20\x20\x20\x6A\x59\x50"
    "\x50\x5C\x6A\xFB\x6A\x61\x57\x5C\x62\x6A\xFB\x20\x20\x20\x6A\x5C\x51\x50\x5F\x6A\xFB\x20\x6A"
    "\x53\x5C\x62\x64\x6A\x6A\x6A\x6A\x6A\x5F\x51\x50\x5F\x6A\xFB\x20\x6A\x64\x5B\x62\x64\x5B\x51"
    "\x50\x51\x53\x5C\x51\x50\x5F\x6A\xFB\x20\x20\x6A\x6A\x66\x67\x62\x62\x5C\x62\x61\x61\x5B\x5B"
    "\x61\x6A\xFB\x20\x20\x20\xFB\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\x20\x20"
    "\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB",

    // 7 = 'H'
    "\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x20\x6A\x5C\x55\x55\x5B\x6A\xFB"
    "\x20\x20\x6A\x5B\x51\x51\x5B\x6A\xFB\x6A\x61\x5F\x5C\x5C\x6A\xFB\x20\x20\x6A\x5C\x59\x57\x61"
    "\x6A\xFB\x6A\x61\x5C\x5C\x5F\x6A\xFB\x20\x20\x6A\x5C\x57\x55\x5F\x6A\xFB\x6A\x61\x5C\x5C\x5F"
    "\x6A\x6A\x6A\x6A\x6A\x5C\x57\x51\x5F\x6A\xFB\x6A\x61\x5C\x5C\x5C\x59\x55\x51\x51\x53\x59\x57"
    "\x51\x5B\x6A\xFB\x6A\x61\x5B\x5B\x61\x61\x61\x5F\x5F\x5F\x5F\x57\x51\x5B\x6A\xFB\x6A\x5F\x59"
    "\x5B\x61\x6A\x6A\x6A\x6A\x6A\x5F\x55\x51\x5B\x6A\xFB\x6A\x5F\x57\x59\x61\x6A\xFB\xFB\xFB\x6A"
    "\x5F\x55\x51\x5B\x6A\xFB\x6A\x5F\x59\x5B\x5F\x6A\xFB\x20\x20\x6A\x5C\x53\x53\x5B\x6A\xFB\x6A"
    "\x61\x5F\x5F\x62\x6A\xFB\x20\x20\x6A\x61\x5C\x5B\x61\x6A\xFB\x6A\x68\x6A\x6A\x68\x6A\xFB\x20"
    "\x20\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\xFB\xFB\xFB\xFB\xFB"
    "\xFB",

    // 8 = 'I'
    "\x6A\x6A\x6A\x6A\x6A\x6A\x20\x6A\x5B\x53\x53\x5C\x6A\xFB\x6A\x5F\x5F\x5C\x62\x6A\xFB\x6A\x5C"
    "\x61\x5C\x61\x6A\xFB\x6A\x5F\x61\x61\x61\x6A\xFB\x6A\x5F\x61\x5F\x61\x6A\xFB\x6A\x5F\x62\x5F"
    "\x62\x6A\xFB\x6A\x5C\x5F\x62\x62\x6A\xFB\x6A\x5C\x5B\x5F\x61\x6A\xFB\x6A\x5C\x57\x5C\x5F\x6A"
    "\xFB\x6A\x61\x5F\x61\x61\x6A\xFB\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB",

    // 9 = 'J'
    "\x20\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x20\x20\x20\x6A\x5B\x51\x55\x61\x6A"
    "\xFB\x20\x20\x20\x20\x20\x6A\x62\x59\x5F\x64\x6A\xFB\x20\x20\x20\x20\x20\x6A\x62\x61\x61\x62"
    "\x6A\xFB\x20\x20\x20\x20\x20\x6A\x62\x61\x62\x62\x6A\xFB\x20\x20\x20\x20\x20\x6A\x61\x5F\x5C"
    "\x62\x6A\xFB\x20\x20\x20\x20\x20\x6A\x5F\x5C\x5C\x61\x6A\xFB\x20\x20\x20\x20\x20\x6A\x62\x5F"
    "\x59\x5F\x6A\xFB\x6A\x6A\x6A\x6A\x6A\x5F\x62\x5C\x59\x5F\x6A\xFB\x6A\x59\x53\x55\x53\x51\x5F"
    "\x5F\x5C\x6A\x6A\xFB\x6A\x5F\x5C\x5F\x5F\x5B\x62\x62\x6A\x6A\xFB\xFB\x6A\x6A\x6A\x6A\x6A\x6A"
    "\x6A\x6A\xFB\xFB\xFB\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20",

    // 10 = 'K'
    "\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x6A\x59\x51\x50\x57\x6A"
    "\xFB\x20\x6A\x50\x50\x50\x50\x5C\x6A\xFB\x20\x6A\x5B\x59\x53\x55\x6A\xFB\x6A\x50\x55\x59\x57"
    "\x61\x6A\xFB\xFB\x20\x6A\x59\x53\x55\x59\x6A\x6A\x51\x55\x55\x55\x5C\x6A\xFB\xFB\x20\x20\x6A"
    "\x5B\x51\x50\x5B\x6A\x51\x57\x55\x53\x5F\x6A\xFB\xFB\x20\x20\x20\x6A\x5F\x53\x51\x55\x57\x59"
    "\x5B\x55\x55\x6A\xFB\xFB\x20\x20\x20\x20\x6A\x5C\x53\x51\x5B\x6A\x5F\x55\x53\x53\x51\x6A\x20"
    "\x20\x20\x20\x20\x6A\x5B\x55\x51\x5B\x6A\x6A\x5C\x53\x51\x53\x57\x6A\x20\x20\x20\x20\x6A\x5C"
    "\x57\x51\x59\x6A\xFB\x6A\x5C\x51\x53\x5C\x55\x6A\x20\x20\x20\x6A\x59\x57\x53\x59\x6A\xFB\x20"
    "\x6A\x5B\x55\x5C\x5B\x57\x6A\x20\x20\x6A\x5F\x5C\x5C\x5F\x6A\xFB\x20\x20\x6A\x62\x64\x61\x62"
    "\x59\x6A\x20\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\xFB\xFB"
    "\xFB\xFB\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB",

    // 11 = 'L'
    "\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x20\x20\x20\x6A\x61\x55\x51\x5B\x6A\xFB\x20\x20\x20\x20"
    "\x20\x6A\x64\x5F\x59\x62\x6A\xFB\x20\x20\x20\x20\x20\x6A\x62\x61\x61\x62\x6A\xFB\x20\x20\x20"
    "\x20\x20\x6A\x62\x62\x61\x62\x6A\xFB\x20\x20\x20\x20\x20\x6A\x62\x5C\x5F\x61\x6A\xFB\x20\x20"
    "\x20\x20\x20\x6A\x61\x5C\x5C\x5F\x6A\xFB\x20\x20\x20\x20\x20\x6A\x5F\x59\x5F\x62\x6A\xFB\x20"
    "\x20\x20\x20\x20\x6A\x5F\x59\x5C\x62\x5F\x6A\x6A\x6A\x6A\x6A\x20\x20\x6A\x5C\x5F\x5F\x51\x53"
    "\x55\x53\x59\x6A\xFB\x20\x6A\x6A\x62\x62\x5B\x5F\x5F\x5C\x5F\x6A\xFB\x20\x20\xFB\x6A\x6A\x6A"
    "\x6A\x6A\x6A\x6A\x6A\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB",

    // 12 = 'M'
    "\x20\x20\x6A\x6A\x6A\x20\x20\x20\x20\x20\x20\x6A\x6A\x6A\x20\x20\x20\x20\x6A\x57\x50\x59\x6A"
    "\x20\x20\x20\x20\x6A\x55\x50\x53\x6A\x20\x20\x6A\x5C\x51\x50\x57\x59\x6A\x20\x20\x6A\x57\x5C"
    "\x55\x59\x5C\x6A\x20\x6A\x5B\x53\x53\x59\x62\x5B\x6A\x6A\x53\x5F\x5B\x59\x5C\x62\x6A\xFB\x6A"
    "\x5C\x53\x57\x5C\x62\x62\x55\x55\x57\x5B\x57\x5B\x5C\x62\x6A\xFB\x6A\x59\x53\x57\x59\x64\x62"
    "\x61\x5F\x57\x59\x55\x5C\x61\x64\x6A\xFB\x6A\x59\x53\x55\x5B\x64\x62\x61\x5C\x59\x57\x53\x61"
    "\x61\x65\x6A\xFB\x6A\x59\x55\x53\x5C\x6A\x64\x61\x59\x5F\x6A\x5B\x61\x62\x62\x6A\xFB\x6A\x57"
    "\x55\x55\x5B\x6A\x6A\x61\x5F\x6A\x6A\x5C\x61\x61\x62\x6A\xFB\x6A\x57\x53\x53\x5B\x6A\xFB\x6A"
    "\x6A\xFB\x6A\x5C\x62\x5F\x5F\x6A\xFB\x6A\x5C\x5C\x5C\x5F\x6A\xFB\x20\xFB\xFB\x6A\x61\x64\x62"
    "\x61\x6A\xFB\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\xFB\xFB"
    "\xFB\xFB\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB",

    // 13 = 'N'
    "\x20\x20\x6A\x6A\x6A\x20\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x6A\x50\x50\x61\x6A"
    "\x20\x20\x20\x20\x6A\x5C\xA8\x50\x5C\x68\xFB\x6A\x5C\x55\x57\x55\x61\x6A\x20\x20\x20\x6A\x59"
    "\xA8\x55\x5C\x6A\xFB\x6A\x5F\x59\x57\x57\x59\x61\x6A\x20\x20\x6A\x59\xA8\x57\x5F\x6A\xFB\x6A"
    "\x5F\x57\x57\x55\x59\x59\x61\x6A\x20\x6A\x5B\xA8\x55\x5F\x6A\xFB\x6A\x61\x59\x59\x59\x59\x59"
    "\x59\x61\x6A\x6A\x5B\xA8\x53\x5F\x6A\xFB\x6A\x61\x59\x57\x55\x59\x59\x55\x51\x61\x6A\x59\xA8"
    "\x53\x5F\x6A\xFB\x6A\x61\x59\x55\x5B\x6A\x61\x51\x51\x55\x55\x51\xA8\x53\x5F\x6A\xFB\x6A\x61"
    "\x57\x53\x5C\x6A\x6A\x61\x51\x57\x55\x51\xA8\x53\x5F\x6A\xFB\x6A\x62\x57\x53\x5C\x6A\xFB\x6A"
    "\x61\x53\x51\x51\xA8\x51\x62\x6A\xFB\x6A\x62\x5F\x5C\x61\x6A\xFB\x20\x6A\x6A\x61\x5C\x59\x5C"
    "\x6A\xFB\xFB\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\x20\xFB\x6A\x6A\x6A\x6A\xFB\xFB\x20\x20\xFB\xFB"
    "\xFB\xFB\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\x20\x20",

    // 14 = 'O'
    "\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x20\x20\x20\x20\x6A\x6A\x5F"
    "\x53\x50\x50\x50\x50\x50\x55\x5F\x6A\x6A\x20\x20\x20\x20\x6A\x62\x50\x57\x57\x5C\x5C\x62\x62"
    "\x61\x59\x5B\x5C\x62\x6A\x20\x20\x20\x6A\x51\x53\x57\x62\x6A\x6A\x6A\x6A\x6A\x64\x5B\x5C\x57"
    "\x6A\xFB\x20\x6A\x61\x55\x57\x5C\x6A\xFB\xFB\xFB\xFB\xFB\x6A\x5F\x5C\x59\x61\x6A\x20\x6A\x5C"
    "\x55\x57\x5C\x6A\xFB\x20\x20\x20\x20\x6A\x5F\x61\x5F\x61\x6A\xFB\x6A\x5C\x55\x55\x5C\x6A\xFB"
    "\x20\x20\x20\x20\x6A\x5F\x62\x62\x61\x6A\xFB\x6A\x5C\x55\x53\x59\x6A\xFB\x20\x20\x20\x20\x6A"
    "\x61\x62\x62\x61\x6A\xFB\x20\x6A\x51\x51\x53\x57\x6A\x6A\x6A\x6A\x6A\x59\x5F\x61\x61\x6A\xFB"
    "\xFB\x20\x6A\x62\x5B\x51\x57\x50\x50\x50\x53\x55\x5C\x61\x5C\x64\x6A\xFB\x20\x20\x20\x6A\x6A"
    "\x5F\x5F\x5C\x5B\x5F\x64\x61\x62\x62\x6A\x6A\xFB\xFB\x20\x20\x20\x20\xFB\x6A\x6A\x6A\x6A\x6A"
    "\x6A\x6A\x6A\x6A\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB"
    "\x20\x20\x20\x20",

    // 15 = 'P'
    "\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x6A\x5C\x50\x51\x50\x50\x50"
    "\x50\x50\x51\x51\x51\x61\x6A\x20\x20\x6A\x61\x5C\x5F\x5C\x5F\x5F\x5F\x5C\x5B\x5B\x55\x51\x61"
    "\x6A\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x5C\x57\x53\x59\x6A\xFB\x6A\x6A\x6A\x6A\x6A"
    "\x6A\x6A\x6A\x6A\x6A\x5C\x55\x57\x5C\x6A\xFB\x6A\x5B\x51\x50\x50\x50\x50\x50\x53\x51\x53\x53"
    "\x57\x53\x6A\xFB\x6A\x5C\x55\x59\x59\x5C\x61\x61\x5F\x5B\x53\x53\x53\x6A\xFB\xFB\x6A\x5B\x55"
    "\x57\x57\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\xFB\xFB\x20\x6A\x59\x57\x55\x59\x6A\xFB\xFB\xFB\xFB"
    "\xFB\xFB\xFB\xFB\x20\x20\x6A\x59\x57\x55\x59\x6A\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x6A"
    "\x5F\x61\x61\x5F\x6A\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20",

    // 16 = 'Q'
    "\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x20\x20\x20\x20\x6A\x6A\x5F"
    "\x53\x50\x50\x50\x50\x50\x55\x5F\x6A\x6A\x20\x20\x20\x20\x6A\x62\x50\x57\x57\x5C\x5C\x62\x62"
    "\x61\x59\x5B\x5C\x62\x6A\x20\x20\x20\x6A\x51\x53\x57\x62\x6A\x6A\x6A\x6A\x6A\x64\x5B\x5C\x57"
    "\x6A\xFB\x20\x6A\x61\x55\x57\x5C\x6A\xFB\xFB\xFB\xFB\xFB\x6A\x5F\x5C\x59\x61\x6A\x20\x6A\x5C"
    "\x55\x57\x5C\x6A\xFB\x20\x20\x20\x20\x6A\x5F\x61\x5F\x61\x6A\xFB\x6A\x5C\x55\x55\x5C\x6A\xFB"
    "\x20\x20\x20\x6A\x6A\x5F\x62\x62\x61\x6A\xFB\x6A\x5C\x55\x53\x59\x6A\xFB\x20\x20\x6A\x62\x62"
    "\x61\x62\x62\x61\x6A\xFB\x20\x6A\x51\x51\x53\x57\x6A\x6A\x6A\x6A\x5C\x59\x5F\x61\x61\x6A\xFB"
    "\xFB\x20\x6A\x62\x5B\x51\x57\x50\x50\x50\x53\x55\x5C\x61\x5C\x64\x61\x6A\x20\x20\x20\x6A\x6A"
    "\x5F\x5F\x5C\x5B\x5F\x64\x61\x62\x62\x61\x62\x5C\x6A\xFB\x20\x20\x20\xFB\x6A\x6A\x6A\x6A\x6A"
    "\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB"
    "\xFB\xFB\xFB\xFB",

    // 17 = 'R'
    "\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x6A\x5C\x50\x51\x50\x50\x50"
    "\x50\x50\x51\x51\x51\x61\x6A\x20\x20\x6A\x61\x5C\x5F\x5C\x5F\x5F\x5F\x5C\x5B\x5B\x55\x51\x61"
    "\x6A\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x5C\x57\x53\x59\x6A\xFB\x6A\x6A\x6A\x6A\x6A"
    "\x6A\x6A\x6A\x6A\x6A\x5C\x55\x57\x5C\x6A\xFB\x6A\x5B\x51\x50\x50\x50\x50\x50\x53\x51\x53\x53"
    "\x57\x6A\x6A\xFB\x6A\x5C\x55\x59\x59\x5C\x61\x61\x5F\x5B\x53\x53\x55\x6A\x6A\xFB\x6A\x5B\x55"
    "\x57\x57\x6A\x6A\x6A\x6A\x61\x51\x53\x55\x5B\x6A\xFB\x6A\x59\x57\x55\x59\x6A\xFB\xFB\xFB\x6A"
    "\x51\x53\x53\x5C\x6A\xFB\x6A\x59\x57\x55\x59\x6A\xFB\x20\x20\x6A\x53\x51\x51\x59\x6A\xFB\x6A"
    "\x5F\x61\x61\x5F\x6A\xFB\x20\x20\x6A\x5C\x61\x5F\x5F\x6A\xFB\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20"
    "\x20\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\xFB\xFB\xFB\xFB\xFB"
    "\xFB",

    // 18 = 'S'
    "\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x6A\x59\x53\x51\x51\x51"
    "\x51\x55\x59\x55\x5B\x5F\x61\x6A\xFB\x6A\x62\x55\x55\x5C\x62\x64\x62\x61\x61\x61\x66\x68\x64"
    "\x6A\xFB\x6A\x5F\x55\x55\x5C\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x6A\x5F\x55\x53\x5C"
    "\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\xFB\xFB\xFB\x6A\x62\x55\x55\x5B\x53\x51\x51\x51\x55\x55\x59"
    "\x61\x6A\x20\x20\x20\x6A\x61\x64\x61\x64\x61\x5F\x61\x64\x64\x5C\x5C\x62\x6A\x20\x20\x20\x6A"
    "\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x64\x5C\x5F\x61\x6A\xFB\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A"
    "\x62\x5C\x5F\x61\x6A\xFB\x6A\x5C\x51\x50\x50\x53\x51\x53\x59\x57\x59\x5C\x5C\x62\x6A\xFB\x6A"
    "\x61\x61\x5F\x61\x64\x61\x62\x61\x5F\x5F\x61\x64\x6A\xFB\xFB\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A"
    "\x6A\x6A\x6A\x6A\x6A\xFB\xFB\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20"
    "\x20",

    // 19 = 'T'
    "\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x6A\x5C\x51\x50\x50\x50\x50\x51\x51\x51"
    "\x57\x6A\xFB\x6A\x62\x62\x59\x59\x50\x53\x59\x5F\x62\x62\x6A\xFB\x6A\x6A\x6A\x6A\x57\x51\x53"
    "\x5B\x6A\x6A\x6A\x6A\xFB\x20\xFB\xFB\x6A\x57\x53\x59\x59\x6A\xFB\xFB\xFB\xFB\x20\x20\x20\x6A"
    "\x57\x50\x57\x5C\x6A\xFB\x20\x20\x20\x20\x20\x20\x6A\x57\x50\x57\x5C\x6A\xFB\x20\x20\x20\x20"
    "\x20\x20\x6A\x57\x51\x55\x5C\x6A\xFB\x20\x20\x20\x20\x20\x20\x6A\x57\x53\x53\x5B\x6A\xFB\x20"
    "\x20\x20\x20\x20\x20\x6A\x59\x53\x53\x59\x6A\xFB\x20\x20\x20\x20\x20\x20\x6A\x5F\x5C\x5C\x5F"
    "\x6A\xFB\x20\x20\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\x20\x20\x20\x20\x20\x20\xFB"
    "\xFB\xFB\xFB\xFB\xFB\x20\x20\x20",

    // 20 = 'U'
    "\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x20\x6A\x5B\x51\x51\x5F\x6A"
    "\xFB\x20\x20\x20\x6A\x5C\x55\x51\x59\x6A\xFB\x6A\x61\x62\x62\x62\x6A\xFB\x20\x20\x20\x6A\x61"
    "\x5F\x57\x59\x6A\xFB\x6A\x62\x62\x62\x61\x6A\xFB\x20\x20\x20\x6A\x5F\x5B\x5B\x5B\x6A\xFB\x6A"
    "\x62\x62\x62\x61\x6A\xFB\x20\x20\x20\x6A\x5F\x5C\x5C\x5C\x6A\xFB\x6A\x64\x62\x61\x61\x6A\xFB"
    "\x20\x20\x20\x6A\x62\x61\x61\x5F\x6A\xFB\x6A\x64\x62\x61\x5F\x6A\xFB\x20\x20\x20\x6A\x62\x62"
    "\x61\x5F\x6A\xFB\x6A\x62\x62\x61\x5C\x6A\xFB\x20\x20\x20\x6A\x62\x61\x5F\x62\x6A\xFB\x20\x6A"
    "\x62\x61\x59\x55\x6A\x6A\x6A\x6A\x61\x5F\x5C\x5C\x6A\xFB\xFB\x20\x6A\x66\x5C\x5C\x51\x50\x51"
    "\x55\x55\x5C\x5B\x59\x64\x6A\xFB\x20\x20\x20\x6A\x6A\x64\x61\x61\x62\x66\x64\x5F\x64\x6A\x6A"
    "\xFB\xFB\x20\x20\x20\x20\xFB\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\xFB\xFB\xFB\x20\x20\x20\x20\x20"
    "\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20",

    // 21 = 'V'
    "\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x20\x6A\x5B\x50\x50\x59\x6A"
    "\xFB\x20\x20\x20\x6A\x59\x51\x50\x50\x6A\xFB\x6A\x5F\x55\x57\x5B\x6A\xFB\x20\x20\x20\x6A\x59"
    "\x55\x55\x5C\x6A\xFB\x20\x6A\x59\x57\x57\x5F\x6A\x20\x20\x6A\x5C\x53\x57\x57\x6A\xFB\xFB\x20"
    "\x6A\x5C\x57\x55\x5C\x6A\xFB\x20\x6A\x59\x55\x57\x5C\x6A\xFB\x20\x20\x20\x6A\x59\x59\x59\x5F"
    "\x6A\x6A\x5C\x57\x55\x53\x6A\xFB\xFB\x20\x20\x20\x6A\x5C\x55\x59\x59\x5F\x5F\x53\x57\x51\x5C"
    "\x6A\xFB\x20\x20\x20\x20\x20\x6A\x55\x57\x57\x51\x51\x55\x55\x51\x6A\xFB\xFB\x20\x20\x20\x20"
    "\x20\x6A\x5C\x55\x59\x55\x51\x57\x55\x5C\x6A\xFB\x20\x20\x20\x20\x20\x20\x20\x6A\x55\x59\x5B"
    "\x55\x53\x51\x6A\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x6A\x5F\x62\x62\x64\x5C\x5B\x6A\xFB\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\xFB\xFB\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20",

    // 22 = 'W'
    "\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x20\x6A\x59\x51\x57\x6A\xFB"
    "\x20\x20\x20\x20\x20\x6A\x5F\x59\x5C\x6A\xFB\x6A\x5B\x57\x5B\x6A\xFB\x20\x6A\x6A\x20\x20\x6A"
    "\x64\x66\x61\x6A\xFB\x6A\x5B\x57\x5B\x6A\xFB\x6A\x51\x51\x6A\x20\x6A\x62\x64\x5F\x6A\xFB\x6A"
    "\x5B\x57\x5B\x6A\x6A\x51\x5B\x5C\x51\x6A\x6A\x61\x62\x5F\x6A\xFB\x6A\x5C\x5B\x5B\x6A\x51\x5C"
    "\x5B\x5B\x5B\x55\x6A\x61\x5F\x5F\x6A\xFB\x6A\x5B\x55\x59\x53\x55\x5B\x5B\x59\x5C\x62\x62\x5F"
    "\x5C\x5F\x6A\xFB\x6A\x59\x53\x53\x51\x53\x5C\x64\x62\x5F\x62\x62\x5C\x5F\x5C\x6A\xFB\x6A\x59"
    "\x57\x55\x51\x53\x64\x6A\x6A\x62\x61\x61\x5C\x5F\x5C\x6A\xFB\x6A\x61\x57\x53\x51\x5C\x6A\xFB"
    "\xFB\x6A\x61\x59\x5C\x5C\x5F\x6A\xFB\x20\x6A\x62\x61\x64\x6A\xFB\xFB\x20\x20\x6A\x66\x64\x66"
    "\x6A\xFB\xFB\x20\x20\x6A\x6A\x6A\xFB\xFB\x20\x20\x20\x20\x6A\x6A\x6A\xFB\xFB\x20\x20\x20\x20"
    "\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\x20\x20",

    // 23 = 'X'
    "\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x20\x6A\x55\x55\x50\x50\x6A"
    "\x20\x20\x20\x20\x6A\x51\x51\x50\x51\x6A\xFB\x6A\x62\x5F\x57\x51\x53\x6A\x20\x20\x6A\x51\x57"
    "\x55\x57\x5F\x6A\xFB\x6A\x6A\x61\x5B\x55\x53\x53\x6A\x6A\x53\x57\x59\x57\x5F\x6A\xFB\xFB\x20"
    "\xFB\x6A\x61\x59\x51\x57\x50\x50\x57\x55\x59\x5F\x6A\xFB\xFB\x20\x20\x20\x20\x6A\x61\x51\x5B"
    "\x59\x57\x59\x59\x5F\x6A\xFB\xFB\x20\x20\x20\x20\x20\x6A\x51\x57\x5B\x51\x59\x59\x51\x5F\x6A"
    "\xFB\x20\x20\x20\x20\x20\x6A\x61\x59\x51\x57\x50\x50\x57\x55\x59\x5F\x6A\x20\x20\x20\x6A\x6A"
    "\x61\x5B\x55\x53\x53\x6A\x6A\x53\x57\x59\x57\x5F\x6A\x20\x20\x6A\x62\x5F\x57\x51\x53\x6A\xFB"
    "\xFB\x6A\x51\x57\x55\x57\x5F\x6A\x20\x6A\x55\x55\x50\x50\x6A\xFB\xFB\x20\x20\x6A\x51\x51\x50"
    "\x51\x6A\xFB\x6A\x6A\x6A\x6A\x6A\xFB\xFB\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\xFB\x20\xFB\xFB"
    "\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB",

    // 24 = 'Y'
    "\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x20\x6A\x55\x55\x50\x50\x6A"
    "\x20\x20\x20\x20\x6A\x51\x51\x50\x51\x6A\xFB\x6A\x62\x5F\x57\x51\x53\x6A\x20\x20\x6A\x51\x57"
    "\x55\x57\x5F\x6A\xFB\x6A\x6A\x61\x5B\x55\x53\x53\x6A\x6A\x53\x57\x59\x57\x5F\x6A\xFB\xFB\x20"
    "\xFB\x6A\x61\x59\x51\x57\x50\x50\x57\x55\x59\x5F\x6A\xFB\xFB\x20\x20\x20\x20\x6A\x61\x51\x5B"
    "\x59\x59\x59\x59\x5F\x6A\xFB\xFB\x20\x20\x20\x20\x20\x20\x6A\x5C\x5B\x59\x59\x57\x5C\x6A\xFB"
    "\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x6A\x5F\x59\x59\x5B\x6A\xFB\xFB\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x6A\x61\x59\x57\x59\x6A\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x6A\x62\x5C"
    "\x57\x59\x6A\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x6A\x62\x61\x5F\x5F\x6A\xFB\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20",

    // 25 = 'Z'
    "\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x6A\x57\x50\x50\x50\x51"
    "\x50\x50\x50\x50\x51\x50\x51\x51\x5B\x6A\xFB\x6A\x5F\x5C\x5B\x5C\x5F\x5C\x59\x50\x57\x57\x55"
    "\x55\x59\x5C\x6A\xFB\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x53\x57\x57\x55\x55\x55\x59\x6A\xFB\x20"
    "\xFB\xFB\xFB\xFB\x6A\x6A\x55\x51\x57\x57\x55\x53\x61\x6A\x6A\xFB\x20\x20\x20\x6A\x6A\x55\x50"
    "\x55\x57\x59\x5B\x61\x6A\x6A\xFB\xFB\xFB\x20\x6A\x6A\x55\x51\x53\x51\x55\x53\x61\x6A\x6A\xFB"
    "\xFB\xFB\x20\x20\x6A\x5B\x50\x55\x55\x55\x51\x61\x6A\x6A\xFB\xFB\xFB\x20\x20\x20\x20\x6A\x59"
    "\x53\x53\x57\x53\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x6A\x59\x51\x51\x53\x57\x51\x50"
    "\x50\x50\x51\x50\x50\x50\x57\x6A\xFB\x6A\x5F\x5F\x5B\x5C\x5C\x5C\x5B\x59\x5C\x5F\x5C\x5B\x5F"
    "\x64\x6A\xFB\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\xFB\xFB"
    "\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB",

    // 26 = '.'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x6A\x6A\x6A\x6A\x6A\x20\x6A\x59\x55\x51\x6A\xFB\x6A\x62\x61\x5F\x6A\xFB\x6A\x6A\x6A"
    "\x6A\x6A\xFB\x20\xFB\xFB\xFB\xFB\xFB",

    // 27 = '!'
    "\x6A\x6A\x6A\x6A\x6A\x6A\x20\x6A\x63\x50\x51\x63\x6A\xFB\x6A\x5A\x53\x53\x5A\x6A\xFB\x6A\x5A"
    "\x55\x51\x5A\x6A\xFB\x6A\x5A\x55\x53\x5A\x6A\xFB\x6A\x5A\x55\x55\x5A\x6A\xFB\x6A\x63\x5C\x5F"
    "\x63\x6A\xFB\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x6A\x61\x5B\x57\x61\x6A"
    "\xFB\x6A\x62\x61\x5F\x62\x6A\xFB\x6A\x6A\x6A\x6A\x6A\x6A\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB",

    // 28 = '’'
    "\x20\x6A\x6A\x6A\x6A\x20\x20\x6A\x51\x51\x6A\xFB\x20\x6A\x57\x5B\x6A\xFB\x6A\x5F\x5F\x6A\xFB"
    "\xFB\x6A\x6A\x6A\xFB\xFB\x20\x20\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 29 = '-'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x68"
    "\x5C\x51\x50\x51\x51\x57\x6A\xFB\x6A\x62\x62\x59\x5F\x62\x62\x6A\xFB\x6A\x6A\x6A\x6A\x6A\x6A"
    "\x6A\x6A\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20",

    // 30 = '/'
    "\x20\x20\x20\x20\x20\x6A\x6A\x6A\x6A\x20\x20\x20\x20\x20\x6A\x61\x51\x57\x6A\xFB\x20\x20\x20"
    "\x20\x6A\x5B\x51\x5B\x6A\xFB\x20\x20\x20\x6A\x61\x51\x57\x6A\xFB\xFB\x20\x20\x20\x6A\x5B\x51"
    "\x61\x6A\xFB\x20\x20\x20\x6A\x61\x51\x57\x6A\xFB\xFB\x20\x20\x20\x6A\x57\x51\x61\x6A\xFB\x20"
    "\x20\x20\x6A\x61\x51\x57\x6A\xFB\xFB\x20\x20\x20\x6A\x57\x51\x61\x6A\xFB\x20\x20\x20\x6A\x61"
    "\x51\x57\x6A\xFB\xFB\x20\x20\x20\x6A\x57\x51\x61\x6A\xFB\x20\x20\x20\x20\x6A\x6A\x6A\x6A\xFB"
    "\xFB\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20",

    // 31 = '0'
    "\x20\x20\x69\x69\x69\x69\x69\x69\x69\x20\x20\x20\x20\x69\x52\x50\xA8\xA8\xA8\x56\x57\x69\x20"
    "\x20\x69\x5B\x54\x56\x5F\x5F\x61\x5B\x57\x5F\x69\x20\x69\x5B\x56\x5B\x69\x69\x69\x5B\x57\x5B"
    "\x69\xFB\x69\x5B\x56\x5B\x69\xFB\x69\x5B\x56\x5D\x69\xFB\x69\x5B\x54\x5B\x69\xFB\x69\x5F\x57"
    "\x5D\x69\xFB\x69\x5B\x54\x5D\x69\xFB\x69\x5D\x56\x5D\x69\xFB\x69\x5B\x54\x5D\x69\xFB\x69\x63"
    "\x5B\x5D\x69\xFB\x69\x5B\x56\x59\x69\x69\x69\x5F\x5F\x5F\x69\xFB\x69\x5F\x56\x52\x52\x54\x57"
    "\x5F\x5F\x65\x69\xFB\x20\x69\x65\x63\x5F\x5F\x5F\x63\x65\x69\xFB\xFB\x20\x20\x69\x69\x69\x69"
    "\x69\x69\x69\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20",

    // 32 = '1'
    "\x20\x20\x20\x69\x69\x69\x69\x20\x20\x20\x69\xA8\x50\x50\x69\xFB\x20\x69\xA8\x5B\x55\x55\x69"
    "\xFB\x69\x52\x5B\x58\x55\x55\x69\xFB\x69\x69\x69\x58\x55\x55\x69\xFB\x20\xFB\x69\x58\x55\x57"
    "\x69\xFB\x20\x20\x69\x52\x52\x55\x69\xFB\x20\x20\x69\x52\x52\x55\x69\xFB\x20\x20\x69\x55\x52"
    "\x57\x69\xFB\x20\x20\x69\x55\x52\x52\x69\xFB\x20\x20\x69\x5F\x5C\x61\x69\xFB\x20\x20\x69\x69"
    "\x69\x69\x69\xFB\x20\x20\x20\xFB\xFB\xFB\xFB\xFB",

    // 33 = '2'
    "\x69\x69\x69\x69\x69\x69\x69\x69\x69\x20\x20\x20\x69\x57\x52\xA8\xA8\xA8\x51\x57\x57\x69\x20"
    "\x20\x69\x5F\x61\x5F\x5F\x5F\x5C\x57\x58\x58\x69\x20\x69\x69\x69\x69\x69\x69\x69\x58\x58\x57"
    "\x69\xFB\x20\x69\x69\x69\x69\x69\x69\x5B\x5B\x55\x69\xFB\x20\x69\x52\x55\x50\x50\x52\x58\x58"
    "\x57\x69\xFB\x69\x52\x58\x58\x5C\x5F\x5C\x5F\x61\x69\xFB\xFB\x69\x55\x5C\x5C\x69\x69\x69\x69"
    "\x69\xFB\xFB\x20\x69\x57\x5C\x58\x69\x69\x69\x69\x69\x69\x69\x20\x69\x51\x58\x58\x51\xA8\xA8"
    "\xA8\xA8\x51\x69\xFB\x69\x5C\x5F\x62\x61\x5B\x5C\x5F\x61\x61\x69\xFB\x69\x69\x69\x69\x69\x69"
    "\x69\x69\x69\x69\x69\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB",

    // 34 = '3'
    "\x69\x69\x69\x69\x69\x69\x69\x69\x69\x20\x20\x20\x69\x57\x51\x51\xA8\xA8\x50\x52\x55\x69\x20"
    "\x20\x69\x58\x5C\x5F\x5C\x5C\x5C\x5C\x5C\x5B\x69\x20\x69\x69\x69\x69\x69\x69\x69\x63\x5F\x5C"
    "\x69\xFB\x20\xFB\xFB\xFB\x69\x69\x69\x66\x61\x5F\x69\xFB\x20\x20\x20\x20\x69\xA8\x52\x5C\x61"
    "\x5F\x69\xFB\x20\x20\x20\x20\x69\x5C\x62\x61\x61\x5F\x69\xFB\x20\x20\x20\x20\x69\x69\x69\x66"
    "\x63\x61\x69\xFB\x69\x69\x69\x69\x69\x69\x69\x63\x63\x61\x69\xFB\x69\x55\x57\x55\x57\x57\x57"
    "\x62\x62\x61\x69\xFB\x69\x62\x62\x61\x62\x62\x66\x66\x66\x69\xFB\xFB\x69\x69\x69\x69\x69\x69"
    "\x69\x69\x69\xFB\xFB\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20",

    // 35 = '4'
    "\x69\x69\x69\x69\x69\x20\x69\x69\x69\x69\x69\x20\x69\x52\x52\x58\x69\xFB\x69\x51\x52\x58\x69"
    "\xFB\x69\x52\x58\x5F\x69\xFB\x69\x51\x57\x5C\x69\xFB\x69\x57\x5C\x58\x69\xFB\x69\x51\x57\x5F"
    "\x69\xFB\x69\x58\x57\x55\x69\x69\x69\x51\x5B\x61\x69\xFB\x69\x55\x55\x51\xA8\xA8\xA8\xA8\x5C"
    "\x61\x69\xFB\x69\x5C\x5F\x5B\x5C\x5F\x5C\xA8\x5C\x61\x69\xFB\x69\x69\x69\x69\x69\x69\x69\xA8"
    "\x58\x61\x69\xFB\x20\xFB\xFB\xFB\xFB\xFB\x69\xA8\x58\x5F\x69\xFB\x20\x20\x20\x20\x20\x20\x69"
    "\x51\x57\x5F\x69\xFB\x20\x20\x20\x20\x20\x20\x69\x5B\x5F\x66\x69\xFB\x20\x20\x20\x20\x20\x20"
    "\x69\x69\x69\x69\x69\xFB\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB",

    // 36 = '5'
    "\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x6A\x56\x52\xA8\xA8\xA8\xA8\x52\x54\x57\x6A"
    "\xFB\x6A\x57\x56\x56\x56\x59\x5D\x59\x5D\x5D\x6A\xFB\x6A\x59\x54\x5F\x6A\x6A\x6A\x6A\x6A\x6A"
    "\x6A\xFB\x6A\x59\x56\x5F\x6A\x6A\x6A\x6A\x6A\xFB\xFB\xFB\x6A\x59\x56\x54\x52\xA8\x52\x56\x57"
    "\x6A\x20\x20\x6A\x5D\x5D\x5F\x5F\x5F\x5F\x56\x57\x59\x6A\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x59"
    "\x5D\x61\x6A\xFB\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x5B\x61\x61\x6A\xFB\x6A\x56\xA8\xA8\xA8\xA8\x56"
    "\x5B\x61\x61\x6A\xFB\x6A\x5D\x5D\x5D\x5D\x5F\x5F\x61\x65\x6A\xFB\xFB\x6A\x6A\x6A\x6A\x6A\x6A"
    "\x6A\x6A\x6A\xFB\xFB\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20",

    // 37 = '6'
    "\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x6A\x5D\x54\xA8\xA8\x52\x52\x54\x57\x6A"
    "\xFB\x6A\x5B\x57\x61\x5F\x5D\x5B\x5D\x5F\x61\x6A\xFB\x6A\x59\x57\x61\x6A\x6A\x6A\x6A\x6A\x6A"
    "\x6A\xFB\x6A\x56\x56\x61\x6A\x6A\x6A\x6A\x6A\xFB\xFB\xFB\x6A\x54\x57\x56\x54\x54\x56\x57\x5D"
    "\x6A\x20\x20\x6A\x54\x57\x57\x5D\x5F\x5F\x57\x57\x5D\x6A\x20\x6A\x54\x59\x57\x6A\x6A\x6A\x59"
    "\x54\x56\x6A\xFB\x6A\x57\x5D\x5B\x6A\x6A\x6A\x5B\x56\x57\x6A\xFB\x6A\x5B\x57\x54\xA8\xA8\xA8"
    "\x54\x56\x5D\x6A\xFB\x20\x6A\x5B\x5D\x5D\x5F\x5D\x5B\x5D\x6A\xFB\xFB\x20\x20\x6A\x6A\x6A\x6A"
    "\x6A\x6A\x6A\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20",

    // 38 = '7'
    "\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x6A\x59\x56\x52\xA8\xA8\xA8\x52\x57\x6A\x20"
    "\x20\x6A\x63\x61\x5F\x61\x5F\x61\x5B\x57\x5B\x6A\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x5B\x57\x5B"
    "\x6A\xFB\x20\xFB\xFB\xFB\xFB\xFB\x6A\x5B\x56\x5D\x6A\xFB\x20\x20\x20\x20\x20\x20\x6A\x5F\x57"
    "\x5F\x6A\xFB\x20\x20\x20\x20\x20\x20\x6A\x5D\x56\x61\x6A\xFB\x20\x20\x20\x20\x20\x20\x6A\x63"
    "\x5B\x61\x6A\xFB\x20\x20\x20\x20\x20\x20\x6A\x63\x63\x65\x6A\xFB\x20\x20\x20\x20\x20\x20\x6A"
    "\x63\x65\x65\x6A\xFB\x20\x20\x20\x20\x20\x20\x6A\x61\x63\x63\x6A\xFB\x20\x20\x20\x20\x20\x20"
    "\x6A\x6A\x6A\x6A\x6A\xFB\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB",

    // 39 = '8'
    "\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x20\x6A\x59\x57\x56\x52\x52\x56\x56\x6A\x20"
    "\x20\x6A\x5D\x5D\x5B\x63\x65\x65\x5B\x57\x5B\x6A\x20\x6A\x5F\x5B\x65\x6A\x6A\x6A\x65\x56\x5D"
    "\x6A\xFB\x6A\x61\x5B\x5F\x6A\x6A\x6A\x5F\x56\x63\x6A\xFB\x20\x6A\x59\x59\x52\x54\x54\x56\x56"
    "\x6A\xFB\xFB\x20\x6A\x59\x5F\x5F\x63\x63\x5D\x54\x6A\xFB\x20\x6A\x5D\x5D\x63\x6A\x6A\x6A\x5F"
    "\x54\x5F\x6A\x20\x6A\x57\x54\x5F\x6A\x6A\x6A\x59\x54\x57\x6A\xFB\x6A\x5F\x57\x54\x50\xA8\x50"
    "\x56\x57\x5F\x6A\xFB\x20\x6A\x5B\x5F\x61\x5F\x5F\x5F\x5D\x6A\xFB\xFB\x20\x20\x6A\x6A\x6A\x6A"
    "\x6A\x6A\x6A\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20",

    // 40 = '9'
    "\x20\x20\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x20\x20\x20\x20\x6A\x61\x57\x54\x52\x52\x54\x57\x6A\x20"
    "\x20\x6A\x67\x67\x65\x67\x67\x67\x61\x63\x59\x6A\x20\x6A\x65\x65\x63\x6A\x6A\x6A\x61\x63\x57"
    "\x6A\xFB\x6A\x61\x5F\x5F\x6A\x6A\x6A\x5D\x63\x57\x6A\xFB\x6A\x5D\x5B\x5F\x54\xA8\x54\x5D\x63"
    "\x59\x6A\xFB\x20\x6A\x61\x63\x63\x5F\x5D\x59\x63\x5B\x6A\xFB\x20\x6A\x6A\x6A\x6A\x6A\x6A\x5B"
    "\x5F\x5D\x6A\xFB\x6A\x6A\x6A\x6A\x6A\x6A\x6A\x59\x63\x5F\x6A\xFB\x6A\x57\x56\x54\x54\x54\xA8"
    "\x57\x67\x67\x6A\xFB\x6A\x61\x61\x61\x63\x63\x5F\x5F\x67\x6A\xFB\xFB\x6A\x6A\x6A\x6A\x6A\x6A"
    "\x6A\x6A\x6A\xFB\xFB\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20",

    // 41 = '‘'
    "\x6A\x6A\x6A\x6A\x20\x20\x6A\x51\x51\x6A\xFB\x20\x6A\x57\x5B\x6A\xFB\x20\x20\x6A\x5F\x5F\x6A"
    "\xFB\x20\x20\x6A\x6A\x6A\xFB\x20\x20\x20\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20"
};

const char *redcharset[] =
{
    // 0 = '!'
    "\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xB1\xB1\xB2\xB1\xBF\xFB\x20\xBF\xB3\xB3\xB3\xB1\xBF\xFB"
    "\x20\xBF\xB4\xB3\xB2\xB2\xBF\xFB\x20\xBF\xB4\xB3\xB2\xB2\xBF\xFB\x20\xBF\xB4\xB3\xB2\xB2\xBF"
    "\xFB\x20\xBF\xB4\xB4\xB2\xB1\xBF\xFB\x20\xBF\xB3\xB4\xB3\xB5\xBF\xFB\x20\xBF\xB7\xB4\xB4\xB6"
    "\xBF\xFB\x20\xBF\xBF\xB8\xB9\xBF\xBF\xFB\x20\x20\xBF\xBF\xBF\xBF\xFB\xFB\x20\x20\xBF\xBF\xBF"
    "\xBF\xFB\x20\x20\x20\xBF\xB7\xB7\xBF\xFB\x20\x20\x20\xBF\xBA\xBA\xBF\xFB\x20\x20\x20\xBF\xBF"
    "\xBF\xBF\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20",

    // 1 = '’'
    "\x20\x20\xBF\xBF\xBF\xBF\x20\x20\x20\xBF\xB2\xB2\xBF\xFB\x20\x20\xBF\xB5\xB7\xBF\xFB\x20\xBF"
    "\xB9\xB9\xBF\xFB\xFB\x20\xBF\xBF\xBF\xFB\xFB\x20\x20\x20\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 2 = ','
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\x20"
    "\x20\xBF\xB2\xB2\xBF\xFB\x20\x20\xBF\xB5\xB7\xBF\xFB\x20\xBF\xB9\xB9\xBF\xFB\xFB\x20\xBF\xBF"
    "\xBF\xFB\xFB\x20\x20\x20\xFB\xFB\xFB\x20\x20",

    // 3 = '-'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\xBF\xBA\xB4\xB4\xB2\xB2\xB7\xBF\x20\x20\x20\xBF\xBC\xB9"
    "\xB9\xB6\xB6\xBB\xBF\xFB\x20\x20\xBF\xBB\xBA\xBA\xBA\xBA\xBB\xBF\xFB\x20\x20\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 4 = '.'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF"
    "\xBF\xBF\x20\x20\xBF\xB8\xB6\xBF\xFB\x20\xBF\xB6\xB5\xBF\xFB\x20\xBF\xBF\xBF\xBF\xFB\x20\x20"
    "\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 5 = ':'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\xBF\xBF\xBF\xBF\x20\x20\xBF\xB8\xB6\xBF\xFB\x20\xBF\xB6\xB5\xBF\xFB\x20\xBF\xBF\xBF"
    "\xBF\xFB\x20\x20\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\x20\xBF\xB8"
    "\xB6\xBF\xFB\x20\xBF\xB6\xB5\xBF\xFB\x20\xBF\xBF\xBF\xBF\xFB\x20\x20\xFB\xFB\xFB\xFB\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 6 = '?'
    "\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\xBF\xB7\xB2\xB2\xB2\xB1\xB1"
    "\xB1\xB4\xB6\xBA\xBF\x20\x20\x20\xBF\xBA\xBC\xB9\xB9\xB6\xB8\xB8\xB6\xB6\xB5\xBA\xBF\x20\x20"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xB4\xB3\xB4\xB6\xBF\xFB\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xB3\xB3\xB5\xB6\xBF\xFB\x20\xBF\xB7\xB1\xB1\xB1\xB2\xB1\xB3\xB5\xB3\xB3\xBA\xBF\xFB\x20\xBF"
    "\xB9\xB6\xB1\xB2\xB9\xB6\xB9\xB9\xB7\xBA\xBF\xFB\xFB\x20\xBF\xBA\xB6\xB3\xB1\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xFB\xFB\x20\x20\xBF\xBA\xB6\xB4\xB6\xBF\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\xBF\xBF"
    "\xB8\xB9\xBF\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xFB\xFB\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB7"
    "\xB7\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBA\xBA\xBF\xFB\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xFB\xFB"
    "\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 7 = 'A'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\xBF\xBD\xB5\xB3\xB3\xB3\xB5\xBD\xBF\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB5"
    "\xB6\xB7\xB7\xB6\xB6\xB5\xB6\xBB\xBF\x20\x20\x20\x20\x20\x20\x20\xBF\xB6\xB9\xB8\xB5\xB9\xB9"
    "\xB9\xB7\xB5\xB6\xBD\xFB\x20\x20\x20\x20\x20\xBF\xBB\xB8\xB8\xB8\xB9\xBF\xBF\xBF\xB9\xB5\xB7"
    "\xBB\xBF\x20\x20\x20\x20\x20\xBF\xB9\xB8\xB7\xB7\xBC\xBF\x20\xBF\xB9\xB4\xB7\xB9\xBF\xFB\x20"
    "\x20\x20\xBF\xBB\xB9\xB6\xB6\xB8\xBF\x20\x20\xBF\xBA\xB4\xB7\xB9\xBF\xFB\x20\x20\x20\xBF\xBC"
    "\xB9\xB6\xB9\xBF\xBF\xBF\xBF\xBF\xBA\xB5\xB7\xB9\xBF\xFB\x20\x20\xBF\xBA\xBB\xBB\xB7\xB9\xBF"
    "\xBF\xB2\xB2\xB3\xB5\xB5\xB7\xB9\xBF\xFB\x20\x20\xBF\xBA\xBB\xBB\xB9\xBF\xFB\xBF\xB9\xB9\xB9"
    "\xB8\xB5\xB7\xB9\xBF\xFB\x20\xBF\xBB\xBA\xBA\xBA\xB9\xBF\xFB\xBF\xBF\xBF\xBF\xB8\xB5\xB8\xB9"
    "\xBF\xFB\x20\xBF\xBB\xBA\xBB\xBA\xBF\xFB\xFB\x20\xFB\xFB\xBF\xB9\xB6\xB8\xB9\xBF\xFB\xBF\xBC"
    "\xBB\xB9\xBA\xB9\xBF\xFB\x20\x20\x20\x20\xBF\xB9\xB5\xB8\xB9\xBF\xFB\xBF\xBB\xBB\xBB\xBB\xBF"
    "\xFB\xFB\x20\x20\x20\x20\xBF\xBC\xBB\xBB\xBB\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20"
    "\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\xC8\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\xFB"
    "\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 8 = 'B'
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\xBF\xB7\xB4\xB3\xB3\xB4"
    "\xB4\xB4\xB4\xB5\xB5\xB7\xBF\xBF\x20\x20\x20\xBF\xB8\xB7\xB8\xBA\xBA\xBA\xB9\xB9\xB8\xB7\xB8"
    "\xB7\xB9\xBF\x20\x20\xBF\xBB\xBA\xBB\xBC\xBC\xBC\xBC\xBB\xBB\xBA\xB8\xB7\xB9\xBC\xBF\x20\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xB9\xB8\xB9\xB8\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xB9\xB8\xB9\xB8\xBF\xFB\xBF\xB7\xB5\xB4\xB5\xB4\xB4\xB4\xB4\xB5\xB5\xB7\xB9"
    "\xB9\xBC\xBF\xFB\xBF\xB8\xB5\xB5\xB9\xBA\xBA\xB9\xB9\xB8\xB7\xB8\xB7\xB9\xBF\xBF\xFB\xBF\xB8"
    "\xB5\xB5\xB9\xBC\xBC\xBC\xBB\xBB\xBA\xB8\xB7\xB9\xBC\xBF\xFB\xBF\xB8\xB5\xB5\xB9\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xB9\xB8\xB9\xB8\xBF\xFB\xBF\xB8\xB5\xB5\xBA\xBF\xBF\xBF\xBF\xBF\xBF\xB9\xB8\xB9"
    "\xB8\xBF\xFB\xBF\xB8\xB6\xB6\xB5\xB6\xB4\xB4\xB7\xB7\xB8\xBB\xB9\xB9\xBC\xBF\xFB\xBF\xB8\xB6"
    "\xB5\xB6\xB8\xB9\xB9\xBA\xBA\xBB\xBB\xBC\xBB\xBF\xFB\xFB\xBF\xB9\xB8\xB9\xBB\xBA\xBB\xBC\xBC"
    "\xBC\xBC\xBC\xBF\xBF\xFB\xFB\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\xFB"
    "\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 9 = 'C'
    "\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xB6"
    "\xB5\xB3\xB2\xB2\xB1\xB1\xB3\xB5\xBF\xBF\x20\x20\x20\x20\xBF\xB9\xB6\xB7\xB8\xB7\xB6\xB5\xB6"
    "\xB6\xB5\xB9\xB6\xB6\xBF\x20\x20\x20\xBF\xB9\xB9\xB8\xB7\xB6\xB8\xB8\xB8\xB8\xB5\xB8\xB8\xB7"
    "\xB5\xBF\x20\xBF\xB9\xB9\xB7\xB9\xB8\xB8\xBF\xBF\xBF\xBF\xB6\xB8\xB9\xB8\xB6\xBF\xFB\xBF\xB7"
    "\xB7\xB9\xB9\xB8\xBF\xFB\xFB\xFB\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xBF\xB9\xB8\xB8\xB8\xBF\xFB"
    "\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xBF\xB9\xB9\xB9\xB8\xBF\xFB\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\xBF\xB9\xB7\xB8\xB8\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\xBF\xB7\xB6\xB8\xB7\xB9\xBF\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB9\xB6\xB7"
    "\xB6\xB8\xB4\xBF\xBF\xBF\xBF\xB4\xB4\xB5\xB5\xB5\xBF\xFB\x20\xBF\xB6\xB7\xB6\xB8\xB9\xB4\xB1"
    "\xB2\xB3\xB5\xB3\xB6\xB6\xB8\xBF\xFB\x20\xBF\xB9\xB5\xB7\xB8\xB8\xB6\xB6\xB5\xB3\xB4\xB3\xB5"
    "\xB8\xBF\xFB\xFB\x20\x20\xBF\xBF\xB8\xB7\xB8\xB8\xB8\xB8\xB8\xB7\xB8\xBF\xBF\xFB\xFB\x20\x20"
    "\x20\x20\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\xFB"
    "\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20",

    // 10 = 'D'
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\xBF\xB9\xB7\xB5\xB5\xB5"
    "\xB5\xB3\xB3\xB5\xB8\xBB\xBF\xBF\x20\x20\x20\xBF\xBA\xBA\xB9\xBA\xBA\xB9\xB9\xBA\xB9\xB9\xB8"
    "\xBA\xBD\xBF\x20\x20\xBF\xBB\xBB\xBB\xBB\xBB\xBC\xBC\xBC\xBA\xB9\xB9\xB8\xB8\xBF\xFB\x20\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBC\xBA\xB8\xB9\xB9\xBB\xBF\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB"
    "\xFB\xFB\xBF\xBC\xBA\xBA\xB9\xB8\xBF\xFB\xBF\xB8\xB2\xB2\xB5\xBF\xFB\x20\x20\x20\xBF\xB9\xBB"
    "\xBB\xB9\xBF\xFB\xBF\xB9\xB5\xB5\xB8\xBF\xFB\x20\x20\x20\xBF\xB8\xBB\xBB\xBC\xBF\xFB\xBF\xB9"
    "\xB5\xB6\xB8\xBF\xFB\x20\x20\x20\xBF\xB8\xBB\xBA\xBB\xBF\xFB\xBF\xB9\xB5\xB5\xB8\xBF\xFB\x20"
    "\x20\xBF\xBB\xB9\xBB\xBA\xBB\xBF\xFB\xBF\xB8\xB5\xB5\xB8\xBF\xBF\xBF\xBF\xBB\xB8\xBA\xBB\xBA"
    "\xBD\xBF\xFB\xBF\xB7\xB5\xB5\xB5\xB5\xB2\xB2\xB2\xB7\xBA\xBC\xBB\xBB\xBF\xFB\xFB\xBF\xB7\xB5"
    "\xB3\xB4\xB4\xB4\xB4\xB4\xB7\xBA\xBC\xBC\xBD\xBF\xFB\x20\xBF\xBA\xBB\xBB\xBB\xBB\xBB\xBB\xBB"
    "\xBB\xBB\xBB\xBF\xBF\xFB\xFB\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\xFB"
    "\x20\x20\x20\xC8\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 11 = 'E'
    "\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\xBF\xBF\xBB\xB5"
    "\xB4\xB2\xB2\xB2\xB3\xB3\xB3\xB5\xB9\xBF\xFB\x20\xBF\xBC\xB8\xB7\xB6\xB6\xB5\xB6\xB6\xB7\xB7"
    "\xB9\xBA\xBA\xBF\xFB\x20\xBF\xB8\xB5\xB5\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBF\xFB\xBF"
    "\xBB\xB8\xB4\xB5\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xBF\xB9\xB7\xB4\xB5\xBF\xBF"
    "\xBF\xBF\xBF\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xBF\xB9\xB5\xB3\xB5\xB4\xB2\xB2\xB4\xBF\xFB\x20\x20"
    "\x20\x20\x20\x20\xBF\xB9\xB5\xB3\xB5\xB6\xB6\xB5\xB5\xBF\xFB\x20\x20\x20\x20\x20\x20\xBF\xB9"
    "\xB5\xB2\xB6\xB9\xBB\xBB\xBB\xBF\xFB\x20\x20\x20\x20\x20\x20\xBF\xB9\xB6\xB2\xB5\xBF\xBF\xBF"
    "\xBF\xBF\xFB\x20\x20\x20\x20\x20\x20\xBF\xBC\xB5\xB2\xB5\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\x20\x20\xBF\xB8\xB3\xB5\xB4\xB4\xB3\xB1\xB1\xB1\xB2\xB3\xB4\xB6\xBF\xFB\x20\xBF\xBC"
    "\xB8\xB5\xB6\xB6\xB6\xB5\xB6\xB6\xB6\xB6\xB6\xB8\xBF\xFB\x20\x20\xBF\xBF\xBB\xBB\xBB\xBB\xBB"
    "\xBB\xBB\xBB\xBB\xBB\xBB\xBF\xFB\x20\x20\x20\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 12 = 'F'
    "\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\xBF\xBF\xBB\xB8"
    "\xB7\xB5\xB5\xB5\xB5\xB5\xB5\xB8\xBA\xBF\xFB\x20\xBF\xBB\xB9\xB7\xB7\xB7\xB7\xB8\xB8\xB9\xB9"
    "\xB8\xB8\xB9\xBF\xFB\x20\xBF\xB6\xB9\xB6\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBB\xBF\xFB\xBF"
    "\xBB\xB6\xB9\xB8\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xBF\xB8\xB6\xB9\xB8\xBF\xBF"
    "\xBF\xBF\xBF\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xBF\xB9\xB6\xB9\xB8\xB6\xB4\xB2\xB4\xBF\xFB\x20\x20"
    "\x20\x20\x20\x20\xBF\xB9\xB6\xB9\xB7\xB8\xB7\xB8\xB7\xBF\xFB\x20\x20\x20\x20\x20\x20\xBF\xB8"
    "\xB6\xB9\xB7\xBB\xBB\xBB\xBB\xBF\xFB\x20\x20\x20\x20\x20\x20\xBF\xB9\xB6\xB9\xB9\xBF\xBF\xBF"
    "\xBF\xBF\xFB\x20\x20\x20\x20\x20\x20\xBF\xB9\xB6\xB9\xBA\xBF\xFB\xFB\xFB\xFB\xFB\x20\x20\x20"
    "\x20\x20\x20\xBF\xBA\xB6\xB9\xBC\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBA\xB6"
    "\xB9\xBC\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBB\xBB\xBB\xBB\xBF\xFB\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 13 = 'G'
    "\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xB7\xB5"
    "\xB4\xB4\xB1\xB1\xB2\xB5\xBF\xBF\x20\x20\x20\x20\xBF\xBC\xB6\xB6\xB5\xB6\xB6\xB7\xB7\xB9\xBA"
    "\xBA\xB8\xBF\x20\x20\x20\xBF\xB5\xB6\xB5\xB4\xB9\xBB\xBC\xBC\xBC\xBB\xB9\xB8\xB5\xBF\x20\xBF"
    "\xBA\xB5\xB6\xB4\xBA\xBD\xBF\xBF\xBF\xBF\x2E\xBC\xB8\xB5\xBF\xFB\xBF\xB8\xB5\xB6\xB5\xBC\xBF"
    "\xFB\xFB\xFB\xFB\xBF\xBF\xBF\xBF\xBF\xFB\xBF\xB8\xB5\xB6\xB5\xBF\xFB\xFB\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xFB\xBF\xB8\xB5\xB6\xB6\xBF\xFB\x20\xBF\xB7\xB5\xB7\xB7\xB7\xB9\xBF\xFB\xBF\xB7"
    "\xB6\xB6\xB6\xBF\xFB\x20\xBF\xB9\xB7\xB9\xB8\xB8\xBB\xBF\xFB\xBF\xB7\xB5\xB6\xB6\xB8\xBF\x20"
    "\xBF\xBF\xBF\xB9\xB8\xB9\xBB\xBF\xFB\xBF\xBA\xB5\xB7\xB6\xB5\xB8\xBF\xBF\xBF\xBF\xB9\xB9\xB8"
    "\xBB\xBF\xFB\x20\xBF\xB5\xB6\xB7\xB6\xB4\xB4\xB4\xB2\xB3\xB7\xB9\xB9\xBB\xBF\xFB\x20\xBF\xBC"
    "\xB6\xB6\xB6\xB5\xB8\xB9\xBA\xBC\xBB\xBA\xB9\xBA\xBF\xFB\x20\x20\xBF\xBF\xB8\xB8\xB9\xBA\xBA"
    "\xBB\xBC\xBB\xBA\xBA\xBC\xBF\xFB\x20\x20\x20\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 14 = 'H'
    "\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB9\xB2\xB1\xB6\xBF"
    "\xFB\x20\x20\x20\xBF\xB7\xB3\xB3\xB8\xBF\xFB\xBF\xBA\xB6\xB6\xB9\xBF\xFB\x20\x20\x20\xBF\xBA"
    "\xB7\xB8\xB9\xBF\xFB\xBF\xBA\xB7\xB7\xBA\xBF\xFB\x20\x20\x20\xBF\xBA\xB8\xB8\xB9\xBF\xFB\xBF"
    "\xB9\xB7\xB7\xBA\xBF\xFB\x20\x20\x20\xBF\xBA\xB9\xB9\xBA\xBF\xFB\xBF\xB9\xB8\xB8\xBA\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xBB\xBA\xB9\xBA\xBF\xFB\xBF\xB9\xB6\xB6\xB9\xB6\xB4\xB2\xB2\xB7\xB7\xBB\xBB"
    "\xBB\xBA\xBF\xFB\xBF\xB9\xB5\xB5\xB7\xB8\xB8\xB8\xB9\xB9\xBA\xBA\xBB\xBB\xBC\xBF\xFB\xBF\xB9"
    "\xB5\xB6\xB7\xBA\xBA\xBA\xBB\xBC\xBC\xBB\xBB\xBA\xBC\xBF\xFB\xBF\xB9\xB5\xB5\xB9\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBC\xBB\xBA\xBC\xBF\xFB\xBF\xB8\xB5\xB5\xB9\xBF\xFB\xFB\xFB\xFB\xBF\xBC\xBB\xBA"
    "\xBB\xBF\xFB\xBF\xB7\xB5\xB5\xB8\xBF\xFB\x20\x20\x20\xBF\xBC\xBB\xBA\xBC\xBF\xFB\xBF\xB7\xB5"
    "\xB3\xB7\xBF\xFB\x20\x20\x20\xBF\xBC\xBB\xB9\xBB\xBF\xFB\xBF\xBA\xB8\xB8\xBA\xBF\xFB\x20\x20"
    "\x20\xBF\x2C\xBD\xBB\xBC\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 15 = 'I'
    "\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB6\xB4\xB3\xB7\xBF\xFB\xBF\xB8\xB5\xB6\xB9\xBF\xFB\xBF\xB7"
    "\xB4\xB5\xB9\xBF\xFB\xBF\xB6\xB4\xB5\xB9\xBF\xFB\xBF\xB7\xB4\xB4\xB9\xBF\xFB\xBF\xB7\xB5\xB4"
    "\xB9\xBF\xFB\xBF\xB8\xB5\xB5\xB9\xBF\xFB\xBF\xB8\xB5\xB5\xB9\xBF\xFB\xBF\xB8\xB5\xB5\xB9\xBF"
    "\xFB\xBF\xB8\xB5\xB5\xBA\xBF\xFB\xBF\xB8\xB6\xB6\xBA\xBF\xFB\xBF\xB8\xB6\xB5\xBA\xBF\xFB\xBF"
    "\xB9\xB8\xB9\xBB\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 16 = 'J'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\xBF\xB6\xB2\xB3\xB9\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB9"
    "\xB6\xB6\xBA\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBA\xB7\xB7\xBA\xBF\xFB\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBA\xB7\xB7\xB9\xBF\xFB\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\xBF\xBA\xB8\xB8\xB9\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB9\xB6"
    "\xB6\xB9\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB9\xB5\xB5\xB9\xBF\xFB\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB9\xB6\xB5\xB9\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\xBF\xB9\xB5\xB5\xB9\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xB9\xB6\xB5\xB5"
    "\xBA\xBF\xFB\xBF\xBA\xB9\xBA\xBA\xB9\xB8\xB7\xB6\xB6\xB5\xB5\xB5\xB8\xBF\xFB\xFB\xBF\xBA\xB8"
    "\xB7\xB8\xB9\xBA\xBA\xBC\xBA\xB4\xB7\xB3\xB9\xBF\xFB\x20\xBF\xBC\xBB\xBD\xBD\xBC\xBA\xBC\x2C"
    "\xBC\xBA\xB9\xBF\xBF\xFB\xFB\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\xFB"
    "\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 17 = 'K'
    "\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB8\xB5\xB5"
    "\xB9\xBF\xFB\x20\x20\x20\x20\xBF\xB4\xB5\xB5\xB4\xB8\xBF\xFB\xBF\xB9\xBB\xBC\xBD\xBF\xFB\x20"
    "\x20\x20\xBF\xB6\xBA\xB9\xBD\xBC\xBF\xFB\xFB\xBF\xB9\xBA\xBB\xBD\xBF\xFB\x20\x20\xBF\xB4\xB8"
    "\xB9\xB9\xBD\xBF\xFB\xFB\x20\xBF\xBA\xBA\xBA\xBD\xBF\xFB\x20\xBF\xB6\xB5\xB5\xB8\xBB\xBF\xFB"
    "\xFB\x20\x20\xBF\xB9\xBA\xBB\xBB\xBF\xFB\xBF\xB6\xB9\xB6\xB7\xBA\xBF\xFB\xFB\x20\x20\x20\xBF"
    "\xB9\xBB\xBD\xBC\xBF\xBF\xB7\xBB\xBA\xB9\xBB\xBF\xFB\xFB\x20\x20\x20\x20\xBF\xB9\xBB\xBD\x2E"
    "\xBF\xBB\xBC\xBB\xBB\xBA\xBF\xFB\xFB\x20\x20\x20\x20\x20\xBF\xB9\xBB\xBD\x2C\xBF\xBF\xBB\xBB"
    "\xBB\xBB\xB6\xBF\x20\x20\x20\x20\x20\x20\xBF\xB9\xB9\xBB\xBA\xBF\xFB\xBF\xBD\xB9\xBB\xBA\xB4"
    "\xBF\x20\x20\x20\x20\x20\xBF\xB9\xB9\xBA\xBA\xBF\xFB\x20\xBF\xBB\xBB\xBA\xB7\xB6\xBF\x20\x20"
    "\x20\x20\xBF\xB8\xB7\xB9\xBA\xBF\xFB\x20\x20\xBF\xBC\xB9\xB7\xB9\xB4\xBF\x20\x20\x20\xBF\xB8"
    "\xB6\xB9\xBC\xBF\xFB\x20\x20\x20\xBF\xBB\xB7\xB8\xB7\xB6\xBF\x20\x20\xBF\xB9\xB9\xBB\x2D\xBF"
    "\xFB\x20\x20\x20\x20\xBF\xBC\xB9\xBA\xBB\xB9\xBF\x20\xBF\xBD\xBF\xBF\xBF\xBF\xFB\x20\x20\x20"
    "\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\xFB"
    "\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 18 = 'L'
    "\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB9\xB3\xB2\xB6\xBF"
    "\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBA\xB6\xB6\xB9\xBF\xFB\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\xBF\xBA\xB7\xB7\xBA\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF"
    "\xB9\xB7\xB7\xBA\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB9\xB8\xB8\xBA\xBF\xFB"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB9\xB6\xB6\xB9\xBF\xFB\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\xBF\xB9\xB5\xB5\xB9\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB9"
    "\xB5\xB6\xB9\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB9\xB5\xB5\xB9\xBF\xFB\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBA\xB5\xB5\xB6\xB9\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\x20\x20\xBF\xB5\xB5\xB5\xB5\xB7\xB7\xB7\xB8\xB9\xBA\xBA\xB9\xBA\xBF\xFB\x20\xBF\xB9"
    "\xB3\xB4\xB4\xB4\xB4\xB4\xB7\xBA\xBC\xBB\xB9\xBA\xBF\xFB\x20\x20\xBF\xBF\xB9\xB8\xB8\xB8\xB9"
    "\xBA\xBC\x2C\xBD\xBB\xBC\xBF\xFB\x20\x20\x20\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 19 = 'M'
    "\x20\x20\xBF\xBF\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\x20\x20\x20\x20\xBF\xB5\xB6\xBF\xBF"
    "\x20\x20\x20\x20\xBF\xBF\xB6\xB5\xBF\x20\x20\xBF\xBB\xB8\xB7\xB1\xB4\xBF\x20\x20\xBF\xB4\xB5"
    "\xB9\xB2\xBC\xBF\x20\xBF\xBA\xB8\xB5\xB1\xB6\xB1\xBF\xBF\xB4\xB8\xB8\xB8\xB2\xBA\xBF\xFB\xBF"
    "\xBA\xB8\xB6\xB1\xB6\xB4\xB1\xB1\xB7\xB7\xB8\xB9\xB2\xBA\xBF\xFB\xBF\xB9\xB7\xB5\xB1\xB6\xB5"
    "\xB4\xB3\xB7\xB8\xB8\xBA\xB4\xBA\xBF\xFB\xBF\xB9\xB5\xB5\xB1\xB6\xB5\xB5\xB3\xB7\xB8\xB9\xBB"
    "\xB4\xBA\xBF\xFB\xBF\xB9\xB5\xB5\xB1\xBF\xB9\xB5\xB5\xBA\xBF\xBA\xBA\xB5\xBA\xBF\xFB\xBF\xB9"
    "\xB5\xB4\xB1\xBF\xBF\xB9\xB9\xBF\xBF\xBB\xBB\xB5\xBA\xBF\xFB\xBF\xB9\xB6\xB4\xB1\xBF\xFB\xBF"
    "\xBF\xFB\xBF\xBA\xBB\xB8\xBB\xBF\xFB\xBF\xB9\xB5\xB4\xB3\xBF\xFB\x20\xFB\xFB\xBF\xBA\xBD\xB8"
    "\xBA\xBF\xFB\xBF\xB9\xB5\xB4\xB3\xBF\xFB\x20\x20\x20\xBF\xBA\xBD\xB8\xBA\xBF\xFB\xBF\xB9\xB5"
    "\xB5\xB3\xBF\xFB\x20\x20\x20\xBF\xBA\x2D\xB8\xBB\xBF\xFB\xBF\xBB\xB8\xB9\xB8\xBF\xFB\x20\x20"
    "\x20\xBF\xBB\x2E\xB8\xBC\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\x20\xC8\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 20 = 'N'
    "\x20\x20\xBF\xBF\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xB5\xB7\xBF\x20"
    "\x20\x20\x20\x20\xBF\xB8\xB4\xB4\xB9\xBF\xFB\xBF\xBA\xB5\xB6\xB4\xBF\x20\x20\x20\x20\xBF\xBA"
    "\xB8\xB8\xBB\xBF\xFB\xBF\xBA\xB5\xB6\xB6\xB4\xBF\x20\x20\x20\xBF\xB9\xB7\xB7\xBB\xBF\xFB\xBF"
    "\xBA\xB5\xB5\xB8\xB7\xB4\xBF\x20\x20\xBF\xB9\xB3\xB7\xBB\xBF\xFB\xBF\xB9\xB7\xB6\xB8\xB8\xB8"
    "\xB4\xBF\x20\xBF\xB9\xB3\xB6\xBA\xBF\xFB\xBF\xBA\xB9\xB8\xB8\xB9\xB7\xB7\xB4\xBF\xBF\xB9\xB4"
    "\xB6\xB9\xBF\xFB\xBF\xBA\xB6\xB6\xB7\xB8\xB7\xB8\xB7\xB4\xBF\xB9\xB5\xB8\xBA\xBF\xFB\xBF\xB9"
    "\xB7\xB7\xB9\xBF\xBA\xB8\xB9\xB7\xB8\xB7\xB5\xB7\xBA\xBF\xFB\xBF\xBA\xB8\xB9\xBA\xBF\xBF\xBB"
    "\xB9\xB6\xB6\xB8\xB7\xB7\xB9\xBF\xFB\xBF\xBA\xB9\xBA\xBB\xBF\xFB\xBF\xBC\xB7\xB6\xB8\xB7\xB7"
    "\xB9\xBF\xFB\xBF\xBB\xBA\xBA\xBC\xBF\xFB\x20\xBF\xBA\xB8\xB6\xB5\xB7\xB9\xBF\xFB\xBF\xBB\xB9"
    "\xBB\xBC\xBF\xFB\x20\x20\xBF\xBA\xB8\xB6\xB4\xBB\xBF\xFB\xBF\xBC\xBC\xBC\xBD\xBF\xFB\x20\x20"
    "\x20\xBF\xBC\xB9\xB9\xBF\xFB\xFB\xBF\x2D\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\x20\xBF\xBF\xBF\xFB"
    "\xFB\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 21 = 'O'
    "\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\x20\xBF\xBF"
    "\xB7\xB5\xB4\xB4\xB1\xB1\xB2\xB5\xB7\xB7\xBF\xBF\x20\x20\x20\x20\xBF\xBC\xB6\xB6\xB5\xB6\xB6"
    "\xB7\xB7\xB9\xBA\xBA\xB8\xB6\xBC\xBF\x20\x20\x20\xBF\xB5\xB6\xB5\xB4\xB9\xBB\xBC\xBC\xBC\xBB"
    "\xB9\xB8\xB5\xB6\xBF\xFB\x20\xBF\xBA\xB5\xB6\xB4\xBA\xBF\xBF\xBF\xBF\xBF\xBF\xBC\xB8\xB5\xB7"
    "\xBA\xBF\x20\xBF\xB8\xB5\xB6\xB5\xBF\xFB\xFB\xFB\xFB\xFB\xFB\xBF\xB7\xB6\xB5\xB9\xBF\xFB\xBF"
    "\xB8\xB5\xB6\xB5\xBF\xFB\x20\x20\x20\x20\x20\xBF\xB5\xB6\xB6\xBA\xBF\xFB\xBF\xB8\xB5\xB6\xB6"
    "\xBF\xFB\x20\x20\x20\x20\x20\xBF\xB7\xB6\xB6\xB8\xBF\xFB\xBF\xB7\xB6\xB6\xB6\xBF\xFB\x20\x20"
    "\x20\x20\x20\xBF\xB8\xB8\xB5\xB9\xBF\xFB\xBF\xB7\xB5\xB6\xB6\xBF\xFB\x20\x20\x20\x20\x20\xBF"
    "\xB9\xB8\xB7\xB9\xBF\xFB\xBF\xBA\xB5\xB7\xB6\xB5\xBF\xBF\xBF\xBF\xBF\xBF\xB9\xB8\xB8\xB7\xBA"
    "\xBF\xFB\x20\xBF\xB5\xB6\xB7\xB6\xB4\xB4\xB4\xB2\xB3\xB7\xB9\xB9\xB8\xB8\xBF\xFB\xFB\x20\xBF"
    "\xBC\xB6\xB6\xB6\xB5\xB8\xB9\xBA\xBC\xBB\xBA\xB9\xB9\xBC\xBF\xFB\x20\x20\x20\xBF\xBF\xB8\xB8"
    "\xB9\xBA\xBA\xBB\xBC\xBB\xBA\xBA\xBF\xBF\xFB\xFB\x20\x20\x20\x20\xFB\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB"
    "\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 22 = 'P'
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\xBF\xB7\xB4\xB3\xB3\xB4"
    "\xB4\xB4\xB4\xB5\xB5\xB7\xBF\xBF\x20\x20\x20\xBF\xB8\xB7\xB8\xBA\xBA\xBA\xB9\xB9\xB8\xB7\xB8"
    "\xB7\xB9\xBF\x20\x20\xBF\xBB\xBA\xBB\xBC\xBC\xBC\xBC\xBB\xBB\xBA\xB8\xB7\xB9\xBC\xBF\x20\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xB9\xB8\xB9\xB8\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xB9\xB8\xB9\xB8\xBF\xFB\xBF\xB7\xB3\xB4\xB4\xB6\xB4\xB4\xB7\xB7\xB8\xBB\xB9"
    "\xB9\xBC\xBF\xFB\xBF\xB8\xB7\xB8\xB8\xB8\xB9\xB9\xBA\xBA\xBB\xBB\xBC\xBB\xBF\xFB\xFB\xBF\xB9"
    "\xB7\xB7\xBA\xBA\xBB\xBC\xBC\xBC\xBC\xBC\xBF\xBF\xFB\xFB\x20\xBF\xB8\xB6\xB7\xB9\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xFB\xFB\xFB\x20\x20\xBF\xB8\xB6\xB6\xB9\xBF\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20"
    "\x20\x20\x20\xBF\xB8\xB5\xB5\xB8\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB7\xB4"
    "\xB4\xB7\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBA\xB8\xB8\xBA\xBF\xFB\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 23 = 'Q'
    "\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\x20\xBF\xBF"
    "\xB7\xB5\xB4\xB4\xB1\xB1\xB2\xB5\xB7\xB7\xBF\xBF\x20\x20\x20\x20\xBF\xBC\xB6\xB6\xB5\xB6\xB6"
    "\xB7\xB7\xB9\xBA\xBA\xB8\xB6\xBC\xBF\x20\x20\x20\xBF\xB5\xB6\xB5\xB4\xB9\xBB\xBC\xBC\xBC\xBB"
    "\xB9\xB8\xB5\xB6\xBF\xBF\x20\xBF\xBA\xB5\xB6\xB4\xBA\xBF\xBF\xBF\xBF\xBF\xBF\xBC\xB8\xB5\xB7"
    "\xBA\xBF\xFB\xBF\xB8\xB5\xB6\xB5\xBF\xFB\xFB\xFB\xFB\xFB\xFB\xBF\xB7\xB6\xB5\xB9\xBF\xFB\xBF"
    "\xB8\xB5\xB6\xB5\xBF\xFB\x20\x20\x20\x20\x20\xBF\xB5\xB6\xB6\xBA\xBF\xFB\xBF\xB8\xB5\xB6\xB6"
    "\xBF\xFB\x20\x20\x20\x20\x20\xBF\xB7\xB6\xB6\xB8\xBF\xFB\xBF\xB7\xB6\xB6\xB6\xBF\xFB\x20\x20"
    "\x20\x20\x20\xBF\xB8\xB8\xB5\xB9\xBF\xFB\xBF\xB7\xB5\xB6\xB6\xBF\xFB\x20\x20\x20\x20\x20\xBF"
    "\xB9\xB8\xB7\xB9\xBF\xFB\xBF\xBA\xB5\xB7\xB6\xB5\xBF\xBF\xBF\xBF\xBF\xBF\xB9\xB8\xB8\xB7\xBA"
    "\xBF\xFB\x20\xBF\xB5\xB6\xB7\xB6\xB4\xB4\xB4\xB2\xB3\xB7\xB9\xB9\xB8\xB8\xBF\xFB\xFB\x20\xBF"
    "\xBC\xB6\xB6\xB6\xB5\xB8\xB9\xBA\xBC\xBB\xBA\xB9\xB9\xBC\xBF\xFB\x20\x20\x20\xBF\xBF\xB8\xB8"
    "\xB9\xBA\xBA\xBB\xBC\xBB\xBA\xBA\xBF\xBF\xFB\xFB\x20\x20\x20\x20\xFB\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBB\xBB\xB9\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xBF\xBC\xBC\xBB"
    "\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\x20\x20\x20",

    // 24 = 'R'
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\xBF\xB6\xB3\xB4\xB4\xB1"
    "\xB1\xB1\xB2\xB4\xB5\xB6\xBF\xBF\x20\x20\x20\xBF\xB8\xB7\xB8\xB7\xB5\xB6\xB6\xB7\xB7\xB8\xB9"
    "\xB7\xBB\xBF\x20\x20\xBF\xBA\xBA\xBA\xBA\xB9\xB8\xB9\xB9\xB9\xBA\xB8\xB8\xB7\xBF\xFB\x20\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBA\xB7\xB7\xBB\xBF\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xBA\xB5\xB8\xB8\xBF\xFB\xBF\xB7\xB4\xB4\xB4\xB4\xB1\xB2\xB3\xB4\xB4\xB5\xB4"
    "\xB6\xB8\xBF\xFB\xBF\xBA\xB8\xB8\xB7\xB7\xB8\xB7\xB5\xB5\xB6\xB5\xB2\xB6\xBB\xBF\xFB\xBF\xB9"
    "\xB8\xB8\xB8\xBB\xBB\xB9\xB9\xB5\xB6\xB5\xB2\xBB\xBF\xBF\xFB\xBF\xB9\xB7\xB7\xB9\xBF\xBF\xBF"
    "\x2D\xBB\xB8\xB5\xB2\xB3\xB9\xBF\xFB\xBF\xB9\xB6\xB7\xB9\xBF\xFB\xFB\xFB\xBF\xB9\xB4\xB2\xB3"
    "\xB9\xBF\xFB\xBF\xB8\xB5\xB6\xB8\xBF\xFB\x20\x20\xBF\xB8\xB4\xB2\xB4\xB8\xBF\xFB\xBF\xB8\xB6"
    "\xB7\xB8\xBF\xFB\x20\x20\xBF\xB8\xB3\xB3\xB3\xB7\xBF\xFB\xBF\xBA\xB9\xB9\xBA\xBF\xFB\x20\x20"
    "\xBF\xBA\xB8\xB7\xB8\xB9\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 25 = 'S'
    "\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\xBF\xBC\xB7\xB6"
    "\xB4\xB4\xB2\xB3\xB3\xB3\xB7\xB9\xBF\xFB\x20\x20\xBF\xBA\xB9\xBA\xB8\xB8\xB6\xB7\xBA\xB9\xB7"
    "\xB9\xBA\xBF\xFB\x20\xBF\xBA\xB5\xB8\xB8\xBB\xBA\xBA\xBA\xBB\xBB\xBB\xB9\xBB\xBF\xFB\x20\xBF"
    "\xB8\xB5\xB7\xBA\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\xBF\xB8\xB4\xB6\xBA\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\xFB\x20\xBF\xBA\xB6\xB5\xB5\xB4\xB3\xB2\xB1\xB2\xB2\xB4\xBA"
    "\xBF\x20\x20\x20\x20\xBF\xBA\xB5\xB5\xB6\xB7\xBA\xBA\xB9\xB7\xB6\xB8\xBA\xBF\x20\x20\x20\x20"
    "\xBF\xBB\xB9\xB9\xBA\xBC\xBB\xBB\xB9\xB6\xB7\xB8\xBA\xBF\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBA\xB8\xB8\xB6\xBF\xFB\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBA\xB7\xB7"
    "\xB6\xBF\xFB\x20\xBF\xB6\xB1\xB1\xB1\xB1\xB1\xB3\xB4\xB9\xB7\xB6\xB8\xBA\xBF\xFB\x20\xBF\xB8"
    "\xB2\xB3\xB5\xB5\xB5\xB8\xB8\xB8\xB7\xB5\xBA\xBF\xFB\xFB\x20\xBF\xB9\xB7\xB7\xB8\xB9\xB9\xBA"
    "\xB9\xBA\xBB\xBA\xBF\xFB\xFB\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB"
    "\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 26 = 'T'
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB7\xB5\xB5\xB2\xB2"
    "\xB2\xB1\xB1\xB1\xB2\xB3\xB4\xB3\xB6\xBF\xFB\xBF\xBA\xBA\xBA\xBB\xBB\xB9\xB9\xB6\xB4\xB7\xB9"
    "\xB9\xB8\xB9\xBF\xFB\xBF\xBB\xBB\xBB\xBB\xBB\xB9\xB9\xB6\xB4\xBB\xBB\xBB\xBB\xBB\xBF\xFB\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xB9\xB7\xB6\xB8\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\xBF\xB8"
    "\xB6\xB6\xB8\xBF\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\xBF\xB8\xB5\xB6\xB7\xBF\xFB\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB8\xB5\xB4\xB7\xBF\xFB\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\xBF\xB7\xB4\xB4\xB7\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB7\xB5"
    "\xB3\xB7\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB8\xB4\xB2\xB6\xBF\xFB\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB8\xB3\xB2\xB6\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\xBF\xB8\xB1\xB2\xB7\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB9\xB6\xB6"
    "\xB9\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 27 = 'U'
    "\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB7\xB4\xB5\xB7\xBF"
    "\xFB\x20\x20\x20\xBF\xB6\xB3\xB4\xB7\xBF\xFB\xBF\xB7\xB7\xB9\xB9\xBF\xFB\x20\x20\x20\xBF\xB7"
    "\xB5\xB7\xB8\xBF\xFB\xBF\xB8\xB7\xB8\xB9\xBF\xFB\x20\x20\x20\xBF\xB8\xB6\xB7\xB9\xBF\xFB\xBF"
    "\xB8\xB7\xB8\xB9\xBF\xFB\x20\x20\x20\xBF\xB8\xB6\xB6\xB9\xBF\xFB\xBF\xB7\xB6\xB8\xB9\xBF\xFB"
    "\x20\x20\x20\xBF\xB7\xB6\xB5\xB8\xBF\xFB\xBF\xB7\xB6\xB8\xB9\xBF\xFB\x20\x20\x20\xBF\xB7\xB6"
    "\xB6\xB8\xBF\xFB\xBF\xB8\xB7\xB8\xB9\xBF\xFB\x20\x20\x20\xBF\xB7\xB5\xB6\xB8\xBF\xFB\xBF\xB8"
    "\xB8\xB8\xBA\xBF\xFB\x20\x20\x20\xBF\xB7\xB5\xB6\xB9\xBF\xFB\xBF\xB8\xB8\xB8\xBA\xBF\xFB\x20"
    "\x20\x20\xBF\xB8\xB5\xB6\xB8\xBF\xFB\xBF\xBA\xB5\xB8\xBB\xB8\xBF\xBF\xBF\xBF\xB7\xB5\xB5\xB5"
    "\xBB\xBF\xFB\x20\xBF\xB3\xB8\xBB\xBC\xB7\xB1\xB1\xB3\xB4\xB7\xB6\xB5\xBF\xFB\xFB\x20\xBF\xBA"
    "\xB7\xBB\xBC\xBB\xB7\xB4\xB7\xB5\xB8\xB6\xBA\xBF\xFB\x20\x20\x20\xBF\xBF\xBD\x2C\xBB\xBB\xB8"
    "\xBB\xBA\xBD\xBF\xBF\xFB\xFB\x20\x20\x20\x20\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\xFB"
    "\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 28 = 'V'
    "\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB4\xB3\xB4\xB7\xBF"
    "\xFB\x20\x20\x20\xBF\xB5\xB4\xB4\xB8\xBF\xFB\xBF\xB6\xB7\xB8\xB7\xBF\xFB\x20\x20\x20\xBF\xB9"
    "\xB7\xB8\xBA\xBF\xFB\xBF\xBA\xB7\xB7\xB7\xBF\xFB\x20\x20\x20\xBF\xB8\xB8\xB7\xBA\xBF\xFB\x20"
    "\xBF\xB7\xB7\xB7\xB6\xBF\x20\x20\xBF\xB7\xB7\xB7\xB7\xBF\xFB\xFB\x20\xBF\xBA\xB8\xB6\xB5\xBF"
    "\xFB\x20\xBF\xB6\xB6\xB5\xBA\xBF\xFB\x20\x20\x20\xBF\xB8\xB7\xB7\xB7\xBF\xBF\xB5\xB5\xB5\xB4"
    "\xBF\xFB\xFB\x20\x20\x20\xBF\xBA\xB7\xB7\xB8\xBF\xBF\xB5\xB6\xB5\xBA\xBF\xFB\x20\x20\x20\x20"
    "\x20\xBF\xB8\xB9\xB9\xB3\xB3\xB5\xB6\xB5\xBF\xFB\xFB\x20\x20\x20\x20\x20\xBF\xBA\xB8\xB8\xB5"
    "\xB5\xB6\xB6\xBA\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\xBF\xB7\xB5\xB5\xB5\xB6\xB7\xBF\xFB\xFB"
    "\x20\x20\x20\x20\x20\x20\x20\xBF\xBA\xB5\xB4\xB5\xB6\xBA\xBF\xFB\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\xBF\xB5\xB4\xB4\xB6\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB8\xB8\xB8"
    "\xB9\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xFB\xFB\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 29 = 'W'
    "\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB7\xB3\xB8\xBF\xFB"
    "\x20\x20\x20\x20\x20\xBF\xB9\xB4\xB7\xBF\xFB\xBF\xB9\xB6\xBA\xBF\xFB\x20\x20\x20\x20\x20\xBF"
    "\xBA\xB9\xBA\xBF\xFB\xBF\xBA\xB5\xB9\xBF\xFB\x20\x20\x20\x20\x20\xBF\xB8\xB8\xB9\xBF\xFB\xBF"
    "\xBA\xB5\xB9\xBF\xFB\x20\x20\x20\x20\x20\xBF\xB9\xB6\xB7\xBF\xFB\xBF\xBA\xB4\xB8\xBF\xFB\x20"
    "\xBF\xBF\x20\x20\xBF\xB9\xB6\xB7\xBF\xFB\xBF\xB9\xB6\xB8\xBF\xFB\xBF\xB5\xB5\xBF\x20\xBF\xB9"
    "\xB7\xB8\xBF\xFB\xBF\xB9\xB6\xB8\xBF\xBF\xB4\xBA\xBA\xB4\xBF\xBF\xB9\xB7\xB8\xBF\xFB\xBF\xB9"
    "\xB6\xB8\xBF\xB3\xB8\xBA\xB9\xB9\xB4\xBF\xB9\xB8\xB9\xBF\xFB\xBF\xB8\xB6\xB3\xB3\xB6\xB8\xBB"
    "\xB9\xBB\xB7\xB4\xB8\xB8\xB9\xBF\xFB\xBF\xB7\xB5\xB1\xB4\xB5\xB6\xB9\xBB\xBB\xB7\xB7\xB7\xB7"
    "\xB9\xBF\xFB\xBF\xB8\xB1\xB0\xB3\xB6\xB9\xBF\xBF\xBC\xB9\xB7\xB6\xB8\xBA\xBF\xFB\xBF\xBA\xB0"
    "\xB0\xB3\xB9\xBF\xFB\xFB\xBF\xBC\xB7\xB5\xB8\xBB\xBF\xFB\x20\xBF\xB6\xB6\xBC\xBF\xFB\xFB\x20"
    "\x20\xBF\xBC\xB9\xBA\xBF\xFB\xFB\x20\x20\xBF\xBF\xBF\xFB\xFB\x20\x20\x20\x20\xBF\xBF\xBF\xFB"
    "\xFB\x20\x20\x20\x20\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 30 = 'X'
    "\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB4\xB3\xB4\xB4\xBF"
    "\x20\x20\x20\x20\xBF\xB2\xB3\xB4\xB6\xBF\xFB\xBF\xB8\xB7\xB9\xB9\xB8\xBF\x20\x20\xBF\xB4\xB4"
    "\xB5\xB7\xB9\xBF\xFB\x20\xBF\xBA\xB8\xB9\xBC\xB8\xBF\xBF\xB4\xB7\xB5\xB6\xBA\xBF\xFB\xFB\x20"
    "\x20\xBF\xBA\xB9\xBC\xBC\xB8\xB6\xB6\xB7\xB5\xB9\xBF\xFB\xFB\x20\x20\x20\x20\xBF\xBB\xBC\xBC"
    "\xBA\xBA\xB4\xB7\xB8\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20\xBF\xBD\xBC\xBA\xB8\xB4\xBA\xBF\xFB"
    "\xFB\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBA\xB9\xB9\xBA\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20"
    "\x20\x20\xBF\xBD\xB9\xB9\xB8\xB7\xBA\xBF\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBB\xB9\xB9\xBA"
    "\xBA\xB7\xB7\xB8\xBF\x20\x20\x20\x20\x20\x20\xBF\xBA\xB9\xB9\xBA\xBB\xBB\xB6\xB7\xB5\xB9\xBF"
    "\x20\x20\x20\x20\xBF\xBA\xB8\xBA\xB9\xBB\xBF\xBF\xBB\xB7\xB5\xB6\xBA\xBF\x20\x20\xBF\xB8\xB7"
    "\xB9\xB9\xBB\xBF\xFB\xFB\xBF\xBB\xB7\xB5\xB7\xB9\xBF\x20\xBF\xBB\xBB\xBC\xBC\xBF\xFB\xFB\x20"
    "\x20\xBF\xBB\xB9\xB9\xBC\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xFB\xFB\x20\x20\x20\x20\xBF\xBF\xBF\xBF"
    "\xBF\xFB\x20\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 31 = 'Y'
    "\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB4\xB3\xB4\xB4"
    "\xBF\x20\x20\x20\x20\xBF\xB2\xB3\xB4\xB6\xB8\xBF\xFB\xBF\xB8\xB7\xB9\xB9\xB8\xBF\x20\x20\xBF"
    "\xB4\xB4\xB5\xB7\xB9\xBF\xFB\xFB\x20\xBF\xBA\xB8\xB9\xBC\xB8\xBF\xBF\xB4\xB7\xB5\xB6\xBA\xBF"
    "\xFB\xFB\x20\x20\x20\xBF\xBA\xB9\xBC\xBC\xB8\xB6\xB6\xB7\xB5\xB9\xBF\xFB\xFB\x20\x20\x20\x20"
    "\x20\xBF\xBB\xBC\xBC\xBB\xBA\xB4\xB7\xB8\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\xBF\xBD\xBC"
    "\xB9\xB8\xB4\xBA\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBC\xBA\xB7\xB7\xBF\xFB"
    "\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBC\xB9\xB6\xB7\xBF\xFB\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\xBF\x2C\xB8\xB5\xB8\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\xBF\x2B\xB8\xB4\xB7\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\x2A\xB8\xB4"
    "\xB8\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBB\xB7\xB4\xB9\xBF\xFB\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBB\xBB\xB8\xBB\xBF\xFB\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20",

    // 32 = 'Z'
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB9\xB7\xB3\xB3\xB3\xB2"
    "\xB4\xB4\xB6\xB3\xB2\xB3\xB4\xBF\xFB\xBF\xBA\xB9\xB7\xB9\xBA\xB7\xB6\xB6\xB6\xB6\xB4\xB5\xB7"
    "\xBF\xFB\xBF\xBB\xB9\xBB\xBB\xBB\xBA\xBB\xBA\xBA\xB7\xB5\xB6\xBA\xBF\xFB\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBA\xB6\xB7\xB5\xB9\xBF\xFB\xFB\x20\xFB\xFB\xFB\xFB\xFB\xBF\xB7\xB8\xB4\xB7\xB8"
    "\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20\xBF\xB7\xB8\xB8\xB8\xBA\xBF\xFB\xFB\x20\x20\x20\x20\x20"
    "\x20\xBF\xB6\xB8\xB9\xB9\xBA\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20\xBF\xB6\xB8\xB8\xB9\xB8\xBF"
    "\xFB\xFB\x20\x20\x20\x20\x20\x20\xBF\xB7\xB8\xB9\xB9\xBA\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20"
    "\xBF\xB7\xB8\xB9\xB9\xBA\xBB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB8\xB8\xBA\xBA\xB9\xBB\xBB"
    "\xB9\xB8\xB5\xB1\xB1\xB6\xBF\xFB\xBF\xBA\xBA\xB9\xB9\xBB\xBB\xB9\xB8\xB5\xB5\xB3\xB2\xB8\xBF"
    "\xFB\xBF\xBB\xBB\xBC\xBC\xBB\xBC\xBC\xBB\xBB\xB9\xB8\xB9\xBC\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB"
    "\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 33 = 'a'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\x20\x20"
    "\xBF\xBF\xB7\xB6\xB2\xB2\xB3\xBA\xBF\x20\x20\x20\x20\x20\x20\xBF\xBB\xB8\xB9\xB8\xBA\xBB\xB5"
    "\xB7\xBC\xBF\x20\x20\x20\x20\xBF\xBA\xB8\xB6\xBA\xBF\xBF\xB9\xB6\xB7\xBA\xBF\xFB\x20\x20\x20"
    "\xBF\xB8\xB6\xB7\xBF\xBF\xBF\xB9\xB6\xB8\xB9\xBF\xFB\x20\x20\xBF\xBA\xB5\xB5\xBA\xBF\xB4\xB4"
    "\xB7\xB6\xB7\xBA\xBF\xFB\x20\x20\xBF\xB8\xB5\xB6\xBF\xBF\xB9\xBB\xB9\xB6\xB8\xBA\xBF\xFB\x20"
    "\xBF\xBA\xB5\xB4\xBA\xBF\xBF\xBF\xBF\xB9\xB7\xB7\xB9\xBF\xFB\x20\xBF\xB7\xB2\xB3\xBF\xFB\xFB"
    "\xFB\xBF\xBA\xB7\xB6\xBA\xBF\xFB\xBF\xB8\xB5\xB2\xBA\xBF\xFB\x20\x20\xBF\xBA\xB7\xB5\xBA\xBF"
    "\xFB\xBF\xB8\xB8\xB7\xBF\xFB\xFB\x20\x20\xBF\xBB\xBA\xB9\xBB\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xFB"
    "\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\xC8\xFB\xFB\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB"
    "\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 34 = 'b'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\xBF\xB7\xB2\xB2\xB2\xB1\xB1\xB1\xB1"
    "\xB4\xB6\xBA\xBF\x20\x20\xBF\xBA\xBC\xB9\xB9\xB6\xB8\xB6\xB8\xB6\xB6\xB5\xBA\xBF\x20\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xB4\xB3\xB4\xB6\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xB3"
    "\xB3\xB5\xB6\xBF\xFB\xBF\xB7\xB2\xB1\xB1\xB2\xB1\xB1\xB3\xB5\xB3\xB3\xBA\xBF\xFB\xBF\xB9\xB7"
    "\xB1\xB2\xB9\xB6\xB6\xB9\xB9\xB3\xB7\xBF\xBF\xFB\xBF\xBA\xBA\xB3\xB1\xBF\xBF\xBF\xBF\xB5\xB3"
    "\xB7\xB6\xBF\xFB\xBF\xB9\xBA\xB4\xB1\xBF\xBF\xBF\xBF\xB3\xB3\xB5\xB6\xBF\xFB\xBF\xBA\xB8\xB5"
    "\xB4\xB1\xB1\xB1\xB3\xB5\xB3\xB3\xBA\xBF\xFB\xBF\xBB\xBC\xBB\xB9\xB6\xB6\xB6\xB9\xB9\xB7\xBA"
    "\xBF\xFB\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\x20\x20\xFB\xFB\xFB\xFB"
    "\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 35 = 'c'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\xBF\xBF\xBB\xB8\xB8\xB6\xB2"
    "\xB2\xB2\xB2\xB6\xBF\xFB\x20\xBF\xBB\xB6\xBC\xBC\xBC\xBC\xB8\xBA\xB8\xB9\xBA\xBF\xFB\x20\xBF"
    "\xB8\xB9\xBC\xBD\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xBF\xBB\xB8\xB9\xBC\xBF\xFB\xFB\xFB\xFB"
    "\xFB\xFB\xFB\xFB\xFB\xBF\xB9\xB8\xBA\xBC\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB9\xB8"
    "\xBA\xBB\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBB\xB8\xBB\xBC\xBF\xFB\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\xBF\xB8\xBB\xBC\xB8\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xBC\xBB"
    "\xBC\xBB\xB4\xB2\xB4\xB2\xB3\xB2\xB6\xBF\xFB\x20\x20\xBF\xBF\x2C\xBB\xBB\xB8\xBB\xBA\xBA\xBA"
    "\xB9\xBF\xFB\x20\x20\x20\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\x20\x20"
    "\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 36 = 'd'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x2D\xB8\xB2\xB2\xB2"
    "\xB2\xB1\xB1\xB2\xB4\xBA\xBF\xBF\x20\x20\x20\xBF\xBB\xBA\xB9\xB9\xB9\xB8\xB8\xB9\xB6\xB6\xB5"
    "\xBB\xBF\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xB9\xB5\xB4\xB6\xBF\xFB\x20\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xFB\xFB\xFB\xBF\xB5\xB2\xB6\xBB\xBF\x20\xBF\xB8\xB5\xB5\xB8\xBF\xFB\x20\x20\xBF"
    "\xB5\xB2\xB4\xB9\xBF\xFB\xBF\xB9\xB7\xB8\xB9\xBF\xFB\x20\x20\xBF\xB5\xB2\xB3\xB9\xBF\xFB\xBF"
    "\xB8\xB7\xB7\xB9\xBF\xFB\x20\x20\xBF\xB4\xB2\xB3\xBB\xBF\xFB\xBF\xB8\xB6\xB6\xB8\xBF\xBF\xBF"
    "\xBF\xB4\xB4\xB2\xB7\xBF\xFB\xFB\xBF\xB8\xB7\xB5\xB4\xB2\xB1\xB1\xB4\xB5\xB3\xB7\xBB\xBF\xFB"
    "\x20\xBF\xBA\xB9\xB9\xB8\xB8\xB8\xB8\xB9\xB9\xBA\xBF\xBF\xFB\xFB\x20\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xFB\xFB\xFB\x20\x20\x20\xC8\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 37 = 'e'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\xBF\xBF\xB9\xB4\xB6\xB3\xB3"
    "\xB4\xB4\xB3\xB8\xBF\xFB\x20\xBF\xBC\xB7\xB6\xB6\xBA\xBB\xBA\xBC\xBC\xB9\xBB\xBF\xFB\x20\xBF"
    "\xB9\xB5\xB5\xB9\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xBF\xBA\xB6\xB5\xB5\xB9\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xFB\xBF\xB9\xB6\xB5\xB5\xB5\xB5\xB4\xB4\xB4\xB2\xB2\xB9\xBF\xFB\xBF\xB9\xB6"
    "\xB6\xB5\xB6\xBA\xBC\xBB\xBC\xBA\xB9\xBB\xBF\xFB\xBF\xBA\xB5\xB5\xB4\xB9\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xFB\x20\xBF\xB7\xB2\xB3\xB9\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\xBF\xBC\xB9"
    "\xB3\xB5\xB3\xB2\xB2\xB2\xB3\xB4\xB7\xBF\xFB\x20\x20\xBF\xBF\xBA\xB8\xB9\xB9\xBA\xB9\xBA\xBA"
    "\xBA\xBF\xFB\x20\x20\x20\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\x20\x20"
    "\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 38 = 'f'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\xBF\xBF\xBA\xB4\xB1\xB1\xB1\xB2\xB7\xBF\xFB\x20\xBF\xBC\xBA"
    "\xB6\xB9\xB9\xB9\xB8\xB8\xBA\xBF\xFB\x20\xBF\xB8\xBA\xB5\xBA\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xBF"
    "\xBB\xB8\xB8\xB5\xBF\xBF\xBF\xBF\xFB\xFB\xFB\xFB\xBF\xB9\xB7\xB5\xB4\xB1\xB1\xB6\xBF\xFB\x20"
    "\x20\x20\xBF\xB9\xB6\xB4\xB4\xB9\xB8\xBA\xBF\xFB\x20\x20\x20\xBF\xB8\xB7\xB5\xB9\xBF\xBF\xBF"
    "\xBF\xFB\x20\x20\x20\xBF\xB9\xB6\xB3\xB8\xBF\xFB\xFB\xFB\xFB\x20\x20\x20\xBF\xB9\xB6\xB2\xB8"
    "\xBF\xFB\x20\x20\x20\x20\x20\x20\xBF\xBA\xBA\xB7\xBA\xBF\xFB\x20\x20\x20\x20\x20\x20\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20",

    // 39 = 'g'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20"
    "\x20\xBF\xBF\xBB\xB8\xB8\xB5\xB4\xB2\xB2\xB2\xB2\xB4\xB9\xBF\xFB\x20\xBF\xBC\xB8\xB9\xBC\xBD"
    "\xBC\xBC\xB8\xBA\xB8\xB9\xB9\xBB\xBF\xFB\x20\xBF\xB6\xB8\xB9\xBC\xBF\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xFB\xBF\xBB\xB7\xB8\xB9\xBF\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xBF\xBA"
    "\xB8\xB8\xBA\xBF\xFB\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xBA\xB8\xB8\xBA\xBF\xFB\x20"
    "\x20\x20\xBF\xB6\xB1\xB1\xB8\xBF\xFB\xBF\xBA\xB5\xB8\xBB\xBF\xFB\x20\x20\x20\xBF\xB8\xB2\xB1"
    "\xB9\xBF\xFB\x20\xBF\xB3\xB8\xBB\xBC\xBF\xBF\xBF\xBF\xBF\xB9\xB2\xB1\xB9\xBF\xFB\x20\xBF\xBC"
    "\xB7\xBB\xBC\xB7\xB2\xB1\xB2\xB3\xB8\xB2\xB1\xB9\xBF\xFB\x20\x20\xBF\xBF\xBD\x2C\xBB\xBB\xB8"
    "\xBB\xBA\xBA\xB7\xB7\xBA\xBF\xFB\x20\x20\x20\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 40 = 'h'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB8\xB4\xB4\xB7"
    "\xBF\xFB\x20\x20\xBF\xB7\xB2\xB2\xB7\xBF\xFB\xBF\xBA\xB9\xB8\xB8\xBF\xFB\x20\x20\xBF\xB8\xB6"
    "\xB5\xBA\xBF\xFB\xBF\xBA\xB8\xB8\xB9\xBF\xFB\x20\x20\xBF\xB8\xB5\xB4\xB9\xBF\xFB\xBF\xBA\xB8"
    "\xB8\xB9\xBF\xBF\xBF\xBF\xBF\xB8\xB5\xB2\xB9\xBF\xFB\xBF\xBA\xB8\xB8\xB8\xB6\xB4\xB2\xB2\xB3"
    "\xB6\xB5\xB2\xB7\xBF\xFB\xBF\xBA\xB7\xB7\xBA\xBA\xBA\xB9\xB9\xB9\xB9\xB5\xB2\xB7\xBF\xFB\xBF"
    "\xB9\xB6\xB7\xBA\xBF\xBF\xBF\xBF\xBF\xB9\xB4\xB2\xB7\xBF\xFB\xBF\xB9\xB5\xB6\xBA\xBF\xFB\xFB"
    "\xFB\xBF\xB9\xB4\xB2\xB7\xBF\xFB\xBF\xB9\xB6\xB7\xB9\xBF\xFB\x20\x20\xBF\xB8\xB3\xB3\xB7\xBF"
    "\xFB\xBF\xBA\xB9\xB9\xBB\xBF\xFB\x20\x20\xBF\xBA\xB8\xB7\xBA\xBF\xFB\xBF\x2D\xBF\xBF\x2D\xBF"
    "\xFB\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\xC8\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\xFB\xFB\xFB"
    "\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 41 = 'i'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF"
    "\xBF\xBF\xBF\xBF\x20\xBF\xB7\xB3\xB3\xB8\xBF\xFB\xBF\xB9\xB9\xB8\xBB\xBF\xFB\xBF\xB8\xBA\xB8"
    "\xBA\xBF\xFB\xBF\xB9\xBA\xBA\xBA\xBF\xFB\xBF\xB9\xBA\xB9\xBA\xBF\xFB\xBF\xB9\xBB\xB9\xBB\xBF"
    "\xFB\xBF\xB8\xB9\xBB\xBB\xBF\xFB\xBF\xB8\xB7\xB9\xBA\xBF\xFB\xBF\xB8\xB5\xB8\xB9\xBF\xFB\xBF"
    "\xBA\xB9\xBA\xBA\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\xC8\xFB\xFB\xFB\xFB\xFB\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 42 = 'j'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF"
    "\xBF\x20\x20\x20\x20\x20\x20\xBF\xB7\xB2\xB4\xBA\xBF\xFB\x20\x20\x20\x20\x20\xBF\xBA\xB6\xB9"
    "\xBC\xBF\xFB\x20\x20\x20\x20\x20\xBF\xBB\xB8\xBA\xBB\xBF\xFB\x20\x20\x20\x20\x20\xBF\xBB\xBA"
    "\xBB\xBA\xBF\xFB\x20\x20\x20\x20\x20\xBF\xBA\xB9\xBA\xBB\xBF\xFB\x20\x20\x20\x20\x20\xBF\xB9"
    "\xB9\xB8\xBA\xBF\xFB\x20\x20\x20\x20\x20\xBF\xBB\xB8\xB6\xB9\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xB9"
    "\xBB\xB9\xB8\xBA\xBF\xFB\xBF\xB6\xB3\xB4\xB6\xB6\xB9\xB9\xBA\xBF\xFB\xFB\xBF\xB9\xBB\xB9\xB9"
    "\xBB\xBB\xBB\xBF\xBF\xFB\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\xFB\x20\x20\xFB\xFB\xFB"
    "\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 43 = 'k'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF"
    "\xB6\xB2\xB1\xB5\xBF\xFB\x20\xBF\xB1\xB1\xB1\xB1\xB8\xBF\xFB\x20\xBF\xB7\xB6\xB3\xB4\xBF\xFB"
    "\xBF\xB1\xB4\xB6\xB5\xBA\xBF\xFB\xFB\x20\xBF\xB6\xB3\xB4\xB6\xBF\xBF\xB2\xB4\xB4\xB4\xB8\xBF"
    "\xFB\xFB\x20\x20\xBF\xB7\xB2\xB1\xB7\xBF\xB2\xB5\xB4\xB3\xB9\xBF\xFB\xFB\x20\x20\x20\xBF\xB9"
    "\xB3\xB2\xB4\xB5\xB6\xB7\xB4\xB4\xBF\xFB\xFB\x20\x20\x20\x20\xBF\xB8\xB3\xB2\xB7\xBF\xB9\xB4"
    "\xB3\xB3\xB2\xBF\x20\x20\x20\x20\x20\xBF\xB7\xB4\xB2\xB7\xBF\xBF\xB8\xB3\xB2\xB3\xB5\xBF\x20"
    "\x20\x20\x20\xBF\xB8\xB5\xB2\xB6\xBF\xFB\xBF\xB8\xB2\xB3\xB8\xB4\xBF\x20\x20\x20\xBF\xB6\xB5"
    "\xB3\xB6\xBF\xFB\x20\xBF\xB7\xB4\xB8\xB7\xB5\xBF\x20\x20\xBF\xB9\xB8\xB8\xB9\xBF\xFB\x20\x20"
    "\xBF\xBB\xBC\xBA\xBB\xB6\xBF\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 44 = 'l'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20"
    "\x20\x20\xBF\xBA\xB4\xB2\xB7\xBF\xFB\x20\x20\x20\x20\x20\xBF\xBC\xB9\xB6\xBB\xBF\xFB\x20\x20"
    "\x20\x20\x20\xBF\xBB\xBA\xBA\xBB\xBF\xFB\x20\x20\x20\x20\x20\xBF\xBB\xBB\xBA\xBB\xBF\xFB\x20"
    "\x20\x20\x20\x20\xBF\xBB\xB8\xB9\xBA\xBF\xFB\x20\x20\x20\x20\x20\xBF\xBA\xB8\xB8\xB9\xBF\xFB"
    "\x20\x20\x20\x20\x20\xBF\xB9\xB6\xB9\xBB\xBF\xFB\x20\x20\x20\x20\x20\xBF\xB9\xB6\xB8\xBB\xB9"
    "\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xB8\xB9\xB9\xB2\xB3\xB4\xB3\xB6\xBF\xFB\x20\xBF\xBF\xBB\xBB"
    "\xB7\xB9\xB9\xB8\xB9\xBF\xFB\x20\x20\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\x20"
    "\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 45 = 'm'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\x20\x20\x20\x20"
    "\xBF\xB5\xB1\xB6\xBF\x20\x20\x20\x20\xBF\xB4\xB1\xB3\xBF\x20\x20\xBF\xB8\xB2\xB1\xB5\xB6\xBF"
    "\x20\x20\xBF\xB5\xB8\xB4\xB6\xB8\xBF\x20\xBF\xB7\xB3\xB3\xB6\xBB\xB7\xBF\xBF\xB3\xB9\xB7\xB6"
    "\xB8\xBB\xBF\xFB\xBF\xB8\xB3\xB5\xB8\xBB\xBB\xB4\xB4\xB5\xB7\xB5\xB7\xB8\xBB\xBF\xFB\xBF\xB6"
    "\xB3\xB5\xB6\xBC\xBB\xBA\xB9\xB5\xB6\xB4\xB8\xBA\xBC\xBF\xFB\xBF\xB6\xB3\xB4\xB7\xBC\xBB\xBA"
    "\xB8\xB6\xB5\xB3\xBA\xBA\x2A\xBF\xFB\xBF\xB6\xB4\xB3\xB8\xBF\xBC\xBA\xB6\xB9\xBF\xB7\xBA\xBB"
    "\xBB\xBF\xFB\xBF\xB5\xB4\xB4\xB7\xBF\xBF\xBA\xB9\xBF\xBF\xB8\xBA\xBA\xBB\xBF\xFB\xBF\xB5\xB3"
    "\xB3\xB7\xBF\xFB\xBF\xBF\xFB\xBF\xB8\xBB\xB9\xB9\xBF\xFB\xBF\xB8\xB8\xB8\xB9\xBF\xFB\x20\xFB"
    "\xFB\xBF\xBA\xBC\xBB\xBA\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\x20\xC8\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 46 = 'n'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20"
    "\xBF\xB1\xB1\xBA\xBF\x20\x20\x20\x20\xBF\xB8\xB0\xB1\xB8\xBF\xFB\xBF\xB8\xB4\xB5\xB4\xBA\xBF"
    "\x20\x20\x20\xBF\xB6\xB0\xB4\xB8\xBF\xFB\xBF\xB9\xB6\xB5\xB5\xB6\xBA\xBF\x20\x20\xBF\xB6\xB0"
    "\xB5\xB9\xBF\xFB\xBF\xB9\xB5\xB5\xB4\xB6\xB6\xBA\xBF\x20\xBF\xB7\xB0\xB4\xB9\xBF\xFB\xBF\xBA"
    "\xB6\xB6\xB6\xB6\xB6\xB6\xBA\xBF\xBF\xB7\xB0\xB3\xB9\xBF\xFB\xBF\xBA\xB6\xB5\xB4\xB6\xB6\xB4"
    "\xB2\xBA\xBF\xB6\xB0\xB3\xB9\xBF\xFB\xBF\xBA\xB6\xB4\xB7\xBF\xBA\xB2\xB2\xB4\xB4\xB2\xB0\xB3"
    "\xB9\xBF\xFB\xBF\xBA\xB5\xB3\xB8\xBF\xBF\xBA\xB2\xB5\xB4\xB2\xB0\xB3\xB9\xBF\xFB\xBF\xBB\xB5"
    "\xB3\xB8\xBF\xFB\xBF\xBA\xB3\xB2\xB2\xB0\xB2\xBB\xBF\xFB\xBF\xBB\xB9\xB8\xBA\xBF\xFB\x20\xBF"
    "\xBF\xBA\xB8\xB6\xB8\xBF\xFB\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\xFB\xBF\xBF\xBF\xBF\xFB"
    "\xFB\x20\x20\xC8\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 47 = 'o'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20"
    "\x20\x20\x20\x20\x20\xBF\xBF\xB9\xB3\xB1\xB1\xB1\xB1\xB1\xB4\xB9\xBF\xBF\x20\x20\x20\x20\xBF"
    "\xBB\xB1\xB5\xB5\xB8\xB8\xBB\xBB\xBA\xB6\xB7\xB8\xBB\xBF\x20\x20\x20\xBF\xB2\xB3\xB5\xBB\xBF"
    "\xBF\xBF\xBF\xBF\xBC\xB7\xB8\xB5\xBF\xFB\x20\xBF\xBA\xB4\xB5\xB8\xBF\xFB\xFB\xFB\xFB\xFB\xBF"
    "\xB9\xB8\xB6\xBA\xBF\x20\xBF\xB8\xB4\xB5\xB8\xBF\xFB\x20\x20\x20\x20\xBF\xB9\xBA\xB9\xBA\xBF"
    "\xFB\xBF\xB8\xB4\xB4\xB8\xBF\xFB\x20\x20\x20\x20\xBF\xB9\xBB\xBB\xBA\xBF\xFB\xBF\xB8\xB4\xB3"
    "\xB6\xBF\xFB\x20\x20\x20\x20\xBF\xBA\xBB\xBB\xBA\xBF\xFB\xBF\xBF\xB2\xB2\xB3\xB5\xBF\xBF\xBF"
    "\xBF\xBF\xB6\xB9\xBA\xBA\xBF\xFB\xFB\x20\xBF\xBB\xB7\xB2\xB5\xB1\xB1\xB1\xB3\xB4\xB8\xBA\xB8"
    "\xBC\xBF\xFB\x20\x20\x20\xBF\xBF\xB9\xB9\xB8\xB7\xB9\xBC\xBA\xBB\xBB\xBF\xBF\xFB\xFB\x20\x20"
    "\x20\x20\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\xFB"
    "\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20",

    // 48 = 'p'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\xBF\xB7\xB2\xB2\xB2\xB1\xB1\xB1\xB1"
    "\xB4\xB6\xBA\xBF\x20\x20\xBF\xBA\xBC\xB9\xB9\xB6\xB8\xB6\xB8\xB6\xB6\xB5\xBA\xBF\x20\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xB4\xB3\xB4\xB6\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xB3"
    "\xB3\xB5\xB6\xBF\xFB\xBF\xB7\xB2\xB1\xB1\xB2\xB1\xB1\xB3\xB5\xB3\xB3\xBA\xBF\xFB\xBF\xB9\xB7"
    "\xB1\xB2\xB9\xB6\xB6\xB9\xB9\xB7\xBA\xBF\xFB\xFB\xBF\xBA\xBA\xB3\xB1\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\xFB\x20\xBF\xB9\xBA\xB4\xB3\xBF\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\xBF\xBA\xB8\xB5"
    "\xB4\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBB\xBC\xBB\xB9\xBF\xFB\x20\x20\x20\x20\x20"
    "\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\xC8\xFB\xFB\xFB"
    "\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 49 = 'q'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20"
    "\x20\x20\x20\x20\x20\xBF\xBF\xB9\xB3\xB1\xB1\xB1\xB1\xB1\xB4\xB9\xBF\xBF\x20\x20\x20\x20\xBF"
    "\xBB\xB1\xB5\xB5\xB8\xB8\xBB\xBB\xBA\xB6\xB7\xB8\xBB\xBF\x20\x20\x20\xBF\xB2\xB3\xB5\xBB\xBF"
    "\xBF\xBF\xBF\xBF\xBC\xB7\xB8\xB5\xBF\xFB\x20\xBF\xBA\xB4\xB5\xB8\xBF\xFB\xFB\xFB\xFB\xFB\xBF"
    "\xB9\xB8\xB6\xBA\xBF\x20\xBF\xB8\xB4\xB5\xB8\xBF\xFB\x20\x20\x20\x20\xBF\xB9\xBA\xB9\xB9\xBF"
    "\xFB\xBF\xB8\xB5\xB5\xB8\xBF\xFB\x20\x20\x20\x20\xBF\xB9\xBB\xBB\xBA\xBF\xFB\xBF\xB8\xB5\xB8"
    "\xB6\xBF\xFB\x20\x20\x20\x20\xBF\xBA\xBB\xBB\xBA\xBF\xFB\x20\xBF\xB8\xB8\xB5\xB9\xBF\xBF\xBF"
    "\xBF\xBF\xB6\xB9\xBA\xBA\xBF\xFB\xFB\x20\xBF\xBB\xB9\xB8\xB5\xB6\xB1\xB1\xB3\xB6\xB8\xBA\xB8"
    "\xBC\xBF\xFB\x20\x20\x20\xBF\xBF\xB9\xB9\xB8\xB7\xB9\xBC\xBA\xBB\xBB\xBF\xBF\xFB\xFB\x20\x20"
    "\x20\x20\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xB8\xBB\xBF\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\xFB"
    "\xFB\xFB\xFB\xBF\xBA\xBB\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF"
    "\xBF\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\x20\x20"
    "\x20\x20",

    // 50 = 'r'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\xBF\xB8\xB1\xB2\xB1"
    "\xB1\xB1\xB1\xB1\xB2\xB2\xB2\xBA\xBF\x20\x20\xBF\xBA\xB8\xB9\xB8\xB9\xB9\xB9\xB8\xB7\xB7\xB4"
    "\xB2\xBA\xBF\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xB8\xB5\xB3\xB6\xBF\xFB\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xB8\xB4\xB5\xB8\xBF\xFB\xBF\xB7\xB2\xB1\xB1\xB1\xB1\xB1\xB3\xB2"
    "\xB3\xB3\xB5\xBF\xFB\xFB\xBF\xB8\xB4\xB6\xB6\xB8\xBA\xBA\xB9\xB7\xB3\xB3\xB4\xBF\xFB\x20\xBF"
    "\xB7\xB4\xB5\xB5\xBF\xBF\xBF\xBF\xBA\xB2\xB3\xB4\xB7\xBF\x20\xBF\xB6\xB5\xB4\xB6\xBF\xFB\xFB"
    "\xFB\xBF\xB2\xB3\xB3\xB8\xBF\xFB\xBF\xB6\xB5\xB4\xB6\xBF\xFB\x20\x20\xBF\xB3\xB2\xB2\xB6\xBF"
    "\xFB\xBF\xB9\xBA\xBA\xB9\xBF\xFB\x20\x20\xBF\xB8\xBA\xB9\xB9\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xFB\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\xC8\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\xFB\xFB\xFB"
    "\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 51 = 's'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xB6\xB3\xB2"
    "\xB2\xB2\xB2\xB4\xB6\xB4\xB7\xB9\xBA\xBF\xFB\xBF\xBB\xB4\xB4\xB8\xBB\xBC\xBB\xBA\xBA\xBA\xBD"
    "\x2D\xBC\xBF\xFB\xBF\xB9\xB4\xB4\xB8\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xBF\xB9\xB4"
    "\xB3\xB8\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\xFB\xBF\xBB\xB4\xB4\xB7\xB3\xB2\xB2\xB2\xB4"
    "\xB4\xB6\xBA\xBF\x20\x20\x20\xBF\xBA\xBC\xBA\xBC\xBA\xB9\xBA\xBC\xBC\xB8\xB8\xBB\xBF\x20\x20"
    "\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBC\xB8\xB9\xBA\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBB\xB8\xB9\xBA\xBF\xFB\xBF\xB8\xB2\xB1\xB1\xB3\xB2\xB3\xB6\xB5\xB6\xB8\xB8\xBB\xBF"
    "\xFB\xBF\xBA\xBA\xB9\xBA\xBC\xBA\xBB\xBA\xB9\xB9\xBA\xBC\xBF\xFB\xFB\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\x20\x20\xC8\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB"
    "\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 52 = 't'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB8\xB2\xB1\xB1\xB1\xB1\xB2\xB2\xB2\xB5\xBF\xFB\xBF\xBB\xBB\xB6"
    "\xB6\xB1\xB3\xB6\xB9\xBB\xBB\xBF\xFB\xBF\xBF\xBF\xBF\xB5\xB2\xB3\xB7\xBF\xBF\xBF\xBF\xFB\x20"
    "\xC8\xFB\xBF\xB5\xB3\xB6\xB6\xBF\xFB\xFB\xFB\xFB\x20\x20\x20\xBF\xB5\xB1\xB5\xB8\xBF\xFB\x20"
    "\x20\x20\x20\x20\x20\xBF\xB5\xB1\xB5\xB8\xBF\xFB\x20\x20\x20\x20\x20\x20\xBF\xB5\xB2\xB4\xB8"
    "\xBF\xFB\x20\x20\x20\x20\x20\x20\xBF\xB5\xB3\xB3\xB7\xBF\xFB\x20\x20\x20\x20\x20\x20\xBF\xB6"
    "\xB3\xB3\xB6\xBF\xFB\x20\x20\x20\x20\x20\x20\xBF\xB9\xB8\xB8\xB9\xBF\xFB\x20\x20\x20\x20\x20"
    "\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20",

    // 53 = 'u'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF"
    "\xB7\xB2\xB2\xB9\xBF\xFB\x20\x20\x20\xBF\xB8\xB4\xB2\xB6\xBF\xFB\xBF\xBA\xBB\xBB\xBB\xBF\xFB"
    "\x20\x20\x20\xBF\xBA\xB9\xB5\xB6\xBF\xFB\xBF\xBB\xBB\xBB\xBA\xBF\xFB\x20\x20\x20\xBF\xB9\xB7"
    "\xB7\xB7\xBF\xFB\xBF\xBB\xBB\xBB\xBA\xBF\xFB\x20\x20\x20\xBF\xB9\xB8\xB8\xB8\xBF\xFB\xBF\xBC"
    "\xBB\xBA\xBA\xBF\xFB\x20\x20\x20\xBF\xBB\xBA\xBA\xB9\xBF\xFB\xBF\xBC\xBB\xBA\xB9\xBF\xFB\x20"
    "\x20\x20\xBF\xBB\xBB\xBA\xB9\xBF\xFB\xBF\xBB\xBB\xBA\xB8\xBF\xFB\x20\x20\x20\xBF\xBB\xBA\xB9"
    "\xBB\xBF\xFB\x20\xBF\xBB\xBA\xB6\xB4\xBF\xBF\xBF\xBF\xBA\xB9\xB8\xB8\xBF\xFB\xFB\x20\xBF\xBD"
    "\xB8\xB8\xB2\xB1\xB2\xB4\xB4\xB8\xB7\xB6\xBC\xBF\xFB\x20\x20\x20\xBF\xBF\xBC\xBA\xBA\xBB\xBD"
    "\xBC\xB9\xBC\xBF\xBF\xFB\xFB\x20\x20\x20\x20\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\xFB"
    "\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 54 = 'v'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF"
    "\xB7\xB1\xB1\xB6\xBF\xFB\x20\x20\x20\xBF\xB6\xB2\xB1\xB1\xBF\xFB\xBF\xB9\xB4\xB5\xB7\xBF\xFB"
    "\x20\x20\x20\xBF\xB6\xB4\xB4\xB8\xBF\xFB\x20\xBF\xB6\xB5\xB5\xB9\xBF\x20\x20\xBF\xB8\xB3\xB5"
    "\xB5\xBF\xFB\xFB\x20\xBF\xB8\xB5\xB4\xB8\xBF\xFB\x20\xBF\xB6\xB4\xB5\xB8\xBF\xFB\x20\x20\x20"
    "\xBF\xB6\xB6\xB6\xB9\xBF\xBF\xB8\xB5\xB4\xB3\xBF\xFB\xFB\x20\x20\x20\xBF\xB8\xB4\xB6\xB6\xB9"
    "\xB9\xB3\xB5\xB2\xB8\xBF\xFB\x20\x20\x20\x20\x20\xBF\xB4\xB5\xB5\xB2\xB2\xB4\xB4\xB2\xBF\xFB"
    "\xFB\x20\x20\x20\x20\x20\xBF\xB8\xB4\xB6\xB4\xB2\xB5\xB4\xB8\xBF\xFB\x20\x20\x20\x20\x20\x20"
    "\x20\xBF\xB4\xB6\xB7\xB4\xB3\xB2\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\xBF\xB9\xBB\xBB\xBC"
    "\xB8\xB7\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 55 = 'w'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\x20\xBF"
    "\xB6\xB2\xB5\xBF\xFB\x20\x20\x20\x20\x20\xBF\xB9\xB6\xB8\xBF\xFB\xBF\xB7\xB5\xB7\xBF\xFB\x20"
    "\xBF\xBF\x20\x20\xBF\xBC\xBD\xBA\xBF\xFB\xBF\xB7\xB5\xB7\xBF\xFB\xBF\xB2\xB2\xBF\x20\xBF\xBB"
    "\xBC\xB9\xBF\xFB\xBF\xB7\xB5\xB7\xBF\xBF\xB2\xB7\xB8\xB2\xBF\xBF\xBA\xBB\xB9\xBF\xFB\xBF\xB8"
    "\xB7\xB7\xBF\xB2\xB8\xB7\xB7\xB7\xB4\xBF\xBA\xB9\xB9\xBF\xFB\xBF\xB7\xB4\xB6\xB3\xB4\xB7\xB7"
    "\xB6\xB8\xBB\xBB\xB9\xB8\xB9\xBF\xFB\xBF\xB6\xB3\xB3\xB2\xB3\xB8\xBC\xBB\xB9\xBB\xBB\xB8\xB9"
    "\xB8\xBF\xFB\xBF\xB6\xB5\xB4\xB2\xB3\xBC\xBF\xBF\xBB\xBA\xBA\xB8\xB9\xB8\xBF\xFB\xBF\xBA\xB5"
    "\xB3\xB2\xB8\xBF\xFB\xFB\xBF\xBA\xB6\xB8\xB8\xB9\xBF\xFB\x20\xBF\xBB\xBA\xBC\xBF\xFB\xFB\x20"
    "\x20\xBF\xBD\xBC\xBD\xBF\xFB\xFB\x20\x20\xBF\xBF\xBF\xFB\xFB\x20\x20\x20\x20\xBF\xBF\xBF\xFB"
    "\xFB\x20\x20\x20\x20\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 56 = 'x'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF"
    "\xB2\xB1\xB2\xB2\xB2\xBF\x20\x20\xBF\xB2\xB4\xB4\xB4\xB9\xBF\xFB\x20\xBF\xB8\xB6\xB6\xB5\xB1"
    "\xBF\xBF\xB6\xBB\xBB\xBA\xBA\xBF\xFB\xFB\x20\x20\xBF\xB8\xB3\xB4\xB3\xB1\xB1\xB7\xBB\xBB\xBB"
    "\xBF\xFB\xFB\x20\x20\x20\x20\xBF\xB8\xB5\xB3\xB5\xB8\xBB\xBB\xBC\xBF\xFB\xFB\x20\x20\x20\x20"
    "\x20\x20\xBF\xB8\xB3\xB5\xB6\xBC\xBC\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\xBF\xB3\xB3\xB4"
    "\xB7\xBC\xBB\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\xBF\xB1\xB2\xB4\xB3\xB6\xBB\xBB\xB6\xBF\x20"
    "\x20\x20\x20\x20\x20\xBF\xB2\xB3\xB1\xB4\xBA\xBA\xBB\xBB\xBA\xB4\xBF\x20\x20\x20\x20\xBF\xB2"
    "\xB3\xB3\xB1\xB8\xBF\xBF\xBA\xB8\xB8\xB8\xB2\xBF\x20\x20\xBF\xB8\xB8\xB8\xB7\xB6\xBF\xFB\xFB"
    "\xBF\xBA\xBA\xBA\xB8\xB5\xBF\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\x20\x20\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\x20\xC8\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 57 = 'y'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\x20\xBF"
    "\xB4\xB4\xB1\xB1\xBF\x20\x20\x20\x20\xBF\xB2\xB2\xB1\xB2\xBF\xFB\xBF\xBB\xB9\xB5\xB2\xB3\xBF"
    "\x20\x20\xBF\xB2\xB5\xB4\xB5\xB9\xBF\xFB\x20\xBF\xBA\xB7\xB4\xB3\xB3\xBF\xBF\xB3\xB5\xB6\xB5"
    "\xB9\xBF\xFB\xFB\x20\x20\xBF\xBA\xB6\xB2\xB5\xB1\xB1\xB5\xB4\xB6\xB9\xBF\xFB\xFB\x20\x20\x20"
    "\x20\xBF\xBA\xB2\xB7\xB6\xB6\xB6\xB6\xB9\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20\xBF\xB8\xB7\xB6"
    "\xB6\xB5\xB8\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB9\xB6\xB6\xB7\xBF\xFB\xFB\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBA\xB6\xB5\xB6\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\xBF\xBB\xB8\xB5\xB6\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBB\xBA\xB9"
    "\xB9\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20",

    // 58 = 'z'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF"
    "\xB5\xB1\xB1\xB1\xB2\xB1\xB1\xB1\xB1\xB2\xB1\xB2\xB2\xB7\xBF\xFB\xBF\xB9\xB8\xB7\xB8\xB9\xB8"
    "\xB6\xB1\xB5\xB5\xB4\xB4\xB6\xB8\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xB3\xB5\xB5\xB4\xB4"
    "\xB4\xB6\xBF\xFB\x20\xFB\xFB\xFB\xFB\xBF\xBF\xB4\xB2\xB5\xB5\xB4\xB3\xBA\xBF\xBF\xFB\x20\x20"
    "\x20\xBF\xBF\xB4\xB1\xB4\xB5\xB6\xB7\xBA\xBF\xBF\xFB\xFB\xFB\x20\xBF\xBF\xB4\xB2\xB3\xB2\xB4"
    "\xB3\xBA\xBF\xBF\xFB\xFB\xFB\x20\x20\xBF\xB7\xB1\xB4\xB4\xB4\xB2\xBA\xBF\xBF\xFB\xFB\xFB\x20"
    "\x20\x20\x20\xBF\xB6\xB3\xB3\xB5\xB3\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB6\xB2"
    "\xB2\xB3\xB5\xB2\xB1\xB1\xB1\xB2\xB1\xB1\xB1\xB5\xBF\xFB\xBF\xB9\xB9\xB7\xB8\xB8\xB8\xB7\xB6"
    "\xB8\xB9\xB8\xB7\xB9\xBC\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\x20\xC8\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20"
};

const char *nmare =
    "\x20\x20\xBF\xBF\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xB2\xB2\xBF\x20\x20\x20\x20\x20\xBF\xB2\xAF\xB1"
    "\xB2\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB2\xAF\xB2\xB2\xBF\xFB\xBF\xB5\xB1\xB1\xB2"
    "\xBF\x20\x20\x20\x20\xBF\xB3\xB1\xB3\xB6\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB3\xB1"
    "\xB4\xB4\xBF\xFB\xBF\xB3\xB4\xB3\xB2\xB5\xBF\x20\x20\x20\xBF\xB3\xB1\xB6\xB7\xBF\xBF\xBF\xBF"
    "\xBF\xBF\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20"
    "\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xBF\xBF"
    "\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF"
    "\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xB3\xB1\xB4\xB6\xBF\xFB\xBF\xB4\xB4\xB3\xB3\xB7\xB5\xBF\x20\x20"
    "\xBF\xB5\xB2\xB4\xB6\xBF\xB6\xB4\xB4\xB7\xBF\xFB\xBF\xBF\xBA\xB9\xB4\xB4\xAF\xB1\xB1\xB3\xB3"
    "\xB5\xB9\xBF\xB7\xB1\xB5\xB7\xBF\xFB\x20\x20\xBF\xB7\xB3\xB4\xB6\xBF\xB7\xB3\xB2\xB1\xB1\xB2"
    "\xB3\xB3\xB3\xB5\xBF\xBF\xB5\xB2\xB6\xBF\x20\x20\x20\x20\xBF\xAF\xB2\xB3\xBF\x20\x20\x20\x20"
    "\x20\xBF\xBF\xB7\xB6\xB3\xB3\xB4\xBA\xBF\xBF\xB7\xB2\xB3\xB2\xB2\xB3\xB2\xB2\xB3\xB3\xB3\xBA"
    "\xBF\x20\x20\xBF\xBF\xB5\xB5\xB6\xB4\xB1\xB5\xB5\xB4\xB7\xBF\xBF\xB5\xB2\xB3\xB4\xBF\xFB\xBF"
    "\xB6\xB4\xB3\xB5\xB8\xB8\xB5\xBF\x20\xBF\xB5\xB2\xB4\xB6\xBF\xB4\xB9\xB9\xB4\xBF\xBF\xBB\xB9"
    "\xBA\xBA\xB9\xB7\xB1\xB8\xB9\xB6\xB4\xB9\xBA\xBF\xBA\xB2\xB8\xB6\xBF\xFB\x20\x20\xBF\xB4\xB7"
    "\xB2\xBA\xBF\xBA\xB1\xB6\xB1\xB1\xB4\xB6\xB9\xBA\xBA\xBF\xB8\xB3\xB2\xB6\xB6\xBF\x20\x20\xBF"
    "\xB6\xB1\xB5\xB6\xB9\xBF\x20\x20\x20\xBF\xBA\xB8\xB9\xB8\xB3\xBA\xB6\xB7\xBB\xBF\xBA\xB8\xB4"
    "\xB1\xB4\xB9\xB7\xB4\xB7\xB2\xB5\xB3\xBA\xBF\xBF\xBB\xB7\xB4\xB3\xBA\xBA\xB2\xBA\xB3\xB9\xBA"
    "\xBF\xBF\xB5\xB2\xB2\xB4\xBF\xFB\xBF\xB3\xB3\xB5\xB6\xB9\xB7\xB7\xB5\xBF\xBF\xB6\xB2\xB5\xB6"
    "\xBF\xB4\xB8\xB7\xB4\xBF\xBF\xB7\xB7\xBA\xBB\xBF\xBB\xB3\xBA\xBF\xBF\xBF\xBF\xBF\xBF\xBA\xB3"
    "\xB8\xB6\xBF\xFB\x20\x20\xBF\xB4\xBA\xAF\xB9\xBF\xBA\xB5\xBF\xB1\xB3\xB4\xB7\xBF\xBF\xBF\xBF"
    "\xB7\xB4\xB4\xB6\xBA\xB3\xBF\xBF\xB5\xB9\xB5\xB6\xB8\xBA\xBF\xFB\x20\xBF\xBA\xB8\xB6\xBA\xBF"
    "\xBF\xB9\xB6\xB7\xBA\xBF\xBF\xBF\xB9\xB2\xB9\xBF\xBC\xB6\xBF\xB6\xB5\xB4\xB6\xBF\xBF\xB9\xB6"
    "\xB2\xB9\xBC\xBA\xB5\xBA\xB6\xBC\x2D\xBF\xBF\xB7\xB2\xB3\xB7\xBF\xFB\xBF\xB1\xB2\xB6\xB7\xB8"
    "\xB7\xB8\xB7\xB5\xBF\xB6\xB2\xB6\xB8\xBF\xB2\xB7\xB6\xB2\xBF\xBA\xB7\xB7\xB9\xBF\xFB\xBF\xB8"
    "\xBF\xFB\xFB\xFB\xFB\xFB\xBF\xBA\xB5\xB8\xB9\xBF\xBF\xBF\xBF\xBF\xB2\xB5\xB1\xB9\xBF\xBA\xB8"
    "\xBF\xB4\xB4\xB6\xB6\xBF\xFB\xFB\xBF\xB8\xB4\xB6\xB6\xBA\xAF\xB5\xB5\xB6\xB7\xB9\xB6\xB6\xBA"
    "\xBF\xFB\x20\xBF\xB8\xB6\xB2\xBF\xBF\xBF\xB9\xB6\xB8\xB9\xBF\xBF\xBF\xBF\xB4\xB9\xBF\xBC\xB9"
    "\xBF\xB9\xB4\xB6\xB8\xBF\xBA\xB6\xB4\xAF\xB9\xBF\xBF\xB9\xBF\xB9\xBF\xBF\xBF\xBF\xB8\xB4\xB6"
    "\xB9\xBF\xFB\xBF\xB6\xB5\xB4\xB9\xBA\xBA\xB9\xB9\xB8\xB9\xBA\xB1\xB8\xBA\xBF\xB1\xB5\xB6\xAF"
    "\xBF\xBA\xB9\xB7\xB9\xBF\xFB\x20\xBB\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBA\xB4\xB9\xB7\xB6\xB1\xB3"
    "\xB3\xB4\xAF\xB5\xB5\xB8\xBF\xBF\xB9\x2D\xB6\xB2\xB6\xB9\xBF\xFB\x20\xBF\xB6\xB4\xB6\xB4\xBB"
    "\xB1\xB9\xB9\xB6\xB7\xB9\xB6\xBA\xBB\xBF\xFB\xBF\xBA\xB6\xB6\xB5\xBA\xB2\xB5\xB8\xB4\xB8\xBA"
    "\xBF\xB8\xAF\xB1\xB2\xB2\xAF\xB2\xB4\xB3\xB4\xB2\xB6\xBF\xBF\xB9\xB5\xB6\xB1\xB6\xB5\xB5\xB5"
    "\xB1\xB3\xB9\xB9\xBF\xBF\xBF\xB9\xB9\xBF\xBF\xFB\xBF\xB6\xB5\xB6\xBA\xBF\xBC\xBB\xBA\xB5\xB6"
    "\xBA\xB5\xB9\xBB\xBF\xB1\xB4\xB6\xB1\xBF\xBA\xB9\xB6\xBA\xBF\xFB\x20\x20\xFB\xBF\xB6\xBA\xB5"
    "\xB9\xBF\xBA\xB2\xBA\xB8\xBA\xB6\xBA\xB4\xB9\xB1\xB3\xB6\xB8\xBF\xFB\x2D\xBF\xB4\xAF\xB6\xB9"
    "\xBF\xFB\x20\xBF\xB4\xB4\xB6\xB2\xBB\xB9\xBA\xB9\xB6\xB8\xB4\xB6\xBA\xB6\xBF\xFB\xBF\xB9\xB5"
    "\xB6\xBA\xBF\xB3\xB6\xBA\xB2\xB7\xBA\xBF\xB9\xB2\xB9\xB5\xB9\xBA\xB2\xBA\xB9\xB4\xAF\xB4\xBF"
    "\xBF\xBA\xB5\xB6\xAF\xB6\xBA\xB4\xB9\xB2\xB9\xBA\xBB\xBF\xFB\xBF\xBF\xBF\xBF\xFB\xFB\xBF\xB6"
    "\xB7\xB9\xB9\xBF\xBF\xBC\xBB\xB3\xBA\xBA\xB4\xB9\xBB\xBF\xB5\xB2\xB5\xB5\xBF\xBA\xB6\xB4\xB9"
    "\xBF\xFB\x20\x20\x20\xBF\xB9\xBB\xB6\xBA\xBF\xBA\xB6\xB6\xB9\xBC\xB9\xBB\xB4\xBC\xB5\xB3\xB9"
    "\xB8\xBF\xFB\x20\xBF\xB2\xB2\xB5\xB6\xBF\xFB\x20\xBF\xB2\xB5\xB6\xB2\xBF\xBB\xBA\xB6\xBA\xBF"
    "\xB9\xB5\xBA\xB9\xBF\xBF\xBA\xB6\xB5\xBA\xBF\xBF\xB6\xBA\xBA\xAF\xB6\xBA\xBF\xB4\xB4\xB9\xB3"
    "\xBF\xBF\xBA\xBF\xBA\xB3\xB4\xB2\xB9\xBF\xBA\xB6\xB5\xB2\xBA\xBF\xBA\xBB\xB4\xBA\xBF\xBF\xBF"
    "\xBF\xBA\xB5\xB5\xBA\xBF\x20\xBF\xB4\xB8\xB7\xB8\xBF\xFB\xBF\xBC\xBA\xB5\xB7\xB4\xB9\xBB\xBF"
    "\xB7\xB1\xB5\xBA\xBF\xBB\xB4\xB4\xB8\xBB\xBF\xBF\xBF\xBF\xBF\xB7\xBB\xB4\xBA\xBF\xB7\xB6\xB4"
    "\xB9\xBF\xBF\xBF\xB9\xBF\xBA\xAF\xB6\xB9\xBF\xFB\x20\xBF\xB2\xB7\xB7\xB4\xBF\xFB\x20\xBF\xB5"
    "\xB2\xB6\xB4\xBF\xBF\xBB\xBA\xBF\xBF\xB9\xB2\xBA\xB6\xBF\xBF\xB9\xB4\xB5\xBF\xFB\xBF\xBB\xBF"
    "\xBB\xB4\xB4\xBB\xBF\xB7\xB1\xB9\xB4\xBF\xFB\xFB\xFB\xBF\xB4\xB4\xB1\xB9\xBF\xBF\xB9\xB6\xB4"
    "\xBA\xBF\xBF\xBF\xB9\xBF\xBF\xBF\xBF\xBF\xB5\xB2\xB9\xB5\xBF\xFB\xBF\xB4\xB8\xB4\xB9\xBF\xFB"
    "\x20\xBF\xBC\xB4\xB9\xB1\xB9\xBB\xBF\xB4\xB1\xB6\xBB\xBF\xBF\xB9\xB6\xB7\xBC\xB9\xB5\xB2\xB4"
    "\xBB\xBA\xBB\xB4\xBA\xBF\xB4\xB9\xB4\xB9\xBF\xBF\xFB\xFB\xFB\xBA\xB4\xB2\xB9\xBF\xFB\x20\xBF"
    "\xBB\xB4\xB9\xB2\xBF\xFB\x20\xBF\xB6\xB2\xB4\xB4\xBF\xFB\xBF\xBF\xFB\xBF\xB9\xB2\xB9\xB4\xBF"
    "\xB9\xB6\xB5\xBB\xBF\xFB\x20\xBF\xBF\xBB\xB2\xB4\xBB\xBF\xB6\xB6\xBB\xB4\xBF\xFB\x20\x20\xBF"
    "\xB4\xB4\xB1\xB7\xBF\xFB\xBF\xB9\xB4\xB9\xB4\xB4\xB4\xB3\xB5\xB7\xBC\xBF\xBF\xBF\xBA\xBF\xBF"
    "\xBF\xFB\xBF\xB7\xB9\xB4\xB9\xBF\xFB\x20\x20\xBF\xBC\xB9\xB5\xBA\xBD\xBF\xB4\xB6\xB7\xBB\xBF"
    "\xFB\xBF\xB9\xB8\x2D\xBB\xBB\xB2\xB7\xBB\xBB\xBC\xB7\xBB\xBF\xB4\xBA\xB7\xB9\xBF\xFB\xFB\x20"
    "\x20\xBA\xB4\xB2\xBB\xBF\xFB\x20\xBF\xBA\xB4\xB9\xBA\xBF\xFB\x20\xBF\xB9\xB1\xB9\xB2\xBF\xFB"
    "\x20\xFB\xFB\xBF\xBB\xB7\xBB\xB5\xBF\xB9\xB5\xBB\xBF\xFB\xFB\x20\x20\xBF\xBB\xB2\xB7\xBB\xBF"
    "\xB5\xB4\xBC\xB4\xBF\xFB\x20\x20\xBF\xB9\xB5\xB2\xBA\xBF\xFB\x20\xBF\xB6\xBB\xB8\xB5\xB8\xBA"
    "\xB8\xBB\xBC\xBF\xBF\xB4\xBF\xBA\xB4\xBF\xFB\xBF\xB9\xBA\xB7\xB9\xBF\xFB\x20\x20\x20\xBF\x2D"
    "\xBA\xBC\x2D\xBF\xB4\xBB\xB5\xBF\xFB\xFB\xBF\xBA\xBA\xBB\xBF\xBF\xBF\xBF\xBB\xB7\x2D\xB4\xBF"
    "\xBF\xB5\xBF\xB5\xBB\xBF\xFB\x20\x20\x20\xBA\xB7\xBA\xBF\xFB\xFB\x20\xBF\xBB\xB2\xBB\xBB\xBF"
    "\xFB\x20\xBF\xBB\xB7\xBA\xB6\xBF\xFB\x20\x20\x20\x20\xBF\xB4\xBF\xBB\xBF\xBF\xB5\xBF\xFB\xFB"
    "\x20\x20\x20\xBF\xBB\xB7\xB4\xBF\xBF\xBA\xB5\xBF\xB7\xBF\xFB\x20\x20\x20\xBF\xB7\xB3\xBF\xFB"
    "\xFB\x20\xBF\xB9\xBB\xBF\xB7\xBF\xBF\xB7\xBB\xBF\xFB\xFB\xBF\xB6\xB8\xBF\xFB\xFB\xBF\xB9\xBB"
    "\xB9\x26\xFB\xFB\x20\x20\x20\xBF\x2D\xBB\xBD\xBF\xBF\xB5\xBF\xBA\xBF\xFB\x20\x20\xBF\xBC\xBF"
    "\xFB\xFB\xFB\xFB\xBF\xB5\xBF\xBB\xBF\xBF\xB4\xBF\xBB\xBF\xFB\xFB\x20\x20\x20\xBF\xBA\xBF\xFB"
    "\xFB\x20\x20\x20\x2D\xB5\x2D\xBF\xFB\xFB\x20\x20\xBF\xB5\xBB\xBF\xFB\xFB\x20\x20\x20\x20\xBF"
    "\xB5\xBF\xBF\xFB\xBF\xBB\xBF\xFB\x20\x20\x20\x20\xBF\xBB\xB4\xBB\xBF\xFB\xBF\xBB\xBF\xBA\xBF"
    "\xFB\x20\x20\x20\x20\xBF\xB3\xBF\xFB\x20\x20\xBF\xBA\xBF\xFB\xBB\xBF\xBF\xBB\xBF\xFB\xFB\x20"
    "\xBF\xBF\xBF\xBF\xFB\x20\xBF\xBB\x29\xBB\xBF\xFB\x20\x20\x20\x20\x20\xBF\x2D\xBF\xFB\xBF\xBB"
    "\xBF\xBF\xFB\xFB\x20\x20\xBF\xBB\xBF\xFB\x20\x20\x20\xBF\xB5\xBF\xBF\xFB\xBF\xBB\xBF\xBF\xFB"
    "\xFB\x20\x20\x20\x20\x20\xBF\xFB\xFB\x20\x20\x20\x20\x20\xBF\xFB\xFB\xFB\x20\x20\x20\xBF\xB5"
    "\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20\xBF\xFB\xFB\xFB\x20\xBF\xFB\xFB\x20\x20\x20\x20\x20\xBF"
    "\xBB\xBF\xFB\xFB\x20\xBF\xFB\xBB\xBF\xFB\x20\x20\x20\x20\xBF\xB8\xBF\xFB\x20\x20\x20\xBF\xFB"
    "\xFB\xBF\xFB\xFB\xBF\xFB\xFB\x20\x20\x20\xFB\xFB\xFB\xFB\x20\x20\xBF\xFB\xBF\xBF\xFB\x20\x20"
    "\x20\x20\x20\x20\xBF\xFB\xFB\x20\xBF\xFB\xFB\xFB\x20\x20\x20\x20\xBF\xFB\xFB\x20\x20\x20\x20"
    "\xBF\xFB\xFB\xFB\x20\xBF\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\xFB\x20\x20\x20\x20\x20\x20"
    "\x20\xFB\x20\x20\x20\x20\x20\x20\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\xFB\x20\x20\x20"
    "\x20\xFB\x20\x20\x20\x20\x20\x20\x20\xBF\xFB\xFB\x20\x20\x20\xFB\xBF\xFB\xFB\x20\x20\x20\x20"
    "\x20\xBF\xFB\xFB\x20\x20\x20\x20\xFB\x20\x20\xFB\x20\x20\xFB\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\xFB\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\xFB\x20\x20\x20\xFB\x20\x20\x20\x20"
    "\x20\x20\x20\xFB\x20\x20\x20\x20\x20\x20\xFB\x20\x20\x20\x20\xFB\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xFB\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xFB\x20\x20\x20"
    "\x20\x20\x20\xFB\x20\x20\x20\x20\x20\x20\x20\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xFB\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20";

const char *lsleft =
    "\x9F\x0A\x0A\x0A\x0A\x09\x0A\x09\x0A\x0B\x7E\x0B\x7E\x7E\x7E\x7E\x0A\x7E\xEF\xEF\xEF\xEF\xEF"
    "\xEF\x0A\x0B\xEE\x97\x97\x97\x4D\x97\x0A\x7E\xEE\x97\x4C\x97\x4E\x97\x09\x7E\xEE\x4C\x97\x97"
    "\x4D\x4D\x0A\x7E\xEE\x4D\x97\x4D\x4D\x4D\x09\x7E\xEE\x97\x97\x4D\x4E\x4D\x09\x7E\xEE\x4D\x4E"
    "\x4D\x97\x97\x09\x0B\xEE\x97\x4D\x97\x4D\x4D\x0A\x7E\xEE\x97\x97\x4E\x97\x4E\x09\x7E\xEE\x97"
    "\x97\x97\x4D\x4E\x0A\x7E\x0A\x9F\x09\x09\x9F\x9F\x09\x0A\x0A\x0A\x0A\x09\x0A\x09\x0A\x0B\x7E"
    "\x0B\x7E\x7E\x7E\x7E\x00\xFB\xFB\xFB\xFB\xFB\xFB\xFB";

const char *lscntr =
    "\x09\x0A\x09\x0A\x0A\x09\x0A\x09\x0B\x7E\x7E\x0B\x7E\x7E\x7E\x7E\xEF\xEF\xEF\xEF\xEF\xEF\xEF"
    "\xEF\x97\x4D\x4E\x4D\x97\x4D\x4E\x4D\x97\x4D\x97\x4D\x4D\x4E\x4D\x4E\x97\x4E\x4D\x4E\x4D\x4D"
    "\x4D\x4D\x4D\x4D\x4E\x4D\x97\x4D\x97\x4D\x4D\x4D\x4E\x4D\x4D\x4D\x4D\x4D\x97\x4E\x4D\x4D\x97"
    "\x4D\x4E\x4D\x4D\x4D\x4D\x4D\x4E\x4D\x4E\x97\x4E\x4D\x4E\x4D\x4D\x97\x4D\x97\x4D\x4E\x4D\x97"
    "\x4D\x4E\x4D\x97\x09\x9F\x09\x9F\x09\x09\x9F\x9F\x09\x0A\x09\x0A\x0A\x09\x0A\x09\x0B\x7E\x7E"
    "\x0B\x7E\x7E\x7E\x7E\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB";

const char *lsrght =
    "\x09\x0A\x09\x0A\x09\x0A\x0A\x9F\x00\x0B\x7E\x7E\x7E\x7E\x7E\x0B\x0A\xFB\xEF\xEF\xEF\xEF\xEF"
    "\xEF\x7E\x0A\xFB\x4E\x4D\x97\x97\x97\xEE\x0B\x0A\xFB\x4E\x97\x4E\x97\x97\xEE\x7E\x0A\xFB\x4D"
    "\x4D\x97\x4D\x97\xEE\x7E\x09\xFB\x97\x97\x4C\x4C\x97\xEE\x7E\x0A\xFB\x4C\x4C\x97\x4D\x97\xEE"
    "\x7E\x09\xFB\x97\x4D\x97\x4C\x4C\xEE\x7E\x09\xFB\x4D\x4D\x97\x97\x4C\xEE\x0B\x09\xFB\x97\x4E"
    "\x97\x4C\x97\xEE\x7E\x0A\xFB\x97\x4D\x97\x97\x97\xEE\x7E\x09\xFB\x09\x9F\x09\x9F\x09\x09\x7E"
    "\x0A\xFB\x09\x0A\x09\x0A\x09\x0A\x0A\x09\xFB\x0B\x7E\x7E\x7E\x7E\x7E\x0B\x0A\xFB\xFB\xFB\xFB"
    "\xFB\xFB\xFB\xFB\xFB\xFB";

const char *smallcharset[] =
{
    // 0 = '!'
    "\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\xBF\xB1\xB1\xBF\xFB\xBF\xB5\xB2\xBF\xFB\xBF\xB5\xB1"
    "\xBF\xFB\xBF\xBF\xBF\xBF\xFB\xBF\xB5\xB3\xBF\xFB\xBF\xBF\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\x20"
    "\x20\x20\x20\x20",

    // 1 = '”'
    "\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB5\xB3\xBF\xB5\xB3\xBF"
    "\xFB\xBF\xBF\xB6\xBF\xBF\xB6\xBF\xFB\x20\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\xFB\xFB\xFB\xFB"
    "\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 2 = '#'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xBF\xB5\xBF\xB4\xBF\xBF"
    "\x20\xBF\xB4\xB1\xB1\xB1\xB4\xBF\xFB\xBF\xBF\xB1\xBF\xB1\xBF\xBF\xFB\xBF\xB5\xB1\xB1\xB1\xB4"
    "\xBF\xFB\xBF\xBF\xB4\xBF\xB4\xBF\xBF\xFB\x20\xBF\xBF\xBF\xBF\xBF\xFB\xFB\x20\x20\xFB\xFB\xFB"
    "\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 3 = '$'
    "\x20\x20\xBF\xBF\xBF\x20\x20\x20\x20\xBF\xBF\xB5\xBF\xBF\xBF\x20\xBF\xB9\xB5\xB2\xB5\xB9\xBF"
    "\xFB\xBF\xB5\xBF\xB2\xBF\xBF\xFB\xFB\xBF\xB9\xB5\xB2\xB5\xB9\xBF\x20\x20\xBF\xBF\xB9\xBF\xB5"
    "\xBF\xFB\xBF\xB9\xB5\xB2\xB5\xB9\xBF\xFB\xBF\xBF\xBF\xB5\xBF\xBF\xFB\xFB\x20\xFB\xBF\xBF\xBF"
    "\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB\x20\x20",

    // 4 = '%'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\x20\x20\xBF\xBF\xBF\x20\x20\xBF\xB1\xBF"
    "\xFB\xBF\xB2\xB3\xBF\xFB\x20\xBF\xBF\xBF\xBF\xB5\xB5\xB7\xBF\xFB\x20\x20\xFB\xBF\xB5\xB4\xB7"
    "\xBF\xFB\xFB\x20\x20\xBF\xB6\xB4\xB7\xBF\xBF\xBF\xBF\x20\x20\xBF\xB5\xB7\xBF\xFB\xBF\xB1\xBF"
    "\xFB\x20\xBF\xBF\xBF\xFB\xFB\xBF\xBF\xBF\xFB\x20\x20\xFB\xFB\xFB\x20\x20\xFB\xFB\xFB\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20",

    // 5 = '&'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\x20\x20\x20\xBF\xB8\xB5\xB6"
    "\xB9\xBF\x20\x20\x20\xBF\xB3\x2D\xB4\xBA\xBF\xFB\x20\xBF\xBB\xB5\xB5\xB6\xBF\xFB\xFB\x20\xBF"
    "\xB6\xB6\x2D\xB5\xB4\xBF\xBF\x20\xBF\xBB\xB7\xB6\xB4\xB4\xB4\xBF\xFB\x20\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xFB\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 6 = '’'
    "\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\xBF\xB5\xB3\xBF\xFB\xBF\xBF\xB3\xBF\xFB\x20\xBF\xBF"
    "\xBF\xFB\x20\x20\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20",

    // 7 = '('
    "\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\xBF\xBA\xB2\xB1\xBF\xFB\xBF\xB8\xB5\xBF\xBF"
    "\xFB\xBF\xB8\xB5\xBF\xFB\xFB\xBF\xB8\xB5\xBF\xBF\x20\xBF\xBA\xB8\xB3\xBF\xFB\x20\xBF\xBF\xBF"
    "\xBF\xFB\x20\x20\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20",

    // 8 = ')'
    "\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\x20\xBF\xB1\xB2\xBA\xBF\x20\xBF\xBF\xB5\xB8\xBF"
    "\xFB\x20\xBF\xB6\xB8\xBF\xFB\xBF\xBF\xB6\xB8\xBF\xFB\xBF\xB3\xB6\xBA\xBF\xFB\xBF\xBF\xBF\xBF"
    "\xFB\xFB\x20\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20",

    // 9 = '*'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\x20\x20\x20\x20\x20\x20\xBF\xB6\xBF\x20\x20"
    "\x20\x20\xBF\xB6\xB2\xB6\xBF\x20\x20\xBF\xB8\xB2\xB2\xB2\xB8\xBF\x20\x20\xBF\xB8\xB2\xB8\xBF"
    "\xFB\xFB\x20\x20\xBF\xB8\xBF\xFB\xFB\x20\x20\x20\x20\xBF\xFB\xFB\x20\x20\x20\x20\x20\x20\xFB"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 10 = '+'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\x20\x20\xBF\xBF\xB6\xBF\xBF"
    "\x20\xBF\xB6\xB6\xB6\xBF\xFB\xBF\xBF\xB6\xBF\xBF\xFB\x20\xBF\xBF\xBF\xFB\xFB\x20\x20\xFB\xFB"
    "\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 11 = ','
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\xBF\xBF\xBF\xBF\x20\xBF\xB5\xB3\xBF\xFB\xBF\xBF\xB3\xBF\xFB\x20\xBF\xBF\xBF\xFB\x20"
    "\x20\xFB\xFB\xFB",

    // 12 = '-'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF"
    "\x20\xBF\xB1\xB1\xB1\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 13 = '.'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\xBF\xBF\xBF\xBF\x20\xBF\xB5\xB3\xBF\xFB\xBF\xBF\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\x20"
    "\x20\x20\x20\x20",

    // 14 = '/'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\x20\x20\x20\x20\xBF\xB5\xB6\xBF"
    "\xFB\x20\x20\xBF\xB5\xB6\xB9\xBF\xFB\x20\xBF\xB5\xB6\xB9\xBF\xFB\xFB\xBF\xB4\xB6\xB9\xBF\xFB"
    "\xFB\x20\xBF\xB8\xBA\xBF\xFB\xFB\x20\x20\xBF\xBF\xBF\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 15 = '0'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xBF\xB8\xB5\xB5"
    "\xB8\xBF\xBF\x20\xBF\xB8\xB3\xB9\xB9\xB4\xB8\xBF\xFB\xBF\xB8\xB5\xBF\xBF\xB2\xB6\xBF\xFB\xBF"
    "\xB8\xB4\xB9\xB9\xB4\xB8\xBF\xFB\xBF\xBF\xB8\xB5\xB5\xB8\xBF\xBF\xFB\x20\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\xFB\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 16 = '1'
    "\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\xBF\xBF\xB1\xB1\xBF\xFB\xBF\xB6\xB5\xB3\xBF"
    "\xFB\xBF\xBF\xB5\xB6\xBF\xFB\x20\xBF\xB5\xB5\xBF\xFB\x20\xBF\xB5\xB3\xBF\xFB\x20\xBF\xBF\xBF"
    "\xBF\xFB\x20\x20\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20",

    // 17 = '2'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xB5\xB4\xB5\xB2"
    "\xB3\xBC\xBF\x20\xBF\xBF\xBF\xBC\xB9\xB3\xB9\xBF\xFB\xBF\xBC\xB7\xB5\xB4\xB5\xBC\xBF\xFB\xBF"
    "\xB5\xB4\xBF\xBF\xBF\xBF\xFB\xFB\xBF\xB5\xB4\xB5\xB3\xB1\xB5\xBF\x20\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 18 = '3'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\xBF\xB8\xB3\xB3\xB4"
    "\xB9\xBF\x20\x20\x20\xBF\xBF\xBF\xB9\xB3\xB9\xBF\x20\x20\xBF\xB4\xB4\xB4\xB2\xB7\xBF\xFB\x20"
    "\xBF\xBF\xBF\xB9\xB5\xBA\xBF\xFB\xBF\xB7\xB4\xB2\xB5\xB7\xBF\xFB\xFB\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xFB\xFB\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 19 = '4'
    "\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB3\xB4\xBF\xB4\xB4\xBF"
    "\xFB\xBF\xB3\xB5\xBF\xB3\xB3\xBF\xFB\xBF\xB3\xB3\xB1\xB1\xB3\xBF\xFB\xBF\xBF\xBF\xBF\xB2\xB4"
    "\xBF\xFB\x20\xFB\xFB\xBF\xB3\xB4\xBF\xFB\x20\x20\x20\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\x20\xFB"
    "\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20",

    // 20 = '5'
    "\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB6\xB2\xB2\xB2\xB4\xBF"
    "\xFB\xBF\xB6\xB2\xBF\xBF\xBF\xFB\xFB\xBF\xB6\xB2\xB2\xB5\xB9\xBF\x20\xBF\xBF\xBC\xBC\xB4\xB2"
    "\xBF\xFB\xBF\xB8\xB1\xB3\xB5\xB9\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\x20\xFB\xFB\xFB\xFB"
    "\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 21 = '6'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xB7\xB4\xB2"
    "\xB2\xB9\xBF\xFB\xBF\xB7\xB4\xBB\xBF\xBF\xBF\xFB\xFB\xBF\xB7\xB2\xB4\xB2\xB2\xBB\xBF\x20\xBF"
    "\xB7\xB2\xBF\xBF\xB1\xB8\xBF\xFB\x20\xBF\xB7\xB7\xB2\xB2\xBB\xBF\xFB\x20\x20\xBF\xBF\xBF\xBF"
    "\xBF\xFB\xFB\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 22 = '7'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xB5\xB4\xB5\xB2"
    "\xB2\xB7\xBF\x20\xBF\xBF\xBF\xBF\xB9\xB6\xB5\xBF\xFB\x20\xFB\xFB\xFB\xBF\xB5\xB4\xBF\xFB\x20"
    "\x20\x20\x20\xBF\xB5\xB2\xBF\xFB\x20\x20\x20\x20\xBF\xB5\xB3\xBF\xFB\x20\x20\x20\x20\xBF\xBF"
    "\xBF\xBF\xFB\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 23 = '8'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xBA\xB7\xB3\xB4"
    "\xB5\xBA\xBF\x20\xBF\xBA\xB4\xBF\xBF\xB5\xBA\xBF\xFB\x20\xBF\xB4\xB6\xB6\xB4\xBF\xFB\xFB\xBF"
    "\xBA\xB4\xBF\xBF\xB4\xBA\xBF\x20\xBF\xBA\xB7\xB7\xB7\xB5\xBA\xBF\xFB\x20\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\xFB\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 24 = '9'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\xBF\xBB\xB4\xB0\xB3"
    "\xB7\xBF\x20\x20\xBF\xB6\xB1\xBF\xBF\xB5\xBA\xBF\x20\xBF\xBB\xB6\xB6\xB6\xB4\xB7\xBF\xFB\x20"
    "\xBF\xBF\xBF\xBB\xB4\xB7\xBF\xFB\xBF\xB9\xB2\xB2\xB4\xB7\xBF\xFB\xFB\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xFB\xFB\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 25 = ':'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\xBF\xB1\xB8\xBF\xFB\xBF\xBF\xBF"
    "\xBF\xFB\xBF\xBF\xBF\xBF\x20\xBF\xB2\xB8\xBF\xFB\xBF\xBF\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\x20"
    "\x20\x20\x20\x20",

    // 26 = ';'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\xBF\xB1\xB1\xBF\xFB\xBF\xBF\xBF"
    "\xBF\xFB\xBF\xBF\xBF\xBF\xFB\xBF\xB5\xB3\xBF\xFB\xBF\xBF\xB3\xBF\xFB\x20\xBF\xBF\xBF\xFB\x20"
    "\x20\xFB\xFB\xFB",

    // 27 = '<'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\x20\x20\x20\xBF\xB5\xBF\xFB\x20\xBF\xB5\xB4\xBF"
    "\xFB\xBF\xB5\xB5\xBF\xFB\xFB\x20\xBF\xB5\xB4\xBF\x20\x20\x20\xBF\xB5\xBF\xFB\x20\x20\x20\xBF"
    "\xBF\xFB\x20\x20\x20\x20\xFB\xFB\x20\x20\x20\x20\x20\x20",

    // 28 = '='
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB1\xB1\xB1\xBF"
    "\xFB\xBF\xBF\xBF\xBF\xBF\xFB\xBF\xB5\xB3\xB3\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xFB\x20\xFB\xFB\xFB"
    "\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 29 = '>'
    "\x20\x20\x20\x20\x20\x20\xBF\xBF\x20\x20\x20\x20\xBF\xB5\xBF\x20\x20\x20\xBF\xB4\xB5\xBF\x20"
    "\x20\x20\xBF\xB5\xB5\xBF\x20\xBF\xB4\xB5\xBF\xFB\xFB\xBF\xB5\xBF\xFB\xFB\x20\xBF\xBF\xFB\xFB"
    "\x20\x20\x20\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 30 = '?'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xB5\xB4\xB5\xB2"
    "\xB3\xB6\xBF\x20\xBF\xBF\xBF\xBF\xB6\xB3\xB9\xBF\xFB\xBF\xB5\xB5\xB5\xB5\xB5\xB9\xBF\xFB\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\xBF\xB5\xB4\xB5\xBF\xFB\xFB\xFB\x20\xBF\xBF\xBF\xBF\xBF\xFB"
    "\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 31 = '@'
    "\x20\x20\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\xBF\xB7\xB2\xB2\xB2\xB5\xBF\x20\x20\xBF\xB7\xBB"
    "\xBF\xBF\xBF\xBF\xB5\xBF\x20\xBF\xB2\xBF\xBB\xB7\xB2\xBF\xB2\xBF\xFB\xBF\xB2\xBF\xB2\xBF\xB2"
    "\xBF\xB6\xBF\xFB\xBF\xB2\xBF\xB2\xB2\xB2\xB6\xBB\xBF\xFB\xBF\xB7\xBB\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xFB\x20\xBF\xB7\xB2\xB2\xB2\xB5\xBF\xFB\xFB\x20\x20\xBF\xBF\xBF\xBF\xBF\xFB\xFB\x20\x20\x20"
    "\x20\xFB\xFB\xFB\xFB\xFB\x20\x20",

    // 32 = 'A'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\xBF\xB7\xB2\xB2"
    "\xB2\xB6\xBF\x20\xBF\xBA\xB4\xBF\xBF\xB6\xB3\xBF\xFB\xBF\xB4\xB7\xB5\xB5\xB4\xB3\xBF\xFB\xBF"
    "\xB4\xB7\xBF\xBF\xB4\xB3\xBF\xFB\xBF\xB4\xB7\xBF\xBF\xB4\xB3\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 33 = 'B'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xB6\xB3\xB1\xB2"
    "\xB1\xB9\xBF\x20\xBF\xBF\xBF\xBF\xBA\xB3\xB9\xBF\xFB\xBF\xB7\xB5\xB6\xB5\xB5\xBF\xFB\xFB\xBF"
    "\xB5\xB5\xBF\xBA\xB3\xB7\xBF\x20\xBF\xB5\xB4\xB2\xB2\xB4\xBB\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 34 = 'C'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xBA\xB3\xB1"
    "\xB1\xB4\xBF\xFB\xBF\xB9\xB3\xB3\xBF\xBF\xBF\xBF\xFB\xBF\xB8\xB5\xB5\xBF\xFB\xFB\xFB\xFB\xBF"
    "\xBA\xB3\xB3\xBF\xBF\xBF\xBF\x20\x20\xBF\xBA\xB5\xB1\xB1\xB6\xBF\xFB\x20\x20\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xFB\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 35 = 'D'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x2D\xB8\xB2\xB1\xB4"
    "\xB9\xBF\x20\x20\xBF\xBF\xBF\xBF\xBB\xB6\xB9\xBF\x20\xBF\xB5\xB5\xBF\xBF\xB4\xB6\xBF\xFB\xBF"
    "\xB4\xB2\xBF\xBB\xB4\xB9\xBF\xFB\xBF\xB4\xB2\xB1\xB3\xB9\xBF\xFB\xFB\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xFB\xFB\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 36 = 'E'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xB9\xB5\xB4"
    "\xB3\xB8\xBF\xFB\xBF\xB9\xB3\xB3\xB9\xBF\xBF\xBF\xFB\xBF\xB7\xB2\xB3\xB4\xB5\xB9\xBF\xFB\xBF"
    "\xBA\xB5\xB3\xB9\xBF\xBF\xBF\xFB\x20\xBF\xB7\xB3\xB5\xB4\xB7\xBF\xFB\x20\x20\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xFB\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 37 = 'F'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB5\xB4\xB1\xB1"
    "\xB1\xB1\xBF\xFB\xBF\xB5\xB5\xB9\xBF\xBF\xBF\xBF\xFB\xBF\xB5\xB5\xB5\xB5\xB5\xBF\xFB\xFB\xBF"
    "\xB5\xB6\xBF\xBF\xBF\xBF\xFB\x20\xBF\xB5\xB7\xBF\xFB\xFB\xFB\xFB\x20\xBF\xBF\xBF\xBF\xFB\x20"
    "\x20\x20\x20\x20\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 38 = 'G'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xB7\xB4\xB2"
    "\xB2\xB2\xBF\xFB\xBF\xB7\xB4\xB8\xBF\xBF\xBF\xBF\xFB\xBF\xB7\xB4\xBB\xBF\xB4\xB4\xBF\xFB\xBF"
    "\xBA\xB5\xB8\xBF\xB8\xB2\xBF\xFB\x20\xBF\xB7\xB7\xB2\xB5\xB2\xBF\xFB\x20\x20\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xFB\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 39 = 'H'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB4\xB7\xBF\xBF"
    "\xB7\xB2\xBF\xFB\xBF\xB4\xB7\xBF\xBF\xB5\xB4\xBF\xFB\xBF\xB4\xB4\xB5\xB5\xB5\xB2\xBF\xFB\xBF"
    "\xB4\xB7\xBF\xBF\xB7\xB2\xBF\xFB\xBF\xB4\xB7\xBF\xBF\xB8\xB3\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 40 = 'I'
    "\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\xBF\xB7\xB1\xBF\xFB\xBF\xB7\xB2\xBF\xFB\xBF\xB7\xB3"
    "\xBF\xFB\xBF\xB7\xB2\xBF\xFB\xBF\xB7\xB3\xBF\xFB\xBF\xBF\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\x20"
    "\x20\x20\x20\x20",

    // 41 = 'J'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\xBF"
    "\xB2\xB8\xBF\xFB\x20\x20\x20\x20\xBF\xB5\xB8\xBF\xFB\x20\x20\x20\x20\xBF\xB6\xB8\xBF\xFB\xBF"
    "\xBF\xBF\xBF\xB9\xB6\xB8\xBF\xFB\xBF\xB6\xB3\xB3\xB3\xB6\xBA\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 42 = 'K'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\xBF\xBF\xBF\x20\xBF\xB7\xB1\xBF\xBF"
    "\xB1\xB6\xBF\xFB\xBF\xB7\xB4\xBF\xB2\xB8\xBF\xFB\xFB\xBF\xB7\xB2\xB4\xB4\xBF\xFB\xFB\x20\xBF"
    "\xB7\xB2\xBF\xB8\xB3\xBF\x20\x20\xBF\xB7\xB3\xBF\xBF\xB8\xB3\xBF\x20\xBF\xBF\xBF\xBF\xFB\xBF"
    "\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\x20\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 43 = 'L'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\xBF\xB4\xB2\xBF\xFB"
    "\x20\x20\x20\x20\xBF\xB8\xB5\xBF\xFB\x20\x20\x20\x20\xBF\xB8\xB5\xBF\xFB\x20\x20\x20\x20\xBF"
    "\xB8\xB5\xB9\xBF\xBF\xBF\xBF\x20\xBF\xBA\xB8\xB3\xB3\xB3\xB3\xBF\xFB\x20\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xFB\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 44 = 'M'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\x20\x20\x20\xBF\xBF\x20\x20\xBF\xB9\xB4"
    "\xBF\x20\xBF\xB3\xB9\xBF\x20\xBF\xB7\xB4\xB7\xBF\xB9\xB5\xB3\xBF\xFB\xBF\xB5\xB6\xB7\xB4\xB7"
    "\xB5\xB7\xBF\xFB\xBF\xB6\xB8\xBF\xB6\xBF\xB5\xB7\xBF\xFB\xBF\xB5\xB7\xBF\xBF\xBF\xB5\xB7\xBF"
    "\xFB\xBF\xBF\xBF\xBF\xFB\xBF\xBF\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\x20\xFB\xFB\xFB\xFB\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20",

    // 45 = 'N'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xBA\xB4\xBB\xBF"
    "\xB4\xB3\xBF\xFB\xBF\xB5\xB5\xB8\xBF\xB6\xB3\xBF\xFB\xBF\xB5\xB4\xB7\xB7\xB3\xB3\xBF\xFB\xBF"
    "\xB5\xB7\xBB\xB4\xB2\xB5\xBF\xFB\xBF\xB5\xB8\xBF\xBA\xB2\xBB\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 46 = 'O'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xBF\xB8\xB5\xB5"
    "\xB8\xBF\xBF\x20\xBF\xB8\xB3\xB9\xB9\xB4\xB8\xBF\xFB\xBF\xB8\xB5\xBF\xBF\xB2\xB6\xBF\xFB\xBF"
    "\xB8\xB4\xB9\xB9\xB4\xB8\xBF\xFB\xBF\xBF\xB8\xB5\xB5\xB8\xBF\xBF\xFB\x20\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xFB\xFB\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 47 = 'P'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xB7\xB2\xB1\xB1"
    "\xB1\xBA\xBF\x20\xBF\xBF\xBF\xBF\xBD\xB5\xB5\xBF\xFB\xBF\xB1\xB1\xB1\xB3\xB3\xBA\xBF\xFB\xBF"
    "\xB1\xB1\xBF\xBF\xBF\xBF\xFB\xFB\xBF\xB5\xB5\xBF\xFB\xFB\xFB\xFB\x20\xBF\xBF\xBF\xBF\xFB\x20"
    "\x20\x20\x20\x20\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 48 = 'Q'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\x20\x20\x20\xBF\xB6\xB5\xB5"
    "\xB6\xBF\x20\x20\xBF\xB6\xB3\xB9\xB9\xB5\xB6\xBF\x20\xBF\xB6\xB5\xBF\xBF\xB5\xB6\xBF\xFB\xBF"
    "\xBA\xB3\xB9\xB9\xB7\xBA\xBF\xFB\x20\xBF\xBA\xB5\xB5\xB7\xBF\xFB\xFB\x20\x20\xBF\xBF\xBF\xB7"
    "\xB7\xBF\x20\x20\x20\x20\xFB\xFB\xBF\xBF\xBF\xFB\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB",

    // 49 = 'R'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\xBF\xB7\xB2\xB1\xB1"
    "\xB1\xBA\xBF\x20\xBF\xBF\xBF\xBF\xBA\xB5\xB8\xBF\xFB\xBF\xB3\xB1\xB1\xB1\xB3\xBF\xFB\xFB\xBF"
    "\xB5\xB1\xBF\xB8\xB5\xBA\xBF\x20\xBF\xB5\xB5\xBF\xBF\xB5\xB8\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 50 = 'S'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB9\xB6\xB2\xB4\xB9\xBF"
    "\xFB\xBF\xB6\xB6\xBF\xBF\xBF\xBF\xFB\xBF\xB9\xB5\xB6\xB8\xB9\xBF\xFB\xBF\xBF\xBF\xBF\xB4\xB6"
    "\xBF\xFB\xBF\xB8\xB1\xB3\xB6\xB9\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\x20\xFB\xFB\xFB\xFB"
    "\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 51 = 'T'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB0\xB0\xB1\xB1"
    "\xB4\xB4\xBF\xFB\xBF\xBF\xBF\xB5\xB2\xBF\xBF\xBF\xFB\x20\xFB\xBF\xB5\xB3\xBF\xFB\xFB\xFB\x20"
    "\x20\xBF\xB5\xB2\xBF\xFB\x20\x20\x20\x20\xBF\xB5\xB3\xBF\xFB\x20\x20\x20\x20\xBF\xBF\xBF\xBF"
    "\xFB\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 52 = 'U'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB7\xB2\xBF\xBF"
    "\xB4\xB6\xBF\xFB\xBF\xB6\xB5\xBF\xBF\xB5\xB7\xBF\xFB\xBF\xB7\xB5\xBF\xBF\xB5\xB7\xBF\xFB\xBF"
    "\xBA\xB5\xB3\xB3\xB5\xBA\xBF\xFB\x20\xBF\xBA\xB7\xB7\xBA\xBF\xFB\xFB\x20\x20\xBF\xBF\xBF\xBF"
    "\xFB\xFB\x20\x20\x20\x20\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 53 = 'V'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB4\xB1\xBF\xBF"
    "\xB2\xB5\xBF\xFB\xBF\xB4\xB2\xBF\xBF\xB3\xB5\xBF\xFB\xBF\xB6\xB4\xB9\xB9\xB2\xB6\xBF\xFB\x20"
    "\xBF\xB6\xB2\xB2\xB6\xBF\xFB\xFB\x20\x20\xBF\xB4\xB4\xBF\xFB\xFB\x20\x20\x20\x20\xBF\xBF\xFB"
    "\xFB\x20\x20\x20\x20\x20\x20\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 54 = 'W'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\xBF\xBF\xBF\xBF\x20\xBF\xB3\xB3"
    "\xBF\xBF\xBF\xB3\xBA\xBF\xFB\xBF\xB6\xB4\xBF\xB3\xBF\xB4\xB8\xBF\xFB\xBF\xB6\xB3\xBA\xB4\xBA"
    "\xB4\xB8\xBF\xFB\xBF\xB8\xB3\xB6\xB4\xB6\xB5\xB8\xBF\xFB\xBF\xB8\xB2\xB6\xBF\xB5\xB8\xB8\xBF"
    "\xFB\x20\xBF\xBF\xBF\xFB\xBF\xBF\xBF\xFB\xFB\x20\x20\xFB\xFB\xFB\x20\xFB\xFB\xFB\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20",

    // 55 = 'X'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\xBF\xBF\xBF\xBF\x20\xBF\xB3\xB5"
    "\xB7\xBF\xB7\xB5\xB7\xBF\xFB\x20\xBF\xB6\xB7\xB5\xB7\xB6\xBF\xFB\xFB\x20\x20\xBF\xB7\xB5\xB5"
    "\xBF\xFB\xFB\x20\x20\xBF\xB6\xB7\xB5\xB7\xB6\xBF\x20\x20\xBF\xB3\xB5\xB7\xBF\xB7\xB5\xB7\xBF"
    "\x20\xBF\xBF\xBF\xBF\xFB\xBF\xBF\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\x20\xFB\xFB\xFB\xFB\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20",

    // 56 = 'Y'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB1\xB1\xBF\xBF"
    "\xB2\xB2\xBF\xFB\xBF\xB4\xB3\xBF\xBF\xB3\xB6\xBF\xFB\x20\xBF\xB5\xB1\xB1\xB5\xBF\xFB\xFB\x20"
    "\x20\xBF\xB7\xB6\xBF\xFB\xFB\x20\x20\x20\xBF\xB7\xB5\xBF\xFB\x20\x20\x20\x20\xBF\xBF\xBF\xBF"
    "\xFB\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 57 = 'Z'
    "\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB5\xB4\xB2\xB2\xB6\xBF"
    "\xFB\xBF\xBF\xBF\xB4\xB6\xBA\xBF\xFB\x20\xBF\xB4\xB5\xBA\xBF\xFB\xFB\xBF\xB6\xB4\xBA\xBF\xBF"
    "\xBF\x20\xBF\xB5\xB4\xB3\xB1\xB5\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB"
    "\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20",

    // 58 = '['
    "\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\xBF\xBA\xB2\xB1\xBF\xFB\xBF\xB8\xB5\xBF\xBF"
    "\xFB\xBF\xB8\xB5\xBF\xFB\xFB\xBF\xB8\xB5\xBF\xBF\x20\xBF\xBA\xB8\xB3\xBF\xFB\x20\xBF\xBF\xBF"
    "\xBF\xFB\x20\x20\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20",

    // 59 = '\'
    "\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\x20\x20\x20\x20\x20\xBF\xB6\xB3\xBF\x20\x20\x20"
    "\x20\xBF\xB9\xB3\xB5\xBF\x20\x20\x20\x20\xBF\xB9\xB5\xB5\xBF\x20\x20\x20\x20\xBF\xB9\xB5\xB4"
    "\xBF\x20\x20\x20\x20\xBF\xB9\xB4\xBF\xFB\x20\x20\x20\x20\xBF\xBF\xBF\xFB\x20\x20\x20\x20\x20"
    "\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20",

    // 60 = ']'
    "\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\x20\xBF\xB1\xB2\xBA\xBF\x20\xBF\xBF\xB5\xB8\xBF"
    "\xFB\x20\xBF\xB6\xB8\xBF\xFB\xBF\xBF\xB6\xB8\xBF\xFB\xBF\xB3\xB6\xBA\xBF\xFB\xBF\xBF\xBF\xBF"
    "\xFB\xFB\x20\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20",

    // 61 = '^'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\x20\x20\x20\x20\x20\x20\xBF\xB8\xBF\x20\x20"
    "\x20\x20\xBF\xB8\xB5\xB8\xBF\x20\x20\xBF\xB8\xB4\xBF\xB4\xB8\xBF\x20\xBF\xBF\xBF\xFB\xBF\xBF"
    "\xBF\xFB\x20\xFB\xFB\xFB\x20\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 62 = '_'
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB1\xB1\xB1\xB1\xB1\xB1\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 63 = '|'
    "\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\xBF\xB1\xB1\xBF\xFB\xBF\xB5\xB3\xBF\xFB\xBF\xB5\xB6"
    "\xBF\xFB\xBF\xB5\xB5\xBF\xFB\xBF\xB5\xB3\xBF\xFB\xBF\xBF\xBF\xBF\xFB\x20\xFB\xFB\xFB\xFB\x20"
    "\x20\x20\x20\x20",

    // 64 = '“'
    "\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\xBF\xB3\xB5\xBF\xB3\xB5\xBF"
    "\xFB\xBF\xB6\xBF\xBF\xB6\xBF\xBF\xFB\xBF\xBF\xBF\xBF\xBF\xBF\xFB\xFB\x20\xFB\xFB\xFB\xFB\xFB"
    "\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20",

    // 65 = '‘'
    "\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\x20\xBF\xB3\xB5\xBF\xFB\xBF\xB3\xBF\xBF\xFB\xBF\xBF\xBF"
    "\xFB\xFB\x20\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20"
};

const char *underscores =
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB3\xB3\xB3\xB3\xB3\xB3\xBF\xFB\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB3\xB3\xB3\xB3\xB3\xBF\xFB\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB3"
    "\xB3\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB3"
    "\xB3\xB3\xB3\xB3\xB3\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\xBF\xB3\xB3\xB3\xB3\xB3\xB3\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xB3\xB3\xB3\xB3\xB3\xB3\xBF\xFB\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF"
    "\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF"
    "\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xBF\xFB\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB"
    "\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\xFB\xFB\xFB\xFB\xFB\xFB\xFB\xFB\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20"
    "\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20\x20";
