/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_OUTPUT_MANAGER_V1_CLIENT_PROTOCOL_H
#define TREELAND_OUTPUT_MANAGER_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_treeland_output_manager_v1 The treeland_output_manager_v1 protocol
 * @section page_ifaces_treeland_output_manager_v1 Interfaces
 * - @subpage page_iface_treeland_output_manager_v1 - expose which is the primary display
 * - @subpage page_iface_treeland_output_color_control_v1 - Color control interface for output.
 * @section page_copyright_treeland_output_manager_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024-2025 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_output_color_control_v1;
struct treeland_output_manager_v1;
struct wl_output;

#ifndef TREELAND_OUTPUT_MANAGER_V1_INTERFACE
#define TREELAND_OUTPUT_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_output_manager_v1 treeland_output_manager_v1
 * @section page_iface_treeland_output_manager_v1_desc Description
 *
 * Protocol for telling which is the primary display among the selection of enabled
 * outputs.
 * @section page_iface_treeland_output_manager_v1_api API
 * See @ref iface_treeland_output_manager_v1.
 */
/**
 * @defgroup iface_treeland_output_manager_v1 The treeland_output_manager_v1 interface
 *
 * Protocol for telling which is the primary display among the selection of enabled
 * outputs.
 */
extern const struct wl_interface treeland_output_manager_v1_interface;
#endif
#ifndef TREELAND_OUTPUT_COLOR_CONTROL_V1_INTERFACE
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_INTERFACE
/**
 * @page page_iface_treeland_output_color_control_v1 treeland_output_color_control_v1
 * @section page_iface_treeland_output_color_control_v1_desc Description
 *
 * Protocol for controlling color temperature and brightness settings of a specific output.
 * @section page_iface_treeland_output_color_control_v1_api API
 * See @ref iface_treeland_output_color_control_v1.
 */
/**
 * @defgroup iface_treeland_output_color_control_v1 The treeland_output_color_control_v1 interface
 *
 * Protocol for controlling color temperature and brightness settings of a specific output.
 */
extern const struct wl_interface treeland_output_color_control_v1_interface;
#endif

/**
 * @ingroup iface_treeland_output_manager_v1
 * @struct treeland_output_manager_v1_listener
 */
struct treeland_output_manager_v1_listener {
	/**
	 * Provide the current primary output's name
	 *
	 * Specifies which output is the primary one identified by their
	 * name.
	 * @param output_name the name of the output
	 */
	void (*primary_output)(void *data,
			       struct treeland_output_manager_v1 *treeland_output_manager_v1,
			       const char *output_name);
};

/**
 * @ingroup iface_treeland_output_manager_v1
 */
static inline int
treeland_output_manager_v1_add_listener(struct treeland_output_manager_v1 *treeland_output_manager_v1,
					const struct treeland_output_manager_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_output_manager_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_OUTPUT_MANAGER_V1_SET_PRIMARY_OUTPUT 0
#define TREELAND_OUTPUT_MANAGER_V1_GET_COLOR_CONTROL 1
#define TREELAND_OUTPUT_MANAGER_V1_DESTROY 2

/**
 * @ingroup iface_treeland_output_manager_v1
 */
#define TREELAND_OUTPUT_MANAGER_V1_PRIMARY_OUTPUT_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_output_manager_v1
 */
#define TREELAND_OUTPUT_MANAGER_V1_SET_PRIMARY_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_output_manager_v1
 */
#define TREELAND_OUTPUT_MANAGER_V1_GET_COLOR_CONTROL_SINCE_VERSION 2
/**
 * @ingroup iface_treeland_output_manager_v1
 */
#define TREELAND_OUTPUT_MANAGER_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_treeland_output_manager_v1 */
static inline void
treeland_output_manager_v1_set_user_data(struct treeland_output_manager_v1 *treeland_output_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_output_manager_v1, user_data);
}

/** @ingroup iface_treeland_output_manager_v1 */
static inline void *
treeland_output_manager_v1_get_user_data(struct treeland_output_manager_v1 *treeland_output_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_output_manager_v1);
}

static inline uint32_t
treeland_output_manager_v1_get_version(struct treeland_output_manager_v1 *treeland_output_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_output_manager_v1);
}

/**
 * @ingroup iface_treeland_output_manager_v1
 */
static inline void
treeland_output_manager_v1_set_primary_output(struct treeland_output_manager_v1 *treeland_output_manager_v1, const char *output)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_output_manager_v1,
			 TREELAND_OUTPUT_MANAGER_V1_SET_PRIMARY_OUTPUT, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_output_manager_v1), 0, output);
}

/**
 * @ingroup iface_treeland_output_manager_v1
 */
static inline struct treeland_output_color_control_v1 *
treeland_output_manager_v1_get_color_control(struct treeland_output_manager_v1 *treeland_output_manager_v1, struct wl_output *output)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) treeland_output_manager_v1,
			 TREELAND_OUTPUT_MANAGER_V1_GET_COLOR_CONTROL, &treeland_output_color_control_v1_interface, wl_proxy_get_version((struct wl_proxy *) treeland_output_manager_v1), 0, NULL, output);

	return (struct treeland_output_color_control_v1 *) id;
}

/**
 * @ingroup iface_treeland_output_manager_v1
 */
static inline void
treeland_output_manager_v1_destroy(struct treeland_output_manager_v1 *treeland_output_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_output_manager_v1,
			 TREELAND_OUTPUT_MANAGER_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_output_manager_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef TREELAND_OUTPUT_COLOR_CONTROL_V1_ERROR_ENUM
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_ERROR_ENUM
enum treeland_output_color_control_v1_error {
	/**
	 * Invalid color temperature value provided.
	 */
	TREELAND_OUTPUT_COLOR_CONTROL_V1_ERROR_INVALID_COLOR_TEMPERATURE = 1,
	/**
	 * Invalid brightness value provided.
	 */
	TREELAND_OUTPUT_COLOR_CONTROL_V1_ERROR_INVALID_BRIGHTNESS = 2,
};
#endif /* TREELAND_OUTPUT_COLOR_CONTROL_V1_ERROR_ENUM */

/**
 * @ingroup iface_treeland_output_color_control_v1
 * @struct treeland_output_color_control_v1_listener
 */
struct treeland_output_color_control_v1_listener {
	/**
	 * The result of the last commit request.
	 *
	 * 
	 * @param success 1 if the commit was successful, 0 otherwise.
	 */
	void (*result)(void *data,
		       struct treeland_output_color_control_v1 *treeland_output_color_control_v1,
		       uint32_t success);
	/**
	 * Current color temperature for output.
	 *
	 * Provides the current color temperature setting of the output.
	 * Color temperature is valued in the range [1000, 20000]. Color
	 * temperature is defined as the corresponding temperature (in
	 * Kelvin) of the current white point of the display on a Planckian
	 * locus. With the current implementation, the neutral temperature
	 * is 6600K. This event is sent once after the
	 * treeland_output_color_control_v1 object is created, or right
	 * after when a color temperature change for the output is
	 * successfully commited.
	 * @param temperature current color temperature in Kelvin
	 */
	void (*color_temperature)(void *data,
				  struct treeland_output_color_control_v1 *treeland_output_color_control_v1,
				  uint32_t temperature);
	/**
	 * Current brightness for output.
	 *
	 * Provides the current brightness setting of the output.
	 * Brightness is valued in the range [0.0, 100.0]. This event is
	 * sent once after the treeland_output_color_control_v1 object is
	 * created, or right after when a brightness change for the output
	 * is successfully commited.
	 * @param brightness current brightness level (in range [0.0, 100.0])
	 */
	void (*brightness)(void *data,
			   struct treeland_output_color_control_v1 *treeland_output_color_control_v1,
			   wl_fixed_t brightness);
};

/**
 * @ingroup iface_treeland_output_color_control_v1
 */
static inline int
treeland_output_color_control_v1_add_listener(struct treeland_output_color_control_v1 *treeland_output_color_control_v1,
					      const struct treeland_output_color_control_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) treeland_output_color_control_v1,
				     (void (**)(void)) listener, data);
}

#define TREELAND_OUTPUT_COLOR_CONTROL_V1_SET_COLOR_TEMPERATURE 0
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_SET_BRIGHTNESS 1
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_COMMIT 2
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_DESTROY 3

/**
 * @ingroup iface_treeland_output_color_control_v1
 */
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_RESULT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_output_color_control_v1
 */
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_COLOR_TEMPERATURE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_output_color_control_v1
 */
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_BRIGHTNESS_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_output_color_control_v1
 */
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_SET_COLOR_TEMPERATURE_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_output_color_control_v1
 */
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_SET_BRIGHTNESS_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_output_color_control_v1
 */
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_output_color_control_v1
 */
#define TREELAND_OUTPUT_COLOR_CONTROL_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_treeland_output_color_control_v1 */
static inline void
treeland_output_color_control_v1_set_user_data(struct treeland_output_color_control_v1 *treeland_output_color_control_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) treeland_output_color_control_v1, user_data);
}

/** @ingroup iface_treeland_output_color_control_v1 */
static inline void *
treeland_output_color_control_v1_get_user_data(struct treeland_output_color_control_v1 *treeland_output_color_control_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) treeland_output_color_control_v1);
}

static inline uint32_t
treeland_output_color_control_v1_get_version(struct treeland_output_color_control_v1 *treeland_output_color_control_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) treeland_output_color_control_v1);
}

/**
 * @ingroup iface_treeland_output_color_control_v1
 *
 * Color temperature settings are applied only after a commit request is made.
 * Setting a value outside the range [1000, 20000] is a protocol error.
 */
static inline void
treeland_output_color_control_v1_set_color_temperature(struct treeland_output_color_control_v1 *treeland_output_color_control_v1, uint32_t temperature)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_output_color_control_v1,
			 TREELAND_OUTPUT_COLOR_CONTROL_V1_SET_COLOR_TEMPERATURE, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_output_color_control_v1), 0, temperature);
}

/**
 * @ingroup iface_treeland_output_color_control_v1
 *
 * Brightness settings are applied only after a commit request is made.
 * Setting a value outside the range [0.0, 100.0] is a protocol error.
 */
static inline void
treeland_output_color_control_v1_set_brightness(struct treeland_output_color_control_v1 *treeland_output_color_control_v1, wl_fixed_t brightness)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_output_color_control_v1,
			 TREELAND_OUTPUT_COLOR_CONTROL_V1_SET_BRIGHTNESS, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_output_color_control_v1), 0, brightness);
}

/**
 * @ingroup iface_treeland_output_color_control_v1
 */
static inline void
treeland_output_color_control_v1_commit(struct treeland_output_color_control_v1 *treeland_output_color_control_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_output_color_control_v1,
			 TREELAND_OUTPUT_COLOR_CONTROL_V1_COMMIT, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_output_color_control_v1), 0);
}

/**
 * @ingroup iface_treeland_output_color_control_v1
 */
static inline void
treeland_output_color_control_v1_destroy(struct treeland_output_color_control_v1 *treeland_output_color_control_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) treeland_output_color_control_v1,
			 TREELAND_OUTPUT_COLOR_CONTROL_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) treeland_output_color_control_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifdef  __cplusplus
}
#endif

#endif
