/* Generated by wayland-scanner 1.24.0 */

#ifndef PLUGIN_MANAGER_V1_SERVER_PROTOCOL_H
#define PLUGIN_MANAGER_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_plugin_manager_v1 The plugin_manager_v1 protocol
 * @section page_ifaces_plugin_manager_v1 Interfaces
 * - @subpage page_iface_plugin_manager_v1 - plugin manager
 * - @subpage page_iface_plugin_popup - 
 * - @subpage page_iface_plugin - 
 * @section page_copyright_plugin_manager_v1 Copyright
 * <pre>
 *
 * Copyright © 2024 Uniontech
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct plugin;
struct plugin_manager_v1;
struct plugin_popup;
struct wl_surface;

#ifndef PLUGIN_MANAGER_V1_INTERFACE
#define PLUGIN_MANAGER_V1_INTERFACE
/**
 * @page page_iface_plugin_manager_v1 plugin_manager_v1
 * @section page_iface_plugin_manager_v1_desc Description
 *
 * This interface allows a client to get server(dock) some info and create plugins to compositor.
 * @section page_iface_plugin_manager_v1_api API
 * See @ref iface_plugin_manager_v1.
 */
/**
 * @defgroup iface_plugin_manager_v1 The plugin_manager_v1 interface
 *
 * This interface allows a client to get server(dock) some info and create plugins to compositor.
 */
extern const struct wl_interface plugin_manager_v1_interface;
#endif
#ifndef PLUGIN_POPUP_INTERFACE
#define PLUGIN_POPUP_INTERFACE
/**
 * @page page_iface_plugin_popup plugin_popup
 * @section page_iface_plugin_popup_api API
 * See @ref iface_plugin_popup.
 */
/**
 * @defgroup iface_plugin_popup The plugin_popup interface
 */
extern const struct wl_interface plugin_popup_interface;
#endif
#ifndef PLUGIN_INTERFACE
#define PLUGIN_INTERFACE
/**
 * @page page_iface_plugin plugin
 * @section page_iface_plugin_api API
 * See @ref iface_plugin.
 */
/**
 * @defgroup iface_plugin The plugin interface
 */
extern const struct wl_interface plugin_interface;
#endif

#ifndef PLUGIN_MANAGER_V1_ERROR_ENUM
#define PLUGIN_MANAGER_V1_ERROR_ENUM
enum plugin_manager_v1_error {
	/**
	 * given wl_surface has another role
	 */
	PLUGIN_MANAGER_V1_ERROR_ROLE = 0,
	/**
	 * given wl_surface has another plugin_id
	 */
	PLUGIN_MANAGER_V1_ERROR_PLUGIN_ID = 1,
};
#endif /* PLUGIN_MANAGER_V1_ERROR_ENUM */

#ifndef PLUGIN_MANAGER_V1_ERROR_ENUM_IS_VALID
#define PLUGIN_MANAGER_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_plugin_manager_v1
 * Validate a plugin_manager_v1 error value.
 *
 * @return true on success, false on error.
 * @ref plugin_manager_v1_error
 */
static inline bool
plugin_manager_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case PLUGIN_MANAGER_V1_ERROR_ROLE:
		return version >= 1;
	case PLUGIN_MANAGER_V1_ERROR_PLUGIN_ID:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* PLUGIN_MANAGER_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_plugin_manager_v1
 * @struct plugin_manager_v1_interface
 */
struct plugin_manager_v1_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 * a message sent from client
	 *
	 * This event will emitted when client send message to server.
	 * Such as plugin status interface defined.
	 */
	void (*request_message)(struct wl_client *client,
				struct wl_resource *resource,
				const char *plugin_id,
				const char *item_key,
				const char *msg);
	/**
	 * created popup window
	 *
	 * This will created a popup window at (x, y) pos relative to
	 * ouput.
	 */
	void (*create_popup_at)(struct wl_client *client,
				struct wl_resource *resource,
				const char *plugin_id,
				const char *item_key,
				int32_t type,
				int32_t x,
				int32_t y,
				struct wl_resource *surface,
				uint32_t id);
	/**
	 */
	void (*create_plugin)(struct wl_client *client,
			      struct wl_resource *resource,
			      const char *plugin_id,
			      const char *item_key,
			      const char *display_name,
			      int32_t plugin_flags,
			      int32_t type,
			      int32_t size_policy,
			      struct wl_resource *surface,
			      uint32_t id);
};

#define PLUGIN_MANAGER_V1_POSITION_CHANGED 0
#define PLUGIN_MANAGER_V1_COLOR_THEME_CHANGED 1
#define PLUGIN_MANAGER_V1_ACTIVE_COLOR_CHANGED 2
#define PLUGIN_MANAGER_V1_FONT_CHANGED 3
#define PLUGIN_MANAGER_V1_THEME_CHANGED 4
#define PLUGIN_MANAGER_V1_EVENT_MESSAGE 5

/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_POSITION_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_COLOR_THEME_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_ACTIVE_COLOR_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_FONT_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_THEME_CHANGED_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_EVENT_MESSAGE_SINCE_VERSION 1

/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_REQUEST_MESSAGE_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_CREATE_POPUP_AT_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_manager_v1
 */
#define PLUGIN_MANAGER_V1_CREATE_PLUGIN_SINCE_VERSION 1

/**
 * @ingroup iface_plugin_manager_v1
 * Sends an position_changed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
plugin_manager_v1_send_position_changed(struct wl_resource *resource_, uint32_t dock_position)
{
	wl_resource_post_event(resource_, PLUGIN_MANAGER_V1_POSITION_CHANGED, dock_position);
}

/**
 * @ingroup iface_plugin_manager_v1
 * Sends an color_theme_changed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
plugin_manager_v1_send_color_theme_changed(struct wl_resource *resource_, uint32_t dock_color_theme)
{
	wl_resource_post_event(resource_, PLUGIN_MANAGER_V1_COLOR_THEME_CHANGED, dock_color_theme);
}

/**
 * @ingroup iface_plugin_manager_v1
 * Sends an active_color_changed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
plugin_manager_v1_send_active_color_changed(struct wl_resource *resource_, const char *active_color, const char *dark_active_color)
{
	wl_resource_post_event(resource_, PLUGIN_MANAGER_V1_ACTIVE_COLOR_CHANGED, active_color, dark_active_color);
}

/**
 * @ingroup iface_plugin_manager_v1
 * Sends an font_changed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
plugin_manager_v1_send_font_changed(struct wl_resource *resource_, const char *font_name, int32_t font_point_size)
{
	wl_resource_post_event(resource_, PLUGIN_MANAGER_V1_FONT_CHANGED, font_name, font_point_size);
}

/**
 * @ingroup iface_plugin_manager_v1
 * Sends an theme_changed event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
plugin_manager_v1_send_theme_changed(struct wl_resource *resource_, const char *theme_name, const char *icon_theme_name)
{
	wl_resource_post_event(resource_, PLUGIN_MANAGER_V1_THEME_CHANGED, theme_name, icon_theme_name);
}

/**
 * @ingroup iface_plugin_manager_v1
 * Sends an event_message event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
plugin_manager_v1_send_event_message(struct wl_resource *resource_, const char *msg)
{
	wl_resource_post_event(resource_, PLUGIN_MANAGER_V1_EVENT_MESSAGE, msg);
}

/**
 * @ingroup iface_plugin_popup
 * @struct plugin_popup_interface
 */
struct plugin_popup_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 */
	void (*set_position)(struct wl_client *client,
			     struct wl_resource *resource,
			     int32_t x,
			     int32_t y);
	/**
	 */
	void (*source_size)(struct wl_client *client,
			    struct wl_resource *resource,
			    int32_t width,
			    int32_t height);
};

#define PLUGIN_POPUP_CLOSE 0
#define PLUGIN_POPUP_GEOMETRY 1

/**
 * @ingroup iface_plugin_popup
 */
#define PLUGIN_POPUP_CLOSE_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_popup
 */
#define PLUGIN_POPUP_GEOMETRY_SINCE_VERSION 1

/**
 * @ingroup iface_plugin_popup
 */
#define PLUGIN_POPUP_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_popup
 */
#define PLUGIN_POPUP_SET_POSITION_SINCE_VERSION 1
/**
 * @ingroup iface_plugin_popup
 */
#define PLUGIN_POPUP_SOURCE_SIZE_SINCE_VERSION 1

/**
 * @ingroup iface_plugin_popup
 * Sends an close event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
plugin_popup_send_close(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, PLUGIN_POPUP_CLOSE);
}

/**
 * @ingroup iface_plugin_popup
 * Sends an geometry event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
plugin_popup_send_geometry(struct wl_resource *resource_, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_resource_post_event(resource_, PLUGIN_POPUP_GEOMETRY, x, y, width, height);
}

/**
 * @ingroup iface_plugin
 * @struct plugin_interface
 */
struct plugin_interface {
	/**
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
	/**
	 */
	void (*mouse_event)(struct wl_client *client,
			    struct wl_resource *resource,
			    int32_t type);
	/**
	 */
	void (*dcc_icon)(struct wl_client *client,
			 struct wl_resource *resource,
			 const char *type);
	/**
	 */
	void (*request_shutdown)(struct wl_client *client,
				 struct wl_resource *resource,
				 const char *type);
	/**
	 */
	void (*source_size)(struct wl_client *client,
			    struct wl_resource *resource,
			    int32_t width,
			    int32_t height);
	/**
	 */
	void (*close_quick_panel)(struct wl_client *client,
				  struct wl_resource *resource);
};

#define PLUGIN_CLOSE 0
#define PLUGIN_GEOMETRY 1
#define PLUGIN_MARGIN 2
#define PLUGIN_RAW_GLOBAL_POS 3

/**
 * @ingroup iface_plugin
 */
#define PLUGIN_CLOSE_SINCE_VERSION 1
/**
 * @ingroup iface_plugin
 */
#define PLUGIN_GEOMETRY_SINCE_VERSION 1
/**
 * @ingroup iface_plugin
 */
#define PLUGIN_MARGIN_SINCE_VERSION 1
/**
 * @ingroup iface_plugin
 */
#define PLUGIN_RAW_GLOBAL_POS_SINCE_VERSION 1

/**
 * @ingroup iface_plugin
 */
#define PLUGIN_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_plugin
 */
#define PLUGIN_MOUSE_EVENT_SINCE_VERSION 1
/**
 * @ingroup iface_plugin
 */
#define PLUGIN_DCC_ICON_SINCE_VERSION 1
/**
 * @ingroup iface_plugin
 */
#define PLUGIN_REQUEST_SHUTDOWN_SINCE_VERSION 1
/**
 * @ingroup iface_plugin
 */
#define PLUGIN_SOURCE_SIZE_SINCE_VERSION 1
/**
 * @ingroup iface_plugin
 */
#define PLUGIN_CLOSE_QUICK_PANEL_SINCE_VERSION 1

/**
 * @ingroup iface_plugin
 * Sends an close event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
plugin_send_close(struct wl_resource *resource_)
{
	wl_resource_post_event(resource_, PLUGIN_CLOSE);
}

/**
 * @ingroup iface_plugin
 * Sends an geometry event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
plugin_send_geometry(struct wl_resource *resource_, int32_t x, int32_t y, int32_t width, int32_t height)
{
	wl_resource_post_event(resource_, PLUGIN_GEOMETRY, x, y, width, height);
}

/**
 * @ingroup iface_plugin
 * Sends an margin event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
plugin_send_margin(struct wl_resource *resource_, int32_t spacing)
{
	wl_resource_post_event(resource_, PLUGIN_MARGIN, spacing);
}

/**
 * @ingroup iface_plugin
 * Sends an raw_global_pos event to the client owning the resource.
 * @param resource_ The client's resource
 */
static inline void
plugin_send_raw_global_pos(struct wl_resource *resource_, int32_t x, int32_t y)
{
	wl_resource_post_event(resource_, PLUGIN_RAW_GLOBAL_POS, x, y);
}

#ifdef  __cplusplus
}
#endif

#endif
