/* Generated by wayland-scanner 1.24.0 */

#ifndef DDE_KVM_SERVER_PROTOCOL_H
#define DDE_KVM_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_dde_kvm The dde_kvm protocol
 * @section page_ifaces_dde_kvm Interfaces
 * - @subpage page_iface_dde_kvm - dde kvm
 * - @subpage page_iface_dde_kvm_pointer - dde kvm pointer
 * - @subpage page_iface_dde_kvm_keyboard - dde kvm keyboard
 * @section page_copyright_dde_kvm Copyright
 * <pre>
 *
 * Copyright © 2024  xinbo wang <wangxinbo@uniontech.com>
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct dde_kvm;
struct dde_kvm_keyboard;
struct dde_kvm_pointer;

#ifndef DDE_KVM_INTERFACE
#define DDE_KVM_INTERFACE
/**
 * @page page_iface_dde_kvm dde_kvm
 * @section page_iface_dde_kvm_desc Description
 * @section page_iface_dde_kvm_api API
 * See @ref iface_dde_kvm.
 */
/**
 * @defgroup iface_dde_kvm The dde_kvm interface
 */
extern const struct wl_interface dde_kvm_interface;
#endif
#ifndef DDE_KVM_POINTER_INTERFACE
#define DDE_KVM_POINTER_INTERFACE
/**
 * @page page_iface_dde_kvm_pointer dde_kvm_pointer
 * @section page_iface_dde_kvm_pointer_desc Description
 * @section page_iface_dde_kvm_pointer_api API
 * See @ref iface_dde_kvm_pointer.
 */
/**
 * @defgroup iface_dde_kvm_pointer The dde_kvm_pointer interface
 */
extern const struct wl_interface dde_kvm_pointer_interface;
#endif
#ifndef DDE_KVM_KEYBOARD_INTERFACE
#define DDE_KVM_KEYBOARD_INTERFACE
/**
 * @page page_iface_dde_kvm_keyboard dde_kvm_keyboard
 * @section page_iface_dde_kvm_keyboard_desc Description
 * @section page_iface_dde_kvm_keyboard_api API
 * See @ref iface_dde_kvm_keyboard.
 */
/**
 * @defgroup iface_dde_kvm_keyboard The dde_kvm_keyboard interface
 */
extern const struct wl_interface dde_kvm_keyboard_interface;
#endif

/**
 * @ingroup iface_dde_kvm
 * @struct dde_kvm_interface
 */
struct dde_kvm_interface {
	/**
	 * get dde kvm keyboard
	 *
	 * 
	 * @param id Requested dde kvm keyboard id
	 */
	void (*get_dde_kvm_keyboard)(struct wl_client *client,
				     struct wl_resource *resource,
				     uint32_t id);
	/**
	 * get dde kvm pointer
	 *
	 * 
	 * @param id Requested dde kvm pointer id
	 */
	void (*get_dde_kvm_pointer)(struct wl_client *client,
				    struct wl_resource *resource,
				    uint32_t id);
};


/**
 * @ingroup iface_dde_kvm
 */
#define DDE_KVM_GET_DDE_KVM_KEYBOARD_SINCE_VERSION 1
/**
 * @ingroup iface_dde_kvm
 */
#define DDE_KVM_GET_DDE_KVM_POINTER_SINCE_VERSION 1

#ifndef DDE_KVM_POINTER_BUTTON_STATE_ENUM
#define DDE_KVM_POINTER_BUTTON_STATE_ENUM
/**
 * @ingroup iface_dde_kvm_pointer
 * the pointer click-button status of whether the pointer click-button be pressed or release
 */
enum dde_kvm_pointer_button_state {
	/**
	 * feature click-button press
	 */
	DDE_KVM_POINTER_BUTTON_STATE_PRESS = 1,
	/**
	 * feature click-button release
	 */
	DDE_KVM_POINTER_BUTTON_STATE_RELEASE = 0,
};
#endif /* DDE_KVM_POINTER_BUTTON_STATE_ENUM */

#ifndef DDE_KVM_POINTER_BUTTON_STATE_ENUM_IS_VALID
#define DDE_KVM_POINTER_BUTTON_STATE_ENUM_IS_VALID
/**
 * @ingroup iface_dde_kvm_pointer
 * Validate a dde_kvm_pointer button_state value.
 *
 * @return true on success, false on error.
 * @ref dde_kvm_pointer_button_state
 */
static inline bool
dde_kvm_pointer_button_state_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_KVM_POINTER_BUTTON_STATE_PRESS:
		return version >= 1;
	case DDE_KVM_POINTER_BUTTON_STATE_RELEASE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_KVM_POINTER_BUTTON_STATE_ENUM_IS_VALID */

#ifndef DDE_KVM_POINTER_SCROLL_TYPE_ENUM
#define DDE_KVM_POINTER_SCROLL_TYPE_ENUM
/**
 * @ingroup iface_dde_kvm_pointer
 * the pointer scroll button status of whether the pointer scroll-button be vertical or horizontal
 */
enum dde_kvm_pointer_scroll_type {
	/**
	 * feature scroll-button vertical
	 */
	DDE_KVM_POINTER_SCROLL_TYPE_VERTICAL = 0,
	/**
	 * feature scroll-button horizontal
	 */
	DDE_KVM_POINTER_SCROLL_TYPE_HORIZONTAL = 1,
};
#endif /* DDE_KVM_POINTER_SCROLL_TYPE_ENUM */

#ifndef DDE_KVM_POINTER_SCROLL_TYPE_ENUM_IS_VALID
#define DDE_KVM_POINTER_SCROLL_TYPE_ENUM_IS_VALID
/**
 * @ingroup iface_dde_kvm_pointer
 * Validate a dde_kvm_pointer scroll_type value.
 *
 * @return true on success, false on error.
 * @ref dde_kvm_pointer_scroll_type
 */
static inline bool
dde_kvm_pointer_scroll_type_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_KVM_POINTER_SCROLL_TYPE_VERTICAL:
		return version >= 1;
	case DDE_KVM_POINTER_SCROLL_TYPE_HORIZONTAL:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_KVM_POINTER_SCROLL_TYPE_ENUM_IS_VALID */

/**
 * @ingroup iface_dde_kvm_pointer
 * @struct dde_kvm_pointer_interface
 */
struct dde_kvm_pointer_interface {
	/**
	 * enable pointer
	 *
	 * 
	 * @param is_enable Requested enable pointer
	 */
	void (*enable_pointer)(struct wl_client *client,
			       struct wl_resource *resource,
			       uint32_t is_enable);
	/**
	 * enale cursor
	 *
	 * 
	 * @param is_enable Requested enable cursor
	 */
	void (*enable_cursor)(struct wl_client *client,
			      struct wl_resource *resource,
			      uint32_t is_enable);
	/**
	 * set cursor pos
	 *
	 * 
	 * @param x Requested set cursor x
	 * @param y Requested set cursor y
	 */
	void (*set_pos)(struct wl_client *client,
			struct wl_resource *resource,
			wl_fixed_t x,
			wl_fixed_t y);
};

#define DDE_KVM_POINTER_MOTION 0
#define DDE_KVM_POINTER_BUTTON 1
#define DDE_KVM_POINTER_AXIS 2

/**
 * @ingroup iface_dde_kvm_pointer
 */
#define DDE_KVM_POINTER_MOTION_SINCE_VERSION 1
/**
 * @ingroup iface_dde_kvm_pointer
 */
#define DDE_KVM_POINTER_BUTTON_SINCE_VERSION 1
/**
 * @ingroup iface_dde_kvm_pointer
 */
#define DDE_KVM_POINTER_AXIS_SINCE_VERSION 1

/**
 * @ingroup iface_dde_kvm_pointer
 */
#define DDE_KVM_POINTER_ENABLE_POINTER_SINCE_VERSION 1
/**
 * @ingroup iface_dde_kvm_pointer
 */
#define DDE_KVM_POINTER_ENABLE_CURSOR_SINCE_VERSION 1
/**
 * @ingroup iface_dde_kvm_pointer
 */
#define DDE_KVM_POINTER_SET_POS_SINCE_VERSION 1

/**
 * @ingroup iface_dde_kvm_pointer
 * Sends an motion event to the client owning the resource.
 * @param resource_ The client's resource
 * @param time the event occured time.
 * @param x the event occured x.
 * @param y the event occured y.
 */
static inline void
dde_kvm_pointer_send_motion(struct wl_resource *resource_, uint32_t time, wl_fixed_t x, wl_fixed_t y)
{
	wl_resource_post_event(resource_, DDE_KVM_POINTER_MOTION, time, x, y);
}

/**
 * @ingroup iface_dde_kvm_pointer
 * Sends an button event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serial serial number of the enter event
 * @param time timestamp with millisecond granularity
 * @param state button state
 */
static inline void
dde_kvm_pointer_send_button(struct wl_resource *resource_, uint32_t serial, uint32_t time, uint32_t state)
{
	wl_resource_post_event(resource_, DDE_KVM_POINTER_BUTTON, serial, time, state);
}

/**
 * @ingroup iface_dde_kvm_pointer
 * Sends an axis event to the client owning the resource.
 * @param resource_ The client's resource
 * @param time timestamp with millisecond granularity
 * @param type type
 * @param value length of vector in surface-local coordinate space
 */
static inline void
dde_kvm_pointer_send_axis(struct wl_resource *resource_, uint32_t time, uint32_t type, wl_fixed_t value)
{
	wl_resource_post_event(resource_, DDE_KVM_POINTER_AXIS, time, type, value);
}

#ifndef DDE_KVM_KEYBOARD_KEY_STATE_ENUM
#define DDE_KVM_KEYBOARD_KEY_STATE_ENUM
/**
 * @ingroup iface_dde_kvm_keyboard
 * the keyboard key status
 */
enum dde_kvm_keyboard_key_state {
	/**
	 * key is pressed
	 */
	DDE_KVM_KEYBOARD_KEY_STATE_PRESS = 1,
	/**
	 * key is released
	 */
	DDE_KVM_KEYBOARD_KEY_STATE_RELEASE = 0,
};
#endif /* DDE_KVM_KEYBOARD_KEY_STATE_ENUM */

#ifndef DDE_KVM_KEYBOARD_KEY_STATE_ENUM_IS_VALID
#define DDE_KVM_KEYBOARD_KEY_STATE_ENUM_IS_VALID
/**
 * @ingroup iface_dde_kvm_keyboard
 * Validate a dde_kvm_keyboard key_state value.
 *
 * @return true on success, false on error.
 * @ref dde_kvm_keyboard_key_state
 */
static inline bool
dde_kvm_keyboard_key_state_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case DDE_KVM_KEYBOARD_KEY_STATE_PRESS:
		return version >= 1;
	case DDE_KVM_KEYBOARD_KEY_STATE_RELEASE:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* DDE_KVM_KEYBOARD_KEY_STATE_ENUM_IS_VALID */

/**
 * @ingroup iface_dde_kvm_keyboard
 * @struct dde_kvm_keyboard_interface
 */
struct dde_kvm_keyboard_interface {
	/**
	 * enable keyboard
	 *
	 * 
	 * @param is_enable Requested enable keyboard
	 */
	void (*enable_keyboard)(struct wl_client *client,
				struct wl_resource *resource,
				uint32_t is_enable);
};

#define DDE_KVM_KEYBOARD_KEY 0
#define DDE_KVM_KEYBOARD_MODIFIERS 1

/**
 * @ingroup iface_dde_kvm_keyboard
 */
#define DDE_KVM_KEYBOARD_KEY_SINCE_VERSION 1
/**
 * @ingroup iface_dde_kvm_keyboard
 */
#define DDE_KVM_KEYBOARD_MODIFIERS_SINCE_VERSION 1

/**
 * @ingroup iface_dde_kvm_keyboard
 */
#define DDE_KVM_KEYBOARD_ENABLE_KEYBOARD_SINCE_VERSION 1

/**
 * @ingroup iface_dde_kvm_keyboard
 * Sends an key event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serial serial number of the key event
 * @param time timestamp with millisecond granularity
 * @param key key that produced the event
 * @param state physical state of the key
 */
static inline void
dde_kvm_keyboard_send_key(struct wl_resource *resource_, uint32_t serial, uint32_t time, uint32_t key, uint32_t state)
{
	wl_resource_post_event(resource_, DDE_KVM_KEYBOARD_KEY, serial, time, key, state);
}

/**
 * @ingroup iface_dde_kvm_keyboard
 * Sends an modifiers event to the client owning the resource.
 * @param resource_ The client's resource
 * @param serial serial number of the key event
 * @param mods_depressed depressed modifiers
 * @param mods_latched latched modifiers
 * @param mods_locked locked modifiers
 * @param group keyboard layout
 */
static inline void
dde_kvm_keyboard_send_modifiers(struct wl_resource *resource_, uint32_t serial, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group)
{
	wl_resource_post_event(resource_, DDE_KVM_KEYBOARD_MODIFIERS, serial, mods_depressed, mods_latched, mods_locked, group);
}

#ifdef  __cplusplus
}
#endif

#endif
