// This file was generated by qtwaylandscanner
// source file is /usr/share/deepin-wayland-protocols/dde-kvm.xml

#ifndef QT_WAYLAND_SERVER_DDE_KVM
#define QT_WAYLAND_SERVER_DDE_KVM

#include "wayland-server-core.h"
#include "wayland-dde-kvm-server-protocol.h"
#include <QByteArray>
#include <QMultiMap>
#include <QString>

#include <unistd.h>

#ifndef WAYLAND_VERSION_CHECK
#define WAYLAND_VERSION_CHECK(major, minor, micro) \
    ((WAYLAND_VERSION_MAJOR > (major)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR > (minor)) || \
    (WAYLAND_VERSION_MAJOR == (major) && WAYLAND_VERSION_MINOR == (minor) && WAYLAND_VERSION_MICRO >= (micro)))
#endif

QT_BEGIN_NAMESPACE
QT_WARNING_PUSH
QT_WARNING_DISABLE_GCC("-Wmissing-field-initializers")
QT_WARNING_DISABLE_CLANG("-Wmissing-field-initializers")

namespace QtWaylandServer {
    class  dde_kvm
    {
    public:
        dde_kvm(struct ::wl_client *client, int id, int version);
        dde_kvm(struct ::wl_display *display, int version);
        dde_kvm(struct ::wl_resource *resource);
        dde_kvm();

        virtual ~dde_kvm();

        class Resource
        {
        public:
            Resource() : dde_kvm_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            dde_kvm *dde_kvm_object;
            dde_kvm *object() { return dde_kvm_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


    protected:
        virtual Resource *dde_kvm_allocate();

        virtual void dde_kvm_destroy_global();

        virtual void dde_kvm_bind_resource(Resource *resource);
        virtual void dde_kvm_destroy_resource(Resource *resource);

        virtual void dde_kvm_get_dde_kvm_keyboard(Resource *resource, uint32_t id);
        virtual void dde_kvm_get_dde_kvm_pointer(Resource *resource, uint32_t id);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::dde_kvm_interface m_dde_kvm_interface;

        static void handle_get_dde_kvm_keyboard(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id);
        static void handle_get_dde_kvm_pointer(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t id);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            dde_kvm *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  dde_kvm_pointer
    {
    public:
        dde_kvm_pointer(struct ::wl_client *client, int id, int version);
        dde_kvm_pointer(struct ::wl_display *display, int version);
        dde_kvm_pointer(struct ::wl_resource *resource);
        dde_kvm_pointer();

        virtual ~dde_kvm_pointer();

        class Resource
        {
        public:
            Resource() : dde_kvm_pointer_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            dde_kvm_pointer *dde_kvm_pointer_object;
            dde_kvm_pointer *object() { return dde_kvm_pointer_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum button_state {
            button_state_press = 1, // feature click-button press
            button_state_release = 0, // feature click-button release
        };

        enum scroll_type {
            scroll_type_vertical = 0, // feature scroll-button vertical
            scroll_type_horizontal = 1, // feature scroll-button horizontal
        };

        void send_motion(uint32_t time, wl_fixed_t x, wl_fixed_t y);
        void send_motion(struct ::wl_resource *resource, uint32_t time, wl_fixed_t x, wl_fixed_t y);
        void send_button(uint32_t serial, uint32_t time, uint32_t state);
        void send_button(struct ::wl_resource *resource, uint32_t serial, uint32_t time, uint32_t state);
        void send_axis(uint32_t time, uint32_t type, wl_fixed_t value);
        void send_axis(struct ::wl_resource *resource, uint32_t time, uint32_t type, wl_fixed_t value);

    protected:
        virtual Resource *dde_kvm_pointer_allocate();

        virtual void dde_kvm_pointer_destroy_global();

        virtual void dde_kvm_pointer_bind_resource(Resource *resource);
        virtual void dde_kvm_pointer_destroy_resource(Resource *resource);

        virtual void dde_kvm_pointer_enable_pointer(Resource *resource, uint32_t is_enable);
        virtual void dde_kvm_pointer_enable_cursor(Resource *resource, uint32_t is_enable);
        virtual void dde_kvm_pointer_set_pos(Resource *resource, wl_fixed_t x, wl_fixed_t y);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::dde_kvm_pointer_interface m_dde_kvm_pointer_interface;

        static void handle_enable_pointer(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t is_enable);
        static void handle_enable_cursor(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t is_enable);
        static void handle_set_pos(
            ::wl_client *client,
            struct wl_resource *resource,
            wl_fixed_t x,
            wl_fixed_t y);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            dde_kvm_pointer *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };

    class  dde_kvm_keyboard
    {
    public:
        dde_kvm_keyboard(struct ::wl_client *client, int id, int version);
        dde_kvm_keyboard(struct ::wl_display *display, int version);
        dde_kvm_keyboard(struct ::wl_resource *resource);
        dde_kvm_keyboard();

        virtual ~dde_kvm_keyboard();

        class Resource
        {
        public:
            Resource() : dde_kvm_keyboard_object(nullptr), handle(nullptr) {}
            virtual ~Resource() {}

            dde_kvm_keyboard *dde_kvm_keyboard_object;
            dde_kvm_keyboard *object() { return dde_kvm_keyboard_object; } 
            struct ::wl_resource *handle;

            struct ::wl_client *client() const { return wl_resource_get_client(handle); }
            int version() const { return wl_resource_get_version(handle); }

            static Resource *fromResource(struct ::wl_resource *resource);
        };

        void init(struct ::wl_client *client, int id, int version);
        void init(struct ::wl_display *display, int version);
        void init(struct ::wl_resource *resource);

        Resource *add(struct ::wl_client *client, int version);
        Resource *add(struct ::wl_client *client, int id, int version);
        Resource *add(struct wl_list *resource_list, struct ::wl_client *client, int id, int version);

        Resource *resource() { return m_resource; }
        const Resource *resource() const { return m_resource; }

        QMultiMap<struct ::wl_client*, Resource*> resourceMap() { return m_resource_map; }
        const QMultiMap<struct ::wl_client*, Resource*> resourceMap() const { return m_resource_map; }

        bool isGlobalRemoved() const { return m_globalRemovedEvent; }
        void globalRemove();

        bool isGlobal() const { return m_global != nullptr; }
        bool isResource() const { return m_resource != nullptr; }

        static const struct ::wl_interface *interface();
        static QByteArray interfaceName() { return interface()->name; }
        static int interfaceVersion() { return interface()->version; }


        enum key_state {
            key_state_press = 1, // key is pressed
            key_state_release = 0, // key is released
        };

        void send_key(uint32_t serial, uint32_t time, uint32_t key, uint32_t state);
        void send_key(struct ::wl_resource *resource, uint32_t serial, uint32_t time, uint32_t key, uint32_t state);
        void send_modifiers(uint32_t serial, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group);
        void send_modifiers(struct ::wl_resource *resource, uint32_t serial, uint32_t mods_depressed, uint32_t mods_latched, uint32_t mods_locked, uint32_t group);

    protected:
        virtual Resource *dde_kvm_keyboard_allocate();

        virtual void dde_kvm_keyboard_destroy_global();

        virtual void dde_kvm_keyboard_bind_resource(Resource *resource);
        virtual void dde_kvm_keyboard_destroy_resource(Resource *resource);

        virtual void dde_kvm_keyboard_enable_keyboard(Resource *resource, uint32_t is_enable);

    private:
        static void bind_func(struct ::wl_client *client, void *data, uint32_t version, uint32_t id);
        static void destroy_func(struct ::wl_resource *client_resource);
        static void display_destroy_func(struct ::wl_listener *listener, void *data);
        static int deferred_destroy_global_func(void *data);

        Resource *bind(struct ::wl_client *client, uint32_t id, int version);
        Resource *bind(struct ::wl_resource *handle);

        static const struct ::dde_kvm_keyboard_interface m_dde_kvm_keyboard_interface;

        static void handle_enable_keyboard(
            ::wl_client *client,
            struct wl_resource *resource,
            uint32_t is_enable);

        QMultiMap<struct ::wl_client*, Resource*> m_resource_map;
        Resource *m_resource;
        struct ::wl_global *m_global;
        struct ::wl_display *m_display;
        struct wl_event_source *m_globalRemovedEvent;
        struct DisplayDestroyedListener : ::wl_listener {
            dde_kvm_keyboard *parent;
        };
        DisplayDestroyedListener m_displayDestroyedListener;
    };
}

QT_WARNING_POP
QT_END_NAMESPACE

#endif
