/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	acmev1 "github.com/cert-manager/cert-manager/pkg/client/applyconfigurations/acme/v1"
)

// IssuerConfigApplyConfiguration represents a declarative configuration of the IssuerConfig type for use
// with apply.
type IssuerConfigApplyConfiguration struct {
	ACME       *acmev1.ACMEIssuerApplyConfiguration `json:"acme,omitempty"`
	CA         *CAIssuerApplyConfiguration          `json:"ca,omitempty"`
	Vault      *VaultIssuerApplyConfiguration       `json:"vault,omitempty"`
	SelfSigned *SelfSignedIssuerApplyConfiguration  `json:"selfSigned,omitempty"`
	Venafi     *VenafiIssuerApplyConfiguration      `json:"venafi,omitempty"`
}

// IssuerConfigApplyConfiguration constructs a declarative configuration of the IssuerConfig type for use with
// apply.
func IssuerConfig() *IssuerConfigApplyConfiguration {
	return &IssuerConfigApplyConfiguration{}
}

// WithACME sets the ACME field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ACME field is set to the value of the last call.
func (b *IssuerConfigApplyConfiguration) WithACME(value *acmev1.ACMEIssuerApplyConfiguration) *IssuerConfigApplyConfiguration {
	b.ACME = value
	return b
}

// WithCA sets the CA field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CA field is set to the value of the last call.
func (b *IssuerConfigApplyConfiguration) WithCA(value *CAIssuerApplyConfiguration) *IssuerConfigApplyConfiguration {
	b.CA = value
	return b
}

// WithVault sets the Vault field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Vault field is set to the value of the last call.
func (b *IssuerConfigApplyConfiguration) WithVault(value *VaultIssuerApplyConfiguration) *IssuerConfigApplyConfiguration {
	b.Vault = value
	return b
}

// WithSelfSigned sets the SelfSigned field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SelfSigned field is set to the value of the last call.
func (b *IssuerConfigApplyConfiguration) WithSelfSigned(value *SelfSignedIssuerApplyConfiguration) *IssuerConfigApplyConfiguration {
	b.SelfSigned = value
	return b
}

// WithVenafi sets the Venafi field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Venafi field is set to the value of the last call.
func (b *IssuerConfigApplyConfiguration) WithVenafi(value *VenafiIssuerApplyConfiguration) *IssuerConfigApplyConfiguration {
	b.Venafi = value
	return b
}
