/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	acmev1 "github.com/cert-manager/cert-manager/pkg/apis/acme/v1"
)

// ACMEChallengeSolverDNS01ApplyConfiguration represents a declarative configuration of the ACMEChallengeSolverDNS01 type for use
// with apply.
type ACMEChallengeSolverDNS01ApplyConfiguration struct {
	CNAMEStrategy *acmev1.CNAMEStrategy                                  `json:"cnameStrategy,omitempty"`
	Akamai        *ACMEIssuerDNS01ProviderAkamaiApplyConfiguration       `json:"akamai,omitempty"`
	CloudDNS      *ACMEIssuerDNS01ProviderCloudDNSApplyConfiguration     `json:"cloudDNS,omitempty"`
	Cloudflare    *ACMEIssuerDNS01ProviderCloudflareApplyConfiguration   `json:"cloudflare,omitempty"`
	Route53       *ACMEIssuerDNS01ProviderRoute53ApplyConfiguration      `json:"route53,omitempty"`
	AzureDNS      *ACMEIssuerDNS01ProviderAzureDNSApplyConfiguration     `json:"azureDNS,omitempty"`
	DigitalOcean  *ACMEIssuerDNS01ProviderDigitalOceanApplyConfiguration `json:"digitalocean,omitempty"`
	AcmeDNS       *ACMEIssuerDNS01ProviderAcmeDNSApplyConfiguration      `json:"acmeDNS,omitempty"`
	RFC2136       *ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration      `json:"rfc2136,omitempty"`
	Webhook       *ACMEIssuerDNS01ProviderWebhookApplyConfiguration      `json:"webhook,omitempty"`
}

// ACMEChallengeSolverDNS01ApplyConfiguration constructs a declarative configuration of the ACMEChallengeSolverDNS01 type for use with
// apply.
func ACMEChallengeSolverDNS01() *ACMEChallengeSolverDNS01ApplyConfiguration {
	return &ACMEChallengeSolverDNS01ApplyConfiguration{}
}

// WithCNAMEStrategy sets the CNAMEStrategy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CNAMEStrategy field is set to the value of the last call.
func (b *ACMEChallengeSolverDNS01ApplyConfiguration) WithCNAMEStrategy(value acmev1.CNAMEStrategy) *ACMEChallengeSolverDNS01ApplyConfiguration {
	b.CNAMEStrategy = &value
	return b
}

// WithAkamai sets the Akamai field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Akamai field is set to the value of the last call.
func (b *ACMEChallengeSolverDNS01ApplyConfiguration) WithAkamai(value *ACMEIssuerDNS01ProviderAkamaiApplyConfiguration) *ACMEChallengeSolverDNS01ApplyConfiguration {
	b.Akamai = value
	return b
}

// WithCloudDNS sets the CloudDNS field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CloudDNS field is set to the value of the last call.
func (b *ACMEChallengeSolverDNS01ApplyConfiguration) WithCloudDNS(value *ACMEIssuerDNS01ProviderCloudDNSApplyConfiguration) *ACMEChallengeSolverDNS01ApplyConfiguration {
	b.CloudDNS = value
	return b
}

// WithCloudflare sets the Cloudflare field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Cloudflare field is set to the value of the last call.
func (b *ACMEChallengeSolverDNS01ApplyConfiguration) WithCloudflare(value *ACMEIssuerDNS01ProviderCloudflareApplyConfiguration) *ACMEChallengeSolverDNS01ApplyConfiguration {
	b.Cloudflare = value
	return b
}

// WithRoute53 sets the Route53 field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Route53 field is set to the value of the last call.
func (b *ACMEChallengeSolverDNS01ApplyConfiguration) WithRoute53(value *ACMEIssuerDNS01ProviderRoute53ApplyConfiguration) *ACMEChallengeSolverDNS01ApplyConfiguration {
	b.Route53 = value
	return b
}

// WithAzureDNS sets the AzureDNS field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AzureDNS field is set to the value of the last call.
func (b *ACMEChallengeSolverDNS01ApplyConfiguration) WithAzureDNS(value *ACMEIssuerDNS01ProviderAzureDNSApplyConfiguration) *ACMEChallengeSolverDNS01ApplyConfiguration {
	b.AzureDNS = value
	return b
}

// WithDigitalOcean sets the DigitalOcean field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DigitalOcean field is set to the value of the last call.
func (b *ACMEChallengeSolverDNS01ApplyConfiguration) WithDigitalOcean(value *ACMEIssuerDNS01ProviderDigitalOceanApplyConfiguration) *ACMEChallengeSolverDNS01ApplyConfiguration {
	b.DigitalOcean = value
	return b
}

// WithAcmeDNS sets the AcmeDNS field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the AcmeDNS field is set to the value of the last call.
func (b *ACMEChallengeSolverDNS01ApplyConfiguration) WithAcmeDNS(value *ACMEIssuerDNS01ProviderAcmeDNSApplyConfiguration) *ACMEChallengeSolverDNS01ApplyConfiguration {
	b.AcmeDNS = value
	return b
}

// WithRFC2136 sets the RFC2136 field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RFC2136 field is set to the value of the last call.
func (b *ACMEChallengeSolverDNS01ApplyConfiguration) WithRFC2136(value *ACMEIssuerDNS01ProviderRFC2136ApplyConfiguration) *ACMEChallengeSolverDNS01ApplyConfiguration {
	b.RFC2136 = value
	return b
}

// WithWebhook sets the Webhook field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Webhook field is set to the value of the last call.
func (b *ACMEChallengeSolverDNS01ApplyConfiguration) WithWebhook(value *ACMEIssuerDNS01ProviderWebhookApplyConfiguration) *ACMEChallengeSolverDNS01ApplyConfiguration {
	b.Webhook = value
	return b
}
