/*
 * Copyright (C) 2025 The Phosh.mobi e.V.
 *
 * SPDX-License-Identifier: GPL-3.0+
 *
 * Author: Evangelos Ribeiro Tzaras <devrtz@fortysixandtwo.eu>
 */

#include "cbd-message.h"

typedef struct _CbdMessage {
  LcbMessage      parent;

} CbdMessage;

G_DEFINE_FINAL_TYPE (CbdMessage, cbd_message, LCB_TYPE_MESSAGE);

static void
cbd_message_class_init (CbdMessageClass *klass)
{
}

static void
cbd_message_init (CbdMessage *self)
{
}


CbdMessage *
cbd_message_new (const char      *text,
                 guint            channel,
                 guint            msg_code,
                 guint            update,
                 gint64           timestamp,
                 LcbSeverityLevel severity,
                 const char      *severity_subject,
                 const char      *operator_code)
{
  return g_object_new (CBD_TYPE_MESSAGE,
                       "text", text,
                       "channel", channel,
                       "message-code", msg_code,
                       "update", update,
                       "timestamp", timestamp,
                       "severity", severity,
                       "severity-subject", severity_subject,
                       "operator-code", operator_code,
                       NULL);
}
