// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.10
// 	protoc        (unknown)
// source: buf/compiler/v1alpha1/ast.proto

package compilerv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type Path_Component_Separator int32

const (
	Path_Component_SEPARATOR_UNSPECIFIED Path_Component_Separator = 0
	Path_Component_SEPARATOR_DOT         Path_Component_Separator = 1
	Path_Component_SEPARATOR_SLASH       Path_Component_Separator = 2
)

// Enum value maps for Path_Component_Separator.
var (
	Path_Component_Separator_name = map[int32]string{
		0: "SEPARATOR_UNSPECIFIED",
		1: "SEPARATOR_DOT",
		2: "SEPARATOR_SLASH",
	}
	Path_Component_Separator_value = map[string]int32{
		"SEPARATOR_UNSPECIFIED": 0,
		"SEPARATOR_DOT":         1,
		"SEPARATOR_SLASH":       2,
	}
)

func (x Path_Component_Separator) Enum() *Path_Component_Separator {
	p := new(Path_Component_Separator)
	*p = x
	return p
}

func (x Path_Component_Separator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Path_Component_Separator) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_compiler_v1alpha1_ast_proto_enumTypes[0].Descriptor()
}

func (Path_Component_Separator) Type() protoreflect.EnumType {
	return &file_buf_compiler_v1alpha1_ast_proto_enumTypes[0]
}

func (x Path_Component_Separator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Path_Component_Separator.Descriptor instead.
func (Path_Component_Separator) EnumDescriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{2, 0, 0}
}

type Decl_Syntax_Kind int32

const (
	Decl_Syntax_KIND_UNSPECIFIED Decl_Syntax_Kind = 0
	Decl_Syntax_KIND_SYNTAX      Decl_Syntax_Kind = 1
	Decl_Syntax_KIND_EDITION     Decl_Syntax_Kind = 2
)

// Enum value maps for Decl_Syntax_Kind.
var (
	Decl_Syntax_Kind_name = map[int32]string{
		0: "KIND_UNSPECIFIED",
		1: "KIND_SYNTAX",
		2: "KIND_EDITION",
	}
	Decl_Syntax_Kind_value = map[string]int32{
		"KIND_UNSPECIFIED": 0,
		"KIND_SYNTAX":      1,
		"KIND_EDITION":     2,
	}
)

func (x Decl_Syntax_Kind) Enum() *Decl_Syntax_Kind {
	p := new(Decl_Syntax_Kind)
	*p = x
	return p
}

func (x Decl_Syntax_Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Decl_Syntax_Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_compiler_v1alpha1_ast_proto_enumTypes[1].Descriptor()
}

func (Decl_Syntax_Kind) Type() protoreflect.EnumType {
	return &file_buf_compiler_v1alpha1_ast_proto_enumTypes[1]
}

func (x Decl_Syntax_Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Decl_Syntax_Kind.Descriptor instead.
func (Decl_Syntax_Kind) EnumDescriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{3, 1, 0}
}

type Decl_Import_Modifier int32

const (
	Decl_Import_MODIFIER_UNSPECIFIED Decl_Import_Modifier = 0
	Decl_Import_MODIFIER_WEAK        Decl_Import_Modifier = 1
	Decl_Import_MODIFIER_PUBLIC      Decl_Import_Modifier = 2
)

// Enum value maps for Decl_Import_Modifier.
var (
	Decl_Import_Modifier_name = map[int32]string{
		0: "MODIFIER_UNSPECIFIED",
		1: "MODIFIER_WEAK",
		2: "MODIFIER_PUBLIC",
	}
	Decl_Import_Modifier_value = map[string]int32{
		"MODIFIER_UNSPECIFIED": 0,
		"MODIFIER_WEAK":        1,
		"MODIFIER_PUBLIC":      2,
	}
)

func (x Decl_Import_Modifier) Enum() *Decl_Import_Modifier {
	p := new(Decl_Import_Modifier)
	*p = x
	return p
}

func (x Decl_Import_Modifier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Decl_Import_Modifier) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_compiler_v1alpha1_ast_proto_enumTypes[2].Descriptor()
}

func (Decl_Import_Modifier) Type() protoreflect.EnumType {
	return &file_buf_compiler_v1alpha1_ast_proto_enumTypes[2]
}

func (x Decl_Import_Modifier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Decl_Import_Modifier.Descriptor instead.
func (Decl_Import_Modifier) EnumDescriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{3, 3, 0}
}

type Decl_Range_Kind int32

const (
	Decl_Range_KIND_UNSPECIFIED Decl_Range_Kind = 0
	Decl_Range_KIND_EXTENSIONS  Decl_Range_Kind = 1
	Decl_Range_KIND_RESERVED    Decl_Range_Kind = 2
)

// Enum value maps for Decl_Range_Kind.
var (
	Decl_Range_Kind_name = map[int32]string{
		0: "KIND_UNSPECIFIED",
		1: "KIND_EXTENSIONS",
		2: "KIND_RESERVED",
	}
	Decl_Range_Kind_value = map[string]int32{
		"KIND_UNSPECIFIED": 0,
		"KIND_EXTENSIONS":  1,
		"KIND_RESERVED":    2,
	}
)

func (x Decl_Range_Kind) Enum() *Decl_Range_Kind {
	p := new(Decl_Range_Kind)
	*p = x
	return p
}

func (x Decl_Range_Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Decl_Range_Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_compiler_v1alpha1_ast_proto_enumTypes[3].Descriptor()
}

func (Decl_Range_Kind) Type() protoreflect.EnumType {
	return &file_buf_compiler_v1alpha1_ast_proto_enumTypes[3]
}

func (x Decl_Range_Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Decl_Range_Kind.Descriptor instead.
func (Decl_Range_Kind) EnumDescriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{3, 5, 0}
}

type Def_Kind int32

const (
	Def_KIND_UNSPECIFIED Def_Kind = 0
	Def_KIND_MESSAGE     Def_Kind = 1
	Def_KIND_ENUM        Def_Kind = 2
	Def_KIND_SERVICE     Def_Kind = 3
	Def_KIND_EXTEND      Def_Kind = 4
	Def_KIND_FIELD       Def_Kind = 5
	Def_KIND_ENUM_VALUE  Def_Kind = 6
	Def_KIND_ONEOF       Def_Kind = 7
	Def_KIND_GROUP       Def_Kind = 8
	Def_KIND_METHOD      Def_Kind = 9
	Def_KIND_OPTION      Def_Kind = 10
)

// Enum value maps for Def_Kind.
var (
	Def_Kind_name = map[int32]string{
		0:  "KIND_UNSPECIFIED",
		1:  "KIND_MESSAGE",
		2:  "KIND_ENUM",
		3:  "KIND_SERVICE",
		4:  "KIND_EXTEND",
		5:  "KIND_FIELD",
		6:  "KIND_ENUM_VALUE",
		7:  "KIND_ONEOF",
		8:  "KIND_GROUP",
		9:  "KIND_METHOD",
		10: "KIND_OPTION",
	}
	Def_Kind_value = map[string]int32{
		"KIND_UNSPECIFIED": 0,
		"KIND_MESSAGE":     1,
		"KIND_ENUM":        2,
		"KIND_SERVICE":     3,
		"KIND_EXTEND":      4,
		"KIND_FIELD":       5,
		"KIND_ENUM_VALUE":  6,
		"KIND_ONEOF":       7,
		"KIND_GROUP":       8,
		"KIND_METHOD":      9,
		"KIND_OPTION":      10,
	}
)

func (x Def_Kind) Enum() *Def_Kind {
	p := new(Def_Kind)
	*p = x
	return p
}

func (x Def_Kind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Def_Kind) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_compiler_v1alpha1_ast_proto_enumTypes[4].Descriptor()
}

func (Def_Kind) Type() protoreflect.EnumType {
	return &file_buf_compiler_v1alpha1_ast_proto_enumTypes[4]
}

func (x Def_Kind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Def_Kind.Descriptor instead.
func (Def_Kind) EnumDescriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{4, 0}
}

type Expr_Prefixed_Prefix int32

const (
	Expr_Prefixed_PREFIX_UNSPECIFIED Expr_Prefixed_Prefix = 0
	Expr_Prefixed_PREFIX_MINUS       Expr_Prefixed_Prefix = 1
)

// Enum value maps for Expr_Prefixed_Prefix.
var (
	Expr_Prefixed_Prefix_name = map[int32]string{
		0: "PREFIX_UNSPECIFIED",
		1: "PREFIX_MINUS",
	}
	Expr_Prefixed_Prefix_value = map[string]int32{
		"PREFIX_UNSPECIFIED": 0,
		"PREFIX_MINUS":       1,
	}
)

func (x Expr_Prefixed_Prefix) Enum() *Expr_Prefixed_Prefix {
	p := new(Expr_Prefixed_Prefix)
	*p = x
	return p
}

func (x Expr_Prefixed_Prefix) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Expr_Prefixed_Prefix) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_compiler_v1alpha1_ast_proto_enumTypes[5].Descriptor()
}

func (Expr_Prefixed_Prefix) Type() protoreflect.EnumType {
	return &file_buf_compiler_v1alpha1_ast_proto_enumTypes[5]
}

func (x Expr_Prefixed_Prefix) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Expr_Prefixed_Prefix.Descriptor instead.
func (Expr_Prefixed_Prefix) EnumDescriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{6, 1, 0}
}

type Type_Prefixed_Prefix int32

const (
	Type_Prefixed_PREFIX_UNSPECIFIED Type_Prefixed_Prefix = 0
	Type_Prefixed_PREFIX_OPTIONAL    Type_Prefixed_Prefix = 1
	Type_Prefixed_PREFIX_REPEATED    Type_Prefixed_Prefix = 2
	Type_Prefixed_PREFIX_REQUIRED    Type_Prefixed_Prefix = 3
	Type_Prefixed_PREFIX_STREAM      Type_Prefixed_Prefix = 4
)

// Enum value maps for Type_Prefixed_Prefix.
var (
	Type_Prefixed_Prefix_name = map[int32]string{
		0: "PREFIX_UNSPECIFIED",
		1: "PREFIX_OPTIONAL",
		2: "PREFIX_REPEATED",
		3: "PREFIX_REQUIRED",
		4: "PREFIX_STREAM",
	}
	Type_Prefixed_Prefix_value = map[string]int32{
		"PREFIX_UNSPECIFIED": 0,
		"PREFIX_OPTIONAL":    1,
		"PREFIX_REPEATED":    2,
		"PREFIX_REQUIRED":    3,
		"PREFIX_STREAM":      4,
	}
)

func (x Type_Prefixed_Prefix) Enum() *Type_Prefixed_Prefix {
	p := new(Type_Prefixed_Prefix)
	*p = x
	return p
}

func (x Type_Prefixed_Prefix) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Type_Prefixed_Prefix) Descriptor() protoreflect.EnumDescriptor {
	return file_buf_compiler_v1alpha1_ast_proto_enumTypes[6].Descriptor()
}

func (Type_Prefixed_Prefix) Type() protoreflect.EnumType {
	return &file_buf_compiler_v1alpha1_ast_proto_enumTypes[6]
}

func (x Type_Prefixed_Prefix) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Type_Prefixed_Prefix.Descriptor instead.
func (Type_Prefixed_Prefix) EnumDescriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{7, 0, 0}
}

// A parsed AST file. This is the root file for the whole Protocompile AST.
type File struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The original filesystem file this file was parsed from.
	File *Report_File `protobuf:"bytes,1,opt,name=file,proto3" json:"file,omitempty"`
	// Declarations in this file.
	Decls         []*Decl `protobuf:"bytes,2,rep,name=decls,proto3" json:"decls,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *File) Reset() {
	*x = File{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *File) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*File) ProtoMessage() {}

func (x *File) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use File.ProtoReflect.Descriptor instead.
func (*File) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{0}
}

func (x *File) GetFile() *Report_File {
	if x != nil {
		return x.File
	}
	return nil
}

func (x *File) GetDecls() []*Decl {
	if x != nil {
		return x.Decls
	}
	return nil
}

// A source code span for a specific `File`.
//
// This only contains byte offsets for the span; all other information
// (such as the line number) should be re-computed as needed.
type Span struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Start         uint32                 `protobuf:"varint,1,opt,name=start,proto3" json:"start,omitempty"`
	End           uint32                 `protobuf:"varint,2,opt,name=end,proto3" json:"end,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Span) Reset() {
	*x = Span{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Span) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span) ProtoMessage() {}

func (x *Span) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span.ProtoReflect.Descriptor instead.
func (*Span) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{1}
}

func (x *Span) GetStart() uint32 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *Span) GetEnd() uint32 {
	if x != nil {
		return x.End
	}
	return 0
}

// A path in a Protobuf file. This models all identifiers (simple, compound,
// and fully-qualified). It also models option names, which contain nested
// paths, and Any URLs, which contain a single slash.
//
// To do so, it models the maximal union of these syntax constructs, permitting
// arbitrary nesting and mixed . and / separators. Many paths representable with
// this message do not correspond to valid Protobuf syntax, but they are
// accepted by the parser.
type Path struct {
	state      protoimpl.MessageState `protogen:"open.v1"`
	Components []*Path_Component      `protobuf:"bytes,1,rep,name=components,proto3" json:"components,omitempty"`
	// The span for the whole path.
	Span          *Span `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Path) Reset() {
	*x = Path{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Path) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Path) ProtoMessage() {}

func (x *Path) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Path.ProtoReflect.Descriptor instead.
func (*Path) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{2}
}

func (x *Path) GetComponents() []*Path_Component {
	if x != nil {
		return x.Components
	}
	return nil
}

func (x *Path) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

// A declaration in a Protobuf file.
type Decl struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Decl:
	//
	//	*Decl_Empty_
	//	*Decl_Syntax_
	//	*Decl_Import_
	//	*Decl_Package_
	//	*Decl_Def
	//	*Decl_Body_
	//	*Decl_Range_
	Decl          isDecl_Decl `protobuf_oneof:"decl"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Decl) Reset() {
	*x = Decl{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Decl) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Decl) ProtoMessage() {}

func (x *Decl) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Decl.ProtoReflect.Descriptor instead.
func (*Decl) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{3}
}

func (x *Decl) GetDecl() isDecl_Decl {
	if x != nil {
		return x.Decl
	}
	return nil
}

func (x *Decl) GetEmpty() *Decl_Empty {
	if x != nil {
		if x, ok := x.Decl.(*Decl_Empty_); ok {
			return x.Empty
		}
	}
	return nil
}

func (x *Decl) GetSyntax() *Decl_Syntax {
	if x != nil {
		if x, ok := x.Decl.(*Decl_Syntax_); ok {
			return x.Syntax
		}
	}
	return nil
}

func (x *Decl) GetImport() *Decl_Import {
	if x != nil {
		if x, ok := x.Decl.(*Decl_Import_); ok {
			return x.Import
		}
	}
	return nil
}

func (x *Decl) GetPackage() *Decl_Package {
	if x != nil {
		if x, ok := x.Decl.(*Decl_Package_); ok {
			return x.Package
		}
	}
	return nil
}

func (x *Decl) GetDef() *Def {
	if x != nil {
		if x, ok := x.Decl.(*Decl_Def); ok {
			return x.Def
		}
	}
	return nil
}

func (x *Decl) GetBody() *Decl_Body {
	if x != nil {
		if x, ok := x.Decl.(*Decl_Body_); ok {
			return x.Body
		}
	}
	return nil
}

func (x *Decl) GetRange() *Decl_Range {
	if x != nil {
		if x, ok := x.Decl.(*Decl_Range_); ok {
			return x.Range
		}
	}
	return nil
}

type isDecl_Decl interface {
	isDecl_Decl()
}

type Decl_Empty_ struct {
	Empty *Decl_Empty `protobuf:"bytes,1,opt,name=empty,proto3,oneof"`
}

type Decl_Syntax_ struct {
	Syntax *Decl_Syntax `protobuf:"bytes,2,opt,name=syntax,proto3,oneof"`
}

type Decl_Import_ struct {
	Import *Decl_Import `protobuf:"bytes,3,opt,name=import,proto3,oneof"`
}

type Decl_Package_ struct {
	Package *Decl_Package `protobuf:"bytes,4,opt,name=package,proto3,oneof"`
}

type Decl_Def struct {
	Def *Def `protobuf:"bytes,5,opt,name=def,proto3,oneof"`
}

type Decl_Body_ struct {
	Body *Decl_Body `protobuf:"bytes,6,opt,name=body,proto3,oneof"`
}

type Decl_Range_ struct {
	Range *Decl_Range `protobuf:"bytes,7,opt,name=range,proto3,oneof"`
}

func (*Decl_Empty_) isDecl_Decl() {}

func (*Decl_Syntax_) isDecl_Decl() {}

func (*Decl_Import_) isDecl_Decl() {}

func (*Decl_Package_) isDecl_Decl() {}

func (*Decl_Def) isDecl_Decl() {}

func (*Decl_Body_) isDecl_Decl() {}

func (*Decl_Range_) isDecl_Decl() {}

// A definition is a particular kind of declaration that combines the syntactic
// elements of type definitions, fields, options, and service methods.
//
// This allows the parser to accept and represent many invalid but plausible productions.
type Def struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Definitions without a clear kind may be marked as `KIND_UNSPECIFIED`.
	Kind Def_Kind `protobuf:"varint,1,opt,name=kind,proto3,enum=buf.compiler.v1alpha1.Def_Kind" json:"kind,omitempty"`
	Name *Path    `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The type for a `KIND_FIELD` definition.
	Type      *Type          `protobuf:"bytes,3,opt,name=type,proto3" json:"type,omitempty"`
	Signature *Def_Signature `protobuf:"bytes,4,opt,name=signature,proto3" json:"signature,omitempty"`
	// This is the tag number of `KIND_FIELD` or `KIND_ENUM_VALUE,
	// or the value of `KIND_OPTION`.
	Value *Expr `protobuf:"bytes,5,opt,name=value,proto3" json:"value,omitempty"`
	// This is options appearing in `[...]`, such as on `KIND_FIELD`
	// or `KIND_GROUP`. This will NOT include options on a oneof, since
	// those are represented as `KIND_OPTION` `Def` in `body`.
	Options *Options `protobuf:"bytes,6,opt,name=options,proto3" json:"options,omitempty"`
	// This is a braced body at the end of the definition.
	Body          *Decl_Body `protobuf:"bytes,7,opt,name=body,proto3" json:"body,omitempty"`
	Span          *Span      `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	KeywordSpan   *Span      `protobuf:"bytes,11,opt,name=keyword_span,json=keywordSpan,proto3" json:"keyword_span,omitempty"`
	EqualsSpan    *Span      `protobuf:"bytes,12,opt,name=equals_span,json=equalsSpan,proto3" json:"equals_span,omitempty"`
	SemicolonSpan *Span      `protobuf:"bytes,13,opt,name=semicolon_span,json=semicolonSpan,proto3" json:"semicolon_span,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Def) Reset() {
	*x = Def{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Def) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Def) ProtoMessage() {}

func (x *Def) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Def.ProtoReflect.Descriptor instead.
func (*Def) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{4}
}

func (x *Def) GetKind() Def_Kind {
	if x != nil {
		return x.Kind
	}
	return Def_KIND_UNSPECIFIED
}

func (x *Def) GetName() *Path {
	if x != nil {
		return x.Name
	}
	return nil
}

func (x *Def) GetType() *Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Def) GetSignature() *Def_Signature {
	if x != nil {
		return x.Signature
	}
	return nil
}

func (x *Def) GetValue() *Expr {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Def) GetOptions() *Options {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *Def) GetBody() *Decl_Body {
	if x != nil {
		return x.Body
	}
	return nil
}

func (x *Def) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

func (x *Def) GetKeywordSpan() *Span {
	if x != nil {
		return x.KeywordSpan
	}
	return nil
}

func (x *Def) GetEqualsSpan() *Span {
	if x != nil {
		return x.EqualsSpan
	}
	return nil
}

func (x *Def) GetSemicolonSpan() *Span {
	if x != nil {
		return x.SemicolonSpan
	}
	return nil
}

// Compact options after a declaration, in `[...]`.
type Options struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Entries       []*Options_Entry       `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	Span          *Span                  `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Options) Reset() {
	*x = Options{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Options) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Options) ProtoMessage() {}

func (x *Options) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Options.ProtoReflect.Descriptor instead.
func (*Options) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{5}
}

func (x *Options) GetEntries() []*Options_Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

func (x *Options) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

// An expression, such as the value of an option or the tag of a field.
type Expr struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Expr:
	//
	//	*Expr_Literal_
	//	*Expr_Path
	//	*Expr_Prefixed_
	//	*Expr_Range_
	//	*Expr_Array_
	//	*Expr_Dict_
	//	*Expr_Field_
	Expr          isExpr_Expr `protobuf_oneof:"expr"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Expr) Reset() {
	*x = Expr{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Expr) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expr) ProtoMessage() {}

func (x *Expr) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expr.ProtoReflect.Descriptor instead.
func (*Expr) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{6}
}

func (x *Expr) GetExpr() isExpr_Expr {
	if x != nil {
		return x.Expr
	}
	return nil
}

func (x *Expr) GetLiteral() *Expr_Literal {
	if x != nil {
		if x, ok := x.Expr.(*Expr_Literal_); ok {
			return x.Literal
		}
	}
	return nil
}

func (x *Expr) GetPath() *Path {
	if x != nil {
		if x, ok := x.Expr.(*Expr_Path); ok {
			return x.Path
		}
	}
	return nil
}

func (x *Expr) GetPrefixed() *Expr_Prefixed {
	if x != nil {
		if x, ok := x.Expr.(*Expr_Prefixed_); ok {
			return x.Prefixed
		}
	}
	return nil
}

func (x *Expr) GetRange() *Expr_Range {
	if x != nil {
		if x, ok := x.Expr.(*Expr_Range_); ok {
			return x.Range
		}
	}
	return nil
}

func (x *Expr) GetArray() *Expr_Array {
	if x != nil {
		if x, ok := x.Expr.(*Expr_Array_); ok {
			return x.Array
		}
	}
	return nil
}

func (x *Expr) GetDict() *Expr_Dict {
	if x != nil {
		if x, ok := x.Expr.(*Expr_Dict_); ok {
			return x.Dict
		}
	}
	return nil
}

func (x *Expr) GetField() *Expr_Field {
	if x != nil {
		if x, ok := x.Expr.(*Expr_Field_); ok {
			return x.Field
		}
	}
	return nil
}

type isExpr_Expr interface {
	isExpr_Expr()
}

type Expr_Literal_ struct {
	Literal *Expr_Literal `protobuf:"bytes,1,opt,name=literal,proto3,oneof"`
}

type Expr_Path struct {
	Path *Path `protobuf:"bytes,2,opt,name=path,proto3,oneof"`
}

type Expr_Prefixed_ struct {
	Prefixed *Expr_Prefixed `protobuf:"bytes,3,opt,name=prefixed,proto3,oneof"`
}

type Expr_Range_ struct {
	Range *Expr_Range `protobuf:"bytes,4,opt,name=range,proto3,oneof"`
}

type Expr_Array_ struct {
	Array *Expr_Array `protobuf:"bytes,5,opt,name=array,proto3,oneof"`
}

type Expr_Dict_ struct {
	Dict *Expr_Dict `protobuf:"bytes,6,opt,name=dict,proto3,oneof"`
}

type Expr_Field_ struct {
	Field *Expr_Field `protobuf:"bytes,7,opt,name=field,proto3,oneof"`
}

func (*Expr_Literal_) isExpr_Expr() {}

func (*Expr_Path) isExpr_Expr() {}

func (*Expr_Prefixed_) isExpr_Expr() {}

func (*Expr_Range_) isExpr_Expr() {}

func (*Expr_Array_) isExpr_Expr() {}

func (*Expr_Dict_) isExpr_Expr() {}

func (*Expr_Field_) isExpr_Expr() {}

// A type, such as the prefix of a field.
//
// This AST includes many types not present in ordinary Protobuf, such as representations
// for `repeated repeated int32` and `Arbitrary<int32>`, among others.
type Type struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Type:
	//
	//	*Type_Path
	//	*Type_Prefixed_
	//	*Type_Generic_
	Type          isType_Type `protobuf_oneof:"type"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Type) Reset() {
	*x = Type{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type) ProtoMessage() {}

func (x *Type) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type.ProtoReflect.Descriptor instead.
func (*Type) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{7}
}

func (x *Type) GetType() isType_Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Type) GetPath() *Path {
	if x != nil {
		if x, ok := x.Type.(*Type_Path); ok {
			return x.Path
		}
	}
	return nil
}

func (x *Type) GetPrefixed() *Type_Prefixed {
	if x != nil {
		if x, ok := x.Type.(*Type_Prefixed_); ok {
			return x.Prefixed
		}
	}
	return nil
}

func (x *Type) GetGeneric() *Type_Generic {
	if x != nil {
		if x, ok := x.Type.(*Type_Generic_); ok {
			return x.Generic
		}
	}
	return nil
}

type isType_Type interface {
	isType_Type()
}

type Type_Path struct {
	Path *Path `protobuf:"bytes,1,opt,name=path,proto3,oneof"`
}

type Type_Prefixed_ struct {
	Prefixed *Type_Prefixed `protobuf:"bytes,2,opt,name=prefixed,proto3,oneof"`
}

type Type_Generic_ struct {
	Generic *Type_Generic `protobuf:"bytes,3,opt,name=generic,proto3,oneof"`
}

func (*Type_Path) isType_Type() {}

func (*Type_Prefixed_) isType_Type() {}

func (*Type_Generic_) isType_Type() {}

// A path component.
type Path_Component struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// May be missing altogether, for invalid paths like `foo..bar`.
	//
	// Types that are valid to be assigned to Component:
	//
	//	*Path_Component_Ident
	//	*Path_Component_Extension
	Component isPath_Component_Component `protobuf_oneof:"component"`
	// The type of separator this component had before it.
	// If this is SEPARATOR_UNSPECIFIED, this is the first
	// component, and the path is not absolute.
	Separator Path_Component_Separator `protobuf:"varint,3,opt,name=separator,proto3,enum=buf.compiler.v1alpha1.Path_Component_Separator" json:"separator,omitempty"`
	// The span of the component's value.
	ComponentSpan *Span `protobuf:"bytes,10,opt,name=component_span,json=componentSpan,proto3" json:"component_span,omitempty"`
	// The span of this component's leading dot, if any.
	SeparatorSpan *Span `protobuf:"bytes,11,opt,name=separator_span,json=separatorSpan,proto3" json:"separator_span,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Path_Component) Reset() {
	*x = Path_Component{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Path_Component) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Path_Component) ProtoMessage() {}

func (x *Path_Component) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Path_Component.ProtoReflect.Descriptor instead.
func (*Path_Component) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{2, 0}
}

func (x *Path_Component) GetComponent() isPath_Component_Component {
	if x != nil {
		return x.Component
	}
	return nil
}

func (x *Path_Component) GetIdent() string {
	if x != nil {
		if x, ok := x.Component.(*Path_Component_Ident); ok {
			return x.Ident
		}
	}
	return ""
}

func (x *Path_Component) GetExtension() *Path {
	if x != nil {
		if x, ok := x.Component.(*Path_Component_Extension); ok {
			return x.Extension
		}
	}
	return nil
}

func (x *Path_Component) GetSeparator() Path_Component_Separator {
	if x != nil {
		return x.Separator
	}
	return Path_Component_SEPARATOR_UNSPECIFIED
}

func (x *Path_Component) GetComponentSpan() *Span {
	if x != nil {
		return x.ComponentSpan
	}
	return nil
}

func (x *Path_Component) GetSeparatorSpan() *Span {
	if x != nil {
		return x.SeparatorSpan
	}
	return nil
}

type isPath_Component_Component interface {
	isPath_Component_Component()
}

type Path_Component_Ident struct {
	// A single identifier.
	Ident string `protobuf:"bytes,1,opt,name=ident,proto3,oneof"`
}

type Path_Component_Extension struct {
	// A nested extension path.
	Extension *Path `protobuf:"bytes,2,opt,name=extension,proto3,oneof"`
}

func (*Path_Component_Ident) isPath_Component_Component() {}

func (*Path_Component_Extension) isPath_Component_Component() {}

// An empty declaration.
type Decl_Empty struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Span          *Span                  `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Decl_Empty) Reset() {
	*x = Decl_Empty{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Decl_Empty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Decl_Empty) ProtoMessage() {}

func (x *Decl_Empty) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Decl_Empty.ProtoReflect.Descriptor instead.
func (*Decl_Empty) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{3, 0}
}

func (x *Decl_Empty) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

// A language pragma, such as a syntax or edition declaration.
type Decl_Syntax struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Kind          Decl_Syntax_Kind       `protobuf:"varint,1,opt,name=kind,proto3,enum=buf.compiler.v1alpha1.Decl_Syntax_Kind" json:"kind,omitempty"`
	Value         *Expr                  `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	Options       *Options               `protobuf:"bytes,3,opt,name=options,proto3" json:"options,omitempty"`
	Span          *Span                  `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	KeywordSpan   *Span                  `protobuf:"bytes,11,opt,name=keyword_span,json=keywordSpan,proto3" json:"keyword_span,omitempty"`
	EqualsSpan    *Span                  `protobuf:"bytes,12,opt,name=equals_span,json=equalsSpan,proto3" json:"equals_span,omitempty"`
	SemicolonSpan *Span                  `protobuf:"bytes,13,opt,name=semicolon_span,json=semicolonSpan,proto3" json:"semicolon_span,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Decl_Syntax) Reset() {
	*x = Decl_Syntax{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Decl_Syntax) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Decl_Syntax) ProtoMessage() {}

func (x *Decl_Syntax) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Decl_Syntax.ProtoReflect.Descriptor instead.
func (*Decl_Syntax) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{3, 1}
}

func (x *Decl_Syntax) GetKind() Decl_Syntax_Kind {
	if x != nil {
		return x.Kind
	}
	return Decl_Syntax_KIND_UNSPECIFIED
}

func (x *Decl_Syntax) GetValue() *Expr {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Decl_Syntax) GetOptions() *Options {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *Decl_Syntax) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

func (x *Decl_Syntax) GetKeywordSpan() *Span {
	if x != nil {
		return x.KeywordSpan
	}
	return nil
}

func (x *Decl_Syntax) GetEqualsSpan() *Span {
	if x != nil {
		return x.EqualsSpan
	}
	return nil
}

func (x *Decl_Syntax) GetSemicolonSpan() *Span {
	if x != nil {
		return x.SemicolonSpan
	}
	return nil
}

// A package declaration.
type Decl_Package struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Path          *Path                  `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Options       *Options               `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
	Span          *Span                  `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	KeywordSpan   *Span                  `protobuf:"bytes,11,opt,name=keyword_span,json=keywordSpan,proto3" json:"keyword_span,omitempty"`
	SemicolonSpan *Span                  `protobuf:"bytes,12,opt,name=semicolon_span,json=semicolonSpan,proto3" json:"semicolon_span,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Decl_Package) Reset() {
	*x = Decl_Package{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Decl_Package) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Decl_Package) ProtoMessage() {}

func (x *Decl_Package) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Decl_Package.ProtoReflect.Descriptor instead.
func (*Decl_Package) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{3, 2}
}

func (x *Decl_Package) GetPath() *Path {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *Decl_Package) GetOptions() *Options {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *Decl_Package) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

func (x *Decl_Package) GetKeywordSpan() *Span {
	if x != nil {
		return x.KeywordSpan
	}
	return nil
}

func (x *Decl_Package) GetSemicolonSpan() *Span {
	if x != nil {
		return x.SemicolonSpan
	}
	return nil
}

// An import declaration.
type Decl_Import struct {
	state          protoimpl.MessageState `protogen:"open.v1"`
	Modifier       []Decl_Import_Modifier `protobuf:"varint,1,rep,packed,name=modifier,proto3,enum=buf.compiler.v1alpha1.Decl_Import_Modifier" json:"modifier,omitempty"`
	ImportPath     *Expr                  `protobuf:"bytes,2,opt,name=import_path,json=importPath,proto3" json:"import_path,omitempty"`
	Options        *Options               `protobuf:"bytes,3,opt,name=options,proto3" json:"options,omitempty"`
	Span           *Span                  `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	KeywordSpan    *Span                  `protobuf:"bytes,11,opt,name=keyword_span,json=keywordSpan,proto3" json:"keyword_span,omitempty"`
	ModifierSpan   []*Span                `protobuf:"bytes,12,rep,name=modifier_span,json=modifierSpan,proto3" json:"modifier_span,omitempty"`
	ImportPathSpan *Span                  `protobuf:"bytes,13,opt,name=import_path_span,json=importPathSpan,proto3" json:"import_path_span,omitempty"`
	SemicolonSpan  *Span                  `protobuf:"bytes,14,opt,name=semicolon_span,json=semicolonSpan,proto3" json:"semicolon_span,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *Decl_Import) Reset() {
	*x = Decl_Import{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Decl_Import) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Decl_Import) ProtoMessage() {}

func (x *Decl_Import) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Decl_Import.ProtoReflect.Descriptor instead.
func (*Decl_Import) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{3, 3}
}

func (x *Decl_Import) GetModifier() []Decl_Import_Modifier {
	if x != nil {
		return x.Modifier
	}
	return nil
}

func (x *Decl_Import) GetImportPath() *Expr {
	if x != nil {
		return x.ImportPath
	}
	return nil
}

func (x *Decl_Import) GetOptions() *Options {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *Decl_Import) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

func (x *Decl_Import) GetKeywordSpan() *Span {
	if x != nil {
		return x.KeywordSpan
	}
	return nil
}

func (x *Decl_Import) GetModifierSpan() []*Span {
	if x != nil {
		return x.ModifierSpan
	}
	return nil
}

func (x *Decl_Import) GetImportPathSpan() *Span {
	if x != nil {
		return x.ImportPathSpan
	}
	return nil
}

func (x *Decl_Import) GetSemicolonSpan() *Span {
	if x != nil {
		return x.SemicolonSpan
	}
	return nil
}

// The body of a message, enum, or similar declaration, which
// itself contains declarations.
type Decl_Body struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Decls         []*Decl                `protobuf:"bytes,1,rep,name=decls,proto3" json:"decls,omitempty"`
	Span          *Span                  `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Decl_Body) Reset() {
	*x = Decl_Body{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Decl_Body) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Decl_Body) ProtoMessage() {}

func (x *Decl_Body) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Decl_Body.ProtoReflect.Descriptor instead.
func (*Decl_Body) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{3, 4}
}

func (x *Decl_Body) GetDecls() []*Decl {
	if x != nil {
		return x.Decls
	}
	return nil
}

func (x *Decl_Body) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

// An extensions or reserved range within a message. Both productions are
// extremely similar, so they share an AST node.
type Decl_Range struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Kind          Decl_Range_Kind        `protobuf:"varint,1,opt,name=kind,proto3,enum=buf.compiler.v1alpha1.Decl_Range_Kind" json:"kind,omitempty"`
	Ranges        []*Expr                `protobuf:"bytes,2,rep,name=ranges,proto3" json:"ranges,omitempty"`
	Options       *Options               `protobuf:"bytes,3,opt,name=options,proto3" json:"options,omitempty"`
	Span          *Span                  `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	KeywordSpan   *Span                  `protobuf:"bytes,11,opt,name=keyword_span,json=keywordSpan,proto3" json:"keyword_span,omitempty"`
	SemicolonSpan *Span                  `protobuf:"bytes,12,opt,name=semicolon_span,json=semicolonSpan,proto3" json:"semicolon_span,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Decl_Range) Reset() {
	*x = Decl_Range{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Decl_Range) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Decl_Range) ProtoMessage() {}

func (x *Decl_Range) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Decl_Range.ProtoReflect.Descriptor instead.
func (*Decl_Range) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{3, 5}
}

func (x *Decl_Range) GetKind() Decl_Range_Kind {
	if x != nil {
		return x.Kind
	}
	return Decl_Range_KIND_UNSPECIFIED
}

func (x *Decl_Range) GetRanges() []*Expr {
	if x != nil {
		return x.Ranges
	}
	return nil
}

func (x *Decl_Range) GetOptions() *Options {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *Decl_Range) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

func (x *Decl_Range) GetKeywordSpan() *Span {
	if x != nil {
		return x.KeywordSpan
	}
	return nil
}

func (x *Decl_Range) GetSemicolonSpan() *Span {
	if x != nil {
		return x.SemicolonSpan
	}
	return nil
}

// A method signature. This appears on `KIND_METHOD`, for example.
type Def_Signature struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Inputs        []*Type                `protobuf:"bytes,1,rep,name=inputs,proto3" json:"inputs,omitempty"`
	Outputs       []*Type                `protobuf:"bytes,2,rep,name=outputs,proto3" json:"outputs,omitempty"`
	Span          *Span                  `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	InputSpan     *Span                  `protobuf:"bytes,11,opt,name=input_span,json=inputSpan,proto3" json:"input_span,omitempty"`
	ReturnsSpan   *Span                  `protobuf:"bytes,12,opt,name=returns_span,json=returnsSpan,proto3" json:"returns_span,omitempty"`
	OutputSpan    *Span                  `protobuf:"bytes,13,opt,name=output_span,json=outputSpan,proto3" json:"output_span,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Def_Signature) Reset() {
	*x = Def_Signature{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Def_Signature) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Def_Signature) ProtoMessage() {}

func (x *Def_Signature) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Def_Signature.ProtoReflect.Descriptor instead.
func (*Def_Signature) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{4, 0}
}

func (x *Def_Signature) GetInputs() []*Type {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *Def_Signature) GetOutputs() []*Type {
	if x != nil {
		return x.Outputs
	}
	return nil
}

func (x *Def_Signature) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

func (x *Def_Signature) GetInputSpan() *Span {
	if x != nil {
		return x.InputSpan
	}
	return nil
}

func (x *Def_Signature) GetReturnsSpan() *Span {
	if x != nil {
		return x.ReturnsSpan
	}
	return nil
}

func (x *Def_Signature) GetOutputSpan() *Span {
	if x != nil {
		return x.OutputSpan
	}
	return nil
}

type Options_Entry struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Path          *Path                  `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Value         *Expr                  `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	EqualsSpan    *Span                  `protobuf:"bytes,10,opt,name=equals_span,json=equalsSpan,proto3" json:"equals_span,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Options_Entry) Reset() {
	*x = Options_Entry{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Options_Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Options_Entry) ProtoMessage() {}

func (x *Options_Entry) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Options_Entry.ProtoReflect.Descriptor instead.
func (*Options_Entry) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{5, 0}
}

func (x *Options_Entry) GetPath() *Path {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *Options_Entry) GetValue() *Expr {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Options_Entry) GetEqualsSpan() *Span {
	if x != nil {
		return x.EqualsSpan
	}
	return nil
}

// A literal value: a number or a string.
type Expr_Literal struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// None of these may be set, in the case of an integer with an invalid or
	// out-of-range format.
	//
	// Types that are valid to be assigned to Value:
	//
	//	*Expr_Literal_IntValue
	//	*Expr_Literal_FloatValue
	//	*Expr_Literal_StringValue
	Value         isExpr_Literal_Value `protobuf_oneof:"value"`
	Span          *Span                `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Expr_Literal) Reset() {
	*x = Expr_Literal{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Expr_Literal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expr_Literal) ProtoMessage() {}

func (x *Expr_Literal) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expr_Literal.ProtoReflect.Descriptor instead.
func (*Expr_Literal) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{6, 0}
}

func (x *Expr_Literal) GetValue() isExpr_Literal_Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Expr_Literal) GetIntValue() uint64 {
	if x != nil {
		if x, ok := x.Value.(*Expr_Literal_IntValue); ok {
			return x.IntValue
		}
	}
	return 0
}

func (x *Expr_Literal) GetFloatValue() float64 {
	if x != nil {
		if x, ok := x.Value.(*Expr_Literal_FloatValue); ok {
			return x.FloatValue
		}
	}
	return 0
}

func (x *Expr_Literal) GetStringValue() string {
	if x != nil {
		if x, ok := x.Value.(*Expr_Literal_StringValue); ok {
			return x.StringValue
		}
	}
	return ""
}

func (x *Expr_Literal) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

type isExpr_Literal_Value interface {
	isExpr_Literal_Value()
}

type Expr_Literal_IntValue struct {
	IntValue uint64 `protobuf:"varint,1,opt,name=int_value,json=intValue,proto3,oneof"`
}

type Expr_Literal_FloatValue struct {
	FloatValue float64 `protobuf:"fixed64,2,opt,name=float_value,json=floatValue,proto3,oneof"`
}

type Expr_Literal_StringValue struct {
	StringValue string `protobuf:"bytes,3,opt,name=string_value,json=stringValue,proto3,oneof"`
}

func (*Expr_Literal_IntValue) isExpr_Literal_Value() {}

func (*Expr_Literal_FloatValue) isExpr_Literal_Value() {}

func (*Expr_Literal_StringValue) isExpr_Literal_Value() {}

// An expression with some kind of prefix, such as a minus sign.
type Expr_Prefixed struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Prefix        Expr_Prefixed_Prefix   `protobuf:"varint,1,opt,name=prefix,proto3,enum=buf.compiler.v1alpha1.Expr_Prefixed_Prefix" json:"prefix,omitempty"`
	Expr          *Expr                  `protobuf:"bytes,2,opt,name=expr,proto3" json:"expr,omitempty"`
	Span          *Span                  `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	PrefixSpan    *Span                  `protobuf:"bytes,11,opt,name=prefix_span,json=prefixSpan,proto3" json:"prefix_span,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Expr_Prefixed) Reset() {
	*x = Expr_Prefixed{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Expr_Prefixed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expr_Prefixed) ProtoMessage() {}

func (x *Expr_Prefixed) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expr_Prefixed.ProtoReflect.Descriptor instead.
func (*Expr_Prefixed) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{6, 1}
}

func (x *Expr_Prefixed) GetPrefix() Expr_Prefixed_Prefix {
	if x != nil {
		return x.Prefix
	}
	return Expr_Prefixed_PREFIX_UNSPECIFIED
}

func (x *Expr_Prefixed) GetExpr() *Expr {
	if x != nil {
		return x.Expr
	}
	return nil
}

func (x *Expr_Prefixed) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

func (x *Expr_Prefixed) GetPrefixSpan() *Span {
	if x != nil {
		return x.PrefixSpan
	}
	return nil
}

// A range expression, i.e. something like `1 to 10`. `1 to max` is not
// special syntax; `max` is realized as a path expression.
//
// Ranges are inclusive.
type Expr_Range struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Start         *Expr                  `protobuf:"bytes,1,opt,name=start,proto3" json:"start,omitempty"`
	End           *Expr                  `protobuf:"bytes,2,opt,name=end,proto3" json:"end,omitempty"`
	Span          *Span                  `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	ToSpan        *Span                  `protobuf:"bytes,11,opt,name=to_span,json=toSpan,proto3" json:"to_span,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Expr_Range) Reset() {
	*x = Expr_Range{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Expr_Range) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expr_Range) ProtoMessage() {}

func (x *Expr_Range) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expr_Range.ProtoReflect.Descriptor instead.
func (*Expr_Range) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{6, 2}
}

func (x *Expr_Range) GetStart() *Expr {
	if x != nil {
		return x.Start
	}
	return nil
}

func (x *Expr_Range) GetEnd() *Expr {
	if x != nil {
		return x.End
	}
	return nil
}

func (x *Expr_Range) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

func (x *Expr_Range) GetToSpan() *Span {
	if x != nil {
		return x.ToSpan
	}
	return nil
}

// An array literal, a sequence of expressions bound by square brackets.
type Expr_Array struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Elements      []*Expr                `protobuf:"bytes,1,rep,name=elements,proto3" json:"elements,omitempty"`
	Span          *Span                  `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	OpenSpan      *Span                  `protobuf:"bytes,11,opt,name=open_span,json=openSpan,proto3" json:"open_span,omitempty"`
	CloseSpan     *Span                  `protobuf:"bytes,12,opt,name=close_span,json=closeSpan,proto3" json:"close_span,omitempty"`
	CommaSpans    []*Span                `protobuf:"bytes,13,rep,name=comma_spans,json=commaSpans,proto3" json:"comma_spans,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Expr_Array) Reset() {
	*x = Expr_Array{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Expr_Array) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expr_Array) ProtoMessage() {}

func (x *Expr_Array) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expr_Array.ProtoReflect.Descriptor instead.
func (*Expr_Array) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{6, 3}
}

func (x *Expr_Array) GetElements() []*Expr {
	if x != nil {
		return x.Elements
	}
	return nil
}

func (x *Expr_Array) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

func (x *Expr_Array) GetOpenSpan() *Span {
	if x != nil {
		return x.OpenSpan
	}
	return nil
}

func (x *Expr_Array) GetCloseSpan() *Span {
	if x != nil {
		return x.CloseSpan
	}
	return nil
}

func (x *Expr_Array) GetCommaSpans() []*Span {
	if x != nil {
		return x.CommaSpans
	}
	return nil
}

// A dictionary literal, a sequence of key-value pairs bound by curly braces.
type Expr_Dict struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Entries       []*Expr_Field          `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	Span          *Span                  `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	OpenSpan      *Span                  `protobuf:"bytes,11,opt,name=open_span,json=openSpan,proto3" json:"open_span,omitempty"`
	CloseSpan     *Span                  `protobuf:"bytes,12,opt,name=close_span,json=closeSpan,proto3" json:"close_span,omitempty"`
	CommaSpans    []*Span                `protobuf:"bytes,13,rep,name=comma_spans,json=commaSpans,proto3" json:"comma_spans,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Expr_Dict) Reset() {
	*x = Expr_Dict{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Expr_Dict) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expr_Dict) ProtoMessage() {}

func (x *Expr_Dict) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expr_Dict.ProtoReflect.Descriptor instead.
func (*Expr_Dict) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{6, 4}
}

func (x *Expr_Dict) GetEntries() []*Expr_Field {
	if x != nil {
		return x.Entries
	}
	return nil
}

func (x *Expr_Dict) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

func (x *Expr_Dict) GetOpenSpan() *Span {
	if x != nil {
		return x.OpenSpan
	}
	return nil
}

func (x *Expr_Dict) GetCloseSpan() *Span {
	if x != nil {
		return x.CloseSpan
	}
	return nil
}

func (x *Expr_Dict) GetCommaSpans() []*Span {
	if x != nil {
		return x.CommaSpans
	}
	return nil
}

// A key-value pair expression, which usually will appear inside of an
// `Expr.Dict`.
type Expr_Field struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Key           *Expr                  `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value         *Expr                  `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	Span          *Span                  `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	ColonSpan     *Span                  `protobuf:"bytes,11,opt,name=colon_span,json=colonSpan,proto3" json:"colon_span,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Expr_Field) Reset() {
	*x = Expr_Field{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Expr_Field) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Expr_Field) ProtoMessage() {}

func (x *Expr_Field) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Expr_Field.ProtoReflect.Descriptor instead.
func (*Expr_Field) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{6, 5}
}

func (x *Expr_Field) GetKey() *Expr {
	if x != nil {
		return x.Key
	}
	return nil
}

func (x *Expr_Field) GetValue() *Expr {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *Expr_Field) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

func (x *Expr_Field) GetColonSpan() *Span {
	if x != nil {
		return x.ColonSpan
	}
	return nil
}

// A type with a modifier prefix in front of it, such as `repeated` or `stream`.
type Type_Prefixed struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Prefix        Type_Prefixed_Prefix   `protobuf:"varint,1,opt,name=prefix,proto3,enum=buf.compiler.v1alpha1.Type_Prefixed_Prefix" json:"prefix,omitempty"`
	Type          *Type                  `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	Span          *Span                  `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	PrefixSpan    *Span                  `protobuf:"bytes,11,opt,name=prefix_span,json=prefixSpan,proto3" json:"prefix_span,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Type_Prefixed) Reset() {
	*x = Type_Prefixed{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Prefixed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Prefixed) ProtoMessage() {}

func (x *Type_Prefixed) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Prefixed.ProtoReflect.Descriptor instead.
func (*Type_Prefixed) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{7, 0}
}

func (x *Type_Prefixed) GetPrefix() Type_Prefixed_Prefix {
	if x != nil {
		return x.Prefix
	}
	return Type_Prefixed_PREFIX_UNSPECIFIED
}

func (x *Type_Prefixed) GetType() *Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Type_Prefixed) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

func (x *Type_Prefixed) GetPrefixSpan() *Span {
	if x != nil {
		return x.PrefixSpan
	}
	return nil
}

// A type with generic arguments, such as `map<string, int32>`.
//
// Note that no other generic types are part of Protobuf, but we support arbitrary generic
// types since it is a more natural way to define the AST.
type Type_Generic struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Path          *Path                  `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	Args          []*Type                `protobuf:"bytes,2,rep,name=args,proto3" json:"args,omitempty"`
	Span          *Span                  `protobuf:"bytes,10,opt,name=span,proto3" json:"span,omitempty"`
	OpenSpan      *Span                  `protobuf:"bytes,11,opt,name=open_span,json=openSpan,proto3" json:"open_span,omitempty"`
	CloseSpan     *Span                  `protobuf:"bytes,12,opt,name=close_span,json=closeSpan,proto3" json:"close_span,omitempty"`
	CommaSpans    []*Span                `protobuf:"bytes,13,rep,name=comma_spans,json=commaSpans,proto3" json:"comma_spans,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Type_Generic) Reset() {
	*x = Type_Generic{}
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Type_Generic) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Type_Generic) ProtoMessage() {}

func (x *Type_Generic) ProtoReflect() protoreflect.Message {
	mi := &file_buf_compiler_v1alpha1_ast_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Type_Generic.ProtoReflect.Descriptor instead.
func (*Type_Generic) Descriptor() ([]byte, []int) {
	return file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP(), []int{7, 1}
}

func (x *Type_Generic) GetPath() *Path {
	if x != nil {
		return x.Path
	}
	return nil
}

func (x *Type_Generic) GetArgs() []*Type {
	if x != nil {
		return x.Args
	}
	return nil
}

func (x *Type_Generic) GetSpan() *Span {
	if x != nil {
		return x.Span
	}
	return nil
}

func (x *Type_Generic) GetOpenSpan() *Span {
	if x != nil {
		return x.OpenSpan
	}
	return nil
}

func (x *Type_Generic) GetCloseSpan() *Span {
	if x != nil {
		return x.CloseSpan
	}
	return nil
}

func (x *Type_Generic) GetCommaSpans() []*Span {
	if x != nil {
		return x.CommaSpans
	}
	return nil
}

var File_buf_compiler_v1alpha1_ast_proto protoreflect.FileDescriptor

const file_buf_compiler_v1alpha1_ast_proto_rawDesc = "" +
	"\n" +
	"\x1fbuf/compiler/v1alpha1/ast.proto\x12\x15buf.compiler.v1alpha1\x1a\"buf/compiler/v1alpha1/report.proto\"q\n" +
	"\x04File\x126\n" +
	"\x04file\x18\x01 \x01(\v2\".buf.compiler.v1alpha1.Report.FileR\x04file\x121\n" +
	"\x05decls\x18\x02 \x03(\v2\x1b.buf.compiler.v1alpha1.DeclR\x05decls\".\n" +
	"\x04Span\x12\x14\n" +
	"\x05start\x18\x01 \x01(\rR\x05start\x12\x10\n" +
	"\x03end\x18\x02 \x01(\rR\x03end\"\x95\x04\n" +
	"\x04Path\x12E\n" +
	"\n" +
	"components\x18\x01 \x03(\v2%.buf.compiler.v1alpha1.Path.ComponentR\n" +
	"components\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x1a\x94\x03\n" +
	"\tComponent\x12\x16\n" +
	"\x05ident\x18\x01 \x01(\tH\x00R\x05ident\x12;\n" +
	"\textension\x18\x02 \x01(\v2\x1b.buf.compiler.v1alpha1.PathH\x00R\textension\x12M\n" +
	"\tseparator\x18\x03 \x01(\x0e2/.buf.compiler.v1alpha1.Path.Component.SeparatorR\tseparator\x12B\n" +
	"\x0ecomponent_span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\rcomponentSpan\x12B\n" +
	"\x0eseparator_span\x18\v \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\rseparatorSpan\"N\n" +
	"\tSeparator\x12\x19\n" +
	"\x15SEPARATOR_UNSPECIFIED\x10\x00\x12\x11\n" +
	"\rSEPARATOR_DOT\x10\x01\x12\x13\n" +
	"\x0fSEPARATOR_SLASH\x10\x02B\v\n" +
	"\tcomponent\"\xec\x12\n" +
	"\x04Decl\x129\n" +
	"\x05empty\x18\x01 \x01(\v2!.buf.compiler.v1alpha1.Decl.EmptyH\x00R\x05empty\x12<\n" +
	"\x06syntax\x18\x02 \x01(\v2\".buf.compiler.v1alpha1.Decl.SyntaxH\x00R\x06syntax\x12<\n" +
	"\x06import\x18\x03 \x01(\v2\".buf.compiler.v1alpha1.Decl.ImportH\x00R\x06import\x12?\n" +
	"\apackage\x18\x04 \x01(\v2#.buf.compiler.v1alpha1.Decl.PackageH\x00R\apackage\x12.\n" +
	"\x03def\x18\x05 \x01(\v2\x1a.buf.compiler.v1alpha1.DefH\x00R\x03def\x126\n" +
	"\x04body\x18\x06 \x01(\v2 .buf.compiler.v1alpha1.Decl.BodyH\x00R\x04body\x129\n" +
	"\x05range\x18\a \x01(\v2!.buf.compiler.v1alpha1.Decl.RangeH\x00R\x05range\x1a8\n" +
	"\x05Empty\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x1a\xe6\x03\n" +
	"\x06Syntax\x12;\n" +
	"\x04kind\x18\x01 \x01(\x0e2'.buf.compiler.v1alpha1.Decl.Syntax.KindR\x04kind\x121\n" +
	"\x05value\x18\x02 \x01(\v2\x1b.buf.compiler.v1alpha1.ExprR\x05value\x128\n" +
	"\aoptions\x18\x03 \x01(\v2\x1e.buf.compiler.v1alpha1.OptionsR\aoptions\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x12>\n" +
	"\fkeyword_span\x18\v \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\vkeywordSpan\x12<\n" +
	"\vequals_span\x18\f \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\n" +
	"equalsSpan\x12B\n" +
	"\x0esemicolon_span\x18\r \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\rsemicolonSpan\"?\n" +
	"\x04Kind\x12\x14\n" +
	"\x10KIND_UNSPECIFIED\x10\x00\x12\x0f\n" +
	"\vKIND_SYNTAX\x10\x01\x12\x10\n" +
	"\fKIND_EDITION\x10\x02\x1a\xa9\x02\n" +
	"\aPackage\x12/\n" +
	"\x04path\x18\x01 \x01(\v2\x1b.buf.compiler.v1alpha1.PathR\x04path\x128\n" +
	"\aoptions\x18\x02 \x01(\v2\x1e.buf.compiler.v1alpha1.OptionsR\aoptions\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x12>\n" +
	"\fkeyword_span\x18\v \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\vkeywordSpan\x12B\n" +
	"\x0esemicolon_span\x18\f \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\rsemicolonSpan\x1a\xd5\x04\n" +
	"\x06Import\x12G\n" +
	"\bmodifier\x18\x01 \x03(\x0e2+.buf.compiler.v1alpha1.Decl.Import.ModifierR\bmodifier\x12<\n" +
	"\vimport_path\x18\x02 \x01(\v2\x1b.buf.compiler.v1alpha1.ExprR\n" +
	"importPath\x128\n" +
	"\aoptions\x18\x03 \x01(\v2\x1e.buf.compiler.v1alpha1.OptionsR\aoptions\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x12>\n" +
	"\fkeyword_span\x18\v \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\vkeywordSpan\x12@\n" +
	"\rmodifier_span\x18\f \x03(\v2\x1b.buf.compiler.v1alpha1.SpanR\fmodifierSpan\x12E\n" +
	"\x10import_path_span\x18\r \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x0eimportPathSpan\x12B\n" +
	"\x0esemicolon_span\x18\x0e \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\rsemicolonSpan\"L\n" +
	"\bModifier\x12\x18\n" +
	"\x14MODIFIER_UNSPECIFIED\x10\x00\x12\x11\n" +
	"\rMODIFIER_WEAK\x10\x01\x12\x13\n" +
	"\x0fMODIFIER_PUBLIC\x10\x02\x1aj\n" +
	"\x04Body\x121\n" +
	"\x05decls\x18\x01 \x03(\v2\x1b.buf.compiler.v1alpha1.DeclR\x05decls\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x1a\xad\x03\n" +
	"\x05Range\x12:\n" +
	"\x04kind\x18\x01 \x01(\x0e2&.buf.compiler.v1alpha1.Decl.Range.KindR\x04kind\x123\n" +
	"\x06ranges\x18\x02 \x03(\v2\x1b.buf.compiler.v1alpha1.ExprR\x06ranges\x128\n" +
	"\aoptions\x18\x03 \x01(\v2\x1e.buf.compiler.v1alpha1.OptionsR\aoptions\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x12>\n" +
	"\fkeyword_span\x18\v \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\vkeywordSpan\x12B\n" +
	"\x0esemicolon_span\x18\f \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\rsemicolonSpan\"D\n" +
	"\x04Kind\x12\x14\n" +
	"\x10KIND_UNSPECIFIED\x10\x00\x12\x13\n" +
	"\x0fKIND_EXTENSIONS\x10\x01\x12\x11\n" +
	"\rKIND_RESERVED\x10\x02B\x06\n" +
	"\x04decl\"\xa5\t\n" +
	"\x03Def\x123\n" +
	"\x04kind\x18\x01 \x01(\x0e2\x1f.buf.compiler.v1alpha1.Def.KindR\x04kind\x12/\n" +
	"\x04name\x18\x02 \x01(\v2\x1b.buf.compiler.v1alpha1.PathR\x04name\x12/\n" +
	"\x04type\x18\x03 \x01(\v2\x1b.buf.compiler.v1alpha1.TypeR\x04type\x12B\n" +
	"\tsignature\x18\x04 \x01(\v2$.buf.compiler.v1alpha1.Def.SignatureR\tsignature\x121\n" +
	"\x05value\x18\x05 \x01(\v2\x1b.buf.compiler.v1alpha1.ExprR\x05value\x128\n" +
	"\aoptions\x18\x06 \x01(\v2\x1e.buf.compiler.v1alpha1.OptionsR\aoptions\x124\n" +
	"\x04body\x18\a \x01(\v2 .buf.compiler.v1alpha1.Decl.BodyR\x04body\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x12>\n" +
	"\fkeyword_span\x18\v \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\vkeywordSpan\x12<\n" +
	"\vequals_span\x18\f \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\n" +
	"equalsSpan\x12B\n" +
	"\x0esemicolon_span\x18\r \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\rsemicolonSpan\x1a\xe2\x02\n" +
	"\tSignature\x123\n" +
	"\x06inputs\x18\x01 \x03(\v2\x1b.buf.compiler.v1alpha1.TypeR\x06inputs\x125\n" +
	"\aoutputs\x18\x02 \x03(\v2\x1b.buf.compiler.v1alpha1.TypeR\aoutputs\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x12:\n" +
	"\n" +
	"input_span\x18\v \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\tinputSpan\x12>\n" +
	"\freturns_span\x18\f \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\vreturnsSpan\x12<\n" +
	"\voutput_span\x18\r \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\n" +
	"outputSpan\"\xc7\x01\n" +
	"\x04Kind\x12\x14\n" +
	"\x10KIND_UNSPECIFIED\x10\x00\x12\x10\n" +
	"\fKIND_MESSAGE\x10\x01\x12\r\n" +
	"\tKIND_ENUM\x10\x02\x12\x10\n" +
	"\fKIND_SERVICE\x10\x03\x12\x0f\n" +
	"\vKIND_EXTEND\x10\x04\x12\x0e\n" +
	"\n" +
	"KIND_FIELD\x10\x05\x12\x13\n" +
	"\x0fKIND_ENUM_VALUE\x10\x06\x12\x0e\n" +
	"\n" +
	"KIND_ONEOF\x10\a\x12\x0e\n" +
	"\n" +
	"KIND_GROUP\x10\b\x12\x0f\n" +
	"\vKIND_METHOD\x10\t\x12\x0f\n" +
	"\vKIND_OPTION\x10\n" +
	"\"\xa6\x02\n" +
	"\aOptions\x12>\n" +
	"\aentries\x18\x01 \x03(\v2$.buf.compiler.v1alpha1.Options.EntryR\aentries\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x1a\xa9\x01\n" +
	"\x05Entry\x12/\n" +
	"\x04path\x18\x01 \x01(\v2\x1b.buf.compiler.v1alpha1.PathR\x04path\x121\n" +
	"\x05value\x18\x02 \x01(\v2\x1b.buf.compiler.v1alpha1.ExprR\x05value\x12<\n" +
	"\vequals_span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\n" +
	"equalsSpan\"\x81\x0f\n" +
	"\x04Expr\x12?\n" +
	"\aliteral\x18\x01 \x01(\v2#.buf.compiler.v1alpha1.Expr.LiteralH\x00R\aliteral\x121\n" +
	"\x04path\x18\x02 \x01(\v2\x1b.buf.compiler.v1alpha1.PathH\x00R\x04path\x12B\n" +
	"\bprefixed\x18\x03 \x01(\v2$.buf.compiler.v1alpha1.Expr.PrefixedH\x00R\bprefixed\x129\n" +
	"\x05range\x18\x04 \x01(\v2!.buf.compiler.v1alpha1.Expr.RangeH\x00R\x05range\x129\n" +
	"\x05array\x18\x05 \x01(\v2!.buf.compiler.v1alpha1.Expr.ArrayH\x00R\x05array\x126\n" +
	"\x04dict\x18\x06 \x01(\v2 .buf.compiler.v1alpha1.Expr.DictH\x00R\x04dict\x129\n" +
	"\x05field\x18\a \x01(\v2!.buf.compiler.v1alpha1.Expr.FieldH\x00R\x05field\x1a\xaa\x01\n" +
	"\aLiteral\x12\x1d\n" +
	"\tint_value\x18\x01 \x01(\x04H\x00R\bintValue\x12!\n" +
	"\vfloat_value\x18\x02 \x01(\x01H\x00R\n" +
	"floatValue\x12#\n" +
	"\fstring_value\x18\x03 \x01(\tH\x00R\vstringValue\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04spanB\a\n" +
	"\x05value\x1a\xa3\x02\n" +
	"\bPrefixed\x12C\n" +
	"\x06prefix\x18\x01 \x01(\x0e2+.buf.compiler.v1alpha1.Expr.Prefixed.PrefixR\x06prefix\x12/\n" +
	"\x04expr\x18\x02 \x01(\v2\x1b.buf.compiler.v1alpha1.ExprR\x04expr\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x12<\n" +
	"\vprefix_span\x18\v \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\n" +
	"prefixSpan\"2\n" +
	"\x06Prefix\x12\x16\n" +
	"\x12PREFIX_UNSPECIFIED\x10\x00\x12\x10\n" +
	"\fPREFIX_MINUS\x10\x01\x1a\xd0\x01\n" +
	"\x05Range\x121\n" +
	"\x05start\x18\x01 \x01(\v2\x1b.buf.compiler.v1alpha1.ExprR\x05start\x12-\n" +
	"\x03end\x18\x02 \x01(\v2\x1b.buf.compiler.v1alpha1.ExprR\x03end\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x124\n" +
	"\ato_span\x18\v \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x06toSpan\x1a\xa5\x02\n" +
	"\x05Array\x127\n" +
	"\belements\x18\x01 \x03(\v2\x1b.buf.compiler.v1alpha1.ExprR\belements\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x128\n" +
	"\topen_span\x18\v \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\bopenSpan\x12:\n" +
	"\n" +
	"close_span\x18\f \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\tcloseSpan\x12<\n" +
	"\vcomma_spans\x18\r \x03(\v2\x1b.buf.compiler.v1alpha1.SpanR\n" +
	"commaSpans\x1a\xa8\x02\n" +
	"\x04Dict\x12;\n" +
	"\aentries\x18\x01 \x03(\v2!.buf.compiler.v1alpha1.Expr.FieldR\aentries\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x128\n" +
	"\topen_span\x18\v \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\bopenSpan\x12:\n" +
	"\n" +
	"close_span\x18\f \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\tcloseSpan\x12<\n" +
	"\vcomma_spans\x18\r \x03(\v2\x1b.buf.compiler.v1alpha1.SpanR\n" +
	"commaSpans\x1a\xd6\x01\n" +
	"\x05Field\x12-\n" +
	"\x03key\x18\x01 \x01(\v2\x1b.buf.compiler.v1alpha1.ExprR\x03key\x121\n" +
	"\x05value\x18\x02 \x01(\v2\x1b.buf.compiler.v1alpha1.ExprR\x05value\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x12:\n" +
	"\n" +
	"colon_span\x18\v \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\tcolonSpanB\x06\n" +
	"\x04expr\"\xff\x06\n" +
	"\x04Type\x121\n" +
	"\x04path\x18\x01 \x01(\v2\x1b.buf.compiler.v1alpha1.PathH\x00R\x04path\x12B\n" +
	"\bprefixed\x18\x02 \x01(\v2$.buf.compiler.v1alpha1.Type.PrefixedH\x00R\bprefixed\x12?\n" +
	"\ageneric\x18\x03 \x01(\v2#.buf.compiler.v1alpha1.Type.GenericH\x00R\ageneric\x1a\xe3\x02\n" +
	"\bPrefixed\x12C\n" +
	"\x06prefix\x18\x01 \x01(\x0e2+.buf.compiler.v1alpha1.Type.Prefixed.PrefixR\x06prefix\x12/\n" +
	"\x04type\x18\x02 \x01(\v2\x1b.buf.compiler.v1alpha1.TypeR\x04type\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x12<\n" +
	"\vprefix_span\x18\v \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\n" +
	"prefixSpan\"r\n" +
	"\x06Prefix\x12\x16\n" +
	"\x12PREFIX_UNSPECIFIED\x10\x00\x12\x13\n" +
	"\x0fPREFIX_OPTIONAL\x10\x01\x12\x13\n" +
	"\x0fPREFIX_REPEATED\x10\x02\x12\x13\n" +
	"\x0fPREFIX_REQUIRED\x10\x03\x12\x11\n" +
	"\rPREFIX_STREAM\x10\x04\x1a\xd0\x02\n" +
	"\aGeneric\x12/\n" +
	"\x04path\x18\x01 \x01(\v2\x1b.buf.compiler.v1alpha1.PathR\x04path\x12/\n" +
	"\x04args\x18\x02 \x03(\v2\x1b.buf.compiler.v1alpha1.TypeR\x04args\x12/\n" +
	"\x04span\x18\n" +
	" \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\x04span\x128\n" +
	"\topen_span\x18\v \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\bopenSpan\x12:\n" +
	"\n" +
	"close_span\x18\f \x01(\v2\x1b.buf.compiler.v1alpha1.SpanR\tcloseSpan\x12<\n" +
	"\vcomma_spans\x18\r \x03(\v2\x1b.buf.compiler.v1alpha1.SpanR\n" +
	"commaSpansB\x06\n" +
	"\x04typeB\xf1\x01\n" +
	"\x19com.buf.compiler.v1alpha1B\bAstProtoP\x01ZTgithub.com/bufbuild/protocompile/internal/gen/buf/compiler/v1alpha1;compilerv1alpha1\xa2\x02\x03BCX\xaa\x02\x15Buf.Compiler.V1alpha1\xca\x02\x15Buf\\Compiler\\V1alpha1\xe2\x02!Buf\\Compiler\\V1alpha1\\GPBMetadata\xea\x02\x17Buf::Compiler::V1alpha1b\x06proto3"

var (
	file_buf_compiler_v1alpha1_ast_proto_rawDescOnce sync.Once
	file_buf_compiler_v1alpha1_ast_proto_rawDescData []byte
)

func file_buf_compiler_v1alpha1_ast_proto_rawDescGZIP() []byte {
	file_buf_compiler_v1alpha1_ast_proto_rawDescOnce.Do(func() {
		file_buf_compiler_v1alpha1_ast_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_buf_compiler_v1alpha1_ast_proto_rawDesc), len(file_buf_compiler_v1alpha1_ast_proto_rawDesc)))
	})
	return file_buf_compiler_v1alpha1_ast_proto_rawDescData
}

var file_buf_compiler_v1alpha1_ast_proto_enumTypes = make([]protoimpl.EnumInfo, 7)
var file_buf_compiler_v1alpha1_ast_proto_msgTypes = make([]protoimpl.MessageInfo, 25)
var file_buf_compiler_v1alpha1_ast_proto_goTypes = []any{
	(Path_Component_Separator)(0), // 0: buf.compiler.v1alpha1.Path.Component.Separator
	(Decl_Syntax_Kind)(0),         // 1: buf.compiler.v1alpha1.Decl.Syntax.Kind
	(Decl_Import_Modifier)(0),     // 2: buf.compiler.v1alpha1.Decl.Import.Modifier
	(Decl_Range_Kind)(0),          // 3: buf.compiler.v1alpha1.Decl.Range.Kind
	(Def_Kind)(0),                 // 4: buf.compiler.v1alpha1.Def.Kind
	(Expr_Prefixed_Prefix)(0),     // 5: buf.compiler.v1alpha1.Expr.Prefixed.Prefix
	(Type_Prefixed_Prefix)(0),     // 6: buf.compiler.v1alpha1.Type.Prefixed.Prefix
	(*File)(nil),                  // 7: buf.compiler.v1alpha1.File
	(*Span)(nil),                  // 8: buf.compiler.v1alpha1.Span
	(*Path)(nil),                  // 9: buf.compiler.v1alpha1.Path
	(*Decl)(nil),                  // 10: buf.compiler.v1alpha1.Decl
	(*Def)(nil),                   // 11: buf.compiler.v1alpha1.Def
	(*Options)(nil),               // 12: buf.compiler.v1alpha1.Options
	(*Expr)(nil),                  // 13: buf.compiler.v1alpha1.Expr
	(*Type)(nil),                  // 14: buf.compiler.v1alpha1.Type
	(*Path_Component)(nil),        // 15: buf.compiler.v1alpha1.Path.Component
	(*Decl_Empty)(nil),            // 16: buf.compiler.v1alpha1.Decl.Empty
	(*Decl_Syntax)(nil),           // 17: buf.compiler.v1alpha1.Decl.Syntax
	(*Decl_Package)(nil),          // 18: buf.compiler.v1alpha1.Decl.Package
	(*Decl_Import)(nil),           // 19: buf.compiler.v1alpha1.Decl.Import
	(*Decl_Body)(nil),             // 20: buf.compiler.v1alpha1.Decl.Body
	(*Decl_Range)(nil),            // 21: buf.compiler.v1alpha1.Decl.Range
	(*Def_Signature)(nil),         // 22: buf.compiler.v1alpha1.Def.Signature
	(*Options_Entry)(nil),         // 23: buf.compiler.v1alpha1.Options.Entry
	(*Expr_Literal)(nil),          // 24: buf.compiler.v1alpha1.Expr.Literal
	(*Expr_Prefixed)(nil),         // 25: buf.compiler.v1alpha1.Expr.Prefixed
	(*Expr_Range)(nil),            // 26: buf.compiler.v1alpha1.Expr.Range
	(*Expr_Array)(nil),            // 27: buf.compiler.v1alpha1.Expr.Array
	(*Expr_Dict)(nil),             // 28: buf.compiler.v1alpha1.Expr.Dict
	(*Expr_Field)(nil),            // 29: buf.compiler.v1alpha1.Expr.Field
	(*Type_Prefixed)(nil),         // 30: buf.compiler.v1alpha1.Type.Prefixed
	(*Type_Generic)(nil),          // 31: buf.compiler.v1alpha1.Type.Generic
	(*Report_File)(nil),           // 32: buf.compiler.v1alpha1.Report.File
}
var file_buf_compiler_v1alpha1_ast_proto_depIdxs = []int32{
	32,  // 0: buf.compiler.v1alpha1.File.file:type_name -> buf.compiler.v1alpha1.Report.File
	10,  // 1: buf.compiler.v1alpha1.File.decls:type_name -> buf.compiler.v1alpha1.Decl
	15,  // 2: buf.compiler.v1alpha1.Path.components:type_name -> buf.compiler.v1alpha1.Path.Component
	8,   // 3: buf.compiler.v1alpha1.Path.span:type_name -> buf.compiler.v1alpha1.Span
	16,  // 4: buf.compiler.v1alpha1.Decl.empty:type_name -> buf.compiler.v1alpha1.Decl.Empty
	17,  // 5: buf.compiler.v1alpha1.Decl.syntax:type_name -> buf.compiler.v1alpha1.Decl.Syntax
	19,  // 6: buf.compiler.v1alpha1.Decl.import:type_name -> buf.compiler.v1alpha1.Decl.Import
	18,  // 7: buf.compiler.v1alpha1.Decl.package:type_name -> buf.compiler.v1alpha1.Decl.Package
	11,  // 8: buf.compiler.v1alpha1.Decl.def:type_name -> buf.compiler.v1alpha1.Def
	20,  // 9: buf.compiler.v1alpha1.Decl.body:type_name -> buf.compiler.v1alpha1.Decl.Body
	21,  // 10: buf.compiler.v1alpha1.Decl.range:type_name -> buf.compiler.v1alpha1.Decl.Range
	4,   // 11: buf.compiler.v1alpha1.Def.kind:type_name -> buf.compiler.v1alpha1.Def.Kind
	9,   // 12: buf.compiler.v1alpha1.Def.name:type_name -> buf.compiler.v1alpha1.Path
	14,  // 13: buf.compiler.v1alpha1.Def.type:type_name -> buf.compiler.v1alpha1.Type
	22,  // 14: buf.compiler.v1alpha1.Def.signature:type_name -> buf.compiler.v1alpha1.Def.Signature
	13,  // 15: buf.compiler.v1alpha1.Def.value:type_name -> buf.compiler.v1alpha1.Expr
	12,  // 16: buf.compiler.v1alpha1.Def.options:type_name -> buf.compiler.v1alpha1.Options
	20,  // 17: buf.compiler.v1alpha1.Def.body:type_name -> buf.compiler.v1alpha1.Decl.Body
	8,   // 18: buf.compiler.v1alpha1.Def.span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 19: buf.compiler.v1alpha1.Def.keyword_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 20: buf.compiler.v1alpha1.Def.equals_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 21: buf.compiler.v1alpha1.Def.semicolon_span:type_name -> buf.compiler.v1alpha1.Span
	23,  // 22: buf.compiler.v1alpha1.Options.entries:type_name -> buf.compiler.v1alpha1.Options.Entry
	8,   // 23: buf.compiler.v1alpha1.Options.span:type_name -> buf.compiler.v1alpha1.Span
	24,  // 24: buf.compiler.v1alpha1.Expr.literal:type_name -> buf.compiler.v1alpha1.Expr.Literal
	9,   // 25: buf.compiler.v1alpha1.Expr.path:type_name -> buf.compiler.v1alpha1.Path
	25,  // 26: buf.compiler.v1alpha1.Expr.prefixed:type_name -> buf.compiler.v1alpha1.Expr.Prefixed
	26,  // 27: buf.compiler.v1alpha1.Expr.range:type_name -> buf.compiler.v1alpha1.Expr.Range
	27,  // 28: buf.compiler.v1alpha1.Expr.array:type_name -> buf.compiler.v1alpha1.Expr.Array
	28,  // 29: buf.compiler.v1alpha1.Expr.dict:type_name -> buf.compiler.v1alpha1.Expr.Dict
	29,  // 30: buf.compiler.v1alpha1.Expr.field:type_name -> buf.compiler.v1alpha1.Expr.Field
	9,   // 31: buf.compiler.v1alpha1.Type.path:type_name -> buf.compiler.v1alpha1.Path
	30,  // 32: buf.compiler.v1alpha1.Type.prefixed:type_name -> buf.compiler.v1alpha1.Type.Prefixed
	31,  // 33: buf.compiler.v1alpha1.Type.generic:type_name -> buf.compiler.v1alpha1.Type.Generic
	9,   // 34: buf.compiler.v1alpha1.Path.Component.extension:type_name -> buf.compiler.v1alpha1.Path
	0,   // 35: buf.compiler.v1alpha1.Path.Component.separator:type_name -> buf.compiler.v1alpha1.Path.Component.Separator
	8,   // 36: buf.compiler.v1alpha1.Path.Component.component_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 37: buf.compiler.v1alpha1.Path.Component.separator_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 38: buf.compiler.v1alpha1.Decl.Empty.span:type_name -> buf.compiler.v1alpha1.Span
	1,   // 39: buf.compiler.v1alpha1.Decl.Syntax.kind:type_name -> buf.compiler.v1alpha1.Decl.Syntax.Kind
	13,  // 40: buf.compiler.v1alpha1.Decl.Syntax.value:type_name -> buf.compiler.v1alpha1.Expr
	12,  // 41: buf.compiler.v1alpha1.Decl.Syntax.options:type_name -> buf.compiler.v1alpha1.Options
	8,   // 42: buf.compiler.v1alpha1.Decl.Syntax.span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 43: buf.compiler.v1alpha1.Decl.Syntax.keyword_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 44: buf.compiler.v1alpha1.Decl.Syntax.equals_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 45: buf.compiler.v1alpha1.Decl.Syntax.semicolon_span:type_name -> buf.compiler.v1alpha1.Span
	9,   // 46: buf.compiler.v1alpha1.Decl.Package.path:type_name -> buf.compiler.v1alpha1.Path
	12,  // 47: buf.compiler.v1alpha1.Decl.Package.options:type_name -> buf.compiler.v1alpha1.Options
	8,   // 48: buf.compiler.v1alpha1.Decl.Package.span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 49: buf.compiler.v1alpha1.Decl.Package.keyword_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 50: buf.compiler.v1alpha1.Decl.Package.semicolon_span:type_name -> buf.compiler.v1alpha1.Span
	2,   // 51: buf.compiler.v1alpha1.Decl.Import.modifier:type_name -> buf.compiler.v1alpha1.Decl.Import.Modifier
	13,  // 52: buf.compiler.v1alpha1.Decl.Import.import_path:type_name -> buf.compiler.v1alpha1.Expr
	12,  // 53: buf.compiler.v1alpha1.Decl.Import.options:type_name -> buf.compiler.v1alpha1.Options
	8,   // 54: buf.compiler.v1alpha1.Decl.Import.span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 55: buf.compiler.v1alpha1.Decl.Import.keyword_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 56: buf.compiler.v1alpha1.Decl.Import.modifier_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 57: buf.compiler.v1alpha1.Decl.Import.import_path_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 58: buf.compiler.v1alpha1.Decl.Import.semicolon_span:type_name -> buf.compiler.v1alpha1.Span
	10,  // 59: buf.compiler.v1alpha1.Decl.Body.decls:type_name -> buf.compiler.v1alpha1.Decl
	8,   // 60: buf.compiler.v1alpha1.Decl.Body.span:type_name -> buf.compiler.v1alpha1.Span
	3,   // 61: buf.compiler.v1alpha1.Decl.Range.kind:type_name -> buf.compiler.v1alpha1.Decl.Range.Kind
	13,  // 62: buf.compiler.v1alpha1.Decl.Range.ranges:type_name -> buf.compiler.v1alpha1.Expr
	12,  // 63: buf.compiler.v1alpha1.Decl.Range.options:type_name -> buf.compiler.v1alpha1.Options
	8,   // 64: buf.compiler.v1alpha1.Decl.Range.span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 65: buf.compiler.v1alpha1.Decl.Range.keyword_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 66: buf.compiler.v1alpha1.Decl.Range.semicolon_span:type_name -> buf.compiler.v1alpha1.Span
	14,  // 67: buf.compiler.v1alpha1.Def.Signature.inputs:type_name -> buf.compiler.v1alpha1.Type
	14,  // 68: buf.compiler.v1alpha1.Def.Signature.outputs:type_name -> buf.compiler.v1alpha1.Type
	8,   // 69: buf.compiler.v1alpha1.Def.Signature.span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 70: buf.compiler.v1alpha1.Def.Signature.input_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 71: buf.compiler.v1alpha1.Def.Signature.returns_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 72: buf.compiler.v1alpha1.Def.Signature.output_span:type_name -> buf.compiler.v1alpha1.Span
	9,   // 73: buf.compiler.v1alpha1.Options.Entry.path:type_name -> buf.compiler.v1alpha1.Path
	13,  // 74: buf.compiler.v1alpha1.Options.Entry.value:type_name -> buf.compiler.v1alpha1.Expr
	8,   // 75: buf.compiler.v1alpha1.Options.Entry.equals_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 76: buf.compiler.v1alpha1.Expr.Literal.span:type_name -> buf.compiler.v1alpha1.Span
	5,   // 77: buf.compiler.v1alpha1.Expr.Prefixed.prefix:type_name -> buf.compiler.v1alpha1.Expr.Prefixed.Prefix
	13,  // 78: buf.compiler.v1alpha1.Expr.Prefixed.expr:type_name -> buf.compiler.v1alpha1.Expr
	8,   // 79: buf.compiler.v1alpha1.Expr.Prefixed.span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 80: buf.compiler.v1alpha1.Expr.Prefixed.prefix_span:type_name -> buf.compiler.v1alpha1.Span
	13,  // 81: buf.compiler.v1alpha1.Expr.Range.start:type_name -> buf.compiler.v1alpha1.Expr
	13,  // 82: buf.compiler.v1alpha1.Expr.Range.end:type_name -> buf.compiler.v1alpha1.Expr
	8,   // 83: buf.compiler.v1alpha1.Expr.Range.span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 84: buf.compiler.v1alpha1.Expr.Range.to_span:type_name -> buf.compiler.v1alpha1.Span
	13,  // 85: buf.compiler.v1alpha1.Expr.Array.elements:type_name -> buf.compiler.v1alpha1.Expr
	8,   // 86: buf.compiler.v1alpha1.Expr.Array.span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 87: buf.compiler.v1alpha1.Expr.Array.open_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 88: buf.compiler.v1alpha1.Expr.Array.close_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 89: buf.compiler.v1alpha1.Expr.Array.comma_spans:type_name -> buf.compiler.v1alpha1.Span
	29,  // 90: buf.compiler.v1alpha1.Expr.Dict.entries:type_name -> buf.compiler.v1alpha1.Expr.Field
	8,   // 91: buf.compiler.v1alpha1.Expr.Dict.span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 92: buf.compiler.v1alpha1.Expr.Dict.open_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 93: buf.compiler.v1alpha1.Expr.Dict.close_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 94: buf.compiler.v1alpha1.Expr.Dict.comma_spans:type_name -> buf.compiler.v1alpha1.Span
	13,  // 95: buf.compiler.v1alpha1.Expr.Field.key:type_name -> buf.compiler.v1alpha1.Expr
	13,  // 96: buf.compiler.v1alpha1.Expr.Field.value:type_name -> buf.compiler.v1alpha1.Expr
	8,   // 97: buf.compiler.v1alpha1.Expr.Field.span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 98: buf.compiler.v1alpha1.Expr.Field.colon_span:type_name -> buf.compiler.v1alpha1.Span
	6,   // 99: buf.compiler.v1alpha1.Type.Prefixed.prefix:type_name -> buf.compiler.v1alpha1.Type.Prefixed.Prefix
	14,  // 100: buf.compiler.v1alpha1.Type.Prefixed.type:type_name -> buf.compiler.v1alpha1.Type
	8,   // 101: buf.compiler.v1alpha1.Type.Prefixed.span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 102: buf.compiler.v1alpha1.Type.Prefixed.prefix_span:type_name -> buf.compiler.v1alpha1.Span
	9,   // 103: buf.compiler.v1alpha1.Type.Generic.path:type_name -> buf.compiler.v1alpha1.Path
	14,  // 104: buf.compiler.v1alpha1.Type.Generic.args:type_name -> buf.compiler.v1alpha1.Type
	8,   // 105: buf.compiler.v1alpha1.Type.Generic.span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 106: buf.compiler.v1alpha1.Type.Generic.open_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 107: buf.compiler.v1alpha1.Type.Generic.close_span:type_name -> buf.compiler.v1alpha1.Span
	8,   // 108: buf.compiler.v1alpha1.Type.Generic.comma_spans:type_name -> buf.compiler.v1alpha1.Span
	109, // [109:109] is the sub-list for method output_type
	109, // [109:109] is the sub-list for method input_type
	109, // [109:109] is the sub-list for extension type_name
	109, // [109:109] is the sub-list for extension extendee
	0,   // [0:109] is the sub-list for field type_name
}

func init() { file_buf_compiler_v1alpha1_ast_proto_init() }
func file_buf_compiler_v1alpha1_ast_proto_init() {
	if File_buf_compiler_v1alpha1_ast_proto != nil {
		return
	}
	file_buf_compiler_v1alpha1_report_proto_init()
	file_buf_compiler_v1alpha1_ast_proto_msgTypes[3].OneofWrappers = []any{
		(*Decl_Empty_)(nil),
		(*Decl_Syntax_)(nil),
		(*Decl_Import_)(nil),
		(*Decl_Package_)(nil),
		(*Decl_Def)(nil),
		(*Decl_Body_)(nil),
		(*Decl_Range_)(nil),
	}
	file_buf_compiler_v1alpha1_ast_proto_msgTypes[6].OneofWrappers = []any{
		(*Expr_Literal_)(nil),
		(*Expr_Path)(nil),
		(*Expr_Prefixed_)(nil),
		(*Expr_Range_)(nil),
		(*Expr_Array_)(nil),
		(*Expr_Dict_)(nil),
		(*Expr_Field_)(nil),
	}
	file_buf_compiler_v1alpha1_ast_proto_msgTypes[7].OneofWrappers = []any{
		(*Type_Path)(nil),
		(*Type_Prefixed_)(nil),
		(*Type_Generic_)(nil),
	}
	file_buf_compiler_v1alpha1_ast_proto_msgTypes[8].OneofWrappers = []any{
		(*Path_Component_Ident)(nil),
		(*Path_Component_Extension)(nil),
	}
	file_buf_compiler_v1alpha1_ast_proto_msgTypes[17].OneofWrappers = []any{
		(*Expr_Literal_IntValue)(nil),
		(*Expr_Literal_FloatValue)(nil),
		(*Expr_Literal_StringValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_compiler_v1alpha1_ast_proto_rawDesc), len(file_buf_compiler_v1alpha1_ast_proto_rawDesc)),
			NumEnums:      7,
			NumMessages:   25,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_buf_compiler_v1alpha1_ast_proto_goTypes,
		DependencyIndexes: file_buf_compiler_v1alpha1_ast_proto_depIdxs,
		EnumInfos:         file_buf_compiler_v1alpha1_ast_proto_enumTypes,
		MessageInfos:      file_buf_compiler_v1alpha1_ast_proto_msgTypes,
	}.Build()
	File_buf_compiler_v1alpha1_ast_proto = out.File
	file_buf_compiler_v1alpha1_ast_proto_goTypes = nil
	file_buf_compiler_v1alpha1_ast_proto_depIdxs = nil
}
