#line 534 "filter/decl.m4"


#if defined(__GNUC__) && __GNUC__ >= 6
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmisleading-indentation"
#endif

#include "nest/bird.h"
#include "filter/filter.h"
#include "filter/f-inst.h"

/* Instruction codes to string */
static const char * const f_instruction_name_str[] = {
#line 288 "filter/f-inst.c"
 /* Code enum to string for FI_ADD */
#line 288
  [FI_ADD] = "FI_ADD",
#line 293 "filter/f-inst.c"
 /* Code enum to string for FI_SUBTRACT */
#line 293
  [FI_SUBTRACT] = "FI_SUBTRACT",
#line 298 "filter/f-inst.c"
 /* Code enum to string for FI_MULTIPLY */
#line 298
  [FI_MULTIPLY] = "FI_MULTIPLY",
#line 304 "filter/f-inst.c"
 /* Code enum to string for FI_DIVIDE */
#line 304
  [FI_DIVIDE] = "FI_DIVIDE",
#line 309 "filter/f-inst.c"
 /* Code enum to string for FI_BITOR */
#line 309
  [FI_BITOR] = "FI_BITOR",
#line 314 "filter/f-inst.c"
 /* Code enum to string for FI_BITAND */
#line 314
  [FI_BITAND] = "FI_BITAND",
#line 324 "filter/f-inst.c"
 /* Code enum to string for FI_AND */
#line 324
  [FI_AND] = "FI_AND",
#line 335 "filter/f-inst.c"
 /* Code enum to string for FI_OR */
#line 335
  [FI_OR] = "FI_OR",
#line 345 "filter/f-inst.c"
 /* Code enum to string for FI_PAIR_CONSTRUCT */
#line 345
  [FI_PAIR_CONSTRUCT] = "FI_PAIR_CONSTRUCT",
#line 385 "filter/f-inst.c"
 /* Code enum to string for FI_EC_CONSTRUCT */
#line 385
  [FI_EC_CONSTRUCT] = "FI_EC_CONSTRUCT",
#line 392 "filter/f-inst.c"
 /* Code enum to string for FI_LC_CONSTRUCT */
#line 392
  [FI_LC_CONSTRUCT] = "FI_LC_CONSTRUCT",
#line 442 "filter/f-inst.c"
 /* Code enum to string for FI_PATHMASK_CONSTRUCT */
#line 442
  [FI_PATHMASK_CONSTRUCT] = "FI_PATHMASK_CONSTRUCT",
#line 449 "filter/f-inst.c"
 /* Code enum to string for FI_NEQ */
#line 449
  [FI_NEQ] = "FI_NEQ",
#line 456 "filter/f-inst.c"
 /* Code enum to string for FI_EQ */
#line 456
  [FI_EQ] = "FI_EQ",
#line 467 "filter/f-inst.c"
 /* Code enum to string for FI_LT */
#line 467
  [FI_LT] = "FI_LT",
#line 478 "filter/f-inst.c"
 /* Code enum to string for FI_LTE */
#line 478
  [FI_LTE] = "FI_LTE",
#line 483 "filter/f-inst.c"
 /* Code enum to string for FI_NOT */
#line 483
  [FI_NOT] = "FI_NOT",
#line 492 "filter/f-inst.c"
 /* Code enum to string for FI_MATCH */
#line 492
  [FI_MATCH] = "FI_MATCH",
#line 501 "filter/f-inst.c"
 /* Code enum to string for FI_NOT_MATCH */
#line 501
  [FI_NOT_MATCH] = "FI_NOT_MATCH",
#line 506 "filter/f-inst.c"
 /* Code enum to string for FI_DEFINED */
#line 506
  [FI_DEFINED] = "FI_DEFINED",
#line 507 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_NET__type */
#line 507
  [FI_METHOD__T_NET__type] = "FI_METHOD__T_NET__type",
#line 510 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_IP__is_v4 */
#line 510
  [FI_METHOD__T_IP__is_v4] = "FI_METHOD__T_IP__is_v4",
#line 523 "filter/f-inst.c"
 /* Code enum to string for FI_VAR_INIT */
#line 523
  [FI_VAR_INIT] = "FI_VAR_INIT",
#line 534 "filter/f-inst.c"
 /* Code enum to string for FI_VAR_INIT0 */
#line 534
  [FI_VAR_INIT0] = "FI_VAR_INIT0",
#line 543 "filter/f-inst.c"
 /* Code enum to string for FI_VAR_SET */
#line 543
  [FI_VAR_SET] = "FI_VAR_SET",
#line 550 "filter/f-inst.c"
 /* Code enum to string for FI_VAR_GET */
#line 550
  [FI_VAR_GET] = "FI_VAR_GET",
#line 563 "filter/f-inst.c"
 /* Code enum to string for FI_CONSTANT */
#line 563
  [FI_CONSTANT] = "FI_CONSTANT",
#line 564 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PATH__empty */
#line 564
  [FI_METHOD__T_PATH__empty] = "FI_METHOD__T_PATH__empty",
#line 565 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_CLIST__empty */
#line 565
  [FI_METHOD__T_CLIST__empty] = "FI_METHOD__T_CLIST__empty",
#line 566 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_ECLIST__empty */
#line 566
  [FI_METHOD__T_ECLIST__empty] = "FI_METHOD__T_ECLIST__empty",
#line 569 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LCLIST__empty */
#line 569
  [FI_METHOD__T_LCLIST__empty] = "FI_METHOD__T_LCLIST__empty",
#line 591 "filter/f-inst.c"
 /* Code enum to string for FI_FOR_LOOP_START */
#line 591
  [FI_FOR_LOOP_START] = "FI_FOR_LOOP_START",
#line 600 "filter/f-inst.c"
 /* Code enum to string for FI_PATH_FOR_NEXT */
#line 600
  [FI_PATH_FOR_NEXT] = "FI_PATH_FOR_NEXT",
#line 609 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_FOR_NEXT */
#line 609
  [FI_CLIST_FOR_NEXT] = "FI_CLIST_FOR_NEXT",
#line 618 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_FOR_NEXT */
#line 618
  [FI_ECLIST_FOR_NEXT] = "FI_ECLIST_FOR_NEXT",
#line 627 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_FOR_NEXT */
#line 627
  [FI_LCLIST_FOR_NEXT] = "FI_LCLIST_FOR_NEXT",
#line 640 "filter/f-inst.c"
 /* Code enum to string for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
  [FI_ROUTES_BLOCK_FOR_NEXT] = "FI_ROUTES_BLOCK_FOR_NEXT",
#line 648 "filter/f-inst.c"
 /* Code enum to string for FI_CONDITION */
#line 648
  [FI_CONDITION] = "FI_CONDITION",
#line 661 "filter/f-inst.c"
 /* Code enum to string for FI_PRINT */
#line 661
  [FI_PRINT] = "FI_PRINT",
#line 668 "filter/f-inst.c"
 /* Code enum to string for FI_FLUSH */
#line 668
  [FI_FLUSH] = "FI_FLUSH",
#line 682 "filter/f-inst.c"
 /* Code enum to string for FI_DIE */
#line 682
  [FI_DIE] = "FI_DIE",
#line 689 "filter/f-inst.c"
 /* Code enum to string for FI_CURRENT_ROUTE */
#line 689
  [FI_CURRENT_ROUTE] = "FI_CURRENT_ROUTE",
#line 737 "filter/f-inst.c"
 /* Code enum to string for FI_RTA_GET */
#line 737
  [FI_RTA_GET] = "FI_RTA_GET",
#line 866 "filter/f-inst.c"
 /* Code enum to string for FI_RTA_SET */
#line 866
  [FI_RTA_SET] = "FI_RTA_SET",
#line 903 "filter/f-inst.c"
 /* Code enum to string for FI_EA_GET */
#line 903
  [FI_EA_GET] = "FI_EA_GET",
#line 944 "filter/f-inst.c"
 /* Code enum to string for FI_EA_SET */
#line 944
  [FI_EA_SET] = "FI_EA_SET",
#line 951 "filter/f-inst.c"
 /* Code enum to string for FI_EA_UNSET */
#line 951
  [FI_EA_UNSET] = "FI_EA_UNSET",
#line 965 "filter/f-inst.c"
 /* Code enum to string for FI_DEFAULT */
#line 965
  [FI_DEFAULT] = "FI_DEFAULT",
#line 966 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_NET__len */
#line 966
  [FI_METHOD__T_NET__len] = "FI_METHOD__T_NET__len",
#line 967 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PATH__len */
#line 967
  [FI_METHOD__T_PATH__len] = "FI_METHOD__T_PATH__len",
#line 968 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_CLIST__len */
#line 968
  [FI_METHOD__T_CLIST__len] = "FI_METHOD__T_CLIST__len",
#line 969 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_ECLIST__len */
#line 969
  [FI_METHOD__T_ECLIST__len] = "FI_METHOD__T_ECLIST__len",
#line 971 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LCLIST__len */
#line 971
  [FI_METHOD__T_LCLIST__len] = "FI_METHOD__T_LCLIST__len",
#line 1007 "filter/f-inst.c"
 /* Code enum to string for FI_NET_SRC */
#line 1007
  [FI_NET_SRC] = "FI_NET_SRC",
#line 1044 "filter/f-inst.c"
 /* Code enum to string for FI_NET_DST */
#line 1044
  [FI_NET_DST] = "FI_NET_DST",
#line 1054 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_NET__maxlen */
#line 1054
  [FI_METHOD__T_NET__maxlen] = "FI_METHOD__T_NET__maxlen",
#line 1064 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_NET__asn */
#line 1064
  [FI_METHOD__T_NET__asn] = "FI_METHOD__T_NET__asn",
#line 1066 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_NET__ip */
#line 1066
  [FI_METHOD__T_NET__ip] = "FI_METHOD__T_NET__ip",
#line 1075 "filter/f-inst.c"
 /* Code enum to string for FI_ROUTE_DISTINGUISHER */
#line 1075
  [FI_ROUTE_DISTINGUISHER] = "FI_ROUTE_DISTINGUISHER",
#line 1078 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PATH__first */
#line 1078
  [FI_METHOD__T_PATH__first] = "FI_METHOD__T_PATH__first",
#line 1081 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PATH__last */
#line 1081
  [FI_METHOD__T_PATH__last] = "FI_METHOD__T_PATH__last",
#line 1084 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PATH__last_nonaggregated */
#line 1084
  [FI_METHOD__T_PATH__last_nonaggregated] = "FI_METHOD__T_PATH__last_nonaggregated",
#line 1087 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PAIR__asn */
#line 1087
  [FI_METHOD__T_PAIR__asn] = "FI_METHOD__T_PAIR__asn",
#line 1090 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_PAIR__data */
#line 1090
  [FI_METHOD__T_PAIR__data] = "FI_METHOD__T_PAIR__data",
#line 1093 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LC__asn */
#line 1093
  [FI_METHOD__T_LC__asn] = "FI_METHOD__T_LC__asn",
#line 1096 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LC__data1 */
#line 1096
  [FI_METHOD__T_LC__data1] = "FI_METHOD__T_LC__data1",
#line 1099 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LC__data2 */
#line 1099
  [FI_METHOD__T_LC__data2] = "FI_METHOD__T_LC__data2",
#line 1102 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_CLIST__min */
#line 1102
  [FI_METHOD__T_CLIST__min] = "FI_METHOD__T_CLIST__min",
#line 1105 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_CLIST__max */
#line 1105
  [FI_METHOD__T_CLIST__max] = "FI_METHOD__T_CLIST__max",
#line 1108 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_ECLIST__min */
#line 1108
  [FI_METHOD__T_ECLIST__min] = "FI_METHOD__T_ECLIST__min",
#line 1111 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_ECLIST__max */
#line 1111
  [FI_METHOD__T_ECLIST__max] = "FI_METHOD__T_ECLIST__max",
#line 1114 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LCLIST__min */
#line 1114
  [FI_METHOD__T_LCLIST__min] = "FI_METHOD__T_LCLIST__min",
#line 1116 "filter/f-inst.c"
 /* Code enum to string for FI_METHOD__T_LCLIST__max */
#line 1116
  [FI_METHOD__T_LCLIST__max] = "FI_METHOD__T_LCLIST__max",
#line 1142 "filter/f-inst.c"
 /* Code enum to string for FI_RETURN */
#line 1142
  [FI_RETURN] = "FI_RETURN",
#line 1202 "filter/f-inst.c"
 /* Code enum to string for FI_CALL */
#line 1202
  [FI_CALL] = "FI_CALL",
#line 1207 "filter/f-inst.c"
 /* Code enum to string for FI_DROP_RESULT */
#line 1207
  [FI_DROP_RESULT] = "FI_DROP_RESULT",
#line 1248 "filter/f-inst.c"
 /* Code enum to string for FI_SWITCH */
#line 1248
  [FI_SWITCH] = "FI_SWITCH",
#line 1257 "filter/f-inst.c"
 /* Code enum to string for FI_IP_MASK */
#line 1257
  [FI_IP_MASK] = "FI_IP_MASK",
#line 1265 "filter/f-inst.c"
 /* Code enum to string for FI_PATH_PREPEND */
#line 1265
  [FI_PATH_PREPEND] = "FI_PATH_PREPEND",
#line 1272 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_ADD_PAIR */
#line 1272
  [FI_CLIST_ADD_PAIR] = "FI_CLIST_ADD_PAIR",
#line 1286 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_ADD_IP */
#line 1286
  [FI_CLIST_ADD_IP] = "FI_CLIST_ADD_IP",
#line 1293 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_ADD_QUAD */
#line 1293
  [FI_CLIST_ADD_QUAD] = "FI_CLIST_ADD_QUAD",
#line 1300 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_ADD_CLIST */
#line 1300
  [FI_CLIST_ADD_CLIST] = "FI_CLIST_ADD_CLIST",
#line 1307 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_ADD_EC */
#line 1307
  [FI_ECLIST_ADD_EC] = "FI_ECLIST_ADD_EC",
#line 1314 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_ADD_ECLIST */
#line 1314
  [FI_ECLIST_ADD_ECLIST] = "FI_ECLIST_ADD_ECLIST",
#line 1321 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_ADD_LC */
#line 1321
  [FI_LCLIST_ADD_LC] = "FI_LCLIST_ADD_LC",
#line 1328 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_ADD_LCLIST */
#line 1328
  [FI_LCLIST_ADD_LCLIST] = "FI_LCLIST_ADD_LCLIST",
#line 1335 "filter/f-inst.c"
 /* Code enum to string for FI_PATH_DELETE_INT */
#line 1335
  [FI_PATH_DELETE_INT] = "FI_PATH_DELETE_INT",
#line 1347 "filter/f-inst.c"
 /* Code enum to string for FI_PATH_DELETE_SET */
#line 1347
  [FI_PATH_DELETE_SET] = "FI_PATH_DELETE_SET",
#line 1354 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_DELETE_PAIR */
#line 1354
  [FI_CLIST_DELETE_PAIR] = "FI_CLIST_DELETE_PAIR",
#line 1368 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_DELETE_IP */
#line 1368
  [FI_CLIST_DELETE_IP] = "FI_CLIST_DELETE_IP",
#line 1375 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_DELETE_QUAD */
#line 1375
  [FI_CLIST_DELETE_QUAD] = "FI_CLIST_DELETE_QUAD",
#line 1382 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_DELETE_CLIST */
#line 1382
  [FI_CLIST_DELETE_CLIST] = "FI_CLIST_DELETE_CLIST",
#line 1393 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_DELETE_SET */
#line 1393
  [FI_CLIST_DELETE_SET] = "FI_CLIST_DELETE_SET",
#line 1400 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_DELETE_EC */
#line 1400
  [FI_ECLIST_DELETE_EC] = "FI_ECLIST_DELETE_EC",
#line 1407 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_DELETE_ECLIST */
#line 1407
  [FI_ECLIST_DELETE_ECLIST] = "FI_ECLIST_DELETE_ECLIST",
#line 1418 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_DELETE_SET */
#line 1418
  [FI_ECLIST_DELETE_SET] = "FI_ECLIST_DELETE_SET",
#line 1425 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_DELETE_LC */
#line 1425
  [FI_LCLIST_DELETE_LC] = "FI_LCLIST_DELETE_LC",
#line 1432 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_DELETE_LCLIST */
#line 1432
  [FI_LCLIST_DELETE_LCLIST] = "FI_LCLIST_DELETE_LCLIST",
#line 1443 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_DELETE_SET */
#line 1443
  [FI_LCLIST_DELETE_SET] = "FI_LCLIST_DELETE_SET",
#line 1454 "filter/f-inst.c"
 /* Code enum to string for FI_PATH_FILTER_SET */
#line 1454
  [FI_PATH_FILTER_SET] = "FI_PATH_FILTER_SET",
#line 1461 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_FILTER_CLIST */
#line 1461
  [FI_CLIST_FILTER_CLIST] = "FI_CLIST_FILTER_CLIST",
#line 1472 "filter/f-inst.c"
 /* Code enum to string for FI_CLIST_FILTER_SET */
#line 1472
  [FI_CLIST_FILTER_SET] = "FI_CLIST_FILTER_SET",
#line 1479 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_FILTER_ECLIST */
#line 1479
  [FI_ECLIST_FILTER_ECLIST] = "FI_ECLIST_FILTER_ECLIST",
#line 1490 "filter/f-inst.c"
 /* Code enum to string for FI_ECLIST_FILTER_SET */
#line 1490
  [FI_ECLIST_FILTER_SET] = "FI_ECLIST_FILTER_SET",
#line 1497 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_FILTER_LCLIST */
#line 1497
  [FI_LCLIST_FILTER_LCLIST] = "FI_LCLIST_FILTER_LCLIST",
#line 1508 "filter/f-inst.c"
 /* Code enum to string for FI_LCLIST_FILTER_SET */
#line 1508
  [FI_LCLIST_FILTER_SET] = "FI_LCLIST_FILTER_SET",
#line 1530 "filter/f-inst.c"
 /* Code enum to string for FI_ROA_CHECK */
#line 1530
  [FI_ROA_CHECK] = "FI_ROA_CHECK",
#line 1546 "filter/f-inst.c"
 /* Code enum to string for FI_ASPA_CHECK_EXPLICIT */
#line 1546
  [FI_ASPA_CHECK_EXPLICIT] = "FI_ASPA_CHECK_EXPLICIT",
#line 1561 "filter/f-inst.c"
 /* Code enum to string for FI_FROM_HEX */
#line 1561
  [FI_FROM_HEX] = "FI_FROM_HEX",
#line 1566 "filter/f-inst.c"
 /* Code enum to string for FI_FORMAT */
#line 1566
  [FI_FORMAT] = "FI_FORMAT",
#line 830 "filter/decl.m4"
 /* Code enum to string for FI_ASSERT */
#line 830
  [FI_ASSERT] = "FI_ASSERT",
#line 547 "filter/decl.m4"

};

const char *
f_instruction_name_(enum f_instruction_code fi)
{
  if (fi < (sizeof(f_instruction_name_str) / sizeof(f_instruction_name_str[0])))
    return f_instruction_name_str[fi];
  else
    bug("Got unknown instruction code: %d", fi);
}

static inline struct f_inst *
fi_new(enum f_instruction_code fi_code)
{
  struct f_inst *what = tmp_allocz(sizeof(struct f_inst));
  what->lineno = ifs->lino;
  what->size = 1;
  what->fi_code = fi_code;
  return what;
}

static inline struct f_inst *
fi_constant(struct f_inst *what, struct f_val val)
{
  what->fi_code = FI_CONSTANT;
  what->i_FI_CONSTANT.val = val;
  return what;
}

int
f_const_promotion_(struct f_inst *arg, btype want, int update)
{
  if (arg->fi_code != FI_CONSTANT)
    return 0;

  struct f_val *c = &arg->i_FI_CONSTANT.val;

  if ((c->type == T_IP) && ipa_is_ip4(c->val.ip) && (want == T_QUAD)) {
    if (update)
      *c = (struct f_val) {
        .type = T_QUAD,
        .val.i = ipa_to_u32(c->val.ip),
      };
    return 1;
  }

  else if ((c->type == T_SET) && (!c->val.t) && (want == T_PREFIX_SET)) {
    if (update)
      *c = f_const_empty_prefix_set;
    return 1;
  }

  return 0;
}

#define v1 whati->f1->i_FI_CONSTANT.val
#define v2 whati->f2->i_FI_CONSTANT.val
#define v3 whati->f3->i_FI_CONSTANT.val
#define vv(i) items[i]->i_FI_CONSTANT.val
#define runtime(fmt, ...) cf_error("filter preevaluation, line %d: " fmt, ifs->lino, ##__VA_ARGS__)
#define fpool cfg_mem
#define falloc(size) cfg_alloc(size)
/* Instruction constructors */
#line 288 "filter/f-inst.c"
 /* Constructor for FI_ADD */
#line 288
struct f_inst *
#line 284 "filter/f-inst.c"
NONNULL(2)
#line 285 "filter/f-inst.c"
NONNULL(3)
#line 288 "filter/f-inst.c"
f_new_inst_FI_ADD(enum f_instruction_code fi_code
#line 284 "filter/f-inst.c"
  , struct f_inst * f1
#line 285 "filter/f-inst.c"
  , struct f_inst * f2
#line 288 "filter/f-inst.c"
)
#line 288
  {
#line 288
    /* Allocate the structure */
#line 288
    struct f_inst *what = fi_new(fi_code);
#line 288
    uint constargs = 1;
#line 288

#line 288
    /* Initialize all the members */
#line 288
  #define whati (&(what->i_FI_ADD))
#line 288
  #line 284 "filter/f-inst.c"
whati->f1 = f1;
#line 284
const struct f_inst *child1 = f1;
#line 284
do {
#line 284
  what->size += child1->size;
#line 284

#line 284
  if (child1->fi_code != FI_CONSTANT)
#line 284
    constargs = 0;
#line 284

#line 284
} while (child1 = child1->next);
#line 284

#line 284 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 284
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 284
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 285 "filter/f-inst.c"
whati->f2 = f2;
#line 285
const struct f_inst *child2 = f2;
#line 285
do {
#line 285
  what->size += child2->size;
#line 285

#line 285
  if (child2->fi_code != FI_CONSTANT)
#line 285
    constargs = 0;
#line 285

#line 285
} while (child2 = child2->next);
#line 285 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 285
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 285
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 286 "filter/f-inst.c"
what->type = T_INT;

#line 288 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 288
    if (!constargs)
#line 288
      return what;
#line 288

#line 288
    /* Try to pre-calculate the result */
#line 288
    #line 283 "filter/f-inst.c"
 {
    
#line 284 "filter/f-inst.c"
 #line 284 "filter/f-inst.c"
 ;
#line 285 "filter/f-inst.c"
    
#line 285 "filter/f-inst.c"
 #line 285 "filter/f-inst.c"
 ;
#line 286 "filter/f-inst.c"
     
#line 286 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i + v2.val.i } );
  }
  
  #undef whati
#line 288 "filter/f-inst.c"
  }
#line 288

#line 288

#line 293 "filter/f-inst.c"
 /* Constructor for FI_SUBTRACT */
#line 293
struct f_inst *
#line 289 "filter/f-inst.c"
NONNULL(2)
#line 290 "filter/f-inst.c"
NONNULL(3)
#line 293 "filter/f-inst.c"
f_new_inst_FI_SUBTRACT(enum f_instruction_code fi_code
#line 289 "filter/f-inst.c"
  , struct f_inst * f1
#line 290 "filter/f-inst.c"
  , struct f_inst * f2
#line 293 "filter/f-inst.c"
)
#line 293
  {
#line 293
    /* Allocate the structure */
#line 293
    struct f_inst *what = fi_new(fi_code);
#line 293
    uint constargs = 1;
#line 293

#line 293
    /* Initialize all the members */
#line 293
  #define whati (&(what->i_FI_SUBTRACT))
#line 293
  #line 289 "filter/f-inst.c"
whati->f1 = f1;
#line 289
const struct f_inst *child1 = f1;
#line 289
do {
#line 289
  what->size += child1->size;
#line 289

#line 289
  if (child1->fi_code != FI_CONSTANT)
#line 289
    constargs = 0;
#line 289

#line 289
} while (child1 = child1->next);
#line 289

#line 289 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 289
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 289
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 290 "filter/f-inst.c"
whati->f2 = f2;
#line 290
const struct f_inst *child2 = f2;
#line 290
do {
#line 290
  what->size += child2->size;
#line 290

#line 290
  if (child2->fi_code != FI_CONSTANT)
#line 290
    constargs = 0;
#line 290

#line 290
} while (child2 = child2->next);
#line 290 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 290
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 290
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 291 "filter/f-inst.c"
what->type = T_INT;

#line 293 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 293
    if (!constargs)
#line 293
      return what;
#line 293

#line 293
    /* Try to pre-calculate the result */
#line 293
    #line 288 "filter/f-inst.c"
 {
    
#line 289 "filter/f-inst.c"
 #line 289 "filter/f-inst.c"
 ;
#line 290 "filter/f-inst.c"
    
#line 290 "filter/f-inst.c"
 #line 290 "filter/f-inst.c"
 ;
#line 291 "filter/f-inst.c"
     
#line 291 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i - v2.val.i } );
  }
  
  #undef whati
#line 293 "filter/f-inst.c"
  }
#line 293

#line 293

#line 298 "filter/f-inst.c"
 /* Constructor for FI_MULTIPLY */
#line 298
struct f_inst *
#line 294 "filter/f-inst.c"
NONNULL(2)
#line 295 "filter/f-inst.c"
NONNULL(3)
#line 298 "filter/f-inst.c"
f_new_inst_FI_MULTIPLY(enum f_instruction_code fi_code
#line 294 "filter/f-inst.c"
  , struct f_inst * f1
#line 295 "filter/f-inst.c"
  , struct f_inst * f2
#line 298 "filter/f-inst.c"
)
#line 298
  {
#line 298
    /* Allocate the structure */
#line 298
    struct f_inst *what = fi_new(fi_code);
#line 298
    uint constargs = 1;
#line 298

#line 298
    /* Initialize all the members */
#line 298
  #define whati (&(what->i_FI_MULTIPLY))
#line 298
  #line 294 "filter/f-inst.c"
whati->f1 = f1;
#line 294
const struct f_inst *child1 = f1;
#line 294
do {
#line 294
  what->size += child1->size;
#line 294

#line 294
  if (child1->fi_code != FI_CONSTANT)
#line 294
    constargs = 0;
#line 294

#line 294
} while (child1 = child1->next);
#line 294

#line 294 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 294
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 294
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 295 "filter/f-inst.c"
whati->f2 = f2;
#line 295
const struct f_inst *child2 = f2;
#line 295
do {
#line 295
  what->size += child2->size;
#line 295

#line 295
  if (child2->fi_code != FI_CONSTANT)
#line 295
    constargs = 0;
#line 295

#line 295
} while (child2 = child2->next);
#line 295 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 295
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 295
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 296 "filter/f-inst.c"
what->type = T_INT;

#line 298 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 298
    if (!constargs)
#line 298
      return what;
#line 298

#line 298
    /* Try to pre-calculate the result */
#line 298
    #line 293 "filter/f-inst.c"
 {
    
#line 294 "filter/f-inst.c"
 #line 294 "filter/f-inst.c"
 ;
#line 295 "filter/f-inst.c"
    
#line 295 "filter/f-inst.c"
 #line 295 "filter/f-inst.c"
 ;
#line 296 "filter/f-inst.c"
     
#line 296 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i * v2.val.i } );
  }
  
  #undef whati
#line 298 "filter/f-inst.c"
  }
#line 298

#line 298

#line 304 "filter/f-inst.c"
 /* Constructor for FI_DIVIDE */
#line 304
struct f_inst *
#line 299 "filter/f-inst.c"
NONNULL(2)
#line 300 "filter/f-inst.c"
NONNULL(3)
#line 304 "filter/f-inst.c"
f_new_inst_FI_DIVIDE(enum f_instruction_code fi_code
#line 299 "filter/f-inst.c"
  , struct f_inst * f1
#line 300 "filter/f-inst.c"
  , struct f_inst * f2
#line 304 "filter/f-inst.c"
)
#line 304
  {
#line 304
    /* Allocate the structure */
#line 304
    struct f_inst *what = fi_new(fi_code);
#line 304
    uint constargs = 1;
#line 304

#line 304
    /* Initialize all the members */
#line 304
  #define whati (&(what->i_FI_DIVIDE))
#line 304
  #line 299 "filter/f-inst.c"
whati->f1 = f1;
#line 299
const struct f_inst *child1 = f1;
#line 299
do {
#line 299
  what->size += child1->size;
#line 299

#line 299
  if (child1->fi_code != FI_CONSTANT)
#line 299
    constargs = 0;
#line 299

#line 299
} while (child1 = child1->next);
#line 299

#line 299 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 299
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 299
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 300 "filter/f-inst.c"
whati->f2 = f2;
#line 300
const struct f_inst *child2 = f2;
#line 300
do {
#line 300
  what->size += child2->size;
#line 300

#line 300
  if (child2->fi_code != FI_CONSTANT)
#line 300
    constargs = 0;
#line 300

#line 300
} while (child2 = child2->next);
#line 300 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 300
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 300
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 302 "filter/f-inst.c"
what->type = T_INT;

#line 304 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 304
    if (!constargs)
#line 304
      return what;
#line 304

#line 304
    /* Try to pre-calculate the result */
#line 304
    #line 298 "filter/f-inst.c"
 {
    
#line 299 "filter/f-inst.c"
 #line 299 "filter/f-inst.c"
 ;
#line 300 "filter/f-inst.c"
    
#line 300 "filter/f-inst.c"
 #line 300 "filter/f-inst.c"
 ;
#line 301 "filter/f-inst.c"
    if (v2.val.i == 0) runtime( "Mother told me not to divide by 0" );
     
#line 302 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i / v2.val.i } );
  }
  
  #undef whati
#line 304 "filter/f-inst.c"
  }
#line 304

#line 304

#line 309 "filter/f-inst.c"
 /* Constructor for FI_BITOR */
#line 309
struct f_inst *
#line 305 "filter/f-inst.c"
NONNULL(2)
#line 306 "filter/f-inst.c"
NONNULL(3)
#line 309 "filter/f-inst.c"
f_new_inst_FI_BITOR(enum f_instruction_code fi_code
#line 305 "filter/f-inst.c"
  , struct f_inst * f1
#line 306 "filter/f-inst.c"
  , struct f_inst * f2
#line 309 "filter/f-inst.c"
)
#line 309
  {
#line 309
    /* Allocate the structure */
#line 309
    struct f_inst *what = fi_new(fi_code);
#line 309
    uint constargs = 1;
#line 309

#line 309
    /* Initialize all the members */
#line 309
  #define whati (&(what->i_FI_BITOR))
#line 309
  #line 305 "filter/f-inst.c"
whati->f1 = f1;
#line 305
const struct f_inst *child1 = f1;
#line 305
do {
#line 305
  what->size += child1->size;
#line 305

#line 305
  if (child1->fi_code != FI_CONSTANT)
#line 305
    constargs = 0;
#line 305

#line 305
} while (child1 = child1->next);
#line 305

#line 305 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 305
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 305
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 306 "filter/f-inst.c"
whati->f2 = f2;
#line 306
const struct f_inst *child2 = f2;
#line 306
do {
#line 306
  what->size += child2->size;
#line 306

#line 306
  if (child2->fi_code != FI_CONSTANT)
#line 306
    constargs = 0;
#line 306

#line 306
} while (child2 = child2->next);
#line 306 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 306
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 306
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 307 "filter/f-inst.c"
what->type = T_INT;

#line 309 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 309
    if (!constargs)
#line 309
      return what;
#line 309

#line 309
    /* Try to pre-calculate the result */
#line 309
    #line 304 "filter/f-inst.c"
 {
    
#line 305 "filter/f-inst.c"
 #line 305 "filter/f-inst.c"
 ;
#line 306 "filter/f-inst.c"
    
#line 306 "filter/f-inst.c"
 #line 306 "filter/f-inst.c"
 ;
#line 307 "filter/f-inst.c"
     
#line 307 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i | v2.val.i } );
  }
  
  #undef whati
#line 309 "filter/f-inst.c"
  }
#line 309

#line 309

#line 314 "filter/f-inst.c"
 /* Constructor for FI_BITAND */
#line 314
struct f_inst *
#line 310 "filter/f-inst.c"
NONNULL(2)
#line 311 "filter/f-inst.c"
NONNULL(3)
#line 314 "filter/f-inst.c"
f_new_inst_FI_BITAND(enum f_instruction_code fi_code
#line 310 "filter/f-inst.c"
  , struct f_inst * f1
#line 311 "filter/f-inst.c"
  , struct f_inst * f2
#line 314 "filter/f-inst.c"
)
#line 314
  {
#line 314
    /* Allocate the structure */
#line 314
    struct f_inst *what = fi_new(fi_code);
#line 314
    uint constargs = 1;
#line 314

#line 314
    /* Initialize all the members */
#line 314
  #define whati (&(what->i_FI_BITAND))
#line 314
  #line 310 "filter/f-inst.c"
whati->f1 = f1;
#line 310
const struct f_inst *child1 = f1;
#line 310
do {
#line 310
  what->size += child1->size;
#line 310

#line 310
  if (child1->fi_code != FI_CONSTANT)
#line 310
    constargs = 0;
#line 310

#line 310
} while (child1 = child1->next);
#line 310

#line 310 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 310
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 310
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 311 "filter/f-inst.c"
whati->f2 = f2;
#line 311
const struct f_inst *child2 = f2;
#line 311
do {
#line 311
  what->size += child2->size;
#line 311

#line 311
  if (child2->fi_code != FI_CONSTANT)
#line 311
    constargs = 0;
#line 311

#line 311
} while (child2 = child2->next);
#line 311 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 311
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 311
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 312 "filter/f-inst.c"
what->type = T_INT;

#line 314 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 314
    if (!constargs)
#line 314
      return what;
#line 314

#line 314
    /* Try to pre-calculate the result */
#line 314
    #line 309 "filter/f-inst.c"
 {
    
#line 310 "filter/f-inst.c"
 #line 310 "filter/f-inst.c"
 ;
#line 311 "filter/f-inst.c"
    
#line 311 "filter/f-inst.c"
 #line 311 "filter/f-inst.c"
 ;
#line 312 "filter/f-inst.c"
     
#line 312 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i & v2.val.i } );
  }
  
  #undef whati
#line 314 "filter/f-inst.c"
  }
#line 314

#line 314

#line 324 "filter/f-inst.c"
 /* Constructor for FI_AND */
#line 324
struct f_inst *
#line 315 "filter/f-inst.c"
NONNULL(2)
#line 324 "filter/f-inst.c"
f_new_inst_FI_AND(enum f_instruction_code fi_code
#line 315 "filter/f-inst.c"
  , struct f_inst * f1
#line 320 "filter/f-inst.c"
  , struct f_inst * f2
#line 324 "filter/f-inst.c"
)
#line 324
  {
#line 324
    /* Allocate the structure */
#line 324
    struct f_inst *what = fi_new(fi_code);
#line 324
    uint constargs = 1;
#line 324

#line 324
    /* Initialize all the members */
#line 324
  #define whati (&(what->i_FI_AND))
#line 324
  #line 315 "filter/f-inst.c"
whati->f1 = f1;
#line 315
const struct f_inst *child1 = f1;
#line 315
do {
#line 315
  what->size += child1->size;
#line 315

#line 315
  if (child1->fi_code != FI_CONSTANT)
#line 315
    constargs = 0;
#line 315

#line 315
} while (child1 = child1->next);
#line 315

#line 315 "filter/f-inst.c"
if (f1->type && (f1->type != (T_BOOL)) && !f_const_promotion(f1, (T_BOOL)))
#line 315
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 315
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f1->type));
#line 316 "filter/f-inst.c"
if (f2->type && (f2->type != (T_BOOL)) && !f_const_promotion(f2, (T_BOOL)))
#line 316
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 316
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f2->type));
#line 317 "filter/f-inst.c"
what->type = T_BOOL;
#line 320 "filter/f-inst.c"
whati->f2 = f2;

#line 324 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 324
    if (!constargs)
#line 324
      return what;
#line 324

#line 324
    /* Try to pre-calculate the result */
#line 324
    #line 314 "filter/f-inst.c"
 {
    
#line 315 "filter/f-inst.c"
 #line 315 "filter/f-inst.c"
 ;
#line 316 "filter/f-inst.c"
    #line 316 "filter/f-inst.c"
;
     
#line 317 "filter/f-inst.c"
;

    if (v1.val.i)
      
#line 320 "filter/f-inst.c"
return whati->f2
#line 320
;
    else
      return fi_constant(what, v1);
  }
  
  #undef whati
#line 324 "filter/f-inst.c"
  }
#line 324

#line 324

#line 335 "filter/f-inst.c"
 /* Constructor for FI_OR */
#line 335
struct f_inst *
#line 325 "filter/f-inst.c"
NONNULL(2)
#line 335 "filter/f-inst.c"
f_new_inst_FI_OR(enum f_instruction_code fi_code
#line 325 "filter/f-inst.c"
  , struct f_inst * f1
#line 330 "filter/f-inst.c"
  , struct f_inst * f2
#line 335 "filter/f-inst.c"
)
#line 335
  {
#line 335
    /* Allocate the structure */
#line 335
    struct f_inst *what = fi_new(fi_code);
#line 335
    uint constargs = 1;
#line 335

#line 335
    /* Initialize all the members */
#line 335
  #define whati (&(what->i_FI_OR))
#line 335
  #line 325 "filter/f-inst.c"
whati->f1 = f1;
#line 325
const struct f_inst *child1 = f1;
#line 325
do {
#line 325
  what->size += child1->size;
#line 325

#line 325
  if (child1->fi_code != FI_CONSTANT)
#line 325
    constargs = 0;
#line 325

#line 325
} while (child1 = child1->next);
#line 325

#line 325 "filter/f-inst.c"
if (f1->type && (f1->type != (T_BOOL)) && !f_const_promotion(f1, (T_BOOL)))
#line 325
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 325
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f1->type));
#line 326 "filter/f-inst.c"
if (f2->type && (f2->type != (T_BOOL)) && !f_const_promotion(f2, (T_BOOL)))
#line 326
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 326
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f2->type));
#line 327 "filter/f-inst.c"
what->type = T_BOOL;
#line 330 "filter/f-inst.c"
whati->f2 = f2;

#line 335 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 335
    if (!constargs)
#line 335
      return what;
#line 335

#line 335
    /* Try to pre-calculate the result */
#line 335
    #line 324 "filter/f-inst.c"
 {
    
#line 325 "filter/f-inst.c"
 #line 325 "filter/f-inst.c"
 ;
#line 326 "filter/f-inst.c"
    #line 326 "filter/f-inst.c"
;
     
#line 327 "filter/f-inst.c"
;

    if (!v1.val.i)
      
#line 330 "filter/f-inst.c"
return whati->f2
#line 330
;
    else
      return fi_constant(what, v1);
  }

  
  #undef whati
#line 335 "filter/f-inst.c"
  }
#line 335

#line 335

#line 345 "filter/f-inst.c"
 /* Constructor for FI_PAIR_CONSTRUCT */
#line 345
struct f_inst *
#line 336 "filter/f-inst.c"
NONNULL(2)
#line 337 "filter/f-inst.c"
NONNULL(3)
#line 345 "filter/f-inst.c"
f_new_inst_FI_PAIR_CONSTRUCT(enum f_instruction_code fi_code
#line 336 "filter/f-inst.c"
  , struct f_inst * f1
#line 337 "filter/f-inst.c"
  , struct f_inst * f2
#line 345 "filter/f-inst.c"
)
#line 345
  {
#line 345
    /* Allocate the structure */
#line 345
    struct f_inst *what = fi_new(fi_code);
#line 345
    uint constargs = 1;
#line 345

#line 345
    /* Initialize all the members */
#line 345
  #define whati (&(what->i_FI_PAIR_CONSTRUCT))
#line 345
  #line 336 "filter/f-inst.c"
whati->f1 = f1;
#line 336
const struct f_inst *child1 = f1;
#line 336
do {
#line 336
  what->size += child1->size;
#line 336

#line 336
  if (child1->fi_code != FI_CONSTANT)
#line 336
    constargs = 0;
#line 336

#line 336
} while (child1 = child1->next);
#line 336

#line 336 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 336
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 336
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 337 "filter/f-inst.c"
whati->f2 = f2;
#line 337
const struct f_inst *child2 = f2;
#line 337
do {
#line 337
  what->size += child2->size;
#line 337

#line 337
  if (child2->fi_code != FI_CONSTANT)
#line 337
    constargs = 0;
#line 337

#line 337
} while (child2 = child2->next);
#line 337 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 337
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 337
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 342 "filter/f-inst.c"
what->type = T_PAIR;

#line 345 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 345
    if (!constargs)
#line 345
      return what;
#line 345

#line 345
    /* Try to pre-calculate the result */
#line 345
    #line 335 "filter/f-inst.c"
 {
    
#line 336 "filter/f-inst.c"
 #line 336 "filter/f-inst.c"
 ;
#line 337 "filter/f-inst.c"
    
#line 337 "filter/f-inst.c"
 #line 337 "filter/f-inst.c"
 ;
#line 338 "filter/f-inst.c"
    uint u1 = v1.val.i;
    uint u2 = v2.val.i;
    if ((u1 > 0xFFFF) || (u2 > 0xFFFF))
      runtime( "Can't operate with value out of bounds in pair constructor" );
     
#line 342 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PAIR, .val.i = (u1 << 16) | u2 } );
  }

  
  #undef whati
#line 345 "filter/f-inst.c"
  }
#line 345

#line 345

#line 385 "filter/f-inst.c"
 /* Constructor for FI_EC_CONSTRUCT */
#line 385
struct f_inst *
#line 346 "filter/f-inst.c"
NONNULL(2)
#line 347 "filter/f-inst.c"
NONNULL(3)
#line 385 "filter/f-inst.c"
f_new_inst_FI_EC_CONSTRUCT(enum f_instruction_code fi_code
#line 346 "filter/f-inst.c"
  , struct f_inst * f1
#line 347 "filter/f-inst.c"
  , struct f_inst * f2
#line 349 "filter/f-inst.c"
  , enum ec_subtype ecs
#line 385 "filter/f-inst.c"
)
#line 385
  {
#line 385
    /* Allocate the structure */
#line 385
    struct f_inst *what = fi_new(fi_code);
#line 385
    uint constargs = 1;
#line 385

#line 385
    /* Initialize all the members */
#line 385
  #define whati (&(what->i_FI_EC_CONSTRUCT))
#line 385
  #line 346 "filter/f-inst.c"
whati->f1 = f1;
#line 346
const struct f_inst *child1 = f1;
#line 346
do {
#line 346
  what->size += child1->size;
#line 346

#line 346
  if (child1->fi_code != FI_CONSTANT)
#line 346
    constargs = 0;
#line 346

#line 346
} while (child1 = child1->next);
#line 346

#line 347 "filter/f-inst.c"
whati->f2 = f2;
#line 347
const struct f_inst *child2 = f2;
#line 347
do {
#line 347
  what->size += child2->size;
#line 347

#line 347
  if (child2->fi_code != FI_CONSTANT)
#line 347
    constargs = 0;
#line 347

#line 347
} while (child2 = child2->next);
#line 347 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 347
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 347
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 349 "filter/f-inst.c"
whati->ecs = ecs;
#line 370 "filter/f-inst.c"
what->type = T_EC;

#line 385 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 385
    if (!constargs)
#line 385
      return what;
#line 385

#line 385
    /* Try to pre-calculate the result */
#line 385
    #line 345 "filter/f-inst.c"
 {
    
#line 346 "filter/f-inst.c"
;
    
#line 347 "filter/f-inst.c"
 #line 347 "filter/f-inst.c"
 ;
#line 348 "filter/f-inst.c"

    #line 349 "filter/f-inst.c"
;

    int ipv4_used;
    u32 key, val;

    if (v1.type == T_INT) {
      ipv4_used = 0; key = v1.val.i;
    }
    else if (v1.type == T_QUAD) {
      ipv4_used = 1; key = v1.val.i;
    }
    /* IP->Quad implicit conversion */
    else if (val_is_ip4(&v1)) {
      ipv4_used = 1; key = ipa_to_u32(v1.val.ip);
    }
    else
      runtime("Argument 1 of EC constructor must be integer or IPv4 address, got 0x%02x", v1.type);

    val = v2.val.i;

    if (ecs == EC_GENERIC)
       
#line 370 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ec_generic(key, val) } );
    else if (ipv4_used)
      if (val <= 0xFFFF)
	 return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ec_ip4(ecs, key, val) } );
      else
	runtime("4-byte value %u can't be used with IP-address key in extended community", val);
    else if (key < 0x10000)
       return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ec_as2(ecs, key, val) } );
    else
      if (val <= 0xFFFF)
	 return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ec_as4(ecs, key, val) } );
      else
	runtime("4-byte value %u can't be used with 4-byte ASN in extended community", val);
  }

  
  #undef whati
#line 385 "filter/f-inst.c"
  }
#line 385

#line 385

#line 392 "filter/f-inst.c"
 /* Constructor for FI_LC_CONSTRUCT */
#line 392
struct f_inst *
#line 386 "filter/f-inst.c"
NONNULL(2)
#line 387 "filter/f-inst.c"
NONNULL(3)
#line 388 "filter/f-inst.c"
NONNULL(4)
#line 392 "filter/f-inst.c"
f_new_inst_FI_LC_CONSTRUCT(enum f_instruction_code fi_code
#line 386 "filter/f-inst.c"
  , struct f_inst * f1
#line 387 "filter/f-inst.c"
  , struct f_inst * f2
#line 388 "filter/f-inst.c"
  , struct f_inst * f3
#line 392 "filter/f-inst.c"
)
#line 392
  {
#line 392
    /* Allocate the structure */
#line 392
    struct f_inst *what = fi_new(fi_code);
#line 392
    uint constargs = 1;
#line 392

#line 392
    /* Initialize all the members */
#line 392
  #define whati (&(what->i_FI_LC_CONSTRUCT))
#line 392
  #line 386 "filter/f-inst.c"
whati->f1 = f1;
#line 386
const struct f_inst *child1 = f1;
#line 386
do {
#line 386
  what->size += child1->size;
#line 386

#line 386
  if (child1->fi_code != FI_CONSTANT)
#line 386
    constargs = 0;
#line 386

#line 386
} while (child1 = child1->next);
#line 386

#line 386 "filter/f-inst.c"
if (f1->type && (f1->type != (T_INT)) && !f_const_promotion(f1, (T_INT)))
#line 386
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 386
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f1->type));
#line 387 "filter/f-inst.c"
whati->f2 = f2;
#line 387
const struct f_inst *child2 = f2;
#line 387
do {
#line 387
  what->size += child2->size;
#line 387

#line 387
  if (child2->fi_code != FI_CONSTANT)
#line 387
    constargs = 0;
#line 387

#line 387
} while (child2 = child2->next);
#line 387 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 387
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 387
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 388 "filter/f-inst.c"
whati->f3 = f3;
#line 388
const struct f_inst *child3 = f3;
#line 388
do {
#line 388
  what->size += child3->size;
#line 388

#line 388
  if (child3->fi_code != FI_CONSTANT)
#line 388
    constargs = 0;
#line 388

#line 388
} while (child3 = child3->next);
#line 388 "filter/f-inst.c"
if (f3->type && (f3->type != (T_INT)) && !f_const_promotion(f3, (T_INT)))
#line 388
  cf_error("Argument 3 of %s must be of type %s, got type %s",
#line 388
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f3->type));
#line 389 "filter/f-inst.c"
what->type = T_LC;

#line 392 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 392
    if (!constargs)
#line 392
      return what;
#line 392

#line 392
    /* Try to pre-calculate the result */
#line 392
    #line 385 "filter/f-inst.c"
 {
    
#line 386 "filter/f-inst.c"
 #line 386 "filter/f-inst.c"
 ;
#line 387 "filter/f-inst.c"
    
#line 387 "filter/f-inst.c"
 #line 387 "filter/f-inst.c"
 ;
#line 388 "filter/f-inst.c"
    
#line 388 "filter/f-inst.c"
 #line 388 "filter/f-inst.c"
 ;
#line 389 "filter/f-inst.c"
     
#line 389 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LC, .val.lc = (lcomm) { v1.val.i, v2.val.i, v3.val.i } } );
  }

  
  #undef whati
#line 392 "filter/f-inst.c"
  }
#line 392

#line 392

#line 442 "filter/f-inst.c"
 /* Constructor for FI_PATHMASK_CONSTRUCT */
#line 442
struct f_inst *
#line 442
f_new_inst_FI_PATHMASK_CONSTRUCT(enum f_instruction_code fi_code
#line 393 "filter/f-inst.c"
  , struct f_inst * fvar
#line 442 "filter/f-inst.c"
)
#line 442
  {
#line 442
    /* Allocate the structure */
#line 442
    struct f_inst *what = fi_new(fi_code);
#line 442
    uint constargs = 1;
#line 442

#line 442
    /* Initialize all the members */
#line 442
  #define whati (&(what->i_FI_PATHMASK_CONSTRUCT))
#line 442
  #line 393 "filter/f-inst.c"
whati->varcount = 0;
#line 393
whati->fvar = fvar;
#line 393
for (const struct f_inst *child = fvar; child; child = child->next, whati->varcount++) {
#line 393
  what->size += child->size;
#line 393

#line 393
  if (child->fi_code != FI_CONSTANT)
#line 393
    constargs = 0;
#line 393

#line 393
}
#line 393

#line 393
  const struct f_inst **items = NULL;
#line 393
  if (constargs && whati->varcount) {
#line 393
    items = alloca(whati->varcount * sizeof(struct f_inst *));
#line 393
    const struct f_inst *child = fvar;
#line 393
    for (uint i=0; child; i++)
#line 393
      child = (items[i] = child)->next;
#line 393
  }
#line 393

#line 437 "filter/f-inst.c"
what->type = T_PATH_MASK;

#line 442 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 442
    if (!constargs)
#line 442
      return what;
#line 442

#line 442
    /* Try to pre-calculate the result */
#line 442
    #line 392 "filter/f-inst.c"
 {
    
#line 393 "filter/f-inst.c"

#line 393

#line 393
;

    struct f_path_mask *pm = falloc(sizeof(struct f_path_mask) + whati->varcount * sizeof(struct f_path_mask_item));
    pm->len = whati->varcount;

    for (uint i=0; i<whati->varcount; i++) {
      switch (vv(i).type) {
	case T_PATH_MASK_ITEM:
	  if (vv(i).val.pmi.kind == PM_LOOP)
	  {
	    if (i == 0)
	      runtime("Path mask iterator '+' cannot be first");

	    /* We want PM_LOOP as prefix operator */
	    pm->item[i] = pm->item[i - 1];
	    pm->item[i - 1] = vv(i).val.pmi;
	    break;
	  }

	  pm->item[i] = vv(i).val.pmi;
	  break;

	case T_INT:
	  pm->item[i] = (struct f_path_mask_item) {
	    .asn = vv(i).val.i,
	    .kind = PM_ASN,
	  };
	  break;

	case T_SET:
	  if (!path_set_type(vv(i).val.t))
	    runtime("Only integer sets allowed in path mask");

	  pm->item[i] = (struct f_path_mask_item) {
	    .set = vv(i).val.t,
	    .kind = PM_ASN_SET,
	  };
	  break;

	default:
	  runtime( "Error resolving path mask template: value not an integer" );
      }
    }

     
#line 437 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH_MASK, .val.path_mask = pm } );
  }

/* Relational operators */

  
  #undef whati
#line 442 "filter/f-inst.c"
  }
#line 442

#line 442

#line 449 "filter/f-inst.c"
 /* Constructor for FI_NEQ */
#line 449
struct f_inst *
#line 443 "filter/f-inst.c"
NONNULL(2)
#line 444 "filter/f-inst.c"
NONNULL(3)
#line 449 "filter/f-inst.c"
f_new_inst_FI_NEQ(enum f_instruction_code fi_code
#line 443 "filter/f-inst.c"
  , struct f_inst * f1
#line 444 "filter/f-inst.c"
  , struct f_inst * f2
#line 449 "filter/f-inst.c"
)
#line 449
  {
#line 449
    /* Allocate the structure */
#line 449
    struct f_inst *what = fi_new(fi_code);
#line 449
    uint constargs = 1;
#line 449

#line 449
    /* Initialize all the members */
#line 449
  #define whati (&(what->i_FI_NEQ))
#line 449
  #line 443 "filter/f-inst.c"
whati->f1 = f1;
#line 443
const struct f_inst *child1 = f1;
#line 443
do {
#line 443
  what->size += child1->size;
#line 443

#line 443
  if (child1->fi_code != FI_CONSTANT)
#line 443
    constargs = 0;
#line 443

#line 443
} while (child1 = child1->next);
#line 443

#line 444 "filter/f-inst.c"
whati->f2 = f2;
#line 444
const struct f_inst *child2 = f2;
#line 444
do {
#line 444
  what->size += child2->size;
#line 444

#line 444
  if (child2->fi_code != FI_CONSTANT)
#line 444
    constargs = 0;
#line 444

#line 444
} while (child2 = child2->next);
if (f1->type && f2->type && (f1->type != f2->type))
#line 445 "filter/f-inst.c"
   (void) (f_const_promotion(f2, f1->type) || f_const_promotion(f1, f2->type));
#line 446 "filter/f-inst.c"
what->type = T_BOOL;

#line 449 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 449
    if (!constargs)
#line 449
      return what;
#line 449

#line 449
    /* Try to pre-calculate the result */
#line 449
    #line 442 "filter/f-inst.c"
 {
    
#line 443 "filter/f-inst.c"
;
    
#line 444 "filter/f-inst.c"
;
    #line 445 "filter/f-inst.c"
;
     
#line 446 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = !val_same(&v1, &v2) } );
  }

  
  #undef whati
#line 449 "filter/f-inst.c"
  }
#line 449

#line 449

#line 456 "filter/f-inst.c"
 /* Constructor for FI_EQ */
#line 456
struct f_inst *
#line 450 "filter/f-inst.c"
NONNULL(2)
#line 451 "filter/f-inst.c"
NONNULL(3)
#line 456 "filter/f-inst.c"
f_new_inst_FI_EQ(enum f_instruction_code fi_code
#line 450 "filter/f-inst.c"
  , struct f_inst * f1
#line 451 "filter/f-inst.c"
  , struct f_inst * f2
#line 456 "filter/f-inst.c"
)
#line 456
  {
#line 456
    /* Allocate the structure */
#line 456
    struct f_inst *what = fi_new(fi_code);
#line 456
    uint constargs = 1;
#line 456

#line 456
    /* Initialize all the members */
#line 456
  #define whati (&(what->i_FI_EQ))
#line 456
  #line 450 "filter/f-inst.c"
whati->f1 = f1;
#line 450
const struct f_inst *child1 = f1;
#line 450
do {
#line 450
  what->size += child1->size;
#line 450

#line 450
  if (child1->fi_code != FI_CONSTANT)
#line 450
    constargs = 0;
#line 450

#line 450
} while (child1 = child1->next);
#line 450

#line 451 "filter/f-inst.c"
whati->f2 = f2;
#line 451
const struct f_inst *child2 = f2;
#line 451
do {
#line 451
  what->size += child2->size;
#line 451

#line 451
  if (child2->fi_code != FI_CONSTANT)
#line 451
    constargs = 0;
#line 451

#line 451
} while (child2 = child2->next);
if (f1->type && f2->type && (f1->type != f2->type))
#line 452 "filter/f-inst.c"
   (void) (f_const_promotion(f2, f1->type) || f_const_promotion(f1, f2->type));
#line 453 "filter/f-inst.c"
what->type = T_BOOL;

#line 456 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 456
    if (!constargs)
#line 456
      return what;
#line 456

#line 456
    /* Try to pre-calculate the result */
#line 456
    #line 449 "filter/f-inst.c"
 {
    
#line 450 "filter/f-inst.c"
;
    
#line 451 "filter/f-inst.c"
;
    #line 452 "filter/f-inst.c"
;
     
#line 453 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = val_same(&v1, &v2) } );
  }

  
  #undef whati
#line 456 "filter/f-inst.c"
  }
#line 456

#line 456

#line 467 "filter/f-inst.c"
 /* Constructor for FI_LT */
#line 467
struct f_inst *
#line 457 "filter/f-inst.c"
NONNULL(2)
#line 458 "filter/f-inst.c"
NONNULL(3)
#line 467 "filter/f-inst.c"
f_new_inst_FI_LT(enum f_instruction_code fi_code
#line 457 "filter/f-inst.c"
  , struct f_inst * f1
#line 458 "filter/f-inst.c"
  , struct f_inst * f2
#line 467 "filter/f-inst.c"
)
#line 467
  {
#line 467
    /* Allocate the structure */
#line 467
    struct f_inst *what = fi_new(fi_code);
#line 467
    uint constargs = 1;
#line 467

#line 467
    /* Initialize all the members */
#line 467
  #define whati (&(what->i_FI_LT))
#line 467
  #line 457 "filter/f-inst.c"
whati->f1 = f1;
#line 457
const struct f_inst *child1 = f1;
#line 457
do {
#line 457
  what->size += child1->size;
#line 457

#line 457
  if (child1->fi_code != FI_CONSTANT)
#line 457
    constargs = 0;
#line 457

#line 457
} while (child1 = child1->next);
#line 457

#line 458 "filter/f-inst.c"
whati->f2 = f2;
#line 458
const struct f_inst *child2 = f2;
#line 458
do {
#line 458
  what->size += child2->size;
#line 458

#line 458
  if (child2->fi_code != FI_CONSTANT)
#line 458
    constargs = 0;
#line 458

#line 458
} while (child2 = child2->next);
if (f1->type && f2->type && (f1->type != f2->type) &&
#line 459 "filter/f-inst.c"
   !f_const_promotion(f2, f1->type) && !f_const_promotion(f1, f2->type))
#line 459
  cf_error("Arguments 1 and 2 of %s must be of the same type", f_instruction_name(what->fi_code));
#line 464 "filter/f-inst.c"
what->type = T_BOOL;

#line 467 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 467
    if (!constargs)
#line 467
      return what;
#line 467

#line 467
    /* Try to pre-calculate the result */
#line 467
    #line 456 "filter/f-inst.c"
 {
    
#line 457 "filter/f-inst.c"
;
    
#line 458 "filter/f-inst.c"
;
    #line 459 "filter/f-inst.c"
;

    int i = val_compare(&v1, &v2);
    if (i == F_CMP_ERROR)
      runtime( "Can't compare values of incompatible types" );
     
#line 464 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = (i == -1) } );
  }

  
  #undef whati
#line 467 "filter/f-inst.c"
  }
#line 467

#line 467

#line 478 "filter/f-inst.c"
 /* Constructor for FI_LTE */
#line 478
struct f_inst *
#line 468 "filter/f-inst.c"
NONNULL(2)
#line 469 "filter/f-inst.c"
NONNULL(3)
#line 478 "filter/f-inst.c"
f_new_inst_FI_LTE(enum f_instruction_code fi_code
#line 468 "filter/f-inst.c"
  , struct f_inst * f1
#line 469 "filter/f-inst.c"
  , struct f_inst * f2
#line 478 "filter/f-inst.c"
)
#line 478
  {
#line 478
    /* Allocate the structure */
#line 478
    struct f_inst *what = fi_new(fi_code);
#line 478
    uint constargs = 1;
#line 478

#line 478
    /* Initialize all the members */
#line 478
  #define whati (&(what->i_FI_LTE))
#line 478
  #line 468 "filter/f-inst.c"
whati->f1 = f1;
#line 468
const struct f_inst *child1 = f1;
#line 468
do {
#line 468
  what->size += child1->size;
#line 468

#line 468
  if (child1->fi_code != FI_CONSTANT)
#line 468
    constargs = 0;
#line 468

#line 468
} while (child1 = child1->next);
#line 468

#line 469 "filter/f-inst.c"
whati->f2 = f2;
#line 469
const struct f_inst *child2 = f2;
#line 469
do {
#line 469
  what->size += child2->size;
#line 469

#line 469
  if (child2->fi_code != FI_CONSTANT)
#line 469
    constargs = 0;
#line 469

#line 469
} while (child2 = child2->next);
if (f1->type && f2->type && (f1->type != f2->type) &&
#line 470 "filter/f-inst.c"
   !f_const_promotion(f2, f1->type) && !f_const_promotion(f1, f2->type))
#line 470
  cf_error("Arguments 1 and 2 of %s must be of the same type", f_instruction_name(what->fi_code));
#line 475 "filter/f-inst.c"
what->type = T_BOOL;

#line 478 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 478
    if (!constargs)
#line 478
      return what;
#line 478

#line 478
    /* Try to pre-calculate the result */
#line 478
    #line 467 "filter/f-inst.c"
 {
    
#line 468 "filter/f-inst.c"
;
    
#line 469 "filter/f-inst.c"
;
    #line 470 "filter/f-inst.c"
;

    int i = val_compare(&v1, &v2);
    if (i == F_CMP_ERROR)
      runtime( "Can't compare values of incompatible types" );
     
#line 475 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = (i != 1) } );
  }

  
  #undef whati
#line 478 "filter/f-inst.c"
  }
#line 478

#line 478

#line 483 "filter/f-inst.c"
 /* Constructor for FI_NOT */
#line 483
struct f_inst *
#line 479 "filter/f-inst.c"
NONNULL(2)
#line 483 "filter/f-inst.c"
f_new_inst_FI_NOT(enum f_instruction_code fi_code
#line 479 "filter/f-inst.c"
  , struct f_inst * f1
#line 483 "filter/f-inst.c"
)
#line 483
  {
#line 483
    /* Allocate the structure */
#line 483
    struct f_inst *what = fi_new(fi_code);
#line 483
    uint constargs = 1;
#line 483

#line 483
    /* Initialize all the members */
#line 483
  #define whati (&(what->i_FI_NOT))
#line 483
  #line 479 "filter/f-inst.c"
whati->f1 = f1;
#line 479
const struct f_inst *child1 = f1;
#line 479
do {
#line 479
  what->size += child1->size;
#line 479

#line 479
  if (child1->fi_code != FI_CONSTANT)
#line 479
    constargs = 0;
#line 479

#line 479
} while (child1 = child1->next);
#line 479

#line 479 "filter/f-inst.c"
if (f1->type && (f1->type != (T_BOOL)) && !f_const_promotion(f1, (T_BOOL)))
#line 479
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 479
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f1->type));
#line 480 "filter/f-inst.c"
what->type = T_BOOL;

#line 483 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 483
    if (!constargs)
#line 483
      return what;
#line 483

#line 483
    /* Try to pre-calculate the result */
#line 483
    #line 478 "filter/f-inst.c"
 {
    
#line 479 "filter/f-inst.c"
 #line 479 "filter/f-inst.c"
 ;
#line 480 "filter/f-inst.c"
     
#line 480 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = !v1.val.i } );
  }

  
  #undef whati
#line 483 "filter/f-inst.c"
  }
#line 483

#line 483

#line 492 "filter/f-inst.c"
 /* Constructor for FI_MATCH */
#line 492
struct f_inst *
#line 484 "filter/f-inst.c"
NONNULL(2)
#line 485 "filter/f-inst.c"
NONNULL(3)
#line 492 "filter/f-inst.c"
f_new_inst_FI_MATCH(enum f_instruction_code fi_code
#line 484 "filter/f-inst.c"
  , struct f_inst * f1
#line 485 "filter/f-inst.c"
  , struct f_inst * f2
#line 492 "filter/f-inst.c"
)
#line 492
  {
#line 492
    /* Allocate the structure */
#line 492
    struct f_inst *what = fi_new(fi_code);
#line 492
    uint constargs = 1;
#line 492

#line 492
    /* Initialize all the members */
#line 492
  #define whati (&(what->i_FI_MATCH))
#line 492
  #line 484 "filter/f-inst.c"
whati->f1 = f1;
#line 484
const struct f_inst *child1 = f1;
#line 484
do {
#line 484
  what->size += child1->size;
#line 484

#line 484
  if (child1->fi_code != FI_CONSTANT)
#line 484
    constargs = 0;
#line 484

#line 484
} while (child1 = child1->next);
#line 484

#line 485 "filter/f-inst.c"
whati->f2 = f2;
#line 485
const struct f_inst *child2 = f2;
#line 485
do {
#line 485
  what->size += child2->size;
#line 485

#line 485
  if (child2->fi_code != FI_CONSTANT)
#line 485
    constargs = 0;
#line 485

#line 485
} while (child2 = child2->next);
#line 489 "filter/f-inst.c"
what->type = T_BOOL;

#line 492 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 492
    if (!constargs)
#line 492
      return what;
#line 492

#line 492
    /* Try to pre-calculate the result */
#line 492
    #line 483 "filter/f-inst.c"
 {
    
#line 484 "filter/f-inst.c"
;
    
#line 485 "filter/f-inst.c"
;
    int i = val_in_range(&v1, &v2);
    if (i == F_CMP_ERROR)
      runtime( "~ applied on unknown type pair" );
     
#line 489 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = !!i } );
  }

  
  #undef whati
#line 492 "filter/f-inst.c"
  }
#line 492

#line 492

#line 501 "filter/f-inst.c"
 /* Constructor for FI_NOT_MATCH */
#line 501
struct f_inst *
#line 493 "filter/f-inst.c"
NONNULL(2)
#line 494 "filter/f-inst.c"
NONNULL(3)
#line 501 "filter/f-inst.c"
f_new_inst_FI_NOT_MATCH(enum f_instruction_code fi_code
#line 493 "filter/f-inst.c"
  , struct f_inst * f1
#line 494 "filter/f-inst.c"
  , struct f_inst * f2
#line 501 "filter/f-inst.c"
)
#line 501
  {
#line 501
    /* Allocate the structure */
#line 501
    struct f_inst *what = fi_new(fi_code);
#line 501
    uint constargs = 1;
#line 501

#line 501
    /* Initialize all the members */
#line 501
  #define whati (&(what->i_FI_NOT_MATCH))
#line 501
  #line 493 "filter/f-inst.c"
whati->f1 = f1;
#line 493
const struct f_inst *child1 = f1;
#line 493
do {
#line 493
  what->size += child1->size;
#line 493

#line 493
  if (child1->fi_code != FI_CONSTANT)
#line 493
    constargs = 0;
#line 493

#line 493
} while (child1 = child1->next);
#line 493

#line 494 "filter/f-inst.c"
whati->f2 = f2;
#line 494
const struct f_inst *child2 = f2;
#line 494
do {
#line 494
  what->size += child2->size;
#line 494

#line 494
  if (child2->fi_code != FI_CONSTANT)
#line 494
    constargs = 0;
#line 494

#line 494
} while (child2 = child2->next);
#line 498 "filter/f-inst.c"
what->type = T_BOOL;

#line 501 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 501
    if (!constargs)
#line 501
      return what;
#line 501

#line 501
    /* Try to pre-calculate the result */
#line 501
    #line 492 "filter/f-inst.c"
 {
    
#line 493 "filter/f-inst.c"
;
    
#line 494 "filter/f-inst.c"
;
    int i = val_in_range(&v1, &v2);
    if (i == F_CMP_ERROR)
      runtime( "!~ applied on unknown type pair" );
     
#line 498 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = !i } );
  }

  
  #undef whati
#line 501 "filter/f-inst.c"
  }
#line 501

#line 501

#line 506 "filter/f-inst.c"
 /* Constructor for FI_DEFINED */
#line 506
struct f_inst *
#line 502 "filter/f-inst.c"
NONNULL(2)
#line 506 "filter/f-inst.c"
f_new_inst_FI_DEFINED(enum f_instruction_code fi_code
#line 502 "filter/f-inst.c"
  , struct f_inst * f1
#line 506 "filter/f-inst.c"
)
#line 506
  {
#line 506
    /* Allocate the structure */
#line 506
    struct f_inst *what = fi_new(fi_code);
#line 506
    uint constargs = 1;
#line 506

#line 506
    /* Initialize all the members */
#line 506
  #define whati (&(what->i_FI_DEFINED))
#line 506
  #line 502 "filter/f-inst.c"
whati->f1 = f1;
#line 502
const struct f_inst *child1 = f1;
#line 502
do {
#line 502
  what->size += child1->size;
#line 502

#line 502
  if (child1->fi_code != FI_CONSTANT)
#line 502
    constargs = 0;
#line 502

#line 502
} while (child1 = child1->next);
#line 502

#line 503 "filter/f-inst.c"
what->type = T_BOOL;

#line 506 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 506
    if (!constargs)
#line 506
      return what;
#line 506

#line 506
    /* Try to pre-calculate the result */
#line 506
    #line 501 "filter/f-inst.c"
 {
    
#line 502 "filter/f-inst.c"
;
     
#line 503 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = (v1.type != T_VOID) && !val_is_undefined(v1) } );
  }

  
  #undef whati
#line 506 "filter/f-inst.c"
  }
#line 506

#line 506

#line 507 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_NET__type */
#line 507
struct f_inst *
#line 506 "filter/f-inst.c"
NONNULL(2)
#line 507 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_NET__type(enum f_instruction_code fi_code
#line 506 "filter/f-inst.c"
  , struct f_inst * f1
#line 507 "filter/f-inst.c"
)
#line 507
  {
#line 507
    /* Allocate the structure */
#line 507
    struct f_inst *what = fi_new(fi_code);
#line 507
    uint constargs = 1;
#line 507

#line 507
    /* Initialize all the members */
#line 507
  #define whati (&(what->i_FI_METHOD__T_NET__type))
#line 507
  #line 506 "filter/f-inst.c"
whati->f1 = f1;
#line 506
const struct f_inst *child1 = f1;
#line 506
do {
#line 506
  what->size += child1->size;
#line 506

#line 506
  if (child1->fi_code != FI_CONSTANT)
#line 506
    constargs = 0;
#line 506

#line 506
} while (child1 = child1->next);
#line 506

#line 506 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 506
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 506
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 506 "filter/f-inst.c"
what->type = T_ENUM_NET_TYPE;

#line 507 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 507
    if (!constargs)
#line 507
      return what;
#line 507

#line 507
    /* Try to pre-calculate the result */
#line 507
    #line 506 "filter/f-inst.c"
 {
#line 506
  
#line 506 "filter/f-inst.c"
 #line 506 "filter/f-inst.c"
 ;
#line 506 "filter/f-inst.c"
    
#line 506 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ENUM_NET_TYPE, .val.i = v1.val.net->type } ) 
#line 506
  #line 506 "filter/f-inst.c"
;
#line 506
};
  
  #undef whati
#line 507 "filter/f-inst.c"
  }
#line 507

#line 507

#line 510 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_IP__is_v4 */
#line 510
struct f_inst *
#line 507 "filter/f-inst.c"
NONNULL(2)
#line 510 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_IP__is_v4(enum f_instruction_code fi_code
#line 507 "filter/f-inst.c"
  , struct f_inst * f1
#line 510 "filter/f-inst.c"
)
#line 510
  {
#line 510
    /* Allocate the structure */
#line 510
    struct f_inst *what = fi_new(fi_code);
#line 510
    uint constargs = 1;
#line 510

#line 510
    /* Initialize all the members */
#line 510
  #define whati (&(what->i_FI_METHOD__T_IP__is_v4))
#line 510
  #line 507 "filter/f-inst.c"
whati->f1 = f1;
#line 507
const struct f_inst *child1 = f1;
#line 507
do {
#line 507
  what->size += child1->size;
#line 507

#line 507
  if (child1->fi_code != FI_CONSTANT)
#line 507
    constargs = 0;
#line 507

#line 507
} while (child1 = child1->next);
#line 507

#line 507 "filter/f-inst.c"
if (f1->type && (f1->type != (T_IP)) && !f_const_promotion(f1, (T_IP)))
#line 507
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 507
	   f_instruction_name(what->fi_code), f_type_name(T_IP), f_type_name(f1->type));
#line 507 "filter/f-inst.c"
what->type = T_BOOL;

#line 510 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 510
    if (!constargs)
#line 510
      return what;
#line 510

#line 510
    /* Try to pre-calculate the result */
#line 510
    #line 507 "filter/f-inst.c"
 {
#line 507
  
#line 507 "filter/f-inst.c"
 #line 507 "filter/f-inst.c"
 ;
#line 507 "filter/f-inst.c"
    
#line 507 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BOOL, .val.i = ipa_is_ip4(v1.val.ip) } ) 
#line 507
  #line 507 "filter/f-inst.c"
;
#line 507
};

  /* Add initialized variable */
  
  #undef whati
#line 510 "filter/f-inst.c"
  }
#line 510

#line 510

#line 523 "filter/f-inst.c"
 /* Constructor for FI_VAR_INIT */
#line 523
struct f_inst *
#line 512 "filter/f-inst.c"
NONNULL(2)
#line 523 "filter/f-inst.c"
f_new_inst_FI_VAR_INIT(enum f_instruction_code fi_code
#line 512 "filter/f-inst.c"
  , struct f_inst * f1
#line 513 "filter/f-inst.c"
  , struct symbol * sym
#line 523 "filter/f-inst.c"
)
#line 523
  {
#line 523
    /* Allocate the structure */
#line 523
    struct f_inst *what = fi_new(fi_code);
#line 523
    
#line 523

#line 523
    /* Initialize all the members */
#line 523
  #define whati (&(what->i_FI_VAR_INIT))
#line 523
  #line 512 "filter/f-inst.c"
whati->f1 = f1;
#line 512
const struct f_inst *child1 = f1;
#line 512
do {
#line 512
  what->size += child1->size;
#line 512

#line 512
} while (child1 = child1->next);
#line 512

#line 513 "filter/f-inst.c"
whati->sym = sym;
#line 514 "filter/f-inst.c"
if (f1->type && (f1->type != (sym->class & 0xff)) && !f_const_promotion(f1, (sym->class & 0xff)))
#line 514
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 514
	   f_instruction_name(what->fi_code), f_type_name(sym->class & 0xff), f_type_name(f1->type));

#line 523 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 523
    
#line 523
      return what;
#line 523

#line 523
    /* Try to pre-calculate the result */
#line 523
      #undef whati
#line 523
  }
#line 523

#line 523

#line 534 "filter/f-inst.c"
 /* Constructor for FI_VAR_INIT0 */
#line 534
struct f_inst *
#line 534
f_new_inst_FI_VAR_INIT0(enum f_instruction_code fi_code
#line 525 "filter/f-inst.c"
  , struct symbol * sym
#line 534 "filter/f-inst.c"
)
#line 534
  {
#line 534
    /* Allocate the structure */
#line 534
    struct f_inst *what = fi_new(fi_code);
#line 534
    
#line 534

#line 534
    /* Initialize all the members */
#line 534
  #define whati (&(what->i_FI_VAR_INIT0))
#line 534
  #line 525 "filter/f-inst.c"
whati->sym = sym;

#line 534 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 534
    
#line 534
      return what;
#line 534

#line 534
    /* Try to pre-calculate the result */
#line 534
      #undef whati
#line 534
  }
#line 534

#line 534

#line 543 "filter/f-inst.c"
 /* Constructor for FI_VAR_SET */
#line 543
struct f_inst *
#line 536 "filter/f-inst.c"
NONNULL(2)
#line 543 "filter/f-inst.c"
f_new_inst_FI_VAR_SET(enum f_instruction_code fi_code
#line 536 "filter/f-inst.c"
  , struct f_inst * f1
#line 537 "filter/f-inst.c"
  , struct symbol * sym
#line 543 "filter/f-inst.c"
)
#line 543
  {
#line 543
    /* Allocate the structure */
#line 543
    struct f_inst *what = fi_new(fi_code);
#line 543
    
#line 543

#line 543
    /* Initialize all the members */
#line 543
  #define whati (&(what->i_FI_VAR_SET))
#line 543
  #line 536 "filter/f-inst.c"
whati->f1 = f1;
#line 536
const struct f_inst *child1 = f1;
#line 536
do {
#line 536
  what->size += child1->size;
#line 536

#line 536
} while (child1 = child1->next);
#line 536

#line 537 "filter/f-inst.c"
whati->sym = sym;
#line 538 "filter/f-inst.c"
if (f1->type && (f1->type != (sym->class & 0xff)) && !f_const_promotion(f1, (sym->class & 0xff)))
#line 538
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 538
	   f_instruction_name(what->fi_code), f_type_name(sym->class & 0xff), f_type_name(f1->type));

#line 543 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 543
    
#line 543
      return what;
#line 543

#line 543
    /* Try to pre-calculate the result */
#line 543
      #undef whati
#line 543
  }
#line 543

#line 543

#line 550 "filter/f-inst.c"
 /* Constructor for FI_VAR_GET */
#line 550
struct f_inst *
#line 550
f_new_inst_FI_VAR_GET(enum f_instruction_code fi_code
#line 544 "filter/f-inst.c"
  , struct symbol * sym
#line 550 "filter/f-inst.c"
)
#line 550
  {
#line 550
    /* Allocate the structure */
#line 550
    struct f_inst *what = fi_new(fi_code);
#line 550
    
#line 550

#line 550
    /* Initialize all the members */
#line 550
  #define whati (&(what->i_FI_VAR_GET))
#line 550
  #line 544 "filter/f-inst.c"
whati->sym = sym;
#line 546 "filter/f-inst.c"
what->type = sym->class & 0xff;

#line 550 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 550
    
#line 550
      return what;
#line 550

#line 550
    /* Try to pre-calculate the result */
#line 550
      #undef whati
#line 550
  }
#line 550

#line 550

#line 563 "filter/f-inst.c"
 /* Constructor for FI_CONSTANT */
#line 563
struct f_inst *
#line 563
f_new_inst_FI_CONSTANT(enum f_instruction_code fi_code
#line 551 "filter/f-inst.c"
  , struct f_val val
#line 563 "filter/f-inst.c"
)
#line 563
  {
#line 563
    /* Allocate the structure */
#line 563
    struct f_inst *what = fi_new(fi_code);
#line 563
    uint constargs = 1;
#line 563

#line 563
    /* Initialize all the members */
#line 563
  #define whati (&(what->i_FI_CONSTANT))
#line 563
  #line 551 "filter/f-inst.c"
whati->val = val;
#line 559 "filter/f-inst.c"
what->type = val.type;

#line 563 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 563
    if (!constargs)
#line 563
      return what;
#line 563

#line 563
    /* Try to pre-calculate the result */
#line 563
    #line 550 "filter/f-inst.c"
 {
    #line 557 "filter/f-inst.c"
;

     
#line 559 "filter/f-inst.c"
;
    return fi_constant(what, val);
  }

  
  #undef whati
#line 563 "filter/f-inst.c"
  }
#line 563

#line 563

#line 564 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PATH__empty */
#line 564
struct f_inst *
#line 563 "filter/f-inst.c"
NONNULL(2)
#line 564 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PATH__empty(enum f_instruction_code fi_code
#line 563 "filter/f-inst.c"
  , struct f_inst * f1
#line 564 "filter/f-inst.c"
)
#line 564
  {
#line 564
    /* Allocate the structure */
#line 564
    struct f_inst *what = fi_new(fi_code);
#line 564
    uint constargs = 1;
#line 564

#line 564
    /* Initialize all the members */
#line 564
  #define whati (&(what->i_FI_METHOD__T_PATH__empty))
#line 564
  #line 563 "filter/f-inst.c"
whati->f1 = f1;
#line 563
const struct f_inst *child1 = f1;
#line 563
do {
#line 563
  what->size += child1->size;
#line 563

#line 563
  if (child1->fi_code != FI_CONSTANT)
#line 563
    constargs = 0;
#line 563

#line 563
} while (child1 = child1->next);
#line 563

#line 563 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 563
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 563
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 563 "filter/f-inst.c"
what->type = T_PATH;

#line 564 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 564
    if (!constargs)
#line 564
      return what;
#line 564

#line 564
    /* Try to pre-calculate the result */
#line 564
    #line 563 "filter/f-inst.c"
 {
#line 563
  
#line 563 "filter/f-inst.c"
 #line 563 "filter/f-inst.c"
 ;
#line 563 "filter/f-inst.c"
    
#line 563 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH, .val.ad = &null_adata } ) 
#line 563
  #line 563 "filter/f-inst.c"
;
#line 563
};
  
  #undef whati
#line 564 "filter/f-inst.c"
  }
#line 564

#line 564

#line 565 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_CLIST__empty */
#line 565
struct f_inst *
#line 564 "filter/f-inst.c"
NONNULL(2)
#line 565 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_CLIST__empty(enum f_instruction_code fi_code
#line 564 "filter/f-inst.c"
  , struct f_inst * f1
#line 565 "filter/f-inst.c"
)
#line 565
  {
#line 565
    /* Allocate the structure */
#line 565
    struct f_inst *what = fi_new(fi_code);
#line 565
    uint constargs = 1;
#line 565

#line 565
    /* Initialize all the members */
#line 565
  #define whati (&(what->i_FI_METHOD__T_CLIST__empty))
#line 565
  #line 564 "filter/f-inst.c"
whati->f1 = f1;
#line 564
const struct f_inst *child1 = f1;
#line 564
do {
#line 564
  what->size += child1->size;
#line 564

#line 564
  if (child1->fi_code != FI_CONSTANT)
#line 564
    constargs = 0;
#line 564

#line 564
} while (child1 = child1->next);
#line 564

#line 564 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 564
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 564
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 564 "filter/f-inst.c"
what->type = T_CLIST;

#line 565 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 565
    if (!constargs)
#line 565
      return what;
#line 565

#line 565
    /* Try to pre-calculate the result */
#line 565
    #line 564 "filter/f-inst.c"
 {
#line 564
  
#line 564 "filter/f-inst.c"
 #line 564 "filter/f-inst.c"
 ;
#line 564 "filter/f-inst.c"
    
#line 564 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad = &null_adata } ) 
#line 564
  #line 564 "filter/f-inst.c"
;
#line 564
};
  
  #undef whati
#line 565 "filter/f-inst.c"
  }
#line 565

#line 565

#line 566 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_ECLIST__empty */
#line 566
struct f_inst *
#line 565 "filter/f-inst.c"
NONNULL(2)
#line 566 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_ECLIST__empty(enum f_instruction_code fi_code
#line 565 "filter/f-inst.c"
  , struct f_inst * f1
#line 566 "filter/f-inst.c"
)
#line 566
  {
#line 566
    /* Allocate the structure */
#line 566
    struct f_inst *what = fi_new(fi_code);
#line 566
    uint constargs = 1;
#line 566

#line 566
    /* Initialize all the members */
#line 566
  #define whati (&(what->i_FI_METHOD__T_ECLIST__empty))
#line 566
  #line 565 "filter/f-inst.c"
whati->f1 = f1;
#line 565
const struct f_inst *child1 = f1;
#line 565
do {
#line 565
  what->size += child1->size;
#line 565

#line 565
  if (child1->fi_code != FI_CONSTANT)
#line 565
    constargs = 0;
#line 565

#line 565
} while (child1 = child1->next);
#line 565

#line 565 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 565
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 565
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 565 "filter/f-inst.c"
what->type = T_ECLIST;

#line 566 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 566
    if (!constargs)
#line 566
      return what;
#line 566

#line 566
    /* Try to pre-calculate the result */
#line 566
    #line 565 "filter/f-inst.c"
 {
#line 565
  
#line 565 "filter/f-inst.c"
 #line 565 "filter/f-inst.c"
 ;
#line 565 "filter/f-inst.c"
    
#line 565 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad = &null_adata } ) 
#line 565
  #line 565 "filter/f-inst.c"
;
#line 565
};
  
  #undef whati
#line 566 "filter/f-inst.c"
  }
#line 566

#line 566

#line 569 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LCLIST__empty */
#line 569
struct f_inst *
#line 566 "filter/f-inst.c"
NONNULL(2)
#line 569 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LCLIST__empty(enum f_instruction_code fi_code
#line 566 "filter/f-inst.c"
  , struct f_inst * f1
#line 569 "filter/f-inst.c"
)
#line 569
  {
#line 569
    /* Allocate the structure */
#line 569
    struct f_inst *what = fi_new(fi_code);
#line 569
    uint constargs = 1;
#line 569

#line 569
    /* Initialize all the members */
#line 569
  #define whati (&(what->i_FI_METHOD__T_LCLIST__empty))
#line 569
  #line 566 "filter/f-inst.c"
whati->f1 = f1;
#line 566
const struct f_inst *child1 = f1;
#line 566
do {
#line 566
  what->size += child1->size;
#line 566

#line 566
  if (child1->fi_code != FI_CONSTANT)
#line 566
    constargs = 0;
#line 566

#line 566
} while (child1 = child1->next);
#line 566

#line 566 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 566
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 566
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 566 "filter/f-inst.c"
what->type = T_LCLIST;

#line 569 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 569
    if (!constargs)
#line 569
      return what;
#line 569

#line 569
    /* Try to pre-calculate the result */
#line 569
    #line 566 "filter/f-inst.c"
 {
#line 566
  
#line 566 "filter/f-inst.c"
 #line 566 "filter/f-inst.c"
 ;
#line 566 "filter/f-inst.c"
    
#line 566 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad = &null_adata } ) 
#line 566
  #line 566 "filter/f-inst.c"
;
#line 566
};

  /* Common loop begin instruction, always created by f_for_cycle() */
  
  #undef whati
#line 569 "filter/f-inst.c"
  }
#line 569

#line 569

#line 591 "filter/f-inst.c"
 /* Constructor for FI_FOR_LOOP_START */
#line 591
struct f_inst *
#line 591
f_new_inst_FI_FOR_LOOP_START(enum f_instruction_code fi_code
#line 571 "filter/f-inst.c"
  , struct symbol * sym
#line 591 "filter/f-inst.c"
)
#line 591
  {
#line 591
    /* Allocate the structure */
#line 591
    struct f_inst *what = fi_new(fi_code);
#line 591
    
#line 591

#line 591
    /* Initialize all the members */
#line 591
  #define whati (&(what->i_FI_FOR_LOOP_START))
#line 591
  #line 571 "filter/f-inst.c"
whati->sym = sym;
#line 587 "filter/f-inst.c"
what->type = T_VOID;

#line 591 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 591
    
#line 591
      return what;
#line 591

#line 591
    /* Try to pre-calculate the result */
#line 591
      #undef whati
#line 591
  }
#line 591

#line 591

#line 600 "filter/f-inst.c"
 /* Constructor for FI_PATH_FOR_NEXT */
#line 600
struct f_inst *
#line 593 "filter/f-inst.c"
NONNULL(2)
#line 600 "filter/f-inst.c"
f_new_inst_FI_PATH_FOR_NEXT(enum f_instruction_code fi_code
#line 593 "filter/f-inst.c"
  , struct f_inst * f1
#line 595 "filter/f-inst.c"
  , struct f_inst * f2
#line 600 "filter/f-inst.c"
)
#line 600
  {
#line 600
    /* Allocate the structure */
#line 600
    struct f_inst *what = fi_new(fi_code);
#line 600
    
#line 600

#line 600
    /* Initialize all the members */
#line 600
  #define whati (&(what->i_FI_PATH_FOR_NEXT))
#line 600
  #line 593 "filter/f-inst.c"
whati->f1 = f1;
#line 593
const struct f_inst *child1 = f1;
#line 593
do {
#line 593
  what->size += child1->size;
#line 593

#line 593
} while (child1 = child1->next);
#line 593

#line 593 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 593
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 593
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 595 "filter/f-inst.c"
whati->f2 = f2;

#line 600 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 600
    
#line 600
      return what;
#line 600

#line 600
    /* Try to pre-calculate the result */
#line 600
      #undef whati
#line 600
  }
#line 600

#line 600

#line 609 "filter/f-inst.c"
 /* Constructor for FI_CLIST_FOR_NEXT */
#line 609
struct f_inst *
#line 602 "filter/f-inst.c"
NONNULL(2)
#line 609 "filter/f-inst.c"
f_new_inst_FI_CLIST_FOR_NEXT(enum f_instruction_code fi_code
#line 602 "filter/f-inst.c"
  , struct f_inst * f1
#line 604 "filter/f-inst.c"
  , struct f_inst * f2
#line 609 "filter/f-inst.c"
)
#line 609
  {
#line 609
    /* Allocate the structure */
#line 609
    struct f_inst *what = fi_new(fi_code);
#line 609
    
#line 609

#line 609
    /* Initialize all the members */
#line 609
  #define whati (&(what->i_FI_CLIST_FOR_NEXT))
#line 609
  #line 602 "filter/f-inst.c"
whati->f1 = f1;
#line 602
const struct f_inst *child1 = f1;
#line 602
do {
#line 602
  what->size += child1->size;
#line 602

#line 602
} while (child1 = child1->next);
#line 602

#line 602 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 602
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 602
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 604 "filter/f-inst.c"
whati->f2 = f2;

#line 609 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 609
    
#line 609
      return what;
#line 609

#line 609
    /* Try to pre-calculate the result */
#line 609
      #undef whati
#line 609
  }
#line 609

#line 609

#line 618 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_FOR_NEXT */
#line 618
struct f_inst *
#line 611 "filter/f-inst.c"
NONNULL(2)
#line 618 "filter/f-inst.c"
f_new_inst_FI_ECLIST_FOR_NEXT(enum f_instruction_code fi_code
#line 611 "filter/f-inst.c"
  , struct f_inst * f1
#line 613 "filter/f-inst.c"
  , struct f_inst * f2
#line 618 "filter/f-inst.c"
)
#line 618
  {
#line 618
    /* Allocate the structure */
#line 618
    struct f_inst *what = fi_new(fi_code);
#line 618
    
#line 618

#line 618
    /* Initialize all the members */
#line 618
  #define whati (&(what->i_FI_ECLIST_FOR_NEXT))
#line 618
  #line 611 "filter/f-inst.c"
whati->f1 = f1;
#line 611
const struct f_inst *child1 = f1;
#line 611
do {
#line 611
  what->size += child1->size;
#line 611

#line 611
} while (child1 = child1->next);
#line 611

#line 611 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 611
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 611
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 613 "filter/f-inst.c"
whati->f2 = f2;

#line 618 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 618
    
#line 618
      return what;
#line 618

#line 618
    /* Try to pre-calculate the result */
#line 618
      #undef whati
#line 618
  }
#line 618

#line 618

#line 627 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_FOR_NEXT */
#line 627
struct f_inst *
#line 620 "filter/f-inst.c"
NONNULL(2)
#line 627 "filter/f-inst.c"
f_new_inst_FI_LCLIST_FOR_NEXT(enum f_instruction_code fi_code
#line 620 "filter/f-inst.c"
  , struct f_inst * f1
#line 622 "filter/f-inst.c"
  , struct f_inst * f2
#line 627 "filter/f-inst.c"
)
#line 627
  {
#line 627
    /* Allocate the structure */
#line 627
    struct f_inst *what = fi_new(fi_code);
#line 627
    
#line 627

#line 627
    /* Initialize all the members */
#line 627
  #define whati (&(what->i_FI_LCLIST_FOR_NEXT))
#line 627
  #line 620 "filter/f-inst.c"
whati->f1 = f1;
#line 620
const struct f_inst *child1 = f1;
#line 620
do {
#line 620
  what->size += child1->size;
#line 620

#line 620
} while (child1 = child1->next);
#line 620

#line 620 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 620
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 620
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 622 "filter/f-inst.c"
whati->f2 = f2;

#line 627 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 627
    
#line 627
      return what;
#line 627

#line 627
    /* Try to pre-calculate the result */
#line 627
      #undef whati
#line 627
  }
#line 627

#line 627

#line 640 "filter/f-inst.c"
 /* Constructor for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
struct f_inst *
#line 629 "filter/f-inst.c"
NONNULL(2)
#line 640 "filter/f-inst.c"
f_new_inst_FI_ROUTES_BLOCK_FOR_NEXT(enum f_instruction_code fi_code
#line 629 "filter/f-inst.c"
  , struct f_inst * f1
#line 634 "filter/f-inst.c"
  , struct f_inst * f2
#line 640 "filter/f-inst.c"
)
#line 640
  {
#line 640
    /* Allocate the structure */
#line 640
    struct f_inst *what = fi_new(fi_code);
#line 640
    
#line 640

#line 640
    /* Initialize all the members */
#line 640
  #define whati (&(what->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 640
  #line 629 "filter/f-inst.c"
whati->f1 = f1;
#line 629
const struct f_inst *child1 = f1;
#line 629
do {
#line 629
  what->size += child1->size;
#line 629

#line 629
} while (child1 = child1->next);
#line 629

#line 629 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ROUTES_BLOCK)) && !f_const_promotion(f1, (T_ROUTES_BLOCK)))
#line 629
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 629
	   f_instruction_name(what->fi_code), f_type_name(T_ROUTES_BLOCK), f_type_name(f1->type));
#line 634 "filter/f-inst.c"
whati->f2 = f2;

#line 640 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 640
    
#line 640
      return what;
#line 640

#line 640
    /* Try to pre-calculate the result */
#line 640
      #undef whati
#line 640
  }
#line 640

#line 640

#line 648 "filter/f-inst.c"
 /* Constructor for FI_CONDITION */
#line 648
struct f_inst *
#line 641 "filter/f-inst.c"
NONNULL(2)
#line 648 "filter/f-inst.c"
f_new_inst_FI_CONDITION(enum f_instruction_code fi_code
#line 641 "filter/f-inst.c"
  , struct f_inst * f1
#line 643 "filter/f-inst.c"
  , struct f_inst * f2
#line 645 "filter/f-inst.c"
  , struct f_inst * f3
#line 648 "filter/f-inst.c"
)
#line 648
  {
#line 648
    /* Allocate the structure */
#line 648
    struct f_inst *what = fi_new(fi_code);
#line 648
    uint constargs = 1;
#line 648

#line 648
    /* Initialize all the members */
#line 648
  #define whati (&(what->i_FI_CONDITION))
#line 648
  #line 641 "filter/f-inst.c"
whati->f1 = f1;
#line 641
const struct f_inst *child1 = f1;
#line 641
do {
#line 641
  what->size += child1->size;
#line 641

#line 641
  if (child1->fi_code != FI_CONSTANT)
#line 641
    constargs = 0;
#line 641

#line 641
} while (child1 = child1->next);
#line 641

#line 641 "filter/f-inst.c"
if (f1->type && (f1->type != (T_BOOL)) && !f_const_promotion(f1, (T_BOOL)))
#line 641
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 641
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f1->type));
#line 643 "filter/f-inst.c"
whati->f2 = f2;
#line 645 "filter/f-inst.c"
whati->f3 = f3;

#line 648 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 648
    if (!constargs)
#line 648
      return what;
#line 648

#line 648
    /* Try to pre-calculate the result */
#line 648
    #line 640 "filter/f-inst.c"
 {
    
#line 641 "filter/f-inst.c"
 #line 641 "filter/f-inst.c"
 ;
#line 642 "filter/f-inst.c"
    if (v1.val.i)
      
#line 643 "filter/f-inst.c"
return whati->f2
#line 643
;
    else
      
#line 645 "filter/f-inst.c"
return whati->f3
#line 645
;
  }

  
  #undef whati
#line 648 "filter/f-inst.c"
  }
#line 648

#line 648

#line 661 "filter/f-inst.c"
 /* Constructor for FI_PRINT */
#line 661
struct f_inst *
#line 650 "filter/f-inst.c"
NONNULL(2)
#line 661 "filter/f-inst.c"
f_new_inst_FI_PRINT(enum f_instruction_code fi_code
#line 650 "filter/f-inst.c"
  , struct f_inst * f1
#line 661 "filter/f-inst.c"
)
#line 661
  {
#line 661
    /* Allocate the structure */
#line 661
    struct f_inst *what = fi_new(fi_code);
#line 661
    
#line 661

#line 661
    /* Initialize all the members */
#line 661
  #define whati (&(what->i_FI_PRINT))
#line 661
  #line 650 "filter/f-inst.c"
whati->f1 = f1;
#line 650
const struct f_inst *child1 = f1;
#line 650
do {
#line 650
  what->size += child1->size;
#line 650

#line 650
} while (child1 = child1->next);
#line 650


#line 661 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 661
    
#line 661
      return what;
#line 661

#line 661
    /* Try to pre-calculate the result */
#line 661
      #undef whati
#line 661
  }
#line 661

#line 661

#line 668 "filter/f-inst.c"
 /* Constructor for FI_FLUSH */
#line 668
struct f_inst *
#line 668
f_new_inst_FI_FLUSH(enum f_instruction_code fi_code
#line 668
)
#line 668
  {
#line 668
    /* Allocate the structure */
#line 668
    struct f_inst *what = fi_new(fi_code);
#line 668
    
#line 668

#line 668
    /* Initialize all the members */
#line 668
  #define whati (&(what->i_FI_FLUSH))
#line 668
  
#line 668
    /* If not constant, return the instruction itself */
#line 668
    
#line 668
      return what;
#line 668

#line 668
    /* Try to pre-calculate the result */
#line 668
      #undef whati
#line 668
  }
#line 668

#line 668

#line 682 "filter/f-inst.c"
 /* Constructor for FI_DIE */
#line 682
struct f_inst *
#line 682
f_new_inst_FI_DIE(enum f_instruction_code fi_code
#line 670 "filter/f-inst.c"
  , enum filter_return fret
#line 682 "filter/f-inst.c"
)
#line 682
  {
#line 682
    /* Allocate the structure */
#line 682
    struct f_inst *what = fi_new(fi_code);
#line 682
    
#line 682

#line 682
    /* Initialize all the members */
#line 682
  #define whati (&(what->i_FI_DIE))
#line 682
  #line 670 "filter/f-inst.c"
whati->fret = fret;

#line 682 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 682
    
#line 682
      return what;
#line 682

#line 682
    /* Try to pre-calculate the result */
#line 682
      #undef whati
#line 682
  }
#line 682

#line 682

#line 689 "filter/f-inst.c"
 /* Constructor for FI_CURRENT_ROUTE */
#line 689
struct f_inst *
#line 689
f_new_inst_FI_CURRENT_ROUTE(enum f_instruction_code fi_code
#line 689
)
#line 689
  {
#line 689
    /* Allocate the structure */
#line 689
    struct f_inst *what = fi_new(fi_code);
#line 689
    
#line 689

#line 689
    /* Initialize all the members */
#line 689
  #define whati (&(what->i_FI_CURRENT_ROUTE))
#line 689
  #line 685 "filter/f-inst.c"
what->type = T_ROUTE;

#line 689 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 689
    
#line 689
      return what;
#line 689

#line 689
    /* Try to pre-calculate the result */
#line 689
      #undef whati
#line 689
  }
#line 689

#line 689

#line 737 "filter/f-inst.c"
 /* Constructor for FI_RTA_GET */
#line 737
struct f_inst *
#line 691 "filter/f-inst.c"
NONNULL(2)
#line 737 "filter/f-inst.c"
f_new_inst_FI_RTA_GET(enum f_instruction_code fi_code
#line 691 "filter/f-inst.c"
  , struct f_inst * f1
#line 692 "filter/f-inst.c"
  , struct f_static_attr sa
#line 737 "filter/f-inst.c"
)
#line 737
  {
#line 737
    /* Allocate the structure */
#line 737
    struct f_inst *what = fi_new(fi_code);
#line 737
    uint constargs = 1;
#line 737

#line 737
    /* Initialize all the members */
#line 737
  #define whati (&(what->i_FI_RTA_GET))
#line 737
  #line 691 "filter/f-inst.c"
whati->f1 = f1;
#line 691
const struct f_inst *child1 = f1;
#line 691
do {
#line 691
  what->size += child1->size;
#line 691

#line 691
  if (child1->fi_code != FI_CONSTANT)
#line 691
    constargs = 0;
#line 691

#line 691
} while (child1 = child1->next);
#line 691

#line 691 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ROUTE)) && !f_const_promotion(f1, (T_ROUTE)))
#line 691
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 691
	   f_instruction_name(what->fi_code), f_type_name(T_ROUTE), f_type_name(f1->type));
#line 692 "filter/f-inst.c"
whati->sa = sa;
#line 698 "filter/f-inst.c"
what->type = sa.type;

#line 737 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 737
    if (!constargs)
#line 737
      return what;
#line 737

#line 737
    /* Try to pre-calculate the result */
#line 737
    #line 689 "filter/f-inst.c"
 {
    {
      
#line 691 "filter/f-inst.c"
 #line 691 "filter/f-inst.c"
 ;
#line 692 "filter/f-inst.c"
      #line 692 "filter/f-inst.c"
;

      struct rte *rte = v1.val.rte;

      switch (sa.sa_code)
      {
      case SA_NET:	 
#line 698 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = sa.type, .val.net = rte->net } ); break;
      case SA_PROTO:	 return fi_constant(what,  (struct f_val) { .type = sa.type, .val.s = rte->src->owner->name } ); break;
      default:
	{
	  /* Next hop examination */
	  struct eattr *nhea = ea_find(rte->attrs, &ea_gen_nexthop);
	  struct nexthop_adata *nhad = nhea ? (struct nexthop_adata *) nhea->u.ptr : NULL;
	  struct nexthop *nh = (nhad && NEXTHOP_IS_REACHABLE(nhad)) ? &nhad->nh : NULL;

	  switch (sa.sa_code)
	  {
	    case SA_DEST:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.i = nhad ?
#line 710
		  (NEXTHOP_IS_REACHABLE(nhad) ? RTD_UNICAST : nhad->dest)
#line 710
		  : RTD_NONE } );
#line 713
	      break;
	    case SA_GW:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.ip = nh ? nh->gw : IPA_NONE } );
	      break;
	    case SA_IFNAME:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.s = (nh && nh->iface) ? nh->iface->name : "" } );
	      break;
	    case SA_IFINDEX:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.i = (nh && nh->iface) ? nh->iface->index : 0 } );
	      break;
	    case SA_WEIGHT:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.i = (nh ? nh->weight : 0) + 1 } );
	      break;
	    case SA_GW_MPLS:
	       return fi_constant(what,  (struct f_val) { .type = sa.type, .val.i = (nh && nh->labels) ? nh->label[0] : MPLS_NULL } );
	      break;
	    default:
	      bug("Invalid static attribute access (%u/%u)", sa.type, sa.sa_code);
	  }
	}
      }
    }
  }

  
  #undef whati
#line 737 "filter/f-inst.c"
  }
#line 737

#line 737

#line 866 "filter/f-inst.c"
 /* Constructor for FI_RTA_SET */
#line 866
struct f_inst *
#line 739 "filter/f-inst.c"
NONNULL(2)
#line 866 "filter/f-inst.c"
f_new_inst_FI_RTA_SET(enum f_instruction_code fi_code
#line 739 "filter/f-inst.c"
  , struct f_inst * f1
#line 740 "filter/f-inst.c"
  , struct f_static_attr sa
#line 866 "filter/f-inst.c"
)
#line 866
  {
#line 866
    /* Allocate the structure */
#line 866
    struct f_inst *what = fi_new(fi_code);
#line 866
    
#line 866

#line 866
    /* Initialize all the members */
#line 866
  #define whati (&(what->i_FI_RTA_SET))
#line 866
  #line 739 "filter/f-inst.c"
whati->f1 = f1;
#line 739
const struct f_inst *child1 = f1;
#line 739
do {
#line 739
  what->size += child1->size;
#line 739

#line 739
} while (child1 = child1->next);
#line 739

#line 740 "filter/f-inst.c"
whati->sa = sa;
#line 741 "filter/f-inst.c"
if (f1->type && (f1->type != (sa.type)) && !f_const_promotion(f1, (sa.type)))
#line 741
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 741
	   f_instruction_name(what->fi_code), f_type_name(sa.type), f_type_name(f1->type));

#line 866 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 866
    
#line 866
      return what;
#line 866

#line 866
    /* Try to pre-calculate the result */
#line 866
      #undef whati
#line 866
  }
#line 866

#line 866

#line 903 "filter/f-inst.c"
 /* Constructor for FI_EA_GET */
#line 903
struct f_inst *
#line 867 "filter/f-inst.c"
NONNULL(2)
#line 903 "filter/f-inst.c"
f_new_inst_FI_EA_GET(enum f_instruction_code fi_code
#line 867 "filter/f-inst.c"
  , struct f_inst * f1
#line 868 "filter/f-inst.c"
  , const struct ea_class * da
#line 903 "filter/f-inst.c"
)
#line 903
  {
#line 903
    /* Allocate the structure */
#line 903
    struct f_inst *what = fi_new(fi_code);
#line 903
    uint constargs = 1;
#line 903

#line 903
    /* Initialize all the members */
#line 903
  #define whati (&(what->i_FI_EA_GET))
#line 903
  #line 867 "filter/f-inst.c"
whati->f1 = f1;
#line 867
const struct f_inst *child1 = f1;
#line 867
do {
#line 867
  what->size += child1->size;
#line 867

#line 867
  if (child1->fi_code != FI_CONSTANT)
#line 867
    constargs = 0;
#line 867

#line 867
} while (child1 = child1->next);
#line 867

#line 867 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ROUTE)) && !f_const_promotion(f1, (T_ROUTE)))
#line 867
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 867
	   f_instruction_name(what->fi_code), f_type_name(T_ROUTE), f_type_name(f1->type));
#line 868 "filter/f-inst.c"
whati->da = da;
#line 869 "filter/f-inst.c"
what->type = da->type;

#line 903 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 903
    if (!constargs)
#line 903
      return what;
#line 903

#line 903
    /* Try to pre-calculate the result */
#line 903
    #line 866 "filter/f-inst.c"
 {	/* Access to extended attributes */
    
#line 867 "filter/f-inst.c"
 #line 867 "filter/f-inst.c"
 ;
#line 868 "filter/f-inst.c"
    #line 868 "filter/f-inst.c"
;
     
#line 869 "filter/f-inst.c"
;
    {
      struct f_val empty;
      const eattr *e = ea_find(v1.val.rte->attrs, da->id);

      if (e)
      {
	ASSERT_DIE(e->type == da->type);

	switch (e->type) {
	  case T_IP:
	    return fi_constant(what,  (struct f_val) { .type = T_IP, .val.ip = *((const ip_addr *) e->u.ptr->data) } );
	    break;

	  case T_STRING:
	    return fi_constant(what,  (struct f_val) { .type = T_STRING, .val.s = (const char *) e->u.ptr->data } );
	    break;

	  default:
	    return fi_constant(what, (struct f_val) {
#line 888
		.type = e->type,
#line 888
		.val.bval = e->u,
#line 888
		});
#line 892
	}
      }
      else if (da->empty)
	return fi_constant(what, da->empty(da));
      else if ((empty = f_get_empty(da->type)).type != T_VOID)
	return fi_constant(what, empty);
      else
	return fi_constant(what,  (struct f_val) { .type = T_VOID } );
    }
  }

  
  #undef whati
#line 903 "filter/f-inst.c"
  }
#line 903

#line 903

#line 944 "filter/f-inst.c"
 /* Constructor for FI_EA_SET */
#line 944
struct f_inst *
#line 905 "filter/f-inst.c"
NONNULL(2)
#line 944 "filter/f-inst.c"
f_new_inst_FI_EA_SET(enum f_instruction_code fi_code
#line 905 "filter/f-inst.c"
  , struct f_inst * f1
#line 906 "filter/f-inst.c"
  , const struct ea_class * da
#line 944 "filter/f-inst.c"
)
#line 944
  {
#line 944
    /* Allocate the structure */
#line 944
    struct f_inst *what = fi_new(fi_code);
#line 944
    
#line 944

#line 944
    /* Initialize all the members */
#line 944
  #define whati (&(what->i_FI_EA_SET))
#line 944
  #line 905 "filter/f-inst.c"
whati->f1 = f1;
#line 905
const struct f_inst *child1 = f1;
#line 905
do {
#line 905
  what->size += child1->size;
#line 905

#line 905
} while (child1 = child1->next);
#line 905

#line 906 "filter/f-inst.c"
whati->da = da;
#line 907 "filter/f-inst.c"
if (f1->type && (f1->type != (da->type)) && !f_const_promotion(f1, (da->type)))
#line 907
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 907
	   f_instruction_name(what->fi_code), f_type_name(da->type), f_type_name(f1->type));
;
#line 910 "filter/f-inst.c"
      if (da->type == T_OPAQUE)
	cf_error("Setting opaque attribute is not allowed");

    
#line 944 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 944
    
#line 944
      return what;
#line 944

#line 944
    /* Try to pre-calculate the result */
#line 944
      #undef whati
#line 944
  }
#line 944

#line 944

#line 951 "filter/f-inst.c"
 /* Constructor for FI_EA_UNSET */
#line 951
struct f_inst *
#line 951
f_new_inst_FI_EA_UNSET(enum f_instruction_code fi_code
#line 945 "filter/f-inst.c"
  , const struct ea_class * da
#line 951 "filter/f-inst.c"
)
#line 951
  {
#line 951
    /* Allocate the structure */
#line 951
    struct f_inst *what = fi_new(fi_code);
#line 951
    
#line 951

#line 951
    /* Initialize all the members */
#line 951
  #define whati (&(what->i_FI_EA_UNSET))
#line 951
  #line 945 "filter/f-inst.c"
whati->da = da;

#line 951 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 951
    
#line 951
      return what;
#line 951

#line 951
    /* Try to pre-calculate the result */
#line 951
      #undef whati
#line 951
  }
#line 951

#line 951

#line 965 "filter/f-inst.c"
 /* Constructor for FI_DEFAULT */
#line 965
struct f_inst *
#line 952 "filter/f-inst.c"
NONNULL(2)
#line 953 "filter/f-inst.c"
NONNULL(3)
#line 965 "filter/f-inst.c"
f_new_inst_FI_DEFAULT(enum f_instruction_code fi_code
#line 952 "filter/f-inst.c"
  , struct f_inst * f1
#line 953 "filter/f-inst.c"
  , struct f_inst * f2
#line 965 "filter/f-inst.c"
)
#line 965
  {
#line 965
    /* Allocate the structure */
#line 965
    struct f_inst *what = fi_new(fi_code);
#line 965
    uint constargs = 1;
#line 965

#line 965
    /* Initialize all the members */
#line 965
  #define whati (&(what->i_FI_DEFAULT))
#line 965
  #line 952 "filter/f-inst.c"
whati->f1 = f1;
#line 952
const struct f_inst *child1 = f1;
#line 952
do {
#line 952
  what->size += child1->size;
#line 952

#line 952
  if (child1->fi_code != FI_CONSTANT)
#line 952
    constargs = 0;
#line 952

#line 952
} while (child1 = child1->next);
#line 952

#line 953 "filter/f-inst.c"
whati->f2 = f2;
#line 953
const struct f_inst *child2 = f2;
#line 953
do {
#line 953
  what->size += child2->size;
#line 953

#line 953
  if (child2->fi_code != FI_CONSTANT)
#line 953
    constargs = 0;
#line 953

#line 953
} while (child2 = child2->next);
#line 954 "filter/f-inst.c"
what->type = f_type_element_type(v2.type);

#line 965 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 965
    if (!constargs)
#line 965
      return what;
#line 965

#line 965
    /* Try to pre-calculate the result */
#line 965
    #line 951 "filter/f-inst.c"
 {
    
#line 952 "filter/f-inst.c"
;
    
#line 953 "filter/f-inst.c"
;
     
#line 954 "filter/f-inst.c"
;

    log(L_INFO "Type of arg 1 is: %d", v1.type);

    if (v1.type == T_VOID)
      return fi_constant(what, v2);
    else
      return fi_constant(what, v1);
  }

  /* Get length of */
  
  #undef whati
#line 965 "filter/f-inst.c"
  }
#line 965

#line 965

#line 966 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_NET__len */
#line 966
struct f_inst *
#line 965 "filter/f-inst.c"
NONNULL(2)
#line 966 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_NET__len(enum f_instruction_code fi_code
#line 965 "filter/f-inst.c"
  , struct f_inst * f1
#line 966 "filter/f-inst.c"
)
#line 966
  {
#line 966
    /* Allocate the structure */
#line 966
    struct f_inst *what = fi_new(fi_code);
#line 966
    uint constargs = 1;
#line 966

#line 966
    /* Initialize all the members */
#line 966
  #define whati (&(what->i_FI_METHOD__T_NET__len))
#line 966
  #line 965 "filter/f-inst.c"
whati->f1 = f1;
#line 965
const struct f_inst *child1 = f1;
#line 965
do {
#line 965
  what->size += child1->size;
#line 965

#line 965
  if (child1->fi_code != FI_CONSTANT)
#line 965
    constargs = 0;
#line 965

#line 965
} while (child1 = child1->next);
#line 965

#line 965 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 965
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 965
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 965 "filter/f-inst.c"
what->type = T_INT;

#line 966 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 966
    if (!constargs)
#line 966
      return what;
#line 966

#line 966
    /* Try to pre-calculate the result */
#line 966
    #line 965 "filter/f-inst.c"
 {
#line 965
  
#line 965 "filter/f-inst.c"
 #line 965 "filter/f-inst.c"
 ;
#line 965 "filter/f-inst.c"
    
#line 965 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = net_pxlen(v1.val.net) } ) 
#line 965
  #line 965 "filter/f-inst.c"
;
#line 965
};
  
  #undef whati
#line 966 "filter/f-inst.c"
  }
#line 966

#line 966

#line 967 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PATH__len */
#line 967
struct f_inst *
#line 966 "filter/f-inst.c"
NONNULL(2)
#line 967 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PATH__len(enum f_instruction_code fi_code
#line 966 "filter/f-inst.c"
  , struct f_inst * f1
#line 967 "filter/f-inst.c"
)
#line 967
  {
#line 967
    /* Allocate the structure */
#line 967
    struct f_inst *what = fi_new(fi_code);
#line 967
    uint constargs = 1;
#line 967

#line 967
    /* Initialize all the members */
#line 967
  #define whati (&(what->i_FI_METHOD__T_PATH__len))
#line 967
  #line 966 "filter/f-inst.c"
whati->f1 = f1;
#line 966
const struct f_inst *child1 = f1;
#line 966
do {
#line 966
  what->size += child1->size;
#line 966

#line 966
  if (child1->fi_code != FI_CONSTANT)
#line 966
    constargs = 0;
#line 966

#line 966
} while (child1 = child1->next);
#line 966

#line 966 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 966
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 966
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 966 "filter/f-inst.c"
what->type = T_INT;

#line 967 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 967
    if (!constargs)
#line 967
      return what;
#line 967

#line 967
    /* Try to pre-calculate the result */
#line 967
    #line 966 "filter/f-inst.c"
 {
#line 966
  
#line 966 "filter/f-inst.c"
 #line 966 "filter/f-inst.c"
 ;
#line 966 "filter/f-inst.c"
    
#line 966 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = as_path_getlen(v1.val.ad) } ) 
#line 966
  #line 966 "filter/f-inst.c"
;
#line 966
};
  
  #undef whati
#line 967 "filter/f-inst.c"
  }
#line 967

#line 967

#line 968 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_CLIST__len */
#line 968
struct f_inst *
#line 967 "filter/f-inst.c"
NONNULL(2)
#line 968 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_CLIST__len(enum f_instruction_code fi_code
#line 967 "filter/f-inst.c"
  , struct f_inst * f1
#line 968 "filter/f-inst.c"
)
#line 968
  {
#line 968
    /* Allocate the structure */
#line 968
    struct f_inst *what = fi_new(fi_code);
#line 968
    uint constargs = 1;
#line 968

#line 968
    /* Initialize all the members */
#line 968
  #define whati (&(what->i_FI_METHOD__T_CLIST__len))
#line 968
  #line 967 "filter/f-inst.c"
whati->f1 = f1;
#line 967
const struct f_inst *child1 = f1;
#line 967
do {
#line 967
  what->size += child1->size;
#line 967

#line 967
  if (child1->fi_code != FI_CONSTANT)
#line 967
    constargs = 0;
#line 967

#line 967
} while (child1 = child1->next);
#line 967

#line 967 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 967
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 967
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 967 "filter/f-inst.c"
what->type = T_INT;

#line 968 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 968
    if (!constargs)
#line 968
      return what;
#line 968

#line 968
    /* Try to pre-calculate the result */
#line 968
    #line 967 "filter/f-inst.c"
 {
#line 967
  
#line 967 "filter/f-inst.c"
 #line 967 "filter/f-inst.c"
 ;
#line 967 "filter/f-inst.c"
    
#line 967 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = int_set_get_size(v1.val.ad) } ) 
#line 967
  #line 967 "filter/f-inst.c"
;
#line 967
};
  
  #undef whati
#line 968 "filter/f-inst.c"
  }
#line 968

#line 968

#line 969 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_ECLIST__len */
#line 969
struct f_inst *
#line 968 "filter/f-inst.c"
NONNULL(2)
#line 969 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_ECLIST__len(enum f_instruction_code fi_code
#line 968 "filter/f-inst.c"
  , struct f_inst * f1
#line 969 "filter/f-inst.c"
)
#line 969
  {
#line 969
    /* Allocate the structure */
#line 969
    struct f_inst *what = fi_new(fi_code);
#line 969
    uint constargs = 1;
#line 969

#line 969
    /* Initialize all the members */
#line 969
  #define whati (&(what->i_FI_METHOD__T_ECLIST__len))
#line 969
  #line 968 "filter/f-inst.c"
whati->f1 = f1;
#line 968
const struct f_inst *child1 = f1;
#line 968
do {
#line 968
  what->size += child1->size;
#line 968

#line 968
  if (child1->fi_code != FI_CONSTANT)
#line 968
    constargs = 0;
#line 968

#line 968
} while (child1 = child1->next);
#line 968

#line 968 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 968
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 968
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 968 "filter/f-inst.c"
what->type = T_INT;

#line 969 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 969
    if (!constargs)
#line 969
      return what;
#line 969

#line 969
    /* Try to pre-calculate the result */
#line 969
    #line 968 "filter/f-inst.c"
 {
#line 968
  
#line 968 "filter/f-inst.c"
 #line 968 "filter/f-inst.c"
 ;
#line 968 "filter/f-inst.c"
    
#line 968 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = ec_set_get_size(v1.val.ad) } ) 
#line 968
  #line 968 "filter/f-inst.c"
;
#line 968
};
  
  #undef whati
#line 969 "filter/f-inst.c"
  }
#line 969

#line 969

#line 971 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LCLIST__len */
#line 971
struct f_inst *
#line 969 "filter/f-inst.c"
NONNULL(2)
#line 971 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LCLIST__len(enum f_instruction_code fi_code
#line 969 "filter/f-inst.c"
  , struct f_inst * f1
#line 971 "filter/f-inst.c"
)
#line 971
  {
#line 971
    /* Allocate the structure */
#line 971
    struct f_inst *what = fi_new(fi_code);
#line 971
    uint constargs = 1;
#line 971

#line 971
    /* Initialize all the members */
#line 971
  #define whati (&(what->i_FI_METHOD__T_LCLIST__len))
#line 971
  #line 969 "filter/f-inst.c"
whati->f1 = f1;
#line 969
const struct f_inst *child1 = f1;
#line 969
do {
#line 969
  what->size += child1->size;
#line 969

#line 969
  if (child1->fi_code != FI_CONSTANT)
#line 969
    constargs = 0;
#line 969

#line 969
} while (child1 = child1->next);
#line 969

#line 969 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 969
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 969
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 969 "filter/f-inst.c"
what->type = T_INT;

#line 971 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 971
    if (!constargs)
#line 971
      return what;
#line 971

#line 971
    /* Try to pre-calculate the result */
#line 971
    #line 969 "filter/f-inst.c"
 {
#line 969
  
#line 969 "filter/f-inst.c"
 #line 969 "filter/f-inst.c"
 ;
#line 969 "filter/f-inst.c"
    
#line 969 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = lc_set_get_size(v1.val.ad) } ) 
#line 969
  #line 969 "filter/f-inst.c"
;
#line 969
};

  
  #undef whati
#line 971 "filter/f-inst.c"
  }
#line 971

#line 971

#line 1007 "filter/f-inst.c"
 /* Constructor for FI_NET_SRC */
#line 1007
struct f_inst *
#line 972 "filter/f-inst.c"
NONNULL(2)
#line 1007 "filter/f-inst.c"
f_new_inst_FI_NET_SRC(enum f_instruction_code fi_code
#line 972 "filter/f-inst.c"
  , struct f_inst * f1
#line 1007 "filter/f-inst.c"
)
#line 1007
  {
#line 1007
    /* Allocate the structure */
#line 1007
    struct f_inst *what = fi_new(fi_code);
#line 1007
    uint constargs = 1;
#line 1007

#line 1007
    /* Initialize all the members */
#line 1007
  #define whati (&(what->i_FI_NET_SRC))
#line 1007
  #line 972 "filter/f-inst.c"
whati->f1 = f1;
#line 972
const struct f_inst *child1 = f1;
#line 972
do {
#line 972
  what->size += child1->size;
#line 972

#line 972
  if (child1->fi_code != FI_CONSTANT)
#line 972
    constargs = 0;
#line 972

#line 972
} while (child1 = child1->next);
#line 972

#line 972 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 972
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 972
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1004 "filter/f-inst.c"
what->type = T_NET;

#line 1007 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1007
    if (!constargs)
#line 1007
      return what;
#line 1007

#line 1007
    /* Try to pre-calculate the result */
#line 1007
    #line 971 "filter/f-inst.c"
 { 	/* Get src prefix */
    
#line 972 "filter/f-inst.c"
 #line 972 "filter/f-inst.c"
 ;
#line 973 "filter/f-inst.c"
    #line 973 "filter/f-inst.c"
;

    net_addr_union *net = (void *) v1.val.net;
    net_addr *src = falloc(sizeof(net_addr_ip6));
    const byte *part;

    switch(v1.val.net->type) {
    case NET_FLOW4:
      part = flow4_get_part(&net->flow4, FLOW_TYPE_SRC_PREFIX);
      if (part)
	net_fill_ip4(src, flow_read_ip4_part(part), flow_read_pxlen(part));
      else
	net_fill_ip4(src, IP4_NONE, 0);
      break;

    case NET_FLOW6:
      part = flow6_get_part(&net->flow6, FLOW_TYPE_SRC_PREFIX);
      if (part)
	net_fill_ip6(src, flow_read_ip6_part(part), flow_read_pxlen(part));
      else
	net_fill_ip6(src, IP6_NONE, 0);
      break;

    case NET_IP6_SADR:
      net_fill_ip6(src, net->ip6_sadr.src_prefix, net->ip6_sadr.src_pxlen);
      break;

    default:
      runtime( "Flow or SADR expected" );
    }

     
#line 1004 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_NET, .val.net = src } );
  }

  
  #undef whati
#line 1007 "filter/f-inst.c"
  }
#line 1007

#line 1007

#line 1044 "filter/f-inst.c"
 /* Constructor for FI_NET_DST */
#line 1044
struct f_inst *
#line 1008 "filter/f-inst.c"
NONNULL(2)
#line 1044 "filter/f-inst.c"
f_new_inst_FI_NET_DST(enum f_instruction_code fi_code
#line 1008 "filter/f-inst.c"
  , struct f_inst * f1
#line 1044 "filter/f-inst.c"
)
#line 1044
  {
#line 1044
    /* Allocate the structure */
#line 1044
    struct f_inst *what = fi_new(fi_code);
#line 1044
    uint constargs = 1;
#line 1044

#line 1044
    /* Initialize all the members */
#line 1044
  #define whati (&(what->i_FI_NET_DST))
#line 1044
  #line 1008 "filter/f-inst.c"
whati->f1 = f1;
#line 1008
const struct f_inst *child1 = f1;
#line 1008
do {
#line 1008
  what->size += child1->size;
#line 1008

#line 1008
  if (child1->fi_code != FI_CONSTANT)
#line 1008
    constargs = 0;
#line 1008

#line 1008
} while (child1 = child1->next);
#line 1008

#line 1008 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1008
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1008
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1040 "filter/f-inst.c"
what->type = T_NET;

#line 1044 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1044
    if (!constargs)
#line 1044
      return what;
#line 1044

#line 1044
    /* Try to pre-calculate the result */
#line 1044
    #line 1007 "filter/f-inst.c"
 { 	/* Get dst prefix */
    
#line 1008 "filter/f-inst.c"
 #line 1008 "filter/f-inst.c"
 ;
#line 1009 "filter/f-inst.c"
    #line 1009 "filter/f-inst.c"
;

    net_addr_union *net = (void *) v1.val.net;
    net_addr *dst = falloc(sizeof(net_addr_ip6));
    const byte *part;

    switch(v1.val.net->type) {
    case NET_FLOW4:
      part = flow4_get_part(&net->flow4, FLOW_TYPE_DST_PREFIX);
      if (part)
	net_fill_ip4(dst, flow_read_ip4_part(part), flow_read_pxlen(part));
      else
	net_fill_ip4(dst, IP4_NONE, 0);
      break;

    case NET_FLOW6:
      part = flow6_get_part(&net->flow6, FLOW_TYPE_DST_PREFIX);
      if (part)
	net_fill_ip6(dst, flow_read_ip6_part(part), flow_read_pxlen(part));
      else
	net_fill_ip6(dst, IP6_NONE, 0);
      break;

    case NET_IP6_SADR:
      net_fill_ip6(dst, net->ip6_sadr.dst_prefix, net->ip6_sadr.dst_pxlen);
      break;

    default:
      runtime( "Flow or SADR expected" );
    }

     
#line 1040 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_NET, .val.net = dst } );
  }

  /* Get ROA max prefix length */
  
  #undef whati
#line 1044 "filter/f-inst.c"
  }
#line 1044

#line 1044

#line 1054 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_NET__maxlen */
#line 1054
struct f_inst *
#line 1044 "filter/f-inst.c"
NONNULL(2)
#line 1054 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_NET__maxlen(enum f_instruction_code fi_code
#line 1044 "filter/f-inst.c"
  , struct f_inst * f1
#line 1054 "filter/f-inst.c"
)
#line 1054
  {
#line 1054
    /* Allocate the structure */
#line 1054
    struct f_inst *what = fi_new(fi_code);
#line 1054
    uint constargs = 1;
#line 1054

#line 1054
    /* Initialize all the members */
#line 1054
  #define whati (&(what->i_FI_METHOD__T_NET__maxlen))
#line 1054
  #line 1044 "filter/f-inst.c"
whati->f1 = f1;
#line 1044
const struct f_inst *child1 = f1;
#line 1044
do {
#line 1044
  what->size += child1->size;
#line 1044

#line 1044
  if (child1->fi_code != FI_CONSTANT)
#line 1044
    constargs = 0;
#line 1044

#line 1044
} while (child1 = child1->next);
#line 1044

#line 1044 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1044
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1044
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1044 "filter/f-inst.c"
what->type = T_INT;

#line 1054 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1054
    if (!constargs)
#line 1054
      return what;
#line 1054

#line 1054
    /* Try to pre-calculate the result */
#line 1054
    #line 1044 "filter/f-inst.c"
 {
#line 1044
  
#line 1044 "filter/f-inst.c"
 #line 1044 "filter/f-inst.c"
 ;
#line 1044 "filter/f-inst.c"
  
#line 1044
    if (!net_is_roa(v1.val.net))
#line 1044
      runtime( "ROA expected" );
#line 1044

#line 1044
     
#line 1044 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = (v1.val.net->type == NET_ROA4) ?
#line 1044
      ((net_addr_roa4 *) v1.val.net)->max_pxlen :
#line 1044
      ((net_addr_roa6 *) v1.val.net)->max_pxlen } );
#line 1044
  
#line 1044
  #line 1044 "filter/f-inst.c"
;
#line 1044
};
#line 1052

  /* Get ROA ASN */
  
  #undef whati
#line 1054 "filter/f-inst.c"
  }
#line 1054

#line 1054

#line 1064 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_NET__asn */
#line 1064
struct f_inst *
#line 1054 "filter/f-inst.c"
NONNULL(2)
#line 1064 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_NET__asn(enum f_instruction_code fi_code
#line 1054 "filter/f-inst.c"
  , struct f_inst * f1
#line 1064 "filter/f-inst.c"
)
#line 1064
  {
#line 1064
    /* Allocate the structure */
#line 1064
    struct f_inst *what = fi_new(fi_code);
#line 1064
    uint constargs = 1;
#line 1064

#line 1064
    /* Initialize all the members */
#line 1064
  #define whati (&(what->i_FI_METHOD__T_NET__asn))
#line 1064
  #line 1054 "filter/f-inst.c"
whati->f1 = f1;
#line 1054
const struct f_inst *child1 = f1;
#line 1054
do {
#line 1054
  what->size += child1->size;
#line 1054

#line 1054
  if (child1->fi_code != FI_CONSTANT)
#line 1054
    constargs = 0;
#line 1054

#line 1054
} while (child1 = child1->next);
#line 1054

#line 1054 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1054
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1054
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1054 "filter/f-inst.c"
what->type = T_INT;

#line 1064 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1064
    if (!constargs)
#line 1064
      return what;
#line 1064

#line 1064
    /* Try to pre-calculate the result */
#line 1064
    #line 1054 "filter/f-inst.c"
 {
#line 1054
  
#line 1054 "filter/f-inst.c"
 #line 1054 "filter/f-inst.c"
 ;
#line 1054 "filter/f-inst.c"
  
#line 1054
        if (!net_is_roa(v1.val.net))
#line 1054
          runtime( "ROA expected" );
#line 1054

#line 1054
         
#line 1054 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = (v1.val.net->type == NET_ROA4) ?
#line 1054
          ((net_addr_roa4 *) v1.val.net)->asn :
#line 1054
          ((net_addr_roa6 *) v1.val.net)->asn } );
#line 1054
  
#line 1054
  #line 1054 "filter/f-inst.c"
;
#line 1054
};
#line 1062

  /* Convert prefix to IP */
  
  #undef whati
#line 1064 "filter/f-inst.c"
  }
#line 1064

#line 1064

#line 1066 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_NET__ip */
#line 1066
struct f_inst *
#line 1064 "filter/f-inst.c"
NONNULL(2)
#line 1066 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_NET__ip(enum f_instruction_code fi_code
#line 1064 "filter/f-inst.c"
  , struct f_inst * f1
#line 1066 "filter/f-inst.c"
)
#line 1066
  {
#line 1066
    /* Allocate the structure */
#line 1066
    struct f_inst *what = fi_new(fi_code);
#line 1066
    uint constargs = 1;
#line 1066

#line 1066
    /* Initialize all the members */
#line 1066
  #define whati (&(what->i_FI_METHOD__T_NET__ip))
#line 1066
  #line 1064 "filter/f-inst.c"
whati->f1 = f1;
#line 1064
const struct f_inst *child1 = f1;
#line 1064
do {
#line 1064
  what->size += child1->size;
#line 1064

#line 1064
  if (child1->fi_code != FI_CONSTANT)
#line 1064
    constargs = 0;
#line 1064

#line 1064
} while (child1 = child1->next);
#line 1064

#line 1064 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1064
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1064
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1064 "filter/f-inst.c"
what->type = T_IP;

#line 1066 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1066
    if (!constargs)
#line 1066
      return what;
#line 1066

#line 1066
    /* Try to pre-calculate the result */
#line 1066
    #line 1064 "filter/f-inst.c"
 {
#line 1064
  
#line 1064 "filter/f-inst.c"
 #line 1064 "filter/f-inst.c"
 ;
#line 1064 "filter/f-inst.c"
    
#line 1064 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_IP, .val.ip = net_prefix(v1.val.net) } ) 
#line 1064
  #line 1064 "filter/f-inst.c"
;
#line 1064
};

  
  #undef whati
#line 1066 "filter/f-inst.c"
  }
#line 1066

#line 1066

#line 1075 "filter/f-inst.c"
 /* Constructor for FI_ROUTE_DISTINGUISHER */
#line 1075
struct f_inst *
#line 1067 "filter/f-inst.c"
NONNULL(2)
#line 1075 "filter/f-inst.c"
f_new_inst_FI_ROUTE_DISTINGUISHER(enum f_instruction_code fi_code
#line 1067 "filter/f-inst.c"
  , struct f_inst * f1
#line 1075 "filter/f-inst.c"
)
#line 1075
  {
#line 1075
    /* Allocate the structure */
#line 1075
    struct f_inst *what = fi_new(fi_code);
#line 1075
    uint constargs = 1;
#line 1075

#line 1075
    /* Initialize all the members */
#line 1075
  #define whati (&(what->i_FI_ROUTE_DISTINGUISHER))
#line 1075
  #line 1067 "filter/f-inst.c"
whati->f1 = f1;
#line 1067
const struct f_inst *child1 = f1;
#line 1067
do {
#line 1067
  what->size += child1->size;
#line 1067

#line 1067
  if (child1->fi_code != FI_CONSTANT)
#line 1067
    constargs = 0;
#line 1067

#line 1067
} while (child1 = child1->next);
#line 1067

#line 1067 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1067
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1067
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1071 "filter/f-inst.c"
what->type = T_RD;

#line 1075 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1075
    if (!constargs)
#line 1075
      return what;
#line 1075

#line 1075
    /* Try to pre-calculate the result */
#line 1075
    #line 1066 "filter/f-inst.c"
 {
    
#line 1067 "filter/f-inst.c"
 #line 1067 "filter/f-inst.c"
 ;
#line 1068 "filter/f-inst.c"
    #line 1068 "filter/f-inst.c"
;
    if (!net_is_vpn(v1.val.net))
      runtime( "VPN address expected" );
     
#line 1071 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_RD, .val.rd = net_rd(v1.val.net) } );
  }

  /* Get first ASN from AS PATH */
  
  #undef whati
#line 1075 "filter/f-inst.c"
  }
#line 1075

#line 1075

#line 1078 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PATH__first */
#line 1078
struct f_inst *
#line 1075 "filter/f-inst.c"
NONNULL(2)
#line 1078 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PATH__first(enum f_instruction_code fi_code
#line 1075 "filter/f-inst.c"
  , struct f_inst * f1
#line 1078 "filter/f-inst.c"
)
#line 1078
  {
#line 1078
    /* Allocate the structure */
#line 1078
    struct f_inst *what = fi_new(fi_code);
#line 1078
    uint constargs = 1;
#line 1078

#line 1078
    /* Initialize all the members */
#line 1078
  #define whati (&(what->i_FI_METHOD__T_PATH__first))
#line 1078
  #line 1075 "filter/f-inst.c"
whati->f1 = f1;
#line 1075
const struct f_inst *child1 = f1;
#line 1075
do {
#line 1075
  what->size += child1->size;
#line 1075

#line 1075
  if (child1->fi_code != FI_CONSTANT)
#line 1075
    constargs = 0;
#line 1075

#line 1075
} while (child1 = child1->next);
#line 1075

#line 1075 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1075
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1075
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1075 "filter/f-inst.c"
what->type = T_INT;

#line 1078 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1078
    if (!constargs)
#line 1078
      return what;
#line 1078

#line 1078
    /* Try to pre-calculate the result */
#line 1078
    #line 1075 "filter/f-inst.c"
 {
#line 1075
  
#line 1075 "filter/f-inst.c"
 #line 1075 "filter/f-inst.c"
 ;
#line 1075 "filter/f-inst.c"
    
#line 1075 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = ({ u32 as = 0; as_path_get_first(v1.val.ad, &as); as; }) } ) 
#line 1075
  #line 1075 "filter/f-inst.c"
;
#line 1075
};

  /* Get last ASN from AS PATH */
  
  #undef whati
#line 1078 "filter/f-inst.c"
  }
#line 1078

#line 1078

#line 1081 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PATH__last */
#line 1081
struct f_inst *
#line 1078 "filter/f-inst.c"
NONNULL(2)
#line 1081 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PATH__last(enum f_instruction_code fi_code
#line 1078 "filter/f-inst.c"
  , struct f_inst * f1
#line 1081 "filter/f-inst.c"
)
#line 1081
  {
#line 1081
    /* Allocate the structure */
#line 1081
    struct f_inst *what = fi_new(fi_code);
#line 1081
    uint constargs = 1;
#line 1081

#line 1081
    /* Initialize all the members */
#line 1081
  #define whati (&(what->i_FI_METHOD__T_PATH__last))
#line 1081
  #line 1078 "filter/f-inst.c"
whati->f1 = f1;
#line 1078
const struct f_inst *child1 = f1;
#line 1078
do {
#line 1078
  what->size += child1->size;
#line 1078

#line 1078
  if (child1->fi_code != FI_CONSTANT)
#line 1078
    constargs = 0;
#line 1078

#line 1078
} while (child1 = child1->next);
#line 1078

#line 1078 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1078
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1078
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1078 "filter/f-inst.c"
what->type = T_INT;

#line 1081 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1081
    if (!constargs)
#line 1081
      return what;
#line 1081

#line 1081
    /* Try to pre-calculate the result */
#line 1081
    #line 1078 "filter/f-inst.c"
 {
#line 1078
  
#line 1078 "filter/f-inst.c"
 #line 1078 "filter/f-inst.c"
 ;
#line 1078 "filter/f-inst.c"
    
#line 1078 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = ({ u32 as = 0; as_path_get_last(v1.val.ad, &as); as; }) } ) 
#line 1078
  #line 1078 "filter/f-inst.c"
;
#line 1078
};

  /* Get last ASN from non-aggregated part of AS PATH */
  
  #undef whati
#line 1081 "filter/f-inst.c"
  }
#line 1081

#line 1081

#line 1084 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PATH__last_nonaggregated */
#line 1084
struct f_inst *
#line 1081 "filter/f-inst.c"
NONNULL(2)
#line 1084 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PATH__last_nonaggregated(enum f_instruction_code fi_code
#line 1081 "filter/f-inst.c"
  , struct f_inst * f1
#line 1084 "filter/f-inst.c"
)
#line 1084
  {
#line 1084
    /* Allocate the structure */
#line 1084
    struct f_inst *what = fi_new(fi_code);
#line 1084
    uint constargs = 1;
#line 1084

#line 1084
    /* Initialize all the members */
#line 1084
  #define whati (&(what->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1084
  #line 1081 "filter/f-inst.c"
whati->f1 = f1;
#line 1081
const struct f_inst *child1 = f1;
#line 1081
do {
#line 1081
  what->size += child1->size;
#line 1081

#line 1081
  if (child1->fi_code != FI_CONSTANT)
#line 1081
    constargs = 0;
#line 1081

#line 1081
} while (child1 = child1->next);
#line 1081

#line 1081 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1081
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1081
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1081 "filter/f-inst.c"
what->type = T_INT;

#line 1084 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1084
    if (!constargs)
#line 1084
      return what;
#line 1084

#line 1084
    /* Try to pre-calculate the result */
#line 1084
    #line 1081 "filter/f-inst.c"
 {
#line 1081
  
#line 1081 "filter/f-inst.c"
 #line 1081 "filter/f-inst.c"
 ;
#line 1081 "filter/f-inst.c"
    
#line 1081 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = as_path_get_last_nonaggregated(v1.val.ad) } ) 
#line 1081
  #line 1081 "filter/f-inst.c"
;
#line 1081
};

  /* Get ASN part from the standard community ASN */
  
  #undef whati
#line 1084 "filter/f-inst.c"
  }
#line 1084

#line 1084

#line 1087 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PAIR__asn */
#line 1087
struct f_inst *
#line 1084 "filter/f-inst.c"
NONNULL(2)
#line 1087 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PAIR__asn(enum f_instruction_code fi_code
#line 1084 "filter/f-inst.c"
  , struct f_inst * f1
#line 1087 "filter/f-inst.c"
)
#line 1087
  {
#line 1087
    /* Allocate the structure */
#line 1087
    struct f_inst *what = fi_new(fi_code);
#line 1087
    uint constargs = 1;
#line 1087

#line 1087
    /* Initialize all the members */
#line 1087
  #define whati (&(what->i_FI_METHOD__T_PAIR__asn))
#line 1087
  #line 1084 "filter/f-inst.c"
whati->f1 = f1;
#line 1084
const struct f_inst *child1 = f1;
#line 1084
do {
#line 1084
  what->size += child1->size;
#line 1084

#line 1084
  if (child1->fi_code != FI_CONSTANT)
#line 1084
    constargs = 0;
#line 1084

#line 1084
} while (child1 = child1->next);
#line 1084

#line 1084 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PAIR)) && !f_const_promotion(f1, (T_PAIR)))
#line 1084
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1084
	   f_instruction_name(what->fi_code), f_type_name(T_PAIR), f_type_name(f1->type));
#line 1084 "filter/f-inst.c"
what->type = T_INT;

#line 1087 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1087
    if (!constargs)
#line 1087
      return what;
#line 1087

#line 1087
    /* Try to pre-calculate the result */
#line 1087
    #line 1084 "filter/f-inst.c"
 {
#line 1084
  
#line 1084 "filter/f-inst.c"
 #line 1084 "filter/f-inst.c"
 ;
#line 1084 "filter/f-inst.c"
    
#line 1084 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i >> 16 } ) 
#line 1084
  #line 1084 "filter/f-inst.c"
;
#line 1084
};

  /* Get data part from the standard community */
  
  #undef whati
#line 1087 "filter/f-inst.c"
  }
#line 1087

#line 1087

#line 1090 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_PAIR__data */
#line 1090
struct f_inst *
#line 1087 "filter/f-inst.c"
NONNULL(2)
#line 1090 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_PAIR__data(enum f_instruction_code fi_code
#line 1087 "filter/f-inst.c"
  , struct f_inst * f1
#line 1090 "filter/f-inst.c"
)
#line 1090
  {
#line 1090
    /* Allocate the structure */
#line 1090
    struct f_inst *what = fi_new(fi_code);
#line 1090
    uint constargs = 1;
#line 1090

#line 1090
    /* Initialize all the members */
#line 1090
  #define whati (&(what->i_FI_METHOD__T_PAIR__data))
#line 1090
  #line 1087 "filter/f-inst.c"
whati->f1 = f1;
#line 1087
const struct f_inst *child1 = f1;
#line 1087
do {
#line 1087
  what->size += child1->size;
#line 1087

#line 1087
  if (child1->fi_code != FI_CONSTANT)
#line 1087
    constargs = 0;
#line 1087

#line 1087
} while (child1 = child1->next);
#line 1087

#line 1087 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PAIR)) && !f_const_promotion(f1, (T_PAIR)))
#line 1087
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1087
	   f_instruction_name(what->fi_code), f_type_name(T_PAIR), f_type_name(f1->type));
#line 1087 "filter/f-inst.c"
what->type = T_INT;

#line 1090 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1090
    if (!constargs)
#line 1090
      return what;
#line 1090

#line 1090
    /* Try to pre-calculate the result */
#line 1090
    #line 1087 "filter/f-inst.c"
 {
#line 1087
  
#line 1087 "filter/f-inst.c"
 #line 1087 "filter/f-inst.c"
 ;
#line 1087 "filter/f-inst.c"
    
#line 1087 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.i & 0xFFFF } ) 
#line 1087
  #line 1087 "filter/f-inst.c"
;
#line 1087
};

  /* Get ASN part from the large community */
  
  #undef whati
#line 1090 "filter/f-inst.c"
  }
#line 1090

#line 1090

#line 1093 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LC__asn */
#line 1093
struct f_inst *
#line 1090 "filter/f-inst.c"
NONNULL(2)
#line 1093 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LC__asn(enum f_instruction_code fi_code
#line 1090 "filter/f-inst.c"
  , struct f_inst * f1
#line 1093 "filter/f-inst.c"
)
#line 1093
  {
#line 1093
    /* Allocate the structure */
#line 1093
    struct f_inst *what = fi_new(fi_code);
#line 1093
    uint constargs = 1;
#line 1093

#line 1093
    /* Initialize all the members */
#line 1093
  #define whati (&(what->i_FI_METHOD__T_LC__asn))
#line 1093
  #line 1090 "filter/f-inst.c"
whati->f1 = f1;
#line 1090
const struct f_inst *child1 = f1;
#line 1090
do {
#line 1090
  what->size += child1->size;
#line 1090

#line 1090
  if (child1->fi_code != FI_CONSTANT)
#line 1090
    constargs = 0;
#line 1090

#line 1090
} while (child1 = child1->next);
#line 1090

#line 1090 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LC)) && !f_const_promotion(f1, (T_LC)))
#line 1090
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1090
	   f_instruction_name(what->fi_code), f_type_name(T_LC), f_type_name(f1->type));
#line 1090 "filter/f-inst.c"
what->type = T_INT;

#line 1093 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1093
    if (!constargs)
#line 1093
      return what;
#line 1093

#line 1093
    /* Try to pre-calculate the result */
#line 1093
    #line 1090 "filter/f-inst.c"
 {
#line 1090
  
#line 1090 "filter/f-inst.c"
 #line 1090 "filter/f-inst.c"
 ;
#line 1090 "filter/f-inst.c"
    
#line 1090 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.lc.asn } ) 
#line 1090
  #line 1090 "filter/f-inst.c"
;
#line 1090
};

  /* Get data1 part from the large community */
  
  #undef whati
#line 1093 "filter/f-inst.c"
  }
#line 1093

#line 1093

#line 1096 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LC__data1 */
#line 1096
struct f_inst *
#line 1093 "filter/f-inst.c"
NONNULL(2)
#line 1096 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LC__data1(enum f_instruction_code fi_code
#line 1093 "filter/f-inst.c"
  , struct f_inst * f1
#line 1096 "filter/f-inst.c"
)
#line 1096
  {
#line 1096
    /* Allocate the structure */
#line 1096
    struct f_inst *what = fi_new(fi_code);
#line 1096
    uint constargs = 1;
#line 1096

#line 1096
    /* Initialize all the members */
#line 1096
  #define whati (&(what->i_FI_METHOD__T_LC__data1))
#line 1096
  #line 1093 "filter/f-inst.c"
whati->f1 = f1;
#line 1093
const struct f_inst *child1 = f1;
#line 1093
do {
#line 1093
  what->size += child1->size;
#line 1093

#line 1093
  if (child1->fi_code != FI_CONSTANT)
#line 1093
    constargs = 0;
#line 1093

#line 1093
} while (child1 = child1->next);
#line 1093

#line 1093 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LC)) && !f_const_promotion(f1, (T_LC)))
#line 1093
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1093
	   f_instruction_name(what->fi_code), f_type_name(T_LC), f_type_name(f1->type));
#line 1093 "filter/f-inst.c"
what->type = T_INT;

#line 1096 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1096
    if (!constargs)
#line 1096
      return what;
#line 1096

#line 1096
    /* Try to pre-calculate the result */
#line 1096
    #line 1093 "filter/f-inst.c"
 {
#line 1093
  
#line 1093 "filter/f-inst.c"
 #line 1093 "filter/f-inst.c"
 ;
#line 1093 "filter/f-inst.c"
    
#line 1093 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.lc.ldp1 } ) 
#line 1093
  #line 1093 "filter/f-inst.c"
;
#line 1093
};

  /* Get data2 part from the large community */
  
  #undef whati
#line 1096 "filter/f-inst.c"
  }
#line 1096

#line 1096

#line 1099 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LC__data2 */
#line 1099
struct f_inst *
#line 1096 "filter/f-inst.c"
NONNULL(2)
#line 1099 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LC__data2(enum f_instruction_code fi_code
#line 1096 "filter/f-inst.c"
  , struct f_inst * f1
#line 1099 "filter/f-inst.c"
)
#line 1099
  {
#line 1099
    /* Allocate the structure */
#line 1099
    struct f_inst *what = fi_new(fi_code);
#line 1099
    uint constargs = 1;
#line 1099

#line 1099
    /* Initialize all the members */
#line 1099
  #define whati (&(what->i_FI_METHOD__T_LC__data2))
#line 1099
  #line 1096 "filter/f-inst.c"
whati->f1 = f1;
#line 1096
const struct f_inst *child1 = f1;
#line 1096
do {
#line 1096
  what->size += child1->size;
#line 1096

#line 1096
  if (child1->fi_code != FI_CONSTANT)
#line 1096
    constargs = 0;
#line 1096

#line 1096
} while (child1 = child1->next);
#line 1096

#line 1096 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LC)) && !f_const_promotion(f1, (T_LC)))
#line 1096
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1096
	   f_instruction_name(what->fi_code), f_type_name(T_LC), f_type_name(f1->type));
#line 1096 "filter/f-inst.c"
what->type = T_INT;

#line 1099 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1099
    if (!constargs)
#line 1099
      return what;
#line 1099

#line 1099
    /* Try to pre-calculate the result */
#line 1099
    #line 1096 "filter/f-inst.c"
 {
#line 1096
  
#line 1096 "filter/f-inst.c"
 #line 1096 "filter/f-inst.c"
 ;
#line 1096 "filter/f-inst.c"
    
#line 1096 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_INT, .val.i = v1.val.lc.ldp2 } ) 
#line 1096
  #line 1096 "filter/f-inst.c"
;
#line 1096
};

  /* Get minimum element from clist */
  
  #undef whati
#line 1099 "filter/f-inst.c"
  }
#line 1099

#line 1099

#line 1102 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_CLIST__min */
#line 1102
struct f_inst *
#line 1099 "filter/f-inst.c"
NONNULL(2)
#line 1102 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_CLIST__min(enum f_instruction_code fi_code
#line 1099 "filter/f-inst.c"
  , struct f_inst * f1
#line 1102 "filter/f-inst.c"
)
#line 1102
  {
#line 1102
    /* Allocate the structure */
#line 1102
    struct f_inst *what = fi_new(fi_code);
#line 1102
    uint constargs = 1;
#line 1102

#line 1102
    /* Initialize all the members */
#line 1102
  #define whati (&(what->i_FI_METHOD__T_CLIST__min))
#line 1102
  #line 1099 "filter/f-inst.c"
whati->f1 = f1;
#line 1099
const struct f_inst *child1 = f1;
#line 1099
do {
#line 1099
  what->size += child1->size;
#line 1099

#line 1099
  if (child1->fi_code != FI_CONSTANT)
#line 1099
    constargs = 0;
#line 1099

#line 1099
} while (child1 = child1->next);
#line 1099

#line 1099 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1099
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1099
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1099 "filter/f-inst.c"
what->type = T_PAIR;

#line 1102 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1102
    if (!constargs)
#line 1102
      return what;
#line 1102

#line 1102
    /* Try to pre-calculate the result */
#line 1102
    #line 1099 "filter/f-inst.c"
 {
#line 1099
  
#line 1099 "filter/f-inst.c"
 #line 1099 "filter/f-inst.c"
 ;
#line 1099 "filter/f-inst.c"
    
#line 1099 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PAIR, .val.i = ({ u32 val = 0; int_set_min(v1.val.ad, &val); val; }) } ) 
#line 1099
  #line 1099 "filter/f-inst.c"
;
#line 1099
};

  /* Get maximum element from clist */
  
  #undef whati
#line 1102 "filter/f-inst.c"
  }
#line 1102

#line 1102

#line 1105 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_CLIST__max */
#line 1105
struct f_inst *
#line 1102 "filter/f-inst.c"
NONNULL(2)
#line 1105 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_CLIST__max(enum f_instruction_code fi_code
#line 1102 "filter/f-inst.c"
  , struct f_inst * f1
#line 1105 "filter/f-inst.c"
)
#line 1105
  {
#line 1105
    /* Allocate the structure */
#line 1105
    struct f_inst *what = fi_new(fi_code);
#line 1105
    uint constargs = 1;
#line 1105

#line 1105
    /* Initialize all the members */
#line 1105
  #define whati (&(what->i_FI_METHOD__T_CLIST__max))
#line 1105
  #line 1102 "filter/f-inst.c"
whati->f1 = f1;
#line 1102
const struct f_inst *child1 = f1;
#line 1102
do {
#line 1102
  what->size += child1->size;
#line 1102

#line 1102
  if (child1->fi_code != FI_CONSTANT)
#line 1102
    constargs = 0;
#line 1102

#line 1102
} while (child1 = child1->next);
#line 1102

#line 1102 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1102
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1102
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1102 "filter/f-inst.c"
what->type = T_PAIR;

#line 1105 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1105
    if (!constargs)
#line 1105
      return what;
#line 1105

#line 1105
    /* Try to pre-calculate the result */
#line 1105
    #line 1102 "filter/f-inst.c"
 {
#line 1102
  
#line 1102 "filter/f-inst.c"
 #line 1102 "filter/f-inst.c"
 ;
#line 1102 "filter/f-inst.c"
    
#line 1102 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PAIR, .val.i = ({ u32 val = 0; int_set_max(v1.val.ad, &val); val; }) } ) 
#line 1102
  #line 1102 "filter/f-inst.c"
;
#line 1102
};

  /* Get minimum element from eclist */
  
  #undef whati
#line 1105 "filter/f-inst.c"
  }
#line 1105

#line 1105

#line 1108 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_ECLIST__min */
#line 1108
struct f_inst *
#line 1105 "filter/f-inst.c"
NONNULL(2)
#line 1108 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_ECLIST__min(enum f_instruction_code fi_code
#line 1105 "filter/f-inst.c"
  , struct f_inst * f1
#line 1108 "filter/f-inst.c"
)
#line 1108
  {
#line 1108
    /* Allocate the structure */
#line 1108
    struct f_inst *what = fi_new(fi_code);
#line 1108
    uint constargs = 1;
#line 1108

#line 1108
    /* Initialize all the members */
#line 1108
  #define whati (&(what->i_FI_METHOD__T_ECLIST__min))
#line 1108
  #line 1105 "filter/f-inst.c"
whati->f1 = f1;
#line 1105
const struct f_inst *child1 = f1;
#line 1105
do {
#line 1105
  what->size += child1->size;
#line 1105

#line 1105
  if (child1->fi_code != FI_CONSTANT)
#line 1105
    constargs = 0;
#line 1105

#line 1105
} while (child1 = child1->next);
#line 1105

#line 1105 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1105
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1105
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1105 "filter/f-inst.c"
what->type = T_EC;

#line 1108 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1108
    if (!constargs)
#line 1108
      return what;
#line 1108

#line 1108
    /* Try to pre-calculate the result */
#line 1108
    #line 1105 "filter/f-inst.c"
 {
#line 1105
  
#line 1105 "filter/f-inst.c"
 #line 1105 "filter/f-inst.c"
 ;
#line 1105 "filter/f-inst.c"
    
#line 1105 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ({ u64 val = 0; ec_set_min(v1.val.ad, &val); val; }) } ) 
#line 1105
  #line 1105 "filter/f-inst.c"
;
#line 1105
};

  /* Get maximum element from eclist */
  
  #undef whati
#line 1108 "filter/f-inst.c"
  }
#line 1108

#line 1108

#line 1111 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_ECLIST__max */
#line 1111
struct f_inst *
#line 1108 "filter/f-inst.c"
NONNULL(2)
#line 1111 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_ECLIST__max(enum f_instruction_code fi_code
#line 1108 "filter/f-inst.c"
  , struct f_inst * f1
#line 1111 "filter/f-inst.c"
)
#line 1111
  {
#line 1111
    /* Allocate the structure */
#line 1111
    struct f_inst *what = fi_new(fi_code);
#line 1111
    uint constargs = 1;
#line 1111

#line 1111
    /* Initialize all the members */
#line 1111
  #define whati (&(what->i_FI_METHOD__T_ECLIST__max))
#line 1111
  #line 1108 "filter/f-inst.c"
whati->f1 = f1;
#line 1108
const struct f_inst *child1 = f1;
#line 1108
do {
#line 1108
  what->size += child1->size;
#line 1108

#line 1108
  if (child1->fi_code != FI_CONSTANT)
#line 1108
    constargs = 0;
#line 1108

#line 1108
} while (child1 = child1->next);
#line 1108

#line 1108 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1108
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1108
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1108 "filter/f-inst.c"
what->type = T_EC;

#line 1111 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1111
    if (!constargs)
#line 1111
      return what;
#line 1111

#line 1111
    /* Try to pre-calculate the result */
#line 1111
    #line 1108 "filter/f-inst.c"
 {
#line 1108
  
#line 1108 "filter/f-inst.c"
 #line 1108 "filter/f-inst.c"
 ;
#line 1108 "filter/f-inst.c"
    
#line 1108 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_EC, .val.ec = ({ u64 val = 0; ec_set_max(v1.val.ad, &val); val; }) } ) 
#line 1108
  #line 1108 "filter/f-inst.c"
;
#line 1108
};

  /* Get minimum element from lclist */
  
  #undef whati
#line 1111 "filter/f-inst.c"
  }
#line 1111

#line 1111

#line 1114 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LCLIST__min */
#line 1114
struct f_inst *
#line 1111 "filter/f-inst.c"
NONNULL(2)
#line 1114 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LCLIST__min(enum f_instruction_code fi_code
#line 1111 "filter/f-inst.c"
  , struct f_inst * f1
#line 1114 "filter/f-inst.c"
)
#line 1114
  {
#line 1114
    /* Allocate the structure */
#line 1114
    struct f_inst *what = fi_new(fi_code);
#line 1114
    uint constargs = 1;
#line 1114

#line 1114
    /* Initialize all the members */
#line 1114
  #define whati (&(what->i_FI_METHOD__T_LCLIST__min))
#line 1114
  #line 1111 "filter/f-inst.c"
whati->f1 = f1;
#line 1111
const struct f_inst *child1 = f1;
#line 1111
do {
#line 1111
  what->size += child1->size;
#line 1111

#line 1111
  if (child1->fi_code != FI_CONSTANT)
#line 1111
    constargs = 0;
#line 1111

#line 1111
} while (child1 = child1->next);
#line 1111

#line 1111 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1111
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1111
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1111 "filter/f-inst.c"
what->type = T_LC;

#line 1114 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1114
    if (!constargs)
#line 1114
      return what;
#line 1114

#line 1114
    /* Try to pre-calculate the result */
#line 1114
    #line 1111 "filter/f-inst.c"
 {
#line 1111
  
#line 1111 "filter/f-inst.c"
 #line 1111 "filter/f-inst.c"
 ;
#line 1111 "filter/f-inst.c"
    
#line 1111 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LC, .val.lc = ({ lcomm val = {}; lc_set_min(v1.val.ad, &val); val; }) } ) 
#line 1111
  #line 1111 "filter/f-inst.c"
;
#line 1111
};

  /* Get maximum element from lclist */
  
  #undef whati
#line 1114 "filter/f-inst.c"
  }
#line 1114

#line 1114

#line 1116 "filter/f-inst.c"
 /* Constructor for FI_METHOD__T_LCLIST__max */
#line 1116
struct f_inst *
#line 1114 "filter/f-inst.c"
NONNULL(2)
#line 1116 "filter/f-inst.c"
f_new_inst_FI_METHOD__T_LCLIST__max(enum f_instruction_code fi_code
#line 1114 "filter/f-inst.c"
  , struct f_inst * f1
#line 1116 "filter/f-inst.c"
)
#line 1116
  {
#line 1116
    /* Allocate the structure */
#line 1116
    struct f_inst *what = fi_new(fi_code);
#line 1116
    uint constargs = 1;
#line 1116

#line 1116
    /* Initialize all the members */
#line 1116
  #define whati (&(what->i_FI_METHOD__T_LCLIST__max))
#line 1116
  #line 1114 "filter/f-inst.c"
whati->f1 = f1;
#line 1114
const struct f_inst *child1 = f1;
#line 1114
do {
#line 1114
  what->size += child1->size;
#line 1114

#line 1114
  if (child1->fi_code != FI_CONSTANT)
#line 1114
    constargs = 0;
#line 1114

#line 1114
} while (child1 = child1->next);
#line 1114

#line 1114 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1114
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1114
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1114 "filter/f-inst.c"
what->type = T_LC;

#line 1116 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1116
    if (!constargs)
#line 1116
      return what;
#line 1116

#line 1116
    /* Try to pre-calculate the result */
#line 1116
    #line 1114 "filter/f-inst.c"
 {
#line 1114
  
#line 1114 "filter/f-inst.c"
 #line 1114 "filter/f-inst.c"
 ;
#line 1114 "filter/f-inst.c"
    
#line 1114 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LC, .val.lc = ({ lcomm val = {}; lc_set_max(v1.val.ad, &val); val; }) } ) 
#line 1114
  #line 1114 "filter/f-inst.c"
;
#line 1114
};

  
  #undef whati
#line 1116 "filter/f-inst.c"
  }
#line 1116

#line 1116

#line 1142 "filter/f-inst.c"
 /* Constructor for FI_RETURN */
#line 1142
struct f_inst *
#line 1119 "filter/f-inst.c"
NONNULL(2)
#line 1142 "filter/f-inst.c"
f_new_inst_FI_RETURN(enum f_instruction_code fi_code
#line 1119 "filter/f-inst.c"
  , struct f_inst * f1
#line 1142 "filter/f-inst.c"
)
#line 1142
  {
#line 1142
    /* Allocate the structure */
#line 1142
    struct f_inst *what = fi_new(fi_code);
#line 1142
    
#line 1142

#line 1142
    /* Initialize all the members */
#line 1142
  #define whati (&(what->i_FI_RETURN))
#line 1142
  #line 1119 "filter/f-inst.c"
whati->f1 = f1;
#line 1119
const struct f_inst *child1 = f1;
#line 1119
do {
#line 1119
  what->size += child1->size;
#line 1119

#line 1119
} while (child1 = child1->next);
#line 1119


#line 1142 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1142
    
#line 1142
      return what;
#line 1142

#line 1142
    /* Try to pre-calculate the result */
#line 1142
      #undef whati
#line 1142
  }
#line 1142

#line 1142

#line 1202 "filter/f-inst.c"
 /* Constructor for FI_CALL */
#line 1202
struct f_inst *
#line 1202
f_new_inst_FI_CALL(enum f_instruction_code fi_code
#line 1144 "filter/f-inst.c"
  , struct f_inst * fvar
#line 1145 "filter/f-inst.c"
  , struct symbol * sym
#line 1202 "filter/f-inst.c"
)
#line 1202
  {
#line 1202
    /* Allocate the structure */
#line 1202
    struct f_inst *what = fi_new(fi_code);
#line 1202
    
#line 1202

#line 1202
    /* Initialize all the members */
#line 1202
  #define whati (&(what->i_FI_CALL))
#line 1202
  #line 1144 "filter/f-inst.c"
whati->varcount = 0;
#line 1144
whati->fvar = fvar;
#line 1144
for (const struct f_inst *child = fvar; child; child = child->next, whati->varcount++) {
#line 1144
  what->size += child->size;
#line 1144

#line 1144
}
#line 1144

#line 1145 "filter/f-inst.c"
whati->sym = sym;
#line 1146 "filter/f-inst.c"
what->type = sym->function->return_type;

#line 1149 "filter/f-inst.c"
    ASSERT(sym->class == SYM_FUNCTION);

    if (whati->varcount != sym->function->args)
      cf_error("Function '%s' expects %u arguments, got %u arguments",
	       sym->name, sym->function->args, whati->varcount);

    /* Typecheck individual arguments */
    struct f_inst *a = fvar;
    struct f_arg *b = sym->function->arg_list;
    for (uint i = 1; a && b; a = a->next, b = b->next, i++)
    {
      enum btype b_type = b->arg->class & 0xff;

      if (a->type && (a->type != b_type) && !f_const_promotion(a, b_type))
	cf_error("Argument %u of '%s' must be %s, got %s",
		 i, sym->name, f_type_name(b_type), f_type_name(a->type));
    }
    ASSERT(!a && !b);

    /* Add implicit void slot for the return value */
    struct f_inst *tmp = f_new_inst(FI_CONSTANT, (struct f_val) { .type = T_VOID });
    tmp->next = whati->fvar;
    whati->fvar = tmp;
    what->size += tmp->size;

    /* Mark recursive calls, they have dummy f_line */
    if (!sym->function->len)
      what->flags |= FIF_RECURSIVE;

    
#line 1202 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1202
    
#line 1202
      return what;
#line 1202

#line 1202
    /* Try to pre-calculate the result */
#line 1202
      #undef whati
#line 1202
  }
#line 1202

#line 1202

#line 1207 "filter/f-inst.c"
 /* Constructor for FI_DROP_RESULT */
#line 1207
struct f_inst *
#line 1204 "filter/f-inst.c"
NONNULL(2)
#line 1207 "filter/f-inst.c"
f_new_inst_FI_DROP_RESULT(enum f_instruction_code fi_code
#line 1204 "filter/f-inst.c"
  , struct f_inst * f1
#line 1207 "filter/f-inst.c"
)
#line 1207
  {
#line 1207
    /* Allocate the structure */
#line 1207
    struct f_inst *what = fi_new(fi_code);
#line 1207
    
#line 1207

#line 1207
    /* Initialize all the members */
#line 1207
  #define whati (&(what->i_FI_DROP_RESULT))
#line 1207
  #line 1204 "filter/f-inst.c"
whati->f1 = f1;
#line 1204
const struct f_inst *child1 = f1;
#line 1204
do {
#line 1204
  what->size += child1->size;
#line 1204

#line 1204
} while (child1 = child1->next);
#line 1204


#line 1207 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1207
    
#line 1207
      return what;
#line 1207

#line 1207
    /* Try to pre-calculate the result */
#line 1207
      #undef whati
#line 1207
  }
#line 1207

#line 1207

#line 1248 "filter/f-inst.c"
 /* Constructor for FI_SWITCH */
#line 1248
struct f_inst *
#line 1208 "filter/f-inst.c"
NONNULL(2)
#line 1248 "filter/f-inst.c"
f_new_inst_FI_SWITCH(enum f_instruction_code fi_code
#line 1208 "filter/f-inst.c"
  , struct f_inst * f1
#line 1210 "filter/f-inst.c"
  , struct f_tree * tree
#line 1248 "filter/f-inst.c"
)
#line 1248
  {
#line 1248
    /* Allocate the structure */
#line 1248
    struct f_inst *what = fi_new(fi_code);
#line 1248
    uint constargs = 1;
#line 1248

#line 1248
    /* Initialize all the members */
#line 1248
  #define whati (&(what->i_FI_SWITCH))
#line 1248
  #line 1208 "filter/f-inst.c"
whati->f1 = f1;
#line 1208
const struct f_inst *child1 = f1;
#line 1208
do {
#line 1208
  what->size += child1->size;
#line 1208

#line 1208
  if (child1->fi_code != FI_CONSTANT)
#line 1208
    constargs = 0;
#line 1208

#line 1208
} while (child1 = child1->next);
#line 1208

#line 1210 "filter/f-inst.c"
whati->tree = tree;

#line 1248 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1248
    if (!constargs)
#line 1248
      return what;
#line 1248

#line 1248
    /* Try to pre-calculate the result */
#line 1248
    #line 1207 "filter/f-inst.c"
 {
    
#line 1208 "filter/f-inst.c"
;

    #line 1210 "filter/f-inst.c"
;

    
#line 1234 "filter/f-inst.c"
    /* In parse-time use find_tree_linear(), in runtime use find_tree() */
    const struct f_tree *t = find_tree_linear(tree, &v1);
    if (!t) {
      v1.type = T_VOID;
      t = find_tree_linear(tree, &v1);
      if (!t) {
	debug( "No else statement?\n");
	return NULL;
      }
    }

    return t->data ;
#line 1246 "filter/f-inst.c"
  }

  
  #undef whati
#line 1248 "filter/f-inst.c"
  }
#line 1248

#line 1248

#line 1257 "filter/f-inst.c"
 /* Constructor for FI_IP_MASK */
#line 1257
struct f_inst *
#line 1249 "filter/f-inst.c"
NONNULL(2)
#line 1250 "filter/f-inst.c"
NONNULL(3)
#line 1257 "filter/f-inst.c"
f_new_inst_FI_IP_MASK(enum f_instruction_code fi_code
#line 1249 "filter/f-inst.c"
  , struct f_inst * f1
#line 1250 "filter/f-inst.c"
  , struct f_inst * f2
#line 1257 "filter/f-inst.c"
)
#line 1257
  {
#line 1257
    /* Allocate the structure */
#line 1257
    struct f_inst *what = fi_new(fi_code);
#line 1257
    uint constargs = 1;
#line 1257

#line 1257
    /* Initialize all the members */
#line 1257
  #define whati (&(what->i_FI_IP_MASK))
#line 1257
  #line 1249 "filter/f-inst.c"
whati->f1 = f1;
#line 1249
const struct f_inst *child1 = f1;
#line 1249
do {
#line 1249
  what->size += child1->size;
#line 1249

#line 1249
  if (child1->fi_code != FI_CONSTANT)
#line 1249
    constargs = 0;
#line 1249

#line 1249
} while (child1 = child1->next);
#line 1249

#line 1249 "filter/f-inst.c"
if (f1->type && (f1->type != (T_IP)) && !f_const_promotion(f1, (T_IP)))
#line 1249
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1249
	   f_instruction_name(what->fi_code), f_type_name(T_IP), f_type_name(f1->type));
#line 1250 "filter/f-inst.c"
whati->f2 = f2;
#line 1250
const struct f_inst *child2 = f2;
#line 1250
do {
#line 1250
  what->size += child2->size;
#line 1250

#line 1250
  if (child2->fi_code != FI_CONSTANT)
#line 1250
    constargs = 0;
#line 1250

#line 1250
} while (child2 = child2->next);
#line 1250 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 1250
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1250
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 1252 "filter/f-inst.c"
what->type = T_IP;

#line 1257 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1257
    if (!constargs)
#line 1257
      return what;
#line 1257

#line 1257
    /* Try to pre-calculate the result */
#line 1257
    #line 1248 "filter/f-inst.c"
 { /* IP.MASK(val) */
    
#line 1249 "filter/f-inst.c"
 #line 1249 "filter/f-inst.c"
 ;
#line 1250 "filter/f-inst.c"
    
#line 1250 "filter/f-inst.c"
 #line 1250 "filter/f-inst.c"
 ;
#line 1251 "filter/f-inst.c"
    #line 1251 "filter/f-inst.c"
;
     
#line 1252 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_IP, .val.ip =  ipa_is_ip4(v1.val.ip) ?
#line 1252
      ipa_from_ip4(ip4_and(ipa_to_ip4(v1.val.ip), ip4_mkmask(v2.val.i))) :
#line 1252
      ipa_from_ip6(ip6_and(ipa_to_ip6(v1.val.ip), ip6_mkmask(v2.val.i)))  } );
#line 1255
  }

  
  #undef whati
#line 1257 "filter/f-inst.c"
  }
#line 1257

#line 1257

#line 1265 "filter/f-inst.c"
 /* Constructor for FI_PATH_PREPEND */
#line 1265
struct f_inst *
#line 1258 "filter/f-inst.c"
NONNULL(2)
#line 1259 "filter/f-inst.c"
NONNULL(3)
#line 1265 "filter/f-inst.c"
f_new_inst_FI_PATH_PREPEND(enum f_instruction_code fi_code
#line 1258 "filter/f-inst.c"
  , struct f_inst * f1
#line 1259 "filter/f-inst.c"
  , struct f_inst * f2
#line 1265 "filter/f-inst.c"
)
#line 1265
  {
#line 1265
    /* Allocate the structure */
#line 1265
    struct f_inst *what = fi_new(fi_code);
#line 1265
    uint constargs = 1;
#line 1265

#line 1265
    /* Initialize all the members */
#line 1265
  #define whati (&(what->i_FI_PATH_PREPEND))
#line 1265
  #line 1258 "filter/f-inst.c"
whati->f1 = f1;
#line 1258
const struct f_inst *child1 = f1;
#line 1258
do {
#line 1258
  what->size += child1->size;
#line 1258

#line 1258
  if (child1->fi_code != FI_CONSTANT)
#line 1258
    constargs = 0;
#line 1258

#line 1258
} while (child1 = child1->next);
#line 1258

#line 1258 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1258
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1258
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1259 "filter/f-inst.c"
whati->f2 = f2;
#line 1259
const struct f_inst *child2 = f2;
#line 1259
do {
#line 1259
  what->size += child2->size;
#line 1259

#line 1259
  if (child2->fi_code != FI_CONSTANT)
#line 1259
    constargs = 0;
#line 1259

#line 1259
} while (child2 = child2->next);
#line 1259 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 1259
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1259
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 1261 "filter/f-inst.c"
what->type = T_PATH;

#line 1265 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1265
    if (!constargs)
#line 1265
      return what;
#line 1265

#line 1265
    /* Try to pre-calculate the result */
#line 1265
    #line 1257 "filter/f-inst.c"
 {	/* Path prepend */
    
#line 1258 "filter/f-inst.c"
 #line 1258 "filter/f-inst.c"
 ;
#line 1259 "filter/f-inst.c"
    
#line 1259 "filter/f-inst.c"
 #line 1259 "filter/f-inst.c"
 ;
#line 1260 "filter/f-inst.c"
    #line 1260 "filter/f-inst.c"
;
     
#line 1261 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH, .val.ad =  as_path_prepend(fpool, v1.val.ad, v2.val.i)  } );
  }

  /* Community list add */
  
  #undef whati
#line 1265 "filter/f-inst.c"
  }
#line 1265

#line 1265

#line 1272 "filter/f-inst.c"
 /* Constructor for FI_CLIST_ADD_PAIR */
#line 1272
struct f_inst *
#line 1266 "filter/f-inst.c"
NONNULL(2)
#line 1267 "filter/f-inst.c"
NONNULL(3)
#line 1272 "filter/f-inst.c"
f_new_inst_FI_CLIST_ADD_PAIR(enum f_instruction_code fi_code
#line 1266 "filter/f-inst.c"
  , struct f_inst * f1
#line 1267 "filter/f-inst.c"
  , struct f_inst * f2
#line 1272 "filter/f-inst.c"
)
#line 1272
  {
#line 1272
    /* Allocate the structure */
#line 1272
    struct f_inst *what = fi_new(fi_code);
#line 1272
    uint constargs = 1;
#line 1272

#line 1272
    /* Initialize all the members */
#line 1272
  #define whati (&(what->i_FI_CLIST_ADD_PAIR))
#line 1272
  #line 1266 "filter/f-inst.c"
whati->f1 = f1;
#line 1266
const struct f_inst *child1 = f1;
#line 1266
do {
#line 1266
  what->size += child1->size;
#line 1266

#line 1266
  if (child1->fi_code != FI_CONSTANT)
#line 1266
    constargs = 0;
#line 1266

#line 1266
} while (child1 = child1->next);
#line 1266

#line 1266 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1266
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1266
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1267 "filter/f-inst.c"
whati->f2 = f2;
#line 1267
const struct f_inst *child2 = f2;
#line 1267
do {
#line 1267
  what->size += child2->size;
#line 1267

#line 1267
  if (child2->fi_code != FI_CONSTANT)
#line 1267
    constargs = 0;
#line 1267

#line 1267
} while (child2 = child2->next);
#line 1267 "filter/f-inst.c"
if (f2->type && (f2->type != (T_PAIR)) && !f_const_promotion(f2, (T_PAIR)))
#line 1267
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1267
	   f_instruction_name(what->fi_code), f_type_name(T_PAIR), f_type_name(f2->type));
#line 1269 "filter/f-inst.c"
what->type = T_CLIST;

#line 1272 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1272
    if (!constargs)
#line 1272
      return what;
#line 1272

#line 1272
    /* Try to pre-calculate the result */
#line 1272
    #line 1265 "filter/f-inst.c"
 {
    
#line 1266 "filter/f-inst.c"
 #line 1266 "filter/f-inst.c"
 ;
#line 1267 "filter/f-inst.c"
    
#line 1267 "filter/f-inst.c"
 #line 1267 "filter/f-inst.c"
 ;
#line 1268 "filter/f-inst.c"
    #line 1268 "filter/f-inst.c"
;
     
#line 1269 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_add(fpool, v1.val.ad, v2.val.i)  } );
  }

  
  #undef whati
#line 1272 "filter/f-inst.c"
  }
#line 1272

#line 1272

#line 1286 "filter/f-inst.c"
 /* Constructor for FI_CLIST_ADD_IP */
#line 1286
struct f_inst *
#line 1273 "filter/f-inst.c"
NONNULL(2)
#line 1274 "filter/f-inst.c"
NONNULL(3)
#line 1286 "filter/f-inst.c"
f_new_inst_FI_CLIST_ADD_IP(enum f_instruction_code fi_code
#line 1273 "filter/f-inst.c"
  , struct f_inst * f1
#line 1274 "filter/f-inst.c"
  , struct f_inst * f2
#line 1286 "filter/f-inst.c"
)
#line 1286
  {
#line 1286
    /* Allocate the structure */
#line 1286
    struct f_inst *what = fi_new(fi_code);
#line 1286
    uint constargs = 1;
#line 1286

#line 1286
    /* Initialize all the members */
#line 1286
  #define whati (&(what->i_FI_CLIST_ADD_IP))
#line 1286
  #line 1273 "filter/f-inst.c"
whati->f1 = f1;
#line 1273
const struct f_inst *child1 = f1;
#line 1273
do {
#line 1273
  what->size += child1->size;
#line 1273

#line 1273
  if (child1->fi_code != FI_CONSTANT)
#line 1273
    constargs = 0;
#line 1273

#line 1273
} while (child1 = child1->next);
#line 1273

#line 1273 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1273
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1273
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1274 "filter/f-inst.c"
whati->f2 = f2;
#line 1274
const struct f_inst *child2 = f2;
#line 1274
do {
#line 1274
  what->size += child2->size;
#line 1274

#line 1274
  if (child2->fi_code != FI_CONSTANT)
#line 1274
    constargs = 0;
#line 1274

#line 1274
} while (child2 = child2->next);
#line 1274 "filter/f-inst.c"
if (f2->type && (f2->type != (T_IP)) && !f_const_promotion(f2, (T_IP)))
#line 1274
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1274
	   f_instruction_name(what->fi_code), f_type_name(T_IP), f_type_name(f2->type));
;
#line 1278 "filter/f-inst.c"
    /* IP->Quad implicit conversion, must be before FI_CLIST_ADD_QUAD */
    cf_warn("Method add(clist, ip) is deprecated, please use add(clist, quad)");

    #line 1283 "filter/f-inst.c"
what->type = T_CLIST;

#line 1286 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1286
    if (!constargs)
#line 1286
      return what;
#line 1286

#line 1286
    /* Try to pre-calculate the result */
#line 1286
    #line 1272 "filter/f-inst.c"
 {
    
#line 1273 "filter/f-inst.c"
 #line 1273 "filter/f-inst.c"
 ;
#line 1274 "filter/f-inst.c"
    
#line 1274 "filter/f-inst.c"
 #line 1274 "filter/f-inst.c"
 ;
#line 1275 "filter/f-inst.c"
    #line 1275 "filter/f-inst.c"
;

    ;
#line 1282 "filter/f-inst.c"
    if (!val_is_ip4(&v2)) runtime("Mismatched IP type");
     
#line 1283 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_add(fpool, v1.val.ad, ipa_to_u32(v2.val.ip))  } );
  }

  
  #undef whati
#line 1286 "filter/f-inst.c"
  }
#line 1286

#line 1286

#line 1293 "filter/f-inst.c"
 /* Constructor for FI_CLIST_ADD_QUAD */
#line 1293
struct f_inst *
#line 1287 "filter/f-inst.c"
NONNULL(2)
#line 1288 "filter/f-inst.c"
NONNULL(3)
#line 1293 "filter/f-inst.c"
f_new_inst_FI_CLIST_ADD_QUAD(enum f_instruction_code fi_code
#line 1287 "filter/f-inst.c"
  , struct f_inst * f1
#line 1288 "filter/f-inst.c"
  , struct f_inst * f2
#line 1293 "filter/f-inst.c"
)
#line 1293
  {
#line 1293
    /* Allocate the structure */
#line 1293
    struct f_inst *what = fi_new(fi_code);
#line 1293
    uint constargs = 1;
#line 1293

#line 1293
    /* Initialize all the members */
#line 1293
  #define whati (&(what->i_FI_CLIST_ADD_QUAD))
#line 1293
  #line 1287 "filter/f-inst.c"
whati->f1 = f1;
#line 1287
const struct f_inst *child1 = f1;
#line 1287
do {
#line 1287
  what->size += child1->size;
#line 1287

#line 1287
  if (child1->fi_code != FI_CONSTANT)
#line 1287
    constargs = 0;
#line 1287

#line 1287
} while (child1 = child1->next);
#line 1287

#line 1287 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1287
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1287
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1288 "filter/f-inst.c"
whati->f2 = f2;
#line 1288
const struct f_inst *child2 = f2;
#line 1288
do {
#line 1288
  what->size += child2->size;
#line 1288

#line 1288
  if (child2->fi_code != FI_CONSTANT)
#line 1288
    constargs = 0;
#line 1288

#line 1288
} while (child2 = child2->next);
#line 1288 "filter/f-inst.c"
if (f2->type && (f2->type != (T_QUAD)) && !f_const_promotion(f2, (T_QUAD)))
#line 1288
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1288
	   f_instruction_name(what->fi_code), f_type_name(T_QUAD), f_type_name(f2->type));
#line 1290 "filter/f-inst.c"
what->type = T_CLIST;

#line 1293 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1293
    if (!constargs)
#line 1293
      return what;
#line 1293

#line 1293
    /* Try to pre-calculate the result */
#line 1293
    #line 1286 "filter/f-inst.c"
 {
    
#line 1287 "filter/f-inst.c"
 #line 1287 "filter/f-inst.c"
 ;
#line 1288 "filter/f-inst.c"
    
#line 1288 "filter/f-inst.c"
 #line 1288 "filter/f-inst.c"
 ;
#line 1289 "filter/f-inst.c"
    #line 1289 "filter/f-inst.c"
;
     
#line 1290 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_add(fpool, v1.val.ad, v2.val.i)  } );
  }

  
  #undef whati
#line 1293 "filter/f-inst.c"
  }
#line 1293

#line 1293

#line 1300 "filter/f-inst.c"
 /* Constructor for FI_CLIST_ADD_CLIST */
#line 1300
struct f_inst *
#line 1294 "filter/f-inst.c"
NONNULL(2)
#line 1295 "filter/f-inst.c"
NONNULL(3)
#line 1300 "filter/f-inst.c"
f_new_inst_FI_CLIST_ADD_CLIST(enum f_instruction_code fi_code
#line 1294 "filter/f-inst.c"
  , struct f_inst * f1
#line 1295 "filter/f-inst.c"
  , struct f_inst * f2
#line 1300 "filter/f-inst.c"
)
#line 1300
  {
#line 1300
    /* Allocate the structure */
#line 1300
    struct f_inst *what = fi_new(fi_code);
#line 1300
    uint constargs = 1;
#line 1300

#line 1300
    /* Initialize all the members */
#line 1300
  #define whati (&(what->i_FI_CLIST_ADD_CLIST))
#line 1300
  #line 1294 "filter/f-inst.c"
whati->f1 = f1;
#line 1294
const struct f_inst *child1 = f1;
#line 1294
do {
#line 1294
  what->size += child1->size;
#line 1294

#line 1294
  if (child1->fi_code != FI_CONSTANT)
#line 1294
    constargs = 0;
#line 1294

#line 1294
} while (child1 = child1->next);
#line 1294

#line 1294 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1294
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1294
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1295 "filter/f-inst.c"
whati->f2 = f2;
#line 1295
const struct f_inst *child2 = f2;
#line 1295
do {
#line 1295
  what->size += child2->size;
#line 1295

#line 1295
  if (child2->fi_code != FI_CONSTANT)
#line 1295
    constargs = 0;
#line 1295

#line 1295
} while (child2 = child2->next);
#line 1295 "filter/f-inst.c"
if (f2->type && (f2->type != (T_CLIST)) && !f_const_promotion(f2, (T_CLIST)))
#line 1295
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1295
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f2->type));
#line 1297 "filter/f-inst.c"
what->type = T_CLIST;

#line 1300 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1300
    if (!constargs)
#line 1300
      return what;
#line 1300

#line 1300
    /* Try to pre-calculate the result */
#line 1300
    #line 1293 "filter/f-inst.c"
 {
    
#line 1294 "filter/f-inst.c"
 #line 1294 "filter/f-inst.c"
 ;
#line 1295 "filter/f-inst.c"
    
#line 1295 "filter/f-inst.c"
 #line 1295 "filter/f-inst.c"
 ;
#line 1296 "filter/f-inst.c"
    #line 1296 "filter/f-inst.c"
;
     
#line 1297 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_union(fpool, v1.val.ad, v2.val.ad)  } );
  }

  
  #undef whati
#line 1300 "filter/f-inst.c"
  }
#line 1300

#line 1300

#line 1307 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_ADD_EC */
#line 1307
struct f_inst *
#line 1301 "filter/f-inst.c"
NONNULL(2)
#line 1302 "filter/f-inst.c"
NONNULL(3)
#line 1307 "filter/f-inst.c"
f_new_inst_FI_ECLIST_ADD_EC(enum f_instruction_code fi_code
#line 1301 "filter/f-inst.c"
  , struct f_inst * f1
#line 1302 "filter/f-inst.c"
  , struct f_inst * f2
#line 1307 "filter/f-inst.c"
)
#line 1307
  {
#line 1307
    /* Allocate the structure */
#line 1307
    struct f_inst *what = fi_new(fi_code);
#line 1307
    uint constargs = 1;
#line 1307

#line 1307
    /* Initialize all the members */
#line 1307
  #define whati (&(what->i_FI_ECLIST_ADD_EC))
#line 1307
  #line 1301 "filter/f-inst.c"
whati->f1 = f1;
#line 1301
const struct f_inst *child1 = f1;
#line 1301
do {
#line 1301
  what->size += child1->size;
#line 1301

#line 1301
  if (child1->fi_code != FI_CONSTANT)
#line 1301
    constargs = 0;
#line 1301

#line 1301
} while (child1 = child1->next);
#line 1301

#line 1301 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1301
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1301
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1302 "filter/f-inst.c"
whati->f2 = f2;
#line 1302
const struct f_inst *child2 = f2;
#line 1302
do {
#line 1302
  what->size += child2->size;
#line 1302

#line 1302
  if (child2->fi_code != FI_CONSTANT)
#line 1302
    constargs = 0;
#line 1302

#line 1302
} while (child2 = child2->next);
#line 1302 "filter/f-inst.c"
if (f2->type && (f2->type != (T_EC)) && !f_const_promotion(f2, (T_EC)))
#line 1302
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1302
	   f_instruction_name(what->fi_code), f_type_name(T_EC), f_type_name(f2->type));
#line 1304 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1307 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1307
    if (!constargs)
#line 1307
      return what;
#line 1307

#line 1307
    /* Try to pre-calculate the result */
#line 1307
    #line 1300 "filter/f-inst.c"
 {
    
#line 1301 "filter/f-inst.c"
 #line 1301 "filter/f-inst.c"
 ;
#line 1302 "filter/f-inst.c"
    
#line 1302 "filter/f-inst.c"
 #line 1302 "filter/f-inst.c"
 ;
#line 1303 "filter/f-inst.c"
    #line 1303 "filter/f-inst.c"
;
     
#line 1304 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  ec_set_add(fpool, v1.val.ad, v2.val.ec)  } );
  }

  
  #undef whati
#line 1307 "filter/f-inst.c"
  }
#line 1307

#line 1307

#line 1314 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_ADD_ECLIST */
#line 1314
struct f_inst *
#line 1308 "filter/f-inst.c"
NONNULL(2)
#line 1309 "filter/f-inst.c"
NONNULL(3)
#line 1314 "filter/f-inst.c"
f_new_inst_FI_ECLIST_ADD_ECLIST(enum f_instruction_code fi_code
#line 1308 "filter/f-inst.c"
  , struct f_inst * f1
#line 1309 "filter/f-inst.c"
  , struct f_inst * f2
#line 1314 "filter/f-inst.c"
)
#line 1314
  {
#line 1314
    /* Allocate the structure */
#line 1314
    struct f_inst *what = fi_new(fi_code);
#line 1314
    uint constargs = 1;
#line 1314

#line 1314
    /* Initialize all the members */
#line 1314
  #define whati (&(what->i_FI_ECLIST_ADD_ECLIST))
#line 1314
  #line 1308 "filter/f-inst.c"
whati->f1 = f1;
#line 1308
const struct f_inst *child1 = f1;
#line 1308
do {
#line 1308
  what->size += child1->size;
#line 1308

#line 1308
  if (child1->fi_code != FI_CONSTANT)
#line 1308
    constargs = 0;
#line 1308

#line 1308
} while (child1 = child1->next);
#line 1308

#line 1308 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1308
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1308
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1309 "filter/f-inst.c"
whati->f2 = f2;
#line 1309
const struct f_inst *child2 = f2;
#line 1309
do {
#line 1309
  what->size += child2->size;
#line 1309

#line 1309
  if (child2->fi_code != FI_CONSTANT)
#line 1309
    constargs = 0;
#line 1309

#line 1309
} while (child2 = child2->next);
#line 1309 "filter/f-inst.c"
if (f2->type && (f2->type != (T_ECLIST)) && !f_const_promotion(f2, (T_ECLIST)))
#line 1309
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1309
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f2->type));
#line 1311 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1314 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1314
    if (!constargs)
#line 1314
      return what;
#line 1314

#line 1314
    /* Try to pre-calculate the result */
#line 1314
    #line 1307 "filter/f-inst.c"
 {
    
#line 1308 "filter/f-inst.c"
 #line 1308 "filter/f-inst.c"
 ;
#line 1309 "filter/f-inst.c"
    
#line 1309 "filter/f-inst.c"
 #line 1309 "filter/f-inst.c"
 ;
#line 1310 "filter/f-inst.c"
    #line 1310 "filter/f-inst.c"
;
     
#line 1311 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  ec_set_union(fpool, v1.val.ad, v2.val.ad)  } );
  }

  
  #undef whati
#line 1314 "filter/f-inst.c"
  }
#line 1314

#line 1314

#line 1321 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_ADD_LC */
#line 1321
struct f_inst *
#line 1315 "filter/f-inst.c"
NONNULL(2)
#line 1316 "filter/f-inst.c"
NONNULL(3)
#line 1321 "filter/f-inst.c"
f_new_inst_FI_LCLIST_ADD_LC(enum f_instruction_code fi_code
#line 1315 "filter/f-inst.c"
  , struct f_inst * f1
#line 1316 "filter/f-inst.c"
  , struct f_inst * f2
#line 1321 "filter/f-inst.c"
)
#line 1321
  {
#line 1321
    /* Allocate the structure */
#line 1321
    struct f_inst *what = fi_new(fi_code);
#line 1321
    uint constargs = 1;
#line 1321

#line 1321
    /* Initialize all the members */
#line 1321
  #define whati (&(what->i_FI_LCLIST_ADD_LC))
#line 1321
  #line 1315 "filter/f-inst.c"
whati->f1 = f1;
#line 1315
const struct f_inst *child1 = f1;
#line 1315
do {
#line 1315
  what->size += child1->size;
#line 1315

#line 1315
  if (child1->fi_code != FI_CONSTANT)
#line 1315
    constargs = 0;
#line 1315

#line 1315
} while (child1 = child1->next);
#line 1315

#line 1315 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1315
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1315
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1316 "filter/f-inst.c"
whati->f2 = f2;
#line 1316
const struct f_inst *child2 = f2;
#line 1316
do {
#line 1316
  what->size += child2->size;
#line 1316

#line 1316
  if (child2->fi_code != FI_CONSTANT)
#line 1316
    constargs = 0;
#line 1316

#line 1316
} while (child2 = child2->next);
#line 1316 "filter/f-inst.c"
if (f2->type && (f2->type != (T_LC)) && !f_const_promotion(f2, (T_LC)))
#line 1316
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1316
	   f_instruction_name(what->fi_code), f_type_name(T_LC), f_type_name(f2->type));
#line 1318 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1321 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1321
    if (!constargs)
#line 1321
      return what;
#line 1321

#line 1321
    /* Try to pre-calculate the result */
#line 1321
    #line 1314 "filter/f-inst.c"
 {
    
#line 1315 "filter/f-inst.c"
 #line 1315 "filter/f-inst.c"
 ;
#line 1316 "filter/f-inst.c"
    
#line 1316 "filter/f-inst.c"
 #line 1316 "filter/f-inst.c"
 ;
#line 1317 "filter/f-inst.c"
    #line 1317 "filter/f-inst.c"
;
     
#line 1318 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lc_set_add(fpool, v1.val.ad, v2.val.lc)  } );
  }

  
  #undef whati
#line 1321 "filter/f-inst.c"
  }
#line 1321

#line 1321

#line 1328 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_ADD_LCLIST */
#line 1328
struct f_inst *
#line 1322 "filter/f-inst.c"
NONNULL(2)
#line 1323 "filter/f-inst.c"
NONNULL(3)
#line 1328 "filter/f-inst.c"
f_new_inst_FI_LCLIST_ADD_LCLIST(enum f_instruction_code fi_code
#line 1322 "filter/f-inst.c"
  , struct f_inst * f1
#line 1323 "filter/f-inst.c"
  , struct f_inst * f2
#line 1328 "filter/f-inst.c"
)
#line 1328
  {
#line 1328
    /* Allocate the structure */
#line 1328
    struct f_inst *what = fi_new(fi_code);
#line 1328
    uint constargs = 1;
#line 1328

#line 1328
    /* Initialize all the members */
#line 1328
  #define whati (&(what->i_FI_LCLIST_ADD_LCLIST))
#line 1328
  #line 1322 "filter/f-inst.c"
whati->f1 = f1;
#line 1322
const struct f_inst *child1 = f1;
#line 1322
do {
#line 1322
  what->size += child1->size;
#line 1322

#line 1322
  if (child1->fi_code != FI_CONSTANT)
#line 1322
    constargs = 0;
#line 1322

#line 1322
} while (child1 = child1->next);
#line 1322

#line 1322 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1322
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1322
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1323 "filter/f-inst.c"
whati->f2 = f2;
#line 1323
const struct f_inst *child2 = f2;
#line 1323
do {
#line 1323
  what->size += child2->size;
#line 1323

#line 1323
  if (child2->fi_code != FI_CONSTANT)
#line 1323
    constargs = 0;
#line 1323

#line 1323
} while (child2 = child2->next);
#line 1323 "filter/f-inst.c"
if (f2->type && (f2->type != (T_LCLIST)) && !f_const_promotion(f2, (T_LCLIST)))
#line 1323
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1323
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f2->type));
#line 1325 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1328 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1328
    if (!constargs)
#line 1328
      return what;
#line 1328

#line 1328
    /* Try to pre-calculate the result */
#line 1328
    #line 1321 "filter/f-inst.c"
 {
    
#line 1322 "filter/f-inst.c"
 #line 1322 "filter/f-inst.c"
 ;
#line 1323 "filter/f-inst.c"
    
#line 1323 "filter/f-inst.c"
 #line 1323 "filter/f-inst.c"
 ;
#line 1324 "filter/f-inst.c"
    #line 1324 "filter/f-inst.c"
;
     
#line 1325 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lc_set_union(fpool, v1.val.ad, v2.val.ad)  } );
  }

  
  #undef whati
#line 1328 "filter/f-inst.c"
  }
#line 1328

#line 1328

#line 1335 "filter/f-inst.c"
 /* Constructor for FI_PATH_DELETE_INT */
#line 1335
struct f_inst *
#line 1329 "filter/f-inst.c"
NONNULL(2)
#line 1330 "filter/f-inst.c"
NONNULL(3)
#line 1335 "filter/f-inst.c"
f_new_inst_FI_PATH_DELETE_INT(enum f_instruction_code fi_code
#line 1329 "filter/f-inst.c"
  , struct f_inst * f1
#line 1330 "filter/f-inst.c"
  , struct f_inst * f2
#line 1335 "filter/f-inst.c"
)
#line 1335
  {
#line 1335
    /* Allocate the structure */
#line 1335
    struct f_inst *what = fi_new(fi_code);
#line 1335
    uint constargs = 1;
#line 1335

#line 1335
    /* Initialize all the members */
#line 1335
  #define whati (&(what->i_FI_PATH_DELETE_INT))
#line 1335
  #line 1329 "filter/f-inst.c"
whati->f1 = f1;
#line 1329
const struct f_inst *child1 = f1;
#line 1329
do {
#line 1329
  what->size += child1->size;
#line 1329

#line 1329
  if (child1->fi_code != FI_CONSTANT)
#line 1329
    constargs = 0;
#line 1329

#line 1329
} while (child1 = child1->next);
#line 1329

#line 1329 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1329
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1329
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1330 "filter/f-inst.c"
whati->f2 = f2;
#line 1330
const struct f_inst *child2 = f2;
#line 1330
do {
#line 1330
  what->size += child2->size;
#line 1330

#line 1330
  if (child2->fi_code != FI_CONSTANT)
#line 1330
    constargs = 0;
#line 1330

#line 1330
} while (child2 = child2->next);
#line 1330 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 1330
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1330
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 1332 "filter/f-inst.c"
what->type = T_PATH;

#line 1335 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1335
    if (!constargs)
#line 1335
      return what;
#line 1335

#line 1335
    /* Try to pre-calculate the result */
#line 1335
    #line 1328 "filter/f-inst.c"
 {
    
#line 1329 "filter/f-inst.c"
 #line 1329 "filter/f-inst.c"
 ;
#line 1330 "filter/f-inst.c"
    
#line 1330 "filter/f-inst.c"
 #line 1330 "filter/f-inst.c"
 ;
#line 1331 "filter/f-inst.c"
    #line 1331 "filter/f-inst.c"
;
     
#line 1332 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH, .val.ad =  as_path_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1335 "filter/f-inst.c"
  }
#line 1335

#line 1335

#line 1347 "filter/f-inst.c"
 /* Constructor for FI_PATH_DELETE_SET */
#line 1347
struct f_inst *
#line 1336 "filter/f-inst.c"
NONNULL(2)
#line 1337 "filter/f-inst.c"
NONNULL(3)
#line 1347 "filter/f-inst.c"
f_new_inst_FI_PATH_DELETE_SET(enum f_instruction_code fi_code
#line 1336 "filter/f-inst.c"
  , struct f_inst * f1
#line 1337 "filter/f-inst.c"
  , struct f_inst * f2
#line 1347 "filter/f-inst.c"
)
#line 1347
  {
#line 1347
    /* Allocate the structure */
#line 1347
    struct f_inst *what = fi_new(fi_code);
#line 1347
    uint constargs = 1;
#line 1347

#line 1347
    /* Initialize all the members */
#line 1347
  #define whati (&(what->i_FI_PATH_DELETE_SET))
#line 1347
  #line 1336 "filter/f-inst.c"
whati->f1 = f1;
#line 1336
const struct f_inst *child1 = f1;
#line 1336
do {
#line 1336
  what->size += child1->size;
#line 1336

#line 1336
  if (child1->fi_code != FI_CONSTANT)
#line 1336
    constargs = 0;
#line 1336

#line 1336
} while (child1 = child1->next);
#line 1336

#line 1336 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1336
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1336
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1337 "filter/f-inst.c"
whati->f2 = f2;
#line 1337
const struct f_inst *child2 = f2;
#line 1337
do {
#line 1337
  what->size += child2->size;
#line 1337

#line 1337
  if (child2->fi_code != FI_CONSTANT)
#line 1337
    constargs = 0;
#line 1337

#line 1337
} while (child2 = child2->next);
#line 1337 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1337
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1337
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1343 "filter/f-inst.c"
what->type = T_PATH;

#line 1347 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1347
    if (!constargs)
#line 1347
      return what;
#line 1347

#line 1347
    /* Try to pre-calculate the result */
#line 1347
    #line 1335 "filter/f-inst.c"
 {
    
#line 1336 "filter/f-inst.c"
 #line 1336 "filter/f-inst.c"
 ;
#line 1337 "filter/f-inst.c"
    
#line 1337 "filter/f-inst.c"
 #line 1337 "filter/f-inst.c"
 ;
#line 1338 "filter/f-inst.c"
    #line 1338 "filter/f-inst.c"
;

    if (!path_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1343 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH, .val.ad =  as_path_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  /* Community list delete */
  
  #undef whati
#line 1347 "filter/f-inst.c"
  }
#line 1347

#line 1347

#line 1354 "filter/f-inst.c"
 /* Constructor for FI_CLIST_DELETE_PAIR */
#line 1354
struct f_inst *
#line 1348 "filter/f-inst.c"
NONNULL(2)
#line 1349 "filter/f-inst.c"
NONNULL(3)
#line 1354 "filter/f-inst.c"
f_new_inst_FI_CLIST_DELETE_PAIR(enum f_instruction_code fi_code
#line 1348 "filter/f-inst.c"
  , struct f_inst * f1
#line 1349 "filter/f-inst.c"
  , struct f_inst * f2
#line 1354 "filter/f-inst.c"
)
#line 1354
  {
#line 1354
    /* Allocate the structure */
#line 1354
    struct f_inst *what = fi_new(fi_code);
#line 1354
    uint constargs = 1;
#line 1354

#line 1354
    /* Initialize all the members */
#line 1354
  #define whati (&(what->i_FI_CLIST_DELETE_PAIR))
#line 1354
  #line 1348 "filter/f-inst.c"
whati->f1 = f1;
#line 1348
const struct f_inst *child1 = f1;
#line 1348
do {
#line 1348
  what->size += child1->size;
#line 1348

#line 1348
  if (child1->fi_code != FI_CONSTANT)
#line 1348
    constargs = 0;
#line 1348

#line 1348
} while (child1 = child1->next);
#line 1348

#line 1348 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1348
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1348
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1349 "filter/f-inst.c"
whati->f2 = f2;
#line 1349
const struct f_inst *child2 = f2;
#line 1349
do {
#line 1349
  what->size += child2->size;
#line 1349

#line 1349
  if (child2->fi_code != FI_CONSTANT)
#line 1349
    constargs = 0;
#line 1349

#line 1349
} while (child2 = child2->next);
#line 1349 "filter/f-inst.c"
if (f2->type && (f2->type != (T_PAIR)) && !f_const_promotion(f2, (T_PAIR)))
#line 1349
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1349
	   f_instruction_name(what->fi_code), f_type_name(T_PAIR), f_type_name(f2->type));
#line 1351 "filter/f-inst.c"
what->type = T_CLIST;

#line 1354 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1354
    if (!constargs)
#line 1354
      return what;
#line 1354

#line 1354
    /* Try to pre-calculate the result */
#line 1354
    #line 1347 "filter/f-inst.c"
 {
    
#line 1348 "filter/f-inst.c"
 #line 1348 "filter/f-inst.c"
 ;
#line 1349 "filter/f-inst.c"
    
#line 1349 "filter/f-inst.c"
 #line 1349 "filter/f-inst.c"
 ;
#line 1350 "filter/f-inst.c"
    #line 1350 "filter/f-inst.c"
;
     
#line 1351 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_del(fpool, v1.val.ad, v2.val.i)  } );
  }

  
  #undef whati
#line 1354 "filter/f-inst.c"
  }
#line 1354

#line 1354

#line 1368 "filter/f-inst.c"
 /* Constructor for FI_CLIST_DELETE_IP */
#line 1368
struct f_inst *
#line 1355 "filter/f-inst.c"
NONNULL(2)
#line 1356 "filter/f-inst.c"
NONNULL(3)
#line 1368 "filter/f-inst.c"
f_new_inst_FI_CLIST_DELETE_IP(enum f_instruction_code fi_code
#line 1355 "filter/f-inst.c"
  , struct f_inst * f1
#line 1356 "filter/f-inst.c"
  , struct f_inst * f2
#line 1368 "filter/f-inst.c"
)
#line 1368
  {
#line 1368
    /* Allocate the structure */
#line 1368
    struct f_inst *what = fi_new(fi_code);
#line 1368
    uint constargs = 1;
#line 1368

#line 1368
    /* Initialize all the members */
#line 1368
  #define whati (&(what->i_FI_CLIST_DELETE_IP))
#line 1368
  #line 1355 "filter/f-inst.c"
whati->f1 = f1;
#line 1355
const struct f_inst *child1 = f1;
#line 1355
do {
#line 1355
  what->size += child1->size;
#line 1355

#line 1355
  if (child1->fi_code != FI_CONSTANT)
#line 1355
    constargs = 0;
#line 1355

#line 1355
} while (child1 = child1->next);
#line 1355

#line 1355 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1355
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1355
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1356 "filter/f-inst.c"
whati->f2 = f2;
#line 1356
const struct f_inst *child2 = f2;
#line 1356
do {
#line 1356
  what->size += child2->size;
#line 1356

#line 1356
  if (child2->fi_code != FI_CONSTANT)
#line 1356
    constargs = 0;
#line 1356

#line 1356
} while (child2 = child2->next);
#line 1356 "filter/f-inst.c"
if (f2->type && (f2->type != (T_IP)) && !f_const_promotion(f2, (T_IP)))
#line 1356
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1356
	   f_instruction_name(what->fi_code), f_type_name(T_IP), f_type_name(f2->type));
;
#line 1360 "filter/f-inst.c"
    /* IP->Quad implicit conversion, must be before FI_CLIST_DELETE_QUAD */
    cf_warn("Method delete(clist, ip) is deprecated, please use delete(clist, quad)");

    #line 1365 "filter/f-inst.c"
what->type = T_CLIST;

#line 1368 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1368
    if (!constargs)
#line 1368
      return what;
#line 1368

#line 1368
    /* Try to pre-calculate the result */
#line 1368
    #line 1354 "filter/f-inst.c"
 {
    
#line 1355 "filter/f-inst.c"
 #line 1355 "filter/f-inst.c"
 ;
#line 1356 "filter/f-inst.c"
    
#line 1356 "filter/f-inst.c"
 #line 1356 "filter/f-inst.c"
 ;
#line 1357 "filter/f-inst.c"
    #line 1357 "filter/f-inst.c"
;

    ;
#line 1364 "filter/f-inst.c"
    if (!val_is_ip4(&v2)) runtime("Mismatched IP type");
     
#line 1365 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_del(fpool, v1.val.ad, ipa_to_u32(v2.val.ip))  } );
  }

  
  #undef whati
#line 1368 "filter/f-inst.c"
  }
#line 1368

#line 1368

#line 1375 "filter/f-inst.c"
 /* Constructor for FI_CLIST_DELETE_QUAD */
#line 1375
struct f_inst *
#line 1369 "filter/f-inst.c"
NONNULL(2)
#line 1370 "filter/f-inst.c"
NONNULL(3)
#line 1375 "filter/f-inst.c"
f_new_inst_FI_CLIST_DELETE_QUAD(enum f_instruction_code fi_code
#line 1369 "filter/f-inst.c"
  , struct f_inst * f1
#line 1370 "filter/f-inst.c"
  , struct f_inst * f2
#line 1375 "filter/f-inst.c"
)
#line 1375
  {
#line 1375
    /* Allocate the structure */
#line 1375
    struct f_inst *what = fi_new(fi_code);
#line 1375
    uint constargs = 1;
#line 1375

#line 1375
    /* Initialize all the members */
#line 1375
  #define whati (&(what->i_FI_CLIST_DELETE_QUAD))
#line 1375
  #line 1369 "filter/f-inst.c"
whati->f1 = f1;
#line 1369
const struct f_inst *child1 = f1;
#line 1369
do {
#line 1369
  what->size += child1->size;
#line 1369

#line 1369
  if (child1->fi_code != FI_CONSTANT)
#line 1369
    constargs = 0;
#line 1369

#line 1369
} while (child1 = child1->next);
#line 1369

#line 1369 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1369
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1369
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1370 "filter/f-inst.c"
whati->f2 = f2;
#line 1370
const struct f_inst *child2 = f2;
#line 1370
do {
#line 1370
  what->size += child2->size;
#line 1370

#line 1370
  if (child2->fi_code != FI_CONSTANT)
#line 1370
    constargs = 0;
#line 1370

#line 1370
} while (child2 = child2->next);
#line 1370 "filter/f-inst.c"
if (f2->type && (f2->type != (T_QUAD)) && !f_const_promotion(f2, (T_QUAD)))
#line 1370
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1370
	   f_instruction_name(what->fi_code), f_type_name(T_QUAD), f_type_name(f2->type));
#line 1372 "filter/f-inst.c"
what->type = T_CLIST;

#line 1375 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1375
    if (!constargs)
#line 1375
      return what;
#line 1375

#line 1375
    /* Try to pre-calculate the result */
#line 1375
    #line 1368 "filter/f-inst.c"
 {
    
#line 1369 "filter/f-inst.c"
 #line 1369 "filter/f-inst.c"
 ;
#line 1370 "filter/f-inst.c"
    
#line 1370 "filter/f-inst.c"
 #line 1370 "filter/f-inst.c"
 ;
#line 1371 "filter/f-inst.c"
    #line 1371 "filter/f-inst.c"
;
     
#line 1372 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  int_set_del(fpool, v1.val.ad, v2.val.i)  } );
  }

  
  #undef whati
#line 1375 "filter/f-inst.c"
  }
#line 1375

#line 1375

#line 1382 "filter/f-inst.c"
 /* Constructor for FI_CLIST_DELETE_CLIST */
#line 1382
struct f_inst *
#line 1376 "filter/f-inst.c"
NONNULL(2)
#line 1377 "filter/f-inst.c"
NONNULL(3)
#line 1382 "filter/f-inst.c"
f_new_inst_FI_CLIST_DELETE_CLIST(enum f_instruction_code fi_code
#line 1376 "filter/f-inst.c"
  , struct f_inst * f1
#line 1377 "filter/f-inst.c"
  , struct f_inst * f2
#line 1382 "filter/f-inst.c"
)
#line 1382
  {
#line 1382
    /* Allocate the structure */
#line 1382
    struct f_inst *what = fi_new(fi_code);
#line 1382
    uint constargs = 1;
#line 1382

#line 1382
    /* Initialize all the members */
#line 1382
  #define whati (&(what->i_FI_CLIST_DELETE_CLIST))
#line 1382
  #line 1376 "filter/f-inst.c"
whati->f1 = f1;
#line 1376
const struct f_inst *child1 = f1;
#line 1376
do {
#line 1376
  what->size += child1->size;
#line 1376

#line 1376
  if (child1->fi_code != FI_CONSTANT)
#line 1376
    constargs = 0;
#line 1376

#line 1376
} while (child1 = child1->next);
#line 1376

#line 1376 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1376
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1376
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1377 "filter/f-inst.c"
whati->f2 = f2;
#line 1377
const struct f_inst *child2 = f2;
#line 1377
do {
#line 1377
  what->size += child2->size;
#line 1377

#line 1377
  if (child2->fi_code != FI_CONSTANT)
#line 1377
    constargs = 0;
#line 1377

#line 1377
} while (child2 = child2->next);
#line 1377 "filter/f-inst.c"
if (f2->type && (f2->type != (T_CLIST)) && !f_const_promotion(f2, (T_CLIST)))
#line 1377
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1377
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f2->type));
#line 1379 "filter/f-inst.c"
what->type = T_CLIST;

#line 1382 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1382
    if (!constargs)
#line 1382
      return what;
#line 1382

#line 1382
    /* Try to pre-calculate the result */
#line 1382
    #line 1375 "filter/f-inst.c"
 {
    
#line 1376 "filter/f-inst.c"
 #line 1376 "filter/f-inst.c"
 ;
#line 1377 "filter/f-inst.c"
    
#line 1377 "filter/f-inst.c"
 #line 1377 "filter/f-inst.c"
 ;
#line 1378 "filter/f-inst.c"
    #line 1378 "filter/f-inst.c"
;
     
#line 1379 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  clist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1382 "filter/f-inst.c"
  }
#line 1382

#line 1382

#line 1393 "filter/f-inst.c"
 /* Constructor for FI_CLIST_DELETE_SET */
#line 1393
struct f_inst *
#line 1383 "filter/f-inst.c"
NONNULL(2)
#line 1384 "filter/f-inst.c"
NONNULL(3)
#line 1393 "filter/f-inst.c"
f_new_inst_FI_CLIST_DELETE_SET(enum f_instruction_code fi_code
#line 1383 "filter/f-inst.c"
  , struct f_inst * f1
#line 1384 "filter/f-inst.c"
  , struct f_inst * f2
#line 1393 "filter/f-inst.c"
)
#line 1393
  {
#line 1393
    /* Allocate the structure */
#line 1393
    struct f_inst *what = fi_new(fi_code);
#line 1393
    uint constargs = 1;
#line 1393

#line 1393
    /* Initialize all the members */
#line 1393
  #define whati (&(what->i_FI_CLIST_DELETE_SET))
#line 1393
  #line 1383 "filter/f-inst.c"
whati->f1 = f1;
#line 1383
const struct f_inst *child1 = f1;
#line 1383
do {
#line 1383
  what->size += child1->size;
#line 1383

#line 1383
  if (child1->fi_code != FI_CONSTANT)
#line 1383
    constargs = 0;
#line 1383

#line 1383
} while (child1 = child1->next);
#line 1383

#line 1383 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1383
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1383
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1384 "filter/f-inst.c"
whati->f2 = f2;
#line 1384
const struct f_inst *child2 = f2;
#line 1384
do {
#line 1384
  what->size += child2->size;
#line 1384

#line 1384
  if (child2->fi_code != FI_CONSTANT)
#line 1384
    constargs = 0;
#line 1384

#line 1384
} while (child2 = child2->next);
#line 1384 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1384
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1384
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1390 "filter/f-inst.c"
what->type = T_CLIST;

#line 1393 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1393
    if (!constargs)
#line 1393
      return what;
#line 1393

#line 1393
    /* Try to pre-calculate the result */
#line 1393
    #line 1382 "filter/f-inst.c"
 {
    
#line 1383 "filter/f-inst.c"
 #line 1383 "filter/f-inst.c"
 ;
#line 1384 "filter/f-inst.c"
    
#line 1384 "filter/f-inst.c"
 #line 1384 "filter/f-inst.c"
 ;
#line 1385 "filter/f-inst.c"
    #line 1385 "filter/f-inst.c"
;

    if (!clist_set_type(v2.val.t, &(struct f_val){}))
      runtime("Mismatched set type");

     
#line 1390 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  clist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1393 "filter/f-inst.c"
  }
#line 1393

#line 1393

#line 1400 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_DELETE_EC */
#line 1400
struct f_inst *
#line 1394 "filter/f-inst.c"
NONNULL(2)
#line 1395 "filter/f-inst.c"
NONNULL(3)
#line 1400 "filter/f-inst.c"
f_new_inst_FI_ECLIST_DELETE_EC(enum f_instruction_code fi_code
#line 1394 "filter/f-inst.c"
  , struct f_inst * f1
#line 1395 "filter/f-inst.c"
  , struct f_inst * f2
#line 1400 "filter/f-inst.c"
)
#line 1400
  {
#line 1400
    /* Allocate the structure */
#line 1400
    struct f_inst *what = fi_new(fi_code);
#line 1400
    uint constargs = 1;
#line 1400

#line 1400
    /* Initialize all the members */
#line 1400
  #define whati (&(what->i_FI_ECLIST_DELETE_EC))
#line 1400
  #line 1394 "filter/f-inst.c"
whati->f1 = f1;
#line 1394
const struct f_inst *child1 = f1;
#line 1394
do {
#line 1394
  what->size += child1->size;
#line 1394

#line 1394
  if (child1->fi_code != FI_CONSTANT)
#line 1394
    constargs = 0;
#line 1394

#line 1394
} while (child1 = child1->next);
#line 1394

#line 1394 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1394
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1394
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1395 "filter/f-inst.c"
whati->f2 = f2;
#line 1395
const struct f_inst *child2 = f2;
#line 1395
do {
#line 1395
  what->size += child2->size;
#line 1395

#line 1395
  if (child2->fi_code != FI_CONSTANT)
#line 1395
    constargs = 0;
#line 1395

#line 1395
} while (child2 = child2->next);
#line 1395 "filter/f-inst.c"
if (f2->type && (f2->type != (T_EC)) && !f_const_promotion(f2, (T_EC)))
#line 1395
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1395
	   f_instruction_name(what->fi_code), f_type_name(T_EC), f_type_name(f2->type));
#line 1397 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1400 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1400
    if (!constargs)
#line 1400
      return what;
#line 1400

#line 1400
    /* Try to pre-calculate the result */
#line 1400
    #line 1393 "filter/f-inst.c"
 {
    
#line 1394 "filter/f-inst.c"
 #line 1394 "filter/f-inst.c"
 ;
#line 1395 "filter/f-inst.c"
    
#line 1395 "filter/f-inst.c"
 #line 1395 "filter/f-inst.c"
 ;
#line 1396 "filter/f-inst.c"
    #line 1396 "filter/f-inst.c"
;
     
#line 1397 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  ec_set_del(fpool, v1.val.ad, v2.val.ec)  } );
  }

  
  #undef whati
#line 1400 "filter/f-inst.c"
  }
#line 1400

#line 1400

#line 1407 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_DELETE_ECLIST */
#line 1407
struct f_inst *
#line 1401 "filter/f-inst.c"
NONNULL(2)
#line 1402 "filter/f-inst.c"
NONNULL(3)
#line 1407 "filter/f-inst.c"
f_new_inst_FI_ECLIST_DELETE_ECLIST(enum f_instruction_code fi_code
#line 1401 "filter/f-inst.c"
  , struct f_inst * f1
#line 1402 "filter/f-inst.c"
  , struct f_inst * f2
#line 1407 "filter/f-inst.c"
)
#line 1407
  {
#line 1407
    /* Allocate the structure */
#line 1407
    struct f_inst *what = fi_new(fi_code);
#line 1407
    uint constargs = 1;
#line 1407

#line 1407
    /* Initialize all the members */
#line 1407
  #define whati (&(what->i_FI_ECLIST_DELETE_ECLIST))
#line 1407
  #line 1401 "filter/f-inst.c"
whati->f1 = f1;
#line 1401
const struct f_inst *child1 = f1;
#line 1401
do {
#line 1401
  what->size += child1->size;
#line 1401

#line 1401
  if (child1->fi_code != FI_CONSTANT)
#line 1401
    constargs = 0;
#line 1401

#line 1401
} while (child1 = child1->next);
#line 1401

#line 1401 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1401
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1401
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1402 "filter/f-inst.c"
whati->f2 = f2;
#line 1402
const struct f_inst *child2 = f2;
#line 1402
do {
#line 1402
  what->size += child2->size;
#line 1402

#line 1402
  if (child2->fi_code != FI_CONSTANT)
#line 1402
    constargs = 0;
#line 1402

#line 1402
} while (child2 = child2->next);
#line 1402 "filter/f-inst.c"
if (f2->type && (f2->type != (T_ECLIST)) && !f_const_promotion(f2, (T_ECLIST)))
#line 1402
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1402
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f2->type));
#line 1404 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1407 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1407
    if (!constargs)
#line 1407
      return what;
#line 1407

#line 1407
    /* Try to pre-calculate the result */
#line 1407
    #line 1400 "filter/f-inst.c"
 {
    
#line 1401 "filter/f-inst.c"
 #line 1401 "filter/f-inst.c"
 ;
#line 1402 "filter/f-inst.c"
    
#line 1402 "filter/f-inst.c"
 #line 1402 "filter/f-inst.c"
 ;
#line 1403 "filter/f-inst.c"
    #line 1403 "filter/f-inst.c"
;
     
#line 1404 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  eclist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1407 "filter/f-inst.c"
  }
#line 1407

#line 1407

#line 1418 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_DELETE_SET */
#line 1418
struct f_inst *
#line 1408 "filter/f-inst.c"
NONNULL(2)
#line 1409 "filter/f-inst.c"
NONNULL(3)
#line 1418 "filter/f-inst.c"
f_new_inst_FI_ECLIST_DELETE_SET(enum f_instruction_code fi_code
#line 1408 "filter/f-inst.c"
  , struct f_inst * f1
#line 1409 "filter/f-inst.c"
  , struct f_inst * f2
#line 1418 "filter/f-inst.c"
)
#line 1418
  {
#line 1418
    /* Allocate the structure */
#line 1418
    struct f_inst *what = fi_new(fi_code);
#line 1418
    uint constargs = 1;
#line 1418

#line 1418
    /* Initialize all the members */
#line 1418
  #define whati (&(what->i_FI_ECLIST_DELETE_SET))
#line 1418
  #line 1408 "filter/f-inst.c"
whati->f1 = f1;
#line 1408
const struct f_inst *child1 = f1;
#line 1408
do {
#line 1408
  what->size += child1->size;
#line 1408

#line 1408
  if (child1->fi_code != FI_CONSTANT)
#line 1408
    constargs = 0;
#line 1408

#line 1408
} while (child1 = child1->next);
#line 1408

#line 1408 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1408
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1408
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1409 "filter/f-inst.c"
whati->f2 = f2;
#line 1409
const struct f_inst *child2 = f2;
#line 1409
do {
#line 1409
  what->size += child2->size;
#line 1409

#line 1409
  if (child2->fi_code != FI_CONSTANT)
#line 1409
    constargs = 0;
#line 1409

#line 1409
} while (child2 = child2->next);
#line 1409 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1409
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1409
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1415 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1418 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1418
    if (!constargs)
#line 1418
      return what;
#line 1418

#line 1418
    /* Try to pre-calculate the result */
#line 1418
    #line 1407 "filter/f-inst.c"
 {
    
#line 1408 "filter/f-inst.c"
 #line 1408 "filter/f-inst.c"
 ;
#line 1409 "filter/f-inst.c"
    
#line 1409 "filter/f-inst.c"
 #line 1409 "filter/f-inst.c"
 ;
#line 1410 "filter/f-inst.c"
    #line 1410 "filter/f-inst.c"
;

    if (!eclist_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1415 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  eclist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1418 "filter/f-inst.c"
  }
#line 1418

#line 1418

#line 1425 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_DELETE_LC */
#line 1425
struct f_inst *
#line 1419 "filter/f-inst.c"
NONNULL(2)
#line 1420 "filter/f-inst.c"
NONNULL(3)
#line 1425 "filter/f-inst.c"
f_new_inst_FI_LCLIST_DELETE_LC(enum f_instruction_code fi_code
#line 1419 "filter/f-inst.c"
  , struct f_inst * f1
#line 1420 "filter/f-inst.c"
  , struct f_inst * f2
#line 1425 "filter/f-inst.c"
)
#line 1425
  {
#line 1425
    /* Allocate the structure */
#line 1425
    struct f_inst *what = fi_new(fi_code);
#line 1425
    uint constargs = 1;
#line 1425

#line 1425
    /* Initialize all the members */
#line 1425
  #define whati (&(what->i_FI_LCLIST_DELETE_LC))
#line 1425
  #line 1419 "filter/f-inst.c"
whati->f1 = f1;
#line 1419
const struct f_inst *child1 = f1;
#line 1419
do {
#line 1419
  what->size += child1->size;
#line 1419

#line 1419
  if (child1->fi_code != FI_CONSTANT)
#line 1419
    constargs = 0;
#line 1419

#line 1419
} while (child1 = child1->next);
#line 1419

#line 1419 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1419
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1419
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1420 "filter/f-inst.c"
whati->f2 = f2;
#line 1420
const struct f_inst *child2 = f2;
#line 1420
do {
#line 1420
  what->size += child2->size;
#line 1420

#line 1420
  if (child2->fi_code != FI_CONSTANT)
#line 1420
    constargs = 0;
#line 1420

#line 1420
} while (child2 = child2->next);
#line 1420 "filter/f-inst.c"
if (f2->type && (f2->type != (T_LC)) && !f_const_promotion(f2, (T_LC)))
#line 1420
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1420
	   f_instruction_name(what->fi_code), f_type_name(T_LC), f_type_name(f2->type));
#line 1422 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1425 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1425
    if (!constargs)
#line 1425
      return what;
#line 1425

#line 1425
    /* Try to pre-calculate the result */
#line 1425
    #line 1418 "filter/f-inst.c"
 {
    
#line 1419 "filter/f-inst.c"
 #line 1419 "filter/f-inst.c"
 ;
#line 1420 "filter/f-inst.c"
    
#line 1420 "filter/f-inst.c"
 #line 1420 "filter/f-inst.c"
 ;
#line 1421 "filter/f-inst.c"
    #line 1421 "filter/f-inst.c"
;
     
#line 1422 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lc_set_del(fpool, v1.val.ad, v2.val.lc)  } );
  }

  
  #undef whati
#line 1425 "filter/f-inst.c"
  }
#line 1425

#line 1425

#line 1432 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_DELETE_LCLIST */
#line 1432
struct f_inst *
#line 1426 "filter/f-inst.c"
NONNULL(2)
#line 1427 "filter/f-inst.c"
NONNULL(3)
#line 1432 "filter/f-inst.c"
f_new_inst_FI_LCLIST_DELETE_LCLIST(enum f_instruction_code fi_code
#line 1426 "filter/f-inst.c"
  , struct f_inst * f1
#line 1427 "filter/f-inst.c"
  , struct f_inst * f2
#line 1432 "filter/f-inst.c"
)
#line 1432
  {
#line 1432
    /* Allocate the structure */
#line 1432
    struct f_inst *what = fi_new(fi_code);
#line 1432
    uint constargs = 1;
#line 1432

#line 1432
    /* Initialize all the members */
#line 1432
  #define whati (&(what->i_FI_LCLIST_DELETE_LCLIST))
#line 1432
  #line 1426 "filter/f-inst.c"
whati->f1 = f1;
#line 1426
const struct f_inst *child1 = f1;
#line 1426
do {
#line 1426
  what->size += child1->size;
#line 1426

#line 1426
  if (child1->fi_code != FI_CONSTANT)
#line 1426
    constargs = 0;
#line 1426

#line 1426
} while (child1 = child1->next);
#line 1426

#line 1426 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1426
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1426
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1427 "filter/f-inst.c"
whati->f2 = f2;
#line 1427
const struct f_inst *child2 = f2;
#line 1427
do {
#line 1427
  what->size += child2->size;
#line 1427

#line 1427
  if (child2->fi_code != FI_CONSTANT)
#line 1427
    constargs = 0;
#line 1427

#line 1427
} while (child2 = child2->next);
#line 1427 "filter/f-inst.c"
if (f2->type && (f2->type != (T_LCLIST)) && !f_const_promotion(f2, (T_LCLIST)))
#line 1427
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1427
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f2->type));
#line 1429 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1432 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1432
    if (!constargs)
#line 1432
      return what;
#line 1432

#line 1432
    /* Try to pre-calculate the result */
#line 1432
    #line 1425 "filter/f-inst.c"
 {
    
#line 1426 "filter/f-inst.c"
 #line 1426 "filter/f-inst.c"
 ;
#line 1427 "filter/f-inst.c"
    
#line 1427 "filter/f-inst.c"
 #line 1427 "filter/f-inst.c"
 ;
#line 1428 "filter/f-inst.c"
    #line 1428 "filter/f-inst.c"
;
     
#line 1429 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lclist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1432 "filter/f-inst.c"
  }
#line 1432

#line 1432

#line 1443 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_DELETE_SET */
#line 1443
struct f_inst *
#line 1433 "filter/f-inst.c"
NONNULL(2)
#line 1434 "filter/f-inst.c"
NONNULL(3)
#line 1443 "filter/f-inst.c"
f_new_inst_FI_LCLIST_DELETE_SET(enum f_instruction_code fi_code
#line 1433 "filter/f-inst.c"
  , struct f_inst * f1
#line 1434 "filter/f-inst.c"
  , struct f_inst * f2
#line 1443 "filter/f-inst.c"
)
#line 1443
  {
#line 1443
    /* Allocate the structure */
#line 1443
    struct f_inst *what = fi_new(fi_code);
#line 1443
    uint constargs = 1;
#line 1443

#line 1443
    /* Initialize all the members */
#line 1443
  #define whati (&(what->i_FI_LCLIST_DELETE_SET))
#line 1443
  #line 1433 "filter/f-inst.c"
whati->f1 = f1;
#line 1433
const struct f_inst *child1 = f1;
#line 1433
do {
#line 1433
  what->size += child1->size;
#line 1433

#line 1433
  if (child1->fi_code != FI_CONSTANT)
#line 1433
    constargs = 0;
#line 1433

#line 1433
} while (child1 = child1->next);
#line 1433

#line 1433 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1433
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1433
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1434 "filter/f-inst.c"
whati->f2 = f2;
#line 1434
const struct f_inst *child2 = f2;
#line 1434
do {
#line 1434
  what->size += child2->size;
#line 1434

#line 1434
  if (child2->fi_code != FI_CONSTANT)
#line 1434
    constargs = 0;
#line 1434

#line 1434
} while (child2 = child2->next);
#line 1434 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1434
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1434
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1440 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1443 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1443
    if (!constargs)
#line 1443
      return what;
#line 1443

#line 1443
    /* Try to pre-calculate the result */
#line 1443
    #line 1432 "filter/f-inst.c"
 {
    
#line 1433 "filter/f-inst.c"
 #line 1433 "filter/f-inst.c"
 ;
#line 1434 "filter/f-inst.c"
    
#line 1434 "filter/f-inst.c"
 #line 1434 "filter/f-inst.c"
 ;
#line 1435 "filter/f-inst.c"
    #line 1435 "filter/f-inst.c"
;

    if (!lclist_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1440 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lclist_filter(fpool, v1.val.ad, &v2, 0)  } );
  }

  
  #undef whati
#line 1443 "filter/f-inst.c"
  }
#line 1443

#line 1443

#line 1454 "filter/f-inst.c"
 /* Constructor for FI_PATH_FILTER_SET */
#line 1454
struct f_inst *
#line 1444 "filter/f-inst.c"
NONNULL(2)
#line 1445 "filter/f-inst.c"
NONNULL(3)
#line 1454 "filter/f-inst.c"
f_new_inst_FI_PATH_FILTER_SET(enum f_instruction_code fi_code
#line 1444 "filter/f-inst.c"
  , struct f_inst * f1
#line 1445 "filter/f-inst.c"
  , struct f_inst * f2
#line 1454 "filter/f-inst.c"
)
#line 1454
  {
#line 1454
    /* Allocate the structure */
#line 1454
    struct f_inst *what = fi_new(fi_code);
#line 1454
    uint constargs = 1;
#line 1454

#line 1454
    /* Initialize all the members */
#line 1454
  #define whati (&(what->i_FI_PATH_FILTER_SET))
#line 1454
  #line 1444 "filter/f-inst.c"
whati->f1 = f1;
#line 1444
const struct f_inst *child1 = f1;
#line 1444
do {
#line 1444
  what->size += child1->size;
#line 1444

#line 1444
  if (child1->fi_code != FI_CONSTANT)
#line 1444
    constargs = 0;
#line 1444

#line 1444
} while (child1 = child1->next);
#line 1444

#line 1444 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1444
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1444
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1445 "filter/f-inst.c"
whati->f2 = f2;
#line 1445
const struct f_inst *child2 = f2;
#line 1445
do {
#line 1445
  what->size += child2->size;
#line 1445

#line 1445
  if (child2->fi_code != FI_CONSTANT)
#line 1445
    constargs = 0;
#line 1445

#line 1445
} while (child2 = child2->next);
#line 1445 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1445
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1445
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1451 "filter/f-inst.c"
what->type = T_PATH;

#line 1454 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1454
    if (!constargs)
#line 1454
      return what;
#line 1454

#line 1454
    /* Try to pre-calculate the result */
#line 1454
    #line 1443 "filter/f-inst.c"
 {
    
#line 1444 "filter/f-inst.c"
 #line 1444 "filter/f-inst.c"
 ;
#line 1445 "filter/f-inst.c"
    
#line 1445 "filter/f-inst.c"
 #line 1445 "filter/f-inst.c"
 ;
#line 1446 "filter/f-inst.c"
    #line 1446 "filter/f-inst.c"
;

    if (!path_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1451 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_PATH, .val.ad =  as_path_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1454 "filter/f-inst.c"
  }
#line 1454

#line 1454

#line 1461 "filter/f-inst.c"
 /* Constructor for FI_CLIST_FILTER_CLIST */
#line 1461
struct f_inst *
#line 1455 "filter/f-inst.c"
NONNULL(2)
#line 1456 "filter/f-inst.c"
NONNULL(3)
#line 1461 "filter/f-inst.c"
f_new_inst_FI_CLIST_FILTER_CLIST(enum f_instruction_code fi_code
#line 1455 "filter/f-inst.c"
  , struct f_inst * f1
#line 1456 "filter/f-inst.c"
  , struct f_inst * f2
#line 1461 "filter/f-inst.c"
)
#line 1461
  {
#line 1461
    /* Allocate the structure */
#line 1461
    struct f_inst *what = fi_new(fi_code);
#line 1461
    uint constargs = 1;
#line 1461

#line 1461
    /* Initialize all the members */
#line 1461
  #define whati (&(what->i_FI_CLIST_FILTER_CLIST))
#line 1461
  #line 1455 "filter/f-inst.c"
whati->f1 = f1;
#line 1455
const struct f_inst *child1 = f1;
#line 1455
do {
#line 1455
  what->size += child1->size;
#line 1455

#line 1455
  if (child1->fi_code != FI_CONSTANT)
#line 1455
    constargs = 0;
#line 1455

#line 1455
} while (child1 = child1->next);
#line 1455

#line 1455 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1455
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1455
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1456 "filter/f-inst.c"
whati->f2 = f2;
#line 1456
const struct f_inst *child2 = f2;
#line 1456
do {
#line 1456
  what->size += child2->size;
#line 1456

#line 1456
  if (child2->fi_code != FI_CONSTANT)
#line 1456
    constargs = 0;
#line 1456

#line 1456
} while (child2 = child2->next);
#line 1456 "filter/f-inst.c"
if (f2->type && (f2->type != (T_CLIST)) && !f_const_promotion(f2, (T_CLIST)))
#line 1456
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1456
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f2->type));
#line 1458 "filter/f-inst.c"
what->type = T_CLIST;

#line 1461 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1461
    if (!constargs)
#line 1461
      return what;
#line 1461

#line 1461
    /* Try to pre-calculate the result */
#line 1461
    #line 1454 "filter/f-inst.c"
 {
    
#line 1455 "filter/f-inst.c"
 #line 1455 "filter/f-inst.c"
 ;
#line 1456 "filter/f-inst.c"
    
#line 1456 "filter/f-inst.c"
 #line 1456 "filter/f-inst.c"
 ;
#line 1457 "filter/f-inst.c"
    #line 1457 "filter/f-inst.c"
;
     
#line 1458 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  clist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1461 "filter/f-inst.c"
  }
#line 1461

#line 1461

#line 1472 "filter/f-inst.c"
 /* Constructor for FI_CLIST_FILTER_SET */
#line 1472
struct f_inst *
#line 1462 "filter/f-inst.c"
NONNULL(2)
#line 1463 "filter/f-inst.c"
NONNULL(3)
#line 1472 "filter/f-inst.c"
f_new_inst_FI_CLIST_FILTER_SET(enum f_instruction_code fi_code
#line 1462 "filter/f-inst.c"
  , struct f_inst * f1
#line 1463 "filter/f-inst.c"
  , struct f_inst * f2
#line 1472 "filter/f-inst.c"
)
#line 1472
  {
#line 1472
    /* Allocate the structure */
#line 1472
    struct f_inst *what = fi_new(fi_code);
#line 1472
    uint constargs = 1;
#line 1472

#line 1472
    /* Initialize all the members */
#line 1472
  #define whati (&(what->i_FI_CLIST_FILTER_SET))
#line 1472
  #line 1462 "filter/f-inst.c"
whati->f1 = f1;
#line 1462
const struct f_inst *child1 = f1;
#line 1462
do {
#line 1462
  what->size += child1->size;
#line 1462

#line 1462
  if (child1->fi_code != FI_CONSTANT)
#line 1462
    constargs = 0;
#line 1462

#line 1462
} while (child1 = child1->next);
#line 1462

#line 1462 "filter/f-inst.c"
if (f1->type && (f1->type != (T_CLIST)) && !f_const_promotion(f1, (T_CLIST)))
#line 1462
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1462
	   f_instruction_name(what->fi_code), f_type_name(T_CLIST), f_type_name(f1->type));
#line 1463 "filter/f-inst.c"
whati->f2 = f2;
#line 1463
const struct f_inst *child2 = f2;
#line 1463
do {
#line 1463
  what->size += child2->size;
#line 1463

#line 1463
  if (child2->fi_code != FI_CONSTANT)
#line 1463
    constargs = 0;
#line 1463

#line 1463
} while (child2 = child2->next);
#line 1463 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1463
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1463
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1469 "filter/f-inst.c"
what->type = T_CLIST;

#line 1472 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1472
    if (!constargs)
#line 1472
      return what;
#line 1472

#line 1472
    /* Try to pre-calculate the result */
#line 1472
    #line 1461 "filter/f-inst.c"
 {
    
#line 1462 "filter/f-inst.c"
 #line 1462 "filter/f-inst.c"
 ;
#line 1463 "filter/f-inst.c"
    
#line 1463 "filter/f-inst.c"
 #line 1463 "filter/f-inst.c"
 ;
#line 1464 "filter/f-inst.c"
    #line 1464 "filter/f-inst.c"
;

    if (!clist_set_type(v2.val.t, &(struct f_val){}))
      runtime("Mismatched set type");

     
#line 1469 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_CLIST, .val.ad =  clist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1472 "filter/f-inst.c"
  }
#line 1472

#line 1472

#line 1479 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_FILTER_ECLIST */
#line 1479
struct f_inst *
#line 1473 "filter/f-inst.c"
NONNULL(2)
#line 1474 "filter/f-inst.c"
NONNULL(3)
#line 1479 "filter/f-inst.c"
f_new_inst_FI_ECLIST_FILTER_ECLIST(enum f_instruction_code fi_code
#line 1473 "filter/f-inst.c"
  , struct f_inst * f1
#line 1474 "filter/f-inst.c"
  , struct f_inst * f2
#line 1479 "filter/f-inst.c"
)
#line 1479
  {
#line 1479
    /* Allocate the structure */
#line 1479
    struct f_inst *what = fi_new(fi_code);
#line 1479
    uint constargs = 1;
#line 1479

#line 1479
    /* Initialize all the members */
#line 1479
  #define whati (&(what->i_FI_ECLIST_FILTER_ECLIST))
#line 1479
  #line 1473 "filter/f-inst.c"
whati->f1 = f1;
#line 1473
const struct f_inst *child1 = f1;
#line 1473
do {
#line 1473
  what->size += child1->size;
#line 1473

#line 1473
  if (child1->fi_code != FI_CONSTANT)
#line 1473
    constargs = 0;
#line 1473

#line 1473
} while (child1 = child1->next);
#line 1473

#line 1473 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1473
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1473
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1474 "filter/f-inst.c"
whati->f2 = f2;
#line 1474
const struct f_inst *child2 = f2;
#line 1474
do {
#line 1474
  what->size += child2->size;
#line 1474

#line 1474
  if (child2->fi_code != FI_CONSTANT)
#line 1474
    constargs = 0;
#line 1474

#line 1474
} while (child2 = child2->next);
#line 1474 "filter/f-inst.c"
if (f2->type && (f2->type != (T_ECLIST)) && !f_const_promotion(f2, (T_ECLIST)))
#line 1474
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1474
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f2->type));
#line 1476 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1479 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1479
    if (!constargs)
#line 1479
      return what;
#line 1479

#line 1479
    /* Try to pre-calculate the result */
#line 1479
    #line 1472 "filter/f-inst.c"
 {
    
#line 1473 "filter/f-inst.c"
 #line 1473 "filter/f-inst.c"
 ;
#line 1474 "filter/f-inst.c"
    
#line 1474 "filter/f-inst.c"
 #line 1474 "filter/f-inst.c"
 ;
#line 1475 "filter/f-inst.c"
    #line 1475 "filter/f-inst.c"
;
     
#line 1476 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  eclist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1479 "filter/f-inst.c"
  }
#line 1479

#line 1479

#line 1490 "filter/f-inst.c"
 /* Constructor for FI_ECLIST_FILTER_SET */
#line 1490
struct f_inst *
#line 1480 "filter/f-inst.c"
NONNULL(2)
#line 1481 "filter/f-inst.c"
NONNULL(3)
#line 1490 "filter/f-inst.c"
f_new_inst_FI_ECLIST_FILTER_SET(enum f_instruction_code fi_code
#line 1480 "filter/f-inst.c"
  , struct f_inst * f1
#line 1481 "filter/f-inst.c"
  , struct f_inst * f2
#line 1490 "filter/f-inst.c"
)
#line 1490
  {
#line 1490
    /* Allocate the structure */
#line 1490
    struct f_inst *what = fi_new(fi_code);
#line 1490
    uint constargs = 1;
#line 1490

#line 1490
    /* Initialize all the members */
#line 1490
  #define whati (&(what->i_FI_ECLIST_FILTER_SET))
#line 1490
  #line 1480 "filter/f-inst.c"
whati->f1 = f1;
#line 1480
const struct f_inst *child1 = f1;
#line 1480
do {
#line 1480
  what->size += child1->size;
#line 1480

#line 1480
  if (child1->fi_code != FI_CONSTANT)
#line 1480
    constargs = 0;
#line 1480

#line 1480
} while (child1 = child1->next);
#line 1480

#line 1480 "filter/f-inst.c"
if (f1->type && (f1->type != (T_ECLIST)) && !f_const_promotion(f1, (T_ECLIST)))
#line 1480
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1480
	   f_instruction_name(what->fi_code), f_type_name(T_ECLIST), f_type_name(f1->type));
#line 1481 "filter/f-inst.c"
whati->f2 = f2;
#line 1481
const struct f_inst *child2 = f2;
#line 1481
do {
#line 1481
  what->size += child2->size;
#line 1481

#line 1481
  if (child2->fi_code != FI_CONSTANT)
#line 1481
    constargs = 0;
#line 1481

#line 1481
} while (child2 = child2->next);
#line 1481 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1481
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1481
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1487 "filter/f-inst.c"
what->type = T_ECLIST;

#line 1490 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1490
    if (!constargs)
#line 1490
      return what;
#line 1490

#line 1490
    /* Try to pre-calculate the result */
#line 1490
    #line 1479 "filter/f-inst.c"
 {
    
#line 1480 "filter/f-inst.c"
 #line 1480 "filter/f-inst.c"
 ;
#line 1481 "filter/f-inst.c"
    
#line 1481 "filter/f-inst.c"
 #line 1481 "filter/f-inst.c"
 ;
#line 1482 "filter/f-inst.c"
    #line 1482 "filter/f-inst.c"
;

    if (!eclist_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1487 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_ECLIST, .val.ad =  eclist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1490 "filter/f-inst.c"
  }
#line 1490

#line 1490

#line 1497 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_FILTER_LCLIST */
#line 1497
struct f_inst *
#line 1491 "filter/f-inst.c"
NONNULL(2)
#line 1492 "filter/f-inst.c"
NONNULL(3)
#line 1497 "filter/f-inst.c"
f_new_inst_FI_LCLIST_FILTER_LCLIST(enum f_instruction_code fi_code
#line 1491 "filter/f-inst.c"
  , struct f_inst * f1
#line 1492 "filter/f-inst.c"
  , struct f_inst * f2
#line 1497 "filter/f-inst.c"
)
#line 1497
  {
#line 1497
    /* Allocate the structure */
#line 1497
    struct f_inst *what = fi_new(fi_code);
#line 1497
    uint constargs = 1;
#line 1497

#line 1497
    /* Initialize all the members */
#line 1497
  #define whati (&(what->i_FI_LCLIST_FILTER_LCLIST))
#line 1497
  #line 1491 "filter/f-inst.c"
whati->f1 = f1;
#line 1491
const struct f_inst *child1 = f1;
#line 1491
do {
#line 1491
  what->size += child1->size;
#line 1491

#line 1491
  if (child1->fi_code != FI_CONSTANT)
#line 1491
    constargs = 0;
#line 1491

#line 1491
} while (child1 = child1->next);
#line 1491

#line 1491 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1491
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1491
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1492 "filter/f-inst.c"
whati->f2 = f2;
#line 1492
const struct f_inst *child2 = f2;
#line 1492
do {
#line 1492
  what->size += child2->size;
#line 1492

#line 1492
  if (child2->fi_code != FI_CONSTANT)
#line 1492
    constargs = 0;
#line 1492

#line 1492
} while (child2 = child2->next);
#line 1492 "filter/f-inst.c"
if (f2->type && (f2->type != (T_LCLIST)) && !f_const_promotion(f2, (T_LCLIST)))
#line 1492
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1492
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f2->type));
#line 1494 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1497 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1497
    if (!constargs)
#line 1497
      return what;
#line 1497

#line 1497
    /* Try to pre-calculate the result */
#line 1497
    #line 1490 "filter/f-inst.c"
 {
    
#line 1491 "filter/f-inst.c"
 #line 1491 "filter/f-inst.c"
 ;
#line 1492 "filter/f-inst.c"
    
#line 1492 "filter/f-inst.c"
 #line 1492 "filter/f-inst.c"
 ;
#line 1493 "filter/f-inst.c"
    #line 1493 "filter/f-inst.c"
;
     
#line 1494 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lclist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1497 "filter/f-inst.c"
  }
#line 1497

#line 1497

#line 1508 "filter/f-inst.c"
 /* Constructor for FI_LCLIST_FILTER_SET */
#line 1508
struct f_inst *
#line 1498 "filter/f-inst.c"
NONNULL(2)
#line 1499 "filter/f-inst.c"
NONNULL(3)
#line 1508 "filter/f-inst.c"
f_new_inst_FI_LCLIST_FILTER_SET(enum f_instruction_code fi_code
#line 1498 "filter/f-inst.c"
  , struct f_inst * f1
#line 1499 "filter/f-inst.c"
  , struct f_inst * f2
#line 1508 "filter/f-inst.c"
)
#line 1508
  {
#line 1508
    /* Allocate the structure */
#line 1508
    struct f_inst *what = fi_new(fi_code);
#line 1508
    uint constargs = 1;
#line 1508

#line 1508
    /* Initialize all the members */
#line 1508
  #define whati (&(what->i_FI_LCLIST_FILTER_SET))
#line 1508
  #line 1498 "filter/f-inst.c"
whati->f1 = f1;
#line 1498
const struct f_inst *child1 = f1;
#line 1498
do {
#line 1498
  what->size += child1->size;
#line 1498

#line 1498
  if (child1->fi_code != FI_CONSTANT)
#line 1498
    constargs = 0;
#line 1498

#line 1498
} while (child1 = child1->next);
#line 1498

#line 1498 "filter/f-inst.c"
if (f1->type && (f1->type != (T_LCLIST)) && !f_const_promotion(f1, (T_LCLIST)))
#line 1498
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1498
	   f_instruction_name(what->fi_code), f_type_name(T_LCLIST), f_type_name(f1->type));
#line 1499 "filter/f-inst.c"
whati->f2 = f2;
#line 1499
const struct f_inst *child2 = f2;
#line 1499
do {
#line 1499
  what->size += child2->size;
#line 1499

#line 1499
  if (child2->fi_code != FI_CONSTANT)
#line 1499
    constargs = 0;
#line 1499

#line 1499
} while (child2 = child2->next);
#line 1499 "filter/f-inst.c"
if (f2->type && (f2->type != (T_SET)) && !f_const_promotion(f2, (T_SET)))
#line 1499
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1499
	   f_instruction_name(what->fi_code), f_type_name(T_SET), f_type_name(f2->type));
#line 1505 "filter/f-inst.c"
what->type = T_LCLIST;

#line 1508 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1508
    if (!constargs)
#line 1508
      return what;
#line 1508

#line 1508
    /* Try to pre-calculate the result */
#line 1508
    #line 1497 "filter/f-inst.c"
 {
    
#line 1498 "filter/f-inst.c"
 #line 1498 "filter/f-inst.c"
 ;
#line 1499 "filter/f-inst.c"
    
#line 1499 "filter/f-inst.c"
 #line 1499 "filter/f-inst.c"
 ;
#line 1500 "filter/f-inst.c"
    #line 1500 "filter/f-inst.c"
;

    if (!lclist_set_type(v2.val.t))
      runtime("Mismatched set type");

     
#line 1505 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_LCLIST, .val.ad =  lclist_filter(fpool, v1.val.ad, &v2, 1)  } );
  }

  
  #undef whati
#line 1508 "filter/f-inst.c"
  }
#line 1508

#line 1508

#line 1530 "filter/f-inst.c"
 /* Constructor for FI_ROA_CHECK */
#line 1530
struct f_inst *
#line 1510 "filter/f-inst.c"
NONNULL(2)
#line 1511 "filter/f-inst.c"
NONNULL(3)
#line 1530 "filter/f-inst.c"
f_new_inst_FI_ROA_CHECK(enum f_instruction_code fi_code
#line 1510 "filter/f-inst.c"
  , struct f_inst * f1
#line 1511 "filter/f-inst.c"
  , struct f_inst * f2
#line 1512 "filter/f-inst.c"
  , struct rtable_config * rtc
#line 1530 "filter/f-inst.c"
)
#line 1530
  {
#line 1530
    /* Allocate the structure */
#line 1530
    struct f_inst *what = fi_new(fi_code);
#line 1530
    
#line 1530

#line 1530
    /* Initialize all the members */
#line 1530
  #define whati (&(what->i_FI_ROA_CHECK))
#line 1530
  #line 1510 "filter/f-inst.c"
whati->f1 = f1;
#line 1510
const struct f_inst *child1 = f1;
#line 1510
do {
#line 1510
  what->size += child1->size;
#line 1510

#line 1510
} while (child1 = child1->next);
#line 1510

#line 1510 "filter/f-inst.c"
if (f1->type && (f1->type != (T_NET)) && !f_const_promotion(f1, (T_NET)))
#line 1510
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1510
	   f_instruction_name(what->fi_code), f_type_name(T_NET), f_type_name(f1->type));
#line 1511 "filter/f-inst.c"
whati->f2 = f2;
#line 1511
const struct f_inst *child2 = f2;
#line 1511
do {
#line 1511
  what->size += child2->size;
#line 1511

#line 1511
} while (child2 = child2->next);
#line 1511 "filter/f-inst.c"
if (f2->type && (f2->type != (T_INT)) && !f_const_promotion(f2, (T_INT)))
#line 1511
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1511
	   f_instruction_name(what->fi_code), f_type_name(T_INT), f_type_name(f2->type));
#line 1512 "filter/f-inst.c"
whati->rtc = rtc;
#line 1524 "filter/f-inst.c"
what->type = T_ENUM_ROA;

#line 1530 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1530
    
#line 1530
      return what;
#line 1530

#line 1530
    /* Try to pre-calculate the result */
#line 1530
      #undef whati
#line 1530
  }
#line 1530

#line 1530

#line 1546 "filter/f-inst.c"
 /* Constructor for FI_ASPA_CHECK_EXPLICIT */
#line 1546
struct f_inst *
#line 1532 "filter/f-inst.c"
NONNULL(2)
#line 1533 "filter/f-inst.c"
NONNULL(3)
#line 1546 "filter/f-inst.c"
f_new_inst_FI_ASPA_CHECK_EXPLICIT(enum f_instruction_code fi_code
#line 1532 "filter/f-inst.c"
  , struct f_inst * f1
#line 1533 "filter/f-inst.c"
  , struct f_inst * f2
#line 1534 "filter/f-inst.c"
  , struct rtable_config * rtc
#line 1546 "filter/f-inst.c"
)
#line 1546
  {
#line 1546
    /* Allocate the structure */
#line 1546
    struct f_inst *what = fi_new(fi_code);
#line 1546
    
#line 1546

#line 1546
    /* Initialize all the members */
#line 1546
  #define whati (&(what->i_FI_ASPA_CHECK_EXPLICIT))
#line 1546
  #line 1532 "filter/f-inst.c"
whati->f1 = f1;
#line 1532
const struct f_inst *child1 = f1;
#line 1532
do {
#line 1532
  what->size += child1->size;
#line 1532

#line 1532
} while (child1 = child1->next);
#line 1532

#line 1532 "filter/f-inst.c"
if (f1->type && (f1->type != (T_PATH)) && !f_const_promotion(f1, (T_PATH)))
#line 1532
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1532
	   f_instruction_name(what->fi_code), f_type_name(T_PATH), f_type_name(f1->type));
#line 1533 "filter/f-inst.c"
whati->f2 = f2;
#line 1533
const struct f_inst *child2 = f2;
#line 1533
do {
#line 1533
  what->size += child2->size;
#line 1533

#line 1533
} while (child2 = child2->next);
#line 1533 "filter/f-inst.c"
if (f2->type && (f2->type != (T_BOOL)) && !f_const_promotion(f2, (T_BOOL)))
#line 1533
  cf_error("Argument 2 of %s must be of type %s, got type %s",
#line 1533
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f2->type));
#line 1534 "filter/f-inst.c"
whati->rtc = rtc;
#line 1543 "filter/f-inst.c"
what->type = T_ENUM_ASPA;

#line 1546 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1546
    
#line 1546
      return what;
#line 1546

#line 1546
    /* Try to pre-calculate the result */
#line 1546
      #undef whati
#line 1546
  }
#line 1546

#line 1546

#line 1561 "filter/f-inst.c"
 /* Constructor for FI_FROM_HEX */
#line 1561
struct f_inst *
#line 1547 "filter/f-inst.c"
NONNULL(2)
#line 1561 "filter/f-inst.c"
f_new_inst_FI_FROM_HEX(enum f_instruction_code fi_code
#line 1547 "filter/f-inst.c"
  , struct f_inst * f1
#line 1561 "filter/f-inst.c"
)
#line 1561
  {
#line 1561
    /* Allocate the structure */
#line 1561
    struct f_inst *what = fi_new(fi_code);
#line 1561
    uint constargs = 1;
#line 1561

#line 1561
    /* Initialize all the members */
#line 1561
  #define whati (&(what->i_FI_FROM_HEX))
#line 1561
  #line 1547 "filter/f-inst.c"
whati->f1 = f1;
#line 1547
const struct f_inst *child1 = f1;
#line 1547
do {
#line 1547
  what->size += child1->size;
#line 1547

#line 1547
  if (child1->fi_code != FI_CONSTANT)
#line 1547
    constargs = 0;
#line 1547

#line 1547
} while (child1 = child1->next);
#line 1547

#line 1547 "filter/f-inst.c"
if (f1->type && (f1->type != (T_STRING)) && !f_const_promotion(f1, (T_STRING)))
#line 1547
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1547
	   f_instruction_name(what->fi_code), f_type_name(T_STRING), f_type_name(f1->type));
#line 1558 "filter/f-inst.c"
what->type = T_BYTESTRING;

#line 1561 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1561
    if (!constargs)
#line 1561
      return what;
#line 1561

#line 1561
    /* Try to pre-calculate the result */
#line 1561
    #line 1546 "filter/f-inst.c"
 {	/* Convert hex text to bytestring */
    
#line 1547 "filter/f-inst.c"
 #line 1547 "filter/f-inst.c"
 ;
#line 1548 "filter/f-inst.c"

    int len = bstrhextobin(v1.val.s, NULL);
    if (len < 0)
      runtime("Invalid hex string");

    struct adata *bs;
    bs = falloc(sizeof(struct adata) + len);
    bs->length = bstrhextobin(v1.val.s, bs->data);
    ASSERT(bs->length == (size_t) len);

     
#line 1558 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_BYTESTRING, .val.bs = bs } );
  }

  
  #undef whati
#line 1561 "filter/f-inst.c"
  }
#line 1561

#line 1561

#line 1566 "filter/f-inst.c"
 /* Constructor for FI_FORMAT */
#line 1566
struct f_inst *
#line 1562 "filter/f-inst.c"
NONNULL(2)
#line 1566 "filter/f-inst.c"
f_new_inst_FI_FORMAT(enum f_instruction_code fi_code
#line 1562 "filter/f-inst.c"
  , struct f_inst * f1
#line 1566 "filter/f-inst.c"
)
#line 1566
  {
#line 1566
    /* Allocate the structure */
#line 1566
    struct f_inst *what = fi_new(fi_code);
#line 1566
    uint constargs = 1;
#line 1566

#line 1566
    /* Initialize all the members */
#line 1566
  #define whati (&(what->i_FI_FORMAT))
#line 1566
  #line 1562 "filter/f-inst.c"
whati->f1 = f1;
#line 1562
const struct f_inst *child1 = f1;
#line 1562
do {
#line 1562
  what->size += child1->size;
#line 1562

#line 1562
  if (child1->fi_code != FI_CONSTANT)
#line 1562
    constargs = 0;
#line 1562

#line 1562
} while (child1 = child1->next);
#line 1562

#line 1563 "filter/f-inst.c"
what->type = T_STRING;

#line 1566 "filter/f-inst.c"
    /* If not constant, return the instruction itself */
#line 1566
    if (!constargs)
#line 1566
      return what;
#line 1566

#line 1566
    /* Try to pre-calculate the result */
#line 1566
    #line 1561 "filter/f-inst.c"
 {	/* Format */
    
#line 1562 "filter/f-inst.c"
;
     
#line 1563 "filter/f-inst.c"
 return fi_constant(what,  (struct f_val) { .type = T_STRING, .val.s = val_format_str(fpool, &v1) } );
  }

  
  #undef whati
#line 1566 "filter/f-inst.c"
  }
#line 1566

#line 1566

#line 830 "filter/decl.m4"
 /* Constructor for FI_ASSERT */
#line 830
struct f_inst *
#line 1568 "filter/f-inst.c"
NONNULL(2)
#line 830 "filter/decl.m4"
f_new_inst_FI_ASSERT(enum f_instruction_code fi_code
#line 1568 "filter/f-inst.c"
  , struct f_inst * f1
#line 1570 "filter/f-inst.c"
  , char * s
#line 830 "filter/decl.m4"
)
#line 830
  {
#line 830
    /* Allocate the structure */
#line 830
    struct f_inst *what = fi_new(fi_code);
#line 830
    
#line 830

#line 830
    /* Initialize all the members */
#line 830
  #define whati (&(what->i_FI_ASSERT))
#line 830
  #line 1568 "filter/f-inst.c"
whati->f1 = f1;
#line 1568
const struct f_inst *child1 = f1;
#line 1568
do {
#line 1568
  what->size += child1->size;
#line 1568

#line 1568
} while (child1 = child1->next);
#line 1568

#line 1568 "filter/f-inst.c"
if (f1->type && (f1->type != (T_BOOL)) && !f_const_promotion(f1, (T_BOOL)))
#line 1568
  cf_error("Argument 1 of %s must be of type %s, got type %s",
#line 1568
	   f_instruction_name(what->fi_code), f_type_name(T_BOOL), f_type_name(f1->type));
#line 1570 "filter/f-inst.c"
whati->s = s;

#line 830 "filter/decl.m4"
    /* If not constant, return the instruction itself */
#line 830
    
#line 830
      return what;
#line 830

#line 830
    /* Try to pre-calculate the result */
#line 830
      #undef whati
#line 830
  }
#line 830

#line 830

#line 611 "filter/decl.m4"

#undef v1
#undef v2
#undef v3
#undef vv

/* Method constructor wrappers */
#line 288 "filter/f-inst.c"

#line 293 "filter/f-inst.c"

#line 298 "filter/f-inst.c"

#line 304 "filter/f-inst.c"

#line 309 "filter/f-inst.c"

#line 314 "filter/f-inst.c"

#line 324 "filter/f-inst.c"

#line 335 "filter/f-inst.c"

#line 345 "filter/f-inst.c"

#line 385 "filter/f-inst.c"

#line 392 "filter/f-inst.c"

#line 442 "filter/f-inst.c"

#line 449 "filter/f-inst.c"

#line 456 "filter/f-inst.c"

#line 467 "filter/f-inst.c"

#line 478 "filter/f-inst.c"

#line 483 "filter/f-inst.c"

#line 492 "filter/f-inst.c"

#line 501 "filter/f-inst.c"

#line 506 "filter/f-inst.c"

#line 507 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_NET__type */
#line 507
struct f_inst * NONNULL(1)
#line 507
f_new_method_FI_METHOD__T_NET__type(struct f_inst *obj, struct f_inst *args)
#line 507
  {
#line 507
    /* Unwind the arguments (1) */
#line 507
        if (args) cf_error("Too many arguments");
#line 506 "filter/f-inst.c"

#line 506

    return f_new_inst(FI_METHOD__T_NET__type, obj
#line 507 "filter/f-inst.c"

#line 507
    );
#line 507
  }
#line 507

#line 510 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_IP__is_v4 */
#line 510
struct f_inst * NONNULL(1)
#line 510
f_new_method_FI_METHOD__T_IP__is_v4(struct f_inst *obj, struct f_inst *args)
#line 510
  {
#line 510
    /* Unwind the arguments (1) */
#line 510
        if (args) cf_error("Too many arguments");
#line 507 "filter/f-inst.c"

#line 507

    return f_new_inst(FI_METHOD__T_IP__is_v4, obj
#line 510 "filter/f-inst.c"

#line 510
    );
#line 510
  }
#line 510

#line 523 "filter/f-inst.c"

#line 534 "filter/f-inst.c"

#line 543 "filter/f-inst.c"

#line 550 "filter/f-inst.c"

#line 563 "filter/f-inst.c"

#line 564 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PATH__empty */
#line 564
struct f_inst * NONNULL(1)
#line 564
f_new_method_FI_METHOD__T_PATH__empty(struct f_inst *obj, struct f_inst *args)
#line 564
  {
#line 564
    /* Unwind the arguments (1) */
#line 564
        if (args) cf_error("Too many arguments");
#line 563 "filter/f-inst.c"

#line 563

    return f_new_inst(FI_METHOD__T_PATH__empty, obj
#line 564 "filter/f-inst.c"

#line 564
    );
#line 564
  }
#line 564

#line 565 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_CLIST__empty */
#line 565
struct f_inst * NONNULL(1)
#line 565
f_new_method_FI_METHOD__T_CLIST__empty(struct f_inst *obj, struct f_inst *args)
#line 565
  {
#line 565
    /* Unwind the arguments (1) */
#line 565
        if (args) cf_error("Too many arguments");
#line 564 "filter/f-inst.c"

#line 564

    return f_new_inst(FI_METHOD__T_CLIST__empty, obj
#line 565 "filter/f-inst.c"

#line 565
    );
#line 565
  }
#line 565

#line 566 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_ECLIST__empty */
#line 566
struct f_inst * NONNULL(1)
#line 566
f_new_method_FI_METHOD__T_ECLIST__empty(struct f_inst *obj, struct f_inst *args)
#line 566
  {
#line 566
    /* Unwind the arguments (1) */
#line 566
        if (args) cf_error("Too many arguments");
#line 565 "filter/f-inst.c"

#line 565

    return f_new_inst(FI_METHOD__T_ECLIST__empty, obj
#line 566 "filter/f-inst.c"

#line 566
    );
#line 566
  }
#line 566

#line 569 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LCLIST__empty */
#line 569
struct f_inst * NONNULL(1)
#line 569
f_new_method_FI_METHOD__T_LCLIST__empty(struct f_inst *obj, struct f_inst *args)
#line 569
  {
#line 569
    /* Unwind the arguments (1) */
#line 569
        if (args) cf_error("Too many arguments");
#line 566 "filter/f-inst.c"

#line 566

    return f_new_inst(FI_METHOD__T_LCLIST__empty, obj
#line 569 "filter/f-inst.c"

#line 569
    );
#line 569
  }
#line 569

#line 591 "filter/f-inst.c"

#line 600 "filter/f-inst.c"
 /* Method constructor for FI_PATH_FOR_NEXT */
#line 600
struct f_inst * NONNULL(1)
#line 600
f_new_method_FI_PATH_FOR_NEXT(struct f_inst *obj, struct f_inst *args)
#line 600
  {
#line 600
    /* Unwind the arguments (2) */
#line 600
    #line 595 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 595
  if (args == NULL) cf_error("Not enough arguments"); /* FI_PATH_FOR_NEXT */
#line 595
  args = NULL; /* The rest is the line itself */
    if (args) cf_error("Too many arguments");
#line 597 "filter/f-inst.c"

#line 597

    return f_new_inst(FI_PATH_FOR_NEXT, obj
#line 595 "filter/f-inst.c"
    , arg2
#line 600 "filter/f-inst.c"

#line 600
    );
#line 600
  }
#line 600

#line 609 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_FOR_NEXT */
#line 609
struct f_inst * NONNULL(1)
#line 609
f_new_method_FI_CLIST_FOR_NEXT(struct f_inst *obj, struct f_inst *args)
#line 609
  {
#line 609
    /* Unwind the arguments (2) */
#line 609
    #line 604 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 604
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_FOR_NEXT */
#line 604
  args = NULL; /* The rest is the line itself */
    if (args) cf_error("Too many arguments");
#line 606 "filter/f-inst.c"

#line 606

    return f_new_inst(FI_CLIST_FOR_NEXT, obj
#line 604 "filter/f-inst.c"
    , arg2
#line 609 "filter/f-inst.c"

#line 609
    );
#line 609
  }
#line 609

#line 618 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_FOR_NEXT */
#line 618
struct f_inst * NONNULL(1)
#line 618
f_new_method_FI_ECLIST_FOR_NEXT(struct f_inst *obj, struct f_inst *args)
#line 618
  {
#line 618
    /* Unwind the arguments (2) */
#line 618
    #line 613 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 613
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_FOR_NEXT */
#line 613
  args = NULL; /* The rest is the line itself */
    if (args) cf_error("Too many arguments");
#line 615 "filter/f-inst.c"

#line 615

    return f_new_inst(FI_ECLIST_FOR_NEXT, obj
#line 613 "filter/f-inst.c"
    , arg2
#line 618 "filter/f-inst.c"

#line 618
    );
#line 618
  }
#line 618

#line 627 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_FOR_NEXT */
#line 627
struct f_inst * NONNULL(1)
#line 627
f_new_method_FI_LCLIST_FOR_NEXT(struct f_inst *obj, struct f_inst *args)
#line 627
  {
#line 627
    /* Unwind the arguments (2) */
#line 627
    #line 622 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 622
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_FOR_NEXT */
#line 622
  args = NULL; /* The rest is the line itself */
    if (args) cf_error("Too many arguments");
#line 624 "filter/f-inst.c"

#line 624

    return f_new_inst(FI_LCLIST_FOR_NEXT, obj
#line 622 "filter/f-inst.c"
    , arg2
#line 627 "filter/f-inst.c"

#line 627
    );
#line 627
  }
#line 627

#line 640 "filter/f-inst.c"
 /* Method constructor for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
struct f_inst * NONNULL(1)
#line 640
f_new_method_FI_ROUTES_BLOCK_FOR_NEXT(struct f_inst *obj, struct f_inst *args)
#line 640
  {
#line 640
    /* Unwind the arguments (2) */
#line 640
    #line 634 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 634
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ROUTES_BLOCK_FOR_NEXT */
#line 634
  args = NULL; /* The rest is the line itself */
    if (args) cf_error("Too many arguments");
#line 637 "filter/f-inst.c"

#line 637

    return f_new_inst(FI_ROUTES_BLOCK_FOR_NEXT, obj
#line 634 "filter/f-inst.c"
    , arg2
#line 640 "filter/f-inst.c"

#line 640
    );
#line 640
  }
#line 640

#line 648 "filter/f-inst.c"

#line 661 "filter/f-inst.c"

#line 668 "filter/f-inst.c"

#line 682 "filter/f-inst.c"

#line 689 "filter/f-inst.c"

#line 737 "filter/f-inst.c"

#line 866 "filter/f-inst.c"

#line 903 "filter/f-inst.c"

#line 944 "filter/f-inst.c"

#line 951 "filter/f-inst.c"

#line 965 "filter/f-inst.c"

#line 966 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_NET__len */
#line 966
struct f_inst * NONNULL(1)
#line 966
f_new_method_FI_METHOD__T_NET__len(struct f_inst *obj, struct f_inst *args)
#line 966
  {
#line 966
    /* Unwind the arguments (1) */
#line 966
        if (args) cf_error("Too many arguments");
#line 965 "filter/f-inst.c"

#line 965

    return f_new_inst(FI_METHOD__T_NET__len, obj
#line 966 "filter/f-inst.c"

#line 966
    );
#line 966
  }
#line 966

#line 967 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PATH__len */
#line 967
struct f_inst * NONNULL(1)
#line 967
f_new_method_FI_METHOD__T_PATH__len(struct f_inst *obj, struct f_inst *args)
#line 967
  {
#line 967
    /* Unwind the arguments (1) */
#line 967
        if (args) cf_error("Too many arguments");
#line 966 "filter/f-inst.c"

#line 966

    return f_new_inst(FI_METHOD__T_PATH__len, obj
#line 967 "filter/f-inst.c"

#line 967
    );
#line 967
  }
#line 967

#line 968 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_CLIST__len */
#line 968
struct f_inst * NONNULL(1)
#line 968
f_new_method_FI_METHOD__T_CLIST__len(struct f_inst *obj, struct f_inst *args)
#line 968
  {
#line 968
    /* Unwind the arguments (1) */
#line 968
        if (args) cf_error("Too many arguments");
#line 967 "filter/f-inst.c"

#line 967

    return f_new_inst(FI_METHOD__T_CLIST__len, obj
#line 968 "filter/f-inst.c"

#line 968
    );
#line 968
  }
#line 968

#line 969 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_ECLIST__len */
#line 969
struct f_inst * NONNULL(1)
#line 969
f_new_method_FI_METHOD__T_ECLIST__len(struct f_inst *obj, struct f_inst *args)
#line 969
  {
#line 969
    /* Unwind the arguments (1) */
#line 969
        if (args) cf_error("Too many arguments");
#line 968 "filter/f-inst.c"

#line 968

    return f_new_inst(FI_METHOD__T_ECLIST__len, obj
#line 969 "filter/f-inst.c"

#line 969
    );
#line 969
  }
#line 969

#line 971 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LCLIST__len */
#line 971
struct f_inst * NONNULL(1)
#line 971
f_new_method_FI_METHOD__T_LCLIST__len(struct f_inst *obj, struct f_inst *args)
#line 971
  {
#line 971
    /* Unwind the arguments (1) */
#line 971
        if (args) cf_error("Too many arguments");
#line 969 "filter/f-inst.c"

#line 969

    return f_new_inst(FI_METHOD__T_LCLIST__len, obj
#line 971 "filter/f-inst.c"

#line 971
    );
#line 971
  }
#line 971

#line 1007 "filter/f-inst.c"
 /* Method constructor for FI_NET_SRC */
#line 1007
struct f_inst * NONNULL(1)
#line 1007
f_new_method_FI_NET_SRC(struct f_inst *obj, struct f_inst *args)
#line 1007
  {
#line 1007
    /* Unwind the arguments (1) */
#line 1007
        if (args) cf_error("Too many arguments");
#line 973 "filter/f-inst.c"

#line 973

    return f_new_inst(FI_NET_SRC, obj
#line 1007 "filter/f-inst.c"

#line 1007
    );
#line 1007
  }
#line 1007

#line 1044 "filter/f-inst.c"
 /* Method constructor for FI_NET_DST */
#line 1044
struct f_inst * NONNULL(1)
#line 1044
f_new_method_FI_NET_DST(struct f_inst *obj, struct f_inst *args)
#line 1044
  {
#line 1044
    /* Unwind the arguments (1) */
#line 1044
        if (args) cf_error("Too many arguments");
#line 1009 "filter/f-inst.c"

#line 1009

    return f_new_inst(FI_NET_DST, obj
#line 1044 "filter/f-inst.c"

#line 1044
    );
#line 1044
  }
#line 1044

#line 1054 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_NET__maxlen */
#line 1054
struct f_inst * NONNULL(1)
#line 1054
f_new_method_FI_METHOD__T_NET__maxlen(struct f_inst *obj, struct f_inst *args)
#line 1054
  {
#line 1054
    /* Unwind the arguments (1) */
#line 1054
        if (args) cf_error("Too many arguments");
#line 1044 "filter/f-inst.c"

#line 1044

    return f_new_inst(FI_METHOD__T_NET__maxlen, obj
#line 1054 "filter/f-inst.c"

#line 1054
    );
#line 1054
  }
#line 1054

#line 1064 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_NET__asn */
#line 1064
struct f_inst * NONNULL(1)
#line 1064
f_new_method_FI_METHOD__T_NET__asn(struct f_inst *obj, struct f_inst *args)
#line 1064
  {
#line 1064
    /* Unwind the arguments (1) */
#line 1064
        if (args) cf_error("Too many arguments");
#line 1054 "filter/f-inst.c"

#line 1054

    return f_new_inst(FI_METHOD__T_NET__asn, obj
#line 1064 "filter/f-inst.c"

#line 1064
    );
#line 1064
  }
#line 1064

#line 1066 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_NET__ip */
#line 1066
struct f_inst * NONNULL(1)
#line 1066
f_new_method_FI_METHOD__T_NET__ip(struct f_inst *obj, struct f_inst *args)
#line 1066
  {
#line 1066
    /* Unwind the arguments (1) */
#line 1066
        if (args) cf_error("Too many arguments");
#line 1064 "filter/f-inst.c"

#line 1064

    return f_new_inst(FI_METHOD__T_NET__ip, obj
#line 1066 "filter/f-inst.c"

#line 1066
    );
#line 1066
  }
#line 1066

#line 1075 "filter/f-inst.c"
 /* Method constructor for FI_ROUTE_DISTINGUISHER */
#line 1075
struct f_inst * NONNULL(1)
#line 1075
f_new_method_FI_ROUTE_DISTINGUISHER(struct f_inst *obj, struct f_inst *args)
#line 1075
  {
#line 1075
    /* Unwind the arguments (1) */
#line 1075
        if (args) cf_error("Too many arguments");
#line 1068 "filter/f-inst.c"

#line 1068

    return f_new_inst(FI_ROUTE_DISTINGUISHER, obj
#line 1075 "filter/f-inst.c"

#line 1075
    );
#line 1075
  }
#line 1075

#line 1078 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PATH__first */
#line 1078
struct f_inst * NONNULL(1)
#line 1078
f_new_method_FI_METHOD__T_PATH__first(struct f_inst *obj, struct f_inst *args)
#line 1078
  {
#line 1078
    /* Unwind the arguments (1) */
#line 1078
        if (args) cf_error("Too many arguments");
#line 1075 "filter/f-inst.c"

#line 1075

    return f_new_inst(FI_METHOD__T_PATH__first, obj
#line 1078 "filter/f-inst.c"

#line 1078
    );
#line 1078
  }
#line 1078

#line 1081 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PATH__last */
#line 1081
struct f_inst * NONNULL(1)
#line 1081
f_new_method_FI_METHOD__T_PATH__last(struct f_inst *obj, struct f_inst *args)
#line 1081
  {
#line 1081
    /* Unwind the arguments (1) */
#line 1081
        if (args) cf_error("Too many arguments");
#line 1078 "filter/f-inst.c"

#line 1078

    return f_new_inst(FI_METHOD__T_PATH__last, obj
#line 1081 "filter/f-inst.c"

#line 1081
    );
#line 1081
  }
#line 1081

#line 1084 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PATH__last_nonaggregated */
#line 1084
struct f_inst * NONNULL(1)
#line 1084
f_new_method_FI_METHOD__T_PATH__last_nonaggregated(struct f_inst *obj, struct f_inst *args)
#line 1084
  {
#line 1084
    /* Unwind the arguments (1) */
#line 1084
        if (args) cf_error("Too many arguments");
#line 1081 "filter/f-inst.c"

#line 1081

    return f_new_inst(FI_METHOD__T_PATH__last_nonaggregated, obj
#line 1084 "filter/f-inst.c"

#line 1084
    );
#line 1084
  }
#line 1084

#line 1087 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PAIR__asn */
#line 1087
struct f_inst * NONNULL(1)
#line 1087
f_new_method_FI_METHOD__T_PAIR__asn(struct f_inst *obj, struct f_inst *args)
#line 1087
  {
#line 1087
    /* Unwind the arguments (1) */
#line 1087
        if (args) cf_error("Too many arguments");
#line 1084 "filter/f-inst.c"

#line 1084

    return f_new_inst(FI_METHOD__T_PAIR__asn, obj
#line 1087 "filter/f-inst.c"

#line 1087
    );
#line 1087
  }
#line 1087

#line 1090 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_PAIR__data */
#line 1090
struct f_inst * NONNULL(1)
#line 1090
f_new_method_FI_METHOD__T_PAIR__data(struct f_inst *obj, struct f_inst *args)
#line 1090
  {
#line 1090
    /* Unwind the arguments (1) */
#line 1090
        if (args) cf_error("Too many arguments");
#line 1087 "filter/f-inst.c"

#line 1087

    return f_new_inst(FI_METHOD__T_PAIR__data, obj
#line 1090 "filter/f-inst.c"

#line 1090
    );
#line 1090
  }
#line 1090

#line 1093 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LC__asn */
#line 1093
struct f_inst * NONNULL(1)
#line 1093
f_new_method_FI_METHOD__T_LC__asn(struct f_inst *obj, struct f_inst *args)
#line 1093
  {
#line 1093
    /* Unwind the arguments (1) */
#line 1093
        if (args) cf_error("Too many arguments");
#line 1090 "filter/f-inst.c"

#line 1090

    return f_new_inst(FI_METHOD__T_LC__asn, obj
#line 1093 "filter/f-inst.c"

#line 1093
    );
#line 1093
  }
#line 1093

#line 1096 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LC__data1 */
#line 1096
struct f_inst * NONNULL(1)
#line 1096
f_new_method_FI_METHOD__T_LC__data1(struct f_inst *obj, struct f_inst *args)
#line 1096
  {
#line 1096
    /* Unwind the arguments (1) */
#line 1096
        if (args) cf_error("Too many arguments");
#line 1093 "filter/f-inst.c"

#line 1093

    return f_new_inst(FI_METHOD__T_LC__data1, obj
#line 1096 "filter/f-inst.c"

#line 1096
    );
#line 1096
  }
#line 1096

#line 1099 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LC__data2 */
#line 1099
struct f_inst * NONNULL(1)
#line 1099
f_new_method_FI_METHOD__T_LC__data2(struct f_inst *obj, struct f_inst *args)
#line 1099
  {
#line 1099
    /* Unwind the arguments (1) */
#line 1099
        if (args) cf_error("Too many arguments");
#line 1096 "filter/f-inst.c"

#line 1096

    return f_new_inst(FI_METHOD__T_LC__data2, obj
#line 1099 "filter/f-inst.c"

#line 1099
    );
#line 1099
  }
#line 1099

#line 1102 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_CLIST__min */
#line 1102
struct f_inst * NONNULL(1)
#line 1102
f_new_method_FI_METHOD__T_CLIST__min(struct f_inst *obj, struct f_inst *args)
#line 1102
  {
#line 1102
    /* Unwind the arguments (1) */
#line 1102
        if (args) cf_error("Too many arguments");
#line 1099 "filter/f-inst.c"

#line 1099

    return f_new_inst(FI_METHOD__T_CLIST__min, obj
#line 1102 "filter/f-inst.c"

#line 1102
    );
#line 1102
  }
#line 1102

#line 1105 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_CLIST__max */
#line 1105
struct f_inst * NONNULL(1)
#line 1105
f_new_method_FI_METHOD__T_CLIST__max(struct f_inst *obj, struct f_inst *args)
#line 1105
  {
#line 1105
    /* Unwind the arguments (1) */
#line 1105
        if (args) cf_error("Too many arguments");
#line 1102 "filter/f-inst.c"

#line 1102

    return f_new_inst(FI_METHOD__T_CLIST__max, obj
#line 1105 "filter/f-inst.c"

#line 1105
    );
#line 1105
  }
#line 1105

#line 1108 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_ECLIST__min */
#line 1108
struct f_inst * NONNULL(1)
#line 1108
f_new_method_FI_METHOD__T_ECLIST__min(struct f_inst *obj, struct f_inst *args)
#line 1108
  {
#line 1108
    /* Unwind the arguments (1) */
#line 1108
        if (args) cf_error("Too many arguments");
#line 1105 "filter/f-inst.c"

#line 1105

    return f_new_inst(FI_METHOD__T_ECLIST__min, obj
#line 1108 "filter/f-inst.c"

#line 1108
    );
#line 1108
  }
#line 1108

#line 1111 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_ECLIST__max */
#line 1111
struct f_inst * NONNULL(1)
#line 1111
f_new_method_FI_METHOD__T_ECLIST__max(struct f_inst *obj, struct f_inst *args)
#line 1111
  {
#line 1111
    /* Unwind the arguments (1) */
#line 1111
        if (args) cf_error("Too many arguments");
#line 1108 "filter/f-inst.c"

#line 1108

    return f_new_inst(FI_METHOD__T_ECLIST__max, obj
#line 1111 "filter/f-inst.c"

#line 1111
    );
#line 1111
  }
#line 1111

#line 1114 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LCLIST__min */
#line 1114
struct f_inst * NONNULL(1)
#line 1114
f_new_method_FI_METHOD__T_LCLIST__min(struct f_inst *obj, struct f_inst *args)
#line 1114
  {
#line 1114
    /* Unwind the arguments (1) */
#line 1114
        if (args) cf_error("Too many arguments");
#line 1111 "filter/f-inst.c"

#line 1111

    return f_new_inst(FI_METHOD__T_LCLIST__min, obj
#line 1114 "filter/f-inst.c"

#line 1114
    );
#line 1114
  }
#line 1114

#line 1116 "filter/f-inst.c"
 /* Method constructor for FI_METHOD__T_LCLIST__max */
#line 1116
struct f_inst * NONNULL(1)
#line 1116
f_new_method_FI_METHOD__T_LCLIST__max(struct f_inst *obj, struct f_inst *args)
#line 1116
  {
#line 1116
    /* Unwind the arguments (1) */
#line 1116
        if (args) cf_error("Too many arguments");
#line 1114 "filter/f-inst.c"

#line 1114

    return f_new_inst(FI_METHOD__T_LCLIST__max, obj
#line 1116 "filter/f-inst.c"

#line 1116
    );
#line 1116
  }
#line 1116

#line 1142 "filter/f-inst.c"

#line 1202 "filter/f-inst.c"

#line 1207 "filter/f-inst.c"

#line 1248 "filter/f-inst.c"

#line 1257 "filter/f-inst.c"
 /* Method constructor for FI_IP_MASK */
#line 1257
struct f_inst * NONNULL(1)
#line 1257
f_new_method_FI_IP_MASK(struct f_inst *obj, struct f_inst *args)
#line 1257
  {
#line 1257
    /* Unwind the arguments (2) */
#line 1257
    #line 1250 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1250
  if (args == NULL) cf_error("Not enough arguments"); /* FI_IP_MASK */
#line 1250
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1251 "filter/f-inst.c"

#line 1251

    return f_new_inst(FI_IP_MASK, obj
#line 1250 "filter/f-inst.c"
    , arg2
#line 1257 "filter/f-inst.c"

#line 1257
    );
#line 1257
  }
#line 1257

#line 1265 "filter/f-inst.c"
 /* Method constructor for FI_PATH_PREPEND */
#line 1265
struct f_inst * NONNULL(1)
#line 1265
f_new_method_FI_PATH_PREPEND(struct f_inst *obj, struct f_inst *args)
#line 1265
  {
#line 1265
    /* Unwind the arguments (2) */
#line 1265
    #line 1259 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1259
  if (args == NULL) cf_error("Not enough arguments"); /* FI_PATH_PREPEND */
#line 1259
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1260 "filter/f-inst.c"

#line 1260

    return f_new_inst(FI_PATH_PREPEND, obj
#line 1259 "filter/f-inst.c"
    , arg2
#line 1265 "filter/f-inst.c"

#line 1265
    );
#line 1265
  }
#line 1265

#line 1272 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_ADD_PAIR */
#line 1272
struct f_inst * NONNULL(1)
#line 1272
f_new_method_FI_CLIST_ADD_PAIR(struct f_inst *obj, struct f_inst *args)
#line 1272
  {
#line 1272
    /* Unwind the arguments (2) */
#line 1272
    #line 1267 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1267
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_ADD_PAIR */
#line 1267
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1268 "filter/f-inst.c"

#line 1268

    return f_new_inst(FI_CLIST_ADD_PAIR, obj
#line 1267 "filter/f-inst.c"
    , arg2
#line 1272 "filter/f-inst.c"

#line 1272
    );
#line 1272
  }
#line 1272

#line 1286 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_ADD_IP */
#line 1286
struct f_inst * NONNULL(1)
#line 1286
f_new_method_FI_CLIST_ADD_IP(struct f_inst *obj, struct f_inst *args)
#line 1286
  {
#line 1286
    /* Unwind the arguments (2) */
#line 1286
    #line 1274 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1274
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_ADD_IP */
#line 1274
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1275 "filter/f-inst.c"

#line 1275

    return f_new_inst(FI_CLIST_ADD_IP, obj
#line 1274 "filter/f-inst.c"
    , arg2
#line 1286 "filter/f-inst.c"

#line 1286
    );
#line 1286
  }
#line 1286

#line 1293 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_ADD_QUAD */
#line 1293
struct f_inst * NONNULL(1)
#line 1293
f_new_method_FI_CLIST_ADD_QUAD(struct f_inst *obj, struct f_inst *args)
#line 1293
  {
#line 1293
    /* Unwind the arguments (2) */
#line 1293
    #line 1288 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1288
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_ADD_QUAD */
#line 1288
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1289 "filter/f-inst.c"

#line 1289

    return f_new_inst(FI_CLIST_ADD_QUAD, obj
#line 1288 "filter/f-inst.c"
    , arg2
#line 1293 "filter/f-inst.c"

#line 1293
    );
#line 1293
  }
#line 1293

#line 1300 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_ADD_CLIST */
#line 1300
struct f_inst * NONNULL(1)
#line 1300
f_new_method_FI_CLIST_ADD_CLIST(struct f_inst *obj, struct f_inst *args)
#line 1300
  {
#line 1300
    /* Unwind the arguments (2) */
#line 1300
    #line 1295 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1295
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_ADD_CLIST */
#line 1295
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1296 "filter/f-inst.c"

#line 1296

    return f_new_inst(FI_CLIST_ADD_CLIST, obj
#line 1295 "filter/f-inst.c"
    , arg2
#line 1300 "filter/f-inst.c"

#line 1300
    );
#line 1300
  }
#line 1300

#line 1307 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_ADD_EC */
#line 1307
struct f_inst * NONNULL(1)
#line 1307
f_new_method_FI_ECLIST_ADD_EC(struct f_inst *obj, struct f_inst *args)
#line 1307
  {
#line 1307
    /* Unwind the arguments (2) */
#line 1307
    #line 1302 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1302
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_ADD_EC */
#line 1302
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1303 "filter/f-inst.c"

#line 1303

    return f_new_inst(FI_ECLIST_ADD_EC, obj
#line 1302 "filter/f-inst.c"
    , arg2
#line 1307 "filter/f-inst.c"

#line 1307
    );
#line 1307
  }
#line 1307

#line 1314 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_ADD_ECLIST */
#line 1314
struct f_inst * NONNULL(1)
#line 1314
f_new_method_FI_ECLIST_ADD_ECLIST(struct f_inst *obj, struct f_inst *args)
#line 1314
  {
#line 1314
    /* Unwind the arguments (2) */
#line 1314
    #line 1309 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1309
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_ADD_ECLIST */
#line 1309
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1310 "filter/f-inst.c"

#line 1310

    return f_new_inst(FI_ECLIST_ADD_ECLIST, obj
#line 1309 "filter/f-inst.c"
    , arg2
#line 1314 "filter/f-inst.c"

#line 1314
    );
#line 1314
  }
#line 1314

#line 1321 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_ADD_LC */
#line 1321
struct f_inst * NONNULL(1)
#line 1321
f_new_method_FI_LCLIST_ADD_LC(struct f_inst *obj, struct f_inst *args)
#line 1321
  {
#line 1321
    /* Unwind the arguments (2) */
#line 1321
    #line 1316 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1316
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_ADD_LC */
#line 1316
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1317 "filter/f-inst.c"

#line 1317

    return f_new_inst(FI_LCLIST_ADD_LC, obj
#line 1316 "filter/f-inst.c"
    , arg2
#line 1321 "filter/f-inst.c"

#line 1321
    );
#line 1321
  }
#line 1321

#line 1328 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_ADD_LCLIST */
#line 1328
struct f_inst * NONNULL(1)
#line 1328
f_new_method_FI_LCLIST_ADD_LCLIST(struct f_inst *obj, struct f_inst *args)
#line 1328
  {
#line 1328
    /* Unwind the arguments (2) */
#line 1328
    #line 1323 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1323
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_ADD_LCLIST */
#line 1323
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1324 "filter/f-inst.c"

#line 1324

    return f_new_inst(FI_LCLIST_ADD_LCLIST, obj
#line 1323 "filter/f-inst.c"
    , arg2
#line 1328 "filter/f-inst.c"

#line 1328
    );
#line 1328
  }
#line 1328

#line 1335 "filter/f-inst.c"
 /* Method constructor for FI_PATH_DELETE_INT */
#line 1335
struct f_inst * NONNULL(1)
#line 1335
f_new_method_FI_PATH_DELETE_INT(struct f_inst *obj, struct f_inst *args)
#line 1335
  {
#line 1335
    /* Unwind the arguments (2) */
#line 1335
    #line 1330 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1330
  if (args == NULL) cf_error("Not enough arguments"); /* FI_PATH_DELETE_INT */
#line 1330
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1331 "filter/f-inst.c"

#line 1331

    return f_new_inst(FI_PATH_DELETE_INT, obj
#line 1330 "filter/f-inst.c"
    , arg2
#line 1335 "filter/f-inst.c"

#line 1335
    );
#line 1335
  }
#line 1335

#line 1347 "filter/f-inst.c"
 /* Method constructor for FI_PATH_DELETE_SET */
#line 1347
struct f_inst * NONNULL(1)
#line 1347
f_new_method_FI_PATH_DELETE_SET(struct f_inst *obj, struct f_inst *args)
#line 1347
  {
#line 1347
    /* Unwind the arguments (2) */
#line 1347
    #line 1337 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1337
  if (args == NULL) cf_error("Not enough arguments"); /* FI_PATH_DELETE_SET */
#line 1337
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1338 "filter/f-inst.c"

#line 1338

    return f_new_inst(FI_PATH_DELETE_SET, obj
#line 1337 "filter/f-inst.c"
    , arg2
#line 1347 "filter/f-inst.c"

#line 1347
    );
#line 1347
  }
#line 1347

#line 1354 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_DELETE_PAIR */
#line 1354
struct f_inst * NONNULL(1)
#line 1354
f_new_method_FI_CLIST_DELETE_PAIR(struct f_inst *obj, struct f_inst *args)
#line 1354
  {
#line 1354
    /* Unwind the arguments (2) */
#line 1354
    #line 1349 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1349
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_DELETE_PAIR */
#line 1349
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1350 "filter/f-inst.c"

#line 1350

    return f_new_inst(FI_CLIST_DELETE_PAIR, obj
#line 1349 "filter/f-inst.c"
    , arg2
#line 1354 "filter/f-inst.c"

#line 1354
    );
#line 1354
  }
#line 1354

#line 1368 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_DELETE_IP */
#line 1368
struct f_inst * NONNULL(1)
#line 1368
f_new_method_FI_CLIST_DELETE_IP(struct f_inst *obj, struct f_inst *args)
#line 1368
  {
#line 1368
    /* Unwind the arguments (2) */
#line 1368
    #line 1356 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1356
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_DELETE_IP */
#line 1356
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1357 "filter/f-inst.c"

#line 1357

    return f_new_inst(FI_CLIST_DELETE_IP, obj
#line 1356 "filter/f-inst.c"
    , arg2
#line 1368 "filter/f-inst.c"

#line 1368
    );
#line 1368
  }
#line 1368

#line 1375 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_DELETE_QUAD */
#line 1375
struct f_inst * NONNULL(1)
#line 1375
f_new_method_FI_CLIST_DELETE_QUAD(struct f_inst *obj, struct f_inst *args)
#line 1375
  {
#line 1375
    /* Unwind the arguments (2) */
#line 1375
    #line 1370 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1370
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_DELETE_QUAD */
#line 1370
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1371 "filter/f-inst.c"

#line 1371

    return f_new_inst(FI_CLIST_DELETE_QUAD, obj
#line 1370 "filter/f-inst.c"
    , arg2
#line 1375 "filter/f-inst.c"

#line 1375
    );
#line 1375
  }
#line 1375

#line 1382 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_DELETE_CLIST */
#line 1382
struct f_inst * NONNULL(1)
#line 1382
f_new_method_FI_CLIST_DELETE_CLIST(struct f_inst *obj, struct f_inst *args)
#line 1382
  {
#line 1382
    /* Unwind the arguments (2) */
#line 1382
    #line 1377 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1377
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_DELETE_CLIST */
#line 1377
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1378 "filter/f-inst.c"

#line 1378

    return f_new_inst(FI_CLIST_DELETE_CLIST, obj
#line 1377 "filter/f-inst.c"
    , arg2
#line 1382 "filter/f-inst.c"

#line 1382
    );
#line 1382
  }
#line 1382

#line 1393 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_DELETE_SET */
#line 1393
struct f_inst * NONNULL(1)
#line 1393
f_new_method_FI_CLIST_DELETE_SET(struct f_inst *obj, struct f_inst *args)
#line 1393
  {
#line 1393
    /* Unwind the arguments (2) */
#line 1393
    #line 1384 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1384
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_DELETE_SET */
#line 1384
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1385 "filter/f-inst.c"

#line 1385

    return f_new_inst(FI_CLIST_DELETE_SET, obj
#line 1384 "filter/f-inst.c"
    , arg2
#line 1393 "filter/f-inst.c"

#line 1393
    );
#line 1393
  }
#line 1393

#line 1400 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_DELETE_EC */
#line 1400
struct f_inst * NONNULL(1)
#line 1400
f_new_method_FI_ECLIST_DELETE_EC(struct f_inst *obj, struct f_inst *args)
#line 1400
  {
#line 1400
    /* Unwind the arguments (2) */
#line 1400
    #line 1395 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1395
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_DELETE_EC */
#line 1395
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1396 "filter/f-inst.c"

#line 1396

    return f_new_inst(FI_ECLIST_DELETE_EC, obj
#line 1395 "filter/f-inst.c"
    , arg2
#line 1400 "filter/f-inst.c"

#line 1400
    );
#line 1400
  }
#line 1400

#line 1407 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_DELETE_ECLIST */
#line 1407
struct f_inst * NONNULL(1)
#line 1407
f_new_method_FI_ECLIST_DELETE_ECLIST(struct f_inst *obj, struct f_inst *args)
#line 1407
  {
#line 1407
    /* Unwind the arguments (2) */
#line 1407
    #line 1402 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1402
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_DELETE_ECLIST */
#line 1402
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1403 "filter/f-inst.c"

#line 1403

    return f_new_inst(FI_ECLIST_DELETE_ECLIST, obj
#line 1402 "filter/f-inst.c"
    , arg2
#line 1407 "filter/f-inst.c"

#line 1407
    );
#line 1407
  }
#line 1407

#line 1418 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_DELETE_SET */
#line 1418
struct f_inst * NONNULL(1)
#line 1418
f_new_method_FI_ECLIST_DELETE_SET(struct f_inst *obj, struct f_inst *args)
#line 1418
  {
#line 1418
    /* Unwind the arguments (2) */
#line 1418
    #line 1409 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1409
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_DELETE_SET */
#line 1409
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1410 "filter/f-inst.c"

#line 1410

    return f_new_inst(FI_ECLIST_DELETE_SET, obj
#line 1409 "filter/f-inst.c"
    , arg2
#line 1418 "filter/f-inst.c"

#line 1418
    );
#line 1418
  }
#line 1418

#line 1425 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_DELETE_LC */
#line 1425
struct f_inst * NONNULL(1)
#line 1425
f_new_method_FI_LCLIST_DELETE_LC(struct f_inst *obj, struct f_inst *args)
#line 1425
  {
#line 1425
    /* Unwind the arguments (2) */
#line 1425
    #line 1420 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1420
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_DELETE_LC */
#line 1420
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1421 "filter/f-inst.c"

#line 1421

    return f_new_inst(FI_LCLIST_DELETE_LC, obj
#line 1420 "filter/f-inst.c"
    , arg2
#line 1425 "filter/f-inst.c"

#line 1425
    );
#line 1425
  }
#line 1425

#line 1432 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_DELETE_LCLIST */
#line 1432
struct f_inst * NONNULL(1)
#line 1432
f_new_method_FI_LCLIST_DELETE_LCLIST(struct f_inst *obj, struct f_inst *args)
#line 1432
  {
#line 1432
    /* Unwind the arguments (2) */
#line 1432
    #line 1427 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1427
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_DELETE_LCLIST */
#line 1427
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1428 "filter/f-inst.c"

#line 1428

    return f_new_inst(FI_LCLIST_DELETE_LCLIST, obj
#line 1427 "filter/f-inst.c"
    , arg2
#line 1432 "filter/f-inst.c"

#line 1432
    );
#line 1432
  }
#line 1432

#line 1443 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_DELETE_SET */
#line 1443
struct f_inst * NONNULL(1)
#line 1443
f_new_method_FI_LCLIST_DELETE_SET(struct f_inst *obj, struct f_inst *args)
#line 1443
  {
#line 1443
    /* Unwind the arguments (2) */
#line 1443
    #line 1434 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1434
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_DELETE_SET */
#line 1434
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1435 "filter/f-inst.c"

#line 1435

    return f_new_inst(FI_LCLIST_DELETE_SET, obj
#line 1434 "filter/f-inst.c"
    , arg2
#line 1443 "filter/f-inst.c"

#line 1443
    );
#line 1443
  }
#line 1443

#line 1454 "filter/f-inst.c"
 /* Method constructor for FI_PATH_FILTER_SET */
#line 1454
struct f_inst * NONNULL(1)
#line 1454
f_new_method_FI_PATH_FILTER_SET(struct f_inst *obj, struct f_inst *args)
#line 1454
  {
#line 1454
    /* Unwind the arguments (2) */
#line 1454
    #line 1445 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1445
  if (args == NULL) cf_error("Not enough arguments"); /* FI_PATH_FILTER_SET */
#line 1445
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1446 "filter/f-inst.c"

#line 1446

    return f_new_inst(FI_PATH_FILTER_SET, obj
#line 1445 "filter/f-inst.c"
    , arg2
#line 1454 "filter/f-inst.c"

#line 1454
    );
#line 1454
  }
#line 1454

#line 1461 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_FILTER_CLIST */
#line 1461
struct f_inst * NONNULL(1)
#line 1461
f_new_method_FI_CLIST_FILTER_CLIST(struct f_inst *obj, struct f_inst *args)
#line 1461
  {
#line 1461
    /* Unwind the arguments (2) */
#line 1461
    #line 1456 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1456
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_FILTER_CLIST */
#line 1456
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1457 "filter/f-inst.c"

#line 1457

    return f_new_inst(FI_CLIST_FILTER_CLIST, obj
#line 1456 "filter/f-inst.c"
    , arg2
#line 1461 "filter/f-inst.c"

#line 1461
    );
#line 1461
  }
#line 1461

#line 1472 "filter/f-inst.c"
 /* Method constructor for FI_CLIST_FILTER_SET */
#line 1472
struct f_inst * NONNULL(1)
#line 1472
f_new_method_FI_CLIST_FILTER_SET(struct f_inst *obj, struct f_inst *args)
#line 1472
  {
#line 1472
    /* Unwind the arguments (2) */
#line 1472
    #line 1463 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1463
  if (args == NULL) cf_error("Not enough arguments"); /* FI_CLIST_FILTER_SET */
#line 1463
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1464 "filter/f-inst.c"

#line 1464

    return f_new_inst(FI_CLIST_FILTER_SET, obj
#line 1463 "filter/f-inst.c"
    , arg2
#line 1472 "filter/f-inst.c"

#line 1472
    );
#line 1472
  }
#line 1472

#line 1479 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_FILTER_ECLIST */
#line 1479
struct f_inst * NONNULL(1)
#line 1479
f_new_method_FI_ECLIST_FILTER_ECLIST(struct f_inst *obj, struct f_inst *args)
#line 1479
  {
#line 1479
    /* Unwind the arguments (2) */
#line 1479
    #line 1474 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1474
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_FILTER_ECLIST */
#line 1474
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1475 "filter/f-inst.c"

#line 1475

    return f_new_inst(FI_ECLIST_FILTER_ECLIST, obj
#line 1474 "filter/f-inst.c"
    , arg2
#line 1479 "filter/f-inst.c"

#line 1479
    );
#line 1479
  }
#line 1479

#line 1490 "filter/f-inst.c"
 /* Method constructor for FI_ECLIST_FILTER_SET */
#line 1490
struct f_inst * NONNULL(1)
#line 1490
f_new_method_FI_ECLIST_FILTER_SET(struct f_inst *obj, struct f_inst *args)
#line 1490
  {
#line 1490
    /* Unwind the arguments (2) */
#line 1490
    #line 1481 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1481
  if (args == NULL) cf_error("Not enough arguments"); /* FI_ECLIST_FILTER_SET */
#line 1481
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1482 "filter/f-inst.c"

#line 1482

    return f_new_inst(FI_ECLIST_FILTER_SET, obj
#line 1481 "filter/f-inst.c"
    , arg2
#line 1490 "filter/f-inst.c"

#line 1490
    );
#line 1490
  }
#line 1490

#line 1497 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_FILTER_LCLIST */
#line 1497
struct f_inst * NONNULL(1)
#line 1497
f_new_method_FI_LCLIST_FILTER_LCLIST(struct f_inst *obj, struct f_inst *args)
#line 1497
  {
#line 1497
    /* Unwind the arguments (2) */
#line 1497
    #line 1492 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1492
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_FILTER_LCLIST */
#line 1492
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1493 "filter/f-inst.c"

#line 1493

    return f_new_inst(FI_LCLIST_FILTER_LCLIST, obj
#line 1492 "filter/f-inst.c"
    , arg2
#line 1497 "filter/f-inst.c"

#line 1497
    );
#line 1497
  }
#line 1497

#line 1508 "filter/f-inst.c"
 /* Method constructor for FI_LCLIST_FILTER_SET */
#line 1508
struct f_inst * NONNULL(1)
#line 1508
f_new_method_FI_LCLIST_FILTER_SET(struct f_inst *obj, struct f_inst *args)
#line 1508
  {
#line 1508
    /* Unwind the arguments (2) */
#line 1508
    #line 1499 "filter/f-inst.c"
  struct f_inst *arg2 = args;
#line 1499
  if (args == NULL) cf_error("Not enough arguments"); /* FI_LCLIST_FILTER_SET */
#line 1499
  args = args->next;
    if (args) cf_error("Too many arguments");
#line 1500 "filter/f-inst.c"

#line 1500

    return f_new_inst(FI_LCLIST_FILTER_SET, obj
#line 1499 "filter/f-inst.c"
    , arg2
#line 1508 "filter/f-inst.c"

#line 1508
    );
#line 1508
  }
#line 1508

#line 1530 "filter/f-inst.c"

#line 1546 "filter/f-inst.c"

#line 1561 "filter/f-inst.c"

#line 1566 "filter/f-inst.c"

#line 830 "filter/decl.m4"

#line 618 "filter/decl.m4"


#if defined(__GNUC__) && __GNUC__ >= 6
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Woverride-init"
#endif

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Winitializer-overrides"
#endif

static struct sym_scope f_type_method_scopes[] = {
#line 507 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_NET__type */
#line 507
  [T_NET] = {},
#line 510 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_IP__is_v4 */
#line 510
  [T_IP] = {},
#line 564 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PATH__empty */
#line 564
  [T_PATH] = {},
#line 565 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_CLIST__empty */
#line 565
  [T_CLIST] = {},
#line 566 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_ECLIST__empty */
#line 566
  [T_ECLIST] = {},
#line 569 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LCLIST__empty */
#line 569
  [T_LCLIST] = {},
#line 600 "filter/f-inst.c"
 /* Method scope initializator for FI_PATH_FOR_NEXT */
#line 600
  [T_PATH] = {},
#line 609 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_FOR_NEXT */
#line 609
  [T_CLIST] = {},
#line 618 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_FOR_NEXT */
#line 618
  [T_ECLIST] = {},
#line 627 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_FOR_NEXT */
#line 627
  [T_LCLIST] = {},
#line 640 "filter/f-inst.c"
 /* Method scope initializator for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
  [T_ROUTES_BLOCK] = {},
#line 966 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_NET__len */
#line 966
  [T_NET] = {},
#line 967 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PATH__len */
#line 967
  [T_PATH] = {},
#line 968 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_CLIST__len */
#line 968
  [T_CLIST] = {},
#line 969 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_ECLIST__len */
#line 969
  [T_ECLIST] = {},
#line 971 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LCLIST__len */
#line 971
  [T_LCLIST] = {},
#line 1007 "filter/f-inst.c"
 /* Method scope initializator for FI_NET_SRC */
#line 1007
  [T_NET] = {},
#line 1044 "filter/f-inst.c"
 /* Method scope initializator for FI_NET_DST */
#line 1044
  [T_NET] = {},
#line 1054 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_NET__maxlen */
#line 1054
  [T_NET] = {},
#line 1064 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_NET__asn */
#line 1064
  [T_NET] = {},
#line 1066 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_NET__ip */
#line 1066
  [T_NET] = {},
#line 1075 "filter/f-inst.c"
 /* Method scope initializator for FI_ROUTE_DISTINGUISHER */
#line 1075
  [T_NET] = {},
#line 1078 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PATH__first */
#line 1078
  [T_PATH] = {},
#line 1081 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PATH__last */
#line 1081
  [T_PATH] = {},
#line 1084 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PATH__last_nonaggregated */
#line 1084
  [T_PATH] = {},
#line 1087 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PAIR__asn */
#line 1087
  [T_PAIR] = {},
#line 1090 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_PAIR__data */
#line 1090
  [T_PAIR] = {},
#line 1093 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LC__asn */
#line 1093
  [T_LC] = {},
#line 1096 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LC__data1 */
#line 1096
  [T_LC] = {},
#line 1099 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LC__data2 */
#line 1099
  [T_LC] = {},
#line 1102 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_CLIST__min */
#line 1102
  [T_CLIST] = {},
#line 1105 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_CLIST__max */
#line 1105
  [T_CLIST] = {},
#line 1108 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_ECLIST__min */
#line 1108
  [T_ECLIST] = {},
#line 1111 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_ECLIST__max */
#line 1111
  [T_ECLIST] = {},
#line 1114 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LCLIST__min */
#line 1114
  [T_LCLIST] = {},
#line 1116 "filter/f-inst.c"
 /* Method scope initializator for FI_METHOD__T_LCLIST__max */
#line 1116
  [T_LCLIST] = {},
#line 1257 "filter/f-inst.c"
 /* Method scope initializator for FI_IP_MASK */
#line 1257
  [T_IP] = {},
#line 1265 "filter/f-inst.c"
 /* Method scope initializator for FI_PATH_PREPEND */
#line 1265
  [T_PATH] = {},
#line 1272 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_ADD_PAIR */
#line 1272
  [T_CLIST] = {},
#line 1286 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_ADD_IP */
#line 1286
  [T_CLIST] = {},
#line 1293 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_ADD_QUAD */
#line 1293
  [T_CLIST] = {},
#line 1300 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_ADD_CLIST */
#line 1300
  [T_CLIST] = {},
#line 1307 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_ADD_EC */
#line 1307
  [T_ECLIST] = {},
#line 1314 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_ADD_ECLIST */
#line 1314
  [T_ECLIST] = {},
#line 1321 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_ADD_LC */
#line 1321
  [T_LCLIST] = {},
#line 1328 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_ADD_LCLIST */
#line 1328
  [T_LCLIST] = {},
#line 1335 "filter/f-inst.c"
 /* Method scope initializator for FI_PATH_DELETE_INT */
#line 1335
  [T_PATH] = {},
#line 1347 "filter/f-inst.c"
 /* Method scope initializator for FI_PATH_DELETE_SET */
#line 1347
  [T_PATH] = {},
#line 1354 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_DELETE_PAIR */
#line 1354
  [T_CLIST] = {},
#line 1368 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_DELETE_IP */
#line 1368
  [T_CLIST] = {},
#line 1375 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_DELETE_QUAD */
#line 1375
  [T_CLIST] = {},
#line 1382 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_DELETE_CLIST */
#line 1382
  [T_CLIST] = {},
#line 1393 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_DELETE_SET */
#line 1393
  [T_CLIST] = {},
#line 1400 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_DELETE_EC */
#line 1400
  [T_ECLIST] = {},
#line 1407 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_DELETE_ECLIST */
#line 1407
  [T_ECLIST] = {},
#line 1418 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_DELETE_SET */
#line 1418
  [T_ECLIST] = {},
#line 1425 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_DELETE_LC */
#line 1425
  [T_LCLIST] = {},
#line 1432 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_DELETE_LCLIST */
#line 1432
  [T_LCLIST] = {},
#line 1443 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_DELETE_SET */
#line 1443
  [T_LCLIST] = {},
#line 1454 "filter/f-inst.c"
 /* Method scope initializator for FI_PATH_FILTER_SET */
#line 1454
  [T_PATH] = {},
#line 1461 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_FILTER_CLIST */
#line 1461
  [T_CLIST] = {},
#line 1472 "filter/f-inst.c"
 /* Method scope initializator for FI_CLIST_FILTER_SET */
#line 1472
  [T_CLIST] = {},
#line 1479 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_FILTER_ECLIST */
#line 1479
  [T_ECLIST] = {},
#line 1490 "filter/f-inst.c"
 /* Method scope initializator for FI_ECLIST_FILTER_SET */
#line 1490
  [T_ECLIST] = {},
#line 1497 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_FILTER_LCLIST */
#line 1497
  [T_LCLIST] = {},
#line 1508 "filter/f-inst.c"
 /* Method scope initializator for FI_LCLIST_FILTER_SET */
#line 1508
  [T_LCLIST] = {},
#line 631 "filter/decl.m4"

};

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#if defined(__GNUC__) && __GNUC__ >= 6
#pragma GCC diagnostic pop
#endif

struct sym_scope *f_type_method_scope(enum btype t)
{
  return (t < ARRAY_SIZE(f_type_method_scopes)) ? &f_type_method_scopes[t] : NULL;
}

static void
f_register_method(enum btype t, const byte *name, struct f_method *dsc)
{
  struct sym_scope *scope = &f_type_method_scopes[t];
  struct symbol *sym = cf_find_symbol_scope(scope, name);

  if (!sym)
  {
    sym = cf_root_symbol(name, scope);
    sym->class = SYM_METHOD;
  }

  dsc->sym = sym;
  dsc->next = sym->method;
  sym->method = dsc;
}

extern struct sym_scope global_filter_scope;

void f_type_methods_register(void)
{
  struct f_method *method;

#line 507 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_NET__type */
#line 507
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 507
  method->new_inst = f_new_method_FI_METHOD__T_NET__type;
#line 507
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 507 "filter/f-inst.c"

#line 507
  f_register_method(T_NET, "type", method);
#line 507

#line 507

#line 510 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_IP__is_v4 */
#line 510
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 510
  method->new_inst = f_new_method_FI_METHOD__T_IP__is_v4;
#line 510
  method->arg_num = 1;
  method->args_type[0] = T_IP;
#line 510 "filter/f-inst.c"

#line 510
  f_register_method(T_IP, "is_v4", method);
#line 510

#line 510

#line 564 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PATH__empty */
#line 564
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 564
  method->new_inst = f_new_method_FI_METHOD__T_PATH__empty;
#line 564
  method->arg_num = 1;
  method->args_type[0] = T_PATH;
#line 564 "filter/f-inst.c"

#line 564
  f_register_method(T_PATH, "empty", method);
#line 564

#line 564

#line 565 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_CLIST__empty */
#line 565
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 565
  method->new_inst = f_new_method_FI_METHOD__T_CLIST__empty;
#line 565
  method->arg_num = 1;
  method->args_type[0] = T_CLIST;
#line 565 "filter/f-inst.c"

#line 565
  f_register_method(T_CLIST, "empty", method);
#line 565

#line 565

#line 566 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_ECLIST__empty */
#line 566
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 566
  method->new_inst = f_new_method_FI_METHOD__T_ECLIST__empty;
#line 566
  method->arg_num = 1;
  method->args_type[0] = T_ECLIST;
#line 566 "filter/f-inst.c"

#line 566
  f_register_method(T_ECLIST, "empty", method);
#line 566

#line 566

#line 569 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LCLIST__empty */
#line 569
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 569
  method->new_inst = f_new_method_FI_METHOD__T_LCLIST__empty;
#line 569
  method->arg_num = 1;
  method->args_type[0] = T_LCLIST;
#line 569 "filter/f-inst.c"

#line 569
  f_register_method(T_LCLIST, "empty", method);
#line 569

#line 569

#line 600 "filter/f-inst.c"
 /* Method registrator for FI_PATH_FOR_NEXT */
#line 600
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 600
  method->new_inst = f_new_method_FI_PATH_FOR_NEXT;
#line 600
  method->arg_num = 2;
  method->args_type[0] = T_PATH;
#line 600 "filter/f-inst.c"

#line 600
  f_register_method(T_PATH, "!for_next", method);
#line 600

#line 600

#line 609 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_FOR_NEXT */
#line 609
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 609
  method->new_inst = f_new_method_FI_CLIST_FOR_NEXT;
#line 609
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
#line 609 "filter/f-inst.c"

#line 609
  f_register_method(T_CLIST, "!for_next", method);
#line 609

#line 609

#line 618 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_FOR_NEXT */
#line 618
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 618
  method->new_inst = f_new_method_FI_ECLIST_FOR_NEXT;
#line 618
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
#line 618 "filter/f-inst.c"

#line 618
  f_register_method(T_ECLIST, "!for_next", method);
#line 618

#line 618

#line 627 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_FOR_NEXT */
#line 627
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 627
  method->new_inst = f_new_method_FI_LCLIST_FOR_NEXT;
#line 627
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
#line 627 "filter/f-inst.c"

#line 627
  f_register_method(T_LCLIST, "!for_next", method);
#line 627

#line 627

#line 640 "filter/f-inst.c"
 /* Method registrator for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 640
  method->new_inst = f_new_method_FI_ROUTES_BLOCK_FOR_NEXT;
#line 640
  method->arg_num = 2;
  method->args_type[0] = T_ROUTES_BLOCK;
#line 640 "filter/f-inst.c"

#line 640
  f_register_method(T_ROUTES_BLOCK, "!for_next", method);
#line 640

#line 640

#line 966 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_NET__len */
#line 966
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 966
  method->new_inst = f_new_method_FI_METHOD__T_NET__len;
#line 966
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 966 "filter/f-inst.c"

#line 966
  f_register_method(T_NET, "len", method);
#line 966

#line 966

#line 967 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PATH__len */
#line 967
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 967
  method->new_inst = f_new_method_FI_METHOD__T_PATH__len;
#line 967
  method->arg_num = 1;
  method->args_type[0] = T_PATH;
#line 967 "filter/f-inst.c"

#line 967
  f_register_method(T_PATH, "len", method);
#line 967

#line 967

#line 968 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_CLIST__len */
#line 968
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 968
  method->new_inst = f_new_method_FI_METHOD__T_CLIST__len;
#line 968
  method->arg_num = 1;
  method->args_type[0] = T_CLIST;
#line 968 "filter/f-inst.c"

#line 968
  f_register_method(T_CLIST, "len", method);
#line 968

#line 968

#line 969 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_ECLIST__len */
#line 969
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 969
  method->new_inst = f_new_method_FI_METHOD__T_ECLIST__len;
#line 969
  method->arg_num = 1;
  method->args_type[0] = T_ECLIST;
#line 969 "filter/f-inst.c"

#line 969
  f_register_method(T_ECLIST, "len", method);
#line 969

#line 969

#line 971 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LCLIST__len */
#line 971
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 971
  method->new_inst = f_new_method_FI_METHOD__T_LCLIST__len;
#line 971
  method->arg_num = 1;
  method->args_type[0] = T_LCLIST;
#line 971 "filter/f-inst.c"

#line 971
  f_register_method(T_LCLIST, "len", method);
#line 971

#line 971

#line 1007 "filter/f-inst.c"
 /* Method registrator for FI_NET_SRC */
#line 1007
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1007
  method->new_inst = f_new_method_FI_NET_SRC;
#line 1007
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1007 "filter/f-inst.c"

#line 1007
  f_register_method(T_NET, "src", method);
#line 1007

#line 1007

#line 1044 "filter/f-inst.c"
 /* Method registrator for FI_NET_DST */
#line 1044
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1044
  method->new_inst = f_new_method_FI_NET_DST;
#line 1044
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1044 "filter/f-inst.c"

#line 1044
  f_register_method(T_NET, "dst", method);
#line 1044

#line 1044

#line 1054 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_NET__maxlen */
#line 1054
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1054
  method->new_inst = f_new_method_FI_METHOD__T_NET__maxlen;
#line 1054
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1054 "filter/f-inst.c"

#line 1054
  f_register_method(T_NET, "maxlen", method);
#line 1054

#line 1054

#line 1064 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_NET__asn */
#line 1064
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1064
  method->new_inst = f_new_method_FI_METHOD__T_NET__asn;
#line 1064
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1064 "filter/f-inst.c"

#line 1064
  f_register_method(T_NET, "asn", method);
#line 1064

#line 1064

#line 1066 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_NET__ip */
#line 1066
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1066
  method->new_inst = f_new_method_FI_METHOD__T_NET__ip;
#line 1066
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1066 "filter/f-inst.c"

#line 1066
  f_register_method(T_NET, "ip", method);
#line 1066

#line 1066

#line 1075 "filter/f-inst.c"
 /* Method registrator for FI_ROUTE_DISTINGUISHER */
#line 1075
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1075
  method->new_inst = f_new_method_FI_ROUTE_DISTINGUISHER;
#line 1075
  method->arg_num = 1;
  method->args_type[0] = T_NET;
#line 1075 "filter/f-inst.c"

#line 1075
  f_register_method(T_NET, "rd", method);
#line 1075

#line 1075

#line 1078 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PATH__first */
#line 1078
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1078
  method->new_inst = f_new_method_FI_METHOD__T_PATH__first;
#line 1078
  method->arg_num = 1;
  method->args_type[0] = T_PATH;
#line 1078 "filter/f-inst.c"

#line 1078
  f_register_method(T_PATH, "first", method);
#line 1078

#line 1078

#line 1081 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PATH__last */
#line 1081
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1081
  method->new_inst = f_new_method_FI_METHOD__T_PATH__last;
#line 1081
  method->arg_num = 1;
  method->args_type[0] = T_PATH;
#line 1081 "filter/f-inst.c"

#line 1081
  f_register_method(T_PATH, "last", method);
#line 1081

#line 1081

#line 1084 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PATH__last_nonaggregated */
#line 1084
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1084
  method->new_inst = f_new_method_FI_METHOD__T_PATH__last_nonaggregated;
#line 1084
  method->arg_num = 1;
  method->args_type[0] = T_PATH;
#line 1084 "filter/f-inst.c"

#line 1084
  f_register_method(T_PATH, "last_nonaggregated", method);
#line 1084

#line 1084

#line 1087 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PAIR__asn */
#line 1087
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1087
  method->new_inst = f_new_method_FI_METHOD__T_PAIR__asn;
#line 1087
  method->arg_num = 1;
  method->args_type[0] = T_PAIR;
#line 1087 "filter/f-inst.c"

#line 1087
  f_register_method(T_PAIR, "asn", method);
#line 1087

#line 1087

#line 1090 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_PAIR__data */
#line 1090
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1090
  method->new_inst = f_new_method_FI_METHOD__T_PAIR__data;
#line 1090
  method->arg_num = 1;
  method->args_type[0] = T_PAIR;
#line 1090 "filter/f-inst.c"

#line 1090
  f_register_method(T_PAIR, "data", method);
#line 1090

#line 1090

#line 1093 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LC__asn */
#line 1093
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1093
  method->new_inst = f_new_method_FI_METHOD__T_LC__asn;
#line 1093
  method->arg_num = 1;
  method->args_type[0] = T_LC;
#line 1093 "filter/f-inst.c"

#line 1093
  f_register_method(T_LC, "asn", method);
#line 1093

#line 1093

#line 1096 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LC__data1 */
#line 1096
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1096
  method->new_inst = f_new_method_FI_METHOD__T_LC__data1;
#line 1096
  method->arg_num = 1;
  method->args_type[0] = T_LC;
#line 1096 "filter/f-inst.c"

#line 1096
  f_register_method(T_LC, "data1", method);
#line 1096

#line 1096

#line 1099 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LC__data2 */
#line 1099
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1099
  method->new_inst = f_new_method_FI_METHOD__T_LC__data2;
#line 1099
  method->arg_num = 1;
  method->args_type[0] = T_LC;
#line 1099 "filter/f-inst.c"

#line 1099
  f_register_method(T_LC, "data2", method);
#line 1099

#line 1099

#line 1102 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_CLIST__min */
#line 1102
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1102
  method->new_inst = f_new_method_FI_METHOD__T_CLIST__min;
#line 1102
  method->arg_num = 1;
  method->args_type[0] = T_CLIST;
#line 1102 "filter/f-inst.c"

#line 1102
  f_register_method(T_CLIST, "min", method);
#line 1102

#line 1102

#line 1105 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_CLIST__max */
#line 1105
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1105
  method->new_inst = f_new_method_FI_METHOD__T_CLIST__max;
#line 1105
  method->arg_num = 1;
  method->args_type[0] = T_CLIST;
#line 1105 "filter/f-inst.c"

#line 1105
  f_register_method(T_CLIST, "max", method);
#line 1105

#line 1105

#line 1108 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_ECLIST__min */
#line 1108
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1108
  method->new_inst = f_new_method_FI_METHOD__T_ECLIST__min;
#line 1108
  method->arg_num = 1;
  method->args_type[0] = T_ECLIST;
#line 1108 "filter/f-inst.c"

#line 1108
  f_register_method(T_ECLIST, "min", method);
#line 1108

#line 1108

#line 1111 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_ECLIST__max */
#line 1111
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1111
  method->new_inst = f_new_method_FI_METHOD__T_ECLIST__max;
#line 1111
  method->arg_num = 1;
  method->args_type[0] = T_ECLIST;
#line 1111 "filter/f-inst.c"

#line 1111
  f_register_method(T_ECLIST, "max", method);
#line 1111

#line 1111

#line 1114 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LCLIST__min */
#line 1114
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1114
  method->new_inst = f_new_method_FI_METHOD__T_LCLIST__min;
#line 1114
  method->arg_num = 1;
  method->args_type[0] = T_LCLIST;
#line 1114 "filter/f-inst.c"

#line 1114
  f_register_method(T_LCLIST, "min", method);
#line 1114

#line 1114

#line 1116 "filter/f-inst.c"
 /* Method registrator for FI_METHOD__T_LCLIST__max */
#line 1116
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 1 * sizeof(enum btype));
#line 1116
  method->new_inst = f_new_method_FI_METHOD__T_LCLIST__max;
#line 1116
  method->arg_num = 1;
  method->args_type[0] = T_LCLIST;
#line 1116 "filter/f-inst.c"

#line 1116
  f_register_method(T_LCLIST, "max", method);
#line 1116

#line 1116

#line 1257 "filter/f-inst.c"
 /* Method registrator for FI_IP_MASK */
#line 1257
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1257
  method->new_inst = f_new_method_FI_IP_MASK;
#line 1257
  method->arg_num = 2;
  method->args_type[0] = T_IP;
  method->args_type[1] = T_INT;
#line 1257 "filter/f-inst.c"

#line 1257
  f_register_method(T_IP, "mask", method);
#line 1257

#line 1257

#line 1265 "filter/f-inst.c"
 /* Method registrator for FI_PATH_PREPEND */
#line 1265
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1265
  method->new_inst = f_new_method_FI_PATH_PREPEND;
#line 1265
  method->arg_num = 2;
  method->args_type[0] = T_PATH;
  method->args_type[1] = T_INT;
#line 1265 "filter/f-inst.c"

#line 1265
  f_register_method(T_PATH, "prepend", method);
#line 1265

#line 1265

#line 1272 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_ADD_PAIR */
#line 1272
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1272
  method->new_inst = f_new_method_FI_CLIST_ADD_PAIR;
#line 1272
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_PAIR;
#line 1272 "filter/f-inst.c"

#line 1272
  f_register_method(T_CLIST, "add", method);
#line 1272

#line 1272

#line 1286 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_ADD_IP */
#line 1286
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1286
  method->new_inst = f_new_method_FI_CLIST_ADD_IP;
#line 1286
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_IP;
#line 1286 "filter/f-inst.c"

#line 1286
  f_register_method(T_CLIST, "add", method);
#line 1286

#line 1286

#line 1293 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_ADD_QUAD */
#line 1293
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1293
  method->new_inst = f_new_method_FI_CLIST_ADD_QUAD;
#line 1293
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_QUAD;
#line 1293 "filter/f-inst.c"

#line 1293
  f_register_method(T_CLIST, "add", method);
#line 1293

#line 1293

#line 1300 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_ADD_CLIST */
#line 1300
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1300
  method->new_inst = f_new_method_FI_CLIST_ADD_CLIST;
#line 1300
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_CLIST;
#line 1300 "filter/f-inst.c"

#line 1300
  f_register_method(T_CLIST, "add", method);
#line 1300

#line 1300

#line 1307 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_ADD_EC */
#line 1307
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1307
  method->new_inst = f_new_method_FI_ECLIST_ADD_EC;
#line 1307
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_EC;
#line 1307 "filter/f-inst.c"

#line 1307
  f_register_method(T_ECLIST, "add", method);
#line 1307

#line 1307

#line 1314 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_ADD_ECLIST */
#line 1314
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1314
  method->new_inst = f_new_method_FI_ECLIST_ADD_ECLIST;
#line 1314
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_ECLIST;
#line 1314 "filter/f-inst.c"

#line 1314
  f_register_method(T_ECLIST, "add", method);
#line 1314

#line 1314

#line 1321 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_ADD_LC */
#line 1321
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1321
  method->new_inst = f_new_method_FI_LCLIST_ADD_LC;
#line 1321
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_LC;
#line 1321 "filter/f-inst.c"

#line 1321
  f_register_method(T_LCLIST, "add", method);
#line 1321

#line 1321

#line 1328 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_ADD_LCLIST */
#line 1328
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1328
  method->new_inst = f_new_method_FI_LCLIST_ADD_LCLIST;
#line 1328
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_LCLIST;
#line 1328 "filter/f-inst.c"

#line 1328
  f_register_method(T_LCLIST, "add", method);
#line 1328

#line 1328

#line 1335 "filter/f-inst.c"
 /* Method registrator for FI_PATH_DELETE_INT */
#line 1335
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1335
  method->new_inst = f_new_method_FI_PATH_DELETE_INT;
#line 1335
  method->arg_num = 2;
  method->args_type[0] = T_PATH;
  method->args_type[1] = T_INT;
#line 1335 "filter/f-inst.c"

#line 1335
  f_register_method(T_PATH, "delete", method);
#line 1335

#line 1335

#line 1347 "filter/f-inst.c"
 /* Method registrator for FI_PATH_DELETE_SET */
#line 1347
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1347
  method->new_inst = f_new_method_FI_PATH_DELETE_SET;
#line 1347
  method->arg_num = 2;
  method->args_type[0] = T_PATH;
  method->args_type[1] = T_SET;
#line 1347 "filter/f-inst.c"

#line 1347
  f_register_method(T_PATH, "delete", method);
#line 1347

#line 1347

#line 1354 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_DELETE_PAIR */
#line 1354
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1354
  method->new_inst = f_new_method_FI_CLIST_DELETE_PAIR;
#line 1354
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_PAIR;
#line 1354 "filter/f-inst.c"

#line 1354
  f_register_method(T_CLIST, "delete", method);
#line 1354

#line 1354

#line 1368 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_DELETE_IP */
#line 1368
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1368
  method->new_inst = f_new_method_FI_CLIST_DELETE_IP;
#line 1368
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_IP;
#line 1368 "filter/f-inst.c"

#line 1368
  f_register_method(T_CLIST, "delete", method);
#line 1368

#line 1368

#line 1375 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_DELETE_QUAD */
#line 1375
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1375
  method->new_inst = f_new_method_FI_CLIST_DELETE_QUAD;
#line 1375
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_QUAD;
#line 1375 "filter/f-inst.c"

#line 1375
  f_register_method(T_CLIST, "delete", method);
#line 1375

#line 1375

#line 1382 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_DELETE_CLIST */
#line 1382
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1382
  method->new_inst = f_new_method_FI_CLIST_DELETE_CLIST;
#line 1382
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_CLIST;
#line 1382 "filter/f-inst.c"

#line 1382
  f_register_method(T_CLIST, "delete", method);
#line 1382

#line 1382

#line 1393 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_DELETE_SET */
#line 1393
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1393
  method->new_inst = f_new_method_FI_CLIST_DELETE_SET;
#line 1393
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_SET;
#line 1393 "filter/f-inst.c"

#line 1393
  f_register_method(T_CLIST, "delete", method);
#line 1393

#line 1393

#line 1400 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_DELETE_EC */
#line 1400
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1400
  method->new_inst = f_new_method_FI_ECLIST_DELETE_EC;
#line 1400
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_EC;
#line 1400 "filter/f-inst.c"

#line 1400
  f_register_method(T_ECLIST, "delete", method);
#line 1400

#line 1400

#line 1407 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_DELETE_ECLIST */
#line 1407
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1407
  method->new_inst = f_new_method_FI_ECLIST_DELETE_ECLIST;
#line 1407
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_ECLIST;
#line 1407 "filter/f-inst.c"

#line 1407
  f_register_method(T_ECLIST, "delete", method);
#line 1407

#line 1407

#line 1418 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_DELETE_SET */
#line 1418
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1418
  method->new_inst = f_new_method_FI_ECLIST_DELETE_SET;
#line 1418
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_SET;
#line 1418 "filter/f-inst.c"

#line 1418
  f_register_method(T_ECLIST, "delete", method);
#line 1418

#line 1418

#line 1425 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_DELETE_LC */
#line 1425
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1425
  method->new_inst = f_new_method_FI_LCLIST_DELETE_LC;
#line 1425
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_LC;
#line 1425 "filter/f-inst.c"

#line 1425
  f_register_method(T_LCLIST, "delete", method);
#line 1425

#line 1425

#line 1432 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_DELETE_LCLIST */
#line 1432
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1432
  method->new_inst = f_new_method_FI_LCLIST_DELETE_LCLIST;
#line 1432
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_LCLIST;
#line 1432 "filter/f-inst.c"

#line 1432
  f_register_method(T_LCLIST, "delete", method);
#line 1432

#line 1432

#line 1443 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_DELETE_SET */
#line 1443
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1443
  method->new_inst = f_new_method_FI_LCLIST_DELETE_SET;
#line 1443
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_SET;
#line 1443 "filter/f-inst.c"

#line 1443
  f_register_method(T_LCLIST, "delete", method);
#line 1443

#line 1443

#line 1454 "filter/f-inst.c"
 /* Method registrator for FI_PATH_FILTER_SET */
#line 1454
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1454
  method->new_inst = f_new_method_FI_PATH_FILTER_SET;
#line 1454
  method->arg_num = 2;
  method->args_type[0] = T_PATH;
  method->args_type[1] = T_SET;
#line 1454 "filter/f-inst.c"

#line 1454
  f_register_method(T_PATH, "filter", method);
#line 1454

#line 1454

#line 1461 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_FILTER_CLIST */
#line 1461
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1461
  method->new_inst = f_new_method_FI_CLIST_FILTER_CLIST;
#line 1461
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_CLIST;
#line 1461 "filter/f-inst.c"

#line 1461
  f_register_method(T_CLIST, "filter", method);
#line 1461

#line 1461

#line 1472 "filter/f-inst.c"
 /* Method registrator for FI_CLIST_FILTER_SET */
#line 1472
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1472
  method->new_inst = f_new_method_FI_CLIST_FILTER_SET;
#line 1472
  method->arg_num = 2;
  method->args_type[0] = T_CLIST;
  method->args_type[1] = T_SET;
#line 1472 "filter/f-inst.c"

#line 1472
  f_register_method(T_CLIST, "filter", method);
#line 1472

#line 1472

#line 1479 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_FILTER_ECLIST */
#line 1479
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1479
  method->new_inst = f_new_method_FI_ECLIST_FILTER_ECLIST;
#line 1479
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_ECLIST;
#line 1479 "filter/f-inst.c"

#line 1479
  f_register_method(T_ECLIST, "filter", method);
#line 1479

#line 1479

#line 1490 "filter/f-inst.c"
 /* Method registrator for FI_ECLIST_FILTER_SET */
#line 1490
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1490
  method->new_inst = f_new_method_FI_ECLIST_FILTER_SET;
#line 1490
  method->arg_num = 2;
  method->args_type[0] = T_ECLIST;
  method->args_type[1] = T_SET;
#line 1490 "filter/f-inst.c"

#line 1490
  f_register_method(T_ECLIST, "filter", method);
#line 1490

#line 1490

#line 1497 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_FILTER_LCLIST */
#line 1497
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1497
  method->new_inst = f_new_method_FI_LCLIST_FILTER_LCLIST;
#line 1497
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_LCLIST;
#line 1497 "filter/f-inst.c"

#line 1497
  f_register_method(T_LCLIST, "filter", method);
#line 1497

#line 1497

#line 1508 "filter/f-inst.c"
 /* Method registrator for FI_LCLIST_FILTER_SET */
#line 1508
  method = lp_allocz(global_root_scope_linpool, sizeof(struct f_method) + 2 * sizeof(enum btype));
#line 1508
  method->new_inst = f_new_method_FI_LCLIST_FILTER_SET;
#line 1508
  method->arg_num = 2;
  method->args_type[0] = T_LCLIST;
  method->args_type[1] = T_SET;
#line 1508 "filter/f-inst.c"

#line 1508
  f_register_method(T_LCLIST, "filter", method);
#line 1508

#line 1508

#line 670 "filter/decl.m4"


  for (uint i = 0; i < ARRAY_SIZE(f_type_method_scopes); i++)
    f_type_method_scopes[i].readonly = 1;

  f_type_method_scopes[T_ROUTE].next = &global_filter_scope;
}

/* Line dumpers */
#define INDENT (((const char *) f_dump_line_indent_str) + sizeof(f_dump_line_indent_str) - (indent) - 1)
static const char f_dump_line_indent_str[] = "                                ";

#line 288 "filter/f-inst.c"
 /* Dump line for FI_ADD */
#line 288
static inline void f_dump_line_item_FI_ADD(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 288

#line 288
{
#line 288
#define item (&(item_->i_FI_ADD))
#line 288
#undef item
#line 288
}
#line 288

#line 293 "filter/f-inst.c"
 /* Dump line for FI_SUBTRACT */
#line 293
static inline void f_dump_line_item_FI_SUBTRACT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 293

#line 293
{
#line 293
#define item (&(item_->i_FI_SUBTRACT))
#line 293
#undef item
#line 293
}
#line 293

#line 298 "filter/f-inst.c"
 /* Dump line for FI_MULTIPLY */
#line 298
static inline void f_dump_line_item_FI_MULTIPLY(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 298

#line 298
{
#line 298
#define item (&(item_->i_FI_MULTIPLY))
#line 298
#undef item
#line 298
}
#line 298

#line 304 "filter/f-inst.c"
 /* Dump line for FI_DIVIDE */
#line 304
static inline void f_dump_line_item_FI_DIVIDE(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 304

#line 304
{
#line 304
#define item (&(item_->i_FI_DIVIDE))
#line 304
#undef item
#line 304
}
#line 304

#line 309 "filter/f-inst.c"
 /* Dump line for FI_BITOR */
#line 309
static inline void f_dump_line_item_FI_BITOR(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 309

#line 309
{
#line 309
#define item (&(item_->i_FI_BITOR))
#line 309
#undef item
#line 309
}
#line 309

#line 314 "filter/f-inst.c"
 /* Dump line for FI_BITAND */
#line 314
static inline void f_dump_line_item_FI_BITAND(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 314

#line 314
{
#line 314
#define item (&(item_->i_FI_BITAND))
#line 314
#undef item
#line 314
}
#line 314

#line 324 "filter/f-inst.c"
 /* Dump line for FI_AND */
#line 324
static inline void f_dump_line_item_FI_AND(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 324

#line 324
{
#line 324
#define item (&(item_->i_FI_AND))
#line 320 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 324 "filter/f-inst.c"
#undef item
#line 324
}
#line 324

#line 335 "filter/f-inst.c"
 /* Dump line for FI_OR */
#line 335
static inline void f_dump_line_item_FI_OR(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 335

#line 335
{
#line 335
#define item (&(item_->i_FI_OR))
#line 330 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 335 "filter/f-inst.c"
#undef item
#line 335
}
#line 335

#line 345 "filter/f-inst.c"
 /* Dump line for FI_PAIR_CONSTRUCT */
#line 345
static inline void f_dump_line_item_FI_PAIR_CONSTRUCT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 345

#line 345
{
#line 345
#define item (&(item_->i_FI_PAIR_CONSTRUCT))
#line 345
#undef item
#line 345
}
#line 345

#line 385 "filter/f-inst.c"
 /* Dump line for FI_EC_CONSTRUCT */
#line 385
static inline void f_dump_line_item_FI_EC_CONSTRUCT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 385

#line 385
{
#line 385
#define item (&(item_->i_FI_EC_CONSTRUCT))
#line 349 "filter/f-inst.c"
RDUMP("%s" "ec subtype %s" "\n", INDENT, ec_subtype_str(item->ecs));
#line 349

#line 385 "filter/f-inst.c"
#undef item
#line 385
}
#line 385

#line 392 "filter/f-inst.c"
 /* Dump line for FI_LC_CONSTRUCT */
#line 392
static inline void f_dump_line_item_FI_LC_CONSTRUCT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 392

#line 392
{
#line 392
#define item (&(item_->i_FI_LC_CONSTRUCT))
#line 392
#undef item
#line 392
}
#line 392

#line 442 "filter/f-inst.c"
 /* Dump line for FI_PATHMASK_CONSTRUCT */
#line 442
static inline void f_dump_line_item_FI_PATHMASK_CONSTRUCT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 442

#line 442
{
#line 442
#define item (&(item_->i_FI_PATHMASK_CONSTRUCT))
#line 393 "filter/f-inst.c"
  RDUMP("%snumber of varargs %u\n", INDENT, item->varcount);
#line 442 "filter/f-inst.c"
#undef item
#line 442
}
#line 442

#line 449 "filter/f-inst.c"
 /* Dump line for FI_NEQ */
#line 449
static inline void f_dump_line_item_FI_NEQ(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 449

#line 449
{
#line 449
#define item (&(item_->i_FI_NEQ))
#line 449
#undef item
#line 449
}
#line 449

#line 456 "filter/f-inst.c"
 /* Dump line for FI_EQ */
#line 456
static inline void f_dump_line_item_FI_EQ(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 456

#line 456
{
#line 456
#define item (&(item_->i_FI_EQ))
#line 456
#undef item
#line 456
}
#line 456

#line 467 "filter/f-inst.c"
 /* Dump line for FI_LT */
#line 467
static inline void f_dump_line_item_FI_LT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 467

#line 467
{
#line 467
#define item (&(item_->i_FI_LT))
#line 467
#undef item
#line 467
}
#line 467

#line 478 "filter/f-inst.c"
 /* Dump line for FI_LTE */
#line 478
static inline void f_dump_line_item_FI_LTE(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 478

#line 478
{
#line 478
#define item (&(item_->i_FI_LTE))
#line 478
#undef item
#line 478
}
#line 478

#line 483 "filter/f-inst.c"
 /* Dump line for FI_NOT */
#line 483
static inline void f_dump_line_item_FI_NOT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 483

#line 483
{
#line 483
#define item (&(item_->i_FI_NOT))
#line 483
#undef item
#line 483
}
#line 483

#line 492 "filter/f-inst.c"
 /* Dump line for FI_MATCH */
#line 492
static inline void f_dump_line_item_FI_MATCH(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 492

#line 492
{
#line 492
#define item (&(item_->i_FI_MATCH))
#line 492
#undef item
#line 492
}
#line 492

#line 501 "filter/f-inst.c"
 /* Dump line for FI_NOT_MATCH */
#line 501
static inline void f_dump_line_item_FI_NOT_MATCH(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 501

#line 501
{
#line 501
#define item (&(item_->i_FI_NOT_MATCH))
#line 501
#undef item
#line 501
}
#line 501

#line 506 "filter/f-inst.c"
 /* Dump line for FI_DEFINED */
#line 506
static inline void f_dump_line_item_FI_DEFINED(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 506

#line 506
{
#line 506
#define item (&(item_->i_FI_DEFINED))
#line 506
#undef item
#line 506
}
#line 506

#line 507 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_NET__type */
#line 507
static inline void f_dump_line_item_FI_METHOD__T_NET__type(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 507

#line 507
{
#line 507
#define item (&(item_->i_FI_METHOD__T_NET__type))
#line 507
#undef item
#line 507
}
#line 507

#line 510 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_IP__is_v4 */
#line 510
static inline void f_dump_line_item_FI_METHOD__T_IP__is_v4(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 510

#line 510
{
#line 510
#define item (&(item_->i_FI_METHOD__T_IP__is_v4))
#line 510
#undef item
#line 510
}
#line 510

#line 523 "filter/f-inst.c"
 /* Dump line for FI_VAR_INIT */
#line 523
static inline void f_dump_line_item_FI_VAR_INIT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 523

#line 523
{
#line 523
#define item (&(item_->i_FI_VAR_INIT))
#line 513 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 513

#line 523 "filter/f-inst.c"
#undef item
#line 523
}
#line 523

#line 534 "filter/f-inst.c"
 /* Dump line for FI_VAR_INIT0 */
#line 534
static inline void f_dump_line_item_FI_VAR_INIT0(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 534

#line 534
{
#line 534
#define item (&(item_->i_FI_VAR_INIT0))
#line 525 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 525

#line 534 "filter/f-inst.c"
#undef item
#line 534
}
#line 534

#line 543 "filter/f-inst.c"
 /* Dump line for FI_VAR_SET */
#line 543
static inline void f_dump_line_item_FI_VAR_SET(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 543

#line 543
{
#line 543
#define item (&(item_->i_FI_VAR_SET))
#line 537 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 537

#line 543 "filter/f-inst.c"
#undef item
#line 543
}
#line 543

#line 550 "filter/f-inst.c"
 /* Dump line for FI_VAR_GET */
#line 550
static inline void f_dump_line_item_FI_VAR_GET(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 550

#line 550
{
#line 550
#define item (&(item_->i_FI_VAR_GET))
#line 544 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 544

#line 550 "filter/f-inst.c"
#undef item
#line 550
}
#line 550

#line 563 "filter/f-inst.c"
 /* Dump line for FI_CONSTANT */
#line 563
static inline void f_dump_line_item_FI_CONSTANT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 563

#line 563
{
#line 563
#define item (&(item_->i_FI_CONSTANT))
#line 551 "filter/f-inst.c"
RDUMP("%s" "value %s" "\n", INDENT, val_dump(&(item->val))
#line 551
    );
#line 551

#line 563 "filter/f-inst.c"
#undef item
#line 563
}
#line 563

#line 564 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PATH__empty */
#line 564
static inline void f_dump_line_item_FI_METHOD__T_PATH__empty(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 564

#line 564
{
#line 564
#define item (&(item_->i_FI_METHOD__T_PATH__empty))
#line 564
#undef item
#line 564
}
#line 564

#line 565 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_CLIST__empty */
#line 565
static inline void f_dump_line_item_FI_METHOD__T_CLIST__empty(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 565

#line 565
{
#line 565
#define item (&(item_->i_FI_METHOD__T_CLIST__empty))
#line 565
#undef item
#line 565
}
#line 565

#line 566 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_ECLIST__empty */
#line 566
static inline void f_dump_line_item_FI_METHOD__T_ECLIST__empty(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 566

#line 566
{
#line 566
#define item (&(item_->i_FI_METHOD__T_ECLIST__empty))
#line 566
#undef item
#line 566
}
#line 566

#line 569 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LCLIST__empty */
#line 569
static inline void f_dump_line_item_FI_METHOD__T_LCLIST__empty(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 569

#line 569
{
#line 569
#define item (&(item_->i_FI_METHOD__T_LCLIST__empty))
#line 569
#undef item
#line 569
}
#line 569

#line 591 "filter/f-inst.c"
 /* Dump line for FI_FOR_LOOP_START */
#line 591
static inline void f_dump_line_item_FI_FOR_LOOP_START(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 591

#line 591
{
#line 591
#define item (&(item_->i_FI_FOR_LOOP_START))
#line 571 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 571

#line 591 "filter/f-inst.c"
#undef item
#line 591
}
#line 591

#line 600 "filter/f-inst.c"
 /* Dump line for FI_PATH_FOR_NEXT */
#line 600
static inline void f_dump_line_item_FI_PATH_FOR_NEXT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 600

#line 600
{
#line 600
#define item (&(item_->i_FI_PATH_FOR_NEXT))
#line 595 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 600 "filter/f-inst.c"
#undef item
#line 600
}
#line 600

#line 609 "filter/f-inst.c"
 /* Dump line for FI_CLIST_FOR_NEXT */
#line 609
static inline void f_dump_line_item_FI_CLIST_FOR_NEXT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 609

#line 609
{
#line 609
#define item (&(item_->i_FI_CLIST_FOR_NEXT))
#line 604 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 609 "filter/f-inst.c"
#undef item
#line 609
}
#line 609

#line 618 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_FOR_NEXT */
#line 618
static inline void f_dump_line_item_FI_ECLIST_FOR_NEXT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 618

#line 618
{
#line 618
#define item (&(item_->i_FI_ECLIST_FOR_NEXT))
#line 613 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 618 "filter/f-inst.c"
#undef item
#line 618
}
#line 618

#line 627 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_FOR_NEXT */
#line 627
static inline void f_dump_line_item_FI_LCLIST_FOR_NEXT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 627

#line 627
{
#line 627
#define item (&(item_->i_FI_LCLIST_FOR_NEXT))
#line 622 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 627 "filter/f-inst.c"
#undef item
#line 627
}
#line 627

#line 640 "filter/f-inst.c"
 /* Dump line for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
static inline void f_dump_line_item_FI_ROUTES_BLOCK_FOR_NEXT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 640

#line 640
{
#line 640
#define item (&(item_->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 634 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 640 "filter/f-inst.c"
#undef item
#line 640
}
#line 640

#line 648 "filter/f-inst.c"
 /* Dump line for FI_CONDITION */
#line 648
static inline void f_dump_line_item_FI_CONDITION(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 648

#line 648
{
#line 648
#define item (&(item_->i_FI_CONDITION))
#line 643 "filter/f-inst.c"
f_dump_line(dreq, item->fl2, indent + 1);
#line 645 "filter/f-inst.c"
f_dump_line(dreq, item->fl3, indent + 1);
#line 648 "filter/f-inst.c"
#undef item
#line 648
}
#line 648

#line 661 "filter/f-inst.c"
 /* Dump line for FI_PRINT */
#line 661
static inline void f_dump_line_item_FI_PRINT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 661

#line 661
{
#line 661
#define item (&(item_->i_FI_PRINT))
#line 661
#undef item
#line 661
}
#line 661

#line 668 "filter/f-inst.c"
 /* Dump line for FI_FLUSH */
#line 668
static inline void f_dump_line_item_FI_FLUSH(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 668

#line 668
{
#line 668
#define item (&(item_->i_FI_FLUSH))
#line 668
#undef item
#line 668
}
#line 668

#line 682 "filter/f-inst.c"
 /* Dump line for FI_DIE */
#line 682
static inline void f_dump_line_item_FI_DIE(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 682

#line 682
{
#line 682
#define item (&(item_->i_FI_DIE))
#line 670 "filter/f-inst.c"
RDUMP("%s" "%s" "\n", INDENT, filter_return_str(item->fret));
#line 670

#line 682 "filter/f-inst.c"
#undef item
#line 682
}
#line 682

#line 689 "filter/f-inst.c"
 /* Dump line for FI_CURRENT_ROUTE */
#line 689
static inline void f_dump_line_item_FI_CURRENT_ROUTE(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 689

#line 689
{
#line 689
#define item (&(item_->i_FI_CURRENT_ROUTE))
#line 689
#undef item
#line 689
}
#line 689

#line 737 "filter/f-inst.c"
 /* Dump line for FI_RTA_GET */
#line 737
static inline void f_dump_line_item_FI_RTA_GET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 737

#line 737
{
#line 737
#define item (&(item_->i_FI_RTA_GET))
#line 737
#undef item
#line 737
}
#line 737

#line 866 "filter/f-inst.c"
 /* Dump line for FI_RTA_SET */
#line 866
static inline void f_dump_line_item_FI_RTA_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 866

#line 866
{
#line 866
#define item (&(item_->i_FI_RTA_SET))
#line 866
#undef item
#line 866
}
#line 866

#line 903 "filter/f-inst.c"
 /* Dump line for FI_EA_GET */
#line 903
static inline void f_dump_line_item_FI_EA_GET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 903

#line 903
{
#line 903
#define item (&(item_->i_FI_EA_GET))
#line 903
#undef item
#line 903
}
#line 903

#line 944 "filter/f-inst.c"
 /* Dump line for FI_EA_SET */
#line 944
static inline void f_dump_line_item_FI_EA_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 944

#line 944
{
#line 944
#define item (&(item_->i_FI_EA_SET))
#line 944
#undef item
#line 944
}
#line 944

#line 951 "filter/f-inst.c"
 /* Dump line for FI_EA_UNSET */
#line 951
static inline void f_dump_line_item_FI_EA_UNSET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 951

#line 951
{
#line 951
#define item (&(item_->i_FI_EA_UNSET))
#line 951
#undef item
#line 951
}
#line 951

#line 965 "filter/f-inst.c"
 /* Dump line for FI_DEFAULT */
#line 965
static inline void f_dump_line_item_FI_DEFAULT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 965

#line 965
{
#line 965
#define item (&(item_->i_FI_DEFAULT))
#line 965
#undef item
#line 965
}
#line 965

#line 966 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_NET__len */
#line 966
static inline void f_dump_line_item_FI_METHOD__T_NET__len(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 966

#line 966
{
#line 966
#define item (&(item_->i_FI_METHOD__T_NET__len))
#line 966
#undef item
#line 966
}
#line 966

#line 967 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PATH__len */
#line 967
static inline void f_dump_line_item_FI_METHOD__T_PATH__len(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 967

#line 967
{
#line 967
#define item (&(item_->i_FI_METHOD__T_PATH__len))
#line 967
#undef item
#line 967
}
#line 967

#line 968 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_CLIST__len */
#line 968
static inline void f_dump_line_item_FI_METHOD__T_CLIST__len(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 968

#line 968
{
#line 968
#define item (&(item_->i_FI_METHOD__T_CLIST__len))
#line 968
#undef item
#line 968
}
#line 968

#line 969 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_ECLIST__len */
#line 969
static inline void f_dump_line_item_FI_METHOD__T_ECLIST__len(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 969

#line 969
{
#line 969
#define item (&(item_->i_FI_METHOD__T_ECLIST__len))
#line 969
#undef item
#line 969
}
#line 969

#line 971 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LCLIST__len */
#line 971
static inline void f_dump_line_item_FI_METHOD__T_LCLIST__len(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 971

#line 971
{
#line 971
#define item (&(item_->i_FI_METHOD__T_LCLIST__len))
#line 971
#undef item
#line 971
}
#line 971

#line 1007 "filter/f-inst.c"
 /* Dump line for FI_NET_SRC */
#line 1007
static inline void f_dump_line_item_FI_NET_SRC(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1007

#line 1007
{
#line 1007
#define item (&(item_->i_FI_NET_SRC))
#line 1007
#undef item
#line 1007
}
#line 1007

#line 1044 "filter/f-inst.c"
 /* Dump line for FI_NET_DST */
#line 1044
static inline void f_dump_line_item_FI_NET_DST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1044

#line 1044
{
#line 1044
#define item (&(item_->i_FI_NET_DST))
#line 1044
#undef item
#line 1044
}
#line 1044

#line 1054 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_NET__maxlen */
#line 1054
static inline void f_dump_line_item_FI_METHOD__T_NET__maxlen(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1054

#line 1054
{
#line 1054
#define item (&(item_->i_FI_METHOD__T_NET__maxlen))
#line 1054
#undef item
#line 1054
}
#line 1054

#line 1064 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_NET__asn */
#line 1064
static inline void f_dump_line_item_FI_METHOD__T_NET__asn(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1064

#line 1064
{
#line 1064
#define item (&(item_->i_FI_METHOD__T_NET__asn))
#line 1064
#undef item
#line 1064
}
#line 1064

#line 1066 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_NET__ip */
#line 1066
static inline void f_dump_line_item_FI_METHOD__T_NET__ip(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1066

#line 1066
{
#line 1066
#define item (&(item_->i_FI_METHOD__T_NET__ip))
#line 1066
#undef item
#line 1066
}
#line 1066

#line 1075 "filter/f-inst.c"
 /* Dump line for FI_ROUTE_DISTINGUISHER */
#line 1075
static inline void f_dump_line_item_FI_ROUTE_DISTINGUISHER(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1075

#line 1075
{
#line 1075
#define item (&(item_->i_FI_ROUTE_DISTINGUISHER))
#line 1075
#undef item
#line 1075
}
#line 1075

#line 1078 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PATH__first */
#line 1078
static inline void f_dump_line_item_FI_METHOD__T_PATH__first(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1078

#line 1078
{
#line 1078
#define item (&(item_->i_FI_METHOD__T_PATH__first))
#line 1078
#undef item
#line 1078
}
#line 1078

#line 1081 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PATH__last */
#line 1081
static inline void f_dump_line_item_FI_METHOD__T_PATH__last(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1081

#line 1081
{
#line 1081
#define item (&(item_->i_FI_METHOD__T_PATH__last))
#line 1081
#undef item
#line 1081
}
#line 1081

#line 1084 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PATH__last_nonaggregated */
#line 1084
static inline void f_dump_line_item_FI_METHOD__T_PATH__last_nonaggregated(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1084

#line 1084
{
#line 1084
#define item (&(item_->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1084
#undef item
#line 1084
}
#line 1084

#line 1087 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PAIR__asn */
#line 1087
static inline void f_dump_line_item_FI_METHOD__T_PAIR__asn(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1087

#line 1087
{
#line 1087
#define item (&(item_->i_FI_METHOD__T_PAIR__asn))
#line 1087
#undef item
#line 1087
}
#line 1087

#line 1090 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_PAIR__data */
#line 1090
static inline void f_dump_line_item_FI_METHOD__T_PAIR__data(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1090

#line 1090
{
#line 1090
#define item (&(item_->i_FI_METHOD__T_PAIR__data))
#line 1090
#undef item
#line 1090
}
#line 1090

#line 1093 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LC__asn */
#line 1093
static inline void f_dump_line_item_FI_METHOD__T_LC__asn(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1093

#line 1093
{
#line 1093
#define item (&(item_->i_FI_METHOD__T_LC__asn))
#line 1093
#undef item
#line 1093
}
#line 1093

#line 1096 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LC__data1 */
#line 1096
static inline void f_dump_line_item_FI_METHOD__T_LC__data1(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1096

#line 1096
{
#line 1096
#define item (&(item_->i_FI_METHOD__T_LC__data1))
#line 1096
#undef item
#line 1096
}
#line 1096

#line 1099 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LC__data2 */
#line 1099
static inline void f_dump_line_item_FI_METHOD__T_LC__data2(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1099

#line 1099
{
#line 1099
#define item (&(item_->i_FI_METHOD__T_LC__data2))
#line 1099
#undef item
#line 1099
}
#line 1099

#line 1102 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_CLIST__min */
#line 1102
static inline void f_dump_line_item_FI_METHOD__T_CLIST__min(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1102

#line 1102
{
#line 1102
#define item (&(item_->i_FI_METHOD__T_CLIST__min))
#line 1102
#undef item
#line 1102
}
#line 1102

#line 1105 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_CLIST__max */
#line 1105
static inline void f_dump_line_item_FI_METHOD__T_CLIST__max(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1105

#line 1105
{
#line 1105
#define item (&(item_->i_FI_METHOD__T_CLIST__max))
#line 1105
#undef item
#line 1105
}
#line 1105

#line 1108 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_ECLIST__min */
#line 1108
static inline void f_dump_line_item_FI_METHOD__T_ECLIST__min(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1108

#line 1108
{
#line 1108
#define item (&(item_->i_FI_METHOD__T_ECLIST__min))
#line 1108
#undef item
#line 1108
}
#line 1108

#line 1111 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_ECLIST__max */
#line 1111
static inline void f_dump_line_item_FI_METHOD__T_ECLIST__max(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1111

#line 1111
{
#line 1111
#define item (&(item_->i_FI_METHOD__T_ECLIST__max))
#line 1111
#undef item
#line 1111
}
#line 1111

#line 1114 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LCLIST__min */
#line 1114
static inline void f_dump_line_item_FI_METHOD__T_LCLIST__min(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1114

#line 1114
{
#line 1114
#define item (&(item_->i_FI_METHOD__T_LCLIST__min))
#line 1114
#undef item
#line 1114
}
#line 1114

#line 1116 "filter/f-inst.c"
 /* Dump line for FI_METHOD__T_LCLIST__max */
#line 1116
static inline void f_dump_line_item_FI_METHOD__T_LCLIST__max(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1116

#line 1116
{
#line 1116
#define item (&(item_->i_FI_METHOD__T_LCLIST__max))
#line 1116
#undef item
#line 1116
}
#line 1116

#line 1142 "filter/f-inst.c"
 /* Dump line for FI_RETURN */
#line 1142
static inline void f_dump_line_item_FI_RETURN(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1142

#line 1142
{
#line 1142
#define item (&(item_->i_FI_RETURN))
#line 1142
#undef item
#line 1142
}
#line 1142

#line 1202 "filter/f-inst.c"
 /* Dump line for FI_CALL */
#line 1202
static inline void f_dump_line_item_FI_CALL(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 1202

#line 1202
{
#line 1202
#define item (&(item_->i_FI_CALL))
#line 1144 "filter/f-inst.c"
  RDUMP("%snumber of varargs %u\n", INDENT, item->varcount);
#line 1145 "filter/f-inst.c"
RDUMP("%s" "symbol %s" "\n", INDENT, item->sym->name);
#line 1145

#line 1202 "filter/f-inst.c"
#undef item
#line 1202
}
#line 1202

#line 1207 "filter/f-inst.c"
 /* Dump line for FI_DROP_RESULT */
#line 1207
static inline void f_dump_line_item_FI_DROP_RESULT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1207

#line 1207
{
#line 1207
#define item (&(item_->i_FI_DROP_RESULT))
#line 1207
#undef item
#line 1207
}
#line 1207

#line 1248 "filter/f-inst.c"
 /* Dump line for FI_SWITCH */
#line 1248
static inline void f_dump_line_item_FI_SWITCH(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 1248

#line 1248
{
#line 1248
#define item (&(item_->i_FI_SWITCH))
#line 1210 "filter/f-inst.c"
RDUMP("%s" "tree %p" "\n", INDENT, item->tree);
#line 1210

#line 1248 "filter/f-inst.c"
#undef item
#line 1248
}
#line 1248

#line 1257 "filter/f-inst.c"
 /* Dump line for FI_IP_MASK */
#line 1257
static inline void f_dump_line_item_FI_IP_MASK(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1257

#line 1257
{
#line 1257
#define item (&(item_->i_FI_IP_MASK))
#line 1257
#undef item
#line 1257
}
#line 1257

#line 1265 "filter/f-inst.c"
 /* Dump line for FI_PATH_PREPEND */
#line 1265
static inline void f_dump_line_item_FI_PATH_PREPEND(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1265

#line 1265
{
#line 1265
#define item (&(item_->i_FI_PATH_PREPEND))
#line 1265
#undef item
#line 1265
}
#line 1265

#line 1272 "filter/f-inst.c"
 /* Dump line for FI_CLIST_ADD_PAIR */
#line 1272
static inline void f_dump_line_item_FI_CLIST_ADD_PAIR(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1272

#line 1272
{
#line 1272
#define item (&(item_->i_FI_CLIST_ADD_PAIR))
#line 1272
#undef item
#line 1272
}
#line 1272

#line 1286 "filter/f-inst.c"
 /* Dump line for FI_CLIST_ADD_IP */
#line 1286
static inline void f_dump_line_item_FI_CLIST_ADD_IP(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1286

#line 1286
{
#line 1286
#define item (&(item_->i_FI_CLIST_ADD_IP))
#line 1286
#undef item
#line 1286
}
#line 1286

#line 1293 "filter/f-inst.c"
 /* Dump line for FI_CLIST_ADD_QUAD */
#line 1293
static inline void f_dump_line_item_FI_CLIST_ADD_QUAD(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1293

#line 1293
{
#line 1293
#define item (&(item_->i_FI_CLIST_ADD_QUAD))
#line 1293
#undef item
#line 1293
}
#line 1293

#line 1300 "filter/f-inst.c"
 /* Dump line for FI_CLIST_ADD_CLIST */
#line 1300
static inline void f_dump_line_item_FI_CLIST_ADD_CLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1300

#line 1300
{
#line 1300
#define item (&(item_->i_FI_CLIST_ADD_CLIST))
#line 1300
#undef item
#line 1300
}
#line 1300

#line 1307 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_ADD_EC */
#line 1307
static inline void f_dump_line_item_FI_ECLIST_ADD_EC(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1307

#line 1307
{
#line 1307
#define item (&(item_->i_FI_ECLIST_ADD_EC))
#line 1307
#undef item
#line 1307
}
#line 1307

#line 1314 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_ADD_ECLIST */
#line 1314
static inline void f_dump_line_item_FI_ECLIST_ADD_ECLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1314

#line 1314
{
#line 1314
#define item (&(item_->i_FI_ECLIST_ADD_ECLIST))
#line 1314
#undef item
#line 1314
}
#line 1314

#line 1321 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_ADD_LC */
#line 1321
static inline void f_dump_line_item_FI_LCLIST_ADD_LC(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1321

#line 1321
{
#line 1321
#define item (&(item_->i_FI_LCLIST_ADD_LC))
#line 1321
#undef item
#line 1321
}
#line 1321

#line 1328 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_ADD_LCLIST */
#line 1328
static inline void f_dump_line_item_FI_LCLIST_ADD_LCLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1328

#line 1328
{
#line 1328
#define item (&(item_->i_FI_LCLIST_ADD_LCLIST))
#line 1328
#undef item
#line 1328
}
#line 1328

#line 1335 "filter/f-inst.c"
 /* Dump line for FI_PATH_DELETE_INT */
#line 1335
static inline void f_dump_line_item_FI_PATH_DELETE_INT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1335

#line 1335
{
#line 1335
#define item (&(item_->i_FI_PATH_DELETE_INT))
#line 1335
#undef item
#line 1335
}
#line 1335

#line 1347 "filter/f-inst.c"
 /* Dump line for FI_PATH_DELETE_SET */
#line 1347
static inline void f_dump_line_item_FI_PATH_DELETE_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1347

#line 1347
{
#line 1347
#define item (&(item_->i_FI_PATH_DELETE_SET))
#line 1347
#undef item
#line 1347
}
#line 1347

#line 1354 "filter/f-inst.c"
 /* Dump line for FI_CLIST_DELETE_PAIR */
#line 1354
static inline void f_dump_line_item_FI_CLIST_DELETE_PAIR(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1354

#line 1354
{
#line 1354
#define item (&(item_->i_FI_CLIST_DELETE_PAIR))
#line 1354
#undef item
#line 1354
}
#line 1354

#line 1368 "filter/f-inst.c"
 /* Dump line for FI_CLIST_DELETE_IP */
#line 1368
static inline void f_dump_line_item_FI_CLIST_DELETE_IP(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1368

#line 1368
{
#line 1368
#define item (&(item_->i_FI_CLIST_DELETE_IP))
#line 1368
#undef item
#line 1368
}
#line 1368

#line 1375 "filter/f-inst.c"
 /* Dump line for FI_CLIST_DELETE_QUAD */
#line 1375
static inline void f_dump_line_item_FI_CLIST_DELETE_QUAD(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1375

#line 1375
{
#line 1375
#define item (&(item_->i_FI_CLIST_DELETE_QUAD))
#line 1375
#undef item
#line 1375
}
#line 1375

#line 1382 "filter/f-inst.c"
 /* Dump line for FI_CLIST_DELETE_CLIST */
#line 1382
static inline void f_dump_line_item_FI_CLIST_DELETE_CLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1382

#line 1382
{
#line 1382
#define item (&(item_->i_FI_CLIST_DELETE_CLIST))
#line 1382
#undef item
#line 1382
}
#line 1382

#line 1393 "filter/f-inst.c"
 /* Dump line for FI_CLIST_DELETE_SET */
#line 1393
static inline void f_dump_line_item_FI_CLIST_DELETE_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1393

#line 1393
{
#line 1393
#define item (&(item_->i_FI_CLIST_DELETE_SET))
#line 1393
#undef item
#line 1393
}
#line 1393

#line 1400 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_DELETE_EC */
#line 1400
static inline void f_dump_line_item_FI_ECLIST_DELETE_EC(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1400

#line 1400
{
#line 1400
#define item (&(item_->i_FI_ECLIST_DELETE_EC))
#line 1400
#undef item
#line 1400
}
#line 1400

#line 1407 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_DELETE_ECLIST */
#line 1407
static inline void f_dump_line_item_FI_ECLIST_DELETE_ECLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1407

#line 1407
{
#line 1407
#define item (&(item_->i_FI_ECLIST_DELETE_ECLIST))
#line 1407
#undef item
#line 1407
}
#line 1407

#line 1418 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_DELETE_SET */
#line 1418
static inline void f_dump_line_item_FI_ECLIST_DELETE_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1418

#line 1418
{
#line 1418
#define item (&(item_->i_FI_ECLIST_DELETE_SET))
#line 1418
#undef item
#line 1418
}
#line 1418

#line 1425 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_DELETE_LC */
#line 1425
static inline void f_dump_line_item_FI_LCLIST_DELETE_LC(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1425

#line 1425
{
#line 1425
#define item (&(item_->i_FI_LCLIST_DELETE_LC))
#line 1425
#undef item
#line 1425
}
#line 1425

#line 1432 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_DELETE_LCLIST */
#line 1432
static inline void f_dump_line_item_FI_LCLIST_DELETE_LCLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1432

#line 1432
{
#line 1432
#define item (&(item_->i_FI_LCLIST_DELETE_LCLIST))
#line 1432
#undef item
#line 1432
}
#line 1432

#line 1443 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_DELETE_SET */
#line 1443
static inline void f_dump_line_item_FI_LCLIST_DELETE_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1443

#line 1443
{
#line 1443
#define item (&(item_->i_FI_LCLIST_DELETE_SET))
#line 1443
#undef item
#line 1443
}
#line 1443

#line 1454 "filter/f-inst.c"
 /* Dump line for FI_PATH_FILTER_SET */
#line 1454
static inline void f_dump_line_item_FI_PATH_FILTER_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1454

#line 1454
{
#line 1454
#define item (&(item_->i_FI_PATH_FILTER_SET))
#line 1454
#undef item
#line 1454
}
#line 1454

#line 1461 "filter/f-inst.c"
 /* Dump line for FI_CLIST_FILTER_CLIST */
#line 1461
static inline void f_dump_line_item_FI_CLIST_FILTER_CLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1461

#line 1461
{
#line 1461
#define item (&(item_->i_FI_CLIST_FILTER_CLIST))
#line 1461
#undef item
#line 1461
}
#line 1461

#line 1472 "filter/f-inst.c"
 /* Dump line for FI_CLIST_FILTER_SET */
#line 1472
static inline void f_dump_line_item_FI_CLIST_FILTER_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1472

#line 1472
{
#line 1472
#define item (&(item_->i_FI_CLIST_FILTER_SET))
#line 1472
#undef item
#line 1472
}
#line 1472

#line 1479 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_FILTER_ECLIST */
#line 1479
static inline void f_dump_line_item_FI_ECLIST_FILTER_ECLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1479

#line 1479
{
#line 1479
#define item (&(item_->i_FI_ECLIST_FILTER_ECLIST))
#line 1479
#undef item
#line 1479
}
#line 1479

#line 1490 "filter/f-inst.c"
 /* Dump line for FI_ECLIST_FILTER_SET */
#line 1490
static inline void f_dump_line_item_FI_ECLIST_FILTER_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1490

#line 1490
{
#line 1490
#define item (&(item_->i_FI_ECLIST_FILTER_SET))
#line 1490
#undef item
#line 1490
}
#line 1490

#line 1497 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_FILTER_LCLIST */
#line 1497
static inline void f_dump_line_item_FI_LCLIST_FILTER_LCLIST(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1497

#line 1497
{
#line 1497
#define item (&(item_->i_FI_LCLIST_FILTER_LCLIST))
#line 1497
#undef item
#line 1497
}
#line 1497

#line 1508 "filter/f-inst.c"
 /* Dump line for FI_LCLIST_FILTER_SET */
#line 1508
static inline void f_dump_line_item_FI_LCLIST_FILTER_SET(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1508

#line 1508
{
#line 1508
#define item (&(item_->i_FI_LCLIST_FILTER_SET))
#line 1508
#undef item
#line 1508
}
#line 1508

#line 1530 "filter/f-inst.c"
 /* Dump line for FI_ROA_CHECK */
#line 1530
static inline void f_dump_line_item_FI_ROA_CHECK(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 1530

#line 1530
{
#line 1530
#define item (&(item_->i_FI_ROA_CHECK))
#line 1512 "filter/f-inst.c"
RDUMP("%s" "route table %s" "\n", INDENT, item->rtc->name);
#line 1512

#line 1530 "filter/f-inst.c"
#undef item
#line 1530
}
#line 1530

#line 1546 "filter/f-inst.c"
 /* Dump line for FI_ASPA_CHECK_EXPLICIT */
#line 1546
static inline void f_dump_line_item_FI_ASPA_CHECK_EXPLICIT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 1546

#line 1546
{
#line 1546
#define item (&(item_->i_FI_ASPA_CHECK_EXPLICIT))
#line 1534 "filter/f-inst.c"
RDUMP("%s" "route table %s" "\n", INDENT, item->rtc->name);
#line 1534

#line 1546 "filter/f-inst.c"
#undef item
#line 1546
}
#line 1546

#line 1561 "filter/f-inst.c"
 /* Dump line for FI_FROM_HEX */
#line 1561
static inline void f_dump_line_item_FI_FROM_HEX(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1561

#line 1561
{
#line 1561
#define item (&(item_->i_FI_FROM_HEX))
#line 1561
#undef item
#line 1561
}
#line 1561

#line 1566 "filter/f-inst.c"
 /* Dump line for FI_FORMAT */
#line 1566
static inline void f_dump_line_item_FI_FORMAT(struct dump_request *dreq UNUSED, const struct f_line_item *item UNUSED, const int indent UNUSED)
#line 1566

#line 1566
{
#line 1566
#define item (&(item_->i_FI_FORMAT))
#line 1566
#undef item
#line 1566
}
#line 1566

#line 830 "filter/decl.m4"
 /* Dump line for FI_ASSERT */
#line 830
static inline void f_dump_line_item_FI_ASSERT(struct dump_request *dreq, const struct f_line_item *item_, const int indent)
#line 830

#line 830
{
#line 830
#define item (&(item_->i_FI_ASSERT))
#line 1570 "filter/f-inst.c"
RDUMP("%s" "string %s" "\n", INDENT, item->s);
#line 1570

#line 830 "filter/decl.m4"
#undef item
#line 830
}
#line 830

#line 682 "filter/decl.m4"


void f_dump_line(struct dump_request *dreq, const struct f_line *dest, uint indent)
{
  if (!dest) {
    RDUMP("%sNo filter line (NULL)\n", INDENT);
    return;
  }
  RDUMP("%sFilter line %p (len=%u)\n", INDENT, dest, dest->len);
  for (uint i=0; i<dest->len; i++) {
    const struct f_line_item *item = &dest->items[i];
    RDUMP("%sInstruction %s at line %u\n", INDENT, f_instruction_name_(item->fi_code), item->lineno);
    switch (item->fi_code) {
#line 288 "filter/f-inst.c"
 /* Dump line caller for FI_ADD */
#line 288
case FI_ADD: f_dump_line_item_FI_ADD(dreq, item, indent + 1); break;
#line 288

#line 293 "filter/f-inst.c"
 /* Dump line caller for FI_SUBTRACT */
#line 293
case FI_SUBTRACT: f_dump_line_item_FI_SUBTRACT(dreq, item, indent + 1); break;
#line 293

#line 298 "filter/f-inst.c"
 /* Dump line caller for FI_MULTIPLY */
#line 298
case FI_MULTIPLY: f_dump_line_item_FI_MULTIPLY(dreq, item, indent + 1); break;
#line 298

#line 304 "filter/f-inst.c"
 /* Dump line caller for FI_DIVIDE */
#line 304
case FI_DIVIDE: f_dump_line_item_FI_DIVIDE(dreq, item, indent + 1); break;
#line 304

#line 309 "filter/f-inst.c"
 /* Dump line caller for FI_BITOR */
#line 309
case FI_BITOR: f_dump_line_item_FI_BITOR(dreq, item, indent + 1); break;
#line 309

#line 314 "filter/f-inst.c"
 /* Dump line caller for FI_BITAND */
#line 314
case FI_BITAND: f_dump_line_item_FI_BITAND(dreq, item, indent + 1); break;
#line 314

#line 324 "filter/f-inst.c"
 /* Dump line caller for FI_AND */
#line 324
case FI_AND: f_dump_line_item_FI_AND(dreq, item, indent + 1); break;
#line 324

#line 335 "filter/f-inst.c"
 /* Dump line caller for FI_OR */
#line 335
case FI_OR: f_dump_line_item_FI_OR(dreq, item, indent + 1); break;
#line 335

#line 345 "filter/f-inst.c"
 /* Dump line caller for FI_PAIR_CONSTRUCT */
#line 345
case FI_PAIR_CONSTRUCT: f_dump_line_item_FI_PAIR_CONSTRUCT(dreq, item, indent + 1); break;
#line 345

#line 385 "filter/f-inst.c"
 /* Dump line caller for FI_EC_CONSTRUCT */
#line 385
case FI_EC_CONSTRUCT: f_dump_line_item_FI_EC_CONSTRUCT(dreq, item, indent + 1); break;
#line 385

#line 392 "filter/f-inst.c"
 /* Dump line caller for FI_LC_CONSTRUCT */
#line 392
case FI_LC_CONSTRUCT: f_dump_line_item_FI_LC_CONSTRUCT(dreq, item, indent + 1); break;
#line 392

#line 442 "filter/f-inst.c"
 /* Dump line caller for FI_PATHMASK_CONSTRUCT */
#line 442
case FI_PATHMASK_CONSTRUCT: f_dump_line_item_FI_PATHMASK_CONSTRUCT(dreq, item, indent + 1); break;
#line 442

#line 449 "filter/f-inst.c"
 /* Dump line caller for FI_NEQ */
#line 449
case FI_NEQ: f_dump_line_item_FI_NEQ(dreq, item, indent + 1); break;
#line 449

#line 456 "filter/f-inst.c"
 /* Dump line caller for FI_EQ */
#line 456
case FI_EQ: f_dump_line_item_FI_EQ(dreq, item, indent + 1); break;
#line 456

#line 467 "filter/f-inst.c"
 /* Dump line caller for FI_LT */
#line 467
case FI_LT: f_dump_line_item_FI_LT(dreq, item, indent + 1); break;
#line 467

#line 478 "filter/f-inst.c"
 /* Dump line caller for FI_LTE */
#line 478
case FI_LTE: f_dump_line_item_FI_LTE(dreq, item, indent + 1); break;
#line 478

#line 483 "filter/f-inst.c"
 /* Dump line caller for FI_NOT */
#line 483
case FI_NOT: f_dump_line_item_FI_NOT(dreq, item, indent + 1); break;
#line 483

#line 492 "filter/f-inst.c"
 /* Dump line caller for FI_MATCH */
#line 492
case FI_MATCH: f_dump_line_item_FI_MATCH(dreq, item, indent + 1); break;
#line 492

#line 501 "filter/f-inst.c"
 /* Dump line caller for FI_NOT_MATCH */
#line 501
case FI_NOT_MATCH: f_dump_line_item_FI_NOT_MATCH(dreq, item, indent + 1); break;
#line 501

#line 506 "filter/f-inst.c"
 /* Dump line caller for FI_DEFINED */
#line 506
case FI_DEFINED: f_dump_line_item_FI_DEFINED(dreq, item, indent + 1); break;
#line 506

#line 507 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_NET__type */
#line 507
case FI_METHOD__T_NET__type: f_dump_line_item_FI_METHOD__T_NET__type(dreq, item, indent + 1); break;
#line 507

#line 510 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_IP__is_v4 */
#line 510
case FI_METHOD__T_IP__is_v4: f_dump_line_item_FI_METHOD__T_IP__is_v4(dreq, item, indent + 1); break;
#line 510

#line 523 "filter/f-inst.c"
 /* Dump line caller for FI_VAR_INIT */
#line 523
case FI_VAR_INIT: f_dump_line_item_FI_VAR_INIT(dreq, item, indent + 1); break;
#line 523

#line 534 "filter/f-inst.c"
 /* Dump line caller for FI_VAR_INIT0 */
#line 534
case FI_VAR_INIT0: f_dump_line_item_FI_VAR_INIT0(dreq, item, indent + 1); break;
#line 534

#line 543 "filter/f-inst.c"
 /* Dump line caller for FI_VAR_SET */
#line 543
case FI_VAR_SET: f_dump_line_item_FI_VAR_SET(dreq, item, indent + 1); break;
#line 543

#line 550 "filter/f-inst.c"
 /* Dump line caller for FI_VAR_GET */
#line 550
case FI_VAR_GET: f_dump_line_item_FI_VAR_GET(dreq, item, indent + 1); break;
#line 550

#line 563 "filter/f-inst.c"
 /* Dump line caller for FI_CONSTANT */
#line 563
case FI_CONSTANT: f_dump_line_item_FI_CONSTANT(dreq, item, indent + 1); break;
#line 563

#line 564 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PATH__empty */
#line 564
case FI_METHOD__T_PATH__empty: f_dump_line_item_FI_METHOD__T_PATH__empty(dreq, item, indent + 1); break;
#line 564

#line 565 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_CLIST__empty */
#line 565
case FI_METHOD__T_CLIST__empty: f_dump_line_item_FI_METHOD__T_CLIST__empty(dreq, item, indent + 1); break;
#line 565

#line 566 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_ECLIST__empty */
#line 566
case FI_METHOD__T_ECLIST__empty: f_dump_line_item_FI_METHOD__T_ECLIST__empty(dreq, item, indent + 1); break;
#line 566

#line 569 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LCLIST__empty */
#line 569
case FI_METHOD__T_LCLIST__empty: f_dump_line_item_FI_METHOD__T_LCLIST__empty(dreq, item, indent + 1); break;
#line 569

#line 591 "filter/f-inst.c"
 /* Dump line caller for FI_FOR_LOOP_START */
#line 591
case FI_FOR_LOOP_START: f_dump_line_item_FI_FOR_LOOP_START(dreq, item, indent + 1); break;
#line 591

#line 600 "filter/f-inst.c"
 /* Dump line caller for FI_PATH_FOR_NEXT */
#line 600
case FI_PATH_FOR_NEXT: f_dump_line_item_FI_PATH_FOR_NEXT(dreq, item, indent + 1); break;
#line 600

#line 609 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_FOR_NEXT */
#line 609
case FI_CLIST_FOR_NEXT: f_dump_line_item_FI_CLIST_FOR_NEXT(dreq, item, indent + 1); break;
#line 609

#line 618 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_FOR_NEXT */
#line 618
case FI_ECLIST_FOR_NEXT: f_dump_line_item_FI_ECLIST_FOR_NEXT(dreq, item, indent + 1); break;
#line 618

#line 627 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_FOR_NEXT */
#line 627
case FI_LCLIST_FOR_NEXT: f_dump_line_item_FI_LCLIST_FOR_NEXT(dreq, item, indent + 1); break;
#line 627

#line 640 "filter/f-inst.c"
 /* Dump line caller for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
case FI_ROUTES_BLOCK_FOR_NEXT: f_dump_line_item_FI_ROUTES_BLOCK_FOR_NEXT(dreq, item, indent + 1); break;
#line 640

#line 648 "filter/f-inst.c"
 /* Dump line caller for FI_CONDITION */
#line 648
case FI_CONDITION: f_dump_line_item_FI_CONDITION(dreq, item, indent + 1); break;
#line 648

#line 661 "filter/f-inst.c"
 /* Dump line caller for FI_PRINT */
#line 661
case FI_PRINT: f_dump_line_item_FI_PRINT(dreq, item, indent + 1); break;
#line 661

#line 668 "filter/f-inst.c"
 /* Dump line caller for FI_FLUSH */
#line 668
case FI_FLUSH: f_dump_line_item_FI_FLUSH(dreq, item, indent + 1); break;
#line 668

#line 682 "filter/f-inst.c"
 /* Dump line caller for FI_DIE */
#line 682
case FI_DIE: f_dump_line_item_FI_DIE(dreq, item, indent + 1); break;
#line 682

#line 689 "filter/f-inst.c"
 /* Dump line caller for FI_CURRENT_ROUTE */
#line 689
case FI_CURRENT_ROUTE: f_dump_line_item_FI_CURRENT_ROUTE(dreq, item, indent + 1); break;
#line 689

#line 737 "filter/f-inst.c"
 /* Dump line caller for FI_RTA_GET */
#line 737
case FI_RTA_GET: f_dump_line_item_FI_RTA_GET(dreq, item, indent + 1); break;
#line 737

#line 866 "filter/f-inst.c"
 /* Dump line caller for FI_RTA_SET */
#line 866
case FI_RTA_SET: f_dump_line_item_FI_RTA_SET(dreq, item, indent + 1); break;
#line 866

#line 903 "filter/f-inst.c"
 /* Dump line caller for FI_EA_GET */
#line 903
case FI_EA_GET: f_dump_line_item_FI_EA_GET(dreq, item, indent + 1); break;
#line 903

#line 944 "filter/f-inst.c"
 /* Dump line caller for FI_EA_SET */
#line 944
case FI_EA_SET: f_dump_line_item_FI_EA_SET(dreq, item, indent + 1); break;
#line 944

#line 951 "filter/f-inst.c"
 /* Dump line caller for FI_EA_UNSET */
#line 951
case FI_EA_UNSET: f_dump_line_item_FI_EA_UNSET(dreq, item, indent + 1); break;
#line 951

#line 965 "filter/f-inst.c"
 /* Dump line caller for FI_DEFAULT */
#line 965
case FI_DEFAULT: f_dump_line_item_FI_DEFAULT(dreq, item, indent + 1); break;
#line 965

#line 966 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_NET__len */
#line 966
case FI_METHOD__T_NET__len: f_dump_line_item_FI_METHOD__T_NET__len(dreq, item, indent + 1); break;
#line 966

#line 967 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PATH__len */
#line 967
case FI_METHOD__T_PATH__len: f_dump_line_item_FI_METHOD__T_PATH__len(dreq, item, indent + 1); break;
#line 967

#line 968 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_CLIST__len */
#line 968
case FI_METHOD__T_CLIST__len: f_dump_line_item_FI_METHOD__T_CLIST__len(dreq, item, indent + 1); break;
#line 968

#line 969 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_ECLIST__len */
#line 969
case FI_METHOD__T_ECLIST__len: f_dump_line_item_FI_METHOD__T_ECLIST__len(dreq, item, indent + 1); break;
#line 969

#line 971 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LCLIST__len */
#line 971
case FI_METHOD__T_LCLIST__len: f_dump_line_item_FI_METHOD__T_LCLIST__len(dreq, item, indent + 1); break;
#line 971

#line 1007 "filter/f-inst.c"
 /* Dump line caller for FI_NET_SRC */
#line 1007
case FI_NET_SRC: f_dump_line_item_FI_NET_SRC(dreq, item, indent + 1); break;
#line 1007

#line 1044 "filter/f-inst.c"
 /* Dump line caller for FI_NET_DST */
#line 1044
case FI_NET_DST: f_dump_line_item_FI_NET_DST(dreq, item, indent + 1); break;
#line 1044

#line 1054 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_NET__maxlen */
#line 1054
case FI_METHOD__T_NET__maxlen: f_dump_line_item_FI_METHOD__T_NET__maxlen(dreq, item, indent + 1); break;
#line 1054

#line 1064 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_NET__asn */
#line 1064
case FI_METHOD__T_NET__asn: f_dump_line_item_FI_METHOD__T_NET__asn(dreq, item, indent + 1); break;
#line 1064

#line 1066 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_NET__ip */
#line 1066
case FI_METHOD__T_NET__ip: f_dump_line_item_FI_METHOD__T_NET__ip(dreq, item, indent + 1); break;
#line 1066

#line 1075 "filter/f-inst.c"
 /* Dump line caller for FI_ROUTE_DISTINGUISHER */
#line 1075
case FI_ROUTE_DISTINGUISHER: f_dump_line_item_FI_ROUTE_DISTINGUISHER(dreq, item, indent + 1); break;
#line 1075

#line 1078 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PATH__first */
#line 1078
case FI_METHOD__T_PATH__first: f_dump_line_item_FI_METHOD__T_PATH__first(dreq, item, indent + 1); break;
#line 1078

#line 1081 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PATH__last */
#line 1081
case FI_METHOD__T_PATH__last: f_dump_line_item_FI_METHOD__T_PATH__last(dreq, item, indent + 1); break;
#line 1081

#line 1084 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PATH__last_nonaggregated */
#line 1084
case FI_METHOD__T_PATH__last_nonaggregated: f_dump_line_item_FI_METHOD__T_PATH__last_nonaggregated(dreq, item, indent + 1); break;
#line 1084

#line 1087 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PAIR__asn */
#line 1087
case FI_METHOD__T_PAIR__asn: f_dump_line_item_FI_METHOD__T_PAIR__asn(dreq, item, indent + 1); break;
#line 1087

#line 1090 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_PAIR__data */
#line 1090
case FI_METHOD__T_PAIR__data: f_dump_line_item_FI_METHOD__T_PAIR__data(dreq, item, indent + 1); break;
#line 1090

#line 1093 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LC__asn */
#line 1093
case FI_METHOD__T_LC__asn: f_dump_line_item_FI_METHOD__T_LC__asn(dreq, item, indent + 1); break;
#line 1093

#line 1096 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LC__data1 */
#line 1096
case FI_METHOD__T_LC__data1: f_dump_line_item_FI_METHOD__T_LC__data1(dreq, item, indent + 1); break;
#line 1096

#line 1099 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LC__data2 */
#line 1099
case FI_METHOD__T_LC__data2: f_dump_line_item_FI_METHOD__T_LC__data2(dreq, item, indent + 1); break;
#line 1099

#line 1102 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_CLIST__min */
#line 1102
case FI_METHOD__T_CLIST__min: f_dump_line_item_FI_METHOD__T_CLIST__min(dreq, item, indent + 1); break;
#line 1102

#line 1105 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_CLIST__max */
#line 1105
case FI_METHOD__T_CLIST__max: f_dump_line_item_FI_METHOD__T_CLIST__max(dreq, item, indent + 1); break;
#line 1105

#line 1108 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_ECLIST__min */
#line 1108
case FI_METHOD__T_ECLIST__min: f_dump_line_item_FI_METHOD__T_ECLIST__min(dreq, item, indent + 1); break;
#line 1108

#line 1111 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_ECLIST__max */
#line 1111
case FI_METHOD__T_ECLIST__max: f_dump_line_item_FI_METHOD__T_ECLIST__max(dreq, item, indent + 1); break;
#line 1111

#line 1114 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LCLIST__min */
#line 1114
case FI_METHOD__T_LCLIST__min: f_dump_line_item_FI_METHOD__T_LCLIST__min(dreq, item, indent + 1); break;
#line 1114

#line 1116 "filter/f-inst.c"
 /* Dump line caller for FI_METHOD__T_LCLIST__max */
#line 1116
case FI_METHOD__T_LCLIST__max: f_dump_line_item_FI_METHOD__T_LCLIST__max(dreq, item, indent + 1); break;
#line 1116

#line 1142 "filter/f-inst.c"
 /* Dump line caller for FI_RETURN */
#line 1142
case FI_RETURN: f_dump_line_item_FI_RETURN(dreq, item, indent + 1); break;
#line 1142

#line 1202 "filter/f-inst.c"
 /* Dump line caller for FI_CALL */
#line 1202
case FI_CALL: f_dump_line_item_FI_CALL(dreq, item, indent + 1); break;
#line 1202

#line 1207 "filter/f-inst.c"
 /* Dump line caller for FI_DROP_RESULT */
#line 1207
case FI_DROP_RESULT: f_dump_line_item_FI_DROP_RESULT(dreq, item, indent + 1); break;
#line 1207

#line 1248 "filter/f-inst.c"
 /* Dump line caller for FI_SWITCH */
#line 1248
case FI_SWITCH: f_dump_line_item_FI_SWITCH(dreq, item, indent + 1); break;
#line 1248

#line 1257 "filter/f-inst.c"
 /* Dump line caller for FI_IP_MASK */
#line 1257
case FI_IP_MASK: f_dump_line_item_FI_IP_MASK(dreq, item, indent + 1); break;
#line 1257

#line 1265 "filter/f-inst.c"
 /* Dump line caller for FI_PATH_PREPEND */
#line 1265
case FI_PATH_PREPEND: f_dump_line_item_FI_PATH_PREPEND(dreq, item, indent + 1); break;
#line 1265

#line 1272 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_ADD_PAIR */
#line 1272
case FI_CLIST_ADD_PAIR: f_dump_line_item_FI_CLIST_ADD_PAIR(dreq, item, indent + 1); break;
#line 1272

#line 1286 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_ADD_IP */
#line 1286
case FI_CLIST_ADD_IP: f_dump_line_item_FI_CLIST_ADD_IP(dreq, item, indent + 1); break;
#line 1286

#line 1293 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_ADD_QUAD */
#line 1293
case FI_CLIST_ADD_QUAD: f_dump_line_item_FI_CLIST_ADD_QUAD(dreq, item, indent + 1); break;
#line 1293

#line 1300 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_ADD_CLIST */
#line 1300
case FI_CLIST_ADD_CLIST: f_dump_line_item_FI_CLIST_ADD_CLIST(dreq, item, indent + 1); break;
#line 1300

#line 1307 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_ADD_EC */
#line 1307
case FI_ECLIST_ADD_EC: f_dump_line_item_FI_ECLIST_ADD_EC(dreq, item, indent + 1); break;
#line 1307

#line 1314 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_ADD_ECLIST */
#line 1314
case FI_ECLIST_ADD_ECLIST: f_dump_line_item_FI_ECLIST_ADD_ECLIST(dreq, item, indent + 1); break;
#line 1314

#line 1321 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_ADD_LC */
#line 1321
case FI_LCLIST_ADD_LC: f_dump_line_item_FI_LCLIST_ADD_LC(dreq, item, indent + 1); break;
#line 1321

#line 1328 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_ADD_LCLIST */
#line 1328
case FI_LCLIST_ADD_LCLIST: f_dump_line_item_FI_LCLIST_ADD_LCLIST(dreq, item, indent + 1); break;
#line 1328

#line 1335 "filter/f-inst.c"
 /* Dump line caller for FI_PATH_DELETE_INT */
#line 1335
case FI_PATH_DELETE_INT: f_dump_line_item_FI_PATH_DELETE_INT(dreq, item, indent + 1); break;
#line 1335

#line 1347 "filter/f-inst.c"
 /* Dump line caller for FI_PATH_DELETE_SET */
#line 1347
case FI_PATH_DELETE_SET: f_dump_line_item_FI_PATH_DELETE_SET(dreq, item, indent + 1); break;
#line 1347

#line 1354 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_DELETE_PAIR */
#line 1354
case FI_CLIST_DELETE_PAIR: f_dump_line_item_FI_CLIST_DELETE_PAIR(dreq, item, indent + 1); break;
#line 1354

#line 1368 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_DELETE_IP */
#line 1368
case FI_CLIST_DELETE_IP: f_dump_line_item_FI_CLIST_DELETE_IP(dreq, item, indent + 1); break;
#line 1368

#line 1375 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_DELETE_QUAD */
#line 1375
case FI_CLIST_DELETE_QUAD: f_dump_line_item_FI_CLIST_DELETE_QUAD(dreq, item, indent + 1); break;
#line 1375

#line 1382 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_DELETE_CLIST */
#line 1382
case FI_CLIST_DELETE_CLIST: f_dump_line_item_FI_CLIST_DELETE_CLIST(dreq, item, indent + 1); break;
#line 1382

#line 1393 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_DELETE_SET */
#line 1393
case FI_CLIST_DELETE_SET: f_dump_line_item_FI_CLIST_DELETE_SET(dreq, item, indent + 1); break;
#line 1393

#line 1400 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_DELETE_EC */
#line 1400
case FI_ECLIST_DELETE_EC: f_dump_line_item_FI_ECLIST_DELETE_EC(dreq, item, indent + 1); break;
#line 1400

#line 1407 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_DELETE_ECLIST */
#line 1407
case FI_ECLIST_DELETE_ECLIST: f_dump_line_item_FI_ECLIST_DELETE_ECLIST(dreq, item, indent + 1); break;
#line 1407

#line 1418 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_DELETE_SET */
#line 1418
case FI_ECLIST_DELETE_SET: f_dump_line_item_FI_ECLIST_DELETE_SET(dreq, item, indent + 1); break;
#line 1418

#line 1425 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_DELETE_LC */
#line 1425
case FI_LCLIST_DELETE_LC: f_dump_line_item_FI_LCLIST_DELETE_LC(dreq, item, indent + 1); break;
#line 1425

#line 1432 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_DELETE_LCLIST */
#line 1432
case FI_LCLIST_DELETE_LCLIST: f_dump_line_item_FI_LCLIST_DELETE_LCLIST(dreq, item, indent + 1); break;
#line 1432

#line 1443 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_DELETE_SET */
#line 1443
case FI_LCLIST_DELETE_SET: f_dump_line_item_FI_LCLIST_DELETE_SET(dreq, item, indent + 1); break;
#line 1443

#line 1454 "filter/f-inst.c"
 /* Dump line caller for FI_PATH_FILTER_SET */
#line 1454
case FI_PATH_FILTER_SET: f_dump_line_item_FI_PATH_FILTER_SET(dreq, item, indent + 1); break;
#line 1454

#line 1461 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_FILTER_CLIST */
#line 1461
case FI_CLIST_FILTER_CLIST: f_dump_line_item_FI_CLIST_FILTER_CLIST(dreq, item, indent + 1); break;
#line 1461

#line 1472 "filter/f-inst.c"
 /* Dump line caller for FI_CLIST_FILTER_SET */
#line 1472
case FI_CLIST_FILTER_SET: f_dump_line_item_FI_CLIST_FILTER_SET(dreq, item, indent + 1); break;
#line 1472

#line 1479 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_FILTER_ECLIST */
#line 1479
case FI_ECLIST_FILTER_ECLIST: f_dump_line_item_FI_ECLIST_FILTER_ECLIST(dreq, item, indent + 1); break;
#line 1479

#line 1490 "filter/f-inst.c"
 /* Dump line caller for FI_ECLIST_FILTER_SET */
#line 1490
case FI_ECLIST_FILTER_SET: f_dump_line_item_FI_ECLIST_FILTER_SET(dreq, item, indent + 1); break;
#line 1490

#line 1497 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_FILTER_LCLIST */
#line 1497
case FI_LCLIST_FILTER_LCLIST: f_dump_line_item_FI_LCLIST_FILTER_LCLIST(dreq, item, indent + 1); break;
#line 1497

#line 1508 "filter/f-inst.c"
 /* Dump line caller for FI_LCLIST_FILTER_SET */
#line 1508
case FI_LCLIST_FILTER_SET: f_dump_line_item_FI_LCLIST_FILTER_SET(dreq, item, indent + 1); break;
#line 1508

#line 1530 "filter/f-inst.c"
 /* Dump line caller for FI_ROA_CHECK */
#line 1530
case FI_ROA_CHECK: f_dump_line_item_FI_ROA_CHECK(dreq, item, indent + 1); break;
#line 1530

#line 1546 "filter/f-inst.c"
 /* Dump line caller for FI_ASPA_CHECK_EXPLICIT */
#line 1546
case FI_ASPA_CHECK_EXPLICIT: f_dump_line_item_FI_ASPA_CHECK_EXPLICIT(dreq, item, indent + 1); break;
#line 1546

#line 1561 "filter/f-inst.c"
 /* Dump line caller for FI_FROM_HEX */
#line 1561
case FI_FROM_HEX: f_dump_line_item_FI_FROM_HEX(dreq, item, indent + 1); break;
#line 1561

#line 1566 "filter/f-inst.c"
 /* Dump line caller for FI_FORMAT */
#line 1566
case FI_FORMAT: f_dump_line_item_FI_FORMAT(dreq, item, indent + 1); break;
#line 1566

#line 830 "filter/decl.m4"
 /* Dump line caller for FI_ASSERT */
#line 830
case FI_ASSERT: f_dump_line_item_FI_ASSERT(dreq, item, indent + 1); break;
#line 830

#line 695 "filter/decl.m4"

      default: bug("Unknown instruction %x in f_dump_line", item->fi_code);
    }
  }
  RDUMP("%sFilter line %p dump done\n", INDENT, dest);
}

/* Linearize */
static uint
linearize(struct f_line *dest, const struct f_inst *what, uint pos)
{
  for ( ; what; what = what->next) {
    switch (what->fi_code) {
#line 288 "filter/f-inst.c"
 /* Linearize for FI_ADD */
#line 288
case FI_ADD: {
#line 288
#define whati (&(what->i_FI_ADD))
#line 288
#define item (&(dest->items[pos].i_FI_ADD))
#line 288
  #line 284 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 285 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 288 "filter/f-inst.c"
#undef item
#line 288
  dest->items[pos].fi_code = what->fi_code;
#line 288
  dest->items[pos].flags = what->flags;
#line 288
  dest->items[pos].lineno = what->lineno;
#line 288
  break;
#line 288
}
#line 288

#line 293 "filter/f-inst.c"
 /* Linearize for FI_SUBTRACT */
#line 293
case FI_SUBTRACT: {
#line 293
#define whati (&(what->i_FI_SUBTRACT))
#line 293
#define item (&(dest->items[pos].i_FI_SUBTRACT))
#line 293
  #line 289 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 290 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 293 "filter/f-inst.c"
#undef item
#line 293
  dest->items[pos].fi_code = what->fi_code;
#line 293
  dest->items[pos].flags = what->flags;
#line 293
  dest->items[pos].lineno = what->lineno;
#line 293
  break;
#line 293
}
#line 293

#line 298 "filter/f-inst.c"
 /* Linearize for FI_MULTIPLY */
#line 298
case FI_MULTIPLY: {
#line 298
#define whati (&(what->i_FI_MULTIPLY))
#line 298
#define item (&(dest->items[pos].i_FI_MULTIPLY))
#line 298
  #line 294 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 295 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 298 "filter/f-inst.c"
#undef item
#line 298
  dest->items[pos].fi_code = what->fi_code;
#line 298
  dest->items[pos].flags = what->flags;
#line 298
  dest->items[pos].lineno = what->lineno;
#line 298
  break;
#line 298
}
#line 298

#line 304 "filter/f-inst.c"
 /* Linearize for FI_DIVIDE */
#line 304
case FI_DIVIDE: {
#line 304
#define whati (&(what->i_FI_DIVIDE))
#line 304
#define item (&(dest->items[pos].i_FI_DIVIDE))
#line 304
  #line 299 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 300 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 304 "filter/f-inst.c"
#undef item
#line 304
  dest->items[pos].fi_code = what->fi_code;
#line 304
  dest->items[pos].flags = what->flags;
#line 304
  dest->items[pos].lineno = what->lineno;
#line 304
  break;
#line 304
}
#line 304

#line 309 "filter/f-inst.c"
 /* Linearize for FI_BITOR */
#line 309
case FI_BITOR: {
#line 309
#define whati (&(what->i_FI_BITOR))
#line 309
#define item (&(dest->items[pos].i_FI_BITOR))
#line 309
  #line 305 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 306 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 309 "filter/f-inst.c"
#undef item
#line 309
  dest->items[pos].fi_code = what->fi_code;
#line 309
  dest->items[pos].flags = what->flags;
#line 309
  dest->items[pos].lineno = what->lineno;
#line 309
  break;
#line 309
}
#line 309

#line 314 "filter/f-inst.c"
 /* Linearize for FI_BITAND */
#line 314
case FI_BITAND: {
#line 314
#define whati (&(what->i_FI_BITAND))
#line 314
#define item (&(dest->items[pos].i_FI_BITAND))
#line 314
  #line 310 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 311 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 314 "filter/f-inst.c"
#undef item
#line 314
  dest->items[pos].fi_code = what->fi_code;
#line 314
  dest->items[pos].flags = what->flags;
#line 314
  dest->items[pos].lineno = what->lineno;
#line 314
  break;
#line 314
}
#line 314

#line 324 "filter/f-inst.c"
 /* Linearize for FI_AND */
#line 324
case FI_AND: {
#line 324
#define whati (&(what->i_FI_AND))
#line 324
#define item (&(dest->items[pos].i_FI_AND))
#line 324
  #line 315 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 320 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 1);
#undef whati
#line 324 "filter/f-inst.c"
#undef item
#line 324
  dest->items[pos].fi_code = what->fi_code;
#line 324
  dest->items[pos].flags = what->flags;
#line 324
  dest->items[pos].lineno = what->lineno;
#line 324
  break;
#line 324
}
#line 324

#line 335 "filter/f-inst.c"
 /* Linearize for FI_OR */
#line 335
case FI_OR: {
#line 335
#define whati (&(what->i_FI_OR))
#line 335
#define item (&(dest->items[pos].i_FI_OR))
#line 335
  #line 325 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 330 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 1);
#undef whati
#line 335 "filter/f-inst.c"
#undef item
#line 335
  dest->items[pos].fi_code = what->fi_code;
#line 335
  dest->items[pos].flags = what->flags;
#line 335
  dest->items[pos].lineno = what->lineno;
#line 335
  break;
#line 335
}
#line 335

#line 345 "filter/f-inst.c"
 /* Linearize for FI_PAIR_CONSTRUCT */
#line 345
case FI_PAIR_CONSTRUCT: {
#line 345
#define whati (&(what->i_FI_PAIR_CONSTRUCT))
#line 345
#define item (&(dest->items[pos].i_FI_PAIR_CONSTRUCT))
#line 345
  #line 336 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 337 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 345 "filter/f-inst.c"
#undef item
#line 345
  dest->items[pos].fi_code = what->fi_code;
#line 345
  dest->items[pos].flags = what->flags;
#line 345
  dest->items[pos].lineno = what->lineno;
#line 345
  break;
#line 345
}
#line 345

#line 385 "filter/f-inst.c"
 /* Linearize for FI_EC_CONSTRUCT */
#line 385
case FI_EC_CONSTRUCT: {
#line 385
#define whati (&(what->i_FI_EC_CONSTRUCT))
#line 385
#define item (&(dest->items[pos].i_FI_EC_CONSTRUCT))
#line 385
  #line 346 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 347 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#line 349 "filter/f-inst.c"
item->ecs = whati->ecs;
#line 349

#undef whati
#line 385 "filter/f-inst.c"
#undef item
#line 385
  dest->items[pos].fi_code = what->fi_code;
#line 385
  dest->items[pos].flags = what->flags;
#line 385
  dest->items[pos].lineno = what->lineno;
#line 385
  break;
#line 385
}
#line 385

#line 392 "filter/f-inst.c"
 /* Linearize for FI_LC_CONSTRUCT */
#line 392
case FI_LC_CONSTRUCT: {
#line 392
#define whati (&(what->i_FI_LC_CONSTRUCT))
#line 392
#define item (&(dest->items[pos].i_FI_LC_CONSTRUCT))
#line 392
  #line 386 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 387 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#line 388 "filter/f-inst.c"
pos = linearize(dest, whati->f3, pos);
#undef whati
#line 392 "filter/f-inst.c"
#undef item
#line 392
  dest->items[pos].fi_code = what->fi_code;
#line 392
  dest->items[pos].flags = what->flags;
#line 392
  dest->items[pos].lineno = what->lineno;
#line 392
  break;
#line 392
}
#line 392

#line 442 "filter/f-inst.c"
 /* Linearize for FI_PATHMASK_CONSTRUCT */
#line 442
case FI_PATHMASK_CONSTRUCT: {
#line 442
#define whati (&(what->i_FI_PATHMASK_CONSTRUCT))
#line 442
#define item (&(dest->items[pos].i_FI_PATHMASK_CONSTRUCT))
#line 442
  #line 393 "filter/f-inst.c"
  pos = linearize(dest, whati->fvar, pos);
#line 393
  item->varcount = whati->varcount;
#undef whati
#line 442 "filter/f-inst.c"
#undef item
#line 442
  dest->items[pos].fi_code = what->fi_code;
#line 442
  dest->items[pos].flags = what->flags;
#line 442
  dest->items[pos].lineno = what->lineno;
#line 442
  break;
#line 442
}
#line 442

#line 449 "filter/f-inst.c"
 /* Linearize for FI_NEQ */
#line 449
case FI_NEQ: {
#line 449
#define whati (&(what->i_FI_NEQ))
#line 449
#define item (&(dest->items[pos].i_FI_NEQ))
#line 449
  #line 443 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 444 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 449 "filter/f-inst.c"
#undef item
#line 449
  dest->items[pos].fi_code = what->fi_code;
#line 449
  dest->items[pos].flags = what->flags;
#line 449
  dest->items[pos].lineno = what->lineno;
#line 449
  break;
#line 449
}
#line 449

#line 456 "filter/f-inst.c"
 /* Linearize for FI_EQ */
#line 456
case FI_EQ: {
#line 456
#define whati (&(what->i_FI_EQ))
#line 456
#define item (&(dest->items[pos].i_FI_EQ))
#line 456
  #line 450 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 451 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 456 "filter/f-inst.c"
#undef item
#line 456
  dest->items[pos].fi_code = what->fi_code;
#line 456
  dest->items[pos].flags = what->flags;
#line 456
  dest->items[pos].lineno = what->lineno;
#line 456
  break;
#line 456
}
#line 456

#line 467 "filter/f-inst.c"
 /* Linearize for FI_LT */
#line 467
case FI_LT: {
#line 467
#define whati (&(what->i_FI_LT))
#line 467
#define item (&(dest->items[pos].i_FI_LT))
#line 467
  #line 457 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 458 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 467 "filter/f-inst.c"
#undef item
#line 467
  dest->items[pos].fi_code = what->fi_code;
#line 467
  dest->items[pos].flags = what->flags;
#line 467
  dest->items[pos].lineno = what->lineno;
#line 467
  break;
#line 467
}
#line 467

#line 478 "filter/f-inst.c"
 /* Linearize for FI_LTE */
#line 478
case FI_LTE: {
#line 478
#define whati (&(what->i_FI_LTE))
#line 478
#define item (&(dest->items[pos].i_FI_LTE))
#line 478
  #line 468 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 469 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 478 "filter/f-inst.c"
#undef item
#line 478
  dest->items[pos].fi_code = what->fi_code;
#line 478
  dest->items[pos].flags = what->flags;
#line 478
  dest->items[pos].lineno = what->lineno;
#line 478
  break;
#line 478
}
#line 478

#line 483 "filter/f-inst.c"
 /* Linearize for FI_NOT */
#line 483
case FI_NOT: {
#line 483
#define whati (&(what->i_FI_NOT))
#line 483
#define item (&(dest->items[pos].i_FI_NOT))
#line 483
  #line 479 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 483 "filter/f-inst.c"
#undef item
#line 483
  dest->items[pos].fi_code = what->fi_code;
#line 483
  dest->items[pos].flags = what->flags;
#line 483
  dest->items[pos].lineno = what->lineno;
#line 483
  break;
#line 483
}
#line 483

#line 492 "filter/f-inst.c"
 /* Linearize for FI_MATCH */
#line 492
case FI_MATCH: {
#line 492
#define whati (&(what->i_FI_MATCH))
#line 492
#define item (&(dest->items[pos].i_FI_MATCH))
#line 492
  #line 484 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 485 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 492 "filter/f-inst.c"
#undef item
#line 492
  dest->items[pos].fi_code = what->fi_code;
#line 492
  dest->items[pos].flags = what->flags;
#line 492
  dest->items[pos].lineno = what->lineno;
#line 492
  break;
#line 492
}
#line 492

#line 501 "filter/f-inst.c"
 /* Linearize for FI_NOT_MATCH */
#line 501
case FI_NOT_MATCH: {
#line 501
#define whati (&(what->i_FI_NOT_MATCH))
#line 501
#define item (&(dest->items[pos].i_FI_NOT_MATCH))
#line 501
  #line 493 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 494 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 501 "filter/f-inst.c"
#undef item
#line 501
  dest->items[pos].fi_code = what->fi_code;
#line 501
  dest->items[pos].flags = what->flags;
#line 501
  dest->items[pos].lineno = what->lineno;
#line 501
  break;
#line 501
}
#line 501

#line 506 "filter/f-inst.c"
 /* Linearize for FI_DEFINED */
#line 506
case FI_DEFINED: {
#line 506
#define whati (&(what->i_FI_DEFINED))
#line 506
#define item (&(dest->items[pos].i_FI_DEFINED))
#line 506
  #line 502 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 506 "filter/f-inst.c"
#undef item
#line 506
  dest->items[pos].fi_code = what->fi_code;
#line 506
  dest->items[pos].flags = what->flags;
#line 506
  dest->items[pos].lineno = what->lineno;
#line 506
  break;
#line 506
}
#line 506

#line 507 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_NET__type */
#line 507
case FI_METHOD__T_NET__type: {
#line 507
#define whati (&(what->i_FI_METHOD__T_NET__type))
#line 507
#define item (&(dest->items[pos].i_FI_METHOD__T_NET__type))
#line 507
  #line 506 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 507 "filter/f-inst.c"
#undef item
#line 507
  dest->items[pos].fi_code = what->fi_code;
#line 507
  dest->items[pos].flags = what->flags;
#line 507
  dest->items[pos].lineno = what->lineno;
#line 507
  break;
#line 507
}
#line 507

#line 510 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_IP__is_v4 */
#line 510
case FI_METHOD__T_IP__is_v4: {
#line 510
#define whati (&(what->i_FI_METHOD__T_IP__is_v4))
#line 510
#define item (&(dest->items[pos].i_FI_METHOD__T_IP__is_v4))
#line 510
  #line 507 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 510 "filter/f-inst.c"
#undef item
#line 510
  dest->items[pos].fi_code = what->fi_code;
#line 510
  dest->items[pos].flags = what->flags;
#line 510
  dest->items[pos].lineno = what->lineno;
#line 510
  break;
#line 510
}
#line 510

#line 523 "filter/f-inst.c"
 /* Linearize for FI_VAR_INIT */
#line 523
case FI_VAR_INIT: {
#line 523
#define whati (&(what->i_FI_VAR_INIT))
#line 523
#define item (&(dest->items[pos].i_FI_VAR_INIT))
#line 523
  #line 512 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 513 "filter/f-inst.c"
item->sym = whati->sym;
#line 513

#undef whati
#line 523 "filter/f-inst.c"
#undef item
#line 523
  dest->items[pos].fi_code = what->fi_code;
#line 523
  dest->items[pos].flags = what->flags;
#line 523
  dest->items[pos].lineno = what->lineno;
#line 523
  break;
#line 523
}
#line 523

#line 534 "filter/f-inst.c"
 /* Linearize for FI_VAR_INIT0 */
#line 534
case FI_VAR_INIT0: {
#line 534
#define whati (&(what->i_FI_VAR_INIT0))
#line 534
#define item (&(dest->items[pos].i_FI_VAR_INIT0))
#line 534
  #line 525 "filter/f-inst.c"
item->sym = whati->sym;
#line 525

#undef whati
#line 534 "filter/f-inst.c"
#undef item
#line 534
  dest->items[pos].fi_code = what->fi_code;
#line 534
  dest->items[pos].flags = what->flags;
#line 534
  dest->items[pos].lineno = what->lineno;
#line 534
  break;
#line 534
}
#line 534

#line 543 "filter/f-inst.c"
 /* Linearize for FI_VAR_SET */
#line 543
case FI_VAR_SET: {
#line 543
#define whati (&(what->i_FI_VAR_SET))
#line 543
#define item (&(dest->items[pos].i_FI_VAR_SET))
#line 543
  #line 536 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 537 "filter/f-inst.c"
item->sym = whati->sym;
#line 537

#undef whati
#line 543 "filter/f-inst.c"
#undef item
#line 543
  dest->items[pos].fi_code = what->fi_code;
#line 543
  dest->items[pos].flags = what->flags;
#line 543
  dest->items[pos].lineno = what->lineno;
#line 543
  break;
#line 543
}
#line 543

#line 550 "filter/f-inst.c"
 /* Linearize for FI_VAR_GET */
#line 550
case FI_VAR_GET: {
#line 550
#define whati (&(what->i_FI_VAR_GET))
#line 550
#define item (&(dest->items[pos].i_FI_VAR_GET))
#line 550
  #line 544 "filter/f-inst.c"
item->sym = whati->sym;
#line 544

#undef whati
#line 550 "filter/f-inst.c"
#undef item
#line 550
  dest->items[pos].fi_code = what->fi_code;
#line 550
  dest->items[pos].flags = what->flags;
#line 550
  dest->items[pos].lineno = what->lineno;
#line 550
  break;
#line 550
}
#line 550

#line 563 "filter/f-inst.c"
 /* Linearize for FI_CONSTANT */
#line 563
case FI_CONSTANT: {
#line 563
#define whati (&(what->i_FI_CONSTANT))
#line 563
#define item (&(dest->items[pos].i_FI_CONSTANT))
#line 563
  #line 551 "filter/f-inst.c"
item->val = whati->val;
#line 551

#undef whati
#line 563 "filter/f-inst.c"
#undef item
#line 563
  dest->items[pos].fi_code = what->fi_code;
#line 563
  dest->items[pos].flags = what->flags;
#line 563
  dest->items[pos].lineno = what->lineno;
#line 563
  break;
#line 563
}
#line 563

#line 564 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PATH__empty */
#line 564
case FI_METHOD__T_PATH__empty: {
#line 564
#define whati (&(what->i_FI_METHOD__T_PATH__empty))
#line 564
#define item (&(dest->items[pos].i_FI_METHOD__T_PATH__empty))
#line 564
  #line 563 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 564 "filter/f-inst.c"
#undef item
#line 564
  dest->items[pos].fi_code = what->fi_code;
#line 564
  dest->items[pos].flags = what->flags;
#line 564
  dest->items[pos].lineno = what->lineno;
#line 564
  break;
#line 564
}
#line 564

#line 565 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_CLIST__empty */
#line 565
case FI_METHOD__T_CLIST__empty: {
#line 565
#define whati (&(what->i_FI_METHOD__T_CLIST__empty))
#line 565
#define item (&(dest->items[pos].i_FI_METHOD__T_CLIST__empty))
#line 565
  #line 564 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 565 "filter/f-inst.c"
#undef item
#line 565
  dest->items[pos].fi_code = what->fi_code;
#line 565
  dest->items[pos].flags = what->flags;
#line 565
  dest->items[pos].lineno = what->lineno;
#line 565
  break;
#line 565
}
#line 565

#line 566 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_ECLIST__empty */
#line 566
case FI_METHOD__T_ECLIST__empty: {
#line 566
#define whati (&(what->i_FI_METHOD__T_ECLIST__empty))
#line 566
#define item (&(dest->items[pos].i_FI_METHOD__T_ECLIST__empty))
#line 566
  #line 565 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 566 "filter/f-inst.c"
#undef item
#line 566
  dest->items[pos].fi_code = what->fi_code;
#line 566
  dest->items[pos].flags = what->flags;
#line 566
  dest->items[pos].lineno = what->lineno;
#line 566
  break;
#line 566
}
#line 566

#line 569 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LCLIST__empty */
#line 569
case FI_METHOD__T_LCLIST__empty: {
#line 569
#define whati (&(what->i_FI_METHOD__T_LCLIST__empty))
#line 569
#define item (&(dest->items[pos].i_FI_METHOD__T_LCLIST__empty))
#line 569
  #line 566 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 569 "filter/f-inst.c"
#undef item
#line 569
  dest->items[pos].fi_code = what->fi_code;
#line 569
  dest->items[pos].flags = what->flags;
#line 569
  dest->items[pos].lineno = what->lineno;
#line 569
  break;
#line 569
}
#line 569

#line 591 "filter/f-inst.c"
 /* Linearize for FI_FOR_LOOP_START */
#line 591
case FI_FOR_LOOP_START: {
#line 591
#define whati (&(what->i_FI_FOR_LOOP_START))
#line 591
#define item (&(dest->items[pos].i_FI_FOR_LOOP_START))
#line 591
  #line 571 "filter/f-inst.c"
item->sym = whati->sym;
#line 571

#undef whati
#line 591 "filter/f-inst.c"
#undef item
#line 591
  dest->items[pos].fi_code = what->fi_code;
#line 591
  dest->items[pos].flags = what->flags;
#line 591
  dest->items[pos].lineno = what->lineno;
#line 591
  break;
#line 591
}
#line 591

#line 600 "filter/f-inst.c"
 /* Linearize for FI_PATH_FOR_NEXT */
#line 600
case FI_PATH_FOR_NEXT: {
#line 600
#define whati (&(what->i_FI_PATH_FOR_NEXT))
#line 600
#define item (&(dest->items[pos].i_FI_PATH_FOR_NEXT))
#line 600
  #line 593 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 595 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#undef whati
#line 600 "filter/f-inst.c"
#undef item
#line 600
  dest->items[pos].fi_code = what->fi_code;
#line 600
  dest->items[pos].flags = what->flags;
#line 600
  dest->items[pos].lineno = what->lineno;
#line 600
  break;
#line 600
}
#line 600

#line 609 "filter/f-inst.c"
 /* Linearize for FI_CLIST_FOR_NEXT */
#line 609
case FI_CLIST_FOR_NEXT: {
#line 609
#define whati (&(what->i_FI_CLIST_FOR_NEXT))
#line 609
#define item (&(dest->items[pos].i_FI_CLIST_FOR_NEXT))
#line 609
  #line 602 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 604 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#undef whati
#line 609 "filter/f-inst.c"
#undef item
#line 609
  dest->items[pos].fi_code = what->fi_code;
#line 609
  dest->items[pos].flags = what->flags;
#line 609
  dest->items[pos].lineno = what->lineno;
#line 609
  break;
#line 609
}
#line 609

#line 618 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_FOR_NEXT */
#line 618
case FI_ECLIST_FOR_NEXT: {
#line 618
#define whati (&(what->i_FI_ECLIST_FOR_NEXT))
#line 618
#define item (&(dest->items[pos].i_FI_ECLIST_FOR_NEXT))
#line 618
  #line 611 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 613 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#undef whati
#line 618 "filter/f-inst.c"
#undef item
#line 618
  dest->items[pos].fi_code = what->fi_code;
#line 618
  dest->items[pos].flags = what->flags;
#line 618
  dest->items[pos].lineno = what->lineno;
#line 618
  break;
#line 618
}
#line 618

#line 627 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_FOR_NEXT */
#line 627
case FI_LCLIST_FOR_NEXT: {
#line 627
#define whati (&(what->i_FI_LCLIST_FOR_NEXT))
#line 627
#define item (&(dest->items[pos].i_FI_LCLIST_FOR_NEXT))
#line 627
  #line 620 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 622 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#undef whati
#line 627 "filter/f-inst.c"
#undef item
#line 627
  dest->items[pos].fi_code = what->fi_code;
#line 627
  dest->items[pos].flags = what->flags;
#line 627
  dest->items[pos].lineno = what->lineno;
#line 627
  break;
#line 627
}
#line 627

#line 640 "filter/f-inst.c"
 /* Linearize for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
case FI_ROUTES_BLOCK_FOR_NEXT: {
#line 640
#define whati (&(what->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 640
#define item (&(dest->items[pos].i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 640
  #line 629 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 634 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#undef whati
#line 640 "filter/f-inst.c"
#undef item
#line 640
  dest->items[pos].fi_code = what->fi_code;
#line 640
  dest->items[pos].flags = what->flags;
#line 640
  dest->items[pos].lineno = what->lineno;
#line 640
  break;
#line 640
}
#line 640

#line 648 "filter/f-inst.c"
 /* Linearize for FI_CONDITION */
#line 648
case FI_CONDITION: {
#line 648
#define whati (&(what->i_FI_CONDITION))
#line 648
#define item (&(dest->items[pos].i_FI_CONDITION))
#line 648
  #line 641 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 643 "filter/f-inst.c"
item->fl2 = f_linearize(whati->f2, 0);
#line 645 "filter/f-inst.c"
item->fl3 = f_linearize(whati->f3, 0);
#undef whati
#line 648 "filter/f-inst.c"
#undef item
#line 648
  dest->items[pos].fi_code = what->fi_code;
#line 648
  dest->items[pos].flags = what->flags;
#line 648
  dest->items[pos].lineno = what->lineno;
#line 648
  break;
#line 648
}
#line 648

#line 661 "filter/f-inst.c"
 /* Linearize for FI_PRINT */
#line 661
case FI_PRINT: {
#line 661
#define whati (&(what->i_FI_PRINT))
#line 661
#define item (&(dest->items[pos].i_FI_PRINT))
#line 661
  #line 650 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 661 "filter/f-inst.c"
#undef item
#line 661
  dest->items[pos].fi_code = what->fi_code;
#line 661
  dest->items[pos].flags = what->flags;
#line 661
  dest->items[pos].lineno = what->lineno;
#line 661
  break;
#line 661
}
#line 661

#line 668 "filter/f-inst.c"
 /* Linearize for FI_FLUSH */
#line 668
case FI_FLUSH: {
#line 668
#define whati (&(what->i_FI_FLUSH))
#line 668
#define item (&(dest->items[pos].i_FI_FLUSH))
#line 668
  #undef whati
#line 668
#undef item
#line 668
  dest->items[pos].fi_code = what->fi_code;
#line 668
  dest->items[pos].flags = what->flags;
#line 668
  dest->items[pos].lineno = what->lineno;
#line 668
  break;
#line 668
}
#line 668

#line 682 "filter/f-inst.c"
 /* Linearize for FI_DIE */
#line 682
case FI_DIE: {
#line 682
#define whati (&(what->i_FI_DIE))
#line 682
#define item (&(dest->items[pos].i_FI_DIE))
#line 682
  #line 670 "filter/f-inst.c"
item->fret = whati->fret;
#line 670

#undef whati
#line 682 "filter/f-inst.c"
#undef item
#line 682
  dest->items[pos].fi_code = what->fi_code;
#line 682
  dest->items[pos].flags = what->flags;
#line 682
  dest->items[pos].lineno = what->lineno;
#line 682
  break;
#line 682
}
#line 682

#line 689 "filter/f-inst.c"
 /* Linearize for FI_CURRENT_ROUTE */
#line 689
case FI_CURRENT_ROUTE: {
#line 689
#define whati (&(what->i_FI_CURRENT_ROUTE))
#line 689
#define item (&(dest->items[pos].i_FI_CURRENT_ROUTE))
#line 689
  #undef whati
#line 689
#undef item
#line 689
  dest->items[pos].fi_code = what->fi_code;
#line 689
  dest->items[pos].flags = what->flags;
#line 689
  dest->items[pos].lineno = what->lineno;
#line 689
  break;
#line 689
}
#line 689

#line 737 "filter/f-inst.c"
 /* Linearize for FI_RTA_GET */
#line 737
case FI_RTA_GET: {
#line 737
#define whati (&(what->i_FI_RTA_GET))
#line 737
#define item (&(dest->items[pos].i_FI_RTA_GET))
#line 737
  #line 691 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 692 "filter/f-inst.c"
item->sa = whati->sa;
#line 692

#undef whati
#line 737 "filter/f-inst.c"
#undef item
#line 737
  dest->items[pos].fi_code = what->fi_code;
#line 737
  dest->items[pos].flags = what->flags;
#line 737
  dest->items[pos].lineno = what->lineno;
#line 737
  break;
#line 737
}
#line 737

#line 866 "filter/f-inst.c"
 /* Linearize for FI_RTA_SET */
#line 866
case FI_RTA_SET: {
#line 866
#define whati (&(what->i_FI_RTA_SET))
#line 866
#define item (&(dest->items[pos].i_FI_RTA_SET))
#line 866
  #line 739 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 740 "filter/f-inst.c"
item->sa = whati->sa;
#line 740

#undef whati
#line 866 "filter/f-inst.c"
#undef item
#line 866
  dest->items[pos].fi_code = what->fi_code;
#line 866
  dest->items[pos].flags = what->flags;
#line 866
  dest->items[pos].lineno = what->lineno;
#line 866
  break;
#line 866
}
#line 866

#line 903 "filter/f-inst.c"
 /* Linearize for FI_EA_GET */
#line 903
case FI_EA_GET: {
#line 903
#define whati (&(what->i_FI_EA_GET))
#line 903
#define item (&(dest->items[pos].i_FI_EA_GET))
#line 903
  #line 867 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 868 "filter/f-inst.c"
item->da = whati->da;
#line 868

#undef whati
#line 903 "filter/f-inst.c"
#undef item
#line 903
  dest->items[pos].fi_code = what->fi_code;
#line 903
  dest->items[pos].flags = what->flags;
#line 903
  dest->items[pos].lineno = what->lineno;
#line 903
  break;
#line 903
}
#line 903

#line 944 "filter/f-inst.c"
 /* Linearize for FI_EA_SET */
#line 944
case FI_EA_SET: {
#line 944
#define whati (&(what->i_FI_EA_SET))
#line 944
#define item (&(dest->items[pos].i_FI_EA_SET))
#line 944
  #line 905 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 906 "filter/f-inst.c"
item->da = whati->da;
#line 906

#undef whati
#line 944 "filter/f-inst.c"
#undef item
#line 944
  dest->items[pos].fi_code = what->fi_code;
#line 944
  dest->items[pos].flags = what->flags;
#line 944
  dest->items[pos].lineno = what->lineno;
#line 944
  break;
#line 944
}
#line 944

#line 951 "filter/f-inst.c"
 /* Linearize for FI_EA_UNSET */
#line 951
case FI_EA_UNSET: {
#line 951
#define whati (&(what->i_FI_EA_UNSET))
#line 951
#define item (&(dest->items[pos].i_FI_EA_UNSET))
#line 951
  #line 945 "filter/f-inst.c"
item->da = whati->da;
#line 945

#undef whati
#line 951 "filter/f-inst.c"
#undef item
#line 951
  dest->items[pos].fi_code = what->fi_code;
#line 951
  dest->items[pos].flags = what->flags;
#line 951
  dest->items[pos].lineno = what->lineno;
#line 951
  break;
#line 951
}
#line 951

#line 965 "filter/f-inst.c"
 /* Linearize for FI_DEFAULT */
#line 965
case FI_DEFAULT: {
#line 965
#define whati (&(what->i_FI_DEFAULT))
#line 965
#define item (&(dest->items[pos].i_FI_DEFAULT))
#line 965
  #line 952 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 953 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 965 "filter/f-inst.c"
#undef item
#line 965
  dest->items[pos].fi_code = what->fi_code;
#line 965
  dest->items[pos].flags = what->flags;
#line 965
  dest->items[pos].lineno = what->lineno;
#line 965
  break;
#line 965
}
#line 965

#line 966 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_NET__len */
#line 966
case FI_METHOD__T_NET__len: {
#line 966
#define whati (&(what->i_FI_METHOD__T_NET__len))
#line 966
#define item (&(dest->items[pos].i_FI_METHOD__T_NET__len))
#line 966
  #line 965 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 966 "filter/f-inst.c"
#undef item
#line 966
  dest->items[pos].fi_code = what->fi_code;
#line 966
  dest->items[pos].flags = what->flags;
#line 966
  dest->items[pos].lineno = what->lineno;
#line 966
  break;
#line 966
}
#line 966

#line 967 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PATH__len */
#line 967
case FI_METHOD__T_PATH__len: {
#line 967
#define whati (&(what->i_FI_METHOD__T_PATH__len))
#line 967
#define item (&(dest->items[pos].i_FI_METHOD__T_PATH__len))
#line 967
  #line 966 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 967 "filter/f-inst.c"
#undef item
#line 967
  dest->items[pos].fi_code = what->fi_code;
#line 967
  dest->items[pos].flags = what->flags;
#line 967
  dest->items[pos].lineno = what->lineno;
#line 967
  break;
#line 967
}
#line 967

#line 968 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_CLIST__len */
#line 968
case FI_METHOD__T_CLIST__len: {
#line 968
#define whati (&(what->i_FI_METHOD__T_CLIST__len))
#line 968
#define item (&(dest->items[pos].i_FI_METHOD__T_CLIST__len))
#line 968
  #line 967 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 968 "filter/f-inst.c"
#undef item
#line 968
  dest->items[pos].fi_code = what->fi_code;
#line 968
  dest->items[pos].flags = what->flags;
#line 968
  dest->items[pos].lineno = what->lineno;
#line 968
  break;
#line 968
}
#line 968

#line 969 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_ECLIST__len */
#line 969
case FI_METHOD__T_ECLIST__len: {
#line 969
#define whati (&(what->i_FI_METHOD__T_ECLIST__len))
#line 969
#define item (&(dest->items[pos].i_FI_METHOD__T_ECLIST__len))
#line 969
  #line 968 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 969 "filter/f-inst.c"
#undef item
#line 969
  dest->items[pos].fi_code = what->fi_code;
#line 969
  dest->items[pos].flags = what->flags;
#line 969
  dest->items[pos].lineno = what->lineno;
#line 969
  break;
#line 969
}
#line 969

#line 971 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LCLIST__len */
#line 971
case FI_METHOD__T_LCLIST__len: {
#line 971
#define whati (&(what->i_FI_METHOD__T_LCLIST__len))
#line 971
#define item (&(dest->items[pos].i_FI_METHOD__T_LCLIST__len))
#line 971
  #line 969 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 971 "filter/f-inst.c"
#undef item
#line 971
  dest->items[pos].fi_code = what->fi_code;
#line 971
  dest->items[pos].flags = what->flags;
#line 971
  dest->items[pos].lineno = what->lineno;
#line 971
  break;
#line 971
}
#line 971

#line 1007 "filter/f-inst.c"
 /* Linearize for FI_NET_SRC */
#line 1007
case FI_NET_SRC: {
#line 1007
#define whati (&(what->i_FI_NET_SRC))
#line 1007
#define item (&(dest->items[pos].i_FI_NET_SRC))
#line 1007
  #line 972 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1007 "filter/f-inst.c"
#undef item
#line 1007
  dest->items[pos].fi_code = what->fi_code;
#line 1007
  dest->items[pos].flags = what->flags;
#line 1007
  dest->items[pos].lineno = what->lineno;
#line 1007
  break;
#line 1007
}
#line 1007

#line 1044 "filter/f-inst.c"
 /* Linearize for FI_NET_DST */
#line 1044
case FI_NET_DST: {
#line 1044
#define whati (&(what->i_FI_NET_DST))
#line 1044
#define item (&(dest->items[pos].i_FI_NET_DST))
#line 1044
  #line 1008 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1044 "filter/f-inst.c"
#undef item
#line 1044
  dest->items[pos].fi_code = what->fi_code;
#line 1044
  dest->items[pos].flags = what->flags;
#line 1044
  dest->items[pos].lineno = what->lineno;
#line 1044
  break;
#line 1044
}
#line 1044

#line 1054 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_NET__maxlen */
#line 1054
case FI_METHOD__T_NET__maxlen: {
#line 1054
#define whati (&(what->i_FI_METHOD__T_NET__maxlen))
#line 1054
#define item (&(dest->items[pos].i_FI_METHOD__T_NET__maxlen))
#line 1054
  #line 1044 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1054 "filter/f-inst.c"
#undef item
#line 1054
  dest->items[pos].fi_code = what->fi_code;
#line 1054
  dest->items[pos].flags = what->flags;
#line 1054
  dest->items[pos].lineno = what->lineno;
#line 1054
  break;
#line 1054
}
#line 1054

#line 1064 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_NET__asn */
#line 1064
case FI_METHOD__T_NET__asn: {
#line 1064
#define whati (&(what->i_FI_METHOD__T_NET__asn))
#line 1064
#define item (&(dest->items[pos].i_FI_METHOD__T_NET__asn))
#line 1064
  #line 1054 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1064 "filter/f-inst.c"
#undef item
#line 1064
  dest->items[pos].fi_code = what->fi_code;
#line 1064
  dest->items[pos].flags = what->flags;
#line 1064
  dest->items[pos].lineno = what->lineno;
#line 1064
  break;
#line 1064
}
#line 1064

#line 1066 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_NET__ip */
#line 1066
case FI_METHOD__T_NET__ip: {
#line 1066
#define whati (&(what->i_FI_METHOD__T_NET__ip))
#line 1066
#define item (&(dest->items[pos].i_FI_METHOD__T_NET__ip))
#line 1066
  #line 1064 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1066 "filter/f-inst.c"
#undef item
#line 1066
  dest->items[pos].fi_code = what->fi_code;
#line 1066
  dest->items[pos].flags = what->flags;
#line 1066
  dest->items[pos].lineno = what->lineno;
#line 1066
  break;
#line 1066
}
#line 1066

#line 1075 "filter/f-inst.c"
 /* Linearize for FI_ROUTE_DISTINGUISHER */
#line 1075
case FI_ROUTE_DISTINGUISHER: {
#line 1075
#define whati (&(what->i_FI_ROUTE_DISTINGUISHER))
#line 1075
#define item (&(dest->items[pos].i_FI_ROUTE_DISTINGUISHER))
#line 1075
  #line 1067 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1075 "filter/f-inst.c"
#undef item
#line 1075
  dest->items[pos].fi_code = what->fi_code;
#line 1075
  dest->items[pos].flags = what->flags;
#line 1075
  dest->items[pos].lineno = what->lineno;
#line 1075
  break;
#line 1075
}
#line 1075

#line 1078 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PATH__first */
#line 1078
case FI_METHOD__T_PATH__first: {
#line 1078
#define whati (&(what->i_FI_METHOD__T_PATH__first))
#line 1078
#define item (&(dest->items[pos].i_FI_METHOD__T_PATH__first))
#line 1078
  #line 1075 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1078 "filter/f-inst.c"
#undef item
#line 1078
  dest->items[pos].fi_code = what->fi_code;
#line 1078
  dest->items[pos].flags = what->flags;
#line 1078
  dest->items[pos].lineno = what->lineno;
#line 1078
  break;
#line 1078
}
#line 1078

#line 1081 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PATH__last */
#line 1081
case FI_METHOD__T_PATH__last: {
#line 1081
#define whati (&(what->i_FI_METHOD__T_PATH__last))
#line 1081
#define item (&(dest->items[pos].i_FI_METHOD__T_PATH__last))
#line 1081
  #line 1078 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1081 "filter/f-inst.c"
#undef item
#line 1081
  dest->items[pos].fi_code = what->fi_code;
#line 1081
  dest->items[pos].flags = what->flags;
#line 1081
  dest->items[pos].lineno = what->lineno;
#line 1081
  break;
#line 1081
}
#line 1081

#line 1084 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PATH__last_nonaggregated */
#line 1084
case FI_METHOD__T_PATH__last_nonaggregated: {
#line 1084
#define whati (&(what->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1084
#define item (&(dest->items[pos].i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1084
  #line 1081 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1084 "filter/f-inst.c"
#undef item
#line 1084
  dest->items[pos].fi_code = what->fi_code;
#line 1084
  dest->items[pos].flags = what->flags;
#line 1084
  dest->items[pos].lineno = what->lineno;
#line 1084
  break;
#line 1084
}
#line 1084

#line 1087 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PAIR__asn */
#line 1087
case FI_METHOD__T_PAIR__asn: {
#line 1087
#define whati (&(what->i_FI_METHOD__T_PAIR__asn))
#line 1087
#define item (&(dest->items[pos].i_FI_METHOD__T_PAIR__asn))
#line 1087
  #line 1084 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1087 "filter/f-inst.c"
#undef item
#line 1087
  dest->items[pos].fi_code = what->fi_code;
#line 1087
  dest->items[pos].flags = what->flags;
#line 1087
  dest->items[pos].lineno = what->lineno;
#line 1087
  break;
#line 1087
}
#line 1087

#line 1090 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_PAIR__data */
#line 1090
case FI_METHOD__T_PAIR__data: {
#line 1090
#define whati (&(what->i_FI_METHOD__T_PAIR__data))
#line 1090
#define item (&(dest->items[pos].i_FI_METHOD__T_PAIR__data))
#line 1090
  #line 1087 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1090 "filter/f-inst.c"
#undef item
#line 1090
  dest->items[pos].fi_code = what->fi_code;
#line 1090
  dest->items[pos].flags = what->flags;
#line 1090
  dest->items[pos].lineno = what->lineno;
#line 1090
  break;
#line 1090
}
#line 1090

#line 1093 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LC__asn */
#line 1093
case FI_METHOD__T_LC__asn: {
#line 1093
#define whati (&(what->i_FI_METHOD__T_LC__asn))
#line 1093
#define item (&(dest->items[pos].i_FI_METHOD__T_LC__asn))
#line 1093
  #line 1090 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1093 "filter/f-inst.c"
#undef item
#line 1093
  dest->items[pos].fi_code = what->fi_code;
#line 1093
  dest->items[pos].flags = what->flags;
#line 1093
  dest->items[pos].lineno = what->lineno;
#line 1093
  break;
#line 1093
}
#line 1093

#line 1096 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LC__data1 */
#line 1096
case FI_METHOD__T_LC__data1: {
#line 1096
#define whati (&(what->i_FI_METHOD__T_LC__data1))
#line 1096
#define item (&(dest->items[pos].i_FI_METHOD__T_LC__data1))
#line 1096
  #line 1093 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1096 "filter/f-inst.c"
#undef item
#line 1096
  dest->items[pos].fi_code = what->fi_code;
#line 1096
  dest->items[pos].flags = what->flags;
#line 1096
  dest->items[pos].lineno = what->lineno;
#line 1096
  break;
#line 1096
}
#line 1096

#line 1099 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LC__data2 */
#line 1099
case FI_METHOD__T_LC__data2: {
#line 1099
#define whati (&(what->i_FI_METHOD__T_LC__data2))
#line 1099
#define item (&(dest->items[pos].i_FI_METHOD__T_LC__data2))
#line 1099
  #line 1096 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1099 "filter/f-inst.c"
#undef item
#line 1099
  dest->items[pos].fi_code = what->fi_code;
#line 1099
  dest->items[pos].flags = what->flags;
#line 1099
  dest->items[pos].lineno = what->lineno;
#line 1099
  break;
#line 1099
}
#line 1099

#line 1102 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_CLIST__min */
#line 1102
case FI_METHOD__T_CLIST__min: {
#line 1102
#define whati (&(what->i_FI_METHOD__T_CLIST__min))
#line 1102
#define item (&(dest->items[pos].i_FI_METHOD__T_CLIST__min))
#line 1102
  #line 1099 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1102 "filter/f-inst.c"
#undef item
#line 1102
  dest->items[pos].fi_code = what->fi_code;
#line 1102
  dest->items[pos].flags = what->flags;
#line 1102
  dest->items[pos].lineno = what->lineno;
#line 1102
  break;
#line 1102
}
#line 1102

#line 1105 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_CLIST__max */
#line 1105
case FI_METHOD__T_CLIST__max: {
#line 1105
#define whati (&(what->i_FI_METHOD__T_CLIST__max))
#line 1105
#define item (&(dest->items[pos].i_FI_METHOD__T_CLIST__max))
#line 1105
  #line 1102 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1105 "filter/f-inst.c"
#undef item
#line 1105
  dest->items[pos].fi_code = what->fi_code;
#line 1105
  dest->items[pos].flags = what->flags;
#line 1105
  dest->items[pos].lineno = what->lineno;
#line 1105
  break;
#line 1105
}
#line 1105

#line 1108 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_ECLIST__min */
#line 1108
case FI_METHOD__T_ECLIST__min: {
#line 1108
#define whati (&(what->i_FI_METHOD__T_ECLIST__min))
#line 1108
#define item (&(dest->items[pos].i_FI_METHOD__T_ECLIST__min))
#line 1108
  #line 1105 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1108 "filter/f-inst.c"
#undef item
#line 1108
  dest->items[pos].fi_code = what->fi_code;
#line 1108
  dest->items[pos].flags = what->flags;
#line 1108
  dest->items[pos].lineno = what->lineno;
#line 1108
  break;
#line 1108
}
#line 1108

#line 1111 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_ECLIST__max */
#line 1111
case FI_METHOD__T_ECLIST__max: {
#line 1111
#define whati (&(what->i_FI_METHOD__T_ECLIST__max))
#line 1111
#define item (&(dest->items[pos].i_FI_METHOD__T_ECLIST__max))
#line 1111
  #line 1108 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1111 "filter/f-inst.c"
#undef item
#line 1111
  dest->items[pos].fi_code = what->fi_code;
#line 1111
  dest->items[pos].flags = what->flags;
#line 1111
  dest->items[pos].lineno = what->lineno;
#line 1111
  break;
#line 1111
}
#line 1111

#line 1114 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LCLIST__min */
#line 1114
case FI_METHOD__T_LCLIST__min: {
#line 1114
#define whati (&(what->i_FI_METHOD__T_LCLIST__min))
#line 1114
#define item (&(dest->items[pos].i_FI_METHOD__T_LCLIST__min))
#line 1114
  #line 1111 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1114 "filter/f-inst.c"
#undef item
#line 1114
  dest->items[pos].fi_code = what->fi_code;
#line 1114
  dest->items[pos].flags = what->flags;
#line 1114
  dest->items[pos].lineno = what->lineno;
#line 1114
  break;
#line 1114
}
#line 1114

#line 1116 "filter/f-inst.c"
 /* Linearize for FI_METHOD__T_LCLIST__max */
#line 1116
case FI_METHOD__T_LCLIST__max: {
#line 1116
#define whati (&(what->i_FI_METHOD__T_LCLIST__max))
#line 1116
#define item (&(dest->items[pos].i_FI_METHOD__T_LCLIST__max))
#line 1116
  #line 1114 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1116 "filter/f-inst.c"
#undef item
#line 1116
  dest->items[pos].fi_code = what->fi_code;
#line 1116
  dest->items[pos].flags = what->flags;
#line 1116
  dest->items[pos].lineno = what->lineno;
#line 1116
  break;
#line 1116
}
#line 1116

#line 1142 "filter/f-inst.c"
 /* Linearize for FI_RETURN */
#line 1142
case FI_RETURN: {
#line 1142
#define whati (&(what->i_FI_RETURN))
#line 1142
#define item (&(dest->items[pos].i_FI_RETURN))
#line 1142
  #line 1119 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1142 "filter/f-inst.c"
#undef item
#line 1142
  dest->items[pos].fi_code = what->fi_code;
#line 1142
  dest->items[pos].flags = what->flags;
#line 1142
  dest->items[pos].lineno = what->lineno;
#line 1142
  break;
#line 1142
}
#line 1142

#line 1202 "filter/f-inst.c"
 /* Linearize for FI_CALL */
#line 1202
case FI_CALL: {
#line 1202
#define whati (&(what->i_FI_CALL))
#line 1202
#define item (&(dest->items[pos].i_FI_CALL))
#line 1202
  #line 1144 "filter/f-inst.c"
  pos = linearize(dest, whati->fvar, pos);
#line 1144
  item->varcount = whati->varcount;
#line 1145 "filter/f-inst.c"
item->sym = whati->sym;
#line 1145

#undef whati
#line 1202 "filter/f-inst.c"
#undef item
#line 1202
  dest->items[pos].fi_code = what->fi_code;
#line 1202
  dest->items[pos].flags = what->flags;
#line 1202
  dest->items[pos].lineno = what->lineno;
#line 1202
  break;
#line 1202
}
#line 1202

#line 1207 "filter/f-inst.c"
 /* Linearize for FI_DROP_RESULT */
#line 1207
case FI_DROP_RESULT: {
#line 1207
#define whati (&(what->i_FI_DROP_RESULT))
#line 1207
#define item (&(dest->items[pos].i_FI_DROP_RESULT))
#line 1207
  #line 1204 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1207 "filter/f-inst.c"
#undef item
#line 1207
  dest->items[pos].fi_code = what->fi_code;
#line 1207
  dest->items[pos].flags = what->flags;
#line 1207
  dest->items[pos].lineno = what->lineno;
#line 1207
  break;
#line 1207
}
#line 1207

#line 1248 "filter/f-inst.c"
 /* Linearize for FI_SWITCH */
#line 1248
case FI_SWITCH: {
#line 1248
#define whati (&(what->i_FI_SWITCH))
#line 1248
#define item (&(dest->items[pos].i_FI_SWITCH))
#line 1248
  #line 1208 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1210 "filter/f-inst.c"
item->tree = whati->tree;
#line 1210


#line 1213 "filter/f-inst.c"
    /* Linearize all branches in switch */
    struct f_inst *last_inst = NULL;
    struct f_line *last_line = NULL;
    for (struct f_tree *t = whati->tree; t; t = t->left)
    {
      if (t->data != last_inst)
      {
	last_inst = t->data;
	last_line = f_linearize(t->data, 0);
      }

      t->data = last_line;
    }

    /* Balance the tree */
    item->tree = build_tree(whati->tree);

    #undef whati
#line 1248 "filter/f-inst.c"
#undef item
#line 1248
  dest->items[pos].fi_code = what->fi_code;
#line 1248
  dest->items[pos].flags = what->flags;
#line 1248
  dest->items[pos].lineno = what->lineno;
#line 1248
  break;
#line 1248
}
#line 1248

#line 1257 "filter/f-inst.c"
 /* Linearize for FI_IP_MASK */
#line 1257
case FI_IP_MASK: {
#line 1257
#define whati (&(what->i_FI_IP_MASK))
#line 1257
#define item (&(dest->items[pos].i_FI_IP_MASK))
#line 1257
  #line 1249 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1250 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1257 "filter/f-inst.c"
#undef item
#line 1257
  dest->items[pos].fi_code = what->fi_code;
#line 1257
  dest->items[pos].flags = what->flags;
#line 1257
  dest->items[pos].lineno = what->lineno;
#line 1257
  break;
#line 1257
}
#line 1257

#line 1265 "filter/f-inst.c"
 /* Linearize for FI_PATH_PREPEND */
#line 1265
case FI_PATH_PREPEND: {
#line 1265
#define whati (&(what->i_FI_PATH_PREPEND))
#line 1265
#define item (&(dest->items[pos].i_FI_PATH_PREPEND))
#line 1265
  #line 1258 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1259 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1265 "filter/f-inst.c"
#undef item
#line 1265
  dest->items[pos].fi_code = what->fi_code;
#line 1265
  dest->items[pos].flags = what->flags;
#line 1265
  dest->items[pos].lineno = what->lineno;
#line 1265
  break;
#line 1265
}
#line 1265

#line 1272 "filter/f-inst.c"
 /* Linearize for FI_CLIST_ADD_PAIR */
#line 1272
case FI_CLIST_ADD_PAIR: {
#line 1272
#define whati (&(what->i_FI_CLIST_ADD_PAIR))
#line 1272
#define item (&(dest->items[pos].i_FI_CLIST_ADD_PAIR))
#line 1272
  #line 1266 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1267 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1272 "filter/f-inst.c"
#undef item
#line 1272
  dest->items[pos].fi_code = what->fi_code;
#line 1272
  dest->items[pos].flags = what->flags;
#line 1272
  dest->items[pos].lineno = what->lineno;
#line 1272
  break;
#line 1272
}
#line 1272

#line 1286 "filter/f-inst.c"
 /* Linearize for FI_CLIST_ADD_IP */
#line 1286
case FI_CLIST_ADD_IP: {
#line 1286
#define whati (&(what->i_FI_CLIST_ADD_IP))
#line 1286
#define item (&(dest->items[pos].i_FI_CLIST_ADD_IP))
#line 1286
  #line 1273 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1274 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1286 "filter/f-inst.c"
#undef item
#line 1286
  dest->items[pos].fi_code = what->fi_code;
#line 1286
  dest->items[pos].flags = what->flags;
#line 1286
  dest->items[pos].lineno = what->lineno;
#line 1286
  break;
#line 1286
}
#line 1286

#line 1293 "filter/f-inst.c"
 /* Linearize for FI_CLIST_ADD_QUAD */
#line 1293
case FI_CLIST_ADD_QUAD: {
#line 1293
#define whati (&(what->i_FI_CLIST_ADD_QUAD))
#line 1293
#define item (&(dest->items[pos].i_FI_CLIST_ADD_QUAD))
#line 1293
  #line 1287 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1288 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1293 "filter/f-inst.c"
#undef item
#line 1293
  dest->items[pos].fi_code = what->fi_code;
#line 1293
  dest->items[pos].flags = what->flags;
#line 1293
  dest->items[pos].lineno = what->lineno;
#line 1293
  break;
#line 1293
}
#line 1293

#line 1300 "filter/f-inst.c"
 /* Linearize for FI_CLIST_ADD_CLIST */
#line 1300
case FI_CLIST_ADD_CLIST: {
#line 1300
#define whati (&(what->i_FI_CLIST_ADD_CLIST))
#line 1300
#define item (&(dest->items[pos].i_FI_CLIST_ADD_CLIST))
#line 1300
  #line 1294 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1295 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1300 "filter/f-inst.c"
#undef item
#line 1300
  dest->items[pos].fi_code = what->fi_code;
#line 1300
  dest->items[pos].flags = what->flags;
#line 1300
  dest->items[pos].lineno = what->lineno;
#line 1300
  break;
#line 1300
}
#line 1300

#line 1307 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_ADD_EC */
#line 1307
case FI_ECLIST_ADD_EC: {
#line 1307
#define whati (&(what->i_FI_ECLIST_ADD_EC))
#line 1307
#define item (&(dest->items[pos].i_FI_ECLIST_ADD_EC))
#line 1307
  #line 1301 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1302 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1307 "filter/f-inst.c"
#undef item
#line 1307
  dest->items[pos].fi_code = what->fi_code;
#line 1307
  dest->items[pos].flags = what->flags;
#line 1307
  dest->items[pos].lineno = what->lineno;
#line 1307
  break;
#line 1307
}
#line 1307

#line 1314 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_ADD_ECLIST */
#line 1314
case FI_ECLIST_ADD_ECLIST: {
#line 1314
#define whati (&(what->i_FI_ECLIST_ADD_ECLIST))
#line 1314
#define item (&(dest->items[pos].i_FI_ECLIST_ADD_ECLIST))
#line 1314
  #line 1308 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1309 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1314 "filter/f-inst.c"
#undef item
#line 1314
  dest->items[pos].fi_code = what->fi_code;
#line 1314
  dest->items[pos].flags = what->flags;
#line 1314
  dest->items[pos].lineno = what->lineno;
#line 1314
  break;
#line 1314
}
#line 1314

#line 1321 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_ADD_LC */
#line 1321
case FI_LCLIST_ADD_LC: {
#line 1321
#define whati (&(what->i_FI_LCLIST_ADD_LC))
#line 1321
#define item (&(dest->items[pos].i_FI_LCLIST_ADD_LC))
#line 1321
  #line 1315 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1316 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1321 "filter/f-inst.c"
#undef item
#line 1321
  dest->items[pos].fi_code = what->fi_code;
#line 1321
  dest->items[pos].flags = what->flags;
#line 1321
  dest->items[pos].lineno = what->lineno;
#line 1321
  break;
#line 1321
}
#line 1321

#line 1328 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_ADD_LCLIST */
#line 1328
case FI_LCLIST_ADD_LCLIST: {
#line 1328
#define whati (&(what->i_FI_LCLIST_ADD_LCLIST))
#line 1328
#define item (&(dest->items[pos].i_FI_LCLIST_ADD_LCLIST))
#line 1328
  #line 1322 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1323 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1328 "filter/f-inst.c"
#undef item
#line 1328
  dest->items[pos].fi_code = what->fi_code;
#line 1328
  dest->items[pos].flags = what->flags;
#line 1328
  dest->items[pos].lineno = what->lineno;
#line 1328
  break;
#line 1328
}
#line 1328

#line 1335 "filter/f-inst.c"
 /* Linearize for FI_PATH_DELETE_INT */
#line 1335
case FI_PATH_DELETE_INT: {
#line 1335
#define whati (&(what->i_FI_PATH_DELETE_INT))
#line 1335
#define item (&(dest->items[pos].i_FI_PATH_DELETE_INT))
#line 1335
  #line 1329 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1330 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1335 "filter/f-inst.c"
#undef item
#line 1335
  dest->items[pos].fi_code = what->fi_code;
#line 1335
  dest->items[pos].flags = what->flags;
#line 1335
  dest->items[pos].lineno = what->lineno;
#line 1335
  break;
#line 1335
}
#line 1335

#line 1347 "filter/f-inst.c"
 /* Linearize for FI_PATH_DELETE_SET */
#line 1347
case FI_PATH_DELETE_SET: {
#line 1347
#define whati (&(what->i_FI_PATH_DELETE_SET))
#line 1347
#define item (&(dest->items[pos].i_FI_PATH_DELETE_SET))
#line 1347
  #line 1336 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1337 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1347 "filter/f-inst.c"
#undef item
#line 1347
  dest->items[pos].fi_code = what->fi_code;
#line 1347
  dest->items[pos].flags = what->flags;
#line 1347
  dest->items[pos].lineno = what->lineno;
#line 1347
  break;
#line 1347
}
#line 1347

#line 1354 "filter/f-inst.c"
 /* Linearize for FI_CLIST_DELETE_PAIR */
#line 1354
case FI_CLIST_DELETE_PAIR: {
#line 1354
#define whati (&(what->i_FI_CLIST_DELETE_PAIR))
#line 1354
#define item (&(dest->items[pos].i_FI_CLIST_DELETE_PAIR))
#line 1354
  #line 1348 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1349 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1354 "filter/f-inst.c"
#undef item
#line 1354
  dest->items[pos].fi_code = what->fi_code;
#line 1354
  dest->items[pos].flags = what->flags;
#line 1354
  dest->items[pos].lineno = what->lineno;
#line 1354
  break;
#line 1354
}
#line 1354

#line 1368 "filter/f-inst.c"
 /* Linearize for FI_CLIST_DELETE_IP */
#line 1368
case FI_CLIST_DELETE_IP: {
#line 1368
#define whati (&(what->i_FI_CLIST_DELETE_IP))
#line 1368
#define item (&(dest->items[pos].i_FI_CLIST_DELETE_IP))
#line 1368
  #line 1355 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1356 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1368 "filter/f-inst.c"
#undef item
#line 1368
  dest->items[pos].fi_code = what->fi_code;
#line 1368
  dest->items[pos].flags = what->flags;
#line 1368
  dest->items[pos].lineno = what->lineno;
#line 1368
  break;
#line 1368
}
#line 1368

#line 1375 "filter/f-inst.c"
 /* Linearize for FI_CLIST_DELETE_QUAD */
#line 1375
case FI_CLIST_DELETE_QUAD: {
#line 1375
#define whati (&(what->i_FI_CLIST_DELETE_QUAD))
#line 1375
#define item (&(dest->items[pos].i_FI_CLIST_DELETE_QUAD))
#line 1375
  #line 1369 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1370 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1375 "filter/f-inst.c"
#undef item
#line 1375
  dest->items[pos].fi_code = what->fi_code;
#line 1375
  dest->items[pos].flags = what->flags;
#line 1375
  dest->items[pos].lineno = what->lineno;
#line 1375
  break;
#line 1375
}
#line 1375

#line 1382 "filter/f-inst.c"
 /* Linearize for FI_CLIST_DELETE_CLIST */
#line 1382
case FI_CLIST_DELETE_CLIST: {
#line 1382
#define whati (&(what->i_FI_CLIST_DELETE_CLIST))
#line 1382
#define item (&(dest->items[pos].i_FI_CLIST_DELETE_CLIST))
#line 1382
  #line 1376 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1377 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1382 "filter/f-inst.c"
#undef item
#line 1382
  dest->items[pos].fi_code = what->fi_code;
#line 1382
  dest->items[pos].flags = what->flags;
#line 1382
  dest->items[pos].lineno = what->lineno;
#line 1382
  break;
#line 1382
}
#line 1382

#line 1393 "filter/f-inst.c"
 /* Linearize for FI_CLIST_DELETE_SET */
#line 1393
case FI_CLIST_DELETE_SET: {
#line 1393
#define whati (&(what->i_FI_CLIST_DELETE_SET))
#line 1393
#define item (&(dest->items[pos].i_FI_CLIST_DELETE_SET))
#line 1393
  #line 1383 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1384 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1393 "filter/f-inst.c"
#undef item
#line 1393
  dest->items[pos].fi_code = what->fi_code;
#line 1393
  dest->items[pos].flags = what->flags;
#line 1393
  dest->items[pos].lineno = what->lineno;
#line 1393
  break;
#line 1393
}
#line 1393

#line 1400 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_DELETE_EC */
#line 1400
case FI_ECLIST_DELETE_EC: {
#line 1400
#define whati (&(what->i_FI_ECLIST_DELETE_EC))
#line 1400
#define item (&(dest->items[pos].i_FI_ECLIST_DELETE_EC))
#line 1400
  #line 1394 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1395 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1400 "filter/f-inst.c"
#undef item
#line 1400
  dest->items[pos].fi_code = what->fi_code;
#line 1400
  dest->items[pos].flags = what->flags;
#line 1400
  dest->items[pos].lineno = what->lineno;
#line 1400
  break;
#line 1400
}
#line 1400

#line 1407 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_DELETE_ECLIST */
#line 1407
case FI_ECLIST_DELETE_ECLIST: {
#line 1407
#define whati (&(what->i_FI_ECLIST_DELETE_ECLIST))
#line 1407
#define item (&(dest->items[pos].i_FI_ECLIST_DELETE_ECLIST))
#line 1407
  #line 1401 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1402 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1407 "filter/f-inst.c"
#undef item
#line 1407
  dest->items[pos].fi_code = what->fi_code;
#line 1407
  dest->items[pos].flags = what->flags;
#line 1407
  dest->items[pos].lineno = what->lineno;
#line 1407
  break;
#line 1407
}
#line 1407

#line 1418 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_DELETE_SET */
#line 1418
case FI_ECLIST_DELETE_SET: {
#line 1418
#define whati (&(what->i_FI_ECLIST_DELETE_SET))
#line 1418
#define item (&(dest->items[pos].i_FI_ECLIST_DELETE_SET))
#line 1418
  #line 1408 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1409 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1418 "filter/f-inst.c"
#undef item
#line 1418
  dest->items[pos].fi_code = what->fi_code;
#line 1418
  dest->items[pos].flags = what->flags;
#line 1418
  dest->items[pos].lineno = what->lineno;
#line 1418
  break;
#line 1418
}
#line 1418

#line 1425 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_DELETE_LC */
#line 1425
case FI_LCLIST_DELETE_LC: {
#line 1425
#define whati (&(what->i_FI_LCLIST_DELETE_LC))
#line 1425
#define item (&(dest->items[pos].i_FI_LCLIST_DELETE_LC))
#line 1425
  #line 1419 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1420 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1425 "filter/f-inst.c"
#undef item
#line 1425
  dest->items[pos].fi_code = what->fi_code;
#line 1425
  dest->items[pos].flags = what->flags;
#line 1425
  dest->items[pos].lineno = what->lineno;
#line 1425
  break;
#line 1425
}
#line 1425

#line 1432 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_DELETE_LCLIST */
#line 1432
case FI_LCLIST_DELETE_LCLIST: {
#line 1432
#define whati (&(what->i_FI_LCLIST_DELETE_LCLIST))
#line 1432
#define item (&(dest->items[pos].i_FI_LCLIST_DELETE_LCLIST))
#line 1432
  #line 1426 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1427 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1432 "filter/f-inst.c"
#undef item
#line 1432
  dest->items[pos].fi_code = what->fi_code;
#line 1432
  dest->items[pos].flags = what->flags;
#line 1432
  dest->items[pos].lineno = what->lineno;
#line 1432
  break;
#line 1432
}
#line 1432

#line 1443 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_DELETE_SET */
#line 1443
case FI_LCLIST_DELETE_SET: {
#line 1443
#define whati (&(what->i_FI_LCLIST_DELETE_SET))
#line 1443
#define item (&(dest->items[pos].i_FI_LCLIST_DELETE_SET))
#line 1443
  #line 1433 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1434 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1443 "filter/f-inst.c"
#undef item
#line 1443
  dest->items[pos].fi_code = what->fi_code;
#line 1443
  dest->items[pos].flags = what->flags;
#line 1443
  dest->items[pos].lineno = what->lineno;
#line 1443
  break;
#line 1443
}
#line 1443

#line 1454 "filter/f-inst.c"
 /* Linearize for FI_PATH_FILTER_SET */
#line 1454
case FI_PATH_FILTER_SET: {
#line 1454
#define whati (&(what->i_FI_PATH_FILTER_SET))
#line 1454
#define item (&(dest->items[pos].i_FI_PATH_FILTER_SET))
#line 1454
  #line 1444 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1445 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1454 "filter/f-inst.c"
#undef item
#line 1454
  dest->items[pos].fi_code = what->fi_code;
#line 1454
  dest->items[pos].flags = what->flags;
#line 1454
  dest->items[pos].lineno = what->lineno;
#line 1454
  break;
#line 1454
}
#line 1454

#line 1461 "filter/f-inst.c"
 /* Linearize for FI_CLIST_FILTER_CLIST */
#line 1461
case FI_CLIST_FILTER_CLIST: {
#line 1461
#define whati (&(what->i_FI_CLIST_FILTER_CLIST))
#line 1461
#define item (&(dest->items[pos].i_FI_CLIST_FILTER_CLIST))
#line 1461
  #line 1455 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1456 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1461 "filter/f-inst.c"
#undef item
#line 1461
  dest->items[pos].fi_code = what->fi_code;
#line 1461
  dest->items[pos].flags = what->flags;
#line 1461
  dest->items[pos].lineno = what->lineno;
#line 1461
  break;
#line 1461
}
#line 1461

#line 1472 "filter/f-inst.c"
 /* Linearize for FI_CLIST_FILTER_SET */
#line 1472
case FI_CLIST_FILTER_SET: {
#line 1472
#define whati (&(what->i_FI_CLIST_FILTER_SET))
#line 1472
#define item (&(dest->items[pos].i_FI_CLIST_FILTER_SET))
#line 1472
  #line 1462 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1463 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1472 "filter/f-inst.c"
#undef item
#line 1472
  dest->items[pos].fi_code = what->fi_code;
#line 1472
  dest->items[pos].flags = what->flags;
#line 1472
  dest->items[pos].lineno = what->lineno;
#line 1472
  break;
#line 1472
}
#line 1472

#line 1479 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_FILTER_ECLIST */
#line 1479
case FI_ECLIST_FILTER_ECLIST: {
#line 1479
#define whati (&(what->i_FI_ECLIST_FILTER_ECLIST))
#line 1479
#define item (&(dest->items[pos].i_FI_ECLIST_FILTER_ECLIST))
#line 1479
  #line 1473 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1474 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1479 "filter/f-inst.c"
#undef item
#line 1479
  dest->items[pos].fi_code = what->fi_code;
#line 1479
  dest->items[pos].flags = what->flags;
#line 1479
  dest->items[pos].lineno = what->lineno;
#line 1479
  break;
#line 1479
}
#line 1479

#line 1490 "filter/f-inst.c"
 /* Linearize for FI_ECLIST_FILTER_SET */
#line 1490
case FI_ECLIST_FILTER_SET: {
#line 1490
#define whati (&(what->i_FI_ECLIST_FILTER_SET))
#line 1490
#define item (&(dest->items[pos].i_FI_ECLIST_FILTER_SET))
#line 1490
  #line 1480 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1481 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1490 "filter/f-inst.c"
#undef item
#line 1490
  dest->items[pos].fi_code = what->fi_code;
#line 1490
  dest->items[pos].flags = what->flags;
#line 1490
  dest->items[pos].lineno = what->lineno;
#line 1490
  break;
#line 1490
}
#line 1490

#line 1497 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_FILTER_LCLIST */
#line 1497
case FI_LCLIST_FILTER_LCLIST: {
#line 1497
#define whati (&(what->i_FI_LCLIST_FILTER_LCLIST))
#line 1497
#define item (&(dest->items[pos].i_FI_LCLIST_FILTER_LCLIST))
#line 1497
  #line 1491 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1492 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1497 "filter/f-inst.c"
#undef item
#line 1497
  dest->items[pos].fi_code = what->fi_code;
#line 1497
  dest->items[pos].flags = what->flags;
#line 1497
  dest->items[pos].lineno = what->lineno;
#line 1497
  break;
#line 1497
}
#line 1497

#line 1508 "filter/f-inst.c"
 /* Linearize for FI_LCLIST_FILTER_SET */
#line 1508
case FI_LCLIST_FILTER_SET: {
#line 1508
#define whati (&(what->i_FI_LCLIST_FILTER_SET))
#line 1508
#define item (&(dest->items[pos].i_FI_LCLIST_FILTER_SET))
#line 1508
  #line 1498 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1499 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#undef whati
#line 1508 "filter/f-inst.c"
#undef item
#line 1508
  dest->items[pos].fi_code = what->fi_code;
#line 1508
  dest->items[pos].flags = what->flags;
#line 1508
  dest->items[pos].lineno = what->lineno;
#line 1508
  break;
#line 1508
}
#line 1508

#line 1530 "filter/f-inst.c"
 /* Linearize for FI_ROA_CHECK */
#line 1530
case FI_ROA_CHECK: {
#line 1530
#define whati (&(what->i_FI_ROA_CHECK))
#line 1530
#define item (&(dest->items[pos].i_FI_ROA_CHECK))
#line 1530
  #line 1510 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1511 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#line 1512 "filter/f-inst.c"
item->rtc = whati->rtc;
#line 1512

#undef whati
#line 1530 "filter/f-inst.c"
#undef item
#line 1530
  dest->items[pos].fi_code = what->fi_code;
#line 1530
  dest->items[pos].flags = what->flags;
#line 1530
  dest->items[pos].lineno = what->lineno;
#line 1530
  break;
#line 1530
}
#line 1530

#line 1546 "filter/f-inst.c"
 /* Linearize for FI_ASPA_CHECK_EXPLICIT */
#line 1546
case FI_ASPA_CHECK_EXPLICIT: {
#line 1546
#define whati (&(what->i_FI_ASPA_CHECK_EXPLICIT))
#line 1546
#define item (&(dest->items[pos].i_FI_ASPA_CHECK_EXPLICIT))
#line 1546
  #line 1532 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1533 "filter/f-inst.c"
pos = linearize(dest, whati->f2, pos);
#line 1534 "filter/f-inst.c"
item->rtc = whati->rtc;
#line 1534

#undef whati
#line 1546 "filter/f-inst.c"
#undef item
#line 1546
  dest->items[pos].fi_code = what->fi_code;
#line 1546
  dest->items[pos].flags = what->flags;
#line 1546
  dest->items[pos].lineno = what->lineno;
#line 1546
  break;
#line 1546
}
#line 1546

#line 1561 "filter/f-inst.c"
 /* Linearize for FI_FROM_HEX */
#line 1561
case FI_FROM_HEX: {
#line 1561
#define whati (&(what->i_FI_FROM_HEX))
#line 1561
#define item (&(dest->items[pos].i_FI_FROM_HEX))
#line 1561
  #line 1547 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1561 "filter/f-inst.c"
#undef item
#line 1561
  dest->items[pos].fi_code = what->fi_code;
#line 1561
  dest->items[pos].flags = what->flags;
#line 1561
  dest->items[pos].lineno = what->lineno;
#line 1561
  break;
#line 1561
}
#line 1561

#line 1566 "filter/f-inst.c"
 /* Linearize for FI_FORMAT */
#line 1566
case FI_FORMAT: {
#line 1566
#define whati (&(what->i_FI_FORMAT))
#line 1566
#define item (&(dest->items[pos].i_FI_FORMAT))
#line 1566
  #line 1562 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#undef whati
#line 1566 "filter/f-inst.c"
#undef item
#line 1566
  dest->items[pos].fi_code = what->fi_code;
#line 1566
  dest->items[pos].flags = what->flags;
#line 1566
  dest->items[pos].lineno = what->lineno;
#line 1566
  break;
#line 1566
}
#line 1566

#line 830 "filter/decl.m4"
 /* Linearize for FI_ASSERT */
#line 830
case FI_ASSERT: {
#line 830
#define whati (&(what->i_FI_ASSERT))
#line 830
#define item (&(dest->items[pos].i_FI_ASSERT))
#line 830
  #line 1568 "filter/f-inst.c"
pos = linearize(dest, whati->f1, pos);
#line 1570 "filter/f-inst.c"
item->s = whati->s;
#line 1570

#undef whati
#line 830 "filter/decl.m4"
#undef item
#line 830
  dest->items[pos].fi_code = what->fi_code;
#line 830
  dest->items[pos].flags = what->flags;
#line 830
  dest->items[pos].lineno = what->lineno;
#line 830
  break;
#line 830
}
#line 830

#line 708 "filter/decl.m4"

    }
    pos++;
  }
  return pos;
}

struct f_line *
f_linearize_concat(const struct f_inst * const inst[], uint count, uint results)
{
  uint len = 0;
  for (uint i=0; i<count; i++)
    for (const struct f_inst *what = inst[i]; what; what = what->next)
      len += what->size;

  struct f_line *out = cfg_allocz(sizeof(struct f_line) + sizeof(struct f_line_item)*len);

  for (uint i=0; i<count; i++)
    out->len = linearize(out, inst[i], out->len);

  out->results = results;
  return out;
}

/* Filter line comparison */
int
f_same(const struct f_line *fl1, const struct f_line *fl2)
{
  if ((!fl1) && (!fl2))
    return 1;
  if ((!fl1) || (!fl2))
    return 0;
  if (fl1->len != fl2->len)
    return 0;
  for (uint i=0; i<fl1->len; i++) {
#define f1_ (&(fl1->items[i]))
#define f2_ (&(fl2->items[i]))
    if (f1_->fi_code != f2_->fi_code)
      return 0;
    if (f1_->flags != f2_->flags)
      return 0;

    switch(f1_->fi_code) {
#line 288 "filter/f-inst.c"
 /* Comparison for FI_ADD */
#line 288
case FI_ADD:
#line 288
#define f1 (&(f1_->i_FI_ADD))
#line 288
#define f2 (&(f2_->i_FI_ADD))
#line 288
#undef f1
#line 288
#undef f2
#line 288
break;
#line 288

#line 293 "filter/f-inst.c"
 /* Comparison for FI_SUBTRACT */
#line 293
case FI_SUBTRACT:
#line 293
#define f1 (&(f1_->i_FI_SUBTRACT))
#line 293
#define f2 (&(f2_->i_FI_SUBTRACT))
#line 293
#undef f1
#line 293
#undef f2
#line 293
break;
#line 293

#line 298 "filter/f-inst.c"
 /* Comparison for FI_MULTIPLY */
#line 298
case FI_MULTIPLY:
#line 298
#define f1 (&(f1_->i_FI_MULTIPLY))
#line 298
#define f2 (&(f2_->i_FI_MULTIPLY))
#line 298
#undef f1
#line 298
#undef f2
#line 298
break;
#line 298

#line 304 "filter/f-inst.c"
 /* Comparison for FI_DIVIDE */
#line 304
case FI_DIVIDE:
#line 304
#define f1 (&(f1_->i_FI_DIVIDE))
#line 304
#define f2 (&(f2_->i_FI_DIVIDE))
#line 304
#undef f1
#line 304
#undef f2
#line 304
break;
#line 304

#line 309 "filter/f-inst.c"
 /* Comparison for FI_BITOR */
#line 309
case FI_BITOR:
#line 309
#define f1 (&(f1_->i_FI_BITOR))
#line 309
#define f2 (&(f2_->i_FI_BITOR))
#line 309
#undef f1
#line 309
#undef f2
#line 309
break;
#line 309

#line 314 "filter/f-inst.c"
 /* Comparison for FI_BITAND */
#line 314
case FI_BITAND:
#line 314
#define f1 (&(f1_->i_FI_BITAND))
#line 314
#define f2 (&(f2_->i_FI_BITAND))
#line 314
#undef f1
#line 314
#undef f2
#line 314
break;
#line 314

#line 324 "filter/f-inst.c"
 /* Comparison for FI_AND */
#line 324
case FI_AND:
#line 324
#define f1 (&(f1_->i_FI_AND))
#line 324
#define f2 (&(f2_->i_FI_AND))
#line 320 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 324 "filter/f-inst.c"
#undef f1
#line 324
#undef f2
#line 324
break;
#line 324

#line 335 "filter/f-inst.c"
 /* Comparison for FI_OR */
#line 335
case FI_OR:
#line 335
#define f1 (&(f1_->i_FI_OR))
#line 335
#define f2 (&(f2_->i_FI_OR))
#line 330 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 335 "filter/f-inst.c"
#undef f1
#line 335
#undef f2
#line 335
break;
#line 335

#line 345 "filter/f-inst.c"
 /* Comparison for FI_PAIR_CONSTRUCT */
#line 345
case FI_PAIR_CONSTRUCT:
#line 345
#define f1 (&(f1_->i_FI_PAIR_CONSTRUCT))
#line 345
#define f2 (&(f2_->i_FI_PAIR_CONSTRUCT))
#line 345
#undef f1
#line 345
#undef f2
#line 345
break;
#line 345

#line 385 "filter/f-inst.c"
 /* Comparison for FI_EC_CONSTRUCT */
#line 385
case FI_EC_CONSTRUCT:
#line 385
#define f1 (&(f1_->i_FI_EC_CONSTRUCT))
#line 385
#define f2 (&(f2_->i_FI_EC_CONSTRUCT))
#line 349 "filter/f-inst.c"
if (f1->ecs != f2->ecs) return 0;
#line 349

#line 349

#line 385 "filter/f-inst.c"
#undef f1
#line 385
#undef f2
#line 385
break;
#line 385

#line 392 "filter/f-inst.c"
 /* Comparison for FI_LC_CONSTRUCT */
#line 392
case FI_LC_CONSTRUCT:
#line 392
#define f1 (&(f1_->i_FI_LC_CONSTRUCT))
#line 392
#define f2 (&(f2_->i_FI_LC_CONSTRUCT))
#line 392
#undef f1
#line 392
#undef f2
#line 392
break;
#line 392

#line 442 "filter/f-inst.c"
 /* Comparison for FI_PATHMASK_CONSTRUCT */
#line 442
case FI_PATHMASK_CONSTRUCT:
#line 442
#define f1 (&(f1_->i_FI_PATHMASK_CONSTRUCT))
#line 442
#define f2 (&(f2_->i_FI_PATHMASK_CONSTRUCT))
#line 393 "filter/f-inst.c"
  if (f1->varcount != f2->varcount) return 0;
#line 442 "filter/f-inst.c"
#undef f1
#line 442
#undef f2
#line 442
break;
#line 442

#line 449 "filter/f-inst.c"
 /* Comparison for FI_NEQ */
#line 449
case FI_NEQ:
#line 449
#define f1 (&(f1_->i_FI_NEQ))
#line 449
#define f2 (&(f2_->i_FI_NEQ))
#line 449
#undef f1
#line 449
#undef f2
#line 449
break;
#line 449

#line 456 "filter/f-inst.c"
 /* Comparison for FI_EQ */
#line 456
case FI_EQ:
#line 456
#define f1 (&(f1_->i_FI_EQ))
#line 456
#define f2 (&(f2_->i_FI_EQ))
#line 456
#undef f1
#line 456
#undef f2
#line 456
break;
#line 456

#line 467 "filter/f-inst.c"
 /* Comparison for FI_LT */
#line 467
case FI_LT:
#line 467
#define f1 (&(f1_->i_FI_LT))
#line 467
#define f2 (&(f2_->i_FI_LT))
#line 467
#undef f1
#line 467
#undef f2
#line 467
break;
#line 467

#line 478 "filter/f-inst.c"
 /* Comparison for FI_LTE */
#line 478
case FI_LTE:
#line 478
#define f1 (&(f1_->i_FI_LTE))
#line 478
#define f2 (&(f2_->i_FI_LTE))
#line 478
#undef f1
#line 478
#undef f2
#line 478
break;
#line 478

#line 483 "filter/f-inst.c"
 /* Comparison for FI_NOT */
#line 483
case FI_NOT:
#line 483
#define f1 (&(f1_->i_FI_NOT))
#line 483
#define f2 (&(f2_->i_FI_NOT))
#line 483
#undef f1
#line 483
#undef f2
#line 483
break;
#line 483

#line 492 "filter/f-inst.c"
 /* Comparison for FI_MATCH */
#line 492
case FI_MATCH:
#line 492
#define f1 (&(f1_->i_FI_MATCH))
#line 492
#define f2 (&(f2_->i_FI_MATCH))
#line 492
#undef f1
#line 492
#undef f2
#line 492
break;
#line 492

#line 501 "filter/f-inst.c"
 /* Comparison for FI_NOT_MATCH */
#line 501
case FI_NOT_MATCH:
#line 501
#define f1 (&(f1_->i_FI_NOT_MATCH))
#line 501
#define f2 (&(f2_->i_FI_NOT_MATCH))
#line 501
#undef f1
#line 501
#undef f2
#line 501
break;
#line 501

#line 506 "filter/f-inst.c"
 /* Comparison for FI_DEFINED */
#line 506
case FI_DEFINED:
#line 506
#define f1 (&(f1_->i_FI_DEFINED))
#line 506
#define f2 (&(f2_->i_FI_DEFINED))
#line 506
#undef f1
#line 506
#undef f2
#line 506
break;
#line 506

#line 507 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_NET__type */
#line 507
case FI_METHOD__T_NET__type:
#line 507
#define f1 (&(f1_->i_FI_METHOD__T_NET__type))
#line 507
#define f2 (&(f2_->i_FI_METHOD__T_NET__type))
#line 507
#undef f1
#line 507
#undef f2
#line 507
break;
#line 507

#line 510 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_IP__is_v4 */
#line 510
case FI_METHOD__T_IP__is_v4:
#line 510
#define f1 (&(f1_->i_FI_METHOD__T_IP__is_v4))
#line 510
#define f2 (&(f2_->i_FI_METHOD__T_IP__is_v4))
#line 510
#undef f1
#line 510
#undef f2
#line 510
break;
#line 510

#line 523 "filter/f-inst.c"
 /* Comparison for FI_VAR_INIT */
#line 523
case FI_VAR_INIT:
#line 523
#define f1 (&(f1_->i_FI_VAR_INIT))
#line 523
#define f2 (&(f2_->i_FI_VAR_INIT))
#line 513 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 513

#line 513

#line 523 "filter/f-inst.c"
#undef f1
#line 523
#undef f2
#line 523
break;
#line 523

#line 534 "filter/f-inst.c"
 /* Comparison for FI_VAR_INIT0 */
#line 534
case FI_VAR_INIT0:
#line 534
#define f1 (&(f1_->i_FI_VAR_INIT0))
#line 534
#define f2 (&(f2_->i_FI_VAR_INIT0))
#line 525 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 525

#line 525

#line 534 "filter/f-inst.c"
#undef f1
#line 534
#undef f2
#line 534
break;
#line 534

#line 543 "filter/f-inst.c"
 /* Comparison for FI_VAR_SET */
#line 543
case FI_VAR_SET:
#line 543
#define f1 (&(f1_->i_FI_VAR_SET))
#line 543
#define f2 (&(f2_->i_FI_VAR_SET))
#line 537 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 537

#line 537

#line 543 "filter/f-inst.c"
#undef f1
#line 543
#undef f2
#line 543
break;
#line 543

#line 550 "filter/f-inst.c"
 /* Comparison for FI_VAR_GET */
#line 550
case FI_VAR_GET:
#line 550
#define f1 (&(f1_->i_FI_VAR_GET))
#line 550
#define f2 (&(f2_->i_FI_VAR_GET))
#line 544 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 544

#line 544

#line 550 "filter/f-inst.c"
#undef f1
#line 550
#undef f2
#line 550
break;
#line 550

#line 563 "filter/f-inst.c"
 /* Comparison for FI_CONSTANT */
#line 563
case FI_CONSTANT:
#line 563
#define f1 (&(f1_->i_FI_CONSTANT))
#line 563
#define f2 (&(f2_->i_FI_CONSTANT))
#line 551 "filter/f-inst.c"
if ( !val_same(&(f1->val), &(f2->val)) ) return 0;
#line 551

#line 551

#line 563 "filter/f-inst.c"
#undef f1
#line 563
#undef f2
#line 563
break;
#line 563

#line 564 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PATH__empty */
#line 564
case FI_METHOD__T_PATH__empty:
#line 564
#define f1 (&(f1_->i_FI_METHOD__T_PATH__empty))
#line 564
#define f2 (&(f2_->i_FI_METHOD__T_PATH__empty))
#line 564
#undef f1
#line 564
#undef f2
#line 564
break;
#line 564

#line 565 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_CLIST__empty */
#line 565
case FI_METHOD__T_CLIST__empty:
#line 565
#define f1 (&(f1_->i_FI_METHOD__T_CLIST__empty))
#line 565
#define f2 (&(f2_->i_FI_METHOD__T_CLIST__empty))
#line 565
#undef f1
#line 565
#undef f2
#line 565
break;
#line 565

#line 566 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_ECLIST__empty */
#line 566
case FI_METHOD__T_ECLIST__empty:
#line 566
#define f1 (&(f1_->i_FI_METHOD__T_ECLIST__empty))
#line 566
#define f2 (&(f2_->i_FI_METHOD__T_ECLIST__empty))
#line 566
#undef f1
#line 566
#undef f2
#line 566
break;
#line 566

#line 569 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LCLIST__empty */
#line 569
case FI_METHOD__T_LCLIST__empty:
#line 569
#define f1 (&(f1_->i_FI_METHOD__T_LCLIST__empty))
#line 569
#define f2 (&(f2_->i_FI_METHOD__T_LCLIST__empty))
#line 569
#undef f1
#line 569
#undef f2
#line 569
break;
#line 569

#line 591 "filter/f-inst.c"
 /* Comparison for FI_FOR_LOOP_START */
#line 591
case FI_FOR_LOOP_START:
#line 591
#define f1 (&(f1_->i_FI_FOR_LOOP_START))
#line 591
#define f2 (&(f2_->i_FI_FOR_LOOP_START))
#line 571 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 571

#line 571

#line 591 "filter/f-inst.c"
#undef f1
#line 591
#undef f2
#line 591
break;
#line 591

#line 600 "filter/f-inst.c"
 /* Comparison for FI_PATH_FOR_NEXT */
#line 600
case FI_PATH_FOR_NEXT:
#line 600
#define f1 (&(f1_->i_FI_PATH_FOR_NEXT))
#line 600
#define f2 (&(f2_->i_FI_PATH_FOR_NEXT))
#line 595 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 600 "filter/f-inst.c"
#undef f1
#line 600
#undef f2
#line 600
break;
#line 600

#line 609 "filter/f-inst.c"
 /* Comparison for FI_CLIST_FOR_NEXT */
#line 609
case FI_CLIST_FOR_NEXT:
#line 609
#define f1 (&(f1_->i_FI_CLIST_FOR_NEXT))
#line 609
#define f2 (&(f2_->i_FI_CLIST_FOR_NEXT))
#line 604 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 609 "filter/f-inst.c"
#undef f1
#line 609
#undef f2
#line 609
break;
#line 609

#line 618 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_FOR_NEXT */
#line 618
case FI_ECLIST_FOR_NEXT:
#line 618
#define f1 (&(f1_->i_FI_ECLIST_FOR_NEXT))
#line 618
#define f2 (&(f2_->i_FI_ECLIST_FOR_NEXT))
#line 613 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 618 "filter/f-inst.c"
#undef f1
#line 618
#undef f2
#line 618
break;
#line 618

#line 627 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_FOR_NEXT */
#line 627
case FI_LCLIST_FOR_NEXT:
#line 627
#define f1 (&(f1_->i_FI_LCLIST_FOR_NEXT))
#line 627
#define f2 (&(f2_->i_FI_LCLIST_FOR_NEXT))
#line 622 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 627 "filter/f-inst.c"
#undef f1
#line 627
#undef f2
#line 627
break;
#line 627

#line 640 "filter/f-inst.c"
 /* Comparison for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
case FI_ROUTES_BLOCK_FOR_NEXT:
#line 640
#define f1 (&(f1_->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 640
#define f2 (&(f2_->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 634 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 640 "filter/f-inst.c"
#undef f1
#line 640
#undef f2
#line 640
break;
#line 640

#line 648 "filter/f-inst.c"
 /* Comparison for FI_CONDITION */
#line 648
case FI_CONDITION:
#line 648
#define f1 (&(f1_->i_FI_CONDITION))
#line 648
#define f2 (&(f2_->i_FI_CONDITION))
#line 643 "filter/f-inst.c"
if (!f_same(f1->fl2, f2->fl2)) return 0;
#line 645 "filter/f-inst.c"
if (!f_same(f1->fl3, f2->fl3)) return 0;
#line 648 "filter/f-inst.c"
#undef f1
#line 648
#undef f2
#line 648
break;
#line 648

#line 661 "filter/f-inst.c"
 /* Comparison for FI_PRINT */
#line 661
case FI_PRINT:
#line 661
#define f1 (&(f1_->i_FI_PRINT))
#line 661
#define f2 (&(f2_->i_FI_PRINT))
#line 661
#undef f1
#line 661
#undef f2
#line 661
break;
#line 661

#line 668 "filter/f-inst.c"
 /* Comparison for FI_FLUSH */
#line 668
case FI_FLUSH:
#line 668
#define f1 (&(f1_->i_FI_FLUSH))
#line 668
#define f2 (&(f2_->i_FI_FLUSH))
#line 668
#undef f1
#line 668
#undef f2
#line 668
break;
#line 668

#line 682 "filter/f-inst.c"
 /* Comparison for FI_DIE */
#line 682
case FI_DIE:
#line 682
#define f1 (&(f1_->i_FI_DIE))
#line 682
#define f2 (&(f2_->i_FI_DIE))
#line 670 "filter/f-inst.c"
if (f1->fret != f2->fret) return 0;
#line 670

#line 670

#line 682 "filter/f-inst.c"
#undef f1
#line 682
#undef f2
#line 682
break;
#line 682

#line 689 "filter/f-inst.c"
 /* Comparison for FI_CURRENT_ROUTE */
#line 689
case FI_CURRENT_ROUTE:
#line 689
#define f1 (&(f1_->i_FI_CURRENT_ROUTE))
#line 689
#define f2 (&(f2_->i_FI_CURRENT_ROUTE))
#line 689
#undef f1
#line 689
#undef f2
#line 689
break;
#line 689

#line 737 "filter/f-inst.c"
 /* Comparison for FI_RTA_GET */
#line 737
case FI_RTA_GET:
#line 737
#define f1 (&(f1_->i_FI_RTA_GET))
#line 737
#define f2 (&(f2_->i_FI_RTA_GET))
#line 692 "filter/f-inst.c"
if (f1->sa.sa_code != f2->sa.sa_code) return 0;
#line 692

#line 692

#line 737 "filter/f-inst.c"
#undef f1
#line 737
#undef f2
#line 737
break;
#line 737

#line 866 "filter/f-inst.c"
 /* Comparison for FI_RTA_SET */
#line 866
case FI_RTA_SET:
#line 866
#define f1 (&(f1_->i_FI_RTA_SET))
#line 866
#define f2 (&(f2_->i_FI_RTA_SET))
#line 740 "filter/f-inst.c"
if (f1->sa.sa_code != f2->sa.sa_code) return 0;
#line 740

#line 740

#line 866 "filter/f-inst.c"
#undef f1
#line 866
#undef f2
#line 866
break;
#line 866

#line 903 "filter/f-inst.c"
 /* Comparison for FI_EA_GET */
#line 903
case FI_EA_GET:
#line 903
#define f1 (&(f1_->i_FI_EA_GET))
#line 903
#define f2 (&(f2_->i_FI_EA_GET))
#line 868 "filter/f-inst.c"
if (f1->da != f2->da) return 0;
#line 868

#line 868

#line 903 "filter/f-inst.c"
#undef f1
#line 903
#undef f2
#line 903
break;
#line 903

#line 944 "filter/f-inst.c"
 /* Comparison for FI_EA_SET */
#line 944
case FI_EA_SET:
#line 944
#define f1 (&(f1_->i_FI_EA_SET))
#line 944
#define f2 (&(f2_->i_FI_EA_SET))
#line 906 "filter/f-inst.c"
if (f1->da != f2->da) return 0;
#line 906

#line 906

#line 944 "filter/f-inst.c"
#undef f1
#line 944
#undef f2
#line 944
break;
#line 944

#line 951 "filter/f-inst.c"
 /* Comparison for FI_EA_UNSET */
#line 951
case FI_EA_UNSET:
#line 951
#define f1 (&(f1_->i_FI_EA_UNSET))
#line 951
#define f2 (&(f2_->i_FI_EA_UNSET))
#line 945 "filter/f-inst.c"
if (f1->da != f2->da) return 0;
#line 945

#line 945

#line 951 "filter/f-inst.c"
#undef f1
#line 951
#undef f2
#line 951
break;
#line 951

#line 965 "filter/f-inst.c"
 /* Comparison for FI_DEFAULT */
#line 965
case FI_DEFAULT:
#line 965
#define f1 (&(f1_->i_FI_DEFAULT))
#line 965
#define f2 (&(f2_->i_FI_DEFAULT))
#line 965
#undef f1
#line 965
#undef f2
#line 965
break;
#line 965

#line 966 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_NET__len */
#line 966
case FI_METHOD__T_NET__len:
#line 966
#define f1 (&(f1_->i_FI_METHOD__T_NET__len))
#line 966
#define f2 (&(f2_->i_FI_METHOD__T_NET__len))
#line 966
#undef f1
#line 966
#undef f2
#line 966
break;
#line 966

#line 967 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PATH__len */
#line 967
case FI_METHOD__T_PATH__len:
#line 967
#define f1 (&(f1_->i_FI_METHOD__T_PATH__len))
#line 967
#define f2 (&(f2_->i_FI_METHOD__T_PATH__len))
#line 967
#undef f1
#line 967
#undef f2
#line 967
break;
#line 967

#line 968 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_CLIST__len */
#line 968
case FI_METHOD__T_CLIST__len:
#line 968
#define f1 (&(f1_->i_FI_METHOD__T_CLIST__len))
#line 968
#define f2 (&(f2_->i_FI_METHOD__T_CLIST__len))
#line 968
#undef f1
#line 968
#undef f2
#line 968
break;
#line 968

#line 969 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_ECLIST__len */
#line 969
case FI_METHOD__T_ECLIST__len:
#line 969
#define f1 (&(f1_->i_FI_METHOD__T_ECLIST__len))
#line 969
#define f2 (&(f2_->i_FI_METHOD__T_ECLIST__len))
#line 969
#undef f1
#line 969
#undef f2
#line 969
break;
#line 969

#line 971 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LCLIST__len */
#line 971
case FI_METHOD__T_LCLIST__len:
#line 971
#define f1 (&(f1_->i_FI_METHOD__T_LCLIST__len))
#line 971
#define f2 (&(f2_->i_FI_METHOD__T_LCLIST__len))
#line 971
#undef f1
#line 971
#undef f2
#line 971
break;
#line 971

#line 1007 "filter/f-inst.c"
 /* Comparison for FI_NET_SRC */
#line 1007
case FI_NET_SRC:
#line 1007
#define f1 (&(f1_->i_FI_NET_SRC))
#line 1007
#define f2 (&(f2_->i_FI_NET_SRC))
#line 1007
#undef f1
#line 1007
#undef f2
#line 1007
break;
#line 1007

#line 1044 "filter/f-inst.c"
 /* Comparison for FI_NET_DST */
#line 1044
case FI_NET_DST:
#line 1044
#define f1 (&(f1_->i_FI_NET_DST))
#line 1044
#define f2 (&(f2_->i_FI_NET_DST))
#line 1044
#undef f1
#line 1044
#undef f2
#line 1044
break;
#line 1044

#line 1054 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_NET__maxlen */
#line 1054
case FI_METHOD__T_NET__maxlen:
#line 1054
#define f1 (&(f1_->i_FI_METHOD__T_NET__maxlen))
#line 1054
#define f2 (&(f2_->i_FI_METHOD__T_NET__maxlen))
#line 1054
#undef f1
#line 1054
#undef f2
#line 1054
break;
#line 1054

#line 1064 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_NET__asn */
#line 1064
case FI_METHOD__T_NET__asn:
#line 1064
#define f1 (&(f1_->i_FI_METHOD__T_NET__asn))
#line 1064
#define f2 (&(f2_->i_FI_METHOD__T_NET__asn))
#line 1064
#undef f1
#line 1064
#undef f2
#line 1064
break;
#line 1064

#line 1066 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_NET__ip */
#line 1066
case FI_METHOD__T_NET__ip:
#line 1066
#define f1 (&(f1_->i_FI_METHOD__T_NET__ip))
#line 1066
#define f2 (&(f2_->i_FI_METHOD__T_NET__ip))
#line 1066
#undef f1
#line 1066
#undef f2
#line 1066
break;
#line 1066

#line 1075 "filter/f-inst.c"
 /* Comparison for FI_ROUTE_DISTINGUISHER */
#line 1075
case FI_ROUTE_DISTINGUISHER:
#line 1075
#define f1 (&(f1_->i_FI_ROUTE_DISTINGUISHER))
#line 1075
#define f2 (&(f2_->i_FI_ROUTE_DISTINGUISHER))
#line 1075
#undef f1
#line 1075
#undef f2
#line 1075
break;
#line 1075

#line 1078 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PATH__first */
#line 1078
case FI_METHOD__T_PATH__first:
#line 1078
#define f1 (&(f1_->i_FI_METHOD__T_PATH__first))
#line 1078
#define f2 (&(f2_->i_FI_METHOD__T_PATH__first))
#line 1078
#undef f1
#line 1078
#undef f2
#line 1078
break;
#line 1078

#line 1081 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PATH__last */
#line 1081
case FI_METHOD__T_PATH__last:
#line 1081
#define f1 (&(f1_->i_FI_METHOD__T_PATH__last))
#line 1081
#define f2 (&(f2_->i_FI_METHOD__T_PATH__last))
#line 1081
#undef f1
#line 1081
#undef f2
#line 1081
break;
#line 1081

#line 1084 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PATH__last_nonaggregated */
#line 1084
case FI_METHOD__T_PATH__last_nonaggregated:
#line 1084
#define f1 (&(f1_->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1084
#define f2 (&(f2_->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1084
#undef f1
#line 1084
#undef f2
#line 1084
break;
#line 1084

#line 1087 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PAIR__asn */
#line 1087
case FI_METHOD__T_PAIR__asn:
#line 1087
#define f1 (&(f1_->i_FI_METHOD__T_PAIR__asn))
#line 1087
#define f2 (&(f2_->i_FI_METHOD__T_PAIR__asn))
#line 1087
#undef f1
#line 1087
#undef f2
#line 1087
break;
#line 1087

#line 1090 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_PAIR__data */
#line 1090
case FI_METHOD__T_PAIR__data:
#line 1090
#define f1 (&(f1_->i_FI_METHOD__T_PAIR__data))
#line 1090
#define f2 (&(f2_->i_FI_METHOD__T_PAIR__data))
#line 1090
#undef f1
#line 1090
#undef f2
#line 1090
break;
#line 1090

#line 1093 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LC__asn */
#line 1093
case FI_METHOD__T_LC__asn:
#line 1093
#define f1 (&(f1_->i_FI_METHOD__T_LC__asn))
#line 1093
#define f2 (&(f2_->i_FI_METHOD__T_LC__asn))
#line 1093
#undef f1
#line 1093
#undef f2
#line 1093
break;
#line 1093

#line 1096 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LC__data1 */
#line 1096
case FI_METHOD__T_LC__data1:
#line 1096
#define f1 (&(f1_->i_FI_METHOD__T_LC__data1))
#line 1096
#define f2 (&(f2_->i_FI_METHOD__T_LC__data1))
#line 1096
#undef f1
#line 1096
#undef f2
#line 1096
break;
#line 1096

#line 1099 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LC__data2 */
#line 1099
case FI_METHOD__T_LC__data2:
#line 1099
#define f1 (&(f1_->i_FI_METHOD__T_LC__data2))
#line 1099
#define f2 (&(f2_->i_FI_METHOD__T_LC__data2))
#line 1099
#undef f1
#line 1099
#undef f2
#line 1099
break;
#line 1099

#line 1102 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_CLIST__min */
#line 1102
case FI_METHOD__T_CLIST__min:
#line 1102
#define f1 (&(f1_->i_FI_METHOD__T_CLIST__min))
#line 1102
#define f2 (&(f2_->i_FI_METHOD__T_CLIST__min))
#line 1102
#undef f1
#line 1102
#undef f2
#line 1102
break;
#line 1102

#line 1105 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_CLIST__max */
#line 1105
case FI_METHOD__T_CLIST__max:
#line 1105
#define f1 (&(f1_->i_FI_METHOD__T_CLIST__max))
#line 1105
#define f2 (&(f2_->i_FI_METHOD__T_CLIST__max))
#line 1105
#undef f1
#line 1105
#undef f2
#line 1105
break;
#line 1105

#line 1108 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_ECLIST__min */
#line 1108
case FI_METHOD__T_ECLIST__min:
#line 1108
#define f1 (&(f1_->i_FI_METHOD__T_ECLIST__min))
#line 1108
#define f2 (&(f2_->i_FI_METHOD__T_ECLIST__min))
#line 1108
#undef f1
#line 1108
#undef f2
#line 1108
break;
#line 1108

#line 1111 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_ECLIST__max */
#line 1111
case FI_METHOD__T_ECLIST__max:
#line 1111
#define f1 (&(f1_->i_FI_METHOD__T_ECLIST__max))
#line 1111
#define f2 (&(f2_->i_FI_METHOD__T_ECLIST__max))
#line 1111
#undef f1
#line 1111
#undef f2
#line 1111
break;
#line 1111

#line 1114 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LCLIST__min */
#line 1114
case FI_METHOD__T_LCLIST__min:
#line 1114
#define f1 (&(f1_->i_FI_METHOD__T_LCLIST__min))
#line 1114
#define f2 (&(f2_->i_FI_METHOD__T_LCLIST__min))
#line 1114
#undef f1
#line 1114
#undef f2
#line 1114
break;
#line 1114

#line 1116 "filter/f-inst.c"
 /* Comparison for FI_METHOD__T_LCLIST__max */
#line 1116
case FI_METHOD__T_LCLIST__max:
#line 1116
#define f1 (&(f1_->i_FI_METHOD__T_LCLIST__max))
#line 1116
#define f2 (&(f2_->i_FI_METHOD__T_LCLIST__max))
#line 1116
#undef f1
#line 1116
#undef f2
#line 1116
break;
#line 1116

#line 1142 "filter/f-inst.c"
 /* Comparison for FI_RETURN */
#line 1142
case FI_RETURN:
#line 1142
#define f1 (&(f1_->i_FI_RETURN))
#line 1142
#define f2 (&(f2_->i_FI_RETURN))
#line 1142
#undef f1
#line 1142
#undef f2
#line 1142
break;
#line 1142

#line 1202 "filter/f-inst.c"
 /* Comparison for FI_CALL */
#line 1202
case FI_CALL:
#line 1202
#define f1 (&(f1_->i_FI_CALL))
#line 1202
#define f2 (&(f2_->i_FI_CALL))
#line 1144 "filter/f-inst.c"
  if (f1->varcount != f2->varcount) return 0;
#line 1145 "filter/f-inst.c"
if (strcmp(f1->sym->name, f2->sym->name) || (f1->sym->class != f2->sym->class)) return 0;
#line 1145

#line 1145


#line 1179 "filter/f-inst.c"
    if (!(f1->sym->flags & SYM_FLAG_SAME) && !(f1_->flags & FIF_RECURSIVE))
      return 0;

    #line 1202 "filter/f-inst.c"
#undef f1
#line 1202
#undef f2
#line 1202
break;
#line 1202

#line 1207 "filter/f-inst.c"
 /* Comparison for FI_DROP_RESULT */
#line 1207
case FI_DROP_RESULT:
#line 1207
#define f1 (&(f1_->i_FI_DROP_RESULT))
#line 1207
#define f2 (&(f2_->i_FI_DROP_RESULT))
#line 1207
#undef f1
#line 1207
#undef f2
#line 1207
break;
#line 1207

#line 1248 "filter/f-inst.c"
 /* Comparison for FI_SWITCH */
#line 1248
case FI_SWITCH:
#line 1248
#define f1 (&(f1_->i_FI_SWITCH))
#line 1248
#define f2 (&(f2_->i_FI_SWITCH))
#line 1210 "filter/f-inst.c"
if (!same_tree(f1->tree, f2->tree)) return 0;
#line 1210

#line 1210

#line 1248 "filter/f-inst.c"
#undef f1
#line 1248
#undef f2
#line 1248
break;
#line 1248

#line 1257 "filter/f-inst.c"
 /* Comparison for FI_IP_MASK */
#line 1257
case FI_IP_MASK:
#line 1257
#define f1 (&(f1_->i_FI_IP_MASK))
#line 1257
#define f2 (&(f2_->i_FI_IP_MASK))
#line 1257
#undef f1
#line 1257
#undef f2
#line 1257
break;
#line 1257

#line 1265 "filter/f-inst.c"
 /* Comparison for FI_PATH_PREPEND */
#line 1265
case FI_PATH_PREPEND:
#line 1265
#define f1 (&(f1_->i_FI_PATH_PREPEND))
#line 1265
#define f2 (&(f2_->i_FI_PATH_PREPEND))
#line 1265
#undef f1
#line 1265
#undef f2
#line 1265
break;
#line 1265

#line 1272 "filter/f-inst.c"
 /* Comparison for FI_CLIST_ADD_PAIR */
#line 1272
case FI_CLIST_ADD_PAIR:
#line 1272
#define f1 (&(f1_->i_FI_CLIST_ADD_PAIR))
#line 1272
#define f2 (&(f2_->i_FI_CLIST_ADD_PAIR))
#line 1272
#undef f1
#line 1272
#undef f2
#line 1272
break;
#line 1272

#line 1286 "filter/f-inst.c"
 /* Comparison for FI_CLIST_ADD_IP */
#line 1286
case FI_CLIST_ADD_IP:
#line 1286
#define f1 (&(f1_->i_FI_CLIST_ADD_IP))
#line 1286
#define f2 (&(f2_->i_FI_CLIST_ADD_IP))
#line 1286
#undef f1
#line 1286
#undef f2
#line 1286
break;
#line 1286

#line 1293 "filter/f-inst.c"
 /* Comparison for FI_CLIST_ADD_QUAD */
#line 1293
case FI_CLIST_ADD_QUAD:
#line 1293
#define f1 (&(f1_->i_FI_CLIST_ADD_QUAD))
#line 1293
#define f2 (&(f2_->i_FI_CLIST_ADD_QUAD))
#line 1293
#undef f1
#line 1293
#undef f2
#line 1293
break;
#line 1293

#line 1300 "filter/f-inst.c"
 /* Comparison for FI_CLIST_ADD_CLIST */
#line 1300
case FI_CLIST_ADD_CLIST:
#line 1300
#define f1 (&(f1_->i_FI_CLIST_ADD_CLIST))
#line 1300
#define f2 (&(f2_->i_FI_CLIST_ADD_CLIST))
#line 1300
#undef f1
#line 1300
#undef f2
#line 1300
break;
#line 1300

#line 1307 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_ADD_EC */
#line 1307
case FI_ECLIST_ADD_EC:
#line 1307
#define f1 (&(f1_->i_FI_ECLIST_ADD_EC))
#line 1307
#define f2 (&(f2_->i_FI_ECLIST_ADD_EC))
#line 1307
#undef f1
#line 1307
#undef f2
#line 1307
break;
#line 1307

#line 1314 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_ADD_ECLIST */
#line 1314
case FI_ECLIST_ADD_ECLIST:
#line 1314
#define f1 (&(f1_->i_FI_ECLIST_ADD_ECLIST))
#line 1314
#define f2 (&(f2_->i_FI_ECLIST_ADD_ECLIST))
#line 1314
#undef f1
#line 1314
#undef f2
#line 1314
break;
#line 1314

#line 1321 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_ADD_LC */
#line 1321
case FI_LCLIST_ADD_LC:
#line 1321
#define f1 (&(f1_->i_FI_LCLIST_ADD_LC))
#line 1321
#define f2 (&(f2_->i_FI_LCLIST_ADD_LC))
#line 1321
#undef f1
#line 1321
#undef f2
#line 1321
break;
#line 1321

#line 1328 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_ADD_LCLIST */
#line 1328
case FI_LCLIST_ADD_LCLIST:
#line 1328
#define f1 (&(f1_->i_FI_LCLIST_ADD_LCLIST))
#line 1328
#define f2 (&(f2_->i_FI_LCLIST_ADD_LCLIST))
#line 1328
#undef f1
#line 1328
#undef f2
#line 1328
break;
#line 1328

#line 1335 "filter/f-inst.c"
 /* Comparison for FI_PATH_DELETE_INT */
#line 1335
case FI_PATH_DELETE_INT:
#line 1335
#define f1 (&(f1_->i_FI_PATH_DELETE_INT))
#line 1335
#define f2 (&(f2_->i_FI_PATH_DELETE_INT))
#line 1335
#undef f1
#line 1335
#undef f2
#line 1335
break;
#line 1335

#line 1347 "filter/f-inst.c"
 /* Comparison for FI_PATH_DELETE_SET */
#line 1347
case FI_PATH_DELETE_SET:
#line 1347
#define f1 (&(f1_->i_FI_PATH_DELETE_SET))
#line 1347
#define f2 (&(f2_->i_FI_PATH_DELETE_SET))
#line 1347
#undef f1
#line 1347
#undef f2
#line 1347
break;
#line 1347

#line 1354 "filter/f-inst.c"
 /* Comparison for FI_CLIST_DELETE_PAIR */
#line 1354
case FI_CLIST_DELETE_PAIR:
#line 1354
#define f1 (&(f1_->i_FI_CLIST_DELETE_PAIR))
#line 1354
#define f2 (&(f2_->i_FI_CLIST_DELETE_PAIR))
#line 1354
#undef f1
#line 1354
#undef f2
#line 1354
break;
#line 1354

#line 1368 "filter/f-inst.c"
 /* Comparison for FI_CLIST_DELETE_IP */
#line 1368
case FI_CLIST_DELETE_IP:
#line 1368
#define f1 (&(f1_->i_FI_CLIST_DELETE_IP))
#line 1368
#define f2 (&(f2_->i_FI_CLIST_DELETE_IP))
#line 1368
#undef f1
#line 1368
#undef f2
#line 1368
break;
#line 1368

#line 1375 "filter/f-inst.c"
 /* Comparison for FI_CLIST_DELETE_QUAD */
#line 1375
case FI_CLIST_DELETE_QUAD:
#line 1375
#define f1 (&(f1_->i_FI_CLIST_DELETE_QUAD))
#line 1375
#define f2 (&(f2_->i_FI_CLIST_DELETE_QUAD))
#line 1375
#undef f1
#line 1375
#undef f2
#line 1375
break;
#line 1375

#line 1382 "filter/f-inst.c"
 /* Comparison for FI_CLIST_DELETE_CLIST */
#line 1382
case FI_CLIST_DELETE_CLIST:
#line 1382
#define f1 (&(f1_->i_FI_CLIST_DELETE_CLIST))
#line 1382
#define f2 (&(f2_->i_FI_CLIST_DELETE_CLIST))
#line 1382
#undef f1
#line 1382
#undef f2
#line 1382
break;
#line 1382

#line 1393 "filter/f-inst.c"
 /* Comparison for FI_CLIST_DELETE_SET */
#line 1393
case FI_CLIST_DELETE_SET:
#line 1393
#define f1 (&(f1_->i_FI_CLIST_DELETE_SET))
#line 1393
#define f2 (&(f2_->i_FI_CLIST_DELETE_SET))
#line 1393
#undef f1
#line 1393
#undef f2
#line 1393
break;
#line 1393

#line 1400 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_DELETE_EC */
#line 1400
case FI_ECLIST_DELETE_EC:
#line 1400
#define f1 (&(f1_->i_FI_ECLIST_DELETE_EC))
#line 1400
#define f2 (&(f2_->i_FI_ECLIST_DELETE_EC))
#line 1400
#undef f1
#line 1400
#undef f2
#line 1400
break;
#line 1400

#line 1407 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_DELETE_ECLIST */
#line 1407
case FI_ECLIST_DELETE_ECLIST:
#line 1407
#define f1 (&(f1_->i_FI_ECLIST_DELETE_ECLIST))
#line 1407
#define f2 (&(f2_->i_FI_ECLIST_DELETE_ECLIST))
#line 1407
#undef f1
#line 1407
#undef f2
#line 1407
break;
#line 1407

#line 1418 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_DELETE_SET */
#line 1418
case FI_ECLIST_DELETE_SET:
#line 1418
#define f1 (&(f1_->i_FI_ECLIST_DELETE_SET))
#line 1418
#define f2 (&(f2_->i_FI_ECLIST_DELETE_SET))
#line 1418
#undef f1
#line 1418
#undef f2
#line 1418
break;
#line 1418

#line 1425 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_DELETE_LC */
#line 1425
case FI_LCLIST_DELETE_LC:
#line 1425
#define f1 (&(f1_->i_FI_LCLIST_DELETE_LC))
#line 1425
#define f2 (&(f2_->i_FI_LCLIST_DELETE_LC))
#line 1425
#undef f1
#line 1425
#undef f2
#line 1425
break;
#line 1425

#line 1432 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_DELETE_LCLIST */
#line 1432
case FI_LCLIST_DELETE_LCLIST:
#line 1432
#define f1 (&(f1_->i_FI_LCLIST_DELETE_LCLIST))
#line 1432
#define f2 (&(f2_->i_FI_LCLIST_DELETE_LCLIST))
#line 1432
#undef f1
#line 1432
#undef f2
#line 1432
break;
#line 1432

#line 1443 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_DELETE_SET */
#line 1443
case FI_LCLIST_DELETE_SET:
#line 1443
#define f1 (&(f1_->i_FI_LCLIST_DELETE_SET))
#line 1443
#define f2 (&(f2_->i_FI_LCLIST_DELETE_SET))
#line 1443
#undef f1
#line 1443
#undef f2
#line 1443
break;
#line 1443

#line 1454 "filter/f-inst.c"
 /* Comparison for FI_PATH_FILTER_SET */
#line 1454
case FI_PATH_FILTER_SET:
#line 1454
#define f1 (&(f1_->i_FI_PATH_FILTER_SET))
#line 1454
#define f2 (&(f2_->i_FI_PATH_FILTER_SET))
#line 1454
#undef f1
#line 1454
#undef f2
#line 1454
break;
#line 1454

#line 1461 "filter/f-inst.c"
 /* Comparison for FI_CLIST_FILTER_CLIST */
#line 1461
case FI_CLIST_FILTER_CLIST:
#line 1461
#define f1 (&(f1_->i_FI_CLIST_FILTER_CLIST))
#line 1461
#define f2 (&(f2_->i_FI_CLIST_FILTER_CLIST))
#line 1461
#undef f1
#line 1461
#undef f2
#line 1461
break;
#line 1461

#line 1472 "filter/f-inst.c"
 /* Comparison for FI_CLIST_FILTER_SET */
#line 1472
case FI_CLIST_FILTER_SET:
#line 1472
#define f1 (&(f1_->i_FI_CLIST_FILTER_SET))
#line 1472
#define f2 (&(f2_->i_FI_CLIST_FILTER_SET))
#line 1472
#undef f1
#line 1472
#undef f2
#line 1472
break;
#line 1472

#line 1479 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_FILTER_ECLIST */
#line 1479
case FI_ECLIST_FILTER_ECLIST:
#line 1479
#define f1 (&(f1_->i_FI_ECLIST_FILTER_ECLIST))
#line 1479
#define f2 (&(f2_->i_FI_ECLIST_FILTER_ECLIST))
#line 1479
#undef f1
#line 1479
#undef f2
#line 1479
break;
#line 1479

#line 1490 "filter/f-inst.c"
 /* Comparison for FI_ECLIST_FILTER_SET */
#line 1490
case FI_ECLIST_FILTER_SET:
#line 1490
#define f1 (&(f1_->i_FI_ECLIST_FILTER_SET))
#line 1490
#define f2 (&(f2_->i_FI_ECLIST_FILTER_SET))
#line 1490
#undef f1
#line 1490
#undef f2
#line 1490
break;
#line 1490

#line 1497 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_FILTER_LCLIST */
#line 1497
case FI_LCLIST_FILTER_LCLIST:
#line 1497
#define f1 (&(f1_->i_FI_LCLIST_FILTER_LCLIST))
#line 1497
#define f2 (&(f2_->i_FI_LCLIST_FILTER_LCLIST))
#line 1497
#undef f1
#line 1497
#undef f2
#line 1497
break;
#line 1497

#line 1508 "filter/f-inst.c"
 /* Comparison for FI_LCLIST_FILTER_SET */
#line 1508
case FI_LCLIST_FILTER_SET:
#line 1508
#define f1 (&(f1_->i_FI_LCLIST_FILTER_SET))
#line 1508
#define f2 (&(f2_->i_FI_LCLIST_FILTER_SET))
#line 1508
#undef f1
#line 1508
#undef f2
#line 1508
break;
#line 1508

#line 1530 "filter/f-inst.c"
 /* Comparison for FI_ROA_CHECK */
#line 1530
case FI_ROA_CHECK:
#line 1530
#define f1 (&(f1_->i_FI_ROA_CHECK))
#line 1530
#define f2 (&(f2_->i_FI_ROA_CHECK))
#line 1512 "filter/f-inst.c"
if (strcmp(f1->rtc->name, f2->rtc->name)) return 0;
#line 1512

#line 1512

#line 1530 "filter/f-inst.c"
#undef f1
#line 1530
#undef f2
#line 1530
break;
#line 1530

#line 1546 "filter/f-inst.c"
 /* Comparison for FI_ASPA_CHECK_EXPLICIT */
#line 1546
case FI_ASPA_CHECK_EXPLICIT:
#line 1546
#define f1 (&(f1_->i_FI_ASPA_CHECK_EXPLICIT))
#line 1546
#define f2 (&(f2_->i_FI_ASPA_CHECK_EXPLICIT))
#line 1534 "filter/f-inst.c"
if (strcmp(f1->rtc->name, f2->rtc->name)) return 0;
#line 1534

#line 1534

#line 1546 "filter/f-inst.c"
#undef f1
#line 1546
#undef f2
#line 1546
break;
#line 1546

#line 1561 "filter/f-inst.c"
 /* Comparison for FI_FROM_HEX */
#line 1561
case FI_FROM_HEX:
#line 1561
#define f1 (&(f1_->i_FI_FROM_HEX))
#line 1561
#define f2 (&(f2_->i_FI_FROM_HEX))
#line 1561
#undef f1
#line 1561
#undef f2
#line 1561
break;
#line 1561

#line 1566 "filter/f-inst.c"
 /* Comparison for FI_FORMAT */
#line 1566
case FI_FORMAT:
#line 1566
#define f1 (&(f1_->i_FI_FORMAT))
#line 1566
#define f2 (&(f2_->i_FI_FORMAT))
#line 1566
#undef f1
#line 1566
#undef f2
#line 1566
break;
#line 1566

#line 830 "filter/decl.m4"
 /* Comparison for FI_ASSERT */
#line 830
case FI_ASSERT:
#line 830
#define f1 (&(f1_->i_FI_ASSERT))
#line 830
#define f2 (&(f2_->i_FI_ASSERT))
#line 1570 "filter/f-inst.c"
if (strcmp(f1->s, f2->s)) return 0;
#line 1570

#line 1570

#line 830 "filter/decl.m4"
#undef f1
#line 830
#undef f2
#line 830
break;
#line 830

#line 751 "filter/decl.m4"

    }
  }
#undef f1_
#undef f2_
  return 1;
}


/* Part of FI_SWITCH filter iterator */
static void
f_add_tree_lines(const struct f_tree *t, void *fit_)
{
  struct filter_iterator * fit = fit_;

  if (t->data)
    BUFFER_PUSH(fit->lines) = t->data;
}

/* Filter line iterator */
void
f_add_lines(const struct f_line_item *what, struct filter_iterator *fit)
{
  switch(what->fi_code) {
#line 288 "filter/f-inst.c"
 /* Iteration for FI_ADD */
#line 288
case FI_ADD:
#line 288
#define whati (&(what->i_FI_ADD))
#line 288
#undef whati
#line 288
break;
#line 288

#line 293 "filter/f-inst.c"
 /* Iteration for FI_SUBTRACT */
#line 293
case FI_SUBTRACT:
#line 293
#define whati (&(what->i_FI_SUBTRACT))
#line 293
#undef whati
#line 293
break;
#line 293

#line 298 "filter/f-inst.c"
 /* Iteration for FI_MULTIPLY */
#line 298
case FI_MULTIPLY:
#line 298
#define whati (&(what->i_FI_MULTIPLY))
#line 298
#undef whati
#line 298
break;
#line 298

#line 304 "filter/f-inst.c"
 /* Iteration for FI_DIVIDE */
#line 304
case FI_DIVIDE:
#line 304
#define whati (&(what->i_FI_DIVIDE))
#line 304
#undef whati
#line 304
break;
#line 304

#line 309 "filter/f-inst.c"
 /* Iteration for FI_BITOR */
#line 309
case FI_BITOR:
#line 309
#define whati (&(what->i_FI_BITOR))
#line 309
#undef whati
#line 309
break;
#line 309

#line 314 "filter/f-inst.c"
 /* Iteration for FI_BITAND */
#line 314
case FI_BITAND:
#line 314
#define whati (&(what->i_FI_BITAND))
#line 314
#undef whati
#line 314
break;
#line 314

#line 324 "filter/f-inst.c"
 /* Iteration for FI_AND */
#line 324
case FI_AND:
#line 324
#define whati (&(what->i_FI_AND))
#line 320 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 324 "filter/f-inst.c"
#undef whati
#line 324
break;
#line 324

#line 335 "filter/f-inst.c"
 /* Iteration for FI_OR */
#line 335
case FI_OR:
#line 335
#define whati (&(what->i_FI_OR))
#line 330 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 335 "filter/f-inst.c"
#undef whati
#line 335
break;
#line 335

#line 345 "filter/f-inst.c"
 /* Iteration for FI_PAIR_CONSTRUCT */
#line 345
case FI_PAIR_CONSTRUCT:
#line 345
#define whati (&(what->i_FI_PAIR_CONSTRUCT))
#line 345
#undef whati
#line 345
break;
#line 345

#line 385 "filter/f-inst.c"
 /* Iteration for FI_EC_CONSTRUCT */
#line 385
case FI_EC_CONSTRUCT:
#line 385
#define whati (&(what->i_FI_EC_CONSTRUCT))
#line 385
#undef whati
#line 385
break;
#line 385

#line 392 "filter/f-inst.c"
 /* Iteration for FI_LC_CONSTRUCT */
#line 392
case FI_LC_CONSTRUCT:
#line 392
#define whati (&(what->i_FI_LC_CONSTRUCT))
#line 392
#undef whati
#line 392
break;
#line 392

#line 442 "filter/f-inst.c"
 /* Iteration for FI_PATHMASK_CONSTRUCT */
#line 442
case FI_PATHMASK_CONSTRUCT:
#line 442
#define whati (&(what->i_FI_PATHMASK_CONSTRUCT))
#line 442
#undef whati
#line 442
break;
#line 442

#line 449 "filter/f-inst.c"
 /* Iteration for FI_NEQ */
#line 449
case FI_NEQ:
#line 449
#define whati (&(what->i_FI_NEQ))
#line 449
#undef whati
#line 449
break;
#line 449

#line 456 "filter/f-inst.c"
 /* Iteration for FI_EQ */
#line 456
case FI_EQ:
#line 456
#define whati (&(what->i_FI_EQ))
#line 456
#undef whati
#line 456
break;
#line 456

#line 467 "filter/f-inst.c"
 /* Iteration for FI_LT */
#line 467
case FI_LT:
#line 467
#define whati (&(what->i_FI_LT))
#line 467
#undef whati
#line 467
break;
#line 467

#line 478 "filter/f-inst.c"
 /* Iteration for FI_LTE */
#line 478
case FI_LTE:
#line 478
#define whati (&(what->i_FI_LTE))
#line 478
#undef whati
#line 478
break;
#line 478

#line 483 "filter/f-inst.c"
 /* Iteration for FI_NOT */
#line 483
case FI_NOT:
#line 483
#define whati (&(what->i_FI_NOT))
#line 483
#undef whati
#line 483
break;
#line 483

#line 492 "filter/f-inst.c"
 /* Iteration for FI_MATCH */
#line 492
case FI_MATCH:
#line 492
#define whati (&(what->i_FI_MATCH))
#line 492
#undef whati
#line 492
break;
#line 492

#line 501 "filter/f-inst.c"
 /* Iteration for FI_NOT_MATCH */
#line 501
case FI_NOT_MATCH:
#line 501
#define whati (&(what->i_FI_NOT_MATCH))
#line 501
#undef whati
#line 501
break;
#line 501

#line 506 "filter/f-inst.c"
 /* Iteration for FI_DEFINED */
#line 506
case FI_DEFINED:
#line 506
#define whati (&(what->i_FI_DEFINED))
#line 506
#undef whati
#line 506
break;
#line 506

#line 507 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_NET__type */
#line 507
case FI_METHOD__T_NET__type:
#line 507
#define whati (&(what->i_FI_METHOD__T_NET__type))
#line 507
#undef whati
#line 507
break;
#line 507

#line 510 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_IP__is_v4 */
#line 510
case FI_METHOD__T_IP__is_v4:
#line 510
#define whati (&(what->i_FI_METHOD__T_IP__is_v4))
#line 510
#undef whati
#line 510
break;
#line 510

#line 523 "filter/f-inst.c"
 /* Iteration for FI_VAR_INIT */
#line 523
case FI_VAR_INIT:
#line 523
#define whati (&(what->i_FI_VAR_INIT))
#line 523
#undef whati
#line 523
break;
#line 523

#line 534 "filter/f-inst.c"
 /* Iteration for FI_VAR_INIT0 */
#line 534
case FI_VAR_INIT0:
#line 534
#define whati (&(what->i_FI_VAR_INIT0))
#line 534
#undef whati
#line 534
break;
#line 534

#line 543 "filter/f-inst.c"
 /* Iteration for FI_VAR_SET */
#line 543
case FI_VAR_SET:
#line 543
#define whati (&(what->i_FI_VAR_SET))
#line 543
#undef whati
#line 543
break;
#line 543

#line 550 "filter/f-inst.c"
 /* Iteration for FI_VAR_GET */
#line 550
case FI_VAR_GET:
#line 550
#define whati (&(what->i_FI_VAR_GET))
#line 550
#undef whati
#line 550
break;
#line 550

#line 563 "filter/f-inst.c"
 /* Iteration for FI_CONSTANT */
#line 563
case FI_CONSTANT:
#line 563
#define whati (&(what->i_FI_CONSTANT))
#line 563
#undef whati
#line 563
break;
#line 563

#line 564 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PATH__empty */
#line 564
case FI_METHOD__T_PATH__empty:
#line 564
#define whati (&(what->i_FI_METHOD__T_PATH__empty))
#line 564
#undef whati
#line 564
break;
#line 564

#line 565 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_CLIST__empty */
#line 565
case FI_METHOD__T_CLIST__empty:
#line 565
#define whati (&(what->i_FI_METHOD__T_CLIST__empty))
#line 565
#undef whati
#line 565
break;
#line 565

#line 566 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_ECLIST__empty */
#line 566
case FI_METHOD__T_ECLIST__empty:
#line 566
#define whati (&(what->i_FI_METHOD__T_ECLIST__empty))
#line 566
#undef whati
#line 566
break;
#line 566

#line 569 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LCLIST__empty */
#line 569
case FI_METHOD__T_LCLIST__empty:
#line 569
#define whati (&(what->i_FI_METHOD__T_LCLIST__empty))
#line 569
#undef whati
#line 569
break;
#line 569

#line 591 "filter/f-inst.c"
 /* Iteration for FI_FOR_LOOP_START */
#line 591
case FI_FOR_LOOP_START:
#line 591
#define whati (&(what->i_FI_FOR_LOOP_START))
#line 591
#undef whati
#line 591
break;
#line 591

#line 600 "filter/f-inst.c"
 /* Iteration for FI_PATH_FOR_NEXT */
#line 600
case FI_PATH_FOR_NEXT:
#line 600
#define whati (&(what->i_FI_PATH_FOR_NEXT))
#line 595 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 600 "filter/f-inst.c"
#undef whati
#line 600
break;
#line 600

#line 609 "filter/f-inst.c"
 /* Iteration for FI_CLIST_FOR_NEXT */
#line 609
case FI_CLIST_FOR_NEXT:
#line 609
#define whati (&(what->i_FI_CLIST_FOR_NEXT))
#line 604 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 609 "filter/f-inst.c"
#undef whati
#line 609
break;
#line 609

#line 618 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_FOR_NEXT */
#line 618
case FI_ECLIST_FOR_NEXT:
#line 618
#define whati (&(what->i_FI_ECLIST_FOR_NEXT))
#line 613 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 618 "filter/f-inst.c"
#undef whati
#line 618
break;
#line 618

#line 627 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_FOR_NEXT */
#line 627
case FI_LCLIST_FOR_NEXT:
#line 627
#define whati (&(what->i_FI_LCLIST_FOR_NEXT))
#line 622 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 627 "filter/f-inst.c"
#undef whati
#line 627
break;
#line 627

#line 640 "filter/f-inst.c"
 /* Iteration for FI_ROUTES_BLOCK_FOR_NEXT */
#line 640
case FI_ROUTES_BLOCK_FOR_NEXT:
#line 640
#define whati (&(what->i_FI_ROUTES_BLOCK_FOR_NEXT))
#line 634 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 640 "filter/f-inst.c"
#undef whati
#line 640
break;
#line 640

#line 648 "filter/f-inst.c"
 /* Iteration for FI_CONDITION */
#line 648
case FI_CONDITION:
#line 648
#define whati (&(what->i_FI_CONDITION))
#line 643 "filter/f-inst.c"
if (whati->fl2) BUFFER_PUSH(fit->lines) = whati->fl2;
#line 645 "filter/f-inst.c"
if (whati->fl3) BUFFER_PUSH(fit->lines) = whati->fl3;
#line 648 "filter/f-inst.c"
#undef whati
#line 648
break;
#line 648

#line 661 "filter/f-inst.c"
 /* Iteration for FI_PRINT */
#line 661
case FI_PRINT:
#line 661
#define whati (&(what->i_FI_PRINT))
#line 661
#undef whati
#line 661
break;
#line 661

#line 668 "filter/f-inst.c"
 /* Iteration for FI_FLUSH */
#line 668
case FI_FLUSH:
#line 668
#define whati (&(what->i_FI_FLUSH))
#line 668
#undef whati
#line 668
break;
#line 668

#line 682 "filter/f-inst.c"
 /* Iteration for FI_DIE */
#line 682
case FI_DIE:
#line 682
#define whati (&(what->i_FI_DIE))
#line 682
#undef whati
#line 682
break;
#line 682

#line 689 "filter/f-inst.c"
 /* Iteration for FI_CURRENT_ROUTE */
#line 689
case FI_CURRENT_ROUTE:
#line 689
#define whati (&(what->i_FI_CURRENT_ROUTE))
#line 689
#undef whati
#line 689
break;
#line 689

#line 737 "filter/f-inst.c"
 /* Iteration for FI_RTA_GET */
#line 737
case FI_RTA_GET:
#line 737
#define whati (&(what->i_FI_RTA_GET))
#line 737
#undef whati
#line 737
break;
#line 737

#line 866 "filter/f-inst.c"
 /* Iteration for FI_RTA_SET */
#line 866
case FI_RTA_SET:
#line 866
#define whati (&(what->i_FI_RTA_SET))
#line 866
#undef whati
#line 866
break;
#line 866

#line 903 "filter/f-inst.c"
 /* Iteration for FI_EA_GET */
#line 903
case FI_EA_GET:
#line 903
#define whati (&(what->i_FI_EA_GET))
#line 903
#undef whati
#line 903
break;
#line 903

#line 944 "filter/f-inst.c"
 /* Iteration for FI_EA_SET */
#line 944
case FI_EA_SET:
#line 944
#define whati (&(what->i_FI_EA_SET))
#line 944
#undef whati
#line 944
break;
#line 944

#line 951 "filter/f-inst.c"
 /* Iteration for FI_EA_UNSET */
#line 951
case FI_EA_UNSET:
#line 951
#define whati (&(what->i_FI_EA_UNSET))
#line 951
#undef whati
#line 951
break;
#line 951

#line 965 "filter/f-inst.c"
 /* Iteration for FI_DEFAULT */
#line 965
case FI_DEFAULT:
#line 965
#define whati (&(what->i_FI_DEFAULT))
#line 965
#undef whati
#line 965
break;
#line 965

#line 966 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_NET__len */
#line 966
case FI_METHOD__T_NET__len:
#line 966
#define whati (&(what->i_FI_METHOD__T_NET__len))
#line 966
#undef whati
#line 966
break;
#line 966

#line 967 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PATH__len */
#line 967
case FI_METHOD__T_PATH__len:
#line 967
#define whati (&(what->i_FI_METHOD__T_PATH__len))
#line 967
#undef whati
#line 967
break;
#line 967

#line 968 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_CLIST__len */
#line 968
case FI_METHOD__T_CLIST__len:
#line 968
#define whati (&(what->i_FI_METHOD__T_CLIST__len))
#line 968
#undef whati
#line 968
break;
#line 968

#line 969 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_ECLIST__len */
#line 969
case FI_METHOD__T_ECLIST__len:
#line 969
#define whati (&(what->i_FI_METHOD__T_ECLIST__len))
#line 969
#undef whati
#line 969
break;
#line 969

#line 971 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LCLIST__len */
#line 971
case FI_METHOD__T_LCLIST__len:
#line 971
#define whati (&(what->i_FI_METHOD__T_LCLIST__len))
#line 971
#undef whati
#line 971
break;
#line 971

#line 1007 "filter/f-inst.c"
 /* Iteration for FI_NET_SRC */
#line 1007
case FI_NET_SRC:
#line 1007
#define whati (&(what->i_FI_NET_SRC))
#line 1007
#undef whati
#line 1007
break;
#line 1007

#line 1044 "filter/f-inst.c"
 /* Iteration for FI_NET_DST */
#line 1044
case FI_NET_DST:
#line 1044
#define whati (&(what->i_FI_NET_DST))
#line 1044
#undef whati
#line 1044
break;
#line 1044

#line 1054 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_NET__maxlen */
#line 1054
case FI_METHOD__T_NET__maxlen:
#line 1054
#define whati (&(what->i_FI_METHOD__T_NET__maxlen))
#line 1054
#undef whati
#line 1054
break;
#line 1054

#line 1064 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_NET__asn */
#line 1064
case FI_METHOD__T_NET__asn:
#line 1064
#define whati (&(what->i_FI_METHOD__T_NET__asn))
#line 1064
#undef whati
#line 1064
break;
#line 1064

#line 1066 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_NET__ip */
#line 1066
case FI_METHOD__T_NET__ip:
#line 1066
#define whati (&(what->i_FI_METHOD__T_NET__ip))
#line 1066
#undef whati
#line 1066
break;
#line 1066

#line 1075 "filter/f-inst.c"
 /* Iteration for FI_ROUTE_DISTINGUISHER */
#line 1075
case FI_ROUTE_DISTINGUISHER:
#line 1075
#define whati (&(what->i_FI_ROUTE_DISTINGUISHER))
#line 1075
#undef whati
#line 1075
break;
#line 1075

#line 1078 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PATH__first */
#line 1078
case FI_METHOD__T_PATH__first:
#line 1078
#define whati (&(what->i_FI_METHOD__T_PATH__first))
#line 1078
#undef whati
#line 1078
break;
#line 1078

#line 1081 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PATH__last */
#line 1081
case FI_METHOD__T_PATH__last:
#line 1081
#define whati (&(what->i_FI_METHOD__T_PATH__last))
#line 1081
#undef whati
#line 1081
break;
#line 1081

#line 1084 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PATH__last_nonaggregated */
#line 1084
case FI_METHOD__T_PATH__last_nonaggregated:
#line 1084
#define whati (&(what->i_FI_METHOD__T_PATH__last_nonaggregated))
#line 1084
#undef whati
#line 1084
break;
#line 1084

#line 1087 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PAIR__asn */
#line 1087
case FI_METHOD__T_PAIR__asn:
#line 1087
#define whati (&(what->i_FI_METHOD__T_PAIR__asn))
#line 1087
#undef whati
#line 1087
break;
#line 1087

#line 1090 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_PAIR__data */
#line 1090
case FI_METHOD__T_PAIR__data:
#line 1090
#define whati (&(what->i_FI_METHOD__T_PAIR__data))
#line 1090
#undef whati
#line 1090
break;
#line 1090

#line 1093 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LC__asn */
#line 1093
case FI_METHOD__T_LC__asn:
#line 1093
#define whati (&(what->i_FI_METHOD__T_LC__asn))
#line 1093
#undef whati
#line 1093
break;
#line 1093

#line 1096 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LC__data1 */
#line 1096
case FI_METHOD__T_LC__data1:
#line 1096
#define whati (&(what->i_FI_METHOD__T_LC__data1))
#line 1096
#undef whati
#line 1096
break;
#line 1096

#line 1099 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LC__data2 */
#line 1099
case FI_METHOD__T_LC__data2:
#line 1099
#define whati (&(what->i_FI_METHOD__T_LC__data2))
#line 1099
#undef whati
#line 1099
break;
#line 1099

#line 1102 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_CLIST__min */
#line 1102
case FI_METHOD__T_CLIST__min:
#line 1102
#define whati (&(what->i_FI_METHOD__T_CLIST__min))
#line 1102
#undef whati
#line 1102
break;
#line 1102

#line 1105 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_CLIST__max */
#line 1105
case FI_METHOD__T_CLIST__max:
#line 1105
#define whati (&(what->i_FI_METHOD__T_CLIST__max))
#line 1105
#undef whati
#line 1105
break;
#line 1105

#line 1108 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_ECLIST__min */
#line 1108
case FI_METHOD__T_ECLIST__min:
#line 1108
#define whati (&(what->i_FI_METHOD__T_ECLIST__min))
#line 1108
#undef whati
#line 1108
break;
#line 1108

#line 1111 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_ECLIST__max */
#line 1111
case FI_METHOD__T_ECLIST__max:
#line 1111
#define whati (&(what->i_FI_METHOD__T_ECLIST__max))
#line 1111
#undef whati
#line 1111
break;
#line 1111

#line 1114 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LCLIST__min */
#line 1114
case FI_METHOD__T_LCLIST__min:
#line 1114
#define whati (&(what->i_FI_METHOD__T_LCLIST__min))
#line 1114
#undef whati
#line 1114
break;
#line 1114

#line 1116 "filter/f-inst.c"
 /* Iteration for FI_METHOD__T_LCLIST__max */
#line 1116
case FI_METHOD__T_LCLIST__max:
#line 1116
#define whati (&(what->i_FI_METHOD__T_LCLIST__max))
#line 1116
#undef whati
#line 1116
break;
#line 1116

#line 1142 "filter/f-inst.c"
 /* Iteration for FI_RETURN */
#line 1142
case FI_RETURN:
#line 1142
#define whati (&(what->i_FI_RETURN))
#line 1142
#undef whati
#line 1142
break;
#line 1142

#line 1202 "filter/f-inst.c"
 /* Iteration for FI_CALL */
#line 1202
case FI_CALL:
#line 1202
#define whati (&(what->i_FI_CALL))

#line 1183 "filter/f-inst.c"
    if (!(what->flags & FIF_RECURSIVE))
      BUFFER_PUSH(fit->lines) = whati->sym->function;

    #line 1202 "filter/f-inst.c"
#undef whati
#line 1202
break;
#line 1202

#line 1207 "filter/f-inst.c"
 /* Iteration for FI_DROP_RESULT */
#line 1207
case FI_DROP_RESULT:
#line 1207
#define whati (&(what->i_FI_DROP_RESULT))
#line 1207
#undef whati
#line 1207
break;
#line 1207

#line 1248 "filter/f-inst.c"
 /* Iteration for FI_SWITCH */
#line 1248
case FI_SWITCH:
#line 1248
#define whati (&(what->i_FI_SWITCH))

#line 1231 "filter/f-inst.c"
    tree_walk(whati->tree, f_add_tree_lines, fit);

    #line 1248 "filter/f-inst.c"
#undef whati
#line 1248
break;
#line 1248

#line 1257 "filter/f-inst.c"
 /* Iteration for FI_IP_MASK */
#line 1257
case FI_IP_MASK:
#line 1257
#define whati (&(what->i_FI_IP_MASK))
#line 1257
#undef whati
#line 1257
break;
#line 1257

#line 1265 "filter/f-inst.c"
 /* Iteration for FI_PATH_PREPEND */
#line 1265
case FI_PATH_PREPEND:
#line 1265
#define whati (&(what->i_FI_PATH_PREPEND))
#line 1265
#undef whati
#line 1265
break;
#line 1265

#line 1272 "filter/f-inst.c"
 /* Iteration for FI_CLIST_ADD_PAIR */
#line 1272
case FI_CLIST_ADD_PAIR:
#line 1272
#define whati (&(what->i_FI_CLIST_ADD_PAIR))
#line 1272
#undef whati
#line 1272
break;
#line 1272

#line 1286 "filter/f-inst.c"
 /* Iteration for FI_CLIST_ADD_IP */
#line 1286
case FI_CLIST_ADD_IP:
#line 1286
#define whati (&(what->i_FI_CLIST_ADD_IP))
#line 1286
#undef whati
#line 1286
break;
#line 1286

#line 1293 "filter/f-inst.c"
 /* Iteration for FI_CLIST_ADD_QUAD */
#line 1293
case FI_CLIST_ADD_QUAD:
#line 1293
#define whati (&(what->i_FI_CLIST_ADD_QUAD))
#line 1293
#undef whati
#line 1293
break;
#line 1293

#line 1300 "filter/f-inst.c"
 /* Iteration for FI_CLIST_ADD_CLIST */
#line 1300
case FI_CLIST_ADD_CLIST:
#line 1300
#define whati (&(what->i_FI_CLIST_ADD_CLIST))
#line 1300
#undef whati
#line 1300
break;
#line 1300

#line 1307 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_ADD_EC */
#line 1307
case FI_ECLIST_ADD_EC:
#line 1307
#define whati (&(what->i_FI_ECLIST_ADD_EC))
#line 1307
#undef whati
#line 1307
break;
#line 1307

#line 1314 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_ADD_ECLIST */
#line 1314
case FI_ECLIST_ADD_ECLIST:
#line 1314
#define whati (&(what->i_FI_ECLIST_ADD_ECLIST))
#line 1314
#undef whati
#line 1314
break;
#line 1314

#line 1321 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_ADD_LC */
#line 1321
case FI_LCLIST_ADD_LC:
#line 1321
#define whati (&(what->i_FI_LCLIST_ADD_LC))
#line 1321
#undef whati
#line 1321
break;
#line 1321

#line 1328 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_ADD_LCLIST */
#line 1328
case FI_LCLIST_ADD_LCLIST:
#line 1328
#define whati (&(what->i_FI_LCLIST_ADD_LCLIST))
#line 1328
#undef whati
#line 1328
break;
#line 1328

#line 1335 "filter/f-inst.c"
 /* Iteration for FI_PATH_DELETE_INT */
#line 1335
case FI_PATH_DELETE_INT:
#line 1335
#define whati (&(what->i_FI_PATH_DELETE_INT))
#line 1335
#undef whati
#line 1335
break;
#line 1335

#line 1347 "filter/f-inst.c"
 /* Iteration for FI_PATH_DELETE_SET */
#line 1347
case FI_PATH_DELETE_SET:
#line 1347
#define whati (&(what->i_FI_PATH_DELETE_SET))
#line 1347
#undef whati
#line 1347
break;
#line 1347

#line 1354 "filter/f-inst.c"
 /* Iteration for FI_CLIST_DELETE_PAIR */
#line 1354
case FI_CLIST_DELETE_PAIR:
#line 1354
#define whati (&(what->i_FI_CLIST_DELETE_PAIR))
#line 1354
#undef whati
#line 1354
break;
#line 1354

#line 1368 "filter/f-inst.c"
 /* Iteration for FI_CLIST_DELETE_IP */
#line 1368
case FI_CLIST_DELETE_IP:
#line 1368
#define whati (&(what->i_FI_CLIST_DELETE_IP))
#line 1368
#undef whati
#line 1368
break;
#line 1368

#line 1375 "filter/f-inst.c"
 /* Iteration for FI_CLIST_DELETE_QUAD */
#line 1375
case FI_CLIST_DELETE_QUAD:
#line 1375
#define whati (&(what->i_FI_CLIST_DELETE_QUAD))
#line 1375
#undef whati
#line 1375
break;
#line 1375

#line 1382 "filter/f-inst.c"
 /* Iteration for FI_CLIST_DELETE_CLIST */
#line 1382
case FI_CLIST_DELETE_CLIST:
#line 1382
#define whati (&(what->i_FI_CLIST_DELETE_CLIST))
#line 1382
#undef whati
#line 1382
break;
#line 1382

#line 1393 "filter/f-inst.c"
 /* Iteration for FI_CLIST_DELETE_SET */
#line 1393
case FI_CLIST_DELETE_SET:
#line 1393
#define whati (&(what->i_FI_CLIST_DELETE_SET))
#line 1393
#undef whati
#line 1393
break;
#line 1393

#line 1400 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_DELETE_EC */
#line 1400
case FI_ECLIST_DELETE_EC:
#line 1400
#define whati (&(what->i_FI_ECLIST_DELETE_EC))
#line 1400
#undef whati
#line 1400
break;
#line 1400

#line 1407 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_DELETE_ECLIST */
#line 1407
case FI_ECLIST_DELETE_ECLIST:
#line 1407
#define whati (&(what->i_FI_ECLIST_DELETE_ECLIST))
#line 1407
#undef whati
#line 1407
break;
#line 1407

#line 1418 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_DELETE_SET */
#line 1418
case FI_ECLIST_DELETE_SET:
#line 1418
#define whati (&(what->i_FI_ECLIST_DELETE_SET))
#line 1418
#undef whati
#line 1418
break;
#line 1418

#line 1425 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_DELETE_LC */
#line 1425
case FI_LCLIST_DELETE_LC:
#line 1425
#define whati (&(what->i_FI_LCLIST_DELETE_LC))
#line 1425
#undef whati
#line 1425
break;
#line 1425

#line 1432 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_DELETE_LCLIST */
#line 1432
case FI_LCLIST_DELETE_LCLIST:
#line 1432
#define whati (&(what->i_FI_LCLIST_DELETE_LCLIST))
#line 1432
#undef whati
#line 1432
break;
#line 1432

#line 1443 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_DELETE_SET */
#line 1443
case FI_LCLIST_DELETE_SET:
#line 1443
#define whati (&(what->i_FI_LCLIST_DELETE_SET))
#line 1443
#undef whati
#line 1443
break;
#line 1443

#line 1454 "filter/f-inst.c"
 /* Iteration for FI_PATH_FILTER_SET */
#line 1454
case FI_PATH_FILTER_SET:
#line 1454
#define whati (&(what->i_FI_PATH_FILTER_SET))
#line 1454
#undef whati
#line 1454
break;
#line 1454

#line 1461 "filter/f-inst.c"
 /* Iteration for FI_CLIST_FILTER_CLIST */
#line 1461
case FI_CLIST_FILTER_CLIST:
#line 1461
#define whati (&(what->i_FI_CLIST_FILTER_CLIST))
#line 1461
#undef whati
#line 1461
break;
#line 1461

#line 1472 "filter/f-inst.c"
 /* Iteration for FI_CLIST_FILTER_SET */
#line 1472
case FI_CLIST_FILTER_SET:
#line 1472
#define whati (&(what->i_FI_CLIST_FILTER_SET))
#line 1472
#undef whati
#line 1472
break;
#line 1472

#line 1479 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_FILTER_ECLIST */
#line 1479
case FI_ECLIST_FILTER_ECLIST:
#line 1479
#define whati (&(what->i_FI_ECLIST_FILTER_ECLIST))
#line 1479
#undef whati
#line 1479
break;
#line 1479

#line 1490 "filter/f-inst.c"
 /* Iteration for FI_ECLIST_FILTER_SET */
#line 1490
case FI_ECLIST_FILTER_SET:
#line 1490
#define whati (&(what->i_FI_ECLIST_FILTER_SET))
#line 1490
#undef whati
#line 1490
break;
#line 1490

#line 1497 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_FILTER_LCLIST */
#line 1497
case FI_LCLIST_FILTER_LCLIST:
#line 1497
#define whati (&(what->i_FI_LCLIST_FILTER_LCLIST))
#line 1497
#undef whati
#line 1497
break;
#line 1497

#line 1508 "filter/f-inst.c"
 /* Iteration for FI_LCLIST_FILTER_SET */
#line 1508
case FI_LCLIST_FILTER_SET:
#line 1508
#define whati (&(what->i_FI_LCLIST_FILTER_SET))
#line 1508
#undef whati
#line 1508
break;
#line 1508

#line 1530 "filter/f-inst.c"
 /* Iteration for FI_ROA_CHECK */
#line 1530
case FI_ROA_CHECK:
#line 1530
#define whati (&(what->i_FI_ROA_CHECK))
#line 1530
#undef whati
#line 1530
break;
#line 1530

#line 1546 "filter/f-inst.c"
 /* Iteration for FI_ASPA_CHECK_EXPLICIT */
#line 1546
case FI_ASPA_CHECK_EXPLICIT:
#line 1546
#define whati (&(what->i_FI_ASPA_CHECK_EXPLICIT))
#line 1546
#undef whati
#line 1546
break;
#line 1546

#line 1561 "filter/f-inst.c"
 /* Iteration for FI_FROM_HEX */
#line 1561
case FI_FROM_HEX:
#line 1561
#define whati (&(what->i_FI_FROM_HEX))
#line 1561
#undef whati
#line 1561
break;
#line 1561

#line 1566 "filter/f-inst.c"
 /* Iteration for FI_FORMAT */
#line 1566
case FI_FORMAT:
#line 1566
#define whati (&(what->i_FI_FORMAT))
#line 1566
#undef whati
#line 1566
break;
#line 1566

#line 830 "filter/decl.m4"
 /* Iteration for FI_ASSERT */
#line 830
case FI_ASSERT:
#line 830
#define whati (&(what->i_FI_ASSERT))
#line 830
#undef whati
#line 830
break;
#line 830

#line 775 "filter/decl.m4"

  }
}


#if defined(__GNUC__) && __GNUC__ >= 6
#pragma GCC diagnostic pop
#endif

