﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/appstream/model/ImageStateChangeReason.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace AppStream {
namespace Model {

ImageStateChangeReason::ImageStateChangeReason(JsonView jsonValue) { *this = jsonValue; }

ImageStateChangeReason& ImageStateChangeReason::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("Code")) {
    m_code = ImageStateChangeReasonCodeMapper::GetImageStateChangeReasonCodeForName(jsonValue.GetString("Code"));
    m_codeHasBeenSet = true;
  }
  if (jsonValue.ValueExists("Message")) {
    m_message = jsonValue.GetString("Message");
    m_messageHasBeenSet = true;
  }
  return *this;
}

JsonValue ImageStateChangeReason::Jsonize() const {
  JsonValue payload;

  if (m_codeHasBeenSet) {
    payload.WithString("Code", ImageStateChangeReasonCodeMapper::GetNameForImageStateChangeReasonCode(m_code));
  }

  if (m_messageHasBeenSet) {
    payload.WithString("Message", m_message);
  }

  return payload;
}

}  // namespace Model
}  // namespace AppStream
}  // namespace Aws
