﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/application-signals/model/ListServiceLevelObjectivesResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::ApplicationSignals::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListServiceLevelObjectivesResult::ListServiceLevelObjectivesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListServiceLevelObjectivesResult& ListServiceLevelObjectivesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("SloSummaries")) {
    Aws::Utils::Array<JsonView> sloSummariesJsonList = jsonValue.GetArray("SloSummaries");
    for (unsigned sloSummariesIndex = 0; sloSummariesIndex < sloSummariesJsonList.GetLength(); ++sloSummariesIndex) {
      m_sloSummaries.push_back(sloSummariesJsonList[sloSummariesIndex].AsObject());
    }
    m_sloSummariesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
