﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/accessanalyzer/AccessAnalyzer_EXPORTS.h>
#include <aws/accessanalyzer/model/ResourceType.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace AccessAnalyzer {
namespace Model {

/**
 * <p>Contains the ARN of the analyzed resource.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/accessanalyzer-2019-11-01/AnalyzedResourceSummary">AWS
 * API Reference</a></p>
 */
class AnalyzedResourceSummary {
 public:
  AWS_ACCESSANALYZER_API AnalyzedResourceSummary() = default;
  AWS_ACCESSANALYZER_API AnalyzedResourceSummary(Aws::Utils::Json::JsonView jsonValue);
  AWS_ACCESSANALYZER_API AnalyzedResourceSummary& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_ACCESSANALYZER_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The ARN of the analyzed resource.</p>
   */
  inline const Aws::String& GetResourceArn() const { return m_resourceArn; }
  inline bool ResourceArnHasBeenSet() const { return m_resourceArnHasBeenSet; }
  template <typename ResourceArnT = Aws::String>
  void SetResourceArn(ResourceArnT&& value) {
    m_resourceArnHasBeenSet = true;
    m_resourceArn = std::forward<ResourceArnT>(value);
  }
  template <typename ResourceArnT = Aws::String>
  AnalyzedResourceSummary& WithResourceArn(ResourceArnT&& value) {
    SetResourceArn(std::forward<ResourceArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Web Services account ID that owns the resource.</p>
   */
  inline const Aws::String& GetResourceOwnerAccount() const { return m_resourceOwnerAccount; }
  inline bool ResourceOwnerAccountHasBeenSet() const { return m_resourceOwnerAccountHasBeenSet; }
  template <typename ResourceOwnerAccountT = Aws::String>
  void SetResourceOwnerAccount(ResourceOwnerAccountT&& value) {
    m_resourceOwnerAccountHasBeenSet = true;
    m_resourceOwnerAccount = std::forward<ResourceOwnerAccountT>(value);
  }
  template <typename ResourceOwnerAccountT = Aws::String>
  AnalyzedResourceSummary& WithResourceOwnerAccount(ResourceOwnerAccountT&& value) {
    SetResourceOwnerAccount(std::forward<ResourceOwnerAccountT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of resource that was analyzed.</p>
   */
  inline ResourceType GetResourceType() const { return m_resourceType; }
  inline bool ResourceTypeHasBeenSet() const { return m_resourceTypeHasBeenSet; }
  inline void SetResourceType(ResourceType value) {
    m_resourceTypeHasBeenSet = true;
    m_resourceType = value;
  }
  inline AnalyzedResourceSummary& WithResourceType(ResourceType value) {
    SetResourceType(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_resourceArn;

  Aws::String m_resourceOwnerAccount;

  ResourceType m_resourceType{ResourceType::NOT_SET};
  bool m_resourceArnHasBeenSet = false;
  bool m_resourceOwnerAccountHasBeenSet = false;
  bool m_resourceTypeHasBeenSet = false;
};

}  // namespace Model
}  // namespace AccessAnalyzer
}  // namespace Aws
