/* do not edit automatically generated by mc from M2Quads.  */
/* M2Quads.def generates quadruples.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2Quads_H)
#   define _M2Quads_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GSYSTEM.h"
#   include "GDynamicStrings.h"

#   if defined (_M2Quads_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

typedef enum {M2Quads_AddOp, M2Quads_AddrOp, M2Quads_ArithAddOp, M2Quads_ArrayOp, M2Quads_BecomesOp, M2Quads_BuiltinConstOp, M2Quads_BuiltinTypeInfoOp, M2Quads_CallOp, M2Quads_CastOp, M2Quads_CatchBeginOp, M2Quads_CatchEndOp, M2Quads_CodeOffOp, M2Quads_CodeOnOp, M2Quads_CoerceOp, M2Quads_ConvertOp, M2Quads_DivCeilOp, M2Quads_DivFloorOp, M2Quads_DivM2Op, M2Quads_DivTruncOp, M2Quads_DummyOp, M2Quads_ElementSizeOp, M2Quads_EndFileOp, M2Quads_ErrorOp, M2Quads_ExclOp, M2Quads_FinallyEndOp, M2Quads_FinallyStartOp, M2Quads_FunctValueOp, M2Quads_GotoOp, M2Quads_HighOp, M2Quads_IfEquOp, M2Quads_IfGreEquOp, M2Quads_IfGreOp, M2Quads_IfInOp, M2Quads_IfLessEquOp, M2Quads_IfLessOp, M2Quads_IfNotEquOp, M2Quads_IfNotInOp, M2Quads_InclOp, M2Quads_IndrXOp, M2Quads_InitAddressOp, M2Quads_InitEndOp, M2Quads_InitStartOp, M2Quads_InlineOp, M2Quads_KillLocalVarOp, M2Quads_LastForIteratorOp, M2Quads_LineNumberOp, M2Quads_LogicalAndOp, M2Quads_LogicalDiffOp, M2Quads_LogicalOrOp, M2Quads_LogicalRotateOp, M2Quads_LogicalShiftOp, M2Quads_LogicalXorOp, M2Quads_ModCeilOp, M2Quads_ModFloorOp, M2Quads_ModM2Op, M2Quads_ModTruncOp, M2Quads_ModuleScopeOp, M2Quads_MultOp, M2Quads_NegateOp, M2Quads_NewLocalVarOp, M2Quads_OptimizeOffOp, M2Quads_OptimizeOnOp, M2Quads_OptParamOp, M2Quads_ParamOp, M2Quads_ProcedureScopeOp, M2Quads_ProfileOffOp, M2Quads_ProfileOnOp, M2Quads_RangeCheckOp, M2Quads_RecordFieldOp, M2Quads_RestoreExceptionOp, M2Quads_RestorePriorityOp, M2Quads_RetryOp, M2Quads_ReturnOp, M2Quads_ReturnValueOp, M2Quads_SaveExceptionOp, M2Quads_SavePriorityOp, M2Quads_SizeOp, M2Quads_StandardFunctionOp, M2Quads_StartDefFileOp, M2Quads_StartModFileOp, M2Quads_StatementNoteOp, M2Quads_SubOp, M2Quads_SubrangeHighOp, M2Quads_SubrangeLowOp, M2Quads_StringConvertCnulOp, M2Quads_StringConvertM2nulOp, M2Quads_StringLengthOp, M2Quads_ThrowOp, M2Quads_TryOp, M2Quads_UnboundedOp, M2Quads_XIndrOp} M2Quads_QuadOperator;


/*
   SetOptionCoding - builds a code quadruple if the profiling
                     option was given to the compiler.
*/

EXTERN void M2Quads_SetOptionCoding (bool b);

/*
   SetOptionProfiling - builds a profile quadruple if the profiling
                        option was given to the compiler.
*/

EXTERN void M2Quads_SetOptionProfiling (bool b);

/*
   SetOptionOptimizing - builds a code quadruple if the profiling
                         option was given to the compiler.
*/

EXTERN void M2Quads_SetOptionOptimizing (bool b);

/*
   Opposite - returns the opposite comparison operator.
*/

EXTERN M2Quads_QuadOperator M2Quads_Opposite (M2Quads_QuadOperator Operator);

/*
   IsReferenced - returns true if QuadNo is referenced by another quadruple.
*/

EXTERN bool M2Quads_IsReferenced (unsigned int QuadNo);

/*
   IsBackReference - returns TRUE if quadruple, q, is referenced from a quad further on.
*/

EXTERN bool M2Quads_IsBackReference (unsigned int q);

/*
   IsUnConditional - returns true if QuadNo is an unconditional jump.
*/

EXTERN bool M2Quads_IsUnConditional (unsigned int QuadNo);

/*
   IsConditional - returns true if QuadNo is a conditional jump.
*/

EXTERN bool M2Quads_IsConditional (unsigned int QuadNo);

/*
   IsBackReferenceConditional - returns TRUE if quadruple, q, is referenced from
                                a conditional quad further on.
*/

EXTERN bool M2Quads_IsBackReferenceConditional (unsigned int q);

/*
   IsGoto - returns true if QuadNo is a goto operation.
*/

EXTERN bool M2Quads_IsGoto (unsigned int QuadNo);

/*
   IsCall - returns true if QuadNo is a call operation.
*/

EXTERN bool M2Quads_IsCall (unsigned int QuadNo);

/*
   IsReturn - returns true if QuadNo is a return operation.
*/

EXTERN bool M2Quads_IsReturn (unsigned int QuadNo);

/*
   IsProcedureScope - returns true if QuadNo is a ProcedureScope operation.
*/

EXTERN bool M2Quads_IsProcedureScope (unsigned int QuadNo);

/*
   IsNewLocalVar - returns true if QuadNo is a NewLocalVar operation.
*/

EXTERN bool M2Quads_IsNewLocalVar (unsigned int QuadNo);

/*
   IsKillLocalVar - returns true if QuadNo is a KillLocalVar operation.
*/

EXTERN bool M2Quads_IsKillLocalVar (unsigned int QuadNo);

/*
   IsCatchBegin - returns true if QuadNo is a catch begin quad.
*/

EXTERN bool M2Quads_IsCatchBegin (unsigned int QuadNo);

/*
   IsCatchEnd - returns true if QuadNo is a catch end quad.
*/

EXTERN bool M2Quads_IsCatchEnd (unsigned int QuadNo);

/*
   IsInitStart - returns true if QuadNo is a init start quad.
*/

EXTERN bool M2Quads_IsInitStart (unsigned int QuadNo);

/*
   IsInitEnd - returns true if QuadNo is a init end quad.
*/

EXTERN bool M2Quads_IsInitEnd (unsigned int QuadNo);

/*
   IsFinallyStart - returns true if QuadNo is a finally start quad.
*/

EXTERN bool M2Quads_IsFinallyStart (unsigned int QuadNo);

/*
   IsFinallyEnd - returns true if QuadNo is a finally end quad.
*/

EXTERN bool M2Quads_IsFinallyEnd (unsigned int QuadNo);

/*
   IsBecomes - return TRUE if QuadNo is a BecomesOp.
*/

EXTERN bool M2Quads_IsBecomes (unsigned int QuadNo);

/*
   IsDummy - return TRUE if QuadNo is a DummyOp.
*/

EXTERN bool M2Quads_IsDummy (unsigned int QuadNo);

/*
   IsQuadConstExpr - returns TRUE if QuadNo is part of a constant expression.
*/

EXTERN bool M2Quads_IsQuadConstExpr (unsigned int QuadNo);

/*
   SetQuadConstExpr - sets the constexpr field to value.
*/

EXTERN void M2Quads_SetQuadConstExpr (unsigned int QuadNo, bool value);

/*
   GetQuadDest - returns the jump destination associated with quad.
*/

EXTERN unsigned int M2Quads_GetQuadDest (unsigned int QuadNo);

/*
   GetQuadOp1 - returns the 1st operand associated with quad.
*/

EXTERN unsigned int M2Quads_GetQuadOp1 (unsigned int QuadNo);

/*
   GetQuadOp2 - returns the 2nd operand associated with quad.
*/

EXTERN unsigned int M2Quads_GetQuadOp2 (unsigned int QuadNo);

/*
   GetQuadOp3 - returns the 3rd operand associated with quad.
*/

EXTERN unsigned int M2Quads_GetQuadOp3 (unsigned int QuadNo);

/*
   IsInitialisingConst - returns TRUE if the quadruple is setting
                         a const (op1) with a value.
*/

EXTERN bool M2Quads_IsInitialisingConst (unsigned int QuadNo);

/*
   IsConstQuad - return TRUE if the quadruple is marked as a constexpr.
*/

EXTERN bool M2Quads_IsConstQuad (unsigned int quad);

/*
   IsConditionalBooleanQuad - return TRUE if operand 1 is a boolean result.
*/

EXTERN bool M2Quads_IsConditionalBooleanQuad (unsigned int quad);

/*
   IsOptimizeOn - returns true if the Optimize flag was true at QuadNo.
*/

EXTERN bool M2Quads_IsOptimizeOn (unsigned int QuadNo);

/*
   IsProfileOn - returns true if the Profile flag was true at QuadNo.
*/

EXTERN bool M2Quads_IsProfileOn (unsigned int QuadNo);

/*
   IsCodeOn - returns true if the Code flag was true at QuadNo.
*/

EXTERN bool M2Quads_IsCodeOn (unsigned int QuadNo);

/*
   IsPseudoQuad - returns true if QuadNo is a compiler directive.
                  ie code, profile and optimize.
*/

EXTERN bool M2Quads_IsPseudoQuad (unsigned int QuadNo);

/*
   IsDefOrModFile - returns TRUE if QuadNo is a start of Module or Def file
                    directive.
*/

EXTERN bool M2Quads_IsDefOrModFile (unsigned int QuadNo);

/*
   DumpQuadruples - dump all quadruples providing the -fq, -fdump-lang-quad,
                    -fdump-lang-quad= or -fdump-lang-all were issued to the
                    command line.
*/

EXTERN void M2Quads_DumpQuadruples (const char *title_, unsigned int _title_high);

/*
   DisplayQuadRange - displays all quads in list range, start..end.
*/

EXTERN void M2Quads_DisplayQuadRange (unsigned int scope, unsigned int start, unsigned int end);

/*
   DisplayQuad - displays a quadruple, QuadNo.
*/

EXTERN void M2Quads_DisplayQuad (unsigned int QuadNo);

/*
   GetLastFileQuad - returns the Quadruple number of the last StartDefFile or
                     StartModFile quadruple.
*/

EXTERN unsigned int M2Quads_GetLastFileQuad (unsigned int QuadNo);

/*
   GetLastQuadNo - returns the last quadruple number referenced
                   by a GetQuad.
*/

EXTERN unsigned int M2Quads_GetLastQuadNo (void);

/*
   QuadToTokenNo - Converts a QuadNo into the approprate token number of the
                   source file, the line number is returned.

                   This may be used to yield an idea where abouts in the
                   source file the code generetion is
                   processing.
*/

EXTERN unsigned int M2Quads_QuadToTokenNo (unsigned int QuadNo);

/*
   QuadToLineNo - Converts a QuadNo into the approprate line number of the
                  source file, the line number is returned.

                  This may be used to yield an idea where abouts in the
                  source file the code generetion is
                  processing.
*/

EXTERN unsigned int M2Quads_QuadToLineNo (unsigned int QuadNo);

/*
   GetQuad - returns the Quadruple QuadNo.
*/

EXTERN void M2Quads_GetQuad (unsigned int QuadNo, M2Quads_QuadOperator *Op, unsigned int *Oper1, unsigned int *Oper2, unsigned int *Oper3);

/*
   GetQuadOp - returns the operator for quad.
*/

EXTERN M2Quads_QuadOperator M2Quads_GetQuadOp (unsigned int quad);

/*
   GetM2OperatorDesc - returns the Modula-2 string associated with the quad operator
                       (if possible).  It returns NIL if no there is not an obvious match
                       in Modula-2.  It is assummed that the string will be used during
                       construction of error messages and therefore keywords are
                       wrapped with a format specifier.
*/

EXTERN DynamicStrings_String M2Quads_GetM2OperatorDesc (M2Quads_QuadOperator op);

/*
   GetQuadtok - returns the Quadruple QuadNo.
*/

EXTERN void M2Quads_GetQuadtok (unsigned int QuadNo, M2Quads_QuadOperator *Op, unsigned int *Oper1, unsigned int *Oper2, unsigned int *Oper3, unsigned int *Op1Pos, unsigned int *Op2Pos, unsigned int *Op3Pos);

/*
   GetQuadOtok - returns the Quadruple QuadNo.
*/

EXTERN void M2Quads_GetQuadOtok (unsigned int QuadNo, unsigned int *tok, M2Quads_QuadOperator *Op, unsigned int *Oper1, unsigned int *Oper2, unsigned int *Oper3, bool *overflowChecking, bool *constExpr, unsigned int *Op1Pos, unsigned int *Op2Pos, unsigned int *Op3Pos);

/*
   GetQuadOTypetok - returns the fields associated with quadruple QuadNo.
*/

EXTERN void M2Quads_GetQuadOTypetok (unsigned int QuadNo, unsigned int *tok, M2Quads_QuadOperator *Op, unsigned int *Oper1, unsigned int *Oper2, unsigned int *Oper3, bool *overflowChecking, bool *typeChecking, bool *constExpr, unsigned int *Op1Pos, unsigned int *Op2Pos, unsigned int *Op3Pos);

/*
   PutQuadOtok - alters a quadruple QuadNo with Op, Oper1, Oper2, Oper3, and
                 sets a boolean to determinine whether overflow should be checked.
*/

EXTERN void M2Quads_PutQuadOtok (unsigned int QuadNo, unsigned int tok, M2Quads_QuadOperator Op, unsigned int Oper1, unsigned int Oper2, unsigned int Oper3, bool overflowChecking, bool constExpr, unsigned int Op1Pos, unsigned int Op2Pos, unsigned int Op3Pos);

/*
   PutQuad - overwrites a quadruple QuadNo with Op, Oper1, Oper2, Oper3
*/

EXTERN void M2Quads_PutQuad (unsigned int QuadNo, M2Quads_QuadOperator Op, unsigned int Oper1, unsigned int Oper2, unsigned int Oper3);

/*
   GetFirstQuad - returns the first quadruple.
*/

EXTERN unsigned int M2Quads_GetFirstQuad (void);

/*
   GetNextQuad - returns the Quadruple number following QuadNo.
*/

EXTERN unsigned int M2Quads_GetNextQuad (unsigned int QuadNo);

/*
   GetRealQuad - returns the Quadruple number of the real quadruple
                 at QuadNo or beyond.
*/

EXTERN unsigned int M2Quads_GetRealQuad (unsigned int QuadNo);

/*
   SubQuad - removes quadruple QuadNo.
*/

EXTERN void M2Quads_SubQuad (unsigned int QuadNo);

/*
   EraseQuad - erases a quadruple QuadNo, the quaduple is still in the list
               but wiped clean.
*/

EXTERN void M2Quads_EraseQuad (unsigned int QuadNo);

/*
   CountQuads - returns the number of quadruples.
*/

EXTERN unsigned int M2Quads_CountQuads (void);

/*
   BuildScaffold - generate the main, init, finish functions if
                   no -c and this is the application module.
*/

EXTERN void M2Quads_BuildScaffold (unsigned int tok, unsigned int moduleSym);

/*
   StartBuildDefFile - generates a StartFileOp quadruple indicating the file
                       that has produced the subsequent quadruples.
                       The code generator uses the StartDefFileOp quadruples
                       to relate any error to the appropriate file.


                       Entry                   Exit
                       =====                   ====


                Ptr ->                                        <- Ptr
                       +------------+          +------------+
                       | ModuleName |          | ModuleName |
                       |------------|          |------------|


                       Quadruples Produced

                       q     StartDefFileOp  _  _  ModuleSym
*/

EXTERN void M2Quads_StartBuildDefFile (unsigned int tok);

/*
   StartBuildModFile - generates a StartModFileOp quadruple indicating the file
                       that has produced the subsequent quadruples.
                       The code generator uses the StartModFileOp quadruples
                       to relate any error to the appropriate file.


                       Entry                   Exit
                       =====                   ====


                Ptr ->                                        <- Ptr
                       +------------+          +------------+
                       | ModuleName |          | ModuleName |
                       |------------|          |------------|


                       Quadruples Produced

                       q     StartModFileOp  _  _  ModuleSym
*/

EXTERN void M2Quads_StartBuildModFile (unsigned int tok);

/*
   EndBuildFile - generates an EndFileOp quadruple indicating the file
                  that has produced the previous quadruples has ended.

                  Entry                   Exit
                  =====                   ====


           Ptr ->                                        <- Ptr
                  +------------+          +------------+
                  | ModuleName |          | ModuleName |
                  |------------|          |------------|


                  Quadruples Produced

                  q     EndFileOp  _  _  ModuleSym
*/

EXTERN void M2Quads_EndBuildFile (unsigned int tok);

/*
   StartBuildInit - Builds the start initialisation code of a module.
*/

EXTERN void M2Quads_StartBuildInit (unsigned int tok);

/*
   EndBuildInit - Builds the end initialisation code of a module.
*/

EXTERN void M2Quads_EndBuildInit (unsigned int tok);

/*
   StartBuildFinally - Builds the start finalisation code of a module.
*/

EXTERN void M2Quads_StartBuildFinally (unsigned int tok);

/*
   EndBuildFinally - Builds the end finalisation code of a module.
*/

EXTERN void M2Quads_EndBuildFinally (unsigned int tok);

/*
   BuildExceptInitial - adds an ExceptOp quadruple in a modules
                        initial block.
*/

EXTERN void M2Quads_BuildExceptInitial (unsigned int tok);

/*
   BuildExceptFinally - adds an ExceptOp quadruple in a modules
                        finally block.
*/

EXTERN void M2Quads_BuildExceptFinally (unsigned int tok);

/*
   BuildExceptProcedure - adds an ExceptOp quadruple in a procedure
                          block.
*/

EXTERN void M2Quads_BuildExceptProcedure (unsigned int tok);

/*
   BuildRetry - adds an RetryOp quadruple.
*/

EXTERN void M2Quads_BuildRetry (unsigned int tok);

/*
   BuildReThrow - creates a ThrowOp _ _ NulSym, indicating that
                  the exception needs to be rethrown.  The stack
                  is unaltered.
*/

EXTERN void M2Quads_BuildReThrow (unsigned int tokenno);

/*
   StartBuildInnerInit - Sets the start of initialization code of the
                         inner module to the next quadruple.
*/

EXTERN void M2Quads_StartBuildInnerInit (unsigned int tok);

/*
   EndBuildInnerInit - Sets the end initialization code of a module.
*/

EXTERN void M2Quads_EndBuildInnerInit (unsigned int tok);

/*
   BuildBuiltinConst - makes reference to a builtin constant within gm2.

                              Entry                 Exit

                       Ptr ->
                              +------------+        +------------+
                              | Ident      |        | Sym        |
                              |------------|        |------------|

                       Quadruple produced:

                       q    Sym  BuiltinConstOp  Ident
*/

EXTERN void M2Quads_BuildBuiltinConst (void);

/*
   BuildBuiltinTypeInfo - make reference to a builtin typeinfo function
                          within gm2.

                                 Entry                 Exit

                          Ptr ->
                                 +-------------+
                                 | IdentType   |
                                 |-------------|       +------------+
                                 | ConstString |       | Sym        |
                                 |-------------|       |------------|

                          Quadruple produced:

                          q    Sym  BuiltinTypeInfoOp  Ident ConstString
*/

EXTERN void M2Quads_BuildBuiltinTypeInfo (void);

/*
   BuildAssignment - Builds an assignment from the values given on the
                     quad stack. Either an assignment to an
                     arithmetic expression or an assignment to a
                     boolean expression.  This procedure should not
                     be called in CONST declarations.
                     The Stack is expected to contain:


       Either

                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | Expression |
                     |------------|
                     | Designator |
                     |------------|          +------------+
                     |            |          |            |  <- Ptr
                     |------------|          |------------|


                     Quadruples Produced

                     q     BecomesOp  Designator  _  Expression

       OR

                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | True |False|
                     |------------|
                     | Designator |
                     |------------|          +------------+
                     |            |          |            |  <- Ptr
                     |------------|          |------------|


                     Quadruples Produced

                     q     BecomesOp  Designator  _  TRUE
                     q+1   GotoOp                    q+3
                     q+2   BecomesOp  Designator  _  FALSE

*/

EXTERN void M2Quads_BuildAssignment (unsigned int becomesTokNo);

/*
   BuildAssignConstant - used to create constant in the CONST declaration.
                         The stack is expected to contain:

       Either

                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | Expression |
                     |------------|
                     | Designator |
                     |------------|          +------------+
                     |            |          |            |  <- Ptr
                     |------------|          |------------|


                     Quadruples Produced

                     q     BecomesOp  Designator  _  Expression

       OR

                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | True |False|
                     |------------|
                     | Designator |
                     |------------|          +------------+
                     |            |          |            |  <- Ptr
                     |------------|          |------------|


                     Quadruples Produced

                     q     BecomesOp  Designator  _  TRUE
                     q+1   GotoOp                    q+3
                     q+2   BecomesOp  Designator  _  FALSE
*/

EXTERN void M2Quads_BuildAssignConstant (unsigned int equalsTokNo);

/*
   BuildAlignment - builds an assignment to an alignment constant.

                    The Stack is expected to contain:


                            Entry                   Exit
                            =====                   ====

                    Ptr ->
                            +---------------+
                            | Expression    |
                            |---------------|
                            | bytealignment |
                            |---------------|       empty
*/

EXTERN void M2Quads_BuildAlignment (unsigned int tokno);

/*
   BuildBitLength - builds an assignment to a bit length constant.

                    The Stack is expected to contain:


                           Entry                   Exit
                           =====                   ====

                    Ptr ->
                           +------------+
                           | Expression |
                           |------------|          empty
*/

EXTERN void M2Quads_BuildBitLength (unsigned int tokno);

/*
   BuildPragmaField - builds an assignment to a pragma constant.

                      The Stack is expected to contain:


                                 Entry                   Exit
                                 =====                   ====

                         Ptr ->
                                +------------+
                                | Expression |
                                |------------|          empty
*/

EXTERN void M2Quads_BuildPragmaField (void);

/*
   BuildDefaultFieldAlignment - builds an assignment to an alignment constant.

                                The Stack is expected to contain:


                                       Entry                   Exit
                                       =====                   ====

                                Ptr ->
                                       +------------+
                                       | Expression |
                                       |------------|          empty
*/

EXTERN void M2Quads_BuildDefaultFieldAlignment (void);

/*
   BuildRepeat - Builds the repeat statement from the quad stack.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====


                 Empty
                                                        <- Ptr
                                         +------------+
                                         | RepeatQuad |
                                         |------------|

*/

EXTERN void M2Quads_BuildRepeat (void);

/*
   BuildUntil - Builds the until part of the repeat statement
                from the quad stack.
                The Stack is expected to contain:


                Entry                   Exit
                =====                   ====

        Ptr ->
                +------------+
                | t   | f    |
                |------------|
                | RepeatQuad |          Empty
                |------------|
*/

EXTERN void M2Quads_BuildUntil (void);

/*
   BuildWhile - Builds the While part of the While statement
                from the quad stack.
                The Stack is expected to contain:


                Entry                   Exit
                =====                   ====

                                                       <- Ptr
                                        |------------|
                Empty                   | WhileQuad  |
                                        |------------|
*/

EXTERN void M2Quads_BuildWhile (void);

/*
   BuildDoWhile - Builds the Do part of the while statement
                  from the quad stack.
                  The Stack is expected to contain:


                  Entry                   Exit
                  =====                   ====

          Ptr ->
                  +------------+          +------------+
                  | t   | f    |          | 0    | f   |
                  |------------|          |------------|
                  | WhileQuad  |          | WhileQuad  |
                  |------------|          |------------|

                  Quadruples

                  BackPatch t exit to the NextQuad
*/

EXTERN void M2Quads_BuildDoWhile (void);

/*
   BuildEndWhile - Builds the end part of the while statement
                   from the quad stack.
                   The Stack is expected to contain:


                   Entry                   Exit
                   =====                   ====

           Ptr ->
                   +------------+
                   | t   | f    |
                   |------------|
                   | WhileQuad  |          Empty
                   |------------|

                   Quadruples

                   q    GotoOp  WhileQuad
                   False exit is backpatched with q+1
*/

EXTERN void M2Quads_BuildEndWhile (int reltokpos);

/*
   BuildLoop - Builds the Loop part of the Loop statement
               from the quad stack.
               The Stack is expected to contain:


               Entry                   Exit
               =====                   ====

                                                      <- Ptr
               Empty                   +------------+
                                       | LoopQuad   |
                                       |------------|
*/

EXTERN void M2Quads_BuildLoop (void);

/*
   BuildExit - Builds the Exit part of the Loop statement.
*/

EXTERN void M2Quads_BuildExit (void);

/*
   BuildEndLoop - Builds the End part of the Loop statement
                  from the quad stack.
                  The Stack is expected to contain:


                  Entry                   Exit
                  =====                   ====

          Ptr ->
                  +------------+
                  | LoopQuad   |          Empty
                  |------------|

                  Quadruples

                  Goto  _  _  LoopQuad
*/

EXTERN void M2Quads_BuildEndLoop (void);

/*
   BuildThenIf - Builds the Then part of the If statement
                 from the quad stack.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====

         Ptr ->                                          <- Ptr
                 +------------+          +------------+
                 | t   | f    |          | 0    | f   |
                 |------------|          |------------|

                 Quadruples

                 The true exit is BackPatched to point to
                 the NextQuad.
*/

EXTERN void M2Quads_BuildThenIf (void);

/*
   BuildElse - Builds the Else part of the If statement
               from the quad stack.
               The Stack is expected to contain:


               Entry                   Exit
               =====                   ====

       Ptr ->
               +------------+          +------------+
               | t   | f    |          | t+q  | 0   |
               |------------|          |------------|

               Quadruples

               q    GotoOp  _  _  0
               q+1  <- BackPatched from f
*/

EXTERN void M2Quads_BuildElse (void);

/*
   BuildEndIf - Builds the End part of the If statement
                from the quad stack.
                The Stack is expected to contain:


                Entry                   Exit
                =====                   ====

        Ptr ->
                +------------+
                | t   | f    |          Empty
                |------------|

                Quadruples

                Both t and f are backpatched to point to the NextQuad
*/

EXTERN void M2Quads_BuildEndIf (void);

/*
   BuildElsif1 - Builds the Elsif part of the If statement
                 from the quad stack.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====

         Ptr ->
                 +------------+          +------------+
                 | t   | f    |          | t+q  | 0   |
                 |------------|          |------------|

                 Quadruples

                 q    GotoOp  _  _  0
                 q+1  <- BackPatched from f
*/

EXTERN void M2Quads_BuildElsif1 (void);

/*
   BuildElsif2 - Builds the Elsif until part of the If statement
                 from the quad stack.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====

          Ptr ->
                 +--------------+
                 | 0    | f1    |                            <- Ptr
                 |--------------|          +---------------+
                 | t2   | f2    |          | t2    | f1+f2 |
                 |--------------|          |---------------|
*/

EXTERN void M2Quads_BuildElsif2 (void);

/*
   BuildForToByDo - Builds the For To By Do part of the For statement
                    from the quad stack.
                    The Stack is expected to contain:


                    Entry                   Exit
                    =====                   ====


             Ptr ->                                        <- Ptr
                    +------------+          +------------+
                    | BySym      |          | t   | f    |
                    |------------|          |------------|
                    | e2         |          | ForQuad    |
                    |------------|          |------------|
                    | e1         |          | BySym      |
                    |------------|          |------------|
                    | Ident      |          | IdentSym   |
                    |------------|          |------------|

                    Quadruple

                    q   BecomesOp  IdentSym  _  e1
                    q+1 if <       by        0  q+5
      	       	    q+2 GotoOp                  q+3
                    q+3 If >       IdentSym  e2 _
      	       	    q+4 GotoOp                  q+7
                    q+5 If <=      IdentSym  e2 _
      	       	    q+6 GotoOp                  q+7


                    The For Loop is regarded:

                    For ident := e1 To e2 By by Do

                    End
*/

EXTERN void M2Quads_BuildForToByDo (void);

/*
   BuildPseudoBy - Builds the Non existant part of the By
                   clause of the For statement
                   from the quad stack.
                   The Stack is expected to contain:


                   Entry                   Exit
                   =====                   ====

                                                           <- Ptr
                                           +------------+
                   Empty                   | BySym      |
                                           |------------|
*/

EXTERN void M2Quads_BuildPseudoBy (void);

/*
   BuildEndFor - Builds the End part of the For statement
                 from the quad stack.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====

         Ptr ->
                 +------------+
                 | t   | f    |
                 |------------|
                 | ForQuad    |
                 |------------|
                 | BySym      |
                 |------------|
                 | IdSym      |          Empty
                 |------------|
*/

EXTERN void M2Quads_BuildEndFor (unsigned int endpostok);

/*
   BuildCaseStart - starts the case statement.
                    It initializes a backpatch list on the compile
                    time stack, the list is used to contain all
                    case break points. The list is later backpatched
                    and contains all positions of the case statement
                    which jump to the end of the case statement.
                    The stack also contains room for a boolean
                    expression, this is needed to allow , operator
                    in the CaseField alternatives.

                    The Stack is expected to contain:


                    Entry                   Exit
                    =====                   ====

                                                           <- Ptr
                                            +------------+
                    Empty                   | 0    | 0   |
                                            |------------|
                                            | 0    | 0   |
                                            |------------|
*/

EXTERN void M2Quads_BuildCaseStart (void);

/*
   BuildCaseStartStatementSequence - starts the statement sequence
                                     inside a case clause.
                                     BackPatches the true exit to the
                                     NextQuad.
                                     The Stack:

                                     Entry             Exit

                              Ptr ->                                  <- Ptr
                                     +-----------+     +------------+
                                     | t   | f   |     | 0   | f    |
                                     |-----------|     |------------|
*/

EXTERN void M2Quads_BuildCaseStartStatementSequence (void);

/*
   BuildCaseEndStatementSequence - ends the statement sequence
                                   inside a case clause.
                                   BackPatches the false exit f1 to the
                                   NextQuad.
                                   Asserts that t1 and f2 is 0
                                   Pushes t2+q and 0

                                   Quadruples:

                                   q  GotoOp  _  _  0

                                   The Stack:

                                   Entry             Exit

                            Ptr ->                                  <- Ptr
                                   +-----------+     +------------+
                                   | t1  | f1  |     | 0    | 0   |
                                   |-----------|     |------------|
                                   | t2  | f2  |     | t2+q | 0   |
                                   |-----------|     |------------|
*/

EXTERN void M2Quads_BuildCaseEndStatementSequence (void);

/*
   BuildCaseRange - builds the range testing quaruples for
                    a case clause.

                    IF (e1>=ce1) AND (e1<=ce2)
                    THEN

                    ELS..

                    The Stack:

                    Entry             Exit

             Ptr ->
                    +-----------+
                    | ce2       |                   <- Ptr
                    |-----------|     +-----------+
                    | ce1       |     | t   | f   |
                    |-----------|     |-----------|
                    | t1  | f1  |     | t1  | f1  |
                    |-----------|     |-----------|
                    | t2  | f2  |     | t2  | f2  |
                    |-----------|     |-----------|
                    | e1        |     | e1        |
                    |-----------|     |-----------|
*/

EXTERN void M2Quads_BuildCaseRange (void);

/*
   BuildCaseEquality - builds the range testing quadruples for
                       a case clause.

                       IF e1=ce1
                       THEN

                       ELS..

                       The Stack:

                       Entry             Exit

                Ptr ->
                       +-----------+     +-----------+
                       | ce1       |     | t   | f   |
                       |-----------|     |-----------|
                       | t1  | f1  |     | t1  | f1  |
                       |-----------|     |-----------|
                       | t2  | f2  |     | t2  | f2  |
                       |-----------|     |-----------|
                       | e1        |     | e1        |
                       |-----------|     |-----------|
*/

EXTERN void M2Quads_BuildCaseEquality (void);

/*
   BuildCaseList - merges two case tests into one

                   The Stack:

                   Entry             Exit

            Ptr ->
                   +-----------+
                   | t2  | f2  |
                   |-----------|     +-------------+
                   | t1  | f1  |     | t1+t2| f1+f2|
                   |-----------|     |-------------|
*/

EXTERN void M2Quads_BuildCaseList (void);

/*
   BuildCaseOr - builds the , in the case clause.

                 The Stack:

                 Entry             Exit

          Ptr ->                                  <- Ptr
                 +-----------+     +------------+
                 | t   | f   |     | t    | 0   |
                 |-----------|     |------------|
*/

EXTERN void M2Quads_BuildCaseOr (void);

/*
   BuildCaseElse - builds the else of case clause.

                  The Stack:

                  Entry             Exit

           Ptr ->                                  <- Ptr
                  +-----------+     +------------+
                  | t   | f   |     | t    | 0   |
                  |-----------|     |------------|
*/

EXTERN void M2Quads_BuildCaseElse (void);

/*
   BuildCaseEnd - builds the end of case clause.

                  The Stack:

                  Entry             Exit

           Ptr ->
                  +-----------+
                  | t1  | f1  |
                  |-----------|
                  | t2  | f2  |
                  |-----------|
                  | e1        |
                  |-----------|     Empty
*/

EXTERN void M2Quads_BuildCaseEnd (void);

/*
   BuildCaseCheck - builds the case checking code to ensure that
                    the program does not need an else clause at runtime.
                    The stack is unaltered.
*/

EXTERN void M2Quads_BuildCaseCheck (void);

/*
   BuildNulParam - Builds a nul parameter on the stack.
                   The Stack:

                   Entry             Exit

                                                    <- Ptr
                   Empty             +------------+
                                     | 0          |
                                     |------------|
*/

EXTERN void M2Quads_BuildNulParam (void);

/*
   BuildProcedureCall - builds a procedure call.
                        The Stack:


                        Entry                      Exit

                 Ptr ->
                        +----------------+
                        | NoOfParam      |
                        |----------------|
                        | Param 1        |
                        |----------------|
                        | Param 2        |
                        |----------------|
                        .                .
                        .                .
                        .                .
                        |----------------|
                        | Param #        |
                        |----------------|
                        | ProcSym | Type |         Empty
                        |----------------|
*/

EXTERN void M2Quads_BuildProcedureCall (unsigned int tokno);

/*
   CheckBuildFunction - checks to see whether ProcSym is a function
                        and if so it adds a TempSym value which will
                        hold the return value once the function finishes.
                        This procedure also generates an error message
                        if the user is calling a function and ignoring
                        the return result.  The additional TempSym
                        is not created if ProcSym is a procedure
                        and the stack is unaltered.

                        The Stack:


                       Entry                      Exit

                Ptr ->

                                                  +----------------+
                                                  | ProcSym | Type |
                       +----------------+         |----------------|
                       | ProcSym | Type |         | TempSym | Type |
                       |----------------|         |----------------|
*/

EXTERN bool M2Quads_CheckBuildFunction (void);

/*
   BuildFunctionCall - builds a function call.
                       The Stack:


                       Entry                      Exit

                Ptr ->
                       +----------------+
                       | NoOfParam      |
                       |----------------|
                       | Param 1        |
                       |----------------|
                       | Param 2        |
                       |----------------|
                       .                .
                       .                .
                       .                .
                       |----------------|
                       | Param #        |                        <- Ptr
                       |----------------|         +------------+
                       | ProcSym | Type |         | ReturnVar  |
                       |----------------|         |------------|

*/

EXTERN void M2Quads_BuildFunctionCall (bool ConstExpr);

/*
   BuildConstFunctionCall - builds a function call and checks that this function can be
                            called inside a ConstExpression.

                            The Stack:


                            Entry                      Exit

                     Ptr ->
                            +----------------+
                            | NoOfParam      |
                            |----------------|
                            | Param 1        |
                            |----------------|
                            | Param 2        |
                            |----------------|
                            .                .
                            .                .
                            .                .
                            |----------------|
                            | Param #        |                        <- Ptr
                            |----------------|         +------------+
                            | ProcSym | Type |         | ReturnVar  |
                            |----------------|         |------------|

*/

EXTERN void M2Quads_BuildConstFunctionCall (void);

/*
   BuildBooleanVariable - tests to see whether top of stack is a boolean
                          conditional and if so it converts it into a boolean
                          variable.
*/

EXTERN void M2Quads_BuildBooleanVariable (void);

/*
   BuildModuleStart - starts current module scope.
*/

EXTERN void M2Quads_BuildModuleStart (unsigned int tok);

/*
   BuildProcedureStart - Builds start of the procedure. Creates space for
                         the local variables.
                         The Stack is expected to contain:


                         Entry                   Exit
                         =====                   ====

                 Ptr ->                                       <- Ptr
                        +------------+          +-----------+
                        | ProcSym    |          | ProcSym   |
                        |------------|          |-----------|
                        | Name       |          | Name      |
                        |------------|          |-----------|


                        Quadruples:

                        q   NewLocalVarOp  _  _  ProcSym
*/

EXTERN void M2Quads_BuildProcedureStart (void);

/*
   BuildProcedureBegin - determines the start of the BEGIN END block of
                         the procedure.
                         The Stack is expected to contain:


                         Entry                   Exit
                         =====                   ====

                 Ptr ->                                       <- Ptr
                        +------------+          +-----------+
                        | ProcSym    |          | ProcSym   |
                        |------------|          |-----------|
                        | Name       |          | Name      |
                        |------------|          |-----------|


                        Quadruples:

                        q   BeginOp  _  _  ProcSym
*/

EXTERN void M2Quads_BuildProcedureBegin (void);

/*
   BuildProcedureEnd - Builds end of the procedure. Destroys space for
                       the local variables.
                       The Stack is expected to contain:


                       Entry                   Exit
                       =====                   ====

                Ptr ->                                       <- Ptr
                       +------------+          +-----------+
                       | ProcSym    |          | ProcSym   |
                       |------------|          |-----------|
                       | Name       |          | Name      |
                       |------------|          |-----------|


                       Quadruples:

                       q   KillLocalVarOp  _  _  ProcSym
*/

EXTERN void M2Quads_BuildProcedureEnd (void);

/*
   BuildReturn - Builds the Return part of the procedure.
                 The Stack is expected to contain:


                 Entry                   Exit
                 =====                   ====

         Ptr ->
                 +------------+
                 | e1         |          Empty
                 |------------|
*/

EXTERN void M2Quads_BuildReturn (unsigned int tokreturn);

/*
   BuildModulePriority - assigns the current module with a priority
                         from the top of stack.

                         Entry                   Exit
                         =====                   ====


                  Ptr ->                         Empty
                         +------------+
                         | Priority   |
                         |------------|
*/

EXTERN void M2Quads_BuildModulePriority (void);

/*
   StartBuildWith - performs the with statement.
                    The Stack:

                    Entry                    Exit

                    +------------+
                    | Sym | Type |           Empty
                    |------------|
*/

EXTERN void M2Quads_StartBuildWith (unsigned int withTok);

/*
   EndBuildWith - terminates the innermost with scope.
*/

EXTERN void M2Quads_EndBuildWith (void);

/*
   CheckWithReference - performs the with statement.
                        The Stack:

                        Entry                    Exit

                        +------------+           +------------+
                        | Sym | Type |           | Sym | Type |
                        |------------|           |------------|
*/

EXTERN void M2Quads_CheckWithReference (void);

/*
   BuildDesignatorRecord - Builds the record referencing.
                           The Stack is expected to contain:


                           Entry                   Exit
                           =====                   ====

                   Ptr ->
                           +--------------+
                           | n            |
                           |--------------|
                           | fld1 | type1 |
                           |--------------|
                           .              .
                           .              .
                           .              .
                           |--------------|
                           | fldn | typen |                        <- Ptr
                           |--------------|        +-------------+
                           | Sym  | Type  |        | S    | type1|
                           |--------------|        |-------------|
*/

EXTERN void M2Quads_BuildDesignatorRecord (unsigned int dottok);

/*
   BuildDesignatorArray - Builds the array referencing.
                          The Stack is expected to contain:


                          Entry                   Exit
                          =====                   ====

                  Ptr ->
                          +--------------+
                          | n            |        Empty
                          |--------------|
                          | e1           |
                          |--------------|
                          .              .
                          .              .
                          .              .
                          |--------------|
                          | e2           |                      <- Ptr
                          |--------------|       +------------+
                          | Sym  | Type  |       | S    | T   |
                          |--------------|       |------------|
*/

EXTERN void M2Quads_BuildDesignatorArray (void);

/*
   BuildDesignatorPointer - Builds the record referencing.
                            The Stack is expected to contain:


                            Entry                   Exit
                            =====                   ====

                    Ptr ->                                           <- Ptr
                            +--------------+        +--------------+
                            | Sym1  | Type1|        | Sym2  | Type2|
                            |--------------|        |--------------|
*/

EXTERN void M2Quads_BuildDesignatorPointer (unsigned int ptrtok);

/*
   BuildNulExpression - Builds a nul expression on the stack.
                        The Stack:

                        Entry             Exit

                                                         <- Ptr
                        Empty             +------------+
                                          | NulSym     |
                                          |------------|
   tokpos is the position of the RETURN token.
*/

EXTERN void M2Quads_BuildNulExpression (unsigned int tokpos);

/*
   BuildSetStart - Pushes a Bitset type on the stack.

                      The Stack:

                      Entry             Exit

               Ptr ->                                        <- Ptr

                      Empty             +--------------+
                                        | Bitset       |
                                        |--------------|
*/

EXTERN void M2Quads_BuildSetStart (unsigned int tokpos);

/*
   BuildSetEnd - pops the set value and type from the stack
                 and pushes the value,type pair.

                        Entry                   Exit

                 Ptr ->
                        +--------------+
                        | Set Value    |                         <- Ptr
                        |--------------|        +--------------+
                        | Set Type     |        | Value | Type |
                        |--------------|        |--------------|
*/

EXTERN void M2Quads_BuildSetEnd (void);

/*
   BuildEmptySet - Builds an empty set on the stack.
                   The Stack:

                   Entry             Exit

                                                     <- Ptr
                                     +-------------+
            Ptr ->                   | Value       |
                   +-----------+     |-------------|
      	       	   | SetType   |     | SetType     |
                   |-----------|     |-------------|

   tokpos points to the opening '{'.
*/

EXTERN void M2Quads_BuildEmptySet (unsigned int tokpos);

/*
   BuildInclRange - includes a set range with a set.


                          Entry                   Exit
                          =====                   ====


                   Ptr ->
                          +------------+
                          | El2        |
                          |------------|
                          | El1        |                                 <- Ptr
                          |------------|           +-------------------+
                          | Set Value  |           | Value + {El1..El2}|
                          |------------|           |-------------------|
                          | Set Type   |           | Set Type          |
                          |------------|           |-------------------|

                   No quadruples produced as the range info is contained within
                   the set value.
*/

EXTERN void M2Quads_BuildInclRange (void);

/*
   BuildInclBit - includes a bit into the set.

                         Entry                   Exit
                         =====                   ====


                  Ptr ->
                         +------------+
                         | Element    |                         <- Ptr
                         |------------|          +------------+
                         | Value      |          | Value      |
                         |------------|          |------------|
                         | Type       |          | Type       |
                         |------------|          |------------|

                  No quadruples produced as this bit inclusion is contained within
                  the set value.
*/

EXTERN void M2Quads_BuildInclBit (void);

/*
   SilentBuildConstructor - places NulSym into the constructor fifo queue.
*/

EXTERN void M2Quads_SilentBuildConstructor (void);

/*
   SilentBuildConstructorStart - removes an entry from the constructor fifo queue.
*/

EXTERN void M2Quads_SilentBuildConstructorStart (void);

/*
   BuildConstructor - builds a constructor.
                      Stack

                      Entry                 Exit

               Ptr ->
                      +------------+
                      | Type       |                <- Ptr
                      |------------+
*/

EXTERN void M2Quads_BuildConstructor (unsigned int tokcbrpos);

/*
   BuildConstructorStart - builds a constructor.
                           Stack

                           Entry                 Exit

                    Ptr ->                                      <- Ptr
                           +------------+        +------------+
                           | Name       |        | Sym        |
                           |------------+        |------------|
*/

EXTERN void M2Quads_BuildConstructorStart (unsigned int cbratokpos);

/*
   BuildConstructorEnd - removes the current constructor frame from the
                         constructor stack (it does not effect the quad
                         stack)

                         Stack

                         Entry                 Exit

                  Ptr ->                                      <- Ptr
                         +------------+        +------------+
                         | const      |        | const      |
                         |------------+        |------------|

   startpos is the start of the constructor, either the typename or '{'
   cbratokpos is the '}'.
*/

EXTERN void M2Quads_BuildConstructorEnd (unsigned int startpos, unsigned int cbratokpos);

/*
   NextConstructorField - increments the top of constructor stacks
                          index by one.
*/

EXTERN void M2Quads_NextConstructorField (void);

/*
   BuildTypeForConstructor - pushes the type implied by the current constructor.
                             If no constructor is currently being built then
                             it Pushes a Bitset type.
*/

EXTERN void M2Quads_BuildTypeForConstructor (unsigned int tokpos);

/*
   BuildComponentValue -  builds a component value.

                          Entry                 Exit

                   Ptr ->                                      <- Ptr


                          +------------+        +------------+
                          | const      |        | const      |
                          |------------|        |------------|

                          (this is incomplete (fixme))
*/

EXTERN void M2Quads_BuildComponentValue (void);

/*
   PopConstructor - removes the top constructor from the top of stack.
*/

EXTERN void M2Quads_PopConstructor (void);

/*
   BuildNot   - Builds a NOT operation from the quad stack.
                The Stack is expected to contain:


                  Entry                   Exit
                  =====                   ====

           Ptr ->                                        <- Ptr
                  +------------+          +------------+
                  | t    | f   |          | f    | t   |
                  |------------|          |------------|
*/

EXTERN void M2Quads_BuildNot (unsigned int notTokPos);

/*
   RecordOp - Records the operator passed on the stack.
              Checks for AND operator or OR operator
              if either of these operators are found then BackPatching
              takes place.
              The Expected Stack:

              Entry                        Exit

       Ptr ->                                               <- Ptr
              +-------------+               +-------------+
              | OperatorTok |               | OperatorTok |
              |-------------|               |-------------|
              | t    | f    |               | t    | f    |
              |-------------|               |-------------|


              If OperatorTok=AndTok
              Then
                 BackPatch(f, NextQuad)
              Elsif OperatorTok=OrTok
              Then
                 BackPatch(t, NextQuad)
              End
*/

EXTERN void M2Quads_RecordOp (void);

/*
   BuildRelOp   - Builds a relative operation from the quad stack.
                  The Stack is expected to contain:


                  Entry                   Exit
                  =====                   ====

           Ptr ->
                  +------------+
                  | e1         |
                  |------------|                          <- Ptr
                  | Operator   |
                  |------------|          +------------+
                  | e2         |          | t    | f   |
                  |------------|          |------------|


                    Quadruples Produced

                    q     IFOperator  e1  e2  TrueExit
                    q+1   GotoOp              FalseExit
*/

EXTERN void M2Quads_BuildRelOp (unsigned int optokpos);

/*
   BuildBinaryOp   - Builds a binary operation from the quad stack.
                     The Stack is expected to contain:


                     Entry                   Exit
                     =====                   ====

              Ptr ->
                     +------------+
                     | Sym1       |
                     |------------|
                     | Operator   |                          <- Ptr
                     |------------|          +------------+
                     | Sym2       |          | Temporary  |
                     |------------|          |------------|


                     Quadruples Produced

                     q     Operator  Temporary  Sym1  Sym2

*/

EXTERN void M2Quads_BuildBinaryOp (void);

/*
   BuildUnaryOp   - Builds a unary operation from the quad stack.
                    The Stack is expected to contain:


                    Entry                   Exit
                    =====                   ====

             Ptr ->
                    +------------+
                    | Sym1       |
                    |------------|          +------------+
                    | Operator   |          | Temporary  |  <- Ptr
                    |------------|          |------------|


                    Quadruples Produced

                    q     Operator  Temporary  _ Sym1

*/

EXTERN void M2Quads_BuildUnaryOp (void);

/*
   OperandT - returns the ident operand stored in the true position on the boolean stack.
*/

EXTERN unsigned int M2Quads_OperandT (unsigned int pos);

/*
   OperandF - returns the ident operand stored in the false position on the boolean stack.
*/

EXTERN unsigned int M2Quads_OperandF (unsigned int pos);

/*
   PushTF - Push a True and a False exit quad numbers onto the
            True/False stack.
*/

EXTERN void M2Quads_PushTF (unsigned int True, unsigned int False);

/*
   PopTF - Pops a True and a False exit quad numbers from the
           True/False stack.
*/

EXTERN void M2Quads_PopTF (unsigned int *True, unsigned int *False);

/*
   PushT - Push a True exit quad numbers onto the
           True/False stack. The False exit will be zero.
*/

EXTERN void M2Quads_PushT (unsigned int True);

/*
   PopT - Pop a True exit quad number from the True/False
          stack. The False exit is ignored.
*/

EXTERN void M2Quads_PopT (unsigned int *True);

/*
   PushTtok - Push an item onto the stack in the T (true) position,
              it is assummed to be a token and its token location is recorded.
*/

EXTERN void M2Quads_PushTtok (unsigned int True, unsigned int tokno);

/*
   PushTFtok - Push an item onto the stack in the T (true) position,
               it is assummed to be a token and its token location is recorded.
*/

EXTERN void M2Quads_PushTFtok (unsigned int True, unsigned int False, unsigned int tokno);

/*
   PopTFtok - Pop T/F/tok from the stack.
*/

EXTERN void M2Quads_PopTFtok (unsigned int *True, unsigned int *False, unsigned int *tokno);

/*
   PushTFAtok - Push T/F/A/tok to the stack.
*/

EXTERN void M2Quads_PushTFAtok (unsigned int True, unsigned int False, unsigned int Array, unsigned int tokno);

/*
   PopTtok - Pops the T value from the stack and token position.
*/

EXTERN void M2Quads_PopTtok (unsigned int *True, unsigned int *tok);

/*
   PushTFn - Push a True and False numbers onto the True/False stack.
             True and False are assumed to contain Symbols or Ident etc.
*/

EXTERN void M2Quads_PushTFn (unsigned int True, unsigned int False, unsigned int n);

/*
   PushTFntok - Push a True and False numbers onto the True/False stack.
                True and False are assumed to contain Symbols or Ident etc.
*/

EXTERN void M2Quads_PushTFntok (unsigned int True, unsigned int False, unsigned int n, unsigned int tokno);

/*
   PopTFn - Pop a True and False number from the True/False stack.
            True and False are assumed to contain Symbols or Ident etc.
*/

EXTERN void M2Quads_PopTFn (unsigned int *True, unsigned int *False, unsigned int *n);

/*
   PopNothing - pops the top element on the stack.
*/

EXTERN void M2Quads_PopNothing (void);

/*
   PopN - pops multiple elements from the BoolStack.
*/

EXTERN void M2Quads_PopN (unsigned int n);

/*
   PushTFA - Push True, False, Array, numbers onto the
             True/False stack.  True and False are assumed to
             contain Symbols or Ident etc.
*/

EXTERN void M2Quads_PushTFA (unsigned int True, unsigned int False, unsigned int Array);

/*
   OperandTok - returns the token associated with pos, on the stack.
*/

EXTERN unsigned int M2Quads_OperandTok (unsigned int pos);

/*
   OperandA - returns possible array symbol associated with the ident
              operand stored on the boolean stack.
*/

EXTERN unsigned int M2Quads_OperandA (unsigned int pos);

/*
   OperandAnno - returns the annotation string associated with the
                 position, n, on the stack.
*/

EXTERN DynamicStrings_String M2Quads_OperandAnno (unsigned int n);

/*
   Annotate - annotate the top of stack.
*/

EXTERN void M2Quads_Annotate (const char *a_, unsigned int _a_high);

/*
   DisplayStack - displays the compile time symbol stack.
*/

EXTERN void M2Quads_DisplayStack (void);

/*
   Top - returns the no of items held in the stack.
*/

EXTERN unsigned int M2Quads_Top (void);

/*
   DupFrame - duplicate the top of stack and push the new frame.
*/

EXTERN void M2Quads_DupFrame (void);

/*
   WriteOperand - displays the operands name, symbol id and mode of addressing.
*/

EXTERN void M2Quads_WriteOperand (unsigned int Sym);

/*
   BeginVarient - begin a varient record.
*/

EXTERN void M2Quads_BeginVarient (void);

/*
   EndVarient - end a varient record.
*/

EXTERN void M2Quads_EndVarient (void);

/*
   ElseVarient - associate an ELSE clause with a varient record.
*/

EXTERN void M2Quads_ElseVarient (void);

/*
   BeginVarientList - begin an ident list containing ranges belonging to a
                      varient list.
*/

EXTERN void M2Quads_BeginVarientList (void);

/*
   EndVarientList - end a range list for a varient field.
*/

EXTERN void M2Quads_EndVarientList (void);

/*
   AddRecordToList - adds the record held on the top of stack to the
                     list of records and varient fields.
*/

EXTERN void M2Quads_AddRecordToList (void);

/*
   AddVarientToList - adds varient held on the top of stack to the list.
*/

EXTERN void M2Quads_AddVarientToList (void);

/*
   AddVarientFieldToList - adds varient field, f, to the list of all varient
                           fields created.
*/

EXTERN void M2Quads_AddVarientFieldToList (unsigned int f);

/*
   AddVarientRange - creates a range from the top two contant expressions
                     on the stack which are recorded with the current
                     varient field.  The stack is unaltered.
*/

EXTERN void M2Quads_AddVarientRange (void);

/*
   AddVarientEquality - adds the contant expression on the top of the stack
                        to the current varient field being recorded.
                        The stack is unaltered.
*/

EXTERN void M2Quads_AddVarientEquality (void);

/*
   BuildCodeOn - generates a quadruple declaring that code should be
                 emitted from henceforth.

                 The Stack is unnaffected.
*/

EXTERN void M2Quads_BuildCodeOn (void);

/*
   BuildCodeOff - generates a quadruple declaring that code should not be
                  emmitted from henceforth.

                  The Stack is unnaffected.
*/

EXTERN void M2Quads_BuildCodeOff (void);

/*
   BuildProfileOn - generates a quadruple declaring that profile timings
                    should be emmitted from henceforth.

                    The Stack is unnaffected.
*/

EXTERN void M2Quads_BuildProfileOn (void);
EXTERN void M2Quads_BuildProfileOff (void);

/*
   BuildOptimizeOn - generates a quadruple declaring that optimization
                     should occur from henceforth.

                     The Stack is unnaffected.
*/

EXTERN void M2Quads_BuildOptimizeOn (void);

/*
   BuildOptimizeOff - generates a quadruple declaring that optimization
                      should not occur from henceforth.

                      The Stack is unnaffected.
*/

EXTERN void M2Quads_BuildOptimizeOff (void);

/*
   BuildAsm - builds an Inline pseudo quadruple operator.
              The inline interface, Sym, is stored as the operand
              to the operator InlineOp.

              The stack is expected to contain:


                        Entry                   Exit
                        =====                   ====

              Ptr ->
                     +--------------+
                     | Sym          |        Empty
                     |--------------|
*/

EXTERN void M2Quads_BuildAsm (unsigned int tok);

/*
   BuildLineNo - builds a LineNumberOp pseudo quadruple operator.
                 This quadruple indicates which source line has been
                 processed, these quadruples are only generated if we
                 are producing runtime debugging information.

                 The stack is not affected, read or altered in any way.


                        Entry                   Exit
                        =====                   ====

                 Ptr ->                              <- Ptr
*/

EXTERN void M2Quads_BuildLineNo (void);

/*
   PushLineNo - pushes the current file and line number to the stack.
*/

EXTERN void M2Quads_PushLineNo (void);

/*
   BuildStmtNote - builds a StatementNoteOp pseudo quadruple operator.
                   This quadruple indicates which source line has been
                   processed and it represents the start of a statement
                   sequence.
                   It differs from LineNumberOp in that multiple successive
                   LineNumberOps will be removed and the final one is attached to
                   the next real GCC tree.  Whereas a StatementNoteOp is always left
                   alone.  Depending upon the debugging level it will issue a nop
                   instruction to ensure that the gdb single step will step into
                   this line.  Practically it allows pedalogical debugging to
                   occur when there is syntax sugar such as:


                         END   step 
                      END   step 
                   END ;  step 
		   a := 1 ;  step 

                   REPEAT  step 
		      i := 1   step 

                   The stack is not affected, read or altered in any way.


                        Entry                   Exit
                        =====                   ====

                 Ptr ->                              <- Ptr
*/

EXTERN void M2Quads_BuildStmtNote (int offset);

/*
   LoopAnalysis - checks whether an infinite loop exists.
*/

EXTERN void M2Quads_LoopAnalysis (unsigned int Scope, unsigned int Current, unsigned int End);

/*
   ForLoopAnalysis - checks all the FOR loops for index variable manipulation
                     and dangerous usage outside the loop.
*/

EXTERN void M2Quads_ForLoopAnalysis (void);

/*
   BuildSizeCheckStart - switches off all quadruple generation if the function SIZE
                         is being "called". This should be done as SIZE only requires the
                         actual type of the expression, not its value. Consider the problem of
                         SIZE(UninitializedPointer^) quite legal and it must also be safe!


                         The Stack is expected to contain:


                         Entry                   Exit
                         =====                   ====

                 Ptr ->                                       <- Ptr
                        +------------+          +-----------+
                        | ProcSym    |          | ProcSym   |
                        |------------|          |-----------|
*/

EXTERN void M2Quads_BuildSizeCheckStart (void);

/*
   BackPatchSubrangesAndOptParam - runs through all the quadruples and finds SubrangeLow or SubrangeHigh
                                   quadruples and replaces it by an assignment to the Low or High component
                                   of the subrange type.

                                   Input:
                                   SubrangeLow    op1     op3          op3 is a subrange 

                                   Output:
                                   Becomes        op1     low

                                   Input:
                                   SubrangeHigh   op1     op3          op3 is a subrange 

                                   Output:
                                   Becomes        op1     high

                                   Input:
                                   OptParam       op1     op2    op3

                                   Output:
                                   Param          op1     op2    GetOptArgInit(op3)
*/

EXTERN void M2Quads_BackPatchSubrangesAndOptParam (void);

/*
   WriteOperator - writes the name of the quadruple operator.
*/

EXTERN void M2Quads_WriteOperator (M2Quads_QuadOperator Operator);

/*
   PushAutoOn - push the auto flag and then set it to TRUE.
                Any call to ident in the parser will result in the token being pushed.
*/

EXTERN void M2Quads_PushAutoOn (void);

/*
   PushAutoOff - push the auto flag and then set it to FALSE.
*/

EXTERN void M2Quads_PushAutoOff (void);

/*
   IsAutoPushOn - returns the value of the current Auto ident push flag.
*/

EXTERN bool M2Quads_IsAutoPushOn (void);

/*
   PopAuto - restores the previous value of the Auto flag.
*/

EXTERN void M2Quads_PopAuto (void);

/*
   MustCheckOverflow - returns TRUE if the quadruple should test for overflow.
*/

EXTERN bool M2Quads_MustCheckOverflow (unsigned int q);

/*
   PushInConstExpression - push the InConstExpression flag and then set it to TRUE.
*/

EXTERN void M2Quads_PushInConstExpression (void);

/*
   PopInConstExpression - restores the previous value of the InConstExpression.
*/

EXTERN void M2Quads_PopInConstExpression (void);

/*
   IsInConstExpression - returns the value of the InConstExpression.
*/

EXTERN bool M2Quads_IsInConstExpression (void);

/*
   PushInConstParameters - push the InConstParameters flag and then set it to TRUE.
*/

EXTERN void M2Quads_PushInConstParameters (void);

/*
   PopInConstParameters - restores the previous value of the InConstParameters.
*/

EXTERN void M2Quads_PopInConstParameters (void);

/*
   IsInConstParameters - returns the value of the InConstParameters.
*/

EXTERN bool M2Quads_IsInConstParameters (void);

/*
   BuildAsmElement - the stack is expected to contain:


                        Entry                      Exit
                        =====                      ====

                 Ptr ->
                        +------------------+
                        | expr | tokpos    |
                        |------------------|
                        | str              |
                        |------------------|
                        | name             |
                        |------------------|       +------------------+
                        | CurrentInterface |       | CurrentInterface |
                        |------------------|       |------------------|
                        | CurrentAsm       |       | CurrentAsm       |
                        |------------------|       |------------------|
                        | n                |       | n                |
                        |------------------|       |------------------|
*/

EXTERN void M2Quads_BuildAsmElement (bool input, bool output);

/*
   BuildAsmTrash - the stack is expected to contain:


                        Entry                      Exit
                        =====                      ====

                 Ptr ->
                        +------------------+
                        | expr | tokpos    |
                        |------------------|       +------------------+
                        | CurrentInterface |       | CurrentInterface |
                        |------------------|       |------------------|
                        | CurrentAsm       |       | CurrentAsm       |
                        |------------------|       |------------------|
                        | n                |       | n                |
                        |------------------|       |------------------|
*/

EXTERN void M2Quads_BuildAsmTrash (void);

/*
   GetQuadTrash - return the symbol associated with the trashed operand.
*/

EXTERN unsigned int M2Quads_GetQuadTrash (unsigned int quad);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
