/* GCompris
 *
 * SPDX-FileCopyrightText: 2015 Bruno Coudoin <bruno.coudoin@gcompris.net>
 *
 * Authors:
 *   Bruno Coudoin <bruno.coudoin@gcompris.net> (GTK+ version)
 *   Pulkit Gupta <pulkitgenius@gmail.com> (Qt Quick port)
 *   Timothée Giet <animtim@gmail.com> (map update svg)
 *
 *   SPDX-License-Identifier: GPL-3.0-or-later
 */
import QtQuick

QtObject {
    property string instruction: qsTr("Southern Africa")
    property var levels: [
    {
        "pixmapfile": "southernafrica/all_south_africa.svgz",
        "type": "SHAPE_BACKGROUND_IMAGE"
    },
    {
        "pixmapfile": "southernafrica/zimbabwe.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/zimbabwe.$CA",
        "toolTipText": qsTr("Zimbabwe"),
        "x": "0.5155",
        "y": "0.6094"
    },
    {
        "pixmapfile": "southernafrica/zambia.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/zambia.$CA",
        "toolTipText": qsTr("Zambia"),
        "x": "0.4865",
        "y": "0.4657"
    },
    {
        "pixmapfile": "southernafrica/uganda.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/uganda.$CA",
        "toolTipText": qsTr("Uganda"),
        "x": "0.5861",
        "y": "0.1135"
    },
    {
        "pixmapfile": "southernafrica/tanzania.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/tanzania.$CA",
        "toolTipText": qsTr("Tanzania"),
        "x": "0.6448",
        "y": "0.3009"
    },
    {
        "pixmapfile": "southernafrica/eswatini.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/eswatini.$CA",
        "toolTipText": qsTr("Eswatini"),
        "x": "0.5677",
        "y": "0.7919"
    },
    {
        "pixmapfile": "southernafrica/south_africa.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/south_africa.$CA",
        "toolTipText": qsTr("South Africa"),
        "x": "0.4159",
        "y": "0.8392"
    },
    {
        "pixmapfile": "southernafrica/rwanda.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/rwanda.$CA",
        "toolTipText": qsTr("Rwanda"),
        "x": "0.5323",
        "y": "0.1933"
    },
    {
        "pixmapfile": "southernafrica/republic_of_congo.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/republic_of_congo.$CA",
        "toolTipText": qsTr("Republic of the Congo"),
        "x": "0.1968",
        "y": "0.1629"
    },
    {
        "pixmapfile": "southernafrica/namibia.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/namibia.$CA",
        "toolTipText": qsTr("Namibia"),
        "x": "0.2777",
        "y": "0.7049"
    },
    {
        "pixmapfile": "southernafrica/mozambique.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/mozambique.$CA",
        "toolTipText": qsTr("Mozambique"),
        "x": "0.6592",
        "y": "0.6005"
    },
    {
        "pixmapfile": "southernafrica/malawi.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/malawi.$CA",
        "toolTipText": qsTr("Malawi"),
        "x": "0.6311",
        "y": "0.4693"
    },
    {
        "pixmapfile": "southernafrica/madagascar.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/madagascar.$CA",
        "toolTipText": qsTr("Madagascar"),
        "x": "0.9128",
        "y": "0.6047"
    },
    {
        "pixmapfile": "southernafrica/lesotho.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/lesotho.$CA",
        "toolTipText": qsTr("Lesotho"),
        "x": "0.4955",
        "y": "0.8669"
    },
    {
        "pixmapfile": "southernafrica/kenya.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/kenya.$CA",
        "toolTipText": qsTr("Kenya"),
        "x": "0.7119",
        "y": "0.1369"
    },
    {
        "pixmapfile": "southernafrica/gabon.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/gabon.$CA",
        "toolTipText": qsTr("Gabon"),
        "x": "0.1233",
        "y": "0.1664"
    },
    {
        "pixmapfile": "southernafrica/equatorial_guinea.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/equatorial_guinea.$CA",
        "toolTipText": qsTr("Equatorial Guinea"),
        "x": "0.0851",
        "y": "0.0894"
    },
    {
        "pixmapfile": "southernafrica/democratic_republic_of_congo.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/democratic_republic_of_congo.$CA",
        "toolTipText": qsTr("Democratic Republic of the Congo"),
        "x": "0.3505",
        "y": "0.2466"
    },
    {
        "pixmapfile": "southernafrica/burundi.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/burundi.$CA",
        "toolTipText": qsTr("Burundi"),
        "x": "0.5333",
        "y": "0.2289"
    },
    {
        "pixmapfile": "southernafrica/botswana.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/botswana.$CA",
        "toolTipText": qsTr("Botswana"),
        "x": "0.416",
        "y": "0.6894"
    },
    {
        "pixmapfile": "southernafrica/angola.svgz",
        "soundFile": "voices-$CA/$LOCALE/geography/angola.$CA",
        "toolTipText": qsTr("Angola"),
        "x": "0.2644",
        "y": "0.4194"
    }
    ]
}
