% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_units.R
\name{scale_units}
\alias{scale_x_units}
\alias{scale_y_units}
\alias{scale_colour_units}
\alias{scale_color_units}
\alias{scale_fill_units}
\alias{scale_alpha_units}
\alias{scale_size_units}
\alias{scale_size_area_units}
\alias{scale_radius_units}
\alias{scale_linewidth_units}
\title{Continuous scales for units data}
\usage{
scale_x_units(..., sec.axis = ggplot2::waiver(), unit = NULL)

scale_y_units(..., sec.axis = ggplot2::waiver(), unit = NULL)

scale_colour_units(..., unit = NULL)

scale_color_units(..., unit = NULL)

scale_fill_units(..., unit = NULL)

scale_alpha_units(..., unit = NULL)

scale_size_units(..., unit = NULL)

scale_size_area_units(..., unit = NULL)

scale_radius_units(..., unit = NULL)

scale_linewidth_units(..., unit = NULL)
}
\arguments{
\item{...}{arguments passed on to the corresponding continuous scale
(see the manual page for each \code{scale_{type}} for details).}

\item{sec.axis}{\code{\link[ggplot2:sec_axis]{sec_axis()}} is used to specify a secondary axis.}

\item{unit}{A unit specification to use for the guide. If given, the values
will be converted to this unit before plotting. An error will be thrown if
the specified unit is incompatible with the unit of the data.}
}
\description{
These are the default scales for the \code{units} class. These will usually
be added automatically. To override manually, use \code{scale_{type}_units}.
}
\examples{
if (requireNamespace("ggplot2", quietly=TRUE)) {

library(ggplot2)

mtcars$consumption <- set_units(mtcars$mpg, mi / gallon)
mtcars$power <- set_units(mtcars$hp, hp)

# Use units encoded into the data
ggplot(mtcars) +
  geom_point(aes(power, consumption))

# Convert units on the fly during plotting
ggplot(mtcars) +
  geom_point(aes(power, consumption)) +
  scale_x_units(unit = "W") +
  scale_y_units(unit = "km/l")

# Resolve units when transforming data
ggplot(mtcars) +
  geom_point(aes(power, 1 / consumption))

# Reverse the y axis
ggplot(mtcars) +
  geom_point(aes(power, consumption)) +
  scale_y_units(transform="reverse")

}
}
