% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pal-gradient.R
\name{pal_div_gradient}
\alias{pal_div_gradient}
\alias{div_gradient_pal}
\title{Diverging colour gradient (continuous).}
\usage{
pal_div_gradient(
  low = "#2B6788",
  mid = "#CBCBCB",
  high = "#90503F",
  space = "Lab"
)

div_gradient_pal(
  low = "#2B6788",
  mid = "#CBCBCB",
  high = "#90503F",
  space = "Lab"
)
}
\arguments{
\item{low}{colour for low end of gradient.}

\item{mid}{colour for mid point}

\item{high}{colour for high end of gradient.}

\item{space}{colour space in which to calculate gradient. Must be "Lab" -
other values are deprecated.}
}
\description{
Diverging colour gradient (continuous).
}
\examples{
x <- seq(-1, 1, length.out = 100)
r <- sqrt(outer(x^2, x^2, "+"))
image(r, col = pal_div_gradient()(seq(0, 1, length.out = 12)))
image(r, col = pal_div_gradient()(seq(0, 1, length.out = 30)))
image(r, col = pal_div_gradient()(seq(0, 1, length.out = 100)))

pal <- pal_div_gradient(low = "#2E6A70")
image(r, col = pal(seq(0, 1, length.out = 100)))
}
