# Security Policy

We take the security of this project seriously. We appreciate your efforts to responsibly disclose your findings and will make every effort to acknowledge your contributions.

## Reporting a Vulnerability

**Do not submit security issues through GitHub Issues, Discussions, or Pull Requests.**

If you believe you have discovered a security vulnerability, please submit it through GitHub’s private and encrypted reporting system:

1. Open the **Security** tab of this repository
2. Click **“Report a vulnerability”**
3. Include a clear description, impact assessment (if known), and steps to reproduce

This mechanism is the preferred and most secure way to report vulnerabilities, consistent with best practices across open-source projects.

## What Happens Next

After receiving your report, maintainers will:

- Review the submitted information
- Request additional details if necessary
- Investigate and work toward a fix or mitigation
- Communicate with you throughout the process

Due to the varying nature and complexity of security issues, we do not commit to strict response or resolution deadlines. Nonetheless, we aim to handle all reports in a timely and responsible manner.

## Coordinated Disclosure

To protect the community, please:

- Avoid publicly disclosing the vulnerability until a fix has been released
- Limit testing or reproduction to what is necessary for your report
- Follow coordinated disclosure norms commonly used in open source

We appreciate your contribution to keeping this project secure!
