# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.virtualenclaves.aio import VirtualEnclavesMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestVirtualEnclavesMgmtApprovalOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(VirtualEnclavesMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_approval_get(self, resource_group):
        response = await self.client.approval.get(
            resource_uri="str",
            approval_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_approval_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.approval.begin_create_or_update(
                resource_uri="str",
                approval_name="str",
                resource={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "requestMetadata": {
                            "resourceAction": "str",
                            "approvalCallbackPayload": "str",
                            "approvalCallbackRoute": "str",
                            "approvalStatus": "str",
                        },
                        "approvers": [
                            {"approverEntraId": "str", "lastUpdatedAt": "2020-02-20 00:00:00", "actionPerformed": "str"}
                        ],
                        "createdAt": "2020-02-20 00:00:00",
                        "grandparentResourceId": "str",
                        "parentResourceId": "str",
                        "provisioningState": "str",
                        "stateChangedAt": "2020-02-20 00:00:00",
                        "ticketId": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_approval_list_by_parent(self, resource_group):
        response = self.client.approval.list_by_parent(
            resource_uri="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_approval_begin_update(self, resource_group):
        response = await (
            await self.client.approval.begin_update(
                resource_uri="str",
                approval_name="str",
                properties={
                    "properties": {
                        "requestMetadata": {
                            "resourceAction": "str",
                            "approvalCallbackPayload": "str",
                            "approvalCallbackRoute": "str",
                            "approvalStatus": "str",
                        },
                        "approvers": [
                            {"approverEntraId": "str", "lastUpdatedAt": "2020-02-20 00:00:00", "actionPerformed": "str"}
                        ],
                        "createdAt": "2020-02-20 00:00:00",
                        "grandparentResourceId": "str",
                        "parentResourceId": "str",
                        "stateChangedAt": "2020-02-20 00:00:00",
                        "ticketId": "str",
                    }
                },
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_approval_begin_delete(self, resource_group):
        response = await (
            await self.client.approval.begin_delete(
                resource_uri="str",
                approval_name="str",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_approval_begin_notify_initiator(self, resource_group):
        response = await (
            await self.client.approval.begin_notify_initiator(
                resource_uri="str",
                approval_name="str",
                body={"approvalStatus": "Approved"},
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
