# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.recoveryservicessiterecovery.aio import SiteRecoveryManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestSiteRecoveryManagementReplicationRecoveryPlansOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(SiteRecoveryManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_recovery_plans_list(self, resource_group):
        response = self.client.replication_recovery_plans.list(
            api_version="2025-01-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_recovery_plans_get(self, resource_group):
        response = await self.client.replication_recovery_plans.get(
            recovery_plan_name="str",
            api_version="2025-01-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_recovery_plans_begin_create(self, resource_group):
        response = await (
            await self.client.replication_recovery_plans.begin_create(
                recovery_plan_name="str",
                input={
                    "properties": {
                        "groups": [
                            {
                                "groupType": "str",
                                "endGroupActions": [
                                    {
                                        "actionName": "str",
                                        "customDetails": "recovery_plan_action_details",
                                        "failoverDirections": ["str"],
                                        "failoverTypes": ["str"],
                                    }
                                ],
                                "replicationProtectedItems": [{"id": "str", "virtualMachineId": "str"}],
                                "startGroupActions": [
                                    {
                                        "actionName": "str",
                                        "customDetails": "recovery_plan_action_details",
                                        "failoverDirections": ["str"],
                                        "failoverTypes": ["str"],
                                    }
                                ],
                            }
                        ],
                        "primaryFabricId": "str",
                        "recoveryFabricId": "str",
                        "failoverDeploymentModel": "str",
                        "providerSpecificInput": ["recovery_plan_provider_specific_input"],
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_recovery_plans_begin_delete(self, resource_group):
        response = await (
            await self.client.replication_recovery_plans.begin_delete(
                recovery_plan_name="str",
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_recovery_plans_begin_update(self, resource_group):
        response = await (
            await self.client.replication_recovery_plans.begin_update(
                recovery_plan_name="str",
                input={
                    "properties": {
                        "groups": [
                            {
                                "groupType": "str",
                                "endGroupActions": [
                                    {
                                        "actionName": "str",
                                        "customDetails": "recovery_plan_action_details",
                                        "failoverDirections": ["str"],
                                        "failoverTypes": ["str"],
                                    }
                                ],
                                "replicationProtectedItems": [{"id": "str", "virtualMachineId": "str"}],
                                "startGroupActions": [
                                    {
                                        "actionName": "str",
                                        "customDetails": "recovery_plan_action_details",
                                        "failoverDirections": ["str"],
                                        "failoverTypes": ["str"],
                                    }
                                ],
                            }
                        ]
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_recovery_plans_begin_failover_cancel(self, resource_group):
        response = await (
            await self.client.replication_recovery_plans.begin_failover_cancel(
                recovery_plan_name="str",
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_recovery_plans_begin_failover_commit(self, resource_group):
        response = await (
            await self.client.replication_recovery_plans.begin_failover_commit(
                recovery_plan_name="str",
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_recovery_plans_begin_planned_failover(self, resource_group):
        response = await (
            await self.client.replication_recovery_plans.begin_planned_failover(
                recovery_plan_name="str",
                input={
                    "properties": {
                        "failoverDirection": "str",
                        "providerSpecificDetails": ["recovery_plan_provider_specific_failover_input"],
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_recovery_plans_begin_reprotect(self, resource_group):
        response = await (
            await self.client.replication_recovery_plans.begin_reprotect(
                recovery_plan_name="str",
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_recovery_plans_begin_test_failover(self, resource_group):
        response = await (
            await self.client.replication_recovery_plans.begin_test_failover(
                recovery_plan_name="str",
                input={
                    "properties": {
                        "failoverDirection": "str",
                        "networkType": "str",
                        "networkId": "str",
                        "providerSpecificDetails": ["recovery_plan_provider_specific_failover_input"],
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_recovery_plans_begin_test_failover_cleanup(self, resource_group):
        response = await (
            await self.client.replication_recovery_plans.begin_test_failover_cleanup(
                recovery_plan_name="str",
                input={"properties": {"comments": "str"}},
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_replication_recovery_plans_begin_unplanned_failover(self, resource_group):
        response = await (
            await self.client.replication_recovery_plans.begin_unplanned_failover(
                recovery_plan_name="str",
                input={
                    "properties": {
                        "failoverDirection": "str",
                        "sourceSiteOperations": "str",
                        "providerSpecificDetails": ["recovery_plan_provider_specific_failover_input"],
                    }
                },
                api_version="2025-01-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
