# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute.aio import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementDedicatedHostGroupsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dedicated_host_groups_list_by_subscription(self, resource_group):
        response = self.client.dedicated_host_groups.list_by_subscription(
            api_version="2025-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dedicated_host_groups_list_by_resource_group(self, resource_group):
        response = self.client.dedicated_host_groups.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-04-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dedicated_host_groups_get(self, resource_group):
        response = await self.client.dedicated_host_groups.get(
            resource_group_name=resource_group.name,
            host_group_name="str",
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dedicated_host_groups_create_or_update(self, resource_group):
        response = await self.client.dedicated_host_groups.create_or_update(
            resource_group_name=resource_group.name,
            host_group_name="str",
            parameters={
                "location": "str",
                "additionalCapabilities": {"ultraSSDEnabled": bool},
                "hosts": [{"id": "str"}],
                "id": "str",
                "instanceView": {
                    "hosts": [
                        {
                            "assetId": "str",
                            "availableCapacity": {"allocatableVMs": [{"count": 0.0, "vmSize": "str"}]},
                            "name": "str",
                            "statuses": [
                                {
                                    "code": "str",
                                    "displayStatus": "str",
                                    "level": "str",
                                    "message": "str",
                                    "time": "2020-02-20 00:00:00",
                                }
                            ],
                        }
                    ]
                },
                "name": "str",
                "platformFaultDomainCount": 0,
                "supportAutomaticPlacement": bool,
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
                "zones": ["str"],
            },
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dedicated_host_groups_update(self, resource_group):
        response = await self.client.dedicated_host_groups.update(
            resource_group_name=resource_group.name,
            host_group_name="str",
            parameters={
                "additionalCapabilities": {"ultraSSDEnabled": bool},
                "hosts": [{"id": "str"}],
                "instanceView": {
                    "hosts": [
                        {
                            "assetId": "str",
                            "availableCapacity": {"allocatableVMs": [{"count": 0.0, "vmSize": "str"}]},
                            "name": "str",
                            "statuses": [
                                {
                                    "code": "str",
                                    "displayStatus": "str",
                                    "level": "str",
                                    "message": "str",
                                    "time": "2020-02-20 00:00:00",
                                }
                            ],
                        }
                    ]
                },
                "platformFaultDomainCount": 0,
                "supportAutomaticPlacement": bool,
                "tags": {"str": "str"},
                "zones": ["str"],
            },
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_dedicated_host_groups_delete(self, resource_group):
        response = await self.client.dedicated_host_groups.delete(
            resource_group_name=resource_group.name,
            host_group_name="str",
            api_version="2025-04-01",
        )

        # please add some check logic here by yourself
        # ...
