; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=armv7-none-eabi -float-abi=hard -mattr=+neon -verify-machineinstrs | FileCheck %s

define i8 @test_umin_v8i8(<8 x i8> %x) {
; CHECK-LABEL: test_umin_v8i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpmin.u8 d16, d0, d0
; CHECK-NEXT:    vpmin.u8 d16, d16, d16
; CHECK-NEXT:    vpmin.u8 d16, d16, d16
; CHECK-NEXT:    vmov.u8 r0, d16[0]
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.umin.v8i8(<8 x i8> %x)
  ret i8 %z
}

define i8 @test_smin_v8i8(<8 x i8> %x) {
; CHECK-LABEL: test_smin_v8i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpmin.s8 d16, d0, d0
; CHECK-NEXT:    vpmin.s8 d16, d16, d16
; CHECK-NEXT:    vpmin.s8 d16, d16, d16
; CHECK-NEXT:    vmov.s8 r0, d16[0]
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.smin.v8i8(<8 x i8> %x)
  ret i8 %z
}

define i8 @test_umax_v8i8(<8 x i8> %x) {
; CHECK-LABEL: test_umax_v8i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpmax.u8 d16, d0, d0
; CHECK-NEXT:    vpmax.u8 d16, d16, d16
; CHECK-NEXT:    vpmax.u8 d16, d16, d16
; CHECK-NEXT:    vmov.u8 r0, d16[0]
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.umax.v8i8(<8 x i8> %x)
  ret i8 %z
}

define i8 @test_smax_v8i8(<8 x i8> %x) {
; CHECK-LABEL: test_smax_v8i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpmax.s8 d16, d0, d0
; CHECK-NEXT:    vpmax.s8 d16, d16, d16
; CHECK-NEXT:    vpmax.s8 d16, d16, d16
; CHECK-NEXT:    vmov.s8 r0, d16[0]
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.smax.v8i8(<8 x i8> %x)
  ret i8 %z
}

define i16 @test_umin_v4i16(<4 x i16> %x) {
; CHECK-LABEL: test_umin_v4i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpmin.u16 d16, d0, d0
; CHECK-NEXT:    vpmin.u16 d16, d16, d16
; CHECK-NEXT:    vmov.u16 r0, d16[0]
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.umin.v4i16(<4 x i16> %x)
  ret i16 %z
}

define i16 @test_smin_v4i16(<4 x i16> %x) {
; CHECK-LABEL: test_smin_v4i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpmin.s16 d16, d0, d0
; CHECK-NEXT:    vpmin.s16 d16, d16, d16
; CHECK-NEXT:    vmov.s16 r0, d16[0]
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.smin.v4i16(<4 x i16> %x)
  ret i16 %z
}

define i16 @test_umax_v4i16(<4 x i16> %x) {
; CHECK-LABEL: test_umax_v4i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpmax.u16 d16, d0, d0
; CHECK-NEXT:    vpmax.u16 d16, d16, d16
; CHECK-NEXT:    vmov.u16 r0, d16[0]
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.umax.v4i16(<4 x i16> %x)
  ret i16 %z
}

define i16 @test_smax_v4i16(<4 x i16> %x) {
; CHECK-LABEL: test_smax_v4i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpmax.s16 d16, d0, d0
; CHECK-NEXT:    vpmax.s16 d16, d16, d16
; CHECK-NEXT:    vmov.s16 r0, d16[0]
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.smax.v4i16(<4 x i16> %x)
  ret i16 %z
}

define i32 @test_umin_v2i32(<2 x i32> %x) {
; CHECK-LABEL: test_umin_v2i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpmin.u32 d16, d0, d0
; CHECK-NEXT:    vmov.32 r0, d16[0]
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.umin.v2i32(<2 x i32> %x)
  ret i32 %z
}

define i32 @test_smin_v2i32(<2 x i32> %x) {
; CHECK-LABEL: test_smin_v2i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpmin.s32 d16, d0, d0
; CHECK-NEXT:    vmov.32 r0, d16[0]
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.smin.v2i32(<2 x i32> %x)
  ret i32 %z
}

define i32 @test_umax_v2i32(<2 x i32> %x) {
; CHECK-LABEL: test_umax_v2i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpmax.u32 d16, d0, d0
; CHECK-NEXT:    vmov.32 r0, d16[0]
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.umax.v2i32(<2 x i32> %x)
  ret i32 %z
}

define i32 @test_smax_v2i32(<2 x i32> %x) {
; CHECK-LABEL: test_smax_v2i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpmax.s32 d16, d0, d0
; CHECK-NEXT:    vmov.32 r0, d16[0]
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.smax.v2i32(<2 x i32> %x)
  ret i32 %z
}

define i8 @test_umin_v16i8(<16 x i8> %x) {
; CHECK-LABEL: test_umin_v16i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpmin.u8 d16, d0, d1
; CHECK-NEXT:    vpmin.u8 d16, d16, d16
; CHECK-NEXT:    vpmin.u8 d16, d16, d16
; CHECK-NEXT:    vpmin.u8 d16, d16, d16
; CHECK-NEXT:    vmov.u8 r0, d16[0]
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.umin.v16i8(<16 x i8> %x)
  ret i8 %z
}

define i16 @test_smin_v8i16(<8 x i16> %x) {
; CHECK-LABEL: test_smin_v8i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpmin.s16 d16, d0, d1
; CHECK-NEXT:    vpmin.s16 d16, d16, d16
; CHECK-NEXT:    vpmin.s16 d16, d16, d16
; CHECK-NEXT:    vmov.s16 r0, d16[0]
; CHECK-NEXT:    bx lr
entry:
  %z = call i16 @llvm.vector.reduce.smin.v8i16(<8 x i16> %x)
  ret i16 %z
}

define i32 @test_umax_v4i32(<4 x i32> %x) {
; CHECK-LABEL: test_umax_v4i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vpmax.u32 d16, d0, d1
; CHECK-NEXT:    vpmax.u32 d16, d16, d16
; CHECK-NEXT:    vmov.32 r0, d16[0]
; CHECK-NEXT:    bx lr
entry:
  %z = call i32 @llvm.vector.reduce.umax.v4i32(<4 x i32> %x)
  ret i32 %z
}

define i8 @test_umin_v32i8(<32 x i8> %x) {
; CHECK-LABEL: test_umin_v32i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmin.u8 q8, q0, q1
; CHECK-NEXT:    vpmin.u8 d16, d16, d17
; CHECK-NEXT:    vpmin.u8 d16, d16, d16
; CHECK-NEXT:    vpmin.u8 d16, d16, d16
; CHECK-NEXT:    vpmin.u8 d16, d16, d16
; CHECK-NEXT:    vmov.u8 r0, d16[0]
; CHECK-NEXT:    bx lr
entry:
  %z = call i8 @llvm.vector.reduce.umin.v32i8(<32 x i8> %x)
  ret i8 %z
}

declare i8 @llvm.vector.reduce.umin.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.smin.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.umax.v8i8(<8 x i8>)
declare i8 @llvm.vector.reduce.smax.v8i8(<8 x i8>)
declare i16 @llvm.vector.reduce.umin.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.smin.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.umax.v4i16(<4 x i16>)
declare i16 @llvm.vector.reduce.smax.v4i16(<4 x i16>)
declare i32 @llvm.vector.reduce.umin.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.smin.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.umax.v2i32(<2 x i32>)
declare i32 @llvm.vector.reduce.smax.v2i32(<2 x i32>)

declare i8 @llvm.vector.reduce.umin.v16i8(<16 x i8>)
declare i16 @llvm.vector.reduce.smin.v8i16(<8 x i16>)
declare i32 @llvm.vector.reduce.umax.v4i32(<4 x i32>)

declare i8 @llvm.vector.reduce.umin.v32i8(<32 x i8>)
