% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simMarkovOrd.r
\name{soprobMarkovOrdm}
\alias{soprobMarkovOrdm}
\title{soprobMarkovOrdm}
\usage{
soprobMarkovOrdm(
  object,
  data,
  times,
  ylevels,
  absorb = NULL,
  tvarname = "time",
  pvarname = "yprev",
  gap = NULL
)
}
\arguments{
\item{object}{a fit object created by \code{blrm}, \code{lrm}, \code{orm}, \code{VGAM::vglm()}, or \code{VGAM::vgam()}}

\item{data}{a single observation list or data frame with covariate settings, including the initial state for Y}

\item{times}{vector of measurement times}

\item{ylevels}{a vector of ordered levels of the outcome variable (numeric or character)}

\item{absorb}{vector of absorbing states, a subset of \code{ylevels}.  The default is no absorbing states. (numeric, character, factor)}

\item{tvarname}{name of time variable, defaulting to \code{time}}

\item{pvarname}{name of previous state variable, defaulting to \code{yprev}}

\item{gap}{name of time gap variable, defaults assuming that gap time is not in the model}
}
\value{
if \code{object} was not a Bayesian model, a matrix with rows corresponding to times and columns corresponding to states, with values equal to exact state occupancy probabilities.  If \code{object} was created by \code{blrm}, the result is a 3-dimensional array with the posterior draws as the first dimension.
}
\description{
State Occupancy Probabilities for First-Order Markov Ordinal Model from a Model Fit
}
\details{
Computes state occupancy probabilities for a single setting of baseline covariates.  If the model fit was from \code{rms::blrm()}, these probabilities are from all the posterior draws of the basic model parameters.  Otherwise they are maximum likelihood point estimates.
}
\seealso{
\url{https://hbiostat.org/R/Hmisc/markov/}
}
\author{
Frank Harrell
}
