#include <stdint.h>

typedef struct {
    uint64_t signatrue;
    uint32_t revision;
    uint32_t header_size;
    uint32_t crc32;
    uint32_t reserved;
} efi_table_header;

typedef uint16_t char16_t;

typedef unsigned long long efi_status;
struct _efi_simple_text_output_protocol;
typedef efi_status (*efi_text_string_output)(struct _efi_simple_text_output_protocol *this, char16_t *string);

typedef struct _efi_simple_text_output_protocol {
    void *reset;
    efi_text_string_output output_string;
    char other_data[0];
} efi_simple_text_output_protocol;

typedef struct {
    efi_table_header hdr;
    char16_t *firmware_vendor;
    uint32_t firmware_revision;
    void *console_in_handle;
    void *con_in;
    void *console_out_handle;
    efi_simple_text_output_protocol *con_out;
    void *standard_error_handle;
    void *std_err;
    void *runtime_services;
    void *boot_services;
    char other_data[0];
} efi_system_table;

efi_status efi_main(void *image_handle, efi_system_table *system_table) {
    (void) image_handle;

    system_table->con_out->output_string(system_table->con_out, L"Hello, World!\r\n");
    while (1);
    return 0;
}
