#!/bin/sh

# NFS root might have reached here before /tmp/net.ifaces was written
udevadm settle --timeout=30

if [ -e /tmp/bridge.info ]; then
    . /tmp/bridge.info
fi

if [ -e /tmp/vlan.info ]; then
    . /tmp/vlan.info
fi

# shellcheck disable=SC2174
mkdir -m 0755 -p /tmp/ifcfg/
# shellcheck disable=SC2174
mkdir -m 0755 -p /tmp/ifcfg-leases/

get_vid() {
    case "$1" in
        vlan*)
            echo "${1#vlan}"
            ;;
        *.*)
            echo "${1##*.}"
            ;;
    esac
}

for netup in /tmp/net.*.did-setup; do
    [ -f "$netup" ] || continue

    netif=${netup%%.did-setup}
    netif=${netif##*/net.}
    strglobin "$netif" ":*:*:*:*:" && continue
    [ -e /tmp/ifcfg/ifcfg-"$netif" ] && continue
    unset bridge
    unset bond
    unset bondslaves
    unset bondname
    unset bondoptions
    unset ip
    unset gw
    unset mtu
    unset mask
    unset macaddr
    unset slave
    unset ethname

    # shellcheck disable=SC1090
    [ -e /tmp/bond."${netif}".info ] && . /tmp/bond."${netif}".info

    if [ "$netif" = "$bridgename" ]; then
        bridge=yes
    elif [ "$netif" = "$bondname" ]; then
        # $netif can't be bridge and bond at the same time
        bond=yes
    fi
    if [ "$netif" = "$vlanname" ]; then
        vlan=yes
    fi
    [ -e /sys/class/net/"$netif"/address ] \
        && cat /sys/class/net/"$netif"/address > /tmp/net."$netif".hwaddr
    {
        echo "# Generated by dracut initrd"
        echo "NAME='$netif'"
        if [ -f /tmp/net."$netif".has_ibft_config ]; then
            echo "STARTMODE='nfsroot'"
        else
            echo "STARTMODE='auto'"
        fi

        local bootproto="static"
        if [ -f /tmp/leaseinfo."${netif}".dhcp.ipv6 ]; then
            bootproto="dhcp6"
        fi
        if [ -f /tmp/leaseinfo."${netif}".dhcp.ipv4 ]; then
            if [ "$bootproto" = "dhcp6" ]; then
                bootproto="dhcp"
            else
                bootproto="dhcp4"
            fi
        fi

        echo "BOOTPROTO='$bootproto'"

        if [ "$bootproto" = "static" ]; then
            # If we've booted with static ip= lines, the override file is there
            # shellcheck disable=SC1090
            [ -e /tmp/net."$netif".override ] && . /tmp/net."$netif".override
            echo "IPADDR='$ip'"
            if [ -n "$mask" ]; then
                if strstr "$mask" "."; then
                    echo "NETMASK='$mask'"
                else
                    echo "PREFIXLEN='$mask'"
                fi
            fi
            if [ -n "$gw" ]; then
                echo "GATEWAY='$gw'"
            fi
        fi
        [ -n "$mtu" ] && echo "MTU='$mtu'"
    } > /tmp/ifcfg/ifcfg-"$netif"

    # bridge needs different things written to ifcfg
    if [ -z "$bridge" ] && [ -z "$bond" ] && [ -z "$vlan" ]; then
        # standard interface
        {
            if [ -n "$macaddr" ]; then
                echo "LLADDR='$macaddr'"
            else
                echo "LLADDR='$(cat /sys/class/net/"$netif"/address)'"
            fi
            echo "INTERFACETYPE='Ethernet'"
        } >> /tmp/ifcfg/ifcfg-"$netif"
    fi

    if [ -n "$vlan" ]; then
        {
            echo "INTERFACETYPE='Vlan'"
            echo "VLAN_ID='$(get_vid "$vlanname")'"
            echo "ETHERDEVICE='$phydevice'"
        } >> /tmp/ifcfg/ifcfg-"$netif"
    fi

    if [ -n "$bond" ]; then
        # bond interface
        {
            # This variable is an indicator of a bond interface for initscripts
            echo "BONDING_MASTER='yes'"
            echo "BONDING_MODULE_OPTS='$bondoptions'"
            echo "INTERFACETYPE='Bond'"
        } >> /tmp/ifcfg/ifcfg-"$netif"

        local i=0
        for slave in $bondslaves; do
            echo "BONDING_SLAVE_$i='$slave'" >> /tmp/ifcfg/ifcfg-"$netif"
            i=$((i + 1))
            # write separate ifcfg file for the raw eth interface
            {
                echo "# Generated by dracut initrd"
                echo "NAME='$slave'"
                echo "INTERFACETYPE='Ethernet'"
                echo "STARTMODE='hotplug'"
                echo "BOOTPROTO='none'"
                echo "# ETHTOOL=''"
            } >> /tmp/ifcfg/ifcfg-"$slave"
        done
    fi

    if [ -n "$bridge" ]; then
        # bridge
        {
            echo "INTERFACETYPE='Bridge'"
            echo "BRIDGE='yes'"
            echo "BRIDGE_STP='off'"
            echo "BRIDGE_FORWARDDELAY='0'"
            printf "BRIDGE_PORTS='"
        } >> /tmp/ifcfg/ifcfg-"$netif"

        if [ "$ethname" = "$bondname" ]; then
            {
                for slave in $bondslaves; do
                    printf "$bondname "
                done
                echo "'"
            } >> /tmp/ifcfg/ifcfg-"$netif"
        else
            echo "$ethname'" >> /tmp/ifcfg/ifcfg-"$netif"
        fi
    fi
done

# Pass network opts
mkdir -m 0755 -p /run/initramfs/state/etc/sysconfig/network
mkdir -m 0755 -p /run/initramfs/state/var/run/wicked
echo "files /etc/sysconfig/network" >> /run/initramfs/rwtab
echo "files /var/run/wicked" >> /run/initramfs/rwtab
{
    cp /tmp/net.* /run/initramfs/
    cp /tmp/net."$netif".resolv.conf /run/initramfs/state/etc/resolv.conf
    copytree /tmp/ifcfg /run/initramfs/state/etc/sysconfig/network
    cp /tmp/leaseinfo.* /run/initramfs/state/var/run/wicked/
} > /dev/null 2>&1
