/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.pajek;

import org.graphstream.graph.implementations.AbstractElement;
import org.graphstream.stream.SourceBase;
import org.graphstream.stream.file.FileSourcePajek;
import org.graphstream.stream.file.pajek.EdgeGraphics;
import org.graphstream.stream.file.pajek.EdgeMatrix;
import org.graphstream.stream.file.pajek.NodeGraphics;
import org.graphstream.util.parser.ParseException;
import org.graphstream.util.parser.Token;

public class PajekContext {
    FileSourcePajek pajek;
    String sourceId;
    protected boolean directed = false;
    protected String weightAttributeName = "weight";

    public PajekContext(FileSourcePajek pajek) {
        this.pajek = pajek;
        this.sourceId = String.format("<Pajek stream %d>", System.currentTimeMillis());
    }

    protected void setDirected(boolean on) {
        this.directed = on;
    }

    protected int addNodes(Token nb) throws ParseException {
        int n = PajekContext.getInt(nb);
        int i = 1;
        while (i <= n) {
            this.pajek.sendNodeAdded(this.sourceId, String.format("%d", i));
            ++i;
        }
        return n;
    }

    protected void addGraphAttribute(String attr, String value) {
        this.pajek.sendAttributeChangedEvent(this.sourceId, this.sourceId, SourceBase.ElementType.GRAPH, attr, AbstractElement.AttributeChangeEvent.ADD, null, value);
    }

    protected void addNodeLabel(String nb, String label) {
        this.pajek.sendAttributeChangedEvent(this.sourceId, nb, SourceBase.ElementType.NODE, "ui.label", AbstractElement.AttributeChangeEvent.ADD, null, label);
    }

    protected void addNodeGraphics(String id, NodeGraphics graphics) {
        this.pajek.sendAttributeChangedEvent(this.sourceId, id, SourceBase.ElementType.NODE, "ui.style", AbstractElement.AttributeChangeEvent.ADD, null, graphics.getStyle());
    }

    protected void addNodePosition(String id, Token x, Token y, Token z) throws ParseException {
        Object[] pos = new Object[]{PajekContext.getReal(x), PajekContext.getReal(y), z != null ? Double.valueOf(PajekContext.getReal(z)) : 0.0};
        this.pajek.sendAttributeChangedEvent(this.sourceId, id, SourceBase.ElementType.NODE, "xyz", AbstractElement.AttributeChangeEvent.ADD, null, pos);
    }

    protected String addEdge(String src, String trg) {
        String id = String.format("%s_%s_%d", src, trg, (long)(Math.random() * 100000.0) + System.currentTimeMillis());
        this.pajek.sendEdgeAdded(this.sourceId, id, src, trg, this.directed);
        return id;
    }

    protected void addEdges(EdgeMatrix mat) {
        int size = mat.size();
        int edgeid = 0;
        int line = 0;
        while (line < size) {
            int col = 0;
            while (col < size) {
                if (mat.hasEdge(line, col)) {
                    String id = String.format("%d_%d_%d", line + 1, col + 1, edgeid++);
                    if (mat.hasEdge(col, line)) {
                        this.pajek.sendEdgeAdded(this.sourceId, id, String.format("%d", line + 1), String.format("%d", col + 1), false);
                        mat.set(col, line, false);
                    } else {
                        this.pajek.sendEdgeAdded(this.sourceId, id, String.format("%d", line + 1), String.format("%d", col + 1), true);
                    }
                }
                ++col;
            }
            ++line;
        }
    }

    protected void addEdgeWeight(String id, Token nb) throws ParseException {
        this.pajek.sendAttributeChangedEvent(this.sourceId, id, SourceBase.ElementType.EDGE, this.weightAttributeName, AbstractElement.AttributeChangeEvent.ADD, null, PajekContext.getReal(nb));
    }

    protected void addEdgeGraphics(String id, EdgeGraphics graphics) {
        this.pajek.sendAttributeChangedEvent(this.sourceId, id, SourceBase.ElementType.EDGE, "ui.style", AbstractElement.AttributeChangeEvent.ADD, null, graphics.getStyle());
    }

    protected static int getInt(Token nb) throws ParseException {
        try {
            return Integer.parseInt(nb.image);
        }
        catch (Exception e) {
            throw new ParseException(String.format("%d:%d: %s not an integer", nb.beginLine, nb.beginColumn, nb.image));
        }
    }

    protected static double getReal(Token nb) throws ParseException {
        try {
            return Double.parseDouble(nb.image);
        }
        catch (Exception e) {
            throw new ParseException(String.format("%d:%d: %s not a real", nb.beginLine, nb.beginColumn, nb.image));
        }
    }

    public static String toColorValue(Token R, Token G, Token B) throws ParseException {
        double r = PajekContext.getReal(R);
        double g = PajekContext.getReal(G);
        double b = PajekContext.getReal(B);
        return String.format("rgb(%d, %d, %d)", (int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0));
    }
}

