/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.graphstream.stream.SourceBase;
import org.graphstream.stream.file.FileSource;
import org.graphstream.util.parser.ParseException;
import org.graphstream.util.parser.Parser;
import org.graphstream.util.parser.ParserFactory;

public abstract class FileSourceParser
extends SourceBase
implements FileSource {
    protected ParserFactory factory = this.getNewParserFactory();
    protected Parser parser;

    public abstract ParserFactory getNewParserFactory();

    protected FileSourceParser() {
    }

    @Override
    public void readAll(String fileName) throws IOException {
        Parser parser = this.factory.newParser(this.createReaderForFile(fileName));
        try {
            parser.all();
            parser.close();
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void readAll(URL url) throws IOException {
        Parser parser = this.factory.newParser(new InputStreamReader(url.openStream()));
        try {
            parser.all();
            parser.close();
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void readAll(InputStream stream) throws IOException {
        Parser parser = this.factory.newParser(new InputStreamReader(stream));
        try {
            parser.all();
            parser.close();
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void readAll(Reader reader) throws IOException {
        Parser parser = this.factory.newParser(reader);
        try {
            parser.all();
            parser.close();
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void begin(String fileName) throws IOException {
        if (this.parser != null) {
            this.end();
        }
        this.parser = this.factory.newParser(this.createReaderForFile(fileName));
        try {
            this.parser.open();
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void begin(URL url) throws IOException {
        this.parser = this.factory.newParser(new InputStreamReader(url.openStream()));
        try {
            this.parser.open();
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void begin(InputStream stream) throws IOException {
        this.parser = this.factory.newParser(new InputStreamReader(stream));
        try {
            this.parser.open();
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void begin(Reader reader) throws IOException {
        this.parser = this.factory.newParser(reader);
        try {
            this.parser.open();
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean nextEvents() throws IOException {
        try {
            return this.parser.next();
        }
        catch (ParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public boolean nextStep() throws IOException {
        return this.nextEvents();
    }

    @Override
    public void end() throws IOException {
        this.parser.close();
        this.parser = null;
    }

    protected Reader createReaderForFile(String filename) throws IOException {
        return new FileReader(filename);
    }
}

