/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.verttimeline;

import ancestris.reports.FormatPlaceOptions;
import ancestris.reports.ScopeIndiMiniOptions;
import ancestris.reports.utils.SvgUtils;
import ancestris.reports.verttimeline.EventTimeLine;
import ancestris.util.Utilities;
import genj.almanac.Almanac;
import genj.almanac.Event;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEventDetails;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import genj.timeline.TimelineView;
import genj.util.Registry;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.apache.batik.svggen.SVGGraphics2D;

public class ReportVertTimeLine
extends Report {
    public FormatOptions formattingOptions = new FormatOptions();
    public ScopeIndiMiniOptions scope = new ScopeIndiMiniOptions();
    public MyContent content = new MyContent();
    public FormatPlaceOptions dataFormatOptions = new FormatPlaceOptions();
    public MyColor colorOptions = new MyColor();
    private final Set<String> USED_TAGS = new HashSet<String>(Arrays.asList("BIRT", "CHR", "BAPM", "DEAT", "BURI", "CREM", "MARR", "DIV"));
    private int maxWidth = 2000;
    private static final Registry REGISTRY = Registry.get(TimelineView.class);
    private SVGGraphics2D svgGenerator;
    private double anneeDebut;
    private double anneeFin;
    private final List<EventTimeLine> events = new ArrayList<EventTimeLine>();
    private int dateWidth = 0;
    private int titleHeight = 0;
    private int maxFamWidth = 1;
    private int maxAlmWidth = 0;
    private PointInTime from;
    private PointInTime to;
    private final Set<Indi> already = new HashSet<Indi>();
    private final Set<String> noTags = new HashSet<String>();
    private PropertyDate birt;
    private PropertyDate death;

    public File start(Gedcom gedcom) {
        Indi indi = this.scope.getScope(gedcom, this);
        return indi != null ? this.start(indi) : null;
    }

    public File start(Indi indi) {
        File file;
        this.events.clear();
        this.already.clear();
        this.noTags.clear();
        this.birt = null;
        this.death = null;
        this.maxAlmWidth = 0;
        this.titleHeight = 0;
        this.dateWidth = 0;
        this.maxFamWidth = 1;
        this.maxWidth = 2000;
        this.from = new PointInTime(0, 0, 0);
        this.to = new PointInTime(0, 0, 0);
        if (!this.content.removeTags.isBlank()) {
            this.noTags.addAll(Arrays.asList(this.content.removeTags.split(";")));
        }
        this.birt = indi.getBirthDateOption();
        if (this.birt == null) {
            this.println(this.translate("birt.error"));
            return null;
        }
        this.death = indi.getDeathDateOption();
        try {
            file = File.createTempFile("ancestris_svg", ".svg");
            file.deleteOnExit();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, this.translate("output.error"), ex);
            return null;
        }
        this.println(this.translate("log.start"));
        this.svgGenerator = SvgUtils.createSvgGenerator();
        this.svgGenerator.setFont(new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, this.formattingOptions.fontSize));
        try {
            int nextHeight;
            this.titleHeight = nextHeight = this.calculateTitleHeight(indi);
            this.calculateDateRange(indi);
            this.getEvents(indi);
            this.maxWidth = this.maxAlmWidth + this.maxFamWidth + this.dateWidth + this.formattingOptions.fontSize * 20;
            nextHeight = this.calculateHeight(nextHeight);
            this.createTitle(indi);
            nextHeight = this.drawTimeLine(nextHeight);
            this.drawEvents(this.titleHeight);
            this.svgGenerator.setColor(this.colorOptions.textColor);
            this.svgGenerator.drawRect(10, 10, this.maxWidth - 10, nextHeight);
            this.svgGenerator.setSVGCanvasSize(new Dimension(this.maxWidth + 10, nextHeight + 10));
        }
        catch (GedcomException e) {
            LOG.log(Level.INFO, this.translate("error.date"), e);
            this.println(this.translate("error.date"));
            return null;
        }
        this.println(this.translate("log.graphic.done"));
        this.flush();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.forName("UTF-8")));
        try {
            this.svgGenerator.stream((Writer)writer);
            writer.flush();
            this.println(this.translate("log.svg.done"));
            File file2 = file;
            writer.close();
            return file2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                LOG.log(Level.INFO, this.translate("output.error"), ioe);
                return null;
            }
        }
    }

    private String format(String value, Indi indi) {
        value = value.replaceAll("\\$i", indi.getId());
        value = value.replaceAll("\\$s", indi.getSosaString());
        value = value.replaceAll("\\$n", indi.getName());
        value = value.replaceAll("\\$f", indi.getFirstName());
        value = value.replaceAll("\\$l", indi.getLastName());
        value = value.replaceAll("\\$d", indi.getBirthDateOption().getReportValue() + " - " + (indi.getDeathDateOption() != null ? indi.getDeathDateOption().getReportValue() : ""));
        Property pTitle = indi.getProperty(new TagPath("INDI:TITL"));
        String titleStr = "";
        if (pTitle != null) {
            titleStr = pTitle.getReportValue();
        }
        value = value.replaceAll("\\$t", titleStr);
        value = value.replaceAll("\\s+", " ");
        return value;
    }

    private int calculateTitleHeight(Indi indi) {
        this.svgGenerator.setFont(new Font(this.formattingOptions.fontTitles[this.formattingOptions.fontTitle], 0, this.formattingOptions.fontTitleSize));
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        String titleValue = this.format(this.formattingOptions.title, indi);
        Rectangle2D boundary = metrics.getStringBounds(titleValue, (Graphics)this.svgGenerator);
        return (int)boundary.getHeight() + this.formattingOptions.fontTitleSize + 2 * this.formattingOptions.fontSize;
    }

    private void createTitle(Indi indi) {
        this.svgGenerator.setFont(new Font(this.formattingOptions.fontTitles[this.formattingOptions.fontTitle], 0, this.formattingOptions.fontTitleSize));
        this.svgGenerator.setColor(this.colorOptions.textColor);
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        String titleValue = this.format(this.formattingOptions.title, indi);
        Rectangle2D boundary = metrics.getStringBounds(titleValue, (Graphics)this.svgGenerator);
        int titleY = 10 + (int)boundary.getHeight();
        this.svgGenerator.drawString(titleValue, (int)((long)(this.maxWidth / 2) - Math.round(boundary.getWidth() / 2.0)), titleY);
    }

    private void calculateDateRange(Indi indi) throws GedcomException {
        int anneeNaissance = this.getDateGreg(indi.getBirthDateOption(), true).getYear();
        this.anneeDebut = this.content.beginBefore ? (double)(anneeNaissance - 10) : (double)anneeNaissance;
        PropertyDate deathDate = indi.getDeathDateOption();
        if (deathDate != null && deathDate.isValid()) {
            int anneeDeces = this.getDateGreg(deathDate, true).getYear();
            this.anneeFin = anneeDeces;
        } else {
            this.anneeFin = this.anneeDebut + 140.0;
        }
        this.from = new PointInTime(0, 0, (int)this.anneeDebut);
        this.to = new PointInTime(30, 11, (int)this.anneeFin);
    }

    private PointInTime getDateGreg(PropertyDate date, boolean start) throws GedcomException {
        if (start) {
            return date.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN);
        }
        return date.getEnd().getPointInTime((Calendar)PointInTime.GREGORIAN);
    }

    private void getEvents(Indi indi) {
        String suffix;
        this.svgGenerator.setFont(new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, this.formattingOptions.fontSize));
        FontMetrics fMetrics = this.svgGenerator.getFontMetrics();
        this.getIndividualEvents(indi, fMetrics, this.colorOptions.defaultEventColor, "", true, true);
        Fam family = indi.getFamilyWhereBiologicalChild();
        this.getFamilyEvents(family, fMetrics, "father", "mother", "parents.wedding", "parents.divorce", this.colorOptions.firstDegreeColor, this.content.displayFamilyEvent);
        for (Indi indi2 : indi.getChildren()) {
            suffix = " " + this.getSexVocable(indi2, "son", "daughter", "child") + " (" + this.getNamewithSosa(indi2) + ")";
            this.getIndividualEvents(indi2, fMetrics, this.colorOptions.firstDegreeColor, suffix, true, this.content.displayFamilyEvent);
        }
        for (Indi indi3 : indi.getFamiliesWhereSpouse()) {
            Indi otherSpouse = indi3.getOtherSpouse(indi);
            if (otherSpouse == null) continue;
            String suffix2 = " " + this.getSexVocable(otherSpouse, "spouseMale", "spouseFemale", "spouse") + " (" + this.getNamewithSosa(otherSpouse) + ")";
            this.getIndividualEvents(otherSpouse, fMetrics, this.colorOptions.firstDegreeColor, suffix2, false, this.content.displayFamilyEvent);
        }
        if (family != null) {
            for (Indi indi4 : family.getChildren()) {
                if (indi4.equals(indi)) continue;
                suffix = " " + this.getSexVocable(indi4, "brother", "sister", "sibling") + " (" + this.getNamewithSosa(indi4) + ")";
                this.getIndividualEvents(indi4, fMetrics, this.colorOptions.firstDegreeColor, suffix, true, this.content.displaySiblings);
            }
            for (Indi parent : family.getSpouses()) {
                for (Fam famParent : parent.getFamiliesWhereSpouse()) {
                    if (famParent.equals(family)) continue;
                    for (Indi sibling : famParent.getChildren()) {
                        String suffix3 = " " + this.getSexVocable(sibling, "brother", "sister", "sibling") + " (" + this.getNamewithSosa(sibling) + ")";
                        this.getIndividualEvents(sibling, fMetrics, this.colorOptions.firstDegreeColor, suffix3, true, this.content.displaySiblings);
                    }
                }
            }
        }
        for (Indi indi5 : indi.getChildren()) {
            for (Indi indi6 : indi5.getChildren()) {
                String suffix4 = " " + this.getSexVocable(indi6, "grandson", "granddaughter", "grandchild") + " (" + this.getNamewithSosa(indi6) + ")";
                this.getIndividualEvents(indi6, fMetrics, this.colorOptions.secondDegreeColor, suffix4, true, this.content.displayGrandChild);
            }
        }
        if (family != null) {
            for (Indi parent : family.getSpouses()) {
                Fam grandParentsFamily = parent.getFamilyWhereBiologicalChild();
                if (grandParentsFamily == null) continue;
                this.getFamilyEvents(grandParentsFamily, fMetrics, "grandfather", "grandmother", "grandparents", "grandparents", this.colorOptions.secondDegreeColor, this.content.displayGrandParents);
            }
            for (Indi parent : family.getSpouses()) {
                Fam fgparent = parent.getFamilyWhereBiologicalChild();
                if (fgparent != null) {
                    for (Indi indi7 : fgparent.getChildren()) {
                        String string = " " + this.getSexVocable(indi7, "uncle", "aunt", "uncleAunt") + " (" + this.getNamewithSosa(indi7) + ")";
                        this.getIndividualEvents(indi7, fMetrics, this.colorOptions.secondDegreeColor, string, true, this.content.displaySecondDegree);
                    }
                }
                for (Indi indi8 : parent.getChildren()) {
                    for (Indi child : indi8.getChildren()) {
                        String suffix6 = " " + this.getSexVocable(child, "nephew", "niece", "nephewNiece") + " (" + this.getNamewithSosa(child) + ")";
                        this.getIndividualEvents(child, fMetrics, this.colorOptions.secondDegreeColor, suffix6, true, this.content.displaySecondDegree);
                    }
                }
            }
            for (Indi indi9 : indi.getChildren()) {
                for (Indi indi10 : indi9.getChildren()) {
                    for (Indi greatGrandChild : indi10.getChildren()) {
                        String suffix7 = " " + this.getSexVocable(greatGrandChild, "greatgrandson", "greatgranddaughter", "greatgrandchild") + " (" + this.getNamewithSosa(greatGrandChild) + ")";
                        this.getIndividualEvents(greatGrandChild, fMetrics, this.colorOptions.thirdDegreeColor, suffix7, true, this.content.displayGreatGrandChild);
                    }
                }
            }
            for (Indi parent : family.getSpouses()) {
                Fam grandparentFamily = parent.getFamilyWhereBiologicalChild();
                if (grandparentFamily == null) continue;
                for (Indi gparent : grandparentFamily.getSpouses()) {
                    Fam ggfamily = gparent.getFamilyWhereBiologicalChild();
                    if (ggfamily == null) continue;
                    for (Indi indi11 : ggfamily.getSpouses()) {
                        String suffix8 = " " + this.getSexVocable(indi11, "greatgrandfather", "greatgrandmother", "greatgrandparent") + " (" + this.getNamewithSosa(indi11) + ")";
                        this.getIndividualEvents(indi11, fMetrics, this.colorOptions.thirdDegreeColor, suffix8, false, this.content.displayGreatGrandParents);
                    }
                }
            }
            for (Indi parent : family.getSpouses()) {
                Fam gFamily = parent.getFamilyWhereBiologicalChild();
                if (gFamily != null) {
                    for (Indi gparent : gFamily.getSpouses()) {
                        Fam ggFamily = gparent.getFamilyWhereBiologicalChild();
                        if (ggFamily != null) {
                            for (Indi indi12 : ggFamily.getSpouses()) {
                                for (Indi child : indi12.getChildren()) {
                                    String suffix9 = " " + this.getSexVocable(child, "granduncle", "grandaunt", "grandUncleAunt") + " (" + this.getNamewithSosa(child) + ")";
                                    this.getIndividualEvents(child, fMetrics, this.colorOptions.thirdDegreeColor, suffix9, true, this.content.displayThirdDegree);
                                }
                            }
                        }
                        for (Indi uncle : gparent.getChildren()) {
                            for (Indi cousin : uncle.getChildren()) {
                                String suffix10 = " " + this.getSexVocable(cousin, "cousinMale", "cousinFemale", "cousin") + " (" + this.getNamewithSosa(cousin) + ")";
                                this.getIndividualEvents(cousin, fMetrics, this.colorOptions.thirdDegreeColor, suffix10, true, this.content.displayThirdDegree);
                            }
                        }
                    }
                }
                for (Indi indi13 : parent.getChildren()) {
                    for (Indi nephew : indi13.getChildren()) {
                        for (Indi gnephew : nephew.getChildren()) {
                            String suffix11 = " " + this.getSexVocable(gnephew, "grandnephew", "grandniece", "greatnephew") + " (" + this.getNamewithSosa(gnephew) + ")";
                            this.getIndividualEvents(gnephew, fMetrics, this.colorOptions.thirdDegreeColor, suffix11, true, this.content.displayThirdDegree);
                        }
                    }
                }
            }
        }
        if (this.content.displayAlmanach) {
            this.addAlmanachEvents();
        }
    }

    private void getFamilyEvents(Fam family, FontMetrics fMetrics, String sFather, String sMother, String sWedding, String sDivorce, Color cCouleur, boolean isDisplay) {
        Indi mother;
        Indi father = family.getHusband();
        if (father != null) {
            String parent = switch (father.getSex()) {
                case 1 -> sFather;
                case 2 -> sMother;
                default -> sFather;
            };
            this.addParentEvents(parent, father, fMetrics, cCouleur, family, isDisplay);
        }
        if ((mother = family.getWife()) != null) {
            String parent = switch (mother.getSex()) {
                case 1 -> sFather;
                case 2 -> sMother;
                default -> sMother;
            };
            this.addParentEvents(parent, mother, fMetrics, cCouleur, family, isDisplay);
        }
        if (!isDisplay) {
            return;
        }
        String tag = "MARR";
        this.addParentsEvent(family, tag, sFather, sWedding, father, mother, fMetrics, cCouleur);
        tag = "DIV";
        this.addParentsEvent(family, tag, sFather, sDivorce, father, mother, fMetrics, cCouleur);
    }

    private void addParentsEvent(Fam family, String tag, String sFather, String sDivorce, Indi father, Indi mother, FontMetrics fMetrics, Color cCouleur) {
        for (Property divorce : family.getProperties(tag)) {
            PropertyDate divorceParent = divorce.getWhen();
            if (divorceParent == null || this.from.compareTo(divorceParent.getStart()) >= 0 || this.to.compareTo(divorceParent.getStart()) <= 0) continue;
            Property divorceType = divorce.getProperty("TYPE");
            Object suffix = "father".equals(sFather) ? this.translate(sDivorce) : Gedcom.getReportName((String)tag) + " " + this.translate(sDivorce) + " (" + this.getNamewithSosa(father) + ") " + this.translate("and") + " (" + this.getNamewithSosa(mother) + ")";
            if (divorceType != null) {
                suffix = (String)suffix + " : " + divorceType.getReportValue();
            }
            EventTimeLine newEvent = this.createEventTimeLine(true, (String)suffix, divorceParent, fMetrics, cCouleur);
            this.events.add(newEvent);
        }
    }

    private void addParentEvents(String sParent, Indi parent, FontMetrics fMetrics, Color cCouleur, Fam family, boolean isDisplay) {
        String suffix = " " + this.translate(sParent) + " (" + this.getNamewithSosa(parent) + ")";
        this.getIndividualEvents(parent, fMetrics, cCouleur, suffix, false, isDisplay);
        if (!isDisplay) {
            return;
        }
        for (Fam famFather : parent.getFamiliesWhereSpouse()) {
            if (famFather.equals(family)) continue;
            PropertyDate newFamilyWedding = famFather.getMarriageDate();
            Indi otherSpouse = famFather.getOtherSpouse(parent);
            if (otherSpouse != null && newFamilyWedding != null && this.from.compareTo(newFamilyWedding.getStart()) < 0 && this.to.compareTo(newFamilyWedding.getStart()) > 0) {
                Property wedding = famFather.getProperty("MARR");
                Property weddingType = wedding.getProperty("TYPE");
                suffix = Gedcom.getReportName((String)"MARR") + " " + this.translate(sParent) + " (" + this.getNamewithSosa(parent) + ") " + this.translate("and") + " (" + this.getNamewithSosa(otherSpouse) + ")";
                if (weddingType != null) {
                    suffix = suffix + " : " + weddingType.getReportValue();
                }
                EventTimeLine newEvent = this.createEventTimeLine(true, suffix, newFamilyWedding, fMetrics, cCouleur);
                this.events.add(newEvent);
            }
            PropertyDate newFamilyDivorce = famFather.getDivorceDate();
            if (otherSpouse == null || newFamilyDivorce == null || this.from.compareTo(newFamilyDivorce.getStart()) >= 0 || this.to.compareTo(newFamilyDivorce.getStart()) <= 0) continue;
            Property divorce = famFather.getProperty("DIV");
            Property divorceType = divorce.getProperty("TYPE");
            suffix = Gedcom.getReportName((String)"DIV") + " " + this.translate(sParent) + " (" + this.getNamewithSosa(parent) + ") " + this.translate("and") + " (" + this.getNamewithSosa(otherSpouse) + ")";
            if (divorceType != null) {
                suffix = suffix + " : " + divorceType.getReportValue();
            }
            EventTimeLine newEvent = this.createEventTimeLine(true, suffix, newFamilyDivorce, fMetrics, cCouleur);
            this.events.add(newEvent);
        }
    }

    private void getIndividualEvents(Indi indi, FontMetrics fMetrics, Color couleur, String suffix, boolean familyEvent, boolean isDisplay) {
        if (this.already.contains(indi)) {
            return;
        }
        this.already.add(indi);
        if (!isDisplay) {
            return;
        }
        for (PropertyEventDetails event : indi.getEvents()) {
            PropertyDate dateEvent;
            String tag = event.getTag();
            if (!this.content.displayOtherEvents && !this.USED_TAGS.contains(tag) || this.noTags.contains(tag) || (dateEvent = event.getDate()) == null || this.from.compareTo(dateEvent.getStart()) >= 0 || this.to.compareTo(dateEvent.getStart()) <= 0) continue;
            Property type = event.getProperty("TYPE");
            Object texte = Gedcom.getReportName((String)tag);
            Property propertyParent = event.getParent();
            if (propertyParent instanceof Fam) {
                Fam fam = (Fam)propertyParent;
                if (!familyEvent) continue;
                Indi oSpouse = fam.getOtherSpouse(indi);
                if ("MARR".equals(tag)) {
                    texte = this.translate("wedding");
                }
                texte = suffix.isBlank() ? (String)texte + " (" + this.getNamewithSosa(oSpouse) + ")" : (String)texte + suffix + " " + this.translate("and") + " (" + this.getNamewithSosa(oSpouse) + ")";
            } else {
                texte = (String)texte + suffix;
            }
            if (event.getValue() != null && !event.getValue().isBlank()) {
                texte = (String)texte + " : " + event.getValue();
            } else if (type != null) {
                texte = (String)texte + " : " + type.getReportValue();
            }
            if ("RESI".equals(tag) || "CENS".equals(tag)) {
                texte = (String)texte + " : " + this.getPlace((Property)event);
            }
            EventTimeLine newEvent = this.createEventTimeLine(true, (String)texte, event.getDate(), fMetrics, couleur);
            this.events.add(newEvent);
        }
    }

    private void addAlmanachEvents() {
        this.svgGenerator.setFont(new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, this.formattingOptions.fontSize));
        FontMetrics fMetrics = this.svgGenerator.getFontMetrics();
        String[] ignoredNames = REGISTRY.get("almanac.ignorenames", new String[0]);
        ArrayList<String> ignoredAlmanacsList = new ArrayList<String>(Arrays.asList(ignoredNames));
        String[] ignored = REGISTRY.get("almanac.ignore", new String[0]);
        ArrayList<String> ignoredAlmanacCategories = new ArrayList<String>(Arrays.asList(ignored));
        int almanacSigLevel = REGISTRY.get("almanac.siglevel", 9);
        Almanac alma = Almanac.getInstance();
        alma.waitLoaded();
        List almanacs = alma.getAlmanacs();
        almanacs.removeAll(ignoredAlmanacsList);
        List categories = alma.getCategories();
        categories.removeAll(ignoredAlmanacCategories);
        Iterator almaEvents = alma.getEvents(this.from, this.to, almanacs, categories, almanacSigLevel);
        while (almaEvents.hasNext()) {
            Event event = (Event)almaEvents.next();
            String texte = event.getTitle();
            if ("".equals(texte) || this.content.displayAlmDescription) {
                texte = event.getDescription();
            }
            texte = Utilities.html2text((String)texte);
            PropertyDate eventDate = new PropertyDate();
            eventDate.setValue(PropertyDate.DATE, event.getTime(), null, null);
            EventTimeLine newEvent = this.createEventTimeLine(false, texte, eventDate, fMetrics, this.colorOptions.almanachColor);
            this.events.add(newEvent);
        }
    }

    private EventTimeLine createEventTimeLine(boolean familyEvent, String texte, PropertyDate eventDate, FontMetrics fMetrics, Color couleur) {
        EventTimeLine newEvent = new EventTimeLine();
        newEvent.setEvent(texte);
        newEvent.setFamily(familyEvent);
        newEvent.setStart(eventDate.getStart());
        newEvent.setDate(eventDate);
        if (this.content.printAge && this.birt.compareTo((Property)eventDate) < 0) {
            if (this.death != null && this.death.compareTo((Property)eventDate) < 0) {
                newEvent.setAge("");
            } else {
                Delta deltaAge = Delta.get((PointInTime)this.birt.getStart(), (PointInTime)eventDate.getStart());
                newEvent.setAge(" (" + deltaAge.toReportString() + ")");
            }
        }
        Rectangle2D boundary = fMetrics.getStringBounds(newEvent.getDate().getReportValue() + newEvent.getAge(), (Graphics)this.svgGenerator);
        this.dateWidth = Math.max(this.dateWidth, (int)boundary.getWidth());
        newEvent.setDateWidth(boundary.getWidth());
        Rectangle2D eventBound = fMetrics.getStringBounds(newEvent.getEvent(), (Graphics)this.svgGenerator);
        newEvent.setWidth(eventBound.getWidth());
        newEvent.setBaseHeight(boundary.getHeight());
        newEvent.setHeight(eventBound.getHeight());
        newEvent.setCouleur(couleur);
        if (familyEvent) {
            this.maxFamWidth = Math.max(this.maxFamWidth, (int)eventBound.getWidth());
        } else {
            int width = (int)eventBound.getWidth();
            if (this.maxFamWidth < width) {
                int height = (int)((eventBound.getHeight() + 2.0) * (double)(width / this.maxFamWidth + 1));
                newEvent.setHeight(height);
                this.maxAlmWidth = this.maxFamWidth;
            } else {
                this.maxAlmWidth = Math.max(this.maxAlmWidth, (int)eventBound.getWidth());
            }
        }
        return newEvent;
    }

    private int calculateHeight(int currentHeight) {
        int height = currentHeight;
        Collections.sort(this.events);
        for (EventTimeLine event : this.events) {
            height = height + (int)event.getHeight() + 10;
        }
        return height;
    }

    private void drawEvents(int currentHeight) {
        int height = currentHeight;
        int milieu = this.maxFamWidth + this.formattingOptions.fontSize * 10 + this.dateWidth / 2;
        this.svgGenerator.setFont(new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, this.formattingOptions.fontSize));
        Collections.sort(this.events);
        for (EventTimeLine event : this.events) {
            String currentDate = event.getDate().getReportValue() + event.getAge();
            this.svgGenerator.setColor(this.colorOptions.textColor);
            this.svgGenerator.drawString(currentDate, (int)((double)milieu - event.getDateWidth() / 2.0), height);
            if (event.getFamily()) {
                this.svgGenerator.setColor(event.getCouleur());
                this.svgGenerator.fillOval(milieu - this.formattingOptions.fontSize * 3 - this.dateWidth / 2, (int)((double)height - event.getBaseHeight() + (double)(this.formattingOptions.fontSize / 3)), (int)(event.getBaseHeight() - 2.0), (int)(event.getBaseHeight() - 2.0));
                this.svgGenerator.setColor(this.colorOptions.textColor);
                this.svgGenerator.drawString(event.getEvent(), (int)((double)(milieu - this.formattingOptions.fontSize * 4) - event.getWidth()) - this.dateWidth / 2, height);
            } else {
                this.svgGenerator.setColor(event.getCouleur());
                this.svgGenerator.fillOval(milieu + this.formattingOptions.fontSize * 2 + this.dateWidth / 2, (int)((double)height - event.getBaseHeight() + (double)(this.formattingOptions.fontSize / 3)), (int)(event.getBaseHeight() - 2.0), (int)(event.getBaseHeight() - 2.0));
                this.svgGenerator.setColor(this.colorOptions.textColor);
                if (event.getWidth() > (double)this.maxFamWidth) {
                    HashMap<TextAttribute, Font> map = new HashMap<TextAttribute, Font>(1);
                    map.put(TextAttribute.FONT, this.svgGenerator.getFont());
                    AttributedString theTexte = new AttributedString(event.getEvent(), map);
                    AttributedCharacterIterator paragraph = theTexte.getIterator();
                    int paragraphEnd = paragraph.getEndIndex();
                    LineBreakMeasurer lbm = new LineBreakMeasurer(paragraph, this.svgGenerator.getFontRenderContext());
                    lbm.setPosition(paragraph.getBeginIndex());
                    float drawY = height;
                    while (lbm.getPosition() < paragraphEnd) {
                        TextLayout tl = lbm.nextLayout(this.maxFamWidth);
                        if (lbm.getPosition() < paragraphEnd) {
                            tl = tl.getJustifiedLayout(this.maxFamWidth);
                        }
                        tl.draw((Graphics2D)this.svgGenerator, milieu + this.formattingOptions.fontSize * 4 + this.dateWidth / 2, drawY);
                        drawY += tl.getDescent() + tl.getLeading() + tl.getAscent();
                    }
                } else {
                    this.svgGenerator.drawString(event.getEvent(), milieu + this.formattingOptions.fontSize * 4 + this.dateWidth / 2, height);
                }
            }
            height = height + (int)event.getHeight() + 10;
        }
    }

    private int drawTimeLine(int currentHeight) {
        int height = currentHeight - this.titleHeight + this.formattingOptions.fontSize;
        int milieu = this.maxFamWidth + this.formattingOptions.fontSize * 10 + this.dateWidth / 2;
        int minDate = milieu - this.dateWidth / 2;
        int maxDate = milieu + this.dateWidth / 2;
        float[] dist = new float[]{0.0f, 1.0f};
        Color[] colors = new Color[]{new Color(255, 255, 255, 100), new Color(180, 180, 180, 100)};
        Point2D.Double start = new Point2D.Double(100.0, this.titleHeight - 2 * this.formattingOptions.fontSize);
        Point2D.Double close = new Point2D.Double(100.0, currentHeight + 20);
        this.svgGenerator.setPaint((Paint)new LinearGradientPaint(start, close, dist, colors));
        Rectangle2D.Double rect = new Rectangle2D.Double(10.0, this.titleHeight - 2 * this.formattingOptions.fontSize, this.maxWidth - 10, height + 3 * this.formattingOptions.fontSize);
        this.svgGenerator.fill((Shape)rect);
        Color[] colorTime = new Color[]{Color.white, this.colorOptions.timelineColor};
        rect = new Rectangle2D.Double(minDate - 10, this.titleHeight - 2 * this.formattingOptions.fontSize, maxDate - minDate + 20, height);
        start = new Point2D.Double(minDate - 10, this.titleHeight - 2 * this.formattingOptions.fontSize);
        Point2D.Double end = new Point2D.Double(minDate - 10, height);
        this.svgGenerator.setPaint((Paint)new LinearGradientPaint(start, end, dist, colorTime));
        this.svgGenerator.fill((Shape)rect);
        this.svgGenerator.setColor(this.colorOptions.timelineColor);
        this.svgGenerator.drawRect(minDate - 10, this.titleHeight - 2 * this.formattingOptions.fontSize, maxDate - minDate + 20, height);
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(minDate - 10, currentHeight - this.formattingOptions.fontSize + 2);
        ((Path2D)path).lineTo(minDate + (maxDate - minDate) / 2, currentHeight + 20);
        ((Path2D)path).lineTo(maxDate + 10, currentHeight - this.formattingOptions.fontSize + 2);
        path.closePath();
        this.svgGenerator.fill((Shape)path);
        return currentHeight + 20;
    }

    private String getNamewithSosa(Indi indi) {
        if (indi == null) {
            return " ";
        }
        String name = indi.getName();
        if (this.content.displaySosa) {
            String sosa = indi.getSosaString();
            if (name != null && sosa != null && !"".equals(sosa)) {
                return name + " - " + sosa;
            }
            return name + sosa;
        }
        return name;
    }

    private String getPlace(Property prop) {
        StringBuilder result = new StringBuilder();
        Property addr = prop.getProperty("ADDR");
        if (addr != null) {
            this.appendToPlace(result, addr);
            this.appendToPlace(result, addr.getProperty("ADR1"));
            this.appendToPlace(result, addr.getProperty("ADR2"));
            this.appendToPlace(result, addr.getProperty("CITY"));
            this.appendToPlace(result, addr.getProperty("STAE"));
            this.appendToPlace(result, addr.getProperty("CTRY"));
        } else if (prop.getProperty("PLAC") != null) {
            PropertyPlace place = (PropertyPlace)prop.getProperty("PLAC");
            String placeFormatted = this.dataFormatOptions.getPlace((Property)place);
            placeFormatted = !"".equals(placeFormatted) ? placeFormatted.replaceAll("\\(\\)", " ").trim() : "";
            result.append(placeFormatted);
        }
        if (result.length() == 0) {
            return "";
        }
        return result.toString();
    }

    private void appendToPlace(StringBuilder result, Property prop) {
        if (prop != null && !prop.getValue().isEmpty()) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(prop.getValue());
        }
    }

    private String getSexVocable(Indi indi, String male, String female, String unknown) {
        return switch (indi.getSex()) {
            case 1 -> this.translate(male);
            case 2 -> this.translate(female);
            default -> this.translate(unknown);
        };
    }

    public class FormatOptions {
        public String title = "$n ($i)";
        public int fontTitle = 0;
        public String[] fontTitles = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        public int fontTitleSize = 40;
        public int fontName = 0;
        public String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        public int fontSize = 14;
    }

    public class MyContent {
        public boolean displaySosa = false;
        public boolean beginBefore = true;
        public boolean printAge = false;
        public boolean displayOtherEvents = true;
        public String removeTags = "";
        public boolean displayFamilyEvent = true;
        public boolean displaySiblings = false;
        public boolean displayGrandChild = true;
        public boolean displayGrandParents = true;
        public boolean displaySecondDegree = false;
        public boolean displayGreatGrandChild = false;
        public boolean displayGreatGrandParents = false;
        public boolean displayThirdDegree = false;
        public boolean displayAlmanach = true;
        public boolean displayAlmDescription = true;
    }

    public class MyColor {
        public Color textColor = Color.BLACK;
        public Color timelineColor = Color.GREEN;
        public Color defaultEventColor = Color.BLUE;
        public Color firstDegreeColor = Color.MAGENTA;
        public Color secondDegreeColor = Color.PINK;
        public Color thirdDegreeColor = Color.RED;
        public Color almanachColor = Color.YELLOW;
    }
}

