/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.star;

import ancestris.reports.FormatPlaceOptions;
import ancestris.reports.ScopeIndiMiniOptions;
import ancestris.reports.star.Cellule;
import ancestris.reports.utils.ColorUtils;
import ancestris.reports.utils.SvgUtils;
import ancestris.util.Utilities;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyPlace;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.report.Report;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class ReportTreeStar
extends Report {
    public FormatOptions formattingOptions = new FormatOptions();
    public ScopeIndiMiniOptions scope = new ScopeIndiMiniOptions();
    public MyContent content = new MyContent();
    public MyDataOptions dataFormatOptions = new MyDataOptions();
    public MyColorOptions colorOptions = new MyColorOptions();
    private final Map<Integer, Integer> generations = new HashMap<Integer, Integer>();
    private int maxX = 0;
    private int maxY = 0;
    private int centerX = 0;
    private int centerY = 0;
    private int maxLevel;
    private int sizeBlock;
    private final List<Cellule> individus = new ArrayList<Cellule>();
    private final Map<String, Color> colorMap = new HashMap<String, Color>();
    private final Set<Color> colorUsed = new HashSet<Color>();
    private SVGGraphics2D svgGenerator;
    private Document document;

    public File start(Gedcom gedcom) {
        Indi indi = this.scope.getScope(gedcom, this);
        return indi != null ? this.start(indi) : null;
    }

    public File start(Indi indi) {
        File file;
        if (this.init()) {
            return null;
        }
        try {
            file = File.createTempFile("ancestris_svg", ".svg");
            file.deleteOnExit();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, this.translate("output.error"), ex);
            return null;
        }
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        this.document = domImpl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        this.svgGenerator = new SVGGraphics2D(this.document);
        this.svgGenerator.getGeneratorContext().setComment("Generated by Ancestris with Batik SVG Generator");
        Font myFont = new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, 12);
        this.svgGenerator.setFont(myFont);
        this.mainSvg(indi);
        try {
            PrintWriter writer = SvgUtils.getWriter(new FileOutputStream(file));
            this.svgGenerator.stream((Writer)writer);
            writer.flush();
            writer.close();
        }
        catch (FileNotFoundException | SVGGraphics2DIOException ex) {
            LOG.log(Level.INFO, this.translate("output.error"), ex);
            return null;
        }
        return file;
    }

    private boolean init() {
        this.generations.clear();
        this.colorMap.clear();
        this.colorUsed.clear();
        this.maxLevel = this.content.umaxlevel + 3;
        if (this.maxLevel == 11) {
            this.maxLevel = this.content.otherLevel;
        }
        if (this.maxLevel < 1 || this.maxLevel > 25) {
            this.println(this.translate("log.maxLevel"));
            return true;
        }
        this.individus.clear();
        this.maxY = 0;
        this.maxX = 0;
        int ecart = 0;
        for (int i = 1; i <= this.maxLevel; ++i) {
            if (i == 2) {
                ecart = 2;
            } else if (i == 4) {
                ecart = 3;
            } else if (i % 2 == 0) {
                ecart += ecart;
            }
            this.generations.put(this.maxLevel + 1 - i, ecart);
        }
        switch (this.formattingOptions.blockSize) {
            case 0: {
                this.sizeBlock = 100;
                break;
            }
            case 1: {
                this.sizeBlock = 150;
                break;
            }
            case 2: {
                this.sizeBlock = 200;
                break;
            }
            default: {
                this.sizeBlock = 200;
            }
        }
        return false;
    }

    private void mainSvg(Indi indi) {
        Cellule indiCell = new Cellule(indi);
        indiCell.setX(0);
        indiCell.setY(0);
        indiCell.setGeneration(1);
        this.setColor(indiCell);
        this.individus.add(indiCell);
        this.constructTree(indiCell);
        this.defineGrid();
        this.draw();
        if (this.formattingOptions.legende) {
            this.drawLegend();
        }
        if (this.formattingOptions.printDate) {
            this.svgGenerator.setColor(Color.BLACK);
            this.svgGenerator.setFont(new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, 8));
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("uuuu/MM/dd HH:mm:ss");
            LocalDateTime now = LocalDateTime.now();
            String date = dtf.format(now);
            Dimension size = this.svgGenerator.getSVGCanvasSize();
            this.svgGenerator.drawString(date, (int)(size.getWidth() - 120.0), (int)(size.getHeight() - 20.0));
        }
    }

    private void defineGrid() {
        int xSize = 2 * this.sizeBlock * (this.maxX + 1);
        int ySize = 2 * this.sizeBlock * (this.maxY + 1);
        this.centerX = xSize / 2 - this.sizeBlock / 2;
        this.centerY = ySize / 2 - this.sizeBlock / 2;
        if (this.formattingOptions.legende) {
            ySize += this.sizeBlock;
        }
        this.svgGenerator.setSVGCanvasSize(new Dimension(xSize, ySize));
        BasicStroke ligne = new BasicStroke(1.0f);
        this.svgGenerator.setColor(Color.BLACK);
        this.svgGenerator.setStroke((Stroke)ligne);
        this.svgGenerator.drawRect(10, 10, xSize - 20, ySize - 20);
    }

    private void constructTree(Cellule indiCell) {
        if (indiCell.getGeneration() >= this.maxLevel) {
            return;
        }
        int sens = 1;
        if (this.content.orderMale) {
            sens = -1;
        }
        Indi father = this.father(indiCell.getIndividual());
        this.addIndividual(father, indiCell, sens);
        Indi mother = this.mother(indiCell.getIndividual());
        this.addIndividual(mother, indiCell, -sens);
    }

    private void addIndividual(Indi indi, Cellule indiCell, int sens) {
        if (indi != null) {
            int currentGeneration = indiCell.getGeneration();
            Cellule newCell = new Cellule(indi);
            newCell.setGeneration(currentGeneration + 1);
            int space = this.generations.get(currentGeneration);
            if (currentGeneration % 2 == 1) {
                newCell.setX(indiCell.getX() + sens * space);
                newCell.setY(indiCell.getY());
            } else {
                newCell.setX(indiCell.getX());
                newCell.setY(indiCell.getY() + sens * space);
            }
            if (Math.abs(newCell.getX()) > this.maxX) {
                this.maxX = Math.abs(newCell.getX());
            }
            if (Math.abs(newCell.getY()) > this.maxY) {
                this.maxY = Math.abs(newCell.getY());
            }
            newCell.setDescendantX(indiCell.getX());
            newCell.setDescendantY(indiCell.getY());
            this.setColor(newCell);
            this.individus.add(newCell);
            this.constructTree(newCell);
        }
    }

    private void setColor(Cellule indiCell) {
        switch (this.colorOptions.colorScheme) {
            case 0: {
                this.setColorGender(indiCell);
                break;
            }
            case 1: {
                indiCell.setBackColor(Color.white);
                indiCell.setFontColor(Color.BLACK);
                break;
            }
            case 2: {
                this.setColorQuadrant(indiCell);
                break;
            }
            case 3: {
                this.setColorGeneration(indiCell);
                break;
            }
            case 4: {
                this.setColorGeo(indiCell);
                break;
            }
            case 5: {
                this.setColorOccu(indiCell);
                break;
            }
            case 6: {
                this.setLifeSpanColor(indiCell);
                break;
            }
            default: {
                indiCell.setBackColor(Color.white);
                indiCell.setFontColor(Color.BLACK);
            }
        }
    }

    private void setColorGender(Cellule indiCell) {
        Indi indi = indiCell.getIndividual();
        switch (indi.getSex()) {
            case 1: {
                indiCell.setBackColor(this.colorOptions.sexMColor);
                indiCell.setFontColor(this.colorOptions.sexMText);
                break;
            }
            case 2: {
                indiCell.setBackColor(this.colorOptions.sexFColor);
                indiCell.setFontColor(this.colorOptions.sexFText);
                break;
            }
            default: {
                indiCell.setBackColor(Color.white);
                indiCell.setFontColor(Color.black);
            }
        }
    }

    private void setColorQuadrant(Cellule indiCell) {
        if (indiCell.getX() <= 0 && indiCell.getY() > 0) {
            indiCell.setBackColor(this.colorOptions.colourQuadrant2);
            indiCell.setFontColor(this.colorOptions.textQuadrant2);
        } else if (indiCell.getX() >= 0 && indiCell.getY() > 0) {
            indiCell.setBackColor(this.colorOptions.colourQuadrant4);
            indiCell.setFontColor(this.colorOptions.textQuadrant4);
        } else if (indiCell.getX() > 0 && indiCell.getY() <= 0) {
            indiCell.setBackColor(this.colorOptions.colourQuadrant3);
            indiCell.setFontColor(this.colorOptions.textQuadrant3);
        } else if (indiCell.getX() <= 0 && indiCell.getY() <= 0) {
            indiCell.setBackColor(this.colorOptions.colourQuadrant1);
            indiCell.setFontColor(this.colorOptions.textQuadrant1);
        } else {
            indiCell.setBackColor(Color.white);
            indiCell.setFontColor(Color.black);
        }
    }

    private void setColorGeneration(Cellule indiCell) {
        indiCell.setFontColor(Color.black);
        indiCell.setBackColor(this.getRandomColor(String.valueOf(indiCell.getGeneration())));
    }

    private void setColorGeo(Cellule indiCell) {
        indiCell.setFontColor(Color.black);
        Indi indi = indiCell.getIndividual();
        PropertyPlace place = indi.getBirthPlaceOption();
        Color backColor = Color.WHITE;
        if (place == null) {
            place = indi.getDeathPlaceOption();
        }
        if (place == null && indi.getFamiliesWhereSpouse()[0] != null) {
            place = indi.getFamiliesWhereSpouse()[0].getMarriagePlace();
        }
        if (place != null) {
            String value = this.dataFormatOptions.place.getPlace((Property)place);
            backColor = this.getRandomColor(value);
        }
        indiCell.setBackColor(backColor);
    }

    private Color getRandomColor(String value) {
        if ("".equals(value)) {
            return Color.WHITE;
        }
        Color color = this.colorMap.get(value);
        if (color != null) {
            return color;
        }
        color = ColorUtils.getRandomColor();
        while (this.colorUsed.contains(color)) {
            color = ColorUtils.getRandomColor();
        }
        this.colorMap.put(value, color);
        this.colorUsed.add(color);
        return color;
    }

    private void setColorOccu(Cellule indiCell) {
        Indi indi = indiCell.getIndividual();
        Property occupation = indi.getProperty("OCCU");
        Color backColor = Color.WHITE;
        if (occupation != null) {
            String value = occupation.getDisplayValue();
            backColor = this.getRandomColor(value);
        }
        indiCell.setBackColor(backColor);
        indiCell.setFontColor(Color.black);
    }

    private void setLifeSpanColor(Cellule indiCell) {
        Indi indi = indiCell.getIndividual();
        indiCell.setFontColor(Color.black);
        Color backColor = Color.LIGHT_GRAY;
        int lifeSpan = this.lifeSpan(indi);
        if (lifeSpan == -100) {
            this.colorMap.put(this.translate("undecidable"), Color.LIGHT_GRAY);
        } else {
            backColor = lifeSpan < 20 ? this.getRandomColor("0 - 20") : (lifeSpan < 30 ? this.getRandomColor("20 - 30") : (lifeSpan < 40 ? this.getRandomColor("30 - 40") : (lifeSpan < 50 ? this.getRandomColor("40 - 50") : (lifeSpan < 60 ? this.getRandomColor("50 - 60") : (lifeSpan < 70 ? this.getRandomColor("60 - 70") : (lifeSpan < 80 ? this.getRandomColor("70 - 80") : (lifeSpan < 90 ? this.getRandomColor("80 - 90") : this.getRandomColor("90+"))))))));
        }
        indiCell.setBackColor(backColor);
    }

    private int lifeSpan(Indi indi) {
        PropertyDate birth = indi.getBirthDateOption();
        PropertyDate death = indi.getDeathDateOption();
        if (birth == null && death == null) {
            return -100;
        }
        if (birth == null || !birth.isValid() || birth.getAnniversary() == null) {
            return -100;
        }
        if (death == null || !death.isValid()) {
            if (((Indi)birth.getEntity()).isDeceased()) {
                return -100;
            }
            return birth.getAnniversary().getYears();
        }
        return Delta.get((PointInTime)birth.getStart(), (PointInTime)death.getStart()).getYears();
    }

    private Indi husband(Fam fam) {
        return fam == null ? null : fam.getHusband();
    }

    private Indi wife(Fam fam) {
        return fam == null ? null : fam.getWife();
    }

    private Fam parents(Indi person) {
        return person == null ? null : person.getFamilyWhereBiologicalChild();
    }

    private Indi father(Indi person) {
        return person == null ? null : this.husband(this.parents(person));
    }

    private Indi mother(Indi person) {
        return person == null ? null : this.wife(this.parents(person));
    }

    private void draw() {
        for (Cellule iCell : this.individus) {
            int x = this.centerX + iCell.getX() * this.sizeBlock;
            int y = this.centerY + iCell.getY() * this.sizeBlock;
            int previousX = this.centerX + iCell.getDescendantX() * this.sizeBlock;
            int previousY = this.centerY + iCell.getDescendantY() * this.sizeBlock;
            int limitX = 0;
            int limitY = 0;
            if (x > previousX) {
                limitX = -(this.sizeBlock / 2);
            } else if (x < previousX) {
                limitX = this.sizeBlock / 2;
            }
            if (y > previousY) {
                limitY = -(this.sizeBlock / 2);
            } else if (y < previousY) {
                limitY = this.sizeBlock / 2;
            }
            BasicStroke ligne = new BasicStroke(10.0f);
            this.svgGenerator.setColor(this.colorOptions.colorLine);
            this.svgGenerator.setStroke((Stroke)ligne);
            this.svgGenerator.drawLine(x + this.sizeBlock / 2 + limitX, y + this.sizeBlock / 2 + limitY, previousX + this.sizeBlock / 2 - limitX, previousY + this.sizeBlock / 2 - limitY);
            ligne = new BasicStroke(1.0f);
            this.svgGenerator.setStroke((Stroke)ligne);
            this.svgGenerator.setColor(iCell.getBackColor());
            this.svgGenerator.fillRect(x + 5, y + 5, this.sizeBlock - 10, this.sizeBlock - 10);
            this.svgGenerator.setColor(this.colorOptions.colorLine);
            this.svgGenerator.drawRect(x + 5, y + 5, this.sizeBlock - 10, this.sizeBlock - 10);
            this.drawContent(iCell, x, y);
        }
    }

    private void drawContent(Cellule iCell, int x, int y) {
        int lineNumber = 3;
        float fontSize = 12.0f;
        Font currentFont = this.svgGenerator.getFont();
        if (this.content.printLifeDate) {
            lineNumber = this.dataFormatOptions.dateformat == 0 ? 6 : 4;
        }
        Object name = iCell.getIndividual().getLastName();
        fontSize = this.adjustFontSize(currentFont, (String)name, fontSize);
        this.svgGenerator.setFont(currentFont.deriveFont(fontSize));
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        Rectangle2D boundary = metrics.getStringBounds((String)name, (Graphics)this.svgGenerator);
        this.svgGenerator.setColor(iCell.getFontColor());
        this.svgGenerator.drawString((String)name, (int)((double)(x + this.sizeBlock / 2) - boundary.getWidth() / 2.0), y + this.sizeBlock / lineNumber);
        name = iCell.getIndividual().getFirstName();
        fontSize = this.adjustFontSize(currentFont, (String)name, 12.0f);
        this.svgGenerator.setFont(currentFont.deriveFont(fontSize));
        metrics = this.svgGenerator.getFontMetrics();
        boundary = metrics.getStringBounds((String)name, (Graphics)this.svgGenerator);
        this.svgGenerator.setColor(iCell.getFontColor());
        this.svgGenerator.drawString((String)name, (int)((double)(x + this.sizeBlock / 2) - boundary.getWidth() / 2.0), y + 2 * this.sizeBlock / lineNumber);
        if (this.content.printLifeDate && this.dataFormatOptions.dateformat == 0) {
            PropertyDate birthDate = iCell.getIndividual().getBirthDateOption();
            name = birthDate != null ? birthDate.getReportValue(null, GedcomOptions.GedcomDateFormat.SHORT) : " ";
            fontSize = this.adjustFontSize(currentFont, (String)name, 12.0f);
            this.svgGenerator.setFont(currentFont.deriveFont(fontSize));
            metrics = this.svgGenerator.getFontMetrics();
            boundary = metrics.getStringBounds((String)name, (Graphics)this.svgGenerator);
            this.svgGenerator.setColor(iCell.getFontColor());
            this.svgGenerator.drawString((String)name, (int)((double)(x + this.sizeBlock / 2) - boundary.getWidth() / 2.0), y + 3 * this.sizeBlock / lineNumber);
            this.svgGenerator.setFont(currentFont.deriveFont(12.0f));
            metrics = this.svgGenerator.getFontMetrics();
            boundary = metrics.getStringBounds("-", (Graphics)this.svgGenerator);
            this.svgGenerator.setColor(iCell.getFontColor());
            this.svgGenerator.drawString("-", (int)((double)(x + this.sizeBlock / 2) - boundary.getWidth() / 2.0), y + 4 * this.sizeBlock / lineNumber);
            PropertyDate deathDate = iCell.getIndividual().getDeathDateOption();
            name = deathDate != null ? deathDate.getReportValue(null, GedcomOptions.GedcomDateFormat.SHORT) : " ";
            fontSize = this.adjustFontSize(currentFont, (String)name, 12.0f);
            this.svgGenerator.setFont(currentFont.deriveFont(fontSize));
            metrics = this.svgGenerator.getFontMetrics();
            boundary = metrics.getStringBounds((String)name, (Graphics)this.svgGenerator);
            this.svgGenerator.setColor(iCell.getFontColor());
            this.svgGenerator.drawString((String)name, (int)((double)(x + this.sizeBlock / 2) - boundary.getWidth() / 2.0), y + 5 * this.sizeBlock / lineNumber);
        } else if (this.content.printLifeDate) {
            PropertyDate birthDate = iCell.getIndividual().getBirthDateOption();
            PropertyDate deathDate = iCell.getIndividual().getDeathDateOption();
            String birth = this.year(birthDate);
            String death = this.year(deathDate);
            name = "(" + birth + " - " + death + ")";
            fontSize = this.adjustFontSize(currentFont, (String)name, 12.0f);
            this.svgGenerator.setFont(currentFont.deriveFont(fontSize));
            metrics = this.svgGenerator.getFontMetrics();
            boundary = metrics.getStringBounds((String)name, (Graphics)this.svgGenerator);
            this.svgGenerator.setColor(iCell.getFontColor());
            this.svgGenerator.drawString((String)name, (int)((double)(x + this.sizeBlock / 2) - boundary.getWidth() / 2.0), y + 3 * this.sizeBlock / lineNumber);
        }
    }

    private float adjustFontSize(Font currentFont, String content, float currentFontSize) {
        float fontSize = currentFontSize;
        this.svgGenerator.setFont(currentFont.deriveFont(fontSize));
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        Rectangle2D boundary = metrics.getStringBounds(content, (Graphics)this.svgGenerator);
        while (fontSize > 6.0f && boundary.getWidth() > (double)(this.sizeBlock - 10)) {
            this.svgGenerator.setFont(currentFont.deriveFont(fontSize -= 1.0f));
            metrics = this.svgGenerator.getFontMetrics();
            boundary = metrics.getStringBounds(content, (Graphics)this.svgGenerator);
        }
        return fontSize;
    }

    private String year(PropertyDate date) {
        if (date != null) {
            return date.getStart().isValid() ? "" + date.getStart().getYear() : "????";
        }
        return this.dataFormatOptions.dateformat == 1 ? "" : "    ";
    }

    private void drawLegend() {
        this.svgGenerator.setFont(new Font(this.formattingOptions.fontNames[this.formattingOptions.fontName], 0, 12));
        FontMetrics metrics = this.svgGenerator.getFontMetrics();
        Dimension size = this.svgGenerator.getSVGCanvasSize();
        double maxWidth = 0.0;
        double debutX = 15.0;
        double debutY = size.getHeight() - 50.0;
        ArrayList<String> values = new ArrayList<String>(this.colorMap.keySet());
        Collections.sort(values, (o1, o2) -> Utilities.removeDiacritics((String)o1).compareTo(Utilities.removeDiacritics((String)o2)));
        Collections.reverse(values);
        for (String value : values) {
            Rectangle2D boundary = metrics.getStringBounds(value, (Graphics)this.svgGenerator);
            Rectangle2D.Double texteRect = new Rectangle2D.Double(debutX, debutY, 12.0 + boundary.getWidth(), 10.0);
            if (texteRect.intersects(0.0, 0.0, size.getWidth(), 2 * this.centerY + this.sizeBlock)) {
                debutY = size.getHeight() - 50.0;
                debutX += (double)((int)maxWidth + 20);
                maxWidth = 0.0;
            }
            maxWidth = Math.max(maxWidth, boundary.getWidth());
            this.svgGenerator.setColor(this.colorMap.get(value));
            this.svgGenerator.fillRect((int)debutX, (int)debutY, 10, 10);
            this.svgGenerator.setColor(Color.BLACK);
            this.svgGenerator.drawString(value, (int)debutX + 12, (int)debutY + 8);
            debutY -= 20.0;
        }
    }

    public class FormatOptions {
        public int fontName = 0;
        public String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        public int blockSize = 0;
        public String[] blockSizes = new String[]{ReportTreeStar.this.translate("blockSize.100"), ReportTreeStar.this.translate("blockSize.150"), ReportTreeStar.this.translate("blockSize.200")};
        public boolean printDate;
        public boolean legende = true;
    }

    public class MyContent {
        public int umaxlevel = 5;
        public String[] umaxlevels = new String[]{ReportTreeStar.this.translate("umaxlevel.3"), ReportTreeStar.this.translate("umaxlevel.4"), ReportTreeStar.this.translate("umaxlevel.5"), ReportTreeStar.this.translate("umaxlevel.6"), ReportTreeStar.this.translate("umaxlevel.7"), ReportTreeStar.this.translate("umaxlevel.8"), ReportTreeStar.this.translate("umaxlevel.9"), ReportTreeStar.this.translate("umaxlevel.10"), ReportTreeStar.this.translate("umaxlevel.other")};
        public int otherLevel;
        public boolean orderMale = true;
        public boolean printLifeDate = true;
    }

    public class MyDataOptions {
        public int dateformat = 1;
        public String[] dateformats = new String[]{ReportTreeStar.this.translate("dateformat.0"), ReportTreeStar.this.translate("dateformat.1"), ReportTreeStar.this.translate("dateformat.2")};
        public FormatPlaceOptions place = new FormatPlaceOptions();
    }

    public final class MyColorOptions {
        public int colorScheme = 0;
        public String[] colorSchemes = new String[]{ReportTreeStar.this.translate("colouroption.0"), ReportTreeStar.this.translate("colouroption.1"), ReportTreeStar.this.translate("colouroption.2"), ReportTreeStar.this.translate("colouroption.3"), ReportTreeStar.this.translate("colouroption.4"), ReportTreeStar.this.translate("colouroption.5"), ReportTreeStar.this.translate("colouroption.6")};
        public Color colorLine = Color.BLACK;
        public Color sexMColor = new Color(255, 200, 200);
        public Color sexMText = Color.BLUE;
        public Color sexFColor = new Color(200, 200, 255);
        public Color sexFText = Color.RED;
        public Color colourQuadrant1 = new Color(50, 210, 210);
        public Color textQuadrant1 = Color.BLACK;
        public Color colourQuadrant2 = new Color(50, 210, 50);
        public Color textQuadrant2 = Color.BLACK;
        public Color colourQuadrant3 = new Color(210, 50, 210);
        public Color textQuadrant3 = Color.BLACK;
        public Color colourQuadrant4 = new Color(210, 210, 50);
        public Color textQuadrant4 = Color.BLACK;
    }
}

