/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcomcompare.tools;

import ancestris.modules.gedcomcompare.tools.STMap;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Property;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class CompareListPanel
extends JPanel {
    private JScrollPane scrollPane;
    private JTable table;

    public CompareListPanel() {
        this.initComponents();
        this.table.getSelectionModel().addListSelectionListener(new CompareListSelectionListener());
    }

    public void init(STMap map1, STMap map2, STMap intersection) {
        String[] columnNames = new String[]{"", map1.getName(), map2.getName(), "", ""};
        this.table.setModel(new tableModel(columnNames, intersection.getData()));
        ((JLabel)((Object)this.table.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(0);
        this.table.getColumnModel().getColumn(1).setCellRenderer(new CompareTableCellRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new CompareTableCellRenderer());
        this.table.getColumnModel().removeColumn(this.table.getColumnModel().getColumn(4));
        this.table.getColumnModel().removeColumn(this.table.getColumnModel().getColumn(3));
        this.table.getColumnModel().removeColumn(this.table.getColumnModel().getColumn(0));
        this.table.setCellSelectionEnabled(true);
    }

    public boolean isEmpty() {
        return this.table == null || this.table.getRowCount() == 0;
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.table = new JTable();
        this.setPreferredSize(new Dimension(700, 307));
        this.scrollPane.setPreferredSize(new Dimension(700, 300));
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.scrollPane.setViewportView(this.table);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
    }

    private class CompareListSelectionListener
    implements ListSelectionListener {
        private CompareListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                return;
            }
            int row = CompareListPanel.this.table.getSelectedRow();
            int column = CompareListPanel.this.table.getSelectedColumn();
            if (row < 0 || column < 0) {
                return;
            }
            Object o = CompareListPanel.this.table.getModel().getValueAt(row, column + 3);
            if (o instanceof Property) {
                SelectionDispatcher.fireSelection((Context)new Context((Property)o));
            }
        }
    }

    private class tableModel
    extends AbstractTableModel {
        private String[] columnNames = null;
        private Object[][] data;

        private tableModel(String[] columnNames, Object[][] data) {
            this.columnNames = columnNames;
            this.data = data;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex < 0 || rowIndex >= this.getRowCount() || columnIndex < 0 || columnIndex >= this.getColumnCount()) {
                return null;
            }
            return this.data[rowIndex][columnIndex];
        }
    }

    private class CompareTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private final Color bgc;

        public CompareTableCellRenderer() {
            this.bgc = new Color(CompareListPanel.this.table.getBackground().getRGB());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Color fgcs = table.getSelectionForeground();
            Color fgc = table.getForeground();
            String cellText = (String)table.getValueAt(row, column);
            String gap = "";
            Font f = this.getFont();
            this.setFont(f.deriveFont(0));
            int type = Integer.parseInt((String)table.getModel().getValueAt(row, 0));
            switch (type) {
                default: {
                    break;
                }
                case 1: {
                    gap = " ";
                    this.setFont(f.deriveFont(1));
                    break;
                }
                case 2: {
                    gap = "    \u2022 ";
                    break;
                }
                case 3: {
                    gap = "       \u25e6 ";
                    break;
                }
                case 4: {
                    gap = "          \u2219 ";
                    break;
                }
                case 5: {
                    gap = "            \u2043 ";
                    break;
                }
                case 6: {
                    fgcs = Color.WHITE;
                    fgc = Color.RED;
                    gap = "            \u2043 ";
                }
            }
            this.setText(gap + cellText);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(fgcs);
            } else {
                this.setBackground(this.bgc);
                this.setForeground(fgc);
            }
            this.setOpaque(true);
            return this;
        }
    }
}

