/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.searchdupes;

import ancestris.modules.gedcom.matchers.EntityMatcher;
import ancestris.modules.gedcom.searchdupes.DuplicatesTask;
import ancestris.modules.gedcom.searchdupes.Log;
import ancestris.modules.gedcom.searchdupes.MassMergePanel;
import ancestris.modules.gedcom.searchdupes.NonDuplicates;
import ancestris.modules.gedcom.searchdupes.SearchDuplicatesAction;
import ancestris.util.GedcomUtilities;
import ancestris.util.ProgressListener;
import ancestris.util.TimingUtility;
import ancestris.util.Utilities;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.MergeEntityPanel;
import ancestris.util.swing.PotentialMatch;
import ancestris.view.SelectionDispatcher;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.util.Trackable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import spin.Spin;

public class DuplicatesResults {
    private static int PAGE_SIZE = 100;
    private static int MERGE_COL1 = 110;
    private static int MERGE_COL2 = 110;
    private static int MERGE_COL3 = 12;
    private DialogDescriptor checkDuplicatePanelDescriptor;
    private final JPanel descriptorPanel;
    private final JTextArea textAreaMessage;
    private String textAreaMessageText = "";
    private final MergeEntityPanel entityViewPanel;
    private final Gedcom gedcom;
    private final boolean displayNoneMsg;
    private List<String> entities2Check;
    private TreeMap<String, EntityMatcher> entitiesMatchers;
    private List<PotentialMatch<? extends Entity>> matchesLinkedList;
    private Set<PotentialMatch> toBeDeleted = new HashSet<PotentialMatch>();
    private int linkedListIndex = -1;
    private final JTextField searchTextField = new JTextField();
    private final JButton firstButton = new JButton();
    private final JButton previousButton = new JButton();
    private final JButton swapButton = new JButton();
    private final JButton nextButton = new JButton();
    private final JButton lastButton = new JButton();
    private final JButton mergeButton = new JButton();
    private final JButton autoMergeButton = new JButton();
    private final JButton cleanButton = new JButton();
    private final JButton noDupButton = new JButton();
    private final JButton closeButton = new JButton();

    public DuplicatesResults(Gedcom myGedcom, List<PotentialMatch<? extends Entity>> myMatches) {
        this(myGedcom, myMatches, null, false, 0);
    }

    public DuplicatesResults(Gedcom myGedcom, List<PotentialMatch<? extends Entity>> myMatches, Entity mainEntity, boolean multi, int rank) {
        this.gedcom = myGedcom;
        this.displayNoneMsg = mainEntity == null;
        this.matchesLinkedList = myMatches;
        this.toBeDeleted.clear();
        this.textAreaMessageText = mainEntity == null ? NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.msgDupGlobalDetected") : (!multi ? NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.msgDupEntityDetected", (Object)mainEntity) : NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.msgDupEntitiesDetected", (Object)mainEntity));
        this.textAreaMessageText = this.textAreaMessageText + "\n" + NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.msgColors");
        this.descriptorPanel = new JPanel();
        this.textAreaMessage = new JTextArea(this.textAreaMessageText);
        this.textAreaMessage.setLineWrap(true);
        this.textAreaMessage.setWrapStyleWord(true);
        this.textAreaMessage.setRows(4);
        this.textAreaMessage.setEditable(false);
        this.entityViewPanel = new MergeEntityPanel(myGedcom, this.matchesLinkedList);
        this.descriptorPanel.setLayout(new BorderLayout());
        this.descriptorPanel.add((Component)this.textAreaMessage, "First");
        this.descriptorPanel.add((Component)this.entityViewPanel, "Center");
        if (rank < 0) {
            rank = 0;
        }
        if (rank > this.matchesLinkedList.size() - 1) {
            rank = this.matchesLinkedList.size() - 1;
        }
        this.linkedListIndex = rank;
    }

    public void show() {
        AbstractAction doFirst = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplicatesResults.this.firstButton.isEnabled()) {
                    DuplicatesResults.this.firstButtonActionPerformed(e);
                }
            }
        };
        this.firstButton.setAction(doFirst);
        this.firstButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchdupes/first.png")));
        this.firstButton.setToolTipText(NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.firstButton", (Object)PAGE_SIZE));
        this.firstButton.setEnabled(false);
        this.firstButton.setDefaultCapable(true);
        this.firstButton.putClientProperty("defaultButton", Boolean.FALSE);
        AbstractAction doPrevious = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplicatesResults.this.previousButton.isEnabled()) {
                    DuplicatesResults.this.previousButtonActionPerformed(e);
                }
            }
        };
        this.previousButton.setAction(doPrevious);
        this.previousButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchdupes/previous.png")));
        this.previousButton.setToolTipText(NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.previousButton"));
        this.previousButton.setEnabled(false);
        this.previousButton.setDefaultCapable(true);
        this.previousButton.putClientProperty("defaultButton", Boolean.FALSE);
        AbstractAction doSwap = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplicatesResults.this.swapButton.isEnabled()) {
                    DuplicatesResults.this.swapButtonActionPerformed(e);
                }
            }
        };
        this.swapButton.setAction(doSwap);
        this.swapButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchdupes/swap.png")));
        this.swapButton.setToolTipText(NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.swapButton"));
        this.swapButton.setEnabled(true);
        this.swapButton.setDefaultCapable(true);
        this.swapButton.putClientProperty("defaultButton", Boolean.FALSE);
        AbstractAction doNext = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplicatesResults.this.nextButton.isEnabled()) {
                    DuplicatesResults.this.nextButtonActionPerformed(e);
                }
            }
        };
        this.nextButton.setAction(doNext);
        this.nextButton.setDefaultCapable(true);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchdupes/next.png")));
        this.nextButton.setToolTipText(NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.nextButton"));
        this.nextButton.setEnabled(false);
        this.nextButton.putClientProperty("defaultButton", Boolean.FALSE);
        AbstractAction doLast = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplicatesResults.this.lastButton.isEnabled()) {
                    DuplicatesResults.this.lastButtonActionPerformed(e);
                }
            }
        };
        this.lastButton.setAction(doLast);
        this.lastButton.setDefaultCapable(true);
        this.lastButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchdupes/last.png")));
        this.lastButton.setToolTipText(NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.lastButton", (Object)PAGE_SIZE));
        this.lastButton.setEnabled(false);
        this.lastButton.putClientProperty("defaultButton", Boolean.FALSE);
        AbstractAction doClean = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplicatesResults.this.cleanButton.isEnabled()) {
                    DuplicatesResults.this.cleanButtonActionPerformed(e);
                }
            }
        };
        this.cleanButton.setAction(doClean);
        this.cleanButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchdupes/clean.png")));
        this.cleanButton.setToolTipText(NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.cleanButton"));
        this.cleanButton.setDefaultCapable(true);
        this.cleanButton.setEnabled(true);
        this.cleanButton.putClientProperty("defaultButton", Boolean.FALSE);
        AbstractAction doMerge = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplicatesResults.this.mergeButton.isEnabled()) {
                    DuplicatesResults.this.mergeButtonActionPerformed(e);
                }
            }
        };
        this.mergeButton.setAction(doMerge);
        this.mergeButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchdupes/merge.png")));
        this.mergeButton.setToolTipText(NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.mergeButton"));
        this.mergeButton.setDefaultCapable(true);
        this.mergeButton.setEnabled(true);
        AbstractAction doAutoMerge = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplicatesResults.this.autoMergeButton.isEnabled()) {
                    DuplicatesResults.this.massMergeButtonActionPerformed(e);
                }
            }
        };
        this.autoMergeButton.setAction(doAutoMerge);
        this.autoMergeButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchdupes/merge-auto.png")));
        this.autoMergeButton.setToolTipText(NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.autoMergeButton"));
        this.autoMergeButton.setDefaultCapable(true);
        this.autoMergeButton.setEnabled(true);
        this.autoMergeButton.putClientProperty("defaultButton", Boolean.FALSE);
        AbstractAction doNoDup = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DuplicatesResults.this.noDupButton.isEnabled()) {
                    DuplicatesResults.this.noDupButtonActionPerformed(e);
                }
            }
        };
        this.noDupButton.setAction(doNoDup);
        this.noDupButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchdupes/nodup.png")));
        this.noDupButton.setToolTipText(NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.noDupButton"));
        this.noDupButton.setDefaultCapable(true);
        this.noDupButton.setEnabled(true);
        this.noDupButton.putClientProperty("defaultButton", Boolean.FALSE);
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchdupes/close.png")));
        this.closeButton.setToolTipText(NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.closeButton"));
        this.closeButton.setDefaultCapable(true);
        this.closeButton.setEnabled(true);
        this.searchTextField.setText("");
        this.searchTextField.setToolTipText(NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.searchTip"));
        this.searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int key = e.getKeyCode();
                if (key == 10) {
                    DuplicatesResults.this.searchDuplicateActionPerformed(0);
                }
            }
        });
        JLabel searchIcon = new JLabel(new ImageIcon(this.getClass().getResource("/ancestris/modules/gedcom/searchdupes/search.png")));
        searchIcon.setIconTextGap(0);
        searchIcon.setText("");
        if (!this.matchesLinkedList.isEmpty()) {
            this.checkDuplicatePanelDescriptor = new DialogDescriptor((Object)this.descriptorPanel, "", false, new Object[]{searchIcon, this.searchTextField, this.firstButton, this.previousButton, this.swapButton, this.nextButton, this.lastButton, this.closeButton, this.noDupButton, this.cleanButton, this.mergeButton, this.autoMergeButton}, (Object)this.mergeButton, 0, null, null);
            this.checkDuplicatePanelDescriptor.setClosingOptions(new Object[]{this.closeButton});
            if (this.linkedListIndex < this.matchesLinkedList.size() - 1) {
                this.nextButton.setEnabled(true);
                this.lastButton.setEnabled(true);
            }
            if (this.linkedListIndex > 0) {
                this.previousButton.setEnabled(true);
                this.firstButton.setEnabled(true);
            }
            this.setEntities(this.matchesLinkedList.get(this.linkedListIndex));
            this.setTitle();
            Dialog dialog = DialogDisplayer.getDefault().createDialog(this.checkDuplicatePanelDescriptor);
            this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(38, 128), "doFirst");
            this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(37, 128), "doPrevious");
            this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(8, 128), "doSwap");
            this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(39, 128), "doNext");
            this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(40, 128), "doLast");
            this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(10, 128), "doMerge");
            this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(10, 640), "doAutoMerge");
            this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(32, 128), "doClean");
            this.entityViewPanel.getInputMap(2).put(KeyStroke.getKeyStroke(151, 128), "doNoDup");
            this.entityViewPanel.getActionMap().put("doFirst", doFirst);
            this.entityViewPanel.getActionMap().put("doPrevious", doPrevious);
            this.entityViewPanel.getActionMap().put("doSwap", doSwap);
            this.entityViewPanel.getActionMap().put("doNext", doNext);
            this.entityViewPanel.getActionMap().put("doLast", doLast);
            this.entityViewPanel.getActionMap().put("doMerge", doMerge);
            this.entityViewPanel.getActionMap().put("doAutoMerge", doAutoMerge);
            this.entityViewPanel.getActionMap().put("doClean", doClean);
            this.entityViewPanel.getActionMap().put("doNoDup", doNoDup);
            dialog.setModal(false);
            dialog.setVisible(true);
            dialog.toFront();
        } else if (this.displayNoneMsg) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(DuplicatesResults.class, (String)"CheckDuplicates.noDuplicates"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }

    private void setEntities(PotentialMatch<? extends Entity> match) {
        this.entityViewPanel.setEntities((Entity)match.getLeft(), (Entity)match.getRight(), match.isMerged());
        if (match.isMerged()) {
            this.textAreaMessage.setText(NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.alreadyMerged"));
        } else {
            this.textAreaMessage.setText(this.textAreaMessageText);
        }
    }

    private void searchDuplicateActionPerformed(int start) {
        String textToSearch = this.searchTextField.getText();
        boolean found = false;
        if (textToSearch.isBlank()) {
            DialogManager.create((String)NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.searchTitle"), (String)NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.searchMsg", (Object)textToSearch)).setMessageType(2).show();
            return;
        }
        int direction = start - this.linkedListIndex;
        if (Math.abs(direction) != 1) {
            direction = 1;
        }
        for (int i = start; i < this.matchesLinkedList.size() && i > -1; i += direction) {
            PotentialMatch<? extends Entity> match = this.matchesLinkedList.get(i);
            if (!match.toString().toLowerCase().contains(textToSearch.toLowerCase())) continue;
            this.linkedListIndex = this.matchesLinkedList.indexOf(match);
            found = true;
            break;
        }
        if (!found) {
            DialogManager.create((String)NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.searchTitle"), (String)NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.searchMsg", (Object)textToSearch)).setMessageType(2).show();
            return;
        }
        this.mergeButton.setEnabled(!this.matchesLinkedList.get(this.linkedListIndex).isMerged());
        this.setEntities(this.matchesLinkedList.get(this.linkedListIndex));
        this.setTitle();
        this.firstButton.setEnabled(this.linkedListIndex > 0);
        this.previousButton.setEnabled(this.linkedListIndex > 0);
        this.nextButton.setEnabled(this.linkedListIndex < this.matchesLinkedList.size() - 1);
        this.lastButton.setEnabled(this.linkedListIndex < this.matchesLinkedList.size() - 1);
    }

    private void firstButtonActionPerformed(ActionEvent evt) {
        this.linkedListIndex = Math.max(this.linkedListIndex - PAGE_SIZE, 0);
        this.mergeButton.setEnabled(!this.matchesLinkedList.get(this.linkedListIndex).isMerged());
        this.setEntities(this.matchesLinkedList.get(this.linkedListIndex));
        this.setTitle();
        if (this.linkedListIndex <= 0) {
            this.firstButton.setEnabled(false);
            this.previousButton.setEnabled(false);
        }
        if (this.linkedListIndex < this.matchesLinkedList.size() - 1) {
            this.nextButton.setEnabled(true);
            this.lastButton.setEnabled(true);
        }
    }

    private void previousButtonActionPerformed(ActionEvent evt) {
        if (!this.searchTextField.getText().isBlank()) {
            this.searchDuplicateActionPerformed(this.linkedListIndex - 1);
            return;
        }
        --this.linkedListIndex;
        this.mergeButton.setEnabled(!this.matchesLinkedList.get(this.linkedListIndex).isMerged());
        this.setEntities(this.matchesLinkedList.get(this.linkedListIndex));
        this.setTitle();
        if (this.linkedListIndex <= 0) {
            this.firstButton.setEnabled(false);
            this.previousButton.setEnabled(false);
        }
        if (this.linkedListIndex < this.matchesLinkedList.size() - 1) {
            this.nextButton.setEnabled(true);
            this.lastButton.setEnabled(true);
        }
    }

    private void swapButtonActionPerformed(ActionEvent evt) {
        PotentialMatch<? extends Entity> e = this.matchesLinkedList.get(this.linkedListIndex);
        e.swap();
        this.setEntities(e);
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        if (!this.searchTextField.getText().isBlank()) {
            this.searchDuplicateActionPerformed(this.linkedListIndex + 1);
            return;
        }
        ++this.linkedListIndex;
        this.mergeButton.setEnabled(!this.matchesLinkedList.get(this.linkedListIndex).isMerged());
        this.setEntities(this.matchesLinkedList.get(this.linkedListIndex));
        this.setTitle();
        if (this.linkedListIndex >= this.matchesLinkedList.size() - 1) {
            this.nextButton.setEnabled(false);
            this.lastButton.setEnabled(false);
        }
        if (this.linkedListIndex > 0) {
            this.firstButton.setEnabled(true);
            this.previousButton.setEnabled(true);
        }
    }

    private void lastButtonActionPerformed(ActionEvent evt) {
        this.linkedListIndex = Math.min(this.linkedListIndex + PAGE_SIZE, this.matchesLinkedList.size() - 1);
        this.mergeButton.setEnabled(!this.matchesLinkedList.get(this.linkedListIndex).isMerged());
        this.setEntities(this.matchesLinkedList.get(this.linkedListIndex));
        this.setTitle();
        if (this.linkedListIndex >= this.matchesLinkedList.size() - 1) {
            this.nextButton.setEnabled(false);
            this.lastButton.setEnabled(false);
        }
        if (this.linkedListIndex > 0) {
            this.firstButton.setEnabled(true);
            this.previousButton.setEnabled(true);
        }
    }

    private void cleanButtonActionPerformed(ActionEvent evt) {
        this.cleanList(this.matchesLinkedList.get(this.linkedListIndex));
        this.removeAndNext();
    }

    private void noDupButtonActionPerformed(ActionEvent evt) {
        Entity right = (Entity)this.matchesLinkedList.get(this.linkedListIndex).getRight();
        Entity left = (Entity)this.matchesLinkedList.get(this.linkedListIndex).getLeft();
        try {
            this.gedcom.doUnitOfWork(gedcom1 -> {
                boolean confirmed = NonDuplicates.store(left, right);
                if (confirmed) {
                    this.removeAndNext();
                }
            });
        }
        catch (GedcomException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void removeAndNext() {
        this.matchesLinkedList.remove(this.linkedListIndex);
        if (!this.matchesLinkedList.isEmpty()) {
            if (this.linkedListIndex >= this.matchesLinkedList.size() - 1) {
                this.nextButton.setEnabled(false);
                this.lastButton.setEnabled(false);
                this.linkedListIndex = this.matchesLinkedList.size() - 1;
            }
            if (this.linkedListIndex <= 0) {
                this.firstButton.setEnabled(false);
                this.previousButton.setEnabled(false);
                this.linkedListIndex = 0;
            }
            if (this.linkedListIndex > 0) {
                this.firstButton.setEnabled(true);
                this.previousButton.setEnabled(true);
            }
            if (this.linkedListIndex < this.matchesLinkedList.size() - 1) {
                this.nextButton.setEnabled(true);
                this.lastButton.setEnabled(true);
            }
            this.mergeButton.setEnabled(!this.matchesLinkedList.get(this.linkedListIndex).isMerged());
            this.setEntities(this.matchesLinkedList.get(this.linkedListIndex));
            this.setTitle();
        } else {
            this.closeButton.doClick();
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(DuplicatesResults.class, (String)"CheckDuplicates.mergeCompleted"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        }
    }

    private void setTitle() {
        String part1 = this.matchesLinkedList.get(this.linkedListIndex).isMerged() ? NbBundle.getMessage(this.getClass(), (String)"SearchDuplicatesPlugin.title.part1b") : NbBundle.getMessage(this.getClass(), (String)"SearchDuplicatesPlugin.title.part1a", (Object)this.matchesLinkedList.get(this.linkedListIndex).getCertainty());
        String part2 = NbBundle.getMessage(this.getClass(), (String)"SearchDuplicatesPlugin.title.part2", (Object)(this.linkedListIndex + 1), (Object)this.matchesLinkedList.size());
        this.checkDuplicatePanelDescriptor.setTitle(part1 + " - " + part2);
    }

    private void cleanList(PotentialMatch currentMatch) {
        this.toBeDeleted.clear();
        this.rememberMatchToRemoveFromList(currentMatch);
        this.deleteFromList(currentMatch);
    }

    private void rememberMatchToRemoveFromList(PotentialMatch matchMerged) {
        for (PotentialMatch<? extends Entity> match : this.matchesLinkedList) {
            if (match.equals((Object)matchMerged) || !match.getLeft().equals(matchMerged.getRight()) && !match.getRight().equals(matchMerged.getRight())) continue;
            this.toBeDeleted.add(match);
        }
    }

    private void deleteFromList(PotentialMatch currentMatch) {
        if (currentMatch == null) {
            currentMatch = this.matchesLinkedList.get(this.linkedListIndex);
        }
        this.matchesLinkedList.removeAll(this.toBeDeleted);
        this.toBeDeleted.clear();
        int index = 0;
        for (PotentialMatch<? extends Entity> match : this.matchesLinkedList) {
            if (match.equals(currentMatch)) {
                this.linkedListIndex = index;
                return;
            }
            ++index;
        }
        this.linkedListIndex = 0;
    }

    private void mergeButtonActionPerformed(ActionEvent evt) {
        boolean merge = false;
        int mergeMode = 1;
        Map map = this.entityViewPanel.getSelectedProperties();
        if (map.isEmpty()) {
            NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.noSelectedProperties"), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (nd.getValue() == NotifyDescriptor.OK_OPTION) {
                merge = true;
                mergeMode = 0;
            }
        } else {
            merge = true;
        }
        if (merge) {
            Utilities.setCursorWaiting((JPanel)this.descriptorPanel);
            try {
                int mode = mergeMode;
                this.gedcom.doUnitOfWork(gedcom1 -> {
                    PotentialMatch<? extends Entity> match = this.matchesLinkedList.get(this.linkedListIndex);
                    GedcomUtilities.MergeEntities((Entity)((Entity)match.getLeft()), (Entity)((Entity)match.getRight()), (int)mode, (Map)map);
                    match.setMerged(true);
                    this.rememberMatchToRemoveFromList(match);
                    this.deleteFromList(match);
                    this.mergeButton.setEnabled(!match.isMerged());
                    this.setEntities(match);
                    this.setTitle();
                    SelectionDispatcher.fireSelection((Context)new Context((Entity)match.getLeft()));
                });
            }
            catch (GedcomException ex) {
                this.gedcom.undoUnitOfWork();
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.genealogyError", (Object)ex.getLocalizedMessage()), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            Utilities.setCursorNormal((JPanel)this.descriptorPanel);
        }
    }

    private void massMergeButtonActionPerformed(ActionEvent evt) {
        MassMergePanel panel = new MassMergePanel(this.gedcom);
        Object o = DialogManager.create((String)NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.autoMergeTitle"), (JComponent)panel).setOptionType(2).setDialogId(MassMergePanel.class).show();
        if (o == DialogManager.CANCEL_OPTION) {
            return;
        }
        panel.storeParams();
        int thresholdValue = panel.getThreshold();
        int mergeScope = panel.getMergeScope();
        this.massMerge(thresholdValue, mergeScope);
        DialogManager.create((String)NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.autoMergeTitle"), (String)NbBundle.getMessage(DuplicatesResults.class, (String)"SearchDuplicatesPlugin.autoMergeFinish")).setOptionType(10).show();
        if (mergeScope != MassMergePanel.GEDCOM_SCOPE) {
            this.mergeButton.setEnabled(!this.matchesLinkedList.get(this.linkedListIndex).isMerged());
            this.setEntities(this.matchesLinkedList.get(this.linkedListIndex));
            this.setTitle();
        } else {
            this.closeButton.doClick();
        }
    }

    public boolean mergeMatch(Log log, PotentialMatch<? extends Entity> match) {
        if (((Entity)match.getLeft()).getNoOfProperties() < ((Entity)match.getRight()).getNoOfProperties()) {
            match.swap();
        }
        try {
            Log.Col[] cols = new Log.Col[]{log.getCol(MERGE_COL1, ((Entity)match.getLeft()).toString()), log.getCol(MERGE_COL2, ((Entity)match.getRight()).toString()), log.getCol(MERGE_COL3, match.getCertainty() + "%")};
            log.table(true, cols);
            GedcomUtilities.MergeEntities((Entity)((Entity)match.getLeft()), (Entity)((Entity)match.getRight()), (int)2, null);
            this.rememberMatchToRemoveFromList(match);
            match.setMerged(true);
            return true;
        }
        catch (GedcomException ex) {
            log.write(" ");
            log.bar();
            log.error(NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.mergingError", (Object)match.getLeft()));
            log.error(ex.getLocalizedMessage());
            log.bar();
            log.write(" ");
            return false;
        }
    }

    protected void setEntities2Check(List<String> entities2Check) {
        this.entities2Check = entities2Check;
    }

    protected void setEntitiesMatchers(TreeMap<String, EntityMatcher> entitiesMatchers) {
        this.entitiesMatchers = entitiesMatchers;
    }

    protected void setParams(Entity entity, EntityMatcher matcher) {
        this.entities2Check = new ArrayList<String>();
        this.entities2Check.add(entity.getTag());
        this.entitiesMatchers = new TreeMap();
        this.entitiesMatchers.put(entity.getTag(), matcher);
    }

    private void massMerge(int thresholdValue, int mergeScope) {
        String title = NbBundle.getMessage(DuplicatesResults.class, (String)"OpenIDE-Module-Name") + " - " + this.gedcom.getDisplayName();
        Log log = new Log(title, this.gedcom.getDisplayName());
        boolean cancelled = false;
        boolean error = false;
        log.timeStamp();
        log.title(title);
        TimingUtility.getInstance().reset();
        if (mergeScope != MassMergePanel.GEDCOM_SCOPE) {
            if (this.matchesLinkedList != null && !this.matchesLinkedList.isEmpty()) {
                if (mergeScope == MassMergePanel.DUPLICATE_SCOPE) {
                    thresholdValue = this.matchesLinkedList.get(this.linkedListIndex).getCertainty();
                }
                MassMergeEntitiesTask mergeTask = new MassMergeEntitiesTask(log, thresholdValue, mergeScope == MassMergePanel.DUPLICATE_SCOPE);
                DuplicatesTask massMergeEntitiesTask = (DuplicatesTask)Spin.off((Object)mergeTask);
                log.write(" ");
                log.underline(NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.merging.duplicateSet", (Object)thresholdValue, (Object)this.matchesLinkedList.size()));
                log.write(" ");
                Log.Col[] cols = new Log.Col[]{log.getCol(MERGE_COL1, NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.merging.entityKept")), log.getCol(MERGE_COL2, NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.merging.entityDeleted")), log.getCol(MERGE_COL3, NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.merging.probability"))};
                log.table(true, cols, true);
                try {
                    this.gedcom.doUnitOfWork(gedcom1 -> massMergeEntitiesTask.run());
                    error = mergeTask.getError();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    log.error(ex.toString());
                    error = true;
                }
                cancelled = mergeTask.getCancelled();
                log.write(" ");
                log.write(" ");
                log.write(NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.total", (Object)mergeTask.getMergedNb()));
                log.write(" ");
            }
        } else if (this.entities2Check != null && this.entitiesMatchers != null && !this.entities2Check.isEmpty() && !this.entitiesMatchers.isEmpty()) {
            int mergedEntities = 0;
            for (String tag : this.entities2Check) {
                MassMergeData data = new MassMergeData();
                data.initialTotalEntitiesNb = this.gedcom.getEntities(tag).size();
                EntityMatcher.CalculateEntityDuplicatesTask calculationTask = this.entitiesMatchers.get(tag).getcalculationTask(thresholdValue);
                calculationTask.setValues(log, this, 0);
                DuplicatesTask massMergeEntitiesTask = (DuplicatesTask)Spin.off((Object)calculationTask);
                log.write(" ");
                log.underline(NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.merging.entityType", (Object)tag));
                log.write(" ");
                Log.Col[] cols = new Log.Col[]{log.getCol(MERGE_COL1, NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.merging.entityKept")), log.getCol(MERGE_COL2, NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.merging.entityDeleted")), log.getCol(MERGE_COL3, NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.merging.probability"))};
                log.table(true, cols, true);
                try {
                    this.gedcom.doUnitOfWork(gedcom1 -> massMergeEntitiesTask.run());
                    error = calculationTask.getError();
                }
                catch (GedcomException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    log.error(ex.toString());
                    error = true;
                }
                int merged = calculationTask.getMergedNb();
                cancelled = calculationTask.getCancelled();
                mergedEntities += merged;
                data.entityType = Gedcom.getName((String)tag);
                data.mergedEntitiesNb = merged;
                data.totalEntitiesNb = this.gedcom.getEntities(tag).size();
                data.clustersProcessed = calculationTask.getClustersProcessed();
                data.mergedThreshold = thresholdValue;
                data.mergedDuration = TimingUtility.getInstance().getTimeHMS();
                data.excludedNonDup = calculationTask.getExcludedNonDup();
                log.write(data.toString());
            }
            log.write("");
            log.write(" ");
            log.write(" ");
            log.write(NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.total", (Object)mergedEntities));
            log.write(" ");
        }
        if (!cancelled) {
            log.write(TimingUtility.getInstance().getTimeHMS() + " - " + NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.taskCompleted"));
        } else {
            log.error(TimingUtility.getInstance().getTimeHMS() + " - " + NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.taskNotCompleted"));
        }
        if (error) {
            log.error(TimingUtility.getInstance().getTimeHMS() + " - " + NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.taskWithError"));
        }
        log.write(" ");
        log.write(" ");
        log.write(" ");
        log.write(" ");
        log.bar();
        log.timeStamp();
        log.tellLogFile();
        log.close();
    }

    public class MassMergeEntitiesTask
    implements DuplicatesTask {
        private final Log log;
        private final int thresholdValue;
        private List<PotentialMatch<? extends Entity>> matches;
        private int progress = 0;
        private int progressMax = 0;
        private String state = "";
        private String taskname = "";
        private boolean cancel = false;
        private boolean error = false;
        private int counter;

        public MassMergeEntitiesTask(Log log, int thresholdValue, boolean duplicateScope) {
            this.log = log;
            this.thresholdValue = thresholdValue;
            if (duplicateScope) {
                this.matches = new ArrayList<PotentialMatch<? extends Entity>>();
                this.matches.add(DuplicatesResults.this.matchesLinkedList.get(DuplicatesResults.this.linkedListIndex));
            } else {
                this.matches = DuplicatesResults.this.matchesLinkedList;
            }
        }

        @Override
        public void run() {
            ProgressListener.Dispatcher.processStarted((Trackable)this);
            this.massMergeEntities();
            ProgressListener.Dispatcher.processStopped((Trackable)this);
        }

        public void cancelTrackable() {
            this.cancel = true;
        }

        public int getProgress() {
            if (this.progressMax == 0) {
                return 0;
            }
            return 100 * this.progress / this.progressMax;
        }

        public String getState() {
            return this.state;
        }

        public String getTaskName() {
            return this.taskname;
        }

        @Override
        public List<PotentialMatch<? extends Entity>> getResult() {
            return null;
        }

        private void massMergeEntities() {
            this.progress = 0;
            this.progressMax = this.matches.size();
            this.taskname = NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.taskname", (Object)this.thresholdValue);
            this.counter = 0;
            for (PotentialMatch<? extends Entity> match : this.matches) {
                ++this.progress;
                if (this.cancel) {
                    this.log.error(NbBundle.getMessage(SearchDuplicatesAction.class, (String)"MassMergeEntitiesTask.abortRequeted"));
                    break;
                }
                this.state = NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.state", (Object)this.progress, (Object)this.progressMax, (Object)this.counter);
                if (match.isMerged() || match.getCertainty() < this.thresholdValue) continue;
                if (((Entity)match.getLeft()).getGedcom() == null || ((Entity)match.getRight()).getGedcom() == null) {
                    match.setMerged(true);
                    continue;
                }
                if (DuplicatesResults.this.mergeMatch(this.log, match)) {
                    ++this.counter;
                    continue;
                }
                this.error = true;
            }
            DuplicatesResults.this.deleteFromList(null);
        }

        public int getMergedNb() {
            return this.counter;
        }

        public boolean getCancelled() {
            return this.cancel;
        }

        public boolean getError() {
            return this.error;
        }
    }

    private class MassMergeData {
        private String entityType = "";
        private int mergedEntitiesNb = 0;
        private int initialTotalEntitiesNb = 0;
        private int totalEntitiesNb = 0;
        private int mergedThreshold = 0;
        private int clustersProcessed = 0;
        private String mergedDuration = "";
        private boolean excludedNonDup = false;

        private MassMergeData() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\n");
            sb.append("------------------------------------------------------------------------------------------------------------------");
            sb.append("\n");
            sb.append(NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.data.entityType", (Object)this.entityType));
            sb.append("\n");
            sb.append("------------------------------------------------------------------------------------------------------------------");
            sb.append("\n");
            sb.append(NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.data.initialTotalEntitiesNb", (Object)this.initialTotalEntitiesNb));
            sb.append("\n");
            sb.append(NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.data.mergedEntitiesNb", (Object)this.mergedEntitiesNb));
            sb.append("\n");
            sb.append(NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.data.totalEntitiesNb", (Object)this.totalEntitiesNb));
            sb.append("\n");
            sb.append(NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.data.mergedThreshold", (Object)this.mergedThreshold));
            sb.append("\n");
            sb.append(NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.data.clustersProcessed", (Object)this.clustersProcessed));
            sb.append("\n");
            sb.append(NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.data.mergedDuration", (Object)this.mergedDuration));
            sb.append("\n");
            sb.append(NbBundle.getMessage(DuplicatesResults.class, (String)"MassMergeEntitiesTask.data.excludedNonDup", (Object)String.valueOf(this.excludedNonDup)));
            sb.append("\n");
            sb.append("------------------------------------------------------------------------------------------------------------------");
            sb.append("\n");
            return sb.toString();
        }
    }
}

