/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.table.filter;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.oxbow.swingbits.table.filter.FilterTableHeaderRenderer;
import org.oxbow.swingbits.table.filter.IFilterChangeListener;
import org.oxbow.swingbits.table.filter.ITableFilter;
import org.oxbow.swingbits.table.filter.JTableFilter;
import org.oxbow.swingbits.table.filter.TableFilterColumnPopup;
import org.oxbow.swingbits.util.IObjectToStringTranslator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TableRowFilterSupport {
    private boolean searchable = false;
    private IObjectToStringTranslator translator;
    private final ITableFilter<?> filter;
    private boolean actionsVisible = true;
    private boolean useTableRenderers = false;

    private TableRowFilterSupport(ITableFilter<?> iTableFilter) {
        if (iTableFilter == null) {
            throw new NullPointerException();
        }
        this.filter = iTableFilter;
    }

    public static TableRowFilterSupport forTable(JTable jTable) {
        return new TableRowFilterSupport(new JTableFilter(jTable));
    }

    public static TableRowFilterSupport forFilter(ITableFilter<?> iTableFilter) {
        return new TableRowFilterSupport(iTableFilter);
    }

    public TableRowFilterSupport actions(boolean bl) {
        this.actionsVisible = bl;
        return this;
    }

    public TableRowFilterSupport searchable(boolean bl) {
        this.searchable = bl;
        return this;
    }

    public TableRowFilterSupport searchTransalator(IObjectToStringTranslator iObjectToStringTranslator) {
        this.translator = iObjectToStringTranslator;
        return this;
    }

    public TableRowFilterSupport useTableRenderers(boolean bl) {
        this.useTableRenderers = bl;
        return this;
    }

    public JTable apply() {
        TableFilterColumnPopup tableFilterColumnPopup = new TableFilterColumnPopup(this.filter);
        tableFilterColumnPopup.setEnabled(true);
        tableFilterColumnPopup.setActionsVisible(this.actionsVisible);
        tableFilterColumnPopup.setSearchable(this.searchable);
        tableFilterColumnPopup.setSearchTranslator(this.translator);
        tableFilterColumnPopup.setUseTableRenderers(this.useTableRenderers);
        this.setupTableHeader();
        return this.filter.getTable();
    }

    private void setupTableHeader() {
        Object obj = this.filter.getTable();
        this.filter.addChangeListener(new IFilterChangeListener((JTable)obj){
            final /* synthetic */ JTable val$table;
            {
                this.val$table = jTable;
            }

            @Override
            public void filterChanged(ITableFilter<?> iTableFilter) {
                this.val$table.getTableHeader().repaint();
            }
        });
        this.setupHeaderRenderers(((JTable)obj).getModel(), true);
    }

    private void setupHeaderRenderers(TableModel tableModel, boolean bl) {
        Object obj = this.filter.getTable();
        FilterTableHeaderRenderer filterTableHeaderRenderer = new FilterTableHeaderRenderer(this.filter);
        this.filter.modelChanged(tableModel);
        for (TableColumn tableColumn : Collections.list(((JTable)obj).getColumnModel().getColumns())) {
            tableColumn.setHeaderRenderer(filterTableHeaderRenderer);
        }
        if (!bl) {
            return;
        }
        ((Container)obj).addPropertyChangeListener("model", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TableRowFilterSupport.this.setupHeaderRenderers((TableModel)propertyChangeEvent.getNewValue(), false);
            }
        });
    }
}

